-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: carento
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'t6qtMWFqFHu9vfvwviuSc8kL6wfAVBsI',1,'2025-11-17 21:11:37','2025-11-17 21:11:37','2025-11-17 21:11:37');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Drive Your Dream Car Today – Affordable Rentals at Your Fingertips!',1,'Book Now','/',0,1,'2025-11-18 04:11:37',NULL,1,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(2,'Announcement 2','Hit the Road in Style – Premium Car Rentals for Every Journey!',1,'Book Now','/',0,1,'2025-11-18 04:11:37',NULL,1,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(3,'Announcement 3','Explore the Open Road – Hassle-Free Car Rentals Just a Click Away!',1,'Book Now','/',0,1,'2025-11-18 04:11:37',NULL,1,'2025-11-17 21:11:37','2025-11-17 21:11:37');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'New Cars',0,'Accusantium ipsam esse dolor quos ad quis. Esse temporibus error qui ut consequuntur. Sint dolor est officia non incidunt ratione odio.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(2,'Car Rentals',0,'Ex enim error quibusdam rem reprehenderit praesentium quo et. Maxime quam necessitatibus ut illo. Quia id vel praesentium alias nobis excepturi eaque. Omnis earum vero dicta ratione placeat.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(3,'Electric Vehicles',0,'Dolore consequatur veniam iste ratione sed rem voluptas consectetur. Pariatur maiores cumque pariatur autem temporibus sed. Eos amet eveniet provident numquam in est enim vero.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(4,'Car Maintenance',0,'Dolor excepturi culpa illo. Esse aut ea recusandae aut. Consequatur nobis ullam cumque enim libero blanditiis sint accusamus. Illum maiores consequatur doloribus facilis dolores.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(5,'Road Trips',0,'Quo blanditiis culpa placeat cumque ut est. Beatae aperiam amet soluta qui maxime.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(6,'Luxury Cars',0,'Consectetur quia cum adipisci eius et harum. Non voluptatem quod deserunt voluptatem aut. Occaecati magni tempore doloremque laborum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(7,'Family Cars',0,'Inventore esse exercitationem nisi quia quos doloremque. Consectetur magnam ex unde officia est non dolores. Dicta asperiores animi eaque est itaque aut sit. Sit aut laborum magni quaerat illum ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(8,'Off-Road Vehicles',0,'Omnis necessitatibus dolorem laborum ex. Exercitationem earum vero tenetur. Quis quo culpa facilis possimus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(9,'Hybrid Cars',0,'Molestiae nihil unde totam eaque quae maiores. Ullam earum qui et et. Numquam tempora rerum adipisci laudantium et. Ut maiores tenetur porro blanditiis quod dolores.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(10,'Car Innovations',0,'Harum error harum illum consequuntur accusantium cupiditate officia. Non exercitationem sunt asperiores explicabo illo. Suscipit ut dicta eaque aliquam labore. Rem est eum illo illo quibusdam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:11:44','2025-11-17 21:11:44');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`),
  KEY `idx_cities_name` (`name`),
  KEY `idx_cities_state_status` (`state_id`,`status`),
  KEY `idx_cities_status` (`status`),
  KEY `idx_cities_state_id` (`state_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Los Angeles','los-angeles',1,1,NULL,1,'locations/location1.jpg',1,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(2,'San Francisco','san-francisco',1,1,NULL,2,'locations/location2.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(3,'San Diego','san-diego',1,1,NULL,3,'locations/location3.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(4,'New York City','new-york-city',2,1,NULL,4,'locations/location4.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(5,'Buffalo','buffalo',2,1,NULL,5,'locations/location5.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(6,'Miami','miami',3,1,NULL,6,'locations/location6.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(7,'Orlando','orlando',3,1,NULL,7,'locations/location1.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(8,'Houston','houston',4,1,NULL,8,'locations/location2.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(9,'Austin','austin',4,1,NULL,9,'locations/location3.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(10,'Chicago','chicago',5,1,NULL,10,'locations/location4.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(11,'London','london',6,2,NULL,11,'locations/location5.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(12,'Manchester','manchester',6,2,NULL,12,'locations/location6.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(13,'Edinburgh','edinburgh',7,2,NULL,13,'locations/location1.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(14,'Toronto','toronto',8,3,NULL,14,'locations/location2.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(15,'Ottawa','ottawa',8,3,NULL,15,'locations/location3.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(16,'Vancouver','vancouver',9,3,NULL,16,'locations/location4.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(17,'Munich','munich',10,4,NULL,17,'locations/location5.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(18,'Berlin','berlin',11,4,NULL,18,'locations/location6.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(19,'Paris','paris',12,5,NULL,19,'locations/location1.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(20,'Nice','nice',13,5,NULL,20,'locations/location2.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(21,'Sydney','sydney',14,6,NULL,21,'locations/location3.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(22,'Melbourne','melbourne',15,6,NULL,22,'locations/location4.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(23,'Tokyo','tokyo',16,7,NULL,23,'locations/location5.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(24,'Osaka','osaka',17,7,NULL,24,'locations/location6.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(25,'Rome','rome',18,8,NULL,25,'locations/location1.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL),(26,'Milan','milan',19,8,NULL,26,'locations/location2.jpg',0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL);
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`),
  KEY `idx_cities_trans_city_lang` (`cities_id`,`lang_code`),
  KEY `idx_cities_trans_name` (`name`),
  KEY `idx_cities_trans_cities_id` (`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_countries_name` (`name`),
  KEY `idx_countries_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'United States','American',1,NULL,1,'published','2025-11-17 21:11:51',NULL,'US'),(2,'United Kingdom','British',2,NULL,0,'published','2025-11-17 21:11:51',NULL,'GB'),(3,'Canada','Canadian',3,NULL,0,'published','2025-11-17 21:11:51',NULL,'CA'),(4,'Germany','German',4,NULL,0,'published','2025-11-17 21:11:51',NULL,'DE'),(5,'France','French',5,NULL,0,'published','2025-11-17 21:11:51',NULL,'FR'),(6,'Australia','Australian',6,NULL,0,'published','2025-11-17 21:11:51',NULL,'AU'),(7,'Japan','Japanese',7,NULL,0,'published','2025-11-17 21:11:51',NULL,'JP'),(8,'Italy','Italian',8,NULL,0,'published','2025-11-17 21:11:51',NULL,'IT');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`),
  KEY `idx_countries_trans_country_lang` (`countries_id`,`lang_code`),
  KEY `idx_countries_trans_name` (`name`),
  KEY `idx_countries_trans_countries_id` (`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_booking_cars`
--

DROP TABLE IF EXISTS `cr_booking_cars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_booking_cars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `car_id` bigint unsigned NOT NULL,
  `pickup_city_id` bigint unsigned DEFAULT NULL,
  `return_city_id` bigint unsigned DEFAULT NULL,
  `car_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `car_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` double NOT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `rental_start_date` datetime NOT NULL,
  `rental_end_date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_booking_cars`
--

LOCK TABLES `cr_booking_cars` WRITE;
/*!40000 ALTER TABLE `cr_booking_cars` DISABLE KEYS */;
INSERT INTO `cr_booking_cars` VALUES (1,1,76,NULL,NULL,NULL,'Porsche Cayenne Turbo GT 2024',90,1,'2025-10-09 00:00:00','2025-10-11 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(2,2,59,NULL,NULL,NULL,'Smart EQ fortwo Prime 2024',180,1,'2025-10-11 00:00:00','2025-10-14 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(3,3,46,NULL,NULL,NULL,'Mazda MX-5 Miata Grand Touring 2024',448,1,'2025-11-16 00:00:00','2025-11-23 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(4,4,39,NULL,NULL,NULL,'Bentley Continental GT V8 2024',315,1,'2025-10-21 00:00:00','2025-10-26 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(5,5,51,NULL,NULL,NULL,'Ferrari F8 Tributo 2024',81,1,'2025-11-08 00:00:00','2025-11-09 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(6,6,49,NULL,NULL,NULL,'Dodge Challenger R/T Scat Pack 2024',30,1,'2025-10-13 00:00:00','2025-10-14 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(7,7,47,NULL,NULL,NULL,'Nissan Rogue Platinum AWD 2024',120,1,'2025-10-07 00:00:00','2025-10-10 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(8,8,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',240,1,'2025-10-26 00:00:00','2025-10-31 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(9,9,87,NULL,NULL,NULL,'Bentley Bentayga S V8 2024',130,1,'2025-11-14 00:00:00','2025-11-16 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(10,10,81,NULL,NULL,NULL,'Tesla Model S Plaid 2024',225,1,'2025-10-07 00:00:00','2025-10-12 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(11,11,37,NULL,NULL,NULL,'BMW M4 Competition xDrive 2024',450,1,'2025-10-28 00:00:00','2025-11-03 00:00:00','2025-11-17 21:12:53','2025-11-17 21:12:53'),(12,12,49,NULL,NULL,NULL,'Dodge Challenger R/T Scat Pack 2024',210,1,'2025-10-07 00:00:00','2025-10-14 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(13,13,83,NULL,NULL,NULL,'Rivian R1S Adventure 2024',400,1,'2025-10-12 00:00:00','2025-10-17 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(14,14,68,NULL,NULL,NULL,'BMW X7 xDrive40i M Sport 2024',188,1,'2025-10-07 00:00:00','2025-10-09 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(15,15,26,NULL,NULL,NULL,'Ford Explorer ST 4WD 2024',74,1,'2025-09-23 00:00:00','2025-09-24 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(16,16,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',301,1,'2025-10-13 00:00:00','2025-10-20 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(17,17,48,NULL,NULL,NULL,'Mini Cooper S Hardtop 2024',217,1,'2025-09-24 00:00:00','2025-10-01 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(18,18,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',192,1,'2025-10-28 00:00:00','2025-11-01 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(19,19,82,NULL,NULL,NULL,'Lucid Air Grand Touring Performance 2024',48,1,'2025-09-23 00:00:00','2025-09-24 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(20,20,32,NULL,NULL,NULL,'Mercedes-Benz G550 4MATIC 2024',66,1,'2025-09-21 00:00:00','2025-09-22 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(21,21,7,NULL,NULL,NULL,'Honda CR-V Touring Hybrid AWD 2024',420,1,'2025-10-05 00:00:00','2025-10-10 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(22,22,50,NULL,NULL,NULL,'Chevrolet Camaro SS 1LE 2024',96,1,'2025-10-28 00:00:00','2025-10-31 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(23,23,92,NULL,NULL,NULL,'McLaren GT Luxe 2024',61,1,'2025-11-11 00:00:00','2025-11-12 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(24,24,85,NULL,NULL,NULL,'Genesis Electrified GV70 Advanced AWD 2024',62,1,'2025-11-09 00:00:00','2025-11-11 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(25,25,31,NULL,NULL,NULL,'McLaren 720S Spider 2024',594,1,'2025-10-18 00:00:00','2025-10-24 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(26,26,59,NULL,NULL,NULL,'Smart EQ fortwo Prime 2024',360,1,'2025-10-22 00:00:00','2025-10-28 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(27,27,85,NULL,NULL,NULL,'Genesis Electrified GV70 Advanced AWD 2024',31,1,'2025-10-25 00:00:00','2025-10-26 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(28,28,28,NULL,NULL,NULL,'Cadillac XT5 Premium Luxury AWD 2024',174,1,'2025-11-09 00:00:00','2025-11-11 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(29,29,64,NULL,NULL,NULL,'Pagani Huayra Roadster BC 2024',455,1,'2025-09-23 00:00:00','2025-09-28 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(30,30,1,NULL,NULL,NULL,'Toyota Camry XLE Hybrid 2024',228,1,'2025-09-21 00:00:00','2025-09-25 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(31,31,22,NULL,NULL,NULL,'Hyundai Sonata N Line 2024',300,1,'2025-11-12 00:00:00','2025-11-16 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(32,32,12,NULL,NULL,NULL,'Mazda CX-5 2.5 Turbo Signature AWD 2024',42,1,'2025-11-12 00:00:00','2025-11-13 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(33,33,7,NULL,NULL,NULL,'Honda CR-V Touring Hybrid AWD 2024',252,1,'2025-11-16 00:00:00','2025-11-19 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(34,34,63,NULL,NULL,NULL,'McLaren Artura Spider 2024',270,1,'2025-11-13 00:00:00','2025-11-16 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(35,35,39,NULL,NULL,NULL,'Bentley Continental GT V8 2024',126,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(36,36,35,NULL,NULL,NULL,'Audi R8 V10 Performance 2024',64,1,'2025-11-17 00:00:00','2025-11-19 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(37,37,68,NULL,NULL,NULL,'BMW X7 xDrive40i M Sport 2024',376,1,'2025-11-17 00:00:00','2025-11-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(38,38,93,NULL,NULL,NULL,'Lamborghini Urus Performante 2024',292,1,'2025-11-12 00:00:00','2025-11-16 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(39,39,65,NULL,NULL,NULL,'Koenigsegg Jesko Absolut 2024',294,1,'2025-11-14 00:00:00','2025-11-20 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(40,40,30,NULL,NULL,NULL,'Alfa Romeo Stelvio Veloce AWD 2024',243,1,'2025-11-12 00:00:00','2025-11-15 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(41,41,59,NULL,NULL,NULL,'Smart EQ fortwo Prime 2024',420,1,'2025-11-14 00:00:00','2025-11-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(42,42,11,NULL,NULL,NULL,'Audi A4 Premium Plus quattro 2024',189,1,'2025-11-18 00:00:00','2025-11-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(43,43,95,NULL,NULL,NULL,'BMW XM Label Red 2024',189,1,'2025-11-14 00:00:00','2025-11-17 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(44,44,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',86,1,'2025-11-12 00:00:00','2025-11-14 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(45,45,43,NULL,NULL,NULL,'Volkswagen Tiguan SEL R-Line 2024',268,1,'2025-11-11 00:00:00','2025-11-15 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(46,46,20,NULL,NULL,NULL,'Infiniti QX60 Autograph AWD 2024',186,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(47,47,12,NULL,NULL,NULL,'Mazda CX-5 2.5 Turbo Signature AWD 2024',210,1,'2025-11-16 00:00:00','2025-11-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(48,48,65,NULL,NULL,NULL,'Koenigsegg Jesko Absolut 2024',147,1,'2025-11-16 00:00:00','2025-11-19 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(49,49,2,NULL,NULL,NULL,'Honda Accord Sport 2.0T 2024',294,1,'2025-11-16 00:00:00','2025-11-19 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(50,50,2,NULL,NULL,NULL,'Honda Accord Sport 2.0T 2024',490,1,'2025-11-13 00:00:00','2025-11-18 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(51,51,60,NULL,NULL,NULL,'Toyota Corolla Hybrid LE 2024',462,1,'2025-11-26 00:00:00','2025-12-03 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(52,52,61,NULL,NULL,NULL,'Aston Martin Vantage F1 Edition 2024',275,1,'2025-11-21 00:00:00','2025-11-26 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(53,53,12,NULL,NULL,NULL,'Mazda CX-5 2.5 Turbo Signature AWD 2024',252,1,'2025-12-01 00:00:00','2025-12-07 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(54,54,9,NULL,NULL,NULL,'Mercedes-Benz GLC 300 4MATIC 2024',245,1,'2025-12-08 00:00:00','2025-12-15 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(55,55,95,NULL,NULL,NULL,'BMW XM Label Red 2024',189,1,'2025-11-29 00:00:00','2025-12-02 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(56,56,73,NULL,NULL,NULL,'Infiniti Q50 Red Sport 400 AWD 2024',183,1,'2025-12-05 00:00:00','2025-12-08 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(57,57,35,NULL,NULL,NULL,'Audi R8 V10 Performance 2024',32,1,'2025-12-10 00:00:00','2025-12-11 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(58,58,81,NULL,NULL,NULL,'Tesla Model S Plaid 2024',180,1,'2025-12-12 00:00:00','2025-12-16 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(59,59,87,NULL,NULL,NULL,'Bentley Bentayga S V8 2024',455,1,'2025-12-14 00:00:00','2025-12-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(60,60,77,NULL,NULL,NULL,'Range Rover Sport HSE Dynamic 2024',300,1,'2025-12-01 00:00:00','2025-12-05 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(61,61,91,NULL,NULL,NULL,'Ferrari Roma Spider 2024',30,1,'2025-12-06 00:00:00','2025-12-07 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(62,62,11,NULL,NULL,NULL,'Audi A4 Premium Plus quattro 2024',126,1,'2025-11-23 00:00:00','2025-11-25 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(63,63,72,NULL,NULL,NULL,'Acura TLX Type S PMC Edition 2024',623,1,'2025-12-10 00:00:00','2025-12-17 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(64,64,51,NULL,NULL,NULL,'Ferrari F8 Tributo 2024',243,1,'2025-12-07 00:00:00','2025-12-10 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(65,65,96,NULL,NULL,NULL,'Chevrolet Corvette Z06 3LZ 2024',480,1,'2025-12-08 00:00:00','2025-12-14 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(66,66,24,NULL,NULL,NULL,'Volkswagen Atlas Cross Sport SEL Premium 2024',235,1,'2025-12-13 00:00:00','2025-12-18 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(67,67,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',129,1,'2025-12-10 00:00:00','2025-12-13 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(68,68,6,NULL,NULL,NULL,'Toyota RAV4 Prime XSE AWD 2024',219,1,'2025-11-20 00:00:00','2025-11-23 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(69,69,93,NULL,NULL,NULL,'Lamborghini Urus Performante 2024',511,1,'2025-11-27 00:00:00','2025-12-04 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(70,70,64,NULL,NULL,NULL,'Pagani Huayra Roadster BC 2024',273,1,'2025-12-08 00:00:00','2025-12-11 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(71,71,12,NULL,NULL,NULL,'Mazda CX-5 2.5 Turbo Signature AWD 2024',252,1,'2025-12-15 00:00:00','2025-12-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(72,72,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',301,1,'2025-11-19 00:00:00','2025-11-26 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(73,73,24,NULL,NULL,NULL,'Volkswagen Atlas Cross Sport SEL Premium 2024',47,1,'2025-11-23 00:00:00','2025-11-24 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(74,74,48,NULL,NULL,NULL,'Mini Cooper S Hardtop 2024',186,1,'2025-11-30 00:00:00','2025-12-06 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(75,75,50,NULL,NULL,NULL,'Chevrolet Camaro SS 1LE 2024',64,1,'2025-11-19 00:00:00','2025-11-21 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(76,76,14,NULL,NULL,NULL,'Porsche Macan S 2024',438,1,'2025-12-09 00:00:00','2025-12-15 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(77,77,91,NULL,NULL,NULL,'Ferrari Roma Spider 2024',180,1,'2025-12-16 00:00:00','2025-12-22 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(78,78,87,NULL,NULL,NULL,'Bentley Bentayga S V8 2024',455,1,'2025-11-25 00:00:00','2025-12-02 00:00:00','2025-11-17 21:12:54','2025-11-17 21:12:54'),(79,79,97,NULL,NULL,NULL,'Ford GT Heritage Edition 2024',34,1,'2025-11-30 00:00:00','2025-12-01 00:00:00','2025-11-17 21:12:55','2025-11-17 21:12:55'),(80,80,99,NULL,NULL,NULL,'Nissan GT-R NISMO Special Edition 2024',126,1,'2025-11-26 00:00:00','2025-11-29 00:00:00','2025-11-17 21:12:55','2025-11-17 21:12:55');
/*!40000 ALTER TABLE `cr_booking_cars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_booking_service`
--

DROP TABLE IF EXISTS `cr_booking_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_booking_service` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `service_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_booking_service`
--

LOCK TABLES `cr_booking_service` WRITE;
/*!40000 ALTER TABLE `cr_booking_service` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_booking_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_bookings`
--

DROP TABLE IF EXISTS `cr_bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_bookings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_age` int unsigned DEFAULT NULL,
  `customer_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` double NOT NULL,
  `sub_total` double NOT NULL,
  `coupon_amount` double NOT NULL DEFAULT '0',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_amount` double NOT NULL DEFAULT '0',
  `currency_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `completion_miles` int unsigned DEFAULT NULL,
  `completion_gas_level` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `completion_damage_images` text COLLATE utf8mb4_unicode_ci,
  `completion_notes` text COLLATE utf8mb4_unicode_ci,
  `completed_at` timestamp NULL DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_bookings_booking_number_unique` (`booking_number`),
  UNIQUE KEY `cr_bookings_transaction_id_unique` (`transaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_bookings`
--

LOCK TABLES `cr_bookings` WRITE;
/*!40000 ALTER TABLE `cr_bookings` DISABLE KEYS */;
INSERT INTO `cr_bookings` VALUES (1,'#1000002','TNOTKN1HTCERYEX3IG43UHPF8QPKCHXU','Karlee Ruecker Jr.','alvis35@example.com','+13515620213',NULL,'29',90,90,0,NULL,9,'1','1',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-08 21:12:53','2025-11-17 21:12:53',7),(2,'#1000003','GYEVXXZLURV6GOW4KYYC0LVVAVDPS8Z2','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',180,180,0,NULL,0,'1','2',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-10 21:12:53','2025-11-17 21:12:53',8),(3,'#1000004','ZBZZLHADDT7PJU0XIFUWIIR2QO9Y3YW8','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',448,448,0,NULL,0,'1','3',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-11-15 21:12:53','2025-11-17 21:12:53',15),(4,'#1000005','4MWES7MQQ9K7RIJPVZDTQYVQDPBPFLNO','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',315,315,0,NULL,0,'1','4',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-20 21:12:53','2025-11-17 21:12:53',8),(5,'#1000006','3STXKM8KRAGL8EELV4KGXKH2WFVNTXSE','Jorge Cole','customer@botble.com','+12027539334',NULL,'31',81,81,0,NULL,0,'1','5',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-11-07 21:12:53','2025-11-17 21:12:53',4),(6,'#1000007','4OMYIAPPXUYWPZKW9LFVCI8FHMTCIKII','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',30,30,0,NULL,0,'1','6',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-12 21:12:53','2025-11-17 21:12:53',19),(7,'#1000008','37NPOZWJADYWSNPGEAWVYVNLAPRCBCPM','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',120,120,0,NULL,0,'1','7',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-06 21:12:53','2025-11-17 21:12:53',32),(8,'#1000009','AUJIUYQ57DHNIMJZWXQKLO1LPHYAPTMX','Jorge Cole','customer@botble.com','+12027539334',NULL,'31',240,240,0,NULL,0,'1','8',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-25 21:12:53','2025-11-17 21:12:53',NULL),(9,'#1000010','CVQM8VZFVLGTBO0NG9AO5ASXSLZRV0RA','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',130,130,0,NULL,0,'1','9',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-11-13 21:12:53','2025-11-17 21:12:53',NULL),(10,'#1000011','HUSZMJEGUSQSUVKD2XZ75MCKTDJIBJEC','Clifford Corkery','fdenesik@example.net','+14122179291',NULL,'28',225,225,0,NULL,0,'1','10',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-06 21:12:53','2025-11-17 21:12:53',NULL),(11,'#1000012','YEE18YDHOKLAWLLPEGOX4CKDIGQDIDCR','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',450,450,0,NULL,0,'1','11',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-27 21:12:53','2025-11-17 21:12:54',16),(12,'#1000013','XFWQJIT3BZBJJCRPQUYEDTPSCZFMKEGK','Barbara Goldner','justine.raynor@example.com','+14099364802',NULL,'26',210,210,0,NULL,21,'1','12',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-06 21:12:54','2025-11-17 21:12:54',19),(13,'#1000014','T5JBXN23FTA1CC4GHLKJQYQQZ6LQ6LIE','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',400,400,0,NULL,0,'1','13',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-11 21:12:54','2025-11-17 21:12:54',7),(14,'#1000015','XYZ06ZA4AKPVL6RA7VDSKQ6BRPBWMY0H','Clifford Corkery','fdenesik@example.net','+14122179291',NULL,'28',188,188,0,NULL,0,'1','14',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-06 21:12:54','2025-11-17 21:12:54',18),(15,'#1000016','PSUROWLH4A0BZUVLYMPXXURKYB1QXPVJ','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',74,74,0,NULL,7.4,'1','15',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-09-22 21:12:54','2025-11-17 21:12:54',4),(16,'#1000017','T4B2KFV82XAL2TAQTL0A7LYOLADRWZVA','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',301,301,0,NULL,0,'1','16',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-12 21:12:54','2025-11-17 21:12:54',14),(17,'#1000018','KEXB6RFYKMXR3ENXTIBUFJCYRHANVMRQ','Clifford Corkery','fdenesik@example.net','+14122179291',NULL,'28',217,217,0,NULL,0,'1','17',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-09-23 21:12:54','2025-11-17 21:12:54',2),(18,'#1000019','KWKRAIK1ZPCEDQNOICFSCUPOSBX1GQUG','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',192,192,0,NULL,0,'1','18',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-27 21:12:54','2025-11-17 21:12:54',NULL),(19,'#1000020','DSO6OFLFULT0WJGLRUTFLXYUSHZ2PBQI','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',48,48,0,NULL,4.8,'1','19',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-22 21:12:54','2025-11-17 21:12:54',NULL),(20,'#1000021','FXKTLZEONNO8DF0BOIT2LOK40JXQUYPR','Karlee Ruecker Jr.','alvis35@example.com','+13515620213',NULL,'29',66,66,0,NULL,6.6,'1','20',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-09-20 21:12:54','2025-11-17 21:12:54',NULL),(21,'#1000022','X7AJKJT0GPKIDGOAW34J1YMRMK1YYUDN','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',420,420,0,NULL,42,'1','21',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-04 21:12:54','2025-11-17 21:12:54',7),(22,'#1000023','BK6ECCN0VLRSDIABYPAB1IVCJC7DGDPB','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',96,96,0,NULL,9.6,'1','22',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-27 21:12:54','2025-11-17 21:12:54',15),(23,'#1000024','GZMQZ2CGNHL4KLMYOFIJ0TI1MKSR6I7X','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',61,61,0,NULL,0,'1','23',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-11-10 21:12:54','2025-11-17 21:12:54',9),(24,'#1000025','PBDAKIGAV89S5P7X5F5CWN61ZBNEATVM','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',62,62,0,NULL,0,'1','24',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-08 21:12:54','2025-11-17 21:12:54',1),(25,'#1000026','6FZ83LTCPXKXKCCUFBUWJMOVBBEJBBJ8','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',594,594,0,NULL,59.4,'1','25',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-17 21:12:54','2025-11-17 21:12:54',6),(26,'#1000027','EEWRUJIB6G3UFWYZICVTJVHZDMQQ1IA7','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',360,360,0,NULL,36,'1','26',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-21 21:12:54','2025-11-17 21:12:54',8),(27,'#1000028','JFCUJJGKHDKPMOVMGY3YHZMK6HYMZ4EI','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',31,31,0,NULL,0,'1','27',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-24 21:12:54','2025-11-17 21:12:54',1),(28,'#1000029','HNZYBK9ZSZJTC1J34QAFH39GFVEHZRTC','Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',NULL,'22',174,174,0,NULL,0,'1','28',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-08 21:12:54','2025-11-17 21:12:54',NULL),(29,'#1000030','LX1MLKKIJMXN9JKAFO0AUWIRE2PMBLAB','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',455,455,0,NULL,45.5,'1','29',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-22 21:12:54','2025-11-17 21:12:54',NULL),(30,'#1000031','GU2BKNBUQBBH7CJL5ZJWG5FRVYNPVYBJ','Barbara Goldner','justine.raynor@example.com','+14099364802',NULL,'26',228,228,0,NULL,22.8,'1','30',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-09-20 21:12:54','2025-11-17 21:12:54',NULL),(31,'#1000032','THE4FLPS4I4RREAOYBEAWCCKWF4ESK0U','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',300,300,0,NULL,30,'1','31',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:12:54','2025-11-17 21:12:54',1),(32,'#1000033','ZPGNVBUJER7UP54DXUNOGDGV6JUSOEDE','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',42,42,0,NULL,0,'1','32',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:12:54','2025-11-17 21:12:54',10),(33,'#1000034','CKG8IO66JULSDNDTML108OERYUA6BHDI','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',252,252,0,NULL,0,'1','33',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-15 21:12:54','2025-11-17 21:12:54',7),(34,'#1000035','H9HX5QHDMFOYAT2T5FQG9ZXZEY9AOQWU','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',270,270,0,NULL,0,'1','34',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-12 21:12:54','2025-11-17 21:12:54',9),(35,'#1000036','RS2HUKSAAWEFPQSVU665BYVOCANPD6SD','Karlee Ruecker Jr.','alvis35@example.com','+13515620213',NULL,'29',126,126,0,NULL,12.6,'1','35',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-10 21:12:54','2025-11-17 21:12:54',8),(36,'#1000037','TFIYSQ4BLNE6MEDNWHFIYIW1MK3MKLRD','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',64,64,0,NULL,6.4,'1','36',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-16 21:12:54','2025-11-17 21:12:54',18),(37,'#1000038','NGY8CO0RIRQNTFLXMXMFNXS2M6QKAIDU','Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',NULL,'22',376,376,0,NULL,0,'1','37',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-16 21:12:54','2025-11-17 21:12:54',18),(38,'#1000039','Y6VUKXHZD6GOIQEQDFLA6MS1FDJMY0XL','Karlee Ruecker Jr.','alvis35@example.com','+13515620213',NULL,'29',292,292,0,NULL,0,'1','38',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:12:54','2025-11-17 21:12:54',NULL),(39,'#1000040','EE30JVJ6OUFLCZTWMNEHFT4SDHLEMVHL','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',294,294,0,NULL,0,'1','39',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-13 21:12:54','2025-11-17 21:12:54',NULL),(40,'#1000041','7DK2VQAANWRRQWYCSLKWEW6TAG9FO0LJ','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',243,243,0,NULL,0,'1','40',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:12:54','2025-11-17 21:12:54',NULL),(41,'#1000042','QXOWBWYTGCRECKLWWPJFL2XLXXWHCEEG','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',420,420,0,NULL,0,'1','41',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-13 21:12:54','2025-11-17 21:12:54',8),(42,'#1000043','XAOVAUAVLAC5IMFDIBHI9LWS4XPOYQRH','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',189,189,0,NULL,0,'1','42',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-17 21:12:54','2025-11-17 21:12:54',18),(43,'#1000044','TUAUNTIGILQO1ST3ARL7G9YUF8F6NIDS','Jorge Cole','customer@botble.com','+12027539334',NULL,'31',189,189,0,NULL,0,'1','43',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-13 21:12:54','2025-11-17 21:12:54',2),(44,'#1000045','HI38GOH4E9MVYC87XTSSRNCWJ0MCDDVF','Clifford Corkery','fdenesik@example.net','+14122179291',NULL,'28',86,86,0,NULL,8.6,'1','44',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:12:54','2025-11-17 21:12:54',14),(45,'#1000046','HWHHI5GDMGFUZ93D2RLPWAUOTADYALOI','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',268,268,0,NULL,0,'1','45',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-10 21:12:54','2025-11-17 21:12:54',9),(46,'#1000047','QXAEBMHUQGB0DOM4VAQBDV2TCSQ14GU8','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',186,186,0,NULL,0,'1','46',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-10 21:12:54','2025-11-17 21:12:54',5),(47,'#1000048','IJSQU5SQ5EHBGAVKRPMFRNWYYBUCL6RM','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',210,210,0,NULL,0,'1','47',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-15 21:12:54','2025-11-17 21:12:54',10),(48,'#1000049','ESPUPAY4GTZDTLSQTYPCE1GSNGH2SAZT','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',147,147,0,NULL,0,'1','48',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-15 21:12:54','2025-11-17 21:12:54',NULL),(49,'#1000050','F6VFS80HBPDBNNFZDF2LSFDWBESCEWYH','Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',NULL,'22',294,294,0,NULL,0,'1','49',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-15 21:12:54','2025-11-17 21:12:54',NULL),(50,'#1000051','GPZRQY3VHTDGC5NHIW5AOHJNFKUMKX0W','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',490,490,0,NULL,0,'1','50',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-12 21:12:54','2025-11-17 21:12:54',NULL),(51,'#1000052','OHU3MSUQV3TREC8WHC0EPHTCW3MWVTFX','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',462,462,0,NULL,0,'1','51',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-25 21:12:54','2025-11-17 21:12:54',15),(52,'#1000053','XEYAQZDC4MJGKIRCU6GEBJYCT3UTANOH','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',275,275,0,NULL,0,'1','52',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-20 21:12:54','2025-11-17 21:12:54',12),(53,'#1000054','QG8KB3US3XXKK446UI8EZJXJGJIDYR09','Joelle McClure II','schroeder.davion@example.net','+18624541003',NULL,'25',252,252,0,NULL,0,'1','53',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-30 21:12:54','2025-11-17 21:12:54',10),(54,'#1000055','SDFL1BVO1SHGBKZNLFELOLQVUPS2HXMG','Karlee Ruecker Jr.','alvis35@example.com','+13515620213',NULL,'29',245,245,0,NULL,0,'1','54',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-07 21:12:54','2025-11-17 21:12:54',32),(55,'#1000056','VM0ISMETMKK984L00EOFELF70IHPZUG3','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',189,189,0,NULL,0,'1','55',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-28 21:12:54','2025-11-17 21:12:54',2),(56,'#1000057','JOJC1EOYKW0UNWSR4EI03ZOJF2K7CKMG','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',183,183,0,NULL,0,'1','56',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-04 21:12:54','2025-11-17 21:12:54',18),(57,'#1000058','MDNHR7OL66RNFIPE32M7OBA3APTKNBOT','Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',NULL,'22',32,32,0,NULL,0,'1','57',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-09 21:12:54','2025-11-17 21:12:54',18),(58,'#1000059','FIW8GYITSQIQDFJ9GLTTGBCKQ3KQ9IEK','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',180,180,0,NULL,0,'1','58',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-11 21:12:54','2025-11-17 21:12:54',NULL),(59,'#1000060','AXLSVNCKYS5EFEL0DM7FUUSKFVMAJZRZ','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',455,455,0,NULL,0,'1','59',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-13 21:12:54','2025-11-17 21:12:54',NULL),(60,'#1000061','U1ELKMPEZJREXWOSZJFCVMFLJLWQCSHL','Barbara Goldner','justine.raynor@example.com','+14099364802',NULL,'26',300,300,0,NULL,0,'1','60',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-30 21:12:54','2025-11-17 21:12:54',NULL),(61,'#1000062','0YKGXQVUVP8ASEBXHX9LXQLFEETQ0FID','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',30,30,0,NULL,0,'1','61',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-05 21:12:54','2025-11-17 21:12:54',12),(62,'#1000063','VRSKDDCAESRKYZNBQBPUY0QOAGA0DMRN','Barbara Goldner','justine.raynor@example.com','+14099364802',NULL,'26',126,126,0,NULL,0,'1','62',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-22 21:12:54','2025-11-17 21:12:54',18),(63,'#1000064','04XU7BLRNUEXZ9O1JIXOXKTMDIGTJXA8','Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',NULL,'22',623,623,0,NULL,62.3,'1','63',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-09 21:12:54','2025-11-17 21:12:54',15),(64,'#1000065','ZBAS9DQFXKUOPZNZR9WGTM6IYFCPDKEM','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',243,243,0,NULL,24.3,'1','64',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-06 21:12:54','2025-11-17 21:12:54',4),(65,'#1000066','HOGAIWQYEOM7ZR4WBACZJBUTX0K81XSM','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',480,480,0,NULL,0,'1','65',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-07 21:12:54','2025-11-17 21:12:54',3),(66,'#1000067','AZNNKZTUMPG9A5VOPDKN8HPYSF6WXJWV','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',235,235,0,NULL,0,'1','66',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-12 21:12:54','2025-11-17 21:12:54',20),(67,'#1000068','DEGQUEDELR1CWVOQXWDWFGJ8ZRA7EWCC','Clifford Corkery','fdenesik@example.net','+14122179291',NULL,'28',129,129,0,NULL,0,'1','67',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-09 21:12:54','2025-11-17 21:12:54',14),(68,'#1000069','VRXH2NZEAGY9ESFEKUSVAFR38XRGYBRZ','Nona Swaniawski','fromaguera@example.com','+17328589848',NULL,'27',219,219,0,NULL,21.9,'1','68',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-19 21:12:54','2025-11-17 21:12:54',NULL),(69,'#1000070','TVUYXQR0WHVU0DQJ1K1KD8QLUXUGO2PD','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',511,511,0,NULL,0,'1','69',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-26 21:12:54','2025-11-17 21:12:54',NULL),(70,'#1000071','RYHJDDN450AAJ632IXW3TBW8IR5S63LC','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',273,273,0,NULL,0,'1','70',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-07 21:12:54','2025-11-17 21:12:54',NULL),(71,'#1000072','MDUJPUL4JNUOT9IDOHPCDFBBUNFQPZPZ','Karlee Ruecker Jr.','alvis35@example.com','+13515620213',NULL,'29',252,252,0,NULL,0,'1','71',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-14 21:12:54','2025-11-17 21:12:54',10),(72,'#1000073','USXRORZ9XPJUDOXLJJCHVVUMWUDAERVH','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',301,301,0,NULL,0,'1','72',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-18 21:12:54','2025-11-17 21:12:54',14),(73,'#1000074','5QIJTDOES8UBVZWTW5ZJUDWEKEFTKWT3','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',47,47,0,NULL,4.7,'1','73',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-22 21:12:54','2025-11-17 21:12:54',20),(74,'#1000075','7MG23HV9BRU5UICKKDOBEEM0DCLDPWU6','Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',NULL,'22',186,186,0,NULL,0,'1','74',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-29 21:12:54','2025-11-17 21:12:54',2),(75,'#1000076','TQOJKRPWHXNWRDR2YDM7XQUNTXLFGQHH','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',64,64,0,NULL,0,'1','75',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-18 21:12:54','2025-11-17 21:12:54',15),(76,'#1000077','E0HDMYNAWT62DVDFORLXIUTF6ZLWR7XP','Bobby Hintz','trystan.wisozk@example.net','+14143442961',NULL,'23',438,438,0,NULL,0,'1','76',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-08 21:12:54','2025-11-17 21:12:54',9),(77,'#1000078','HWY8LT9X6JQF57EVASBABZXFLMZREI8E','Jorge Cole','customer@botble.com','+12027539334',NULL,'31',180,180,0,NULL,0,'1','77',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-15 21:12:54','2025-11-17 21:12:54',12),(78,'#1000079','EYKQZJ6RRI7ODWMQ6IFOUFZYADTQGBH4','Desmond Morissette','winifred.ferry@example.org','+13809239578',NULL,'30',455,455,0,NULL,0,'1','78',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-24 21:12:54','2025-11-17 21:12:54',NULL),(79,'#1000080','XEMU2ZYK8INKXXGDJZWBA40YZBN7UOOY','Clint Terry','romaguera.emmitt@example.org','+17075976359',NULL,'21',34,34,0,NULL,0,'1','79',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-29 21:12:55','2025-11-17 21:12:55',NULL),(80,'#1000081','JVX8WD0HQWT786XI7O69VSU3HFZZTSVX','Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',NULL,'24',126,126,0,NULL,0,'1','80',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-25 21:12:55','2025-11-17 21:12:55',NULL);
/*!40000 ALTER TABLE `cr_bookings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenities`
--

DROP TABLE IF EXISTS `cr_car_amenities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_amenities_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenities`
--

LOCK TABLES `cr_car_amenities` WRITE;
/*!40000 ALTER TABLE `cr_car_amenities` DISABLE KEYS */;
INSERT INTO `cr_car_amenities` VALUES (1,'Leather upholstery','ti ti-armchair',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Heated seats','ti ti-flame',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Ventilated seats','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Memory seats','ti ti-device-floppy',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Massage seats','ti ti-massage',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Premium sound system','ti ti-volume',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(7,'Wireless charging','ti ti-battery-charging',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(8,'Dual-zone climate control','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(9,'Ambient lighting','ti ti-bulb',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(10,'Touchscreen display','ti ti-device-tablet',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(11,'Apple CarPlay','ti ti-brand-apple',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(12,'Android Auto','ti ti-brand-android',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(13,'Bluetooth connectivity','ti ti-bluetooth',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(14,'USB ports','ti ti-usb',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(15,'Navigation system','ti ti-map-pin',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(16,'Heads-up display','ti ti-device-desktop',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(17,'Digital instrument cluster','ti ti-dashboard',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(18,'Voice control','ti ti-microphone',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(19,'Sunroof/Moonroof','ti ti-sun',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(20,'Panoramic roof','ti ti-sun-high',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(21,'Power tailgate','ti ti-door',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(22,'Keyless entry','ti ti-key',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(23,'Push-button start','ti ti-power',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(24,'Remote start','ti ti-remote',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(25,'Heated mirrors','ti ti-flame',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(26,'Rain-sensing wipers','ti ti-droplet',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(27,'Auto-dimming mirrors','ti ti-brightness-down',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(28,'Adaptive cruise control','ti ti-steering-wheel',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(29,'Lane departure warning','ti ti-road-sign',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(30,'Blind spot monitoring','ti ti-eye',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(31,'Parking sensors','ti ti-radar',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(32,'Backup camera','ti ti-camera',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(33,'360-degree camera','ti ti-360-view',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(34,'Automatic emergency braking','ti ti-shield-check',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(35,'Cross-traffic alert','ti ti-alert-triangle',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(36,'Driver attention monitoring','ti ti-eye-check',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(37,'All-wheel drive','ti ti-car-4wd',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(38,'Sport mode','ti ti-flag',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(39,'Paddle shifters','ti ti-steering-wheel',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(40,'Adaptive suspension','ti ti-adjustments',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(41,'Electronic stability control','ti ti-shield',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(42,'Traction control','ti ti-wheel',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(43,'Hill start assist','ti ti-mountain',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(44,'Downhill assist control','ti ti-trending-down',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(45,'Air conditioning','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(46,'Power windows','ti ti-window',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(47,'Central locking','ti ti-lock',NULL,'published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_amenities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenities_translations`
--

DROP TABLE IF EXISTS `cr_car_amenities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenities_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_amenities_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_amenities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenities_translations`
--

LOCK TABLES `cr_car_amenities_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_amenities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_amenities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenity_categories`
--

DROP TABLE IF EXISTS `cr_car_amenity_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenity_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '0',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_amenity_categories_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenity_categories`
--

LOCK TABLES `cr_car_amenity_categories` WRITE;
/*!40000 ALTER TABLE `cr_car_amenity_categories` DISABLE KEYS */;
INSERT INTO `cr_car_amenity_categories` VALUES (1,'Comfort & Interior','ti ti-armchair',1,'published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Technology & Infotainment','ti ti-device-tablet',2,'published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Exterior & Convenience','ti ti-sun',3,'published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Safety & Driver Assistance','ti ti-shield-check',4,'published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Performance & Handling','ti ti-steering-wheel',5,'published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Basic Features','ti ti-car',6,'published','2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_amenity_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenity_categories_translations`
--

DROP TABLE IF EXISTS `cr_car_amenity_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenity_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_amenity_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_amenity_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenity_categories_translations`
--

LOCK TABLES `cr_car_amenity_categories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_amenity_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_amenity_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_categories`
--

DROP TABLE IF EXISTS `cr_car_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_categories`
--

LOCK TABLES `cr_car_categories` WRITE;
/*!40000 ALTER TABLE `cr_car_categories` DISABLE KEYS */;
INSERT INTO `cr_car_categories` VALUES (1,'Sport',0,'Sport cars model','published','ti ti-sport-billard',1,0,0,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(2,'Maserati',1,'','published','ti ti-activity',3,0,0,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(3,'Ferrari',1,'','published',NULL,3,0,0,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(4,'Classic',0,'Classic cars model','published','ti ti-alpha',2,0,0,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(5,'New',0,'New cars model','published','ti ti-new-section',4,0,1,'2025-11-17 21:12:53','2025-11-17 21:12:53');
/*!40000 ALTER TABLE `cr_car_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_categories_translations`
--

DROP TABLE IF EXISTS `cr_car_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_car_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_categories_translations`
--

LOCK TABLES `cr_car_categories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_colors`
--

DROP TABLE IF EXISTS `cr_car_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_colors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_colors_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_colors`
--

LOCK TABLES `cr_car_colors` WRITE;
/*!40000 ALTER TABLE `cr_car_colors` DISABLE KEYS */;
INSERT INTO `cr_car_colors` VALUES (1,'Red','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'White','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Black','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Blue','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Pink','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Brown','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_colors_translations`
--

DROP TABLE IF EXISTS `cr_car_colors_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_colors_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_colors_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_colors_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_colors_translations`
--

LOCK TABLES `cr_car_colors_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_colors_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_colors_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_fuels`
--

DROP TABLE IF EXISTS `cr_car_fuels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_fuels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_fuels_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_fuels`
--

LOCK TABLES `cr_car_fuels` WRITE;
/*!40000 ALTER TABLE `cr_car_fuels` DISABLE KEYS */;
INSERT INTO `cr_car_fuels` VALUES (1,'Gasoline','icons/car-diesel.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Diesel','icons/car-diesel.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Electric','icons/car-electricity.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_fuels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_fuels_translations`
--

DROP TABLE IF EXISTS `cr_car_fuels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_fuels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_fuels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_fuels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_fuels_translations`
--

LOCK TABLES `cr_car_fuels_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_fuels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_fuels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_maintenance_histories`
--

DROP TABLE IF EXISTS `cr_car_maintenance_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_maintenance_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `amount` double NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned NOT NULL,
  `date` datetime DEFAULT NULL,
  `car_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_maintenance_histories_car_id_index` (`car_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_maintenance_histories`
--

LOCK TABLES `cr_car_maintenance_histories` WRITE;
/*!40000 ALTER TABLE `cr_car_maintenance_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_maintenance_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_maintenance_histories_translations`
--

DROP TABLE IF EXISTS `cr_car_maintenance_histories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_maintenance_histories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_maintenance_histories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_maintenance_histories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_maintenance_histories_translations`
--

LOCK TABLES `cr_car_maintenance_histories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_maintenance_histories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_maintenance_histories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_makes`
--

DROP TABLE IF EXISTS `cr_car_makes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_makes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_makes`
--

LOCK TABLES `cr_car_makes` WRITE;
/*!40000 ALTER TABLE `cr_car_makes` DISABLE KEYS */;
INSERT INTO `cr_car_makes` VALUES (1,'Lexus','icons/lexus.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Mercedes','icons/mer.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Bugatti','icons/bugatti.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Jaguar','icons/jaguar.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Honda','icons/honda.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Chevrolet','icons/chevrolet.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(7,'Acura','icons/acura.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(8,'BMW','icons/bmw.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(9,'Toyota','icons/toyota.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(10,'Ford','icons/ford-i.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(11,'Nissan','icons/nissan-i.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(12,'Opel','icons/opel-i.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(13,'BMW','icons/bmw.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(14,'Toyota','icons/toyota.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_makes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_makes_translations`
--

DROP TABLE IF EXISTS `cr_car_makes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_makes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_makes_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_makes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_makes_translations`
--

LOCK TABLES `cr_car_makes_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_makes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_makes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_reviews`
--

DROP TABLE IF EXISTS `cr_car_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `star` double NOT NULL DEFAULT '0',
  `customer_id` bigint unsigned NOT NULL,
  `car_id` bigint unsigned NOT NULL,
  `booking_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_reviews_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_reviews`
--

LOCK TABLES `cr_car_reviews` WRITE;
/*!40000 ALTER TABLE `cr_car_reviews` DISABLE KEYS */;
INSERT INTO `cr_car_reviews` VALUES (1,'Outstanding rental experience! Premium sound system was amazing The car was like driving a brand new car and provided effortless acceleration. Outstanding customer service from start to finish Exceeded all expectations. Will definitely be back!',5,7,57,NULL,'published','2024-03-18 00:53:00','2025-11-17 21:12:53'),(2,'Perfect car for our family road trip! Exceptional ergonomics and support Exceptional driving dynamics in all conditions The customer service was world-class Cannot fault anything about this rental. 10/10 would recommend!',5,29,91,NULL,'published','2024-11-08 09:49:06','2025-11-17 21:12:53'),(3,'Great rental experience! Very comfortable seats The car was in excellent mechanical condition and performed flawlessly throughout our trip. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,16,67,NULL,'published','2024-09-16 20:26:13','2025-11-17 21:12:53'),(4,'Standard rental car. No major issues during our rental The pickup process took a while A typical rental car experience Met basic expectations.',3,9,71,NULL,'published','2024-01-03 07:34:21','2025-11-17 21:12:53'),(5,'Absolutely fantastic! Every feature worked flawlessly Performed flawlessly under all conditions This rental exceeded every expectation This is how car rentals should be done. Thank you for an amazing experience!',5,32,52,NULL,'published','2025-06-05 14:47:52','2025-11-17 21:12:53'),(6,'Terrible experience with this car. The air conditioning wasn\'t working properly The vehicle was showing significant wear and was making concerning noises. Would not recommend to anyone. Customer service was unhelpful when I reported the issues.',1,11,98,NULL,'published','2023-12-18 17:30:23','2025-11-17 21:12:53'),(7,'Best rental car I\'ve ever had! Luxury-level quality throughout Service that sets the gold standard Best deal I\'ve found in years Everything was perfect from start to finish. Will definitely use again!',5,1,99,NULL,'published','2025-07-20 10:41:53','2025-11-17 21:12:53'),(8,'Decent car for the price. The sound system worked fine one cup holder being a bit loose but overall acceptable for family road trip. Would consider again if needed.',3,4,48,NULL,'published','2025-03-15 14:09:43','2025-11-17 21:12:53'),(9,'Great rental experience! Excellent fuel economy The car was running smoothly and performed flawlessly throughout our trip. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,11,79,NULL,'published','2025-01-30 17:20:34','2025-11-17 21:12:53'),(10,'Perfect car for our vacation! The seats were like luxury recliners Outstanding handling that exceeded expectations Staff went above and beyond at every step Cannot fault anything about this rental. 10/10 would recommend!',5,20,93,NULL,'published','2025-05-16 03:43:55','2025-11-17 21:12:53'),(11,'Very pleased with this rental. Well-maintained and cared for vehicle Made the rental process seamless Perfect for business or leisure travel Just a small issue with a small scuff on the rear bumper but nothing major.',4,6,68,NULL,'published','2025-05-14 15:59:39','2025-11-17 21:12:53'),(12,'Outstanding rental experience! Incredible fuel efficiency saved us money The car was immaculate in every detail and provided effortless acceleration. The team was absolutely wonderful to work with Exceeded all expectations. Will definitely be back!',5,9,33,NULL,'published','2025-08-15 17:58:11','2025-11-17 21:12:53'),(13,'Outstanding rental experience! Premium sound system was amazing The car was mechanically perfect and was remarkably quiet and refined. Outstanding customer service from start to finish Exceeded all expectations. Will definitely be back!',5,9,6,NULL,'published','2024-10-15 22:20:42','2025-11-17 21:12:53'),(14,'Absolutely fantastic! The technology was cutting-edge and intuitive Reliability that exceeded all expectations This rental exceeded every expectation This is how car rentals should be done. Thank you for an amazing experience!',5,32,3,NULL,'published','2025-09-16 12:23:10','2025-11-17 21:12:53'),(15,'Perfect car for our wedding! Premium seating that rivals luxury vehicles Incredible power delivery and smooth operation Staff went above and beyond at every step Cannot fault anything about this rental. 10/10 would recommend!',5,25,96,NULL,'published','2024-05-22 13:03:55','2025-11-17 21:12:53'),(16,'Perfect car for our wedding! Premium seating that rivals luxury vehicles Outstanding handling that exceeded expectations Outstanding professionalism and care Cannot fault anything about this rental. 10/10 would recommend!',5,27,67,NULL,'published','2024-09-13 02:37:19','2025-11-17 21:12:53'),(17,'Had some issues with this rental. The air conditioning was barely working which made navigation very difficult The price was reasonable but the quality didn\'t match.',2,27,48,NULL,'published','2025-10-02 06:30:19','2025-11-17 21:12:53'),(18,'Decent car for the price. The visibility was good the pickup location being slightly hard to find but overall acceptable for conference. Would consider again if needed.',3,14,18,NULL,'published','2024-05-13 12:43:07','2025-11-17 21:12:53'),(19,'Average rental experience. Nothing particularly stood out about this rental The GPS was a bit outdated but the fuel efficiency was decent. Nothing special but gets the job done.',3,24,4,NULL,'published','2025-02-18 01:51:34','2025-11-17 21:12:53'),(20,'Very disappointed. The car showed signs of heavy use The sound system was not functioning properly and it felt unstable at highway speeds. Not worth the money at all.',1,17,12,NULL,'published','2024-06-18 09:41:04','2025-11-17 21:12:53'),(21,'Standard rental car. Adequate for the rental period The GPS was a bit outdated Nothing exceptional but nothing terrible Met basic expectations.',3,12,65,NULL,'published','2024-12-26 07:51:59','2025-11-17 21:12:53'),(22,'Great rental experience! Great sound system The car was clean and well-maintained and had plenty of power when needed. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,15,13,NULL,'published','2025-09-28 15:59:14','2025-11-17 21:12:53'),(23,'Best rental car I\'ve ever had! Quality that rivals the finest vehicles Exceptional attention to customer needs Outstanding value for the price paid Everything was perfect from start to finish. Will definitely use again!',5,1,10,NULL,'published','2024-09-04 18:33:27','2025-11-17 21:12:53'),(24,'Absolutely fantastic! The technology was cutting-edge and intuitive Performed flawlessly under all conditions A truly exceptional experience from start to finish This is how car rentals should be done. Thank you for an amazing experience!',5,23,78,NULL,'published','2024-08-18 10:18:23','2025-11-17 21:12:53'),(25,'Excellent value for money. Great visibility from all angles Completely dependable for our entire trip Made our vacation stress-free and enjoyable Will book with them again for sure.',4,29,59,NULL,'published','2024-04-16 23:42:35','2025-11-17 21:12:53'),(26,'Outstanding rental experience! Advanced safety features gave us confidence The car was like driving a brand new car and handled like a dream on every road. They made everything so easy and stress-free Exceeded all expectations. Will definitely be back!',5,15,54,NULL,'published','2025-04-09 02:43:06','2025-11-17 21:12:53'),(27,'Mixed feelings about this rental. the technology features were helpful but the pickup process was slower than expected. Gets you from point A to point B Fair value for money.',3,31,60,NULL,'published','2024-06-27 07:16:12','2025-11-17 21:12:53'),(28,'Had some issues with this rental. There was a strong odor in the cabin that we couldn\'t get rid of despite airing out The price was reasonable but the quality didn\'t match.',2,1,72,NULL,'published','2024-12-08 17:07:14','2025-11-17 21:12:53'),(29,'Mixed feelings about this rental. the fuel economy exceeded expectations but the pickup process was slower than expected. Does what it\'s supposed to do Fair value for money.',3,27,97,NULL,'published','2024-09-11 19:53:09','2025-11-17 21:12:53'),(30,'Absolutely fantastic! Advanced capabilities that impressed everyone Zero problems - just pure dependability Absolutely outstanding in every possible way This is how car rentals should be done. Thank you for an amazing experience!',5,32,23,NULL,'published','2024-11-17 22:42:41','2025-11-17 21:12:53'),(31,'Had some issues with this rental. The GPS system was completely outdated that we couldn\'t get rid of despite airing out The price was reasonable but the quality didn\'t match.',2,23,8,NULL,'published','2025-05-20 14:32:25','2025-11-17 21:12:53'),(32,'Great rental experience! Excellent fuel economy The car was spotless inside and out and was very fuel efficient. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,6,71,NULL,'published','2025-09-13 17:56:49','2025-11-17 21:12:53'),(33,'Excellent value for money. The infotainment system was user-friendly Never had a single mechanical issue Contributed to a memorable road trip Will book with them again for sure.',4,10,27,NULL,'published','2025-04-07 21:28:26','2025-11-17 21:12:53'),(34,'Really enjoyed driving this car. Climate control worked perfectly Smooth acceleration and responsive braking Made our trip so much more enjoyable Only minor complaint is one of the USB ports wasn\'t working. Highly recommend!',4,26,79,NULL,'published','2025-04-19 23:59:25','2025-11-17 21:12:53'),(35,'Excellent value for money. Excellent safety features gave us confidence Performed consistently throughout our rental Contributed to a memorable road trip Will book with them again for sure.',4,26,9,NULL,'published','2024-05-16 03:26:16','2025-11-17 21:12:53'),(36,'Perfect car for our family road trip! Exceptional ergonomics and support Performance that rivals much more expensive cars Outstanding professionalism and care Cannot fault anything about this rental. 10/10 would recommend!',5,13,8,NULL,'published','2024-01-03 10:04:17','2025-11-17 21:12:53'),(37,'Outstanding rental experience! The car was immaculate inside and out The car was absolutely pristine and handled like a dream on every road. The staff went above and beyond to help us Exceeded all expectations. Will definitely be back!',5,13,95,NULL,'published','2024-10-18 18:26:34','2025-11-17 21:12:53'),(38,'Decent car for the price. The sound system worked fine the pickup location being slightly hard to find but overall acceptable for conference. Would consider again if needed.',3,30,46,NULL,'published','2024-10-30 08:41:38','2025-11-17 21:12:53'),(39,'Really enjoyed driving this car. Climate control worked perfectly Smooth acceleration and responsive braking Made our trip so much more enjoyable Only minor complaint is the pickup location was hard to find. Highly recommend!',4,13,60,NULL,'published','2024-10-13 02:53:32','2025-11-17 21:12:53'),(40,'Best rental car I\'ve ever had! The quality was absolutely pristine The customer service was world-class Worth every penny and more Everything was perfect from start to finish. Will definitely use again!',5,10,26,NULL,'published','2024-10-22 13:26:36','2025-11-17 21:12:53'),(41,'Excellent value for money. The keyless entry was very convenient Started every time without hesitation Reliable transportation for our family trip Will book with them again for sure.',4,15,53,NULL,'published','2025-10-10 13:56:09','2025-11-17 21:12:53'),(42,'Really enjoyed driving this car. Very quiet cabin for conversations The car felt stable and well-balanced Impressed all our passengers Only minor complaint is the car manual was missing. Highly recommend!',4,4,44,NULL,'published','2025-01-13 11:41:47','2025-11-17 21:12:53'),(43,'Average rental experience. The vehicle met basic expectations Could use a bit more trunk space but the car was clean. Nothing special but gets the job done.',3,24,95,NULL,'published','2024-01-02 10:00:41','2025-11-17 21:12:53'),(44,'Excellent value for money. Great visibility from all angles Performed consistently throughout our rental Contributed to a memorable road trip Will book with them again for sure.',4,6,2,NULL,'published','2025-07-01 09:36:29','2025-11-17 21:12:53'),(45,'Great rental experience! Easy to drive and park The car was in excellent mechanical condition and was surprisingly quiet and smooth. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,9,45,NULL,'published','2025-07-24 02:28:06','2025-11-17 21:12:53'),(46,'Decent car for the price. The sound system worked fine a small scuff on the rear bumper but overall acceptable for wedding. Would consider again if needed.',3,6,66,NULL,'published','2023-12-26 01:29:38','2025-11-17 21:12:53'),(47,'Perfect car for our family road trip! Premium seating that rivals luxury vehicles Exceptional driving dynamics in all conditions The customer service was world-class Cannot fault anything about this rental. 10/10 would recommend!',5,2,30,NULL,'published','2024-03-30 12:23:39','2025-11-17 21:12:53'),(48,'Had some issues with this rental. The air conditioning was barely working that we couldn\'t get rid of despite airing out The price was reasonable but the quality didn\'t match.',2,9,41,NULL,'published','2025-02-08 01:57:33','2025-11-17 21:12:53'),(49,'Absolutely fantastic! Premium features that enhanced every moment Performed flawlessly under all conditions This rental exceeded every expectation This is how car rentals should be done. Thank you for an amazing experience!',5,23,2,NULL,'published','2024-09-29 18:00:11','2025-11-17 21:12:53'),(50,'Below expectations. The GPS was a bit outdated The car was reasonable considering the age but The pickup/return process. The price was competitive but overall not satisfied with the rental.',2,25,20,NULL,'published','2025-07-01 18:13:29','2025-11-17 21:12:53'),(51,'Average rental experience. The vehicle met basic expectations Could use a bit more trunk space but the pickup was convenient. Nothing special but gets the job done.',3,31,41,NULL,'published','2024-02-02 11:06:50','2025-11-17 21:12:53'),(52,'Standard rental car. The car was clean and functional The radio presets weren\'t cleared Meets expectations without exceeding them Met basic expectations.',3,26,68,NULL,'published','2025-04-03 07:54:27','2025-11-17 21:12:53'),(53,'Perfect car for our weekend getaway! Unparalleled comfort for long-distance driving Exceptional driving dynamics in all conditions Exceptional attention to customer needs Cannot fault anything about this rental. 10/10 would recommend!',5,26,78,NULL,'published','2023-11-23 09:32:39','2025-11-17 21:12:53'),(54,'Excellent value for money. The keyless entry was very convenient Never had a single mechanical issue Perfect companion for our business travel Will book with them again for sure.',4,20,22,NULL,'published','2025-01-11 14:02:10','2025-11-17 21:12:53'),(55,'Really enjoyed driving this car. Incredibly comfortable for long drives Reliable performance throughout our trip Perfect for our family vacation Only minor complaint is the pickup location was hard to find. Highly recommend!',4,14,19,NULL,'published','2024-05-12 00:09:22','2025-11-17 21:12:53'),(56,'Perfect car for our business trip! Every passenger commented on the amazing comfort Incredible power delivery and smooth operation Exceptional attention to customer needs Cannot fault anything about this rental. 10/10 would recommend!',5,27,70,NULL,'published','2024-09-27 07:49:21','2025-11-17 21:12:53'),(57,'Excellent value for money. The automatic climate control worked perfectly Never had a single mechanical issue Enhanced our weekend getaway experience Will book with them again for sure.',4,19,27,NULL,'published','2024-02-09 20:13:38','2025-11-17 21:12:53'),(58,'Great rental experience! Smooth and quiet ride The car was spotless inside and out and was surprisingly quiet and smooth. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,22,43,NULL,'published','2023-11-26 12:06:01','2025-11-17 21:12:53'),(59,'Outstanding rental experience! The car was immaculate inside and out The car was like driving a brand new car and delivered outstanding fuel economy. Outstanding customer service from start to finish Exceeded all expectations. Will definitely be back!',5,2,87,NULL,'published','2024-08-14 13:04:03','2025-11-17 21:12:53'),(60,'Absolutely fantastic! State-of-the-art amenities throughout Absolutely perfect reliability record A truly exceptional experience from start to finish This is how car rentals should be done. Thank you for an amazing experience!',5,16,50,NULL,'published','2025-10-28 16:06:24','2025-11-17 21:12:53'),(61,'Terrible experience with this car. The engine was making strange noises The vehicle was not properly maintained and was not as described. Would not recommend to anyone. Customer service was unhelpful when I reported the issues.',1,8,1,NULL,'published','2025-08-17 13:22:45','2025-11-17 21:12:53'),(62,'Outstanding rental experience! Premium sound system was amazing The car was like driving a brand new car and was remarkably quiet and refined. The staff went above and beyond to help us Exceeded all expectations. Will definitely be back!',5,3,97,NULL,'published','2024-07-10 20:57:01','2025-11-17 21:12:53'),(63,'Really enjoyed driving this car. Very quiet cabin for conversations Smooth acceleration and responsive braking Handled the mountain roads beautifully Only minor complaint is the pickup location was hard to find. Highly recommend!',4,4,93,NULL,'published','2024-09-10 22:45:27','2025-11-17 21:12:53'),(64,'Absolutely fantastic! Every feature worked flawlessly Not a single issue throughout our entire rental Absolutely outstanding in every possible way This is how car rentals should be done. Thank you for an amazing experience!',5,20,72,NULL,'published','2024-06-30 01:53:54','2025-11-17 21:12:53'),(65,'Really enjoyed driving this car. Seats were supportive and adjustable The engine performed well on both city and highway Great for city driving and parking Only minor complaint is one of the USB ports wasn\'t working. Highly recommend!',4,21,20,NULL,'published','2024-02-05 17:36:49','2025-11-17 21:12:53'),(66,'Excellent value for money. The infotainment system was user-friendly Performed consistently throughout our rental Contributed to a memorable road trip Will book with them again for sure.',4,26,29,NULL,'published','2024-09-29 05:00:29','2025-11-17 21:12:53'),(67,'Very pleased with this rental. Well-maintained and cared for vehicle Staff was friendly and professional Would definitely recommend to others Just a small issue with one cup holder being a bit loose but nothing major.',4,9,90,NULL,'published','2024-03-16 23:02:42','2025-11-17 21:12:53'),(68,'Very pleased with this rental. The build quality was impressive Made the rental process seamless Great choice for anyone needing a reliable car Just a small issue with a small scuff on the rear bumper but nothing major.',4,12,44,NULL,'published','2024-12-18 10:24:53','2025-11-17 21:12:53'),(69,'Great rental experience! Excellent fuel economy The car was spotless inside and out and was very fuel efficient. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,31,1,NULL,'published','2024-05-03 08:14:51','2025-11-17 21:12:53'),(70,'Excellent value for money. Great visibility from all angles Completely dependable for our entire trip Made our vacation stress-free and enjoyable Will book with them again for sure.',4,3,39,NULL,'published','2024-05-06 03:52:56','2025-11-17 21:12:53'),(71,'Outstanding rental experience! Premium sound system was amazing The car was absolutely pristine and exceeded all performance expectations. They made everything so easy and stress-free Exceeded all expectations. Will definitely be back!',5,6,43,NULL,'published','2024-05-03 15:47:55','2025-11-17 21:12:53'),(72,'Standard rental car. Served our transportation needs The GPS was a bit outdated Standard service and vehicle quality Met basic expectations.',3,30,48,NULL,'published','2024-06-24 00:59:28','2025-11-17 21:12:53'),(73,'Absolutely fantastic! Premium features that enhanced every moment Absolutely perfect reliability record Absolutely outstanding in every possible way This is how car rentals should be done. Thank you for an amazing experience!',5,15,86,NULL,'published','2024-08-18 01:56:32','2025-11-17 21:12:53'),(74,'Very pleased with this rental. Well-maintained and cared for vehicle Excellent customer service Perfect for business or leisure travel Just a small issue with the pickup location being slightly hard to find but nothing major.',4,9,84,NULL,'published','2025-07-15 02:36:37','2025-11-17 21:12:53'),(75,'Very pleased with this rental. The build quality was impressive Made the rental process seamless Would definitely recommend to others Just a small issue with the radio taking a moment to connect to Bluetooth but nothing major.',4,32,79,NULL,'published','2025-03-10 04:21:46','2025-11-17 21:12:53'),(76,'Very pleased with this rental. Well-maintained and cared for vehicle Staff was friendly and professional Perfect for business or leisure travel Just a small issue with the owner\'s manual being missing but nothing major.',4,12,80,NULL,'published','2024-11-09 23:32:00','2025-11-17 21:12:53'),(77,'Mixed feelings about this rental. the overall condition was satisfactory but the customer service could be improved. Does what it\'s supposed to do Fair value for money.',3,17,11,NULL,'published','2024-10-27 12:11:06','2025-11-17 21:12:53'),(78,'Excellent value for money. The automatic climate control worked perfectly No unexpected problems or breakdowns Reliable transportation for our family trip Will book with them again for sure.',4,6,16,NULL,'published','2023-11-28 23:53:53','2025-11-17 21:12:53');
/*!40000 ALTER TABLE `cr_car_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_tag`
--

DROP TABLE IF EXISTS `cr_car_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_tag` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_tag`
--

LOCK TABLES `cr_car_tag` WRITE;
/*!40000 ALTER TABLE `cr_car_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_transmissions`
--

DROP TABLE IF EXISTS `cr_car_transmissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_transmissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_transmissions_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_transmissions`
--

LOCK TABLES `cr_car_transmissions` WRITE;
/*!40000 ALTER TABLE `cr_car_transmissions` DISABLE KEYS */;
INSERT INTO `cr_car_transmissions` VALUES (1,'Automatic','icons/car-transmission-auto.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Manual','icons/car-transmission-manual.png','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_transmissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_transmissions_translations`
--

DROP TABLE IF EXISTS `cr_car_transmissions_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_transmissions_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_transmissions_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_transmissions_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_transmissions_translations`
--

LOCK TABLES `cr_car_transmissions_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_transmissions_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_transmissions_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_types`
--

DROP TABLE IF EXISTS `cr_car_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_types_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_types`
--

LOCK TABLES `cr_car_types` WRITE;
/*!40000 ALTER TABLE `cr_car_types` DISABLE KEYS */;
INSERT INTO `cr_car_types` VALUES (1,'SUV','cars/car-1.jpg','ti ti-car-suv','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Hatchback','cars/car-2.jpg','ti ti-car','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Sedan','cars/car-3.jpg','ti ti-car','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Crossover','cars/car-4.jpg','ti ti-car-4wd','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Minivan','cars/car-5.jpg','ti ti-caravan','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Coupe','cars/car-6.jpg','ti ti-car','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(7,'Sport Cars','cars/car-7.jpg','ti ti-car-turbine','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(8,'Pickup Truck','cars/car-8.jpg','ti ti-truck','published',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_car_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_types_translations`
--

DROP TABLE IF EXISTS `cr_car_types_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_types_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_types_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_types_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_types_translations`
--

LOCK TABLES `cr_car_types_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_types_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_types_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_views`
--

DROP TABLE IF EXISTS `cr_car_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2025-11-18',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_car_views_car_id_date_unique` (`car_id`,`date`),
  KEY `cr_car_views_car_id_index` (`car_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_views`
--

LOCK TABLES `cr_car_views` WRITE;
/*!40000 ALTER TABLE `cr_car_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars`
--

DROP TABLE IF EXISTS `cr_cars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `images` text COLLATE utf8mb4_unicode_ci,
  `license_plate` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `make_id` bigint unsigned DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `year` int unsigned DEFAULT NULL,
  `mileage` int unsigned DEFAULT NULL,
  `horsepower` decimal(8,2) DEFAULT NULL,
  `vehicle_type_id` bigint unsigned DEFAULT NULL,
  `transmission_id` bigint unsigned DEFAULT NULL,
  `fuel_type_id` bigint unsigned DEFAULT NULL,
  `number_of_seats` int unsigned DEFAULT NULL,
  `number_of_doors` int unsigned DEFAULT NULL,
  `rental_rate` double unsigned NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rental_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'per_day',
  `rental_available_types` text COLLATE utf8mb4_unicode_ci,
  `insurance_info` text COLLATE utf8mb4_unicode_ci,
  `vin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_used` tinyint(1) NOT NULL DEFAULT '0',
  `is_for_sale` tinyint(1) NOT NULL DEFAULT '0',
  `sale_price` decimal(15,2) DEFAULT NULL,
  `condition` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ownership_history` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `warranty_information` text COLLATE utf8mb4_unicode_ci,
  `sale_status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `external_booking_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `vendor_id` bigint unsigned DEFAULT NULL,
  `moderation_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `reject_reason` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_cars_make_id_index` (`make_id`),
  KEY `cr_cars_status_index` (`status`),
  KEY `cr_cars_vehicle_type_id_index` (`vehicle_type_id`),
  KEY `cr_cars_vin_index` (`vin`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars`
--

LOCK TABLES `cr_cars` WRITE;
/*!40000 ALTER TABLE `cr_cars` DISABLE KEYS */;
INSERT INTO `cr_cars` VALUES (1,'Toyota Camry XLE Hybrid 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/81.jpg\",\"cars\\/100.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-123.00',2,'available',2010,17184,NULL,4,3,3,5,2,57,NULL,NULL,'per_day',NULL,'','LL4YY1BW7ZXFF8ZZG','',8,18,25,'50967 Roberts Point',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(2,'Honda Accord Sport 2.0T 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/62.jpg\",\"cars\\/51.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-123.11',12,'available',2014,13384,NULL,2,3,2,7,5,98,NULL,NULL,'per_day',NULL,'','41HNK0XA4FMMBEDVK','',1,4,8,'8969 Butler Creek',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(3,'Mercedes-Benz C300 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/72.jpg\",\"cars\\/18.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-123.22',1,'available',2019,19000,NULL,2,1,3,4,4,72,NULL,NULL,'per_day',NULL,'','1JWYUPXS48YLTUMCL','',3,8,15,'94231 Walker Circle',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(4,'BMW 330i xDrive M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/12.jpg\",\"cars\\/25.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-123.33',3,'available',2012,2867,NULL,4,1,2,7,2,87,NULL,NULL,'per_day',NULL,'','97SDGCYE23AHS76BA','',8,19,26,'99887 Harrison Grove',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.enterprise.com/en/reserve.html?vehicleType=bmw-330i-xdrive-m-sport-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(5,'Lexus ES 350 F Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/59.jpg\",\"cars\\/72.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-123.44',6,'available',2017,14584,NULL,1,2,3,8,2,46,NULL,NULL,'per_day',NULL,'','UMX2RTXV6GM6NH40Z','',1,3,6,'79385 Thompson Circle',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.expedia.com/carsearch?vehicle=lexus-es-350-f-sport-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(6,'Toyota RAV4 Prime XSE AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/36.jpg\",\"cars\\/50.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-123.55',11,'available',2020,8142,NULL,2,2,1,5,5,73,NULL,NULL,'per_day',NULL,'','V662STCJ4HHC52EGD','',6,15,22,'66897 King Parkway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(7,'Honda CR-V Touring Hybrid AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/76.jpg\",\"cars\\/54.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-123.66',1,'available',2019,3944,NULL,4,1,2,8,4,84,NULL,NULL,'per_day',NULL,'','NB0BKXPE0FWG3ZXKR','',1,1,2,'21663 Carter Heights',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',7,'Botble\\CarRentals\\Models\\Customer',7,'approved',NULL),(8,'BMW X5 xDrive40i M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/16.jpg\",\"cars\\/6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-123.77',2,'available',2011,3717,NULL,2,2,2,5,2,85,NULL,NULL,'per_day',NULL,'','XRVY2ZT56MNNEFAVN','',4,11,18,'10243 Gray Lane',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(9,'Mercedes-Benz GLC 300 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/58.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-123.88',6,'available',2018,15375,NULL,1,2,1,4,2,35,NULL,NULL,'per_day',NULL,'','KG6939DJ6CED2WHNE','',8,18,25,'99324 Adams Valley',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=mercedes-benz-glc-300-4matic-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(10,'Lexus RX 350 F Sport Handling AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/66.jpg\",\"cars\\/57.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\"]','29A-123.99',13,'available',2011,9554,NULL,2,2,1,8,4,66,NULL,NULL,'per_day',NULL,'','UAMP93E06RUGY16BC','',1,2,5,'97262 Wilson Court Suite 837',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(11,'Audi A4 Premium Plus quattro 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/6.jpg\",\"cars\\/21.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-456.00',8,'available',2019,17253,NULL,4,2,3,4,5,63,NULL,NULL,'per_day',NULL,'','RU2YTW6M6DZ2KM733','',2,6,11,'56827 Turner Cliffs # 770',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(12,'Mazda CX-5 2.5 Turbo Signature AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/88.jpg\",\"cars\\/16.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-456.11',14,'available',2010,13530,NULL,8,2,2,5,4,42,NULL,NULL,'per_day',NULL,'','5XA8MSA86X8EGCYW6','',1,1,2,'57482 Rivera Drive',NULL,0,1,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=mazda-cx-5-2.5-turbo-signature-awd-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(13,'Tesla Model 3 Long Range AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/39.jpg\",\"cars\\/40.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','30A-456.22',2,'available',2014,5793,NULL,7,1,3,8,5,35,NULL,NULL,'per_day',NULL,'','JJRTEBJ4539LL7Z33','',1,1,2,'42910 Madison Meadows',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(14,'Porsche Macan S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/1.jpg\",\"cars\\/2.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-456.33',10,'available',2021,12268,NULL,4,2,3,7,5,73,NULL,NULL,'per_day',NULL,'','TMV41TLS2NNKFKZC6','',8,19,26,'62983 Jones Hills',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(15,'Volvo XC60 B6 Ultimate AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/54.jpg\",\"cars\\/71.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-456.44',7,'available',2022,17025,NULL,5,3,2,4,2,47,NULL,NULL,'per_day',NULL,'','WLP0BTWS3V7UMZT87','',2,6,11,'64466 Davis Court # 982',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(16,'Genesis G70 3.3T Sport Prestige AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/77.jpg\",\"cars\\/34.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-456.55',11,'available',2024,19259,NULL,7,1,2,5,4,69,NULL,NULL,'per_day',NULL,'','B16T6Z0638S96Y4GG','',1,1,1,'16988 Brown Creek',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(17,'Subaru Outback Limited XT 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/38.jpg\",\"cars\\/30.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-456.66',11,'available',2019,1394,NULL,8,2,3,8,2,40,NULL,NULL,'per_day',NULL,'','AUBRF4KP57WSDNGTL','',3,9,16,'84959 Bell Park',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=subaru-outback-limited-xt-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(18,'Acura MDX Type S Advance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/71.jpg\",\"cars\\/9.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-456.77',5,'available',2014,1039,NULL,5,2,3,7,5,87,NULL,NULL,'per_day',NULL,'','MTT9XEZ31JDWCDBAC','',1,2,4,'54591 Fisher Pass',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(19,'Range Rover Evoque P250 S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/31.jpg\",\"cars\\/81.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\"]','30A-456.88',8,'available',2020,9031,NULL,5,3,1,8,5,56,NULL,NULL,'per_day',NULL,'','3CYX744Z4Z0738A0R','',5,12,19,'57720 Lake Plaza',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(20,'Infiniti QX60 Autograph AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/34.jpg\",\"cars\\/63.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-456.99',6,'available',2015,16192,NULL,2,3,1,4,5,93,NULL,NULL,'per_day',NULL,'','MWZWT6S21GZY4N6YX','',4,10,17,'51319 Allen Ridge Apt 277',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=infiniti-qx60-autograph-awd-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(21,'Nissan Altima SR VC-Turbo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/74.jpg\",\"cars\\/1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\"]','29A-789.00',10,'available',2015,11054,NULL,4,1,3,5,5,35,NULL,NULL,'per_day',NULL,'','SXLZLDZN00ULCHFZL','',1,1,1,'78143 Russell Plaza',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(22,'Hyundai Sonata N Line 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/57.jpg\",\"cars\\/99.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\"]','29A-789.11',10,'available',2023,1945,NULL,1,3,1,4,4,75,NULL,NULL,'per_day',NULL,'','HJU12EX49RENLN01M','',4,11,18,'10054 Ross Plaza Floor 576',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(23,'Kia Stinger GT2 AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/102.jpg\",\"cars\\/14.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\"]','29A-789.22',8,'available',2010,16608,NULL,2,1,1,5,5,70,NULL,NULL,'per_day',NULL,'','HS880B0W6GADGWRPM','',1,1,2,'64706 Morales Plaza # 26',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(24,'Volkswagen Atlas Cross Sport SEL Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/71.jpg\",\"cars\\/10.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-789.33',1,'available',2013,17266,NULL,1,2,3,4,2,47,NULL,NULL,'per_day',NULL,'','0X96GE9B29U0W29N2','',6,14,21,'29354 Morgan Point',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=volkswagen-atlas-cross-sport-sel-premium-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(25,'Chevrolet Blazer RS AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/15.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-789.44',11,'available',2019,15217,NULL,4,3,2,7,5,30,NULL,NULL,'per_day',NULL,'','VW4YVG8D1FCNKFAAS','',3,9,16,'2783 Mitchell Way # 138',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/chevrolet-blazer-rs-awd-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(26,'Ford Explorer ST 4WD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/100.jpg\",\"cars\\/16.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\"]','29A-789.55',5,'available',2018,6160,NULL,4,2,3,4,4,74,NULL,NULL,'per_day',NULL,'','UT8D56FH5T7A47DHH','',6,14,21,'27958 Long Plaza',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(27,'Jeep Grand Cherokee Summit Reserve 4xe 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/104.jpg\",\"cars\\/34.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','29A-789.66',12,'available',2023,11005,NULL,5,2,2,4,5,40,NULL,NULL,'per_day',NULL,'','9HYZRBDG506U3RC5F','',1,1,3,'10230 Turner Walk Floor 837',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(28,'Cadillac XT5 Premium Luxury AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/96.jpg\",\"cars\\/24.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\"]','29A-789.77',1,'available',2015,8848,NULL,7,2,1,4,2,87,NULL,NULL,'per_day',NULL,'','E467PB4L4S6PKU8VE','',6,14,21,'57665 Madison Ridge',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=cadillac-xt5-premium-luxury-awd-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(29,'Lincoln Aviator Reserve AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/81.jpg\",\"cars\\/63.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-789.88',6,'available',2012,11792,NULL,1,1,1,8,2,75,NULL,NULL,'per_day',NULL,'','MPP31T6X05AU6SZNB','',1,2,5,'15636 Edwards Creek',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(30,'Alfa Romeo Stelvio Veloce AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/21.jpg\",\"cars\\/103.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','29A-789.99',12,'available',2022,3674,NULL,8,1,1,4,2,81,NULL,NULL,'per_day',NULL,'','H7CPW72309W30LAAP','',2,7,13,'19400 Peterson Gardens',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(31,'McLaren 720S Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/53.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\"]','30B-100.00',14,'available',2020,7942,NULL,7,3,2,7,2,99,NULL,NULL,'per_day',NULL,'','F6JR8UY96YKLDFAUS','',7,17,24,'76572 Long Avenue',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(32,'Mercedes-Benz G550 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/90.jpg\",\"cars\\/85.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\"]','30B-100.11',9,'available',2015,10560,NULL,6,2,1,5,2,66,NULL,NULL,'per_day',NULL,'','RJW2TGY44P12AW2WZ','',4,11,18,'98301 Watson Hills',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(33,'Ford Mustang GT Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/56.jpg\",\"cars\\/38.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\"]','30B-100.22',10,'available',2022,19261,NULL,3,3,3,7,5,69,NULL,NULL,'per_day',NULL,'','5DGXTFRJ652P4XREJ','',1,2,4,'69058 Moore Terrace',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(34,'Porsche 911 Carrera S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/48.jpg\",\"cars\\/31.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\"]','30B-100.33',5,'available',2014,7145,NULL,6,2,2,5,2,30,NULL,NULL,'per_day',NULL,'','VMWZ3KLW2E278TYCU','',2,6,11,'91140 Howard Trail',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(35,'Audi R8 V10 Performance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/75.jpg\",\"cars\\/49.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\"]','30B-100.44',12,'available',2015,13499,NULL,1,3,2,8,4,32,NULL,NULL,'per_day',NULL,'','PDAMV7FL4J0KGVL49','',8,19,26,'32592 Birch Boulevard',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(36,'Lamborghini Huracán EVO 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/84.jpg\",\"cars\\/16.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\"]','30B-100.55',3,'available',2024,5746,NULL,5,3,1,5,2,48,NULL,NULL,'per_day',NULL,'','FFZG646800K5RYFKL','',7,16,23,'38103 Smith Court',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(37,'BMW M4 Competition xDrive 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/29.jpg\",\"cars\\/38.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\"]','30B-100.66',10,'available',2013,19387,NULL,8,1,2,4,4,75,NULL,NULL,'per_day',NULL,'','1ANMFSFD32TX5L54B','',5,12,19,'83570 Green Park',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(38,'Maserati Ghibli Modena 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/8.jpg\",\"cars\\/72.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-3.jpg\"]','30B-100.77',12,'available',2015,4084,NULL,1,3,1,5,5,77,NULL,NULL,'per_day',NULL,'','2VSY0HKB2C9KEPKH0','',3,9,16,'57924 Thompson Walk',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(39,'Bentley Continental GT V8 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/85.jpg\",\"cars\\/60.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\"]','30B-100.88',4,'available',2017,17366,NULL,8,3,3,7,2,63,NULL,NULL,'per_day',NULL,'','89JSLF8G69LDR0RKK','',2,6,12,'90999 Powell Ridge',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(40,'Rolls-Royce Ghost Black Badge 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/76.jpg\",\"cars\\/72.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\"]','30B-100.99',13,'available',2024,5920,NULL,5,2,1,5,4,58,NULL,NULL,'per_day',NULL,'','9BHWG7MC7LRBWEAGP','',1,4,8,'33633 Murphy View Suite 450',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(41,'Hyundai Tucson Limited AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/55.jpg\",\"cars\\/18.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','29B-200.00',9,'available',2010,13437,NULL,4,1,1,7,4,93,NULL,NULL,'per_day',NULL,'','1EXADRXJ6FUH09W5G','',2,7,13,'4435 Sullivan Creek',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(42,'Kia Sportage SX-Turbo AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/55.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\"]','29B-200.11',5,'available',2020,17729,NULL,8,2,1,7,2,76,NULL,NULL,'per_day',NULL,'','KSG4N0BG3JEYJHCAC','',3,8,15,'47592 Brown Grove Floor 177',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.enterprise.com/en/reserve.html?vehicleType=kia-sportage-sx-turbo-awd-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(43,'Volkswagen Tiguan SEL R-Line 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/69.jpg\",\"cars\\/101.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\"]','29B-200.22',7,'available',2011,12868,NULL,7,2,3,8,4,67,NULL,NULL,'per_day',NULL,'','XZRV76P49T81032MG','',2,7,13,'22883 Carter Park',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=volkswagen-tiguan-sel-r-line-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(44,'Toyota Highlander Platinum AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/37.jpg\",\"cars\\/57.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\"]','29B-200.33',10,'available',2023,17260,NULL,3,3,3,4,5,70,NULL,NULL,'per_day',NULL,'','UV26B5331JHZKDYK1','',4,10,17,'28530 Clark Ridge Apt 919',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(45,'Honda Pilot TrailSport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/25.jpg\",\"cars\\/99.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','29B-200.44',10,'available',2021,8691,NULL,7,3,3,4,2,85,NULL,NULL,'per_day',NULL,'','7VLKJ4C437L5Y292L','',1,5,10,'96367 Reyes Avenue',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.expedia.com/carsearch?vehicle=honda-pilot-trailsport-awd-2024','2025-11-17 21:12:52','2025-11-17 21:12:52',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(46,'Mazda MX-5 Miata Grand Touring 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/7.jpg\",\"cars\\/71.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\"]','29B-200.55',10,'available',2010,6230,NULL,3,3,2,8,5,64,NULL,NULL,'per_day',NULL,'','NEJDBM7X9MB7L58LB','',3,9,16,'52410 Wilson Hills',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(47,'Nissan Rogue Platinum AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/9.jpg\",\"cars\\/77.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\"]','29B-200.66',14,'available',2014,11373,NULL,6,2,1,8,2,40,NULL,NULL,'per_day',NULL,'','NGXVGS5P5VE259J66','',2,7,13,'35042 Wilson Park Unit 325',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(48,'Mini Cooper S Hardtop 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/28.jpg\",\"cars\\/52.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\"]','29B-200.77',6,'available',2011,6439,NULL,7,2,3,5,5,31,NULL,NULL,'per_day',NULL,'','7GZ49FYL43ANY2D3U','',1,1,3,'40577 Richardson Point',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(49,'Dodge Challenger R/T Scat Pack 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/84.jpg\",\"cars\\/27.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\"]','29B-200.88',2,'available',2023,7346,NULL,8,2,1,4,2,30,NULL,NULL,'per_day',NULL,'','X37EAJ9V0AMV1H1K9','',5,12,19,'48791 Adams Trail',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(50,'Chevrolet Camaro SS 1LE 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/83.jpg\",\"cars\\/17.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','29B-200.99',9,'available',2014,4396,NULL,1,2,3,7,4,32,NULL,NULL,'per_day',NULL,'','VJUF0E167SGA66FR3','',1,4,8,'59684 Campbell Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(51,'Ferrari F8 Tributo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/17.jpg\",\"cars\\/36.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\"]','30C-300.00',4,'available',2020,14185,NULL,1,3,2,8,4,81,NULL,NULL,'per_day',NULL,'','RX27EY2E7NH21B37Y','',3,8,15,'64305 Jenkins Way',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(52,'Jaguar F-PACE SVR 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/62.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.11',13,'available',2015,4896,NULL,8,3,2,7,2,71,NULL,NULL,'per_day',NULL,'','SKR0YRT71MNZRJGVC','',5,12,19,'45923 Peterson Boulevard Suite 252',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:52','2025-11-17 21:12:52',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(53,'Land Rover Defender 110 X 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/95.jpg\",\"cars\\/86.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\"]','30C-300.22',6,'available',2015,1949,NULL,1,3,2,8,2,42,NULL,NULL,'per_day',NULL,'','83AAMD3W4BVYZAXU0','',1,2,4,'41990 Ash Road Suite 908',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',7,'Botble\\CarRentals\\Models\\Customer',7,'approved',NULL),(54,'Chrysler Pacifica Pinnacle AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/29.jpg\",\"cars\\/63.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\"]','30C-300.33',4,'available',2015,15035,NULL,4,2,2,4,4,42,NULL,NULL,'per_day',NULL,'','L7JLM2LA5XM2W6B11','',5,13,20,'49932 Myers Gardens Unit 876',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(55,'GMC Sierra 1500 Denali 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/96.jpg\",\"cars\\/8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','30C-300.44',14,'available',2023,7406,NULL,7,3,2,8,5,51,NULL,NULL,'per_day',NULL,'','ZK5ARW1P8FUE8CCYV','',5,13,20,'92769 Edwards Road Apt 732',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=gmc-sierra-1500-denali-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(56,'Mitsubishi Outlander SEL S-AWC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/53.jpg\",\"cars\\/12.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\"]','30C-300.55',11,'available',2012,8604,NULL,8,1,2,4,4,82,NULL,NULL,'per_day',NULL,'','PLAZM13E3EJZGFM3G','',1,3,7,'42490 Wilson Cliffs # 908',NULL,0,1,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/mitsubishi-outlander-sel-s-awc-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(57,'Peugeot 308 GT Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/73.jpg\",\"cars\\/30.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.66',3,'available',2019,14758,NULL,5,2,2,7,4,97,NULL,NULL,'per_day',NULL,'','TCRLBB1230TXC39M7','',4,11,18,'34308 Jackson Heights',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(58,'Fiat 500X Sport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/1.jpg\",\"cars\\/101.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\"]','30C-300.77',1,'available',2013,13321,NULL,5,1,3,8,4,48,NULL,NULL,'per_day',NULL,'','KCNAUX4S02R2G6UVK','',8,18,25,'10944 Main Walk',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/fiat-500x-sport-awd-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(59,'Smart EQ fortwo Prime 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/105.jpg\",\"cars\\/15.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','30C-300.88',14,'available',2014,19289,NULL,7,2,1,5,5,60,NULL,NULL,'per_day',NULL,'','NCNFNC7Y0YXFSMNZD','',5,12,19,'14797 Martin Highway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(60,'Toyota Corolla Hybrid LE 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/41.jpg\",\"cars\\/81.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','30C-300.99',1,'available',2012,3005,NULL,4,3,1,8,5,66,NULL,NULL,'per_day',NULL,'','A7EZJDGG7DBCZ1YFW','',1,1,3,'35908 Park Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(61,'Aston Martin Vantage F1 Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\"]','30D-400.00',13,'available',2021,3780,NULL,2,2,3,4,4,55,NULL,NULL,'per_day',NULL,'','BFKPLKHJ5BU1BZ306','',1,1,2,'4976 Adams Parkway Suite 71',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.sixt.com/rental-car/usa/vehicle/aston-martin-vantage-f1-edition-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(62,'Bugatti Chiron Super Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/73.jpg\",\"cars\\/36.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-8.jpg\"]','30D-400.11',4,'available',2010,19998,NULL,4,3,3,8,2,44,NULL,NULL,'per_day',NULL,'','FZANFGKW42TJ95R7B','',2,6,11,'60633 Morales Hills',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(63,'McLaren Artura Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/33.jpg\",\"cars\\/12.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\"]','30D-400.22',9,'available',2012,3365,NULL,8,3,1,5,4,90,NULL,NULL,'per_day',NULL,'','62WGKRU36EU4XP4SK','',1,1,3,'57291 Perry Valley',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(64,'Pagani Huayra Roadster BC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/15.jpg\",\"cars\\/80.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30D-400.33',5,'available',2012,4107,NULL,7,1,1,5,4,91,NULL,NULL,'per_day',NULL,'','U7YKCTKY1KGBMLBT1','',1,4,8,'92931 Brooks Boulevard Suite 685',NULL,0,1,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/pagani-huayra-roadster-bc-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(65,'Koenigsegg Jesko Absolut 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/70.jpg\",\"cars\\/23.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\"]','30D-400.44',14,'available',2021,9396,NULL,2,1,2,4,4,49,NULL,NULL,'per_day',NULL,'','47VR50YR32S97LPAV','',1,2,5,'91242 Morales Court Apt 843',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=koenigsegg-jesko-absolut-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(66,'Mercedes-Benz E450 4MATIC All-Terrain 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/46.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.00',14,'available',2019,13733,NULL,8,1,3,5,2,46,NULL,NULL,'per_day',NULL,'','J15FD1566PSCFY1C2','',1,5,10,'18206 King Street Apt 550',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(67,'Audi Q7 55 TFSI quattro Premium Plus 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/86.jpg\",\"cars\\/39.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\"]','30E-500.11',9,'available',2013,8802,NULL,6,1,1,7,5,85,NULL,NULL,'per_day',NULL,'','4AZYJEVU7BU46KP62','',3,8,14,'96420 Long Grove',NULL,1,1,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=audi-q7-55-tfsi-quattro-premium-plus-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(68,'BMW X7 xDrive40i M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/39.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\"]','30E-500.22',13,'available',2021,8493,NULL,8,3,1,5,4,94,NULL,NULL,'per_day',NULL,'','1J070GKT9FZ4JLDW9','',3,9,16,'36986 Howard Drive',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.europcar.com/en-us/car-rental/vehicles/bmw-x7-xdrive40i-m-sport-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(69,'Lexus LX 600 Ultra Luxury 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/1.jpg\",\"cars\\/81.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\"]','30E-500.33',6,'available',2019,8505,NULL,5,3,1,5,4,90,NULL,NULL,'per_day',NULL,'','FVHW7XG915DW66EJK','',1,1,1,'27812 Myers Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(70,'Volvo S90 B6 Ultimate AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/4.jpg\",\"cars\\/26.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\"]','30E-500.44',3,'available',2017,13559,NULL,5,2,2,7,2,68,NULL,NULL,'per_day',NULL,'','FMJUPSK46DM6LHZTE','',4,10,17,'24682 Gray Grove',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(71,'Genesis GV70 2.5T Sport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/56.jpg\",\"cars\\/93.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\"]','30E-500.55',10,'available',2017,5480,NULL,8,1,2,4,2,45,NULL,NULL,'per_day',NULL,'','NESBDE5R8Y842TLPC','',1,4,8,'40786 Maple Plaza',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(72,'Acura TLX Type S PMC Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/17.jpg\",\"cars\\/67.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','30E-500.66',9,'available',2011,10319,NULL,6,3,2,8,4,89,NULL,NULL,'per_day',NULL,'','T14JB76G9E0C0XJN5','',5,13,20,'72568 Parker Heights',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=acura-tlx-type-s-pmc-edition-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(73,'Infiniti Q50 Red Sport 400 AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/95.jpg\",\"cars\\/83.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30E-500.77',7,'available',2011,10758,NULL,3,1,3,7,4,61,NULL,NULL,'per_day',NULL,'','8VJ8RDAJ1YS2810LL','',2,6,12,'59061 Spruce Avenue',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(74,'Jaguar XF P300 R-Dynamic S AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/98.jpg\",\"cars\\/68.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\"]','30E-500.88',13,'available',2022,11734,NULL,2,3,2,7,4,58,NULL,NULL,'per_day',NULL,'','RM86V38K3FTMNJZ9Z','',8,18,25,'52642 Cox Pass',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(75,'Alfa Romeo Giulia Quadrifoglio 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/70.jpg\",\"cars\\/8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30E-500.99',5,'available',2019,8614,NULL,2,3,3,8,4,66,NULL,NULL,'per_day',NULL,'','4JEJAPY679FHSA7A2','',8,19,26,'30407 Walker Plaza Apt 87',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(76,'Porsche Cayenne Turbo GT 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/59.jpg\",\"cars\\/19.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\"]','29E-600.00',9,'available',2012,7968,NULL,8,1,3,8,4,45,NULL,NULL,'per_day',NULL,'','6J4ZS3W992HEB539N','',3,8,14,'68617 Gray Plaza',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',7,'Botble\\CarRentals\\Models\\Customer',7,'approved',NULL),(77,'Range Rover Sport HSE Dynamic 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/89.jpg\",\"cars\\/39.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\"]','29E-600.11',4,'available',2012,18059,NULL,1,2,1,5,2,75,NULL,NULL,'per_day',NULL,'','36X3N0XD82DLJKNM3','',1,4,8,'32880 Perry Terrace # 516',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=range-rover-sport-hse-dynamic-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(78,'Mercedes-AMG GLE 63 S 4MATIC+ 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/83.jpg\",\"cars\\/25.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','29E-600.22',1,'available',2024,16531,NULL,6,2,3,5,5,81,NULL,NULL,'per_day',NULL,'','A7LFK3U1700TJWN5D','',6,15,22,'17197 Green Trail Unit 809',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(79,'BMW M5 Competition xDrive 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/81.jpg\",\"cars\\/88.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\"]','29E-600.33',3,'available',2024,11288,NULL,6,2,3,4,5,89,NULL,NULL,'per_day',NULL,'','ZXFYYMGY1SCABMGMK','',1,2,4,'33977 Smith Highway Apt 360',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(80,'Audi RS Q8 quattro 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/95.jpg\",\"cars\\/44.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','29E-600.44',5,'available',2023,5408,NULL,5,1,3,8,2,43,NULL,NULL,'per_day',NULL,'','HTDF2XDU2860SADGE','',5,12,19,'53485 Miller Landing # 430',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(81,'Tesla Model S Plaid 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/90.jpg\",\"cars\\/64.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\"]','29E-600.55',4,'available',2020,11880,NULL,7,2,1,4,2,45,NULL,NULL,'per_day',NULL,'','CXHV21ET6DK6FXAJ8','',1,2,5,'24784 Roberts Plaza',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(82,'Lucid Air Grand Touring Performance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/79.jpg\",\"cars\\/84.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\"]','29E-600.66',2,'available',2022,10058,NULL,7,3,1,7,5,48,NULL,NULL,'per_day',NULL,'','RWLJVXTV46A51627R','',1,2,5,'92741 Ross Road',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/lucid-air-grand-touring-performance-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(83,'Rivian R1S Adventure 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/5.jpg\",\"cars\\/39.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\"]','29E-600.77',2,'available',2019,10799,NULL,2,2,3,5,4,80,NULL,NULL,'per_day',NULL,'','2KRM6SF88DUKWSFDH','',4,10,17,'20419 Turner Highway',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',7,'Botble\\CarRentals\\Models\\Customer',7,'approved',NULL),(84,'Polestar 2 Long Range Dual Motor 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/25.jpg\",\"cars\\/3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\"]','29E-600.88',1,'available',2017,12374,NULL,3,2,1,8,2,65,NULL,NULL,'per_day',NULL,'','MMGVSUX438VVN6J4E','',3,8,14,'43248 King Avenue',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(85,'Genesis Electrified GV70 Advanced AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/48.jpg\",\"cars\\/65.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\"]','29E-600.99',4,'available',2013,6536,NULL,7,3,1,5,2,31,NULL,NULL,'per_day',NULL,'','YW80H4RV68N1LJNT8','',6,15,22,'34949 Hall Heights # 514',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(86,'Mercedes-Maybach S 580 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/46.jpg\",\"cars\\/96.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.00',4,'available',2018,18186,NULL,5,3,1,4,4,31,NULL,NULL,'per_day',NULL,'','E18WAVWB9LFTM0HMM','',1,1,2,'31277 Perry Landing # 189',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=mercedes-maybach-s-580-4matic-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(87,'Bentley Bentayga S V8 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/24.jpg\",\"cars\\/1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\"]','30F-700.11',10,'available',2014,14211,NULL,8,1,3,5,5,65,NULL,NULL,'per_day',NULL,'','X3XE2AML1M8SJPC90','',7,17,24,'95792 Wood Walk Suite 925',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(88,'Rolls-Royce Cullinan Black Badge 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/48.jpg\",\"cars\\/44.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\"]','30F-700.22',5,'available',2016,3032,NULL,7,3,1,5,4,80,NULL,NULL,'per_day',NULL,'','W2SZR7220J2VESEL0','',3,8,15,'2475 Cruz Landing # 937',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/rolls-royce-cullinan-black-badge-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(89,'Aston Martin DBX707 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/22.jpg\",\"cars\\/69.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.33',4,'available',2016,16632,NULL,8,1,2,7,5,81,NULL,NULL,'per_day',NULL,'','52YTFD3M9SAXP25XC','',3,8,15,'22747 Barnes Place',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(90,'Maserati Levante Trofeo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/36.jpg\",\"cars\\/30.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\"]','30F-700.44',10,'available',2019,9404,NULL,2,2,1,5,4,39,NULL,NULL,'per_day',NULL,'','BSGRXFD78AELEMW17','',3,8,14,'88142 Evans Road',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(91,'Ferrari Roma Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/77.jpg\",\"cars\\/99.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.55',8,'available',2023,18881,NULL,5,2,3,4,4,30,NULL,NULL,'per_day',NULL,'','NC69SS4Z2WYBKMKAH','',2,7,13,'92799 Reyes Landing',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(92,'McLaren GT Luxe 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/16.jpg\",\"cars\\/11.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\"]','30F-700.66',10,'available',2011,3022,NULL,6,1,3,8,2,61,NULL,NULL,'per_day',NULL,'','MZZ0G16X4Y12ME9PJ','',1,4,8,'60580 James Court',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(93,'Lamborghini Urus Performante 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/30.jpg\",\"cars\\/66.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\"]','30F-700.77',4,'available',2021,2866,NULL,7,3,2,5,5,73,NULL,NULL,'per_day',NULL,'','1X99VE1088JZWHTZS','',7,16,23,'11188 Peterson Cliffs Apt 87',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(94,'Porsche Taycan Turbo S Cross Turismo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/20.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\"]','30F-700.88',4,'available',2014,10240,NULL,1,1,3,4,2,34,NULL,NULL,'per_day',NULL,'','AFUBCM118GFCU71VX','',7,17,24,'57816 Clark Highway Unit 220',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(95,'BMW XM Label Red 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/96.jpg\",\"cars\\/20.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\"]','30F-700.99',5,'available',2024,3853,NULL,1,2,1,5,2,63,NULL,NULL,'per_day',NULL,'','0ANYW2SP60Z7W2CRR','',5,13,20,'69691 Price Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/bmw-xm-label-red-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(96,'Chevrolet Corvette Z06 3LZ 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/36.jpg\",\"cars\\/72.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\"]','29F-800.00',13,'available',2021,6312,NULL,1,2,1,4,5,80,NULL,NULL,'per_day',NULL,'','DGGWDVJ39BN06704F','',3,8,14,'34200 Thompson Hills',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(97,'Ford GT Heritage Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/92.jpg\",\"cars\\/23.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\"]','29F-800.11',10,'available',2021,13992,NULL,5,1,2,8,2,34,NULL,NULL,'per_day',NULL,'','Y24UHL8Y9W4A7DK8D','',1,1,2,'75647 Bennett Pass',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(98,'Dodge Viper ACR Extreme 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/98.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','29F-800.22',14,'available',2017,2434,NULL,5,3,3,4,2,91,NULL,NULL,'per_day',NULL,'','HMNWBH4Y9TJ33V5A2','',1,1,3,'91962 Carter Highway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(99,'Nissan GT-R NISMO Special Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/35.jpg\",\"cars\\/86.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','29F-800.33',2,'available',2011,2716,NULL,4,3,3,7,5,42,NULL,NULL,'per_day',NULL,'','0H2H7VEX9SG9B2HC7','',1,1,1,'99338 Thompson Ridge',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:12:53','2025-11-17 21:12:53',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(100,'Toyota Supra 3.0 Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/65.jpg\",\"cars\\/82.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\"]','29F-800.44',8,'available',2020,17181,NULL,3,1,2,8,2,63,NULL,NULL,'per_day',NULL,'','PVWHXUPB459CWZ0PZ','',5,12,19,'74050 Park View',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/toyota-supra-3.0-premium-2024','2025-11-17 21:12:53','2025-11-17 21:12:53',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL);
/*!40000 ALTER TABLE `cr_cars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_amenities`
--

DROP TABLE IF EXISTS `cr_cars_amenities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_amenities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_id` bigint unsigned NOT NULL,
  `cr_car_amenity_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1619 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_amenities`
--

LOCK TABLES `cr_cars_amenities` WRITE;
/*!40000 ALTER TABLE `cr_cars_amenities` DISABLE KEYS */;
INSERT INTO `cr_cars_amenities` VALUES (1,1,13,NULL,NULL),(2,1,23,NULL,NULL),(3,1,47,NULL,NULL),(4,1,4,NULL,NULL),(5,1,6,NULL,NULL),(6,1,19,NULL,NULL),(7,1,15,NULL,NULL),(8,1,18,NULL,NULL),(9,1,35,NULL,NULL),(10,2,13,NULL,NULL),(11,2,23,NULL,NULL),(12,2,45,NULL,NULL),(13,2,46,NULL,NULL),(14,2,47,NULL,NULL),(15,2,3,NULL,NULL),(16,2,5,NULL,NULL),(17,2,20,NULL,NULL),(18,2,25,NULL,NULL),(19,2,33,NULL,NULL),(20,2,7,NULL,NULL),(21,2,10,NULL,NULL),(22,2,12,NULL,NULL),(23,2,15,NULL,NULL),(24,2,16,NULL,NULL),(25,2,28,NULL,NULL),(26,2,31,NULL,NULL),(27,2,34,NULL,NULL),(28,2,37,NULL,NULL),(29,2,39,NULL,NULL),(30,2,41,NULL,NULL),(31,2,42,NULL,NULL),(32,3,13,NULL,NULL),(33,3,22,NULL,NULL),(34,3,23,NULL,NULL),(35,3,46,NULL,NULL),(36,3,47,NULL,NULL),(37,3,1,NULL,NULL),(38,3,2,NULL,NULL),(39,3,8,NULL,NULL),(40,3,7,NULL,NULL),(41,3,15,NULL,NULL),(42,3,16,NULL,NULL),(43,3,28,NULL,NULL),(44,3,31,NULL,NULL),(45,3,34,NULL,NULL),(46,3,35,NULL,NULL),(47,3,5,NULL,NULL),(48,3,9,NULL,NULL),(49,3,33,NULL,NULL),(50,4,22,NULL,NULL),(51,4,45,NULL,NULL),(52,4,46,NULL,NULL),(53,4,3,NULL,NULL),(54,4,20,NULL,NULL),(55,4,27,NULL,NULL),(56,4,33,NULL,NULL),(57,4,10,NULL,NULL),(58,4,11,NULL,NULL),(59,4,16,NULL,NULL),(60,4,17,NULL,NULL),(61,4,18,NULL,NULL),(62,4,28,NULL,NULL),(63,4,29,NULL,NULL),(64,4,30,NULL,NULL),(65,4,31,NULL,NULL),(66,4,32,NULL,NULL),(67,4,38,NULL,NULL),(68,4,40,NULL,NULL),(69,4,41,NULL,NULL),(70,4,43,NULL,NULL),(71,4,37,NULL,NULL),(72,4,42,NULL,NULL),(73,5,13,NULL,NULL),(74,5,14,NULL,NULL),(75,5,23,NULL,NULL),(76,5,45,NULL,NULL),(77,5,1,NULL,NULL),(78,5,2,NULL,NULL),(79,5,4,NULL,NULL),(80,5,8,NULL,NULL),(81,5,10,NULL,NULL),(82,5,12,NULL,NULL),(83,5,17,NULL,NULL),(84,5,18,NULL,NULL),(85,5,28,NULL,NULL),(86,5,34,NULL,NULL),(87,5,38,NULL,NULL),(88,5,41,NULL,NULL),(89,6,14,NULL,NULL),(90,6,22,NULL,NULL),(91,6,23,NULL,NULL),(92,6,45,NULL,NULL),(93,6,47,NULL,NULL),(94,6,1,NULL,NULL),(95,6,2,NULL,NULL),(96,6,8,NULL,NULL),(97,6,19,NULL,NULL),(98,6,7,NULL,NULL),(99,6,11,NULL,NULL),(100,6,15,NULL,NULL),(101,6,16,NULL,NULL),(102,6,18,NULL,NULL),(103,6,31,NULL,NULL),(104,6,35,NULL,NULL),(105,6,3,NULL,NULL),(106,6,9,NULL,NULL),(107,7,13,NULL,NULL),(108,7,45,NULL,NULL),(109,7,46,NULL,NULL),(110,7,3,NULL,NULL),(111,7,9,NULL,NULL),(112,7,21,NULL,NULL),(113,7,33,NULL,NULL),(114,7,7,NULL,NULL),(115,7,10,NULL,NULL),(116,7,11,NULL,NULL),(117,7,15,NULL,NULL),(118,7,18,NULL,NULL),(119,7,29,NULL,NULL),(120,7,31,NULL,NULL),(121,7,32,NULL,NULL),(122,7,37,NULL,NULL),(123,7,39,NULL,NULL),(124,7,41,NULL,NULL),(125,7,43,NULL,NULL),(126,8,13,NULL,NULL),(127,8,14,NULL,NULL),(128,8,22,NULL,NULL),(129,8,45,NULL,NULL),(130,8,47,NULL,NULL),(131,8,3,NULL,NULL),(132,8,5,NULL,NULL),(133,8,20,NULL,NULL),(134,8,21,NULL,NULL),(135,8,25,NULL,NULL),(136,8,27,NULL,NULL),(137,8,7,NULL,NULL),(138,8,10,NULL,NULL),(139,8,12,NULL,NULL),(140,8,15,NULL,NULL),(141,8,16,NULL,NULL),(142,8,18,NULL,NULL),(143,8,31,NULL,NULL),(144,8,34,NULL,NULL),(145,8,35,NULL,NULL),(146,8,38,NULL,NULL),(147,8,41,NULL,NULL),(148,8,42,NULL,NULL),(149,8,43,NULL,NULL),(150,8,37,NULL,NULL),(151,9,13,NULL,NULL),(152,9,14,NULL,NULL),(153,9,47,NULL,NULL),(154,9,6,NULL,NULL),(155,9,8,NULL,NULL),(156,9,15,NULL,NULL),(157,9,18,NULL,NULL),(158,10,13,NULL,NULL),(159,10,14,NULL,NULL),(160,10,46,NULL,NULL),(161,10,1,NULL,NULL),(162,10,4,NULL,NULL),(163,10,6,NULL,NULL),(164,10,8,NULL,NULL),(165,10,19,NULL,NULL),(166,10,10,NULL,NULL),(167,10,16,NULL,NULL),(168,10,18,NULL,NULL),(169,10,30,NULL,NULL),(170,10,32,NULL,NULL),(171,10,5,NULL,NULL),(172,10,27,NULL,NULL),(173,10,33,NULL,NULL),(174,10,37,NULL,NULL),(175,10,39,NULL,NULL),(176,10,41,NULL,NULL),(177,10,43,NULL,NULL),(178,11,13,NULL,NULL),(179,11,23,NULL,NULL),(180,11,46,NULL,NULL),(181,11,47,NULL,NULL),(182,11,1,NULL,NULL),(183,11,2,NULL,NULL),(184,11,4,NULL,NULL),(185,11,6,NULL,NULL),(186,11,19,NULL,NULL),(187,11,11,NULL,NULL),(188,11,16,NULL,NULL),(189,11,18,NULL,NULL),(190,11,29,NULL,NULL),(191,11,30,NULL,NULL),(192,11,31,NULL,NULL),(193,11,3,NULL,NULL),(194,11,20,NULL,NULL),(195,11,21,NULL,NULL),(196,11,38,NULL,NULL),(197,11,41,NULL,NULL),(198,12,13,NULL,NULL),(199,12,22,NULL,NULL),(200,12,23,NULL,NULL),(201,12,45,NULL,NULL),(202,12,47,NULL,NULL),(203,12,2,NULL,NULL),(204,12,6,NULL,NULL),(205,12,8,NULL,NULL),(206,12,10,NULL,NULL),(207,12,11,NULL,NULL),(208,12,12,NULL,NULL),(209,12,17,NULL,NULL),(210,12,35,NULL,NULL),(211,13,13,NULL,NULL),(212,13,14,NULL,NULL),(213,13,23,NULL,NULL),(214,13,45,NULL,NULL),(215,13,46,NULL,NULL),(216,13,19,NULL,NULL),(217,13,12,NULL,NULL),(218,13,16,NULL,NULL),(219,14,13,NULL,NULL),(220,14,14,NULL,NULL),(221,14,46,NULL,NULL),(222,14,4,NULL,NULL),(223,14,6,NULL,NULL),(224,14,8,NULL,NULL),(225,14,10,NULL,NULL),(226,14,11,NULL,NULL),(227,14,12,NULL,NULL),(228,14,16,NULL,NULL),(229,14,18,NULL,NULL),(230,14,29,NULL,NULL),(231,14,35,NULL,NULL),(232,14,33,NULL,NULL),(233,14,37,NULL,NULL),(234,14,38,NULL,NULL),(235,14,39,NULL,NULL),(236,14,42,NULL,NULL),(237,15,13,NULL,NULL),(238,15,23,NULL,NULL),(239,15,45,NULL,NULL),(240,15,6,NULL,NULL),(241,15,8,NULL,NULL),(242,15,7,NULL,NULL),(243,15,15,NULL,NULL),(244,15,16,NULL,NULL),(245,15,28,NULL,NULL),(246,15,29,NULL,NULL),(247,16,13,NULL,NULL),(248,16,14,NULL,NULL),(249,16,22,NULL,NULL),(250,16,45,NULL,NULL),(251,16,46,NULL,NULL),(252,16,1,NULL,NULL),(253,16,2,NULL,NULL),(254,16,4,NULL,NULL),(255,16,10,NULL,NULL),(256,16,11,NULL,NULL),(257,16,12,NULL,NULL),(258,16,17,NULL,NULL),(259,16,32,NULL,NULL),(260,16,34,NULL,NULL),(261,16,9,NULL,NULL),(262,16,37,NULL,NULL),(263,16,38,NULL,NULL),(264,16,42,NULL,NULL),(265,16,43,NULL,NULL),(266,17,14,NULL,NULL),(267,17,23,NULL,NULL),(268,17,45,NULL,NULL),(269,17,46,NULL,NULL),(270,17,1,NULL,NULL),(271,17,2,NULL,NULL),(272,17,6,NULL,NULL),(273,17,8,NULL,NULL),(274,17,10,NULL,NULL),(275,17,11,NULL,NULL),(276,17,15,NULL,NULL),(277,17,16,NULL,NULL),(278,17,28,NULL,NULL),(279,17,30,NULL,NULL),(280,18,13,NULL,NULL),(281,18,22,NULL,NULL),(282,18,23,NULL,NULL),(283,18,45,NULL,NULL),(284,18,46,NULL,NULL),(285,18,3,NULL,NULL),(286,18,5,NULL,NULL),(287,18,9,NULL,NULL),(288,18,20,NULL,NULL),(289,18,25,NULL,NULL),(290,18,33,NULL,NULL),(291,18,7,NULL,NULL),(292,18,10,NULL,NULL),(293,18,11,NULL,NULL),(294,18,15,NULL,NULL),(295,18,16,NULL,NULL),(296,18,17,NULL,NULL),(297,18,28,NULL,NULL),(298,18,30,NULL,NULL),(299,18,31,NULL,NULL),(300,18,34,NULL,NULL),(301,18,35,NULL,NULL),(302,18,37,NULL,NULL),(303,18,39,NULL,NULL),(304,18,40,NULL,NULL),(305,18,43,NULL,NULL),(306,19,14,NULL,NULL),(307,19,22,NULL,NULL),(308,19,23,NULL,NULL),(309,19,45,NULL,NULL),(310,19,6,NULL,NULL),(311,19,8,NULL,NULL),(312,19,7,NULL,NULL),(313,19,11,NULL,NULL),(314,19,16,NULL,NULL),(315,19,28,NULL,NULL),(316,19,35,NULL,NULL),(317,20,14,NULL,NULL),(318,20,22,NULL,NULL),(319,20,23,NULL,NULL),(320,20,47,NULL,NULL),(321,20,3,NULL,NULL),(322,20,9,NULL,NULL),(323,20,20,NULL,NULL),(324,20,25,NULL,NULL),(325,20,27,NULL,NULL),(326,20,33,NULL,NULL),(327,20,7,NULL,NULL),(328,20,11,NULL,NULL),(329,20,15,NULL,NULL),(330,20,17,NULL,NULL),(331,20,18,NULL,NULL),(332,20,30,NULL,NULL),(333,20,34,NULL,NULL),(334,20,35,NULL,NULL),(335,20,39,NULL,NULL),(336,20,40,NULL,NULL),(337,20,42,NULL,NULL),(338,21,14,NULL,NULL),(339,21,22,NULL,NULL),(340,21,47,NULL,NULL),(341,21,4,NULL,NULL),(342,21,17,NULL,NULL),(343,21,18,NULL,NULL),(344,22,13,NULL,NULL),(345,22,14,NULL,NULL),(346,22,23,NULL,NULL),(347,22,45,NULL,NULL),(348,22,46,NULL,NULL),(349,22,1,NULL,NULL),(350,22,2,NULL,NULL),(351,22,6,NULL,NULL),(352,22,10,NULL,NULL),(353,22,12,NULL,NULL),(354,22,15,NULL,NULL),(355,22,17,NULL,NULL),(356,22,18,NULL,NULL),(357,22,28,NULL,NULL),(358,22,30,NULL,NULL),(359,22,32,NULL,NULL),(360,22,35,NULL,NULL),(361,22,9,NULL,NULL),(362,23,13,NULL,NULL),(363,23,14,NULL,NULL),(364,23,23,NULL,NULL),(365,23,45,NULL,NULL),(366,23,46,NULL,NULL),(367,23,1,NULL,NULL),(368,23,2,NULL,NULL),(369,23,4,NULL,NULL),(370,23,6,NULL,NULL),(371,23,19,NULL,NULL),(372,23,7,NULL,NULL),(373,23,10,NULL,NULL),(374,23,15,NULL,NULL),(375,23,17,NULL,NULL),(376,23,18,NULL,NULL),(377,23,29,NULL,NULL),(378,23,31,NULL,NULL),(379,23,33,NULL,NULL),(380,23,37,NULL,NULL),(381,23,43,NULL,NULL),(382,24,14,NULL,NULL),(383,24,22,NULL,NULL),(384,24,23,NULL,NULL),(385,24,46,NULL,NULL),(386,24,2,NULL,NULL),(387,24,4,NULL,NULL),(388,24,6,NULL,NULL),(389,24,19,NULL,NULL),(390,24,7,NULL,NULL),(391,24,10,NULL,NULL),(392,24,30,NULL,NULL),(393,24,32,NULL,NULL),(394,24,35,NULL,NULL),(395,24,37,NULL,NULL),(396,24,38,NULL,NULL),(397,24,39,NULL,NULL),(398,25,13,NULL,NULL),(399,25,22,NULL,NULL),(400,25,23,NULL,NULL),(401,25,47,NULL,NULL),(402,25,4,NULL,NULL),(403,25,16,NULL,NULL),(404,25,40,NULL,NULL),(405,25,41,NULL,NULL),(406,25,42,NULL,NULL),(407,25,43,NULL,NULL),(408,26,23,NULL,NULL),(409,26,45,NULL,NULL),(410,26,47,NULL,NULL),(411,26,2,NULL,NULL),(412,26,6,NULL,NULL),(413,26,19,NULL,NULL),(414,26,15,NULL,NULL),(415,26,17,NULL,NULL),(416,26,18,NULL,NULL),(417,26,28,NULL,NULL),(418,26,29,NULL,NULL),(419,26,30,NULL,NULL),(420,26,31,NULL,NULL),(421,26,20,NULL,NULL),(422,27,22,NULL,NULL),(423,27,23,NULL,NULL),(424,27,45,NULL,NULL),(425,27,46,NULL,NULL),(426,27,6,NULL,NULL),(427,27,8,NULL,NULL),(428,27,12,NULL,NULL),(429,27,16,NULL,NULL),(430,27,32,NULL,NULL),(431,28,13,NULL,NULL),(432,28,23,NULL,NULL),(433,28,45,NULL,NULL),(434,28,3,NULL,NULL),(435,28,20,NULL,NULL),(436,28,25,NULL,NULL),(437,28,27,NULL,NULL),(438,28,33,NULL,NULL),(439,28,7,NULL,NULL),(440,28,10,NULL,NULL),(441,28,12,NULL,NULL),(442,28,17,NULL,NULL),(443,28,18,NULL,NULL),(444,28,28,NULL,NULL),(445,28,29,NULL,NULL),(446,28,30,NULL,NULL),(447,28,34,NULL,NULL),(448,28,40,NULL,NULL),(449,28,41,NULL,NULL),(450,28,39,NULL,NULL),(451,28,42,NULL,NULL),(452,28,43,NULL,NULL),(453,29,14,NULL,NULL),(454,29,22,NULL,NULL),(455,29,23,NULL,NULL),(456,29,45,NULL,NULL),(457,29,46,NULL,NULL),(458,29,1,NULL,NULL),(459,29,6,NULL,NULL),(460,29,8,NULL,NULL),(461,29,10,NULL,NULL),(462,29,15,NULL,NULL),(463,29,17,NULL,NULL),(464,29,30,NULL,NULL),(465,29,34,NULL,NULL),(466,29,35,NULL,NULL),(467,29,5,NULL,NULL),(468,29,9,NULL,NULL),(469,30,22,NULL,NULL),(470,30,45,NULL,NULL),(471,30,46,NULL,NULL),(472,30,5,NULL,NULL),(473,30,20,NULL,NULL),(474,30,27,NULL,NULL),(475,30,33,NULL,NULL),(476,30,10,NULL,NULL),(477,30,11,NULL,NULL),(478,30,15,NULL,NULL),(479,30,18,NULL,NULL),(480,30,29,NULL,NULL),(481,30,31,NULL,NULL),(482,30,34,NULL,NULL),(483,30,35,NULL,NULL),(484,30,39,NULL,NULL),(485,30,43,NULL,NULL),(486,31,13,NULL,NULL),(487,31,14,NULL,NULL),(488,31,22,NULL,NULL),(489,31,45,NULL,NULL),(490,31,47,NULL,NULL),(491,31,3,NULL,NULL),(492,31,5,NULL,NULL),(493,31,25,NULL,NULL),(494,31,27,NULL,NULL),(495,31,7,NULL,NULL),(496,31,10,NULL,NULL),(497,31,11,NULL,NULL),(498,31,15,NULL,NULL),(499,31,16,NULL,NULL),(500,31,17,NULL,NULL),(501,31,28,NULL,NULL),(502,31,29,NULL,NULL),(503,31,30,NULL,NULL),(504,31,32,NULL,NULL),(505,31,41,NULL,NULL),(506,31,42,NULL,NULL),(507,32,14,NULL,NULL),(508,32,22,NULL,NULL),(509,32,46,NULL,NULL),(510,32,2,NULL,NULL),(511,32,4,NULL,NULL),(512,32,8,NULL,NULL),(513,32,19,NULL,NULL),(514,32,15,NULL,NULL),(515,32,16,NULL,NULL),(516,32,18,NULL,NULL),(517,32,29,NULL,NULL),(518,32,34,NULL,NULL),(519,32,35,NULL,NULL),(520,32,3,NULL,NULL),(521,32,21,NULL,NULL),(522,33,13,NULL,NULL),(523,33,14,NULL,NULL),(524,33,22,NULL,NULL),(525,33,1,NULL,NULL),(526,33,2,NULL,NULL),(527,33,6,NULL,NULL),(528,33,8,NULL,NULL),(529,33,7,NULL,NULL),(530,33,11,NULL,NULL),(531,33,12,NULL,NULL),(532,33,16,NULL,NULL),(533,33,17,NULL,NULL),(534,33,28,NULL,NULL),(535,33,30,NULL,NULL),(536,33,33,NULL,NULL),(537,33,38,NULL,NULL),(538,33,41,NULL,NULL),(539,34,13,NULL,NULL),(540,34,22,NULL,NULL),(541,34,23,NULL,NULL),(542,34,45,NULL,NULL),(543,34,2,NULL,NULL),(544,34,19,NULL,NULL),(545,34,16,NULL,NULL),(546,34,37,NULL,NULL),(547,34,41,NULL,NULL),(548,35,13,NULL,NULL),(549,35,14,NULL,NULL),(550,35,23,NULL,NULL),(551,35,45,NULL,NULL),(552,35,1,NULL,NULL),(553,35,7,NULL,NULL),(554,35,10,NULL,NULL),(555,36,13,NULL,NULL),(556,36,14,NULL,NULL),(557,36,23,NULL,NULL),(558,36,45,NULL,NULL),(559,36,1,NULL,NULL),(560,36,2,NULL,NULL),(561,36,8,NULL,NULL),(562,36,19,NULL,NULL),(563,36,15,NULL,NULL),(564,36,16,NULL,NULL),(565,36,17,NULL,NULL),(566,36,28,NULL,NULL),(567,36,29,NULL,NULL),(568,36,31,NULL,NULL),(569,37,14,NULL,NULL),(570,37,22,NULL,NULL),(571,37,23,NULL,NULL),(572,37,46,NULL,NULL),(573,37,2,NULL,NULL),(574,37,8,NULL,NULL),(575,37,19,NULL,NULL),(576,37,7,NULL,NULL),(577,37,10,NULL,NULL),(578,37,11,NULL,NULL),(579,37,12,NULL,NULL),(580,37,15,NULL,NULL),(581,37,32,NULL,NULL),(582,37,35,NULL,NULL),(583,37,5,NULL,NULL),(584,37,9,NULL,NULL),(585,37,27,NULL,NULL),(586,38,13,NULL,NULL),(587,38,22,NULL,NULL),(588,38,23,NULL,NULL),(589,38,45,NULL,NULL),(590,38,47,NULL,NULL),(591,38,1,NULL,NULL),(592,38,4,NULL,NULL),(593,38,6,NULL,NULL),(594,38,19,NULL,NULL),(595,38,7,NULL,NULL),(596,38,12,NULL,NULL),(597,38,15,NULL,NULL),(598,38,28,NULL,NULL),(599,38,30,NULL,NULL),(600,38,32,NULL,NULL),(601,38,34,NULL,NULL),(602,38,9,NULL,NULL),(603,38,21,NULL,NULL),(604,38,25,NULL,NULL),(605,39,14,NULL,NULL),(606,39,23,NULL,NULL),(607,39,45,NULL,NULL),(608,39,46,NULL,NULL),(609,39,1,NULL,NULL),(610,39,4,NULL,NULL),(611,39,6,NULL,NULL),(612,39,8,NULL,NULL),(613,39,19,NULL,NULL),(614,39,7,NULL,NULL),(615,39,10,NULL,NULL),(616,39,15,NULL,NULL),(617,39,16,NULL,NULL),(618,39,17,NULL,NULL),(619,39,30,NULL,NULL),(620,39,31,NULL,NULL),(621,39,3,NULL,NULL),(622,39,21,NULL,NULL),(623,39,37,NULL,NULL),(624,39,39,NULL,NULL),(625,39,40,NULL,NULL),(626,39,43,NULL,NULL),(627,40,13,NULL,NULL),(628,40,14,NULL,NULL),(629,40,45,NULL,NULL),(630,40,1,NULL,NULL),(631,40,8,NULL,NULL),(632,40,7,NULL,NULL),(633,40,10,NULL,NULL),(634,40,28,NULL,NULL),(635,40,30,NULL,NULL),(636,41,14,NULL,NULL),(637,41,22,NULL,NULL),(638,41,45,NULL,NULL),(639,41,46,NULL,NULL),(640,41,47,NULL,NULL),(641,41,3,NULL,NULL),(642,41,5,NULL,NULL),(643,41,20,NULL,NULL),(644,41,21,NULL,NULL),(645,41,33,NULL,NULL),(646,41,7,NULL,NULL),(647,41,11,NULL,NULL),(648,41,15,NULL,NULL),(649,41,16,NULL,NULL),(650,41,28,NULL,NULL),(651,41,31,NULL,NULL),(652,41,34,NULL,NULL),(653,41,35,NULL,NULL),(654,41,39,NULL,NULL),(655,41,40,NULL,NULL),(656,41,41,NULL,NULL),(657,42,13,NULL,NULL),(658,42,23,NULL,NULL),(659,42,46,NULL,NULL),(660,42,1,NULL,NULL),(661,42,2,NULL,NULL),(662,42,6,NULL,NULL),(663,42,8,NULL,NULL),(664,42,11,NULL,NULL),(665,42,15,NULL,NULL),(666,42,16,NULL,NULL),(667,42,18,NULL,NULL),(668,42,29,NULL,NULL),(669,42,30,NULL,NULL),(670,42,32,NULL,NULL),(671,42,9,NULL,NULL),(672,42,38,NULL,NULL),(673,42,40,NULL,NULL),(674,42,42,NULL,NULL),(675,42,43,NULL,NULL),(676,43,13,NULL,NULL),(677,43,23,NULL,NULL),(678,43,45,NULL,NULL),(679,43,1,NULL,NULL),(680,43,2,NULL,NULL),(681,43,19,NULL,NULL),(682,43,7,NULL,NULL),(683,43,12,NULL,NULL),(684,43,16,NULL,NULL),(685,43,17,NULL,NULL),(686,43,28,NULL,NULL),(687,43,31,NULL,NULL),(688,43,32,NULL,NULL),(689,43,9,NULL,NULL),(690,43,21,NULL,NULL),(691,44,14,NULL,NULL),(692,44,23,NULL,NULL),(693,44,47,NULL,NULL),(694,44,2,NULL,NULL),(695,44,4,NULL,NULL),(696,44,6,NULL,NULL),(697,44,8,NULL,NULL),(698,44,19,NULL,NULL),(699,44,10,NULL,NULL),(700,44,11,NULL,NULL),(701,44,12,NULL,NULL),(702,44,18,NULL,NULL),(703,44,29,NULL,NULL),(704,44,34,NULL,NULL),(705,44,21,NULL,NULL),(706,44,25,NULL,NULL),(707,44,27,NULL,NULL),(708,44,37,NULL,NULL),(709,44,38,NULL,NULL),(710,45,13,NULL,NULL),(711,45,22,NULL,NULL),(712,45,45,NULL,NULL),(713,45,47,NULL,NULL),(714,45,3,NULL,NULL),(715,45,9,NULL,NULL),(716,45,25,NULL,NULL),(717,45,27,NULL,NULL),(718,45,7,NULL,NULL),(719,45,10,NULL,NULL),(720,45,11,NULL,NULL),(721,45,12,NULL,NULL),(722,45,16,NULL,NULL),(723,45,17,NULL,NULL),(724,45,29,NULL,NULL),(725,45,31,NULL,NULL),(726,45,32,NULL,NULL),(727,45,34,NULL,NULL),(728,45,39,NULL,NULL),(729,45,40,NULL,NULL),(730,45,41,NULL,NULL),(731,45,43,NULL,NULL),(732,45,42,NULL,NULL),(733,46,22,NULL,NULL),(734,46,45,NULL,NULL),(735,46,46,NULL,NULL),(736,46,47,NULL,NULL),(737,46,1,NULL,NULL),(738,46,2,NULL,NULL),(739,46,4,NULL,NULL),(740,46,6,NULL,NULL),(741,46,8,NULL,NULL),(742,46,10,NULL,NULL),(743,46,11,NULL,NULL),(744,46,12,NULL,NULL),(745,46,16,NULL,NULL),(746,46,17,NULL,NULL),(747,46,32,NULL,NULL),(748,46,34,NULL,NULL),(749,46,20,NULL,NULL),(750,46,21,NULL,NULL),(751,47,14,NULL,NULL),(752,47,23,NULL,NULL),(753,47,45,NULL,NULL),(754,47,46,NULL,NULL),(755,47,47,NULL,NULL),(756,47,1,NULL,NULL),(757,47,8,NULL,NULL),(758,47,7,NULL,NULL),(759,47,10,NULL,NULL),(760,47,17,NULL,NULL),(761,47,28,NULL,NULL),(762,47,35,NULL,NULL),(763,47,37,NULL,NULL),(764,47,43,NULL,NULL),(765,48,22,NULL,NULL),(766,48,23,NULL,NULL),(767,48,47,NULL,NULL),(768,48,1,NULL,NULL),(769,48,6,NULL,NULL),(770,48,18,NULL,NULL),(771,49,13,NULL,NULL),(772,49,22,NULL,NULL),(773,49,45,NULL,NULL),(774,49,46,NULL,NULL),(775,49,47,NULL,NULL),(776,49,1,NULL,NULL),(777,49,19,NULL,NULL),(778,49,7,NULL,NULL),(779,50,13,NULL,NULL),(780,50,22,NULL,NULL),(781,50,23,NULL,NULL),(782,50,45,NULL,NULL),(783,50,46,NULL,NULL),(784,50,1,NULL,NULL),(785,50,7,NULL,NULL),(786,50,15,NULL,NULL),(787,51,13,NULL,NULL),(788,51,14,NULL,NULL),(789,51,22,NULL,NULL),(790,51,23,NULL,NULL),(791,51,45,NULL,NULL),(792,51,9,NULL,NULL),(793,51,21,NULL,NULL),(794,51,25,NULL,NULL),(795,51,33,NULL,NULL),(796,51,7,NULL,NULL),(797,51,11,NULL,NULL),(798,51,12,NULL,NULL),(799,51,15,NULL,NULL),(800,51,16,NULL,NULL),(801,51,18,NULL,NULL),(802,51,28,NULL,NULL),(803,51,31,NULL,NULL),(804,51,32,NULL,NULL),(805,51,34,NULL,NULL),(806,51,35,NULL,NULL),(807,51,38,NULL,NULL),(808,51,39,NULL,NULL),(809,52,13,NULL,NULL),(810,52,22,NULL,NULL),(811,52,45,NULL,NULL),(812,52,46,NULL,NULL),(813,52,1,NULL,NULL),(814,52,2,NULL,NULL),(815,52,4,NULL,NULL),(816,52,6,NULL,NULL),(817,52,7,NULL,NULL),(818,52,12,NULL,NULL),(819,52,15,NULL,NULL),(820,52,17,NULL,NULL),(821,52,18,NULL,NULL),(822,52,30,NULL,NULL),(823,52,31,NULL,NULL),(824,52,32,NULL,NULL),(825,52,34,NULL,NULL),(826,52,33,NULL,NULL),(827,53,13,NULL,NULL),(828,53,14,NULL,NULL),(829,53,45,NULL,NULL),(830,53,46,NULL,NULL),(831,53,1,NULL,NULL),(832,53,8,NULL,NULL),(833,53,19,NULL,NULL),(834,53,10,NULL,NULL),(835,53,12,NULL,NULL),(836,53,15,NULL,NULL),(837,53,18,NULL,NULL),(838,53,29,NULL,NULL),(839,53,34,NULL,NULL),(840,54,13,NULL,NULL),(841,54,22,NULL,NULL),(842,54,23,NULL,NULL),(843,54,46,NULL,NULL),(844,54,1,NULL,NULL),(845,54,6,NULL,NULL),(846,54,10,NULL,NULL),(847,54,18,NULL,NULL),(848,54,28,NULL,NULL),(849,54,29,NULL,NULL),(850,55,13,NULL,NULL),(851,55,14,NULL,NULL),(852,55,22,NULL,NULL),(853,55,45,NULL,NULL),(854,55,47,NULL,NULL),(855,55,1,NULL,NULL),(856,55,2,NULL,NULL),(857,55,6,NULL,NULL),(858,55,7,NULL,NULL),(859,55,15,NULL,NULL),(860,55,17,NULL,NULL),(861,55,30,NULL,NULL),(862,55,35,NULL,NULL),(863,56,22,NULL,NULL),(864,56,23,NULL,NULL),(865,56,45,NULL,NULL),(866,56,3,NULL,NULL),(867,56,20,NULL,NULL),(868,56,21,NULL,NULL),(869,56,25,NULL,NULL),(870,56,27,NULL,NULL),(871,56,33,NULL,NULL),(872,56,12,NULL,NULL),(873,56,15,NULL,NULL),(874,56,16,NULL,NULL),(875,56,17,NULL,NULL),(876,56,29,NULL,NULL),(877,56,30,NULL,NULL),(878,56,32,NULL,NULL),(879,56,34,NULL,NULL),(880,56,37,NULL,NULL),(881,56,38,NULL,NULL),(882,56,43,NULL,NULL),(883,57,13,NULL,NULL),(884,57,23,NULL,NULL),(885,57,45,NULL,NULL),(886,57,46,NULL,NULL),(887,57,9,NULL,NULL),(888,57,21,NULL,NULL),(889,57,25,NULL,NULL),(890,57,27,NULL,NULL),(891,57,33,NULL,NULL),(892,57,7,NULL,NULL),(893,57,10,NULL,NULL),(894,57,11,NULL,NULL),(895,57,15,NULL,NULL),(896,57,18,NULL,NULL),(897,57,29,NULL,NULL),(898,57,31,NULL,NULL),(899,57,32,NULL,NULL),(900,57,34,NULL,NULL),(901,57,35,NULL,NULL),(902,57,38,NULL,NULL),(903,57,39,NULL,NULL),(904,57,40,NULL,NULL),(905,57,43,NULL,NULL),(906,57,37,NULL,NULL),(907,58,14,NULL,NULL),(908,58,23,NULL,NULL),(909,58,46,NULL,NULL),(910,58,1,NULL,NULL),(911,58,4,NULL,NULL),(912,58,11,NULL,NULL),(913,58,17,NULL,NULL),(914,58,34,NULL,NULL),(915,58,40,NULL,NULL),(916,58,41,NULL,NULL),(917,58,42,NULL,NULL),(918,58,43,NULL,NULL),(919,59,14,NULL,NULL),(920,59,45,NULL,NULL),(921,59,46,NULL,NULL),(922,59,47,NULL,NULL),(923,59,1,NULL,NULL),(924,59,2,NULL,NULL),(925,59,4,NULL,NULL),(926,59,6,NULL,NULL),(927,59,19,NULL,NULL),(928,59,10,NULL,NULL),(929,59,15,NULL,NULL),(930,59,17,NULL,NULL),(931,59,18,NULL,NULL),(932,59,29,NULL,NULL),(933,59,30,NULL,NULL),(934,59,34,NULL,NULL),(935,59,35,NULL,NULL),(936,59,3,NULL,NULL),(937,60,22,NULL,NULL),(938,60,45,NULL,NULL),(939,60,46,NULL,NULL),(940,60,1,NULL,NULL),(941,60,2,NULL,NULL),(942,60,6,NULL,NULL),(943,60,8,NULL,NULL),(944,60,10,NULL,NULL),(945,60,12,NULL,NULL),(946,60,16,NULL,NULL),(947,60,17,NULL,NULL),(948,60,34,NULL,NULL),(949,60,35,NULL,NULL),(950,60,9,NULL,NULL),(951,60,33,NULL,NULL),(952,61,14,NULL,NULL),(953,61,23,NULL,NULL),(954,61,45,NULL,NULL),(955,61,46,NULL,NULL),(956,61,47,NULL,NULL),(957,61,1,NULL,NULL),(958,61,4,NULL,NULL),(959,61,19,NULL,NULL),(960,61,10,NULL,NULL),(961,61,11,NULL,NULL),(962,61,30,NULL,NULL),(963,61,32,NULL,NULL),(964,61,34,NULL,NULL),(965,62,14,NULL,NULL),(966,62,45,NULL,NULL),(967,62,46,NULL,NULL),(968,62,47,NULL,NULL),(969,62,4,NULL,NULL),(970,62,8,NULL,NULL),(971,62,10,NULL,NULL),(972,62,16,NULL,NULL),(973,62,17,NULL,NULL),(974,62,29,NULL,NULL),(975,62,37,NULL,NULL),(976,62,39,NULL,NULL),(977,62,41,NULL,NULL),(978,62,43,NULL,NULL),(979,63,13,NULL,NULL),(980,63,22,NULL,NULL),(981,63,47,NULL,NULL),(982,63,20,NULL,NULL),(983,63,21,NULL,NULL),(984,63,25,NULL,NULL),(985,63,33,NULL,NULL),(986,63,10,NULL,NULL),(987,63,11,NULL,NULL),(988,63,12,NULL,NULL),(989,63,18,NULL,NULL),(990,63,28,NULL,NULL),(991,63,29,NULL,NULL),(992,63,30,NULL,NULL),(993,63,31,NULL,NULL),(994,63,32,NULL,NULL),(995,63,38,NULL,NULL),(996,63,40,NULL,NULL),(997,63,41,NULL,NULL),(998,63,43,NULL,NULL),(999,64,13,NULL,NULL),(1000,64,22,NULL,NULL),(1001,64,45,NULL,NULL),(1002,64,46,NULL,NULL),(1003,64,5,NULL,NULL),(1004,64,9,NULL,NULL),(1005,64,21,NULL,NULL),(1006,64,25,NULL,NULL),(1007,64,33,NULL,NULL),(1008,64,7,NULL,NULL),(1009,64,10,NULL,NULL),(1010,64,11,NULL,NULL),(1011,64,15,NULL,NULL),(1012,64,16,NULL,NULL),(1013,64,17,NULL,NULL),(1014,64,28,NULL,NULL),(1015,64,34,NULL,NULL),(1016,64,35,NULL,NULL),(1017,64,38,NULL,NULL),(1018,64,39,NULL,NULL),(1019,64,40,NULL,NULL),(1020,64,43,NULL,NULL),(1021,65,22,NULL,NULL),(1022,65,45,NULL,NULL),(1023,65,46,NULL,NULL),(1024,65,2,NULL,NULL),(1025,65,6,NULL,NULL),(1026,65,7,NULL,NULL),(1027,65,11,NULL,NULL),(1028,65,18,NULL,NULL),(1029,65,28,NULL,NULL),(1030,65,32,NULL,NULL),(1031,65,34,NULL,NULL),(1032,66,13,NULL,NULL),(1033,66,14,NULL,NULL),(1034,66,22,NULL,NULL),(1035,66,23,NULL,NULL),(1036,66,46,NULL,NULL),(1037,66,4,NULL,NULL),(1038,66,6,NULL,NULL),(1039,66,8,NULL,NULL),(1040,66,16,NULL,NULL),(1041,66,18,NULL,NULL),(1042,66,29,NULL,NULL),(1043,67,13,NULL,NULL),(1044,67,22,NULL,NULL),(1045,67,23,NULL,NULL),(1046,67,5,NULL,NULL),(1047,67,20,NULL,NULL),(1048,67,21,NULL,NULL),(1049,67,27,NULL,NULL),(1050,67,33,NULL,NULL),(1051,67,7,NULL,NULL),(1052,67,11,NULL,NULL),(1053,67,12,NULL,NULL),(1054,67,15,NULL,NULL),(1055,67,18,NULL,NULL),(1056,67,29,NULL,NULL),(1057,67,30,NULL,NULL),(1058,67,32,NULL,NULL),(1059,67,34,NULL,NULL),(1060,67,39,NULL,NULL),(1061,67,42,NULL,NULL),(1062,67,43,NULL,NULL),(1063,67,41,NULL,NULL),(1064,68,13,NULL,NULL),(1065,68,14,NULL,NULL),(1066,68,22,NULL,NULL),(1067,68,23,NULL,NULL),(1068,68,45,NULL,NULL),(1069,68,5,NULL,NULL),(1070,68,9,NULL,NULL),(1071,68,25,NULL,NULL),(1072,68,27,NULL,NULL),(1073,68,33,NULL,NULL),(1074,68,7,NULL,NULL),(1075,68,10,NULL,NULL),(1076,68,12,NULL,NULL),(1077,68,15,NULL,NULL),(1078,68,16,NULL,NULL),(1079,68,18,NULL,NULL),(1080,68,28,NULL,NULL),(1081,68,29,NULL,NULL),(1082,68,34,NULL,NULL),(1083,68,35,NULL,NULL),(1084,68,37,NULL,NULL),(1085,68,39,NULL,NULL),(1086,68,42,NULL,NULL),(1087,68,43,NULL,NULL),(1088,68,38,NULL,NULL),(1089,68,40,NULL,NULL),(1090,69,13,NULL,NULL),(1091,69,14,NULL,NULL),(1092,69,22,NULL,NULL),(1093,69,23,NULL,NULL),(1094,69,46,NULL,NULL),(1095,69,3,NULL,NULL),(1096,69,5,NULL,NULL),(1097,69,9,NULL,NULL),(1098,69,20,NULL,NULL),(1099,69,21,NULL,NULL),(1100,69,25,NULL,NULL),(1101,69,15,NULL,NULL),(1102,69,16,NULL,NULL),(1103,69,17,NULL,NULL),(1104,69,18,NULL,NULL),(1105,69,28,NULL,NULL),(1106,69,29,NULL,NULL),(1107,69,31,NULL,NULL),(1108,69,35,NULL,NULL),(1109,69,37,NULL,NULL),(1110,69,40,NULL,NULL),(1111,69,41,NULL,NULL),(1112,69,43,NULL,NULL),(1113,70,13,NULL,NULL),(1114,70,14,NULL,NULL),(1115,70,22,NULL,NULL),(1116,70,45,NULL,NULL),(1117,70,46,NULL,NULL),(1118,70,1,NULL,NULL),(1119,70,2,NULL,NULL),(1120,70,4,NULL,NULL),(1121,70,8,NULL,NULL),(1122,70,19,NULL,NULL),(1123,70,7,NULL,NULL),(1124,70,11,NULL,NULL),(1125,70,12,NULL,NULL),(1126,70,15,NULL,NULL),(1127,70,17,NULL,NULL),(1128,70,29,NULL,NULL),(1129,70,31,NULL,NULL),(1130,70,35,NULL,NULL),(1131,70,5,NULL,NULL),(1132,70,25,NULL,NULL),(1133,71,22,NULL,NULL),(1134,71,23,NULL,NULL),(1135,71,46,NULL,NULL),(1136,71,47,NULL,NULL),(1137,71,1,NULL,NULL),(1138,71,2,NULL,NULL),(1139,71,4,NULL,NULL),(1140,71,19,NULL,NULL),(1141,71,7,NULL,NULL),(1142,71,10,NULL,NULL),(1143,71,17,NULL,NULL),(1144,71,35,NULL,NULL),(1145,71,37,NULL,NULL),(1146,71,43,NULL,NULL),(1147,72,13,NULL,NULL),(1148,72,14,NULL,NULL),(1149,72,22,NULL,NULL),(1150,72,45,NULL,NULL),(1151,72,47,NULL,NULL),(1152,72,3,NULL,NULL),(1153,72,9,NULL,NULL),(1154,72,20,NULL,NULL),(1155,72,25,NULL,NULL),(1156,72,27,NULL,NULL),(1157,72,33,NULL,NULL),(1158,72,10,NULL,NULL),(1159,72,12,NULL,NULL),(1160,72,15,NULL,NULL),(1161,72,16,NULL,NULL),(1162,72,18,NULL,NULL),(1163,72,28,NULL,NULL),(1164,72,30,NULL,NULL),(1165,72,32,NULL,NULL),(1166,72,34,NULL,NULL),(1167,72,35,NULL,NULL),(1168,72,37,NULL,NULL),(1169,72,40,NULL,NULL),(1170,72,41,NULL,NULL),(1171,72,43,NULL,NULL),(1172,73,13,NULL,NULL),(1173,73,22,NULL,NULL),(1174,73,47,NULL,NULL),(1175,73,2,NULL,NULL),(1176,73,4,NULL,NULL),(1177,73,6,NULL,NULL),(1178,73,8,NULL,NULL),(1179,73,19,NULL,NULL),(1180,73,7,NULL,NULL),(1181,73,11,NULL,NULL),(1182,73,16,NULL,NULL),(1183,73,18,NULL,NULL),(1184,73,28,NULL,NULL),(1185,73,29,NULL,NULL),(1186,73,30,NULL,NULL),(1187,73,32,NULL,NULL),(1188,73,21,NULL,NULL),(1189,73,33,NULL,NULL),(1190,73,41,NULL,NULL),(1191,73,42,NULL,NULL),(1192,74,14,NULL,NULL),(1193,74,22,NULL,NULL),(1194,74,45,NULL,NULL),(1195,74,46,NULL,NULL),(1196,74,2,NULL,NULL),(1197,74,4,NULL,NULL),(1198,74,6,NULL,NULL),(1199,74,19,NULL,NULL),(1200,74,7,NULL,NULL),(1201,74,12,NULL,NULL),(1202,74,17,NULL,NULL),(1203,74,18,NULL,NULL),(1204,74,29,NULL,NULL),(1205,75,14,NULL,NULL),(1206,75,22,NULL,NULL),(1207,75,23,NULL,NULL),(1208,75,1,NULL,NULL),(1209,75,2,NULL,NULL),(1210,75,4,NULL,NULL),(1211,75,8,NULL,NULL),(1212,75,19,NULL,NULL),(1213,75,7,NULL,NULL),(1214,75,12,NULL,NULL),(1215,75,18,NULL,NULL),(1216,75,30,NULL,NULL),(1217,75,35,NULL,NULL),(1218,75,21,NULL,NULL),(1219,75,33,NULL,NULL),(1220,76,22,NULL,NULL),(1221,76,45,NULL,NULL),(1222,76,46,NULL,NULL),(1223,76,4,NULL,NULL),(1224,76,8,NULL,NULL),(1225,76,19,NULL,NULL),(1226,76,16,NULL,NULL),(1227,76,17,NULL,NULL),(1228,76,29,NULL,NULL),(1229,76,31,NULL,NULL),(1230,76,32,NULL,NULL),(1231,76,39,NULL,NULL),(1232,76,40,NULL,NULL),(1233,76,42,NULL,NULL),(1234,77,13,NULL,NULL),(1235,77,22,NULL,NULL),(1236,77,45,NULL,NULL),(1237,77,47,NULL,NULL),(1238,77,2,NULL,NULL),(1239,77,4,NULL,NULL),(1240,77,8,NULL,NULL),(1241,77,19,NULL,NULL),(1242,77,7,NULL,NULL),(1243,77,10,NULL,NULL),(1244,77,11,NULL,NULL),(1245,77,12,NULL,NULL),(1246,77,16,NULL,NULL),(1247,77,28,NULL,NULL),(1248,77,29,NULL,NULL),(1249,77,31,NULL,NULL),(1250,77,32,NULL,NULL),(1251,77,5,NULL,NULL),(1252,77,9,NULL,NULL),(1253,77,38,NULL,NULL),(1254,77,41,NULL,NULL),(1255,77,42,NULL,NULL),(1256,77,43,NULL,NULL),(1257,78,13,NULL,NULL),(1258,78,14,NULL,NULL),(1259,78,23,NULL,NULL),(1260,78,46,NULL,NULL),(1261,78,5,NULL,NULL),(1262,78,9,NULL,NULL),(1263,78,20,NULL,NULL),(1264,78,21,NULL,NULL),(1265,78,25,NULL,NULL),(1266,78,33,NULL,NULL),(1267,78,7,NULL,NULL),(1268,78,12,NULL,NULL),(1269,78,15,NULL,NULL),(1270,78,16,NULL,NULL),(1271,78,17,NULL,NULL),(1272,78,18,NULL,NULL),(1273,78,28,NULL,NULL),(1274,78,29,NULL,NULL),(1275,78,32,NULL,NULL),(1276,78,35,NULL,NULL),(1277,78,38,NULL,NULL),(1278,78,39,NULL,NULL),(1279,78,41,NULL,NULL),(1280,78,42,NULL,NULL),(1281,78,40,NULL,NULL),(1282,79,14,NULL,NULL),(1283,79,22,NULL,NULL),(1284,79,47,NULL,NULL),(1285,79,3,NULL,NULL),(1286,79,9,NULL,NULL),(1287,79,20,NULL,NULL),(1288,79,21,NULL,NULL),(1289,79,33,NULL,NULL),(1290,79,7,NULL,NULL),(1291,79,11,NULL,NULL),(1292,79,12,NULL,NULL),(1293,79,15,NULL,NULL),(1294,79,16,NULL,NULL),(1295,79,17,NULL,NULL),(1296,79,28,NULL,NULL),(1297,79,29,NULL,NULL),(1298,79,30,NULL,NULL),(1299,79,31,NULL,NULL),(1300,79,35,NULL,NULL),(1301,79,40,NULL,NULL),(1302,79,41,NULL,NULL),(1303,79,43,NULL,NULL),(1304,80,13,NULL,NULL),(1305,80,22,NULL,NULL),(1306,80,23,NULL,NULL),(1307,80,45,NULL,NULL),(1308,80,47,NULL,NULL),(1309,80,1,NULL,NULL),(1310,80,19,NULL,NULL),(1311,80,15,NULL,NULL),(1312,80,16,NULL,NULL),(1313,80,30,NULL,NULL),(1314,80,34,NULL,NULL),(1315,80,37,NULL,NULL),(1316,80,38,NULL,NULL),(1317,80,42,NULL,NULL),(1318,81,13,NULL,NULL),(1319,81,45,NULL,NULL),(1320,81,46,NULL,NULL),(1321,81,47,NULL,NULL),(1322,81,2,NULL,NULL),(1323,81,4,NULL,NULL),(1324,81,6,NULL,NULL),(1325,81,7,NULL,NULL),(1326,81,10,NULL,NULL),(1327,81,16,NULL,NULL),(1328,81,17,NULL,NULL),(1329,81,32,NULL,NULL),(1330,81,34,NULL,NULL),(1331,82,13,NULL,NULL),(1332,82,22,NULL,NULL),(1333,82,23,NULL,NULL),(1334,82,45,NULL,NULL),(1335,82,47,NULL,NULL),(1336,82,2,NULL,NULL),(1337,82,6,NULL,NULL),(1338,82,7,NULL,NULL),(1339,82,10,NULL,NULL),(1340,82,15,NULL,NULL),(1341,82,17,NULL,NULL),(1342,82,31,NULL,NULL),(1343,83,14,NULL,NULL),(1344,83,23,NULL,NULL),(1345,83,46,NULL,NULL),(1346,83,47,NULL,NULL),(1347,83,5,NULL,NULL),(1348,83,20,NULL,NULL),(1349,83,21,NULL,NULL),(1350,83,25,NULL,NULL),(1351,83,33,NULL,NULL),(1352,83,7,NULL,NULL),(1353,83,10,NULL,NULL),(1354,83,11,NULL,NULL),(1355,83,15,NULL,NULL),(1356,83,16,NULL,NULL),(1357,83,28,NULL,NULL),(1358,83,29,NULL,NULL),(1359,83,34,NULL,NULL),(1360,83,38,NULL,NULL),(1361,83,40,NULL,NULL),(1362,84,14,NULL,NULL),(1363,84,22,NULL,NULL),(1364,84,23,NULL,NULL),(1365,84,47,NULL,NULL),(1366,84,1,NULL,NULL),(1367,84,2,NULL,NULL),(1368,84,4,NULL,NULL),(1369,84,6,NULL,NULL),(1370,84,19,NULL,NULL),(1371,84,7,NULL,NULL),(1372,84,11,NULL,NULL),(1373,84,12,NULL,NULL),(1374,84,17,NULL,NULL),(1375,84,28,NULL,NULL),(1376,84,29,NULL,NULL),(1377,84,5,NULL,NULL),(1378,84,25,NULL,NULL),(1379,84,27,NULL,NULL),(1380,85,13,NULL,NULL),(1381,85,14,NULL,NULL),(1382,85,47,NULL,NULL),(1383,85,2,NULL,NULL),(1384,85,12,NULL,NULL),(1385,85,15,NULL,NULL),(1386,86,14,NULL,NULL),(1387,86,22,NULL,NULL),(1388,86,45,NULL,NULL),(1389,86,46,NULL,NULL),(1390,86,1,NULL,NULL),(1391,86,11,NULL,NULL),(1392,87,13,NULL,NULL),(1393,87,14,NULL,NULL),(1394,87,22,NULL,NULL),(1395,87,45,NULL,NULL),(1396,87,46,NULL,NULL),(1397,87,1,NULL,NULL),(1398,87,2,NULL,NULL),(1399,87,6,NULL,NULL),(1400,87,8,NULL,NULL),(1401,87,19,NULL,NULL),(1402,87,7,NULL,NULL),(1403,87,11,NULL,NULL),(1404,87,12,NULL,NULL),(1405,87,17,NULL,NULL),(1406,87,28,NULL,NULL),(1407,87,31,NULL,NULL),(1408,87,34,NULL,NULL),(1409,87,35,NULL,NULL),(1410,87,33,NULL,NULL),(1411,88,22,NULL,NULL),(1412,88,23,NULL,NULL),(1413,88,47,NULL,NULL),(1414,88,5,NULL,NULL),(1415,88,9,NULL,NULL),(1416,88,21,NULL,NULL),(1417,88,27,NULL,NULL),(1418,88,33,NULL,NULL),(1419,88,10,NULL,NULL),(1420,88,16,NULL,NULL),(1421,88,17,NULL,NULL),(1422,88,18,NULL,NULL),(1423,88,28,NULL,NULL),(1424,88,31,NULL,NULL),(1425,88,34,NULL,NULL),(1426,88,37,NULL,NULL),(1427,88,38,NULL,NULL),(1428,88,39,NULL,NULL),(1429,88,41,NULL,NULL),(1430,89,13,NULL,NULL),(1431,89,22,NULL,NULL),(1432,89,45,NULL,NULL),(1433,89,47,NULL,NULL),(1434,89,3,NULL,NULL),(1435,89,5,NULL,NULL),(1436,89,9,NULL,NULL),(1437,89,20,NULL,NULL),(1438,89,21,NULL,NULL),(1439,89,25,NULL,NULL),(1440,89,7,NULL,NULL),(1441,89,11,NULL,NULL),(1442,89,12,NULL,NULL),(1443,89,17,NULL,NULL),(1444,89,18,NULL,NULL),(1445,89,28,NULL,NULL),(1446,89,29,NULL,NULL),(1447,89,31,NULL,NULL),(1448,89,32,NULL,NULL),(1449,89,35,NULL,NULL),(1450,89,38,NULL,NULL),(1451,89,39,NULL,NULL),(1452,90,13,NULL,NULL),(1453,90,22,NULL,NULL),(1454,90,47,NULL,NULL),(1455,90,2,NULL,NULL),(1456,90,12,NULL,NULL),(1457,90,15,NULL,NULL),(1458,91,13,NULL,NULL),(1459,91,14,NULL,NULL),(1460,91,46,NULL,NULL),(1461,91,2,NULL,NULL),(1462,91,12,NULL,NULL),(1463,91,15,NULL,NULL),(1464,92,13,NULL,NULL),(1465,92,23,NULL,NULL),(1466,92,47,NULL,NULL),(1467,92,1,NULL,NULL),(1468,92,4,NULL,NULL),(1469,92,6,NULL,NULL),(1470,92,8,NULL,NULL),(1471,92,19,NULL,NULL),(1472,92,7,NULL,NULL),(1473,92,10,NULL,NULL),(1474,92,11,NULL,NULL),(1475,92,15,NULL,NULL),(1476,92,18,NULL,NULL),(1477,92,28,NULL,NULL),(1478,92,29,NULL,NULL),(1479,92,31,NULL,NULL),(1480,92,32,NULL,NULL),(1481,92,25,NULL,NULL),(1482,92,33,NULL,NULL),(1483,92,38,NULL,NULL),(1484,92,41,NULL,NULL),(1485,92,42,NULL,NULL),(1486,92,43,NULL,NULL),(1487,93,22,NULL,NULL),(1488,93,46,NULL,NULL),(1489,93,47,NULL,NULL),(1490,93,1,NULL,NULL),(1491,93,4,NULL,NULL),(1492,93,6,NULL,NULL),(1493,93,8,NULL,NULL),(1494,93,19,NULL,NULL),(1495,93,11,NULL,NULL),(1496,93,15,NULL,NULL),(1497,93,18,NULL,NULL),(1498,93,30,NULL,NULL),(1499,93,31,NULL,NULL),(1500,93,33,NULL,NULL),(1501,94,13,NULL,NULL),(1502,94,14,NULL,NULL),(1503,94,45,NULL,NULL),(1504,94,6,NULL,NULL),(1505,94,19,NULL,NULL),(1506,94,10,NULL,NULL),(1507,94,16,NULL,NULL),(1508,94,37,NULL,NULL),(1509,94,39,NULL,NULL),(1510,94,40,NULL,NULL),(1511,94,43,NULL,NULL),(1512,95,13,NULL,NULL),(1513,95,22,NULL,NULL),(1514,95,23,NULL,NULL),(1515,95,46,NULL,NULL),(1516,95,47,NULL,NULL),(1517,95,1,NULL,NULL),(1518,95,4,NULL,NULL),(1519,95,6,NULL,NULL),(1520,95,8,NULL,NULL),(1521,95,12,NULL,NULL),(1522,95,15,NULL,NULL),(1523,95,18,NULL,NULL),(1524,95,28,NULL,NULL),(1525,95,30,NULL,NULL),(1526,95,31,NULL,NULL),(1527,95,35,NULL,NULL),(1528,95,25,NULL,NULL),(1529,95,38,NULL,NULL),(1530,95,40,NULL,NULL),(1531,96,13,NULL,NULL),(1532,96,14,NULL,NULL),(1533,96,22,NULL,NULL),(1534,96,23,NULL,NULL),(1535,96,46,NULL,NULL),(1536,96,3,NULL,NULL),(1537,96,9,NULL,NULL),(1538,96,21,NULL,NULL),(1539,96,25,NULL,NULL),(1540,96,27,NULL,NULL),(1541,96,15,NULL,NULL),(1542,96,16,NULL,NULL),(1543,96,17,NULL,NULL),(1544,96,18,NULL,NULL),(1545,96,30,NULL,NULL),(1546,96,31,NULL,NULL),(1547,96,34,NULL,NULL),(1548,96,35,NULL,NULL),(1549,96,38,NULL,NULL),(1550,96,42,NULL,NULL),(1551,97,13,NULL,NULL),(1552,97,23,NULL,NULL),(1553,97,45,NULL,NULL),(1554,97,46,NULL,NULL),(1555,97,47,NULL,NULL),(1556,97,2,NULL,NULL),(1557,97,12,NULL,NULL),(1558,97,40,NULL,NULL),(1559,97,43,NULL,NULL),(1560,98,13,NULL,NULL),(1561,98,14,NULL,NULL),(1562,98,23,NULL,NULL),(1563,98,45,NULL,NULL),(1564,98,46,NULL,NULL),(1565,98,3,NULL,NULL),(1566,98,5,NULL,NULL),(1567,98,27,NULL,NULL),(1568,98,33,NULL,NULL),(1569,98,7,NULL,NULL),(1570,98,10,NULL,NULL),(1571,98,15,NULL,NULL),(1572,98,17,NULL,NULL),(1573,98,18,NULL,NULL),(1574,98,28,NULL,NULL),(1575,98,29,NULL,NULL),(1576,98,30,NULL,NULL),(1577,98,35,NULL,NULL),(1578,98,37,NULL,NULL),(1579,98,41,NULL,NULL),(1580,98,42,NULL,NULL),(1581,99,45,NULL,NULL),(1582,99,46,NULL,NULL),(1583,99,47,NULL,NULL),(1584,99,4,NULL,NULL),(1585,99,8,NULL,NULL),(1586,99,19,NULL,NULL),(1587,99,10,NULL,NULL),(1588,99,12,NULL,NULL),(1589,99,15,NULL,NULL),(1590,99,29,NULL,NULL),(1591,99,34,NULL,NULL),(1592,99,37,NULL,NULL),(1593,99,39,NULL,NULL),(1594,99,41,NULL,NULL),(1595,99,42,NULL,NULL),(1596,100,13,NULL,NULL),(1597,100,22,NULL,NULL),(1598,100,23,NULL,NULL),(1599,100,45,NULL,NULL),(1600,100,47,NULL,NULL),(1601,100,1,NULL,NULL),(1602,100,4,NULL,NULL),(1603,100,6,NULL,NULL),(1604,100,8,NULL,NULL),(1605,100,19,NULL,NULL),(1606,100,7,NULL,NULL),(1607,100,17,NULL,NULL),(1608,100,18,NULL,NULL),(1609,100,28,NULL,NULL),(1610,100,30,NULL,NULL),(1611,100,31,NULL,NULL),(1612,100,32,NULL,NULL),(1613,100,25,NULL,NULL),(1614,100,33,NULL,NULL),(1615,100,37,NULL,NULL),(1616,100,40,NULL,NULL),(1617,100,41,NULL,NULL),(1618,100,42,NULL,NULL);
/*!40000 ALTER TABLE `cr_cars_amenities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_categories`
--

DROP TABLE IF EXISTS `cr_cars_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_category_id` bigint unsigned DEFAULT NULL,
  `cr_car_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_cars_categories_cr_car_category_id_index` (`cr_car_category_id`),
  KEY `cr_cars_categories_cr_car_id_index` (`cr_car_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_categories`
--

LOCK TABLES `cr_cars_categories` WRITE;
/*!40000 ALTER TABLE `cr_cars_categories` DISABLE KEYS */;
INSERT INTO `cr_cars_categories` VALUES (1,3,3),(2,4,7),(3,3,24),(4,3,28),(5,1,58),(6,4,60),(7,4,78),(8,2,84),(9,4,1),(10,5,8),(11,3,13),(12,3,49),(13,4,82),(14,5,83),(15,1,99),(16,2,4),(17,1,36),(18,5,57),(19,4,70),(20,1,79),(21,2,39),(22,4,51),(23,5,54),(24,2,62),(25,4,77),(26,2,81),(27,3,85),(28,4,86),(29,5,89),(30,3,93),(31,5,94),(32,4,18),(33,5,26),(34,5,34),(35,1,42),(36,4,64),(37,2,75),(38,5,80),(39,1,88),(40,5,95),(41,5,5),(42,5,9),(43,5,20),(44,3,29),(45,2,48),(46,4,53),(47,5,69),(48,4,15),(49,2,43),(50,2,73),(51,4,11),(52,4,19),(53,2,23),(54,5,91),(55,2,100),(56,4,32),(57,3,41),(58,3,50),(59,2,63),(60,5,67),(61,5,72),(62,2,76),(63,4,14),(64,2,21),(65,5,22),(66,1,33),(67,2,37),(68,5,44),(69,5,45),(70,1,46),(71,4,71),(72,3,87),(73,3,90),(74,1,92),(75,3,97),(76,4,6),(77,5,16),(78,1,17),(79,3,25),(80,2,56),(81,2,2),(82,5,27),(83,3,30),(84,3,35),(85,4,38),(86,5,10),(87,3,40),(88,1,52),(89,5,61),(90,1,68),(91,1,74),(92,1,96),(93,2,12),(94,5,31),(95,1,47),(96,1,55),(97,1,59),(98,4,65),(99,5,66),(100,4,98);
/*!40000 ALTER TABLE `cr_cars_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_colors`
--

DROP TABLE IF EXISTS `cr_cars_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_colors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_id` bigint unsigned NOT NULL,
  `cr_car_color_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_colors`
--

LOCK TABLES `cr_cars_colors` WRITE;
/*!40000 ALTER TABLE `cr_cars_colors` DISABLE KEYS */;
INSERT INTO `cr_cars_colors` VALUES (1,1,3,NULL,NULL),(2,2,2,NULL,NULL),(3,3,4,NULL,NULL),(4,4,3,NULL,NULL),(5,5,6,NULL,NULL),(6,6,4,NULL,NULL),(7,7,3,NULL,NULL),(8,8,4,NULL,NULL),(9,9,6,NULL,NULL),(10,10,5,NULL,NULL),(11,11,1,NULL,NULL),(12,12,5,NULL,NULL),(13,13,3,NULL,NULL),(14,14,4,NULL,NULL),(15,15,1,NULL,NULL),(16,16,5,NULL,NULL),(17,17,5,NULL,NULL),(18,18,6,NULL,NULL),(19,19,6,NULL,NULL),(20,20,2,NULL,NULL),(21,21,1,NULL,NULL),(22,22,1,NULL,NULL),(23,23,1,NULL,NULL),(24,24,1,NULL,NULL),(25,25,1,NULL,NULL),(26,26,3,NULL,NULL),(27,27,5,NULL,NULL),(28,28,5,NULL,NULL),(29,29,5,NULL,NULL),(30,30,3,NULL,NULL),(31,31,2,NULL,NULL),(32,32,1,NULL,NULL),(33,33,5,NULL,NULL),(34,34,1,NULL,NULL),(35,35,5,NULL,NULL),(36,36,6,NULL,NULL),(37,37,4,NULL,NULL),(38,38,3,NULL,NULL),(39,39,6,NULL,NULL),(40,40,5,NULL,NULL),(41,41,2,NULL,NULL),(42,42,6,NULL,NULL),(43,43,3,NULL,NULL),(44,44,3,NULL,NULL),(45,45,5,NULL,NULL),(46,46,5,NULL,NULL),(47,47,6,NULL,NULL),(48,48,1,NULL,NULL),(49,49,5,NULL,NULL),(50,50,3,NULL,NULL),(51,51,1,NULL,NULL),(52,52,4,NULL,NULL),(53,53,3,NULL,NULL),(54,54,5,NULL,NULL),(55,55,4,NULL,NULL),(56,56,5,NULL,NULL),(57,57,6,NULL,NULL),(58,58,3,NULL,NULL),(59,59,5,NULL,NULL),(60,60,5,NULL,NULL),(61,61,3,NULL,NULL),(62,62,1,NULL,NULL),(63,63,4,NULL,NULL),(64,64,4,NULL,NULL),(65,65,3,NULL,NULL),(66,66,5,NULL,NULL),(67,67,4,NULL,NULL),(68,68,2,NULL,NULL),(69,69,6,NULL,NULL),(70,70,1,NULL,NULL),(71,71,3,NULL,NULL),(72,72,1,NULL,NULL),(73,73,4,NULL,NULL),(74,74,6,NULL,NULL),(75,75,4,NULL,NULL),(76,76,4,NULL,NULL),(77,77,4,NULL,NULL),(78,78,3,NULL,NULL),(79,79,3,NULL,NULL),(80,80,1,NULL,NULL),(81,81,2,NULL,NULL),(82,82,2,NULL,NULL),(83,83,2,NULL,NULL),(84,84,2,NULL,NULL),(85,85,1,NULL,NULL),(86,86,1,NULL,NULL),(87,87,6,NULL,NULL),(88,88,4,NULL,NULL),(89,89,4,NULL,NULL),(90,90,3,NULL,NULL),(91,91,3,NULL,NULL),(92,92,1,NULL,NULL),(93,93,2,NULL,NULL),(94,94,2,NULL,NULL),(95,95,1,NULL,NULL),(96,96,5,NULL,NULL),(97,97,6,NULL,NULL),(98,98,3,NULL,NULL),(99,99,1,NULL,NULL),(100,100,5,NULL,NULL);
/*!40000 ALTER TABLE `cr_cars_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_translations`
--

DROP TABLE IF EXISTS `cr_cars_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_cars_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_cars_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_translations`
--

LOCK TABLES `cr_cars_translations` WRITE;
/*!40000 ALTER TABLE `cr_cars_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_cars_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_category_commissions`
--

DROP TABLE IF EXISTS `cr_category_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_category_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_category_commissions`
--

LOCK TABLES `cr_category_commissions` WRITE;
/*!40000 ALTER TABLE `cr_category_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_category_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_coupons`
--

DROP TABLE IF EXISTS `cr_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` double NOT NULL,
  `is_unlimited_expires` tinyint NOT NULL DEFAULT '0',
  `expires_at` datetime DEFAULT NULL,
  `is_unlimited` tinyint NOT NULL DEFAULT '1',
  `limit` int NOT NULL DEFAULT '0',
  `used` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_coupons_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_coupons`
--

LOCK TABLES `cr_coupons` WRITE;
/*!40000 ALTER TABLE `cr_coupons` DISABLE KEYS */;
INSERT INTO `cr_coupons` VALUES (1,'gWrpvK4i8BjI','money',6,0,'2025-12-18 04:12:06',1,0,107,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'u9h2VScs9Mao','money',2,0,'2026-01-18 04:12:06',0,874,111,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'IVsxtvyUF7lX','money',5,1,NULL,0,834,78,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'MlSZ0GQfsSHW','percentage',66.98,1,NULL,1,0,112,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'6ogeiNgUO0wE','percentage',44.64,1,NULL,0,178,45,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'mkJy0xAi2cO7','money',7,1,NULL,0,686,66,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(7,'i4kyYPlSzN1v','money',8,0,'2026-02-18 04:12:06',0,403,28,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(8,'ZMd2iR3JYJxh','money',8,1,NULL,0,521,90,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(9,'SJ0sxwC36cjO','percentage',67.1,1,NULL,1,0,116,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(10,'dbXMwYinTiWE','percentage',89.33,1,NULL,1,0,19,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(11,'ahI4txNgGJvU','money',7,0,'2026-03-18 04:12:06',0,535,71,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(12,'ExGoX7PDut0D','money',0,0,'2026-04-18 04:12:06',0,157,58,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(13,'AW0Q8RxK6X6F','percentage',59.94,1,NULL,1,0,57,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(14,'7uVgJsbS0Luo','percentage',81.9,0,'2026-05-18 04:12:06',0,382,18,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(15,'u1xwdKsCLscx','money',9,0,'2026-06-18 04:12:06',1,0,51,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(16,'PqCnj8woZcwP','money',2,1,NULL,1,0,26,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(17,'l0gurwmz5llI','money',3,0,'2026-07-18 04:12:06',1,0,106,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(18,'tUOQ5YakfGF3','money',4,0,'2026-08-18 04:12:06',0,885,85,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(19,'KPrU1Qp3TzZk','money',0,0,'2026-09-18 04:12:06',1,0,34,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(20,'kd0u6FomJaNV','money',7,1,NULL,1,0,130,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(21,'UEYqIXBWmNzy','percentage',26.87,0,'2026-10-18 04:12:06',1,0,66,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(22,'UBhGO5ifL5Nd','percentage',84.28,0,'2026-11-18 04:12:06',0,747,111,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(23,'jXfb64vLQ7ST','percentage',12.94,1,NULL,0,117,35,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(24,'KpbJWeG8ZsQ8','percentage',28.1,1,NULL,1,0,124,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(25,'2LvAu4PY4IMs','money',0,0,'2026-12-18 04:12:06',1,0,117,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(26,'gC8Yzj0AHHAD','money',0,0,'2027-01-18 04:12:06',0,877,84,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(27,'nSBtvByI1ZRg','money',1,1,NULL,0,121,43,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(28,'jXqIMQHvHeYE','money',6,0,'2027-02-18 04:12:06',1,0,21,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(29,'UmIfm2WyBsME','money',3,0,'2027-03-18 04:12:06',1,0,110,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(30,'c4eV45l3BfyE','percentage',48.47,1,NULL,1,0,117,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(31,'VDGi1hCC3PcP','percentage',38.87,1,NULL,0,899,23,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_currencies`
--

DROP TABLE IF EXISTS `cr_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `number_format_style` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'western',
  `space_between_price_and_currency` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_currencies`
--

LOCK TABLES `cr_currencies` WRITE;
/*!40000 ALTER TABLE `cr_currencies` DISABLE KEYS */;
INSERT INTO `cr_currencies` VALUES (1,'USD','$',1,0,0,1,1,'western',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'EUR','€',0,0,1,0,0.84,'western',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'VND','₫',0,0,2,0,23203,'western',0,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'NGN','₦',1,0,2,0,895.52,'western',0,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_password_resets`
--

DROP TABLE IF EXISTS `cr_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `cr_customer_password_resets_email_index` (`email`),
  KEY `cr_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_password_resets`
--

LOCK TABLES `cr_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `cr_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_revenues`
--

DROP TABLE IF EXISTS `cr_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `booking_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) NOT NULL,
  `fee` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `current_balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add-amount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_revenues`
--

LOCK TABLES `cr_customer_revenues` WRITE;
/*!40000 ALTER TABLE `cr_customer_revenues` DISABLE KEYS */;
INSERT INTO `cr_customer_revenues` VALUES (1,8,2,180.00,36.00,144.00,144.00,'USD','Earnings from booking ##1000003 for Smart EQ fortwo Prime 2024',NULL,'booking-completed','2025-10-10 21:12:53','2025-10-10 21:12:53'),(2,19,6,30.00,6.00,24.00,24.00,'USD','Earnings from booking ##1000007 for Dodge Challenger R/T Scat Pack 2024',NULL,'booking-completed','2025-10-12 21:12:53','2025-10-12 21:12:53'),(3,32,7,120.00,24.00,96.00,96.00,'USD','Earnings from booking ##1000008 for Nissan Rogue Platinum AWD 2024',NULL,'booking-completed','2025-10-06 21:12:53','2025-10-06 21:12:53'),(4,16,11,450.00,90.00,360.00,360.00,'USD','Earnings from booking ##1000012 for BMW M4 Competition xDrive 2024',NULL,'booking-completed','2025-10-27 21:12:53','2025-10-27 21:12:53'),(5,18,14,188.00,37.60,150.40,150.40,'USD','Earnings from booking ##1000015 for BMW X7 xDrive40i M Sport 2024',NULL,'booking-completed','2025-10-06 21:12:54','2025-10-06 21:12:54'),(6,14,16,301.00,60.20,240.80,240.80,'USD','Earnings from booking ##1000017 for Audi RS Q8 quattro 2024',NULL,'booking-completed','2025-10-12 21:12:54','2025-10-12 21:12:54'),(7,7,21,378.00,75.60,302.40,302.40,'USD','Earnings from booking ##1000022 for Honda CR-V Touring Hybrid AWD 2024',NULL,'booking-completed','2025-10-04 21:12:54','2025-10-04 21:12:54'),(8,15,22,86.40,17.28,69.12,69.12,'USD','Earnings from booking ##1000023 for Chevrolet Camaro SS 1LE 2024',NULL,'booking-completed','2025-10-27 21:12:54','2025-10-27 21:12:54'),(9,1,24,62.00,12.40,49.60,49.60,'USD','Earnings from booking ##1000025 for Genesis Electrified GV70 Advanced AWD 2024',NULL,'booking-completed','2025-11-08 21:12:54','2025-11-08 21:12:54'),(10,6,25,534.60,106.92,427.68,427.68,'USD','Earnings from booking ##1000026 for McLaren 720S Spider 2024',NULL,'booking-completed','2025-10-17 21:12:54','2025-10-17 21:12:54'),(11,8,26,324.00,64.80,259.20,403.20,'USD','Earnings from booking ##1000027 for Smart EQ fortwo Prime 2024',NULL,'booking-completed','2025-10-21 21:12:54','2025-10-21 21:12:54'),(12,1,27,31.00,6.20,24.80,74.40,'USD','Earnings from booking ##1000028 for Genesis Electrified GV70 Advanced AWD 2024',NULL,'booking-completed','2025-10-24 21:12:54','2025-10-24 21:12:54'),(13,7,33,252.00,50.40,201.60,504.00,'USD','Earnings from booking ##1000034 for Honda CR-V Touring Hybrid AWD 2024',NULL,'booking-completed','2025-11-15 21:12:54','2025-11-15 21:12:54'),(14,18,36,57.60,11.52,46.08,196.48,'USD','Earnings from booking ##1000037 for Audi R8 V10 Performance 2024',NULL,'booking-completed','2025-11-16 21:12:54','2025-11-16 21:12:54'),(15,18,37,376.00,75.20,300.80,497.28,'USD','Earnings from booking ##1000038 for BMW X7 xDrive40i M Sport 2024',NULL,'booking-completed','2025-11-16 21:12:54','2025-11-16 21:12:54'),(16,2,43,189.00,37.80,151.20,151.20,'USD','Earnings from booking ##1000044 for BMW XM Label Red 2024',NULL,'booking-completed','2025-11-13 21:12:54','2025-11-13 21:12:54'),(17,10,47,210.00,42.00,168.00,168.00,'USD','Earnings from booking ##1000048 for Mazda CX-5 2.5 Turbo Signature AWD 2024',NULL,'booking-completed','2025-11-15 21:12:54','2025-11-15 21:12:54');
/*!40000 ALTER TABLE `cr_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_withdrawals`
--

DROP TABLE IF EXISTS `cr_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `fee` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `current_balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_withdrawals`
--

LOCK TABLES `cr_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `cr_customer_withdrawals` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customers`
--

DROP TABLE IF EXISTS `cr_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `is_verified` tinyint(1) NOT NULL DEFAULT '0',
  `verified_at` timestamp NULL DEFAULT NULL,
  `verified_by` bigint unsigned DEFAULT NULL,
  `verification_note` text COLLATE utf8mb4_unicode_ci,
  `vendor_verified_at` datetime DEFAULT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `bank_info` json DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customers`
--

LOCK TABLES `cr_customers` WRITE;
/*!40000 ALTER TABLE `cr_customers` DISABLE KEYS */;
INSERT INTO `cr_customers` VALUES (1,'Elite Auto Group','htromp@batz.com','$2y$12$5kyrNA3sDo1DjvpH8/r9N.ikqgn9ojebjzFxuTgBIZ6LLahym.ZYy','customers/12.jpg','+14349216796','+14349216796',NULL,'published',NULL,'2025-11-18 04:11:58',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-10-16 22:08:36',1,'Trusted automotive partner','2025-04-18 21:54:04',74.40,NULL,NULL),(2,'Premier Motors','ansley37@barton.info','$2y$12$y5ioBeYJldSKzM7u6.mgkOeMTz8t7Vx8LqIcxfkfTem5Yo.MD0wwC','customers/13.jpg','+15519499639','+15519499639',NULL,'published',NULL,'2025-11-18 04:11:59',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-11-08 18:30:29',1,'Trusted automotive partner','2025-05-15 05:01:36',151.20,NULL,NULL),(3,'Luxury Car Rentals','earline70@wilkinson.com','$2y$12$7ygblElxIfeUzfpr0gTZ1enRC.sm.m393de5fkc1DLiFgkg3mWq/i','customers/14.jpg','+15518585727','+15518585727',NULL,'published',NULL,'2025-11-18 04:11:59',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-07-27 02:19:38',1,'Premium vendor account','2025-09-09 13:44:51',0.00,NULL,NULL),(4,'City Drive Solutions','weissnat.rodrigo@fay.com','$2y$12$tGTbJm6We5alfCTZ7e9zGOqpXa3qWp0ANGfaYmUSk5LwIx99dLF66','customers/15.jpg','+17548037011','+17548037011',NULL,'published',NULL,'2025-11-18 04:11:59',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-09-08 06:43:36',1,'Premium vendor account','2025-04-16 04:22:20',0.00,NULL,NULL),(5,'Express Auto Dealers','guadalupe38@lubowitz.com','$2y$12$wix77pSUtnGTHO1mWqNtY.vcNYYJxdTUDzzdF8F6HDxtkzqYVqqjG','customers/16.jpg','+17609785882','+17609785882',NULL,'published',NULL,'2025-11-18 04:11:59',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-06-26 06:07:37',1,'Authorized car dealer','2025-06-27 17:53:59',0.00,NULL,NULL),(6,'Summit Car Company','pagac.jarrod@mosciski.com','$2y$12$76AxXw02qO1l1J7PtlC7hewqqvCNuTw5j4Em7yw3Y5ny5qUaNj9I.','customers/17.jpg','+14587645860','+14587645860',NULL,'published',NULL,'2025-11-18 04:12:00',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-09-21 07:41:47',1,'Trusted automotive partner','2025-07-23 20:35:13',427.68,NULL,NULL),(7,'Horizon Automotive','ysmitham@yundt.biz','$2y$12$dPE1oB5GMQz/eSevOEMapOe38i7Pv78vhhFTVoH3uAOrg54FT/5fO','customers/18.jpg','+18592316640','+18592316640',NULL,'published',NULL,'2025-11-18 04:12:00',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-09-09 00:03:23',1,'Certified dealer','2024-12-16 03:43:32',504.00,NULL,NULL),(8,'Prestige Vehicles','hermiston.sandra@armstrong.com','$2y$12$LEUUfKv30GOpCAdqSJjcneIEsHDXljjtDYwecAfhzfb30HeRF2DLm','customers/19.jpg','+17313611740','+17313611740',NULL,'published',NULL,'2025-11-18 04:12:00',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-10-15 23:29:01',1,'Premium vendor account','2025-08-12 17:57:38',403.20,NULL,NULL),(9,'Metro Car Center','dalton50@reinger.com','$2y$12$beJp50jOkc0JZ.jNP3u8w.d49p/0UGtmMwnwgpox4N2X199opsBDu','customers/20.jpg','+17372994634','+17372994634',NULL,'published',NULL,'2025-11-18 04:12:00',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-08-18 06:19:02',1,'Authorized car dealer','2025-04-14 19:10:10',0.00,NULL,NULL),(10,'Global Auto Partners','kuhlman.ted@schowalter.com','$2y$12$JEzO/xbSrK2PSCHmmt2D9unO5efSNgndiXxgR.A6wu9dPELh7zgmC','customers/21.jpg','+16319500700','+16319500700',NULL,'published',NULL,'2025-11-18 04:12:01',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,0,NULL,NULL,NULL,NULL,168.00,NULL,NULL),(11,'Royal Motors Group','mollie.schuster@schamberger.org','$2y$12$fc/hnBweVkcR1snoCJCyzuICPcpoJSbvjgg5QqKPfvfz71eMnPRPq','customers/22.jpg','+12312021037','+12312021037',NULL,'published',NULL,'2025-11-18 04:12:01',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(12,'Diamond Car Dealers','cordia.torphy@windler.net','$2y$12$hiDVrFtucr/jsPATzP4MuO02zEoEMQgmtbxN1LM0g0cz5kuxPoaq.','customers/23.jpg','+15855941212','+15855941212',NULL,'published',NULL,'2025-11-18 04:12:01',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-10-15 06:15:59',1,'Trusted automotive partner','2025-01-04 10:18:32',0.00,NULL,NULL),(13,'Pacific Auto Sales','pagac.tad@balistreri.com','$2y$12$ymziUlYZdCqNyyn28xjbfukEmk8bIkmBrktigOp86V4dm3KgqIvuO','customers/24.jpg','+13017818151','+13017818151',NULL,'published',NULL,'2025-11-18 04:12:01',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-07-16 00:37:45',1,'Premium vendor account','2025-10-09 21:02:49',0.00,NULL,NULL),(14,'Mountain View Motors','dveum@beer.com','$2y$12$V8IyD4PQY4rdEHbHFbxy3.EPV.KSbm/epQEkD4AI6K9awHQROONTu','customers/25.jpg','+19078690777','+19078690777',NULL,'published',NULL,'2025-11-18 04:12:01',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-09-20 12:58:44',1,'Premium vendor account','2025-05-08 15:19:38',240.80,NULL,NULL),(15,'Coastal Car Company','ollie.dubuque@bogan.com','$2y$12$OGnoKp3U7p3GpxGkXRJE1usxb.oplybyHQCrAS6v94JHXkbv2yIKi','customers/26.jpg','+14757374445','+14757374445',NULL,'published',NULL,'2025-11-18 04:12:02',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-08-28 06:03:43',1,'Certified dealer','2025-09-02 11:41:23',69.12,NULL,NULL),(16,'Central Auto Hub','omari74@aufderhar.biz','$2y$12$cHTrelChnZP5fOS6y7vJsuskv5hw7uHz4fTovNlPY.s84/ayKcYhK','customers/27.jpg','+12284785419','+12284785419',NULL,'published',NULL,'2025-11-18 04:12:02',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,0,NULL,NULL,NULL,NULL,360.00,NULL,NULL),(17,'Victory Automotive','kevin35@leffler.com','$2y$12$mTllJekt/545GpqUAHUBiuge7SyDihb68YL8DyjFKyjAunHl34ZT6','customers/28.jpg','+19158816649','+19158816649',NULL,'published',NULL,'2025-11-18 04:12:02',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(18,'Alliance Car Group','salvador.kuphal@muller.com','$2y$12$zbPYr/AvOBpL7E2Rde7BCuvDkvZuXT/uTPqAEul3cIOZUTnF0ys32','customers/29.jpg','+17544824787','+17544824787',NULL,'published',NULL,'2025-11-18 04:12:02',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:54',1,1,'2025-11-08 08:23:26',1,'Certified dealer','2025-07-14 23:30:01',497.28,NULL,NULL),(19,'Phoenix Motors','yhudson@harvey.info','$2y$12$kGpMqNLxQSE4AQuzuGYLs.4dAgB3NT7kKNtff2jfTzdsgwBZV94L.','customers/30.jpg','+13025350613','+13025350613',NULL,'published',NULL,'2025-11-18 04:12:03',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:53',1,0,NULL,NULL,NULL,NULL,24.00,NULL,NULL),(20,'Sterling Auto Sales','huel.berta@oconner.biz','$2y$12$ED3XKBmF8PIeiiTuml4tt.EGVh6KgZP9Rr4lJBofMx122C0zv6eYu','customers/31.jpg','+12088686828','+12088686828',NULL,'published',NULL,'2025-11-18 04:12:03',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',1,1,'2025-09-24 18:35:33',1,'Authorized car dealer','2025-03-05 07:57:34',0.00,NULL,NULL),(21,'Clint Terry','romaguera.emmitt@example.org','$2y$12$hBU.TIUu3CD4RffBZMkC4.bzPQ9aw0kLvYI98l0wmjNQtmzYrfUBm','customers/1.jpg','+17075976359','+17075976359',NULL,'published',NULL,'2025-11-18 04:12:03',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','$2y$12$6DeN0G/p0lhWJKleF3Lz7.ybQgtwv0hj5Kp6T1XpxS/qDXLezjt1G','customers/2.jpg','+14845841969','+14845841969',NULL,'published',NULL,'2025-11-18 04:12:03',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-11-03 23:55:28',1,'Verified customer - regular client',NULL,0.00,NULL,NULL),(23,'Bobby Hintz','trystan.wisozk@example.net','$2y$12$vCjOUL1F/RPxpS1QLlc5qOj7ZZd1T9yhr.KDf2Pwrh9ss19BFWYUO','customers/3.jpg','+14143442961','+14143442961',NULL,'published',NULL,'2025-11-18 04:12:04',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-11-06 11:13:59',1,'Verified customer - regular client',NULL,0.00,NULL,NULL),(24,'Scot Baumbach Jr.','moore.dennis@example.net','$2y$12$5XLd7iJXfCUOvbcCOsz5b.p6tzqk43iy56YO0zeLAbo4EgsN6vGMK','customers/4.jpg','+18315405351','+18315405351',NULL,'published',NULL,'2025-11-18 04:12:04',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-07-24 09:53:18',1,'Documents verified successfully',NULL,0.00,NULL,NULL),(25,'Joelle McClure II','schroeder.davion@example.net','$2y$12$jIhnTr5sn7ExD4Buyeh3guJYeEiTOQqixpXAibKik7etLum3bEmJ2','customers/5.jpg','+18624541003','+18624541003',NULL,'published',NULL,'2025-11-18 04:12:04',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-09-27 14:40:56',1,'Trusted customer',NULL,0.00,NULL,NULL),(26,'Barbara Goldner','justine.raynor@example.com','$2y$12$NIfgLDtB7wwXpYaLmoPesuA804B2flxr4AzYN7kE9.cpPmpvNR4qW','customers/6.jpg','+14099364802','+14099364802',NULL,'published',NULL,'2025-11-18 04:12:04',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(27,'Nona Swaniawski','fromaguera@example.com','$2y$12$7WyIuRHRhZiAaD9bx4YzYOSl5UC1f0OEdlwSGRIqVDsVtKwjrNGKm','customers/7.jpg','+17328589848','+17328589848',NULL,'published',NULL,'2025-11-18 04:12:05',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-10-26 09:10:08',1,'Trusted customer',NULL,0.00,NULL,NULL),(28,'Clifford Corkery','fdenesik@example.net','$2y$12$SrhHc8.PhF3w13CN2CHUq.wI0MqNKKwDRghR8Uwtcq55/YDW91OYC','customers/8.jpg','+14122179291','+14122179291',NULL,'published',NULL,'2025-11-18 04:12:05',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-11-08 15:40:40',1,'Identity confirmed',NULL,0.00,NULL,NULL),(29,'Karlee Ruecker Jr.','alvis35@example.com','$2y$12$BKyjU.DQNd8BYOH3foUcyOVaIofY3RhPM6gush9AauxA/uz/kBnJK','customers/9.jpg','+13515620213','+13515620213',NULL,'published',NULL,'2025-11-18 04:12:05',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-08-17 07:43:42',1,'Identity confirmed',NULL,0.00,NULL,NULL),(30,'Desmond Morissette','winifred.ferry@example.org','$2y$12$dQC54I0WG9U4nhTZW6.SqeqKyzsi/UV1IHbCLa7mdZh7oJmFh9NPi','customers/10.jpg','+13809239578','+13809239578',NULL,'published',NULL,'2025-11-18 04:12:05',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,1,'2025-06-01 05:01:31',1,'Verified through government ID',NULL,0.00,NULL,NULL),(31,'Jorge Cole','customer@botble.com','$2y$12$KXrifSUsPLNniPB9FQe1Oebu0lOZ3GQkKF5SDHlUHfjxuT29UmWl2','customers/2.jpg','+12027539334','+12027539334',NULL,'published',NULL,'2025-11-18 04:12:05',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:06',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(32,'Lane Bernier','vendor@botble.com','$2y$12$3E50gQvqcU5TRIkoFL.xkeNa/bcyDzlwlDAYDQijiQG52grY5KSWa','customers/2.jpg','+18639644977','+18639644977',NULL,'published',NULL,'2025-11-18 04:12:06',NULL,'2025-11-17 21:12:06','2025-11-17 21:12:53',1,1,'2025-10-29 01:59:43',1,'Verified vendor account','2025-10-16 10:10:27',96.00,NULL,NULL);
/*!40000 ALTER TABLE `cr_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_invoice_items`
--

DROP TABLE IF EXISTS `cr_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_invoice_items`
--

LOCK TABLES `cr_invoice_items` WRITE;
/*!40000 ALTER TABLE `cr_invoice_items` DISABLE KEYS */;
INSERT INTO `cr_invoice_items` VALUES (1,1,'Porsche Cayenne Turbo GT 2024','',1,90.00,0.00,0.00,90.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(2,2,'Smart EQ fortwo Prime 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(3,3,'Mazda MX-5 Miata Grand Touring 2024','',1,448.00,0.00,0.00,448.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(4,4,'Bentley Continental GT V8 2024','',1,315.00,0.00,0.00,315.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(5,5,'Ferrari F8 Tributo 2024','',1,81.00,0.00,0.00,81.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(6,6,'Dodge Challenger R/T Scat Pack 2024','',1,30.00,0.00,0.00,30.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(7,7,'Nissan Rogue Platinum AWD 2024','',1,120.00,0.00,0.00,120.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(8,8,'Fiat 500X Sport AWD 2024','',1,240.00,0.00,0.00,240.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(9,9,'Bentley Bentayga S V8 2024','',1,130.00,0.00,0.00,130.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(10,10,'Tesla Model S Plaid 2024','',1,225.00,0.00,0.00,225.00,'2025-11-17 21:12:53','2025-11-17 21:12:53'),(11,11,'BMW M4 Competition xDrive 2024','',1,450.00,0.00,0.00,450.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(12,12,'Dodge Challenger R/T Scat Pack 2024','',1,210.00,0.00,0.00,210.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(13,13,'Rivian R1S Adventure 2024','',1,400.00,0.00,0.00,400.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(14,14,'BMW X7 xDrive40i M Sport 2024','',1,188.00,0.00,0.00,188.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(15,15,'Ford Explorer ST 4WD 2024','',1,74.00,0.00,0.00,74.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(16,16,'Audi RS Q8 quattro 2024','',1,301.00,0.00,0.00,301.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(17,17,'Mini Cooper S Hardtop 2024','',1,217.00,0.00,0.00,217.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(18,18,'Fiat 500X Sport AWD 2024','',1,192.00,0.00,0.00,192.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(19,19,'Lucid Air Grand Touring Performance 2024','',1,48.00,0.00,0.00,48.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(20,20,'Mercedes-Benz G550 4MATIC 2024','',1,66.00,0.00,0.00,66.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(21,21,'Honda CR-V Touring Hybrid AWD 2024','',1,420.00,0.00,0.00,420.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(22,22,'Chevrolet Camaro SS 1LE 2024','',1,96.00,0.00,0.00,96.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(23,23,'McLaren GT Luxe 2024','',1,61.00,0.00,0.00,61.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(24,24,'Genesis Electrified GV70 Advanced AWD 2024','',1,62.00,0.00,0.00,62.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(25,25,'McLaren 720S Spider 2024','',1,594.00,0.00,0.00,594.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(26,26,'Smart EQ fortwo Prime 2024','',1,360.00,0.00,0.00,360.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(27,27,'Genesis Electrified GV70 Advanced AWD 2024','',1,31.00,0.00,0.00,31.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(28,28,'Cadillac XT5 Premium Luxury AWD 2024','',1,174.00,0.00,0.00,174.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(29,29,'Pagani Huayra Roadster BC 2024','',1,455.00,0.00,0.00,455.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(30,30,'Toyota Camry XLE Hybrid 2024','',1,228.00,0.00,0.00,228.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(31,31,'Hyundai Sonata N Line 2024','',1,300.00,0.00,0.00,300.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(32,32,'Mazda CX-5 2.5 Turbo Signature AWD 2024','',1,42.00,0.00,0.00,42.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(33,33,'Honda CR-V Touring Hybrid AWD 2024','',1,252.00,0.00,0.00,252.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(34,34,'McLaren Artura Spider 2024','',1,270.00,0.00,0.00,270.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(35,35,'Bentley Continental GT V8 2024','',1,126.00,0.00,0.00,126.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(36,36,'Audi R8 V10 Performance 2024','',1,64.00,0.00,0.00,64.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(37,37,'BMW X7 xDrive40i M Sport 2024','',1,376.00,0.00,0.00,376.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(38,38,'Lamborghini Urus Performante 2024','',1,292.00,0.00,0.00,292.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(39,39,'Koenigsegg Jesko Absolut 2024','',1,294.00,0.00,0.00,294.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(40,40,'Alfa Romeo Stelvio Veloce AWD 2024','',1,243.00,0.00,0.00,243.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(41,41,'Smart EQ fortwo Prime 2024','',1,420.00,0.00,0.00,420.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(42,42,'Audi A4 Premium Plus quattro 2024','',1,189.00,0.00,0.00,189.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(43,43,'BMW XM Label Red 2024','',1,189.00,0.00,0.00,189.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(44,44,'Audi RS Q8 quattro 2024','',1,86.00,0.00,0.00,86.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(45,45,'Volkswagen Tiguan SEL R-Line 2024','',1,268.00,0.00,0.00,268.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(46,46,'Infiniti QX60 Autograph AWD 2024','',1,186.00,0.00,0.00,186.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(47,47,'Mazda CX-5 2.5 Turbo Signature AWD 2024','',1,210.00,0.00,0.00,210.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(48,48,'Koenigsegg Jesko Absolut 2024','',1,147.00,0.00,0.00,147.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(49,49,'Honda Accord Sport 2.0T 2024','',1,294.00,0.00,0.00,294.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(50,50,'Honda Accord Sport 2.0T 2024','',1,490.00,0.00,0.00,490.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(51,51,'Toyota Corolla Hybrid LE 2024','',1,462.00,0.00,0.00,462.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(52,52,'Aston Martin Vantage F1 Edition 2024','',1,275.00,0.00,0.00,275.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(53,53,'Mazda CX-5 2.5 Turbo Signature AWD 2024','',1,252.00,0.00,0.00,252.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(54,54,'Mercedes-Benz GLC 300 4MATIC 2024','',1,245.00,0.00,0.00,245.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(55,55,'BMW XM Label Red 2024','',1,189.00,0.00,0.00,189.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(56,56,'Infiniti Q50 Red Sport 400 AWD 2024','',1,183.00,0.00,0.00,183.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(57,57,'Audi R8 V10 Performance 2024','',1,32.00,0.00,0.00,32.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(58,58,'Tesla Model S Plaid 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(59,59,'Bentley Bentayga S V8 2024','',1,455.00,0.00,0.00,455.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(60,60,'Range Rover Sport HSE Dynamic 2024','',1,300.00,0.00,0.00,300.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(61,61,'Ferrari Roma Spider 2024','',1,30.00,0.00,0.00,30.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(62,62,'Audi A4 Premium Plus quattro 2024','',1,126.00,0.00,0.00,126.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(63,63,'Acura TLX Type S PMC Edition 2024','',1,623.00,0.00,0.00,623.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(64,64,'Ferrari F8 Tributo 2024','',1,243.00,0.00,0.00,243.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(65,65,'Chevrolet Corvette Z06 3LZ 2024','',1,480.00,0.00,0.00,480.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(66,66,'Volkswagen Atlas Cross Sport SEL Premium 2024','',1,235.00,0.00,0.00,235.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(67,67,'Audi RS Q8 quattro 2024','',1,129.00,0.00,0.00,129.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(68,68,'Toyota RAV4 Prime XSE AWD 2024','',1,219.00,0.00,0.00,219.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(69,69,'Lamborghini Urus Performante 2024','',1,511.00,0.00,0.00,511.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(70,70,'Pagani Huayra Roadster BC 2024','',1,273.00,0.00,0.00,273.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(71,71,'Mazda CX-5 2.5 Turbo Signature AWD 2024','',1,252.00,0.00,0.00,252.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(72,72,'Audi RS Q8 quattro 2024','',1,301.00,0.00,0.00,301.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(73,73,'Volkswagen Atlas Cross Sport SEL Premium 2024','',1,47.00,0.00,0.00,47.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(74,74,'Mini Cooper S Hardtop 2024','',1,186.00,0.00,0.00,186.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(75,75,'Chevrolet Camaro SS 1LE 2024','',1,64.00,0.00,0.00,64.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(76,76,'Porsche Macan S 2024','',1,438.00,0.00,0.00,438.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(77,77,'Ferrari Roma Spider 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:12:54','2025-11-17 21:12:54'),(78,78,'Bentley Bentayga S V8 2024','',1,455.00,0.00,0.00,455.00,'2025-11-17 21:12:55','2025-11-17 21:12:55'),(79,79,'Ford GT Heritage Edition 2024','',1,34.00,0.00,0.00,34.00,'2025-11-17 21:12:55','2025-11-17 21:12:55'),(80,80,'Nissan GT-R NISMO Special Edition 2024','',1,126.00,0.00,0.00,126.00,'2025-11-17 21:12:55','2025-11-17 21:12:55');
/*!40000 ALTER TABLE `cr_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_invoices`
--

DROP TABLE IF EXISTS `cr_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` double NOT NULL,
  `tax_amount` double NOT NULL DEFAULT '0',
  `discount_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_invoices_code_unique` (`code`),
  KEY `cr_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `cr_invoices_payment_id_index` (`payment_id`),
  KEY `cr_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_invoices`
--

LOCK TABLES `cr_invoices` WRITE;
/*!40000 ALTER TABLE `cr_invoices` DISABLE KEYS */;
INSERT INTO `cr_invoices` VALUES (1,29,'Karlee Ruecker Jr.','alvis35@example.com','+13515620213',1,1,'Botble\\CarRentals\\Models\\Booking',1,'INV-1',90,9,0,90,'pending',NULL,'2025-10-08 21:12:53','2025-11-17 21:12:53',7),(2,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',2,1,'Botble\\CarRentals\\Models\\Booking',2,'INV-2',180,0,0,180,'completed','2025-11-17 21:12:53','2025-10-10 21:12:53','2025-11-17 21:12:53',8),(3,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',3,1,'Botble\\CarRentals\\Models\\Booking',3,'INV-3',448,0,0,448,'pending',NULL,'2025-11-15 21:12:53','2025-11-17 21:12:53',15),(4,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',4,1,'Botble\\CarRentals\\Models\\Booking',4,'INV-4',315,0,0,315,'pending',NULL,'2025-10-20 21:12:53','2025-11-17 21:12:53',8),(5,31,'Jorge Cole','customer@botble.com','+12027539334',5,1,'Botble\\CarRentals\\Models\\Booking',5,'INV-5',81,0,0,81,'pending',NULL,'2025-11-07 21:12:53','2025-11-17 21:12:53',4),(6,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',6,1,'Botble\\CarRentals\\Models\\Booking',6,'INV-6',30,0,0,30,'completed','2025-11-17 21:12:53','2025-10-12 21:12:53','2025-11-17 21:12:53',19),(7,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',7,1,'Botble\\CarRentals\\Models\\Booking',7,'INV-7',120,0,0,120,'completed','2025-11-17 21:12:53','2025-10-06 21:12:53','2025-11-17 21:12:53',32),(8,31,'Jorge Cole','customer@botble.com','+12027539334',8,1,'Botble\\CarRentals\\Models\\Booking',8,'INV-8',240,0,0,240,'completed','2025-11-17 21:12:53','2025-10-25 21:12:53','2025-11-17 21:12:53',NULL),(9,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',9,1,'Botble\\CarRentals\\Models\\Booking',9,'INV-9',130,0,0,130,'pending',NULL,'2025-11-13 21:12:53','2025-11-17 21:12:53',NULL),(10,28,'Clifford Corkery','fdenesik@example.net','+14122179291',10,1,'Botble\\CarRentals\\Models\\Booking',10,'INV-10',225,0,0,225,'pending',NULL,'2025-10-06 21:12:53','2025-11-17 21:12:53',NULL),(11,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',11,1,'Botble\\CarRentals\\Models\\Booking',11,'INV-11',450,0,0,450,'completed','2025-11-17 21:12:54','2025-10-27 21:12:53','2025-11-17 21:12:54',16),(12,26,'Barbara Goldner','justine.raynor@example.com','+14099364802',12,1,'Botble\\CarRentals\\Models\\Booking',12,'INV-12',210,21,0,210,'pending',NULL,'2025-10-06 21:12:54','2025-11-17 21:12:54',19),(13,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',13,1,'Botble\\CarRentals\\Models\\Booking',13,'INV-13',400,0,0,400,'pending',NULL,'2025-10-11 21:12:54','2025-11-17 21:12:54',7),(14,28,'Clifford Corkery','fdenesik@example.net','+14122179291',14,1,'Botble\\CarRentals\\Models\\Booking',14,'INV-14',188,0,0,188,'completed','2025-11-17 21:12:54','2025-10-06 21:12:54','2025-11-17 21:12:54',18),(15,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',15,1,'Botble\\CarRentals\\Models\\Booking',15,'INV-15',74,7.4,0,74,'pending',NULL,'2025-09-22 21:12:54','2025-11-17 21:12:54',4),(16,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',16,1,'Botble\\CarRentals\\Models\\Booking',16,'INV-16',301,0,0,301,'completed','2025-11-17 21:12:54','2025-10-12 21:12:54','2025-11-17 21:12:54',14),(17,28,'Clifford Corkery','fdenesik@example.net','+14122179291',17,1,'Botble\\CarRentals\\Models\\Booking',17,'INV-17',217,0,0,217,'pending',NULL,'2025-09-23 21:12:54','2025-11-17 21:12:54',2),(18,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',18,1,'Botble\\CarRentals\\Models\\Booking',18,'INV-18',192,0,0,192,'pending',NULL,'2025-10-27 21:12:54','2025-11-17 21:12:54',NULL),(19,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',19,1,'Botble\\CarRentals\\Models\\Booking',19,'INV-19',48,4.8,0,48,'completed','2025-11-17 21:12:54','2025-09-22 21:12:54','2025-11-17 21:12:54',NULL),(20,29,'Karlee Ruecker Jr.','alvis35@example.com','+13515620213',20,1,'Botble\\CarRentals\\Models\\Booking',20,'INV-20',66,6.6,0,66,'pending',NULL,'2025-09-20 21:12:54','2025-11-17 21:12:54',NULL),(21,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',21,1,'Botble\\CarRentals\\Models\\Booking',21,'INV-21',420,42,0,420,'completed','2025-11-17 21:12:54','2025-10-04 21:12:54','2025-11-17 21:12:54',7),(22,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',22,1,'Botble\\CarRentals\\Models\\Booking',22,'INV-22',96,9.6,0,96,'completed','2025-11-17 21:12:54','2025-10-27 21:12:54','2025-11-17 21:12:54',15),(23,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',23,1,'Botble\\CarRentals\\Models\\Booking',23,'INV-23',61,0,0,61,'pending',NULL,'2025-11-10 21:12:54','2025-11-17 21:12:54',9),(24,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',24,1,'Botble\\CarRentals\\Models\\Booking',24,'INV-24',62,0,0,62,'completed','2025-11-17 21:12:54','2025-11-08 21:12:54','2025-11-17 21:12:54',1),(25,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',25,1,'Botble\\CarRentals\\Models\\Booking',25,'INV-25',594,59.4,0,594,'completed','2025-11-17 21:12:54','2025-10-17 21:12:54','2025-11-17 21:12:54',6),(26,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',26,1,'Botble\\CarRentals\\Models\\Booking',26,'INV-26',360,36,0,360,'completed','2025-11-17 21:12:54','2025-10-21 21:12:54','2025-11-17 21:12:54',8),(27,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',27,1,'Botble\\CarRentals\\Models\\Booking',27,'INV-27',31,0,0,31,'completed','2025-11-17 21:12:54','2025-10-24 21:12:54','2025-11-17 21:12:54',1),(28,22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',28,1,'Botble\\CarRentals\\Models\\Booking',28,'INV-28',174,0,0,174,'completed','2025-11-17 21:12:54','2025-11-08 21:12:54','2025-11-17 21:12:54',NULL),(29,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',29,1,'Botble\\CarRentals\\Models\\Booking',29,'INV-29',455,45.5,0,455,'completed','2025-11-17 21:12:54','2025-09-22 21:12:54','2025-11-17 21:12:54',NULL),(30,26,'Barbara Goldner','justine.raynor@example.com','+14099364802',30,1,'Botble\\CarRentals\\Models\\Booking',30,'INV-30',228,22.8,0,228,'pending',NULL,'2025-09-20 21:12:54','2025-11-17 21:12:54',NULL),(31,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',31,1,'Botble\\CarRentals\\Models\\Booking',31,'INV-31',300,30,0,300,'pending',NULL,'2025-11-11 21:12:54','2025-11-17 21:12:54',1),(32,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',32,1,'Botble\\CarRentals\\Models\\Booking',32,'INV-32',42,0,0,42,'pending',NULL,'2025-11-11 21:12:54','2025-11-17 21:12:54',10),(33,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',33,1,'Botble\\CarRentals\\Models\\Booking',33,'INV-33',252,0,0,252,'completed','2025-11-17 21:12:54','2025-11-15 21:12:54','2025-11-17 21:12:54',7),(34,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',34,1,'Botble\\CarRentals\\Models\\Booking',34,'INV-34',270,0,0,270,'pending',NULL,'2025-11-12 21:12:54','2025-11-17 21:12:54',9),(35,29,'Karlee Ruecker Jr.','alvis35@example.com','+13515620213',35,1,'Botble\\CarRentals\\Models\\Booking',35,'INV-35',126,12.6,0,126,'pending',NULL,'2025-11-10 21:12:54','2025-11-17 21:12:54',8),(36,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',36,1,'Botble\\CarRentals\\Models\\Booking',36,'INV-36',64,6.4,0,64,'completed','2025-11-17 21:12:54','2025-11-16 21:12:54','2025-11-17 21:12:54',18),(37,22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',37,1,'Botble\\CarRentals\\Models\\Booking',37,'INV-37',376,0,0,376,'completed','2025-11-17 21:12:54','2025-11-16 21:12:54','2025-11-17 21:12:54',18),(38,29,'Karlee Ruecker Jr.','alvis35@example.com','+13515620213',38,1,'Botble\\CarRentals\\Models\\Booking',38,'INV-38',292,0,0,292,'pending',NULL,'2025-11-11 21:12:54','2025-11-17 21:12:54',NULL),(39,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',39,1,'Botble\\CarRentals\\Models\\Booking',39,'INV-39',294,0,0,294,'pending',NULL,'2025-11-13 21:12:54','2025-11-17 21:12:54',NULL),(40,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',40,1,'Botble\\CarRentals\\Models\\Booking',40,'INV-40',243,0,0,243,'pending',NULL,'2025-11-11 21:12:54','2025-11-17 21:12:54',NULL),(41,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',41,1,'Botble\\CarRentals\\Models\\Booking',41,'INV-41',420,0,0,420,'pending',NULL,'2025-11-13 21:12:54','2025-11-17 21:12:54',8),(42,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',42,1,'Botble\\CarRentals\\Models\\Booking',42,'INV-42',189,0,0,189,'pending',NULL,'2025-11-17 21:12:54','2025-11-17 21:12:54',18),(43,31,'Jorge Cole','customer@botble.com','+12027539334',43,1,'Botble\\CarRentals\\Models\\Booking',43,'INV-43',189,0,0,189,'completed','2025-11-17 21:12:54','2025-11-13 21:12:54','2025-11-17 21:12:54',2),(44,28,'Clifford Corkery','fdenesik@example.net','+14122179291',44,1,'Botble\\CarRentals\\Models\\Booking',44,'INV-44',86,8.6,0,86,'pending',NULL,'2025-11-11 21:12:54','2025-11-17 21:12:54',14),(45,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',45,1,'Botble\\CarRentals\\Models\\Booking',45,'INV-45',268,0,0,268,'pending',NULL,'2025-11-10 21:12:54','2025-11-17 21:12:54',9),(46,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',46,1,'Botble\\CarRentals\\Models\\Booking',46,'INV-46',186,0,0,186,'pending',NULL,'2025-11-10 21:12:54','2025-11-17 21:12:54',5),(47,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',47,1,'Botble\\CarRentals\\Models\\Booking',47,'INV-47',210,0,0,210,'completed','2025-11-17 21:12:54','2025-11-15 21:12:54','2025-11-17 21:12:54',10),(48,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',48,1,'Botble\\CarRentals\\Models\\Booking',48,'INV-48',147,0,0,147,'pending',NULL,'2025-11-15 21:12:54','2025-11-17 21:12:54',NULL),(49,22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',49,1,'Botble\\CarRentals\\Models\\Booking',49,'INV-49',294,0,0,294,'completed','2025-11-17 21:12:54','2025-11-15 21:12:54','2025-11-17 21:12:54',NULL),(50,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',50,1,'Botble\\CarRentals\\Models\\Booking',50,'INV-50',490,0,0,490,'pending',NULL,'2025-11-12 21:12:54','2025-11-17 21:12:54',NULL),(51,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',51,1,'Botble\\CarRentals\\Models\\Booking',51,'INV-51',462,0,0,462,'pending',NULL,'2025-11-25 21:12:54','2025-11-17 21:12:54',15),(52,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',52,1,'Botble\\CarRentals\\Models\\Booking',52,'INV-52',275,0,0,275,'pending',NULL,'2025-11-20 21:12:54','2025-11-17 21:12:54',12),(53,25,'Joelle McClure II','schroeder.davion@example.net','+18624541003',53,1,'Botble\\CarRentals\\Models\\Booking',53,'INV-53',252,0,0,252,'pending',NULL,'2025-11-30 21:12:54','2025-11-17 21:12:54',10),(54,29,'Karlee Ruecker Jr.','alvis35@example.com','+13515620213',54,1,'Botble\\CarRentals\\Models\\Booking',54,'INV-54',245,0,0,245,'pending',NULL,'2025-12-07 21:12:54','2025-11-17 21:12:54',32),(55,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',55,1,'Botble\\CarRentals\\Models\\Booking',55,'INV-55',189,0,0,189,'pending',NULL,'2025-11-28 21:12:54','2025-11-17 21:12:54',2),(56,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',56,1,'Botble\\CarRentals\\Models\\Booking',56,'INV-56',183,0,0,183,'pending',NULL,'2025-12-04 21:12:54','2025-11-17 21:12:54',18),(57,22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',57,1,'Botble\\CarRentals\\Models\\Booking',57,'INV-57',32,0,0,32,'pending',NULL,'2025-12-09 21:12:54','2025-11-17 21:12:54',18),(58,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',58,1,'Botble\\CarRentals\\Models\\Booking',58,'INV-58',180,0,0,180,'pending',NULL,'2025-12-11 21:12:54','2025-11-17 21:12:54',NULL),(59,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',59,1,'Botble\\CarRentals\\Models\\Booking',59,'INV-59',455,0,0,455,'pending',NULL,'2025-12-13 21:12:54','2025-11-17 21:12:54',NULL),(60,26,'Barbara Goldner','justine.raynor@example.com','+14099364802',60,1,'Botble\\CarRentals\\Models\\Booking',60,'INV-60',300,0,0,300,'pending',NULL,'2025-11-30 21:12:54','2025-11-17 21:12:54',NULL),(61,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',61,1,'Botble\\CarRentals\\Models\\Booking',61,'INV-61',30,0,0,30,'pending',NULL,'2025-12-05 21:12:54','2025-11-17 21:12:54',12),(62,26,'Barbara Goldner','justine.raynor@example.com','+14099364802',62,1,'Botble\\CarRentals\\Models\\Booking',62,'INV-62',126,0,0,126,'pending',NULL,'2025-11-22 21:12:54','2025-11-17 21:12:54',18),(63,22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',63,1,'Botble\\CarRentals\\Models\\Booking',63,'INV-63',623,62.3,0,623,'pending',NULL,'2025-12-09 21:12:54','2025-11-17 21:12:54',15),(64,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',64,1,'Botble\\CarRentals\\Models\\Booking',64,'INV-64',243,24.3,0,243,'pending',NULL,'2025-12-06 21:12:54','2025-11-17 21:12:54',4),(65,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',65,1,'Botble\\CarRentals\\Models\\Booking',65,'INV-65',480,0,0,480,'pending',NULL,'2025-12-07 21:12:54','2025-11-17 21:12:54',3),(66,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',66,1,'Botble\\CarRentals\\Models\\Booking',66,'INV-66',235,0,0,235,'pending',NULL,'2025-12-12 21:12:54','2025-11-17 21:12:54',20),(67,28,'Clifford Corkery','fdenesik@example.net','+14122179291',67,1,'Botble\\CarRentals\\Models\\Booking',67,'INV-67',129,0,0,129,'pending',NULL,'2025-12-09 21:12:54','2025-11-17 21:12:54',14),(68,27,'Nona Swaniawski','fromaguera@example.com','+17328589848',68,1,'Botble\\CarRentals\\Models\\Booking',68,'INV-68',219,21.9,0,219,'pending',NULL,'2025-11-19 21:12:54','2025-11-17 21:12:54',NULL),(69,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',69,1,'Botble\\CarRentals\\Models\\Booking',69,'INV-69',511,0,0,511,'pending',NULL,'2025-11-26 21:12:54','2025-11-17 21:12:54',NULL),(70,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',70,1,'Botble\\CarRentals\\Models\\Booking',70,'INV-70',273,0,0,273,'pending',NULL,'2025-12-07 21:12:54','2025-11-17 21:12:54',NULL),(71,29,'Karlee Ruecker Jr.','alvis35@example.com','+13515620213',71,1,'Botble\\CarRentals\\Models\\Booking',71,'INV-71',252,0,0,252,'pending',NULL,'2025-12-14 21:12:54','2025-11-17 21:12:54',10),(72,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',72,1,'Botble\\CarRentals\\Models\\Booking',72,'INV-72',301,0,0,301,'pending',NULL,'2025-11-18 21:12:54','2025-11-17 21:12:54',14),(73,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',73,1,'Botble\\CarRentals\\Models\\Booking',73,'INV-73',47,4.7,0,47,'pending',NULL,'2025-11-22 21:12:54','2025-11-17 21:12:54',20),(74,22,'Ms. Sonya Hilpert','keebler.ephraim@example.net','+14845841969',74,1,'Botble\\CarRentals\\Models\\Booking',74,'INV-74',186,0,0,186,'pending',NULL,'2025-11-29 21:12:54','2025-11-17 21:12:54',2),(75,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',75,1,'Botble\\CarRentals\\Models\\Booking',75,'INV-75',64,0,0,64,'pending',NULL,'2025-11-18 21:12:54','2025-11-17 21:12:54',15),(76,23,'Bobby Hintz','trystan.wisozk@example.net','+14143442961',76,1,'Botble\\CarRentals\\Models\\Booking',76,'INV-76',438,0,0,438,'pending',NULL,'2025-12-08 21:12:54','2025-11-17 21:12:54',9),(77,31,'Jorge Cole','customer@botble.com','+12027539334',77,1,'Botble\\CarRentals\\Models\\Booking',77,'INV-77',180,0,0,180,'pending',NULL,'2025-12-15 21:12:54','2025-11-17 21:12:54',12),(78,30,'Desmond Morissette','winifred.ferry@example.org','+13809239578',78,1,'Botble\\CarRentals\\Models\\Booking',78,'INV-78',455,0,0,455,'pending',NULL,'2025-11-24 21:12:54','2025-11-17 21:12:54',NULL),(79,21,'Clint Terry','romaguera.emmitt@example.org','+17075976359',79,1,'Botble\\CarRentals\\Models\\Booking',79,'INV-79',34,0,0,34,'pending',NULL,'2025-11-29 21:12:55','2025-11-17 21:12:55',NULL),(80,24,'Scot Baumbach Jr.','moore.dennis@example.net','+18315405351',80,1,'Botble\\CarRentals\\Models\\Booking',80,'INV-80',126,0,0,126,'pending',NULL,'2025-11-25 21:12:55','2025-11-17 21:12:55',NULL);
/*!40000 ALTER TABLE `cr_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_messages`
--

DROP TABLE IF EXISTS `cr_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_messages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_messages`
--

LOCK TABLES `cr_messages` WRITE;
/*!40000 ALTER TABLE `cr_messages` DISABLE KEYS */;
INSERT INTO `cr_messages` VALUES (1,NULL,28,'John Doe','johndoe@example.com','I would like to know more about your services.','192.168.1.1','2025-11-17 21:12:55','2025-11-17 21:12:55','123-456-7890','unread',20),(2,NULL,11,'Jane Smith','janesmith@example.com','Can you provide a quotation for the project?','192.168.1.2','2025-11-17 21:12:55','2025-11-17 21:12:55','987-654-3210','unread',NULL),(3,NULL,28,'Alice Brown','alicebrown@example.com','I am having an issue with my recent order.','192.168.1.3','2025-11-17 21:12:55','2025-11-17 21:12:55','555-666-7777','read',NULL),(4,NULL,10,'Bob Green','bobgreen@example.com','What are your business hours?','192.168.1.4','2025-11-17 21:12:55','2025-11-17 21:12:55','222-333-4444','read',1),(5,NULL,30,'Charlie White','charliewhite@example.com','I need assistance with your product.','192.168.1.5','2025-11-17 21:12:55','2025-11-17 21:12:55','333-444-5555','unread',NULL),(6,NULL,30,'Diana Blue','dianablue@example.com','Do you offer international shipping?','192.168.1.6','2025-11-17 21:12:55','2025-11-17 21:12:55','444-555-6666','unread',NULL),(7,NULL,21,'Edward Black','edwardblack@example.com','Can I schedule an appointment?','192.168.1.7','2025-11-17 21:12:55','2025-11-17 21:12:55','555-666-7778','read',16),(8,NULL,8,'Fiona Gray','fionagray@example.com','Your website is not loading for me.','192.168.1.8','2025-11-17 21:12:55','2025-11-17 21:12:55','666-777-8888','read',NULL),(9,NULL,16,'George Violet','georgeviolet@example.com','I want to change my order details.','192.168.1.9','2025-11-17 21:12:55','2025-11-17 21:12:55','777-888-9999','read',NULL),(10,NULL,32,'Hannah Pink','hannahpink@example.com','Can you send me a catalog of your products?','192.168.1.10','2025-11-17 21:12:55','2025-11-17 21:12:55','888-999-0000','read',32),(11,NULL,2,'Ian Orange','ianorange@example.com','Do you offer discounts for bulk purchases?','192.168.1.11','2025-11-17 21:12:55','2025-11-17 21:12:55','999-000-1111','unread',NULL),(12,NULL,17,'Jack Purple','jackpurple@example.com','I forgot my account password.','192.168.1.12','2025-11-17 21:12:55','2025-11-17 21:12:55','000-111-2222','read',NULL),(13,NULL,3,'Karen Yellow','karenyellow@example.com','Can you expedite my order?','192.168.1.13','2025-11-17 21:12:55','2025-11-17 21:12:55','111-222-3333','unread',10),(14,NULL,20,'Liam Red','liamred@example.com','Do you have a return policy?','192.168.1.14','2025-11-17 21:12:55','2025-11-17 21:12:55','222-333-4445','unread',NULL),(15,NULL,29,'Mia Silver','miasilver@example.com','Thank you for resolving my issue quickly.','192.168.1.15','2025-11-17 21:12:55','2025-11-17 21:12:55','333-444-5556','read',NULL),(16,NULL,8,'Noah Gold','noahgold@example.com','Can I get an invoice for my purchase?','192.168.1.16','2025-11-17 21:12:55','2025-11-17 21:12:55','444-555-6667','read',7),(17,NULL,15,'Olivia Bronze','oliviabronze@example.com','I would like to cancel my order.','192.168.1.17','2025-11-17 21:12:55','2025-11-17 21:12:55','555-666-7779','unread',NULL),(18,NULL,10,'Paul Amber','paulamber@example.com','Your support team is very helpful.','192.168.1.18','2025-11-17 21:12:55','2025-11-17 21:12:55','666-777-8889','read',NULL),(19,NULL,21,'Quinn Platinum','quinnplatinum@example.com','How do I track my shipment?','192.168.1.19','2025-11-17 21:12:55','2025-11-17 21:12:55','777-888-9990','read',19),(20,NULL,10,'Ruby Diamond','rubydiamond@example.com','Great service and prompt delivery!','192.168.1.20','2025-11-17 21:12:55','2025-11-17 21:12:55','888-999-0001','read',NULL);
/*!40000 ALTER TABLE `cr_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_services`
--

DROP TABLE IF EXISTS `cr_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_services` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `price` double unsigned NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned DEFAULT NULL,
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'once',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_services_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_services`
--

LOCK TABLES `cr_services` WRITE;
/*!40000 ALTER TABLE `cr_services` DISABLE KEYS */;
INSERT INTO `cr_services` VALUES (1,'Driver Rental Service','In addition to our car rental service, we offer professional drivers for hire. Enjoy a stress-free journey with our experienced drivers handling the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quidem atque qui illum eos assumenda vel. Quo vitae temporibus necessitatibus voluptates voluptates esse inventore. Eum ipsum omnis quaerat et distinctio nam. Aspernatur dolores unde incidunt aut mollitia. Eos enim necessitatibus in assumenda. Dignissimos blanditiis est dignissimos sint quia. Ut odio id saepe tempora voluptatem rerum.\" content_2=\"Nihil quisquam fugiat et nesciunt. Ut neque qui porro sed sunt distinctio omnis. Quos praesentium ducimus laudantium facilis. Ducimus est qui a explicabo vero et fugiat. Ut sapiente dolorem tempore eaque. Qui qui quo commodi cupiditate dolor. Totam ad magnam eveniet quaerat voluptatem. Eos sit autem suscipit assumenda. Et quo eius perspiciatis sint esse.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',161,NULL,'once','news/1.jpg','icons/lexus.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Oil Change Service','Keep your engine in top condition with our oil change service. Available as an add-on to any of our maintenance or repair services.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Corrupti ipsum cupiditate animi nemo. Enim sit quo fugiat sit cumque commodi maxime. Omnis quia occaecati velit quo et voluptas. Libero nihil aliquam totam quidem veniam iure dolore. Voluptatem ut vel laudantium rerum necessitatibus. Optio labore ratione ducimus nulla odio facere. Aut officia non illo nihil velit harum. Quidem dolor voluptatem veniam impedit amet sit totam.\" content_2=\"Deleniti mollitia libero aut nobis quae dolor. Autem in alias fugiat sed veritatis ipsa fugit. Qui nesciunt quasi dolores. Aut sint eum eos iure nulla aut molestias.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',632,NULL,'once','news/2.jpg','icons/mer.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Car Wash & Detailing Package','Enhance your car rental or repair experience with our premium car wash and detailing service, leaving your car spotless inside and out.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Provident recusandae exercitationem rerum ut omnis nam aut repudiandae. Vel animi eveniet exercitationem sed sunt qui. Aperiam ut dolores quaerat laborum. Dolore omnis similique doloremque. Iure perspiciatis maiores eaque nesciunt at quis. Consectetur aperiam cupiditate et aspernatur sed pariatur saepe.\" content_2=\"Qui non ea commodi occaecati sit quia dolores. Quod est cupiditate sunt earum molestiae maxime expedita. Nisi nihil illo quas ab perspiciatis eligendi. Qui suscipit placeat aspernatur alias possimus nisi dolorum. Quod iste eos quas qui minus et. Ut sint facilis aut eum. Dolores voluptates molestias at est dolores est.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',756,NULL,'once','news/3.jpg','icons/bugatti.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Roadside Assistance','Our roadside assistance service ensures peace of mind while you rent or drive. Get help with breakdowns, flat tires, or towing when you need it most.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Et odio quo ducimus qui non iure. Ratione ut repudiandae perferendis dolore. Natus ex corporis esse dolor fugiat. Nam ut aut eum velit. Officiis reprehenderit ut sint dignissimos reprehenderit accusamus sit. Odio beatae iure tenetur molestias quisquam cumque cupiditate. Et magni esse rerum dicta. Hic dicta sit et consequatur et eum molestias. Quis consequuntur et omnis laudantium ducimus enim.\" content_2=\"Debitis minima doloremque labore et molestias quia. Voluptas vero est iusto qui. Dignissimos sapiente ea et pariatur a eligendi.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',582,NULL,'once','news/4.jpg','icons/jaguar.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Temporary Car Replacement','If your car is in for repairs or maintenance, we offer a temporary car replacement service so you’re never without transportation.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Ut rerum ab dolor numquam libero quia quo qui. Est perferendis aut fugiat sed similique totam quas ab. Ut cumque nesciunt voluptatem quaerat qui. Corrupti dolor quibusdam omnis facere unde sit occaecati. Voluptatem laudantium assumenda non et officia laboriosam. Enim ut nesciunt voluptas officiis et eaque quo. Quidem eos veniam eligendi.\" content_2=\"Dolor voluptas officiis et consequatur enim consectetur. Est nesciunt nihil quibusdam. Eum modi ipsum in deleniti quis qui doloremque. Neque impedit quia itaque. Nesciunt perferendis iste aliquid molestiae voluptatibus. Vel ut quia aliquid magnam minima vel non. Voluptas excepturi qui blanditiis consequatur et. Asperiores quae nihil esse voluptas explicabo rem.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',358,NULL,'once','news/5.jpg','icons/honda.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Tire Replacement & Balancing','We provide tire replacement and wheel balancing services, ensuring your car is safe and smooth on the road, available as an add-on to any maintenance package.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Incidunt debitis quis eius aliquam praesentium dolores. Iure voluptatum quia et velit enim magnam numquam. Non laborum quis ut ipsum est ducimus. Perspiciatis voluptates cupiditate minus possimus eum. Et at ipsa quaerat nam corrupti. Eos commodi libero quia. Amet impedit quo ipsa pariatur soluta. Quae praesentium facere voluptatibus delectus assumenda fuga.\" content_2=\"Aliquam iste veritatis nulla. Non voluptatem inventore eum occaecati iusto harum quibusdam. Distinctio id maxime ratione repellat molestias. Corrupti recusandae debitis et quia. Nemo earum ab fugit est nostrum eveniet qui. Voluptatibus non corporis cum dolorem aperiam quisquam ut excepturi. Rem eius tempora aut iste explicabo consequatur et.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',248,NULL,'once','news/6.jpg','icons/chevrolet.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(7,'Vehicle Inspection Service','For those looking to sell or rent a car, we offer thorough vehicle inspection services to certify your car’s condition and increase its market value.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Sunt ducimus saepe error ut repellendus. Aperiam quod sed laborum omnis veritatis occaecati. Eius unde est suscipit tempora corrupti harum. Dolorem quod et ex. Laudantium est ea voluptatem qui sapiente exercitationem. Nisi autem quis vero quod et autem dolor omnis. Omnis et incidunt voluptate vel.\" content_2=\"Quia qui consequatur recusandae nihil pariatur quasi. Fugit recusandae et perferendis ea id vel hic. Deserunt culpa eum et nihil. Qui dolores quos vitae sequi quae quos. Consequatur commodi placeat corporis officia asperiores. Magni id reprehenderit reprehenderit facilis provident. Quia aliquam nulla et molestiae in quia. Culpa et aut accusantium nihil. Debitis et eos ea vero vitae.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',284,NULL,'once','news/7.jpg','icons/chevrolet.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(8,'Car Insurance Assistance','Our experts can help you find the right car insurance policy, available as an add-on when purchasing or renting a vehicle from us.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Qui sed consequatur accusamus modi voluptatum occaecati cupiditate. Rerum nisi sit quis quo quis corporis. Voluptatem ut quasi illum laudantium soluta sint deleniti. Sit debitis sunt quaerat deleniti. Ducimus quas qui itaque recusandae id quibusdam. Et enim ut inventore nisi aliquam. Quia dolore aperiam aliquam delectus nesciunt atque ad hic. Doloremque totam amet nostrum et velit eum eum.\" content_2=\"Repudiandae nostrum earum aut exercitationem autem. Voluptatum dicta dolores amet rerum dolores. Reprehenderit qui dicta veniam odit hic et aut. Consectetur praesentium et ipsam ut voluptas nobis. Assumenda non quis a ipsa praesentium culpa velit. Sapiente aperiam alias harum architecto qui ut.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',351,NULL,'once','news/8.jpg','icons/chevrolet.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(9,'Pick-Up & Drop-Off Service','We offer a convenient pick-up and drop-off service when you rent a car, have your car serviced, or use our detailing services.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Nulla laudantium qui consequuntur omnis explicabo nesciunt rerum quae. Fuga expedita sit animi itaque quis. Ut blanditiis est veritatis. Illum est et quis voluptates non. Quam voluptatibus et maiores. Repellendus et suscipit voluptatem qui minima ex perspiciatis. Sunt optio aut rem magni non. Sunt earum iusto hic autem voluptas.\" content_2=\"Vero eos voluptates aut libero et eius sunt. Labore voluptatum labore deleniti. Corrupti nesciunt est minus odit ipsum recusandae. Quis enim omnis eum commodi. Deserunt corrupti est consectetur est quod. Sit sit rerum temporibus nesciunt. Laudantium ea vel nemo laudantium enim officiis quasi ut.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',562,NULL,'once','news/9.jpg','icons/chevrolet.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06'),(10,'Premium Fuel Service','Refuel your rental or serviced vehicle with high-quality premium fuel before hitting the road, ensuring optimal performance and mileage.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Similique corporis doloribus minima praesentium quia sit. Amet dolores totam suscipit tenetur odit est iste. Velit dolorum architecto molestiae voluptatibus maxime rem. Quae minima accusamus qui voluptates. Quisquam explicabo necessitatibus autem. Quibusdam reiciendis itaque quidem. Libero vero nostrum sit esse magni. Optio sit culpa impedit est eligendi commodi et accusamus.\" content_2=\"Quaerat cupiditate enim ut dignissimos ea qui. Laboriosam quia provident deleniti minima soluta molestiae dolor. Iste aut suscipit et voluptatibus. Odio omnis quisquam laboriosam non rerum.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',469,NULL,'once','news/10.jpg','icons/chevrolet.png','published','2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_services_translations`
--

DROP TABLE IF EXISTS `cr_services_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_services_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_services_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_services_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_services_translations`
--

LOCK TABLES `cr_services_translations` WRITE;
/*!40000 ALTER TABLE `cr_services_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_services_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_tags`
--

DROP TABLE IF EXISTS `cr_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_tags_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_tags`
--

LOCK TABLES `cr_tags` WRITE;
/*!40000 ALTER TABLE `cr_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_tags_translations`
--

DROP TABLE IF EXISTS `cr_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_tags_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_tags_translations`
--

LOCK TABLES `cr_tags_translations` WRITE;
/*!40000 ALTER TABLE `cr_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_taxes`
--

DROP TABLE IF EXISTS `cr_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `priority` smallint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_taxes`
--

LOCK TABLES `cr_taxes` WRITE;
/*!40000 ALTER TABLE `cr_taxes` DISABLE KEYS */;
INSERT INTO `cr_taxes` VALUES (1,'Import Duty',2.44,'published',1,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(2,'Value Added Tax (VAT)',0.26,'published',2,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(3,'Currency Conversion',1.53,'published',3,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(4,'Brokerage',1.66,'published',4,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(5,'Storage',2.95,'published',5,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(6,'Administrative',2.09,'published',6,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(7,'Handling',4.92,'published',7,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(8,'Insurance',0.42,'published',8,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(9,'Rural Delivery',3.74,'published',9,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(10,'Return Shipping',3.87,'published',10,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(11,'Environmental',4.75,'published',11,'2025-11-17 21:12:06','2025-11-17 21:12:06'),(12,'Excise',0.71,'published',12,'2025-11-17 21:12:06','2025-11-17 21:12:06');
/*!40000 ALTER TABLE `cr_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_taxes_translations`
--

DROP TABLE IF EXISTS `cr_taxes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_taxes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_taxes_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_code`,`cr_taxes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_taxes_translations`
--

LOCK TABLES `cr_taxes_translations` WRITE;
/*!40000 ALTER TABLE `cr_taxes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_taxes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_tokens_token_unique` (`token`),
  KEY `device_tokens_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `device_tokens_platform_is_active_index` (`platform`,`is_active`),
  KEY `device_tokens_is_active_index` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'GENERAL INFORMATION',0,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(2,'ACCOMMODATIONS AND AMENITIES',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(3,'SPECIAL EVENTS',2,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(4,'SAFETY AND HEALTH',3,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(5,'EXPLORING',4,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(6,'Account Management',5,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(7,'Booking and Reservations',6,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(8,'Activity Information',7,'published','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What sets Luxury Hotel apart from others area?','Our hotel stands out with its prime coastal location, captivating design that harmonizes with nature, impeccable service dedicated to fulfilling every guest’s desire, and an array of world-class amenities that redefine opulence and sophistication.',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(2,'Are pets allowed at your hotel?','Unfortunately, as we strive to maintain an environment of tranquility and luxury for all our guests, we regret to inform you that we do not permit pets in our elegantly appointed rooms and meticulously designed public spaces.',2,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(3,'Is there a service from airport to hotel?','Absolutely! For your convenience, we offer an exclusive airport shuttle service that can be arranged in advance. Our dedicated concierge team will be delighted to provide you with detailed information and assist with reservations.',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(4,'What dining options are available at hotel?','Indulge in a culinary journey at our resort with a range of exquisite dining options. From elegantly crafted local and international cuisines to delightful specialty restaurants and inviting bars, every dining experience promises to tantalize your taste buds and elevate your stay to new heights of gastronomic pleasure.',2,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(5,'Is there a spa and wellness center on-site?','Embrace holistic well-being at our luxurious on-site spa and wellness center. Immerse yourself in a world of serenity and rejuvenation with a diverse selection of treatments, therapies, and state-of-the-art facilities that cater to your body, mind, and soul.',2,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(6,'Do you have family-friendly activities?','Families are warmly welcomed to our resort, where we have thoughtfully curated a range of family-friendly amenities and activities. From a dedicated kids’ club to a family pool and a host of engaging recreational options, we ensure a harmonious and enjoyable stay for guests of all ages.',2,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(7,'How can I arrange special at resort?','Celebrate life’s most precious moments in the epitome of luxury and elegance. Our skilled event planning team is committed to orchestrating seamless and memorable celebrations, ensuring every detail is tailored to your vision. Contact our dedicated events department to embark on a journey of crafting extraordinary moments.',3,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(8,'What safety measures do you have for guests?','Your well-being is our paramount concern. We have implemented stringent health and safety protocols to ensure a secure and comfortable environment for all our guests. These measures encompass enhanced cleaning procedures, social distancing guidelines, and a commitment to maintaining the highest standards of hygiene throughout the resort.',4,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(9,'Can I cancel or modify my reservation?','Our reservation policies vary based on the rate type and specific booking conditions. We kindly advise reviewing the terms and details of your reservation or reaching out to our dedicated reservations team for personalized assistance regarding cancellations or modifications. Your comfort and satisfaction remain our utmost priority.',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(10,'What activities are near your hotel?','Our hotel’s prime location offers easy access to a plethora of attractions. Explore the captivating Adriatic coastline, immerse yourself in historical landmarks, indulge in vibrant local culture, and embark on memorable excursions that our concierge team can readily assist in arranging.',5,'published','2025-11-17 21:11:47','2025-11-17 21:11:47');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fob_comments`
--

DROP TABLE IF EXISTS `fob_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fob_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reply_to` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fob_comments_author_type_author_id_index` (`author_type`,`author_id`),
  KEY `fob_comments_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `fob_comments_reply_to_index` (`reply_to`),
  KEY `fob_comments_reference_url_index` (`reference_url`),
  KEY `fob_comments_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fob_comments`
--

LOCK TABLES `fob_comments` WRITE;
/*!40000 ALTER TABLE `fob_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `fob_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Stunning Electric Cars of 2024','Facilis ut est est illo. Sed et quod vitae voluptatem vitae ex soluta sit.',0,0,'galleries/1.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(2,'Top Luxury Cars for Special Occasions','Ipsa expedita distinctio vero sint voluptatem eius consequuntur. Numquam voluptates nihil quia dolore vel. Et minus magnam aut aliquam aut tempora.',0,0,'galleries/2.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(3,'Family Cars with Advanced Safety Features','Expedita officiis iure tempore porro. Beatae facere optio quam nihil perferendis. Atque pariatur non est ab voluptatum.',0,0,'galleries/3.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(4,'Off-Road Vehicles in Action','Reiciendis vel asperiores expedita repellat voluptas veniam. Sunt consequuntur est dolorem maxime expedita non.',0,0,'galleries/4.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(5,'The Evolution of Car Design: A Visual Journey','Illum hic explicabo dolore autem occaecati necessitatibus tempore. Repudiandae magni officiis ut. Est id aspernatur quia aut qui unde omnis.',0,0,'galleries/5.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(6,'Best Road Trip Cars of the Year','Voluptatem nesciunt assumenda at. Reiciendis ipsa veritatis odit magni odit quia delectus. Porro dolore sit qui.',0,0,'galleries/6.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(7,'Exclusive New Car Models Unveiled','Quia aspernatur qui et. Totam natus consectetur sunt. Iure omnis aut consequatur architecto enim molestiae.',0,0,'galleries/7.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(8,'Iconic Cars from Around the World','Ea quis ut odit minus aliquid. Accusamus natus commodi explicabo aut qui. Reiciendis voluptatem ut qui aperiam perspiciatis dicta provident.',0,0,'galleries/8.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(9,'The Future of Electric and Hybrid Cars','Illo esse inventore voluptas nobis est. Quo amet non deserunt labore. Facere qui voluptatem provident illum.',0,0,'galleries/9.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47'),(10,'Luxury Car Interiors: A Closer Look','Voluptates nostrum facere qui magnam amet at quia. Eius ex rerum et. Quam animi non et corporis nesciunt dolore aut.',0,0,'galleries/10.jpg',1,'published','2025-11-17 21:11:47','2025-11-17 21:11:47');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(2,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(3,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(4,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(5,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(6,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(7,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(8,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(9,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47'),(10,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:11:47','2025-11-17 21:11:47');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','5d0eaba86e7420d2beb70beac6ce7302',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','7bc807403ce7a08e1c7ebebada8c4a37',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','f06ad982dab5a33c60fc48979310def1',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(4,'en_US','82bfdf24cb793526a0cb13c6b2b3617d',2,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'1','1',1,'image/jpeg',10644,'general/1.jpg','[]','2025-11-17 21:11:29','2025-11-17 21:11:29',NULL,'public'),(2,0,'2','2',1,'image/jpeg',4750,'general/2.jpg','[]','2025-11-17 21:11:29','2025-11-17 21:11:29',NULL,'public'),(3,0,'3','3',1,'image/jpeg',8045,'general/3.jpg','[]','2025-11-17 21:11:29','2025-11-17 21:11:29',NULL,'public'),(4,0,'about-us-1','about-us-1',1,'image/jpeg',11009,'general/about-us-1.jpg','[]','2025-11-17 21:11:29','2025-11-17 21:11:29',NULL,'public'),(5,0,'about-us-2','about-us-2',1,'image/jpeg',11009,'general/about-us-2.jpg','[]','2025-11-17 21:11:30','2025-11-17 21:11:30',NULL,'public'),(6,0,'about-us-3','about-us-3',1,'image/jpeg',9151,'general/about-us-3.jpg','[]','2025-11-17 21:11:30','2025-11-17 21:11:30',NULL,'public'),(7,0,'admin-logo','admin-logo',1,'image/png',3856,'general/admin-logo.png','[]','2025-11-17 21:11:30','2025-11-17 21:11:30',NULL,'public'),(8,0,'appstore','appstore',1,'image/png',3718,'general/appstore.png','[]','2025-11-17 21:11:30','2025-11-17 21:11:30',NULL,'public'),(9,0,'background','background',1,'image/png',171804,'general/background.png','[]','2025-11-17 21:11:31','2025-11-17 21:11:31',NULL,'public'),(10,0,'favicon','favicon',1,'image/png',2019,'general/favicon.png','[]','2025-11-17 21:11:31','2025-11-17 21:11:31',NULL,'public'),(11,0,'googleplay','googleplay',1,'image/png',3970,'general/googleplay.png','[]','2025-11-17 21:11:31','2025-11-17 21:11:31',NULL,'public'),(12,0,'img-1','img-1',1,'image/png',8332,'general/img-1.png','[]','2025-11-17 21:11:32','2025-11-17 21:11:32',NULL,'public'),(13,0,'img-2-1','img-2-1',1,'image/png',4793,'general/img-2-1.png','[]','2025-11-17 21:11:32','2025-11-17 21:11:32',NULL,'public'),(14,0,'img-2-2','img-2-2',1,'image/png',4443,'general/img-2-2.png','[]','2025-11-17 21:11:32','2025-11-17 21:11:32',NULL,'public'),(15,0,'img-2-3','img-2-3',1,'image/png',3547,'general/img-2-3.png','[]','2025-11-17 21:11:32','2025-11-17 21:11:32',NULL,'public'),(16,0,'img-2-4','img-2-4',1,'image/png',4221,'general/img-2-4.png','[]','2025-11-17 21:11:33','2025-11-17 21:11:33',NULL,'public'),(17,0,'img-2','img-2',1,'image/png',8360,'general/img-2.png','[]','2025-11-17 21:11:33','2025-11-17 21:11:33',NULL,'public'),(18,0,'img-3','img-3',1,'image/png',7564,'general/img-3.png','[]','2025-11-17 21:11:33','2025-11-17 21:11:33',NULL,'public'),(19,0,'img-4','img-4',1,'image/png',7335,'general/img-4.png','[]','2025-11-17 21:11:33','2025-11-17 21:11:33',NULL,'public'),(20,0,'img-5','img-5',1,'image/png',8318,'general/img-5.png','[]','2025-11-17 21:11:34','2025-11-17 21:11:34',NULL,'public'),(21,0,'logo-dark','logo-dark',1,'image/png',3856,'general/logo-dark.png','[]','2025-11-17 21:11:34','2025-11-17 21:11:34',NULL,'public'),(22,0,'logo','logo',1,'image/png',4617,'general/logo.png','[]','2025-11-17 21:11:34','2025-11-17 21:11:34',NULL,'public'),(23,0,'phone','phone',1,'image/png',10618,'general/phone.png','[]','2025-11-17 21:11:34','2025-11-17 21:11:34',NULL,'public'),(24,0,'truck','truck',1,'image/png',5660,'general/truck.png','[]','2025-11-17 21:11:35','2025-11-17 21:11:35',NULL,'public'),(29,0,'1','1',3,'image/jpeg',19108,'news/1.jpg','[]','2025-11-17 21:11:37','2025-11-17 21:11:37',NULL,'public'),(30,0,'10','10',3,'image/jpeg',19108,'news/10.jpg','[]','2025-11-17 21:11:38','2025-11-17 21:11:38',NULL,'public'),(31,0,'11','11',3,'image/jpeg',19108,'news/11.jpg','[]','2025-11-17 21:11:38','2025-11-17 21:11:38',NULL,'public'),(32,0,'12','12',3,'image/jpeg',19108,'news/12.jpg','[]','2025-11-17 21:11:38','2025-11-17 21:11:38',NULL,'public'),(33,0,'13','13',3,'image/jpeg',19108,'news/13.jpg','[]','2025-11-17 21:11:39','2025-11-17 21:11:39',NULL,'public'),(34,0,'14','14',3,'image/jpeg',19108,'news/14.jpg','[]','2025-11-17 21:11:39','2025-11-17 21:11:39',NULL,'public'),(35,0,'15','15',3,'image/jpeg',19108,'news/15.jpg','[]','2025-11-17 21:11:39','2025-11-17 21:11:39',NULL,'public'),(36,0,'16','16',3,'image/jpeg',19108,'news/16.jpg','[]','2025-11-17 21:11:39','2025-11-17 21:11:39',NULL,'public'),(37,0,'17','17',3,'image/jpeg',19108,'news/17.jpg','[]','2025-11-17 21:11:40','2025-11-17 21:11:40',NULL,'public'),(38,0,'18','18',3,'image/jpeg',19108,'news/18.jpg','[]','2025-11-17 21:11:40','2025-11-17 21:11:40',NULL,'public'),(39,0,'19','19',3,'image/jpeg',19108,'news/19.jpg','[]','2025-11-17 21:11:40','2025-11-17 21:11:40',NULL,'public'),(40,0,'2','2',3,'image/jpeg',19108,'news/2.jpg','[]','2025-11-17 21:11:41','2025-11-17 21:11:41',NULL,'public'),(41,0,'20','20',3,'image/jpeg',19108,'news/20.jpg','[]','2025-11-17 21:11:41','2025-11-17 21:11:41',NULL,'public'),(42,0,'3','3',3,'image/jpeg',19108,'news/3.jpg','[]','2025-11-17 21:11:41','2025-11-17 21:11:41',NULL,'public'),(43,0,'4','4',3,'image/jpeg',19108,'news/4.jpg','[]','2025-11-17 21:11:42','2025-11-17 21:11:42',NULL,'public'),(44,0,'5','5',3,'image/jpeg',19108,'news/5.jpg','[]','2025-11-17 21:11:42','2025-11-17 21:11:42',NULL,'public'),(45,0,'6','6',3,'image/jpeg',19108,'news/6.jpg','[]','2025-11-17 21:11:42','2025-11-17 21:11:42',NULL,'public'),(46,0,'7','7',3,'image/jpeg',19108,'news/7.jpg','[]','2025-11-17 21:11:43','2025-11-17 21:11:43',NULL,'public'),(47,0,'8','8',3,'image/jpeg',19108,'news/8.jpg','[]','2025-11-17 21:11:43','2025-11-17 21:11:43',NULL,'public'),(48,0,'9','9',3,'image/jpeg',19108,'news/9.jpg','[]','2025-11-17 21:11:43','2025-11-17 21:11:43',NULL,'public'),(49,0,'1','1',4,'image/jpeg',12879,'galleries/1.jpg','[]','2025-11-17 21:11:44','2025-11-17 21:11:44',NULL,'public'),(50,0,'10','10',4,'image/jpeg',12879,'galleries/10.jpg','[]','2025-11-17 21:11:44','2025-11-17 21:11:44',NULL,'public'),(51,0,'2','2',4,'image/jpeg',12879,'galleries/2.jpg','[]','2025-11-17 21:11:44','2025-11-17 21:11:44',NULL,'public'),(52,0,'3','3',4,'image/jpeg',12879,'galleries/3.jpg','[]','2025-11-17 21:11:45','2025-11-17 21:11:45',NULL,'public'),(53,0,'4','4',4,'image/jpeg',12879,'galleries/4.jpg','[]','2025-11-17 21:11:45','2025-11-17 21:11:45',NULL,'public'),(54,0,'5','5',4,'image/jpeg',12879,'galleries/5.jpg','[]','2025-11-17 21:11:45','2025-11-17 21:11:45',NULL,'public'),(55,0,'6','6',4,'image/jpeg',12879,'galleries/6.jpg','[]','2025-11-17 21:11:46','2025-11-17 21:11:46',NULL,'public'),(56,0,'7','7',4,'image/jpeg',12879,'galleries/7.jpg','[]','2025-11-17 21:11:46','2025-11-17 21:11:46',NULL,'public'),(57,0,'8','8',4,'image/jpeg',12879,'galleries/8.jpg','[]','2025-11-17 21:11:46','2025-11-17 21:11:46',NULL,'public'),(58,0,'9','9',4,'image/jpeg',12879,'galleries/9.jpg','[]','2025-11-17 21:11:46','2025-11-17 21:11:46',NULL,'public'),(59,0,'1','1',5,'image/jpeg',9803,'teams/1.jpg','[]','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL,'public'),(60,0,'2','2',5,'image/jpeg',9803,'teams/2.jpg','[]','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL,'public'),(61,0,'3','3',5,'image/jpeg',9803,'teams/3.jpg','[]','2025-11-17 21:11:47','2025-11-17 21:11:47',NULL,'public'),(62,0,'4','4',5,'image/jpeg',9803,'teams/4.jpg','[]','2025-11-17 21:11:48','2025-11-17 21:11:48',NULL,'public'),(63,0,'5','5',5,'image/jpeg',9803,'teams/5.jpg','[]','2025-11-17 21:11:48','2025-11-17 21:11:48',NULL,'public'),(64,0,'6','6',5,'image/jpeg',9803,'teams/6.jpg','[]','2025-11-17 21:11:48','2025-11-17 21:11:48',NULL,'public'),(65,0,'7','7',5,'image/jpeg',9803,'teams/7.jpg','[]','2025-11-17 21:11:48','2025-11-17 21:11:48',NULL,'public'),(66,0,'8','8',5,'image/jpeg',9803,'teams/8.jpg','[]','2025-11-17 21:11:49','2025-11-17 21:11:49',NULL,'public'),(67,0,'1','1',6,'image/png',3750,'testimonials/1.png','[]','2025-11-17 21:11:49','2025-11-17 21:11:49',NULL,'public'),(68,0,'2','2',6,'image/png',3750,'testimonials/2.png','[]','2025-11-17 21:11:49','2025-11-17 21:11:49',NULL,'public'),(69,0,'3','3',6,'image/png',3750,'testimonials/3.png','[]','2025-11-17 21:11:49','2025-11-17 21:11:49',NULL,'public'),(70,0,'4','4',6,'image/png',3750,'testimonials/4.png','[]','2025-11-17 21:11:50','2025-11-17 21:11:50',NULL,'public'),(71,0,'location1','location1',7,'image/jpeg',11707,'locations/location1.jpg','[]','2025-11-17 21:11:50','2025-11-17 21:11:50',NULL,'public'),(72,0,'location2','location2',7,'image/jpeg',11707,'locations/location2.jpg','[]','2025-11-17 21:11:50','2025-11-17 21:11:50',NULL,'public'),(73,0,'location3','location3',7,'image/jpeg',11707,'locations/location3.jpg','[]','2025-11-17 21:11:50','2025-11-17 21:11:50',NULL,'public'),(74,0,'location4','location4',7,'image/jpeg',11707,'locations/location4.jpg','[]','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL,'public'),(75,0,'location5','location5',7,'image/jpeg',11707,'locations/location5.jpg','[]','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL,'public'),(76,0,'location6','location6',7,'image/jpeg',11707,'locations/location6.jpg','[]','2025-11-17 21:11:51','2025-11-17 21:11:51',NULL,'public'),(77,0,'1','1',8,'image/jpeg',3916,'customers/1.jpg','[]','2025-11-17 21:11:52','2025-11-17 21:11:52',NULL,'public'),(78,0,'10','10',8,'image/jpeg',3916,'customers/10.jpg','[]','2025-11-17 21:11:52','2025-11-17 21:11:52',NULL,'public'),(79,0,'11','11',8,'image/jpeg',3916,'customers/11.jpg','[]','2025-11-17 21:11:52','2025-11-17 21:11:52',NULL,'public'),(80,0,'12','12',8,'image/jpeg',3916,'customers/12.jpg','[]','2025-11-17 21:11:52','2025-11-17 21:11:52',NULL,'public'),(81,0,'13','13',8,'image/jpeg',3916,'customers/13.jpg','[]','2025-11-17 21:11:52','2025-11-17 21:11:52',NULL,'public'),(82,0,'14','14',8,'image/jpeg',3916,'customers/14.jpg','[]','2025-11-17 21:11:53','2025-11-17 21:11:53',NULL,'public'),(83,0,'15','15',8,'image/jpeg',3916,'customers/15.jpg','[]','2025-11-17 21:11:53','2025-11-17 21:11:53',NULL,'public'),(84,0,'16','16',8,'image/jpeg',3916,'customers/16.jpg','[]','2025-11-17 21:11:53','2025-11-17 21:11:53',NULL,'public'),(85,0,'17','17',8,'image/jpeg',3916,'customers/17.jpg','[]','2025-11-17 21:11:53','2025-11-17 21:11:53',NULL,'public'),(86,0,'18','18',8,'image/jpeg',3916,'customers/18.jpg','[]','2025-11-17 21:11:53','2025-11-17 21:11:53',NULL,'public'),(87,0,'19','19',8,'image/jpeg',3916,'customers/19.jpg','[]','2025-11-17 21:11:54','2025-11-17 21:11:54',NULL,'public'),(88,0,'2','2',8,'image/jpeg',3916,'customers/2.jpg','[]','2025-11-17 21:11:54','2025-11-17 21:11:54',NULL,'public'),(89,0,'20','20',8,'image/jpeg',3916,'customers/20.jpg','[]','2025-11-17 21:11:54','2025-11-17 21:11:54',NULL,'public'),(90,0,'21','21',8,'image/jpeg',3916,'customers/21.jpg','[]','2025-11-17 21:11:54','2025-11-17 21:11:54',NULL,'public'),(91,0,'22','22',8,'image/jpeg',3916,'customers/22.jpg','[]','2025-11-17 21:11:55','2025-11-17 21:11:55',NULL,'public'),(92,0,'23','23',8,'image/jpeg',3916,'customers/23.jpg','[]','2025-11-17 21:11:55','2025-11-17 21:11:55',NULL,'public'),(93,0,'24','24',8,'image/jpeg',3916,'customers/24.jpg','[]','2025-11-17 21:11:55','2025-11-17 21:11:55',NULL,'public'),(94,0,'25','25',8,'image/jpeg',3916,'customers/25.jpg','[]','2025-11-17 21:11:55','2025-11-17 21:11:55',NULL,'public'),(95,0,'26','26',8,'image/jpeg',3916,'customers/26.jpg','[]','2025-11-17 21:11:55','2025-11-17 21:11:55',NULL,'public'),(96,0,'27','27',8,'image/jpeg',3916,'customers/27.jpg','[]','2025-11-17 21:11:56','2025-11-17 21:11:56',NULL,'public'),(97,0,'28','28',8,'image/jpeg',3916,'customers/28.jpg','[]','2025-11-17 21:11:56','2025-11-17 21:11:56',NULL,'public'),(98,0,'29','29',8,'image/jpeg',3916,'customers/29.jpg','[]','2025-11-17 21:11:56','2025-11-17 21:11:56',NULL,'public'),(99,0,'3','3',8,'image/jpeg',3916,'customers/3.jpg','[]','2025-11-17 21:11:56','2025-11-17 21:11:56',NULL,'public'),(100,0,'30','30',8,'image/jpeg',3916,'customers/30.jpg','[]','2025-11-17 21:11:56','2025-11-17 21:11:56',NULL,'public'),(101,0,'31','31',8,'image/jpeg',3916,'customers/31.jpg','[]','2025-11-17 21:11:57','2025-11-17 21:11:57',NULL,'public'),(102,0,'4','4',8,'image/jpeg',3916,'customers/4.jpg','[]','2025-11-17 21:11:57','2025-11-17 21:11:57',NULL,'public'),(103,0,'5','5',8,'image/jpeg',3916,'customers/5.jpg','[]','2025-11-17 21:11:57','2025-11-17 21:11:57',NULL,'public'),(104,0,'6','6',8,'image/jpeg',3916,'customers/6.jpg','[]','2025-11-17 21:11:57','2025-11-17 21:11:57',NULL,'public'),(105,0,'7','7',8,'image/jpeg',3916,'customers/7.jpg','[]','2025-11-17 21:11:58','2025-11-17 21:11:58',NULL,'public'),(106,0,'8','8',8,'image/jpeg',3916,'customers/8.jpg','[]','2025-11-17 21:11:58','2025-11-17 21:11:58',NULL,'public'),(107,0,'9','9',8,'image/jpeg',3916,'customers/9.jpg','[]','2025-11-17 21:11:58','2025-11-17 21:11:58',NULL,'public'),(108,0,'1','1',9,'image/jpeg',33268,'cars/1.jpg','[]','2025-11-17 21:12:06','2025-11-17 21:12:06',NULL,'public'),(109,0,'10','10',9,'image/jpeg',33268,'cars/10.jpg','[]','2025-11-17 21:12:07','2025-11-17 21:12:07',NULL,'public'),(110,0,'100','100',9,'image/jpeg',33268,'cars/100.jpg','[]','2025-11-17 21:12:07','2025-11-17 21:12:07',NULL,'public'),(111,0,'101','101',9,'image/jpeg',33268,'cars/101.jpg','[]','2025-11-17 21:12:07','2025-11-17 21:12:07',NULL,'public'),(112,0,'102','102',9,'image/jpeg',33268,'cars/102.jpg','[]','2025-11-17 21:12:08','2025-11-17 21:12:08',NULL,'public'),(113,0,'103','103',9,'image/jpeg',33268,'cars/103.jpg','[]','2025-11-17 21:12:08','2025-11-17 21:12:08',NULL,'public'),(114,0,'104','104',9,'image/jpeg',33268,'cars/104.jpg','[]','2025-11-17 21:12:09','2025-11-17 21:12:09',NULL,'public'),(115,0,'105','105',9,'image/jpeg',33268,'cars/105.jpg','[]','2025-11-17 21:12:09','2025-11-17 21:12:09',NULL,'public'),(116,0,'11','11',9,'image/jpeg',33268,'cars/11.jpg','[]','2025-11-17 21:12:10','2025-11-17 21:12:10',NULL,'public'),(117,0,'12','12',9,'image/jpeg',33268,'cars/12.jpg','[]','2025-11-17 21:12:10','2025-11-17 21:12:10',NULL,'public'),(118,0,'13','13',9,'image/jpeg',33268,'cars/13.jpg','[]','2025-11-17 21:12:10','2025-11-17 21:12:10',NULL,'public'),(119,0,'14','14',9,'image/jpeg',33268,'cars/14.jpg','[]','2025-11-17 21:12:11','2025-11-17 21:12:11',NULL,'public'),(120,0,'15','15',9,'image/jpeg',33268,'cars/15.jpg','[]','2025-11-17 21:12:11','2025-11-17 21:12:11',NULL,'public'),(121,0,'16','16',9,'image/jpeg',33268,'cars/16.jpg','[]','2025-11-17 21:12:11','2025-11-17 21:12:11',NULL,'public'),(122,0,'17','17',9,'image/jpeg',33268,'cars/17.jpg','[]','2025-11-17 21:12:12','2025-11-17 21:12:12',NULL,'public'),(123,0,'18','18',9,'image/jpeg',33268,'cars/18.jpg','[]','2025-11-17 21:12:12','2025-11-17 21:12:12',NULL,'public'),(124,0,'19','19',9,'image/jpeg',33268,'cars/19.jpg','[]','2025-11-17 21:12:13','2025-11-17 21:12:13',NULL,'public'),(125,0,'2','2',9,'image/jpeg',33268,'cars/2.jpg','[]','2025-11-17 21:12:13','2025-11-17 21:12:13',NULL,'public'),(126,0,'20','20',9,'image/jpeg',33268,'cars/20.jpg','[]','2025-11-17 21:12:13','2025-11-17 21:12:13',NULL,'public'),(127,0,'21','21',9,'image/jpeg',33268,'cars/21.jpg','[]','2025-11-17 21:12:14','2025-11-17 21:12:14',NULL,'public'),(128,0,'22','22',9,'image/jpeg',33268,'cars/22.jpg','[]','2025-11-17 21:12:14','2025-11-17 21:12:14',NULL,'public'),(129,0,'23','23',9,'image/jpeg',33268,'cars/23.jpg','[]','2025-11-17 21:12:14','2025-11-17 21:12:14',NULL,'public'),(130,0,'24','24',9,'image/jpeg',33268,'cars/24.jpg','[]','2025-11-17 21:12:15','2025-11-17 21:12:15',NULL,'public'),(131,0,'25','25',9,'image/jpeg',33268,'cars/25.jpg','[]','2025-11-17 21:12:15','2025-11-17 21:12:15',NULL,'public'),(132,0,'26','26',9,'image/jpeg',33268,'cars/26.jpg','[]','2025-11-17 21:12:16','2025-11-17 21:12:16',NULL,'public'),(133,0,'27','27',9,'image/jpeg',33268,'cars/27.jpg','[]','2025-11-17 21:12:16','2025-11-17 21:12:16',NULL,'public'),(134,0,'28','28',9,'image/jpeg',33268,'cars/28.jpg','[]','2025-11-17 21:12:16','2025-11-17 21:12:16',NULL,'public'),(135,0,'29','29',9,'image/jpeg',33268,'cars/29.jpg','[]','2025-11-17 21:12:17','2025-11-17 21:12:17',NULL,'public'),(136,0,'3','3',9,'image/jpeg',33268,'cars/3.jpg','[]','2025-11-17 21:12:17','2025-11-17 21:12:17',NULL,'public'),(137,0,'30','30',9,'image/jpeg',33268,'cars/30.jpg','[]','2025-11-17 21:12:17','2025-11-17 21:12:17',NULL,'public'),(138,0,'31','31',9,'image/jpeg',33268,'cars/31.jpg','[]','2025-11-17 21:12:18','2025-11-17 21:12:18',NULL,'public'),(139,0,'32','32',9,'image/jpeg',33268,'cars/32.jpg','[]','2025-11-17 21:12:18','2025-11-17 21:12:18',NULL,'public'),(140,0,'33','33',9,'image/jpeg',33268,'cars/33.jpg','[]','2025-11-17 21:12:19','2025-11-17 21:12:19',NULL,'public'),(141,0,'34','34',9,'image/jpeg',33268,'cars/34.jpg','[]','2025-11-17 21:12:19','2025-11-17 21:12:19',NULL,'public'),(142,0,'35','35',9,'image/jpeg',33268,'cars/35.jpg','[]','2025-11-17 21:12:19','2025-11-17 21:12:19',NULL,'public'),(143,0,'36','36',9,'image/jpeg',33268,'cars/36.jpg','[]','2025-11-17 21:12:20','2025-11-17 21:12:20',NULL,'public'),(144,0,'37','37',9,'image/jpeg',33268,'cars/37.jpg','[]','2025-11-17 21:12:20','2025-11-17 21:12:20',NULL,'public'),(145,0,'38','38',9,'image/jpeg',33268,'cars/38.jpg','[]','2025-11-17 21:12:21','2025-11-17 21:12:21',NULL,'public'),(146,0,'39','39',9,'image/jpeg',33268,'cars/39.jpg','[]','2025-11-17 21:12:21','2025-11-17 21:12:21',NULL,'public'),(147,0,'4','4',9,'image/jpeg',33268,'cars/4.jpg','[]','2025-11-17 21:12:21','2025-11-17 21:12:21',NULL,'public'),(148,0,'40','40',9,'image/jpeg',33268,'cars/40.jpg','[]','2025-11-17 21:12:22','2025-11-17 21:12:22',NULL,'public'),(149,0,'41','41',9,'image/jpeg',33268,'cars/41.jpg','[]','2025-11-17 21:12:22','2025-11-17 21:12:22',NULL,'public'),(150,0,'42','42',9,'image/jpeg',33268,'cars/42.jpg','[]','2025-11-17 21:12:22','2025-11-17 21:12:22',NULL,'public'),(151,0,'43','43',9,'image/jpeg',33268,'cars/43.jpg','[]','2025-11-17 21:12:23','2025-11-17 21:12:23',NULL,'public'),(152,0,'44','44',9,'image/jpeg',33268,'cars/44.jpg','[]','2025-11-17 21:12:23','2025-11-17 21:12:23',NULL,'public'),(153,0,'45','45',9,'image/jpeg',33268,'cars/45.jpg','[]','2025-11-17 21:12:24','2025-11-17 21:12:24',NULL,'public'),(154,0,'46','46',9,'image/jpeg',33268,'cars/46.jpg','[]','2025-11-17 21:12:24','2025-11-17 21:12:24',NULL,'public'),(155,0,'47','47',9,'image/jpeg',33268,'cars/47.jpg','[]','2025-11-17 21:12:24','2025-11-17 21:12:24',NULL,'public'),(156,0,'48','48',9,'image/jpeg',33268,'cars/48.jpg','[]','2025-11-17 21:12:25','2025-11-17 21:12:25',NULL,'public'),(157,0,'49','49',9,'image/jpeg',33268,'cars/49.jpg','[]','2025-11-17 21:12:25','2025-11-17 21:12:25',NULL,'public'),(158,0,'5','5',9,'image/jpeg',33268,'cars/5.jpg','[]','2025-11-17 21:12:25','2025-11-17 21:12:25',NULL,'public'),(159,0,'50','50',9,'image/jpeg',33268,'cars/50.jpg','[]','2025-11-17 21:12:26','2025-11-17 21:12:26',NULL,'public'),(160,0,'51','51',9,'image/jpeg',33268,'cars/51.jpg','[]','2025-11-17 21:12:26','2025-11-17 21:12:26',NULL,'public'),(161,0,'52','52',9,'image/jpeg',33268,'cars/52.jpg','[]','2025-11-17 21:12:27','2025-11-17 21:12:27',NULL,'public'),(162,0,'53','53',9,'image/jpeg',33268,'cars/53.jpg','[]','2025-11-17 21:12:27','2025-11-17 21:12:27',NULL,'public'),(163,0,'54','54',9,'image/jpeg',33268,'cars/54.jpg','[]','2025-11-17 21:12:27','2025-11-17 21:12:27',NULL,'public'),(164,0,'55','55',9,'image/jpeg',33268,'cars/55.jpg','[]','2025-11-17 21:12:28','2025-11-17 21:12:28',NULL,'public'),(165,0,'56','56',9,'image/jpeg',33268,'cars/56.jpg','[]','2025-11-17 21:12:28','2025-11-17 21:12:28',NULL,'public'),(166,0,'57','57',9,'image/jpeg',33268,'cars/57.jpg','[]','2025-11-17 21:12:28','2025-11-17 21:12:28',NULL,'public'),(167,0,'58','58',9,'image/jpeg',33268,'cars/58.jpg','[]','2025-11-17 21:12:29','2025-11-17 21:12:29',NULL,'public'),(168,0,'59','59',9,'image/jpeg',33268,'cars/59.jpg','[]','2025-11-17 21:12:29','2025-11-17 21:12:29',NULL,'public'),(169,0,'6','6',9,'image/jpeg',33268,'cars/6.jpg','[]','2025-11-17 21:12:29','2025-11-17 21:12:29',NULL,'public'),(170,0,'60','60',9,'image/jpeg',33268,'cars/60.jpg','[]','2025-11-17 21:12:30','2025-11-17 21:12:30',NULL,'public'),(171,0,'61','61',9,'image/jpeg',33268,'cars/61.jpg','[]','2025-11-17 21:12:30','2025-11-17 21:12:30',NULL,'public'),(172,0,'62','62',9,'image/jpeg',33268,'cars/62.jpg','[]','2025-11-17 21:12:31','2025-11-17 21:12:31',NULL,'public'),(173,0,'63','63',9,'image/jpeg',33268,'cars/63.jpg','[]','2025-11-17 21:12:31','2025-11-17 21:12:31',NULL,'public'),(174,0,'64','64',9,'image/jpeg',33268,'cars/64.jpg','[]','2025-11-17 21:12:31','2025-11-17 21:12:31',NULL,'public'),(175,0,'65','65',9,'image/jpeg',33268,'cars/65.jpg','[]','2025-11-17 21:12:32','2025-11-17 21:12:32',NULL,'public'),(176,0,'66','66',9,'image/jpeg',33268,'cars/66.jpg','[]','2025-11-17 21:12:32','2025-11-17 21:12:32',NULL,'public'),(177,0,'67','67',9,'image/jpeg',33268,'cars/67.jpg','[]','2025-11-17 21:12:32','2025-11-17 21:12:32',NULL,'public'),(178,0,'68','68',9,'image/jpeg',33268,'cars/68.jpg','[]','2025-11-17 21:12:33','2025-11-17 21:12:33',NULL,'public'),(179,0,'69','69',9,'image/jpeg',33268,'cars/69.jpg','[]','2025-11-17 21:12:33','2025-11-17 21:12:33',NULL,'public'),(180,0,'7','7',9,'image/jpeg',33268,'cars/7.jpg','[]','2025-11-17 21:12:33','2025-11-17 21:12:33',NULL,'public'),(181,0,'70','70',9,'image/jpeg',33268,'cars/70.jpg','[]','2025-11-17 21:12:34','2025-11-17 21:12:34',NULL,'public'),(182,0,'71','71',9,'image/jpeg',33268,'cars/71.jpg','[]','2025-11-17 21:12:34','2025-11-17 21:12:34',NULL,'public'),(183,0,'72','72',9,'image/jpeg',33268,'cars/72.jpg','[]','2025-11-17 21:12:35','2025-11-17 21:12:35',NULL,'public'),(184,0,'73','73',9,'image/jpeg',33268,'cars/73.jpg','[]','2025-11-17 21:12:35','2025-11-17 21:12:35',NULL,'public'),(185,0,'74','74',9,'image/jpeg',33268,'cars/74.jpg','[]','2025-11-17 21:12:35','2025-11-17 21:12:35',NULL,'public'),(186,0,'75','75',9,'image/jpeg',33268,'cars/75.jpg','[]','2025-11-17 21:12:36','2025-11-17 21:12:36',NULL,'public'),(187,0,'76','76',9,'image/jpeg',33268,'cars/76.jpg','[]','2025-11-17 21:12:36','2025-11-17 21:12:36',NULL,'public'),(188,0,'77','77',9,'image/jpeg',33268,'cars/77.jpg','[]','2025-11-17 21:12:36','2025-11-17 21:12:36',NULL,'public'),(189,0,'78','78',9,'image/jpeg',33268,'cars/78.jpg','[]','2025-11-17 21:12:37','2025-11-17 21:12:37',NULL,'public'),(190,0,'79','79',9,'image/jpeg',33268,'cars/79.jpg','[]','2025-11-17 21:12:37','2025-11-17 21:12:37',NULL,'public'),(191,0,'8','8',9,'image/jpeg',33268,'cars/8.jpg','[]','2025-11-17 21:12:37','2025-11-17 21:12:37',NULL,'public'),(192,0,'80','80',9,'image/jpeg',33268,'cars/80.jpg','[]','2025-11-17 21:12:38','2025-11-17 21:12:38',NULL,'public'),(193,0,'81','81',9,'image/jpeg',33268,'cars/81.jpg','[]','2025-11-17 21:12:38','2025-11-17 21:12:38',NULL,'public'),(194,0,'82','82',9,'image/jpeg',33268,'cars/82.jpg','[]','2025-11-17 21:12:39','2025-11-17 21:12:39',NULL,'public'),(195,0,'83','83',9,'image/jpeg',33268,'cars/83.jpg','[]','2025-11-17 21:12:39','2025-11-17 21:12:39',NULL,'public'),(196,0,'84','84',9,'image/jpeg',33268,'cars/84.jpg','[]','2025-11-17 21:12:39','2025-11-17 21:12:39',NULL,'public'),(197,0,'85','85',9,'image/jpeg',33268,'cars/85.jpg','[]','2025-11-17 21:12:40','2025-11-17 21:12:40',NULL,'public'),(198,0,'86','86',9,'image/jpeg',33268,'cars/86.jpg','[]','2025-11-17 21:12:40','2025-11-17 21:12:40',NULL,'public'),(199,0,'87','87',9,'image/jpeg',33268,'cars/87.jpg','[]','2025-11-17 21:12:40','2025-11-17 21:12:40',NULL,'public'),(200,0,'88','88',9,'image/jpeg',33268,'cars/88.jpg','[]','2025-11-17 21:12:41','2025-11-17 21:12:41',NULL,'public'),(201,0,'89','89',9,'image/jpeg',33268,'cars/89.jpg','[]','2025-11-17 21:12:41','2025-11-17 21:12:41',NULL,'public'),(202,0,'9','9',9,'image/jpeg',33268,'cars/9.jpg','[]','2025-11-17 21:12:41','2025-11-17 21:12:41',NULL,'public'),(203,0,'90','90',9,'image/jpeg',33268,'cars/90.jpg','[]','2025-11-17 21:12:42','2025-11-17 21:12:42',NULL,'public'),(204,0,'91','91',9,'image/jpeg',33268,'cars/91.jpg','[]','2025-11-17 21:12:42','2025-11-17 21:12:42',NULL,'public'),(205,0,'92','92',9,'image/jpeg',33268,'cars/92.jpg','[]','2025-11-17 21:12:42','2025-11-17 21:12:42',NULL,'public'),(206,0,'93','93',9,'image/jpeg',33268,'cars/93.jpg','[]','2025-11-17 21:12:43','2025-11-17 21:12:43',NULL,'public'),(207,0,'94','94',9,'image/jpeg',33268,'cars/94.jpg','[]','2025-11-17 21:12:43','2025-11-17 21:12:43',NULL,'public'),(208,0,'95','95',9,'image/jpeg',33268,'cars/95.jpg','[]','2025-11-17 21:12:44','2025-11-17 21:12:44',NULL,'public'),(209,0,'96','96',9,'image/jpeg',33268,'cars/96.jpg','[]','2025-11-17 21:12:44','2025-11-17 21:12:44',NULL,'public'),(210,0,'97','97',9,'image/jpeg',33268,'cars/97.jpg','[]','2025-11-17 21:12:44','2025-11-17 21:12:44',NULL,'public'),(211,0,'98','98',9,'image/jpeg',33268,'cars/98.jpg','[]','2025-11-17 21:12:45','2025-11-17 21:12:45',NULL,'public'),(212,0,'99','99',9,'image/jpeg',33268,'cars/99.jpg','[]','2025-11-17 21:12:45','2025-11-17 21:12:45',NULL,'public'),(213,0,'car-1','car-1',9,'image/jpeg',33268,'cars/car-1.jpg','[]','2025-11-17 21:12:45','2025-11-17 21:12:45',NULL,'public'),(214,0,'car-2','car-2',9,'image/jpeg',33268,'cars/car-2.jpg','[]','2025-11-17 21:12:46','2025-11-17 21:12:46',NULL,'public'),(215,0,'car-3','car-3',9,'image/jpeg',33268,'cars/car-3.jpg','[]','2025-11-17 21:12:46','2025-11-17 21:12:46',NULL,'public'),(216,0,'car-4','car-4',9,'image/jpeg',33268,'cars/car-4.jpg','[]','2025-11-17 21:12:46','2025-11-17 21:12:46',NULL,'public'),(217,0,'car-5','car-5',9,'image/jpeg',33268,'cars/car-5.jpg','[]','2025-11-17 21:12:47','2025-11-17 21:12:47',NULL,'public'),(218,0,'car-6','car-6',9,'image/jpeg',33268,'cars/car-6.jpg','[]','2025-11-17 21:12:47','2025-11-17 21:12:47',NULL,'public'),(219,0,'car-7','car-7',9,'image/jpeg',33268,'cars/car-7.jpg','[]','2025-11-17 21:12:48','2025-11-17 21:12:48',NULL,'public'),(220,0,'car-8','car-8',9,'image/jpeg',33268,'cars/car-8.jpg','[]','2025-11-17 21:12:48','2025-11-17 21:12:48',NULL,'public'),(221,0,'car-interiors-1','car-interiors-1',9,'image/jpeg',33268,'cars/car-interiors-1.jpg','[]','2025-11-17 21:12:48','2025-11-17 21:12:48',NULL,'public'),(222,0,'car-interiors-2','car-interiors-2',9,'image/jpeg',33268,'cars/car-interiors-2.jpg','[]','2025-11-17 21:12:49','2025-11-17 21:12:49',NULL,'public'),(223,0,'car-interiors-3','car-interiors-3',9,'image/jpeg',33268,'cars/car-interiors-3.jpg','[]','2025-11-17 21:12:49','2025-11-17 21:12:49',NULL,'public'),(224,0,'car-interiors-4','car-interiors-4',9,'image/jpeg',33268,'cars/car-interiors-4.jpg','[]','2025-11-17 21:12:49','2025-11-17 21:12:49',NULL,'public'),(225,0,'car-interiors-5','car-interiors-5',9,'image/jpeg',33268,'cars/car-interiors-5.jpg','[]','2025-11-17 21:12:50','2025-11-17 21:12:50',NULL,'public'),(226,0,'car-interiors-6','car-interiors-6',9,'image/jpeg',33268,'cars/car-interiors-6.jpg','[]','2025-11-17 21:12:50','2025-11-17 21:12:50',NULL,'public'),(227,0,'car-interiors-7','car-interiors-7',9,'image/jpeg',33268,'cars/car-interiors-7.jpg','[]','2025-11-17 21:12:50','2025-11-17 21:12:50',NULL,'public'),(228,0,'car-interiors-8','car-interiors-8',9,'image/jpeg',33268,'cars/car-interiors-8.jpg','[]','2025-11-17 21:12:51','2025-11-17 21:12:51',NULL,'public'),(229,0,'img-1','img-1',9,'image/png',33268,'cars/img-1.png','[]','2025-11-17 21:12:51','2025-11-17 21:12:51',NULL,'public'),(230,0,'img-2','img-2',9,'image/png',33268,'cars/img-2.png','[]','2025-11-17 21:12:51','2025-11-17 21:12:51',NULL,'public'),(231,0,'banner-1','banner-1',10,'image/jpeg',23738,'sliders/banner-1.jpg','[]','2025-11-17 21:12:55','2025-11-17 21:12:55',NULL,'public'),(232,0,'banner-2','banner-2',10,'image/jpeg',23738,'sliders/banner-2.jpg','[]','2025-11-17 21:12:55','2025-11-17 21:12:55',NULL,'public'),(233,0,'img-1-1','img-1-1',10,'image/jpeg',23738,'sliders/img-1-1.jpg','[]','2025-11-17 21:12:55','2025-11-17 21:12:55',NULL,'public'),(234,0,'img-1','img-1',10,'image/jpeg',23738,'sliders/img-1.jpg','[]','2025-11-17 21:12:56','2025-11-17 21:12:56',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'general',NULL,'general',0,'2025-11-17 21:11:28','2025-11-17 21:11:28',NULL),(3,0,'news',NULL,'news',0,'2025-11-17 21:11:37','2025-11-17 21:11:37',NULL),(4,0,'galleries',NULL,'galleries',0,'2025-11-17 21:11:44','2025-11-17 21:11:44',NULL),(5,0,'teams',NULL,'teams',0,'2025-11-17 21:11:47','2025-11-17 21:11:47',NULL),(6,0,'testimonials',NULL,'testimonials',0,'2025-11-17 21:11:49','2025-11-17 21:11:49',NULL),(7,0,'locations',NULL,'locations',0,'2025-11-17 21:11:50','2025-11-17 21:11:50',NULL),(8,0,'customers',NULL,'customers',0,'2025-11-17 21:11:52','2025-11-17 21:11:52',NULL),(9,0,'cars',NULL,'cars',0,'2025-11-17 21:12:06','2025-11-17 21:12:06',NULL),(10,0,'sliders',NULL,'sliders',0,'2025-11-17 21:12:55','2025-11-17 21:12:55',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-11-17 21:11:37','2025-11-17 21:11:37');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(2,1,1,NULL,NULL,'https://carento.botble.com',NULL,0,'Home Page v1',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(3,1,1,NULL,NULL,'https://carento-home-2.botble.com',NULL,1,'Home Page v2',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(4,1,1,NULL,NULL,'https://carento-home-3.botble.com',NULL,2,'Home Page v3',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(5,1,0,NULL,NULL,'/',NULL,1,'Vehicles',NULL,'_self',1,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(6,1,5,7,'Botble\\Page\\Models\\Page','/car-list-1',NULL,0,'Cars List v1',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(7,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024',NULL,1,'Car Detail v1',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(8,1,5,8,'Botble\\Page\\Models\\Page','/car-list-2',NULL,2,'Car List v2',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(9,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-2',NULL,3,'Car Detail v2',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(10,1,5,9,'Botble\\Page\\Models\\Page','/car-list-3',NULL,4,'Car List v3',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(11,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-3',NULL,5,'Car Detail v3',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(12,1,5,10,'Botble\\Page\\Models\\Page','/car-list-4',NULL,6,'Car List v4',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(13,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-4',NULL,7,'Car Detail v4',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(14,1,0,NULL,NULL,'/',NULL,2,'Pages',NULL,'_self',1,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(15,1,14,6,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'About Us',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(16,1,14,4,'Botble\\Page\\Models\\Page','/services',NULL,1,'Our Services',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(17,1,14,5,'Botble\\Page\\Models\\Page','/pricing',NULL,2,'Pricing',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(18,1,14,12,'Botble\\Page\\Models\\Page','/faqs',NULL,3,'FAQs',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(19,1,14,14,'Botble\\Page\\Models\\Page','/car-dealers',NULL,4,'Car Dealers',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(20,1,14,17,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,5,'Term',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(21,1,14,NULL,NULL,'/login',NULL,6,'Login',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(22,1,14,NULL,NULL,'/register',NULL,7,'Register',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(23,1,0,NULL,NULL,'/',NULL,3,'News',NULL,'_self',1,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(24,1,23,2,'Botble\\Page\\Models\\Page','/blog',NULL,0,'News Grid',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(25,1,23,NULL,NULL,'/blog?style=list',NULL,1,'News List',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(26,1,23,NULL,NULL,'/news/top-5-new-cars-to-look-out-for-in-2024',NULL,2,'New Detail',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37'),(27,1,0,3,'Botble\\Page\\Models\\Page','/contact',NULL,4,'Contact',NULL,'_self',0,'2025-11-17 21:11:37','2025-11-17 21:11:37');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-11-17 21:11:37','2025-11-17 21:11:37');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'content_on_top','[\"[car-advance-search button_search_name=\\\"Find a Vehicle\\\" link_need_help=\\\"\\/faqs\\\" top=\\\"0\\\" bottom=\\\"0\\\" left=\\\"0\\\" right=\\\"0\\\" url=\\\"\\/cars\\\" tabs=\\\"all,new_car,used_car\\\"][\\/car-advance-search]\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:11:36','2025-11-17 21:11:36'),(2,'footer_on_top','[\"<p><span class=\\\"text-lg-medium color-white\\\">Get 5% discount when <\\/span><a class=\\\"text-primary\\\" href=\\\"#install-app\\\"><span class=\\\"text-lg-medium\\\">Ordering via APP<\\/span><\\/a><\\/p>\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:11:36','2025-11-17 21:11:36'),(3,'label_top','[\"+3600 cars for you\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(4,'keywords','[[{\"name\":\"Economy\",\"link\":\"\\/\"},{\"name\":\"Standard\",\"link\":\"\\/\"},{\"name\":\"Luxury\",\"link\":\"\\/\"},{\"name\":\"SUV\",\"link\":\"\\/\"},{\"name\":\"Convertible\",\"link\":\"\\/\"}]]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(5,'label_top','[\"Best car rental system\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(6,'keywords','[[{\"name\":\"Economy\",\"link\":\"\\/\"},{\"name\":\"Standard\",\"link\":\"\\/\"},{\"name\":\"Luxury\",\"link\":\"\\/\"},{\"name\":\"SUV\",\"link\":\"\\/\"},{\"name\":\"Convertible\",\"link\":\"\\/\"}]]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(7,'appearance','[\"style-2\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:11:36','2025-11-17 21:11:36'),(8,'subtitle','[\"2025 Mazda CX-50 <br class=\\\"d-none d-md-block\\\"> Review and news\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(9,'link_label','[\"View Details\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(10,'subtitle','[\"Hyundai Tucson Plug-In <br class=\\\"d-none d-md-block\\\"> Hybrid 2025 review\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(11,'link_label','[\"View Details\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:11:36','2025-11-17 21:11:36'),(12,'breadcrumb_simple','[true]',2,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(13,'breadcrumb_background_image','[\"backgrounds\\/contact-bg.jpg\"]',3,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(14,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(15,'breadcrumb_background_image','[\"backgrounds\\/service-bg.jpg\"]',4,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(16,'breadcrumb_text_color','[\"#ffffff\"]',4,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(17,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',5,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(18,'breadcrumb_text_color','[\"#ffffff\"]',5,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(19,'breadcrumb_background_image','[\"backgrounds\\/about-us-bg.jpg\"]',6,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(20,'breadcrumb_text_color','[\"#ffffff\"]',6,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(21,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(22,'breadcrumb_text_color','[\"#ffffff\"]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(23,'breadcrumb_display_last_update','[true]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(24,'breadcrumb_simple','[true]',12,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(25,'breadcrumb_background_image','[\"backgrounds\\/brand-bg.jpg\"]',13,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(26,'breadcrumb_text_color','[\"#ffffff\"]',13,'Botble\\Page\\Models\\Page','2025-11-17 21:11:36','2025-11-17 21:11:36'),(27,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',14,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(28,'breadcrumb_text_color','[\"#ffffff\"]',14,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(29,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',15,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(30,'breadcrumb_text_color','[\"#ffffff\"]',15,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(31,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',16,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(32,'breadcrumb_text_color','[\"#ffffff\"]',16,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(33,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',17,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(34,'breadcrumb_text_color','[\"#ffffff\"]',17,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(35,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',18,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(36,'breadcrumb_text_color','[\"#ffffff\"]',18,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(37,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',19,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(38,'breadcrumb_text_color','[\"#ffffff\"]',19,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(39,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',20,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(40,'breadcrumb_text_color','[\"#ffffff\"]',20,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(41,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',21,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(42,'breadcrumb_text_color','[\"#ffffff\"]',21,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(43,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',22,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(44,'breadcrumb_text_color','[\"#ffffff\"]',22,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(45,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',23,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(46,'breadcrumb_text_color','[\"#ffffff\"]',23,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(47,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',24,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(48,'breadcrumb_text_color','[\"#ffffff\"]',24,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(49,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',25,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(50,'breadcrumb_text_color','[\"#ffffff\"]',25,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(51,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',26,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(52,'breadcrumb_text_color','[\"#ffffff\"]',26,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(53,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',27,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(54,'breadcrumb_text_color','[\"#ffffff\"]',27,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(55,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',28,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(56,'breadcrumb_text_color','[\"#ffffff\"]',28,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(57,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',29,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(58,'breadcrumb_text_color','[\"#ffffff\"]',29,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(59,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',30,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(60,'breadcrumb_text_color','[\"#ffffff\"]',30,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(61,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',31,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(62,'breadcrumb_text_color','[\"#ffffff\"]',31,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(63,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',32,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(64,'breadcrumb_text_color','[\"#ffffff\"]',32,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(65,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',33,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(66,'breadcrumb_text_color','[\"#ffffff\"]',33,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(67,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',34,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(68,'breadcrumb_text_color','[\"#ffffff\"]',34,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(69,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',35,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(70,'breadcrumb_text_color','[\"#ffffff\"]',35,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(71,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',36,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(72,'breadcrumb_text_color','[\"#ffffff\"]',36,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(73,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',37,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(74,'breadcrumb_text_color','[\"#ffffff\"]',37,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(75,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',38,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(76,'breadcrumb_text_color','[\"#ffffff\"]',38,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(77,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',39,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(78,'breadcrumb_text_color','[\"#ffffff\"]',39,'Botble\\Page\\Models\\Page','2025-11-17 21:11:37','2025-11-17 21:11:37'),(79,'logo','[\"icons\\/activity.png\"]',1,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(80,'logo_dark','[\"icons\\/activity-w.png\"]',1,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(81,'logo','[\"icons\\/flash.png\"]',2,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(82,'logo_dark','[\"icons\\/flash-w.png\"]',2,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(83,'logo','[\"icons\\/list.png\"]',3,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(84,'logo_dark','[\"icons\\/list-w.png\"]',3,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(85,'logo','[\"icons\\/refresh.png\"]',4,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(86,'logo_dark','[\"icons\\/refresh-w.png\"]',4,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(87,'logo','[\"icons\\/ticket.png\"]',5,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(88,'logo_dark','[\"icons\\/ticket-w.png\"]',5,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(89,'logo','[\"icons\\/user.png\"]',6,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(90,'logo_dark','[\"icons\\/user-w.png\"]',6,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(91,'logo','[\"icons\\/ticket.png\"]',7,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(92,'logo_dark','[\"icons\\/ticket-w.png\"]',7,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(93,'logo','[\"icons\\/wallet.png\"]',8,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(94,'logo_dark','[\"icons\\/wallet-w.png\"]',8,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:11:47','2025-11-17 21:11:47'),(95,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:11:50','2025-11-17 21:11:50'),(96,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:11:50','2025-11-17 21:11:50'),(97,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:11:50','2025-11-17 21:11:50'),(98,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:11:50','2025-11-17 21:11:50'),(99,'logo_dark','[\"icons\\/lexus-w.png\"]',1,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(100,'logo_invert','[\"icons\\/lexus-w.png\"]',1,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(101,'logo_dark','[\"icons\\/mer-w.png\"]',2,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(102,'logo_invert','[\"icons\\/mer-i.png\"]',2,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(103,'logo_dark','[\"icons\\/bugatti-w.png\"]',3,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(104,'logo_invert','[\"icons\\/bugatti-w.png\"]',3,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(105,'logo_dark','[\"icons\\/jaguar-w.png\"]',4,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(106,'logo_invert','[\"icons\\/jaguar-w.png\"]',4,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(107,'logo_dark','[\"icons\\/honda-w.png\"]',5,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(108,'logo_invert','[\"icons\\/honda-w.png\"]',5,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(109,'logo_dark','[\"icons\\/chevrolet-w.png\"]',6,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(110,'logo_invert','[\"icons\\/chevrolet-w.png\"]',6,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(111,'logo_dark','[\"icons\\/acura-w.png\"]',7,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(112,'logo_invert','[\"icons\\/acura-w.png\"]',7,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(113,'logo_dark','[\"icons\\/bmw-w.png\"]',8,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(114,'logo_invert','[\"icons\\/bmw-i.png\"]',8,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(115,'logo_dark','[\"icons\\/toyota-w.png\"]',9,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(116,'logo_invert','[\"icons\\/toyota-i.png\"]',9,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(117,'logo_dark','[\"icons\\/ford-i.png\"]',10,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(118,'logo_invert','[\"icons\\/ford-i.png\"]',10,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(119,'logo_dark','[\"icons\\/nissan-w.png\"]',11,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(120,'logo_invert','[\"icons\\/nissan-i.png\"]',11,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(121,'logo_dark','[\"icons\\/opel-w.png\"]',12,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(122,'logo_invert','[\"icons\\/opel-i.png\"]',12,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(123,'logo_dark','[\"icons\\/bmw-w.png\"]',13,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(124,'logo_invert','[\"icons\\/bmw-i.png\"]',13,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(125,'logo_dark','[\"icons\\/toyota-w.png\"]',14,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(126,'logo_invert','[\"icons\\/toyota-i.png\"]',14,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:12:06','2025-11-17 21:12:06'),(127,'faq_ids','[[3,7,8,9,10]]',1,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(128,'faq_ids','[[4,5,7,9,10]]',2,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(129,'faq_ids','[[3,5,7,8,10]]',3,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(130,'faq_ids','[[5,6,8,9,10]]',4,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(131,'faq_ids','[[2,3,6,8,10]]',5,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(132,'faq_ids','[[1,2,3,6,7]]',6,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(133,'faq_ids','[[3,4,5,9,10]]',7,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(134,'faq_ids','[[1,3,5,6,10]]',8,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(135,'faq_ids','[[3,4,5,7,10]]',9,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(136,'faq_ids','[[1,2,6,8,9]]',10,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(137,'faq_ids','[[4,5,8,9,10]]',11,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(138,'faq_ids','[[1,3,5,7,9]]',12,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(139,'faq_ids','[[3,5,8,9,10]]',13,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(140,'faq_ids','[[1,2,5,8,10]]',14,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(141,'faq_ids','[[1,2,4,6,10]]',15,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(142,'faq_ids','[[3,4,5,6,8]]',16,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(143,'faq_ids','[[1,2,4,6,10]]',17,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(144,'faq_ids','[[5,7,8,9,10]]',18,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(145,'faq_ids','[[1,2,3,4,7]]',19,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(146,'faq_ids','[[1,2,3,4,6]]',20,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(147,'faq_ids','[[2,5,6,8,9]]',21,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(148,'faq_ids','[[1,4,6,7,8]]',22,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(149,'faq_ids','[[1,5,6,8,10]]',23,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(150,'faq_ids','[[1,2,4,5,6]]',24,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(151,'faq_ids','[[1,2,3,4,10]]',25,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(152,'faq_ids','[[2,3,6,7,9]]',26,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(153,'faq_ids','[[2,3,5,8,9]]',27,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(154,'faq_ids','[[1,2,3,5,10]]',28,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(155,'faq_ids','[[1,3,4,7,10]]',29,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(156,'faq_ids','[[2,5,6,7,8]]',30,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(157,'faq_ids','[[2,3,4,7,10]]',31,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(158,'faq_ids','[[5,6,7,9,10]]',32,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(159,'faq_ids','[[1,3,4,7,9]]',33,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(160,'faq_ids','[[1,2,3,6,9]]',34,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(161,'faq_ids','[[4,5,6,7,9]]',35,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(162,'faq_ids','[[1,2,6,8,10]]',36,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(163,'faq_ids','[[2,3,7,8,9]]',37,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(164,'faq_ids','[[2,3,5,8,9]]',38,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(165,'faq_ids','[[2,3,4,7,9]]',39,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(166,'faq_ids','[[1,4,5,9,10]]',40,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(167,'faq_ids','[[1,3,5,6,10]]',41,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(168,'faq_ids','[[2,4,5,7,9]]',42,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(169,'faq_ids','[[1,4,5,6,9]]',43,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(170,'faq_ids','[[2,3,6,9,10]]',44,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(171,'faq_ids','[[3,5,6,7,9]]',45,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(172,'faq_ids','[[2,6,8,9,10]]',46,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(173,'faq_ids','[[1,4,7,8,10]]',47,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(174,'faq_ids','[[1,4,5,9,10]]',48,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(175,'faq_ids','[[1,3,4,5,8]]',49,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(176,'faq_ids','[[2,6,7,8,10]]',50,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(177,'faq_ids','[[1,2,5,6,9]]',51,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:52','2025-11-17 21:12:52'),(178,'faq_ids','[[1,4,6,8,9]]',52,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(179,'faq_ids','[[1,2,3,8,10]]',53,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(180,'faq_ids','[[2,3,4,9,10]]',54,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(181,'faq_ids','[[4,5,6,7,9]]',55,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(182,'faq_ids','[[1,4,7,9,10]]',56,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(183,'faq_ids','[[1,3,4,5,8]]',57,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(184,'faq_ids','[[1,2,6,9,10]]',58,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(185,'faq_ids','[[1,2,3,5,6]]',59,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(186,'faq_ids','[[1,5,6,8,10]]',60,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(187,'faq_ids','[[1,2,4,7,8]]',61,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(188,'faq_ids','[[2,3,5,6,9]]',62,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(189,'faq_ids','[[6,7,8,9,10]]',63,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(190,'faq_ids','[[1,3,6,7,9]]',64,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(191,'faq_ids','[[4,5,6,8,9]]',65,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(192,'faq_ids','[[2,6,7,8,10]]',66,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(193,'faq_ids','[[2,4,5,6,10]]',67,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(194,'faq_ids','[[5,6,7,8,10]]',68,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(195,'faq_ids','[[2,3,5,7,10]]',69,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(196,'faq_ids','[[1,2,3,6,7]]',70,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(197,'faq_ids','[[2,3,4,5,10]]',71,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(198,'faq_ids','[[1,2,4,5,6]]',72,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(199,'faq_ids','[[1,3,5,7,10]]',73,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(200,'faq_ids','[[2,3,4,5,10]]',74,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(201,'faq_ids','[[2,3,5,7,10]]',75,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(202,'faq_ids','[[1,3,6,7,8]]',76,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(203,'faq_ids','[[1,2,5,7,10]]',77,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(204,'faq_ids','[[1,2,6,8,10]]',78,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(205,'faq_ids','[[5,6,7,9,10]]',79,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(206,'faq_ids','[[2,3,6,7,10]]',80,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(207,'faq_ids','[[2,4,7,9,10]]',81,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(208,'faq_ids','[[2,3,4,8,9]]',82,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(209,'faq_ids','[[1,2,4,9,10]]',83,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(210,'faq_ids','[[2,4,5,7,10]]',84,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(211,'faq_ids','[[1,4,5,8,10]]',85,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(212,'faq_ids','[[1,3,7,9,10]]',86,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(213,'faq_ids','[[2,3,7,8,9]]',87,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(214,'faq_ids','[[2,3,5,9,10]]',88,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(215,'faq_ids','[[4,6,7,8,9]]',89,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(216,'faq_ids','[[3,4,7,8,9]]',90,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(217,'faq_ids','[[5,7,8,9,10]]',91,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(218,'faq_ids','[[1,6,7,8,10]]',92,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(219,'faq_ids','[[1,5,6,7,10]]',93,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(220,'faq_ids','[[1,2,4,5,8]]',94,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(221,'faq_ids','[[3,5,6,7,9]]',95,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(222,'faq_ids','[[2,4,5,9,10]]',96,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(223,'faq_ids','[[3,5,6,8,9]]',97,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(224,'faq_ids','[[1,2,4,5,7]]',98,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(225,'faq_ids','[[2,3,4,9,10]]',99,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53'),(226,'faq_ids','[[1,2,3,8,9]]',100,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:12:53','2025-11-17 21:12:53');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2021_02_16_092633_remove_default_value_for_author_type',1),(30,'2021_03_27_144913_add_customer_type_into_table_payments',1),(31,'2021_05_24_034720_make_column_currency_nullable',1),(32,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(33,'2021_10_19_020859_update_metadata_field',1),(34,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(35,'2021_12_03_030600_create_blog_translations',1),(36,'2021_12_03_075608_create_page_translations',1),(37,'2021_12_03_082134_create_faq_translations',1),(38,'2021_12_03_082953_create_gallery_translations',1),(39,'2021_12_03_083642_create_testimonials_translations',1),(40,'2021_12_03_084118_create_location_translations',1),(41,'2021_12_03_094518_migrate_old_location_data',1),(42,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(43,'2022_01_16_085908_improve_plugin_location',1),(44,'2022_04_19_113923_add_index_to_table_posts',1),(45,'2022_04_20_100851_add_index_to_media_table',1),(46,'2022_04_20_101046_add_index_to_menu_table',1),(47,'2022_04_30_034048_create_gallery_meta_translations_table',1),(48,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(49,'2022_07_07_153354_update_charge_id_in_table_payments',1),(50,'2022_07_10_034813_move_lang_folder_to_root',1),(51,'2022_08_04_051940_add_missing_column_expires_at',1),(52,'2022_08_04_052122_delete_location_backup_tables',1),(53,'2022_09_01_000001_create_admin_notifications_tables',1),(54,'2022_10_14_024629_drop_column_is_featured',1),(55,'2022_11_02_092723_team_create_team_table',1),(56,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(57,'2022_12_02_093615_update_slug_index_columns',1),(58,'2023_01_30_024431_add_alt_to_media_table',1),(59,'2023_02_16_042611_drop_table_password_resets',1),(60,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(61,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(62,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(63,'2023_07_06_011444_create_slug_translations_table',1),(64,'2023_07_26_041451_add_more_columns_to_location_table',1),(65,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(66,'2023_08_11_060908_create_announcements_table',1),(67,'2023_08_11_094574_update_team_table',1),(68,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(69,'2023_08_21_090810_make_page_content_nullable',1),(70,'2023_08_29_074620_make_column_author_id_nullable',1),(71,'2023_08_29_075308_make_column_user_id_nullable',1),(72,'2023_09_14_021936_update_index_for_slugs_table',1),(73,'2023_09_14_022423_add_index_for_language_table',1),(74,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(75,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(76,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(77,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(78,'2023_11_30_085354_add_missing_description_to_team',1),(79,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(80,'2023_12_12_105220_drop_translations_table',1),(81,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(82,'2024_01_16_050056_create_comments_table',1),(83,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(84,'2024_03_25_000001_update_captcha_settings_for_contact',1),(85,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(86,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(87,'2024_04_19_063914_create_custom_fields_table',1),(88,'2024_04_27_100730_improve_analytics_setting',1),(89,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(90,'2024_07_04_083133_create_payment_logs_table',1),(91,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(92,'2024_07_12_100000_change_random_hash_for_media',1),(93,'2024_07_30_091615_fix_order_column_in_categories_table',1),(94,'2024_08_17_094600_add_image_into_countries',1),(95,'2024_08_22_062602_create_car_rentals_tables',1),(96,'2024_08_28_154009_create_cr_car_addresses',1),(97,'2024_09_05_151532_add_column_addresses_cars_table',1),(98,'2024_09_11_151251_create_cr_car_categories',1),(99,'2024_09_30_024515_create_sessions_table',1),(100,'2024_10_02_030027_add_more_columns_to_teams_translations_table',1),(101,'2024_12_11_044552_add_author_to_table_cr_cars',1),(102,'2024_12_11_082630_create_cr_messages_table',1),(103,'2024_12_12_034118_add_is_vendor_to_cr_customers',1),(104,'2024_12_12_082259_add_phone_to_table_cr_messages',1),(105,'2024_12_12_093603_add_vendor_verified_at_to_table_cr_customers',1),(106,'2024_12_19_000001_create_device_tokens_table',1),(107,'2024_12_19_000002_create_push_notifications_table',1),(108,'2024_12_19_000003_create_push_notification_recipients_table',1),(109,'2024_12_20_064621_add_moderation_status_to_cr_cars',1),(110,'2024_12_30_000001_create_user_settings_table',1),(111,'2024_12_30_022046_add_vendor_id_to_cr_bookings_table',1),(112,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(113,'2025_01_08_093652_add_zip_code_to_cities',1),(114,'2025_01_15_000000_add_completion_fields_to_cr_bookings_table',1),(115,'2025_01_17_043153_improve_invoices_table',1),(116,'2025_02_10_040833_add_reject_reason_to_cars',1),(117,'2025_02_11_153025_add_action_label_to_announcement_translations',1),(118,'2025_02_20_075043_improve_cr_cars_table',1),(119,'2025_03_23_075418_add_selling_features_to_cr_cars_table',1),(120,'2025_04_02_000000_rename_car_rentals_enabled_rental_booking_setting',1),(121,'2025_04_08_040931_create_social_logins_table',1),(122,'2025_04_10_000000_update_cr_taxes_table',1),(123,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(124,'2025_04_14_000001_create_category_commissions_table',1),(125,'2025_04_14_000002_create_customer_revenues_table',1),(126,'2025_04_14_000003_add_balance_column_to_customers_table',1),(127,'2025_04_14_000004_add_vendor_id_column_to_bookings_table',1),(128,'2025_04_14_000005_add_vendor_id_column_to_cars_table',1),(129,'2025_04_14_000006_create_customer_withdrawals_table',1),(130,'2025_04_14_000007_add_bank_info_to_customers_table',1),(131,'2025_04_20_081632_rename_current_location_to_location_in_cr_cars_table',1),(132,'2025_04_22_102623_set_moderation_status_to_approved_for_existing_cars',1),(133,'2025_04_23_000000_add_external_booking_url_to_cr_cars_table',1),(134,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(135,'2025_05_13_000000_add_price_type_column_to_cr_services_table',1),(136,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1),(137,'2025_06_04_000000_add_horsepower_to_cr_cars_table',1),(138,'2025_07_06_030754_add_phone_to_users_table',1),(139,'2025_07_11_160139_add_order_column_to_cr_car_makes_table',1),(140,'2025_07_11_160140_add_order_column_to_cr_car_types_table',1),(141,'2025_07_11_160141_add_order_column_to_cr_car_transmissions_table',1),(142,'2025_07_11_160142_add_order_column_to_cr_car_fuels_table',1),(143,'2025_07_11_160143_add_order_column_to_cr_car_addresses_table',1),(144,'2025_07_11_160144_add_order_column_to_cr_car_amenities_table',1),(145,'2025_07_11_160145_add_order_column_to_cr_car_colors_table',1),(146,'2025_07_14_014535_add_currency_tables_to_car_rentals',1),(147,'2025_07_14_025000_simplify_currency_implementation',1),(148,'2025_07_14_030502_add_currency_id_to_cr_services_table',1),(149,'2025_07_23_000000_create_car_amenity_categories_table',1),(150,'2025_07_23_000001_add_category_id_to_car_amenities_table',1),(151,'2025_07_23_add_icon_column_to_cr_car_amenities_table',1),(152,'2025_07_23_add_icon_column_to_cr_car_types_table',1),(153,'2025_07_31_083459_add_indexes_for_location_search_performance',1),(154,'2025_07_31_add_performance_indexes_to_slugs_table',1),(155,'2025_08_07_090752_add_verification_fields_to_cr_customers_table',1),(156,'2025_08_11_055037_add_location_fields_to_cr_cars_table',1),(157,'2025_08_11_063447_remove_address_fields_from_cr_cars_table',1),(158,'2025_08_11_064405_migrate_car_addresses_to_cities',1),(159,'2025_08_11_091336_add_address_to_cr_cars_table',1),(160,'2025_10_10_200000_add_advanced_fields_to_cr_currencies_table',1),(161,'2025_10_22_000001_add_whatsapp_to_cr_customers_table',1),(162,'2025_10_29_100000_add_sessions_invalidated_at_to_users_table',1),(163,'2025_11_07_000001_add_actor_type_to_audit_histories_table',1),(164,'2025_11_10_000000_cleanup_duplicate_widgets',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[simple-slider key=&quot;home-slider&quot; style=&quot;style-1&quot;][/simple-slider][car-types style=&quot;style-2&quot; title=&quot;Browse by Type&quot; sub_title=&quot;Find the perfect ride for any occasion&quot; car_types=&quot;1,2,3,4,5,6&quot; redirect_url=&quot;/cars&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/car-types][cars style=&quot;style-popular&quot; title=&quot;Popular Vehicles&quot; subtitle=&quot;Favorite vehicles based on customer reviews&quot; filter_types=&quot;category,fuel_type,order,price_range&quot; limit=&quot;8&quot; button_label=&quot;View More&quot; button_url=&quot;/Cars&quot;][/cars][rental-invitations title=&quot;Best Car Rental System&quot; description=&quot;Receive a Competitive Offer &lt;br&gt; Sell Your Car to Us Today.&quot; middle_image=&quot;icons/car-center.png&quot; background_image=&quot;backgrounds/background.jpg&quot; icon_1=&quot;icons/icon-1.png&quot; title_1=&quot;Looking for a rental car?&quot; subtitle_1=&quot;Find your perfect rental car for any journey, from road trips to business travel.&quot; button_url_1=&quot;/cars&quot; button_name_1=&quot;Get Started Now&quot; icon_2=&quot;icons/icon-2.png&quot; title_2=&quot;Looking for a rental car?&quot; subtitle_2=&quot;Find your perfect rental car for any journey, from road trips to business travel.&quot; button_url_2=&quot;/cars&quot; button_name_2=&quot;Get Started Now&quot; quantity=&quot;2&quot;][/rental-invitations][simple-slider key=&quot;home-slider-02&quot; style=&quot;style-2&quot;][/simple-slider][site-statistics style=&quot;style-1&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot; quantity=&quot;5&quot; background_color=&quot;rgb(227, 240, 255)&quot;][/site-statistics][cars style=&quot;style-feature&quot; title=&quot;Featured Listings&quot; subtitle=&quot;Find the perfect ride for any occasion&quot; limit=&quot;8&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/cars][brands style=&quot;style-2&quot; title=&quot;Premium Brands&quot; subtitle=&quot;Unveil the Finest Selection of High-End Vehicles&quot; brand_ids=&quot;2,8,9,10,11,12,13,14&quot; button_label=&quot;Show All Brands&quot; button_url=&quot;/brands&quot;][/brands][team title=&quot;Meet Our Agents&quot; subtitle=&quot;Awesome Teams&quot; team_ids=&quot;1,2,3,4,5,6,7,8&quot;][/team][car-loan-form style=&quot;style-2&quot; title=&quot;Want to Calculate Your Car Payment?&quot; description=&quot;Match with up to 4 lenders to get the lowest rate available with no markups, no fees, and no obligations.&quot; form_url=&quot;/contact&quot; form_title=&quot;Car Loan Calculator&quot; form_description=&quot;Estimate your monthly auto loan payments with this calculator.&quot; form_button_label=&quot;Apply for a loan&quot; background_image=&quot;backgrounds/car-loan-form-bg-1.jpg&quot; enable_lazy_loading=&quot;&quot;][/car-loan-form][testimonials title=&quot;What they say about us?&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot; style=&quot;style-2&quot; enable_lazy_loading=&quot;&quot;][/testimonials][why-us sub_title=&quot;HOW IT WORKS&quot; title=&quot;Presenting Your New Go-To Car &lt;br&gt; Rental Experience&quot; card_image_1=&quot;icons/car-location.png&quot; card_title_1=&quot;Choose a Location&quot; card_content_1=&quot;Select the ideal destination to begin your journey with ease&quot; card_image_2=&quot;icons/car-selected.png&quot; card_title_2=&quot;Choose Your Vehicle&quot; card_content_2=&quot;Browse our fleet and find the perfect car for your needs&quot; card_image_3=&quot;icons/car.png&quot; card_title_3=&quot;Verification&quot; card_content_3=&quot;Review your information and confirm your booking&quot; card_image_4=&quot;icons/car-key.png&quot; card_title_4=&quot;Begin Your Journey&quot; card_content_4=&quot;Start your adventure with confidence and ease&quot; quantity=&quot;4&quot;][/why-us][blog-posts style=&quot;style-2&quot; title=&quot;Inside &amp; Trending&quot; subtitle=&quot;The latest news and events&quot; category_ids=&quot;1,2,3,4,5,6,7,8,9,10&quot; button_label=&quot;Keep Reading&quot; limit=&quot;10&quot;][/blog-posts][install-apps style=&quot;style-2&quot; title=&quot;Carento App is Available&quot; description=&quot;Install App&quot; apps_description=&quot;Manage all your car rentals on the go with the Carento app&quot; android_app_url=&quot;/contact&quot; android_app_image=&quot;general/googleplay.png&quot; ios_app_url=&quot;/contact&quot; ios_app_image=&quot;general/appstore.png&quot; decor_image=&quot;general/phone.png&quot; button_label=&quot;Download Apps&quot; button_url=&quot;/contact&quot; background_color=&quot;#f6f3fc&quot;][/install-apps]',1,NULL,'homepage',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(2,'Blog','',1,NULL,'blog-with-sidebar',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(3,'Contact','[branch-locations title=\"Our agents worldwide\" quantity=\"4\" name_1=\"New York\" icon_image_1=\"icons/sedan-car-model.png\" phone_1=\"+1 212 555 0146\" email_1=\"newyork@carento.com\" address_1=\"750 7th Avenue, Manhattan, New York, NY 10019, USA\" name_2=\"Tokyo\" icon_image_2=\"icons/car-city-model.png\" phone_2=\"+81 3 3456 7890\" email_2=\"tokyo@carento.com\" address_2=\"2-11-3 Meguro, Meguro City, Tokyo 153-0063, Japan\" name_3=\"Paris\" icon_image_3=\"icons/jeep.png\" phone_3=\"+33 1 42 68 53 00\" email_3=\"paris@carento.com\" address_3=\"22 Rue de la Paix, 75002 Paris, France\" name_4=\"Sydney\" icon_image_4=\"icons/pick-up.png\" phone_4=\"+61 2 9255 6000\" email_4=\"sydney@carento.com\" address_4=\"88 George Street, The Rocks, Sydney NSW 2000, Australia\"][/branch-locations][contact-form display_fields=\"phone,email,subject,address\" mandatory_fields=\"email\" title=\"Get in Touch\" show_map=\"0,1\" map_title=\"Our location\" map_address=\"12560 Rental Rd, Memphis, TN 38118, United States\"][/contact-form]',1,NULL,NULL,NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(4,'Services','[car-services title=\"Comprehensive Car Rental Services to Meet All Your Needs\" description=\"From daily rentals to long-term solutions, we offer a comprehensive range of vehicles and services to suit every need and budget.\" limit=\"10\"][/car-services][promotion-block title=\"Best Car Rent Deals\" subtitle=\"Save 15% or more when you book and ride before 1 April 2025\" button_label=\"Find Early 2025 Deals\" button_url=\"/cars\" background_image=\"backgrounds/promotion-block-bg.jpg\"][/promotion-block][testimonials title=\"What they say about us?\" subtitle=\"Testimonials\" testimonial_ids=\"1,2,3,4\" style=\"style-2\" enable_lazy_loading=\"\"][/testimonials][intro-video title=\"Receive a Competitive Offer Sell Your Car to Us Today.\" description=\"We are committed to delivering exceptional service, competitive pricing, and a diverse selection of options for our customers.\" subtitle=\"Best Car Rental System\" image=\"general/1.jpg\" content_1=\"Expert Certified Mechanics\" content_2=\"First Class Services\" content_3=\"Get Reasonable Price\" content_4=\"24/7 road assistance\" content_5=\"Genuine Spares Parts\" content_6=\"Free Pick-Up & Drop-Offs\" quantity=\"6\"][/intro-video][site-statistics quantity=\"5\" title_1=\"Global <br> Branches\" data_1=\"45\" unit_1=\"+\" title_2=\"Destinations  <br> Collaboration\" data_2=\"29\" unit_2=\"K\" title_3=\"Years <br> Experience\" data_3=\"20\" unit_3=\"+\" title_4=\"Happy <br> Customers\" data_4=\"168\" unit_4=\"K\" title_5=\"User  <br> Account\" data_5=\"15\" unit_5=\"M\"][/site-statistics][blog-posts style=\"style-1\" title=\"Upcoming Cars & Events\" subtitle=\"Stay ahead with the latest car releases and upcoming events\" button_label=\"Keep Reading\" category_ids=\"1,2,3,4,5\" limit=\"10\"][/blog-posts]',1,NULL,'full-width',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(5,'Pricing','[pricing title=\"Membership Plans\" button_label_monthly=\"Monthly Price\" button_label_yearly=\"Annual Price\" quantity=\"4\" name_1=\"Basic\" description_1=\"For most businesses that want to optimize web queries\" monthly_price_1=\"19\" yearly_price_1=\"348\" features_1=\"+ Access to standard vehicles \\n + 24/7 customer support \\n + Basic insurance coverage \\n + Online booking \\n + Standard roadside assistance \\n+ One free vehicle per month\" button_label_1=\"Get Started Now\" button_url_1=\"/\" name_2=\"Standard\" description_2=\"For most businesses that want to optimize web queries\" monthly_price_2=\"29\" yearly_price_2=\"348\" features_2=\"+ All Basic Plan features \\n + Access to premium vehicles \\n + Flexible rental terms \\n + GPS included \\n + Free additional driver \\n + Unlimited vehicle swaps\" button_label_2=\"Get Started Now\" button_url_2=\"/\" name_3=\"Premium\" description_3=\"For most businesses that want to optimize web queries\" monthly_price_3=\"49\" yearly_price_3=\"585\" features_3=\"+ All Standard Plan features \\n + Luxury vehicle options \\n + Complimentary upgrades \\n + Enhanced insurance coverage \\n + Free airport pickup, drop off \\n + Exclusive deals and offers\" button_label_3=\"Get Started Now\" button_url_3=\"/\" name_4=\"VIP\" description_4=\"For most businesses that want to optimize web queries\" monthly_price_4=\"99\" yearly_price_4=\"1185\" features_4=\"+ All Premium Plan features \\n + VIP transfer service \\n + Personal concierge \\n + Unlimited mileage \\n + Luxury vehicle upgrades \\n + 24/7 account manager\" button_label_4=\"Get Started Now\" button_url_4=\"/\"][/pricing][faqs title=\"Frequently Asked Questions\" description=\"Any questions? We would be happy to help you.\" faq_category_ids=\"1,2,3,4,5\" limit=\"10\" button_secondary_label=\"Contact Us\" button_secondary_url=\"/contact\" button_primary_label=\"Submit A Ticket\" button_primary_url=\"/\"][/faqs]',1,NULL,'full-width',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(6,'About Us','[about-us-information title=&quot;The Future of &lt;br&gt; Car Rental is Here&quot; description=&quot;Welcome to Carento, your trusted partner in car rentals. Since our founding, we have been committed to providing our customers with a seamless and reliable car rental experience. Whether you are planning a business trip, a family vacation, or just need a vehicle for everyday use, we offer a wide range of vehicles to meet your needs.&quot; quantity=&quot;3&quot; data_number_1=&quot;86&quot; data_title_1=&quot;Industry &lt;br&gt; Experts&quot; image_1=&quot;general/about-us-1.jpg&quot; image_2=&quot;general/about-us-2.jpg&quot; data_number_3=&quot;25&quot; data_title_3=&quot;Years in Business&quot; image_3=&quot;general/about-us-3.jpg&quot;][/about-us-information][why-us card_image_1=&quot;icons/car-location.png&quot; card_title_1=&quot;Choose a Location&quot; card_content_1=&quot;Select the ideal destination to begin your journey with ease&quot; card_image_2=&quot;icons/money.png&quot; card_title_2=&quot;Transparent Pricing&quot; card_content_2=&quot;Enjoy clear and upfront pricing with no surprises, ensuring you know exactly what you are paying for.&quot; card_image_3=&quot;icons/convenient.png&quot; card_title_3=&quot;Convenient Booking&quot; card_content_3=&quot;Benefit from a variety of rental options, including short-term, long-term, and weekend specials&quot; card_image_4=&quot;icons/supporter.png&quot; card_title_4=&quot;24/7 Customer Support&quot; card_content_4=&quot;Get assistance whenever you need it with our dedicated support team available around the clock.&quot; quantity=&quot;4&quot;][/why-us][team title=&quot;Meet Our Agents&quot; subtitle=&quot;Awesome Teams&quot; team_ids=&quot;1,2,3,5&quot;][/team][featured-block style=&quot;style-2&quot; title=&quot;Sell your car at a fair price. Get started with us today.&quot; subtitle=&quot;Our Mission&quot; description=&quot;Our mission is to make car rental easy, accessible, and affordable for everyone. We believe that renting a car should be a hassle-free experience, and we are dedicated to ensuring that every customer finds the perfect vehicle for their journey.&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot; 24/7 customer support for assistance anytime, anywhere&quot; image_1=&quot;general/img-2-1.png&quot; image_2=&quot;general/img-2-2.png&quot; image_3=&quot;general/img-2-3.png&quot; image_4=&quot;general/img-2-4.png&quot; enable_lazy_loading=&quot;no&quot;][/featured-block][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot; background_color=&quot;#d8f4db&quot;][/site-statistics][intro-video style=&quot;style-2&quot; title=&quot;Carento offers clear pricing and 24/7 great support.&quot; subtitle=&quot;Our Commitment&quot; description=&quot;We are committed to offering transparent pricing with no hidden fees, comprehensive insurance options for peace of mind, and 24/7 customer support to assist you whenever you need it. At Carento, your satisfaction is our top priority.&quot; youtube_video_url=&quot;https://www.youtube.com/watch?v=ldusxyoq0Y8&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot;24/7 customer support for assistance anytime, anywhere&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; image=&quot;general/3.jpg&quot; image_1=&quot;general/2.jpg&quot; enable_lazy_loading=&quot;&quot;][/intro-video][testimonials title=&quot;What they say about us?&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot; style=&quot;style-2&quot; enable_lazy_loading=&quot;&quot;][/testimonials][blog-posts style=&quot;style-1&quot; title=&quot;Upcoming Cars &amp; Events&quot; subtitle=&quot;Stay ahead with the latest car releases and upcoming events&quot; button_label=&quot;Keep Reading&quot; category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot;][/blog-posts]',1,NULL,'full-width',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(7,'Car List 1','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;yes&quot; default_layout=&quot;grid&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(8,'Car List 2','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;no&quot; default_layout=&quot;grid&quot; layout_col=&quot;4&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(9,'Car List 3','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;no&quot; default_layout=&quot;grid&quot; layout_col=&quot;3&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(10,'Car List 4','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;yes&quot; default_layout=&quot;list&quot; layout_col=&quot;4&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(11,'Agencies','[team title=\"Meet Our Agents\" subtitle=\"Awesome Teams\" team_ids=\"1,2,3,4,5,6,7,8\"][/team]',1,NULL,'full-width',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(12,'Faqs','[faq-categories title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot;][/faq-categories][faqs title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot; faq_category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot; button_secondary_label=&quot;Contact Us&quot; button_secondary_url=&quot;/contact&quot; button_primary_label=&quot;Submit A Ticket&quot; button_primary_url=&quot;/&quot;][/faqs][faqs title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot; faq_category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot; button_secondary_label=&quot;Contact Us&quot; button_secondary_url=&quot;/contact&quot; button_primary_label=&quot;Submit A Ticket&quot; button_primary_url=&quot;/&quot;][/faqs][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot;][/site-statistics]',1,NULL,'full-width',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(13,'Brands','[brands title=\"Brands\" style=\"style-3\" brand_ids=\"1,2,3,4,5,6,7,8,9,10,11,12,13,14\"][/brands]',1,NULL,NULL,NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(14,'Car Dealers','[car-dealers title=\"Our Trusted Car Dealers\" subtitle=\"Find the best car dealers with excellent service and competitive prices\" limit=\"12\" show_car_count=\"yes\" button_label=\"View All Dealers\" button_url=\"/car-dealers\"][/car-dealers]',1,NULL,'full-width',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(15,'Our Awards','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(16,'Copyright Notices','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(17,'Terms of Use','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(18,'Privacy Notice','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(19,'Lost &amp; Found','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(20,'Car Rental Services','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(21,'Vehicle Leasing Options','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(22,'Long-Term Car Rentals','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(23,'Car Sales and Trade-Ins','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(24,'Luxury Car Rentals','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(25,'Rent-to-Own Programs','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(26,'Fleet Management Solutions','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(27,'Affiliates','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(28,'Travel Agents','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(29,'AARP Members','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(30,'Points Programs','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(31,'Military &amp; Veterans','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(32,'Work with us','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(33,'Advertise with us','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(34,'Forum support','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(35,'Help Center','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(36,'Live chat','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(37,'How it works','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(38,'Security','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(39,'Refund Policy','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:12:56','2025-11-17 21:12:56');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',29,'UOXBBZNL6OHH','sslcommerz',NULL,90.00,0.00,1,'pending','direct',29,NULL,NULL,'2025-10-08 21:12:53','2025-10-08 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(2,'USD',23,'ZCGLSC8SUZ6U','razorpay',NULL,180.00,0.00,2,'completed','direct',23,NULL,NULL,'2025-10-10 21:12:53','2025-10-10 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(3,'USD',23,'OXDZNM4S10DD','sslcommerz',NULL,448.00,0.00,3,'pending','direct',23,NULL,NULL,'2025-11-15 21:12:53','2025-11-15 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(4,'USD',30,'YBJKVJJFBLS0','paypal',NULL,315.00,0.00,4,'pending','direct',30,NULL,NULL,'2025-10-20 21:12:53','2025-10-20 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(5,'USD',31,'ASA9YOCIKXOE','stripe',NULL,81.00,0.00,5,'pending','direct',31,NULL,NULL,'2025-11-07 21:12:53','2025-11-07 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(6,'USD',25,'S59KBF1VM2KY','razorpay',NULL,30.00,0.00,6,'completed','direct',25,NULL,NULL,'2025-10-12 21:12:53','2025-10-12 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(7,'USD',25,'4J49LW7GYNHB','stripe',NULL,120.00,0.00,7,'completed','direct',25,NULL,NULL,'2025-10-06 21:12:53','2025-10-06 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(8,'USD',31,'TI5DZ2IFKHTW','paypal',NULL,240.00,0.00,8,'completed','direct',31,NULL,NULL,'2025-10-25 21:12:53','2025-10-25 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(9,'USD',27,'IM8SRT9MIDO7','paystack',NULL,130.00,0.00,9,'pending','direct',27,NULL,NULL,'2025-11-13 21:12:53','2025-11-13 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(10,'USD',28,'WMIDTEQFSAZT','paypal',NULL,225.00,0.00,10,'pending','direct',28,NULL,NULL,'2025-10-06 21:12:53','2025-10-06 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(11,'USD',25,'TR6QQUNDPIYG','stripe',NULL,450.00,0.00,11,'completed','direct',25,NULL,NULL,'2025-10-27 21:12:53','2025-10-27 21:12:53','Botble\\CarRentals\\Models\\Customer',NULL),(12,'USD',26,'80O6RJ22U67N','paystack',NULL,210.00,0.00,12,'pending','direct',26,NULL,NULL,'2025-10-06 21:12:54','2025-10-06 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(13,'USD',23,'TJDGKUZU58B0','cod',NULL,400.00,0.00,13,'pending','direct',23,NULL,NULL,'2025-10-11 21:12:54','2025-10-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(14,'USD',28,'CCF12TMFWXZG','paypal',NULL,188.00,0.00,14,'completed','direct',28,NULL,NULL,'2025-10-06 21:12:54','2025-10-06 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(15,'USD',25,'NFECDBY722CU','bank_transfer',NULL,74.00,0.00,15,'pending','direct',25,NULL,NULL,'2025-09-22 21:12:54','2025-09-22 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(16,'USD',24,'HYJHEGA2TICV','razorpay',NULL,301.00,0.00,16,'completed','direct',24,NULL,NULL,'2025-10-12 21:12:54','2025-10-12 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(17,'USD',28,'VT9MO7HQXTAR','razorpay',NULL,217.00,0.00,17,'pending','direct',28,NULL,NULL,'2025-09-23 21:12:54','2025-09-23 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(18,'USD',27,'T5PCMY06LHVT','sslcommerz',NULL,192.00,0.00,18,'pending','direct',27,NULL,NULL,'2025-10-27 21:12:54','2025-10-27 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(19,'USD',23,'MGAWZLAU9DXF','paystack',NULL,48.00,0.00,19,'completed','direct',23,NULL,NULL,'2025-09-22 21:12:54','2025-09-22 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(20,'USD',29,'N8MIO4JERQPO','cod',NULL,66.00,0.00,20,'pending','direct',29,NULL,NULL,'2025-09-20 21:12:54','2025-09-20 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(21,'USD',23,'PRYYFTCSLEDD','stripe',NULL,420.00,0.00,21,'completed','direct',23,NULL,NULL,'2025-10-04 21:12:54','2025-10-04 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(22,'USD',30,'EY74DQRVJ5YZ','stripe',NULL,96.00,0.00,22,'completed','direct',30,NULL,NULL,'2025-10-27 21:12:54','2025-10-27 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(23,'USD',30,'0B8XZP9SZSDP','stripe',NULL,61.00,0.00,23,'pending','direct',30,NULL,NULL,'2025-11-10 21:12:54','2025-11-10 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(24,'USD',24,'G24NLU9L0HOH','stripe',NULL,62.00,0.00,24,'completed','direct',24,NULL,NULL,'2025-11-08 21:12:54','2025-11-08 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(25,'USD',23,'LPPKZJGDYTYA','bank_transfer',NULL,594.00,0.00,25,'completed','direct',23,NULL,NULL,'2025-10-17 21:12:54','2025-10-17 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(26,'USD',23,'2PQL8JF7SGBF','paystack',NULL,360.00,0.00,26,'completed','direct',23,NULL,NULL,'2025-10-21 21:12:54','2025-10-21 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(27,'USD',25,'RAPXZUSW3BEU','stripe',NULL,31.00,0.00,27,'completed','direct',25,NULL,NULL,'2025-10-24 21:12:54','2025-10-24 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(28,'USD',22,'PZ0XSLQ4K7PI','paypal',NULL,174.00,0.00,28,'completed','direct',22,NULL,NULL,'2025-11-08 21:12:54','2025-11-08 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(29,'USD',24,'L8ZH6NERN4P7','bank_transfer',NULL,455.00,0.00,29,'completed','direct',24,NULL,NULL,'2025-09-22 21:12:54','2025-09-22 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(30,'USD',26,'BLRQKEFUW0WY','razorpay',NULL,228.00,0.00,30,'pending','direct',26,NULL,NULL,'2025-09-20 21:12:54','2025-09-20 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(31,'USD',23,'BNVCIFSXNIS6','stripe',NULL,300.00,0.00,31,'pending','direct',23,NULL,NULL,'2025-11-11 21:12:54','2025-11-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(32,'USD',30,'K1G7AFTT9SSE','stripe',NULL,42.00,0.00,32,'pending','direct',30,NULL,NULL,'2025-11-11 21:12:54','2025-11-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(33,'USD',21,'BIJEDSEN9HWZ','razorpay',NULL,252.00,0.00,33,'completed','direct',21,NULL,NULL,'2025-11-15 21:12:54','2025-11-15 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(34,'USD',24,'JF2EWR13XBG0','razorpay',NULL,270.00,0.00,34,'pending','direct',24,NULL,NULL,'2025-11-12 21:12:54','2025-11-12 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(35,'USD',29,'NRPSKZE932W3','paystack',NULL,126.00,0.00,35,'pending','direct',29,NULL,NULL,'2025-11-10 21:12:54','2025-11-10 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(36,'USD',23,'TKZ3JQUUKZHF','paystack',NULL,64.00,0.00,36,'completed','direct',23,NULL,NULL,'2025-11-16 21:12:54','2025-11-16 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(37,'USD',22,'CRNNL4TGXQ0Z','razorpay',NULL,376.00,0.00,37,'completed','direct',22,NULL,NULL,'2025-11-16 21:12:54','2025-11-16 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(38,'USD',29,'FUGS2CBYS1ZJ','paystack',NULL,292.00,0.00,38,'pending','direct',29,NULL,NULL,'2025-11-11 21:12:54','2025-11-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(39,'USD',21,'QAZAC8AMVNAG','stripe',NULL,294.00,0.00,39,'pending','direct',21,NULL,NULL,'2025-11-13 21:12:54','2025-11-13 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(40,'USD',21,'D7UES41XYKYB','stripe',NULL,243.00,0.00,40,'pending','direct',21,NULL,NULL,'2025-11-11 21:12:54','2025-11-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(41,'USD',27,'Q9PGFTBS2BXH','paystack',NULL,420.00,0.00,41,'pending','direct',27,NULL,NULL,'2025-11-13 21:12:54','2025-11-13 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(42,'USD',23,'TH3EWNRG7WU6','razorpay',NULL,189.00,0.00,42,'pending','direct',23,NULL,NULL,'2025-11-17 21:12:54','2025-11-17 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(43,'USD',31,'CQ3FOOD9CIY3','sslcommerz',NULL,189.00,0.00,43,'completed','direct',31,NULL,NULL,'2025-11-13 21:12:54','2025-11-13 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(44,'USD',28,'JL4PZU8S48Z8','paypal',NULL,86.00,0.00,44,'pending','direct',28,NULL,NULL,'2025-11-11 21:12:54','2025-11-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(45,'USD',23,'QYQUOKBVSTGB','sslcommerz',NULL,268.00,0.00,45,'pending','direct',23,NULL,NULL,'2025-11-10 21:12:54','2025-11-10 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(46,'USD',25,'WO3ZIB1QKUUO','paystack',NULL,186.00,0.00,46,'pending','direct',25,NULL,NULL,'2025-11-10 21:12:54','2025-11-10 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(47,'USD',27,'6G3VSWAIFGXI','bank_transfer',NULL,210.00,0.00,47,'completed','direct',27,NULL,NULL,'2025-11-15 21:12:54','2025-11-15 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(48,'USD',24,'MWBGYINZMAS9','stripe',NULL,147.00,0.00,48,'pending','direct',24,NULL,NULL,'2025-11-15 21:12:54','2025-11-15 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(49,'USD',22,'C7MHE43NDZC4','bank_transfer',NULL,294.00,0.00,49,'completed','direct',22,NULL,NULL,'2025-11-15 21:12:54','2025-11-15 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(50,'USD',25,'GDNEDE7DVUP0','bank_transfer',NULL,490.00,0.00,50,'pending','direct',25,NULL,NULL,'2025-11-12 21:12:54','2025-11-12 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(51,'USD',27,'CVRDQCAUNJ7C','cod',NULL,462.00,0.00,51,'pending','direct',27,NULL,NULL,'2025-11-25 21:12:54','2025-11-25 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(52,'USD',24,'ON5D5KZ5MMT5','bank_transfer',NULL,275.00,0.00,52,'pending','direct',24,NULL,NULL,'2025-11-20 21:12:54','2025-11-20 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(53,'USD',25,'4RRKMOBSMYFY','paystack',NULL,252.00,0.00,53,'pending','direct',25,NULL,NULL,'2025-11-30 21:12:54','2025-11-30 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(54,'USD',29,'WQQO33XRJXXD','paystack',NULL,245.00,0.00,54,'pending','direct',29,NULL,NULL,'2025-12-07 21:12:54','2025-12-07 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(55,'USD',24,'TGRRJZMKUH7E','paypal',NULL,189.00,0.00,55,'pending','direct',24,NULL,NULL,'2025-11-28 21:12:54','2025-11-28 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(56,'USD',21,'CTFY3K6MZ4FW','sslcommerz',NULL,183.00,0.00,56,'pending','direct',21,NULL,NULL,'2025-12-04 21:12:54','2025-12-04 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(57,'USD',22,'IMGB9ATUHCGE','paypal',NULL,32.00,0.00,57,'pending','direct',22,NULL,NULL,'2025-12-09 21:12:54','2025-12-09 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(58,'USD',23,'WGYOJ5LO0DGQ','razorpay',NULL,180.00,0.00,58,'pending','direct',23,NULL,NULL,'2025-12-11 21:12:54','2025-12-11 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(59,'USD',23,'DYRNJG4HX9PD','cod',NULL,455.00,0.00,59,'pending','direct',23,NULL,NULL,'2025-12-13 21:12:54','2025-12-13 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(60,'USD',26,'FZWHH5D29EHB','razorpay',NULL,300.00,0.00,60,'pending','direct',26,NULL,NULL,'2025-11-30 21:12:54','2025-11-30 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(61,'USD',30,'SAM6EWETTBUS','bank_transfer',NULL,30.00,0.00,61,'pending','direct',30,NULL,NULL,'2025-12-05 21:12:54','2025-12-05 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(62,'USD',26,'164PMKDBCTRX','paypal',NULL,126.00,0.00,62,'pending','direct',26,NULL,NULL,'2025-11-22 21:12:54','2025-11-22 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(63,'USD',22,'PRTN5YIBJUO6','razorpay',NULL,623.00,0.00,63,'pending','direct',22,NULL,NULL,'2025-12-09 21:12:54','2025-12-09 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(64,'USD',23,'VTJKJ8SYTLYM','paystack',NULL,243.00,0.00,64,'pending','direct',23,NULL,NULL,'2025-12-06 21:12:54','2025-12-06 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(65,'USD',27,'V00P6MOT7WTA','cod',NULL,480.00,0.00,65,'pending','direct',27,NULL,NULL,'2025-12-07 21:12:54','2025-12-07 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(66,'USD',21,'HJZHAHCBPUFW','paypal',NULL,235.00,0.00,66,'pending','direct',21,NULL,NULL,'2025-12-12 21:12:54','2025-12-12 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(67,'USD',28,'CLULGXNQPMEW','sslcommerz',NULL,129.00,0.00,67,'pending','direct',28,NULL,NULL,'2025-12-09 21:12:54','2025-12-09 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(68,'USD',27,'G6RBIT7YWA0F','cod',NULL,219.00,0.00,68,'pending','direct',27,NULL,NULL,'2025-11-19 21:12:54','2025-11-19 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(69,'USD',23,'XGH7LK3CXBRO','bank_transfer',NULL,511.00,0.00,69,'pending','direct',23,NULL,NULL,'2025-11-26 21:12:54','2025-11-26 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(70,'USD',21,'OVLE2GHIFSRF','paystack',NULL,273.00,0.00,70,'pending','direct',21,NULL,NULL,'2025-12-07 21:12:54','2025-12-07 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(71,'USD',29,'0SSSTQHLYFLP','stripe',NULL,252.00,0.00,71,'pending','direct',29,NULL,NULL,'2025-12-14 21:12:54','2025-12-14 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(72,'USD',21,'YRLM6JLNBNMX','cod',NULL,301.00,0.00,72,'pending','direct',21,NULL,NULL,'2025-11-18 21:12:54','2025-11-18 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(73,'USD',30,'8VTQ3LD18CHF','bank_transfer',NULL,47.00,0.00,73,'pending','direct',30,NULL,NULL,'2025-11-22 21:12:54','2025-11-22 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(74,'USD',22,'UEHJXR139VZX','paypal',NULL,186.00,0.00,74,'pending','direct',22,NULL,NULL,'2025-11-29 21:12:54','2025-11-29 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(75,'USD',24,'T8STZPZTDXVF','paypal',NULL,64.00,0.00,75,'pending','direct',24,NULL,NULL,'2025-11-18 21:12:54','2025-11-18 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(76,'USD',23,'WDOB4JQMFWKO','sslcommerz',NULL,438.00,0.00,76,'pending','direct',23,NULL,NULL,'2025-12-08 21:12:54','2025-12-08 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(77,'USD',31,'QQIEITPT9Y78','razorpay',NULL,180.00,0.00,77,'pending','direct',31,NULL,NULL,'2025-12-15 21:12:54','2025-12-15 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(78,'USD',30,'QNNODOUZNVQR','paypal',NULL,455.00,0.00,78,'pending','direct',30,NULL,NULL,'2025-11-24 21:12:54','2025-11-24 21:12:54','Botble\\CarRentals\\Models\\Customer',NULL),(79,'USD',21,'0R0CF71AVUEK','cod',NULL,34.00,0.00,79,'pending','direct',21,NULL,NULL,'2025-11-29 21:12:55','2025-11-29 21:12:55','Botble\\CarRentals\\Models\\Customer',NULL),(80,'USD',24,'WT58ZAF55G2W','razorpay',NULL,126.00,0.00,80,'pending','direct',24,NULL,NULL,'2025-11-25 21:12:55','2025-11-25 21:12:55','Botble\\CarRentals\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (5,1),(2,1),(4,2),(8,2),(3,3),(9,3),(1,4),(10,4),(1,5),(2,5),(5,6),(7,6),(5,7),(2,7),(4,8),(8,8),(6,9),(10,9),(5,10),(10,10),(10,11),(5,12),(4,12),(9,13),(3,13),(3,14),(10,14),(3,15),(1,15),(10,16),(3,16),(10,17),(5,17),(2,18),(1,18),(8,19),(9,19),(2,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (1,1),(8,1),(5,2),(4,2),(8,2),(5,3),(6,3),(4,3),(10,4),(4,4),(1,4),(7,5),(6,5),(1,5),(5,6),(6,6),(3,7),(7,7),(4,8),(7,8),(1,8),(7,9),(4,9),(1,9),(10,10),(3,10),(8,10),(9,11),(4,11),(8,11),(10,12),(5,12),(1,12),(5,13),(6,13),(6,14),(9,14),(10,14),(10,15),(8,15),(6,16),(3,16),(7,17),(2,17),(3,17),(1,18),(6,18),(2,19),(4,19),(3,19),(6,20),(4,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Top 5 New Cars to Look Out for in 2024','Discover the most anticipated car models coming in 2024, featuring cutting-edge technology and stunning designs.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quam qui est minima ut vel quia. Optio voluptatum ut labore molestias neque repudiandae. Expedita aliquid voluptatibus nulla consequatur iste. Est magni omnis quia suscipit alias et accusantium. Porro nesciunt nobis incidunt suscipit omnis voluptatum. Excepturi et accusantium sunt eos est.\" content_2=\"Sit amet nisi ullam quaerat ut sed officiis. Dolor aperiam sit voluptatem qui officiis et aut culpa. Temporibus ullam non temporibus ut amet error est beatae. Cumque rem rem dolorem voluptas modi tempora. Minima aut iste omnis veritatis veritatis molestiae pariatur rerum. Aut deserunt et similique consequuntur doloremque. Nam saepe aspernatur vel et similique. Soluta eligendi quis id.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/1.jpg',249,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(2,'How to Choose the Best Car Rental Service for Your Trip','A comprehensive guide on selecting the right car rental service based on your travel needs and budget.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Temporibus ut rem non vel. Dolorem et quo tempora dicta. Possimus voluptas facere totam facere eligendi possimus suscipit. Quia illo fuga dolores nostrum blanditiis. Maxime unde qui id hic. Ut quaerat error temporibus sed accusantium eum debitis unde. Sunt voluptas occaecati temporibus eaque esse voluptas.\" content_2=\"Quo aut vel sunt pariatur animi et placeat. Molestiae eaque quidem provident. Omnis voluptate commodi sunt expedita dolorum ipsa deleniti accusantium. Provident magni totam ea et rerum natus. Est delectus quo nam ducimus. Maiores sequi qui dolorum iste ut minima. Perferendis quidem et odit consequatur possimus amet.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/2.jpg',1234,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(3,'The Evolution of Electric Vehicles: A New Era','Explore how electric cars are transforming the auto industry and why they are the future of transportation.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Facere fuga corrupti dolore et. Nesciunt et eligendi dolores labore sint. Consequuntur vel nobis maiores et et. Et possimus non architecto aut. Tempora repellendus officiis exercitationem voluptatibus earum nihil. Ea ex pariatur omnis ea.\" content_2=\"Deleniti labore sint labore. Quaerat rerum sit veritatis. Nihil amet mollitia adipisci optio reprehenderit deserunt eos. Sit placeat ut consectetur dolorem. Eos iusto quisquam doloribus porro facere. Praesentium temporibus rerum iure praesentium facilis. Dolorem quae tempora aut aut fugiat. Cumque consequuntur rerum quam rerum libero sequi.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/3.jpg',454,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(4,'Leasing vs. Buying a Car: Which Is Right for You?','An in-depth comparison of leasing and buying a car, helping you decide which option suits your lifestyle.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Et maxime repellat et. Voluptas eius quidem rem sunt quia repellat consectetur. Quasi facilis dolores tempore. Et rerum occaecati vel sint perspiciatis. Eligendi est et dolor adipisci consequatur voluptate eaque praesentium. Repellendus autem tempora iusto sapiente minima. Libero dolorem aut veniam hic et. Autem fugit molestias molestiae.\" content_2=\"Sint recusandae eius dolores enim quis ullam ipsum maxime. Quia saepe autem voluptas similique eius. Voluptatibus iusto corrupti vero nam facere voluptas. Pariatur dolor et a quasi sed. Iure numquam et alias qui omnis id. Ea aut sequi voluptatem nostrum. Odio quo mollitia nihil ipsam veritatis. Nulla adipisci error dolorum blanditiis consequatur quo velit.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/4.jpg',603,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(5,'The Ultimate Road Trip Checklist','Everything you need to pack and check before embarking on an unforgettable road trip adventure.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Odit et consectetur cumque et saepe odit. Ab cumque sit delectus dolor. Molestias voluptatem occaecati beatae sed vel pariatur. Earum dolorem corrupti quis quibusdam repudiandae enim sunt cupiditate.\" content_2=\"Itaque vero nesciunt facilis unde perferendis tempore reprehenderit. Veritatis repellendus aliquid inventore distinctio alias qui commodi ullam. Eum ut totam asperiores veniam eveniet magni accusantium.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/5.jpg',272,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(6,'The Benefits of Renting a Luxury Car for Special Occasions','Find out why renting a luxury vehicle can make your events even more memorable and stylish.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quam officia reiciendis odio ea. Enim alias illum veritatis quam sit. Unde praesentium molestias architecto et aut sit. Quam ea qui ut velit facilis praesentium voluptatem. Itaque quia quia omnis aut incidunt nostrum. Rerum porro expedita repellendus in iusto. Dolorem consequatur ab aspernatur qui voluptatem dolores. Ut quo voluptatem sapiente voluptatum laudantium ut voluptas.\" content_2=\"Magni placeat error laudantium. Deserunt dolores necessitatibus in aut voluptate magnam. Sed architecto numquam quasi rerum eaque. Qui laudantium vel enim debitis fugit eaque aut. Aut veniam possimus autem impedit ut. Consequuntur rerum autem non quis debitis et aliquid eius. Omnis commodi molestias molestiae id nobis.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/6.jpg',754,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(7,'Tips for Maintaining Your Car to Extend Its Lifespan','Essential tips on how to keep your car in top condition, ensuring it lasts longer and performs better.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Iste tempora quia possimus veniam ipsa voluptatem hic. Dolorum rerum rerum voluptas et non doloribus. Voluptate voluptatem amet doloribus autem sed repellat suscipit. Quam alias possimus distinctio neque modi ex tempore fugiat. Vel quae assumenda modi itaque non. Sequi quisquam optio eius laudantium minus maxime occaecati aut. Optio cum repellendus modi praesentium odit voluptas ex.\" content_2=\"Molestias voluptate et iusto sed minus voluptatem neque ut. Assumenda possimus nihil sit et. Sit quia et quidem eum et. Provident voluptas illo soluta expedita hic explicabo. Eveniet autem consectetur possimus dolores ut. Voluptas quibusdam libero rerum soluta maiores velit repudiandae. Accusantium minima quas aliquam totam quo. Repellat odit sequi libero voluptatem.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/7.jpg',1367,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(8,'Top Safety Features to Look for in a Family Car','A guide to the latest safety innovations in family vehicles and how they protect your loved ones on the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Sit recusandae cum quia quos a. Voluptatum doloribus qui alias molestiae id. Eius suscipit illum eos possimus fugit ex numquam. Nobis voluptatibus sequi necessitatibus quis culpa eaque corporis. Ipsa sapiente laudantium et eos. Aut aut ratione quidem quibusdam libero debitis. Est dolorem in enim sapiente. Nihil aut quam illo officiis corrupti.\" content_2=\"Sapiente maxime ex dicta sed. Et quos dolorem illum consequatur. Necessitatibus cupiditate expedita consequatur ad. Nobis nobis nobis ut id aliquid impedit. Dicta repellendus animi ut id non. Sint facere dicta aut possimus voluptates. Enim quisquam atque nulla. Ut ut nobis earum et odio ab culpa.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/8.jpg',112,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(9,'How Self-Driving Cars Are Changing the Future of Transportation','An overview of autonomous vehicles and the potential they have to reshape the way we travel.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Esse ex nemo ut fugit harum in occaecati amet. Sit rerum voluptatem quas blanditiis libero amet. Laborum vel dignissimos vel unde. Exercitationem harum voluptas dolorum aut officiis. At rerum nesciunt recusandae similique nostrum velit voluptatem quod. Blanditiis qui beatae vero dicta impedit repudiandae ab mollitia. Enim odit dolor adipisci earum et.\" content_2=\"Consequatur deleniti doloremque voluptatem. Unde corrupti ducimus et eligendi id eum commodi ut. Rerum dolores voluptas illum possimus et eius voluptas. Et iure sed quaerat non sit voluptate. Aut facilis doloribus hic. Exercitationem praesentium et qui distinctio mollitia.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/9.jpg',2465,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(10,'The Best Cars for Off-Road Adventures','Discover the top vehicles that offer exceptional performance on rough terrains for your next outdoor adventure.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Voluptates quam praesentium aliquid ut voluptas itaque. Nisi qui aut ea sed tempore. Ea quaerat sit et vel. Illum veritatis vitae doloremque possimus. Quo dolorem alias et voluptatem. Earum soluta perferendis impedit dolorum. Officia voluptas et tenetur non et occaecati cum. Sequi dicta sed aut deleniti ut.\" content_2=\"Ut ipsum dicta laboriosam odio rerum. Quam asperiores quia aperiam soluta. At aliquam dolor modi quasi quasi est inventore. Libero ut molestias aut laboriosam. Eum qui ipsum earum asperiores qui officia. Sed doloremque quis dolor.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/10.jpg',1648,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(11,'The Rise of Car Subscription Services','Learn about the growing trend of car subscription services and why more drivers are opting for this flexible alternative to car ownership.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Omnis aut voluptate at excepturi voluptates quis beatae deleniti. Natus unde recusandae mollitia minima. Repellendus quia similique cupiditate cupiditate. Saepe ipsa vitae in nulla voluptatum enim laboriosam. Ut perferendis et est. Asperiores amet non accusantium. Omnis ea porro doloribus iusto fugit nostrum aperiam.\" content_2=\"Vel maxime sit debitis corporis voluptas molestiae. Qui qui sunt voluptatem. Eaque suscipit quam aut. Non eveniet ut illo sed cum. Aperiam inventore aliquam quaerat explicabo. Amet provident quo voluptatem. Fugit aperiam sunt nulla aut ratione enim fuga.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/11.jpg',1430,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(12,'Eco-Friendly Driving Tips to Reduce Your Carbon Footprint','Simple strategies for eco-conscious drivers to minimize their environmental impact on the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Ex blanditiis quis iure eos voluptates a. Adipisci eius harum neque laudantium optio eum aspernatur. Quidem ut aperiam nostrum sed reprehenderit omnis. Non eos non animi ut recusandae. Nihil ducimus qui et eum aut odit. Iste qui cum voluptas corrupti et dolor nisi. Ex quam qui id vel. Laboriosam exercitationem hic hic ea sunt sit deserunt. Fuga sed non et fugiat.\" content_2=\"Quod vero optio explicabo laudantium nam accusamus praesentium rerum. Laudantium est aut ad quisquam reiciendis incidunt. Similique qui voluptatem eos maxime. Aperiam modi distinctio odio in iure eius quidem asperiores. Inventore aperiam ut ipsa qui ducimus fugiat. Voluptas earum omnis illo corrupti animi laborum et. Fugit dolorem vitae et quos.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/12.jpg',464,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(13,'The Future of Car Sharing: Convenience at Your Fingertips','Explore how car sharing platforms are making it easier for people to access vehicles without the commitment of ownership.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Assumenda aut incidunt nesciunt temporibus. Repellat aut vel omnis ab omnis recusandae. Voluptates laboriosam beatae aliquam quasi. Et minima possimus minus voluptatum. Sit dolorem eaque omnis nostrum ipsa voluptatum praesentium. Distinctio iste vitae iusto modi voluptate. Optio qui provident eum porro impedit. Consequatur accusantium fuga quis nesciunt eos aut.\" content_2=\"Porro qui corporis quia aut. Quia doloribus quibusdam nostrum similique. Itaque ipsam laudantium dolorem. Iste consequatur temporibus nobis quod minima. Velit modi velit amet numquam unde et. Aut aut fuga et repudiandae hic quos ut. Et culpa nulla modi. Nobis asperiores possimus excepturi est quia natus.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/13.jpg',1523,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(14,'How to Get the Best Deals on Car Rentals During Holidays','Insider tips on how to save money and secure great deals when renting cars for your holiday travels.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Error aut quia aut ut odit quia. Vel similique neque cumque ab totam itaque similique. Voluptate officia quos aliquid sit soluta aut voluptas. Error nihil consequatur voluptatem qui doloribus. Nulla ratione occaecati amet maxime accusamus nihil sapiente dolorum. Ut ut et qui eos occaecati qui. Necessitatibus qui reprehenderit fuga ipsum id dolorem.\" content_2=\"Suscipit sit voluptatibus velit velit necessitatibus ducimus. Officia ea dolores eum quibusdam repellendus molestiae ipsum. Sunt aperiam aliquam possimus maxime voluptatem earum. Veniam mollitia magni iusto voluptatem adipisci aspernatur. Et cumque consequatur aut quaerat dolores. Iure voluptatem dolores voluptas cum qui. Ut incidunt omnis voluptates tenetur iusto consequatur odio placeat.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/14.jpg',722,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(15,'The Pros and Cons of Hybrid Vehicles','An analysis of the advantages and disadvantages of hybrid cars, helping you decide if they are the right choice for you.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Incidunt quo delectus nam nihil. A dolore est ipsam et quos. Id quo aut ut omnis est. Ratione ea nam culpa tenetur. Iste nostrum molestiae quos nisi aut molestiae sunt. Vel magni quidem beatae iure qui omnis. Nostrum doloremque ad odit. Quo et distinctio fuga sint totam ratione voluptatem. Velit rem molestiae qui aut vel id. Magni distinctio id sequi velit et.\" content_2=\"Architecto aut dolor aut qui et recusandae ducimus. Adipisci libero quibusdam vitae qui occaecati autem ea. Molestiae cum tenetur ex natus autem. Sint quos eius odit est iusto a. Et reiciendis pariatur et est autem unde omnis. Temporibus nihil ipsam adipisci vel ea labore autem. Quis est quia quia sint autem voluptate incidunt.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/15.jpg',1528,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(16,'How to Properly Clean and Detail Your Car','Step-by-step instructions on cleaning your car inside and out to keep it looking brand new.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Ut aut omnis commodi repudiandae suscipit qui quis. Pariatur maiores itaque in aut. Quo exercitationem repellendus dolor magnam. Beatae accusamus et quasi sint quisquam libero quas. Aut eos non natus recusandae animi quia. Quo et in id cupiditate quia.\" content_2=\"Necessitatibus inventore maxime perspiciatis nihil similique maxime. Assumenda sed nesciunt quae assumenda labore dicta. Laudantium quos exercitationem autem. Maiores placeat alias velit ut. Nisi ullam et occaecati aspernatur deleniti nostrum. Aliquam vel alias voluptatem voluptatem.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/16.jpg',1806,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(17,'Car Innovations: What to Expect in the Next 5 Years','A look at the technological advancements expected to revolutionize cars in the near future.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Autem in quia incidunt neque quaerat esse quaerat. Et recusandae et aut minus enim enim ea totam. Dolore voluptates commodi et. At nobis deserunt quaerat recusandae facilis. Quia qui tempora sed similique. Dolor iure sed dolor earum tempora. Ipsam maxime qui iste.\" content_2=\"Corrupti qui veritatis facilis a mollitia et. Commodi quia tempore veniam. Ipsum voluptas voluptatem ipsam suscipit et. Odit minus soluta ullam asperiores harum tenetur est et. Voluptatem aut veritatis nobis ipsa. Maxime ut suscipit odit reiciendis dolorem eos. Maxime quis ipsa suscipit consequuntur. Ipsa eveniet quam necessitatibus porro voluptatem.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/17.jpg',660,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(18,'The Ultimate Guide to Buying a Used Car','Everything you need to know about purchasing a used vehicle, from inspecting it to negotiating the best price.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quo in alias laudantium molestiae. Dolor nobis et ducimus minima vero aut mollitia. Quia dolor est labore itaque aliquam aliquid. Blanditiis quidem temporibus iure omnis porro amet animi. Iusto omnis consequatur cupiditate quae esse omnis dolor quia. Dolores eum ipsum quaerat ut consectetur.\" content_2=\"Itaque ipsum autem ea officiis eligendi et reprehenderit. Quo ad et odio atque sit laborum nobis. Omnis ad deleniti aut laborum. Recusandae consequatur eum incidunt maxime culpa suscipit repellat et. Quos voluptas omnis cumque assumenda quis assumenda. Delectus eveniet enim at dolores. Et quo nesciunt odio reprehenderit. Unde odit recusandae totam. Eligendi cupiditate eos blanditiis ab aut ab ut.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/18.jpg',1306,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(19,'How to Plan a Cross-Country Trip with a Rented Car','Tips on organizing a successful cross-country road trip, including how to choose the right rental car.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Eveniet dolores accusantium consequatur minima quis labore autem. Eveniet nihil sed vero aut aut. Minima omnis aperiam dolorem consequuntur. Suscipit possimus dolores vitae. Fuga facilis rerum praesentium in quae. Ipsa ut facilis aut. Reiciendis nihil similique voluptas.\" content_2=\"Numquam aliquam recusandae quia consequatur enim explicabo. Dolore quo recusandae molestias corrupti autem sunt provident. Velit ipsa omnis aut et. Vitae placeat illo corrupti adipisci repudiandae. Fuga fuga officia et dolor porro et. Deserunt temporibus voluptas inventore quia doloribus itaque ipsa. Voluptatem est ullam rerum. Quas aut reiciendis quam porro quis eligendi delectus.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/19.jpg',1617,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44'),(20,'What You Need to Know About Car Insurance Before Renting','An essential guide to understanding car rental insurance and how to choose the right coverage for your trip.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Dolor consequatur fugit qui illum sit ab possimus. Nulla assumenda suscipit et sit dolores ad nostrum. Et nesciunt et alias blanditiis aut et doloribus minima. Assumenda neque adipisci praesentium neque sit asperiores ut. Aut alias tempora voluptatem id illo. Non et enim blanditiis deleniti natus in ut cumque. Ea eum eius rem sit.\" content_2=\"Voluptatem magni repellendus veniam. Adipisci temporibus neque quis molestiae quibusdam excepturi. Quod quia ea incidunt sed. Voluptas quo quo aliquam et expedita. Id molestiae consequatur voluptatem voluptatem illum. Nihil rerum nisi necessitatibus et. Nobis facilis aut enim quidem in velit.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/20.jpg',2246,NULL,'2025-11-17 21:11:44','2025-11-17 21:11:44');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notification_recipients`
--

DROP TABLE IF EXISTS `push_notification_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notification_recipients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `push_notification_id` bigint unsigned NOT NULL,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `device_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `clicked_at` timestamp NULL DEFAULT NULL,
  `fcm_response` json DEFAULT NULL,
  `error_message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pnr_notification_user_index` (`push_notification_id`,`user_type`,`user_id`),
  KEY `pnr_user_status_index` (`user_type`,`user_id`,`status`),
  KEY `pnr_user_read_index` (`user_type`,`user_id`,`read_at`),
  KEY `pnr_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notification_recipients`
--

LOCK TABLES `push_notification_recipients` WRITE;
/*!40000 ALTER TABLE `push_notification_recipients` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notification_recipients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notifications`
--

DROP TABLE IF EXISTS `push_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `target_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` json DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_count` int NOT NULL DEFAULT '0',
  `failed_count` int NOT NULL DEFAULT '0',
  `delivered_count` int NOT NULL DEFAULT '0',
  `read_count` int NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `push_notifications_type_created_at_index` (`type`,`created_at`),
  KEY `push_notifications_status_scheduled_at_index` (`status`,`scheduled_at`),
  KEY `push_notifications_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notifications`
--

LOCK TABLES `push_notifications` WRITE;
/*!40000 ALTER TABLE `push_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"car-rentals.index\":true,\"car-rentals.cars.index\":true,\"car-rentals.cars.create\":true,\"car-rentals.cars.edit\":true,\"car-rentals.cars.destroy\":true,\"car-rentals.customers.index\":true,\"car-rentals.customers.create\":true,\"car-rentals.customers.edit\":true,\"car-rentals.customers.destroy\":true,\"car-rentals.bookings.index\":true,\"car-rentals.bookings.create\":true,\"car-rentals.bookings.edit\":true,\"car-rentals.bookings.destroy\":true,\"car-rentals.invoices.index\":true,\"car-rentals.invoices.create\":true,\"car-rentals.invoices.edit\":true,\"car-rentals.invoices.destroy\":true,\"car-rentals.reviews.index\":true,\"car-rentals.reviews.edit\":true,\"car-rentals.reviews.destroy\":true,\"car-rentals.coupons.index\":true,\"car-rentals.coupons.create\":true,\"car-rentals.coupons.edit\":true,\"car-rentals.coupons.destroy\":true,\"car-rentals.taxes.index\":true,\"car-rentals.taxes.create\":true,\"car-rentals.taxes.edit\":true,\"car-rentals.taxes.destroy\":true,\"car-rentals.attributes.index\":true,\"car-rentals.car-makes.index\":true,\"car-rentals.car-makes.create\":true,\"car-rentals.car-makes.edit\":true,\"car-rentals.car-makes.destroy\":true,\"car-rentals.car-types.index\":true,\"car-rentals.car-types.create\":true,\"car-rentals.car-types.edit\":true,\"car-rentals.car-types.destroy\":true,\"car-rentals.car-transmissions.index\":true,\"car-rentals.car-transmissions.create\":true,\"car-rentals.car-transmissions.edit\":true,\"car-rentals.car-transmissions.destroy\":true,\"car-rentals.car-fuels.index\":true,\"car-rentals.car-fuels.create\":true,\"car-rentals.car-fuels.edit\":true,\"car-rentals.car-fuels.destroy\":true,\"car-rentals.car-colors.index\":true,\"car-rentals.car-colors.create\":true,\"car-rentals.car-colors.edit\":true,\"car-rentals.car-colors.destroy\":true,\"car-rentals.car-maintenance-histories.index\":true,\"car-rentals.car-maintenance-histories.create\":true,\"car-rentals.car-maintenance-histories.edit\":true,\"car-rentals.car-maintenance-histories.destroy\":true,\"car-rentals.car-tags.index\":true,\"car-rentals.car-tags.create\":true,\"car-rentals.car-tags.edit\":true,\"car-rentals.car-tags.destroy\":true,\"car-rentals.car-categories.index\":true,\"car-rentals.car-categories.create\":true,\"car-rentals.car-categories.edit\":true,\"car-rentals.car-categories.destroy\":true,\"car-rentals.car-amenities.index\":true,\"car-rentals.car-amenities.create\":true,\"car-rentals.car-amenities.edit\":true,\"car-rentals.car-amenities.destroy\":true,\"car-rentals.services.index\":true,\"car-rentals.services.create\":true,\"car-rentals.services.edit\":true,\"car-rentals.services.destroy\":true,\"car-rentals.booking.reports.index\":true,\"car-rentals.booking.calendar.index\":true,\"car-rentals.message.index\":true,\"car-rentals.message.edit\":true,\"car-rentals.message.destroy\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"fob-comment.index\":true,\"fob-comment.comments.index\":true,\"fob-comment.comments.edit\":true,\"fob-comment.comments.destroy\":true,\"fob-comment.comments.reply\":true,\"fob-comment.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"team.index\":true,\"team.create\":true,\"team.edit\":true,\"team.destroy\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-11-17 21:11:37','2025-11-17 21:11:37');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','81be00ee243cb174ade5ed22de97ceaf',NULL,'2025-11-17 21:12:56'),(2,'api_enabled','0',NULL,'2025-11-17 21:12:56'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"car-rentals\",\"contact\",\"cookie-consent\",\"faq\",\"fob-comment\",\"gallery\",\"location\",\"newsletter\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"team\",\"testimonial\",\"translation\"]',NULL,'2025-11-17 21:12:56'),(4,'theme','carento',NULL,'2025-11-17 21:12:56'),(5,'show_admin_bar','1',NULL,'2025-11-17 21:12:56'),(6,'admin_logo','general/logo-dark.png',NULL,'2025-11-17 21:12:56'),(7,'admin_favicon','general/favicon.png',NULL,'2025-11-17 21:12:56'),(8,'permalink-botble-blog-models-post','news',NULL,'2025-11-17 21:12:56'),(9,'permalink-botble-blog-models-category','news',NULL,'2025-11-17 21:12:56'),(10,'payment_cod_status','1',NULL,'2025-11-17 21:12:56'),(11,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-11-17 21:12:56'),(12,'payment_bank_transfer_status','1',NULL,'2025-11-17 21:12:56'),(13,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-11-17 21:12:56'),(14,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-11-17 21:12:56'),(15,'language_switcher_display','dropdown',NULL,'2025-11-17 21:12:56'),(16,'car_rentals_company_name_for_invoicing','Carento',NULL,'2025-11-17 21:12:56'),(17,'car_rentals_company_logo_for_invoicing','general/logo.png',NULL,'2025-11-17 21:12:56'),(18,'car_rentals_company_address_for_invoicing','123, My Street, Kingston, New York',NULL,'2025-11-17 21:12:56'),(19,'car_rentals_company_email_for_invoicing','contact@botble.com',NULL,'2025-11-17 21:12:56'),(20,'car_rentals_company_phone_for_invoicing','123456789',NULL,'2025-11-17 21:12:56'),(21,'car_rentals_enabled_review','1',NULL,'2025-11-17 21:12:56'),(22,'car_rentals_enabled_multi_vendor','1',NULL,'2025-11-17 21:12:56'),(23,'simple_slider_using_assets','0',NULL,'2025-11-17 21:12:56'),(61,'language_hide_default','1',NULL,'2025-11-17 21:12:56'),(62,'language_display','all',NULL,'2025-11-17 21:12:56'),(63,'language_hide_languages','[]',NULL,'2025-11-17 21:12:56'),(64,'announcement_max_width','1210',NULL,'2025-11-17 21:12:56'),(65,'announcement_text_color','#FFFFFF',NULL,'2025-11-17 21:12:56'),(66,'announcement_background_color','transparent',NULL,'2025-11-17 21:12:56'),(67,'announcement_text_alignment','start',NULL,'2025-11-17 21:12:56'),(68,'announcement_dismissible','1',NULL,'2025-11-17 21:12:56'),(69,'announcement_font_size','14',NULL,'2025-11-17 21:12:56'),(70,'announcement_font_size_unit','px',NULL,'2025-11-17 21:12:56'),(71,'announcement_placement','theme',NULL,'2025-11-17 21:12:56'),(72,'theme-carento-site_title','Carento - Car Rentals Laravel Script',NULL,NULL),(73,'theme-carento-seo_description','Carento is a robust Laravel script for managing car rental businesses, featuring advanced booking, real-time vehicle availability, and customizable options for efficient operations.',NULL,NULL),(74,'theme-carento-copyright','©%Y Botble Team. All Rights Reserved.',NULL,NULL),(75,'theme-carento-favicon','general/favicon.png',NULL,NULL),(76,'theme-carento-logo','general/logo.png',NULL,NULL),(77,'theme-carento-logo_dark','general/logo-dark.png',NULL,NULL),(78,'theme-carento-logo_height','76',NULL,NULL),(79,'theme-carento-primary_font','Urbanist',NULL,NULL),(80,'theme-carento-secondary_font','Urbanist',NULL,NULL),(81,'theme-carento-primary_color','#82b440',NULL,NULL),(82,'theme-carento-primary_color_hover','#7aa93c',NULL,NULL),(83,'theme-carento-secondary_color','rgba(45, 74, 44, 0.6)',NULL,NULL),(84,'theme-carento-heading_color','#000000',NULL,NULL),(85,'theme-carento-text_color','#454545',NULL,NULL),(86,'theme-carento-header_top_background_color','#000000',NULL,NULL),(87,'theme-carento-header_top_text_color','#ffffff',NULL,NULL),(88,'theme-carento-is_header_transparent','0',NULL,NULL),(89,'theme-carento-preloader_enabled','1',NULL,NULL),(90,'theme-carento-preloader_version','v2',NULL,NULL),(91,'theme-carento-breadcrumb_background_image','backgrounds/service-bg.jpg',NULL,NULL),(92,'theme-carento-homepage_id','1',NULL,NULL),(93,'theme-carento-blog_page_id','2',NULL,NULL),(94,'theme-carento-blog_post_list_page_title','Recent Posts',NULL,NULL),(95,'theme-carento-blog_post_list_page_description','Favorite vehicles based on customer reviews',NULL,NULL),(96,'theme-carento-blog_post_gird_items_per_row','2',NULL,NULL),(97,'theme-carento-blog_post_style','grid',NULL,NULL),(98,'theme-carento-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL),(99,'theme-carento-footer_text_color','#8e8e8e',NULL,NULL),(100,'theme-carento-footer_heading_color','#ffffff',NULL,NULL),(101,'theme-carento-footer_border_color','#5756567d',NULL,NULL),(102,'theme-carento-footer_background_color','#000000',NULL,NULL),(103,'theme-carento-newsletter_popup_enable','1',NULL,NULL),(104,'theme-carento-newsletter_popup_image','backgrounds/newsletter-bg.jpg',NULL,NULL),(105,'theme-carento-newsletter_popup_title','Special Offers',NULL,NULL),(106,'theme-carento-newsletter_popup_subtitle','Newsletter',NULL,NULL),(107,'theme-carento-newsletter_popup_description','Special Offer: Rent Your Car Today!',NULL,NULL),(108,'theme-carento-number_of_cars_per_page','30',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Find your next vehicle today','sliders/banner-1.jpg','/','Browse our diverse inventory and enjoy a seamless buying experience <br> with expert support every step of the way',0,'2025-11-17 21:12:56','2025-11-17 21:12:56'),(2,1,'Discover your next ride today','sliders/banner-2.jpg','/','Explore our wide selection and enjoy a smooth purchasing journey, <br> with expert assistance at every turn',1,'2025-11-17 21:12:56','2025-11-17 21:12:56'),(3,2,'CAR REVIEW','sliders/img-1-1.jpg','/','The Tucson Plug-in Hybrid is easy to drive and provides a sufficient all-electric range.',0,'2025-11-17 21:12:56','2025-11-17 21:12:56'),(4,2,'CAR REVIEW','sliders/img-1.jpg','/','The Tucson Plug-in Hybrid is easy to drive and provides a sufficient all-electric range.',1,'2025-11-17 21:12:56','2025-11-17 21:12:56');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-11-17 21:12:56','2025-11-17 21:12:56'),(2,'Home slider 02','home-slider-02','The slider in homepage page 2','published','2025-11-17 21:12:56','2025-11-17 21:12:56');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`),
  KEY `idx_slugs_reference` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'homepage',1,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(2,'blog',2,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(3,'contact',3,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(4,'services',4,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(5,'pricing',5,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(6,'about-us',6,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(7,'car-list-1',7,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(8,'car-list-2',8,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(9,'car-list-3',9,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(10,'car-list-4',10,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(11,'agencies',11,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(12,'faqs',12,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:36','2025-11-17 21:11:36'),(13,'brands',13,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(14,'car-dealers',14,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(15,'our-awards',15,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(16,'copyright-notices',16,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(17,'terms-of-use',17,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(18,'privacy-notice',18,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(19,'lost-found',19,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(20,'car-rental-services',20,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(21,'vehicle-leasing-options',21,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(22,'long-term-car-rentals',22,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(23,'car-sales-and-trade-ins',23,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(24,'luxury-car-rentals',24,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(25,'rent-to-own-programs',25,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(26,'fleet-management-solutions',26,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(27,'affiliates',27,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(28,'travel-agents',28,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(29,'aarp-members',29,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(30,'points-programs',30,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(31,'military-veterans',31,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(32,'work-with-us',32,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(33,'advertise-with-us',33,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(34,'forum-support',34,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(35,'help-center',35,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(36,'live-chat',36,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(37,'how-it-works',37,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(38,'security',38,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(39,'refund-policy',39,'Botble\\Page\\Models\\Page','','2025-11-17 21:11:37','2025-11-17 21:11:37'),(40,'new-cars',1,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(41,'car-rentals',2,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(42,'electric-vehicles',3,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(43,'car-maintenance',4,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(44,'road-trips',5,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(45,'luxury-cars',6,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(46,'family-cars',7,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(47,'off-road-vehicles',8,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(48,'hybrid-cars',9,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(49,'car-innovations',10,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(50,'2024-cars',1,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(51,'car-leasing',2,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(52,'self-driving-cars',3,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(53,'eco-friendly',4,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(54,'car-subscription',5,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(55,'car-insurance',6,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(56,'used-cars',7,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(57,'car-detailing',8,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(58,'holiday-rentals',9,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(59,'cross-country-trips',10,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:11:44','2025-11-17 21:11:44'),(60,'top-5-new-cars-to-look-out-for-in-2024',1,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(61,'how-to-choose-the-best-car-rental-service-for-your-trip',2,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(62,'the-evolution-of-electric-vehicles-a-new-era',3,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(63,'leasing-vs-buying-a-car-which-is-right-for-you',4,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(64,'the-ultimate-road-trip-checklist',5,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(65,'the-benefits-of-renting-a-luxury-car-for-special-occasions',6,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(66,'tips-for-maintaining-your-car-to-extend-its-lifespan',7,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(67,'top-safety-features-to-look-for-in-a-family-car',8,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(68,'how-self-driving-cars-are-changing-the-future-of-transportation',9,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(69,'the-best-cars-for-off-road-adventures',10,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(70,'the-rise-of-car-subscription-services',11,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(71,'eco-friendly-driving-tips-to-reduce-your-carbon-footprint',12,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(72,'the-future-of-car-sharing-convenience-at-your-fingertips',13,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(73,'how-to-get-the-best-deals-on-car-rentals-during-holidays',14,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(74,'the-pros-and-cons-of-hybrid-vehicles',15,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(75,'how-to-properly-clean-and-detail-your-car',16,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(76,'car-innovations-what-to-expect-in-the-next-5-years',17,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(77,'the-ultimate-guide-to-buying-a-used-car',18,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(78,'how-to-plan-a-cross-country-trip-with-a-rented-car',19,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(79,'what-you-need-to-know-about-car-insurance-before-renting',20,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:11:44','2025-11-17 21:11:44'),(80,'stunning-electric-cars-of-2024',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(81,'top-luxury-cars-for-special-occasions',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(82,'family-cars-with-advanced-safety-features',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(83,'off-road-vehicles-in-action',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(84,'the-evolution-of-car-design-a-visual-journey',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(85,'best-road-trip-cars-of-the-year',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(86,'exclusive-new-car-models-unveiled',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(87,'iconic-cars-from-around-the-world',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(88,'the-future-of-electric-and-hybrid-cars',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(89,'luxury-car-interiors-a-closer-look',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:11:47','2025-11-17 21:11:47'),(90,'devon-lane',1,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(91,'marvin-mckinney',2,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(92,'ronald-richards',3,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(93,'cameron-williamson',4,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(94,'alicia-sanders',5,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(95,'ethan-wright',6,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(96,'isabella-johnson',7,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(97,'liam-brown',8,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:11:49','2025-11-17 21:11:49'),(98,'toyota-camry-xle-hybrid-2024',1,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(99,'honda-accord-sport-20t-2024',2,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(100,'mercedes-benz-c300-4matic-2024',3,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(101,'bmw-330i-xdrive-m-sport-2024',4,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(102,'lexus-es-350-f-sport-2024',5,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(103,'toyota-rav4-prime-xse-awd-2024',6,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(104,'honda-cr-v-touring-hybrid-awd-2024',7,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(105,'bmw-x5-xdrive40i-m-sport-2024',8,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(106,'mercedes-benz-glc-300-4matic-2024',9,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(107,'lexus-rx-350-f-sport-handling-awd-2024',10,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(108,'audi-a4-premium-plus-quattro-2024',11,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(109,'mazda-cx-5-25-turbo-signature-awd-2024',12,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(110,'tesla-model-3-long-range-awd-2024',13,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(111,'porsche-macan-s-2024',14,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(112,'volvo-xc60-b6-ultimate-awd-2024',15,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(113,'genesis-g70-33t-sport-prestige-awd-2024',16,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(114,'subaru-outback-limited-xt-2024',17,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(115,'acura-mdx-type-s-advance-2024',18,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(116,'range-rover-evoque-p250-s-2024',19,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(117,'infiniti-qx60-autograph-awd-2024',20,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(118,'nissan-altima-sr-vc-turbo-2024',21,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(119,'hyundai-sonata-n-line-2024',22,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(120,'kia-stinger-gt2-awd-2024',23,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(121,'volkswagen-atlas-cross-sport-sel-premium-2024',24,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(122,'chevrolet-blazer-rs-awd-2024',25,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(123,'ford-explorer-st-4wd-2024',26,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(124,'jeep-grand-cherokee-summit-reserve-4xe-2024',27,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(125,'cadillac-xt5-premium-luxury-awd-2024',28,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(126,'lincoln-aviator-reserve-awd-2024',29,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(127,'alfa-romeo-stelvio-veloce-awd-2024',30,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(128,'mclaren-720s-spider-2024',31,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(129,'mercedes-benz-g550-4matic-2024',32,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(130,'ford-mustang-gt-premium-2024',33,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(131,'porsche-911-carrera-s-2024',34,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(132,'audi-r8-v10-performance-2024',35,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(133,'lamborghini-huracan-evo-2024',36,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(134,'bmw-m4-competition-xdrive-2024',37,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(135,'maserati-ghibli-modena-2024',38,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(136,'bentley-continental-gt-v8-2024',39,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(137,'rolls-royce-ghost-black-badge-2024',40,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(138,'hyundai-tucson-limited-awd-2024',41,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(139,'kia-sportage-sx-turbo-awd-2024',42,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(140,'volkswagen-tiguan-sel-r-line-2024',43,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(141,'toyota-highlander-platinum-awd-2024',44,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(142,'honda-pilot-trailsport-awd-2024',45,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(143,'mazda-mx-5-miata-grand-touring-2024',46,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(144,'nissan-rogue-platinum-awd-2024',47,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(145,'mini-cooper-s-hardtop-2024',48,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(146,'dodge-challenger-rt-scat-pack-2024',49,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(147,'chevrolet-camaro-ss-1le-2024',50,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(148,'ferrari-f8-tributo-2024',51,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(149,'jaguar-f-pace-svr-2024',52,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(150,'land-rover-defender-110-x-2024',53,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(151,'chrysler-pacifica-pinnacle-awd-2024',54,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(152,'gmc-sierra-1500-denali-2024',55,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(153,'mitsubishi-outlander-sel-s-awc-2024',56,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(154,'peugeot-308-gt-premium-2024',57,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(155,'fiat-500x-sport-awd-2024',58,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(156,'smart-eq-fortwo-prime-2024',59,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(157,'toyota-corolla-hybrid-le-2024',60,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(158,'aston-martin-vantage-f1-edition-2024',61,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(159,'bugatti-chiron-super-sport-2024',62,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(160,'mclaren-artura-spider-2024',63,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(161,'pagani-huayra-roadster-bc-2024',64,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(162,'koenigsegg-jesko-absolut-2024',65,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(163,'mercedes-benz-e450-4matic-all-terrain-2024',66,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(164,'audi-q7-55-tfsi-quattro-premium-plus-2024',67,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(165,'bmw-x7-xdrive40i-m-sport-2024',68,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(166,'lexus-lx-600-ultra-luxury-2024',69,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(167,'volvo-s90-b6-ultimate-awd-2024',70,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(168,'genesis-gv70-25t-sport-awd-2024',71,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(169,'acura-tlx-type-s-pmc-edition-2024',72,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(170,'infiniti-q50-red-sport-400-awd-2024',73,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(171,'jaguar-xf-p300-r-dynamic-s-awd-2024',74,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(172,'alfa-romeo-giulia-quadrifoglio-2024',75,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(173,'porsche-cayenne-turbo-gt-2024',76,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(174,'range-rover-sport-hse-dynamic-2024',77,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(175,'mercedes-amg-gle-63-s-4matic-2024',78,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(176,'bmw-m5-competition-xdrive-2024',79,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(177,'audi-rs-q8-quattro-2024',80,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(178,'tesla-model-s-plaid-2024',81,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(179,'lucid-air-grand-touring-performance-2024',82,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(180,'rivian-r1s-adventure-2024',83,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(181,'polestar-2-long-range-dual-motor-2024',84,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(182,'genesis-electrified-gv70-advanced-awd-2024',85,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(183,'mercedes-maybach-s-580-4matic-2024',86,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(184,'bentley-bentayga-s-v8-2024',87,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(185,'rolls-royce-cullinan-black-badge-2024',88,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(186,'aston-martin-dbx707-2024',89,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(187,'maserati-levante-trofeo-2024',90,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(188,'ferrari-roma-spider-2024',91,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(189,'mclaren-gt-luxe-2024',92,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(190,'lamborghini-urus-performante-2024',93,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(191,'porsche-taycan-turbo-s-cross-turismo-2024',94,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(192,'bmw-xm-label-red-2024',95,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(193,'chevrolet-corvette-z06-3lz-2024',96,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(194,'ford-gt-heritage-edition-2024',97,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(195,'dodge-viper-acr-extreme-2024',98,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(196,'nissan-gt-r-nismo-special-edition-2024',99,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(197,'toyota-supra-30-premium-2024',100,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:12:56','2025-11-17 21:12:56'),(198,'driver-rental-service',1,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(199,'oil-change-service',2,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(200,'car-wash-detailing-package',3,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(201,'roadside-assistance',4,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(202,'temporary-car-replacement',5,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(203,'tire-replacement-balancing',6,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(204,'vehicle-inspection-service',7,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(205,'car-insurance-assistance',8,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(206,'pick-up-drop-off-service',9,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:56','2025-11-17 21:12:56'),(207,'premium-fuel-service',10,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:12:57','2025-11-17 21:12:57'),(208,'sport',1,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:12:57','2025-11-17 21:12:57'),(209,'maserati',2,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:12:57','2025-11-17 21:12:57'),(210,'ferrari',3,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:12:57','2025-11-17 21:12:57'),(211,'classic',4,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:12:57','2025-11-17 21:12:57'),(212,'new',5,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:12:57','2025-11-17 21:12:57'),(213,'lexus',1,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(214,'mercedes',2,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(215,'bugatti',3,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(216,'jaguar',4,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(217,'honda',5,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(218,'chevrolet',6,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(219,'acura',7,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(220,'bmw',8,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(221,'toyota',9,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(222,'ford',10,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(223,'nissan',11,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(224,'opel',12,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(225,'bmw',13,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57'),(226,'toyota',14,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:12:57','2025-11-17 21:12:57');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`),
  KEY `idx_states_name` (`name`),
  KEY `idx_states_status` (`status`),
  KEY `idx_states_country_id` (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'California','california','CA',1,1,NULL,1,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(2,'New York','new-york','NY',1,2,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(3,'Florida','florida','FL',1,3,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(4,'Texas','texas','TX',1,4,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(5,'Illinois','illinois','IL',1,5,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(6,'England','england','ENG',2,6,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(7,'Scotland','scotland','SCT',2,7,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(8,'Ontario','ontario','ON',3,8,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(9,'British Columbia','british-columbia','BC',3,9,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(10,'Bavaria','bavaria','BY',4,10,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(11,'Berlin','berlin','BE',4,11,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(12,'Île-de-France','ile-de-france','IDF',5,12,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(13,'Provence-Alpes-Côte d\'Azur','provence-alpes-cote-dazur','PACA',5,13,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(14,'New South Wales','new-south-wales','NSW',6,14,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(15,'Victoria','victoria','VIC',6,15,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(16,'Tokyo','tokyo','TK',7,16,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(17,'Osaka','osaka','OS',7,17,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(18,'Lazio','lazio','LAZ',8,18,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51'),(19,'Lombardy','lombardy','LOM',8,19,NULL,0,'published','2025-11-17 21:11:51','2025-11-17 21:11:51');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`),
  KEY `idx_states_trans_state_lang` (`states_id`,`lang_code`),
  KEY `idx_states_trans_name` (`name`),
  KEY `idx_states_trans_states_id` (`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'2024 Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(2,'Car Leasing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(3,'Self-Driving Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(4,'Eco-Friendly',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(5,'Car Subscription',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(6,'Car Insurance',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(7,'Used Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(8,'Car Detailing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(9,'Holiday Rentals',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44'),(10,'Cross-Country Trips',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:11:44','2025-11-17 21:11:44');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teams`
--

DROP TABLE IF EXISTS `teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `socials` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `phone` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teams`
--

LOCK TABLES `teams` WRITE;
/*!40000 ALTER TABLE `teams` DISABLE KEYS */;
INSERT INTO `teams` VALUES (1,'Devon Lane','teams/1.jpg','Chief Executive Officer (CEO)','India','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','01123259241','devonsoland111@gmail.com','4855, 24, Ansari Road, Darya Ganj',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(2,'Marvin McKinney','teams/2.jpg','Fleet Manager','Thailand','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','6623742088','marvinkensy@gmail.com','849 Sukhapibal 1 Klong Chan Bang Kapi',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(3,'Ronald Richards','teams/3.jpg','Customer Service Representative','Canada','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','4165550123','ronrichards@marketing.com','123 Maple Street, Toronto, ON',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(4,'Cameron Williamson','teams/4.jpg','Finance &amp; Accounting Officer','Germany','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','49221567890','cameronwill@tech.com','45 Hauptstraße, 50667 Köln',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(5,'Alicia Sanders','teams/5.jpg','Marketing Executive','Australia','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0298765432','alicia.hr@company.com','15 George St, Sydney, NSW',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(6,'Ethan Wright','teams/6.jpg','Automotive Technician/Mechanic','South Africa','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0217896543','ethanwright@operations.com','789 Beach Road, Cape Town',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(7,'Isabella Johnson','teams/7.jpg','Operations Coordinator','New Zealand','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0498761234','isabella.prod@company.com','32 Victoria St, Wellington',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(8,'Liam Brown','teams/8.jpg','HR &amp; Administration Officer','United Kingdom','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:11:49','2025-11-17 21:11:49','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','02079461234','liam.legal@company.co.uk','10 Downing Street, London',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally');
/*!40000 ALTER TABLE `teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teams_translations`
--

DROP TABLE IF EXISTS `teams_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `teams_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`teams_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teams_translations`
--

LOCK TABLES `teams_translations` WRITE;
/*!40000 ALTER TABLE `teams_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `teams_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','testimonials/1.png','CEO, JAKS Shans','published','2025-11-17 21:11:50','2025-11-17 21:11:50'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','testimonials/2.png','SEO, ChenTech Solutions','published','2025-11-17 21:11:50','2025-11-17 21:11:50'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','testimonials/3.png','Developer, Moie Agency','published','2025-11-17 21:11:50','2025-11-17 21:11:50'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','testimonials/4.png','CEO, Bank of America','published','2025-11-17 21:11:50','2025-11-17 21:11:50');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_settings`
--

DROP TABLE IF EXISTS `user_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` json NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_settings_user_type_user_id_key_unique` (`user_type`,`user_id`,`key`),
  KEY `user_settings_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `user_settings_key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_settings`
--

LOCK TABLES `user_settings` WRITE;
/*!40000 ALTER TABLE `user_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  `sessions_invalidated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'wuckert.andreanne@mayert.com',NULL,NULL,'$2y$12$OdY910jtEIFzjin/HsP.KePoN5GL.I6zG6O6vqrGYSi5DUGJY/XuS',NULL,'2025-11-17 21:11:37','2025-11-17 21:11:49','Tevin','Macejkovic','admin',65,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `widgets_unique_index` (`theme`,`sidebar_id`,`widget_id`,`position`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInformationWidget','footer_sidebar','carento',1,'{\"id\":\"SiteInformationWidget\",\"logo\":\"general\\/logo-dark.png\",\"quantity\":4,\"icon_1\":\"ti ti-map-pin\",\"description_1\":\"2356 Oakwood Drive, Suite 18, San Francisco, California 94111, US\",\"icon_2\":\"ti ti-clock-hour-3\",\"description_2\":\"Hours: 8:00 - 17:00, Mon - Sat\",\"icon_3\":\"ti ti-mail\",\"description_3\":\"support@carento.com\",\"title_4\":\"Need help? Call us\",\"icon_4\":\"ti ti-phone\",\"description_4\":\"<a href=\\\"tel:+1 222-555-33-99\\\">+1 222-555-33-99<\\/a>\"}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(2,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Company\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Awards\"},{\"key\":\"url\",\"value\":\"\\/our-awards\"}],[{\"key\":\"label\",\"value\":\"Agencies\"},{\"key\":\"url\",\"value\":\"\\/agencies\"}],[{\"key\":\"label\",\"value\":\"Copyright Notices\"},{\"key\":\"url\",\"value\":\"\\/copyright-notices\"}],[{\"key\":\"label\",\"value\":\"Terms of Use\"},{\"key\":\"url\",\"value\":\"\\/terms-of-use\"}],[{\"key\":\"label\",\"value\":\"Privacy Notice\"},{\"key\":\"url\",\"value\":\"\\/privacy-notice\"}],[{\"key\":\"label\",\"value\":\"Lost & Found\"},{\"key\":\"url\",\"value\":\"\\/lost-found\"}]]}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(3,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Our Services\",\"items\":[[{\"key\":\"label\",\"value\":\"Premium Fuel Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/premium-fuel-service\"}],[{\"key\":\"label\",\"value\":\"Pick-Up & Drop-Off Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/pick-up-drop-off-service\"}],[{\"key\":\"label\",\"value\":\"Car Insurance Assistance\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/car-insurance-assistance\"}],[{\"key\":\"label\",\"value\":\"Vehicle Inspection Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/vehicle-inspection-service\"}],[{\"key\":\"label\",\"value\":\"Tire Replacement & Balancing\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/tire-replacement-balancing\"}],[{\"key\":\"label\",\"value\":\"Temporary Car Replacement\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/temporary-car-replacement\"}],[{\"key\":\"label\",\"value\":\"Roadside Assistance\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/roadside-assistance\"}]]}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',4,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Our Partners\",\"items\":[[{\"key\":\"label\",\"value\":\"Affiliates\"},{\"key\":\"url\",\"value\":\"\\/affiliates\"}],[{\"key\":\"label\",\"value\":\"Travel Agents\"},{\"key\":\"url\",\"value\":\"\\/travel-agents\"}],[{\"key\":\"label\",\"value\":\"AARP Members\"},{\"key\":\"url\",\"value\":\"\\/aarp-members\"}],[{\"key\":\"label\",\"value\":\"Points Programs\"},{\"key\":\"url\",\"value\":\"\\/points-programs\"}],[{\"key\":\"label\",\"value\":\"Military & Veterans\"},{\"key\":\"url\",\"value\":\"\\/military-veterans\"}],[{\"key\":\"label\",\"value\":\"Work with us\"},{\"key\":\"url\",\"value\":\"\\/work-with-us\"}],[{\"key\":\"label\",\"value\":\"Advertise with us\"},{\"key\":\"url\",\"value\":\"\\/advertise-with-us\"}]]}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',5,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Support\",\"items\":[[{\"key\":\"label\",\"value\":\"Forum support\"},{\"key\":\"url\",\"value\":\"\\/forum-support\"}],[{\"key\":\"label\",\"value\":\"Help Center\"},{\"key\":\"url\",\"value\":\"\\/help-center\"}],[{\"key\":\"label\",\"value\":\"Live chat\"},{\"key\":\"url\",\"value\":\"\\/live-chat\"}],[{\"key\":\"label\",\"value\":\"How it works\"},{\"key\":\"url\",\"value\":\"\\/how-it-works\"}],[{\"key\":\"label\",\"value\":\"Security\"},{\"key\":\"url\",\"value\":\"\\/security\"}],[{\"key\":\"label\",\"value\":\"Refund Policy\"},{\"key\":\"url\",\"value\":\"\\/refund-policy\"}]]}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(6,'SiteCopyrightWidget','bottom_footer_sidebar','carento',1,'[]','2025-11-17 21:12:55','2025-11-17 21:12:55'),(7,'SocialLinksWidget','bottom_footer_sidebar','carento',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"\"}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(8,'NewsletterWidget','top_footer_sidebar','carento',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe to see secret deals prices drop the moment you sign up!\",\"button_label\":\"Subscribe\"}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(9,'ContactInformationWidget','header_top_sidebar','carento',1,'{\"id\":\"ContactInformationWidget\",\"quantity\":2,\"title_1\":\"+123 9898 500\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:123 9898 500\",\"title_2\":\"sale@carento.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:sale@carento.com\"}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(10,'BlogSearchWidget','blog_sidebar','carento',1,'{\"id\":\"BlogSearchWidget\"}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(11,'BlogPostsWidget','blog_sidebar','carento',2,'{\"id\":\"BlogPostsWidget\",\"title\":\"Latest Posts\",\"category_ids\":[1,2,3,4,5],\"limit\":5}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(12,'GalleriesWidget','blog_sidebar','carento',3,'{\"id\":\"GalleriesWidget\",\"title\":\"Instagram Posts\",\"limit\":9}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(13,'FeaturedPostsWidget','above_blog_list_sidebar','carento',1,'{\"id\":\"FeaturedPostsWidget\",\"title\":\"Inside & Trending\",\"category_ids\":[1,2,3,4,5,6],\"limit\":4}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(14,'BlogPostsWidget','off_canvas_sidebar','carento',1,'{\"id\":\"BlogPostsWidget\",\"title\":\"Latest Posts\",\"category_ids\":[1,2,3,4,5],\"limit\":5}','2025-11-17 21:12:55','2025-11-17 21:12:55'),(15,'SiteInformationWidget','off_canvas_sidebar','carento',2,'{\"id\":\"SiteInformationWidget\",\"logo\":\"icons\\/contact.png\",\"quantity\":4,\"icon_1\":\"ti ti-map-pin\",\"description_1\":\"2356 Oakwood Drive, Suite 18, San Francisco, California 94111, US\",\"icon_2\":\"ti ti-clock-hour-3\",\"description_2\":\"Hours: 8:00 - 17:00, Mon - Sat\",\"icon_3\":\"ti ti-mail\",\"description_3\":\"support@carento.com\"}','2025-11-17 21:12:55','2025-11-17 21:12:55');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-11-18 11:12:58
