-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: carento
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'qyaWsYjoxbtUCtgg4vSFMnjtkz6ilyWH',1,'2025-11-17 21:13:08','2025-11-17 21:13:08','2025-11-17 21:13:08');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Drive Your Dream Car Today – Affordable Rentals at Your Fingertips!',1,'Book Now','/',0,1,'2025-11-18 04:13:08',NULL,1,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(2,'Announcement 2','Hit the Road in Style – Premium Car Rentals for Every Journey!',1,'Book Now','/',0,1,'2025-11-18 04:13:08',NULL,1,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(3,'Announcement 3','Explore the Open Road – Hassle-Free Car Rentals Just a Click Away!',1,'Book Now','/',0,1,'2025-11-18 04:13:08',NULL,1,'2025-11-17 21:13:08','2025-11-17 21:13:08');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'New Cars',0,'Quidem velit et accusantium. Sapiente qui aliquid hic suscipit. Est sit ab et excepturi inventore ea.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(2,'Car Rentals',0,'Totam cupiditate ullam ut tenetur autem qui ut. Beatae rem ducimus accusamus illum ut id itaque et. Eveniet non doloremque dolorem eos numquam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(3,'Electric Vehicles',0,'Est quae ratione quos ut veniam odit. Incidunt sit distinctio voluptatum nemo tempora.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(4,'Car Maintenance',0,'Dolor alias harum itaque ut atque. Corrupti possimus delectus saepe illo expedita necessitatibus nihil. Dignissimos impedit reiciendis quo iure fugit quidem quae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(5,'Road Trips',0,'Excepturi aut fugiat quo velit eligendi dolores. Quidem rerum qui in aliquam. Velit vero asperiores illo debitis. Aut quisquam distinctio consequatur voluptates voluptatem.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(6,'Luxury Cars',0,'Dolorem est quis vitae nihil. Dolorem possimus quis culpa quibusdam id. Est dolor et vel laborum. Suscipit qui consequatur voluptas fugiat porro eos aliquam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(7,'Family Cars',0,'Quae nesciunt amet expedita fugit. Voluptatem sit illo consequatur doloribus possimus architecto sit exercitationem. Adipisci enim sed et magni est facilis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(8,'Off-Road Vehicles',0,'Magnam corrupti neque vero et nisi ut officia cupiditate. Illo sunt hic voluptatem atque eaque. Deleniti maxime officia aut placeat eaque.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(9,'Hybrid Cars',0,'Voluptas eos eligendi quia quaerat perspiciatis veritatis ea rerum. Fuga non culpa labore. Deserunt unde doloremque aliquam tempora perferendis ratione et.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(10,'Car Innovations',0,'In ea aspernatur quo. Itaque quia sint earum eligendi. Aut facere sint omnis repellendus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:13:14','2025-11-17 21:13:14');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`),
  KEY `idx_cities_name` (`name`),
  KEY `idx_cities_state_status` (`state_id`,`status`),
  KEY `idx_cities_status` (`status`),
  KEY `idx_cities_state_id` (`state_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Los Angeles','los-angeles',1,1,NULL,1,'locations/location1.jpg',1,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(2,'San Francisco','san-francisco',1,1,NULL,2,'locations/location2.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(3,'San Diego','san-diego',1,1,NULL,3,'locations/location3.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(4,'New York City','new-york-city',2,1,NULL,4,'locations/location4.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(5,'Buffalo','buffalo',2,1,NULL,5,'locations/location5.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(6,'Miami','miami',3,1,NULL,6,'locations/location6.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(7,'Orlando','orlando',3,1,NULL,7,'locations/location1.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(8,'Houston','houston',4,1,NULL,8,'locations/location2.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(9,'Austin','austin',4,1,NULL,9,'locations/location3.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(10,'Chicago','chicago',5,1,NULL,10,'locations/location4.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(11,'London','london',6,2,NULL,11,'locations/location5.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(12,'Manchester','manchester',6,2,NULL,12,'locations/location6.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(13,'Edinburgh','edinburgh',7,2,NULL,13,'locations/location1.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(14,'Toronto','toronto',8,3,NULL,14,'locations/location2.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(15,'Ottawa','ottawa',8,3,NULL,15,'locations/location3.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(16,'Vancouver','vancouver',9,3,NULL,16,'locations/location4.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(17,'Munich','munich',10,4,NULL,17,'locations/location5.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(18,'Berlin','berlin',11,4,NULL,18,'locations/location6.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(19,'Paris','paris',12,5,NULL,19,'locations/location1.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(20,'Nice','nice',13,5,NULL,20,'locations/location2.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(21,'Sydney','sydney',14,6,NULL,21,'locations/location3.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(22,'Melbourne','melbourne',15,6,NULL,22,'locations/location4.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(23,'Tokyo','tokyo',16,7,NULL,23,'locations/location5.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(24,'Osaka','osaka',17,7,NULL,24,'locations/location6.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(25,'Rome','rome',18,8,NULL,25,'locations/location1.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(26,'Milan','milan',19,8,NULL,26,'locations/location2.jpg',0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL);
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`),
  KEY `idx_cities_trans_city_lang` (`cities_id`,`lang_code`),
  KEY `idx_cities_trans_name` (`name`),
  KEY `idx_cities_trans_cities_id` (`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_countries_name` (`name`),
  KEY `idx_countries_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'United States','American',1,NULL,1,'published','2025-11-17 21:13:21',NULL,'US'),(2,'United Kingdom','British',2,NULL,0,'published','2025-11-17 21:13:21',NULL,'GB'),(3,'Canada','Canadian',3,NULL,0,'published','2025-11-17 21:13:21',NULL,'CA'),(4,'Germany','German',4,NULL,0,'published','2025-11-17 21:13:21',NULL,'DE'),(5,'France','French',5,NULL,0,'published','2025-11-17 21:13:21',NULL,'FR'),(6,'Australia','Australian',6,NULL,0,'published','2025-11-17 21:13:21',NULL,'AU'),(7,'Japan','Japanese',7,NULL,0,'published','2025-11-17 21:13:21',NULL,'JP'),(8,'Italy','Italian',8,NULL,0,'published','2025-11-17 21:13:21',NULL,'IT');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`),
  KEY `idx_countries_trans_country_lang` (`countries_id`,`lang_code`),
  KEY `idx_countries_trans_name` (`name`),
  KEY `idx_countries_trans_countries_id` (`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_booking_cars`
--

DROP TABLE IF EXISTS `cr_booking_cars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_booking_cars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `car_id` bigint unsigned NOT NULL,
  `pickup_city_id` bigint unsigned DEFAULT NULL,
  `return_city_id` bigint unsigned DEFAULT NULL,
  `car_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `car_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` double NOT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `rental_start_date` datetime NOT NULL,
  `rental_end_date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_booking_cars`
--

LOCK TABLES `cr_booking_cars` WRITE;
/*!40000 ALTER TABLE `cr_booking_cars` DISABLE KEYS */;
INSERT INTO `cr_booking_cars` VALUES (1,1,1,NULL,NULL,NULL,'Toyota Camry XLE Hybrid 2024',450,1,'2025-10-14 00:00:00','2025-10-20 00:00:00','2025-11-17 21:14:20','2025-11-17 21:14:20'),(2,2,62,NULL,NULL,NULL,'Bugatti Chiron Super Sport 2024',270,1,'2025-10-08 00:00:00','2025-10-13 00:00:00','2025-11-17 21:14:20','2025-11-17 21:14:20'),(3,3,39,NULL,NULL,NULL,'Bentley Continental GT V8 2024',90,1,'2025-09-30 00:00:00','2025-10-02 00:00:00','2025-11-17 21:14:20','2025-11-17 21:14:20'),(4,4,7,NULL,NULL,NULL,'Honda CR-V Touring Hybrid AWD 2024',553,1,'2025-10-14 00:00:00','2025-10-21 00:00:00','2025-11-17 21:14:20','2025-11-17 21:14:20'),(5,5,46,NULL,NULL,NULL,'Mazda MX-5 Miata Grand Touring 2024',148,1,'2025-09-19 00:00:00','2025-09-21 00:00:00','2025-11-17 21:14:20','2025-11-17 21:14:20'),(6,6,6,NULL,NULL,NULL,'Toyota RAV4 Prime XSE AWD 2024',352,1,'2025-10-12 00:00:00','2025-10-16 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(7,7,85,NULL,NULL,NULL,'Genesis Electrified GV70 Advanced AWD 2024',128,1,'2025-10-03 00:00:00','2025-10-05 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(8,8,22,NULL,NULL,NULL,'Hyundai Sonata N Line 2024',288,1,'2025-11-09 00:00:00','2025-11-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(9,9,26,NULL,NULL,NULL,'Ford Explorer ST 4WD 2024',266,1,'2025-11-15 00:00:00','2025-11-22 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(10,10,56,NULL,NULL,NULL,'Mitsubishi Outlander SEL S-AWC 2024',56,1,'2025-10-26 00:00:00','2025-10-27 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(11,11,70,NULL,NULL,NULL,'Volvo S90 B6 Ultimate AWD 2024',216,1,'2025-11-12 00:00:00','2025-11-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(12,12,96,NULL,NULL,NULL,'Chevrolet Corvette Z06 3LZ 2024',420,1,'2025-10-10 00:00:00','2025-10-16 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(13,13,39,NULL,NULL,NULL,'Bentley Continental GT V8 2024',315,1,'2025-11-04 00:00:00','2025-11-11 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(14,14,38,NULL,NULL,NULL,'Maserati Ghibli Modena 2024',105,1,'2025-10-07 00:00:00','2025-10-10 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(15,15,53,NULL,NULL,NULL,'Land Rover Defender 110 X 2024',192,1,'2025-10-17 00:00:00','2025-10-21 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(16,16,33,NULL,NULL,NULL,'Ford Mustang GT Premium 2024',245,1,'2025-11-07 00:00:00','2025-11-14 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(17,17,9,NULL,NULL,NULL,'Mercedes-Benz GLC 300 4MATIC 2024',195,1,'2025-11-15 00:00:00','2025-11-20 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(18,18,47,NULL,NULL,NULL,'Nissan Rogue Platinum AWD 2024',70,1,'2025-10-07 00:00:00','2025-10-08 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(19,19,68,NULL,NULL,NULL,'BMW X7 xDrive40i M Sport 2024',66,1,'2025-11-13 00:00:00','2025-11-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(20,20,93,NULL,NULL,NULL,'Lamborghini Urus Performante 2024',352,1,'2025-10-16 00:00:00','2025-10-20 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(21,21,91,NULL,NULL,NULL,'Ferrari Roma Spider 2024',90,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(22,22,63,NULL,NULL,NULL,'McLaren Artura Spider 2024',588,1,'2025-10-29 00:00:00','2025-11-04 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(23,23,42,NULL,NULL,NULL,'Kia Sportage SX-Turbo AWD 2024',48,1,'2025-11-15 00:00:00','2025-11-16 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(24,24,94,NULL,NULL,NULL,'Porsche Taycan Turbo S Cross Turismo 2024',96,1,'2025-10-04 00:00:00','2025-10-05 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(25,25,92,NULL,NULL,NULL,'McLaren GT Luxe 2024',51,1,'2025-10-09 00:00:00','2025-10-10 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(26,26,20,NULL,NULL,NULL,'Infiniti QX60 Autograph AWD 2024',294,1,'2025-09-30 00:00:00','2025-10-07 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(27,27,7,NULL,NULL,NULL,'Honda CR-V Touring Hybrid AWD 2024',474,1,'2025-10-17 00:00:00','2025-10-23 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(28,28,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',525,1,'2025-10-19 00:00:00','2025-10-26 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(29,29,68,NULL,NULL,NULL,'BMW X7 xDrive40i M Sport 2024',33,1,'2025-09-28 00:00:00','2025-09-29 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(30,30,30,NULL,NULL,NULL,'Alfa Romeo Stelvio Veloce AWD 2024',378,1,'2025-10-03 00:00:00','2025-10-09 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(31,31,33,NULL,NULL,NULL,'Ford Mustang GT Premium 2024',105,1,'2025-11-14 00:00:00','2025-11-17 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(32,32,61,NULL,NULL,NULL,'Aston Martin Vantage F1 Edition 2024',55,1,'2025-11-18 00:00:00','2025-11-19 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(33,33,43,NULL,NULL,NULL,'Volkswagen Tiguan SEL R-Line 2024',215,1,'2025-11-17 00:00:00','2025-11-22 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(34,34,91,NULL,NULL,NULL,'Ferrari Roma Spider 2024',180,1,'2025-11-15 00:00:00','2025-11-19 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(35,35,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',380,1,'2025-11-15 00:00:00','2025-11-20 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(36,36,91,NULL,NULL,NULL,'Ferrari Roma Spider 2024',90,1,'2025-11-16 00:00:00','2025-11-18 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(37,37,36,NULL,NULL,NULL,'Lamborghini Huracán EVO 2024',106,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(38,38,26,NULL,NULL,NULL,'Ford Explorer ST 4WD 2024',114,1,'2025-11-12 00:00:00','2025-11-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(39,39,30,NULL,NULL,NULL,'Alfa Romeo Stelvio Veloce AWD 2024',126,1,'2025-11-15 00:00:00','2025-11-17 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(40,40,68,NULL,NULL,NULL,'BMW X7 xDrive40i M Sport 2024',33,1,'2025-11-17 00:00:00','2025-11-18 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(41,41,55,NULL,NULL,NULL,'GMC Sierra 1500 Denali 2024',623,1,'2025-11-16 00:00:00','2025-11-23 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(42,42,76,NULL,NULL,NULL,'Porsche Cayenne Turbo GT 2024',102,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(43,43,88,NULL,NULL,NULL,'Rolls-Royce Cullinan Black Badge 2024',224,1,'2025-11-14 00:00:00','2025-11-18 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(44,44,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',532,1,'2025-11-16 00:00:00','2025-11-23 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(45,45,70,NULL,NULL,NULL,'Volvo S90 B6 Ultimate AWD 2024',144,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(46,46,88,NULL,NULL,NULL,'Rolls-Royce Cullinan Black Badge 2024',56,1,'2025-11-17 00:00:00','2025-11-18 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(47,47,3,NULL,NULL,NULL,'Mercedes-Benz C300 4MATIC 2024',180,1,'2025-11-12 00:00:00','2025-11-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(48,48,10,NULL,NULL,NULL,'Lexus RX 350 F Sport Handling AWD 2024',406,1,'2025-11-14 00:00:00','2025-11-21 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(49,49,11,NULL,NULL,NULL,'Audi A4 Premium Plus quattro 2024',375,1,'2025-11-11 00:00:00','2025-11-16 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(50,50,17,NULL,NULL,NULL,'Subaru Outback Limited XT 2024',308,1,'2025-11-11 00:00:00','2025-11-18 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(51,51,6,NULL,NULL,NULL,'Toyota RAV4 Prime XSE AWD 2024',264,1,'2025-12-08 00:00:00','2025-12-11 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(52,52,8,NULL,NULL,NULL,'BMW X5 xDrive40i M Sport 2024',441,1,'2025-12-15 00:00:00','2025-12-22 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(53,53,70,NULL,NULL,NULL,'Volvo S90 B6 Ultimate AWD 2024',504,1,'2025-12-15 00:00:00','2025-12-22 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(54,54,86,NULL,NULL,NULL,'Mercedes-Maybach S 580 4MATIC 2024',434,1,'2025-11-19 00:00:00','2025-11-26 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(55,55,29,NULL,NULL,NULL,'Lincoln Aviator Reserve AWD 2024',504,1,'2025-12-17 00:00:00','2025-12-24 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(56,56,73,NULL,NULL,NULL,'Infiniti Q50 Red Sport 400 AWD 2024',276,1,'2025-12-11 00:00:00','2025-12-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(57,57,4,NULL,NULL,NULL,'BMW 330i xDrive M Sport 2024',275,1,'2025-12-07 00:00:00','2025-12-12 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(58,58,77,NULL,NULL,NULL,'Range Rover Sport HSE Dynamic 2024',108,1,'2025-11-27 00:00:00','2025-11-30 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(59,59,71,NULL,NULL,NULL,'Genesis GV70 2.5T Sport AWD 2024',644,1,'2025-12-08 00:00:00','2025-12-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(60,60,93,NULL,NULL,NULL,'Lamborghini Urus Performante 2024',616,1,'2025-11-22 00:00:00','2025-11-29 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(61,61,36,NULL,NULL,NULL,'Lamborghini Huracán EVO 2024',106,1,'2025-12-02 00:00:00','2025-12-04 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(62,62,48,NULL,NULL,NULL,'Mini Cooper S Hardtop 2024',296,1,'2025-11-30 00:00:00','2025-12-04 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(63,63,60,NULL,NULL,NULL,'Toyota Corolla Hybrid LE 2024',552,1,'2025-12-03 00:00:00','2025-12-09 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(64,64,74,NULL,NULL,NULL,'Jaguar XF P300 R-Dynamic S AWD 2024',84,1,'2025-12-08 00:00:00','2025-12-09 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(65,65,74,NULL,NULL,NULL,'Jaguar XF P300 R-Dynamic S AWD 2024',168,1,'2025-11-29 00:00:00','2025-12-01 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(66,66,94,NULL,NULL,NULL,'Porsche Taycan Turbo S Cross Turismo 2024',96,1,'2025-12-08 00:00:00','2025-12-09 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(67,67,87,NULL,NULL,NULL,'Bentley Bentayga S V8 2024',297,1,'2025-12-03 00:00:00','2025-12-06 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(68,68,95,NULL,NULL,NULL,'BMW XM Label Red 2024',462,1,'2025-11-22 00:00:00','2025-11-29 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(69,69,89,NULL,NULL,NULL,'Aston Martin DBX707 2024',186,1,'2025-12-13 00:00:00','2025-12-15 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(70,70,95,NULL,NULL,NULL,'BMW XM Label Red 2024',462,1,'2025-11-29 00:00:00','2025-12-06 00:00:00','2025-11-17 21:14:21','2025-11-17 21:14:21'),(71,71,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',456,1,'2025-11-28 00:00:00','2025-12-04 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(72,72,25,NULL,NULL,NULL,'Chevrolet Blazer RS AWD 2024',468,1,'2025-11-21 00:00:00','2025-11-27 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(73,73,54,NULL,NULL,NULL,'Chrysler Pacifica Pinnacle AWD 2024',170,1,'2025-11-20 00:00:00','2025-11-25 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(74,74,96,NULL,NULL,NULL,'Chevrolet Corvette Z06 3LZ 2024',420,1,'2025-11-22 00:00:00','2025-11-28 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(75,75,79,NULL,NULL,NULL,'BMW M5 Competition xDrive 2024',329,1,'2025-12-05 00:00:00','2025-12-12 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(76,76,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',76,1,'2025-12-17 00:00:00','2025-12-18 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(77,77,82,NULL,NULL,NULL,'Lucid Air Grand Touring Performance 2024',330,1,'2025-11-19 00:00:00','2025-11-24 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(78,78,31,NULL,NULL,NULL,'McLaren 720S Spider 2024',63,1,'2025-12-13 00:00:00','2025-12-14 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(79,79,64,NULL,NULL,NULL,'Pagani Huayra Roadster BC 2024',300,1,'2025-11-28 00:00:00','2025-12-02 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22'),(80,80,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',450,1,'2025-11-29 00:00:00','2025-12-05 00:00:00','2025-11-17 21:14:22','2025-11-17 21:14:22');
/*!40000 ALTER TABLE `cr_booking_cars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_booking_service`
--

DROP TABLE IF EXISTS `cr_booking_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_booking_service` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `service_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_booking_service`
--

LOCK TABLES `cr_booking_service` WRITE;
/*!40000 ALTER TABLE `cr_booking_service` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_booking_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_bookings`
--

DROP TABLE IF EXISTS `cr_bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_bookings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_age` int unsigned DEFAULT NULL,
  `customer_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` double NOT NULL,
  `sub_total` double NOT NULL,
  `coupon_amount` double NOT NULL DEFAULT '0',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_amount` double NOT NULL DEFAULT '0',
  `currency_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `completion_miles` int unsigned DEFAULT NULL,
  `completion_gas_level` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `completion_damage_images` text COLLATE utf8mb4_unicode_ci,
  `completion_notes` text COLLATE utf8mb4_unicode_ci,
  `completed_at` timestamp NULL DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_bookings_booking_number_unique` (`booking_number`),
  UNIQUE KEY `cr_bookings_transaction_id_unique` (`transaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_bookings`
--

LOCK TABLES `cr_bookings` WRITE;
/*!40000 ALTER TABLE `cr_bookings` DISABLE KEYS */;
INSERT INTO `cr_bookings` VALUES (1,'#1000002','W50WJ6MBFEGH0K5TFOUJYVHGCGKBLQAS','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',450,450,0,NULL,45,'1','1',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-13 21:14:20','2025-11-17 21:14:20',4),(2,'#1000003','6WC6R8LMQQ1LWRSF7NJACBZ2JBUGVLD5','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',270,270,0,NULL,0,'1','2',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-07 21:14:20','2025-11-17 21:14:20',2),(3,'#1000004','5OCC18RUBSQVCNNNJLCKO4OUTVXIHQJT','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',90,90,0,NULL,0,'1','3',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-29 21:14:20','2025-11-17 21:14:20',3),(4,'#1000005','3PLXXFOYNG9IDDWGLGFWTIB11GWPGCDX','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',553,553,0,NULL,55.3,'1','4',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-13 21:14:20','2025-11-17 21:14:20',18),(5,'#1000006','ZPD9VJIUXSGTJFDL3JMIRVWORYC0K2CF','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',148,148,0,NULL,0,'1','5',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-18 21:14:20','2025-11-17 21:14:21',19),(6,'#1000007','9IWRVGSERGOOF0KTRHZ47ZVLXQE9PKNU','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',352,352,0,NULL,0,'1','6',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-11 21:14:21','2025-11-17 21:14:21',12),(7,'#1000008','NCWTUZ2H4ZQK3KODESO7QFJIKCBOEAAT','Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',NULL,'27',128,128,0,NULL,12.8,'1','7',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-02 21:14:21','2025-11-17 21:14:21',20),(8,'#1000009','UOERH8QHEM8S4PSRGPOAXQLD3NLRK3MH','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',288,288,0,NULL,28.8,'1','8',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-08 21:14:21','2025-11-17 21:14:21',NULL),(9,'#1000010','KAH8IUCHWJDAFXMGNBN2JAV2JY5LNW5M','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',266,266,0,NULL,0,'1','9',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-11-14 21:14:21','2025-11-17 21:14:21',NULL),(10,'#1000011','ZDJEOAJOYOU7UC43TVALCDY7NAMHFGXT','Dr. Rozella Fahey','oboyer@example.org','+19167009366',NULL,'26',56,56,0,NULL,0,'1','10',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-25 21:14:21','2025-11-17 21:14:21',NULL),(11,'#1000012','CPOCRQU5CCYXHMM9AGM3KLPES17CJYE5','Rylee Bogan','rickey.gleichner@example.org','+13412597092',NULL,'29',216,216,0,NULL,21.6,'1','11',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-11 21:14:21','2025-11-17 21:14:21',32),(12,'#1000013','PHRMUSZNHBZH19XSDWHNJZF2ZWX6C8HM','Dr. Rozella Fahey','oboyer@example.org','+19167009366',NULL,'26',420,420,0,NULL,0,'1','12',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-09 21:14:21','2025-11-17 21:14:21',10),(13,'#1000014','HLHRXETPBG1G8TAOIDCDS47PODX37UKY','Rylee Bogan','rickey.gleichner@example.org','+13412597092',NULL,'29',315,315,0,NULL,0,'1','13',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-03 21:14:21','2025-11-17 21:14:21',3),(14,'#1000015','MFI4W3ALMOI6NNHJW2OCOUVVFQPNPRAC','Dr. Rozella Fahey','oboyer@example.org','+19167009366',NULL,'26',105,105,0,NULL,10.5,'1','14',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-06 21:14:21','2025-11-17 21:14:21',17),(15,'#1000016','RNQMAPJXBV16FRJYPCAKRRD2S5MIF3O6','Alvena Will','cummerata.oda@example.org','+14693772940',NULL,'28',192,192,0,NULL,0,'1','15',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-16 21:14:21','2025-11-17 21:14:21',5),(16,'#1000017','MY5JIHWGLOUQHNBRLFJTYKND04QJT1M0','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',245,245,0,NULL,24.5,'1','16',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-06 21:14:21','2025-11-17 21:14:21',16),(17,'#1000018','ZPAXPC96PIL00PAOKNJDU5EB3R7TTKGY','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',195,195,0,NULL,0,'1','17',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-11-14 21:14:21','2025-11-17 21:14:21',3),(18,'#1000019','VTCSKRYEKI1VEGPZBPMOTMPBYZ2SOITK','Rylee Bogan','rickey.gleichner@example.org','+13412597092',NULL,'29',70,70,0,NULL,7,'1','18',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-06 21:14:21','2025-11-17 21:14:21',NULL),(19,'#1000020','7U543IQGMJYPTMZUTYFOXTK4WDTDH1TJ','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',66,66,0,NULL,0,'1','19',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-12 21:14:21','2025-11-17 21:14:21',NULL),(20,'#1000021','LWTB3ZPLFOELEYUHWNAJFEUYDVEJ7YJM','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',352,352,0,NULL,0,'1','20',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-15 21:14:21','2025-11-17 21:14:21',NULL),(21,'#1000022','1G4996FO4BWUXH7BIATSN1BFIOCK1LA5','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',90,90,0,NULL,0,'1','21',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:14:21','2025-11-17 21:14:21',7),(22,'#1000023','TJEMUU75CG0Y81H1YSDQFARUZR2GL6DG','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',588,588,0,NULL,0,'1','22',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-28 21:14:21','2025-11-17 21:14:21',9),(23,'#1000024','Q4C2X0WKPCNDPG6GPD7OKTOCYPLI4NVD','Alvena Will','cummerata.oda@example.org','+14693772940',NULL,'28',48,48,0,NULL,4.8,'1','23',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-14 21:14:21','2025-11-17 21:14:21',5),(24,'#1000025','VW1VZHJQX0JSTUANBX2O1VCTMCDVVLTD','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',96,96,0,NULL,9.6,'1','24',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-03 21:14:21','2025-11-17 21:14:21',15),(25,'#1000026','FQ91OOS2OUWDGDMPHSL2SUSPZAMJYVXU','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',51,51,0,NULL,0,'1','25',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-08 21:14:21','2025-11-17 21:14:21',15),(26,'#1000027','B17DWXKK0I6IJOLT3PPLZEDKXWYDVHE2','Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',NULL,'23',294,294,0,NULL,0,'1','26',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-29 21:14:21','2025-11-17 21:14:21',2),(27,'#1000028','18VRIRKDM1JRLRZQA8FOPTSAK9MPR2V1','Dr. Rozella Fahey','oboyer@example.org','+19167009366',NULL,'26',474,474,0,NULL,47.4,'1','27',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-16 21:14:21','2025-11-17 21:14:21',18),(28,'#1000029','DMSUQHLEVKWARNPHZMQ6DG8TIDSFJRJ7','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',525,525,0,NULL,52.5,'1','28',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-18 21:14:21','2025-11-17 21:14:21',NULL),(29,'#1000030','XUGEYUD1UBJLTYCANOGWGIAKR0FHTOPY','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',33,33,0,NULL,3.3,'1','29',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-09-27 21:14:21','2025-11-17 21:14:21',NULL),(30,'#1000031','J7XNNRLH27JKTCACQX9Q1YDTHY2XOQME','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',378,378,0,NULL,0,'1','30',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-02 21:14:21','2025-11-17 21:14:21',NULL),(31,'#1000032','9NDQLHEV9OXMSEBMWNKELG9FOPE8KQIG','Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',NULL,'23',105,105,0,NULL,0,'1','31',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-13 21:14:21','2025-11-17 21:14:21',16),(32,'#1000033','PZC7SNY3YZX14BLMEYQDCHVISKMNWV0S','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',55,55,0,NULL,5.5,'1','32',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-17 21:14:21','2025-11-17 21:14:21',18),(33,'#1000034','YSTTTYSZ6P2GYQB472NQVQKVEAMQETG1','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',215,215,0,NULL,0,'1','33',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-16 21:14:21','2025-11-17 21:14:21',3),(34,'#1000035','YZVOYVSWHNMBYAS7LX41YUYRQXW3X8GZ','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',180,180,0,NULL,0,'1','34',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-14 21:14:21','2025-11-17 21:14:21',7),(35,'#1000036','RM6TKE6N6SCAHXGJISFAA06VOKPE6EKI','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',380,380,0,NULL,0,'1','35',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-14 21:14:21','2025-11-17 21:14:21',13),(36,'#1000037','VZ1ITM2LE1MXCWHOO9ULCLEKCHNSFJMX','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',90,90,0,NULL,0,'1','36',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-15 21:14:21','2025-11-17 21:14:21',7),(37,'#1000038','U9HLCZMKDKOVXHC655AJYACRM9Z1WNT6','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',106,106,0,NULL,0,'1','37',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:14:21','2025-11-17 21:14:21',15),(38,'#1000039','BHUDXWBTPWNFYODS0B8RZTIGC3PHZRJK','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',114,114,0,NULL,0,'1','38',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-11 21:14:21','2025-11-17 21:14:21',NULL),(39,'#1000040','ZO77UCBEJUXRBWTYEVMRC8DXIYC5K04R','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',126,126,0,NULL,0,'1','39',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-14 21:14:21','2025-11-17 21:14:21',NULL),(40,'#1000041','OPJ5635ER6EIBHXFBY4S8A9A6P5QIZLD','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',33,33,0,NULL,0,'1','40',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-16 21:14:21','2025-11-17 21:14:21',NULL),(41,'#1000042','HVL0YJ3PKCOM1GEDD7SUDYCKZGFRVRTS','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',623,623,0,NULL,0,'1','41',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-15 21:14:21','2025-11-17 21:14:21',13),(42,'#1000043','SXLBXCCXEP0TEQXXRCU5GZR9BHSKLDQN','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',102,102,0,NULL,0,'1','42',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:14:21','2025-11-17 21:14:21',20),(43,'#1000044','2ADVYPPLS3OSYP0QGTT4GNPEE0CRYQ8D','Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',NULL,'23',224,224,0,NULL,0,'1','43',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-13 21:14:21','2025-11-17 21:14:21',2),(44,'#1000045','USD7J8GH6VQYBZRYKPZPTMK3VK5WYTYZ','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',532,532,0,NULL,0,'1','44',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-15 21:14:21','2025-11-17 21:14:21',13),(45,'#1000046','BOI9AQK1GWCE3SLJKH3Z7RYXFOHLR4BB','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',144,144,0,NULL,0,'1','45',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-10 21:14:21','2025-11-17 21:14:21',32),(46,'#1000047','QIQMGEBWTFFWGQ0A1ISP37MNGD9MSMJH','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',56,56,0,NULL,0,'1','46',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-16 21:14:21','2025-11-17 21:14:21',2),(47,'#1000048','DFSGDCXQFQYGNCZPJJXREUMRURFBQAFD','Rylee Bogan','rickey.gleichner@example.org','+13412597092',NULL,'29',180,180,0,NULL,0,'1','47',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:14:21','2025-11-17 21:14:21',14),(48,'#1000049','XURWHNOEFNSCHBFDRWRE3XQGIBDMNG6K','Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',NULL,'27',406,406,0,NULL,0,'1','48',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-13 21:14:21','2025-11-17 21:14:21',NULL),(49,'#1000050','WT6ENR6RHY6MMICEQQK5ZZNZJGT5Y31I','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',375,375,0,NULL,0,'1','49',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-10 21:14:21','2025-11-17 21:14:21',NULL),(50,'#1000051','OKILJBBRLPNJZBJ9Z6EQOMT3KCBBJ1XB','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',308,308,0,NULL,0,'1','50',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:14:21','2025-11-17 21:14:21',NULL),(51,'#1000052','XVDP3GY0FOOBSOEC7CNVUXU9XUE8I5OO','Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',NULL,'27',264,264,0,NULL,26.4,'1','51',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-07 21:14:21','2025-11-17 21:14:21',12),(52,'#1000053','BBJNZZ2QBR0O2GYT2YVZAXCM22GRLLJT','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',441,441,0,NULL,0,'1','52',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-14 21:14:21','2025-11-17 21:14:21',5),(53,'#1000054','TGNFMOY1XMKQR8FADU8HAVRZD1HMPORW','Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',NULL,'22',504,504,0,NULL,50.4,'1','53',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-14 21:14:21','2025-11-17 21:14:21',32),(54,'#1000055','6WO8FG6NRWSCFNWZDN7WSNVGY0OKY4QQ','Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',NULL,'27',434,434,0,NULL,0,'1','54',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-18 21:14:21','2025-11-17 21:14:21',14),(55,'#1000056','MIXPS9L8W3JUTS1MO04EXGMU73QEAJ9J','Alvena Will','cummerata.oda@example.org','+14693772940',NULL,'28',504,504,0,NULL,0,'1','55',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-16 21:14:21','2025-11-17 21:14:21',14),(56,'#1000057','MEJAATFUAL3CAROHNMHQII9AN1WWUNGA','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',276,276,0,NULL,0,'1','56',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-10 21:14:21','2025-11-17 21:14:21',11),(57,'#1000058','GAMYARTEMEWUJUHFRCB6G771CB6QDWYS','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',275,275,0,NULL,0,'1','57',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-06 21:14:21','2025-11-17 21:14:21',9),(58,'#1000059','VXZOJRDMBWNCXN9WR1COER7VRDQR3HMW','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',108,108,0,NULL,0,'1','58',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-26 21:14:21','2025-11-17 21:14:21',NULL),(59,'#1000060','RTSUCNHMQQPB7TJZJGB9NAJJPNBDTYLI','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',644,644,0,NULL,64.4,'1','59',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-07 21:14:21','2025-11-17 21:14:21',NULL),(60,'#1000061','A7VOZPHAVOQ5X2NCOGZYXUQVDFU1NXQZ','Rylee Bogan','rickey.gleichner@example.org','+13412597092',NULL,'29',616,616,0,NULL,0,'1','60',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-21 21:14:21','2025-11-17 21:14:21',NULL),(61,'#1000062','Y55W35LCIXH2AYFT8X1TKDC8G4IHOSKB','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',106,106,0,NULL,0,'1','61',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-01 21:14:21','2025-11-17 21:14:21',15),(62,'#1000063','WFVVKASPWGKIIGTLBULNXKQWZKCTEYRP','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',296,296,0,NULL,0,'1','62',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-29 21:14:21','2025-11-17 21:14:21',8),(63,'#1000064','2PGGSNU81ULBXKNFRIX1IQ3ZFU8SXA4N','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',552,552,0,NULL,55.2,'1','63',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-02 21:14:21','2025-11-17 21:14:21',1),(64,'#1000065','JVEXUTSODV2WMQBFTVV4IMLYSPOTQI4C','Sydnie Crooks','everardo.cole@example.com','+14793463231',NULL,'25',84,84,0,NULL,0,'1','64',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-07 21:14:21','2025-11-17 21:14:21',12),(65,'#1000066','Z4ANZKYMJWOCNCX2MBHPTRWVC1WZ5NLD','Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',NULL,'23',168,168,0,NULL,16.8,'1','65',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-28 21:14:21','2025-11-17 21:14:21',12),(66,'#1000067','TYDQAX9WAXEJZCLYSLMC3EJZOXLSXDMC','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',96,96,0,NULL,0,'1','66',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-07 21:14:21','2025-11-17 21:14:21',15),(67,'#1000068','VN7HNV2LAUF7035JUMLRLXSNDBFVBUDY','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',297,297,0,NULL,29.7,'1','67',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-02 21:14:21','2025-11-17 21:14:21',4),(68,'#1000069','1CCYLB302R8UFJ1ABBLUKBG1B1LVEL4K','Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',NULL,'23',462,462,0,NULL,0,'1','68',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-21 21:14:21','2025-11-17 21:14:21',NULL),(69,'#1000070','LA0JE56VAM3UP6KWA4WIM5JFXNU3CAIL','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',186,186,0,NULL,0,'1','69',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-12 21:14:21','2025-11-17 21:14:21',NULL),(70,'#1000071','5FDMX3H3CWLFTBJ8BMG6KQ4LNJJNUQEQ','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',462,462,0,NULL,0,'1','70',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-28 21:14:21','2025-11-17 21:14:21',NULL),(71,'#1000072','KBTS06XIYVZPDUKRHZGLNMUD9TNENZQ3','Alvena Will','cummerata.oda@example.org','+14693772940',NULL,'28',456,456,0,NULL,0,'1','71',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-27 21:14:22','2025-11-17 21:14:22',13),(72,'#1000073','T6P4VKR6SJAYMKZC7ROHI0PO3HAI16SZ','Dr. Rozella Fahey','oboyer@example.org','+19167009366',NULL,'26',468,468,0,NULL,0,'1','72',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-20 21:14:22','2025-11-17 21:14:22',17),(73,'#1000074','A3J1ASVIV2ZL86FVVWO9BFZ1XPSDKRFN','Rylee Bogan','rickey.gleichner@example.org','+13412597092',NULL,'29',170,170,0,NULL,0,'1','73',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-19 21:14:22','2025-11-17 21:14:22',18),(74,'#1000075','F0IQYDISMDOY5XP49SV9PSDKDFGO8BFU','Cielo Cruickshank V','customer@botble.com','+15126273228',NULL,'31',420,420,0,NULL,42,'1','74',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-21 21:14:22','2025-11-17 21:14:22',10),(75,'#1000076','DNYXJ0BPZK6Z0AY8ZW3GNKICNZFSIQW8','Pat Boyle','sonya.ruecker@example.net','+17409015709',NULL,'30',329,329,0,NULL,0,'1','75',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-04 21:14:22','2025-11-17 21:14:22',1),(76,'#1000077','PKFPDSDQI2A23CGSF2OJFSHDJ0VK00RP','Shanie Ritchie I','anais69@example.org','+18458662737',NULL,'24',76,76,0,NULL,0,'1','76',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-16 21:14:22','2025-11-17 21:14:22',13),(77,'#1000078','G0BLJP2E0JKBYFB6XUL6A4J23CWQPTAL','Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',NULL,'27',330,330,0,NULL,33,'1','77',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-18 21:14:22','2025-11-17 21:14:22',18),(78,'#1000079','6OYTPSK1TC5GKEYKYBXCYQHOLH6DQHSW','Alvena Will','cummerata.oda@example.org','+14693772940',NULL,'28',63,63,0,NULL,0,'1','78',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-12 21:14:22','2025-11-17 21:14:22',NULL),(79,'#1000080','XPJ5PT01FHXGH2YQIMFHOPA0FUS6CLH9','Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',NULL,'27',300,300,0,NULL,0,'1','79',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-27 21:14:22','2025-11-17 21:14:22',NULL),(80,'#1000081','Z3JIOSCPXFUMTUPKXFBXKQZRAREY0CXV','Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',NULL,'21',450,450,0,NULL,45,'1','80',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-28 21:14:22','2025-11-17 21:14:22',NULL);
/*!40000 ALTER TABLE `cr_bookings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenities`
--

DROP TABLE IF EXISTS `cr_car_amenities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_amenities_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenities`
--

LOCK TABLES `cr_car_amenities` WRITE;
/*!40000 ALTER TABLE `cr_car_amenities` DISABLE KEYS */;
INSERT INTO `cr_car_amenities` VALUES (1,'Leather upholstery','ti ti-armchair',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(2,'Heated seats','ti ti-flame',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(3,'Ventilated seats','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(4,'Memory seats','ti ti-device-floppy',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(5,'Massage seats','ti ti-massage',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(6,'Premium sound system','ti ti-volume',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(7,'Wireless charging','ti ti-battery-charging',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(8,'Dual-zone climate control','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(9,'Ambient lighting','ti ti-bulb',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(10,'Touchscreen display','ti ti-device-tablet',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(11,'Apple CarPlay','ti ti-brand-apple',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(12,'Android Auto','ti ti-brand-android',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(13,'Bluetooth connectivity','ti ti-bluetooth',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(14,'USB ports','ti ti-usb',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(15,'Navigation system','ti ti-map-pin',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(16,'Heads-up display','ti ti-device-desktop',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(17,'Digital instrument cluster','ti ti-dashboard',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(18,'Voice control','ti ti-microphone',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(19,'Sunroof/Moonroof','ti ti-sun',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(20,'Panoramic roof','ti ti-sun-high',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(21,'Power tailgate','ti ti-door',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(22,'Keyless entry','ti ti-key',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(23,'Push-button start','ti ti-power',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(24,'Remote start','ti ti-remote',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(25,'Heated mirrors','ti ti-flame',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(26,'Rain-sensing wipers','ti ti-droplet',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(27,'Auto-dimming mirrors','ti ti-brightness-down',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(28,'Adaptive cruise control','ti ti-steering-wheel',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(29,'Lane departure warning','ti ti-road-sign',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(30,'Blind spot monitoring','ti ti-eye',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(31,'Parking sensors','ti ti-radar',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(32,'Backup camera','ti ti-camera',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(33,'360-degree camera','ti ti-360-view',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(34,'Automatic emergency braking','ti ti-shield-check',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(35,'Cross-traffic alert','ti ti-alert-triangle',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(36,'Driver attention monitoring','ti ti-eye-check',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(37,'All-wheel drive','ti ti-car-4wd',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(38,'Sport mode','ti ti-flag',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(39,'Paddle shifters','ti ti-steering-wheel',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(40,'Adaptive suspension','ti ti-adjustments',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(41,'Electronic stability control','ti ti-shield',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(42,'Traction control','ti ti-wheel',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(43,'Hill start assist','ti ti-mountain',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(44,'Downhill assist control','ti ti-trending-down',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(45,'Air conditioning','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(46,'Power windows','ti ti-window',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(47,'Central locking','ti ti-lock',NULL,'published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35');
/*!40000 ALTER TABLE `cr_car_amenities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenities_translations`
--

DROP TABLE IF EXISTS `cr_car_amenities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenities_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_amenities_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_amenities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenities_translations`
--

LOCK TABLES `cr_car_amenities_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_amenities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_amenities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenity_categories`
--

DROP TABLE IF EXISTS `cr_car_amenity_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenity_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '0',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_amenity_categories_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenity_categories`
--

LOCK TABLES `cr_car_amenity_categories` WRITE;
/*!40000 ALTER TABLE `cr_car_amenity_categories` DISABLE KEYS */;
INSERT INTO `cr_car_amenity_categories` VALUES (1,'Comfort & Interior','ti ti-armchair',1,'published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(2,'Technology & Infotainment','ti ti-device-tablet',2,'published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(3,'Exterior & Convenience','ti ti-sun',3,'published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(4,'Safety & Driver Assistance','ti ti-shield-check',4,'published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(5,'Performance & Handling','ti ti-steering-wheel',5,'published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(6,'Basic Features','ti ti-car',6,'published','2025-11-17 21:13:35','2025-11-17 21:13:35');
/*!40000 ALTER TABLE `cr_car_amenity_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenity_categories_translations`
--

DROP TABLE IF EXISTS `cr_car_amenity_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenity_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_amenity_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_amenity_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenity_categories_translations`
--

LOCK TABLES `cr_car_amenity_categories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_amenity_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_amenity_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_categories`
--

DROP TABLE IF EXISTS `cr_car_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_categories`
--

LOCK TABLES `cr_car_categories` WRITE;
/*!40000 ALTER TABLE `cr_car_categories` DISABLE KEYS */;
INSERT INTO `cr_car_categories` VALUES (1,'Sport',0,'Sport cars model','published','ti ti-sport-billard',1,0,0,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(2,'Maserati',1,'','published','ti ti-activity',3,0,0,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(3,'Ferrari',1,'','published',NULL,3,0,0,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(4,'Classic',0,'Classic cars model','published','ti ti-alpha',2,0,0,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(5,'New',0,'New cars model','published','ti ti-new-section',4,0,1,'2025-11-17 21:14:20','2025-11-17 21:14:20');
/*!40000 ALTER TABLE `cr_car_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_categories_translations`
--

DROP TABLE IF EXISTS `cr_car_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_car_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_categories_translations`
--

LOCK TABLES `cr_car_categories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_colors`
--

DROP TABLE IF EXISTS `cr_car_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_colors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_colors_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_colors`
--

LOCK TABLES `cr_car_colors` WRITE;
/*!40000 ALTER TABLE `cr_car_colors` DISABLE KEYS */;
INSERT INTO `cr_car_colors` VALUES (1,'Red','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(2,'White','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(3,'Black','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(4,'Blue','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(5,'Pink','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(6,'Brown','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35');
/*!40000 ALTER TABLE `cr_car_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_colors_translations`
--

DROP TABLE IF EXISTS `cr_car_colors_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_colors_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_colors_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_colors_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_colors_translations`
--

LOCK TABLES `cr_car_colors_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_colors_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_colors_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_fuels`
--

DROP TABLE IF EXISTS `cr_car_fuels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_fuels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_fuels_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_fuels`
--

LOCK TABLES `cr_car_fuels` WRITE;
/*!40000 ALTER TABLE `cr_car_fuels` DISABLE KEYS */;
INSERT INTO `cr_car_fuels` VALUES (1,'Gasoline','icons/car-diesel.png','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(2,'Diesel','icons/car-diesel.png','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(3,'Electric','icons/car-electricity.png','published',0,'2025-11-17 21:13:35','2025-11-17 21:13:35');
/*!40000 ALTER TABLE `cr_car_fuels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_fuels_translations`
--

DROP TABLE IF EXISTS `cr_car_fuels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_fuels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_fuels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_fuels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_fuels_translations`
--

LOCK TABLES `cr_car_fuels_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_fuels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_fuels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_maintenance_histories`
--

DROP TABLE IF EXISTS `cr_car_maintenance_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_maintenance_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `amount` double NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned NOT NULL,
  `date` datetime DEFAULT NULL,
  `car_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_maintenance_histories_car_id_index` (`car_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_maintenance_histories`
--

LOCK TABLES `cr_car_maintenance_histories` WRITE;
/*!40000 ALTER TABLE `cr_car_maintenance_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_maintenance_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_maintenance_histories_translations`
--

DROP TABLE IF EXISTS `cr_car_maintenance_histories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_maintenance_histories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_maintenance_histories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_maintenance_histories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_maintenance_histories_translations`
--

LOCK TABLES `cr_car_maintenance_histories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_maintenance_histories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_maintenance_histories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_makes`
--

DROP TABLE IF EXISTS `cr_car_makes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_makes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_makes`
--

LOCK TABLES `cr_car_makes` WRITE;
/*!40000 ALTER TABLE `cr_car_makes` DISABLE KEYS */;
INSERT INTO `cr_car_makes` VALUES (1,'Lexus','icons/lexus.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(2,'Mercedes','icons/mer.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(3,'Bugatti','icons/bugatti.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(4,'Jaguar','icons/jaguar.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(5,'Honda','icons/honda.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(6,'Chevrolet','icons/chevrolet.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(7,'Acura','icons/acura.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(8,'BMW','icons/bmw.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(9,'Toyota','icons/toyota.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(10,'Ford','icons/ford-i.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(11,'Nissan','icons/nissan-i.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(12,'Opel','icons/opel-i.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(13,'BMW','icons/bmw.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(14,'Toyota','icons/toyota.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34');
/*!40000 ALTER TABLE `cr_car_makes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_makes_translations`
--

DROP TABLE IF EXISTS `cr_car_makes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_makes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_makes_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_makes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_makes_translations`
--

LOCK TABLES `cr_car_makes_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_makes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_makes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_reviews`
--

DROP TABLE IF EXISTS `cr_car_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `star` double NOT NULL DEFAULT '0',
  `customer_id` bigint unsigned NOT NULL,
  `car_id` bigint unsigned NOT NULL,
  `booking_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_reviews_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_reviews`
--

LOCK TABLES `cr_car_reviews` WRITE;
/*!40000 ALTER TABLE `cr_car_reviews` DISABLE KEYS */;
INSERT INTO `cr_car_reviews` VALUES (1,'Decent car for the price. The interior space was adequate a small scuff on the rear bumper but overall acceptable for vacation. Would consider again if needed.',3,26,46,NULL,'published','2025-05-01 03:31:52','2025-11-17 21:14:20'),(2,'Excellent value for money. The automatic climate control worked perfectly Performed consistently throughout our rental Reliable transportation for our family trip Will book with them again for sure.',4,10,37,NULL,'published','2024-12-02 20:44:27','2025-11-17 21:14:20'),(3,'Outstanding rental experience! The car was immaculate inside and out The car was mechanically perfect and handled like a dream on every road. The staff went above and beyond to help us Exceeded all expectations. Will definitely be back!',5,32,30,NULL,'published','2025-04-01 13:56:58','2025-11-17 21:14:20'),(4,'Great rental experience! Easy to drive and park The car was spotless inside and out and had plenty of power when needed. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,31,8,NULL,'published','2024-11-03 22:22:39','2025-11-17 21:14:20'),(5,'Standard rental car. The car was clean and functional The GPS was a bit outdated Reasonable option for basic transportation Met basic expectations.',3,25,61,NULL,'published','2025-09-05 06:14:41','2025-11-17 21:14:20'),(6,'Average rental experience. The vehicle met basic expectations Minor scuff on the bumper but the price was fair. Nothing special but gets the job done.',3,1,61,NULL,'published','2025-07-09 13:59:32','2025-11-17 21:14:20'),(7,'Absolutely fantastic! Every feature worked flawlessly Performed flawlessly under all conditions A truly exceptional experience from start to finish This is how car rentals should be done. Thank you for an amazing experience!',5,9,88,NULL,'published','2024-03-17 10:28:39','2025-11-17 21:14:20'),(8,'Really enjoyed driving this car. Climate control worked perfectly Smooth acceleration and responsive braking Handled the mountain roads beautifully Only minor complaint is the cup holders were a bit small. Highly recommend!',4,19,31,NULL,'published','2023-12-18 12:21:06','2025-11-17 21:14:20'),(9,'Decent car for the price. The handling was predictable the owner\'s manual being missing but overall acceptable for weekend getaway. Would consider again if needed.',3,17,28,NULL,'published','2025-10-19 03:31:41','2025-11-17 21:14:20'),(10,'Really enjoyed driving this car. Incredibly comfortable for long drives The engine performed well on both city and highway Impressed all our passengers Only minor complaint is the return process was slightly confusing. Highly recommend!',4,6,95,NULL,'published','2024-07-31 17:59:18','2025-11-17 21:14:20'),(11,'Mixed feelings about this rental. the comfort level was quite good but the pickup process was slower than expected. Gets you from point A to point B Fair value for money.',3,24,62,NULL,'published','2025-10-06 01:52:01','2025-11-17 21:14:20'),(12,'Below expectations. The radio presets weren\'t cleared The car was decent enough for basic needs but The vehicle\'s mechanical condition. The staff was friendly enough but overall not satisfied with the rental.',2,12,8,NULL,'published','2025-05-25 14:10:25','2025-11-17 21:14:20'),(13,'Horrible condition vehicle. Multiple warning lights were illuminated I felt unsafe driving it. One of the headlights was dimmer than the other Customer service was rude when I complained.',1,29,13,NULL,'published','2024-12-03 11:29:40','2025-11-17 21:14:20'),(14,'Best rental car I\'ve ever had! Impeccable attention to every detail Service that sets the gold standard Worth every penny and more Everything was perfect from start to finish. Will definitely use again!',5,22,55,NULL,'published','2024-02-11 03:20:40','2025-11-17 21:14:20'),(15,'Had some issues with this rental. The radio kept cutting out which made navigation very difficult The price was reasonable but the quality didn\'t match.',2,28,11,NULL,'published','2025-02-25 19:15:49','2025-11-17 21:14:20'),(16,'Very pleased with this rental. Well-maintained and cared for vehicle Quick and easy pickup process Perfect for business or leisure travel Just a small issue with the pickup location being slightly hard to find but nothing major.',4,5,97,NULL,'published','2024-08-14 11:37:51','2025-11-17 21:14:20'),(17,'Average rental experience. The car served its purpose adequately The radio presets weren\'t cleared but the car was clean. Nothing special but gets the job done.',3,7,100,NULL,'published','2024-08-05 19:08:28','2025-11-17 21:14:20'),(18,'Perfect car for our vacation! Every passenger commented on the amazing comfort Performance that rivals much more expensive cars Outstanding professionalism and care Cannot fault anything about this rental. 10/10 would recommend!',5,4,60,NULL,'published','2025-05-06 06:25:43','2025-11-17 21:14:20'),(19,'Excellent value for money. The automatic climate control worked perfectly Performed consistently throughout our rental Enhanced our weekend getaway experience Will book with them again for sure.',4,4,49,NULL,'published','2023-12-20 15:15:21','2025-11-17 21:14:20'),(20,'Mixed feelings about this rental. the overall condition was satisfactory but the car showed some wear and tear. Reasonable option if you\'re not picky Fair value for money.',3,19,50,NULL,'published','2025-10-13 00:49:44','2025-11-17 21:14:20'),(21,'Really enjoyed driving this car. Plenty of legroom for everyone The car felt stable and well-balanced Perfect for our family vacation Only minor complaint is the return process was slightly confusing. Highly recommend!',4,22,76,NULL,'published','2025-06-21 18:44:33','2025-11-17 21:14:20'),(22,'Decent car for the price. The air conditioning was effective the radio taking a moment to connect to Bluetooth but overall acceptable for business trip. Would consider again if needed.',3,13,53,NULL,'published','2025-03-01 19:14:12','2025-11-17 21:14:20'),(23,'Best rental car I\'ve ever had! Exceptional craftsmanship and care The customer service was world-class Premium experience at a fair price Everything was perfect from start to finish. Will definitely use again!',5,3,54,NULL,'published','2025-10-04 15:00:54','2025-11-17 21:14:20'),(24,'Best rental car I\'ve ever had! The quality was absolutely pristine The customer service was world-class Premium experience at a fair price Everything was perfect from start to finish. Will definitely use again!',5,31,71,NULL,'published','2025-07-07 08:25:43','2025-11-17 21:14:20'),(25,'Standard rental car. Served our transportation needs The radio presets weren\'t cleared Meets expectations without exceeding them Met basic expectations.',3,25,72,NULL,'published','2025-11-12 03:35:57','2025-11-17 21:14:20'),(26,'Standard rental car. The car was clean and functional The GPS was a bit outdated Meets expectations without exceeding them Met basic expectations.',3,6,22,NULL,'published','2024-09-08 13:40:07','2025-11-17 21:14:20'),(27,'Great rental experience! Spacious interior The car was clean and well-maintained and handled beautifully on both city and highway. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,31,65,NULL,'published','2024-01-21 12:37:03','2025-11-17 21:14:20'),(28,'Perfect car for our weekend getaway! Unparalleled comfort for long-distance driving The performance was absolutely flawless Staff went above and beyond at every step Cannot fault anything about this rental. 10/10 would recommend!',5,7,54,NULL,'published','2024-07-05 21:44:41','2025-11-17 21:14:20'),(29,'Absolutely fantastic! State-of-the-art amenities throughout Reliability that exceeded all expectations Everything about this rental was perfect This is how car rentals should be done. Thank you for an amazing experience!',5,6,57,NULL,'published','2025-07-27 13:05:44','2025-11-17 21:14:20'),(30,'Mixed feelings about this rental. the car was reliable throughout our trip but the vehicle felt a bit dated. Gets you from point A to point B Fair value for money.',3,16,23,NULL,'published','2024-01-20 21:08:02','2025-11-17 21:14:20'),(31,'Absolutely fantastic! State-of-the-art amenities throughout Absolutely perfect reliability record Everything about this rental was perfect This is how car rentals should be done. Thank you for an amazing experience!',5,18,14,NULL,'published','2024-09-23 17:23:53','2025-11-17 21:14:20'),(32,'Really enjoyed driving this car. Incredibly comfortable for long drives The car felt stable and well-balanced Handled the mountain roads beautifully Only minor complaint is the cup holders were a bit small. Highly recommend!',4,8,42,NULL,'published','2024-06-26 18:08:13','2025-11-17 21:14:20'),(33,'Outstanding rental experience! Whisper-quiet cabin and smooth ride The car was like driving a brand new car and handled like a dream on every road. They made everything so easy and stress-free Exceeded all expectations. Will definitely be back!',5,28,9,NULL,'published','2024-12-23 21:16:01','2025-11-17 21:14:20'),(34,'Absolutely fantastic! State-of-the-art amenities throughout Absolutely perfect reliability record This rental exceeded every expectation This is how car rentals should be done. Thank you for an amazing experience!',5,30,14,NULL,'published','2024-01-26 21:06:30','2025-11-17 21:14:20'),(35,'Really enjoyed driving this car. Climate control worked perfectly The car felt stable and well-balanced Perfect for our family vacation Only minor complaint is the return process was slightly confusing. Highly recommend!',4,4,58,NULL,'published','2024-12-31 10:43:58','2025-11-17 21:14:20'),(36,'Very pleased with this rental. Well-maintained and cared for vehicle Made the rental process seamless Excellent option for families Just a small issue with one cup holder being a bit loose but nothing major.',4,25,98,NULL,'published','2024-11-08 21:12:56','2025-11-17 21:14:20'),(37,'Standard rental car. Adequate for the rental period The GPS was a bit outdated Reasonable option for basic transportation Met basic expectations.',3,23,23,NULL,'published','2025-07-07 22:57:48','2025-11-17 21:14:20'),(38,'Very pleased with this rental. Attention to detail was evident throughout Excellent customer service Would definitely recommend to others Just a small issue with a small scuff on the rear bumper but nothing major.',4,24,39,NULL,'published','2024-10-16 09:12:45','2025-11-17 21:14:20'),(39,'Great rental experience! Spacious interior The car was very reliable and handled beautifully on both city and highway. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,13,3,NULL,'published','2024-04-08 09:48:06','2025-11-17 21:14:20'),(40,'Perfect car for our conference! The seats were like luxury recliners Outstanding handling that exceeded expectations Outstanding professionalism and care Cannot fault anything about this rental. 10/10 would recommend!',5,28,46,NULL,'published','2025-05-31 20:36:17','2025-11-17 21:14:20'),(41,'Great rental experience! Great sound system The car was spotless inside and out and handled beautifully on both city and highway. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,26,85,NULL,'published','2025-08-27 00:28:59','2025-11-17 21:14:20'),(42,'Decent car for the price. The visibility was good one cup holder being a bit loose but overall acceptable for family road trip. Would consider again if needed.',3,11,20,NULL,'published','2025-02-18 09:08:45','2025-11-17 21:14:20'),(43,'Disappointing rental experience. The cleanliness standards was problematic and The interior was dirty and smelled bad. Some good points but too many negatives.',2,2,40,NULL,'published','2024-10-25 03:57:58','2025-11-17 21:14:20'),(44,'Not great but manageable. The technology was quite outdated The car started reliably Would look for other options next time.',2,30,72,NULL,'published','2025-07-24 17:04:53','2025-11-17 21:14:20'),(45,'Really enjoyed driving this car. Incredibly comfortable for long drives Good handling in various driving conditions Great for city driving and parking Only minor complaint is the return process was slightly confusing. Highly recommend!',4,27,40,NULL,'published','2024-01-28 20:01:53','2025-11-17 21:14:20'),(46,'Mixed feelings about this rental. the overall condition was satisfactory but the customer service could be improved. Does what it\'s supposed to do Fair value for money.',3,5,57,NULL,'published','2025-06-26 01:52:56','2025-11-17 21:14:20'),(47,'Excellent value for money. The infotainment system was user-friendly Performed consistently throughout our rental Perfect companion for our business travel Will book with them again for sure.',4,21,60,NULL,'published','2025-09-26 11:45:04','2025-11-17 21:14:20'),(48,'Really enjoyed driving this car. Plenty of legroom for everyone The car felt stable and well-balanced Great for city driving and parking Only minor complaint is one of the USB ports wasn\'t working. Highly recommend!',4,31,11,NULL,'published','2024-09-05 07:12:11','2025-11-17 21:14:20'),(49,'Decent car for the price. The air conditioning was effective one cup holder being a bit loose but overall acceptable for business trip. Would consider again if needed.',3,30,76,NULL,'published','2025-05-07 16:35:58','2025-11-17 21:14:20'),(50,'Great rental experience! The car was clean and well-maintained The car was in excellent mechanical condition and had plenty of power when needed. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,2,95,NULL,'published','2025-09-25 06:10:59','2025-11-17 21:14:20'),(51,'Decent car for the price. The interior space was adequate the owner\'s manual being missing but overall acceptable for vacation. Would consider again if needed.',3,26,70,NULL,'published','2025-09-16 13:52:39','2025-11-17 21:14:20'),(52,'Standard rental car. The car was clean and functional Minor scuff on the bumper Reasonable option for basic transportation Met basic expectations.',3,29,2,NULL,'published','2024-06-23 10:51:21','2025-11-17 21:14:20'),(53,'Best rental car I\'ve ever had! Quality that rivals the finest vehicles Outstanding professionalism and care Worth every penny and more Everything was perfect from start to finish. Will definitely use again!',5,16,11,NULL,'published','2024-10-22 19:19:00','2025-11-17 21:14:20'),(54,'Mixed feelings about this rental. the comfort level was quite good but the car showed some wear and tear. Gets you from point A to point B Fair value for money.',3,2,87,NULL,'published','2024-06-02 18:22:52','2025-11-17 21:14:20'),(55,'Really enjoyed driving this car. Very quiet cabin for conversations Reliable performance throughout our trip Impressed all our passengers Only minor complaint is the car manual was missing. Highly recommend!',4,13,12,NULL,'published','2024-07-18 14:33:45','2025-11-17 21:14:20'),(56,'Excellent value for money. The keyless entry was very convenient Never had a single mechanical issue Perfect companion for our business travel Will book with them again for sure.',4,29,31,NULL,'published','2025-07-22 04:51:25','2025-11-17 21:14:20'),(57,'Great rental experience! Great sound system The car was very reliable and had plenty of power when needed. Minor scuff on the bumper but overall very satisfied. Would definitely rent again.',4,4,87,NULL,'published','2025-05-28 20:06:52','2025-11-17 21:14:20'),(58,'Disappointing rental experience. The cleanliness standards was problematic and The interior was dirty and smelled bad. Some good points but too many negatives.',2,18,7,NULL,'published','2024-10-16 01:08:47','2025-11-17 21:14:20'),(59,'Absolutely fantastic! Every feature worked flawlessly Performed flawlessly under all conditions Absolutely outstanding in every possible way This is how car rentals should be done. Thank you for an amazing experience!',5,22,4,NULL,'published','2024-06-14 15:17:28','2025-11-17 21:14:20'),(60,'Really enjoyed driving this car. Incredibly comfortable for long drives Reliable performance throughout our trip Perfect for our family vacation Only minor complaint is the cup holders were a bit small. Highly recommend!',4,5,31,NULL,'published','2025-02-10 04:31:15','2025-11-17 21:14:20');
/*!40000 ALTER TABLE `cr_car_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_tag`
--

DROP TABLE IF EXISTS `cr_car_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_tag` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_tag`
--

LOCK TABLES `cr_car_tag` WRITE;
/*!40000 ALTER TABLE `cr_car_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_transmissions`
--

DROP TABLE IF EXISTS `cr_car_transmissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_transmissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_transmissions_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_transmissions`
--

LOCK TABLES `cr_car_transmissions` WRITE;
/*!40000 ALTER TABLE `cr_car_transmissions` DISABLE KEYS */;
INSERT INTO `cr_car_transmissions` VALUES (1,'Automatic','icons/car-transmission-auto.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(2,'Manual','icons/car-transmission-manual.png','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34');
/*!40000 ALTER TABLE `cr_car_transmissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_transmissions_translations`
--

DROP TABLE IF EXISTS `cr_car_transmissions_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_transmissions_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_transmissions_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_transmissions_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_transmissions_translations`
--

LOCK TABLES `cr_car_transmissions_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_transmissions_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_transmissions_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_types`
--

DROP TABLE IF EXISTS `cr_car_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_types_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_types`
--

LOCK TABLES `cr_car_types` WRITE;
/*!40000 ALTER TABLE `cr_car_types` DISABLE KEYS */;
INSERT INTO `cr_car_types` VALUES (1,'SUV','cars/car-1.jpg','ti ti-car-suv','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(2,'Hatchback','cars/car-2.jpg','ti ti-car','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(3,'Sedan','cars/car-3.jpg','ti ti-car','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(4,'Crossover','cars/car-4.jpg','ti ti-car-4wd','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(5,'Minivan','cars/car-5.jpg','ti ti-caravan','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(6,'Coupe','cars/car-6.jpg','ti ti-car','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(7,'Sport Cars','cars/car-7.jpg','ti ti-car-turbine','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(8,'Pickup Truck','cars/car-8.jpg','ti ti-truck','published',0,'2025-11-17 21:13:34','2025-11-17 21:13:34');
/*!40000 ALTER TABLE `cr_car_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_types_translations`
--

DROP TABLE IF EXISTS `cr_car_types_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_types_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_types_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_types_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_types_translations`
--

LOCK TABLES `cr_car_types_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_types_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_types_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_views`
--

DROP TABLE IF EXISTS `cr_car_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2025-11-18',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_car_views_car_id_date_unique` (`car_id`,`date`),
  KEY `cr_car_views_car_id_index` (`car_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_views`
--

LOCK TABLES `cr_car_views` WRITE;
/*!40000 ALTER TABLE `cr_car_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars`
--

DROP TABLE IF EXISTS `cr_cars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `images` text COLLATE utf8mb4_unicode_ci,
  `license_plate` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `make_id` bigint unsigned DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `year` int unsigned DEFAULT NULL,
  `mileage` int unsigned DEFAULT NULL,
  `horsepower` decimal(8,2) DEFAULT NULL,
  `vehicle_type_id` bigint unsigned DEFAULT NULL,
  `transmission_id` bigint unsigned DEFAULT NULL,
  `fuel_type_id` bigint unsigned DEFAULT NULL,
  `number_of_seats` int unsigned DEFAULT NULL,
  `number_of_doors` int unsigned DEFAULT NULL,
  `rental_rate` double unsigned NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rental_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'per_day',
  `rental_available_types` text COLLATE utf8mb4_unicode_ci,
  `insurance_info` text COLLATE utf8mb4_unicode_ci,
  `vin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_used` tinyint(1) NOT NULL DEFAULT '0',
  `is_for_sale` tinyint(1) NOT NULL DEFAULT '0',
  `sale_price` decimal(15,2) DEFAULT NULL,
  `condition` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ownership_history` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `warranty_information` text COLLATE utf8mb4_unicode_ci,
  `sale_status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `external_booking_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `vendor_id` bigint unsigned DEFAULT NULL,
  `moderation_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `reject_reason` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_cars_make_id_index` (`make_id`),
  KEY `cr_cars_status_index` (`status`),
  KEY `cr_cars_vehicle_type_id_index` (`vehicle_type_id`),
  KEY `cr_cars_vin_index` (`vin`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars`
--

LOCK TABLES `cr_cars` WRITE;
/*!40000 ALTER TABLE `cr_cars` DISABLE KEYS */;
INSERT INTO `cr_cars` VALUES (1,'Toyota Camry XLE Hybrid 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/60.jpg\",\"cars\\/11.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-123.00',3,'available',2012,4346,NULL,5,2,3,5,2,75,NULL,NULL,'per_day',NULL,'','8VA4VYW84RYKW07WU','',1,3,7,'72662 Bennett Way Floor 644',NULL,1,1,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=toyota-camry-xle-hybrid-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(2,'Honda Accord Sport 2.0T 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/38.jpg\",\"cars\\/41.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-123.11',3,'available',2016,18559,NULL,3,2,2,8,4,67,NULL,NULL,'per_day',NULL,'','3MVT3YCD9YWRCHAJD','',1,1,1,'42328 Gomez View',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.enterprise.com/en/reserve.html?vehicleType=honda-accord-sport-2.0t-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(3,'Mercedes-Benz C300 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/87.jpg\",\"cars\\/41.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\"]','29A-123.22',8,'available',2020,2927,NULL,6,1,1,5,2,60,NULL,NULL,'per_day',NULL,'','8HTZ68HJ11XE05AT8','',1,4,8,'63990 Wilson Boulevard',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(4,'BMW 330i xDrive M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/1.jpg\",\"cars\\/2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-123.33',14,'available',2017,7385,NULL,6,2,3,7,5,55,NULL,NULL,'per_day',NULL,'','Z8XR5MNK20FV28HZC','',1,3,7,'69007 Parker Way Floor 782',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(5,'Lexus ES 350 F Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/71.jpg\",\"cars\\/102.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-123.44',9,'available',2016,10088,NULL,5,2,2,7,4,52,NULL,NULL,'per_day',NULL,'','8ZGCG0F7248SPZ5JF','',1,3,6,'78846 Diaz Boulevard',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(6,'Toyota RAV4 Prime XSE AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/83.jpg\",\"cars\\/72.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-123.55',13,'available',2023,11747,NULL,4,3,2,4,4,88,NULL,NULL,'per_day',NULL,'','GT3PRVGR349K9PNJZ','',1,4,9,'36491 Collins Trail',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(7,'Honda CR-V Touring Hybrid AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/96.jpg\",\"cars\\/39.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\"]','30A-123.66',12,'available',2012,9135,NULL,5,3,1,8,5,79,NULL,NULL,'per_day',NULL,'','XP6UDDJ75VULMZ0YB','',4,11,18,'87086 Stewart Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(8,'BMW X5 xDrive40i M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/100.jpg\",\"cars\\/44.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-123.77',14,'available',2018,10346,NULL,7,2,1,7,4,63,NULL,NULL,'per_day',NULL,'','PAX4GUFE3N86UVHML','',1,4,8,'42872 Cox Court',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(9,'Mercedes-Benz GLC 300 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/34.jpg\",\"cars\\/22.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-123.88',7,'available',2021,17651,NULL,4,1,3,7,4,39,NULL,NULL,'per_day',NULL,'','MHN4A8JS9W8CYJVPV','',4,11,18,'94856 Elm Point',NULL,1,1,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=mercedes-benz-glc-300-4matic-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(10,'Lexus RX 350 F Sport Handling AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/15.jpg\",\"cars\\/69.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-123.99',10,'available',2011,2184,NULL,1,2,2,8,5,58,NULL,NULL,'per_day',NULL,'','2N68M8WD9AHNCCPYS','',3,9,16,'33140 Oren Pass',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(11,'Audi A4 Premium Plus quattro 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/17.jpg\",\"cars\\/90.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-456.00',3,'available',2021,3459,NULL,6,1,3,4,2,75,NULL,NULL,'per_day',NULL,'','MFBE3WHR2XFU5FW03','',1,1,1,'2740 Ortiz Pass',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(12,'Mazda CX-5 2.5 Turbo Signature AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/100.jpg\",\"cars\\/67.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30A-456.11',2,'available',2020,2444,NULL,5,1,3,8,2,31,NULL,NULL,'per_day',NULL,'','FR98UN5E43TFR6ZF6','',1,2,5,'93442 Kelly Parkway Floor 726',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(13,'Tesla Model 3 Long Range AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/32.jpg\",\"cars\\/16.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-456.22',4,'available',2022,1658,NULL,8,2,1,7,2,57,NULL,NULL,'per_day',NULL,'','14JGS9E5863SE52ZH','',5,13,20,'74179 Gray Parkway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.europcar.com/en-us/car-rental/vehicles/tesla-model-3-long-range-awd-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(14,'Porsche Macan S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/56.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-456.33',6,'available',2010,5683,NULL,4,1,3,5,5,40,NULL,NULL,'per_day',NULL,'','SBRJ074M377GHW73D','',7,17,24,'44252 Stewart Court',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(15,'Volvo XC60 B6 Ultimate AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/99.jpg\",\"cars\\/24.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-456.44',7,'available',2016,18843,NULL,5,2,2,4,2,98,NULL,NULL,'per_day',NULL,'','TSF0UCTD0HWVV6YGN','',1,1,1,'59866 Clark Landing',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/volvo-xc60-b6-ultimate-awd-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(16,'Genesis G70 3.3T Sport Prestige AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/61.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','30A-456.55',2,'available',2013,9509,NULL,1,2,2,4,5,49,NULL,NULL,'per_day',NULL,'','KFSN1A6J24B3E0MD7','',2,6,12,'89551 Russell Avenue',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(17,'Subaru Outback Limited XT 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/29.jpg\",\"cars\\/45.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\"]','30A-456.66',5,'available',2014,14443,NULL,5,2,1,8,2,44,NULL,NULL,'per_day',NULL,'','UMTTRL9S8TWNJ6BBZ','',1,4,8,'7087 Willow Road',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(18,'Acura MDX Type S Advance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/35.jpg\",\"cars\\/32.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-456.77',14,'available',2016,13836,NULL,6,1,1,8,5,74,NULL,NULL,'per_day',NULL,'','3H40SLBV152AGXETZ','',2,7,13,'7896 Gutierrez Ridge',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(19,'Range Rover Evoque P250 S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/32.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\"]','30A-456.88',2,'available',2013,3011,NULL,6,1,1,7,4,65,NULL,NULL,'per_day',NULL,'','6SRTWBKU1TJ7TH805','',2,6,12,'4776 Wood Place',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(20,'Infiniti QX60 Autograph AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/53.jpg\",\"cars\\/54.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-456.99',13,'available',2015,3604,NULL,7,1,2,8,2,42,NULL,NULL,'per_day',NULL,'','AY3V8CFR1K5J8L7LS','',1,1,1,'84748 Main Heights',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(21,'Nissan Altima SR VC-Turbo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/51.jpg\",\"cars\\/7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\"]','29A-789.00',9,'available',2023,6608,NULL,2,1,1,8,5,97,NULL,NULL,'per_day',NULL,'','VRW84ZPB6B6ZFL9D9','',6,15,22,'29247 Ash Parkway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(22,'Hyundai Sonata N Line 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/92.jpg\",\"cars\\/56.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-789.11',12,'available',2015,8748,NULL,3,3,2,8,2,48,NULL,NULL,'per_day',NULL,'','B1WGT24X9D1P7PUP1','',1,4,9,'91949 Price Drive',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(23,'Kia Stinger GT2 AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/5.jpg\",\"cars\\/66.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\"]','29A-789.22',9,'available',2015,9588,NULL,6,3,2,7,2,87,NULL,NULL,'per_day',NULL,'','R66T9EHR64T9XPDNM','',8,18,25,'59398 Baker Point',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(24,'Volkswagen Atlas Cross Sport SEL Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/10.jpg\",\"cars\\/85.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-789.33',12,'available',2019,19838,NULL,5,3,3,8,5,42,NULL,NULL,'per_day',NULL,'','11RWMV330ZCV4UG7A','',3,8,15,'87710 Pine Creek',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(25,'Chevrolet Blazer RS AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/80.jpg\",\"cars\\/40.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-789.44',5,'available',2017,12984,NULL,6,1,2,8,5,78,NULL,NULL,'per_day',NULL,'','WTGUTA1663SKM8HEM','',7,17,24,'59125 Bell Gardens',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.europcar.com/en-us/car-rental/vehicles/chevrolet-blazer-rs-awd-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(26,'Ford Explorer ST 4WD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/71.jpg\",\"cars\\/33.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\"]','29A-789.55',9,'available',2015,5774,NULL,8,2,2,4,4,38,NULL,NULL,'per_day',NULL,'','AC8652Z907TM3TU5Y','',1,1,2,'7272 Maple Gardens',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(27,'Jeep Grand Cherokee Summit Reserve 4xe 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/38.jpg\",\"cars\\/21.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\"]','29A-789.66',6,'available',2018,9691,NULL,4,1,3,4,2,58,NULL,NULL,'per_day',NULL,'','YZMGG2063H9RYLRWA','',1,1,3,'53734 Wright Hills',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(28,'Cadillac XT5 Premium Luxury AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/16.jpg\",\"cars\\/77.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\"]','29A-789.77',2,'available',2015,16653,NULL,2,3,3,8,4,94,NULL,NULL,'per_day',NULL,'','HSF7R8NW3FNM2099P','',6,15,22,'44999 Jones Avenue Unit 572',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(29,'Lincoln Aviator Reserve AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/60.jpg\",\"cars\\/102.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\"]','29A-789.88',11,'available',2022,6123,NULL,4,2,2,7,4,72,NULL,NULL,'per_day',NULL,'','2DRKU5H22BSC36W04','',8,19,26,'95260 Mitchell Valley',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(30,'Alfa Romeo Stelvio Veloce AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/84.jpg\",\"cars\\/58.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\"]','29A-789.99',10,'available',2021,6300,NULL,7,2,2,7,4,63,NULL,NULL,'per_day',NULL,'','UMALJ9UF2CW2J9CVZ','',1,3,6,'6038 River Ridge',NULL,0,1,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=alfa-romeo-stelvio-veloce-awd-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(31,'McLaren 720S Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/99.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\"]','30B-100.00',4,'available',2020,5074,NULL,3,1,1,5,5,63,NULL,NULL,'per_day',NULL,'','PXVW47GX03NGEN0V8','',5,12,19,'59979 Clark Road',NULL,1,1,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=mclaren-720s-spider-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(32,'Mercedes-Benz G550 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/53.jpg\",\"cars\\/24.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\"]','30B-100.11',12,'available',2022,8099,NULL,3,1,3,4,2,55,NULL,NULL,'per_day',NULL,'','VFLTP43X201D8P4V8','',2,7,13,'25971 Bell Lane # 766',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/mercedes-benz-g550-4matic-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(33,'Ford Mustang GT Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/22.jpg\",\"cars\\/1.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30B-100.22',4,'available',2023,2963,NULL,1,3,1,4,2,35,NULL,NULL,'per_day',NULL,'','7P4F8JL75RAWU4REC','',1,2,5,'38067 White Trail',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(34,'Porsche 911 Carrera S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/19.jpg\",\"cars\\/15.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\"]','30B-100.33',7,'available',2015,9323,NULL,3,3,1,5,2,32,NULL,NULL,'per_day',NULL,'','RBJZX5LM223MG20FL','',2,7,13,'99517 Hall Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=porsche-911-carrera-s-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(35,'Audi R8 V10 Performance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/45.jpg\",\"cars\\/74.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','30B-100.44',2,'available',2021,2347,NULL,4,1,3,7,5,84,NULL,NULL,'per_day',NULL,'','9XPUHUU8457ERSM5X','',1,3,7,'51249 Pine Valley Unit 103',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(36,'Lamborghini Huracán EVO 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/85.jpg\",\"cars\\/7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\"]','30B-100.55',5,'available',2017,19534,NULL,8,2,2,4,5,53,NULL,NULL,'per_day',NULL,'','D1UHWTWA77YZWTSFW','',7,16,23,'79876 Phillips Highway Apt 110',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(37,'BMW M4 Competition xDrive 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/31.jpg\",\"cars\\/22.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30B-100.66',2,'available',2024,7680,NULL,1,1,1,7,5,79,NULL,NULL,'per_day',NULL,'','6P8HCCA065PKLDPTK','',4,10,17,'95872 Baker Meadows',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(38,'Maserati Ghibli Modena 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/20.jpg\",\"cars\\/100.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','30B-100.77',14,'available',2014,4606,NULL,6,3,2,7,2,35,NULL,NULL,'per_day',NULL,'','77BU5W4E9BKTWYBT7','',2,7,13,'94994 Perry Street Floor 835',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=maserati-ghibli-modena-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(39,'Bentley Continental GT V8 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/12.jpg\",\"cars\\/81.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30B-100.88',11,'available',2019,11994,NULL,5,3,1,7,5,45,NULL,NULL,'per_day',NULL,'','UUJBRBR60WSY5V3LS','',3,8,14,'74797 Cherry Grove Suite 846',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/bentley-continental-gt-v8-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(40,'Rolls-Royce Ghost Black Badge 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/15.jpg\",\"cars\\/14.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\"]','30B-100.99',10,'available',2022,7586,NULL,7,3,2,4,4,96,NULL,NULL,'per_day',NULL,'','V0HC9EAY77J0W9EZC','',1,2,4,'86924 Peterson Meadows Suite 228',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=rolls-royce-ghost-black-badge-2024','2025-11-17 21:14:19','2025-11-17 21:14:19',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(41,'Hyundai Tucson Limited AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/25.jpg\",\"cars\\/7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','29B-200.00',3,'available',2010,19578,NULL,1,1,3,8,4,72,NULL,NULL,'per_day',NULL,'','17CBEKC96SEL6S7KU','',4,10,17,'85067 Campbell Place',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(42,'Kia Sportage SX-Turbo AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/81.jpg\",\"cars\\/99.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\"]','29B-200.11',7,'available',2017,3121,NULL,1,1,1,4,2,48,NULL,NULL,'per_day',NULL,'','RG1G57AS07M6JELJ4','',5,12,19,'99969 Green Place',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(43,'Volkswagen Tiguan SEL R-Line 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/44.jpg\",\"cars\\/73.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\"]','29B-200.22',8,'available',2024,8429,NULL,1,3,3,7,2,43,NULL,NULL,'per_day',NULL,'','10E1XMJF7S4ZGNSPB','',1,5,10,'97232 Brooks Way Floor 56',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(44,'Toyota Highlander Platinum AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/7.jpg\",\"cars\\/4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','29B-200.33',14,'available',2019,1818,NULL,2,1,2,4,5,49,NULL,NULL,'per_day',NULL,'','6GE95NVU0V6WJ77C6','',1,4,8,'66500 Wilson Place # 540',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:19','2025-11-17 21:14:19',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(45,'Honda Pilot TrailSport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/45.jpg\",\"cars\\/89.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\"]','29B-200.44',9,'available',2010,12974,NULL,3,1,2,4,4,51,NULL,NULL,'per_day',NULL,'','GWZ6D9UE8YZTCPZC4','',6,14,21,'90008 Wright Highway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(46,'Mazda MX-5 Miata Grand Touring 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/73.jpg\",\"cars\\/44.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','29B-200.55',8,'available',2010,1122,NULL,1,3,3,8,4,74,NULL,NULL,'per_day',NULL,'','DMYLHK978S3GXJWW5','',4,10,17,'54075 Roberts Court',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(47,'Nissan Rogue Platinum AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/94.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','29B-200.66',10,'available',2011,6083,NULL,3,3,1,5,2,70,NULL,NULL,'per_day',NULL,'','NSXF60CD3461XJTSD','',6,14,21,'14098 Edwards Gardens',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(48,'Mini Cooper S Hardtop 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/84.jpg\",\"cars\\/67.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\"]','29B-200.77',2,'available',2018,14575,NULL,7,2,1,7,2,74,NULL,NULL,'per_day',NULL,'','56EA44K51J12K729K','',2,6,12,'20517 Young Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(49,'Dodge Challenger R/T Scat Pack 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/90.jpg\",\"cars\\/13.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\"]','29B-200.88',5,'available',2017,2964,NULL,3,2,1,4,2,40,NULL,NULL,'per_day',NULL,'','LHNCGG3C828L5ANAG','',2,6,11,'8503 Jackson Highway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=dodge-challenger-r/t-scat-pack-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(50,'Chevrolet Camaro SS 1LE 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/93.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-8.jpg\"]','29B-200.99',5,'available',2013,14592,NULL,2,2,1,7,5,55,NULL,NULL,'per_day',NULL,'','WMYKLPAY094G53XL3','',7,17,24,'94996 Murphy Street # 912',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/chevrolet-camaro-ss-1le-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(51,'Ferrari F8 Tributo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/35.jpg\",\"cars\\/79.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.00',4,'available',2024,7804,NULL,4,1,1,7,2,82,NULL,NULL,'per_day',NULL,'','NYZYAWG31N1HXHULN','',1,1,2,'54786 Foster Avenue',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(52,'Jaguar F-PACE SVR 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/65.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.11',4,'available',2013,1441,NULL,7,3,3,4,2,84,NULL,NULL,'per_day',NULL,'','T1AXW6GV7547GP627','',8,18,25,'3418 Clark Road',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(53,'Land Rover Defender 110 X 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/98.jpg\",\"cars\\/85.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\"]','30C-300.22',10,'available',2021,7670,NULL,8,3,3,5,4,48,NULL,NULL,'per_day',NULL,'','RXV8ACAN0CZUVBTZ6','',3,8,15,'71682 Rogers Heights',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(54,'Chrysler Pacifica Pinnacle AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/57.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.33',10,'available',2021,19710,NULL,6,2,3,4,4,34,NULL,NULL,'per_day',NULL,'','ML1DKEM45VWGCEJ27','',2,7,13,'53779 James Meadows',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.expedia.com/carsearch?vehicle=chrysler-pacifica-pinnacle-awd-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(55,'GMC Sierra 1500 Denali 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/6.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.44',8,'available',2020,8907,NULL,2,1,3,4,5,89,NULL,NULL,'per_day',NULL,'','ES0F7M651FWC1NSA9','',5,12,19,'5042 Diaz Place',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(56,'Mitsubishi Outlander SEL S-AWC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/12.jpg\",\"cars\\/52.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30C-300.55',6,'available',2010,1666,NULL,4,1,1,7,4,56,NULL,NULL,'per_day',NULL,'','JF71936G73TG8G22H','',2,6,11,'46654 Butler Cliffs Suite 56',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(57,'Peugeot 308 GT Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/67.jpg\",\"cars\\/59.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','30C-300.66',8,'available',2021,10900,NULL,3,3,1,5,4,74,NULL,NULL,'per_day',NULL,'','9DD19WPU0TTVWRENH','',1,1,3,'48353 Taylor Lane',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(58,'Fiat 500X Sport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/59.jpg\",\"cars\\/73.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\"]','30C-300.77',13,'available',2011,14280,NULL,2,3,3,7,4,76,NULL,NULL,'per_day',NULL,'','YHRXE91V7HVD706A5','',1,4,8,'73857 Clark Road # 360',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(59,'Smart EQ fortwo Prime 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/77.jpg\",\"cars\\/31.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\"]','30C-300.88',1,'available',2016,1998,NULL,7,2,1,5,2,55,NULL,NULL,'per_day',NULL,'','8Z894DJX9E81A4Y9K','',8,19,26,'47952 Smith Walk',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(60,'Toyota Corolla Hybrid LE 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/43.jpg\",\"cars\\/74.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.99',14,'available',2020,3327,NULL,1,2,3,5,2,92,NULL,NULL,'per_day',NULL,'','9M9YAH2C05C6L9PH3','',1,2,5,'73802 Lincoln Creek Floor 875',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(61,'Aston Martin Vantage F1 Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/25.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\"]','30D-400.00',13,'available',2020,10675,NULL,1,1,1,5,5,55,NULL,NULL,'per_day',NULL,'','XSB5Z6YG6NTF2DE64','',2,6,11,'58426 Russell Valley',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(62,'Bugatti Chiron Super Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/61.jpg\",\"cars\\/28.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\"]','30D-400.11',3,'available',2022,6801,NULL,3,1,2,8,4,54,NULL,NULL,'per_day',NULL,'','KGGT686X0DXM70RJ5','',1,5,10,'75650 Sanders Gardens Suite 452',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(63,'McLaren Artura Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/85.jpg\",\"cars\\/76.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\"]','30D-400.22',9,'available',2014,19666,NULL,8,1,2,7,5,98,NULL,NULL,'per_day',NULL,'','GEKXXMDT4A88K66MX','',3,8,15,'21034 Edwards Heights',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(64,'Pagani Huayra Roadster BC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/96.jpg\",\"cars\\/7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\"]','30D-400.33',7,'available',2013,18414,NULL,5,1,3,5,5,75,NULL,NULL,'per_day',NULL,'','G9GJ9CFE95Y3PE713','',7,17,24,'31348 Thomas Boulevard # 13',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(65,'Koenigsegg Jesko Absolut 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/49.jpg\",\"cars\\/46.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\"]','30D-400.44',4,'available',2021,7890,NULL,1,1,1,8,2,85,NULL,NULL,'per_day',NULL,'','YA9AN9MB2Z3N0803V','',8,19,26,'99885 Taylor Walk # 154',NULL,1,1,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=koenigsegg-jesko-absolut-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(66,'Mercedes-Benz E450 4MATIC All-Terrain 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/72.jpg\",\"cars\\/61.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\"]','30E-500.00',13,'available',2012,17060,NULL,1,3,1,5,2,76,NULL,NULL,'per_day',NULL,'','ZX4D1YRF73CDCG16D','',5,13,20,'57607 Collins Cliffs Unit 994',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(67,'Audi Q7 55 TFSI quattro Premium Plus 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/51.jpg\",\"cars\\/85.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.11',5,'available',2016,7691,NULL,2,3,3,7,2,94,NULL,NULL,'per_day',NULL,'','YRS47VAW2YB547MAG','',6,14,21,'34325 Main Circle Unit 150',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(68,'BMW X7 xDrive40i M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/40.jpg\",\"cars\\/8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\"]','30E-500.22',4,'available',2015,13122,NULL,2,3,3,8,2,33,NULL,NULL,'per_day',NULL,'','P5NTYL0499YDKN3ZJ','',3,8,15,'82970 Powell Highway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(69,'Lexus LX 600 Ultra Luxury 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/22.jpg\",\"cars\\/45.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.33',4,'available',2010,14770,NULL,5,1,2,4,2,43,NULL,NULL,'per_day',NULL,'','6NMPVCGC84VE5RDWX','',2,6,11,'35830 Butler Road Suite 617',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(70,'Volvo S90 B6 Ultimate AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/65.jpg\",\"cars\\/69.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.44',14,'available',2021,1326,NULL,2,3,1,7,5,72,NULL,NULL,'per_day',NULL,'','0S29C4ZT1E1KEZJAT','',6,14,21,'22836 Green Grove Floor 778',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(71,'Genesis GV70 2.5T Sport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/5.jpg\",\"cars\\/5.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.55',2,'available',2023,3595,NULL,4,1,2,8,2,92,NULL,NULL,'per_day',NULL,'','3CKSC75K76AYSCDZT','',1,2,4,'47579 Lincoln Drive',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(72,'Acura TLX Type S PMC Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/35.jpg\",\"cars\\/6.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\"]','30E-500.66',8,'available',2019,15243,NULL,3,3,1,8,5,97,NULL,NULL,'per_day',NULL,'','UYSBW4LE766HCN84N','',8,18,25,'20286 Cedar Parkway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(73,'Infiniti Q50 Red Sport 400 AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/2.jpg\",\"cars\\/64.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','30E-500.77',1,'available',2011,15542,NULL,4,3,2,8,4,69,NULL,NULL,'per_day',NULL,'','L4K4WCER6MAS5E9CG','',2,7,13,'38042 Cruz Gardens',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=infiniti-q50-red-sport-400-awd-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(74,'Jaguar XF P300 R-Dynamic S AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/9.jpg\",\"cars\\/98.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.88',4,'available',2011,10209,NULL,5,3,1,5,4,84,NULL,NULL,'per_day',NULL,'','XB15MCC46E2CLJEMY','',3,8,15,'32362 Hill Trail',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(75,'Alfa Romeo Giulia Quadrifoglio 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/21.jpg\",\"cars\\/95.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\"]','30E-500.99',4,'available',2012,14511,NULL,7,2,3,8,4,75,NULL,NULL,'per_day',NULL,'','N6HFBE6E2XGWK9FV5','',4,10,17,'99937 Barnes Highway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.sixt.com/rental-car/usa/vehicle/alfa-romeo-giulia-quadrifoglio-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(76,'Porsche Cayenne Turbo GT 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/80.jpg\",\"cars\\/47.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\"]','29E-600.00',13,'available',2021,5375,NULL,4,1,3,7,2,51,NULL,NULL,'per_day',NULL,'','ZYPWLFZ26MY5FYKCU','',2,6,12,'67883 Main Ridge',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(77,'Range Rover Sport HSE Dynamic 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/27.jpg\",\"cars\\/31.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\"]','29E-600.11',10,'available',2019,17347,NULL,3,2,3,4,4,36,NULL,NULL,'per_day',NULL,'','JUYEEV1P2BUG4WH34','',1,2,5,'79368 Rogers Lane',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(78,'Mercedes-AMG GLE 63 S 4MATIC+ 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/54.jpg\",\"cars\\/47.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\"]','29E-600.22',1,'available',2021,15051,NULL,7,2,1,5,5,50,NULL,NULL,'per_day',NULL,'','VYVD4HZU3WP5NSS87','',8,19,26,'78666 Murphy Street # 756',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(79,'BMW M5 Competition xDrive 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/76.jpg\",\"cars\\/70.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\"]','29E-600.33',12,'available',2015,11067,NULL,1,3,2,4,5,47,NULL,NULL,'per_day',NULL,'','0CVL3900584M6LL1S','',7,16,23,'66900 Adams Park',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(80,'Audi RS Q8 quattro 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/43.jpg\",\"cars\\/28.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\"]','29E-600.44',6,'available',2019,12355,NULL,2,1,3,5,5,75,NULL,NULL,'per_day',NULL,'','SMRMM3A45Z73SFHSP','',3,9,16,'32354 Russell View',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(81,'Tesla Model S Plaid 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/59.jpg\",\"cars\\/95.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\"]','29E-600.55',4,'available',2015,6194,NULL,8,2,2,4,2,45,NULL,NULL,'per_day',NULL,'','UPNUV2F80J5XZ9BN3','',3,9,16,'76226 Bailey Point',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(82,'Lucid Air Grand Touring Performance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/98.jpg\",\"cars\\/58.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\"]','29E-600.66',7,'available',2019,17628,NULL,3,2,1,4,4,66,NULL,NULL,'per_day',NULL,'','T9VMPF734B9WE06CM','',1,3,6,'83096 Cherry Avenue',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(83,'Rivian R1S Adventure 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/45.jpg\",\"cars\\/61.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\"]','29E-600.77',5,'available',2024,15072,NULL,8,2,2,7,4,73,NULL,NULL,'per_day',NULL,'','V1J6FSF3391FA80D9','',2,6,11,'26861 Fisher Meadows',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(84,'Polestar 2 Long Range Dual Motor 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/86.jpg\",\"cars\\/27.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\"]','29E-600.88',14,'available',2017,15048,NULL,8,2,1,5,5,42,NULL,NULL,'per_day',NULL,'','C93ZD0TA08J26ZRSB','',3,8,15,'49983 Russell Parkway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(85,'Genesis Electrified GV70 Advanced AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/84.jpg\",\"cars\\/19.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-3.jpg\"]','29E-600.99',2,'available',2019,5223,NULL,6,2,2,8,2,64,NULL,NULL,'per_day',NULL,'','JW9GP10R0HXYRFNMK','',8,19,26,'17545 Jenkins Terrace Suite 296',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(86,'Mercedes-Maybach S 580 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/33.jpg\",\"cars\\/76.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.00',10,'available',2010,14265,NULL,1,1,3,7,5,62,NULL,NULL,'per_day',NULL,'','K09PKXG59141H80KM','',3,8,14,'38845 Cooper Parkway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(87,'Bentley Bentayga S V8 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/71.jpg\",\"cars\\/43.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','30F-700.11',4,'available',2022,1766,NULL,5,2,2,5,5,99,NULL,NULL,'per_day',NULL,'','XPN13EFS6JKHFPBT5','',5,13,20,'35585 Jones Pass',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=bentley-bentayga-s-v8-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(88,'Rolls-Royce Cullinan Black Badge 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/1.jpg\",\"cars\\/13.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\"]','30F-700.22',7,'available',2017,12917,NULL,7,2,1,5,4,56,NULL,NULL,'per_day',NULL,'','LYDCMSMF1CNDKBD8F','',8,19,26,'57660 Anderson Point Floor 500',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(89,'Aston Martin DBX707 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/5.jpg\",\"cars\\/79.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\"]','30F-700.33',5,'available',2023,7371,NULL,2,2,3,8,2,93,NULL,NULL,'per_day',NULL,'','M27TXM2898BHR9W2C','',6,15,22,'73651 Young Ridge',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(90,'Maserati Levante Trofeo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/94.jpg\",\"cars\\/66.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\"]','30F-700.44',2,'available',2015,5542,NULL,4,3,3,5,5,62,NULL,NULL,'per_day',NULL,'','3FH2NSWG3LPPMG4DC','',1,1,3,'44473 Ortiz Meadows',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(91,'Ferrari Roma Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/76.jpg\",\"cars\\/92.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\"]','30F-700.55',8,'available',2024,9982,NULL,2,3,1,5,4,45,NULL,NULL,'per_day',NULL,'','HALNFHHN479BTSCDY','',1,1,3,'78709 Evans Grove',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',7,'Botble\\CarRentals\\Models\\Customer',7,'approved',NULL),(92,'McLaren GT Luxe 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/103.jpg\",\"cars\\/65.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.66',7,'available',2022,1677,NULL,1,2,3,8,5,51,NULL,NULL,'per_day',NULL,'','G544NB993JLGG14SW','',1,1,2,'33196 Morales Creek Unit 974',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(93,'Lamborghini Urus Performante 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/104.jpg\",\"cars\\/105.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','30F-700.77',7,'available',2021,1504,NULL,8,1,3,5,2,88,NULL,NULL,'per_day',NULL,'','SW8C5P0S42EBXC4RT','',4,10,17,'28013 Thomas Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(94,'Porsche Taycan Turbo S Cross Turismo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/74.jpg\",\"cars\\/101.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\"]','30F-700.88',7,'available',2012,13715,NULL,7,2,3,8,2,96,NULL,NULL,'per_day',NULL,'','LZNPE4HE00WTG4BC0','',1,1,1,'90133 Elm Circle',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(95,'BMW XM Label Red 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/8.jpg\",\"cars\\/22.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\"]','30F-700.99',11,'available',2016,12853,NULL,6,2,1,8,2,66,NULL,NULL,'per_day',NULL,'','LHST6EEP1TBC1FCMA','',6,14,21,'60090 Davis Walk',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(96,'Chevrolet Corvette Z06 3LZ 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/29.jpg\",\"cars\\/70.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\"]','29F-800.00',8,'available',2022,2142,NULL,8,1,3,8,4,70,NULL,NULL,'per_day',NULL,'','RWP0LAFD2TH1GRYBP','',1,2,5,'6536 Cherry Way',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=chevrolet-corvette-z06-3lz-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(97,'Ford GT Heritage Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/48.jpg\",\"cars\\/75.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\"]','29F-800.11',5,'available',2012,4960,NULL,3,2,3,5,5,49,NULL,NULL,'per_day',NULL,'','PVCLUXEE57L9E8S89','',3,8,14,'65507 Mountain Circle Unit 393',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(98,'Dodge Viper ACR Extreme 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/41.jpg\",\"cars\\/70.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\"]','29F-800.22',8,'available',2024,8173,NULL,3,1,1,4,2,75,NULL,NULL,'per_day',NULL,'','T8Y238S16FVMCBA86','',8,18,25,'92494 Cox Street Floor 288',NULL,0,1,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/dodge-viper-acr-extreme-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(99,'Nissan GT-R NISMO Special Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/96.jpg\",\"cars\\/38.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','29F-800.33',6,'available',2011,13673,NULL,2,2,2,4,5,69,NULL,NULL,'per_day',NULL,'','43F4455165DWAG5SN','',1,3,6,'3875 Adams Valley',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:14:20','2025-11-17 21:14:20',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(100,'Toyota Supra 3.0 Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/87.jpg\",\"cars\\/28.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\"]','29F-800.44',12,'available',2014,10288,NULL,5,1,1,8,4,38,NULL,NULL,'per_day',NULL,'','3FSXF5MH3JNWKFCU0','',8,19,26,'29617 Phillips Ridge Apt 972',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=toyota-supra-3.0-premium-2024','2025-11-17 21:14:20','2025-11-17 21:14:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL);
/*!40000 ALTER TABLE `cr_cars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_amenities`
--

DROP TABLE IF EXISTS `cr_cars_amenities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_amenities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_id` bigint unsigned NOT NULL,
  `cr_car_amenity_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1585 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_amenities`
--

LOCK TABLES `cr_cars_amenities` WRITE;
/*!40000 ALTER TABLE `cr_cars_amenities` DISABLE KEYS */;
INSERT INTO `cr_cars_amenities` VALUES (1,1,13,NULL,NULL),(2,1,14,NULL,NULL),(3,1,45,NULL,NULL),(4,1,1,NULL,NULL),(5,1,2,NULL,NULL),(6,1,6,NULL,NULL),(7,1,8,NULL,NULL),(8,1,19,NULL,NULL),(9,1,11,NULL,NULL),(10,1,15,NULL,NULL),(11,1,18,NULL,NULL),(12,1,28,NULL,NULL),(13,1,29,NULL,NULL),(14,1,32,NULL,NULL),(15,1,34,NULL,NULL),(16,1,27,NULL,NULL),(17,1,33,NULL,NULL),(18,2,14,NULL,NULL),(19,2,23,NULL,NULL),(20,2,46,NULL,NULL),(21,2,47,NULL,NULL),(22,2,1,NULL,NULL),(23,2,2,NULL,NULL),(24,2,4,NULL,NULL),(25,2,6,NULL,NULL),(26,2,12,NULL,NULL),(27,2,17,NULL,NULL),(28,2,18,NULL,NULL),(29,2,28,NULL,NULL),(30,2,29,NULL,NULL),(31,2,31,NULL,NULL),(32,2,34,NULL,NULL),(33,2,5,NULL,NULL),(34,2,9,NULL,NULL),(35,2,25,NULL,NULL),(36,2,41,NULL,NULL),(37,2,42,NULL,NULL),(38,3,13,NULL,NULL),(39,3,14,NULL,NULL),(40,3,45,NULL,NULL),(41,3,46,NULL,NULL),(42,3,47,NULL,NULL),(43,3,2,NULL,NULL),(44,3,6,NULL,NULL),(45,3,19,NULL,NULL),(46,3,11,NULL,NULL),(47,3,15,NULL,NULL),(48,3,17,NULL,NULL),(49,3,28,NULL,NULL),(50,3,30,NULL,NULL),(51,3,32,NULL,NULL),(52,3,35,NULL,NULL),(53,3,21,NULL,NULL),(54,3,27,NULL,NULL),(55,4,13,NULL,NULL),(56,4,22,NULL,NULL),(57,4,23,NULL,NULL),(58,4,45,NULL,NULL),(59,4,1,NULL,NULL),(60,4,2,NULL,NULL),(61,4,6,NULL,NULL),(62,4,19,NULL,NULL),(63,4,7,NULL,NULL),(64,4,11,NULL,NULL),(65,4,18,NULL,NULL),(66,4,34,NULL,NULL),(67,4,39,NULL,NULL),(68,4,40,NULL,NULL),(69,4,42,NULL,NULL),(70,5,13,NULL,NULL),(71,5,22,NULL,NULL),(72,5,23,NULL,NULL),(73,5,1,NULL,NULL),(74,5,4,NULL,NULL),(75,5,11,NULL,NULL),(76,5,12,NULL,NULL),(77,5,15,NULL,NULL),(78,5,18,NULL,NULL),(79,5,30,NULL,NULL),(80,5,34,NULL,NULL),(81,5,39,NULL,NULL),(82,5,41,NULL,NULL),(83,5,43,NULL,NULL),(84,6,13,NULL,NULL),(85,6,14,NULL,NULL),(86,6,47,NULL,NULL),(87,6,3,NULL,NULL),(88,6,25,NULL,NULL),(89,6,27,NULL,NULL),(90,6,33,NULL,NULL),(91,6,11,NULL,NULL),(92,6,12,NULL,NULL),(93,6,15,NULL,NULL),(94,6,17,NULL,NULL),(95,6,18,NULL,NULL),(96,6,28,NULL,NULL),(97,6,29,NULL,NULL),(98,6,32,NULL,NULL),(99,6,34,NULL,NULL),(100,6,35,NULL,NULL),(101,6,40,NULL,NULL),(102,6,41,NULL,NULL),(103,7,13,NULL,NULL),(104,7,14,NULL,NULL),(105,7,23,NULL,NULL),(106,7,45,NULL,NULL),(107,7,46,NULL,NULL),(108,7,4,NULL,NULL),(109,7,6,NULL,NULL),(110,7,8,NULL,NULL),(111,7,7,NULL,NULL),(112,7,11,NULL,NULL),(113,7,15,NULL,NULL),(114,7,16,NULL,NULL),(115,7,18,NULL,NULL),(116,7,28,NULL,NULL),(117,7,31,NULL,NULL),(118,7,34,NULL,NULL),(119,7,5,NULL,NULL),(120,7,20,NULL,NULL),(121,7,25,NULL,NULL),(122,8,14,NULL,NULL),(123,8,22,NULL,NULL),(124,8,46,NULL,NULL),(125,8,1,NULL,NULL),(126,8,4,NULL,NULL),(127,8,19,NULL,NULL),(128,8,12,NULL,NULL),(129,8,17,NULL,NULL),(130,8,18,NULL,NULL),(131,8,29,NULL,NULL),(132,8,30,NULL,NULL),(133,8,32,NULL,NULL),(134,8,35,NULL,NULL),(135,8,3,NULL,NULL),(136,8,20,NULL,NULL),(137,8,21,NULL,NULL),(138,8,38,NULL,NULL),(139,8,41,NULL,NULL),(140,9,14,NULL,NULL),(141,9,22,NULL,NULL),(142,9,23,NULL,NULL),(143,9,46,NULL,NULL),(144,9,47,NULL,NULL),(145,9,8,NULL,NULL),(146,9,19,NULL,NULL),(147,9,10,NULL,NULL),(148,10,14,NULL,NULL),(149,10,22,NULL,NULL),(150,10,45,NULL,NULL),(151,10,47,NULL,NULL),(152,10,2,NULL,NULL),(153,10,8,NULL,NULL),(154,10,10,NULL,NULL),(155,10,11,NULL,NULL),(156,10,15,NULL,NULL),(157,10,16,NULL,NULL),(158,10,28,NULL,NULL),(159,10,34,NULL,NULL),(160,10,37,NULL,NULL),(161,10,40,NULL,NULL),(162,11,13,NULL,NULL),(163,11,22,NULL,NULL),(164,11,23,NULL,NULL),(165,11,1,NULL,NULL),(166,11,2,NULL,NULL),(167,11,6,NULL,NULL),(168,11,8,NULL,NULL),(169,11,19,NULL,NULL),(170,11,7,NULL,NULL),(171,11,12,NULL,NULL),(172,11,16,NULL,NULL),(173,11,28,NULL,NULL),(174,11,29,NULL,NULL),(175,11,30,NULL,NULL),(176,11,3,NULL,NULL),(177,11,9,NULL,NULL),(178,11,38,NULL,NULL),(179,11,40,NULL,NULL),(180,11,41,NULL,NULL),(181,11,42,NULL,NULL),(182,12,13,NULL,NULL),(183,12,23,NULL,NULL),(184,12,46,NULL,NULL),(185,12,1,NULL,NULL),(186,12,7,NULL,NULL),(187,12,18,NULL,NULL),(188,13,13,NULL,NULL),(189,13,22,NULL,NULL),(190,13,45,NULL,NULL),(191,13,46,NULL,NULL),(192,13,1,NULL,NULL),(193,13,8,NULL,NULL),(194,13,19,NULL,NULL),(195,13,7,NULL,NULL),(196,13,17,NULL,NULL),(197,13,30,NULL,NULL),(198,14,14,NULL,NULL),(199,14,22,NULL,NULL),(200,14,23,NULL,NULL),(201,14,1,NULL,NULL),(202,14,2,NULL,NULL),(203,14,7,NULL,NULL),(204,14,12,NULL,NULL),(205,14,30,NULL,NULL),(206,14,31,NULL,NULL),(207,14,34,NULL,NULL),(208,14,37,NULL,NULL),(209,14,39,NULL,NULL),(210,14,41,NULL,NULL),(211,15,13,NULL,NULL),(212,15,14,NULL,NULL),(213,15,22,NULL,NULL),(214,15,45,NULL,NULL),(215,15,47,NULL,NULL),(216,15,3,NULL,NULL),(217,15,5,NULL,NULL),(218,15,20,NULL,NULL),(219,15,21,NULL,NULL),(220,15,7,NULL,NULL),(221,15,11,NULL,NULL),(222,15,15,NULL,NULL),(223,15,18,NULL,NULL),(224,15,29,NULL,NULL),(225,15,30,NULL,NULL),(226,15,32,NULL,NULL),(227,15,34,NULL,NULL),(228,15,40,NULL,NULL),(229,15,41,NULL,NULL),(230,15,42,NULL,NULL),(231,15,43,NULL,NULL),(232,16,13,NULL,NULL),(233,16,22,NULL,NULL),(234,16,23,NULL,NULL),(235,16,47,NULL,NULL),(236,16,1,NULL,NULL),(237,16,4,NULL,NULL),(238,16,7,NULL,NULL),(239,16,10,NULL,NULL),(240,16,16,NULL,NULL),(241,16,32,NULL,NULL),(242,16,38,NULL,NULL),(243,16,40,NULL,NULL),(244,16,41,NULL,NULL),(245,16,43,NULL,NULL),(246,17,13,NULL,NULL),(247,17,14,NULL,NULL),(248,17,22,NULL,NULL),(249,17,46,NULL,NULL),(250,17,47,NULL,NULL),(251,17,1,NULL,NULL),(252,17,2,NULL,NULL),(253,17,4,NULL,NULL),(254,17,19,NULL,NULL),(255,17,15,NULL,NULL),(256,17,18,NULL,NULL),(257,17,32,NULL,NULL),(258,18,23,NULL,NULL),(259,18,45,NULL,NULL),(260,18,47,NULL,NULL),(261,18,4,NULL,NULL),(262,18,6,NULL,NULL),(263,18,19,NULL,NULL),(264,18,10,NULL,NULL),(265,18,11,NULL,NULL),(266,18,12,NULL,NULL),(267,18,17,NULL,NULL),(268,18,18,NULL,NULL),(269,18,28,NULL,NULL),(270,18,29,NULL,NULL),(271,18,31,NULL,NULL),(272,18,32,NULL,NULL),(273,18,5,NULL,NULL),(274,19,13,NULL,NULL),(275,19,22,NULL,NULL),(276,19,46,NULL,NULL),(277,19,1,NULL,NULL),(278,19,4,NULL,NULL),(279,19,6,NULL,NULL),(280,19,8,NULL,NULL),(281,19,19,NULL,NULL),(282,19,7,NULL,NULL),(283,19,12,NULL,NULL),(284,19,15,NULL,NULL),(285,19,17,NULL,NULL),(286,19,29,NULL,NULL),(287,19,31,NULL,NULL),(288,19,33,NULL,NULL),(289,20,14,NULL,NULL),(290,20,46,NULL,NULL),(291,20,47,NULL,NULL),(292,20,1,NULL,NULL),(293,20,2,NULL,NULL),(294,20,4,NULL,NULL),(295,20,16,NULL,NULL),(296,20,18,NULL,NULL),(297,20,31,NULL,NULL),(298,21,13,NULL,NULL),(299,21,23,NULL,NULL),(300,21,47,NULL,NULL),(301,21,3,NULL,NULL),(302,21,9,NULL,NULL),(303,21,20,NULL,NULL),(304,21,25,NULL,NULL),(305,21,33,NULL,NULL),(306,21,10,NULL,NULL),(307,21,11,NULL,NULL),(308,21,12,NULL,NULL),(309,21,15,NULL,NULL),(310,21,17,NULL,NULL),(311,21,30,NULL,NULL),(312,21,31,NULL,NULL),(313,21,34,NULL,NULL),(314,21,35,NULL,NULL),(315,21,37,NULL,NULL),(316,21,42,NULL,NULL),(317,21,43,NULL,NULL),(318,22,13,NULL,NULL),(319,22,14,NULL,NULL),(320,22,23,NULL,NULL),(321,22,46,NULL,NULL),(322,22,47,NULL,NULL),(323,22,1,NULL,NULL),(324,22,2,NULL,NULL),(325,22,6,NULL,NULL),(326,22,19,NULL,NULL),(327,22,16,NULL,NULL),(328,22,17,NULL,NULL),(329,22,30,NULL,NULL),(330,22,32,NULL,NULL),(331,23,13,NULL,NULL),(332,23,22,NULL,NULL),(333,23,47,NULL,NULL),(334,23,5,NULL,NULL),(335,23,9,NULL,NULL),(336,23,25,NULL,NULL),(337,23,33,NULL,NULL),(338,23,7,NULL,NULL),(339,23,16,NULL,NULL),(340,23,17,NULL,NULL),(341,23,18,NULL,NULL),(342,23,28,NULL,NULL),(343,23,31,NULL,NULL),(344,23,32,NULL,NULL),(345,23,34,NULL,NULL),(346,23,35,NULL,NULL),(347,23,38,NULL,NULL),(348,23,39,NULL,NULL),(349,23,40,NULL,NULL),(350,23,41,NULL,NULL),(351,24,14,NULL,NULL),(352,24,22,NULL,NULL),(353,24,23,NULL,NULL),(354,24,45,NULL,NULL),(355,24,47,NULL,NULL),(356,24,2,NULL,NULL),(357,24,4,NULL,NULL),(358,24,6,NULL,NULL),(359,24,10,NULL,NULL),(360,24,12,NULL,NULL),(361,24,16,NULL,NULL),(362,24,18,NULL,NULL),(363,24,28,NULL,NULL),(364,24,37,NULL,NULL),(365,24,39,NULL,NULL),(366,24,43,NULL,NULL),(367,25,14,NULL,NULL),(368,25,23,NULL,NULL),(369,25,45,NULL,NULL),(370,25,1,NULL,NULL),(371,25,4,NULL,NULL),(372,25,6,NULL,NULL),(373,25,8,NULL,NULL),(374,25,11,NULL,NULL),(375,25,15,NULL,NULL),(376,25,18,NULL,NULL),(377,25,28,NULL,NULL),(378,25,29,NULL,NULL),(379,25,30,NULL,NULL),(380,25,34,NULL,NULL),(381,25,9,NULL,NULL),(382,25,21,NULL,NULL),(383,25,25,NULL,NULL),(384,25,37,NULL,NULL),(385,25,41,NULL,NULL),(386,25,42,NULL,NULL),(387,26,13,NULL,NULL),(388,26,14,NULL,NULL),(389,26,45,NULL,NULL),(390,26,46,NULL,NULL),(391,26,19,NULL,NULL),(392,26,7,NULL,NULL),(393,26,16,NULL,NULL),(394,27,14,NULL,NULL),(395,27,45,NULL,NULL),(396,27,47,NULL,NULL),(397,27,2,NULL,NULL),(398,27,4,NULL,NULL),(399,27,8,NULL,NULL),(400,27,10,NULL,NULL),(401,27,15,NULL,NULL),(402,27,31,NULL,NULL),(403,27,34,NULL,NULL),(404,28,13,NULL,NULL),(405,28,23,NULL,NULL),(406,28,45,NULL,NULL),(407,28,47,NULL,NULL),(408,28,3,NULL,NULL),(409,28,9,NULL,NULL),(410,28,20,NULL,NULL),(411,28,25,NULL,NULL),(412,28,33,NULL,NULL),(413,28,10,NULL,NULL),(414,28,11,NULL,NULL),(415,28,12,NULL,NULL),(416,28,16,NULL,NULL),(417,28,17,NULL,NULL),(418,28,18,NULL,NULL),(419,28,29,NULL,NULL),(420,28,32,NULL,NULL),(421,28,34,NULL,NULL),(422,28,35,NULL,NULL),(423,28,38,NULL,NULL),(424,28,40,NULL,NULL),(425,28,42,NULL,NULL),(426,28,43,NULL,NULL),(427,28,37,NULL,NULL),(428,29,13,NULL,NULL),(429,29,22,NULL,NULL),(430,29,23,NULL,NULL),(431,29,45,NULL,NULL),(432,29,47,NULL,NULL),(433,29,1,NULL,NULL),(434,29,2,NULL,NULL),(435,29,4,NULL,NULL),(436,29,6,NULL,NULL),(437,29,8,NULL,NULL),(438,29,11,NULL,NULL),(439,29,15,NULL,NULL),(440,29,17,NULL,NULL),(441,29,18,NULL,NULL),(442,29,28,NULL,NULL),(443,29,32,NULL,NULL),(444,29,5,NULL,NULL),(445,29,9,NULL,NULL),(446,30,13,NULL,NULL),(447,30,14,NULL,NULL),(448,30,22,NULL,NULL),(449,30,23,NULL,NULL),(450,30,45,NULL,NULL),(451,30,1,NULL,NULL),(452,30,4,NULL,NULL),(453,30,19,NULL,NULL),(454,30,7,NULL,NULL),(455,30,12,NULL,NULL),(456,30,15,NULL,NULL),(457,30,16,NULL,NULL),(458,30,17,NULL,NULL),(459,30,29,NULL,NULL),(460,30,30,NULL,NULL),(461,30,35,NULL,NULL),(462,30,3,NULL,NULL),(463,30,20,NULL,NULL),(464,30,27,NULL,NULL),(465,31,13,NULL,NULL),(466,31,14,NULL,NULL),(467,31,45,NULL,NULL),(468,31,46,NULL,NULL),(469,31,4,NULL,NULL),(470,31,6,NULL,NULL),(471,31,19,NULL,NULL),(472,31,10,NULL,NULL),(473,31,11,NULL,NULL),(474,31,12,NULL,NULL),(475,31,15,NULL,NULL),(476,31,16,NULL,NULL),(477,31,30,NULL,NULL),(478,31,31,NULL,NULL),(479,31,34,NULL,NULL),(480,31,35,NULL,NULL),(481,31,5,NULL,NULL),(482,32,13,NULL,NULL),(483,32,14,NULL,NULL),(484,32,45,NULL,NULL),(485,32,1,NULL,NULL),(486,32,2,NULL,NULL),(487,32,4,NULL,NULL),(488,32,8,NULL,NULL),(489,32,11,NULL,NULL),(490,32,12,NULL,NULL),(491,32,18,NULL,NULL),(492,32,29,NULL,NULL),(493,33,13,NULL,NULL),(494,33,14,NULL,NULL),(495,33,22,NULL,NULL),(496,33,46,NULL,NULL),(497,33,1,NULL,NULL),(498,33,10,NULL,NULL),(499,33,39,NULL,NULL),(500,33,40,NULL,NULL),(501,33,41,NULL,NULL),(502,34,22,NULL,NULL),(503,34,23,NULL,NULL),(504,34,46,NULL,NULL),(505,34,47,NULL,NULL),(506,34,2,NULL,NULL),(507,34,8,NULL,NULL),(508,34,7,NULL,NULL),(509,34,17,NULL,NULL),(510,34,37,NULL,NULL),(511,34,38,NULL,NULL),(512,34,41,NULL,NULL),(513,34,42,NULL,NULL),(514,35,13,NULL,NULL),(515,35,22,NULL,NULL),(516,35,45,NULL,NULL),(517,35,47,NULL,NULL),(518,35,3,NULL,NULL),(519,35,5,NULL,NULL),(520,35,9,NULL,NULL),(521,35,21,NULL,NULL),(522,35,25,NULL,NULL),(523,35,33,NULL,NULL),(524,35,7,NULL,NULL),(525,35,10,NULL,NULL),(526,35,15,NULL,NULL),(527,35,17,NULL,NULL),(528,35,18,NULL,NULL),(529,35,28,NULL,NULL),(530,35,30,NULL,NULL),(531,35,31,NULL,NULL),(532,35,32,NULL,NULL),(533,35,35,NULL,NULL),(534,35,38,NULL,NULL),(535,35,39,NULL,NULL),(536,36,14,NULL,NULL),(537,36,22,NULL,NULL),(538,36,23,NULL,NULL),(539,36,45,NULL,NULL),(540,36,46,NULL,NULL),(541,36,6,NULL,NULL),(542,36,19,NULL,NULL),(543,36,11,NULL,NULL),(544,36,16,NULL,NULL),(545,36,17,NULL,NULL),(546,36,18,NULL,NULL),(547,36,34,NULL,NULL),(548,37,13,NULL,NULL),(549,37,22,NULL,NULL),(550,37,23,NULL,NULL),(551,37,2,NULL,NULL),(552,37,4,NULL,NULL),(553,37,6,NULL,NULL),(554,37,19,NULL,NULL),(555,37,7,NULL,NULL),(556,37,10,NULL,NULL),(557,37,11,NULL,NULL),(558,37,15,NULL,NULL),(559,37,16,NULL,NULL),(560,37,29,NULL,NULL),(561,37,30,NULL,NULL),(562,37,35,NULL,NULL),(563,37,5,NULL,NULL),(564,37,20,NULL,NULL),(565,38,13,NULL,NULL),(566,38,46,NULL,NULL),(567,38,47,NULL,NULL),(568,38,2,NULL,NULL),(569,38,18,NULL,NULL),(570,39,13,NULL,NULL),(571,39,22,NULL,NULL),(572,39,45,NULL,NULL),(573,39,46,NULL,NULL),(574,39,47,NULL,NULL),(575,39,2,NULL,NULL),(576,39,4,NULL,NULL),(577,39,8,NULL,NULL),(578,39,19,NULL,NULL),(579,39,16,NULL,NULL),(580,39,17,NULL,NULL),(581,39,18,NULL,NULL),(582,39,28,NULL,NULL),(583,39,29,NULL,NULL),(584,39,37,NULL,NULL),(585,39,39,NULL,NULL),(586,39,42,NULL,NULL),(587,39,43,NULL,NULL),(588,40,22,NULL,NULL),(589,40,45,NULL,NULL),(590,40,46,NULL,NULL),(591,40,47,NULL,NULL),(592,40,5,NULL,NULL),(593,40,20,NULL,NULL),(594,40,27,NULL,NULL),(595,40,33,NULL,NULL),(596,40,11,NULL,NULL),(597,40,12,NULL,NULL),(598,40,15,NULL,NULL),(599,40,16,NULL,NULL),(600,40,17,NULL,NULL),(601,40,28,NULL,NULL),(602,40,29,NULL,NULL),(603,40,32,NULL,NULL),(604,40,35,NULL,NULL),(605,40,38,NULL,NULL),(606,40,39,NULL,NULL),(607,40,43,NULL,NULL),(608,41,13,NULL,NULL),(609,41,22,NULL,NULL),(610,41,23,NULL,NULL),(611,41,45,NULL,NULL),(612,41,46,NULL,NULL),(613,41,1,NULL,NULL),(614,41,2,NULL,NULL),(615,41,4,NULL,NULL),(616,41,6,NULL,NULL),(617,41,8,NULL,NULL),(618,41,11,NULL,NULL),(619,41,12,NULL,NULL),(620,41,17,NULL,NULL),(621,41,28,NULL,NULL),(622,41,32,NULL,NULL),(623,41,21,NULL,NULL),(624,41,33,NULL,NULL),(625,42,13,NULL,NULL),(626,42,22,NULL,NULL),(627,42,23,NULL,NULL),(628,42,47,NULL,NULL),(629,42,1,NULL,NULL),(630,42,6,NULL,NULL),(631,42,19,NULL,NULL),(632,42,7,NULL,NULL),(633,42,11,NULL,NULL),(634,42,12,NULL,NULL),(635,42,17,NULL,NULL),(636,42,32,NULL,NULL),(637,42,37,NULL,NULL),(638,42,39,NULL,NULL),(639,42,42,NULL,NULL),(640,42,43,NULL,NULL),(641,43,14,NULL,NULL),(642,43,22,NULL,NULL),(643,43,23,NULL,NULL),(644,43,1,NULL,NULL),(645,43,4,NULL,NULL),(646,43,19,NULL,NULL),(647,43,12,NULL,NULL),(648,43,15,NULL,NULL),(649,43,17,NULL,NULL),(650,43,31,NULL,NULL),(651,43,32,NULL,NULL),(652,44,14,NULL,NULL),(653,44,23,NULL,NULL),(654,44,45,NULL,NULL),(655,44,46,NULL,NULL),(656,44,1,NULL,NULL),(657,44,4,NULL,NULL),(658,44,8,NULL,NULL),(659,44,10,NULL,NULL),(660,44,16,NULL,NULL),(661,44,17,NULL,NULL),(662,44,28,NULL,NULL),(663,44,35,NULL,NULL),(664,44,38,NULL,NULL),(665,44,39,NULL,NULL),(666,44,40,NULL,NULL),(667,44,43,NULL,NULL),(668,45,14,NULL,NULL),(669,45,45,NULL,NULL),(670,45,46,NULL,NULL),(671,45,1,NULL,NULL),(672,45,6,NULL,NULL),(673,45,19,NULL,NULL),(674,45,7,NULL,NULL),(675,45,12,NULL,NULL),(676,45,28,NULL,NULL),(677,45,29,NULL,NULL),(678,45,38,NULL,NULL),(679,45,41,NULL,NULL),(680,46,22,NULL,NULL),(681,46,23,NULL,NULL),(682,46,45,NULL,NULL),(683,46,46,NULL,NULL),(684,46,47,NULL,NULL),(685,46,1,NULL,NULL),(686,46,2,NULL,NULL),(687,46,8,NULL,NULL),(688,46,19,NULL,NULL),(689,46,10,NULL,NULL),(690,46,11,NULL,NULL),(691,46,15,NULL,NULL),(692,46,32,NULL,NULL),(693,46,34,NULL,NULL),(694,46,25,NULL,NULL),(695,46,33,NULL,NULL),(696,47,22,NULL,NULL),(697,47,23,NULL,NULL),(698,47,46,NULL,NULL),(699,47,1,NULL,NULL),(700,47,2,NULL,NULL),(701,47,4,NULL,NULL),(702,47,8,NULL,NULL),(703,47,19,NULL,NULL),(704,47,7,NULL,NULL),(705,47,10,NULL,NULL),(706,47,18,NULL,NULL),(707,47,28,NULL,NULL),(708,47,29,NULL,NULL),(709,47,30,NULL,NULL),(710,47,35,NULL,NULL),(711,47,5,NULL,NULL),(712,47,33,NULL,NULL),(713,47,41,NULL,NULL),(714,47,42,NULL,NULL),(715,47,43,NULL,NULL),(716,48,14,NULL,NULL),(717,48,23,NULL,NULL),(718,48,45,NULL,NULL),(719,48,46,NULL,NULL),(720,48,47,NULL,NULL),(721,48,1,NULL,NULL),(722,48,2,NULL,NULL),(723,48,4,NULL,NULL),(724,48,6,NULL,NULL),(725,48,19,NULL,NULL),(726,48,7,NULL,NULL),(727,48,11,NULL,NULL),(728,48,12,NULL,NULL),(729,48,15,NULL,NULL),(730,48,18,NULL,NULL),(731,48,30,NULL,NULL),(732,48,31,NULL,NULL),(733,48,20,NULL,NULL),(734,48,21,NULL,NULL),(735,48,33,NULL,NULL),(736,49,13,NULL,NULL),(737,49,14,NULL,NULL),(738,49,23,NULL,NULL),(739,49,45,NULL,NULL),(740,49,1,NULL,NULL),(741,49,2,NULL,NULL),(742,49,4,NULL,NULL),(743,49,12,NULL,NULL),(744,49,15,NULL,NULL),(745,49,16,NULL,NULL),(746,49,31,NULL,NULL),(747,50,14,NULL,NULL),(748,50,22,NULL,NULL),(749,50,45,NULL,NULL),(750,50,1,NULL,NULL),(751,50,4,NULL,NULL),(752,50,6,NULL,NULL),(753,50,11,NULL,NULL),(754,50,17,NULL,NULL),(755,50,18,NULL,NULL),(756,50,30,NULL,NULL),(757,50,32,NULL,NULL),(758,50,34,NULL,NULL),(759,51,14,NULL,NULL),(760,51,22,NULL,NULL),(761,51,23,NULL,NULL),(762,51,45,NULL,NULL),(763,51,47,NULL,NULL),(764,51,5,NULL,NULL),(765,51,9,NULL,NULL),(766,51,20,NULL,NULL),(767,51,25,NULL,NULL),(768,51,33,NULL,NULL),(769,51,7,NULL,NULL),(770,51,10,NULL,NULL),(771,51,15,NULL,NULL),(772,51,16,NULL,NULL),(773,51,28,NULL,NULL),(774,51,29,NULL,NULL),(775,51,31,NULL,NULL),(776,51,32,NULL,NULL),(777,51,38,NULL,NULL),(778,51,39,NULL,NULL),(779,51,42,NULL,NULL),(780,52,13,NULL,NULL),(781,52,22,NULL,NULL),(782,52,45,NULL,NULL),(783,52,46,NULL,NULL),(784,52,3,NULL,NULL),(785,52,21,NULL,NULL),(786,52,25,NULL,NULL),(787,52,27,NULL,NULL),(788,52,10,NULL,NULL),(789,52,11,NULL,NULL),(790,52,12,NULL,NULL),(791,52,16,NULL,NULL),(792,52,17,NULL,NULL),(793,52,28,NULL,NULL),(794,52,30,NULL,NULL),(795,52,35,NULL,NULL),(796,52,38,NULL,NULL),(797,52,41,NULL,NULL),(798,53,13,NULL,NULL),(799,53,22,NULL,NULL),(800,53,47,NULL,NULL),(801,53,4,NULL,NULL),(802,53,6,NULL,NULL),(803,53,8,NULL,NULL),(804,53,10,NULL,NULL),(805,53,11,NULL,NULL),(806,53,18,NULL,NULL),(807,53,30,NULL,NULL),(808,53,34,NULL,NULL),(809,53,35,NULL,NULL),(810,54,13,NULL,NULL),(811,54,22,NULL,NULL),(812,54,23,NULL,NULL),(813,54,46,NULL,NULL),(814,54,2,NULL,NULL),(815,54,19,NULL,NULL),(816,54,16,NULL,NULL),(817,55,13,NULL,NULL),(818,55,14,NULL,NULL),(819,55,23,NULL,NULL),(820,55,46,NULL,NULL),(821,55,47,NULL,NULL),(822,55,3,NULL,NULL),(823,55,5,NULL,NULL),(824,55,9,NULL,NULL),(825,55,20,NULL,NULL),(826,55,25,NULL,NULL),(827,55,27,NULL,NULL),(828,55,10,NULL,NULL),(829,55,12,NULL,NULL),(830,55,15,NULL,NULL),(831,55,16,NULL,NULL),(832,55,17,NULL,NULL),(833,55,18,NULL,NULL),(834,55,30,NULL,NULL),(835,55,32,NULL,NULL),(836,55,34,NULL,NULL),(837,55,37,NULL,NULL),(838,55,38,NULL,NULL),(839,55,39,NULL,NULL),(840,55,41,NULL,NULL),(841,56,14,NULL,NULL),(842,56,45,NULL,NULL),(843,56,47,NULL,NULL),(844,56,4,NULL,NULL),(845,56,6,NULL,NULL),(846,56,8,NULL,NULL),(847,56,19,NULL,NULL),(848,56,10,NULL,NULL),(849,56,15,NULL,NULL),(850,56,18,NULL,NULL),(851,56,32,NULL,NULL),(852,57,14,NULL,NULL),(853,57,22,NULL,NULL),(854,57,23,NULL,NULL),(855,57,46,NULL,NULL),(856,57,47,NULL,NULL),(857,57,1,NULL,NULL),(858,57,4,NULL,NULL),(859,57,6,NULL,NULL),(860,57,8,NULL,NULL),(861,57,7,NULL,NULL),(862,57,11,NULL,NULL),(863,57,18,NULL,NULL),(864,57,29,NULL,NULL),(865,57,32,NULL,NULL),(866,57,35,NULL,NULL),(867,57,21,NULL,NULL),(868,57,39,NULL,NULL),(869,57,43,NULL,NULL),(870,58,13,NULL,NULL),(871,58,45,NULL,NULL),(872,58,46,NULL,NULL),(873,58,47,NULL,NULL),(874,58,1,NULL,NULL),(875,58,2,NULL,NULL),(876,58,4,NULL,NULL),(877,58,12,NULL,NULL),(878,58,17,NULL,NULL),(879,58,18,NULL,NULL),(880,58,29,NULL,NULL),(881,58,30,NULL,NULL),(882,58,35,NULL,NULL),(883,58,5,NULL,NULL),(884,58,39,NULL,NULL),(885,58,40,NULL,NULL),(886,59,13,NULL,NULL),(887,59,14,NULL,NULL),(888,59,46,NULL,NULL),(889,59,47,NULL,NULL),(890,59,1,NULL,NULL),(891,59,2,NULL,NULL),(892,59,6,NULL,NULL),(893,59,10,NULL,NULL),(894,59,11,NULL,NULL),(895,59,29,NULL,NULL),(896,59,35,NULL,NULL),(897,60,22,NULL,NULL),(898,60,23,NULL,NULL),(899,60,46,NULL,NULL),(900,60,47,NULL,NULL),(901,60,3,NULL,NULL),(902,60,9,NULL,NULL),(903,60,20,NULL,NULL),(904,60,21,NULL,NULL),(905,60,10,NULL,NULL),(906,60,11,NULL,NULL),(907,60,15,NULL,NULL),(908,60,16,NULL,NULL),(909,60,17,NULL,NULL),(910,60,29,NULL,NULL),(911,60,30,NULL,NULL),(912,60,31,NULL,NULL),(913,60,34,NULL,NULL),(914,60,35,NULL,NULL),(915,60,38,NULL,NULL),(916,60,41,NULL,NULL),(917,60,42,NULL,NULL),(918,61,23,NULL,NULL),(919,61,45,NULL,NULL),(920,61,46,NULL,NULL),(921,61,47,NULL,NULL),(922,61,1,NULL,NULL),(923,61,2,NULL,NULL),(924,61,8,NULL,NULL),(925,61,19,NULL,NULL),(926,61,16,NULL,NULL),(927,61,17,NULL,NULL),(928,61,28,NULL,NULL),(929,61,30,NULL,NULL),(930,62,13,NULL,NULL),(931,62,14,NULL,NULL),(932,62,22,NULL,NULL),(933,62,46,NULL,NULL),(934,62,4,NULL,NULL),(935,62,8,NULL,NULL),(936,62,16,NULL,NULL),(937,62,17,NULL,NULL),(938,62,30,NULL,NULL),(939,62,37,NULL,NULL),(940,62,40,NULL,NULL),(941,62,41,NULL,NULL),(942,62,42,NULL,NULL),(943,63,13,NULL,NULL),(944,63,14,NULL,NULL),(945,63,23,NULL,NULL),(946,63,3,NULL,NULL),(947,63,9,NULL,NULL),(948,63,20,NULL,NULL),(949,63,25,NULL,NULL),(950,63,27,NULL,NULL),(951,63,33,NULL,NULL),(952,63,7,NULL,NULL),(953,63,12,NULL,NULL),(954,63,15,NULL,NULL),(955,63,16,NULL,NULL),(956,63,17,NULL,NULL),(957,63,18,NULL,NULL),(958,63,29,NULL,NULL),(959,63,30,NULL,NULL),(960,63,32,NULL,NULL),(961,63,35,NULL,NULL),(962,63,40,NULL,NULL),(963,63,41,NULL,NULL),(964,63,42,NULL,NULL),(965,64,13,NULL,NULL),(966,64,22,NULL,NULL),(967,64,45,NULL,NULL),(968,64,2,NULL,NULL),(969,64,6,NULL,NULL),(970,64,8,NULL,NULL),(971,64,19,NULL,NULL),(972,64,10,NULL,NULL),(973,64,11,NULL,NULL),(974,64,12,NULL,NULL),(975,64,15,NULL,NULL),(976,64,17,NULL,NULL),(977,64,30,NULL,NULL),(978,64,32,NULL,NULL),(979,64,34,NULL,NULL),(980,64,9,NULL,NULL),(981,64,25,NULL,NULL),(982,64,27,NULL,NULL),(983,65,22,NULL,NULL),(984,65,23,NULL,NULL),(985,65,47,NULL,NULL),(986,65,5,NULL,NULL),(987,65,20,NULL,NULL),(988,65,21,NULL,NULL),(989,65,33,NULL,NULL),(990,65,12,NULL,NULL),(991,65,15,NULL,NULL),(992,65,16,NULL,NULL),(993,65,18,NULL,NULL),(994,65,28,NULL,NULL),(995,65,29,NULL,NULL),(996,65,30,NULL,NULL),(997,65,31,NULL,NULL),(998,65,35,NULL,NULL),(999,65,37,NULL,NULL),(1000,65,38,NULL,NULL),(1001,65,42,NULL,NULL),(1002,65,43,NULL,NULL),(1003,66,13,NULL,NULL),(1004,66,14,NULL,NULL),(1005,66,22,NULL,NULL),(1006,66,45,NULL,NULL),(1007,66,1,NULL,NULL),(1008,66,4,NULL,NULL),(1009,66,6,NULL,NULL),(1010,66,8,NULL,NULL),(1011,66,19,NULL,NULL),(1012,66,10,NULL,NULL),(1013,66,12,NULL,NULL),(1014,66,17,NULL,NULL),(1015,66,29,NULL,NULL),(1016,66,31,NULL,NULL),(1017,66,3,NULL,NULL),(1018,66,20,NULL,NULL),(1019,66,33,NULL,NULL),(1020,67,14,NULL,NULL),(1021,67,23,NULL,NULL),(1022,67,45,NULL,NULL),(1023,67,3,NULL,NULL),(1024,67,5,NULL,NULL),(1025,67,9,NULL,NULL),(1026,67,21,NULL,NULL),(1027,67,25,NULL,NULL),(1028,67,27,NULL,NULL),(1029,67,10,NULL,NULL),(1030,67,15,NULL,NULL),(1031,67,16,NULL,NULL),(1032,67,18,NULL,NULL),(1033,67,28,NULL,NULL),(1034,67,29,NULL,NULL),(1035,67,31,NULL,NULL),(1036,67,35,NULL,NULL),(1037,67,41,NULL,NULL),(1038,67,42,NULL,NULL),(1039,67,37,NULL,NULL),(1040,67,38,NULL,NULL),(1041,67,39,NULL,NULL),(1042,68,14,NULL,NULL),(1043,68,22,NULL,NULL),(1044,68,45,NULL,NULL),(1045,68,46,NULL,NULL),(1046,68,47,NULL,NULL),(1047,68,8,NULL,NULL),(1048,68,10,NULL,NULL),(1049,68,39,NULL,NULL),(1050,68,41,NULL,NULL),(1051,69,22,NULL,NULL),(1052,69,23,NULL,NULL),(1053,69,46,NULL,NULL),(1054,69,47,NULL,NULL),(1055,69,4,NULL,NULL),(1056,69,8,NULL,NULL),(1057,69,7,NULL,NULL),(1058,69,10,NULL,NULL),(1059,69,15,NULL,NULL),(1060,69,18,NULL,NULL),(1061,69,28,NULL,NULL),(1062,69,29,NULL,NULL),(1063,69,32,NULL,NULL),(1064,70,14,NULL,NULL),(1065,70,22,NULL,NULL),(1066,70,23,NULL,NULL),(1067,70,46,NULL,NULL),(1068,70,1,NULL,NULL),(1069,70,2,NULL,NULL),(1070,70,4,NULL,NULL),(1071,70,6,NULL,NULL),(1072,70,19,NULL,NULL),(1073,70,11,NULL,NULL),(1074,70,12,NULL,NULL),(1075,70,15,NULL,NULL),(1076,70,16,NULL,NULL),(1077,70,17,NULL,NULL),(1078,70,32,NULL,NULL),(1079,70,34,NULL,NULL),(1080,70,9,NULL,NULL),(1081,70,20,NULL,NULL),(1082,71,14,NULL,NULL),(1083,71,22,NULL,NULL),(1084,71,23,NULL,NULL),(1085,71,45,NULL,NULL),(1086,71,47,NULL,NULL),(1087,71,5,NULL,NULL),(1088,71,9,NULL,NULL),(1089,71,21,NULL,NULL),(1090,71,25,NULL,NULL),(1091,71,7,NULL,NULL),(1092,71,11,NULL,NULL),(1093,71,12,NULL,NULL),(1094,71,15,NULL,NULL),(1095,71,16,NULL,NULL),(1096,71,18,NULL,NULL),(1097,71,28,NULL,NULL),(1098,71,32,NULL,NULL),(1099,71,34,NULL,NULL),(1100,71,37,NULL,NULL),(1101,71,40,NULL,NULL),(1102,71,43,NULL,NULL),(1103,71,42,NULL,NULL),(1104,72,22,NULL,NULL),(1105,72,23,NULL,NULL),(1106,72,45,NULL,NULL),(1107,72,46,NULL,NULL),(1108,72,47,NULL,NULL),(1109,72,3,NULL,NULL),(1110,72,9,NULL,NULL),(1111,72,21,NULL,NULL),(1112,72,25,NULL,NULL),(1113,72,33,NULL,NULL),(1114,72,12,NULL,NULL),(1115,72,15,NULL,NULL),(1116,72,16,NULL,NULL),(1117,72,18,NULL,NULL),(1118,72,29,NULL,NULL),(1119,72,31,NULL,NULL),(1120,72,34,NULL,NULL),(1121,72,35,NULL,NULL),(1122,72,37,NULL,NULL),(1123,72,40,NULL,NULL),(1124,72,41,NULL,NULL),(1125,73,22,NULL,NULL),(1126,73,23,NULL,NULL),(1127,73,45,NULL,NULL),(1128,73,2,NULL,NULL),(1129,73,4,NULL,NULL),(1130,73,19,NULL,NULL),(1131,73,10,NULL,NULL),(1132,73,11,NULL,NULL),(1133,73,12,NULL,NULL),(1134,73,15,NULL,NULL),(1135,73,28,NULL,NULL),(1136,73,34,NULL,NULL),(1137,73,5,NULL,NULL),(1138,73,9,NULL,NULL),(1139,73,27,NULL,NULL),(1140,73,38,NULL,NULL),(1141,73,43,NULL,NULL),(1142,74,13,NULL,NULL),(1143,74,14,NULL,NULL),(1144,74,22,NULL,NULL),(1145,74,23,NULL,NULL),(1146,74,45,NULL,NULL),(1147,74,3,NULL,NULL),(1148,74,20,NULL,NULL),(1149,74,21,NULL,NULL),(1150,74,25,NULL,NULL),(1151,74,27,NULL,NULL),(1152,74,33,NULL,NULL),(1153,74,7,NULL,NULL),(1154,74,10,NULL,NULL),(1155,74,12,NULL,NULL),(1156,74,15,NULL,NULL),(1157,74,17,NULL,NULL),(1158,74,18,NULL,NULL),(1159,74,28,NULL,NULL),(1160,74,29,NULL,NULL),(1161,74,31,NULL,NULL),(1162,74,32,NULL,NULL),(1163,74,34,NULL,NULL),(1164,74,37,NULL,NULL),(1165,74,42,NULL,NULL),(1166,75,13,NULL,NULL),(1167,75,23,NULL,NULL),(1168,75,46,NULL,NULL),(1169,75,47,NULL,NULL),(1170,75,1,NULL,NULL),(1171,75,4,NULL,NULL),(1172,75,6,NULL,NULL),(1173,75,15,NULL,NULL),(1174,75,16,NULL,NULL),(1175,75,17,NULL,NULL),(1176,75,29,NULL,NULL),(1177,75,30,NULL,NULL),(1178,75,31,NULL,NULL),(1179,75,32,NULL,NULL),(1180,75,3,NULL,NULL),(1181,75,9,NULL,NULL),(1182,76,14,NULL,NULL),(1183,76,22,NULL,NULL),(1184,76,23,NULL,NULL),(1185,76,45,NULL,NULL),(1186,76,47,NULL,NULL),(1187,76,1,NULL,NULL),(1188,76,4,NULL,NULL),(1189,76,10,NULL,NULL),(1190,76,11,NULL,NULL),(1191,76,18,NULL,NULL),(1192,76,28,NULL,NULL),(1193,76,31,NULL,NULL),(1194,76,35,NULL,NULL),(1195,76,38,NULL,NULL),(1196,76,39,NULL,NULL),(1197,76,40,NULL,NULL),(1198,76,41,NULL,NULL),(1199,77,13,NULL,NULL),(1200,77,14,NULL,NULL),(1201,77,45,NULL,NULL),(1202,77,46,NULL,NULL),(1203,77,2,NULL,NULL),(1204,77,15,NULL,NULL),(1205,77,37,NULL,NULL),(1206,77,42,NULL,NULL),(1207,78,13,NULL,NULL),(1208,78,22,NULL,NULL),(1209,78,23,NULL,NULL),(1210,78,45,NULL,NULL),(1211,78,47,NULL,NULL),(1212,78,1,NULL,NULL),(1213,78,2,NULL,NULL),(1214,78,4,NULL,NULL),(1215,78,19,NULL,NULL),(1216,78,11,NULL,NULL),(1217,78,16,NULL,NULL),(1218,78,28,NULL,NULL),(1219,78,29,NULL,NULL),(1220,78,34,NULL,NULL),(1221,78,37,NULL,NULL),(1222,78,42,NULL,NULL),(1223,79,14,NULL,NULL),(1224,79,45,NULL,NULL),(1225,79,47,NULL,NULL),(1226,79,1,NULL,NULL),(1227,79,2,NULL,NULL),(1228,79,6,NULL,NULL),(1229,79,8,NULL,NULL),(1230,79,11,NULL,NULL),(1231,79,12,NULL,NULL),(1232,79,28,NULL,NULL),(1233,79,30,NULL,NULL),(1234,79,32,NULL,NULL),(1235,80,13,NULL,NULL),(1236,80,22,NULL,NULL),(1237,80,45,NULL,NULL),(1238,80,46,NULL,NULL),(1239,80,2,NULL,NULL),(1240,80,4,NULL,NULL),(1241,80,6,NULL,NULL),(1242,80,19,NULL,NULL),(1243,80,15,NULL,NULL),(1244,80,17,NULL,NULL),(1245,80,18,NULL,NULL),(1246,80,28,NULL,NULL),(1247,80,31,NULL,NULL),(1248,80,32,NULL,NULL),(1249,80,35,NULL,NULL),(1250,80,20,NULL,NULL),(1251,80,21,NULL,NULL),(1252,80,25,NULL,NULL),(1253,80,40,NULL,NULL),(1254,80,42,NULL,NULL),(1255,81,23,NULL,NULL),(1256,81,45,NULL,NULL),(1257,81,46,NULL,NULL),(1258,81,47,NULL,NULL),(1259,81,1,NULL,NULL),(1260,81,2,NULL,NULL),(1261,81,6,NULL,NULL),(1262,81,8,NULL,NULL),(1263,81,7,NULL,NULL),(1264,81,10,NULL,NULL),(1265,81,12,NULL,NULL),(1266,81,28,NULL,NULL),(1267,82,22,NULL,NULL),(1268,82,45,NULL,NULL),(1269,82,46,NULL,NULL),(1270,82,2,NULL,NULL),(1271,82,4,NULL,NULL),(1272,82,8,NULL,NULL),(1273,82,10,NULL,NULL),(1274,82,15,NULL,NULL),(1275,82,17,NULL,NULL),(1276,82,28,NULL,NULL),(1277,82,29,NULL,NULL),(1278,82,35,NULL,NULL),(1279,82,3,NULL,NULL),(1280,82,25,NULL,NULL),(1281,83,22,NULL,NULL),(1282,83,23,NULL,NULL),(1283,83,47,NULL,NULL),(1284,83,2,NULL,NULL),(1285,83,6,NULL,NULL),(1286,83,19,NULL,NULL),(1287,83,10,NULL,NULL),(1288,83,11,NULL,NULL),(1289,83,12,NULL,NULL),(1290,83,17,NULL,NULL),(1291,83,28,NULL,NULL),(1292,83,31,NULL,NULL),(1293,83,34,NULL,NULL),(1294,83,35,NULL,NULL),(1295,83,27,NULL,NULL),(1296,84,13,NULL,NULL),(1297,84,14,NULL,NULL),(1298,84,23,NULL,NULL),(1299,84,46,NULL,NULL),(1300,84,1,NULL,NULL),(1301,84,4,NULL,NULL),(1302,84,8,NULL,NULL),(1303,84,19,NULL,NULL),(1304,84,12,NULL,NULL),(1305,84,15,NULL,NULL),(1306,84,16,NULL,NULL),(1307,84,18,NULL,NULL),(1308,84,30,NULL,NULL),(1309,84,31,NULL,NULL),(1310,85,14,NULL,NULL),(1311,85,45,NULL,NULL),(1312,85,46,NULL,NULL),(1313,85,47,NULL,NULL),(1314,85,2,NULL,NULL),(1315,85,4,NULL,NULL),(1316,85,6,NULL,NULL),(1317,85,10,NULL,NULL),(1318,85,16,NULL,NULL),(1319,85,17,NULL,NULL),(1320,85,32,NULL,NULL),(1321,85,35,NULL,NULL),(1322,85,25,NULL,NULL),(1323,85,33,NULL,NULL),(1324,86,13,NULL,NULL),(1325,86,14,NULL,NULL),(1326,86,22,NULL,NULL),(1327,86,23,NULL,NULL),(1328,86,45,NULL,NULL),(1329,86,1,NULL,NULL),(1330,86,2,NULL,NULL),(1331,86,4,NULL,NULL),(1332,86,6,NULL,NULL),(1333,86,10,NULL,NULL),(1334,86,11,NULL,NULL),(1335,86,12,NULL,NULL),(1336,86,18,NULL,NULL),(1337,86,30,NULL,NULL),(1338,86,31,NULL,NULL),(1339,86,35,NULL,NULL),(1340,86,3,NULL,NULL),(1341,86,27,NULL,NULL),(1342,87,13,NULL,NULL),(1343,87,22,NULL,NULL),(1344,87,23,NULL,NULL),(1345,87,45,NULL,NULL),(1346,87,47,NULL,NULL),(1347,87,9,NULL,NULL),(1348,87,20,NULL,NULL),(1349,87,25,NULL,NULL),(1350,87,33,NULL,NULL),(1351,87,10,NULL,NULL),(1352,87,11,NULL,NULL),(1353,87,12,NULL,NULL),(1354,87,15,NULL,NULL),(1355,87,17,NULL,NULL),(1356,87,18,NULL,NULL),(1357,87,30,NULL,NULL),(1358,87,31,NULL,NULL),(1359,87,32,NULL,NULL),(1360,87,38,NULL,NULL),(1361,87,39,NULL,NULL),(1362,87,40,NULL,NULL),(1363,88,13,NULL,NULL),(1364,88,22,NULL,NULL),(1365,88,23,NULL,NULL),(1366,88,45,NULL,NULL),(1367,88,47,NULL,NULL),(1368,88,1,NULL,NULL),(1369,88,2,NULL,NULL),(1370,88,6,NULL,NULL),(1371,88,7,NULL,NULL),(1372,88,11,NULL,NULL),(1373,88,12,NULL,NULL),(1374,88,17,NULL,NULL),(1375,88,31,NULL,NULL),(1376,89,13,NULL,NULL),(1377,89,14,NULL,NULL),(1378,89,22,NULL,NULL),(1379,89,23,NULL,NULL),(1380,89,46,NULL,NULL),(1381,89,3,NULL,NULL),(1382,89,5,NULL,NULL),(1383,89,9,NULL,NULL),(1384,89,20,NULL,NULL),(1385,89,25,NULL,NULL),(1386,89,27,NULL,NULL),(1387,89,7,NULL,NULL),(1388,89,10,NULL,NULL),(1389,89,11,NULL,NULL),(1390,89,12,NULL,NULL),(1391,89,16,NULL,NULL),(1392,89,18,NULL,NULL),(1393,89,29,NULL,NULL),(1394,89,30,NULL,NULL),(1395,89,31,NULL,NULL),(1396,89,34,NULL,NULL),(1397,89,39,NULL,NULL),(1398,89,41,NULL,NULL),(1399,89,42,NULL,NULL),(1400,89,43,NULL,NULL),(1401,90,14,NULL,NULL),(1402,90,23,NULL,NULL),(1403,90,45,NULL,NULL),(1404,90,46,NULL,NULL),(1405,90,47,NULL,NULL),(1406,90,1,NULL,NULL),(1407,90,2,NULL,NULL),(1408,90,8,NULL,NULL),(1409,90,19,NULL,NULL),(1410,90,7,NULL,NULL),(1411,90,11,NULL,NULL),(1412,90,18,NULL,NULL),(1413,90,31,NULL,NULL),(1414,90,32,NULL,NULL),(1415,90,34,NULL,NULL),(1416,90,3,NULL,NULL),(1417,90,20,NULL,NULL),(1418,90,25,NULL,NULL),(1419,91,22,NULL,NULL),(1420,91,23,NULL,NULL),(1421,91,46,NULL,NULL),(1422,91,47,NULL,NULL),(1423,91,2,NULL,NULL),(1424,91,8,NULL,NULL),(1425,91,19,NULL,NULL),(1426,91,7,NULL,NULL),(1427,91,16,NULL,NULL),(1428,91,30,NULL,NULL),(1429,92,14,NULL,NULL),(1430,92,22,NULL,NULL),(1431,92,23,NULL,NULL),(1432,92,46,NULL,NULL),(1433,92,47,NULL,NULL),(1434,92,1,NULL,NULL),(1435,92,19,NULL,NULL),(1436,92,16,NULL,NULL),(1437,92,18,NULL,NULL),(1438,92,31,NULL,NULL),(1439,92,32,NULL,NULL),(1440,92,34,NULL,NULL),(1441,92,41,NULL,NULL),(1442,92,42,NULL,NULL),(1443,93,14,NULL,NULL),(1444,93,22,NULL,NULL),(1445,93,45,NULL,NULL),(1446,93,46,NULL,NULL),(1447,93,3,NULL,NULL),(1448,93,9,NULL,NULL),(1449,93,20,NULL,NULL),(1450,93,25,NULL,NULL),(1451,93,27,NULL,NULL),(1452,93,33,NULL,NULL),(1453,93,7,NULL,NULL),(1454,93,12,NULL,NULL),(1455,93,15,NULL,NULL),(1456,93,17,NULL,NULL),(1457,93,29,NULL,NULL),(1458,93,31,NULL,NULL),(1459,93,35,NULL,NULL),(1460,93,37,NULL,NULL),(1461,93,41,NULL,NULL),(1462,94,13,NULL,NULL),(1463,94,14,NULL,NULL),(1464,94,22,NULL,NULL),(1465,94,47,NULL,NULL),(1466,94,3,NULL,NULL),(1467,94,5,NULL,NULL),(1468,94,20,NULL,NULL),(1469,94,21,NULL,NULL),(1470,94,33,NULL,NULL),(1471,94,11,NULL,NULL),(1472,94,12,NULL,NULL),(1473,94,16,NULL,NULL),(1474,94,17,NULL,NULL),(1475,94,18,NULL,NULL),(1476,94,28,NULL,NULL),(1477,94,29,NULL,NULL),(1478,94,30,NULL,NULL),(1479,94,34,NULL,NULL),(1480,94,35,NULL,NULL),(1481,94,37,NULL,NULL),(1482,94,38,NULL,NULL),(1483,94,40,NULL,NULL),(1484,94,43,NULL,NULL),(1485,94,41,NULL,NULL),(1486,94,42,NULL,NULL),(1487,95,14,NULL,NULL),(1488,95,22,NULL,NULL),(1489,95,23,NULL,NULL),(1490,95,1,NULL,NULL),(1491,95,2,NULL,NULL),(1492,95,19,NULL,NULL),(1493,95,11,NULL,NULL),(1494,95,12,NULL,NULL),(1495,95,15,NULL,NULL),(1496,95,16,NULL,NULL),(1497,95,34,NULL,NULL),(1498,95,35,NULL,NULL),(1499,95,21,NULL,NULL),(1500,95,27,NULL,NULL),(1501,95,33,NULL,NULL),(1502,95,37,NULL,NULL),(1503,95,43,NULL,NULL),(1504,96,14,NULL,NULL),(1505,96,23,NULL,NULL),(1506,96,45,NULL,NULL),(1507,96,47,NULL,NULL),(1508,96,4,NULL,NULL),(1509,96,8,NULL,NULL),(1510,96,19,NULL,NULL),(1511,96,15,NULL,NULL),(1512,96,16,NULL,NULL),(1513,96,17,NULL,NULL),(1514,96,18,NULL,NULL),(1515,96,31,NULL,NULL),(1516,96,32,NULL,NULL),(1517,96,35,NULL,NULL),(1518,96,5,NULL,NULL),(1519,96,21,NULL,NULL),(1520,96,25,NULL,NULL),(1521,97,14,NULL,NULL),(1522,97,23,NULL,NULL),(1523,97,45,NULL,NULL),(1524,97,47,NULL,NULL),(1525,97,1,NULL,NULL),(1526,97,2,NULL,NULL),(1527,97,8,NULL,NULL),(1528,97,19,NULL,NULL),(1529,97,10,NULL,NULL),(1530,97,16,NULL,NULL),(1531,97,18,NULL,NULL),(1532,97,28,NULL,NULL),(1533,97,29,NULL,NULL),(1534,97,35,NULL,NULL),(1535,97,37,NULL,NULL),(1536,97,40,NULL,NULL),(1537,97,41,NULL,NULL),(1538,97,42,NULL,NULL),(1539,98,13,NULL,NULL),(1540,98,14,NULL,NULL),(1541,98,23,NULL,NULL),(1542,98,45,NULL,NULL),(1543,98,47,NULL,NULL),(1544,98,4,NULL,NULL),(1545,98,6,NULL,NULL),(1546,98,8,NULL,NULL),(1547,98,19,NULL,NULL),(1548,98,11,NULL,NULL),(1549,98,12,NULL,NULL),(1550,98,18,NULL,NULL),(1551,98,28,NULL,NULL),(1552,98,31,NULL,NULL),(1553,98,27,NULL,NULL),(1554,98,33,NULL,NULL),(1555,99,13,NULL,NULL),(1556,99,14,NULL,NULL),(1557,99,23,NULL,NULL),(1558,99,45,NULL,NULL),(1559,99,46,NULL,NULL),(1560,99,2,NULL,NULL),(1561,99,6,NULL,NULL),(1562,99,8,NULL,NULL),(1563,99,19,NULL,NULL),(1564,99,7,NULL,NULL),(1565,99,10,NULL,NULL),(1566,99,11,NULL,NULL),(1567,99,12,NULL,NULL),(1568,99,31,NULL,NULL),(1569,99,35,NULL,NULL),(1570,99,33,NULL,NULL),(1571,99,42,NULL,NULL),(1572,99,43,NULL,NULL),(1573,100,13,NULL,NULL),(1574,100,14,NULL,NULL),(1575,100,22,NULL,NULL),(1576,100,23,NULL,NULL),(1577,100,45,NULL,NULL),(1578,100,6,NULL,NULL),(1579,100,8,NULL,NULL),(1580,100,11,NULL,NULL),(1581,100,37,NULL,NULL),(1582,100,39,NULL,NULL),(1583,100,41,NULL,NULL),(1584,100,42,NULL,NULL);
/*!40000 ALTER TABLE `cr_cars_amenities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_categories`
--

DROP TABLE IF EXISTS `cr_cars_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_category_id` bigint unsigned DEFAULT NULL,
  `cr_car_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_cars_categories_cr_car_category_id_index` (`cr_car_category_id`),
  KEY `cr_cars_categories_cr_car_id_index` (`cr_car_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_categories`
--

LOCK TABLES `cr_cars_categories` WRITE;
/*!40000 ALTER TABLE `cr_cars_categories` DISABLE KEYS */;
INSERT INTO `cr_cars_categories` VALUES (1,3,59),(2,1,73),(3,4,78),(4,2,12),(5,5,16),(6,1,19),(7,3,28),(8,3,35),(9,5,37),(10,2,48),(11,3,71),(12,3,85),(13,1,90),(14,5,1),(15,1,2),(16,4,11),(17,3,41),(18,1,62),(19,5,13),(20,4,31),(21,4,33),(22,1,51),(23,1,52),(24,3,65),(25,4,68),(26,2,69),(27,1,74),(28,5,75),(29,2,81),(30,4,87),(31,2,17),(32,1,25),(33,3,36),(34,5,49),(35,1,50),(36,1,67),(37,2,83),(38,5,89),(39,2,97),(40,4,14),(41,2,27),(42,4,56),(43,1,80),(44,5,99),(45,5,9),(46,4,15),(47,5,34),(48,4,42),(49,5,64),(50,4,82),(51,4,88),(52,3,92),(53,5,93),(54,4,94),(55,1,3),(56,1,43),(57,4,46),(58,4,55),(59,3,57),(60,4,72),(61,4,91),(62,5,96),(63,1,98),(64,3,5),(65,2,21),(66,1,23),(67,4,26),(68,2,45),(69,4,63),(70,4,10),(71,3,30),(72,5,40),(73,4,47),(74,1,53),(75,1,54),(76,5,77),(77,2,86),(78,4,29),(79,4,39),(80,3,95),(81,2,7),(82,3,22),(83,1,24),(84,5,32),(85,3,79),(86,3,100),(87,4,6),(88,5,20),(89,5,58),(90,3,61),(91,4,66),(92,3,76),(93,5,4),(94,4,8),(95,5,18),(96,2,38),(97,5,44),(98,4,60),(99,3,70),(100,5,84);
/*!40000 ALTER TABLE `cr_cars_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_colors`
--

DROP TABLE IF EXISTS `cr_cars_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_colors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_id` bigint unsigned NOT NULL,
  `cr_car_color_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_colors`
--

LOCK TABLES `cr_cars_colors` WRITE;
/*!40000 ALTER TABLE `cr_cars_colors` DISABLE KEYS */;
INSERT INTO `cr_cars_colors` VALUES (1,1,1,NULL,NULL),(2,2,6,NULL,NULL),(3,3,1,NULL,NULL),(4,4,6,NULL,NULL),(5,5,6,NULL,NULL),(6,6,4,NULL,NULL),(7,7,4,NULL,NULL),(8,8,3,NULL,NULL),(9,9,3,NULL,NULL),(10,10,5,NULL,NULL),(11,11,6,NULL,NULL),(12,12,1,NULL,NULL),(13,13,5,NULL,NULL),(14,14,2,NULL,NULL),(15,15,1,NULL,NULL),(16,16,6,NULL,NULL),(17,17,3,NULL,NULL),(18,18,3,NULL,NULL),(19,19,5,NULL,NULL),(20,20,4,NULL,NULL),(21,21,5,NULL,NULL),(22,22,5,NULL,NULL),(23,23,6,NULL,NULL),(24,24,6,NULL,NULL),(25,25,2,NULL,NULL),(26,26,4,NULL,NULL),(27,27,4,NULL,NULL),(28,28,2,NULL,NULL),(29,29,6,NULL,NULL),(30,30,4,NULL,NULL),(31,31,3,NULL,NULL),(32,32,2,NULL,NULL),(33,33,2,NULL,NULL),(34,34,3,NULL,NULL),(35,35,4,NULL,NULL),(36,36,1,NULL,NULL),(37,37,1,NULL,NULL),(38,38,2,NULL,NULL),(39,39,1,NULL,NULL),(40,40,5,NULL,NULL),(41,41,5,NULL,NULL),(42,42,3,NULL,NULL),(43,43,2,NULL,NULL),(44,44,2,NULL,NULL),(45,45,5,NULL,NULL),(46,46,1,NULL,NULL),(47,47,4,NULL,NULL),(48,48,1,NULL,NULL),(49,49,2,NULL,NULL),(50,50,3,NULL,NULL),(51,51,1,NULL,NULL),(52,52,3,NULL,NULL),(53,53,4,NULL,NULL),(54,54,5,NULL,NULL),(55,55,3,NULL,NULL),(56,56,6,NULL,NULL),(57,57,3,NULL,NULL),(58,58,3,NULL,NULL),(59,59,6,NULL,NULL),(60,60,2,NULL,NULL),(61,61,4,NULL,NULL),(62,62,1,NULL,NULL),(63,63,1,NULL,NULL),(64,64,3,NULL,NULL),(65,65,3,NULL,NULL),(66,66,4,NULL,NULL),(67,67,6,NULL,NULL),(68,68,3,NULL,NULL),(69,69,1,NULL,NULL),(70,70,2,NULL,NULL),(71,71,1,NULL,NULL),(72,72,2,NULL,NULL),(73,73,5,NULL,NULL),(74,74,6,NULL,NULL),(75,75,2,NULL,NULL),(76,76,5,NULL,NULL),(77,77,6,NULL,NULL),(78,78,6,NULL,NULL),(79,79,3,NULL,NULL),(80,80,6,NULL,NULL),(81,81,1,NULL,NULL),(82,82,2,NULL,NULL),(83,83,6,NULL,NULL),(84,84,5,NULL,NULL),(85,85,4,NULL,NULL),(86,86,1,NULL,NULL),(87,87,4,NULL,NULL),(88,88,5,NULL,NULL),(89,89,5,NULL,NULL),(90,90,1,NULL,NULL),(91,91,5,NULL,NULL),(92,92,4,NULL,NULL),(93,93,3,NULL,NULL),(94,94,3,NULL,NULL),(95,95,5,NULL,NULL),(96,96,2,NULL,NULL),(97,97,6,NULL,NULL),(98,98,6,NULL,NULL),(99,99,4,NULL,NULL),(100,100,1,NULL,NULL);
/*!40000 ALTER TABLE `cr_cars_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_translations`
--

DROP TABLE IF EXISTS `cr_cars_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_cars_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_cars_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_translations`
--

LOCK TABLES `cr_cars_translations` WRITE;
/*!40000 ALTER TABLE `cr_cars_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_cars_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_category_commissions`
--

DROP TABLE IF EXISTS `cr_category_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_category_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_category_commissions`
--

LOCK TABLES `cr_category_commissions` WRITE;
/*!40000 ALTER TABLE `cr_category_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_category_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_coupons`
--

DROP TABLE IF EXISTS `cr_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` double NOT NULL,
  `is_unlimited_expires` tinyint NOT NULL DEFAULT '0',
  `expires_at` datetime DEFAULT NULL,
  `is_unlimited` tinyint NOT NULL DEFAULT '1',
  `limit` int NOT NULL DEFAULT '0',
  `used` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_coupons_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_coupons`
--

LOCK TABLES `cr_coupons` WRITE;
/*!40000 ALTER TABLE `cr_coupons` DISABLE KEYS */;
INSERT INTO `cr_coupons` VALUES (1,'XJnyjYoKumGG','percentage',86.1,1,NULL,1,0,39,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(2,'xCEaPdaCdlhg','money',1,0,'2025-12-18 04:13:35',0,517,129,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(3,'oCEEQjNDkLN4','percentage',5.97,0,'2026-01-18 04:13:35',1,0,70,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(4,'GO73NDT3KtAq','money',0,0,'2026-02-18 04:13:35',1,0,91,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(5,'Ehi81Eztre4H','percentage',27.61,0,'2026-03-18 04:13:35',0,837,31,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(6,'8nwFjZZaEzc9','percentage',31.41,0,'2026-04-18 04:13:35',1,0,94,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(7,'oBcIOWWlj6Ai','money',2,0,'2026-05-18 04:13:35',0,222,57,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(8,'gsBW9AMrTT2J','money',6,1,NULL,1,0,97,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(9,'6shWZHkLneId','percentage',68.1,0,'2026-06-18 04:13:35',1,0,55,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(10,'9nkAsMDnH6YY','money',0,0,'2026-07-18 04:13:35',1,0,13,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(11,'0nQQeWGWT7Qk','money',9,0,'2026-08-18 04:13:35',0,368,128,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(12,'gkABVag9fZga','percentage',27.33,0,'2026-09-18 04:13:35',0,736,91,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(13,'2TDLQCqOskPM','percentage',61.09,0,'2026-10-18 04:13:35',1,0,86,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(14,'QhUDHl75HQIk','percentage',56.83,1,NULL,0,518,72,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(15,'HfP6BzVO5yzt','percentage',53.87,1,NULL,1,0,112,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(16,'b26GsDUHiqFE','money',0,0,'2026-11-18 04:13:35',0,320,71,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(17,'s4bV0rPFk8KE','percentage',93.95,0,'2026-12-18 04:13:35',1,0,119,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(18,'PZXFGZcpRx7h','percentage',96.49,1,NULL,1,0,112,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(19,'dSAPRzVloyGY','money',1,0,'2027-01-18 04:13:35',1,0,111,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(20,'RndVdvmgUAlW','percentage',21.73,1,NULL,0,486,36,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(21,'gZQIwePZSo3N','money',2,1,NULL,1,0,104,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(22,'u0rrwsPGzrYj','money',7,0,'2027-02-18 04:13:35',0,418,102,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(23,'IukH40r8WvW9','percentage',30.32,1,NULL,0,362,15,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(24,'2T9d7E8hDIcw','money',0,0,'2027-03-18 04:13:35',0,483,100,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(25,'m6gsl0dHbHws','percentage',40.79,1,NULL,0,652,103,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(26,'N98meDKJpPRu','percentage',59.71,0,'2027-04-18 04:13:35',0,872,33,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(27,'vGd3YauX56jl','money',7,0,'2027-05-18 04:13:35',1,0,14,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(28,'ZMXBtyPmp7Fd','money',9,0,'2027-06-18 04:13:35',1,0,48,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(29,'ITaVLqJi33BG','money',8,1,NULL,1,0,26,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(30,'INkzada9pjBY','money',4,1,NULL,0,416,128,'2025-11-17 21:13:35','2025-11-17 21:13:35'),(31,'4FSy2EjLtAWM','percentage',55.34,0,'2027-07-18 04:13:35',1,0,97,'2025-11-17 21:13:35','2025-11-17 21:13:35');
/*!40000 ALTER TABLE `cr_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_currencies`
--

DROP TABLE IF EXISTS `cr_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `number_format_style` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'western',
  `space_between_price_and_currency` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_currencies`
--

LOCK TABLES `cr_currencies` WRITE;
/*!40000 ALTER TABLE `cr_currencies` DISABLE KEYS */;
INSERT INTO `cr_currencies` VALUES (1,'USD','$',1,0,0,1,1,'western',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(2,'EUR','€',0,0,1,0,0.84,'western',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(3,'VND','₫',0,0,2,0,23203,'western',0,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(4,'NGN','₦',1,0,2,0,895.52,'western',0,'2025-11-17 21:13:34','2025-11-17 21:13:34');
/*!40000 ALTER TABLE `cr_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_password_resets`
--

DROP TABLE IF EXISTS `cr_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `cr_customer_password_resets_email_index` (`email`),
  KEY `cr_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_password_resets`
--

LOCK TABLES `cr_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `cr_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_revenues`
--

DROP TABLE IF EXISTS `cr_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `booking_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) NOT NULL,
  `fee` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `current_balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add-amount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_revenues`
--

LOCK TABLES `cr_customer_revenues` WRITE;
/*!40000 ALTER TABLE `cr_customer_revenues` DISABLE KEYS */;
INSERT INTO `cr_customer_revenues` VALUES (1,2,2,270.00,54.00,216.00,216.00,'USD','Earnings from booking ##1000003 for Bugatti Chiron Super Sport 2024',NULL,'booking-completed','2025-10-07 21:14:20','2025-10-07 21:14:20'),(2,3,3,90.00,18.00,72.00,72.00,'USD','Earnings from booking ##1000004 for Bentley Continental GT V8 2024',NULL,'booking-completed','2025-09-29 21:14:20','2025-09-29 21:14:20'),(3,19,5,148.00,29.60,118.40,118.40,'USD','Earnings from booking ##1000006 for Mazda MX-5 Miata Grand Touring 2024',NULL,'booking-completed','2025-09-18 21:14:20','2025-09-18 21:14:20'),(4,12,6,352.00,70.40,281.60,281.60,'USD','Earnings from booking ##1000007 for Toyota RAV4 Prime XSE AWD 2024',NULL,'booking-completed','2025-10-11 21:14:21','2025-10-11 21:14:21'),(5,20,7,115.20,23.04,92.16,92.16,'USD','Earnings from booking ##1000008 for Genesis Electrified GV70 Advanced AWD 2024',NULL,'booking-completed','2025-10-02 21:14:21','2025-10-02 21:14:21'),(6,32,11,194.40,38.88,155.52,155.52,'USD','Earnings from booking ##1000012 for Volvo S90 B6 Ultimate AWD 2024',NULL,'booking-completed','2025-11-11 21:14:21','2025-11-11 21:14:21'),(7,10,12,420.00,84.00,336.00,336.00,'USD','Earnings from booking ##1000013 for Chevrolet Corvette Z06 3LZ 2024',NULL,'booking-completed','2025-10-09 21:14:21','2025-10-09 21:14:21'),(8,3,13,315.00,63.00,252.00,324.00,'USD','Earnings from booking ##1000014 for Bentley Continental GT V8 2024',NULL,'booking-completed','2025-11-03 21:14:21','2025-11-03 21:14:21'),(9,17,14,94.50,18.90,75.60,75.60,'USD','Earnings from booking ##1000015 for Maserati Ghibli Modena 2024',NULL,'booking-completed','2025-10-06 21:14:21','2025-10-06 21:14:21'),(10,16,16,220.50,44.10,176.40,176.40,'USD','Earnings from booking ##1000017 for Ford Mustang GT Premium 2024',NULL,'booking-completed','2025-11-06 21:14:21','2025-11-06 21:14:21'),(11,7,21,90.00,18.00,72.00,72.00,'USD','Earnings from booking ##1000022 for Ferrari Roma Spider 2024',NULL,'booking-completed','2025-11-10 21:14:21','2025-11-10 21:14:21'),(12,9,22,588.00,117.60,470.40,470.40,'USD','Earnings from booking ##1000023 for McLaren Artura Spider 2024',NULL,'booking-completed','2025-10-28 21:14:21','2025-10-28 21:14:21'),(13,5,23,43.20,8.64,34.56,34.56,'USD','Earnings from booking ##1000024 for Kia Sportage SX-Turbo AWD 2024',NULL,'booking-completed','2025-11-14 21:14:21','2025-11-14 21:14:21'),(14,15,24,86.40,17.28,69.12,69.12,'USD','Earnings from booking ##1000025 for Porsche Taycan Turbo S Cross Turismo 2024',NULL,'booking-completed','2025-10-03 21:14:21','2025-10-03 21:14:21'),(15,15,25,51.00,10.20,40.80,109.92,'USD','Earnings from booking ##1000026 for McLaren GT Luxe 2024',NULL,'booking-completed','2025-10-08 21:14:21','2025-10-08 21:14:21'),(16,2,26,294.00,58.80,235.20,451.20,'USD','Earnings from booking ##1000027 for Infiniti QX60 Autograph AWD 2024',NULL,'booking-completed','2025-09-29 21:14:21','2025-09-29 21:14:21'),(17,18,27,426.60,85.32,341.28,341.28,'USD','Earnings from booking ##1000028 for Honda CR-V Touring Hybrid AWD 2024',NULL,'booking-completed','2025-10-16 21:14:21','2025-10-16 21:14:21'),(18,18,32,49.50,9.90,39.60,380.88,'USD','Earnings from booking ##1000033 for Aston Martin Vantage F1 Edition 2024',NULL,'booking-completed','2025-11-17 21:14:21','2025-11-17 21:14:21'),(19,3,33,215.00,43.00,172.00,496.00,'USD','Earnings from booking ##1000034 for Volkswagen Tiguan SEL R-Line 2024',NULL,'booking-completed','2025-11-16 21:14:21','2025-11-16 21:14:21'),(20,13,35,380.00,76.00,304.00,304.00,'USD','Earnings from booking ##1000036 for Fiat 500X Sport AWD 2024',NULL,'booking-completed','2025-11-14 21:14:21','2025-11-14 21:14:21'),(21,15,37,106.00,21.20,84.80,194.72,'USD','Earnings from booking ##1000038 for Lamborghini Huracán EVO 2024',NULL,'booking-completed','2025-11-10 21:14:21','2025-11-10 21:14:21'),(22,20,42,102.00,20.40,81.60,173.76,'USD','Earnings from booking ##1000043 for Porsche Cayenne Turbo GT 2024',NULL,'booking-completed','2025-11-10 21:14:21','2025-11-10 21:14:21'),(23,2,43,224.00,44.80,179.20,630.40,'USD','Earnings from booking ##1000044 for Rolls-Royce Cullinan Black Badge 2024',NULL,'booking-completed','2025-11-13 21:14:21','2025-11-13 21:14:21'),(24,13,44,532.00,106.40,425.60,729.60,'USD','Earnings from booking ##1000045 for Fiat 500X Sport AWD 2024',NULL,'booking-completed','2025-11-15 21:14:21','2025-11-15 21:14:21'),(25,2,46,56.00,11.20,44.80,675.20,'USD','Earnings from booking ##1000047 for Rolls-Royce Cullinan Black Badge 2024',NULL,'booking-completed','2025-11-16 21:14:21','2025-11-16 21:14:21');
/*!40000 ALTER TABLE `cr_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_withdrawals`
--

DROP TABLE IF EXISTS `cr_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `fee` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `current_balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_withdrawals`
--

LOCK TABLES `cr_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `cr_customer_withdrawals` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customers`
--

DROP TABLE IF EXISTS `cr_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `is_verified` tinyint(1) NOT NULL DEFAULT '0',
  `verified_at` timestamp NULL DEFAULT NULL,
  `verified_by` bigint unsigned DEFAULT NULL,
  `verification_note` text COLLATE utf8mb4_unicode_ci,
  `vendor_verified_at` datetime DEFAULT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `bank_info` json DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customers`
--

LOCK TABLES `cr_customers` WRITE;
/*!40000 ALTER TABLE `cr_customers` DISABLE KEYS */;
INSERT INTO `cr_customers` VALUES (1,'Elite Auto Group','zemlak.clyde@terry.com','$2y$12$/0LwpWiKgAfdVzOKq6hAz.CDjSy2Ur7CkAE5pcovfXn7iDkaEF5nu','customers/12.jpg','+16236708309','+16236708309',NULL,'published',NULL,'2025-11-18 04:13:27',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',1,1,'2025-09-03 21:36:09',1,'Authorized car dealer','2025-08-26 15:39:02',0.00,NULL,NULL),(2,'Premier Motors','daphney.prosacco@white.com','$2y$12$0z0J28r2mRdfal9pLnnzO.AeE5.8W/CxAXT9M7f3allrhgAmFeUFy','customers/13.jpg','+19493624202','+19493624202',NULL,'published',NULL,'2025-11-18 04:13:28',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-06-11 13:30:35',1,'Premium vendor account','2024-12-26 18:50:57',675.20,NULL,NULL),(3,'Luxury Car Rentals','larkin.nadia@beer.com','$2y$12$jKkDhbxGKd9G6B2BPN2cteaJ0VMJo/SVpFcWwYm6su7wXBFTjW/kq','customers/14.jpg','+15807861518','+15807861518',NULL,'published',NULL,'2025-11-18 04:13:28',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-10-25 21:24:24',1,'Certified dealer','2025-05-05 21:59:16',496.00,NULL,NULL),(4,'City Drive Solutions','maria86@fisher.com','$2y$12$nfGwFZ9FcI/ljmeeUJZh6.0RHsfg/FmKCU8dwAEX0bgYCnoRdS5CW','customers/15.jpg','+15598599831','+15598599831',NULL,'published',NULL,'2025-11-18 04:13:28',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',1,1,'2025-06-27 10:08:59',1,'Premium vendor account','2025-03-12 15:09:34',0.00,NULL,NULL),(5,'Express Auto Dealers','monty.schumm@pfannerstill.com','$2y$12$QRHdb0RvdHHhOY6nA.iW/.swpA6yEZIBbMxnLsx3x8w8tcCME.hse','customers/16.jpg','+12108451046','+12108451046',NULL,'published',NULL,'2025-11-18 04:13:28',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-08-31 17:45:51',1,'Premium vendor account','2025-01-20 11:54:30',34.56,NULL,NULL),(6,'Summit Car Company','wanda81@parisian.org','$2y$12$pWxI326yF0VSI3sktSHbK.hpCVlJCeGMWfWtJG3o.CmaUP7KoUECS','customers/17.jpg','+14803910618','+14803910618',NULL,'published',NULL,'2025-11-18 04:13:29',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',1,1,'2025-07-20 00:36:32',1,'Verified dealership','2025-11-06 08:42:18',0.00,NULL,NULL),(7,'Horizon Automotive','jacobson.glen@trantow.com','$2y$12$ZhPxUz.H6G8.Hx.iWXdFLemadZ.DEUhmaxLUjr10Ma7CwipB/VfRq','customers/18.jpg','+13515677647','+13515677647',NULL,'published',NULL,'2025-11-18 04:13:29',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-06-22 08:18:07',1,'Authorized car dealer','2025-02-11 11:03:34',72.00,NULL,NULL),(8,'Prestige Vehicles','brendon.grimes@ziemann.com','$2y$12$V7DgXjYifOplXdRrgJUz/O7929fMy5Yt9vknhSDP3uXoZfSowanQq','customers/19.jpg','+16313869887','+16313869887',NULL,'published',NULL,'2025-11-18 04:13:29',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',1,1,'2025-08-22 13:50:14',1,'Trusted automotive partner','2025-02-25 14:59:53',0.00,NULL,NULL),(9,'Metro Car Center','heaney.tyree@pfannerstill.com','$2y$12$z/SQP2MDbQXeB8z8.TpB3unZrKyYN9T0Zw20gDepe/sI7kz9ezqNm','customers/20.jpg','+14019450659','+14019450659',NULL,'published',NULL,'2025-11-18 04:13:29',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-06-27 16:59:23',1,'Certified dealer','2024-12-08 10:57:49',470.40,NULL,NULL),(10,'Global Auto Partners','emilia.bauch@runolfsdottir.info','$2y$12$J84zrHfB5k8Xo1BAiWZxmOSI5usoRIMt6.q6Ahzg4mR/rK2Fp8AB.','customers/21.jpg','+16464711386','+16464711386',NULL,'published',NULL,'2025-11-18 04:13:29',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-08-14 04:40:58',1,'Certified dealer','2025-09-05 06:51:19',336.00,NULL,NULL),(11,'Royal Motors Group','ucasper@hickle.com','$2y$12$JO7euCvh/m.WffDIn.xejuNFYf0HXskdEhKvmWqlDejjGBpUdqm02','customers/22.jpg','+12767077214','+12767077214',NULL,'published',NULL,'2025-11-18 04:13:30',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',1,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(12,'Diamond Car Dealers','briana.rolfson@brekke.com','$2y$12$.3.ybAKo8sbspzb02yw0xe1VcOfBYouQwSbKsAvfmWKw8gnTvvsyK','customers/23.jpg','+14426293440','+14426293440',NULL,'published',NULL,'2025-11-18 04:13:30',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-08-14 18:33:01',1,'Trusted automotive partner','2025-08-24 11:29:21',281.60,NULL,NULL),(13,'Pacific Auto Sales','schmidt.raoul@dicki.com','$2y$12$2mMLzUmXplawgwDDdtdnT.nNTiDyQBzFpwQWbuD2oCgpEQ/LXmXmi','customers/24.jpg','+17817058784','+17817058784',NULL,'published',NULL,'2025-11-18 04:13:30',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-07-25 17:15:17',1,'Premium vendor account','2025-01-25 21:11:13',729.60,NULL,NULL),(14,'Mountain View Motors','wilderman.frederique@cormier.com','$2y$12$cU.UPc6r.0hWS/YMCiNxfeftuQBuIYPbWTZAYVg43MijPunANlMZy','customers/25.jpg','+13155258343','+13155258343',NULL,'published',NULL,'2025-11-18 04:13:30',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',1,1,'2025-10-30 18:05:46',1,'Trusted automotive partner','2025-09-29 09:02:31',0.00,NULL,NULL),(15,'Coastal Car Company','welch.emmitt@hansen.biz','$2y$12$o4X0bznINTt7UPEVcgSp.u/VhfgxV8XYY9ha3TnIteJDEDG5eaALa','customers/26.jpg','+14588417784','+14588417784',NULL,'published',NULL,'2025-11-18 04:13:31',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,0,NULL,NULL,NULL,NULL,194.72,NULL,NULL),(16,'Central Auto Hub','stanton.amina@blick.biz','$2y$12$H9hTAXJdu8l4X3RW.rKFIe1gbTSXr9PQuVoscMPqW8PQbtSEto8Zi','customers/27.jpg','+14804395913','+14804395913',NULL,'published',NULL,'2025-11-18 04:13:31',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,0,NULL,NULL,NULL,NULL,176.40,NULL,NULL),(17,'Victory Automotive','oluettgen@kuhn.com','$2y$12$lEFh3hQ1jb8Kk97inh01r.nPh/2K22TojHx73avDsAPSkazZ98nyq','customers/28.jpg','+14052586176','+14052586176',NULL,'published',NULL,'2025-11-18 04:13:31',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-07-18 17:50:46',1,'Authorized car dealer','2025-01-12 10:45:06',75.60,NULL,NULL),(18,'Alliance Car Group','tberge@barton.com','$2y$12$Ip561F00uWbabr93rBHHAO7VzkvdRVwo5KGFf7cQU8McXgHd31WSa','customers/29.jpg','+13612495271','+13612495271',NULL,'published',NULL,'2025-11-18 04:13:31',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-10-22 01:50:15',1,'Verified dealership','2025-10-02 15:41:40',380.88,NULL,NULL),(19,'Phoenix Motors','lucio67@wehner.com','$2y$12$ocxn.It6WamYwS8Az4W8M.xRG5P/CfNCHBXJRHP3Am34eaJt9C7Be','customers/30.jpg','+14328758357','+14328758357',NULL,'published',NULL,'2025-11-18 04:13:31',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-06-08 17:41:27',1,'Trusted automotive partner','2025-01-27 18:28:38',118.40,NULL,NULL),(20,'Sterling Auto Sales','gutkowski.serenity@howe.net','$2y$12$cvQuFmQJ6prnn0qke.dGMuvXYTvqYGYN0yNh26baZzP4cprnvR8hi','customers/31.jpg','+16788297868','+16788297868',NULL,'published',NULL,'2025-11-18 04:13:32',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-10-04 12:20:21',1,'Verified dealership','2025-10-12 01:38:47',173.76,NULL,NULL),(21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','$2y$12$Bvj8wseOsziW8JlKrBfP4.jTgaURAqK7grEWrCpVprHR0Vcev9.OG','customers/1.jpg','+13615551428','+13615551428',NULL,'published',NULL,'2025-11-18 04:13:32',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','$2y$12$MnHeIV1EGGnQ0KdNImhex.8LKHatpM8Koc8LodL9V7DTE9mshAUP.','customers/2.jpg','+18109804543','+18109804543',NULL,'published',NULL,'2025-11-18 04:13:32',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,1,'2025-08-11 02:49:58',1,'Documents verified successfully',NULL,0.00,NULL,NULL),(23,'Ignacio Kris I','hodkiewicz.dayana@example.com','$2y$12$brEFyjyQVMa6pJ3hxTqQXe4l7bCar3TLWHKSedD3l9akLsYfbeFai','customers/3.jpg','+12694180562','+12694180562',NULL,'published',NULL,'2025-11-18 04:13:32',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,1,'2025-05-20 14:29:25',1,'Verified customer - regular client',NULL,0.00,NULL,NULL),(24,'Shanie Ritchie I','anais69@example.org','$2y$12$Xf.bv9EOl5OzLC7JQakDMuIdOhyLncafXjrXVZg9GfvLVc7xVt.Xq','customers/4.jpg','+18458662737','+18458662737',NULL,'published',NULL,'2025-11-18 04:13:33',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(25,'Sydnie Crooks','everardo.cole@example.com','$2y$12$qb1QeaxFYcOpuJOm8q89A.7OQiMG8vGWmkQVkv.0cG3F2YzkFuWzu','customers/5.jpg','+14793463231','+14793463231',NULL,'published',NULL,'2025-11-18 04:13:33',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(26,'Dr. Rozella Fahey','oboyer@example.org','$2y$12$UnIIKiyWBlR5hiTHf6EvXeY2HDwQGYeipYeimy1Yl42fOnmBww1CG','customers/6.jpg','+19167009366','+19167009366',NULL,'published',NULL,'2025-11-18 04:13:33',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','$2y$12$n3vghy1eNIfbDRm8SSivBekw0WdBP8xvVTRPKKzKzWBrCCEVE1mZ2','customers/7.jpg','+12059822297','+12059822297',NULL,'published',NULL,'2025-11-18 04:13:33',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(28,'Alvena Will','cummerata.oda@example.org','$2y$12$qfivEc9PWKS/bZ2sYd/zC.ZQ4fGINrIsl5lzozfLtiOhYN923L.za','customers/8.jpg','+14693772940','+14693772940',NULL,'published',NULL,'2025-11-18 04:13:33',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(29,'Rylee Bogan','rickey.gleichner@example.org','$2y$12$1Y3L9/sn7mlKIg1ECBR/d.YtgXBAKwNMvnqwP58CYXCv6LSiwiu.m','customers/9.jpg','+13412597092','+13412597092',NULL,'published',NULL,'2025-11-18 04:13:34',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,1,'2025-06-22 15:21:50',1,'Trusted customer',NULL,0.00,NULL,NULL),(30,'Pat Boyle','sonya.ruecker@example.net','$2y$12$QaHUgTA1mEaluH/zx/bs8uKSXE6gQnIgIWFBZOgqGzOT3joe.Wy3i','customers/10.jpg','+17409015709','+17409015709',NULL,'published',NULL,'2025-11-18 04:13:34',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,1,'2025-07-03 23:44:40',1,'Documents verified successfully',NULL,0.00,NULL,NULL),(31,'Cielo Cruickshank V','customer@botble.com','$2y$12$4o6dGHvHNsfZCT/jOBG.pOqbrD/JG3YWF5RjQ2bGd8x4nlEG3BDhm','customers/2.jpg','+15126273228','+15126273228',NULL,'published',NULL,'2025-11-18 04:13:34',NULL,'2025-11-17 21:13:34','2025-11-17 21:13:34',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(32,'Idella Harber','vendor@botble.com','$2y$12$lC48iCQltmkCyJUQE5CHtuUmIoxv.e.bviNQ79hWyPv2I828uo7Ue','customers/2.jpg','+15863859962','+15863859962',NULL,'published',NULL,'2025-11-18 04:13:34',NULL,'2025-11-17 21:13:34','2025-11-17 21:14:21',1,1,'2025-08-25 12:15:03',1,'Verified vendor account','2025-08-27 22:57:59',155.52,NULL,NULL);
/*!40000 ALTER TABLE `cr_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_invoice_items`
--

DROP TABLE IF EXISTS `cr_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_invoice_items`
--

LOCK TABLES `cr_invoice_items` WRITE;
/*!40000 ALTER TABLE `cr_invoice_items` DISABLE KEYS */;
INSERT INTO `cr_invoice_items` VALUES (1,1,'Toyota Camry XLE Hybrid 2024','',1,450.00,0.00,0.00,450.00,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(2,2,'Bugatti Chiron Super Sport 2024','',1,270.00,0.00,0.00,270.00,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(3,3,'Bentley Continental GT V8 2024','',1,90.00,0.00,0.00,90.00,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(4,4,'Honda CR-V Touring Hybrid AWD 2024','',1,553.00,0.00,0.00,553.00,'2025-11-17 21:14:20','2025-11-17 21:14:20'),(5,5,'Mazda MX-5 Miata Grand Touring 2024','',1,148.00,0.00,0.00,148.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(6,6,'Toyota RAV4 Prime XSE AWD 2024','',1,352.00,0.00,0.00,352.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(7,7,'Genesis Electrified GV70 Advanced AWD 2024','',1,128.00,0.00,0.00,128.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(8,8,'Hyundai Sonata N Line 2024','',1,288.00,0.00,0.00,288.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(9,9,'Ford Explorer ST 4WD 2024','',1,266.00,0.00,0.00,266.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(10,10,'Mitsubishi Outlander SEL S-AWC 2024','',1,56.00,0.00,0.00,56.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(11,11,'Volvo S90 B6 Ultimate AWD 2024','',1,216.00,0.00,0.00,216.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(12,12,'Chevrolet Corvette Z06 3LZ 2024','',1,420.00,0.00,0.00,420.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(13,13,'Bentley Continental GT V8 2024','',1,315.00,0.00,0.00,315.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(14,14,'Maserati Ghibli Modena 2024','',1,105.00,0.00,0.00,105.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(15,15,'Land Rover Defender 110 X 2024','',1,192.00,0.00,0.00,192.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(16,16,'Ford Mustang GT Premium 2024','',1,245.00,0.00,0.00,245.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(17,17,'Mercedes-Benz GLC 300 4MATIC 2024','',1,195.00,0.00,0.00,195.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(18,18,'Nissan Rogue Platinum AWD 2024','',1,70.00,0.00,0.00,70.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(19,19,'BMW X7 xDrive40i M Sport 2024','',1,66.00,0.00,0.00,66.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(20,20,'Lamborghini Urus Performante 2024','',1,352.00,0.00,0.00,352.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(21,21,'Ferrari Roma Spider 2024','',1,90.00,0.00,0.00,90.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(22,22,'McLaren Artura Spider 2024','',1,588.00,0.00,0.00,588.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(23,23,'Kia Sportage SX-Turbo AWD 2024','',1,48.00,0.00,0.00,48.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(24,24,'Porsche Taycan Turbo S Cross Turismo 2024','',1,96.00,0.00,0.00,96.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(25,25,'McLaren GT Luxe 2024','',1,51.00,0.00,0.00,51.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(26,26,'Infiniti QX60 Autograph AWD 2024','',1,294.00,0.00,0.00,294.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(27,27,'Honda CR-V Touring Hybrid AWD 2024','',1,474.00,0.00,0.00,474.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(28,28,'Audi RS Q8 quattro 2024','',1,525.00,0.00,0.00,525.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(29,29,'BMW X7 xDrive40i M Sport 2024','',1,33.00,0.00,0.00,33.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(30,30,'Alfa Romeo Stelvio Veloce AWD 2024','',1,378.00,0.00,0.00,378.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(31,31,'Ford Mustang GT Premium 2024','',1,105.00,0.00,0.00,105.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(32,32,'Aston Martin Vantage F1 Edition 2024','',1,55.00,0.00,0.00,55.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(33,33,'Volkswagen Tiguan SEL R-Line 2024','',1,215.00,0.00,0.00,215.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(34,34,'Ferrari Roma Spider 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(35,35,'Fiat 500X Sport AWD 2024','',1,380.00,0.00,0.00,380.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(36,36,'Ferrari Roma Spider 2024','',1,90.00,0.00,0.00,90.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(37,37,'Lamborghini Huracán EVO 2024','',1,106.00,0.00,0.00,106.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(38,38,'Ford Explorer ST 4WD 2024','',1,114.00,0.00,0.00,114.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(39,39,'Alfa Romeo Stelvio Veloce AWD 2024','',1,126.00,0.00,0.00,126.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(40,40,'BMW X7 xDrive40i M Sport 2024','',1,33.00,0.00,0.00,33.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(41,41,'GMC Sierra 1500 Denali 2024','',1,623.00,0.00,0.00,623.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(42,42,'Porsche Cayenne Turbo GT 2024','',1,102.00,0.00,0.00,102.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(43,43,'Rolls-Royce Cullinan Black Badge 2024','',1,224.00,0.00,0.00,224.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(44,44,'Fiat 500X Sport AWD 2024','',1,532.00,0.00,0.00,532.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(45,45,'Volvo S90 B6 Ultimate AWD 2024','',1,144.00,0.00,0.00,144.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(46,46,'Rolls-Royce Cullinan Black Badge 2024','',1,56.00,0.00,0.00,56.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(47,47,'Mercedes-Benz C300 4MATIC 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(48,48,'Lexus RX 350 F Sport Handling AWD 2024','',1,406.00,0.00,0.00,406.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(49,49,'Audi A4 Premium Plus quattro 2024','',1,375.00,0.00,0.00,375.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(50,50,'Subaru Outback Limited XT 2024','',1,308.00,0.00,0.00,308.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(51,51,'Toyota RAV4 Prime XSE AWD 2024','',1,264.00,0.00,0.00,264.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(52,52,'BMW X5 xDrive40i M Sport 2024','',1,441.00,0.00,0.00,441.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(53,53,'Volvo S90 B6 Ultimate AWD 2024','',1,504.00,0.00,0.00,504.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(54,54,'Mercedes-Maybach S 580 4MATIC 2024','',1,434.00,0.00,0.00,434.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(55,55,'Lincoln Aviator Reserve AWD 2024','',1,504.00,0.00,0.00,504.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(56,56,'Infiniti Q50 Red Sport 400 AWD 2024','',1,276.00,0.00,0.00,276.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(57,57,'BMW 330i xDrive M Sport 2024','',1,275.00,0.00,0.00,275.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(58,58,'Range Rover Sport HSE Dynamic 2024','',1,108.00,0.00,0.00,108.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(59,59,'Genesis GV70 2.5T Sport AWD 2024','',1,644.00,0.00,0.00,644.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(60,60,'Lamborghini Urus Performante 2024','',1,616.00,0.00,0.00,616.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(61,61,'Lamborghini Huracán EVO 2024','',1,106.00,0.00,0.00,106.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(62,62,'Mini Cooper S Hardtop 2024','',1,296.00,0.00,0.00,296.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(63,63,'Toyota Corolla Hybrid LE 2024','',1,552.00,0.00,0.00,552.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(64,64,'Jaguar XF P300 R-Dynamic S AWD 2024','',1,84.00,0.00,0.00,84.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(65,65,'Jaguar XF P300 R-Dynamic S AWD 2024','',1,168.00,0.00,0.00,168.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(66,66,'Porsche Taycan Turbo S Cross Turismo 2024','',1,96.00,0.00,0.00,96.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(67,67,'Bentley Bentayga S V8 2024','',1,297.00,0.00,0.00,297.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(68,68,'BMW XM Label Red 2024','',1,462.00,0.00,0.00,462.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(69,69,'Aston Martin DBX707 2024','',1,186.00,0.00,0.00,186.00,'2025-11-17 21:14:21','2025-11-17 21:14:21'),(70,70,'BMW XM Label Red 2024','',1,462.00,0.00,0.00,462.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(71,71,'Fiat 500X Sport AWD 2024','',1,456.00,0.00,0.00,456.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(72,72,'Chevrolet Blazer RS AWD 2024','',1,468.00,0.00,0.00,468.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(73,73,'Chrysler Pacifica Pinnacle AWD 2024','',1,170.00,0.00,0.00,170.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(74,74,'Chevrolet Corvette Z06 3LZ 2024','',1,420.00,0.00,0.00,420.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(75,75,'BMW M5 Competition xDrive 2024','',1,329.00,0.00,0.00,329.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(76,76,'Fiat 500X Sport AWD 2024','',1,76.00,0.00,0.00,76.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(77,77,'Lucid Air Grand Touring Performance 2024','',1,330.00,0.00,0.00,330.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(78,78,'McLaren 720S Spider 2024','',1,63.00,0.00,0.00,63.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(79,79,'Pagani Huayra Roadster BC 2024','',1,300.00,0.00,0.00,300.00,'2025-11-17 21:14:22','2025-11-17 21:14:22'),(80,80,'Audi RS Q8 quattro 2024','',1,450.00,0.00,0.00,450.00,'2025-11-17 21:14:22','2025-11-17 21:14:22');
/*!40000 ALTER TABLE `cr_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_invoices`
--

DROP TABLE IF EXISTS `cr_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` double NOT NULL,
  `tax_amount` double NOT NULL DEFAULT '0',
  `discount_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_invoices_code_unique` (`code`),
  KEY `cr_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `cr_invoices_payment_id_index` (`payment_id`),
  KEY `cr_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_invoices`
--

LOCK TABLES `cr_invoices` WRITE;
/*!40000 ALTER TABLE `cr_invoices` DISABLE KEYS */;
INSERT INTO `cr_invoices` VALUES (1,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',1,1,'Botble\\CarRentals\\Models\\Booking',1,'INV-1',450,45,0,450,'pending',NULL,'2025-10-13 21:14:20','2025-11-17 21:14:20',4),(2,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',2,1,'Botble\\CarRentals\\Models\\Booking',2,'INV-2',270,0,0,270,'completed','2025-11-17 21:14:20','2025-10-07 21:14:20','2025-11-17 21:14:20',2),(3,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',3,1,'Botble\\CarRentals\\Models\\Booking',3,'INV-3',90,0,0,90,'completed','2025-11-17 21:14:20','2025-09-29 21:14:20','2025-11-17 21:14:20',3),(4,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',4,1,'Botble\\CarRentals\\Models\\Booking',4,'INV-4',553,55.3,0,553,'pending',NULL,'2025-10-13 21:14:20','2025-11-17 21:14:20',18),(5,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',5,1,'Botble\\CarRentals\\Models\\Booking',5,'INV-5',148,0,0,148,'completed','2025-11-17 21:14:21','2025-09-18 21:14:20','2025-11-17 21:14:21',19),(6,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',6,1,'Botble\\CarRentals\\Models\\Booking',6,'INV-6',352,0,0,352,'completed','2025-11-17 21:14:21','2025-10-11 21:14:21','2025-11-17 21:14:21',12),(7,27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',7,1,'Botble\\CarRentals\\Models\\Booking',7,'INV-7',128,12.8,0,128,'completed','2025-11-17 21:14:21','2025-10-02 21:14:21','2025-11-17 21:14:21',20),(8,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',8,1,'Botble\\CarRentals\\Models\\Booking',8,'INV-8',288,28.8,0,288,'completed','2025-11-17 21:14:21','2025-11-08 21:14:21','2025-11-17 21:14:21',NULL),(9,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',9,1,'Botble\\CarRentals\\Models\\Booking',9,'INV-9',266,0,0,266,'pending',NULL,'2025-11-14 21:14:21','2025-11-17 21:14:21',NULL),(10,26,'Dr. Rozella Fahey','oboyer@example.org','+19167009366',10,1,'Botble\\CarRentals\\Models\\Booking',10,'INV-10',56,0,0,56,'completed','2025-11-17 21:14:21','2025-10-25 21:14:21','2025-11-17 21:14:21',NULL),(11,29,'Rylee Bogan','rickey.gleichner@example.org','+13412597092',11,1,'Botble\\CarRentals\\Models\\Booking',11,'INV-11',216,21.6,0,216,'completed','2025-11-17 21:14:21','2025-11-11 21:14:21','2025-11-17 21:14:21',32),(12,26,'Dr. Rozella Fahey','oboyer@example.org','+19167009366',12,1,'Botble\\CarRentals\\Models\\Booking',12,'INV-12',420,0,0,420,'completed','2025-11-17 21:14:21','2025-10-09 21:14:21','2025-11-17 21:14:21',10),(13,29,'Rylee Bogan','rickey.gleichner@example.org','+13412597092',13,1,'Botble\\CarRentals\\Models\\Booking',13,'INV-13',315,0,0,315,'completed','2025-11-17 21:14:21','2025-11-03 21:14:21','2025-11-17 21:14:21',3),(14,26,'Dr. Rozella Fahey','oboyer@example.org','+19167009366',14,1,'Botble\\CarRentals\\Models\\Booking',14,'INV-14',105,10.5,0,105,'completed','2025-11-17 21:14:21','2025-10-06 21:14:21','2025-11-17 21:14:21',17),(15,28,'Alvena Will','cummerata.oda@example.org','+14693772940',15,1,'Botble\\CarRentals\\Models\\Booking',15,'INV-15',192,0,0,192,'pending',NULL,'2025-10-16 21:14:21','2025-11-17 21:14:21',5),(16,24,'Shanie Ritchie I','anais69@example.org','+18458662737',16,1,'Botble\\CarRentals\\Models\\Booking',16,'INV-16',245,24.5,0,245,'completed','2025-11-17 21:14:21','2025-11-06 21:14:21','2025-11-17 21:14:21',16),(17,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',17,1,'Botble\\CarRentals\\Models\\Booking',17,'INV-17',195,0,0,195,'pending',NULL,'2025-11-14 21:14:21','2025-11-17 21:14:21',3),(18,29,'Rylee Bogan','rickey.gleichner@example.org','+13412597092',18,1,'Botble\\CarRentals\\Models\\Booking',18,'INV-18',70,7,0,70,'completed','2025-11-17 21:14:21','2025-10-06 21:14:21','2025-11-17 21:14:21',NULL),(19,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',19,1,'Botble\\CarRentals\\Models\\Booking',19,'INV-19',66,0,0,66,'completed','2025-11-17 21:14:21','2025-11-12 21:14:21','2025-11-17 21:14:21',NULL),(20,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',20,1,'Botble\\CarRentals\\Models\\Booking',20,'INV-20',352,0,0,352,'completed','2025-11-17 21:14:21','2025-10-15 21:14:21','2025-11-17 21:14:21',NULL),(21,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',21,1,'Botble\\CarRentals\\Models\\Booking',21,'INV-21',90,0,0,90,'completed','2025-11-17 21:14:21','2025-11-10 21:14:21','2025-11-17 21:14:21',7),(22,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',22,1,'Botble\\CarRentals\\Models\\Booking',22,'INV-22',588,0,0,588,'completed','2025-11-17 21:14:21','2025-10-28 21:14:21','2025-11-17 21:14:21',9),(23,28,'Alvena Will','cummerata.oda@example.org','+14693772940',23,1,'Botble\\CarRentals\\Models\\Booking',23,'INV-23',48,4.8,0,48,'completed','2025-11-17 21:14:21','2025-11-14 21:14:21','2025-11-17 21:14:21',5),(24,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',24,1,'Botble\\CarRentals\\Models\\Booking',24,'INV-24',96,9.6,0,96,'completed','2025-11-17 21:14:21','2025-10-03 21:14:21','2025-11-17 21:14:21',15),(25,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',25,1,'Botble\\CarRentals\\Models\\Booking',25,'INV-25',51,0,0,51,'completed','2025-11-17 21:14:21','2025-10-08 21:14:21','2025-11-17 21:14:21',15),(26,23,'Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',26,1,'Botble\\CarRentals\\Models\\Booking',26,'INV-26',294,0,0,294,'completed','2025-11-17 21:14:21','2025-09-29 21:14:21','2025-11-17 21:14:21',2),(27,26,'Dr. Rozella Fahey','oboyer@example.org','+19167009366',27,1,'Botble\\CarRentals\\Models\\Booking',27,'INV-27',474,47.4,0,474,'completed','2025-11-17 21:14:21','2025-10-16 21:14:21','2025-11-17 21:14:21',18),(28,24,'Shanie Ritchie I','anais69@example.org','+18458662737',28,1,'Botble\\CarRentals\\Models\\Booking',28,'INV-28',525,52.5,0,525,'completed','2025-11-17 21:14:21','2025-10-18 21:14:21','2025-11-17 21:14:21',NULL),(29,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',29,1,'Botble\\CarRentals\\Models\\Booking',29,'INV-29',33,3.3,0,33,'pending',NULL,'2025-09-27 21:14:21','2025-11-17 21:14:21',NULL),(30,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',30,1,'Botble\\CarRentals\\Models\\Booking',30,'INV-30',378,0,0,378,'completed','2025-11-17 21:14:21','2025-10-02 21:14:21','2025-11-17 21:14:21',NULL),(31,23,'Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',31,1,'Botble\\CarRentals\\Models\\Booking',31,'INV-31',105,0,0,105,'pending',NULL,'2025-11-13 21:14:21','2025-11-17 21:14:21',16),(32,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',32,1,'Botble\\CarRentals\\Models\\Booking',32,'INV-32',55,5.5,0,55,'completed','2025-11-17 21:14:21','2025-11-17 21:14:21','2025-11-17 21:14:21',18),(33,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',33,1,'Botble\\CarRentals\\Models\\Booking',33,'INV-33',215,0,0,215,'completed','2025-11-17 21:14:21','2025-11-16 21:14:21','2025-11-17 21:14:21',3),(34,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',34,1,'Botble\\CarRentals\\Models\\Booking',34,'INV-34',180,0,0,180,'pending',NULL,'2025-11-14 21:14:21','2025-11-17 21:14:21',7),(35,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',35,1,'Botble\\CarRentals\\Models\\Booking',35,'INV-35',380,0,0,380,'completed','2025-11-17 21:14:21','2025-11-14 21:14:21','2025-11-17 21:14:21',13),(36,24,'Shanie Ritchie I','anais69@example.org','+18458662737',36,1,'Botble\\CarRentals\\Models\\Booking',36,'INV-36',90,0,0,90,'pending',NULL,'2025-11-15 21:14:21','2025-11-17 21:14:21',7),(37,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',37,1,'Botble\\CarRentals\\Models\\Booking',37,'INV-37',106,0,0,106,'completed','2025-11-17 21:14:21','2025-11-10 21:14:21','2025-11-17 21:14:21',15),(38,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',38,1,'Botble\\CarRentals\\Models\\Booking',38,'INV-38',114,0,0,114,'completed','2025-11-17 21:14:21','2025-11-11 21:14:21','2025-11-17 21:14:21',NULL),(39,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',39,1,'Botble\\CarRentals\\Models\\Booking',39,'INV-39',126,0,0,126,'completed','2025-11-17 21:14:21','2025-11-14 21:14:21','2025-11-17 21:14:21',NULL),(40,24,'Shanie Ritchie I','anais69@example.org','+18458662737',40,1,'Botble\\CarRentals\\Models\\Booking',40,'INV-40',33,0,0,33,'pending',NULL,'2025-11-16 21:14:21','2025-11-17 21:14:21',NULL),(41,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',41,1,'Botble\\CarRentals\\Models\\Booking',41,'INV-41',623,0,0,623,'pending',NULL,'2025-11-15 21:14:21','2025-11-17 21:14:21',13),(42,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',42,1,'Botble\\CarRentals\\Models\\Booking',42,'INV-42',102,0,0,102,'completed','2025-11-17 21:14:21','2025-11-10 21:14:21','2025-11-17 21:14:21',20),(43,23,'Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',43,1,'Botble\\CarRentals\\Models\\Booking',43,'INV-43',224,0,0,224,'completed','2025-11-17 21:14:21','2025-11-13 21:14:21','2025-11-17 21:14:21',2),(44,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',44,1,'Botble\\CarRentals\\Models\\Booking',44,'INV-44',532,0,0,532,'completed','2025-11-17 21:14:21','2025-11-15 21:14:21','2025-11-17 21:14:21',13),(45,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',45,1,'Botble\\CarRentals\\Models\\Booking',45,'INV-45',144,0,0,144,'pending',NULL,'2025-11-10 21:14:21','2025-11-17 21:14:21',32),(46,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',46,1,'Botble\\CarRentals\\Models\\Booking',46,'INV-46',56,0,0,56,'completed','2025-11-17 21:14:21','2025-11-16 21:14:21','2025-11-17 21:14:21',2),(47,29,'Rylee Bogan','rickey.gleichner@example.org','+13412597092',47,1,'Botble\\CarRentals\\Models\\Booking',47,'INV-47',180,0,0,180,'pending',NULL,'2025-11-11 21:14:21','2025-11-17 21:14:21',14),(48,27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',48,1,'Botble\\CarRentals\\Models\\Booking',48,'INV-48',406,0,0,406,'completed','2025-11-17 21:14:21','2025-11-13 21:14:21','2025-11-17 21:14:21',NULL),(49,24,'Shanie Ritchie I','anais69@example.org','+18458662737',49,1,'Botble\\CarRentals\\Models\\Booking',49,'INV-49',375,0,0,375,'pending',NULL,'2025-11-10 21:14:21','2025-11-17 21:14:21',NULL),(50,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',50,1,'Botble\\CarRentals\\Models\\Booking',50,'INV-50',308,0,0,308,'completed','2025-11-17 21:14:21','2025-11-10 21:14:21','2025-11-17 21:14:21',NULL),(51,27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',51,1,'Botble\\CarRentals\\Models\\Booking',51,'INV-51',264,26.4,0,264,'pending',NULL,'2025-12-07 21:14:21','2025-11-17 21:14:21',12),(52,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',52,1,'Botble\\CarRentals\\Models\\Booking',52,'INV-52',441,0,0,441,'pending',NULL,'2025-12-14 21:14:21','2025-11-17 21:14:21',5),(53,22,'Dr. Cameron Yost','runolfsdottir.noe@example.com','+18109804543',53,1,'Botble\\CarRentals\\Models\\Booking',53,'INV-53',504,50.4,0,504,'pending',NULL,'2025-12-14 21:14:21','2025-11-17 21:14:21',32),(54,27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',54,1,'Botble\\CarRentals\\Models\\Booking',54,'INV-54',434,0,0,434,'pending',NULL,'2025-11-18 21:14:21','2025-11-17 21:14:21',14),(55,28,'Alvena Will','cummerata.oda@example.org','+14693772940',55,1,'Botble\\CarRentals\\Models\\Booking',55,'INV-55',504,0,0,504,'pending',NULL,'2025-12-16 21:14:21','2025-11-17 21:14:21',14),(56,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',56,1,'Botble\\CarRentals\\Models\\Booking',56,'INV-56',276,0,0,276,'pending',NULL,'2025-12-10 21:14:21','2025-11-17 21:14:21',11),(57,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',57,1,'Botble\\CarRentals\\Models\\Booking',57,'INV-57',275,0,0,275,'pending',NULL,'2025-12-06 21:14:21','2025-11-17 21:14:21',9),(58,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',58,1,'Botble\\CarRentals\\Models\\Booking',58,'INV-58',108,0,0,108,'pending',NULL,'2025-11-26 21:14:21','2025-11-17 21:14:21',NULL),(59,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',59,1,'Botble\\CarRentals\\Models\\Booking',59,'INV-59',644,64.4,0,644,'pending',NULL,'2025-12-07 21:14:21','2025-11-17 21:14:21',NULL),(60,29,'Rylee Bogan','rickey.gleichner@example.org','+13412597092',60,1,'Botble\\CarRentals\\Models\\Booking',60,'INV-60',616,0,0,616,'pending',NULL,'2025-11-21 21:14:21','2025-11-17 21:14:21',NULL),(61,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',61,1,'Botble\\CarRentals\\Models\\Booking',61,'INV-61',106,0,0,106,'pending',NULL,'2025-12-01 21:14:21','2025-11-17 21:14:21',15),(62,24,'Shanie Ritchie I','anais69@example.org','+18458662737',62,1,'Botble\\CarRentals\\Models\\Booking',62,'INV-62',296,0,0,296,'pending',NULL,'2025-11-29 21:14:21','2025-11-17 21:14:21',8),(63,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',63,1,'Botble\\CarRentals\\Models\\Booking',63,'INV-63',552,55.2,0,552,'pending',NULL,'2025-12-02 21:14:21','2025-11-17 21:14:21',1),(64,25,'Sydnie Crooks','everardo.cole@example.com','+14793463231',64,1,'Botble\\CarRentals\\Models\\Booking',64,'INV-64',84,0,0,84,'pending',NULL,'2025-12-07 21:14:21','2025-11-17 21:14:21',12),(65,23,'Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',65,1,'Botble\\CarRentals\\Models\\Booking',65,'INV-65',168,16.8,0,168,'pending',NULL,'2025-11-28 21:14:21','2025-11-17 21:14:21',12),(66,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',66,1,'Botble\\CarRentals\\Models\\Booking',66,'INV-66',96,0,0,96,'pending',NULL,'2025-12-07 21:14:21','2025-11-17 21:14:21',15),(67,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',67,1,'Botble\\CarRentals\\Models\\Booking',67,'INV-67',297,29.7,0,297,'pending',NULL,'2025-12-02 21:14:21','2025-11-17 21:14:21',4),(68,23,'Ignacio Kris I','hodkiewicz.dayana@example.com','+12694180562',68,1,'Botble\\CarRentals\\Models\\Booking',68,'INV-68',462,0,0,462,'pending',NULL,'2025-11-21 21:14:21','2025-11-17 21:14:21',NULL),(69,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',69,1,'Botble\\CarRentals\\Models\\Booking',69,'INV-69',186,0,0,186,'pending',NULL,'2025-12-12 21:14:21','2025-11-17 21:14:21',NULL),(70,24,'Shanie Ritchie I','anais69@example.org','+18458662737',70,1,'Botble\\CarRentals\\Models\\Booking',70,'INV-70',462,0,0,462,'pending',NULL,'2025-11-28 21:14:21','2025-11-17 21:14:22',NULL),(71,28,'Alvena Will','cummerata.oda@example.org','+14693772940',71,1,'Botble\\CarRentals\\Models\\Booking',71,'INV-71',456,0,0,456,'pending',NULL,'2025-11-27 21:14:22','2025-11-17 21:14:22',13),(72,26,'Dr. Rozella Fahey','oboyer@example.org','+19167009366',72,1,'Botble\\CarRentals\\Models\\Booking',72,'INV-72',468,0,0,468,'pending',NULL,'2025-11-20 21:14:22','2025-11-17 21:14:22',17),(73,29,'Rylee Bogan','rickey.gleichner@example.org','+13412597092',73,1,'Botble\\CarRentals\\Models\\Booking',73,'INV-73',170,0,0,170,'pending',NULL,'2025-11-19 21:14:22','2025-11-17 21:14:22',18),(74,31,'Cielo Cruickshank V','customer@botble.com','+15126273228',74,1,'Botble\\CarRentals\\Models\\Booking',74,'INV-74',420,42,0,420,'pending',NULL,'2025-11-21 21:14:22','2025-11-17 21:14:22',10),(75,30,'Pat Boyle','sonya.ruecker@example.net','+17409015709',75,1,'Botble\\CarRentals\\Models\\Booking',75,'INV-75',329,0,0,329,'pending',NULL,'2025-12-04 21:14:22','2025-11-17 21:14:22',1),(76,24,'Shanie Ritchie I','anais69@example.org','+18458662737',76,1,'Botble\\CarRentals\\Models\\Booking',76,'INV-76',76,0,0,76,'pending',NULL,'2025-12-16 21:14:22','2025-11-17 21:14:22',13),(77,27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',77,1,'Botble\\CarRentals\\Models\\Booking',77,'INV-77',330,33,0,330,'pending',NULL,'2025-11-18 21:14:22','2025-11-17 21:14:22',18),(78,28,'Alvena Will','cummerata.oda@example.org','+14693772940',78,1,'Botble\\CarRentals\\Models\\Booking',78,'INV-78',63,0,0,63,'pending',NULL,'2025-12-12 21:14:22','2025-11-17 21:14:22',NULL),(79,27,'Mrs. Dorris Muller','swaniawski.maxie@example.com','+12059822297',79,1,'Botble\\CarRentals\\Models\\Booking',79,'INV-79',300,0,0,300,'pending',NULL,'2025-11-27 21:14:22','2025-11-17 21:14:22',NULL),(80,21,'Dr. Vernie Quitzon MD','gladyce.kuhn@example.net','+13615551428',80,1,'Botble\\CarRentals\\Models\\Booking',80,'INV-80',450,45,0,450,'pending',NULL,'2025-11-28 21:14:22','2025-11-17 21:14:22',NULL);
/*!40000 ALTER TABLE `cr_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_messages`
--

DROP TABLE IF EXISTS `cr_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_messages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_messages`
--

LOCK TABLES `cr_messages` WRITE;
/*!40000 ALTER TABLE `cr_messages` DISABLE KEYS */;
INSERT INTO `cr_messages` VALUES (1,NULL,23,'John Doe','johndoe@example.com','I would like to know more about your services.','192.168.1.1','2025-11-17 21:14:22','2025-11-17 21:14:22','123-456-7890','unread',7),(2,NULL,16,'Jane Smith','janesmith@example.com','Can you provide a quotation for the project?','192.168.1.2','2025-11-17 21:14:22','2025-11-17 21:14:22','987-654-3210','unread',NULL),(3,NULL,5,'Alice Brown','alicebrown@example.com','I am having an issue with my recent order.','192.168.1.3','2025-11-17 21:14:22','2025-11-17 21:14:22','555-666-7777','read',NULL),(4,NULL,25,'Bob Green','bobgreen@example.com','What are your business hours?','192.168.1.4','2025-11-17 21:14:22','2025-11-17 21:14:22','222-333-4444','unread',17),(5,NULL,27,'Charlie White','charliewhite@example.com','I need assistance with your product.','192.168.1.5','2025-11-17 21:14:22','2025-11-17 21:14:22','333-444-5555','unread',NULL),(6,NULL,14,'Diana Blue','dianablue@example.com','Do you offer international shipping?','192.168.1.6','2025-11-17 21:14:22','2025-11-17 21:14:22','444-555-6666','unread',NULL),(7,NULL,23,'Edward Black','edwardblack@example.com','Can I schedule an appointment?','192.168.1.7','2025-11-17 21:14:22','2025-11-17 21:14:22','555-666-7778','unread',13),(8,NULL,20,'Fiona Gray','fionagray@example.com','Your website is not loading for me.','192.168.1.8','2025-11-17 21:14:22','2025-11-17 21:14:22','666-777-8888','read',NULL),(9,NULL,7,'George Violet','georgeviolet@example.com','I want to change my order details.','192.168.1.9','2025-11-17 21:14:22','2025-11-17 21:14:22','777-888-9999','unread',NULL),(10,NULL,14,'Hannah Pink','hannahpink@example.com','Can you send me a catalog of your products?','192.168.1.10','2025-11-17 21:14:22','2025-11-17 21:14:22','888-999-0000','read',3),(11,NULL,19,'Ian Orange','ianorange@example.com','Do you offer discounts for bulk purchases?','192.168.1.11','2025-11-17 21:14:22','2025-11-17 21:14:22','999-000-1111','unread',NULL),(12,NULL,24,'Jack Purple','jackpurple@example.com','I forgot my account password.','192.168.1.12','2025-11-17 21:14:22','2025-11-17 21:14:22','000-111-2222','unread',NULL),(13,NULL,8,'Karen Yellow','karenyellow@example.com','Can you expedite my order?','192.168.1.13','2025-11-17 21:14:22','2025-11-17 21:14:22','111-222-3333','read',11),(14,NULL,10,'Liam Red','liamred@example.com','Do you have a return policy?','192.168.1.14','2025-11-17 21:14:22','2025-11-17 21:14:22','222-333-4445','unread',NULL),(15,NULL,8,'Mia Silver','miasilver@example.com','Thank you for resolving my issue quickly.','192.168.1.15','2025-11-17 21:14:22','2025-11-17 21:14:22','333-444-5556','read',NULL),(16,NULL,8,'Noah Gold','noahgold@example.com','Can I get an invoice for my purchase?','192.168.1.16','2025-11-17 21:14:22','2025-11-17 21:14:22','444-555-6667','unread',10),(17,NULL,14,'Olivia Bronze','oliviabronze@example.com','I would like to cancel my order.','192.168.1.17','2025-11-17 21:14:22','2025-11-17 21:14:22','555-666-7779','unread',NULL),(18,NULL,2,'Paul Amber','paulamber@example.com','Your support team is very helpful.','192.168.1.18','2025-11-17 21:14:22','2025-11-17 21:14:22','666-777-8889','unread',NULL),(19,NULL,25,'Quinn Platinum','quinnplatinum@example.com','How do I track my shipment?','192.168.1.19','2025-11-17 21:14:22','2025-11-17 21:14:22','777-888-9990','read',2),(20,NULL,11,'Ruby Diamond','rubydiamond@example.com','Great service and prompt delivery!','192.168.1.20','2025-11-17 21:14:22','2025-11-17 21:14:22','888-999-0001','read',NULL);
/*!40000 ALTER TABLE `cr_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_services`
--

DROP TABLE IF EXISTS `cr_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_services` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `price` double unsigned NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned DEFAULT NULL,
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'once',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_services_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_services`
--

LOCK TABLES `cr_services` WRITE;
/*!40000 ALTER TABLE `cr_services` DISABLE KEYS */;
INSERT INTO `cr_services` VALUES (1,'Driver Rental Service','In addition to our car rental service, we offer professional drivers for hire. Enjoy a stress-free journey with our experienced drivers handling the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"A perspiciatis nihil est molestiae enim at maiores. Omnis nostrum adipisci eius. Esse enim beatae voluptatem quibusdam modi omnis et omnis. Nihil iure magni quia laboriosam accusantium non. Et quis similique sit non est quo necessitatibus. Dolor commodi culpa ut. Non asperiores quibusdam consequatur in laborum debitis. Vero quisquam labore autem molestiae laudantium voluptatum.\" content_2=\"Eum minus et unde ducimus. Debitis eveniet alias qui eum id. Atque nisi sequi corporis. Rem at quibusdam qui voluptas. Nihil aperiam est sapiente facilis voluptates cum quam dolorem. Et unde qui quidem doloribus. Mollitia deleniti eum ab. Quod et inventore voluptatem aut voluptatum. Voluptatem quia perferendis enim velit eius.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',483,NULL,'once','news/1.jpg','icons/lexus.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(2,'Oil Change Service','Keep your engine in top condition with our oil change service. Available as an add-on to any of our maintenance or repair services.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Totam repellat accusantium nisi voluptatem. Ea totam ratione et enim magnam. Rerum dignissimos qui dolore officia non. Enim libero voluptatem mollitia voluptatem architecto quasi. Aliquid expedita quaerat voluptas aut. Dolor at aut tempore vel.\" content_2=\"Quam modi non dolor culpa amet. Rem eum nostrum quidem ratione. Quod consequuntur est est autem. Tempora optio voluptatum sapiente ut. Temporibus perspiciatis dolorem sunt omnis. Repudiandae illum quaerat quas quidem quaerat. Ab sed ut ut deserunt nihil similique doloribus. Vero velit inventore et dicta. Ducimus consectetur possimus saepe earum facere ut.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',833,NULL,'once','news/2.jpg','icons/mer.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(3,'Car Wash & Detailing Package','Enhance your car rental or repair experience with our premium car wash and detailing service, leaving your car spotless inside and out.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Qui quo cumque commodi saepe. Maiores quisquam ea in ipsam. Fugit numquam est quidem quas ipsa. Dolore in esse et. Explicabo minima voluptatem dolores commodi aperiam vero voluptate. Possimus minus in id qui. Qui et aliquam dolore perferendis nesciunt praesentium quo. Occaecati quo velit modi omnis. Non quod facere animi.\" content_2=\"Deserunt culpa quia in officia qui animi. Tempora aut ad ut error delectus. Voluptatum fugit ut unde omnis temporibus provident. Dolorum nemo qui sit quas est. Consequatur vel hic aut corporis. Ipsum voluptatibus enim voluptatem et. Explicabo voluptatem et quisquam sed.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',761,NULL,'once','news/3.jpg','icons/bugatti.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(4,'Roadside Assistance','Our roadside assistance service ensures peace of mind while you rent or drive. Get help with breakdowns, flat tires, or towing when you need it most.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Illum minima molestias illum natus magnam debitis. Laudantium inventore ut quaerat dolore fugit. Omnis temporibus itaque architecto voluptas aut. Earum quos optio ducimus provident fugiat sed est. Quo officia a nobis nemo. Veritatis consequuntur praesentium similique.\" content_2=\"Corporis natus numquam assumenda necessitatibus. Molestiae sed cupiditate aut sit. Qui nobis dolorum vero alias sit. Quia temporibus repellendus quisquam. Saepe debitis atque quibusdam totam eius. Suscipit enim sit est cumque sunt quia dolores. Officia ut voluptatibus a praesentium quam molestias officiis.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',635,NULL,'once','news/4.jpg','icons/jaguar.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(5,'Temporary Car Replacement','If your car is in for repairs or maintenance, we offer a temporary car replacement service so you’re never without transportation.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Minus natus illo nemo laborum quia at hic aut. Sint voluptatum voluptates odit sit voluptatem. Dolore assumenda vel tenetur provident et omnis. Vel reprehenderit fugit cupiditate doloribus placeat voluptate. Sunt nihil quis quae ut. Tempora qui eos qui mollitia sint voluptas voluptates ut. Voluptatibus fugiat aut aut iste. Tempora repudiandae aut perspiciatis omnis placeat ut.\" content_2=\"Ipsa dicta quaerat dolorem sed. Qui voluptates accusantium suscipit omnis omnis atque tempore. Et quisquam quisquam non est impedit. Vitae at nesciunt et quod nesciunt qui. Voluptas adipisci et voluptatem facere aperiam illum vel hic. Sed et non nemo amet ipsum et nulla. Et architecto perspiciatis nostrum eos.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',982,NULL,'once','news/5.jpg','icons/honda.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(6,'Tire Replacement & Balancing','We provide tire replacement and wheel balancing services, ensuring your car is safe and smooth on the road, available as an add-on to any maintenance package.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Animi nihil aut earum earum error veniam. Perspiciatis omnis qui cum error. Nisi itaque velit impedit voluptatum quis. Delectus velit saepe quo ipsam sit quia. Laudantium blanditiis corrupti suscipit. Aut necessitatibus ad itaque necessitatibus voluptas ut illum. Sapiente itaque consequatur ut quos. Qui repellat qui laborum in omnis voluptate.\" content_2=\"Labore sequi quos praesentium numquam. Quae at animi inventore. Possimus laborum architecto consequatur dicta non optio. Similique dolores vitae recusandae quia sit amet tempore. Nihil quis ipsa sunt assumenda ut fugiat velit. Iusto ab fugiat temporibus et. Incidunt harum aspernatur aut ut et eveniet. Velit quia ea laboriosam laudantium ut.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',332,NULL,'once','news/6.jpg','icons/chevrolet.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(7,'Vehicle Inspection Service','For those looking to sell or rent a car, we offer thorough vehicle inspection services to certify your car’s condition and increase its market value.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Nihil aliquid veritatis fugit est. Perspiciatis reprehenderit iusto in aut consequatur sed. Corporis voluptas reiciendis nisi sunt vel facere maiores. Nulla et impedit incidunt. Et illum commodi molestias voluptatibus voluptatem. Facilis illum molestiae in consequuntur quaerat est ut doloremque. Vel sunt consequatur aut et.\" content_2=\"Repellat nam quia cum asperiores. Maiores velit in quisquam dolorem blanditiis vero ratione. Aut quia cupiditate et voluptatem nam. Excepturi at voluptatem non. Similique quia in quo. Possimus temporibus culpa eos vel voluptas eius at. Sint quam nam eos et.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',257,NULL,'once','news/7.jpg','icons/chevrolet.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(8,'Car Insurance Assistance','Our experts can help you find the right car insurance policy, available as an add-on when purchasing or renting a vehicle from us.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Atque aut quia quia consequuntur earum. Optio a sed consectetur ut rerum et velit. Ex est itaque adipisci commodi amet. Ullam eius odio voluptatem qui et. Quidem eos tempore ex optio commodi. Eveniet laborum et voluptas rem modi et. Pariatur numquam voluptatem tenetur illum deserunt. Nam eveniet soluta qui et est corporis. In quis et a et vel maiores aliquam.\" content_2=\"Sed aut fuga exercitationem qui vero dolorum. Eos ut fuga explicabo quam. Rem sit quod qui est. Aut quo corrupti quidem harum distinctio quae. Fuga blanditiis voluptatem eligendi mollitia et quia dolor. Asperiores voluptatem magni et repellat incidunt itaque est at. Recusandae quis eos ad voluptatem voluptate. Dicta eos corrupti necessitatibus ea. Et esse aliquid est rerum.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',408,NULL,'once','news/8.jpg','icons/chevrolet.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(9,'Pick-Up & Drop-Off Service','We offer a convenient pick-up and drop-off service when you rent a car, have your car serviced, or use our detailing services.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Eveniet aut at porro. Soluta repudiandae vero est unde id. Modi possimus iure deserunt possimus corporis sequi iste. Quia illum beatae id voluptatum repudiandae aliquam. Accusamus autem voluptatem accusantium similique deleniti quia et. Provident enim aperiam excepturi minus fugit aut explicabo. Eum aut ut sit. Qui nemo quos voluptas illum. Occaecati impedit aliquid omnis nihil quo.\" content_2=\"Dolor voluptatem molestiae et ex voluptatem voluptas. Quasi sequi et alias. A labore tempore hic laborum odio. Ipsam qui repellat blanditiis maxime. Et nam quos sint excepturi corporis. Eos rem inventore deleniti blanditiis id tempora. Quod dolore magni dolores corrupti. Aliquam neque eos voluptas ut voluptate dolorem. Doloribus est officia laudantium. Sed tenetur facere et pariatur velit.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',116,NULL,'once','news/9.jpg','icons/chevrolet.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35'),(10,'Premium Fuel Service','Refuel your rental or serviced vehicle with high-quality premium fuel before hitting the road, ensuring optimal performance and mileage.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Eveniet in neque aut et. Inventore qui delectus illum error accusamus. Nulla delectus culpa ut iusto consequatur et. Itaque dolorem ut vitae.\" content_2=\"Vitae saepe dignissimos et nulla. Cupiditate quia molestias voluptatem repellat voluptas et. Vero ratione aut temporibus temporibus repellendus est maiores necessitatibus. Eaque tempora provident numquam doloremque qui. Aliquid est sint est commodi voluptatem alias ducimus corporis. Et quasi vero quae voluptatibus consequatur asperiores. Ducimus ea sed voluptates illo assumenda.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',181,NULL,'once','news/10.jpg','icons/chevrolet.png','published','2025-11-17 21:13:35','2025-11-17 21:13:35');
/*!40000 ALTER TABLE `cr_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_services_translations`
--

DROP TABLE IF EXISTS `cr_services_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_services_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_services_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_services_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_services_translations`
--

LOCK TABLES `cr_services_translations` WRITE;
/*!40000 ALTER TABLE `cr_services_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_services_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_tags`
--

DROP TABLE IF EXISTS `cr_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_tags_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_tags`
--

LOCK TABLES `cr_tags` WRITE;
/*!40000 ALTER TABLE `cr_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_tags_translations`
--

DROP TABLE IF EXISTS `cr_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_tags_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_tags_translations`
--

LOCK TABLES `cr_tags_translations` WRITE;
/*!40000 ALTER TABLE `cr_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_taxes`
--

DROP TABLE IF EXISTS `cr_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `priority` smallint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_taxes`
--

LOCK TABLES `cr_taxes` WRITE;
/*!40000 ALTER TABLE `cr_taxes` DISABLE KEYS */;
INSERT INTO `cr_taxes` VALUES (1,'Import Duty',1.31,'published',1,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(2,'Value Added Tax (VAT)',2.74,'published',2,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(3,'Currency Conversion',4.31,'published',3,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(4,'Brokerage',4.13,'published',4,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(5,'Storage',3.80,'published',5,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(6,'Administrative',1.95,'published',6,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(7,'Handling',0.80,'published',7,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(8,'Insurance',3.64,'published',8,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(9,'Rural Delivery',4.85,'published',9,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(10,'Return Shipping',1.19,'published',10,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(11,'Environmental',3.70,'published',11,'2025-11-17 21:13:34','2025-11-17 21:13:34'),(12,'Excise',2.90,'published',12,'2025-11-17 21:13:34','2025-11-17 21:13:34');
/*!40000 ALTER TABLE `cr_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_taxes_translations`
--

DROP TABLE IF EXISTS `cr_taxes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_taxes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_taxes_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_code`,`cr_taxes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_taxes_translations`
--

LOCK TABLES `cr_taxes_translations` WRITE;
/*!40000 ALTER TABLE `cr_taxes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_taxes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_tokens_token_unique` (`token`),
  KEY `device_tokens_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `device_tokens_platform_is_active_index` (`platform`,`is_active`),
  KEY `device_tokens_is_active_index` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'GENERAL INFORMATION',0,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(2,'ACCOMMODATIONS AND AMENITIES',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(3,'SPECIAL EVENTS',2,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(4,'SAFETY AND HEALTH',3,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(5,'EXPLORING',4,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(6,'Account Management',5,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(7,'Booking and Reservations',6,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL),(8,'Activity Information',7,'published','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What sets Luxury Hotel apart from others area?','Our hotel stands out with its prime coastal location, captivating design that harmonizes with nature, impeccable service dedicated to fulfilling every guest’s desire, and an array of world-class amenities that redefine opulence and sophistication.',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(2,'Are pets allowed at your hotel?','Unfortunately, as we strive to maintain an environment of tranquility and luxury for all our guests, we regret to inform you that we do not permit pets in our elegantly appointed rooms and meticulously designed public spaces.',2,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(3,'Is there a service from airport to hotel?','Absolutely! For your convenience, we offer an exclusive airport shuttle service that can be arranged in advance. Our dedicated concierge team will be delighted to provide you with detailed information and assist with reservations.',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(4,'What dining options are available at hotel?','Indulge in a culinary journey at our resort with a range of exquisite dining options. From elegantly crafted local and international cuisines to delightful specialty restaurants and inviting bars, every dining experience promises to tantalize your taste buds and elevate your stay to new heights of gastronomic pleasure.',2,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(5,'Is there a spa and wellness center on-site?','Embrace holistic well-being at our luxurious on-site spa and wellness center. Immerse yourself in a world of serenity and rejuvenation with a diverse selection of treatments, therapies, and state-of-the-art facilities that cater to your body, mind, and soul.',2,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(6,'Do you have family-friendly activities?','Families are warmly welcomed to our resort, where we have thoughtfully curated a range of family-friendly amenities and activities. From a dedicated kids’ club to a family pool and a host of engaging recreational options, we ensure a harmonious and enjoyable stay for guests of all ages.',2,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(7,'How can I arrange special at resort?','Celebrate life’s most precious moments in the epitome of luxury and elegance. Our skilled event planning team is committed to orchestrating seamless and memorable celebrations, ensuring every detail is tailored to your vision. Contact our dedicated events department to embark on a journey of crafting extraordinary moments.',3,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(8,'What safety measures do you have for guests?','Your well-being is our paramount concern. We have implemented stringent health and safety protocols to ensure a secure and comfortable environment for all our guests. These measures encompass enhanced cleaning procedures, social distancing guidelines, and a commitment to maintaining the highest standards of hygiene throughout the resort.',4,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(9,'Can I cancel or modify my reservation?','Our reservation policies vary based on the rate type and specific booking conditions. We kindly advise reviewing the terms and details of your reservation or reaching out to our dedicated reservations team for personalized assistance regarding cancellations or modifications. Your comfort and satisfaction remain our utmost priority.',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(10,'What activities are near your hotel?','Our hotel’s prime location offers easy access to a plethora of attractions. Explore the captivating Adriatic coastline, immerse yourself in historical landmarks, indulge in vibrant local culture, and embark on memorable excursions that our concierge team can readily assist in arranging.',5,'published','2025-11-17 21:13:16','2025-11-17 21:13:16');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fob_comments`
--

DROP TABLE IF EXISTS `fob_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fob_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reply_to` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fob_comments_author_type_author_id_index` (`author_type`,`author_id`),
  KEY `fob_comments_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `fob_comments_reply_to_index` (`reply_to`),
  KEY `fob_comments_reference_url_index` (`reference_url`),
  KEY `fob_comments_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fob_comments`
--

LOCK TABLES `fob_comments` WRITE;
/*!40000 ALTER TABLE `fob_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `fob_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Stunning Electric Cars of 2024','Aperiam ea in nesciunt voluptas. Enim distinctio quas facilis corrupti sit. Maiores repellat laudantium odit.',0,0,'galleries/1.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(2,'Top Luxury Cars for Special Occasions','Temporibus quaerat quo voluptas at doloremque fugit dolores. In sed consectetur saepe nemo. Laborum fugit rerum fugit deleniti fugit voluptatem ea.',0,0,'galleries/2.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(3,'Family Cars with Advanced Safety Features','Debitis aliquam et eveniet. Autem dolore qui corporis voluptatem facilis in. Mollitia soluta nisi repudiandae. Nesciunt ut eum optio ab accusantium.',0,0,'galleries/3.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(4,'Off-Road Vehicles in Action','Suscipit velit aut veniam sequi sint aliquid atque. Ratione unde amet ut. Eaque inventore quidem nemo dolore aut qui omnis blanditiis.',0,0,'galleries/4.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(5,'The Evolution of Car Design: A Visual Journey','Repudiandae ducimus in aut ipsa. Soluta est vitae aspernatur sunt aliquid. Laudantium repellendus laborum iste ipsam consequatur repellat.',0,0,'galleries/5.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(6,'Best Road Trip Cars of the Year','Sed dolor non magni omnis dolore ad sed. Voluptatum aut facilis culpa debitis eum aut optio. Rerum repellat voluptas magnam.',0,0,'galleries/6.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(7,'Exclusive New Car Models Unveiled','Illum ut repellat aut. Consequatur et porro ea ea autem earum et quisquam. Nihil tenetur eaque cumque iste.',0,0,'galleries/7.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(8,'Iconic Cars from Around the World','Dolor asperiores placeat earum placeat. Voluptatum iste labore adipisci delectus.',0,0,'galleries/8.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(9,'The Future of Electric and Hybrid Cars','Voluptatibus impedit labore molestiae doloribus. Dignissimos aut sapiente nemo quaerat.',0,0,'galleries/9.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16'),(10,'Luxury Car Interiors: A Closer Look','Ab rem sequi vel alias reprehenderit. Quia animi ut nam velit sed. Facere dolor maiores quia quibusdam vel ex.',0,0,'galleries/10.jpg',1,'published','2025-11-17 21:13:16','2025-11-17 21:13:16');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(2,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(3,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(4,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(5,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(6,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(7,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(8,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(9,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16'),(10,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:13:16','2025-11-17 21:13:16');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','35f440b596defaf000e350eac9efae7e',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','8695aa450a35aaf5e1b19a5b2d58d886',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','343eecf747580e0a45e07bcd1f63a14b',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(4,'en_US','5ac3545a88013b10544c7b5217a3b2b9',2,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'1','1',1,'image/jpeg',10644,'general/1.jpg','[]','2025-11-17 21:13:01','2025-11-17 21:13:01',NULL,'public'),(2,0,'2','2',1,'image/jpeg',4750,'general/2.jpg','[]','2025-11-17 21:13:01','2025-11-17 21:13:01',NULL,'public'),(3,0,'3','3',1,'image/jpeg',8045,'general/3.jpg','[]','2025-11-17 21:13:01','2025-11-17 21:13:01',NULL,'public'),(4,0,'about-us-1','about-us-1',1,'image/jpeg',11009,'general/about-us-1.jpg','[]','2025-11-17 21:13:01','2025-11-17 21:13:01',NULL,'public'),(5,0,'about-us-2','about-us-2',1,'image/jpeg',11009,'general/about-us-2.jpg','[]','2025-11-17 21:13:01','2025-11-17 21:13:01',NULL,'public'),(6,0,'about-us-3','about-us-3',1,'image/jpeg',9151,'general/about-us-3.jpg','[]','2025-11-17 21:13:02','2025-11-17 21:13:02',NULL,'public'),(7,0,'admin-logo','admin-logo',1,'image/png',3856,'general/admin-logo.png','[]','2025-11-17 21:13:02','2025-11-17 21:13:02',NULL,'public'),(8,0,'appstore','appstore',1,'image/png',3718,'general/appstore.png','[]','2025-11-17 21:13:02','2025-11-17 21:13:02',NULL,'public'),(9,0,'background','background',1,'image/png',171804,'general/background.png','[]','2025-11-17 21:13:02','2025-11-17 21:13:02',NULL,'public'),(10,0,'favicon','favicon',1,'image/png',2019,'general/favicon.png','[]','2025-11-17 21:13:03','2025-11-17 21:13:03',NULL,'public'),(11,0,'googleplay','googleplay',1,'image/png',3970,'general/googleplay.png','[]','2025-11-17 21:13:03','2025-11-17 21:13:03',NULL,'public'),(12,0,'img-1','img-1',1,'image/png',8332,'general/img-1.png','[]','2025-11-17 21:13:03','2025-11-17 21:13:03',NULL,'public'),(13,0,'img-2-1','img-2-1',1,'image/png',4793,'general/img-2-1.png','[]','2025-11-17 21:13:03','2025-11-17 21:13:03',NULL,'public'),(14,0,'img-2-2','img-2-2',1,'image/png',4443,'general/img-2-2.png','[]','2025-11-17 21:13:03','2025-11-17 21:13:03',NULL,'public'),(15,0,'img-2-3','img-2-3',1,'image/png',3547,'general/img-2-3.png','[]','2025-11-17 21:13:04','2025-11-17 21:13:04',NULL,'public'),(16,0,'img-2-4','img-2-4',1,'image/png',4221,'general/img-2-4.png','[]','2025-11-17 21:13:04','2025-11-17 21:13:04',NULL,'public'),(17,0,'img-2','img-2',1,'image/png',8360,'general/img-2.png','[]','2025-11-17 21:13:04','2025-11-17 21:13:04',NULL,'public'),(18,0,'img-3','img-3',1,'image/png',7564,'general/img-3.png','[]','2025-11-17 21:13:04','2025-11-17 21:13:04',NULL,'public'),(19,0,'img-4','img-4',1,'image/png',7335,'general/img-4.png','[]','2025-11-17 21:13:05','2025-11-17 21:13:05',NULL,'public'),(20,0,'img-5','img-5',1,'image/png',8318,'general/img-5.png','[]','2025-11-17 21:13:05','2025-11-17 21:13:05',NULL,'public'),(21,0,'logo-dark','logo-dark',1,'image/png',3856,'general/logo-dark.png','[]','2025-11-17 21:13:05','2025-11-17 21:13:05',NULL,'public'),(22,0,'logo','logo',1,'image/png',4617,'general/logo.png','[]','2025-11-17 21:13:05','2025-11-17 21:13:05',NULL,'public'),(23,0,'phone','phone',1,'image/png',10618,'general/phone.png','[]','2025-11-17 21:13:05','2025-11-17 21:13:05',NULL,'public'),(24,0,'truck','truck',1,'image/png',5660,'general/truck.png','[]','2025-11-17 21:13:06','2025-11-17 21:13:06',NULL,'public'),(29,0,'1','1',3,'image/jpeg',19108,'news/1.jpg','[]','2025-11-17 21:13:08','2025-11-17 21:13:08',NULL,'public'),(30,0,'10','10',3,'image/jpeg',19108,'news/10.jpg','[]','2025-11-17 21:13:08','2025-11-17 21:13:08',NULL,'public'),(31,0,'11','11',3,'image/jpeg',19108,'news/11.jpg','[]','2025-11-17 21:13:09','2025-11-17 21:13:09',NULL,'public'),(32,0,'12','12',3,'image/jpeg',19108,'news/12.jpg','[]','2025-11-17 21:13:09','2025-11-17 21:13:09',NULL,'public'),(33,0,'13','13',3,'image/jpeg',19108,'news/13.jpg','[]','2025-11-17 21:13:09','2025-11-17 21:13:09',NULL,'public'),(34,0,'14','14',3,'image/jpeg',19108,'news/14.jpg','[]','2025-11-17 21:13:10','2025-11-17 21:13:10',NULL,'public'),(35,0,'15','15',3,'image/jpeg',19108,'news/15.jpg','[]','2025-11-17 21:13:10','2025-11-17 21:13:10',NULL,'public'),(36,0,'16','16',3,'image/jpeg',19108,'news/16.jpg','[]','2025-11-17 21:13:10','2025-11-17 21:13:10',NULL,'public'),(37,0,'17','17',3,'image/jpeg',19108,'news/17.jpg','[]','2025-11-17 21:13:10','2025-11-17 21:13:10',NULL,'public'),(38,0,'18','18',3,'image/jpeg',19108,'news/18.jpg','[]','2025-11-17 21:13:11','2025-11-17 21:13:11',NULL,'public'),(39,0,'19','19',3,'image/jpeg',19108,'news/19.jpg','[]','2025-11-17 21:13:11','2025-11-17 21:13:11',NULL,'public'),(40,0,'2','2',3,'image/jpeg',19108,'news/2.jpg','[]','2025-11-17 21:13:11','2025-11-17 21:13:11',NULL,'public'),(41,0,'20','20',3,'image/jpeg',19108,'news/20.jpg','[]','2025-11-17 21:13:11','2025-11-17 21:13:11',NULL,'public'),(42,0,'3','3',3,'image/jpeg',19108,'news/3.jpg','[]','2025-11-17 21:13:12','2025-11-17 21:13:12',NULL,'public'),(43,0,'4','4',3,'image/jpeg',19108,'news/4.jpg','[]','2025-11-17 21:13:12','2025-11-17 21:13:12',NULL,'public'),(44,0,'5','5',3,'image/jpeg',19108,'news/5.jpg','[]','2025-11-17 21:13:12','2025-11-17 21:13:12',NULL,'public'),(45,0,'6','6',3,'image/jpeg',19108,'news/6.jpg','[]','2025-11-17 21:13:13','2025-11-17 21:13:13',NULL,'public'),(46,0,'7','7',3,'image/jpeg',19108,'news/7.jpg','[]','2025-11-17 21:13:13','2025-11-17 21:13:13',NULL,'public'),(47,0,'8','8',3,'image/jpeg',19108,'news/8.jpg','[]','2025-11-17 21:13:13','2025-11-17 21:13:13',NULL,'public'),(48,0,'9','9',3,'image/jpeg',19108,'news/9.jpg','[]','2025-11-17 21:13:13','2025-11-17 21:13:13',NULL,'public'),(49,0,'1','1',4,'image/jpeg',12879,'galleries/1.jpg','[]','2025-11-17 21:13:14','2025-11-17 21:13:14',NULL,'public'),(50,0,'10','10',4,'image/jpeg',12879,'galleries/10.jpg','[]','2025-11-17 21:13:14','2025-11-17 21:13:14',NULL,'public'),(51,0,'2','2',4,'image/jpeg',12879,'galleries/2.jpg','[]','2025-11-17 21:13:14','2025-11-17 21:13:14',NULL,'public'),(52,0,'3','3',4,'image/jpeg',12879,'galleries/3.jpg','[]','2025-11-17 21:13:15','2025-11-17 21:13:15',NULL,'public'),(53,0,'4','4',4,'image/jpeg',12879,'galleries/4.jpg','[]','2025-11-17 21:13:15','2025-11-17 21:13:15',NULL,'public'),(54,0,'5','5',4,'image/jpeg',12879,'galleries/5.jpg','[]','2025-11-17 21:13:15','2025-11-17 21:13:15',NULL,'public'),(55,0,'6','6',4,'image/jpeg',12879,'galleries/6.jpg','[]','2025-11-17 21:13:15','2025-11-17 21:13:15',NULL,'public'),(56,0,'7','7',4,'image/jpeg',12879,'galleries/7.jpg','[]','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL,'public'),(57,0,'8','8',4,'image/jpeg',12879,'galleries/8.jpg','[]','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL,'public'),(58,0,'9','9',4,'image/jpeg',12879,'galleries/9.jpg','[]','2025-11-17 21:13:16','2025-11-17 21:13:16',NULL,'public'),(59,0,'1','1',5,'image/jpeg',9803,'teams/1.jpg','[]','2025-11-17 21:13:17','2025-11-17 21:13:17',NULL,'public'),(60,0,'2','2',5,'image/jpeg',9803,'teams/2.jpg','[]','2025-11-17 21:13:17','2025-11-17 21:13:17',NULL,'public'),(61,0,'3','3',5,'image/jpeg',9803,'teams/3.jpg','[]','2025-11-17 21:13:17','2025-11-17 21:13:17',NULL,'public'),(62,0,'4','4',5,'image/jpeg',9803,'teams/4.jpg','[]','2025-11-17 21:13:17','2025-11-17 21:13:17',NULL,'public'),(63,0,'5','5',5,'image/jpeg',9803,'teams/5.jpg','[]','2025-11-17 21:13:17','2025-11-17 21:13:17',NULL,'public'),(64,0,'6','6',5,'image/jpeg',9803,'teams/6.jpg','[]','2025-11-17 21:13:18','2025-11-17 21:13:18',NULL,'public'),(65,0,'7','7',5,'image/jpeg',9803,'teams/7.jpg','[]','2025-11-17 21:13:18','2025-11-17 21:13:18',NULL,'public'),(66,0,'8','8',5,'image/jpeg',9803,'teams/8.jpg','[]','2025-11-17 21:13:18','2025-11-17 21:13:18',NULL,'public'),(67,0,'1','1',6,'image/png',3750,'testimonials/1.png','[]','2025-11-17 21:13:18','2025-11-17 21:13:18',NULL,'public'),(68,0,'2','2',6,'image/png',3750,'testimonials/2.png','[]','2025-11-17 21:13:19','2025-11-17 21:13:19',NULL,'public'),(69,0,'3','3',6,'image/png',3750,'testimonials/3.png','[]','2025-11-17 21:13:19','2025-11-17 21:13:19',NULL,'public'),(70,0,'4','4',6,'image/png',3750,'testimonials/4.png','[]','2025-11-17 21:13:19','2025-11-17 21:13:19',NULL,'public'),(71,0,'location1','location1',7,'image/jpeg',11707,'locations/location1.jpg','[]','2025-11-17 21:13:19','2025-11-17 21:13:19',NULL,'public'),(72,0,'location2','location2',7,'image/jpeg',11707,'locations/location2.jpg','[]','2025-11-17 21:13:20','2025-11-17 21:13:20',NULL,'public'),(73,0,'location3','location3',7,'image/jpeg',11707,'locations/location3.jpg','[]','2025-11-17 21:13:20','2025-11-17 21:13:20',NULL,'public'),(74,0,'location4','location4',7,'image/jpeg',11707,'locations/location4.jpg','[]','2025-11-17 21:13:20','2025-11-17 21:13:20',NULL,'public'),(75,0,'location5','location5',7,'image/jpeg',11707,'locations/location5.jpg','[]','2025-11-17 21:13:20','2025-11-17 21:13:20',NULL,'public'),(76,0,'location6','location6',7,'image/jpeg',11707,'locations/location6.jpg','[]','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL,'public'),(77,0,'1','1',8,'image/jpeg',3916,'customers/1.jpg','[]','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL,'public'),(78,0,'10','10',8,'image/jpeg',3916,'customers/10.jpg','[]','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL,'public'),(79,0,'11','11',8,'image/jpeg',3916,'customers/11.jpg','[]','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL,'public'),(80,0,'12','12',8,'image/jpeg',3916,'customers/12.jpg','[]','2025-11-17 21:13:21','2025-11-17 21:13:21',NULL,'public'),(81,0,'13','13',8,'image/jpeg',3916,'customers/13.jpg','[]','2025-11-17 21:13:22','2025-11-17 21:13:22',NULL,'public'),(82,0,'14','14',8,'image/jpeg',3916,'customers/14.jpg','[]','2025-11-17 21:13:22','2025-11-17 21:13:22',NULL,'public'),(83,0,'15','15',8,'image/jpeg',3916,'customers/15.jpg','[]','2025-11-17 21:13:22','2025-11-17 21:13:22',NULL,'public'),(84,0,'16','16',8,'image/jpeg',3916,'customers/16.jpg','[]','2025-11-17 21:13:22','2025-11-17 21:13:22',NULL,'public'),(85,0,'17','17',8,'image/jpeg',3916,'customers/17.jpg','[]','2025-11-17 21:13:23','2025-11-17 21:13:23',NULL,'public'),(86,0,'18','18',8,'image/jpeg',3916,'customers/18.jpg','[]','2025-11-17 21:13:23','2025-11-17 21:13:23',NULL,'public'),(87,0,'19','19',8,'image/jpeg',3916,'customers/19.jpg','[]','2025-11-17 21:13:23','2025-11-17 21:13:23',NULL,'public'),(88,0,'2','2',8,'image/jpeg',3916,'customers/2.jpg','[]','2025-11-17 21:13:23','2025-11-17 21:13:23',NULL,'public'),(89,0,'20','20',8,'image/jpeg',3916,'customers/20.jpg','[]','2025-11-17 21:13:23','2025-11-17 21:13:23',NULL,'public'),(90,0,'21','21',8,'image/jpeg',3916,'customers/21.jpg','[]','2025-11-17 21:13:24','2025-11-17 21:13:24',NULL,'public'),(91,0,'22','22',8,'image/jpeg',3916,'customers/22.jpg','[]','2025-11-17 21:13:24','2025-11-17 21:13:24',NULL,'public'),(92,0,'23','23',8,'image/jpeg',3916,'customers/23.jpg','[]','2025-11-17 21:13:24','2025-11-17 21:13:24',NULL,'public'),(93,0,'24','24',8,'image/jpeg',3916,'customers/24.jpg','[]','2025-11-17 21:13:24','2025-11-17 21:13:24',NULL,'public'),(94,0,'25','25',8,'image/jpeg',3916,'customers/25.jpg','[]','2025-11-17 21:13:24','2025-11-17 21:13:24',NULL,'public'),(95,0,'26','26',8,'image/jpeg',3916,'customers/26.jpg','[]','2025-11-17 21:13:25','2025-11-17 21:13:25',NULL,'public'),(96,0,'27','27',8,'image/jpeg',3916,'customers/27.jpg','[]','2025-11-17 21:13:25','2025-11-17 21:13:25',NULL,'public'),(97,0,'28','28',8,'image/jpeg',3916,'customers/28.jpg','[]','2025-11-17 21:13:25','2025-11-17 21:13:25',NULL,'public'),(98,0,'29','29',8,'image/jpeg',3916,'customers/29.jpg','[]','2025-11-17 21:13:25','2025-11-17 21:13:25',NULL,'public'),(99,0,'3','3',8,'image/jpeg',3916,'customers/3.jpg','[]','2025-11-17 21:13:25','2025-11-17 21:13:25',NULL,'public'),(100,0,'30','30',8,'image/jpeg',3916,'customers/30.jpg','[]','2025-11-17 21:13:26','2025-11-17 21:13:26',NULL,'public'),(101,0,'31','31',8,'image/jpeg',3916,'customers/31.jpg','[]','2025-11-17 21:13:26','2025-11-17 21:13:26',NULL,'public'),(102,0,'4','4',8,'image/jpeg',3916,'customers/4.jpg','[]','2025-11-17 21:13:26','2025-11-17 21:13:26',NULL,'public'),(103,0,'5','5',8,'image/jpeg',3916,'customers/5.jpg','[]','2025-11-17 21:13:26','2025-11-17 21:13:26',NULL,'public'),(104,0,'6','6',8,'image/jpeg',3916,'customers/6.jpg','[]','2025-11-17 21:13:26','2025-11-17 21:13:26',NULL,'public'),(105,0,'7','7',8,'image/jpeg',3916,'customers/7.jpg','[]','2025-11-17 21:13:27','2025-11-17 21:13:27',NULL,'public'),(106,0,'8','8',8,'image/jpeg',3916,'customers/8.jpg','[]','2025-11-17 21:13:27','2025-11-17 21:13:27',NULL,'public'),(107,0,'9','9',8,'image/jpeg',3916,'customers/9.jpg','[]','2025-11-17 21:13:27','2025-11-17 21:13:27',NULL,'public'),(108,0,'1','1',9,'image/jpeg',33268,'cars/1.jpg','[]','2025-11-17 21:13:35','2025-11-17 21:13:35',NULL,'public'),(109,0,'10','10',9,'image/jpeg',33268,'cars/10.jpg','[]','2025-11-17 21:13:35','2025-11-17 21:13:35',NULL,'public'),(110,0,'100','100',9,'image/jpeg',33268,'cars/100.jpg','[]','2025-11-17 21:13:36','2025-11-17 21:13:36',NULL,'public'),(111,0,'101','101',9,'image/jpeg',33268,'cars/101.jpg','[]','2025-11-17 21:13:36','2025-11-17 21:13:36',NULL,'public'),(112,0,'102','102',9,'image/jpeg',33268,'cars/102.jpg','[]','2025-11-17 21:13:36','2025-11-17 21:13:36',NULL,'public'),(113,0,'103','103',9,'image/jpeg',33268,'cars/103.jpg','[]','2025-11-17 21:13:37','2025-11-17 21:13:37',NULL,'public'),(114,0,'104','104',9,'image/jpeg',33268,'cars/104.jpg','[]','2025-11-17 21:13:37','2025-11-17 21:13:37',NULL,'public'),(115,0,'105','105',9,'image/jpeg',33268,'cars/105.jpg','[]','2025-11-17 21:13:37','2025-11-17 21:13:37',NULL,'public'),(116,0,'11','11',9,'image/jpeg',33268,'cars/11.jpg','[]','2025-11-17 21:13:38','2025-11-17 21:13:38',NULL,'public'),(117,0,'12','12',9,'image/jpeg',33268,'cars/12.jpg','[]','2025-11-17 21:13:38','2025-11-17 21:13:38',NULL,'public'),(118,0,'13','13',9,'image/jpeg',33268,'cars/13.jpg','[]','2025-11-17 21:13:38','2025-11-17 21:13:38',NULL,'public'),(119,0,'14','14',9,'image/jpeg',33268,'cars/14.jpg','[]','2025-11-17 21:13:39','2025-11-17 21:13:39',NULL,'public'),(120,0,'15','15',9,'image/jpeg',33268,'cars/15.jpg','[]','2025-11-17 21:13:39','2025-11-17 21:13:39',NULL,'public'),(121,0,'16','16',9,'image/jpeg',33268,'cars/16.jpg','[]','2025-11-17 21:13:39','2025-11-17 21:13:39',NULL,'public'),(122,0,'17','17',9,'image/jpeg',33268,'cars/17.jpg','[]','2025-11-17 21:13:40','2025-11-17 21:13:40',NULL,'public'),(123,0,'18','18',9,'image/jpeg',33268,'cars/18.jpg','[]','2025-11-17 21:13:40','2025-11-17 21:13:40',NULL,'public'),(124,0,'19','19',9,'image/jpeg',33268,'cars/19.jpg','[]','2025-11-17 21:13:41','2025-11-17 21:13:41',NULL,'public'),(125,0,'2','2',9,'image/jpeg',33268,'cars/2.jpg','[]','2025-11-17 21:13:41','2025-11-17 21:13:41',NULL,'public'),(126,0,'20','20',9,'image/jpeg',33268,'cars/20.jpg','[]','2025-11-17 21:13:41','2025-11-17 21:13:41',NULL,'public'),(127,0,'21','21',9,'image/jpeg',33268,'cars/21.jpg','[]','2025-11-17 21:13:42','2025-11-17 21:13:42',NULL,'public'),(128,0,'22','22',9,'image/jpeg',33268,'cars/22.jpg','[]','2025-11-17 21:13:42','2025-11-17 21:13:42',NULL,'public'),(129,0,'23','23',9,'image/jpeg',33268,'cars/23.jpg','[]','2025-11-17 21:13:42','2025-11-17 21:13:42',NULL,'public'),(130,0,'24','24',9,'image/jpeg',33268,'cars/24.jpg','[]','2025-11-17 21:13:43','2025-11-17 21:13:43',NULL,'public'),(131,0,'25','25',9,'image/jpeg',33268,'cars/25.jpg','[]','2025-11-17 21:13:43','2025-11-17 21:13:43',NULL,'public'),(132,0,'26','26',9,'image/jpeg',33268,'cars/26.jpg','[]','2025-11-17 21:13:43','2025-11-17 21:13:43',NULL,'public'),(133,0,'27','27',9,'image/jpeg',33268,'cars/27.jpg','[]','2025-11-17 21:13:44','2025-11-17 21:13:44',NULL,'public'),(134,0,'28','28',9,'image/jpeg',33268,'cars/28.jpg','[]','2025-11-17 21:13:44','2025-11-17 21:13:44',NULL,'public'),(135,0,'29','29',9,'image/jpeg',33268,'cars/29.jpg','[]','2025-11-17 21:13:45','2025-11-17 21:13:45',NULL,'public'),(136,0,'3','3',9,'image/jpeg',33268,'cars/3.jpg','[]','2025-11-17 21:13:45','2025-11-17 21:13:45',NULL,'public'),(137,0,'30','30',9,'image/jpeg',33268,'cars/30.jpg','[]','2025-11-17 21:13:45','2025-11-17 21:13:45',NULL,'public'),(138,0,'31','31',9,'image/jpeg',33268,'cars/31.jpg','[]','2025-11-17 21:13:46','2025-11-17 21:13:46',NULL,'public'),(139,0,'32','32',9,'image/jpeg',33268,'cars/32.jpg','[]','2025-11-17 21:13:46','2025-11-17 21:13:46',NULL,'public'),(140,0,'33','33',9,'image/jpeg',33268,'cars/33.jpg','[]','2025-11-17 21:13:46','2025-11-17 21:13:46',NULL,'public'),(141,0,'34','34',9,'image/jpeg',33268,'cars/34.jpg','[]','2025-11-17 21:13:47','2025-11-17 21:13:47',NULL,'public'),(142,0,'35','35',9,'image/jpeg',33268,'cars/35.jpg','[]','2025-11-17 21:13:47','2025-11-17 21:13:47',NULL,'public'),(143,0,'36','36',9,'image/jpeg',33268,'cars/36.jpg','[]','2025-11-17 21:13:47','2025-11-17 21:13:47',NULL,'public'),(144,0,'37','37',9,'image/jpeg',33268,'cars/37.jpg','[]','2025-11-17 21:13:48','2025-11-17 21:13:48',NULL,'public'),(145,0,'38','38',9,'image/jpeg',33268,'cars/38.jpg','[]','2025-11-17 21:13:48','2025-11-17 21:13:48',NULL,'public'),(146,0,'39','39',9,'image/jpeg',33268,'cars/39.jpg','[]','2025-11-17 21:13:49','2025-11-17 21:13:49',NULL,'public'),(147,0,'4','4',9,'image/jpeg',33268,'cars/4.jpg','[]','2025-11-17 21:13:49','2025-11-17 21:13:49',NULL,'public'),(148,0,'40','40',9,'image/jpeg',33268,'cars/40.jpg','[]','2025-11-17 21:13:49','2025-11-17 21:13:49',NULL,'public'),(149,0,'41','41',9,'image/jpeg',33268,'cars/41.jpg','[]','2025-11-17 21:13:50','2025-11-17 21:13:50',NULL,'public'),(150,0,'42','42',9,'image/jpeg',33268,'cars/42.jpg','[]','2025-11-17 21:13:50','2025-11-17 21:13:50',NULL,'public'),(151,0,'43','43',9,'image/jpeg',33268,'cars/43.jpg','[]','2025-11-17 21:13:50','2025-11-17 21:13:50',NULL,'public'),(152,0,'44','44',9,'image/jpeg',33268,'cars/44.jpg','[]','2025-11-17 21:13:51','2025-11-17 21:13:51',NULL,'public'),(153,0,'45','45',9,'image/jpeg',33268,'cars/45.jpg','[]','2025-11-17 21:13:51','2025-11-17 21:13:51',NULL,'public'),(154,0,'46','46',9,'image/jpeg',33268,'cars/46.jpg','[]','2025-11-17 21:13:51','2025-11-17 21:13:51',NULL,'public'),(155,0,'47','47',9,'image/jpeg',33268,'cars/47.jpg','[]','2025-11-17 21:13:52','2025-11-17 21:13:52',NULL,'public'),(156,0,'48','48',9,'image/jpeg',33268,'cars/48.jpg','[]','2025-11-17 21:13:52','2025-11-17 21:13:52',NULL,'public'),(157,0,'49','49',9,'image/jpeg',33268,'cars/49.jpg','[]','2025-11-17 21:13:52','2025-11-17 21:13:52',NULL,'public'),(158,0,'5','5',9,'image/jpeg',33268,'cars/5.jpg','[]','2025-11-17 21:13:53','2025-11-17 21:13:53',NULL,'public'),(159,0,'50','50',9,'image/jpeg',33268,'cars/50.jpg','[]','2025-11-17 21:13:53','2025-11-17 21:13:53',NULL,'public'),(160,0,'51','51',9,'image/jpeg',33268,'cars/51.jpg','[]','2025-11-17 21:13:53','2025-11-17 21:13:53',NULL,'public'),(161,0,'52','52',9,'image/jpeg',33268,'cars/52.jpg','[]','2025-11-17 21:13:54','2025-11-17 21:13:54',NULL,'public'),(162,0,'53','53',9,'image/jpeg',33268,'cars/53.jpg','[]','2025-11-17 21:13:54','2025-11-17 21:13:54',NULL,'public'),(163,0,'54','54',9,'image/jpeg',33268,'cars/54.jpg','[]','2025-11-17 21:13:55','2025-11-17 21:13:55',NULL,'public'),(164,0,'55','55',9,'image/jpeg',33268,'cars/55.jpg','[]','2025-11-17 21:13:55','2025-11-17 21:13:55',NULL,'public'),(165,0,'56','56',9,'image/jpeg',33268,'cars/56.jpg','[]','2025-11-17 21:13:55','2025-11-17 21:13:55',NULL,'public'),(166,0,'57','57',9,'image/jpeg',33268,'cars/57.jpg','[]','2025-11-17 21:13:56','2025-11-17 21:13:56',NULL,'public'),(167,0,'58','58',9,'image/jpeg',33268,'cars/58.jpg','[]','2025-11-17 21:13:56','2025-11-17 21:13:56',NULL,'public'),(168,0,'59','59',9,'image/jpeg',33268,'cars/59.jpg','[]','2025-11-17 21:13:56','2025-11-17 21:13:56',NULL,'public'),(169,0,'6','6',9,'image/jpeg',33268,'cars/6.jpg','[]','2025-11-17 21:13:57','2025-11-17 21:13:57',NULL,'public'),(170,0,'60','60',9,'image/jpeg',33268,'cars/60.jpg','[]','2025-11-17 21:13:57','2025-11-17 21:13:57',NULL,'public'),(171,0,'61','61',9,'image/jpeg',33268,'cars/61.jpg','[]','2025-11-17 21:13:57','2025-11-17 21:13:57',NULL,'public'),(172,0,'62','62',9,'image/jpeg',33268,'cars/62.jpg','[]','2025-11-17 21:13:58','2025-11-17 21:13:58',NULL,'public'),(173,0,'63','63',9,'image/jpeg',33268,'cars/63.jpg','[]','2025-11-17 21:13:58','2025-11-17 21:13:58',NULL,'public'),(174,0,'64','64',9,'image/jpeg',33268,'cars/64.jpg','[]','2025-11-17 21:13:59','2025-11-17 21:13:59',NULL,'public'),(175,0,'65','65',9,'image/jpeg',33268,'cars/65.jpg','[]','2025-11-17 21:13:59','2025-11-17 21:13:59',NULL,'public'),(176,0,'66','66',9,'image/jpeg',33268,'cars/66.jpg','[]','2025-11-17 21:13:59','2025-11-17 21:13:59',NULL,'public'),(177,0,'67','67',9,'image/jpeg',33268,'cars/67.jpg','[]','2025-11-17 21:14:00','2025-11-17 21:14:00',NULL,'public'),(178,0,'68','68',9,'image/jpeg',33268,'cars/68.jpg','[]','2025-11-17 21:14:00','2025-11-17 21:14:00',NULL,'public'),(179,0,'69','69',9,'image/jpeg',33268,'cars/69.jpg','[]','2025-11-17 21:14:00','2025-11-17 21:14:00',NULL,'public'),(180,0,'7','7',9,'image/jpeg',33268,'cars/7.jpg','[]','2025-11-17 21:14:01','2025-11-17 21:14:01',NULL,'public'),(181,0,'70','70',9,'image/jpeg',33268,'cars/70.jpg','[]','2025-11-17 21:14:01','2025-11-17 21:14:01',NULL,'public'),(182,0,'71','71',9,'image/jpeg',33268,'cars/71.jpg','[]','2025-11-17 21:14:01','2025-11-17 21:14:01',NULL,'public'),(183,0,'72','72',9,'image/jpeg',33268,'cars/72.jpg','[]','2025-11-17 21:14:02','2025-11-17 21:14:02',NULL,'public'),(184,0,'73','73',9,'image/jpeg',33268,'cars/73.jpg','[]','2025-11-17 21:14:02','2025-11-17 21:14:02',NULL,'public'),(185,0,'74','74',9,'image/jpeg',33268,'cars/74.jpg','[]','2025-11-17 21:14:03','2025-11-17 21:14:03',NULL,'public'),(186,0,'75','75',9,'image/jpeg',33268,'cars/75.jpg','[]','2025-11-17 21:14:03','2025-11-17 21:14:03',NULL,'public'),(187,0,'76','76',9,'image/jpeg',33268,'cars/76.jpg','[]','2025-11-17 21:14:03','2025-11-17 21:14:03',NULL,'public'),(188,0,'77','77',9,'image/jpeg',33268,'cars/77.jpg','[]','2025-11-17 21:14:04','2025-11-17 21:14:04',NULL,'public'),(189,0,'78','78',9,'image/jpeg',33268,'cars/78.jpg','[]','2025-11-17 21:14:04','2025-11-17 21:14:04',NULL,'public'),(190,0,'79','79',9,'image/jpeg',33268,'cars/79.jpg','[]','2025-11-17 21:14:04','2025-11-17 21:14:04',NULL,'public'),(191,0,'8','8',9,'image/jpeg',33268,'cars/8.jpg','[]','2025-11-17 21:14:05','2025-11-17 21:14:05',NULL,'public'),(192,0,'80','80',9,'image/jpeg',33268,'cars/80.jpg','[]','2025-11-17 21:14:05','2025-11-17 21:14:05',NULL,'public'),(193,0,'81','81',9,'image/jpeg',33268,'cars/81.jpg','[]','2025-11-17 21:14:05','2025-11-17 21:14:05',NULL,'public'),(194,0,'82','82',9,'image/jpeg',33268,'cars/82.jpg','[]','2025-11-17 21:14:06','2025-11-17 21:14:06',NULL,'public'),(195,0,'83','83',9,'image/jpeg',33268,'cars/83.jpg','[]','2025-11-17 21:14:06','2025-11-17 21:14:06',NULL,'public'),(196,0,'84','84',9,'image/jpeg',33268,'cars/84.jpg','[]','2025-11-17 21:14:06','2025-11-17 21:14:06',NULL,'public'),(197,0,'85','85',9,'image/jpeg',33268,'cars/85.jpg','[]','2025-11-17 21:14:07','2025-11-17 21:14:07',NULL,'public'),(198,0,'86','86',9,'image/jpeg',33268,'cars/86.jpg','[]','2025-11-17 21:14:07','2025-11-17 21:14:07',NULL,'public'),(199,0,'87','87',9,'image/jpeg',33268,'cars/87.jpg','[]','2025-11-17 21:14:08','2025-11-17 21:14:08',NULL,'public'),(200,0,'88','88',9,'image/jpeg',33268,'cars/88.jpg','[]','2025-11-17 21:14:08','2025-11-17 21:14:08',NULL,'public'),(201,0,'89','89',9,'image/jpeg',33268,'cars/89.jpg','[]','2025-11-17 21:14:08','2025-11-17 21:14:08',NULL,'public'),(202,0,'9','9',9,'image/jpeg',33268,'cars/9.jpg','[]','2025-11-17 21:14:09','2025-11-17 21:14:09',NULL,'public'),(203,0,'90','90',9,'image/jpeg',33268,'cars/90.jpg','[]','2025-11-17 21:14:09','2025-11-17 21:14:09',NULL,'public'),(204,0,'91','91',9,'image/jpeg',33268,'cars/91.jpg','[]','2025-11-17 21:14:09','2025-11-17 21:14:09',NULL,'public'),(205,0,'92','92',9,'image/jpeg',33268,'cars/92.jpg','[]','2025-11-17 21:14:10','2025-11-17 21:14:10',NULL,'public'),(206,0,'93','93',9,'image/jpeg',33268,'cars/93.jpg','[]','2025-11-17 21:14:10','2025-11-17 21:14:10',NULL,'public'),(207,0,'94','94',9,'image/jpeg',33268,'cars/94.jpg','[]','2025-11-17 21:14:10','2025-11-17 21:14:10',NULL,'public'),(208,0,'95','95',9,'image/jpeg',33268,'cars/95.jpg','[]','2025-11-17 21:14:11','2025-11-17 21:14:11',NULL,'public'),(209,0,'96','96',9,'image/jpeg',33268,'cars/96.jpg','[]','2025-11-17 21:14:11','2025-11-17 21:14:11',NULL,'public'),(210,0,'97','97',9,'image/jpeg',33268,'cars/97.jpg','[]','2025-11-17 21:14:11','2025-11-17 21:14:11',NULL,'public'),(211,0,'98','98',9,'image/jpeg',33268,'cars/98.jpg','[]','2025-11-17 21:14:12','2025-11-17 21:14:12',NULL,'public'),(212,0,'99','99',9,'image/jpeg',33268,'cars/99.jpg','[]','2025-11-17 21:14:12','2025-11-17 21:14:12',NULL,'public'),(213,0,'car-1','car-1',9,'image/jpeg',33268,'cars/car-1.jpg','[]','2025-11-17 21:14:13','2025-11-17 21:14:13',NULL,'public'),(214,0,'car-2','car-2',9,'image/jpeg',33268,'cars/car-2.jpg','[]','2025-11-17 21:14:13','2025-11-17 21:14:13',NULL,'public'),(215,0,'car-3','car-3',9,'image/jpeg',33268,'cars/car-3.jpg','[]','2025-11-17 21:14:13','2025-11-17 21:14:13',NULL,'public'),(216,0,'car-4','car-4',9,'image/jpeg',33268,'cars/car-4.jpg','[]','2025-11-17 21:14:14','2025-11-17 21:14:14',NULL,'public'),(217,0,'car-5','car-5',9,'image/jpeg',33268,'cars/car-5.jpg','[]','2025-11-17 21:14:14','2025-11-17 21:14:14',NULL,'public'),(218,0,'car-6','car-6',9,'image/jpeg',33268,'cars/car-6.jpg','[]','2025-11-17 21:14:14','2025-11-17 21:14:14',NULL,'public'),(219,0,'car-7','car-7',9,'image/jpeg',33268,'cars/car-7.jpg','[]','2025-11-17 21:14:15','2025-11-17 21:14:15',NULL,'public'),(220,0,'car-8','car-8',9,'image/jpeg',33268,'cars/car-8.jpg','[]','2025-11-17 21:14:15','2025-11-17 21:14:15',NULL,'public'),(221,0,'car-interiors-1','car-interiors-1',9,'image/jpeg',33268,'cars/car-interiors-1.jpg','[]','2025-11-17 21:14:15','2025-11-17 21:14:15',NULL,'public'),(222,0,'car-interiors-2','car-interiors-2',9,'image/jpeg',33268,'cars/car-interiors-2.jpg','[]','2025-11-17 21:14:16','2025-11-17 21:14:16',NULL,'public'),(223,0,'car-interiors-3','car-interiors-3',9,'image/jpeg',33268,'cars/car-interiors-3.jpg','[]','2025-11-17 21:14:16','2025-11-17 21:14:16',NULL,'public'),(224,0,'car-interiors-4','car-interiors-4',9,'image/jpeg',33268,'cars/car-interiors-4.jpg','[]','2025-11-17 21:14:16','2025-11-17 21:14:16',NULL,'public'),(225,0,'car-interiors-5','car-interiors-5',9,'image/jpeg',33268,'cars/car-interiors-5.jpg','[]','2025-11-17 21:14:17','2025-11-17 21:14:17',NULL,'public'),(226,0,'car-interiors-6','car-interiors-6',9,'image/jpeg',33268,'cars/car-interiors-6.jpg','[]','2025-11-17 21:14:17','2025-11-17 21:14:17',NULL,'public'),(227,0,'car-interiors-7','car-interiors-7',9,'image/jpeg',33268,'cars/car-interiors-7.jpg','[]','2025-11-17 21:14:18','2025-11-17 21:14:18',NULL,'public'),(228,0,'car-interiors-8','car-interiors-8',9,'image/jpeg',33268,'cars/car-interiors-8.jpg','[]','2025-11-17 21:14:18','2025-11-17 21:14:18',NULL,'public'),(229,0,'img-1','img-1',9,'image/png',33268,'cars/img-1.png','[]','2025-11-17 21:14:18','2025-11-17 21:14:18',NULL,'public'),(230,0,'img-2','img-2',9,'image/png',33268,'cars/img-2.png','[]','2025-11-17 21:14:19','2025-11-17 21:14:19',NULL,'public'),(231,0,'banner-1','banner-1',10,'image/jpeg',23738,'sliders/banner-1.jpg','[]','2025-11-17 21:14:22','2025-11-17 21:14:22',NULL,'public'),(232,0,'banner-2','banner-2',10,'image/jpeg',23738,'sliders/banner-2.jpg','[]','2025-11-17 21:14:22','2025-11-17 21:14:22',NULL,'public'),(233,0,'img-1-1','img-1-1',10,'image/jpeg',23738,'sliders/img-1-1.jpg','[]','2025-11-17 21:14:22','2025-11-17 21:14:22',NULL,'public'),(234,0,'img-1','img-1',10,'image/jpeg',23738,'sliders/img-1.jpg','[]','2025-11-17 21:14:23','2025-11-17 21:14:23',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'general',NULL,'general',0,'2025-11-17 21:13:00','2025-11-17 21:13:00',NULL),(3,0,'news',NULL,'news',0,'2025-11-17 21:13:08','2025-11-17 21:13:08',NULL),(4,0,'galleries',NULL,'galleries',0,'2025-11-17 21:13:14','2025-11-17 21:13:14',NULL),(5,0,'teams',NULL,'teams',0,'2025-11-17 21:13:17','2025-11-17 21:13:17',NULL),(6,0,'testimonials',NULL,'testimonials',0,'2025-11-17 21:13:18','2025-11-17 21:13:18',NULL),(7,0,'locations',NULL,'locations',0,'2025-11-17 21:13:19','2025-11-17 21:13:19',NULL),(8,0,'customers',NULL,'customers',0,'2025-11-17 21:13:21','2025-11-17 21:13:21',NULL),(9,0,'cars',NULL,'cars',0,'2025-11-17 21:13:35','2025-11-17 21:13:35',NULL),(10,0,'sliders',NULL,'sliders',0,'2025-11-17 21:14:22','2025-11-17 21:14:22',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-11-17 21:13:08','2025-11-17 21:13:08');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(2,1,1,NULL,NULL,'https://carento.botble.com',NULL,0,'Home Page v1',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(3,1,1,NULL,NULL,'https://carento-home-2.botble.com',NULL,1,'Home Page v2',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(4,1,1,NULL,NULL,'https://carento-home-3.botble.com',NULL,2,'Home Page v3',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(5,1,0,NULL,NULL,'/',NULL,1,'Vehicles',NULL,'_self',1,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(6,1,5,7,'Botble\\Page\\Models\\Page','/car-list-1',NULL,0,'Cars List v1',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(7,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024',NULL,1,'Car Detail v1',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(8,1,5,8,'Botble\\Page\\Models\\Page','/car-list-2',NULL,2,'Car List v2',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(9,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-2',NULL,3,'Car Detail v2',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(10,1,5,9,'Botble\\Page\\Models\\Page','/car-list-3',NULL,4,'Car List v3',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(11,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-3',NULL,5,'Car Detail v3',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(12,1,5,10,'Botble\\Page\\Models\\Page','/car-list-4',NULL,6,'Car List v4',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(13,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-4',NULL,7,'Car Detail v4',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(14,1,0,NULL,NULL,'/',NULL,2,'Pages',NULL,'_self',1,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(15,1,14,6,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'About Us',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(16,1,14,4,'Botble\\Page\\Models\\Page','/services',NULL,1,'Our Services',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(17,1,14,5,'Botble\\Page\\Models\\Page','/pricing',NULL,2,'Pricing',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(18,1,14,12,'Botble\\Page\\Models\\Page','/faqs',NULL,3,'FAQs',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(19,1,14,14,'Botble\\Page\\Models\\Page','/car-dealers',NULL,4,'Car Dealers',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(20,1,14,17,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,5,'Term',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(21,1,14,NULL,NULL,'/login',NULL,6,'Login',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(22,1,14,NULL,NULL,'/register',NULL,7,'Register',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(23,1,0,NULL,NULL,'/',NULL,3,'News',NULL,'_self',1,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(24,1,23,2,'Botble\\Page\\Models\\Page','/blog',NULL,0,'News Grid',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(25,1,23,NULL,NULL,'/blog?style=list',NULL,1,'News List',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(26,1,23,NULL,NULL,'/news/top-5-new-cars-to-look-out-for-in-2024',NULL,2,'New Detail',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08'),(27,1,0,3,'Botble\\Page\\Models\\Page','/contact',NULL,4,'Contact',NULL,'_self',0,'2025-11-17 21:13:08','2025-11-17 21:13:08');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-11-17 21:13:08','2025-11-17 21:13:08');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'content_on_top','[\"[car-advance-search button_search_name=\\\"Find a Vehicle\\\" link_need_help=\\\"\\/faqs\\\" top=\\\"0\\\" bottom=\\\"0\\\" left=\\\"0\\\" right=\\\"0\\\" url=\\\"\\/cars\\\" tabs=\\\"all,new_car,used_car\\\"][\\/car-advance-search]\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:13:07','2025-11-17 21:13:07'),(2,'footer_on_top','[\"<p><span class=\\\"text-lg-medium color-white\\\">Get 5% discount when <\\/span><a class=\\\"text-primary\\\" href=\\\"#install-app\\\"><span class=\\\"text-lg-medium\\\">Ordering via APP<\\/span><\\/a><\\/p>\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:13:07','2025-11-17 21:13:07'),(3,'label_top','[\"+3600 cars for you\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(4,'keywords','[[{\"name\":\"Economy\",\"link\":\"\\/\"},{\"name\":\"Standard\",\"link\":\"\\/\"},{\"name\":\"Luxury\",\"link\":\"\\/\"},{\"name\":\"SUV\",\"link\":\"\\/\"},{\"name\":\"Convertible\",\"link\":\"\\/\"}]]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(5,'label_top','[\"Best car rental system\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(6,'keywords','[[{\"name\":\"Economy\",\"link\":\"\\/\"},{\"name\":\"Standard\",\"link\":\"\\/\"},{\"name\":\"Luxury\",\"link\":\"\\/\"},{\"name\":\"SUV\",\"link\":\"\\/\"},{\"name\":\"Convertible\",\"link\":\"\\/\"}]]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(7,'appearance','[\"style-2\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:13:07','2025-11-17 21:13:07'),(8,'subtitle','[\"2025 Mazda CX-50 <br class=\\\"d-none d-md-block\\\"> Review and news\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(9,'link_label','[\"View Details\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(10,'subtitle','[\"Hyundai Tucson Plug-In <br class=\\\"d-none d-md-block\\\"> Hybrid 2025 review\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(11,'link_label','[\"View Details\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:13:07','2025-11-17 21:13:07'),(12,'breadcrumb_simple','[true]',2,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(13,'breadcrumb_background_image','[\"backgrounds\\/contact-bg.jpg\"]',3,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(14,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(15,'breadcrumb_background_image','[\"backgrounds\\/service-bg.jpg\"]',4,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(16,'breadcrumb_text_color','[\"#ffffff\"]',4,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(17,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',5,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(18,'breadcrumb_text_color','[\"#ffffff\"]',5,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(19,'breadcrumb_background_image','[\"backgrounds\\/about-us-bg.jpg\"]',6,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(20,'breadcrumb_text_color','[\"#ffffff\"]',6,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(21,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(22,'breadcrumb_text_color','[\"#ffffff\"]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(23,'breadcrumb_display_last_update','[true]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(24,'breadcrumb_simple','[true]',12,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(25,'breadcrumb_background_image','[\"backgrounds\\/brand-bg.jpg\"]',13,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(26,'breadcrumb_text_color','[\"#ffffff\"]',13,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(27,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',14,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(28,'breadcrumb_text_color','[\"#ffffff\"]',14,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(29,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',15,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(30,'breadcrumb_text_color','[\"#ffffff\"]',15,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(31,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',16,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(32,'breadcrumb_text_color','[\"#ffffff\"]',16,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(33,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',17,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(34,'breadcrumb_text_color','[\"#ffffff\"]',17,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(35,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',18,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(36,'breadcrumb_text_color','[\"#ffffff\"]',18,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(37,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',19,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(38,'breadcrumb_text_color','[\"#ffffff\"]',19,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(39,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',20,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(40,'breadcrumb_text_color','[\"#ffffff\"]',20,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(41,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',21,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(42,'breadcrumb_text_color','[\"#ffffff\"]',21,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(43,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',22,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(44,'breadcrumb_text_color','[\"#ffffff\"]',22,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(45,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',23,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(46,'breadcrumb_text_color','[\"#ffffff\"]',23,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(47,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',24,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(48,'breadcrumb_text_color','[\"#ffffff\"]',24,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(49,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',25,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(50,'breadcrumb_text_color','[\"#ffffff\"]',25,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(51,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',26,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(52,'breadcrumb_text_color','[\"#ffffff\"]',26,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(53,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',27,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(54,'breadcrumb_text_color','[\"#ffffff\"]',27,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(55,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',28,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(56,'breadcrumb_text_color','[\"#ffffff\"]',28,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(57,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',29,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(58,'breadcrumb_text_color','[\"#ffffff\"]',29,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(59,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',30,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(60,'breadcrumb_text_color','[\"#ffffff\"]',30,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(61,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',31,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(62,'breadcrumb_text_color','[\"#ffffff\"]',31,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(63,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',32,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(64,'breadcrumb_text_color','[\"#ffffff\"]',32,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(65,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',33,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(66,'breadcrumb_text_color','[\"#ffffff\"]',33,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(67,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',34,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(68,'breadcrumb_text_color','[\"#ffffff\"]',34,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(69,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',35,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(70,'breadcrumb_text_color','[\"#ffffff\"]',35,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(71,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',36,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(72,'breadcrumb_text_color','[\"#ffffff\"]',36,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(73,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',37,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(74,'breadcrumb_text_color','[\"#ffffff\"]',37,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(75,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',38,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(76,'breadcrumb_text_color','[\"#ffffff\"]',38,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(77,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',39,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(78,'breadcrumb_text_color','[\"#ffffff\"]',39,'Botble\\Page\\Models\\Page','2025-11-17 21:13:07','2025-11-17 21:13:07'),(79,'logo','[\"icons\\/activity.png\"]',1,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(80,'logo_dark','[\"icons\\/activity-w.png\"]',1,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(81,'logo','[\"icons\\/flash.png\"]',2,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(82,'logo_dark','[\"icons\\/flash-w.png\"]',2,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(83,'logo','[\"icons\\/list.png\"]',3,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(84,'logo_dark','[\"icons\\/list-w.png\"]',3,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(85,'logo','[\"icons\\/refresh.png\"]',4,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(86,'logo_dark','[\"icons\\/refresh-w.png\"]',4,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(87,'logo','[\"icons\\/ticket.png\"]',5,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(88,'logo_dark','[\"icons\\/ticket-w.png\"]',5,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(89,'logo','[\"icons\\/user.png\"]',6,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(90,'logo_dark','[\"icons\\/user-w.png\"]',6,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(91,'logo','[\"icons\\/ticket.png\"]',7,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(92,'logo_dark','[\"icons\\/ticket-w.png\"]',7,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(93,'logo','[\"icons\\/wallet.png\"]',8,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(94,'logo_dark','[\"icons\\/wallet-w.png\"]',8,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:13:16','2025-11-17 21:13:16'),(95,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:13:19','2025-11-17 21:13:19'),(96,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:13:19','2025-11-17 21:13:19'),(97,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:13:19','2025-11-17 21:13:19'),(98,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:13:19','2025-11-17 21:13:19'),(99,'logo_dark','[\"icons\\/lexus-w.png\"]',1,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(100,'logo_invert','[\"icons\\/lexus-w.png\"]',1,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(101,'logo_dark','[\"icons\\/mer-w.png\"]',2,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(102,'logo_invert','[\"icons\\/mer-i.png\"]',2,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(103,'logo_dark','[\"icons\\/bugatti-w.png\"]',3,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(104,'logo_invert','[\"icons\\/bugatti-w.png\"]',3,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(105,'logo_dark','[\"icons\\/jaguar-w.png\"]',4,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(106,'logo_invert','[\"icons\\/jaguar-w.png\"]',4,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(107,'logo_dark','[\"icons\\/honda-w.png\"]',5,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(108,'logo_invert','[\"icons\\/honda-w.png\"]',5,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(109,'logo_dark','[\"icons\\/chevrolet-w.png\"]',6,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(110,'logo_invert','[\"icons\\/chevrolet-w.png\"]',6,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(111,'logo_dark','[\"icons\\/acura-w.png\"]',7,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(112,'logo_invert','[\"icons\\/acura-w.png\"]',7,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(113,'logo_dark','[\"icons\\/bmw-w.png\"]',8,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(114,'logo_invert','[\"icons\\/bmw-i.png\"]',8,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(115,'logo_dark','[\"icons\\/toyota-w.png\"]',9,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(116,'logo_invert','[\"icons\\/toyota-i.png\"]',9,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(117,'logo_dark','[\"icons\\/ford-i.png\"]',10,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(118,'logo_invert','[\"icons\\/ford-i.png\"]',10,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(119,'logo_dark','[\"icons\\/nissan-w.png\"]',11,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(120,'logo_invert','[\"icons\\/nissan-i.png\"]',11,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(121,'logo_dark','[\"icons\\/opel-w.png\"]',12,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(122,'logo_invert','[\"icons\\/opel-i.png\"]',12,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(123,'logo_dark','[\"icons\\/bmw-w.png\"]',13,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(124,'logo_invert','[\"icons\\/bmw-i.png\"]',13,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(125,'logo_dark','[\"icons\\/toyota-w.png\"]',14,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(126,'logo_invert','[\"icons\\/toyota-i.png\"]',14,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:13:34','2025-11-17 21:13:34'),(127,'faq_ids','[[3,4,6,7,10]]',1,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(128,'faq_ids','[[2,3,5,7,9]]',2,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(129,'faq_ids','[[4,5,6,7,10]]',3,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(130,'faq_ids','[[2,3,5,8,9]]',4,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(131,'faq_ids','[[1,2,4,5,6]]',5,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(132,'faq_ids','[[3,4,6,9,10]]',6,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(133,'faq_ids','[[1,2,4,7,9]]',7,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(134,'faq_ids','[[4,5,6,8,9]]',8,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(135,'faq_ids','[[1,3,4,5,6]]',9,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(136,'faq_ids','[[1,4,5,6,7]]',10,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(137,'faq_ids','[[1,5,6,7,10]]',11,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(138,'faq_ids','[[1,3,4,7,8]]',12,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(139,'faq_ids','[[1,4,8,9,10]]',13,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(140,'faq_ids','[[2,4,5,9,10]]',14,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(141,'faq_ids','[[1,3,4,7,10]]',15,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(142,'faq_ids','[[1,2,8,9,10]]',16,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(143,'faq_ids','[[3,4,6,7,8]]',17,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(144,'faq_ids','[[1,2,6,8,10]]',18,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(145,'faq_ids','[[2,3,4,5,6]]',19,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(146,'faq_ids','[[1,2,3,8,9]]',20,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(147,'faq_ids','[[3,5,6,7,9]]',21,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(148,'faq_ids','[[3,5,6,7,9]]',22,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(149,'faq_ids','[[1,5,8,9,10]]',23,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(150,'faq_ids','[[1,4,5,8,10]]',24,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(151,'faq_ids','[[6,7,8,9,10]]',25,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(152,'faq_ids','[[2,5,6,7,9]]',26,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(153,'faq_ids','[[2,5,7,9,10]]',27,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(154,'faq_ids','[[1,3,4,5,10]]',28,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(155,'faq_ids','[[2,3,5,7,8]]',29,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(156,'faq_ids','[[3,4,8,9,10]]',30,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(157,'faq_ids','[[2,4,5,6,8]]',31,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(158,'faq_ids','[[6,7,8,9,10]]',32,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(159,'faq_ids','[[2,3,5,7,10]]',33,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(160,'faq_ids','[[2,3,7,9,10]]',34,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(161,'faq_ids','[[2,3,7,8,10]]',35,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(162,'faq_ids','[[1,2,4,7,10]]',36,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(163,'faq_ids','[[3,6,7,9,10]]',37,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(164,'faq_ids','[[1,2,6,8,9]]',38,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(165,'faq_ids','[[2,3,4,8,10]]',39,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(166,'faq_ids','[[2,6,8,9,10]]',40,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(167,'faq_ids','[[1,4,5,6,7]]',41,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(168,'faq_ids','[[1,3,6,9,10]]',42,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(169,'faq_ids','[[4,5,8,9,10]]',43,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:19','2025-11-17 21:14:19'),(170,'faq_ids','[[2,3,4,6,8]]',44,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(171,'faq_ids','[[1,2,4,7,9]]',45,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(172,'faq_ids','[[3,4,6,7,10]]',46,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(173,'faq_ids','[[2,4,5,6,10]]',47,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(174,'faq_ids','[[2,4,5,7,10]]',48,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(175,'faq_ids','[[1,2,3,4,10]]',49,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(176,'faq_ids','[[1,3,5,7,10]]',50,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(177,'faq_ids','[[2,4,7,9,10]]',51,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(178,'faq_ids','[[3,4,5,7,10]]',52,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(179,'faq_ids','[[1,2,4,5,7]]',53,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(180,'faq_ids','[[5,6,7,8,10]]',54,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(181,'faq_ids','[[1,2,4,6,8]]',55,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(182,'faq_ids','[[3,4,6,7,8]]',56,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(183,'faq_ids','[[1,2,3,7,8]]',57,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(184,'faq_ids','[[1,4,8,9,10]]',58,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(185,'faq_ids','[[1,2,3,5,8]]',59,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(186,'faq_ids','[[3,4,6,7,10]]',60,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(187,'faq_ids','[[2,3,4,5,9]]',61,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(188,'faq_ids','[[1,5,7,8,10]]',62,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(189,'faq_ids','[[3,4,5,6,8]]',63,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(190,'faq_ids','[[1,3,4,5,8]]',64,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(191,'faq_ids','[[1,2,5,7,8]]',65,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(192,'faq_ids','[[1,4,5,8,10]]',66,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(193,'faq_ids','[[3,5,6,7,10]]',67,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(194,'faq_ids','[[1,2,5,6,7]]',68,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(195,'faq_ids','[[3,5,6,7,10]]',69,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(196,'faq_ids','[[1,4,5,8,10]]',70,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(197,'faq_ids','[[4,6,7,8,9]]',71,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(198,'faq_ids','[[2,3,4,5,6]]',72,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(199,'faq_ids','[[1,4,5,7,8]]',73,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(200,'faq_ids','[[1,4,7,9,10]]',74,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(201,'faq_ids','[[3,4,7,9,10]]',75,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(202,'faq_ids','[[3,4,8,9,10]]',76,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(203,'faq_ids','[[2,3,5,8,9]]',77,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(204,'faq_ids','[[4,5,6,8,10]]',78,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(205,'faq_ids','[[2,5,7,8,9]]',79,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(206,'faq_ids','[[1,2,3,8,9]]',80,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(207,'faq_ids','[[1,4,5,7,10]]',81,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(208,'faq_ids','[[3,4,7,9,10]]',82,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(209,'faq_ids','[[1,6,7,8,10]]',83,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(210,'faq_ids','[[1,3,4,6,8]]',84,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(211,'faq_ids','[[2,3,5,8,10]]',85,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(212,'faq_ids','[[1,2,3,4,7]]',86,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(213,'faq_ids','[[1,4,6,8,9]]',87,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(214,'faq_ids','[[1,2,4,5,6]]',88,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(215,'faq_ids','[[1,2,4,5,6]]',89,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(216,'faq_ids','[[5,6,7,8,10]]',90,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(217,'faq_ids','[[1,2,4,6,9]]',91,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(218,'faq_ids','[[4,6,7,8,9]]',92,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(219,'faq_ids','[[3,4,5,6,9]]',93,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(220,'faq_ids','[[2,3,4,5,10]]',94,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(221,'faq_ids','[[5,6,7,8,9]]',95,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(222,'faq_ids','[[3,7,8,9,10]]',96,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(223,'faq_ids','[[1,2,3,5,6]]',97,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(224,'faq_ids','[[1,2,3,6,7]]',98,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(225,'faq_ids','[[4,5,7,8,9]]',99,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20'),(226,'faq_ids','[[1,5,6,7,9]]',100,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:14:20','2025-11-17 21:14:20');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2021_02_16_092633_remove_default_value_for_author_type',1),(30,'2021_03_27_144913_add_customer_type_into_table_payments',1),(31,'2021_05_24_034720_make_column_currency_nullable',1),(32,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(33,'2021_10_19_020859_update_metadata_field',1),(34,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(35,'2021_12_03_030600_create_blog_translations',1),(36,'2021_12_03_075608_create_page_translations',1),(37,'2021_12_03_082134_create_faq_translations',1),(38,'2021_12_03_082953_create_gallery_translations',1),(39,'2021_12_03_083642_create_testimonials_translations',1),(40,'2021_12_03_084118_create_location_translations',1),(41,'2021_12_03_094518_migrate_old_location_data',1),(42,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(43,'2022_01_16_085908_improve_plugin_location',1),(44,'2022_04_19_113923_add_index_to_table_posts',1),(45,'2022_04_20_100851_add_index_to_media_table',1),(46,'2022_04_20_101046_add_index_to_menu_table',1),(47,'2022_04_30_034048_create_gallery_meta_translations_table',1),(48,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(49,'2022_07_07_153354_update_charge_id_in_table_payments',1),(50,'2022_07_10_034813_move_lang_folder_to_root',1),(51,'2022_08_04_051940_add_missing_column_expires_at',1),(52,'2022_08_04_052122_delete_location_backup_tables',1),(53,'2022_09_01_000001_create_admin_notifications_tables',1),(54,'2022_10_14_024629_drop_column_is_featured',1),(55,'2022_11_02_092723_team_create_team_table',1),(56,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(57,'2022_12_02_093615_update_slug_index_columns',1),(58,'2023_01_30_024431_add_alt_to_media_table',1),(59,'2023_02_16_042611_drop_table_password_resets',1),(60,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(61,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(62,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(63,'2023_07_06_011444_create_slug_translations_table',1),(64,'2023_07_26_041451_add_more_columns_to_location_table',1),(65,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(66,'2023_08_11_060908_create_announcements_table',1),(67,'2023_08_11_094574_update_team_table',1),(68,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(69,'2023_08_21_090810_make_page_content_nullable',1),(70,'2023_08_29_074620_make_column_author_id_nullable',1),(71,'2023_08_29_075308_make_column_user_id_nullable',1),(72,'2023_09_14_021936_update_index_for_slugs_table',1),(73,'2023_09_14_022423_add_index_for_language_table',1),(74,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(75,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(76,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(77,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(78,'2023_11_30_085354_add_missing_description_to_team',1),(79,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(80,'2023_12_12_105220_drop_translations_table',1),(81,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(82,'2024_01_16_050056_create_comments_table',1),(83,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(84,'2024_03_25_000001_update_captcha_settings_for_contact',1),(85,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(86,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(87,'2024_04_19_063914_create_custom_fields_table',1),(88,'2024_04_27_100730_improve_analytics_setting',1),(89,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(90,'2024_07_04_083133_create_payment_logs_table',1),(91,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(92,'2024_07_12_100000_change_random_hash_for_media',1),(93,'2024_07_30_091615_fix_order_column_in_categories_table',1),(94,'2024_08_17_094600_add_image_into_countries',1),(95,'2024_08_22_062602_create_car_rentals_tables',1),(96,'2024_08_28_154009_create_cr_car_addresses',1),(97,'2024_09_05_151532_add_column_addresses_cars_table',1),(98,'2024_09_11_151251_create_cr_car_categories',1),(99,'2024_09_30_024515_create_sessions_table',1),(100,'2024_10_02_030027_add_more_columns_to_teams_translations_table',1),(101,'2024_12_11_044552_add_author_to_table_cr_cars',1),(102,'2024_12_11_082630_create_cr_messages_table',1),(103,'2024_12_12_034118_add_is_vendor_to_cr_customers',1),(104,'2024_12_12_082259_add_phone_to_table_cr_messages',1),(105,'2024_12_12_093603_add_vendor_verified_at_to_table_cr_customers',1),(106,'2024_12_19_000001_create_device_tokens_table',1),(107,'2024_12_19_000002_create_push_notifications_table',1),(108,'2024_12_19_000003_create_push_notification_recipients_table',1),(109,'2024_12_20_064621_add_moderation_status_to_cr_cars',1),(110,'2024_12_30_000001_create_user_settings_table',1),(111,'2024_12_30_022046_add_vendor_id_to_cr_bookings_table',1),(112,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(113,'2025_01_08_093652_add_zip_code_to_cities',1),(114,'2025_01_15_000000_add_completion_fields_to_cr_bookings_table',1),(115,'2025_01_17_043153_improve_invoices_table',1),(116,'2025_02_10_040833_add_reject_reason_to_cars',1),(117,'2025_02_11_153025_add_action_label_to_announcement_translations',1),(118,'2025_02_20_075043_improve_cr_cars_table',1),(119,'2025_03_23_075418_add_selling_features_to_cr_cars_table',1),(120,'2025_04_02_000000_rename_car_rentals_enabled_rental_booking_setting',1),(121,'2025_04_08_040931_create_social_logins_table',1),(122,'2025_04_10_000000_update_cr_taxes_table',1),(123,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(124,'2025_04_14_000001_create_category_commissions_table',1),(125,'2025_04_14_000002_create_customer_revenues_table',1),(126,'2025_04_14_000003_add_balance_column_to_customers_table',1),(127,'2025_04_14_000004_add_vendor_id_column_to_bookings_table',1),(128,'2025_04_14_000005_add_vendor_id_column_to_cars_table',1),(129,'2025_04_14_000006_create_customer_withdrawals_table',1),(130,'2025_04_14_000007_add_bank_info_to_customers_table',1),(131,'2025_04_20_081632_rename_current_location_to_location_in_cr_cars_table',1),(132,'2025_04_22_102623_set_moderation_status_to_approved_for_existing_cars',1),(133,'2025_04_23_000000_add_external_booking_url_to_cr_cars_table',1),(134,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(135,'2025_05_13_000000_add_price_type_column_to_cr_services_table',1),(136,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1),(137,'2025_06_04_000000_add_horsepower_to_cr_cars_table',1),(138,'2025_07_06_030754_add_phone_to_users_table',1),(139,'2025_07_11_160139_add_order_column_to_cr_car_makes_table',1),(140,'2025_07_11_160140_add_order_column_to_cr_car_types_table',1),(141,'2025_07_11_160141_add_order_column_to_cr_car_transmissions_table',1),(142,'2025_07_11_160142_add_order_column_to_cr_car_fuels_table',1),(143,'2025_07_11_160143_add_order_column_to_cr_car_addresses_table',1),(144,'2025_07_11_160144_add_order_column_to_cr_car_amenities_table',1),(145,'2025_07_11_160145_add_order_column_to_cr_car_colors_table',1),(146,'2025_07_14_014535_add_currency_tables_to_car_rentals',1),(147,'2025_07_14_025000_simplify_currency_implementation',1),(148,'2025_07_14_030502_add_currency_id_to_cr_services_table',1),(149,'2025_07_23_000000_create_car_amenity_categories_table',1),(150,'2025_07_23_000001_add_category_id_to_car_amenities_table',1),(151,'2025_07_23_add_icon_column_to_cr_car_amenities_table',1),(152,'2025_07_23_add_icon_column_to_cr_car_types_table',1),(153,'2025_07_31_083459_add_indexes_for_location_search_performance',1),(154,'2025_07_31_add_performance_indexes_to_slugs_table',1),(155,'2025_08_07_090752_add_verification_fields_to_cr_customers_table',1),(156,'2025_08_11_055037_add_location_fields_to_cr_cars_table',1),(157,'2025_08_11_063447_remove_address_fields_from_cr_cars_table',1),(158,'2025_08_11_064405_migrate_car_addresses_to_cities',1),(159,'2025_08_11_091336_add_address_to_cr_cars_table',1),(160,'2025_10_10_200000_add_advanced_fields_to_cr_currencies_table',1),(161,'2025_10_22_000001_add_whatsapp_to_cr_customers_table',1),(162,'2025_10_29_100000_add_sessions_invalidated_at_to_users_table',1),(163,'2025_11_07_000001_add_actor_type_to_audit_histories_table',1),(164,'2025_11_10_000000_cleanup_duplicate_widgets',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[simple-slider key=&quot;home-slider&quot; style=&quot;style-3&quot;][/simple-slider][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/cars&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; url=&quot;/cars&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][cars style=&quot;style-popular&quot; title=&quot;Popular Vehicles&quot; subtitle=&quot;Favorite vehicles based on customer reviews&quot; filter_types=&quot;category,fuel_type,order,price_range&quot; limit=&quot;8&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/cars][brands title=&quot;Premium Brands&quot; subtitle=&quot;Unveil the Finest Selection of High-End Vehicles&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;Show All Brands&quot; button_url=&quot;/brands&quot;][/brands][why-us sub_title=&quot;HOW IT WORKS&quot; title=&quot;Presenting Your New Go-To Car &lt;br&gt; Rental Experience&quot; card_image_1=&quot;icons/car-location.png&quot; card_title_1=&quot;Choose a Location&quot; card_content_1=&quot;Select the ideal destination to begin your journey with ease&quot; card_image_2=&quot;icons/car-selected.png&quot; card_title_2=&quot;Choose Your Vehicle&quot; card_content_2=&quot;Browse our fleet and find the perfect car for your needs&quot; card_image_3=&quot;icons/car.png&quot; card_title_3=&quot;Verification&quot; card_content_3=&quot;Review your information and confirm your booking&quot; card_image_4=&quot;icons/car-key.png&quot; card_title_4=&quot;Begin Your Journey&quot; card_content_4=&quot;Start your adventure with confidence and ease&quot; quantity=&quot;4&quot;][/why-us][simple-banners title_1=&quot;Looking for a rental car?&quot; subtitle_1=&quot;Discover your ideal rental car for every adventure, &lt;br&gt;whether it&#039;s a road trip or business travel&quot; image_1=&quot;cars/img-1.png&quot; button_url_1=&quot;/cars&quot; button_name_1=&quot;Get Started Now&quot; button_color_1=&quot;#70f46d&quot; background_color_1=&quot;#9dd3fb&quot; title_2=&quot;Looking for a rental car?&quot; subtitle_2=&quot;Maximize your vehicle&#039;s potential: seamlessly &lt;br&gt; rent or sell with confidence&quot; image_2=&quot;cars/img-2.png&quot; button_url_2=&quot;/cars&quot; button_name_2=&quot;Get Started Now&quot; button_color_2=&quot;#ffffff&quot; background_color_2=&quot;#ffec88&quot; quantity=&quot;2&quot;][/simple-banners][featured-block style=&quot;style-2&quot; title=&quot;Sell your car at a fair price.&lt;br /&gt; Get started with us today.&quot; subtitle=&quot;Best Car Rental System&quot; description=&quot;We are committed to delivering exceptional service, competitive pricing, and a diverse selection of options for our customers&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot; 24/7 customer support for assistance anytime, anywhere&quot; image_1=&quot;general/img-2-1.png&quot; image_2=&quot;general/img-2-2.png&quot; image_3=&quot;general/img-2-3.png&quot; image_4=&quot;general/img-2-4.png&quot; enable_lazy_loading=&quot;no&quot;][/featured-block][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot;][/site-statistics][car-types title=&quot;Browse by Type&quot; sub_title=&quot;Find the perfect ride for any occasion&quot; car_types=&quot;1,2,3,4,5,6,7,8&quot; redirect_url=&quot;/cars&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/car-types][car-loan-form style=&quot;style-3&quot; form_url=&quot;/contact&quot; form_title=&quot;Car Loan Calculator&quot; form_description=&quot;Estimate your monthly auto loan payments with this calculator.&quot; form_button_label=&quot;Apply for a loan&quot; background_image=&quot;backgrounds/car-loan-form-bg-2.jpg&quot; enable_lazy_loading=&quot;&quot;][/car-loan-form][cars style=&quot;style-feature&quot; title=&quot;Featured Listings&quot; subtitle=&quot;Find the perfect ride for any occasion&quot; limit=&quot;4&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/cars][testimonials title=&quot;What our customers say&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot; style=&quot;style-3&quot; enable_lazy_loading=&quot;&quot;][/testimonials][cars-by-locations title=&quot;Available Car Rentals&quot; main_content=&quot;Choose the location that suits your journey and start exploring today&quot; city_ids=&quot;1,2,3,5,6&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot; redirect_url=&quot;/cars&quot;][/cars-by-locations][simple-slider key=&quot;home-slider-02&quot; style=&quot;style-2&quot;][/simple-slider][team title=&quot;Meet Our Agents&quot; subtitle=&quot;Awesome Teams&quot; team_ids=&quot;1,2,3,5&quot;][/team][blog-posts title=&quot;Upcoming Cars &amp; Events&quot; subtitle=&quot;Stay ahead with the latest car releases and upcoming events&quot; button_label=&quot;Keep Reading&quot; category_ids=&quot;1,2,3,4,5,6,7,8,9,10&quot; limit=&quot;10&quot;][/blog-posts][install-apps style=&quot;style-3&quot; title=&quot;Carento App is Available&quot; description=&quot;Install App&quot; apps_description=&quot;Manage all your car rentals on the go with the Carento app&quot; android_app_url=&quot;/contact&quot; android_app_image=&quot;general/googleplay.png&quot; ios_app_url=&quot;/contact&quot; ios_app_image=&quot;general/appstore.png&quot; decor_image=&quot;general/phone.png&quot; button_label=&quot;Download Apps&quot; button_url=&quot;/contact&quot; background_color=&quot;#f2f4f6&quot;][/install-apps]',1,NULL,'homepage',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(2,'Blog','',1,NULL,'blog-with-sidebar',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(3,'Contact','[branch-locations title=\"Our agents worldwide\" quantity=\"4\" name_1=\"New York\" icon_image_1=\"icons/sedan-car-model.png\" phone_1=\"+1 212 555 0146\" email_1=\"newyork@carento.com\" address_1=\"750 7th Avenue, Manhattan, New York, NY 10019, USA\" name_2=\"Tokyo\" icon_image_2=\"icons/car-city-model.png\" phone_2=\"+81 3 3456 7890\" email_2=\"tokyo@carento.com\" address_2=\"2-11-3 Meguro, Meguro City, Tokyo 153-0063, Japan\" name_3=\"Paris\" icon_image_3=\"icons/jeep.png\" phone_3=\"+33 1 42 68 53 00\" email_3=\"paris@carento.com\" address_3=\"22 Rue de la Paix, 75002 Paris, France\" name_4=\"Sydney\" icon_image_4=\"icons/pick-up.png\" phone_4=\"+61 2 9255 6000\" email_4=\"sydney@carento.com\" address_4=\"88 George Street, The Rocks, Sydney NSW 2000, Australia\"][/branch-locations][contact-form display_fields=\"phone,email,subject,address\" mandatory_fields=\"email\" title=\"Get in Touch\" show_map=\"0,1\" map_title=\"Our location\" map_address=\"12560 Rental Rd, Memphis, TN 38118, United States\"][/contact-form]',1,NULL,NULL,NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(4,'Services','[car-services title=\"Comprehensive Car Rental Services to Meet All Your Needs\" description=\"From daily rentals to long-term solutions, we offer a comprehensive range of vehicles and services to suit every need and budget.\" limit=\"10\"][/car-services][promotion-block title=\"Best Car Rent Deals\" subtitle=\"Save 15% or more when you book and ride before 1 April 2025\" button_label=\"Find Early 2025 Deals\" button_url=\"/cars\" background_image=\"backgrounds/promotion-block-bg.jpg\"][/promotion-block][testimonials title=\"What they say about us?\" subtitle=\"Testimonials\" testimonial_ids=\"1,2,3,4\" style=\"style-2\" enable_lazy_loading=\"\"][/testimonials][intro-video title=\"Receive a Competitive Offer Sell Your Car to Us Today.\" description=\"We are committed to delivering exceptional service, competitive pricing, and a diverse selection of options for our customers.\" subtitle=\"Best Car Rental System\" image=\"general/1.jpg\" content_1=\"Expert Certified Mechanics\" content_2=\"First Class Services\" content_3=\"Get Reasonable Price\" content_4=\"24/7 road assistance\" content_5=\"Genuine Spares Parts\" content_6=\"Free Pick-Up & Drop-Offs\" quantity=\"6\"][/intro-video][site-statistics quantity=\"5\" title_1=\"Global <br> Branches\" data_1=\"45\" unit_1=\"+\" title_2=\"Destinations  <br> Collaboration\" data_2=\"29\" unit_2=\"K\" title_3=\"Years <br> Experience\" data_3=\"20\" unit_3=\"+\" title_4=\"Happy <br> Customers\" data_4=\"168\" unit_4=\"K\" title_5=\"User  <br> Account\" data_5=\"15\" unit_5=\"M\"][/site-statistics][blog-posts style=\"style-1\" title=\"Upcoming Cars & Events\" subtitle=\"Stay ahead with the latest car releases and upcoming events\" button_label=\"Keep Reading\" category_ids=\"1,2,3,4,5\" limit=\"10\"][/blog-posts]',1,NULL,'full-width',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(5,'Pricing','[pricing title=\"Membership Plans\" button_label_monthly=\"Monthly Price\" button_label_yearly=\"Annual Price\" quantity=\"4\" name_1=\"Basic\" description_1=\"For most businesses that want to optimize web queries\" monthly_price_1=\"19\" yearly_price_1=\"348\" features_1=\"+ Access to standard vehicles \\n + 24/7 customer support \\n + Basic insurance coverage \\n + Online booking \\n + Standard roadside assistance \\n+ One free vehicle per month\" button_label_1=\"Get Started Now\" button_url_1=\"/\" name_2=\"Standard\" description_2=\"For most businesses that want to optimize web queries\" monthly_price_2=\"29\" yearly_price_2=\"348\" features_2=\"+ All Basic Plan features \\n + Access to premium vehicles \\n + Flexible rental terms \\n + GPS included \\n + Free additional driver \\n + Unlimited vehicle swaps\" button_label_2=\"Get Started Now\" button_url_2=\"/\" name_3=\"Premium\" description_3=\"For most businesses that want to optimize web queries\" monthly_price_3=\"49\" yearly_price_3=\"585\" features_3=\"+ All Standard Plan features \\n + Luxury vehicle options \\n + Complimentary upgrades \\n + Enhanced insurance coverage \\n + Free airport pickup, drop off \\n + Exclusive deals and offers\" button_label_3=\"Get Started Now\" button_url_3=\"/\" name_4=\"VIP\" description_4=\"For most businesses that want to optimize web queries\" monthly_price_4=\"99\" yearly_price_4=\"1185\" features_4=\"+ All Premium Plan features \\n + VIP transfer service \\n + Personal concierge \\n + Unlimited mileage \\n + Luxury vehicle upgrades \\n + 24/7 account manager\" button_label_4=\"Get Started Now\" button_url_4=\"/\"][/pricing][faqs title=\"Frequently Asked Questions\" description=\"Any questions? We would be happy to help you.\" faq_category_ids=\"1,2,3,4,5\" limit=\"10\" button_secondary_label=\"Contact Us\" button_secondary_url=\"/contact\" button_primary_label=\"Submit A Ticket\" button_primary_url=\"/\"][/faqs]',1,NULL,'full-width',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(6,'About Us','[about-us-information title=&quot;The Future of &lt;br&gt; Car Rental is Here&quot; description=&quot;Welcome to Carento, your trusted partner in car rentals. Since our founding, we have been committed to providing our customers with a seamless and reliable car rental experience. Whether you are planning a business trip, a family vacation, or just need a vehicle for everyday use, we offer a wide range of vehicles to meet your needs.&quot; quantity=&quot;3&quot; data_number_1=&quot;86&quot; data_title_1=&quot;Industry &lt;br&gt; Experts&quot; image_1=&quot;general/about-us-1.jpg&quot; image_2=&quot;general/about-us-2.jpg&quot; data_number_3=&quot;25&quot; data_title_3=&quot;Years in Business&quot; image_3=&quot;general/about-us-3.jpg&quot;][/about-us-information][why-us card_image_1=&quot;icons/car-location.png&quot; card_title_1=&quot;Choose a Location&quot; card_content_1=&quot;Select the ideal destination to begin your journey with ease&quot; card_image_2=&quot;icons/money.png&quot; card_title_2=&quot;Transparent Pricing&quot; card_content_2=&quot;Enjoy clear and upfront pricing with no surprises, ensuring you know exactly what you are paying for.&quot; card_image_3=&quot;icons/convenient.png&quot; card_title_3=&quot;Convenient Booking&quot; card_content_3=&quot;Benefit from a variety of rental options, including short-term, long-term, and weekend specials&quot; card_image_4=&quot;icons/supporter.png&quot; card_title_4=&quot;24/7 Customer Support&quot; card_content_4=&quot;Get assistance whenever you need it with our dedicated support team available around the clock.&quot; quantity=&quot;4&quot;][/why-us][team title=&quot;Meet Our Agents&quot; subtitle=&quot;Awesome Teams&quot; team_ids=&quot;1,2,3,5&quot;][/team][featured-block style=&quot;style-2&quot; title=&quot;Sell your car at a fair price. Get started with us today.&quot; subtitle=&quot;Our Mission&quot; description=&quot;Our mission is to make car rental easy, accessible, and affordable for everyone. We believe that renting a car should be a hassle-free experience, and we are dedicated to ensuring that every customer finds the perfect vehicle for their journey.&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot; 24/7 customer support for assistance anytime, anywhere&quot; image_1=&quot;general/img-2-1.png&quot; image_2=&quot;general/img-2-2.png&quot; image_3=&quot;general/img-2-3.png&quot; image_4=&quot;general/img-2-4.png&quot; enable_lazy_loading=&quot;no&quot;][/featured-block][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot; background_color=&quot;#d8f4db&quot;][/site-statistics][intro-video style=&quot;style-2&quot; title=&quot;Carento offers clear pricing and 24/7 great support.&quot; subtitle=&quot;Our Commitment&quot; description=&quot;We are committed to offering transparent pricing with no hidden fees, comprehensive insurance options for peace of mind, and 24/7 customer support to assist you whenever you need it. At Carento, your satisfaction is our top priority.&quot; youtube_video_url=&quot;https://www.youtube.com/watch?v=ldusxyoq0Y8&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot;24/7 customer support for assistance anytime, anywhere&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; image=&quot;general/3.jpg&quot; image_1=&quot;general/2.jpg&quot; enable_lazy_loading=&quot;&quot;][/intro-video][testimonials title=&quot;What they say about us?&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot; style=&quot;style-2&quot; enable_lazy_loading=&quot;&quot;][/testimonials][blog-posts style=&quot;style-1&quot; title=&quot;Upcoming Cars &amp; Events&quot; subtitle=&quot;Stay ahead with the latest car releases and upcoming events&quot; button_label=&quot;Keep Reading&quot; category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot;][/blog-posts]',1,NULL,'full-width',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(7,'Car List 1','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;yes&quot; default_layout=&quot;grid&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(8,'Car List 2','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;no&quot; default_layout=&quot;grid&quot; layout_col=&quot;4&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(9,'Car List 3','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;no&quot; default_layout=&quot;grid&quot; layout_col=&quot;3&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(10,'Car List 4','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;yes&quot; default_layout=&quot;list&quot; layout_col=&quot;4&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;1,2,3,4,5,6,7,8,9,10,11,12,13,14&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(11,'Agencies','[team title=\"Meet Our Agents\" subtitle=\"Awesome Teams\" team_ids=\"1,2,3,4,5,6,7,8\"][/team]',1,NULL,'full-width',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(12,'Faqs','[faq-categories title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot;][/faq-categories][faqs title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot; faq_category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot; button_secondary_label=&quot;Contact Us&quot; button_secondary_url=&quot;/contact&quot; button_primary_label=&quot;Submit A Ticket&quot; button_primary_url=&quot;/&quot;][/faqs][faqs title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot; faq_category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot; button_secondary_label=&quot;Contact Us&quot; button_secondary_url=&quot;/contact&quot; button_primary_label=&quot;Submit A Ticket&quot; button_primary_url=&quot;/&quot;][/faqs][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot;][/site-statistics]',1,NULL,'full-width',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(13,'Brands','[brands title=\"Brands\" style=\"style-3\" brand_ids=\"1,2,3,4,5,6,7,8,9,10,11,12,13,14\"][/brands]',1,NULL,NULL,NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(14,'Car Dealers','[car-dealers title=\"Our Trusted Car Dealers\" subtitle=\"Find the best car dealers with excellent service and competitive prices\" limit=\"12\" show_car_count=\"yes\" button_label=\"View All Dealers\" button_url=\"/car-dealers\"][/car-dealers]',1,NULL,'full-width',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(15,'Our Awards','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(16,'Copyright Notices','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(17,'Terms of Use','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(18,'Privacy Notice','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(19,'Lost &amp; Found','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(20,'Car Rental Services','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(21,'Vehicle Leasing Options','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(22,'Long-Term Car Rentals','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(23,'Car Sales and Trade-Ins','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(24,'Luxury Car Rentals','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(25,'Rent-to-Own Programs','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(26,'Fleet Management Solutions','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(27,'Affiliates','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(28,'Travel Agents','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(29,'AARP Members','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(30,'Points Programs','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(31,'Military &amp; Veterans','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(32,'Work with us','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(33,'Advertise with us','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(34,'Forum support','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(35,'Help Center','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(36,'Live chat','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(37,'How it works','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(38,'Security','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(39,'Refund Policy','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',1,NULL,'default',NULL,'published','2025-11-17 21:14:23','2025-11-17 21:14:23');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',21,'IQZLKUA26G8A','bank_transfer',NULL,450.00,0.00,1,'pending','direct',21,NULL,NULL,'2025-10-13 21:14:20','2025-10-13 21:14:20','Botble\\CarRentals\\Models\\Customer',NULL),(2,'USD',30,'YAS8BNKMIB02','razorpay',NULL,270.00,0.00,2,'completed','direct',30,NULL,NULL,'2025-10-07 21:14:20','2025-10-07 21:14:20','Botble\\CarRentals\\Models\\Customer',NULL),(3,'USD',21,'SJXSSSK9UCQE','razorpay',NULL,90.00,0.00,3,'completed','direct',21,NULL,NULL,'2025-09-29 21:14:20','2025-09-29 21:14:20','Botble\\CarRentals\\Models\\Customer',NULL),(4,'USD',31,'9FBTJZL7YHXK','razorpay',NULL,553.00,0.00,4,'pending','direct',31,NULL,NULL,'2025-10-13 21:14:20','2025-10-13 21:14:20','Botble\\CarRentals\\Models\\Customer',NULL),(5,'USD',25,'CI6GZZ9MUOAC','sslcommerz',NULL,148.00,0.00,5,'completed','direct',25,NULL,NULL,'2025-09-18 21:14:20','2025-09-18 21:14:20','Botble\\CarRentals\\Models\\Customer',NULL),(6,'USD',31,'7GTYTQCFO19H','paypal',NULL,352.00,0.00,6,'completed','direct',31,NULL,NULL,'2025-10-11 21:14:21','2025-10-11 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(7,'USD',27,'AOME85ONQE3M','cod',NULL,128.00,0.00,7,'completed','direct',27,NULL,NULL,'2025-10-02 21:14:21','2025-10-02 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(8,'USD',25,'CEFZEFN6VMIE','bank_transfer',NULL,288.00,0.00,8,'completed','direct',25,NULL,NULL,'2025-11-08 21:14:21','2025-11-08 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(9,'USD',22,'RKU6E95MKVBP','paypal',NULL,266.00,0.00,9,'pending','direct',22,NULL,NULL,'2025-11-14 21:14:21','2025-11-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(10,'USD',26,'0DDIKXD01DH2','paypal',NULL,56.00,0.00,10,'completed','direct',26,NULL,NULL,'2025-10-25 21:14:21','2025-10-25 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(11,'USD',29,'URJCDTR4GCPV','paystack',NULL,216.00,0.00,11,'completed','direct',29,NULL,NULL,'2025-11-11 21:14:21','2025-11-11 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(12,'USD',26,'HQ51NMC6WCUZ','paypal',NULL,420.00,0.00,12,'completed','direct',26,NULL,NULL,'2025-10-09 21:14:21','2025-10-09 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(13,'USD',29,'55ZZNIFACAHE','bank_transfer',NULL,315.00,0.00,13,'completed','direct',29,NULL,NULL,'2025-11-03 21:14:21','2025-11-03 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(14,'USD',26,'DERDRRDNA23Y','razorpay',NULL,105.00,0.00,14,'completed','direct',26,NULL,NULL,'2025-10-06 21:14:21','2025-10-06 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(15,'USD',28,'SPV6BMSSBXNJ','bank_transfer',NULL,192.00,0.00,15,'pending','direct',28,NULL,NULL,'2025-10-16 21:14:21','2025-10-16 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(16,'USD',24,'1VJE4C7TEAXW','paypal',NULL,245.00,0.00,16,'completed','direct',24,NULL,NULL,'2025-11-06 21:14:21','2025-11-06 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(17,'USD',22,'IVWQCB06JHJU','paystack',NULL,195.00,0.00,17,'pending','direct',22,NULL,NULL,'2025-11-14 21:14:21','2025-11-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(18,'USD',29,'6U7IJUNMFOCG','razorpay',NULL,70.00,0.00,18,'completed','direct',29,NULL,NULL,'2025-10-06 21:14:21','2025-10-06 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(19,'USD',25,'3R8JAJQSG57O','bank_transfer',NULL,66.00,0.00,19,'completed','direct',25,NULL,NULL,'2025-11-12 21:14:21','2025-11-12 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(20,'USD',30,'EYOWVPNZVQWR','paypal',NULL,352.00,0.00,20,'completed','direct',30,NULL,NULL,'2025-10-15 21:14:21','2025-10-15 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(21,'USD',31,'NMXYKUEHTMU1','paypal',NULL,90.00,0.00,21,'completed','direct',31,NULL,NULL,'2025-11-10 21:14:21','2025-11-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(22,'USD',22,'WLGXTOPLCEEL','razorpay',NULL,588.00,0.00,22,'completed','direct',22,NULL,NULL,'2025-10-28 21:14:21','2025-10-28 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(23,'USD',28,'JEKVSQYKL4MV','paypal',NULL,48.00,0.00,23,'completed','direct',28,NULL,NULL,'2025-11-14 21:14:21','2025-11-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(24,'USD',21,'AZ4WOBBLCA3I','paystack',NULL,96.00,0.00,24,'completed','direct',21,NULL,NULL,'2025-10-03 21:14:21','2025-10-03 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(25,'USD',25,'TJBJCDZU15XN','paystack',NULL,51.00,0.00,25,'completed','direct',25,NULL,NULL,'2025-10-08 21:14:21','2025-10-08 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(26,'USD',23,'3Q2APBD62HBG','stripe',NULL,294.00,0.00,26,'completed','direct',23,NULL,NULL,'2025-09-29 21:14:21','2025-09-29 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(27,'USD',26,'HE4WXTIIJ2ZD','cod',NULL,474.00,0.00,27,'completed','direct',26,NULL,NULL,'2025-10-16 21:14:21','2025-10-16 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(28,'USD',24,'1XXZGIXILIND','sslcommerz',NULL,525.00,0.00,28,'completed','direct',24,NULL,NULL,'2025-10-18 21:14:21','2025-10-18 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(29,'USD',21,'GJXDCVBRYT0V','stripe',NULL,33.00,0.00,29,'pending','direct',21,NULL,NULL,'2025-09-27 21:14:21','2025-09-27 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(30,'USD',21,'R67LKMHXO4FO','cod',NULL,378.00,0.00,30,'completed','direct',21,NULL,NULL,'2025-10-02 21:14:21','2025-10-02 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(31,'USD',23,'8JMBJOOO646K','stripe',NULL,105.00,0.00,31,'pending','direct',23,NULL,NULL,'2025-11-13 21:14:21','2025-11-13 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(32,'USD',25,'OY3INJN2YREC','paystack',NULL,55.00,0.00,32,'completed','direct',25,NULL,NULL,'2025-11-17 21:14:21','2025-11-17 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(33,'USD',30,'TQROHOR33SI9','paypal',NULL,215.00,0.00,33,'completed','direct',30,NULL,NULL,'2025-11-16 21:14:21','2025-11-16 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(34,'USD',30,'XIPAUZ1LRE6E','bank_transfer',NULL,180.00,0.00,34,'pending','direct',30,NULL,NULL,'2025-11-14 21:14:21','2025-11-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(35,'USD',31,'M31HT3AUKDQV','paypal',NULL,380.00,0.00,35,'completed','direct',31,NULL,NULL,'2025-11-14 21:14:21','2025-11-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(36,'USD',24,'BWOWXYGJ2QF9','cod',NULL,90.00,0.00,36,'pending','direct',24,NULL,NULL,'2025-11-15 21:14:21','2025-11-15 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(37,'USD',30,'RKUIDQRLGT94','cod',NULL,106.00,0.00,37,'completed','direct',30,NULL,NULL,'2025-11-10 21:14:21','2025-11-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(38,'USD',22,'4S5MCQTSUXQB','bank_transfer',NULL,114.00,0.00,38,'completed','direct',22,NULL,NULL,'2025-11-11 21:14:21','2025-11-11 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(39,'USD',30,'5YWTLMATBTML','sslcommerz',NULL,126.00,0.00,39,'completed','direct',30,NULL,NULL,'2025-11-14 21:14:21','2025-11-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(40,'USD',24,'SCRY0R6BC5IV','bank_transfer',NULL,33.00,0.00,40,'pending','direct',24,NULL,NULL,'2025-11-16 21:14:21','2025-11-16 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(41,'USD',30,'31CCDNJPUIUF','sslcommerz',NULL,623.00,0.00,41,'pending','direct',30,NULL,NULL,'2025-11-15 21:14:21','2025-11-15 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(42,'USD',31,'L7AHYEQKA9QN','razorpay',NULL,102.00,0.00,42,'completed','direct',31,NULL,NULL,'2025-11-10 21:14:21','2025-11-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(43,'USD',23,'LX4HSGMWEWMA','bank_transfer',NULL,224.00,0.00,43,'completed','direct',23,NULL,NULL,'2025-11-13 21:14:21','2025-11-13 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(44,'USD',22,'NAR3LAZR7VSN','paystack',NULL,532.00,0.00,44,'completed','direct',22,NULL,NULL,'2025-11-15 21:14:21','2025-11-15 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(45,'USD',25,'YFJIA7UFKS0D','cod',NULL,144.00,0.00,45,'pending','direct',25,NULL,NULL,'2025-11-10 21:14:21','2025-11-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(46,'USD',25,'G8A4ZFOYTEZB','cod',NULL,56.00,0.00,46,'completed','direct',25,NULL,NULL,'2025-11-16 21:14:21','2025-11-16 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(47,'USD',29,'CEKSJ4HLRHDH','sslcommerz',NULL,180.00,0.00,47,'pending','direct',29,NULL,NULL,'2025-11-11 21:14:21','2025-11-11 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(48,'USD',27,'FXVT1VSJSMC8','cod',NULL,406.00,0.00,48,'completed','direct',27,NULL,NULL,'2025-11-13 21:14:21','2025-11-13 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(49,'USD',24,'2QGH1THSXH6U','paypal',NULL,375.00,0.00,49,'pending','direct',24,NULL,NULL,'2025-11-10 21:14:21','2025-11-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(50,'USD',22,'ZXLIZLPJKTLF','razorpay',NULL,308.00,0.00,50,'completed','direct',22,NULL,NULL,'2025-11-10 21:14:21','2025-11-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(51,'USD',27,'MRGXEPAW9K8K','sslcommerz',NULL,264.00,0.00,51,'pending','direct',27,NULL,NULL,'2025-12-07 21:14:21','2025-12-07 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(52,'USD',25,'VMZ5KCMKJ2AE','bank_transfer',NULL,441.00,0.00,52,'pending','direct',25,NULL,NULL,'2025-12-14 21:14:21','2025-12-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(53,'USD',22,'YLMKK4YJBY8R','paystack',NULL,504.00,0.00,53,'pending','direct',22,NULL,NULL,'2025-12-14 21:14:21','2025-12-14 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(54,'USD',27,'NFNNF3TNDMCM','cod',NULL,434.00,0.00,54,'pending','direct',27,NULL,NULL,'2025-11-18 21:14:21','2025-11-18 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(55,'USD',28,'VSKZ4PSOPZO8','razorpay',NULL,504.00,0.00,55,'pending','direct',28,NULL,NULL,'2025-12-16 21:14:21','2025-12-16 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(56,'USD',30,'ZEUPZ4VWTZQ5','bank_transfer',NULL,276.00,0.00,56,'pending','direct',30,NULL,NULL,'2025-12-10 21:14:21','2025-12-10 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(57,'USD',31,'EKOLLIANBBZH','paystack',NULL,275.00,0.00,57,'pending','direct',31,NULL,NULL,'2025-12-06 21:14:21','2025-12-06 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(58,'USD',31,'5FQ2PRB9PCWJ','bank_transfer',NULL,108.00,0.00,58,'pending','direct',31,NULL,NULL,'2025-11-26 21:14:21','2025-11-26 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(59,'USD',25,'XUVATXTOHXCN','paystack',NULL,644.00,0.00,59,'pending','direct',25,NULL,NULL,'2025-12-07 21:14:21','2025-12-07 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(60,'USD',29,'S6HNBZJVPSF3','bank_transfer',NULL,616.00,0.00,60,'pending','direct',29,NULL,NULL,'2025-11-21 21:14:21','2025-11-21 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(61,'USD',25,'IYEX4GMJMU8Q','sslcommerz',NULL,106.00,0.00,61,'pending','direct',25,NULL,NULL,'2025-12-01 21:14:21','2025-12-01 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(62,'USD',24,'CRCPZP1ZD6QI','bank_transfer',NULL,296.00,0.00,62,'pending','direct',24,NULL,NULL,'2025-11-29 21:14:21','2025-11-29 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(63,'USD',31,'RD5CA6A14OEH','paypal',NULL,552.00,0.00,63,'pending','direct',31,NULL,NULL,'2025-12-02 21:14:21','2025-12-02 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(64,'USD',25,'BJG93IHSN7LK','stripe',NULL,84.00,0.00,64,'pending','direct',25,NULL,NULL,'2025-12-07 21:14:21','2025-12-07 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(65,'USD',23,'CI9E6LUIUQ91','paypal',NULL,168.00,0.00,65,'pending','direct',23,NULL,NULL,'2025-11-28 21:14:21','2025-11-28 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(66,'USD',21,'U8FMRQERENXI','cod',NULL,96.00,0.00,66,'pending','direct',21,NULL,NULL,'2025-12-07 21:14:21','2025-12-07 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(67,'USD',31,'RWGGPRUDXUHG','razorpay',NULL,297.00,0.00,67,'pending','direct',31,NULL,NULL,'2025-12-02 21:14:21','2025-12-02 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(68,'USD',23,'F6FKVOJCV6QW','paypal',NULL,462.00,0.00,68,'pending','direct',23,NULL,NULL,'2025-11-21 21:14:21','2025-11-21 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(69,'USD',31,'NAYWTFGFIICN','stripe',NULL,186.00,0.00,69,'pending','direct',31,NULL,NULL,'2025-12-12 21:14:21','2025-12-12 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(70,'USD',24,'SX09GXJDZXDB','cod',NULL,462.00,0.00,70,'pending','direct',24,NULL,NULL,'2025-11-28 21:14:21','2025-11-28 21:14:21','Botble\\CarRentals\\Models\\Customer',NULL),(71,'USD',28,'AN65JW4XIGJC','sslcommerz',NULL,456.00,0.00,71,'pending','direct',28,NULL,NULL,'2025-11-27 21:14:22','2025-11-27 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(72,'USD',26,'82NAGY0S5GVX','sslcommerz',NULL,468.00,0.00,72,'pending','direct',26,NULL,NULL,'2025-11-20 21:14:22','2025-11-20 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(73,'USD',29,'PP2UF2JF9LIB','bank_transfer',NULL,170.00,0.00,73,'pending','direct',29,NULL,NULL,'2025-11-19 21:14:22','2025-11-19 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(74,'USD',31,'J6ZYP6TV0YZR','sslcommerz',NULL,420.00,0.00,74,'pending','direct',31,NULL,NULL,'2025-11-21 21:14:22','2025-11-21 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(75,'USD',30,'HMWCJBWXYTIS','sslcommerz',NULL,329.00,0.00,75,'pending','direct',30,NULL,NULL,'2025-12-04 21:14:22','2025-12-04 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(76,'USD',24,'L2ARWYDQB28R','stripe',NULL,76.00,0.00,76,'pending','direct',24,NULL,NULL,'2025-12-16 21:14:22','2025-12-16 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(77,'USD',27,'SIG4HQHXJMWN','paystack',NULL,330.00,0.00,77,'pending','direct',27,NULL,NULL,'2025-11-18 21:14:22','2025-11-18 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(78,'USD',28,'X57FJAMF9ZLM','paypal',NULL,63.00,0.00,78,'pending','direct',28,NULL,NULL,'2025-12-12 21:14:22','2025-12-12 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(79,'USD',27,'UP3KZCEY7GRS','stripe',NULL,300.00,0.00,79,'pending','direct',27,NULL,NULL,'2025-11-27 21:14:22','2025-11-27 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL),(80,'USD',21,'KWRIIXEM1ZHO','sslcommerz',NULL,450.00,0.00,80,'pending','direct',21,NULL,NULL,'2025-11-28 21:14:22','2025-11-28 21:14:22','Botble\\CarRentals\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (8,1),(9,1),(1,2),(7,2),(6,3),(10,3),(4,4),(8,4),(2,5),(4,6),(10,6),(1,7),(5,7),(7,8),(9,8),(9,9),(9,10),(2,10),(7,11),(2,11),(6,12),(8,12),(8,13),(10,13),(2,14),(4,14),(9,15),(6,15),(6,16),(8,16),(4,17),(1,17),(6,18),(2,19),(7,19),(4,20),(7,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (5,1),(4,1),(6,1),(9,2),(10,2),(5,2),(7,3),(4,3),(7,4),(3,4),(8,4),(2,5),(4,5),(5,5),(9,6),(4,6),(3,6),(5,7),(2,7),(1,8),(9,8),(3,9),(6,9),(1,9),(7,10),(9,10),(3,10),(6,11),(5,11),(9,11),(9,12),(10,12),(5,12),(1,13),(10,13),(3,14),(1,14),(10,14),(4,15),(10,15),(2,16),(1,16),(7,16),(8,17),(5,17),(9,18),(2,18),(6,18),(3,19),(1,19),(10,19),(1,20),(8,20),(9,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Top 5 New Cars to Look Out for in 2024','Discover the most anticipated car models coming in 2024, featuring cutting-edge technology and stunning designs.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Explicabo dolores sequi in. Quia modi voluptatem eum dolor quidem odio. Nesciunt iusto sapiente ab enim at. Nihil praesentium voluptatem maxime dolor magni voluptas voluptatem facere. Qui eum quis pariatur sed consequuntur. Assumenda ullam vero voluptatum debitis doloribus aperiam. Ducimus temporibus minus consectetur laborum. Quos est fuga nihil eaque.\" content_2=\"Saepe dolor laboriosam facilis ipsa et corrupti cum. Ipsa ut quaerat accusantium ea. Vero nobis quia sunt et voluptas. Mollitia qui laboriosam quia voluptatem debitis velit. Eligendi autem cupiditate illo. Ut totam corrupti expedita voluptatum sequi. Dolorem voluptatum architecto ratione excepturi est illo.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/1.jpg',255,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(2,'How to Choose the Best Car Rental Service for Your Trip','A comprehensive guide on selecting the right car rental service based on your travel needs and budget.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Tempora libero et iusto explicabo. Qui sed molestiae ea rerum rerum ex. A tempore quo dignissimos in. Minima sunt error minus quas minus iusto optio consequatur. Et quis numquam laudantium. Molestias quis eveniet sit doloribus. Enim cum reiciendis qui et. Corporis quas delectus quasi molestias. Maiores quis officiis ut a. Ut sed natus quam corporis non quia est.\" content_2=\"Nihil quo cumque rem nesciunt aspernatur neque occaecati. Amet magni enim tenetur. Dolore doloremque minima vel optio voluptas sunt voluptatem. Labore ullam culpa eum qui nesciunt et saepe cumque. Et sunt magnam ut ab autem. Ipsum ea est corporis nesciunt. Quis omnis nihil assumenda modi et accusamus dolores.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/2.jpg',2433,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(3,'The Evolution of Electric Vehicles: A New Era','Explore how electric cars are transforming the auto industry and why they are the future of transportation.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Dolores qui consectetur ex recusandae error. Repellat consequatur odio qui suscipit vel. Assumenda magni nostrum enim quisquam consequatur architecto. Qui velit veniam laudantium optio autem quas dolorem. Consequatur laudantium ex velit doloremque voluptatem cumque. Eaque impedit vitae ut placeat assumenda. Dicta earum placeat vero.\" content_2=\"Doloremque quidem sit cupiditate quos. Voluptates debitis odio et neque aliquam fugiat doloremque. Itaque amet aut rerum aperiam quia. Eveniet aliquid earum beatae autem et. Velit molestias voluptatem totam ut ut corporis tenetur. Quis sit rerum aut vitae. Ullam velit suscipit ea mollitia voluptas soluta ullam. Non molestias qui natus nulla.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/3.jpg',2093,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(4,'Leasing vs. Buying a Car: Which Is Right for You?','An in-depth comparison of leasing and buying a car, helping you decide which option suits your lifestyle.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Inventore illum itaque iste temporibus voluptas corporis. Sint minima necessitatibus ducimus neque nihil placeat id. Commodi occaecati officiis nihil voluptatum quod omnis cumque nihil. Quaerat in facere ipsum commodi corrupti quam.\" content_2=\"Nostrum ut quos harum eos eaque eum quo. Dolores in commodi alias et aut quia labore. Dignissimos dolores sed sunt architecto natus mollitia. In culpa minus eaque aut enim. Voluptatibus quo reprehenderit voluptas dolorum quod impedit et dolorem. Dolorem et eum quam fugit deleniti vitae qui. Sapiente ut est qui voluptatem doloribus illo. Qui eveniet excepturi sit ipsam veniam quaerat in.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/4.jpg',671,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(5,'The Ultimate Road Trip Checklist','Everything you need to pack and check before embarking on an unforgettable road trip adventure.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Voluptas amet provident occaecati enim quo ab nihil. Dolores sed voluptatum sunt. Repudiandae qui ipsum adipisci rerum voluptates distinctio. Voluptate veniam perspiciatis velit ducimus. Unde sit et aliquid quia facere eveniet. Numquam ipsum rerum impedit itaque minus. Sint quia nemo ea dolorem laborum.\" content_2=\"Rerum doloribus voluptatibus ratione eius saepe. Ea rerum culpa esse ut. Non maiores qui quasi laboriosam veritatis optio. Corrupti amet impedit aliquid architecto officia voluptatem autem. Est earum dignissimos dolor et iusto. Ex doloremque quisquam consequatur qui ut qui et. Pariatur quia rerum optio quibusdam. Illo libero porro quam. Quod facilis odit consequatur sunt est ipsum.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/5.jpg',868,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(6,'The Benefits of Renting a Luxury Car for Special Occasions','Find out why renting a luxury vehicle can make your events even more memorable and stylish.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Fugit dolor expedita omnis repudiandae. Voluptate accusamus non qui velit. In est ut est ut sunt. Qui voluptas nulla doloremque. Eius aliquam sed eveniet suscipit. Non beatae est non perspiciatis. Vel veritatis consectetur excepturi eaque voluptatem. Molestiae sint dolore excepturi voluptatem qui similique. Ipsam totam cupiditate repellat qui nam. Harum sed expedita pariatur quia et odio.\" content_2=\"Occaecati ea vitae voluptas ducimus necessitatibus odit. Similique numquam neque voluptas non beatae et quo eos. Accusantium sunt molestiae et porro. Nam possimus impedit et ab tenetur. Qui temporibus fugit cumque tempore nisi quisquam. Assumenda illo voluptas natus nemo a placeat vero.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/6.jpg',1495,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(7,'Tips for Maintaining Your Car to Extend Its Lifespan','Essential tips on how to keep your car in top condition, ensuring it lasts longer and performs better.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Aut voluptas aut tempore rem doloribus delectus ullam assumenda. Recusandae ut sed ab quasi non. Autem eius in voluptas at voluptate placeat nulla. Dolores quo corrupti cumque sapiente eius eius. Eius voluptatem quasi nulla repellat. Deserunt ut eligendi earum sapiente voluptatibus aut aliquam aliquid.\" content_2=\"Quisquam voluptatem consequatur necessitatibus sit ipsam vero sed. Pariatur quis nostrum earum voluptatem dolores sed et possimus. Quis hic laboriosam velit. Velit voluptas nesciunt temporibus id. Similique accusantium aut pariatur et porro quo a. Occaecati nobis qui aut qui veritatis ut rerum sunt. Ut repudiandae sed laboriosam reiciendis ea. Commodi fugit sed eius odio sunt consequatur.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/7.jpg',522,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(8,'Top Safety Features to Look for in a Family Car','A guide to the latest safety innovations in family vehicles and how they protect your loved ones on the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Eos est id ut corrupti illum. Ab totam quia tenetur error facere expedita enim. Eius ullam veritatis deserunt sed. Laudantium esse amet ut modi ea vel. Nihil aut ratione qui voluptatem. Laborum voluptas aliquam enim voluptatem accusamus qui ipsa qui. Consequuntur assumenda expedita vel. Quia sapiente dolores consequatur facilis. Repellat in est sequi cupiditate.\" content_2=\"Voluptatibus sint ipsa praesentium itaque debitis. Qui rerum aut porro amet culpa. Cum enim dolor eum et iusto quo sint. Alias dolorem distinctio nihil et. Voluptas sunt est quia dolorem nobis. Accusamus repellendus itaque tenetur quam modi. Eos id aut qui illum rerum.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/8.jpg',1416,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(9,'How Self-Driving Cars Are Changing the Future of Transportation','An overview of autonomous vehicles and the potential they have to reshape the way we travel.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Et ratione eligendi hic laudantium. Voluptatem vero sit aut. Veniam accusantium et totam voluptatem assumenda quibusdam. Tenetur eum ut blanditiis. Porro quam recusandae et nihil. Qui ratione quidem eum aut harum. Porro inventore aut placeat vel repudiandae. Voluptate aut ratione quia et fuga illum aliquid. Consequatur tempora laborum sit.\" content_2=\"Pariatur voluptatem facere tempora vel tempora. Ut aut facere est voluptatum ipsa eius. Fugiat dolore earum incidunt. Corrupti quibusdam id dolorum et. Reprehenderit ut nobis quaerat officia rem veniam iure. Qui iusto magni velit quo nemo culpa voluptas. Esse optio placeat et deserunt soluta et consequatur. Voluptatem facilis dolor autem doloremque.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/9.jpg',1735,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(10,'The Best Cars for Off-Road Adventures','Discover the top vehicles that offer exceptional performance on rough terrains for your next outdoor adventure.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Nihil dolor eius qui eum quam ea ratione. Explicabo eius dolor aspernatur ut et harum. Facere laborum neque vel omnis perspiciatis deleniti. Sed ratione sit quia. Qui dolores doloremque dolorem facere.\" content_2=\"Est autem ducimus et harum tempore. Ipsum earum adipisci modi molestias placeat quasi reiciendis autem. Velit dolores quia quia quo aliquid vel. Sapiente quis quis aliquid consequuntur aut quia id mollitia. Tempore velit aliquam harum. Culpa mollitia quae saepe eius quam facere. Eius eos dolorum facere saepe id.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/10.jpg',2475,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(11,'The Rise of Car Subscription Services','Learn about the growing trend of car subscription services and why more drivers are opting for this flexible alternative to car ownership.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Illo recusandae aperiam mollitia rerum. Rerum eum libero expedita. Nemo voluptas at explicabo in debitis dolorem. Non mollitia fuga rerum. Laborum earum error quia hic consequuntur quidem. Itaque voluptatem cumque esse expedita. Dolorem expedita provident eum a. Quisquam aliquid sapiente enim voluptatibus optio at sed labore.\" content_2=\"Voluptas aliquam fugiat ut. Consequatur quae explicabo aut eaque vero reiciendis qui. Aut aut quia omnis eos et quibusdam. Qui non voluptatem deserunt dolores et quae placeat sed. Deleniti voluptas voluptate soluta corporis. Impedit deleniti debitis nam ea autem est ducimus. Et perferendis ratione eligendi aut. Corrupti suscipit dignissimos eum ipsum.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/11.jpg',1453,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(12,'Eco-Friendly Driving Tips to Reduce Your Carbon Footprint','Simple strategies for eco-conscious drivers to minimize their environmental impact on the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Voluptate quos sunt voluptatem quia dolore. Aut sit sapiente quia nihil aut rerum illum. Sit rerum cupiditate eos deserunt sed eveniet. Sunt dignissimos magni et totam facilis nihil quam quasi. Sit suscipit officiis quam qui.\" content_2=\"Deserunt quia deserunt fuga optio illum id. Laudantium et aliquam magnam quo itaque et. Consequatur ipsam adipisci ullam et delectus neque fuga. Assumenda quia vero dolorem dignissimos. Id qui consequuntur voluptas exercitationem magnam.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/12.jpg',2421,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(13,'The Future of Car Sharing: Convenience at Your Fingertips','Explore how car sharing platforms are making it easier for people to access vehicles without the commitment of ownership.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quos voluptatum est et eum sapiente dolores iure. Excepturi quia sit magnam quis nemo repellendus. Delectus dolorum excepturi possimus voluptas. Expedita est aspernatur sequi numquam dolor recusandae accusantium. Laudantium perferendis ut voluptatem nam eum neque quas laboriosam. Voluptatem non fuga cupiditate assumenda ullam itaque. Voluptas ut odit sed tempore quod repudiandae.\" content_2=\"Totam recusandae labore ratione dolor. Quis asperiores optio id ut sed eaque nulla. Alias vel necessitatibus eum et deserunt velit. Animi eligendi consequatur atque et voluptas illum sit saepe. Repudiandae eos explicabo animi non illo doloribus quod. Illo ipsa tenetur alias ut eligendi amet sit. Consequatur sunt expedita non repellendus. Sit cumque fugiat ipsam in tempore consequatur expedita.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/13.jpg',2145,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(14,'How to Get the Best Deals on Car Rentals During Holidays','Insider tips on how to save money and secure great deals when renting cars for your holiday travels.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Et accusamus harum ipsum. Expedita a ea aut numquam vel inventore. Ea eos vel accusantium autem veritatis quo optio. Sequi delectus voluptas et sequi a tempora aliquam. At consequatur qui soluta. Est quos amet tempore velit. Ut quia accusamus tempora vitae nam odit iste aut.\" content_2=\"Quia id qui praesentium enim fuga in. Cupiditate ullam facere quidem veritatis aut voluptatum. Cumque dolor voluptas beatae repudiandae accusantium blanditiis placeat. Eos rerum distinctio ut nisi in maiores. Officia minima ullam autem voluptatem id delectus voluptatem occaecati. Sunt ut ipsam dolor animi reprehenderit officia iure aut. Vel eum aut voluptas voluptatibus.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/14.jpg',586,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(15,'The Pros and Cons of Hybrid Vehicles','An analysis of the advantages and disadvantages of hybrid cars, helping you decide if they are the right choice for you.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Corporis minus dignissimos deserunt et rerum quia. Ipsa ut ut officia sequi repellendus et numquam dolores. Aut et totam voluptatem fuga maxime. Assumenda suscipit quo veniam nesciunt id cumque architecto. Omnis exercitationem aut recusandae accusamus. Consequatur error sit eum deleniti modi.\" content_2=\"Quis natus quam ut molestiae quibusdam. Id dolor nihil voluptas omnis vel quo velit. Animi est ut qui ducimus qui qui sed provident. Officia voluptatum dolores autem debitis et dignissimos. Facilis ut et blanditiis et explicabo. Explicabo aliquid temporibus ex. Velit voluptatem et maxime ex quia dolorem perspiciatis nulla. Tenetur a consequatur provident quidem sapiente omnis.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/5.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/15.jpg',1818,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(16,'How to Properly Clean and Detail Your Car','Step-by-step instructions on cleaning your car inside and out to keep it looking brand new.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Dolores qui saepe hic itaque quis facilis pariatur. Necessitatibus quasi cumque est delectus aut voluptas et. Quasi nihil unde eveniet atque. Est sed sapiente aliquam rerum cum rerum dolorem. Accusamus adipisci facere et rerum tempora repudiandae. Pariatur odio eveniet aliquid ut magni.\" content_2=\"Molestias mollitia dolorem sed quas eius aut. Asperiores qui dignissimos cumque. Rerum dignissimos ut harum debitis omnis omnis. Tempore placeat eum deleniti laboriosam. Aliquid iste fugiat aspernatur magni quia aperiam quasi.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/4.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/16.jpg',1465,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(17,'Car Innovations: What to Expect in the Next 5 Years','A look at the technological advancements expected to revolutionize cars in the near future.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Reprehenderit tempora ut et id dolor necessitatibus quod. Quibusdam voluptas culpa vel nemo corrupti laborum. Recusandae libero sunt voluptates amet perferendis at earum mollitia. Sed consequuntur soluta ut fugit laborum.\" content_2=\"Qui eaque culpa vitae praesentium sit. Ratione molestiae aut voluptate corrupti dolor. Aut id voluptatem qui aut consequatur architecto ex. Consequatur sapiente esse sunt. Voluptas delectus ut enim quo. Fuga modi distinctio eos aut saepe. Voluptas rem omnis aliquam nihil vero. Voluptatem harum perspiciatis nihil maxime.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/17.jpg',1818,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(18,'The Ultimate Guide to Buying a Used Car','Everything you need to know about purchasing a used vehicle, from inspecting it to negotiating the best price.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Dolorum ut cupiditate at ad praesentium recusandae dolore aut. Sint tenetur dolor earum amet facilis omnis repudiandae. Vel molestiae voluptatum est velit eos. Molestias non et ad eveniet quia placeat sunt. Sint in aperiam illum repellat et expedita et.\" content_2=\"Labore aut ut et sapiente repudiandae omnis. Fugiat porro maiores est illo. Delectus vero laboriosam quo fuga ipsam voluptatem voluptatem. Expedita quia praesentium nulla repudiandae dolor laborum consectetur. Nemo est non minus consectetur laborum omnis. Distinctio consequatur et laborum numquam ut eaque. Porro a minima quae. Aut et ad placeat.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/18.jpg',1400,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(19,'How to Plan a Cross-Country Trip with a Rented Car','Tips on organizing a successful cross-country road trip, including how to choose the right rental car.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Incidunt quisquam praesentium non necessitatibus aut. Sed dicta molestias eum est reprehenderit quasi. Porro adipisci aut quos tempore. Repellendus consequatur distinctio maiores molestiae nulla sunt. Minima et aut magnam et voluptas mollitia quaerat repellendus. Possimus ut ea debitis similique mollitia repellendus voluptas esse. Voluptas ea aut quos necessitatibus voluptas harum.\" content_2=\"Sint aut repellendus totam totam enim. Tempore vero aut quam laborum. Nam maiores consequatur aperiam expedita minus voluptas. Impedit est qui et minus voluptate officia ut. Consequatur quis ullam officia vero praesentium nemo odio delectus. Fugit repudiandae praesentium sapiente nam. Consequatur est cupiditate qui dicta velit.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/19.jpg',1635,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14'),(20,'What You Need to Know About Car Insurance Before Renting','An essential guide to understanding car rental insurance and how to choose the right coverage for your trip.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Omnis dolor dolores sed qui dolorum beatae. Inventore officia a corporis error voluptatem. Sed amet praesentium aspernatur neque magni. Illum id delectus recusandae rem asperiores enim omnis. Reprehenderit a nostrum illum qui adipisci provident doloribus.\" content_2=\"Corporis saepe sint dolor repellat accusamus. Cumque incidunt dolore et enim. Qui ut et labore similique odio. Non exercitationem et quia voluptatem in. Eveniet omnis porro eos quibusdam fugiat. Ut id iusto velit nihil vero atque.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/20.jpg',1181,NULL,'2025-11-17 21:13:14','2025-11-17 21:13:14');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notification_recipients`
--

DROP TABLE IF EXISTS `push_notification_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notification_recipients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `push_notification_id` bigint unsigned NOT NULL,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `device_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `clicked_at` timestamp NULL DEFAULT NULL,
  `fcm_response` json DEFAULT NULL,
  `error_message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pnr_notification_user_index` (`push_notification_id`,`user_type`,`user_id`),
  KEY `pnr_user_status_index` (`user_type`,`user_id`,`status`),
  KEY `pnr_user_read_index` (`user_type`,`user_id`,`read_at`),
  KEY `pnr_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notification_recipients`
--

LOCK TABLES `push_notification_recipients` WRITE;
/*!40000 ALTER TABLE `push_notification_recipients` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notification_recipients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notifications`
--

DROP TABLE IF EXISTS `push_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `target_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` json DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_count` int NOT NULL DEFAULT '0',
  `failed_count` int NOT NULL DEFAULT '0',
  `delivered_count` int NOT NULL DEFAULT '0',
  `read_count` int NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `push_notifications_type_created_at_index` (`type`,`created_at`),
  KEY `push_notifications_status_scheduled_at_index` (`status`,`scheduled_at`),
  KEY `push_notifications_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notifications`
--

LOCK TABLES `push_notifications` WRITE;
/*!40000 ALTER TABLE `push_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"car-rentals.index\":true,\"car-rentals.cars.index\":true,\"car-rentals.cars.create\":true,\"car-rentals.cars.edit\":true,\"car-rentals.cars.destroy\":true,\"car-rentals.customers.index\":true,\"car-rentals.customers.create\":true,\"car-rentals.customers.edit\":true,\"car-rentals.customers.destroy\":true,\"car-rentals.bookings.index\":true,\"car-rentals.bookings.create\":true,\"car-rentals.bookings.edit\":true,\"car-rentals.bookings.destroy\":true,\"car-rentals.invoices.index\":true,\"car-rentals.invoices.create\":true,\"car-rentals.invoices.edit\":true,\"car-rentals.invoices.destroy\":true,\"car-rentals.reviews.index\":true,\"car-rentals.reviews.edit\":true,\"car-rentals.reviews.destroy\":true,\"car-rentals.coupons.index\":true,\"car-rentals.coupons.create\":true,\"car-rentals.coupons.edit\":true,\"car-rentals.coupons.destroy\":true,\"car-rentals.taxes.index\":true,\"car-rentals.taxes.create\":true,\"car-rentals.taxes.edit\":true,\"car-rentals.taxes.destroy\":true,\"car-rentals.attributes.index\":true,\"car-rentals.car-makes.index\":true,\"car-rentals.car-makes.create\":true,\"car-rentals.car-makes.edit\":true,\"car-rentals.car-makes.destroy\":true,\"car-rentals.car-types.index\":true,\"car-rentals.car-types.create\":true,\"car-rentals.car-types.edit\":true,\"car-rentals.car-types.destroy\":true,\"car-rentals.car-transmissions.index\":true,\"car-rentals.car-transmissions.create\":true,\"car-rentals.car-transmissions.edit\":true,\"car-rentals.car-transmissions.destroy\":true,\"car-rentals.car-fuels.index\":true,\"car-rentals.car-fuels.create\":true,\"car-rentals.car-fuels.edit\":true,\"car-rentals.car-fuels.destroy\":true,\"car-rentals.car-colors.index\":true,\"car-rentals.car-colors.create\":true,\"car-rentals.car-colors.edit\":true,\"car-rentals.car-colors.destroy\":true,\"car-rentals.car-maintenance-histories.index\":true,\"car-rentals.car-maintenance-histories.create\":true,\"car-rentals.car-maintenance-histories.edit\":true,\"car-rentals.car-maintenance-histories.destroy\":true,\"car-rentals.car-tags.index\":true,\"car-rentals.car-tags.create\":true,\"car-rentals.car-tags.edit\":true,\"car-rentals.car-tags.destroy\":true,\"car-rentals.car-categories.index\":true,\"car-rentals.car-categories.create\":true,\"car-rentals.car-categories.edit\":true,\"car-rentals.car-categories.destroy\":true,\"car-rentals.car-amenities.index\":true,\"car-rentals.car-amenities.create\":true,\"car-rentals.car-amenities.edit\":true,\"car-rentals.car-amenities.destroy\":true,\"car-rentals.services.index\":true,\"car-rentals.services.create\":true,\"car-rentals.services.edit\":true,\"car-rentals.services.destroy\":true,\"car-rentals.booking.reports.index\":true,\"car-rentals.booking.calendar.index\":true,\"car-rentals.message.index\":true,\"car-rentals.message.edit\":true,\"car-rentals.message.destroy\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"fob-comment.index\":true,\"fob-comment.comments.index\":true,\"fob-comment.comments.edit\":true,\"fob-comment.comments.destroy\":true,\"fob-comment.comments.reply\":true,\"fob-comment.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"team.index\":true,\"team.create\":true,\"team.edit\":true,\"team.destroy\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-11-17 21:13:08','2025-11-17 21:13:08');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','25d18255d11741dc2d4f59446d245dc4',NULL,'2025-11-17 21:14:23'),(2,'api_enabled','0',NULL,'2025-11-17 21:14:23'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"car-rentals\",\"contact\",\"cookie-consent\",\"faq\",\"fob-comment\",\"gallery\",\"location\",\"newsletter\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"team\",\"testimonial\",\"translation\"]',NULL,'2025-11-17 21:14:23'),(4,'theme','carento',NULL,'2025-11-17 21:14:23'),(5,'show_admin_bar','1',NULL,'2025-11-17 21:14:23'),(6,'admin_logo','general/logo-dark.png',NULL,'2025-11-17 21:14:23'),(7,'admin_favicon','general/favicon.png',NULL,'2025-11-17 21:14:23'),(8,'permalink-botble-blog-models-post','news',NULL,'2025-11-17 21:14:23'),(9,'permalink-botble-blog-models-category','news',NULL,'2025-11-17 21:14:23'),(10,'payment_cod_status','1',NULL,'2025-11-17 21:14:23'),(11,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-11-17 21:14:23'),(12,'payment_bank_transfer_status','1',NULL,'2025-11-17 21:14:23'),(13,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-11-17 21:14:23'),(14,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-11-17 21:14:23'),(15,'language_switcher_display','dropdown',NULL,'2025-11-17 21:14:23'),(16,'car_rentals_company_name_for_invoicing','Carento',NULL,'2025-11-17 21:14:23'),(17,'car_rentals_company_logo_for_invoicing','general/logo.png',NULL,'2025-11-17 21:14:23'),(18,'car_rentals_company_address_for_invoicing','123, My Street, Kingston, New York',NULL,'2025-11-17 21:14:23'),(19,'car_rentals_company_email_for_invoicing','contact@botble.com',NULL,'2025-11-17 21:14:23'),(20,'car_rentals_company_phone_for_invoicing','123456789',NULL,'2025-11-17 21:14:23'),(21,'car_rentals_enabled_review','1',NULL,'2025-11-17 21:14:23'),(22,'car_rentals_enabled_multi_vendor','1',NULL,'2025-11-17 21:14:23'),(23,'simple_slider_using_assets','0',NULL,'2025-11-17 21:14:23'),(61,'language_hide_default','1',NULL,'2025-11-17 21:14:23'),(62,'language_display','all',NULL,'2025-11-17 21:14:23'),(63,'language_hide_languages','[]',NULL,'2025-11-17 21:14:23'),(64,'announcement_max_width','1210',NULL,'2025-11-17 21:14:23'),(65,'announcement_text_color','#FFFFFF',NULL,'2025-11-17 21:14:23'),(66,'announcement_background_color','transparent',NULL,'2025-11-17 21:14:23'),(67,'announcement_text_alignment','start',NULL,'2025-11-17 21:14:23'),(68,'announcement_dismissible','1',NULL,'2025-11-17 21:14:23'),(69,'announcement_font_size','14',NULL,'2025-11-17 21:14:23'),(70,'announcement_font_size_unit','px',NULL,'2025-11-17 21:14:23'),(71,'announcement_placement','theme',NULL,'2025-11-17 21:14:23'),(72,'theme-carento-site_title','Carento - Car Rentals Laravel Script',NULL,NULL),(73,'theme-carento-seo_description','Carento is a robust Laravel script for managing car rental businesses, featuring advanced booking, real-time vehicle availability, and customizable options for efficient operations.',NULL,NULL),(74,'theme-carento-copyright','©%Y Botble Team. All Rights Reserved.',NULL,NULL),(75,'theme-carento-favicon','general/favicon.png',NULL,NULL),(76,'theme-carento-logo','general/logo.png',NULL,NULL),(77,'theme-carento-logo_dark','general/logo-dark.png',NULL,NULL),(78,'theme-carento-logo_height','76',NULL,NULL),(79,'theme-carento-primary_font','Urbanist',NULL,NULL),(80,'theme-carento-secondary_font','Urbanist',NULL,NULL),(81,'theme-carento-primary_color','#82b440',NULL,NULL),(82,'theme-carento-primary_color_hover','#7aa93c',NULL,NULL),(83,'theme-carento-secondary_color','rgba(45, 74, 44, 0.6)',NULL,NULL),(84,'theme-carento-heading_color','#000000',NULL,NULL),(85,'theme-carento-text_color','#454545',NULL,NULL),(86,'theme-carento-header_top_background_color','#000000',NULL,NULL),(87,'theme-carento-header_top_text_color','#ffffff',NULL,NULL),(88,'theme-carento-is_header_transparent','0',NULL,NULL),(89,'theme-carento-preloader_enabled','1',NULL,NULL),(90,'theme-carento-preloader_version','v2',NULL,NULL),(91,'theme-carento-breadcrumb_background_image','backgrounds/service-bg.jpg',NULL,NULL),(92,'theme-carento-homepage_id','1',NULL,NULL),(93,'theme-carento-blog_page_id','2',NULL,NULL),(94,'theme-carento-blog_post_list_page_title','Recent Posts',NULL,NULL),(95,'theme-carento-blog_post_list_page_description','Favorite vehicles based on customer reviews',NULL,NULL),(96,'theme-carento-blog_post_gird_items_per_row','2',NULL,NULL),(97,'theme-carento-blog_post_style','grid',NULL,NULL),(98,'theme-carento-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL),(99,'theme-carento-footer_text_color','#8e8e8e',NULL,NULL),(100,'theme-carento-footer_heading_color','#ffffff',NULL,NULL),(101,'theme-carento-footer_border_color','#5756567d',NULL,NULL),(102,'theme-carento-footer_background_color','#000000',NULL,NULL),(103,'theme-carento-newsletter_popup_enable','1',NULL,NULL),(104,'theme-carento-newsletter_popup_image','backgrounds/newsletter-bg.jpg',NULL,NULL),(105,'theme-carento-newsletter_popup_title','Special Offers',NULL,NULL),(106,'theme-carento-newsletter_popup_subtitle','Newsletter',NULL,NULL),(107,'theme-carento-newsletter_popup_description','Special Offer: Rent Your Car Today!',NULL,NULL),(108,'theme-carento-number_of_cars_per_page','30',NULL,NULL),(109,'theme-carento-display_header_top','1',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Find your next vehicle today','sliders/banner-1.jpg','/','Browse our diverse inventory and enjoy a seamless buying experience <br> with expert support every step of the way',0,'2025-11-17 21:14:23','2025-11-17 21:14:23'),(2,1,'Discover your next ride today','sliders/banner-2.jpg','/','Explore our wide selection and enjoy a smooth purchasing journey, <br> with expert assistance at every turn',1,'2025-11-17 21:14:23','2025-11-17 21:14:23'),(3,2,'CAR REVIEW','sliders/img-1-1.jpg','/','The Tucson Plug-in Hybrid is easy to drive and provides a sufficient all-electric range.',0,'2025-11-17 21:14:23','2025-11-17 21:14:23'),(4,2,'CAR REVIEW','sliders/img-1.jpg','/','The Tucson Plug-in Hybrid is easy to drive and provides a sufficient all-electric range.',1,'2025-11-17 21:14:23','2025-11-17 21:14:23');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-11-17 21:14:23','2025-11-17 21:14:23'),(2,'Home slider 02','home-slider-02','The slider in homepage page 2','published','2025-11-17 21:14:23','2025-11-17 21:14:23');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`),
  KEY `idx_slugs_reference` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'homepage',1,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(2,'blog',2,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(3,'contact',3,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(4,'services',4,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(5,'pricing',5,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(6,'about-us',6,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(7,'car-list-1',7,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(8,'car-list-2',8,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(9,'car-list-3',9,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(10,'car-list-4',10,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(11,'agencies',11,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(12,'faqs',12,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(13,'brands',13,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(14,'car-dealers',14,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(15,'our-awards',15,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(16,'copyright-notices',16,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(17,'terms-of-use',17,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(18,'privacy-notice',18,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(19,'lost-found',19,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(20,'car-rental-services',20,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(21,'vehicle-leasing-options',21,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(22,'long-term-car-rentals',22,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(23,'car-sales-and-trade-ins',23,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(24,'luxury-car-rentals',24,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(25,'rent-to-own-programs',25,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(26,'fleet-management-solutions',26,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(27,'affiliates',27,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(28,'travel-agents',28,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(29,'aarp-members',29,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(30,'points-programs',30,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(31,'military-veterans',31,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(32,'work-with-us',32,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(33,'advertise-with-us',33,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(34,'forum-support',34,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(35,'help-center',35,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(36,'live-chat',36,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(37,'how-it-works',37,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(38,'security',38,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(39,'refund-policy',39,'Botble\\Page\\Models\\Page','','2025-11-17 21:13:07','2025-11-17 21:13:07'),(40,'new-cars',1,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(41,'car-rentals',2,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(42,'electric-vehicles',3,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(43,'car-maintenance',4,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(44,'road-trips',5,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(45,'luxury-cars',6,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(46,'family-cars',7,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(47,'off-road-vehicles',8,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(48,'hybrid-cars',9,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(49,'car-innovations',10,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(50,'2024-cars',1,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(51,'car-leasing',2,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(52,'self-driving-cars',3,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(53,'eco-friendly',4,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(54,'car-subscription',5,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(55,'car-insurance',6,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(56,'used-cars',7,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(57,'car-detailing',8,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(58,'holiday-rentals',9,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(59,'cross-country-trips',10,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:13:14','2025-11-17 21:13:14'),(60,'top-5-new-cars-to-look-out-for-in-2024',1,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(61,'how-to-choose-the-best-car-rental-service-for-your-trip',2,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(62,'the-evolution-of-electric-vehicles-a-new-era',3,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(63,'leasing-vs-buying-a-car-which-is-right-for-you',4,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(64,'the-ultimate-road-trip-checklist',5,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(65,'the-benefits-of-renting-a-luxury-car-for-special-occasions',6,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(66,'tips-for-maintaining-your-car-to-extend-its-lifespan',7,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(67,'top-safety-features-to-look-for-in-a-family-car',8,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(68,'how-self-driving-cars-are-changing-the-future-of-transportation',9,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(69,'the-best-cars-for-off-road-adventures',10,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(70,'the-rise-of-car-subscription-services',11,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(71,'eco-friendly-driving-tips-to-reduce-your-carbon-footprint',12,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(72,'the-future-of-car-sharing-convenience-at-your-fingertips',13,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(73,'how-to-get-the-best-deals-on-car-rentals-during-holidays',14,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(74,'the-pros-and-cons-of-hybrid-vehicles',15,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(75,'how-to-properly-clean-and-detail-your-car',16,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(76,'car-innovations-what-to-expect-in-the-next-5-years',17,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(77,'the-ultimate-guide-to-buying-a-used-car',18,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(78,'how-to-plan-a-cross-country-trip-with-a-rented-car',19,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(79,'what-you-need-to-know-about-car-insurance-before-renting',20,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:13:14','2025-11-17 21:13:14'),(80,'stunning-electric-cars-of-2024',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(81,'top-luxury-cars-for-special-occasions',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(82,'family-cars-with-advanced-safety-features',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(83,'off-road-vehicles-in-action',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(84,'the-evolution-of-car-design-a-visual-journey',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(85,'best-road-trip-cars-of-the-year',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(86,'exclusive-new-car-models-unveiled',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(87,'iconic-cars-from-around-the-world',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(88,'the-future-of-electric-and-hybrid-cars',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(89,'luxury-car-interiors-a-closer-look',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:13:16','2025-11-17 21:13:16'),(90,'devon-lane',1,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(91,'marvin-mckinney',2,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(92,'ronald-richards',3,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(93,'cameron-williamson',4,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(94,'alicia-sanders',5,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(95,'ethan-wright',6,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(96,'isabella-johnson',7,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(97,'liam-brown',8,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:13:18','2025-11-17 21:13:18'),(98,'toyota-camry-xle-hybrid-2024',1,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(99,'honda-accord-sport-20t-2024',2,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(100,'mercedes-benz-c300-4matic-2024',3,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(101,'bmw-330i-xdrive-m-sport-2024',4,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(102,'lexus-es-350-f-sport-2024',5,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(103,'toyota-rav4-prime-xse-awd-2024',6,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(104,'honda-cr-v-touring-hybrid-awd-2024',7,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(105,'bmw-x5-xdrive40i-m-sport-2024',8,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(106,'mercedes-benz-glc-300-4matic-2024',9,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(107,'lexus-rx-350-f-sport-handling-awd-2024',10,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(108,'audi-a4-premium-plus-quattro-2024',11,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(109,'mazda-cx-5-25-turbo-signature-awd-2024',12,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(110,'tesla-model-3-long-range-awd-2024',13,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(111,'porsche-macan-s-2024',14,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(112,'volvo-xc60-b6-ultimate-awd-2024',15,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(113,'genesis-g70-33t-sport-prestige-awd-2024',16,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(114,'subaru-outback-limited-xt-2024',17,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(115,'acura-mdx-type-s-advance-2024',18,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(116,'range-rover-evoque-p250-s-2024',19,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(117,'infiniti-qx60-autograph-awd-2024',20,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(118,'nissan-altima-sr-vc-turbo-2024',21,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(119,'hyundai-sonata-n-line-2024',22,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(120,'kia-stinger-gt2-awd-2024',23,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(121,'volkswagen-atlas-cross-sport-sel-premium-2024',24,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(122,'chevrolet-blazer-rs-awd-2024',25,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(123,'ford-explorer-st-4wd-2024',26,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(124,'jeep-grand-cherokee-summit-reserve-4xe-2024',27,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(125,'cadillac-xt5-premium-luxury-awd-2024',28,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(126,'lincoln-aviator-reserve-awd-2024',29,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(127,'alfa-romeo-stelvio-veloce-awd-2024',30,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(128,'mclaren-720s-spider-2024',31,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(129,'mercedes-benz-g550-4matic-2024',32,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(130,'ford-mustang-gt-premium-2024',33,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(131,'porsche-911-carrera-s-2024',34,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(132,'audi-r8-v10-performance-2024',35,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(133,'lamborghini-huracan-evo-2024',36,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(134,'bmw-m4-competition-xdrive-2024',37,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(135,'maserati-ghibli-modena-2024',38,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(136,'bentley-continental-gt-v8-2024',39,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(137,'rolls-royce-ghost-black-badge-2024',40,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(138,'hyundai-tucson-limited-awd-2024',41,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(139,'kia-sportage-sx-turbo-awd-2024',42,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(140,'volkswagen-tiguan-sel-r-line-2024',43,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(141,'toyota-highlander-platinum-awd-2024',44,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(142,'honda-pilot-trailsport-awd-2024',45,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(143,'mazda-mx-5-miata-grand-touring-2024',46,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(144,'nissan-rogue-platinum-awd-2024',47,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(145,'mini-cooper-s-hardtop-2024',48,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(146,'dodge-challenger-rt-scat-pack-2024',49,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(147,'chevrolet-camaro-ss-1le-2024',50,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(148,'ferrari-f8-tributo-2024',51,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(149,'jaguar-f-pace-svr-2024',52,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(150,'land-rover-defender-110-x-2024',53,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(151,'chrysler-pacifica-pinnacle-awd-2024',54,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(152,'gmc-sierra-1500-denali-2024',55,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(153,'mitsubishi-outlander-sel-s-awc-2024',56,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(154,'peugeot-308-gt-premium-2024',57,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(155,'fiat-500x-sport-awd-2024',58,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(156,'smart-eq-fortwo-prime-2024',59,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(157,'toyota-corolla-hybrid-le-2024',60,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(158,'aston-martin-vantage-f1-edition-2024',61,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(159,'bugatti-chiron-super-sport-2024',62,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(160,'mclaren-artura-spider-2024',63,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(161,'pagani-huayra-roadster-bc-2024',64,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(162,'koenigsegg-jesko-absolut-2024',65,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(163,'mercedes-benz-e450-4matic-all-terrain-2024',66,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(164,'audi-q7-55-tfsi-quattro-premium-plus-2024',67,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(165,'bmw-x7-xdrive40i-m-sport-2024',68,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(166,'lexus-lx-600-ultra-luxury-2024',69,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(167,'volvo-s90-b6-ultimate-awd-2024',70,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(168,'genesis-gv70-25t-sport-awd-2024',71,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(169,'acura-tlx-type-s-pmc-edition-2024',72,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(170,'infiniti-q50-red-sport-400-awd-2024',73,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(171,'jaguar-xf-p300-r-dynamic-s-awd-2024',74,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(172,'alfa-romeo-giulia-quadrifoglio-2024',75,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(173,'porsche-cayenne-turbo-gt-2024',76,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(174,'range-rover-sport-hse-dynamic-2024',77,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(175,'mercedes-amg-gle-63-s-4matic-2024',78,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(176,'bmw-m5-competition-xdrive-2024',79,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(177,'audi-rs-q8-quattro-2024',80,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(178,'tesla-model-s-plaid-2024',81,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(179,'lucid-air-grand-touring-performance-2024',82,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(180,'rivian-r1s-adventure-2024',83,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(181,'polestar-2-long-range-dual-motor-2024',84,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(182,'genesis-electrified-gv70-advanced-awd-2024',85,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(183,'mercedes-maybach-s-580-4matic-2024',86,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(184,'bentley-bentayga-s-v8-2024',87,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(185,'rolls-royce-cullinan-black-badge-2024',88,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(186,'aston-martin-dbx707-2024',89,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(187,'maserati-levante-trofeo-2024',90,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(188,'ferrari-roma-spider-2024',91,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(189,'mclaren-gt-luxe-2024',92,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(190,'lamborghini-urus-performante-2024',93,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(191,'porsche-taycan-turbo-s-cross-turismo-2024',94,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(192,'bmw-xm-label-red-2024',95,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(193,'chevrolet-corvette-z06-3lz-2024',96,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(194,'ford-gt-heritage-edition-2024',97,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(195,'dodge-viper-acr-extreme-2024',98,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(196,'nissan-gt-r-nismo-special-edition-2024',99,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(197,'toyota-supra-30-premium-2024',100,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:14:23','2025-11-17 21:14:23'),(198,'driver-rental-service',1,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(199,'oil-change-service',2,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(200,'car-wash-detailing-package',3,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(201,'roadside-assistance',4,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(202,'temporary-car-replacement',5,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(203,'tire-replacement-balancing',6,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(204,'vehicle-inspection-service',7,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(205,'car-insurance-assistance',8,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(206,'pick-up-drop-off-service',9,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(207,'premium-fuel-service',10,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:14:24','2025-11-17 21:14:24'),(208,'sport',1,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:14:24','2025-11-17 21:14:24'),(209,'maserati',2,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:14:24','2025-11-17 21:14:24'),(210,'ferrari',3,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:14:24','2025-11-17 21:14:24'),(211,'classic',4,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:14:24','2025-11-17 21:14:24'),(212,'new',5,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:14:24','2025-11-17 21:14:24'),(213,'lexus',1,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(214,'mercedes',2,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(215,'bugatti',3,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(216,'jaguar',4,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(217,'honda',5,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(218,'chevrolet',6,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(219,'acura',7,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(220,'bmw',8,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(221,'toyota',9,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(222,'ford',10,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(223,'nissan',11,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(224,'opel',12,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(225,'bmw',13,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24'),(226,'toyota',14,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:14:24','2025-11-17 21:14:24');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`),
  KEY `idx_states_name` (`name`),
  KEY `idx_states_status` (`status`),
  KEY `idx_states_country_id` (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'California','california','CA',1,1,NULL,1,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(2,'New York','new-york','NY',1,2,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(3,'Florida','florida','FL',1,3,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(4,'Texas','texas','TX',1,4,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(5,'Illinois','illinois','IL',1,5,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(6,'England','england','ENG',2,6,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(7,'Scotland','scotland','SCT',2,7,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(8,'Ontario','ontario','ON',3,8,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(9,'British Columbia','british-columbia','BC',3,9,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(10,'Bavaria','bavaria','BY',4,10,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(11,'Berlin','berlin','BE',4,11,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(12,'Île-de-France','ile-de-france','IDF',5,12,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(13,'Provence-Alpes-Côte d\'Azur','provence-alpes-cote-dazur','PACA',5,13,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(14,'New South Wales','new-south-wales','NSW',6,14,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(15,'Victoria','victoria','VIC',6,15,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(16,'Tokyo','tokyo','TK',7,16,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(17,'Osaka','osaka','OS',7,17,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(18,'Lazio','lazio','LAZ',8,18,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21'),(19,'Lombardy','lombardy','LOM',8,19,NULL,0,'published','2025-11-17 21:13:21','2025-11-17 21:13:21');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`),
  KEY `idx_states_trans_state_lang` (`states_id`,`lang_code`),
  KEY `idx_states_trans_name` (`name`),
  KEY `idx_states_trans_states_id` (`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'2024 Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(2,'Car Leasing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(3,'Self-Driving Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(4,'Eco-Friendly',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(5,'Car Subscription',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(6,'Car Insurance',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(7,'Used Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(8,'Car Detailing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(9,'Holiday Rentals',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14'),(10,'Cross-Country Trips',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:13:14','2025-11-17 21:13:14');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teams`
--

DROP TABLE IF EXISTS `teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `socials` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `phone` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teams`
--

LOCK TABLES `teams` WRITE;
/*!40000 ALTER TABLE `teams` DISABLE KEYS */;
INSERT INTO `teams` VALUES (1,'Devon Lane','teams/1.jpg','Chief Executive Officer (CEO)','India','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','01123259241','devonsoland111@gmail.com','4855, 24, Ansari Road, Darya Ganj',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(2,'Marvin McKinney','teams/2.jpg','Fleet Manager','Thailand','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','6623742088','marvinkensy@gmail.com','849 Sukhapibal 1 Klong Chan Bang Kapi',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(3,'Ronald Richards','teams/3.jpg','Customer Service Representative','Canada','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','4165550123','ronrichards@marketing.com','123 Maple Street, Toronto, ON',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(4,'Cameron Williamson','teams/4.jpg','Finance &amp; Accounting Officer','Germany','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','49221567890','cameronwill@tech.com','45 Hauptstraße, 50667 Köln',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(5,'Alicia Sanders','teams/5.jpg','Marketing Executive','Australia','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0298765432','alicia.hr@company.com','15 George St, Sydney, NSW',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(6,'Ethan Wright','teams/6.jpg','Automotive Technician/Mechanic','South Africa','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0217896543','ethanwright@operations.com','789 Beach Road, Cape Town',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(7,'Isabella Johnson','teams/7.jpg','Operations Coordinator','New Zealand','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0498761234','isabella.prod@company.com','32 Victoria St, Wellington',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(8,'Liam Brown','teams/8.jpg','HR &amp; Administration Officer','United Kingdom','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:13:18','2025-11-17 21:13:18','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','02079461234','liam.legal@company.co.uk','10 Downing Street, London',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally');
/*!40000 ALTER TABLE `teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teams_translations`
--

DROP TABLE IF EXISTS `teams_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `teams_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`teams_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teams_translations`
--

LOCK TABLES `teams_translations` WRITE;
/*!40000 ALTER TABLE `teams_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `teams_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','testimonials/1.png','CEO, JAKS Shans','published','2025-11-17 21:13:19','2025-11-17 21:13:19'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','testimonials/2.png','SEO, ChenTech Solutions','published','2025-11-17 21:13:19','2025-11-17 21:13:19'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','testimonials/3.png','Developer, Moie Agency','published','2025-11-17 21:13:19','2025-11-17 21:13:19'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','testimonials/4.png','CEO, Bank of America','published','2025-11-17 21:13:19','2025-11-17 21:13:19');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_settings`
--

DROP TABLE IF EXISTS `user_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` json NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_settings_user_type_user_id_key_unique` (`user_type`,`user_id`,`key`),
  KEY `user_settings_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `user_settings_key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_settings`
--

LOCK TABLES `user_settings` WRITE;
/*!40000 ALTER TABLE `user_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  `sessions_invalidated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'kboyle@lockman.info',NULL,NULL,'$2y$12$pAtel7A1IeXTSRSEZxUoG.oJKI2WU7VSHPfGcLwArelmfejxVqkN2',NULL,'2025-11-17 21:13:08','2025-11-17 21:13:18','Duncan','Skiles','admin',64,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `widgets_unique_index` (`theme`,`sidebar_id`,`widget_id`,`position`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInformationWidget','footer_sidebar','carento',1,'{\"id\":\"SiteInformationWidget\",\"logo\":\"general\\/logo-dark.png\",\"quantity\":4,\"icon_1\":\"ti ti-map-pin\",\"description_1\":\"2356 Oakwood Drive, Suite 18, San Francisco, California 94111, US\",\"icon_2\":\"ti ti-clock-hour-3\",\"description_2\":\"Hours: 8:00 - 17:00, Mon - Sat\",\"icon_3\":\"ti ti-mail\",\"description_3\":\"support@carento.com\",\"title_4\":\"Need help? Call us\",\"icon_4\":\"ti ti-phone\",\"description_4\":\"<a href=\\\"tel:+1 222-555-33-99\\\">+1 222-555-33-99<\\/a>\"}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(2,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Company\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Awards\"},{\"key\":\"url\",\"value\":\"\\/our-awards\"}],[{\"key\":\"label\",\"value\":\"Agencies\"},{\"key\":\"url\",\"value\":\"\\/agencies\"}],[{\"key\":\"label\",\"value\":\"Copyright Notices\"},{\"key\":\"url\",\"value\":\"\\/copyright-notices\"}],[{\"key\":\"label\",\"value\":\"Terms of Use\"},{\"key\":\"url\",\"value\":\"\\/terms-of-use\"}],[{\"key\":\"label\",\"value\":\"Privacy Notice\"},{\"key\":\"url\",\"value\":\"\\/privacy-notice\"}],[{\"key\":\"label\",\"value\":\"Lost & Found\"},{\"key\":\"url\",\"value\":\"\\/lost-found\"}]]}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(3,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Our Services\",\"items\":[[{\"key\":\"label\",\"value\":\"Premium Fuel Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/premium-fuel-service\"}],[{\"key\":\"label\",\"value\":\"Pick-Up & Drop-Off Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/pick-up-drop-off-service\"}],[{\"key\":\"label\",\"value\":\"Car Insurance Assistance\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/car-insurance-assistance\"}],[{\"key\":\"label\",\"value\":\"Vehicle Inspection Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/vehicle-inspection-service\"}],[{\"key\":\"label\",\"value\":\"Tire Replacement & Balancing\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/tire-replacement-balancing\"}],[{\"key\":\"label\",\"value\":\"Temporary Car Replacement\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/temporary-car-replacement\"}],[{\"key\":\"label\",\"value\":\"Roadside Assistance\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/roadside-assistance\"}]]}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',4,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Our Partners\",\"items\":[[{\"key\":\"label\",\"value\":\"Affiliates\"},{\"key\":\"url\",\"value\":\"\\/affiliates\"}],[{\"key\":\"label\",\"value\":\"Travel Agents\"},{\"key\":\"url\",\"value\":\"\\/travel-agents\"}],[{\"key\":\"label\",\"value\":\"AARP Members\"},{\"key\":\"url\",\"value\":\"\\/aarp-members\"}],[{\"key\":\"label\",\"value\":\"Points Programs\"},{\"key\":\"url\",\"value\":\"\\/points-programs\"}],[{\"key\":\"label\",\"value\":\"Military & Veterans\"},{\"key\":\"url\",\"value\":\"\\/military-veterans\"}],[{\"key\":\"label\",\"value\":\"Work with us\"},{\"key\":\"url\",\"value\":\"\\/work-with-us\"}],[{\"key\":\"label\",\"value\":\"Advertise with us\"},{\"key\":\"url\",\"value\":\"\\/advertise-with-us\"}]]}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',5,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Support\",\"items\":[[{\"key\":\"label\",\"value\":\"Forum support\"},{\"key\":\"url\",\"value\":\"\\/forum-support\"}],[{\"key\":\"label\",\"value\":\"Help Center\"},{\"key\":\"url\",\"value\":\"\\/help-center\"}],[{\"key\":\"label\",\"value\":\"Live chat\"},{\"key\":\"url\",\"value\":\"\\/live-chat\"}],[{\"key\":\"label\",\"value\":\"How it works\"},{\"key\":\"url\",\"value\":\"\\/how-it-works\"}],[{\"key\":\"label\",\"value\":\"Security\"},{\"key\":\"url\",\"value\":\"\\/security\"}],[{\"key\":\"label\",\"value\":\"Refund Policy\"},{\"key\":\"url\",\"value\":\"\\/refund-policy\"}]]}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(6,'SiteCopyrightWidget','bottom_footer_sidebar','carento',1,'[]','2025-11-17 21:14:22','2025-11-17 21:14:22'),(7,'SocialLinksWidget','bottom_footer_sidebar','carento',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"\"}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(8,'NewsletterWidget','top_footer_sidebar','carento',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe to see secret deals prices drop the moment you sign up!\",\"button_label\":\"Subscribe\"}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(9,'ContactInformationWidget','header_top_sidebar','carento',1,'{\"id\":\"ContactInformationWidget\",\"quantity\":2,\"title_1\":\"+123 9898 500\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:123 9898 500\",\"title_2\":\"sale@carento.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:sale@carento.com\"}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(10,'BlogSearchWidget','blog_sidebar','carento',1,'{\"id\":\"BlogSearchWidget\"}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(11,'BlogPostsWidget','blog_sidebar','carento',2,'{\"id\":\"BlogPostsWidget\",\"title\":\"Latest Posts\",\"category_ids\":[1,2,3,4,5],\"limit\":5}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(12,'GalleriesWidget','blog_sidebar','carento',3,'{\"id\":\"GalleriesWidget\",\"title\":\"Instagram Posts\",\"limit\":9}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(13,'FeaturedPostsWidget','above_blog_list_sidebar','carento',1,'{\"id\":\"FeaturedPostsWidget\",\"title\":\"Inside & Trending\",\"category_ids\":[1,2,3,4,5,6],\"limit\":4}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(14,'BlogPostsWidget','off_canvas_sidebar','carento',1,'{\"id\":\"BlogPostsWidget\",\"title\":\"Latest Posts\",\"category_ids\":[1,2,3,4,5],\"limit\":5}','2025-11-17 21:14:22','2025-11-17 21:14:22'),(15,'SiteInformationWidget','off_canvas_sidebar','carento',2,'{\"id\":\"SiteInformationWidget\",\"logo\":\"icons\\/contact.png\",\"quantity\":4,\"icon_1\":\"ti ti-map-pin\",\"description_1\":\"2356 Oakwood Drive, Suite 18, San Francisco, California 94111, US\",\"icon_2\":\"ti ti-clock-hour-3\",\"description_2\":\"Hours: 8:00 - 17:00, Mon - Sat\",\"icon_3\":\"ti ti-mail\",\"description_3\":\"support@carento.com\"}','2025-11-17 21:14:22','2025-11-17 21:14:22');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-11-18 11:14:24
