-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: carento
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'A4be3Ajx53Vug7FKQeea19tWM5ydwbea',1,'2025-11-17 21:09:50','2025-11-17 21:09:50','2025-11-17 21:09:50');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Drive Your Dream Car Today – Affordable Rentals at Your Fingertips!',1,'Book Now','/',0,1,'2025-11-18 04:09:51',NULL,1,'2025-11-17 21:09:51','2025-11-17 21:09:51'),(2,'Announcement 2','Hit the Road in Style – Premium Car Rentals for Every Journey!',1,'Book Now','/',0,1,'2025-11-18 04:09:51',NULL,1,'2025-11-17 21:09:51','2025-11-17 21:09:51'),(3,'Announcement 3','Explore the Open Road – Hassle-Free Car Rentals Just a Click Away!',1,'Book Now','/',0,1,'2025-11-18 04:09:51',NULL,1,'2025-11-17 21:09:51','2025-11-17 21:09:51');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'New Cars',0,'Quos et qui voluptate. Saepe magni soluta minima illum. Eligendi animi sint alias eligendi id quia explicabo.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(2,'Car Rentals',0,'Sed totam assumenda non nisi cumque magnam. Aut sit nisi ducimus assumenda in et. Explicabo et esse quasi. Harum omnis adipisci aliquam ut quasi labore.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(3,'Electric Vehicles',0,'At saepe dolore tempore qui sed. Sit eaque repellat maxime sint. Commodi quibusdam quisquam at quia.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(4,'Car Maintenance',0,'Et rerum alias veniam dolor optio. Iure alias sequi minus quia nihil. Voluptatem omnis repellat nisi quis iste. Similique ratione qui omnis vero rerum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(5,'Road Trips',0,'Earum accusantium voluptatem neque dolor laboriosam. Perferendis atque quos quos quos rem repudiandae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(6,'Luxury Cars',0,'Molestiae vero quaerat ullam. Quia ratione adipisci nostrum dolorum inventore. Non dolorum doloribus sapiente deserunt nostrum molestiae quaerat placeat.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(7,'Family Cars',0,'Quia nostrum quas odit sunt consequatur sed. Expedita quisquam ut et iste est autem non. Omnis laborum voluptatibus quis deserunt quas molestiae aut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(8,'Off-Road Vehicles',0,'Quaerat quos vero distinctio et vel atque. Dolorum exercitationem ut vel. Distinctio nulla inventore alias sit. Adipisci unde aspernatur quasi eos atque.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(9,'Hybrid Cars',0,'Animi occaecati error aut incidunt ex aut eius. Numquam aut nam nisi quas temporibus accusantium atque. Iste est aliquid molestiae vel commodi nobis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(10,'Car Innovations',0,'Sint id labore dolor architecto cumque. Sed sit nihil reiciendis. Perspiciatis saepe deleniti consequatur qui voluptate itaque.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-17 21:09:57','2025-11-17 21:09:57');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`),
  KEY `idx_cities_name` (`name`),
  KEY `idx_cities_state_status` (`state_id`,`status`),
  KEY `idx_cities_status` (`status`),
  KEY `idx_cities_state_id` (`state_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Los Angeles','los-angeles',1,1,NULL,1,'locations/location1.jpg',1,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(2,'San Francisco','san-francisco',1,1,NULL,2,'locations/location2.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(3,'San Diego','san-diego',1,1,NULL,3,'locations/location3.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(4,'New York City','new-york-city',2,1,NULL,4,'locations/location4.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(5,'Buffalo','buffalo',2,1,NULL,5,'locations/location5.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(6,'Miami','miami',3,1,NULL,6,'locations/location6.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(7,'Orlando','orlando',3,1,NULL,7,'locations/location1.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(8,'Houston','houston',4,1,NULL,8,'locations/location2.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(9,'Austin','austin',4,1,NULL,9,'locations/location3.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(10,'Chicago','chicago',5,1,NULL,10,'locations/location4.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(11,'London','london',6,2,NULL,11,'locations/location5.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(12,'Manchester','manchester',6,2,NULL,12,'locations/location6.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(13,'Edinburgh','edinburgh',7,2,NULL,13,'locations/location1.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(14,'Toronto','toronto',8,3,NULL,14,'locations/location2.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(15,'Ottawa','ottawa',8,3,NULL,15,'locations/location3.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(16,'Vancouver','vancouver',9,3,NULL,16,'locations/location4.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(17,'Munich','munich',10,4,NULL,17,'locations/location5.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(18,'Berlin','berlin',11,4,NULL,18,'locations/location6.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(19,'Paris','paris',12,5,NULL,19,'locations/location1.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(20,'Nice','nice',13,5,NULL,20,'locations/location2.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(21,'Sydney','sydney',14,6,NULL,21,'locations/location3.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(22,'Melbourne','melbourne',15,6,NULL,22,'locations/location4.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(23,'Tokyo','tokyo',16,7,NULL,23,'locations/location5.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(24,'Osaka','osaka',17,7,NULL,24,'locations/location6.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(25,'Rome','rome',18,8,NULL,25,'locations/location1.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(26,'Milan','milan',19,8,NULL,26,'locations/location2.jpg',0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL);
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`),
  KEY `idx_cities_trans_city_lang` (`cities_id`,`lang_code`),
  KEY `idx_cities_trans_name` (`name`),
  KEY `idx_cities_trans_cities_id` (`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_countries_name` (`name`),
  KEY `idx_countries_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'United States','American',1,NULL,1,'published','2025-11-17 21:10:05',NULL,'US'),(2,'United Kingdom','British',2,NULL,0,'published','2025-11-17 21:10:05',NULL,'GB'),(3,'Canada','Canadian',3,NULL,0,'published','2025-11-17 21:10:05',NULL,'CA'),(4,'Germany','German',4,NULL,0,'published','2025-11-17 21:10:05',NULL,'DE'),(5,'France','French',5,NULL,0,'published','2025-11-17 21:10:05',NULL,'FR'),(6,'Australia','Australian',6,NULL,0,'published','2025-11-17 21:10:05',NULL,'AU'),(7,'Japan','Japanese',7,NULL,0,'published','2025-11-17 21:10:05',NULL,'JP'),(8,'Italy','Italian',8,NULL,0,'published','2025-11-17 21:10:05',NULL,'IT');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`),
  KEY `idx_countries_trans_country_lang` (`countries_id`,`lang_code`),
  KEY `idx_countries_trans_name` (`name`),
  KEY `idx_countries_trans_countries_id` (`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_booking_cars`
--

DROP TABLE IF EXISTS `cr_booking_cars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_booking_cars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `car_id` bigint unsigned NOT NULL,
  `pickup_city_id` bigint unsigned DEFAULT NULL,
  `return_city_id` bigint unsigned DEFAULT NULL,
  `car_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `car_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` double NOT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `rental_start_date` datetime NOT NULL,
  `rental_end_date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_booking_cars`
--

LOCK TABLES `cr_booking_cars` WRITE;
/*!40000 ALTER TABLE `cr_booking_cars` DISABLE KEYS */;
INSERT INTO `cr_booking_cars` VALUES (1,1,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',196,1,'2025-11-14 00:00:00','2025-11-18 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(2,2,57,NULL,NULL,NULL,'Peugeot 308 GT Premium 2024',244,1,'2025-09-21 00:00:00','2025-09-25 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(3,3,66,NULL,NULL,NULL,'Mercedes-Benz E450 4MATIC All-Terrain 2024',76,1,'2025-09-21 00:00:00','2025-09-23 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(4,4,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',49,1,'2025-10-06 00:00:00','2025-10-07 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(5,5,34,NULL,NULL,NULL,'Porsche 911 Carrera S 2024',234,1,'2025-10-22 00:00:00','2025-10-25 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(6,6,43,NULL,NULL,NULL,'Volkswagen Tiguan SEL R-Line 2024',475,1,'2025-10-05 00:00:00','2025-10-10 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(7,7,59,NULL,NULL,NULL,'Smart EQ fortwo Prime 2024',170,1,'2025-10-24 00:00:00','2025-10-29 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(8,8,89,NULL,NULL,NULL,'Aston Martin DBX707 2024',98,1,'2025-10-29 00:00:00','2025-10-30 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(9,9,85,NULL,NULL,NULL,'Genesis Electrified GV70 Advanced AWD 2024',282,1,'2025-10-14 00:00:00','2025-10-20 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(10,10,82,NULL,NULL,NULL,'Lucid Air Grand Touring Performance 2024',141,1,'2025-10-21 00:00:00','2025-10-24 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(11,11,80,NULL,NULL,NULL,'Audi RS Q8 quattro 2024',546,1,'2025-11-12 00:00:00','2025-11-18 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(12,12,54,NULL,NULL,NULL,'Chrysler Pacifica Pinnacle AWD 2024',64,1,'2025-10-04 00:00:00','2025-10-05 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(13,13,56,NULL,NULL,NULL,'Mitsubishi Outlander SEL S-AWC 2024',126,1,'2025-10-26 00:00:00','2025-10-28 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(14,14,59,NULL,NULL,NULL,'Smart EQ fortwo Prime 2024',34,1,'2025-10-12 00:00:00','2025-10-13 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(15,15,76,NULL,NULL,NULL,'Porsche Cayenne Turbo GT 2024',343,1,'2025-10-20 00:00:00','2025-10-27 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(16,16,63,NULL,NULL,NULL,'McLaren Artura Spider 2024',370,1,'2025-10-13 00:00:00','2025-10-18 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(17,17,11,NULL,NULL,NULL,'Audi A4 Premium Plus quattro 2024',30,1,'2025-10-29 00:00:00','2025-10-30 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(18,18,52,NULL,NULL,NULL,'Jaguar F-PACE SVR 2024',252,1,'2025-10-28 00:00:00','2025-11-03 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(19,19,71,NULL,NULL,NULL,'Genesis GV70 2.5T Sport AWD 2024',276,1,'2025-11-11 00:00:00','2025-11-15 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(20,20,5,NULL,NULL,NULL,'Lexus ES 350 F Sport 2024',245,1,'2025-09-20 00:00:00','2025-09-25 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(21,21,30,NULL,NULL,NULL,'Alfa Romeo Stelvio Veloce AWD 2024',546,1,'2025-10-29 00:00:00','2025-11-04 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(22,22,76,NULL,NULL,NULL,'Porsche Cayenne Turbo GT 2024',147,1,'2025-09-26 00:00:00','2025-09-29 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(23,23,97,NULL,NULL,NULL,'Ford GT Heritage Edition 2024',180,1,'2025-11-16 00:00:00','2025-11-22 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(24,24,46,NULL,NULL,NULL,'Mazda MX-5 Miata Grand Touring 2024',180,1,'2025-10-30 00:00:00','2025-11-03 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(25,25,66,NULL,NULL,NULL,'Mercedes-Benz E450 4MATIC All-Terrain 2024',76,1,'2025-10-19 00:00:00','2025-10-21 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(26,26,16,NULL,NULL,NULL,'Genesis G70 3.3T Sport Prestige AWD 2024',62,1,'2025-10-02 00:00:00','2025-10-04 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(27,27,94,NULL,NULL,NULL,'Porsche Taycan Turbo S Cross Turismo 2024',582,1,'2025-11-01 00:00:00','2025-11-07 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(28,28,67,NULL,NULL,NULL,'Audi Q7 55 TFSI quattro Premium Plus 2024',292,1,'2025-11-01 00:00:00','2025-11-05 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(29,29,53,NULL,NULL,NULL,'Land Rover Defender 110 X 2024',427,1,'2025-11-07 00:00:00','2025-11-14 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(30,30,7,NULL,NULL,NULL,'Honda CR-V Touring Hybrid AWD 2024',224,1,'2025-10-19 00:00:00','2025-10-26 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(31,31,9,NULL,NULL,NULL,'Mercedes-Benz GLC 300 4MATIC 2024',320,1,'2025-11-15 00:00:00','2025-11-19 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(32,32,20,NULL,NULL,NULL,'Infiniti QX60 Autograph AWD 2024',426,1,'2025-11-12 00:00:00','2025-11-18 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(33,33,99,NULL,NULL,NULL,'Nissan GT-R NISMO Special Edition 2024',264,1,'2025-11-14 00:00:00','2025-11-20 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(34,34,81,NULL,NULL,NULL,'Tesla Model S Plaid 2024',284,1,'2025-11-18 00:00:00','2025-11-22 00:00:00','2025-11-17 21:11:20','2025-11-17 21:11:20'),(35,35,8,NULL,NULL,NULL,'BMW X5 xDrive40i M Sport 2024',360,1,'2025-11-12 00:00:00','2025-11-16 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(36,36,86,NULL,NULL,NULL,'Mercedes-Maybach S 580 4MATIC 2024',552,1,'2025-11-17 00:00:00','2025-11-23 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(37,37,69,NULL,NULL,NULL,'Lexus LX 600 Ultra Luxury 2024',49,1,'2025-11-17 00:00:00','2025-11-18 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(38,38,27,NULL,NULL,NULL,'Jeep Grand Cherokee Summit Reserve 4xe 2024',36,1,'2025-11-12 00:00:00','2025-11-13 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(39,39,75,NULL,NULL,NULL,'Alfa Romeo Giulia Quadrifoglio 2024',176,1,'2025-11-11 00:00:00','2025-11-13 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(40,40,96,NULL,NULL,NULL,'Chevrolet Corvette Z06 3LZ 2024',188,1,'2025-11-16 00:00:00','2025-11-18 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(41,41,32,NULL,NULL,NULL,'Mercedes-Benz G550 4MATIC 2024',55,1,'2025-11-15 00:00:00','2025-11-16 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(42,42,94,NULL,NULL,NULL,'Porsche Taycan Turbo S Cross Turismo 2024',291,1,'2025-11-11 00:00:00','2025-11-14 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(43,43,87,NULL,NULL,NULL,'Bentley Bentayga S V8 2024',355,1,'2025-11-17 00:00:00','2025-11-22 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(44,44,50,NULL,NULL,NULL,'Chevrolet Camaro SS 1LE 2024',420,1,'2025-11-15 00:00:00','2025-11-21 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(45,45,3,NULL,NULL,NULL,'Mercedes-Benz C300 4MATIC 2024',570,1,'2025-11-16 00:00:00','2025-11-22 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(46,46,54,NULL,NULL,NULL,'Chrysler Pacifica Pinnacle AWD 2024',384,1,'2025-11-14 00:00:00','2025-11-20 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(47,47,31,NULL,NULL,NULL,'McLaren 720S Spider 2024',96,1,'2025-11-14 00:00:00','2025-11-16 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(48,48,29,NULL,NULL,NULL,'Lincoln Aviator Reserve AWD 2024',33,1,'2025-11-13 00:00:00','2025-11-14 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(49,49,29,NULL,NULL,NULL,'Lincoln Aviator Reserve AWD 2024',165,1,'2025-11-16 00:00:00','2025-11-21 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(50,50,52,NULL,NULL,NULL,'Jaguar F-PACE SVR 2024',84,1,'2025-11-12 00:00:00','2025-11-14 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(51,51,64,NULL,NULL,NULL,'Pagani Huayra Roadster BC 2024',270,1,'2025-12-04 00:00:00','2025-12-10 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(52,52,45,NULL,NULL,NULL,'Honda Pilot TrailSport AWD 2024',192,1,'2025-11-26 00:00:00','2025-11-29 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(53,53,76,NULL,NULL,NULL,'Porsche Cayenne Turbo GT 2024',196,1,'2025-12-18 00:00:00','2025-12-22 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(54,54,65,NULL,NULL,NULL,'Koenigsegg Jesko Absolut 2024',602,1,'2025-12-04 00:00:00','2025-12-11 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(55,55,38,NULL,NULL,NULL,'Maserati Ghibli Modena 2024',291,1,'2025-12-17 00:00:00','2025-12-20 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(56,56,64,NULL,NULL,NULL,'Pagani Huayra Roadster BC 2024',45,1,'2025-11-29 00:00:00','2025-11-30 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(57,57,77,NULL,NULL,NULL,'Range Rover Sport HSE Dynamic 2024',570,1,'2025-12-09 00:00:00','2025-12-15 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(58,58,71,NULL,NULL,NULL,'Genesis GV70 2.5T Sport AWD 2024',414,1,'2025-12-04 00:00:00','2025-12-10 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(59,59,27,NULL,NULL,NULL,'Jeep Grand Cherokee Summit Reserve 4xe 2024',216,1,'2025-11-23 00:00:00','2025-11-29 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(60,60,29,NULL,NULL,NULL,'Lincoln Aviator Reserve AWD 2024',99,1,'2025-12-02 00:00:00','2025-12-05 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(61,61,66,NULL,NULL,NULL,'Mercedes-Benz E450 4MATIC All-Terrain 2024',38,1,'2025-12-02 00:00:00','2025-12-03 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(62,62,32,NULL,NULL,NULL,'Mercedes-Benz G550 4MATIC 2024',110,1,'2025-12-01 00:00:00','2025-12-03 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(63,63,20,NULL,NULL,NULL,'Infiniti QX60 Autograph AWD 2024',355,1,'2025-11-26 00:00:00','2025-12-01 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(64,64,99,NULL,NULL,NULL,'Nissan GT-R NISMO Special Edition 2024',220,1,'2025-12-12 00:00:00','2025-12-17 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(65,65,37,NULL,NULL,NULL,'BMW M4 Competition xDrive 2024',570,1,'2025-11-19 00:00:00','2025-11-25 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(66,66,15,NULL,NULL,NULL,'Volvo XC60 B6 Ultimate AWD 2024',441,1,'2025-11-28 00:00:00','2025-12-05 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(67,67,18,NULL,NULL,NULL,'Acura MDX Type S Advance 2024',156,1,'2025-12-02 00:00:00','2025-12-04 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(68,68,33,NULL,NULL,NULL,'Ford Mustang GT Premium 2024',40,1,'2025-11-24 00:00:00','2025-11-25 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(69,69,82,NULL,NULL,NULL,'Lucid Air Grand Touring Performance 2024',282,1,'2025-11-23 00:00:00','2025-11-29 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(70,70,89,NULL,NULL,NULL,'Aston Martin DBX707 2024',294,1,'2025-12-16 00:00:00','2025-12-19 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(71,71,58,NULL,NULL,NULL,'Fiat 500X Sport AWD 2024',196,1,'2025-11-30 00:00:00','2025-12-04 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(72,72,24,NULL,NULL,NULL,'Volkswagen Atlas Cross Sport SEL Premium 2024',288,1,'2025-11-25 00:00:00','2025-11-29 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(73,73,83,NULL,NULL,NULL,'Rivian R1S Adventure 2024',438,1,'2025-11-28 00:00:00','2025-12-04 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(74,74,11,NULL,NULL,NULL,'Audi A4 Premium Plus quattro 2024',210,1,'2025-12-10 00:00:00','2025-12-17 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(75,75,86,NULL,NULL,NULL,'Mercedes-Maybach S 580 4MATIC 2024',644,1,'2025-12-13 00:00:00','2025-12-20 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(76,76,14,NULL,NULL,NULL,'Porsche Macan S 2024',90,1,'2025-12-11 00:00:00','2025-12-14 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(77,77,63,NULL,NULL,NULL,'McLaren Artura Spider 2024',518,1,'2025-12-10 00:00:00','2025-12-17 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(78,78,71,NULL,NULL,NULL,'Genesis GV70 2.5T Sport AWD 2024',483,1,'2025-11-20 00:00:00','2025-11-27 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(79,79,96,NULL,NULL,NULL,'Chevrolet Corvette Z06 3LZ 2024',282,1,'2025-12-09 00:00:00','2025-12-12 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21'),(80,80,75,NULL,NULL,NULL,'Alfa Romeo Giulia Quadrifoglio 2024',176,1,'2025-12-18 00:00:00','2025-12-20 00:00:00','2025-11-17 21:11:21','2025-11-17 21:11:21');
/*!40000 ALTER TABLE `cr_booking_cars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_booking_service`
--

DROP TABLE IF EXISTS `cr_booking_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_booking_service` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `service_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_booking_service`
--

LOCK TABLES `cr_booking_service` WRITE;
/*!40000 ALTER TABLE `cr_booking_service` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_booking_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_bookings`
--

DROP TABLE IF EXISTS `cr_bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_bookings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_age` int unsigned DEFAULT NULL,
  `customer_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` double NOT NULL,
  `sub_total` double NOT NULL,
  `coupon_amount` double NOT NULL DEFAULT '0',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_amount` double NOT NULL DEFAULT '0',
  `currency_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `completion_miles` int unsigned DEFAULT NULL,
  `completion_gas_level` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `completion_damage_images` text COLLATE utf8mb4_unicode_ci,
  `completion_notes` text COLLATE utf8mb4_unicode_ci,
  `completed_at` timestamp NULL DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_bookings_booking_number_unique` (`booking_number`),
  UNIQUE KEY `cr_bookings_transaction_id_unique` (`transaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_bookings`
--

LOCK TABLES `cr_bookings` WRITE;
/*!40000 ALTER TABLE `cr_bookings` DISABLE KEYS */;
INSERT INTO `cr_bookings` VALUES (1,'#1000002','OGP45B2PB5LHN0PKHDS3GRVG51D7GZYI','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',196,196,0,NULL,0,'1','1',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-13 21:11:20','2025-11-17 21:11:20',2),(2,'#1000003','EUC6I1TEVMND7UM7MQU5S71OWXM46V3Y','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',244,244,0,NULL,24.4,'1','2',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-20 21:11:20','2025-11-17 21:11:20',5),(3,'#1000004','CBPM6POUPE1D9EJG1A69Z4MZHGEEQ6AU','Abraham Gutmann','audreanne.casper@example.org','+14232526899',NULL,'24',76,76,0,NULL,7.6,'1','3',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-20 21:11:20','2025-11-17 21:11:20',16),(4,'#1000005','X2SNLNYXYPRGCVOMKB1SFGNZQEM9JJVM','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',49,49,0,NULL,4.9,'1','4',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-05 21:11:20','2025-11-17 21:11:20',2),(5,'#1000006','GFNVWJBXPGEYK8KYQKZ7GIGEEEGGDTPG','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',234,234,0,NULL,0,'1','5',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-21 21:11:20','2025-11-17 21:11:20',4),(6,'#1000007','TMQUECJXUZ197ABVGIZN7R83JG6DNEMJ','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',475,475,0,NULL,0,'1','6',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-04 21:11:20','2025-11-17 21:11:20',4),(7,'#1000008','VXQ67XNV14WDYCKW8LKQMKIW0HGAOYTE','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',170,170,0,NULL,0,'1','7',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-23 21:11:20','2025-11-17 21:11:20',7),(8,'#1000009','JXV5NZXFWXY6BDOYYZKE2UM3HUNPRY5W','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',98,98,0,NULL,0,'1','8',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-28 21:11:20','2025-11-17 21:11:20',NULL),(9,'#1000010','KMXZGDHK1HQ5IPLZJHLT1TVWUIDUAFA9','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',282,282,0,NULL,0,'1','9',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-13 21:11:20','2025-11-17 21:11:20',NULL),(10,'#1000011','QITELPKGQR5JFLPVX0SCV9BWYXY7QCKG','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',141,141,0,NULL,0,'1','10',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-20 21:11:20','2025-11-17 21:11:20',NULL),(11,'#1000012','QJYDXTN93XRERECGMKS3V31WYJ8KIIS5','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',546,546,0,NULL,54.6,'1','11',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-11 21:11:20','2025-11-17 21:11:20',11),(12,'#1000013','5PQ5DEVOGONHZXJ7G2FDG6R8RE57LJ6C','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',64,64,0,NULL,0,'1','12',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-03 21:11:20','2025-11-17 21:11:20',20),(13,'#1000014','MM4Y9SQCANBXUYDMZCEZAEXRRYGFAFPO','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',126,126,0,NULL,0,'1','13',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-25 21:11:20','2025-11-17 21:11:20',9),(14,'#1000015','YBINOPQJ3WVZOZCNYNGB6EXVDJSQ32V1','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',34,34,0,NULL,0,'1','14',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-11 21:11:20','2025-11-17 21:11:20',7),(15,'#1000016','QNZY13NDVUEAPFQJDU20UHOZPPPKPHMH','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',343,343,0,NULL,0,'1','15',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-19 21:11:20','2025-11-17 21:11:20',16),(16,'#1000017','X0Q7G7PRGDU0HVIDKZSW1W5E3PYVHW1O','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',370,370,0,NULL,0,'1','16',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-12 21:11:20','2025-11-17 21:11:20',32),(17,'#1000018','M9IXPJTSM6TAL4KBJNZHXNLCGRPVXQ1V','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',30,30,0,NULL,3,'1','17',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-28 21:11:20','2025-11-17 21:11:20',15),(18,'#1000019','HERIYUNOYDNV8UGIQQT77SMYMRML8APX','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',252,252,0,NULL,0,'1','18',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-27 21:11:20','2025-11-17 21:11:20',NULL),(19,'#1000020','JPPWU07MZGFOCBFE3BUQCDXGFQBNSZFZ','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',276,276,0,NULL,0,'1','19',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:11:20','2025-11-17 21:11:20',NULL),(20,'#1000021','VBOPHPBKBGRSXIOZIT0FAE8HWNVMGDSI','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',245,245,0,NULL,0,'1','20',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-19 21:11:20','2025-11-17 21:11:20',NULL),(21,'#1000022','2JVOAVJP2EM2ZREQJ8ZDHSEPABJWTHOE','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',546,546,0,NULL,0,'1','21',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-28 21:11:20','2025-11-17 21:11:20',19),(22,'#1000023','UMOZSXDIKJSUGM3QWTFHIWPNCPDP6KT8','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',147,147,0,NULL,0,'1','22',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-09-25 21:11:20','2025-11-17 21:11:20',16),(23,'#1000024','SDK1K5UF8JWXQ7RBDNXPJELYX3FNMSVA','Jarrod Schroeder','quigley.oliver@example.org','+17749757485',NULL,'27',180,180,0,NULL,18,'1','23',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-15 21:11:20','2025-11-17 21:11:20',15),(24,'#1000025','OFI6GNYPWDUFTTZYIGA2VCEUQWUNGWPV','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',180,180,0,NULL,0,'1','24',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-29 21:11:20','2025-11-17 21:11:20',10),(25,'#1000026','LMCR1GQY124WFT0CFAYYUPXBH8DWORMZ','Prof. Chad Flatley','htrantow@example.org','+14138452713',NULL,'22',76,76,0,NULL,0,'1','25',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-18 21:11:20','2025-11-17 21:11:20',16),(26,'#1000027','RNLANB7CIPOEBRMVUWHH2ODEITSCU5PZ','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',62,62,0,NULL,6.2,'1','26',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-01 21:11:20','2025-11-17 21:11:20',6),(27,'#1000028','MQJ9JGGNZFUEIGBEJZU3TORSEP5XDCL9','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',582,582,0,NULL,0,'1','27',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-31 21:11:20','2025-11-17 21:11:20',18),(28,'#1000029','1BOZN3ZLSLSNIJ7UQFRRRAJXNHL1J5NN','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',292,292,0,NULL,29.2,'1','28',NULL,NULL,NULL,NULL,NULL,NULL,'cancelled','2025-10-31 21:11:20','2025-11-17 21:11:20',NULL),(29,'#1000030','SVILDW4XQ1KEIPEZ1FVJGZDKY2ELWNGC','Prof. Chad Flatley','htrantow@example.org','+14138452713',NULL,'22',427,427,0,NULL,42.7,'1','29',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-06 21:11:20','2025-11-17 21:11:20',NULL),(30,'#1000031','HKIT8HVC96KNLHU7NSP2GMTBJDGNEH9D','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',224,224,0,NULL,22.4,'1','30',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-10-18 21:11:20','2025-11-17 21:11:20',NULL),(31,'#1000032','P5UR2NN4CKZTWU3BACAT6J90I6KCNJT3','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',320,320,0,NULL,32,'1','31',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-14 21:11:20','2025-11-17 21:11:20',6),(32,'#1000033','3RLT8ABFVD7DVRU0DIIZMXVCUPLRKBXR','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',426,426,0,NULL,0,'1','32',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:11:20','2025-11-17 21:11:20',8),(33,'#1000034','MVVGS0U77WNPZIZF9FD8PBH1XXJFXY9E','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',264,264,0,NULL,0,'1','33',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-13 21:11:20','2025-11-17 21:11:20',12),(34,'#1000035','PDAUGCSRGCWTMPHFQFENSUG0JWPVDNRW','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',284,284,0,NULL,28.4,'1','34',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-17 21:11:20','2025-11-17 21:11:20',13),(35,'#1000036','BMCDIC0HCWQP1WGTGPUBOZLNKTEFYXEL','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',360,360,0,NULL,0,'1','35',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-11 21:11:21','2025-11-17 21:11:21',13),(36,'#1000037','ZKADRR9TKSW1LCPCG929TNJS4OQJXOAS','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',552,552,0,NULL,55.2,'1','36',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-16 21:11:21','2025-11-17 21:11:21',14),(37,'#1000038','QJODW1VTTUG1K3R0JIOQT1T1YUORQ7CC','Jarrod Schroeder','quigley.oliver@example.org','+17749757485',NULL,'27',49,49,0,NULL,0,'1','37',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-16 21:11:21','2025-11-17 21:11:21',9),(38,'#1000039','HLCBL7ADSINS1FBCATPVNQ4W9TBZEWGR','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',36,36,0,NULL,0,'1','38',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-11 21:11:21','2025-11-17 21:11:21',NULL),(39,'#1000040','EJAUHJIHPUGEZDIBA3FKEGNWEEIAYNXB','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',176,176,0,NULL,0,'1','39',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:11:21','2025-11-17 21:11:21',NULL),(40,'#1000041','QMFPTCXP73XDQTAHXGS0ZEYB8LYUF28J','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',188,188,0,NULL,0,'1','40',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-15 21:11:21','2025-11-17 21:11:21',NULL),(41,'#1000042','6FKZ45EHM79MKKIWGJHBP6BE1TX2JY7G','Abraham Gutmann','audreanne.casper@example.org','+14232526899',NULL,'24',55,55,0,NULL,0,'1','41',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-14 21:11:21','2025-11-17 21:11:21',19),(42,'#1000043','CICKOURH9NPF98NDBBHZNHHTOJGZN0MW','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',291,291,0,NULL,0,'1','42',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-10 21:11:21','2025-11-17 21:11:21',18),(43,'#1000044','FYTZGTY7FYXC3GPA4GMSXPA3DJFWRRQO','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',355,355,0,NULL,0,'1','43',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-16 21:11:21','2025-11-17 21:11:21',11),(44,'#1000045','CBQ5QYJRZZ75MNUTHIPK2X5E2L0EBGXF','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',420,420,0,NULL,0,'1','44',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-14 21:11:21','2025-11-17 21:11:21',3),(45,'#1000046','3SXPTJBQU6GJKCPW0C6UTPOGPFUKBKBV','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',570,570,0,NULL,0,'1','45',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-15 21:11:21','2025-11-17 21:11:21',14),(46,'#1000047','KLCEJ6VISN5EOJK8Q0CFAFUAYTGIS4D8','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',384,384,0,NULL,0,'1','46',NULL,NULL,NULL,NULL,NULL,NULL,'completed','2025-11-13 21:11:21','2025-11-17 21:11:21',20),(47,'#1000048','I1BIARZU7EL19Z2JZAGZ6OBVWQLE933C','Abraham Gutmann','audreanne.casper@example.org','+14232526899',NULL,'24',96,96,0,NULL,0,'1','47',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-13 21:11:21','2025-11-17 21:11:21',1),(48,'#1000049','CSHLQJH8HWVWBKVQBDP879GE0T56PZJY','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',33,33,0,NULL,0,'1','48',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-12 21:11:21','2025-11-17 21:11:21',NULL),(49,'#1000050','F8B6QSJBNNAMRBBEFWZMP9FGRZI9XFSP','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',165,165,0,NULL,16.5,'1','49',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-15 21:11:21','2025-11-17 21:11:21',NULL),(50,'#1000051','GFLTJ5HBSU6JC6IUDKRJMDO6MPADJTJI','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',84,84,0,NULL,8.4,'1','50',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-11 21:11:21','2025-11-17 21:11:21',NULL),(51,'#1000052','NM5T8FVWAR8ZTQ8P6DAZWR8GDHMMEKTE','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',270,270,0,NULL,0,'1','51',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-03 21:11:21','2025-11-17 21:11:21',2),(52,'#1000053','WWNT8CKBYJJMIUNHMIGNVRGHCRCTNUN4','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',192,192,0,NULL,0,'1','52',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-25 21:11:21','2025-11-17 21:11:21',5),(53,'#1000054','REE0YGMIMCNCFXMQWCIH4OHY6ROKS7DI','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',196,196,0,NULL,19.6,'1','53',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-17 21:11:21','2025-11-17 21:11:21',16),(54,'#1000055','RSSHQLONAE0AN1M73CL3RV0JSR7GWWSS','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',602,602,0,NULL,60.2,'1','54',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-03 21:11:21','2025-11-17 21:11:21',10),(55,'#1000056','DMTRWCPK8UHRYUD6KMDI9UE72JI86N2X','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',291,291,0,NULL,29.1,'1','55',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-16 21:11:21','2025-11-17 21:11:21',4),(56,'#1000057','JSMXQPNZJRGPUVAPHBVJK2TQPIWBMPGT','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',45,45,0,NULL,4.5,'1','56',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-28 21:11:21','2025-11-17 21:11:21',2),(57,'#1000058','0ZO2GRK8DUKQVCMG1LZI25G5RTNDGC5W','Jarrod Schroeder','quigley.oliver@example.org','+17749757485',NULL,'27',570,570,0,NULL,0,'1','57',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-08 21:11:21','2025-11-17 21:11:21',10),(58,'#1000059','ANXPZWVQCQNT97JQEJNDONGWJ0PGJFYZ','Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',NULL,'23',414,414,0,NULL,0,'1','58',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-03 21:11:21','2025-11-17 21:11:21',NULL),(59,'#1000060','QEDNQWFY300LVDB1IEOBNCEEJQYCCUDG','Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',NULL,'30',216,216,0,NULL,0,'1','59',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-22 21:11:21','2025-11-17 21:11:21',NULL),(60,'#1000061','GVMA88IPGBHUFSP1YYB4F2CZOV3S6CZO','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',99,99,0,NULL,0,'1','60',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-01 21:11:21','2025-11-17 21:11:21',NULL),(61,'#1000062','NO3JUKKRHXKRCQX5ABTAXYCVCGUITDU8','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',38,38,0,NULL,0,'1','61',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-01 21:11:21','2025-11-17 21:11:21',16),(62,'#1000063','M2XPCJ4RU3H9RAJSDHPBFY2CF2L6R1PJ','Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',NULL,'29',110,110,0,NULL,0,'1','62',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-30 21:11:21','2025-11-17 21:11:21',19),(63,'#1000064','MLMUCUO5UCQA9WXTEVBAQPJ80WT8D1LO','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',355,355,0,NULL,0,'1','63',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-25 21:11:21','2025-11-17 21:11:21',8),(64,'#1000065','AEZBZHYS8I6YKBR14ICMUN37REVSS30H','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',220,220,0,NULL,0,'1','64',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-11 21:11:21','2025-11-17 21:11:21',12),(65,'#1000066','DVNYXSNNMFVGXQMSWAJKKI2IRQ6DQLHW','Jarrod Schroeder','quigley.oliver@example.org','+17749757485',NULL,'27',570,570,0,NULL,57,'1','65',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-18 21:11:21','2025-11-17 21:11:21',9),(66,'#1000067','E4HEGKBHAUFQRXDCPJSUWJSYGYE2HSYR','Estefania Dooley','dallas70@example.org','+15647257105',NULL,'26',441,441,0,NULL,44.1,'1','66',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-27 21:11:21','2025-11-17 21:11:21',4),(67,'#1000068','1DIXZTWUC6RKXXCKO9JBTILTTX0BVLKA','Abraham Gutmann','audreanne.casper@example.org','+14232526899',NULL,'24',156,156,0,NULL,0,'1','67',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-01 21:11:21','2025-11-17 21:11:21',4),(68,'#1000069','S7E7V40NSOCH6JV6YCBE78MKKBGJXBAR','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',40,40,0,NULL,0,'1','68',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-23 21:11:21','2025-11-17 21:11:21',NULL),(69,'#1000070','C1DMRCBJZ8NZRIDP5U57C6IS0SWBSIV0','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',282,282,0,NULL,28.2,'1','69',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-11-22 21:11:21','2025-11-17 21:11:21',NULL),(70,'#1000071','FYJLMDTT1BABGKPM8WUDV8HH2TFJCLGJ','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',294,294,0,NULL,0,'1','70',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-15 21:11:21','2025-11-17 21:11:21',NULL),(71,'#1000072','SRRLQYNTS4ZP7NY6VNEFBAW1M74UZBR9','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',196,196,0,NULL,0,'1','71',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-29 21:11:21','2025-11-17 21:11:21',2),(72,'#1000073','M7KGTBVUF2BLQ1YOUB2EP369JHEDOTOU','Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',NULL,'28',288,288,0,NULL,0,'1','72',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-24 21:11:21','2025-11-17 21:11:21',18),(73,'#1000074','9URRTIYN4EFUK4DCOXYRSSATGCA5AK67','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',438,438,0,NULL,0,'1','73',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-27 21:11:21','2025-11-17 21:11:21',12),(74,'#1000075','QNRK6NDCLS5BJCAUJXZF8YA7WXIA5JZ9','Abraham Gutmann','audreanne.casper@example.org','+14232526899',NULL,'24',210,210,0,NULL,0,'1','74',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-09 21:11:21','2025-11-17 21:11:21',15),(75,'#1000076','HZJTHMGBVL8LL0GE1ECHONFDN7XMR5EI','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',644,644,0,NULL,0,'1','75',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-12 21:11:21','2025-11-17 21:11:21',14),(76,'#1000077','5GHZ9SK9ZR4JXUBP9UTPQ8FE8R2GLBRS','Mrs. Hosea Stroman','customer@botble.com','+13526186202',NULL,'31',90,90,0,NULL,9,'1','76',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-10 21:11:21','2025-11-17 21:11:21',14),(77,'#1000078','ZMB9UR1UOSLDKBDCZAEMIKQODDQTCKCE','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',518,518,0,NULL,0,'1','77',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-09 21:11:21','2025-11-17 21:11:21',32),(78,'#1000079','13ZXQVHPSUNWZUMQFYOGBLLYORC1HKTF','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',483,483,0,NULL,0,'1','78',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-11-19 21:11:21','2025-11-17 21:11:21',NULL),(79,'#1000080','OS0TTC8MIALMSIJXMLIOO4C0BPGNG1ZV','Clementina Weimann','gibson.cali@example.org','+18486586228',NULL,'25',282,282,0,NULL,0,'1','79',NULL,NULL,NULL,NULL,NULL,NULL,'processing','2025-12-08 21:11:21','2025-11-17 21:11:21',NULL),(80,'#1000081','WO7AYNHJKQWQREBJC0NZ1XG9QI7WLYTH','Verla Conroy','adams.mackenzie@example.org','+17192703606',NULL,'21',176,176,0,NULL,0,'1','80',NULL,NULL,NULL,NULL,NULL,NULL,'pending','2025-12-17 21:11:21','2025-11-17 21:11:21',NULL);
/*!40000 ALTER TABLE `cr_bookings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenities`
--

DROP TABLE IF EXISTS `cr_car_amenities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_amenities_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenities`
--

LOCK TABLES `cr_car_amenities` WRITE;
/*!40000 ALTER TABLE `cr_car_amenities` DISABLE KEYS */;
INSERT INTO `cr_car_amenities` VALUES (1,'Leather upholstery','ti ti-armchair',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Heated seats','ti ti-flame',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Ventilated seats','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Memory seats','ti ti-device-floppy',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Massage seats','ti ti-massage',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Premium sound system','ti ti-volume',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(7,'Wireless charging','ti ti-battery-charging',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(8,'Dual-zone climate control','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(9,'Ambient lighting','ti ti-bulb',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(10,'Touchscreen display','ti ti-device-tablet',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(11,'Apple CarPlay','ti ti-brand-apple',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(12,'Android Auto','ti ti-brand-android',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(13,'Bluetooth connectivity','ti ti-bluetooth',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(14,'USB ports','ti ti-usb',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(15,'Navigation system','ti ti-map-pin',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(16,'Heads-up display','ti ti-device-desktop',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(17,'Digital instrument cluster','ti ti-dashboard',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(18,'Voice control','ti ti-microphone',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(19,'Sunroof/Moonroof','ti ti-sun',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(20,'Panoramic roof','ti ti-sun-high',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(21,'Power tailgate','ti ti-door',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(22,'Keyless entry','ti ti-key',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(23,'Push-button start','ti ti-power',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(24,'Remote start','ti ti-remote',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(25,'Heated mirrors','ti ti-flame',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(26,'Rain-sensing wipers','ti ti-droplet',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(27,'Auto-dimming mirrors','ti ti-brightness-down',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(28,'Adaptive cruise control','ti ti-steering-wheel',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(29,'Lane departure warning','ti ti-road-sign',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(30,'Blind spot monitoring','ti ti-eye',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(31,'Parking sensors','ti ti-radar',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(32,'Backup camera','ti ti-camera',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(33,'360-degree camera','ti ti-360-view',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(34,'Automatic emergency braking','ti ti-shield-check',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(35,'Cross-traffic alert','ti ti-alert-triangle',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(36,'Driver attention monitoring','ti ti-eye-check',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(37,'All-wheel drive','ti ti-car-4wd',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(38,'Sport mode','ti ti-flag',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(39,'Paddle shifters','ti ti-steering-wheel',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(40,'Adaptive suspension','ti ti-adjustments',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(41,'Electronic stability control','ti ti-shield',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(42,'Traction control','ti ti-wheel',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(43,'Hill start assist','ti ti-mountain',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(44,'Downhill assist control','ti ti-trending-down',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(45,'Air conditioning','ti ti-air-conditioning',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(46,'Power windows','ti ti-window',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(47,'Central locking','ti ti-lock',NULL,'published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_amenities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenities_translations`
--

DROP TABLE IF EXISTS `cr_car_amenities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenities_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_amenities_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_amenities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenities_translations`
--

LOCK TABLES `cr_car_amenities_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_amenities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_amenities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenity_categories`
--

DROP TABLE IF EXISTS `cr_car_amenity_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenity_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '0',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_amenity_categories_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenity_categories`
--

LOCK TABLES `cr_car_amenity_categories` WRITE;
/*!40000 ALTER TABLE `cr_car_amenity_categories` DISABLE KEYS */;
INSERT INTO `cr_car_amenity_categories` VALUES (1,'Comfort & Interior','ti ti-armchair',1,'published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Technology & Infotainment','ti ti-device-tablet',2,'published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Exterior & Convenience','ti ti-sun',3,'published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Safety & Driver Assistance','ti ti-shield-check',4,'published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Performance & Handling','ti ti-steering-wheel',5,'published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Basic Features','ti ti-car',6,'published','2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_amenity_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_amenity_categories_translations`
--

DROP TABLE IF EXISTS `cr_car_amenity_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_amenity_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_amenity_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_amenity_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_amenity_categories_translations`
--

LOCK TABLES `cr_car_amenity_categories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_amenity_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_amenity_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_categories`
--

DROP TABLE IF EXISTS `cr_car_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_categories`
--

LOCK TABLES `cr_car_categories` WRITE;
/*!40000 ALTER TABLE `cr_car_categories` DISABLE KEYS */;
INSERT INTO `cr_car_categories` VALUES (1,'Sport',0,'Sport cars model','published','ti ti-sport-billard',1,0,0,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(2,'Maserati',1,'','published','ti ti-activity',3,0,0,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(3,'Ferrari',1,'','published',NULL,3,0,0,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(4,'Classic',0,'Classic cars model','published','ti ti-alpha',2,0,0,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(5,'New',0,'New cars model','published','ti ti-new-section',4,0,1,'2025-11-17 21:11:20','2025-11-17 21:11:20');
/*!40000 ALTER TABLE `cr_car_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_categories_translations`
--

DROP TABLE IF EXISTS `cr_car_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_car_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_categories_translations`
--

LOCK TABLES `cr_car_categories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_colors`
--

DROP TABLE IF EXISTS `cr_car_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_colors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_colors_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_colors`
--

LOCK TABLES `cr_car_colors` WRITE;
/*!40000 ALTER TABLE `cr_car_colors` DISABLE KEYS */;
INSERT INTO `cr_car_colors` VALUES (1,'Red','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'White','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Black','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Blue','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Pink','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Brown','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_colors_translations`
--

DROP TABLE IF EXISTS `cr_car_colors_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_colors_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_colors_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_colors_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_colors_translations`
--

LOCK TABLES `cr_car_colors_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_colors_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_colors_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_fuels`
--

DROP TABLE IF EXISTS `cr_car_fuels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_fuels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_fuels_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_fuels`
--

LOCK TABLES `cr_car_fuels` WRITE;
/*!40000 ALTER TABLE `cr_car_fuels` DISABLE KEYS */;
INSERT INTO `cr_car_fuels` VALUES (1,'Gasoline','icons/car-diesel.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Diesel','icons/car-diesel.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Electric','icons/car-electricity.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_fuels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_fuels_translations`
--

DROP TABLE IF EXISTS `cr_car_fuels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_fuels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_fuels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_fuels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_fuels_translations`
--

LOCK TABLES `cr_car_fuels_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_fuels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_fuels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_maintenance_histories`
--

DROP TABLE IF EXISTS `cr_car_maintenance_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_maintenance_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `amount` double NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned NOT NULL,
  `date` datetime DEFAULT NULL,
  `car_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_maintenance_histories_car_id_index` (`car_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_maintenance_histories`
--

LOCK TABLES `cr_car_maintenance_histories` WRITE;
/*!40000 ALTER TABLE `cr_car_maintenance_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_maintenance_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_maintenance_histories_translations`
--

DROP TABLE IF EXISTS `cr_car_maintenance_histories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_maintenance_histories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_maintenance_histories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_maintenance_histories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_maintenance_histories_translations`
--

LOCK TABLES `cr_car_maintenance_histories_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_maintenance_histories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_maintenance_histories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_makes`
--

DROP TABLE IF EXISTS `cr_car_makes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_makes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_makes`
--

LOCK TABLES `cr_car_makes` WRITE;
/*!40000 ALTER TABLE `cr_car_makes` DISABLE KEYS */;
INSERT INTO `cr_car_makes` VALUES (1,'Lexus','icons/lexus.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Mercedes','icons/mer.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Bugatti','icons/bugatti.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Jaguar','icons/jaguar.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Honda','icons/honda.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Chevrolet','icons/chevrolet.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(7,'Acura','icons/acura.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(8,'BMW','icons/bmw.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(9,'Toyota','icons/toyota.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(10,'Ford','icons/ford-i.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(11,'Nissan','icons/nissan-i.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(12,'Opel','icons/opel-i.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(13,'BMW','icons/bmw.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(14,'Toyota','icons/toyota.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_makes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_makes_translations`
--

DROP TABLE IF EXISTS `cr_car_makes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_makes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_makes_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_makes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_makes_translations`
--

LOCK TABLES `cr_car_makes_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_makes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_makes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_reviews`
--

DROP TABLE IF EXISTS `cr_car_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `star` double NOT NULL DEFAULT '0',
  `customer_id` bigint unsigned NOT NULL,
  `car_id` bigint unsigned NOT NULL,
  `booking_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_reviews_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_reviews`
--

LOCK TABLES `cr_car_reviews` WRITE;
/*!40000 ALTER TABLE `cr_car_reviews` DISABLE KEYS */;
INSERT INTO `cr_car_reviews` VALUES (1,'Average rental experience. Nothing particularly stood out about this rental The GPS was a bit outdated but the fuel efficiency was decent. Nothing special but gets the job done.',3,1,52,NULL,'published','2024-04-30 01:05:08','2025-11-17 21:11:20'),(2,'Outstanding rental experience! Advanced safety features gave us confidence The car was like driving a brand new car and delivered outstanding fuel economy. Incredibly professional and courteous service Exceeded all expectations. Will definitely be back!',5,20,29,NULL,'published','2025-07-16 09:59:33','2025-11-17 21:11:20'),(3,'Outstanding rental experience! Premium sound system was amazing The car was mechanically perfect and provided effortless acceleration. Outstanding customer service from start to finish Exceeded all expectations. Will definitely be back!',5,25,59,NULL,'published','2025-10-30 03:32:13','2025-11-17 21:11:20'),(4,'Really enjoyed driving this car. Very quiet cabin for conversations Smooth acceleration and responsive braking Handled the mountain roads beautifully Only minor complaint is the cup holders were a bit small. Highly recommend!',4,7,28,NULL,'published','2024-11-27 04:26:53','2025-11-17 21:11:20'),(5,'Perfect car for our family road trip! Every passenger commented on the amazing comfort Performance that rivals much more expensive cars Exceptional attention to customer needs Cannot fault anything about this rental. 10/10 would recommend!',5,19,17,NULL,'published','2024-02-23 10:32:24','2025-11-17 21:11:20'),(6,'Excellent value for money. The automatic climate control worked perfectly Never had a single mechanical issue Reliable transportation for our family trip Will book with them again for sure.',4,25,70,NULL,'published','2024-06-22 10:25:12','2025-11-17 21:11:20'),(7,'Standard rental car. The car was clean and functional The GPS was a bit outdated Reasonable option for basic transportation Met basic expectations.',3,32,99,NULL,'published','2025-06-24 18:44:39','2025-11-17 21:11:20'),(8,'Great rental experience! Spacious interior The car was very reliable and was surprisingly quiet and smooth. The pickup process took a while but overall very satisfied. Would definitely rent again.',4,17,9,NULL,'published','2023-12-14 08:54:49','2025-11-17 21:11:20'),(9,'Very pleased with this rental. High-quality materials and finishes Quick and easy pickup process Will be my go-to rental company Just a small issue with the radio taking a moment to connect to Bluetooth but nothing major.',4,13,2,NULL,'published','2024-10-20 14:11:43','2025-11-17 21:11:20'),(10,'Below expectations. Could use a bit more trunk space The car was decent enough for basic needs but The pickup/return process. The price was competitive but overall not satisfied with the rental.',2,21,97,NULL,'published','2024-11-20 23:10:38','2025-11-17 21:11:20'),(11,'Really enjoyed driving this car. Incredibly comfortable for long drives The car felt stable and well-balanced Made our trip so much more enjoyable Only minor complaint is the car manual was missing. Highly recommend!',4,11,5,NULL,'published','2024-09-15 15:46:40','2025-11-17 21:11:20'),(12,'Had some issues with this rental. The car had a persistent rattling noise that was quite annoying during the drive The price was reasonable but the quality didn\'t match.',2,25,8,NULL,'published','2024-06-15 13:46:38','2025-11-17 21:11:20'),(13,'Best rental car I\'ve ever had! Quality that rivals the finest vehicles Service that sets the gold standard Premium experience at a fair price Everything was perfect from start to finish. Will definitely use again!',5,5,66,NULL,'published','2024-10-09 09:17:22','2025-11-17 21:11:20'),(14,'Very pleased with this rental. Attention to detail was evident throughout Excellent customer service Perfect for business or leisure travel Just a small issue with a small scuff on the rear bumper but nothing major.',4,19,89,NULL,'published','2024-05-29 04:10:26','2025-11-17 21:11:20'),(15,'Really enjoyed driving this car. Climate control worked perfectly The engine performed well on both city and highway Handled the mountain roads beautifully Only minor complaint is one of the USB ports wasn\'t working. Highly recommend!',4,13,20,NULL,'published','2025-04-27 14:28:16','2025-11-17 21:11:20'),(16,'Outstanding rental experience! Incredible fuel efficiency saved us money The car was showroom quality and exceeded all performance expectations. Incredibly professional and courteous service Exceeded all expectations. Will definitely be back!',5,30,54,NULL,'published','2025-01-25 07:08:52','2025-11-17 21:11:20'),(17,'Not great but manageable. The technology was quite outdated The basic features worked fine Would look for other options next time.',2,5,60,NULL,'published','2024-11-15 20:56:13','2025-11-17 21:11:20'),(18,'Absolutely fantastic! Advanced capabilities that impressed everyone Absolutely perfect reliability record Everything about this rental was perfect This is how car rentals should be done. Thank you for an amazing experience!',5,12,83,NULL,'published','2025-01-11 00:00:08','2025-11-17 21:11:20'),(19,'Not great but manageable. The car felt underpowered on highways The trunk space was adequate Would look for other options next time.',2,8,23,NULL,'published','2024-04-17 09:25:53','2025-11-17 21:11:20'),(20,'Mixed feelings about this rental. the overall condition was satisfactory but the customer service could be improved. Standard rental experience Fair value for money.',3,6,61,NULL,'published','2025-05-30 21:30:25','2025-11-17 21:11:20'),(21,'Really enjoyed driving this car. Very quiet cabin for conversations The engine performed well on both city and highway Great for city driving and parking Only minor complaint is the return process was slightly confusing. Highly recommend!',4,10,1,NULL,'published','2024-11-23 22:34:34','2025-11-17 21:11:20'),(22,'Really enjoyed driving this car. Plenty of legroom for everyone The engine performed well on both city and highway Great for city driving and parking Only minor complaint is the return process was slightly confusing. Highly recommend!',4,25,11,NULL,'published','2025-07-23 23:46:55','2025-11-17 21:11:20'),(23,'Standard rental car. Adequate for the rental period The pickup process took a while Nothing exceptional but nothing terrible Met basic expectations.',3,22,55,NULL,'published','2024-06-27 10:47:40','2025-11-17 21:11:20'),(24,'Excellent value for money. The automatic climate control worked perfectly No unexpected problems or breakdowns Made our vacation stress-free and enjoyable Will book with them again for sure.',4,8,5,NULL,'published','2024-11-28 23:11:45','2025-11-17 21:11:20'),(25,'Really enjoyed driving this car. Incredibly comfortable for long drives Good handling in various driving conditions Perfect for our family vacation Only minor complaint is the cup holders were a bit small. Highly recommend!',4,24,21,NULL,'published','2023-12-26 23:52:28','2025-11-17 21:11:20'),(26,'Decent car for the price. The sound system worked fine the owner\'s manual being missing but overall acceptable for conference. Would consider again if needed.',3,19,48,NULL,'published','2025-08-01 00:41:49','2025-11-17 21:11:20'),(27,'Decent car for the price. The visibility was good the radio taking a moment to connect to Bluetooth but overall acceptable for business trip. Would consider again if needed.',3,17,41,NULL,'published','2024-01-09 23:44:24','2025-11-17 21:11:20'),(28,'Excellent value for money. Excellent safety features gave us confidence Started every time without hesitation Contributed to a memorable road trip Will book with them again for sure.',4,32,89,NULL,'published','2023-11-23 02:46:29','2025-11-17 21:11:20'),(29,'Best rental car I\'ve ever had! Impeccable attention to every detail Service that sets the gold standard Premium experience at a fair price Everything was perfect from start to finish. Will definitely use again!',5,21,43,NULL,'published','2024-06-22 16:00:48','2025-11-17 21:11:20'),(30,'Perfect car for our business trip! The seats were like luxury recliners Incredible power delivery and smooth operation Staff went above and beyond at every step Cannot fault anything about this rental. 10/10 would recommend!',5,32,35,NULL,'published','2024-04-09 18:29:41','2025-11-17 21:11:20'),(31,'Mixed feelings about this rental. the car was reliable throughout our trip but the pickup process was slower than expected. Gets you from point A to point B Fair value for money.',3,11,29,NULL,'published','2025-09-09 10:23:46','2025-11-17 21:11:20'),(32,'Very disappointed. Several features weren\'t working properly The interior was completely worn out and I didn\'t feel safe driving it. Not worth the money at all.',1,7,2,NULL,'published','2025-10-22 22:26:25','2025-11-17 21:11:20'),(33,'Really enjoyed driving this car. Incredibly comfortable for long drives Smooth acceleration and responsive braking Handled the mountain roads beautifully Only minor complaint is the return process was slightly confusing. Highly recommend!',4,18,2,NULL,'published','2025-10-22 19:28:55','2025-11-17 21:11:20'),(34,'Perfect car for our wedding! The seats were like luxury recliners The performance was absolutely flawless Exceptional attention to customer needs Cannot fault anything about this rental. 10/10 would recommend!',5,21,43,NULL,'published','2023-11-26 00:58:33','2025-11-17 21:11:20'),(35,'Absolutely fantastic! Every feature worked flawlessly Absolutely perfect reliability record Everything about this rental was perfect This is how car rentals should be done. Thank you for an amazing experience!',5,13,18,NULL,'published','2025-10-13 09:12:24','2025-11-17 21:11:20'),(36,'Perfect car for our vacation! Every passenger commented on the amazing comfort Incredible power delivery and smooth operation Exceptional attention to customer needs Cannot fault anything about this rental. 10/10 would recommend!',5,4,43,NULL,'published','2025-01-31 16:24:25','2025-11-17 21:11:20'),(37,'Very pleased with this rental. High-quality materials and finishes Very helpful with directions Excellent option for families Just a small issue with one cup holder being a bit loose but nothing major.',4,9,42,NULL,'published','2024-09-10 06:57:51','2025-11-17 21:11:20'),(38,'Best rental car I\'ve ever had! Impeccable attention to every detail Exceptional attention to customer needs Worth every penny and more Everything was perfect from start to finish. Will definitely use again!',5,11,5,NULL,'published','2025-01-03 20:55:40','2025-11-17 21:11:20'),(39,'Outstanding rental experience! Surprisingly spacious for our family The car was mechanically perfect and delivered outstanding fuel economy. Outstanding customer service from start to finish Exceeded all expectations. Will definitely be back!',5,1,84,NULL,'published','2025-08-22 09:43:21','2025-11-17 21:11:20'),(40,'Decent car for the price. The sound system worked fine the pickup location being slightly hard to find but overall acceptable for weekend getaway. Would consider again if needed.',3,17,83,NULL,'published','2024-08-08 23:32:04','2025-11-17 21:11:20'),(41,'Outstanding rental experience! The car was immaculate inside and out The car was showroom quality and provided effortless acceleration. The team was absolutely wonderful to work with Exceeded all expectations. Will definitely be back!',5,20,98,NULL,'published','2024-11-03 03:43:49','2025-11-17 21:11:20'),(42,'Very pleased with this rental. Premium feel despite being a rental Very helpful with directions Will be my go-to rental company Just a small issue with the owner\'s manual being missing but nothing major.',4,6,98,NULL,'published','2025-11-02 10:20:16','2025-11-17 21:11:20'),(43,'Standard rental car. Adequate for the rental period Minor scuff on the bumper Standard service and vehicle quality Met basic expectations.',3,6,10,NULL,'published','2024-04-27 20:42:21','2025-11-17 21:11:20'),(44,'Very pleased with this rental. High-quality materials and finishes Quick and easy pickup process Perfect for business or leisure travel Just a small issue with the pickup location being slightly hard to find but nothing major.',4,2,53,NULL,'published','2024-07-22 03:10:27','2025-11-17 21:11:20'),(45,'Standard rental car. Reliable for basic driving Minor scuff on the bumper Meets expectations without exceeding them Met basic expectations.',3,23,11,NULL,'published','2024-01-11 15:04:47','2025-11-17 21:11:20'),(46,'Very pleased with this rental. Attention to detail was evident throughout Staff was friendly and professional Would definitely recommend to others Just a small issue with a small scuff on the rear bumper but nothing major.',4,12,19,NULL,'published','2023-12-27 12:09:17','2025-11-17 21:11:20'),(47,'Really enjoyed driving this car. Incredibly comfortable for long drives Good handling in various driving conditions Handled the mountain roads beautifully Only minor complaint is the return process was slightly confusing. Highly recommend!',4,15,34,NULL,'published','2024-11-22 05:59:24','2025-11-17 21:11:20'),(48,'Standard rental car. No major issues during our rental Minor scuff on the bumper Reasonable option for basic transportation Met basic expectations.',3,14,25,NULL,'published','2024-12-03 11:27:41','2025-11-17 21:11:20'),(49,'Perfect car for our family road trip! Premium seating that rivals luxury vehicles The performance was absolutely flawless Service that sets the gold standard Cannot fault anything about this rental. 10/10 would recommend!',5,24,2,NULL,'published','2024-09-28 04:24:09','2025-11-17 21:11:20'),(50,'Mixed feelings about this rental. the comfort level was quite good but the pickup process was slower than expected. Reasonable option if you\'re not picky Fair value for money.',3,21,3,NULL,'published','2025-08-18 23:20:45','2025-11-17 21:11:20'),(51,'Very pleased with this rental. Attention to detail was evident throughout Very helpful with directions Excellent option for families Just a small issue with the pickup location being slightly hard to find but nothing major.',4,24,90,NULL,'published','2025-07-03 20:32:19','2025-11-17 21:11:20'),(52,'Outstanding rental experience! Surprisingly spacious for our family The car was immaculate in every detail and was remarkably quiet and refined. The staff went above and beyond to help us Exceeded all expectations. Will definitely be back!',5,18,67,NULL,'published','2024-02-13 08:25:48','2025-11-17 21:11:20'),(53,'Perfect car for our business trip! Unparalleled comfort for long-distance driving Performance that rivals much more expensive cars Service that sets the gold standard Cannot fault anything about this rental. 10/10 would recommend!',5,12,51,NULL,'published','2024-12-20 14:20:03','2025-11-17 21:11:20'),(54,'Not great but manageable. The interior was showing its age The trunk space was adequate Would look for other options next time.',2,27,43,NULL,'published','2025-01-16 07:20:11','2025-11-17 21:11:20'),(55,'Really enjoyed driving this car. Seats were supportive and adjustable The car felt stable and well-balanced Great for city driving and parking Only minor complaint is the cup holders were a bit small. Highly recommend!',4,21,53,NULL,'published','2025-05-22 03:54:19','2025-11-17 21:11:20'),(56,'Average rental experience. Nothing particularly stood out about this rental The pickup process took a while but the fuel efficiency was decent. Nothing special but gets the job done.',3,19,19,NULL,'published','2025-10-02 23:50:09','2025-11-17 21:11:20'),(57,'Standard rental car. Reliable for basic driving Could use a bit more trunk space Standard service and vehicle quality Met basic expectations.',3,16,99,NULL,'published','2025-08-05 21:59:25','2025-11-17 21:11:20'),(58,'Great rental experience! Great sound system The car was running smoothly and handled beautifully on both city and highway. The GPS was a bit outdated but overall very satisfied. Would definitely rent again.',4,7,99,NULL,'published','2024-11-18 06:35:39','2025-11-17 21:11:20'),(59,'Best rental car I\'ve ever had! Luxury-level quality throughout Exceptional attention to customer needs Incredible bang for your buck Everything was perfect from start to finish. Will definitely use again!',5,10,21,NULL,'published','2025-02-21 12:21:41','2025-11-17 21:11:20'),(60,'Had some issues with this rental. The car had a persistent rattling noise that was quite annoying during the drive The price was reasonable but the quality didn\'t match.',2,17,9,NULL,'published','2024-11-21 23:32:34','2025-11-17 21:11:20'),(61,'Great rental experience! Very comfortable seats The car was in excellent mechanical condition and performed flawlessly throughout our trip. The radio presets weren\'t cleared but overall very satisfied. Would definitely rent again.',4,13,71,NULL,'published','2025-10-20 22:47:25','2025-11-17 21:11:20'),(62,'Very pleased with this rental. Well-maintained and cared for vehicle Very helpful with directions Will be my go-to rental company Just a small issue with the owner\'s manual being missing but nothing major.',4,21,91,NULL,'published','2024-12-05 03:02:45','2025-11-17 21:11:20'),(63,'Decent car for the price. The interior space was adequate the pickup location being slightly hard to find but overall acceptable for conference. Would consider again if needed.',3,7,83,NULL,'published','2025-01-19 17:53:48','2025-11-17 21:11:20'),(64,'Standard rental car. Adequate for the rental period The pickup process took a while A typical rental car experience Met basic expectations.',3,18,21,NULL,'published','2025-07-20 22:14:46','2025-11-17 21:11:20'),(65,'Below expectations. The GPS was a bit outdated The car was decent enough for basic needs but The pickup/return process. The price was competitive but overall not satisfied with the rental.',2,5,34,NULL,'published','2025-01-20 16:12:27','2025-11-17 21:11:20'),(66,'Outstanding rental experience! Advanced safety features gave us confidence The car was immaculate in every detail and was remarkably quiet and refined. They made everything so easy and stress-free Exceeded all expectations. Will definitely be back!',5,24,81,NULL,'published','2024-02-21 05:04:53','2025-11-17 21:11:20'),(67,'Very disappointed. The car showed signs of heavy use The air conditioning was not functioning properly and it felt unstable at highway speeds. Not worth the money at all.',1,7,23,NULL,'published','2025-08-20 08:33:45','2025-11-17 21:11:20'),(68,'Absolutely fantastic! Every feature worked flawlessly Reliability that exceeded all expectations Everything about this rental was perfect This is how car rentals should be done. Thank you for an amazing experience!',5,3,77,NULL,'published','2024-01-26 22:21:56','2025-11-17 21:11:20'),(69,'Really enjoyed driving this car. Plenty of legroom for everyone Smooth acceleration and responsive braking Handled the mountain roads beautifully Only minor complaint is the return process was slightly confusing. Highly recommend!',4,18,76,NULL,'published','2024-04-24 15:34:48','2025-11-17 21:11:20'),(70,'Absolutely fantastic! Advanced capabilities that impressed everyone Not a single issue throughout our entire rental The best rental car experience we\'ve ever had This is how car rentals should be done. Thank you for an amazing experience!',5,5,81,NULL,'published','2024-12-27 22:18:09','2025-11-17 21:11:20'),(71,'Absolutely fantastic! Premium features that enhanced every moment Reliability that exceeded all expectations This rental exceeded every expectation This is how car rentals should be done. Thank you for an amazing experience!',5,5,52,NULL,'published','2025-11-13 05:40:12','2025-11-17 21:11:20'),(72,'Very pleased with this rental. Well-maintained and cared for vehicle Very helpful with directions Will be my go-to rental company Just a small issue with the owner\'s manual being missing but nothing major.',4,14,75,NULL,'published','2025-08-20 00:46:28','2025-11-17 21:11:20');
/*!40000 ALTER TABLE `cr_car_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_tag`
--

DROP TABLE IF EXISTS `cr_car_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_tag` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_tag`
--

LOCK TABLES `cr_car_tag` WRITE;
/*!40000 ALTER TABLE `cr_car_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_transmissions`
--

DROP TABLE IF EXISTS `cr_car_transmissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_transmissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_transmissions_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_transmissions`
--

LOCK TABLES `cr_car_transmissions` WRITE;
/*!40000 ALTER TABLE `cr_car_transmissions` DISABLE KEYS */;
INSERT INTO `cr_car_transmissions` VALUES (1,'Automatic','icons/car-transmission-auto.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Manual','icons/car-transmission-manual.png','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_transmissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_transmissions_translations`
--

DROP TABLE IF EXISTS `cr_car_transmissions_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_transmissions_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_transmissions_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_transmissions_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_transmissions_translations`
--

LOCK TABLES `cr_car_transmissions_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_transmissions_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_transmissions_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_types`
--

DROP TABLE IF EXISTS `cr_car_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `order` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_car_types_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_types`
--

LOCK TABLES `cr_car_types` WRITE;
/*!40000 ALTER TABLE `cr_car_types` DISABLE KEYS */;
INSERT INTO `cr_car_types` VALUES (1,'SUV','cars/car-1.jpg','ti ti-car-suv','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Hatchback','cars/car-2.jpg','ti ti-car','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Sedan','cars/car-3.jpg','ti ti-car','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Crossover','cars/car-4.jpg','ti ti-car-4wd','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Minivan','cars/car-5.jpg','ti ti-caravan','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Coupe','cars/car-6.jpg','ti ti-car','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(7,'Sport Cars','cars/car-7.jpg','ti ti-car-turbine','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(8,'Pickup Truck','cars/car-8.jpg','ti ti-truck','published',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_car_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_types_translations`
--

DROP TABLE IF EXISTS `cr_car_types_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_types_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_car_types_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_car_types_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_types_translations`
--

LOCK TABLES `cr_car_types_translations` WRITE;
/*!40000 ALTER TABLE `cr_car_types_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_types_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_car_views`
--

DROP TABLE IF EXISTS `cr_car_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_car_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2025-11-18',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_car_views_car_id_date_unique` (`car_id`,`date`),
  KEY `cr_car_views_car_id_index` (`car_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_car_views`
--

LOCK TABLES `cr_car_views` WRITE;
/*!40000 ALTER TABLE `cr_car_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_car_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars`
--

DROP TABLE IF EXISTS `cr_cars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `images` text COLLATE utf8mb4_unicode_ci,
  `license_plate` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `make_id` bigint unsigned DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `year` int unsigned DEFAULT NULL,
  `mileage` int unsigned DEFAULT NULL,
  `horsepower` decimal(8,2) DEFAULT NULL,
  `vehicle_type_id` bigint unsigned DEFAULT NULL,
  `transmission_id` bigint unsigned DEFAULT NULL,
  `fuel_type_id` bigint unsigned DEFAULT NULL,
  `number_of_seats` int unsigned DEFAULT NULL,
  `number_of_doors` int unsigned DEFAULT NULL,
  `rental_rate` double unsigned NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rental_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'per_day',
  `rental_available_types` text COLLATE utf8mb4_unicode_ci,
  `insurance_info` text COLLATE utf8mb4_unicode_ci,
  `vin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_used` tinyint(1) NOT NULL DEFAULT '0',
  `is_for_sale` tinyint(1) NOT NULL DEFAULT '0',
  `sale_price` decimal(15,2) DEFAULT NULL,
  `condition` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ownership_history` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `warranty_information` text COLLATE utf8mb4_unicode_ci,
  `sale_status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `external_booking_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `vendor_id` bigint unsigned DEFAULT NULL,
  `moderation_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `reject_reason` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_cars_make_id_index` (`make_id`),
  KEY `cr_cars_status_index` (`status`),
  KEY `cr_cars_vehicle_type_id_index` (`vehicle_type_id`),
  KEY `cr_cars_vin_index` (`vin`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars`
--

LOCK TABLES `cr_cars` WRITE;
/*!40000 ALTER TABLE `cr_cars` DISABLE KEYS */;
INSERT INTO `cr_cars` VALUES (1,'Toyota Camry XLE Hybrid 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/14.jpg\",\"cars\\/1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\"]','30A-123.00',6,'available',2016,18114,NULL,1,1,2,4,5,57,NULL,NULL,'per_day',NULL,'','NSCTDBU9640YLN761','',1,3,6,'60094 Ortiz Lane',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=toyota-camry-xle-hybrid-2024','2025-11-17 21:11:17','2025-11-17 21:11:17',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(2,'Honda Accord Sport 2.0T 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/95.jpg\",\"cars\\/6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-123.11',6,'available',2016,8066,NULL,4,2,1,8,4,87,NULL,NULL,'per_day',NULL,'','YJEDAUST9DBF9VABJ','',1,5,10,'53770 Long Drive',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:17','2025-11-17 21:11:17',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(3,'Mercedes-Benz C300 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/70.jpg\",\"cars\\/12.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-123.22',10,'available',2016,1703,NULL,8,1,1,7,2,95,NULL,NULL,'per_day',NULL,'','31BWCV5K73G7M8XW0','',1,2,5,'95135 Grant Circle Floor 779',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(4,'BMW 330i xDrive M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/9.jpg\",\"cars\\/14.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-123.33',9,'available',2019,15005,NULL,8,3,2,5,5,36,NULL,NULL,'per_day',NULL,'','AEZNPLAA23Z8N9AVC','',1,3,7,'40893 King Way',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(5,'Lexus ES 350 F Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/38.jpg\",\"cars\\/64.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-123.44',7,'available',2016,16053,NULL,1,3,1,8,2,49,NULL,NULL,'per_day',NULL,'','K3HEH0JP9E4XZPL9Z','',2,6,12,'47614 Davis Place Apt 977',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(6,'Toyota RAV4 Prime XSE AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/59.jpg\",\"cars\\/19.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\"]','30A-123.55',2,'available',2010,8214,NULL,2,2,2,4,4,74,NULL,NULL,'per_day',NULL,'','T4RT6K1P7G490FTGZ','',8,18,25,'70178 Foster Park # 466',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(7,'Honda CR-V Touring Hybrid AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/14.jpg\",\"cars\\/32.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-123.66',2,'available',2018,5630,NULL,2,3,3,7,4,32,NULL,NULL,'per_day',NULL,'','KPBNW3YC2VY7U56UK','',1,1,3,'89126 Cook Gardens',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(8,'BMW X5 xDrive40i M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/19.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\"]','30A-123.77',9,'available',2020,13632,NULL,4,3,1,8,2,90,NULL,NULL,'per_day',NULL,'','TM0213JV6X58MW9RA','',4,10,17,'82873 Nelson Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(9,'Mercedes-Benz GLC 300 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/55.jpg\",\"cars\\/69.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-123.88',10,'available',2013,9006,NULL,8,2,3,7,4,80,NULL,NULL,'per_day',NULL,'','4R4UBJ7W7KYKWZ7SE','',7,16,23,'69365 Nelson Place',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(10,'Lexus RX 350 F Sport Handling AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/18.jpg\",\"cars\\/9.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-123.99',6,'available',2011,16720,NULL,4,1,3,4,4,93,NULL,NULL,'per_day',NULL,'','GJP9T59W1KPXHC94R','',1,3,6,'87022 Thompson Highway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=lexus-rx-350-f-sport-handling-awd-2024','2025-11-17 21:11:18','2025-11-17 21:11:18',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(11,'Audi A4 Premium Plus quattro 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/93.jpg\",\"cars\\/52.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','30A-456.00',8,'available',2010,8571,NULL,7,2,1,8,2,30,NULL,NULL,'per_day',NULL,'','APXJMC076V25E007F','',1,2,4,'55882 Campbell Creek',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(12,'Mazda CX-5 2.5 Turbo Signature AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/90.jpg\",\"cars\\/12.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\"]','30A-456.11',10,'available',2016,10590,NULL,7,3,1,5,4,61,NULL,NULL,'per_day',NULL,'','7W3VB43076BV21TUZ','',1,1,3,'90991 Pine Circle Suite 937',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(13,'Tesla Model 3 Long Range AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/104.jpg\",\"cars\\/33.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','30A-456.22',10,'available',2015,8867,NULL,2,1,1,5,4,49,NULL,NULL,'per_day',NULL,'','MHH1CSSV5RFW77CDT','',1,1,3,'49793 Phillips Heights Floor 969',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(14,'Porsche Macan S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/78.jpg\",\"cars\\/72.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\"]','30A-456.33',6,'available',2023,4331,NULL,8,3,2,8,4,30,NULL,NULL,'per_day',NULL,'','DW144UC621AMEJW26','',1,4,8,'64565 First Park',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(15,'Volvo XC60 B6 Ultimate AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/75.jpg\",\"cars\\/53.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-456.44',9,'available',2022,11054,NULL,1,1,3,7,5,63,NULL,NULL,'per_day',NULL,'','0PDK2STH848TP4T1V','',3,8,15,'59584 Green Park # 792',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(16,'Genesis G70 3.3T Sport Prestige AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/23.jpg\",\"cars\\/84.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-456.55',3,'available',2015,2449,NULL,8,2,2,7,2,31,NULL,NULL,'per_day',NULL,'','8LR4PJ5B8SBGCJSC0','',1,1,3,'95278 Baker Trail',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(17,'Subaru Outback Limited XT 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/67.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\"]','30A-456.66',13,'available',2017,7050,NULL,1,1,2,8,4,72,NULL,NULL,'per_day',NULL,'','XYSVXC5X8GBHPURDK','',1,3,6,'1622 Edwards Lane Suite 467',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=subaru-outback-limited-xt-2024','2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(18,'Acura MDX Type S Advance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/18.jpg\",\"cars\\/18.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\"]','30A-456.77',11,'available',2021,18624,NULL,1,2,1,4,4,78,NULL,NULL,'per_day',NULL,'','THVGXLNJ4RUF5ZN7A','',2,7,13,'70349 Barnes Meadows Unit 920',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.kayak.com/cars/acura-mdx-type-s-advance-2024','2025-11-17 21:11:18','2025-11-17 21:11:18',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(19,'Range Rover Evoque P250 S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/17.jpg\",\"cars\\/81.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\"]','30A-456.88',9,'available',2012,5544,NULL,2,1,3,7,2,68,NULL,NULL,'per_day',NULL,'','1XNM83AD6BTANYZHW','',5,13,20,'49681 Washington Park Floor 165',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(20,'Infiniti QX60 Autograph AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/77.jpg\",\"cars\\/74.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30A-456.99',13,'available',2016,4858,NULL,1,1,3,5,5,71,NULL,NULL,'per_day',NULL,'','N1R63TRM4SWG387YV','',8,18,25,'60536 Fisher Ridge',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',8,'Botble\\CarRentals\\Models\\Customer',8,'approved',NULL),(21,'Nissan Altima SR VC-Turbo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/20.jpg\",\"cars\\/63.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-789.00',1,'available',2016,8564,NULL,1,3,3,5,4,65,NULL,NULL,'per_day',NULL,'','HFC6HWVB7V3CKSKF8','',1,1,1,'51919 Gutierrez Parkway Suite 194',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(22,'Hyundai Sonata N Line 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/14.jpg\",\"cars\\/44.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\"]','29A-789.11',13,'available',2013,18434,NULL,6,3,3,8,5,40,NULL,NULL,'per_day',NULL,'','3EEVY81E5WEEA8ZA0','',4,11,18,'71345 Smith Street',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(23,'Kia Stinger GT2 AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/86.jpg\",\"cars\\/87.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-789.22',6,'available',2014,15752,NULL,8,2,3,4,2,30,NULL,NULL,'per_day',NULL,'','5EZTYCJ01S7H98HFA','',2,7,13,'49788 James Landing',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(24,'Volkswagen Atlas Cross Sport SEL Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/93.jpg\",\"cars\\/58.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','29A-789.33',9,'available',2013,8929,NULL,7,2,1,7,2,72,NULL,NULL,'per_day',NULL,'','JY6DAE5Z1HHSBVD52','',3,8,14,'64072 Cherry Lane',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(25,'Chevrolet Blazer RS AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/48.jpg\",\"cars\\/41.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','29A-789.44',8,'available',2011,11335,NULL,1,3,2,7,4,97,NULL,NULL,'per_day',NULL,'','3G8JX3Z71N98C203U','',1,3,6,'22447 Sullivan Court',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(26,'Ford Explorer ST 4WD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/75.jpg\",\"cars\\/82.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\"]','29A-789.55',7,'available',2024,11288,NULL,2,1,2,4,2,87,NULL,NULL,'per_day',NULL,'','4FXLGWFH0681BBX6C','',3,8,15,'18576 Grant Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=ford-explorer-st-4wd-2024','2025-11-17 21:11:18','2025-11-17 21:11:18',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(27,'Jeep Grand Cherokee Summit Reserve 4xe 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/82.jpg\",\"cars\\/89.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\"]','29A-789.66',1,'available',2020,6948,NULL,2,2,3,5,4,36,NULL,NULL,'per_day',NULL,'','RZSST9926XTJMR8F4','',3,8,15,'63878 Bennett Walk',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(28,'Cadillac XT5 Premium Luxury AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/28.jpg\",\"cars\\/24.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\"]','29A-789.77',6,'available',2013,19333,NULL,7,3,1,7,4,67,NULL,NULL,'per_day',NULL,'','4KYBA9LK00GF4BFS7','',1,1,1,'1623 Morgan Terrace',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(29,'Lincoln Aviator Reserve AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/101.jpg\",\"cars\\/46.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\"]','29A-789.88',12,'available',2023,5258,NULL,5,1,2,5,4,33,NULL,NULL,'per_day',NULL,'','SG3XU0EN5YYMX035E','',1,3,7,'41312 Gomez Valley Suite 687',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(30,'Alfa Romeo Stelvio Veloce AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/57.jpg\",\"cars\\/98.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\"]','29A-789.99',1,'available',2014,5925,NULL,5,1,1,5,4,91,NULL,NULL,'per_day',NULL,'','X8FNCDW457Y9MCP98','',8,19,26,'99120 Roberts Parkway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(31,'McLaren 720S Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/18.jpg\",\"cars\\/59.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\"]','30B-100.00',8,'available',2018,1438,NULL,2,3,3,5,2,48,NULL,NULL,'per_day',NULL,'','BYXJJWYV09WLENSFF','',6,14,21,'2488 River Landing # 256',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(32,'Mercedes-Benz G550 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/63.jpg\",\"cars\\/71.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\"]','30B-100.11',8,'available',2018,16779,NULL,8,3,3,8,4,55,NULL,NULL,'per_day',NULL,'','Y9L6H4LV6A6BVY4VC','',1,1,3,'45206 Turner Creek',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.sixt.com/rental-car/usa/vehicle/mercedes-benz-g550-4matic-2024','2025-11-17 21:11:18','2025-11-17 21:11:18',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(33,'Ford Mustang GT Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/49.jpg\",\"cars\\/12.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\"]','30B-100.22',11,'available',2019,16477,NULL,5,2,3,8,4,40,NULL,NULL,'per_day',NULL,'','SVS2LMJ26GJS8UPVT','',1,1,1,'17601 Pine Circle',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.enterprise.com/en/reserve.html?vehicleType=ford-mustang-gt-premium-2024','2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(34,'Porsche 911 Carrera S 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/25.jpg\",\"cars\\/50.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','30B-100.33',13,'available',2017,9034,NULL,4,2,3,5,2,78,NULL,NULL,'per_day',NULL,'','MTFWJ69V2PLECEZWW','',5,12,19,'1730 Lake Court',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(35,'Audi R8 V10 Performance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/19.jpg\",\"cars\\/57.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\"]','30B-100.44',13,'available',2016,5793,NULL,5,1,3,5,2,98,NULL,NULL,'per_day',NULL,'','1SU8T5YX41P8A7ZCG','',1,2,5,'10024 Morgan Hills Floor 639',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(36,'Lamborghini Huracán EVO 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/84.jpg\",\"cars\\/44.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\"]','30B-100.55',6,'available',2016,16243,NULL,2,2,2,7,5,98,NULL,NULL,'per_day',NULL,'','UWLN1B5U7SFAEUPSF','',1,2,4,'99017 Spruce Ridge',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:18','2025-11-17 21:11:18',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(37,'BMW M4 Competition xDrive 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/2.jpg\",\"cars\\/25.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\"]','30B-100.66',11,'available',2011,4239,NULL,6,2,2,5,5,95,NULL,NULL,'per_day',NULL,'','0HCMT9UY76KNSJF07','',2,6,11,'11026 Johnson Gardens',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(38,'Maserati Ghibli Modena 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/103.jpg\",\"cars\\/104.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-2.jpg\"]','30B-100.77',8,'available',2024,4068,NULL,2,1,2,4,4,97,NULL,NULL,'per_day',NULL,'','64S74T7939CT2KSHA','',4,11,18,'73927 Fisher Point # 126',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(39,'Bentley Continental GT V8 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/99.jpg\",\"cars\\/97.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\"]','30B-100.88',2,'available',2016,10629,NULL,8,1,2,7,2,42,NULL,NULL,'per_day',NULL,'','MUHAFRY409W9NBW6L','',4,11,18,'81561 Johnson Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(40,'Rolls-Royce Ghost Black Badge 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/47.jpg\",\"cars\\/80.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\"]','30B-100.99',2,'available',2015,11175,NULL,5,3,3,5,2,87,NULL,NULL,'per_day',NULL,'','08J7VJRL7S39JWMAB','',2,6,11,'71991 White Circle',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=rolls-royce-ghost-black-badge-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(41,'Hyundai Tucson Limited AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/8.jpg\",\"cars\\/98.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\"]','29B-200.00',8,'available',2014,4520,NULL,6,2,2,4,2,45,NULL,NULL,'per_day',NULL,'','NZT36XB12JZ6R439H','',4,10,17,'62822 Morgan Valley',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=hyundai-tucson-limited-awd-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(42,'Kia Sportage SX-Turbo AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/26.jpg\",\"cars\\/85.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\"]','29B-200.11',14,'available',2023,19841,NULL,2,2,1,5,5,54,NULL,NULL,'per_day',NULL,'','338B4NTK8V8F1AWG9','',1,4,9,'14302 Lake Road',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(43,'Volkswagen Tiguan SEL R-Line 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/102.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\"]','29B-200.22',13,'available',2012,10383,NULL,3,1,1,8,5,95,NULL,NULL,'per_day',NULL,'','L3Z9B7M65T28BTFM6','',5,13,20,'4648 Murphy Drive',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(44,'Toyota Highlander Platinum AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/66.jpg\",\"cars\\/40.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','29B-200.33',6,'available',2022,9559,NULL,2,3,2,7,4,95,NULL,NULL,'per_day',NULL,'','R36ADZL41P6WWDEJP','',1,1,1,'47699 Johnson Parkway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.sixt.com/rental-car/usa/vehicle/toyota-highlander-platinum-awd-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL),(45,'Honda Pilot TrailSport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/73.jpg\",\"cars\\/104.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\"]','29B-200.44',14,'available',2021,19242,NULL,6,2,1,4,2,64,NULL,NULL,'per_day',NULL,'','FF9A33YT9X4R7RR98','',7,17,24,'74773 Harris Avenue Floor 991',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(46,'Mazda MX-5 Miata Grand Touring 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/105.jpg\",\"cars\\/69.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','29B-200.55',12,'available',2017,17476,NULL,2,3,2,4,5,45,NULL,NULL,'per_day',NULL,'','1PMTS2RK10AD7X9NR','',2,7,13,'50624 Ortiz Landing',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/mazda-mx-5-miata-grand-touring-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(47,'Nissan Rogue Platinum AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/73.jpg\",\"cars\\/2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\"]','29B-200.66',8,'available',2016,18356,NULL,4,1,1,7,2,48,NULL,NULL,'per_day',NULL,'','US44W6MX89C612HUC','',1,4,8,'5622 Jenkins Heights',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(48,'Mini Cooper S Hardtop 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/72.jpg\",\"cars\\/8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\"]','29B-200.77',10,'available',2017,3229,NULL,7,2,3,4,5,96,NULL,NULL,'per_day',NULL,'','S75R70V46UBV524H1','',4,10,17,'92303 Cooper Street Suite 15',NULL,0,1,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=mini-cooper-s-hardtop-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(49,'Dodge Challenger R/T Scat Pack 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/102.jpg\",\"cars\\/86.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\"]','29B-200.88',3,'available',2016,2506,NULL,6,1,2,8,5,81,NULL,NULL,'per_day',NULL,'','A8U40KL03FPCEYSYL','',1,3,6,'22464 Phillips Highway # 781',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.expedia.com/carsearch?vehicle=dodge-challenger-r/t-scat-pack-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(50,'Chevrolet Camaro SS 1LE 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/94.jpg\",\"cars\\/27.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\"]','29B-200.99',7,'available',2013,12248,NULL,2,1,2,4,2,70,NULL,NULL,'per_day',NULL,'','U59YUL9U9NUVV1EH8','',8,19,26,'63288 Campbell Meadows # 619',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',3,'Botble\\CarRentals\\Models\\Customer',3,'approved',NULL),(51,'Ferrari F8 Tributo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/82.jpg\",\"cars\\/15.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','30C-300.00',12,'available',2022,5420,NULL,8,2,3,4,4,74,NULL,NULL,'per_day',NULL,'','BJPSARZB3XXSYFEZ2','',6,14,21,'9270 Ash Parkway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(52,'Jaguar F-PACE SVR 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/15.jpg\",\"cars\\/70.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-6.jpg\"]','30C-300.11',4,'available',2010,2092,NULL,1,1,3,4,4,42,NULL,NULL,'per_day',NULL,'','WBWVFVZE2UWKTBHK2','',1,1,3,'65692 Kelly Place',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(53,'Land Rover Defender 110 X 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/78.jpg\",\"cars\\/10.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','30C-300.22',3,'available',2020,13261,NULL,5,1,1,8,2,61,NULL,NULL,'per_day',NULL,'','JVBE0A4L8H8KAFRG4','',3,8,15,'28679 Baker Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(54,'Chrysler Pacifica Pinnacle AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/99.jpg\",\"cars\\/91.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-1.jpg\"]','30C-300.33',11,'available',2024,18783,NULL,4,1,3,4,2,64,NULL,NULL,'per_day',NULL,'','8MKVVWM29RV9R3KP2','',1,4,8,'69094 Nelson Way',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',20,'Botble\\CarRentals\\Models\\Customer',20,'approved',NULL),(55,'GMC Sierra 1500 Denali 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/103.jpg\",\"cars\\/99.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\"]','30C-300.44',8,'available',2013,13505,NULL,2,3,3,4,2,44,NULL,NULL,'per_day',NULL,'','D1ZFKGDZ7EHLUCE01','',1,1,3,'80468 Pine Ridge',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=gmc-sierra-1500-denali-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(56,'Mitsubishi Outlander SEL S-AWC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/54.jpg\",\"cars\\/14.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\"]','30C-300.55',9,'available',2022,1636,NULL,3,1,2,4,2,63,NULL,NULL,'per_day',NULL,'','NVRA51F95KF53UPTB','',3,8,14,'32555 Lake Court',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(57,'Peugeot 308 GT Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/37.jpg\",\"cars\\/60.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-6.jpg\"]','30C-300.66',10,'available',2022,15479,NULL,2,2,1,7,2,61,NULL,NULL,'per_day',NULL,'','NRD41B5A3NW77F0KK','',5,13,20,'2371 Oren Valley',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',5,'Botble\\CarRentals\\Models\\Customer',5,'approved',NULL),(58,'Fiat 500X Sport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/77.jpg\",\"cars\\/42.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\"]','30C-300.77',12,'available',2013,13806,NULL,1,1,3,4,4,49,NULL,NULL,'per_day',NULL,'','0TW9PCSG8U8EJP76F','',5,13,20,'91742 Jackson Heights',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(59,'Smart EQ fortwo Prime 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/100.jpg\",\"cars\\/91.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\"]','30C-300.88',7,'available',2021,14760,NULL,3,2,1,5,2,34,NULL,NULL,'per_day',NULL,'','A3XDTC7V83730SM1C','',1,4,8,'32639 Cook Place # 469',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.expedia.com/carsearch?vehicle=smart-eq-fortwo-prime-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',7,'Botble\\CarRentals\\Models\\Customer',7,'approved',NULL),(60,'Toyota Corolla Hybrid LE 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/76.jpg\",\"cars\\/62.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\"]','30C-300.99',4,'available',2017,8043,NULL,8,2,1,4,4,53,NULL,NULL,'per_day',NULL,'','D9ECJV3K20A9TTWWD','',7,16,23,'38767 Cooper Walk',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(61,'Aston Martin Vantage F1 Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/83.jpg\",\"cars\\/24.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\"]','30D-400.00',10,'available',2024,13695,NULL,2,1,2,7,5,55,NULL,NULL,'per_day',NULL,'','PNTK3LBU7V8AJ42E7','',2,6,12,'74825 Ortiz Point',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(62,'Bugatti Chiron Super Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/88.jpg\",\"cars\\/58.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\"]','30D-400.11',14,'available',2018,3714,NULL,2,2,1,7,5,91,NULL,NULL,'per_day',NULL,'','R7596E471GSU1250V','',1,1,3,'35704 Moore Street Suite 791',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(63,'McLaren Artura Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/65.jpg\",\"cars\\/54.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\"]','30D-400.22',11,'available',2023,18591,NULL,5,2,2,4,5,74,NULL,NULL,'per_day',NULL,'','6AT8UUK60EATE83C0','',3,9,16,'9865 King Park',NULL,1,1,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=mclaren-artura-spider-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',32,'Botble\\CarRentals\\Models\\Customer',32,'approved',NULL),(64,'Pagani Huayra Roadster BC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/7.jpg\",\"cars\\/91.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-5.jpg\"]','30D-400.33',9,'available',2017,3815,NULL,5,1,2,4,4,45,NULL,NULL,'per_day',NULL,'','UB9ZBK4674J9ND13D','',7,16,23,'33714 King Highway',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',2,'Botble\\CarRentals\\Models\\Customer',2,'approved',NULL),(65,'Koenigsegg Jesko Absolut 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/32.jpg\",\"cars\\/93.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\"]','30D-400.44',10,'available',2019,16585,NULL,4,3,2,5,5,86,NULL,NULL,'per_day',NULL,'','V6T4A1FJ69L3GDGXY','',6,14,21,'13757 Brown Place',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(66,'Mercedes-Benz E450 4MATIC All-Terrain 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/33.jpg\",\"cars\\/88.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','30E-500.00',1,'available',2016,14466,NULL,5,2,3,5,2,38,NULL,NULL,'per_day',NULL,'','R5S0S66H5UY6MFZ0B','',1,4,9,'38738 Maple Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(67,'Audi Q7 55 TFSI quattro Premium Plus 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/61.jpg\",\"cars\\/67.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-7.jpg\"]','30E-500.11',11,'available',2018,12836,NULL,5,1,2,5,4,73,NULL,NULL,'per_day',NULL,'','YD7FU9JP7B850JM3T','',1,4,8,'60961 Davis Pass Unit 575',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(68,'BMW X7 xDrive40i M Sport 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/41.jpg\",\"cars\\/8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\"]','30E-500.22',7,'available',2024,16862,NULL,8,1,1,5,4,57,NULL,NULL,'per_day',NULL,'','0PJ8WGDK71T1L2TF1','',1,5,10,'2159 Long Lane',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(69,'Lexus LX 600 Ultra Luxury 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/88.jpg\",\"cars\\/70.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30E-500.33',7,'available',2012,1586,NULL,4,3,3,7,4,49,NULL,NULL,'per_day',NULL,'','EY95SNYK58W3SE1P5','',5,12,19,'19425 Murphy Gardens Suite 665',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.budget.com/en/reservation/vehicles?location=lexus-lx-600-ultra-luxury-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(70,'Volvo S90 B6 Ultimate AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/38.jpg\",\"cars\\/69.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\"]','30E-500.44',6,'available',2024,14003,NULL,2,3,1,5,4,60,NULL,NULL,'per_day',NULL,'','RJ5WRPZS6DSA9PAKD','',1,4,9,'36353 Edwards Hills Apt 735',NULL,0,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(71,'Genesis GV70 2.5T Sport AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/26.jpg\",\"cars\\/31.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-1.jpg\"]','30E-500.55',11,'available',2023,16269,NULL,7,3,1,7,4,69,NULL,NULL,'per_day',NULL,'','UZLVL1K79TU35CHX8','',5,12,19,'25034 Harrison Walk',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.hertz.com/rentacar/reservation/vehicles?location=genesis-gv70-2.5t-sport-awd-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(72,'Acura TLX Type S PMC Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/9.jpg\",\"cars\\/86.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-1.jpg\"]','30E-500.66',2,'available',2023,17392,NULL,1,1,2,7,5,77,NULL,NULL,'per_day',NULL,'','GPX8GKH68X8YFH8M7','',6,14,21,'85414 Second Street',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=acura-tlx-type-s-pmc-edition-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(73,'Infiniti Q50 Red Sport 400 AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/93.jpg\",\"cars\\/18.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-6.jpg\"]','30E-500.77',2,'available',2011,9218,NULL,2,2,3,5,5,47,NULL,NULL,'per_day',NULL,'','N6WV8GJX6WWRZ5BZX','',1,4,8,'80552 Pine Avenue',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',17,'Botble\\CarRentals\\Models\\Customer',17,'approved',NULL),(74,'Jaguar XF P300 R-Dynamic S AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/7.jpg\",\"cars\\/68.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\"]','30E-500.88',11,'available',2013,16044,NULL,3,1,3,8,4,35,NULL,NULL,'per_day',NULL,'','CGCM66HG51R3UV14K','',2,6,12,'10627 Reyes Heights Apt 322',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.europcar.com/en-us/car-rental/vehicles/jaguar-xf-p300-r-dynamic-s-awd-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(75,'Alfa Romeo Giulia Quadrifoglio 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/92.jpg\",\"cars\\/47.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\"]','30E-500.99',7,'available',2020,9041,NULL,7,3,3,7,5,88,NULL,NULL,'per_day',NULL,'','6AKJM89P72XN805ME','',5,13,20,'19871 Kelly Grove',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(76,'Porsche Cayenne Turbo GT 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/9.jpg\",\"cars\\/17.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\"]','29E-600.00',11,'available',2014,9812,NULL,5,1,1,4,4,49,NULL,NULL,'per_day',NULL,'','5UDZ295T482MJC9F8','',3,9,16,'59621 Powell Way Unit 168',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',16,'Botble\\CarRentals\\Models\\Customer',16,'approved',NULL),(77,'Range Rover Sport HSE Dynamic 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/28.jpg\",\"cars\\/35.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-5.jpg\"]','29E-600.11',11,'available',2015,6904,NULL,2,2,2,8,2,95,NULL,NULL,'per_day',NULL,'','NSGG8L6E5JDZSJD8A','',6,15,22,'45061 Harrison Landing',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.rentalcars.com/en/search-results/range-rover-sport-hse-dynamic-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(78,'Mercedes-AMG GLE 63 S 4MATIC+ 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/102.jpg\",\"cars\\/29.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\"]','29E-600.22',4,'available',2019,18969,NULL,2,2,2,5,2,56,NULL,NULL,'per_day',NULL,'','5ZSG2Y4E7T40TFC0G','',1,1,1,'40476 Phillips Walk',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(79,'BMW M5 Competition xDrive 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/91.jpg\",\"cars\\/55.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\"]','29E-600.33',11,'available',2020,8119,NULL,3,2,3,4,2,82,NULL,NULL,'per_day',NULL,'','G3L9JX4X1STPGFHNX','',2,6,11,'80180 Brooks Place',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',4,'Botble\\CarRentals\\Models\\Customer',4,'approved',NULL),(80,'Audi RS Q8 quattro 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/72.jpg\",\"cars\\/60.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-5.jpg\"]','29E-600.44',13,'available',2022,5023,NULL,6,1,1,7,4,91,NULL,NULL,'per_day',NULL,'','23VKJP2D90CKCJ5F5','',8,19,26,'65566 Richardson Plaza Suite 307',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(81,'Tesla Model S Plaid 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/70.jpg\",\"cars\\/61.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\"]','29E-600.55',13,'available',2014,8064,NULL,8,3,3,8,2,71,NULL,NULL,'per_day',NULL,'','RRJ3SW143E3LM4BX7','',3,8,15,'1093 Perry Avenue',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',13,'Botble\\CarRentals\\Models\\Customer',13,'approved',NULL),(82,'Lucid Air Grand Touring Performance 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/55.jpg\",\"cars\\/77.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\"]','29E-600.66',1,'available',2020,7839,NULL,4,2,2,4,5,47,NULL,NULL,'per_day',NULL,'','UCEC8UJX7K5R4SD84','',7,17,24,'63996 Davis Point Apt 991',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(83,'Rivian R1S Adventure 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/16.jpg\",\"cars\\/80.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-6.jpg\"]','29E-600.77',8,'available',2018,7334,NULL,2,2,2,8,4,73,NULL,NULL,'per_day',NULL,'','EV2MP31610AW16EWY','',6,15,22,'87257 Adams Way',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(84,'Polestar 2 Long Range Dual Motor 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/69.jpg\",\"cars\\/58.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-1.jpg\"]','29E-600.88',10,'available',2014,4381,NULL,3,2,1,5,2,81,NULL,NULL,'per_day',NULL,'','D0564HHX0AYCRLGFW','',3,8,14,'63536 Willow Valley Unit 738',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.turo.com/us/en/search?vehicle=polestar-2-long-range-dual-motor-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(85,'Genesis Electrified GV70 Advanced AWD 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/13.jpg\",\"cars\\/42.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-1.jpg\"]','29E-600.99',6,'available',2015,15198,NULL,7,3,1,7,5,47,NULL,NULL,'per_day',NULL,'','34UERK2J0HA3YZYZ0','',1,2,4,'71168 Johnson Creek Unit 439',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(86,'Mercedes-Maybach S 580 4MATIC 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/50.jpg\",\"cars\\/77.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30F-700.00',2,'available',2012,16125,NULL,4,1,1,5,4,92,NULL,NULL,'per_day',NULL,'','1U9KDZRL6R499M0DJ','',8,19,26,'334 Edwards Meadows',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',14,'Botble\\CarRentals\\Models\\Customer',14,'approved',NULL),(87,'Bentley Bentayga S V8 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/89.jpg\",\"cars\\/55.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-5.jpg\"]','30F-700.11',14,'available',2020,2035,NULL,5,2,1,8,5,71,NULL,NULL,'per_day',NULL,'','KN6BG6T76EZ0GA23U','',1,1,1,'35790 Stewart Gardens Unit 815',NULL,1,1,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',11,'Botble\\CarRentals\\Models\\Customer',11,'approved',NULL),(88,'Rolls-Royce Cullinan Black Badge 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/79.jpg\",\"cars\\/73.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-7.jpg\"]','30F-700.22',14,'available',2019,15392,NULL,8,3,3,7,4,70,NULL,NULL,'per_day',NULL,'','PZUY6M075F53PXFZ6','',1,1,2,'37146 Powell Lane',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=rolls-royce-cullinan-black-badge-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',19,'Botble\\CarRentals\\Models\\Customer',19,'approved',NULL),(89,'Aston Martin DBX707 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/22.jpg\",\"cars\\/43.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.33',2,'available',2017,17867,NULL,8,1,1,8,4,98,NULL,NULL,'per_day',NULL,'','7APES94B9L6LSM2KT','',2,6,11,'7685 James Valley Suite 379',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(90,'Maserati Levante Trofeo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/11.jpg\",\"cars\\/93.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-6.jpg\"]','30F-700.44',8,'available',2024,6958,NULL,4,2,3,7,4,41,NULL,NULL,'per_day',NULL,'','BVMN2V7V6PK3HKVZ1','',7,17,24,'26142 Moore Terrace',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',9,'Botble\\CarRentals\\Models\\Customer',9,'approved',NULL),(91,'Ferrari Roma Spider 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/11.jpg\",\"cars\\/20.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\"]','30F-700.55',2,'available',2016,3908,NULL,3,3,2,4,5,68,NULL,NULL,'per_day',NULL,'','VZKJT10U1NEEWEP5W','',1,3,6,'58762 Birch Highway',NULL,1,0,0,NULL,NULL,NULL,NULL,'available','https://www.europcar.com/en-us/car-rental/vehicles/ferrari-roma-spider-2024','2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(92,'McLaren GT Luxe 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/22.jpg\",\"cars\\/30.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-8.jpg\"]','30F-700.66',11,'available',2020,7026,NULL,1,3,2,8,5,41,NULL,NULL,'per_day',NULL,'','LCXFFA906JMRABHGC','',1,1,3,'99595 Oak Way',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(93,'Lamborghini Urus Performante 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/80.jpg\",\"cars\\/83.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-3.jpg\"]','30F-700.77',14,'available',2016,10527,NULL,1,1,3,4,5,77,NULL,NULL,'per_day',NULL,'','1G2TXGLC5A4CFN1GC','',3,9,16,'50654 Grant Pass',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(94,'Porsche Taycan Turbo S Cross Turismo 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/17.jpg\",\"cars\\/16.jpg\",\"cars\\/car-interiors-3.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-6.jpg\",\"cars\\/car-interiors-3.jpg\"]','30F-700.88',9,'available',2012,3590,NULL,8,3,2,8,5,97,NULL,NULL,'per_day',NULL,'','8BJ1H5DR8LNX9FJ47','',2,6,12,'45663 Russell Lane Suite 221',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',18,'Botble\\CarRentals\\Models\\Customer',18,'approved',NULL),(95,'BMW XM Label Red 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/57.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-3.jpg\"]','30F-700.99',9,'available',2013,12618,NULL,5,2,1,4,2,60,NULL,NULL,'per_day',NULL,'','CNU71WP578B2X8M61','',6,14,21,'77364 Rivera Hills',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:19','2025-11-17 21:11:19',1,'Botble\\CarRentals\\Models\\Customer',1,'approved',NULL),(96,'Chevrolet Corvette Z06 3LZ 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/10.jpg\",\"cars\\/49.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\"]','29F-800.00',8,'available',2014,16235,NULL,7,3,2,7,4,94,NULL,NULL,'per_day',NULL,'','TRM1E09C4ZAFBPAZV','',6,15,22,'27056 Ross Meadows Unit 478',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:20','2025-11-17 21:11:20',1,'Botble\\ACL\\Models\\User',NULL,'approved',NULL),(97,'Ford GT Heritage Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/98.jpg\",\"cars\\/94.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-5.jpg\"]','29F-800.11',14,'available',2022,3989,NULL,3,2,2,8,5,30,NULL,NULL,'per_day',NULL,'','G70FCC7S6EUGTSF2W','',8,19,26,'70697 Nelson Cliffs',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:20','2025-11-17 21:11:20',15,'Botble\\CarRentals\\Models\\Customer',15,'approved',NULL),(98,'Dodge Viper ACR Extreme 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/2.jpg\",\"cars\\/48.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-7.jpg\",\"cars\\/car-interiors-5.jpg\"]','29F-800.22',7,'available',2017,18769,NULL,5,3,2,8,2,39,NULL,NULL,'per_day',NULL,'','2MWZWCVF9HXT0C5XF','',3,8,15,'64465 Turner Cliffs',NULL,0,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:20','2025-11-17 21:11:20',10,'Botble\\CarRentals\\Models\\Customer',10,'approved',NULL),(99,'Nissan GT-R NISMO Special Edition 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/53.jpg\",\"cars\\/4.jpg\",\"cars\\/car-interiors-5.jpg\",\"cars\\/car-interiors-8.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-7.jpg\"]','29F-800.33',8,'available',2021,1605,NULL,7,2,1,8,5,44,NULL,NULL,'per_day',NULL,'','XNXTNWK93MW3XPMBV','',4,10,17,'75554 Lewis Boulevard',NULL,1,0,0,NULL,NULL,NULL,NULL,'available',NULL,'2025-11-17 21:11:20','2025-11-17 21:11:20',12,'Botble\\CarRentals\\Models\\Customer',12,'approved',NULL),(100,'Toyota Supra 3.0 Premium 2024',NULL,'<p>Introducing the epitome of modern sophistication in the realm of compact SUVs – the Seltos K3. Dressed in a captivating blue hue that exudes elegance and flair, this dynamic vehicle stands as a testament to innovation and style. With its sleek design accentuated by striking dark wheels, the Seltos K3 is not merely a mode of transportation but a statement of refined taste and contemporary living.</p>\n<p>Prepare to embark on a journey where cutting-edge technology meets unparalleled comfort, all wrapped in a package of unparalleled aesthetics. Join us as we delve into the world of the Seltos K3, where every detail is crafted to elevate your driving experience to new heights.</p>\n','[\"cars\\/97.jpg\",\"cars\\/34.jpg\",\"cars\\/car-interiors-1.jpg\",\"cars\\/car-interiors-2.jpg\",\"cars\\/car-interiors-4.jpg\",\"cars\\/car-interiors-2.jpg\"]','29F-800.44',8,'available',2017,13761,NULL,6,1,2,4,4,33,NULL,NULL,'per_day',NULL,'','TK8XL4M55Z3E144MC','',7,16,23,'715 Cox Ridge Floor 429',NULL,0,0,0,NULL,NULL,NULL,NULL,'available','https://www.avis.com/en/reserve/vehicles?location=toyota-supra-3.0-premium-2024','2025-11-17 21:11:20','2025-11-17 21:11:20',6,'Botble\\CarRentals\\Models\\Customer',6,'approved',NULL);
/*!40000 ALTER TABLE `cr_cars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_amenities`
--

DROP TABLE IF EXISTS `cr_cars_amenities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_amenities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_id` bigint unsigned NOT NULL,
  `cr_car_amenity_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1656 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_amenities`
--

LOCK TABLES `cr_cars_amenities` WRITE;
/*!40000 ALTER TABLE `cr_cars_amenities` DISABLE KEYS */;
INSERT INTO `cr_cars_amenities` VALUES (1,1,13,NULL,NULL),(2,1,23,NULL,NULL),(3,1,45,NULL,NULL),(4,1,1,NULL,NULL),(5,1,4,NULL,NULL),(6,1,8,NULL,NULL),(7,1,19,NULL,NULL),(8,1,15,NULL,NULL),(9,1,18,NULL,NULL),(10,1,28,NULL,NULL),(11,1,34,NULL,NULL),(12,2,13,NULL,NULL),(13,2,45,NULL,NULL),(14,2,46,NULL,NULL),(15,2,47,NULL,NULL),(16,2,3,NULL,NULL),(17,2,5,NULL,NULL),(18,2,9,NULL,NULL),(19,2,20,NULL,NULL),(20,2,21,NULL,NULL),(21,2,25,NULL,NULL),(22,2,11,NULL,NULL),(23,2,12,NULL,NULL),(24,2,15,NULL,NULL),(25,2,16,NULL,NULL),(26,2,17,NULL,NULL),(27,2,18,NULL,NULL),(28,2,28,NULL,NULL),(29,2,30,NULL,NULL),(30,2,32,NULL,NULL),(31,2,37,NULL,NULL),(32,2,39,NULL,NULL),(33,2,40,NULL,NULL),(34,2,43,NULL,NULL),(35,3,14,NULL,NULL),(36,3,45,NULL,NULL),(37,3,46,NULL,NULL),(38,3,47,NULL,NULL),(39,3,5,NULL,NULL),(40,3,9,NULL,NULL),(41,3,20,NULL,NULL),(42,3,21,NULL,NULL),(43,3,27,NULL,NULL),(44,3,33,NULL,NULL),(45,3,10,NULL,NULL),(46,3,12,NULL,NULL),(47,3,17,NULL,NULL),(48,3,18,NULL,NULL),(49,3,28,NULL,NULL),(50,3,30,NULL,NULL),(51,3,35,NULL,NULL),(52,3,37,NULL,NULL),(53,3,38,NULL,NULL),(54,3,41,NULL,NULL),(55,4,13,NULL,NULL),(56,4,14,NULL,NULL),(57,4,46,NULL,NULL),(58,4,1,NULL,NULL),(59,4,11,NULL,NULL),(60,4,39,NULL,NULL),(61,4,41,NULL,NULL),(62,4,42,NULL,NULL),(63,4,43,NULL,NULL),(64,5,13,NULL,NULL),(65,5,14,NULL,NULL),(66,5,22,NULL,NULL),(67,5,45,NULL,NULL),(68,5,47,NULL,NULL),(69,5,4,NULL,NULL),(70,5,8,NULL,NULL),(71,5,19,NULL,NULL),(72,5,7,NULL,NULL),(73,5,10,NULL,NULL),(74,5,11,NULL,NULL),(75,5,17,NULL,NULL),(76,5,29,NULL,NULL),(77,5,30,NULL,NULL),(78,5,32,NULL,NULL),(79,5,38,NULL,NULL),(80,5,43,NULL,NULL),(81,6,13,NULL,NULL),(82,6,14,NULL,NULL),(83,6,46,NULL,NULL),(84,6,1,NULL,NULL),(85,6,4,NULL,NULL),(86,6,6,NULL,NULL),(87,6,8,NULL,NULL),(88,6,19,NULL,NULL),(89,6,12,NULL,NULL),(90,6,15,NULL,NULL),(91,6,17,NULL,NULL),(92,6,28,NULL,NULL),(93,6,31,NULL,NULL),(94,6,34,NULL,NULL),(95,6,35,NULL,NULL),(96,6,33,NULL,NULL),(97,7,13,NULL,NULL),(98,7,14,NULL,NULL),(99,7,22,NULL,NULL),(100,7,23,NULL,NULL),(101,7,45,NULL,NULL),(102,7,6,NULL,NULL),(103,7,15,NULL,NULL),(104,7,17,NULL,NULL),(105,8,13,NULL,NULL),(106,8,14,NULL,NULL),(107,8,22,NULL,NULL),(108,8,45,NULL,NULL),(109,8,3,NULL,NULL),(110,8,9,NULL,NULL),(111,8,20,NULL,NULL),(112,8,25,NULL,NULL),(113,8,27,NULL,NULL),(114,8,11,NULL,NULL),(115,8,15,NULL,NULL),(116,8,16,NULL,NULL),(117,8,18,NULL,NULL),(118,8,29,NULL,NULL),(119,8,30,NULL,NULL),(120,8,31,NULL,NULL),(121,8,32,NULL,NULL),(122,8,35,NULL,NULL),(123,8,38,NULL,NULL),(124,8,40,NULL,NULL),(125,8,42,NULL,NULL),(126,8,43,NULL,NULL),(127,8,39,NULL,NULL),(128,8,41,NULL,NULL),(129,9,13,NULL,NULL),(130,9,14,NULL,NULL),(131,9,46,NULL,NULL),(132,9,47,NULL,NULL),(133,9,3,NULL,NULL),(134,9,9,NULL,NULL),(135,9,20,NULL,NULL),(136,9,27,NULL,NULL),(137,9,7,NULL,NULL),(138,9,10,NULL,NULL),(139,9,15,NULL,NULL),(140,9,16,NULL,NULL),(141,9,17,NULL,NULL),(142,9,18,NULL,NULL),(143,9,29,NULL,NULL),(144,9,30,NULL,NULL),(145,9,34,NULL,NULL),(146,9,38,NULL,NULL),(147,9,41,NULL,NULL),(148,9,42,NULL,NULL),(149,9,43,NULL,NULL),(150,10,13,NULL,NULL),(151,10,23,NULL,NULL),(152,10,46,NULL,NULL),(153,10,3,NULL,NULL),(154,10,5,NULL,NULL),(155,10,20,NULL,NULL),(156,10,21,NULL,NULL),(157,10,25,NULL,NULL),(158,10,33,NULL,NULL),(159,10,7,NULL,NULL),(160,10,11,NULL,NULL),(161,10,12,NULL,NULL),(162,10,16,NULL,NULL),(163,10,28,NULL,NULL),(164,10,29,NULL,NULL),(165,10,34,NULL,NULL),(166,10,35,NULL,NULL),(167,10,37,NULL,NULL),(168,10,38,NULL,NULL),(169,10,39,NULL,NULL),(170,10,43,NULL,NULL),(171,10,40,NULL,NULL),(172,10,41,NULL,NULL),(173,10,42,NULL,NULL),(174,11,13,NULL,NULL),(175,11,14,NULL,NULL),(176,11,22,NULL,NULL),(177,11,23,NULL,NULL),(178,11,45,NULL,NULL),(179,11,1,NULL,NULL),(180,11,17,NULL,NULL),(181,11,37,NULL,NULL),(182,11,39,NULL,NULL),(183,11,43,NULL,NULL),(184,12,14,NULL,NULL),(185,12,22,NULL,NULL),(186,12,23,NULL,NULL),(187,12,45,NULL,NULL),(188,12,47,NULL,NULL),(189,12,1,NULL,NULL),(190,12,4,NULL,NULL),(191,12,6,NULL,NULL),(192,12,8,NULL,NULL),(193,12,19,NULL,NULL),(194,12,15,NULL,NULL),(195,12,17,NULL,NULL),(196,12,18,NULL,NULL),(197,12,30,NULL,NULL),(198,12,31,NULL,NULL),(199,12,21,NULL,NULL),(200,13,13,NULL,NULL),(201,13,14,NULL,NULL),(202,13,45,NULL,NULL),(203,13,46,NULL,NULL),(204,13,1,NULL,NULL),(205,13,8,NULL,NULL),(206,13,7,NULL,NULL),(207,13,15,NULL,NULL),(208,13,16,NULL,NULL),(209,13,17,NULL,NULL),(210,13,29,NULL,NULL),(211,13,30,NULL,NULL),(212,14,13,NULL,NULL),(213,14,14,NULL,NULL),(214,14,22,NULL,NULL),(215,14,23,NULL,NULL),(216,14,45,NULL,NULL),(217,14,1,NULL,NULL),(218,14,19,NULL,NULL),(219,14,16,NULL,NULL),(220,14,41,NULL,NULL),(221,14,43,NULL,NULL),(222,15,13,NULL,NULL),(223,15,14,NULL,NULL),(224,15,22,NULL,NULL),(225,15,23,NULL,NULL),(226,15,45,NULL,NULL),(227,15,1,NULL,NULL),(228,15,4,NULL,NULL),(229,15,6,NULL,NULL),(230,15,8,NULL,NULL),(231,15,19,NULL,NULL),(232,15,7,NULL,NULL),(233,15,12,NULL,NULL),(234,15,16,NULL,NULL),(235,15,18,NULL,NULL),(236,15,29,NULL,NULL),(237,15,32,NULL,NULL),(238,15,3,NULL,NULL),(239,15,25,NULL,NULL),(240,15,33,NULL,NULL),(241,16,14,NULL,NULL),(242,16,22,NULL,NULL),(243,16,45,NULL,NULL),(244,16,46,NULL,NULL),(245,16,47,NULL,NULL),(246,16,1,NULL,NULL),(247,16,2,NULL,NULL),(248,16,11,NULL,NULL),(249,16,40,NULL,NULL),(250,16,43,NULL,NULL),(251,17,14,NULL,NULL),(252,17,22,NULL,NULL),(253,17,23,NULL,NULL),(254,17,45,NULL,NULL),(255,17,4,NULL,NULL),(256,17,6,NULL,NULL),(257,17,19,NULL,NULL),(258,17,10,NULL,NULL),(259,17,12,NULL,NULL),(260,17,16,NULL,NULL),(261,17,31,NULL,NULL),(262,17,34,NULL,NULL),(263,17,3,NULL,NULL),(264,17,25,NULL,NULL),(265,17,27,NULL,NULL),(266,18,14,NULL,NULL),(267,18,23,NULL,NULL),(268,18,45,NULL,NULL),(269,18,46,NULL,NULL),(270,18,47,NULL,NULL),(271,18,2,NULL,NULL),(272,18,4,NULL,NULL),(273,18,6,NULL,NULL),(274,18,8,NULL,NULL),(275,18,19,NULL,NULL),(276,18,11,NULL,NULL),(277,18,12,NULL,NULL),(278,18,16,NULL,NULL),(279,18,18,NULL,NULL),(280,18,31,NULL,NULL),(281,18,32,NULL,NULL),(282,18,34,NULL,NULL),(283,18,35,NULL,NULL),(284,18,20,NULL,NULL),(285,19,13,NULL,NULL),(286,19,22,NULL,NULL),(287,19,23,NULL,NULL),(288,19,45,NULL,NULL),(289,19,1,NULL,NULL),(290,19,4,NULL,NULL),(291,19,6,NULL,NULL),(292,19,8,NULL,NULL),(293,19,19,NULL,NULL),(294,19,10,NULL,NULL),(295,19,12,NULL,NULL),(296,19,16,NULL,NULL),(297,19,17,NULL,NULL),(298,19,18,NULL,NULL),(299,19,28,NULL,NULL),(300,19,32,NULL,NULL),(301,19,34,NULL,NULL),(302,19,3,NULL,NULL),(303,19,21,NULL,NULL),(304,19,33,NULL,NULL),(305,20,13,NULL,NULL),(306,20,22,NULL,NULL),(307,20,23,NULL,NULL),(308,20,1,NULL,NULL),(309,20,2,NULL,NULL),(310,20,4,NULL,NULL),(311,20,6,NULL,NULL),(312,20,8,NULL,NULL),(313,20,15,NULL,NULL),(314,20,16,NULL,NULL),(315,20,17,NULL,NULL),(316,20,29,NULL,NULL),(317,20,30,NULL,NULL),(318,20,31,NULL,NULL),(319,20,5,NULL,NULL),(320,20,20,NULL,NULL),(321,21,14,NULL,NULL),(322,21,23,NULL,NULL),(323,21,45,NULL,NULL),(324,21,46,NULL,NULL),(325,21,47,NULL,NULL),(326,21,1,NULL,NULL),(327,21,2,NULL,NULL),(328,21,4,NULL,NULL),(329,21,19,NULL,NULL),(330,21,12,NULL,NULL),(331,21,15,NULL,NULL),(332,21,16,NULL,NULL),(333,21,29,NULL,NULL),(334,21,34,NULL,NULL),(335,21,35,NULL,NULL),(336,21,20,NULL,NULL),(337,21,27,NULL,NULL),(338,22,22,NULL,NULL),(339,22,23,NULL,NULL),(340,22,45,NULL,NULL),(341,22,46,NULL,NULL),(342,22,47,NULL,NULL),(343,22,1,NULL,NULL),(344,22,4,NULL,NULL),(345,22,6,NULL,NULL),(346,22,8,NULL,NULL),(347,22,7,NULL,NULL),(348,22,11,NULL,NULL),(349,22,12,NULL,NULL),(350,22,16,NULL,NULL),(351,22,29,NULL,NULL),(352,22,35,NULL,NULL),(353,23,14,NULL,NULL),(354,23,23,NULL,NULL),(355,23,47,NULL,NULL),(356,23,19,NULL,NULL),(357,23,7,NULL,NULL),(358,23,17,NULL,NULL),(359,23,41,NULL,NULL),(360,23,43,NULL,NULL),(361,24,14,NULL,NULL),(362,24,45,NULL,NULL),(363,24,46,NULL,NULL),(364,24,4,NULL,NULL),(365,24,6,NULL,NULL),(366,24,8,NULL,NULL),(367,24,19,NULL,NULL),(368,24,10,NULL,NULL),(369,24,17,NULL,NULL),(370,24,18,NULL,NULL),(371,24,29,NULL,NULL),(372,24,30,NULL,NULL),(373,24,34,NULL,NULL),(374,24,21,NULL,NULL),(375,24,25,NULL,NULL),(376,24,37,NULL,NULL),(377,24,39,NULL,NULL),(378,24,42,NULL,NULL),(379,25,13,NULL,NULL),(380,25,14,NULL,NULL),(381,25,22,NULL,NULL),(382,25,23,NULL,NULL),(383,25,3,NULL,NULL),(384,25,5,NULL,NULL),(385,25,25,NULL,NULL),(386,25,33,NULL,NULL),(387,25,7,NULL,NULL),(388,25,15,NULL,NULL),(389,25,16,NULL,NULL),(390,25,17,NULL,NULL),(391,25,18,NULL,NULL),(392,25,29,NULL,NULL),(393,25,30,NULL,NULL),(394,25,34,NULL,NULL),(395,25,41,NULL,NULL),(396,25,43,NULL,NULL),(397,25,37,NULL,NULL),(398,25,40,NULL,NULL),(399,26,13,NULL,NULL),(400,26,14,NULL,NULL),(401,26,46,NULL,NULL),(402,26,47,NULL,NULL),(403,26,3,NULL,NULL),(404,26,9,NULL,NULL),(405,26,20,NULL,NULL),(406,26,21,NULL,NULL),(407,26,25,NULL,NULL),(408,26,27,NULL,NULL),(409,26,7,NULL,NULL),(410,26,10,NULL,NULL),(411,26,15,NULL,NULL),(412,26,18,NULL,NULL),(413,26,28,NULL,NULL),(414,26,30,NULL,NULL),(415,26,34,NULL,NULL),(416,26,35,NULL,NULL),(417,26,38,NULL,NULL),(418,26,42,NULL,NULL),(419,27,14,NULL,NULL),(420,27,23,NULL,NULL),(421,27,47,NULL,NULL),(422,27,1,NULL,NULL),(423,27,6,NULL,NULL),(424,27,16,NULL,NULL),(425,27,18,NULL,NULL),(426,28,13,NULL,NULL),(427,28,14,NULL,NULL),(428,28,22,NULL,NULL),(429,28,23,NULL,NULL),(430,28,45,NULL,NULL),(431,28,1,NULL,NULL),(432,28,4,NULL,NULL),(433,28,6,NULL,NULL),(434,28,8,NULL,NULL),(435,28,19,NULL,NULL),(436,28,7,NULL,NULL),(437,28,10,NULL,NULL),(438,28,12,NULL,NULL),(439,28,17,NULL,NULL),(440,28,18,NULL,NULL),(441,28,31,NULL,NULL),(442,28,35,NULL,NULL),(443,28,5,NULL,NULL),(444,28,9,NULL,NULL),(445,28,37,NULL,NULL),(446,28,38,NULL,NULL),(447,28,39,NULL,NULL),(448,29,13,NULL,NULL),(449,29,14,NULL,NULL),(450,29,23,NULL,NULL),(451,29,46,NULL,NULL),(452,29,47,NULL,NULL),(453,29,2,NULL,NULL),(454,29,6,NULL,NULL),(455,29,12,NULL,NULL),(456,29,18,NULL,NULL),(457,30,13,NULL,NULL),(458,30,14,NULL,NULL),(459,30,45,NULL,NULL),(460,30,46,NULL,NULL),(461,30,47,NULL,NULL),(462,30,3,NULL,NULL),(463,30,5,NULL,NULL),(464,30,20,NULL,NULL),(465,30,21,NULL,NULL),(466,30,25,NULL,NULL),(467,30,7,NULL,NULL),(468,30,11,NULL,NULL),(469,30,12,NULL,NULL),(470,30,17,NULL,NULL),(471,30,18,NULL,NULL),(472,30,28,NULL,NULL),(473,30,29,NULL,NULL),(474,30,31,NULL,NULL),(475,30,32,NULL,NULL),(476,30,34,NULL,NULL),(477,30,37,NULL,NULL),(478,30,42,NULL,NULL),(479,31,13,NULL,NULL),(480,31,22,NULL,NULL),(481,31,47,NULL,NULL),(482,31,4,NULL,NULL),(483,31,6,NULL,NULL),(484,31,16,NULL,NULL),(485,31,17,NULL,NULL),(486,31,18,NULL,NULL),(487,31,28,NULL,NULL),(488,31,29,NULL,NULL),(489,31,31,NULL,NULL),(490,32,13,NULL,NULL),(491,32,14,NULL,NULL),(492,32,45,NULL,NULL),(493,32,46,NULL,NULL),(494,32,47,NULL,NULL),(495,32,1,NULL,NULL),(496,32,4,NULL,NULL),(497,32,7,NULL,NULL),(498,32,16,NULL,NULL),(499,32,29,NULL,NULL),(500,32,31,NULL,NULL),(501,33,13,NULL,NULL),(502,33,14,NULL,NULL),(503,33,23,NULL,NULL),(504,33,46,NULL,NULL),(505,33,47,NULL,NULL),(506,33,1,NULL,NULL),(507,33,6,NULL,NULL),(508,33,10,NULL,NULL),(509,33,16,NULL,NULL),(510,33,32,NULL,NULL),(511,33,38,NULL,NULL),(512,33,39,NULL,NULL),(513,33,40,NULL,NULL),(514,34,23,NULL,NULL),(515,34,45,NULL,NULL),(516,34,47,NULL,NULL),(517,34,1,NULL,NULL),(518,34,2,NULL,NULL),(519,34,4,NULL,NULL),(520,34,6,NULL,NULL),(521,34,19,NULL,NULL),(522,34,12,NULL,NULL),(523,34,15,NULL,NULL),(524,34,16,NULL,NULL),(525,34,17,NULL,NULL),(526,34,18,NULL,NULL),(527,34,31,NULL,NULL),(528,34,32,NULL,NULL),(529,34,3,NULL,NULL),(530,34,5,NULL,NULL),(531,34,33,NULL,NULL),(532,34,37,NULL,NULL),(533,34,43,NULL,NULL),(534,35,13,NULL,NULL),(535,35,14,NULL,NULL),(536,35,23,NULL,NULL),(537,35,46,NULL,NULL),(538,35,3,NULL,NULL),(539,35,9,NULL,NULL),(540,35,20,NULL,NULL),(541,35,25,NULL,NULL),(542,35,27,NULL,NULL),(543,35,33,NULL,NULL),(544,35,10,NULL,NULL),(545,35,15,NULL,NULL),(546,35,16,NULL,NULL),(547,35,18,NULL,NULL),(548,35,30,NULL,NULL),(549,35,31,NULL,NULL),(550,35,32,NULL,NULL),(551,35,40,NULL,NULL),(552,35,41,NULL,NULL),(553,36,22,NULL,NULL),(554,36,23,NULL,NULL),(555,36,45,NULL,NULL),(556,36,46,NULL,NULL),(557,36,47,NULL,NULL),(558,36,3,NULL,NULL),(559,36,9,NULL,NULL),(560,36,21,NULL,NULL),(561,36,25,NULL,NULL),(562,36,27,NULL,NULL),(563,36,33,NULL,NULL),(564,36,11,NULL,NULL),(565,36,15,NULL,NULL),(566,36,16,NULL,NULL),(567,36,18,NULL,NULL),(568,36,29,NULL,NULL),(569,36,32,NULL,NULL),(570,36,34,NULL,NULL),(571,36,40,NULL,NULL),(572,36,41,NULL,NULL),(573,36,42,NULL,NULL),(574,37,13,NULL,NULL),(575,37,14,NULL,NULL),(576,37,22,NULL,NULL),(577,37,45,NULL,NULL),(578,37,47,NULL,NULL),(579,37,5,NULL,NULL),(580,37,9,NULL,NULL),(581,37,20,NULL,NULL),(582,37,25,NULL,NULL),(583,37,27,NULL,NULL),(584,37,33,NULL,NULL),(585,37,11,NULL,NULL),(586,37,15,NULL,NULL),(587,37,16,NULL,NULL),(588,37,18,NULL,NULL),(589,37,28,NULL,NULL),(590,37,30,NULL,NULL),(591,37,34,NULL,NULL),(592,37,35,NULL,NULL),(593,37,39,NULL,NULL),(594,37,40,NULL,NULL),(595,38,13,NULL,NULL),(596,38,14,NULL,NULL),(597,38,22,NULL,NULL),(598,38,47,NULL,NULL),(599,38,3,NULL,NULL),(600,38,5,NULL,NULL),(601,38,9,NULL,NULL),(602,38,20,NULL,NULL),(603,38,27,NULL,NULL),(604,38,33,NULL,NULL),(605,38,10,NULL,NULL),(606,38,11,NULL,NULL),(607,38,12,NULL,NULL),(608,38,15,NULL,NULL),(609,38,16,NULL,NULL),(610,38,28,NULL,NULL),(611,38,30,NULL,NULL),(612,38,32,NULL,NULL),(613,38,34,NULL,NULL),(614,38,40,NULL,NULL),(615,38,42,NULL,NULL),(616,39,13,NULL,NULL),(617,39,14,NULL,NULL),(618,39,22,NULL,NULL),(619,39,46,NULL,NULL),(620,39,47,NULL,NULL),(621,39,1,NULL,NULL),(622,39,4,NULL,NULL),(623,39,19,NULL,NULL),(624,39,7,NULL,NULL),(625,39,10,NULL,NULL),(626,39,15,NULL,NULL),(627,39,29,NULL,NULL),(628,39,34,NULL,NULL),(629,39,35,NULL,NULL),(630,39,39,NULL,NULL),(631,39,41,NULL,NULL),(632,39,42,NULL,NULL),(633,40,13,NULL,NULL),(634,40,14,NULL,NULL),(635,40,45,NULL,NULL),(636,40,46,NULL,NULL),(637,40,47,NULL,NULL),(638,40,3,NULL,NULL),(639,40,5,NULL,NULL),(640,40,20,NULL,NULL),(641,40,21,NULL,NULL),(642,40,25,NULL,NULL),(643,40,11,NULL,NULL),(644,40,12,NULL,NULL),(645,40,17,NULL,NULL),(646,40,18,NULL,NULL),(647,40,28,NULL,NULL),(648,40,29,NULL,NULL),(649,40,32,NULL,NULL),(650,40,34,NULL,NULL),(651,40,35,NULL,NULL),(652,40,37,NULL,NULL),(653,40,42,NULL,NULL),(654,41,13,NULL,NULL),(655,41,22,NULL,NULL),(656,41,23,NULL,NULL),(657,41,45,NULL,NULL),(658,41,46,NULL,NULL),(659,41,4,NULL,NULL),(660,41,8,NULL,NULL),(661,41,7,NULL,NULL),(662,41,10,NULL,NULL),(663,41,16,NULL,NULL),(664,41,18,NULL,NULL),(665,41,30,NULL,NULL),(666,41,35,NULL,NULL),(667,42,13,NULL,NULL),(668,42,23,NULL,NULL),(669,42,45,NULL,NULL),(670,42,46,NULL,NULL),(671,42,4,NULL,NULL),(672,42,6,NULL,NULL),(673,42,8,NULL,NULL),(674,42,11,NULL,NULL),(675,42,15,NULL,NULL),(676,42,18,NULL,NULL),(677,42,30,NULL,NULL),(678,42,34,NULL,NULL),(679,42,35,NULL,NULL),(680,42,38,NULL,NULL),(681,42,40,NULL,NULL),(682,42,41,NULL,NULL),(683,42,42,NULL,NULL),(684,43,14,NULL,NULL),(685,43,22,NULL,NULL),(686,43,23,NULL,NULL),(687,43,45,NULL,NULL),(688,43,3,NULL,NULL),(689,43,5,NULL,NULL),(690,43,20,NULL,NULL),(691,43,21,NULL,NULL),(692,43,25,NULL,NULL),(693,43,33,NULL,NULL),(694,43,12,NULL,NULL),(695,43,15,NULL,NULL),(696,43,16,NULL,NULL),(697,43,18,NULL,NULL),(698,43,28,NULL,NULL),(699,43,29,NULL,NULL),(700,43,31,NULL,NULL),(701,43,34,NULL,NULL),(702,43,38,NULL,NULL),(703,43,40,NULL,NULL),(704,43,41,NULL,NULL),(705,44,13,NULL,NULL),(706,44,14,NULL,NULL),(707,44,45,NULL,NULL),(708,44,46,NULL,NULL),(709,44,47,NULL,NULL),(710,44,5,NULL,NULL),(711,44,9,NULL,NULL),(712,44,21,NULL,NULL),(713,44,33,NULL,NULL),(714,44,7,NULL,NULL),(715,44,11,NULL,NULL),(716,44,12,NULL,NULL),(717,44,17,NULL,NULL),(718,44,18,NULL,NULL),(719,44,28,NULL,NULL),(720,44,29,NULL,NULL),(721,44,32,NULL,NULL),(722,44,39,NULL,NULL),(723,44,40,NULL,NULL),(724,44,41,NULL,NULL),(725,44,37,NULL,NULL),(726,44,43,NULL,NULL),(727,45,13,NULL,NULL),(728,45,22,NULL,NULL),(729,45,23,NULL,NULL),(730,45,46,NULL,NULL),(731,45,47,NULL,NULL),(732,45,1,NULL,NULL),(733,45,2,NULL,NULL),(734,45,4,NULL,NULL),(735,45,19,NULL,NULL),(736,45,7,NULL,NULL),(737,45,15,NULL,NULL),(738,45,17,NULL,NULL),(739,45,31,NULL,NULL),(740,45,34,NULL,NULL),(741,45,3,NULL,NULL),(742,45,20,NULL,NULL),(743,45,21,NULL,NULL),(744,45,37,NULL,NULL),(745,45,39,NULL,NULL),(746,45,40,NULL,NULL),(747,45,42,NULL,NULL),(748,46,13,NULL,NULL),(749,46,14,NULL,NULL),(750,46,22,NULL,NULL),(751,46,23,NULL,NULL),(752,46,45,NULL,NULL),(753,46,1,NULL,NULL),(754,46,2,NULL,NULL),(755,46,4,NULL,NULL),(756,46,8,NULL,NULL),(757,46,11,NULL,NULL),(758,46,12,NULL,NULL),(759,46,16,NULL,NULL),(760,46,30,NULL,NULL),(761,46,31,NULL,NULL),(762,47,13,NULL,NULL),(763,47,14,NULL,NULL),(764,47,22,NULL,NULL),(765,47,23,NULL,NULL),(766,47,47,NULL,NULL),(767,47,2,NULL,NULL),(768,47,4,NULL,NULL),(769,47,19,NULL,NULL),(770,47,12,NULL,NULL),(771,47,15,NULL,NULL),(772,47,17,NULL,NULL),(773,47,32,NULL,NULL),(774,47,38,NULL,NULL),(775,47,39,NULL,NULL),(776,47,40,NULL,NULL),(777,48,23,NULL,NULL),(778,48,45,NULL,NULL),(779,48,46,NULL,NULL),(780,48,47,NULL,NULL),(781,48,3,NULL,NULL),(782,48,20,NULL,NULL),(783,48,21,NULL,NULL),(784,48,25,NULL,NULL),(785,48,7,NULL,NULL),(786,48,10,NULL,NULL),(787,48,11,NULL,NULL),(788,48,15,NULL,NULL),(789,48,17,NULL,NULL),(790,48,18,NULL,NULL),(791,48,30,NULL,NULL),(792,48,31,NULL,NULL),(793,48,32,NULL,NULL),(794,48,34,NULL,NULL),(795,48,38,NULL,NULL),(796,48,39,NULL,NULL),(797,48,41,NULL,NULL),(798,49,13,NULL,NULL),(799,49,22,NULL,NULL),(800,49,45,NULL,NULL),(801,49,46,NULL,NULL),(802,49,20,NULL,NULL),(803,49,21,NULL,NULL),(804,49,27,NULL,NULL),(805,49,33,NULL,NULL),(806,49,7,NULL,NULL),(807,49,12,NULL,NULL),(808,49,15,NULL,NULL),(809,49,17,NULL,NULL),(810,49,18,NULL,NULL),(811,49,28,NULL,NULL),(812,49,30,NULL,NULL),(813,49,35,NULL,NULL),(814,49,41,NULL,NULL),(815,49,43,NULL,NULL),(816,50,23,NULL,NULL),(817,50,46,NULL,NULL),(818,50,47,NULL,NULL),(819,50,1,NULL,NULL),(820,50,2,NULL,NULL),(821,50,4,NULL,NULL),(822,50,10,NULL,NULL),(823,50,12,NULL,NULL),(824,50,16,NULL,NULL),(825,50,17,NULL,NULL),(826,50,18,NULL,NULL),(827,50,28,NULL,NULL),(828,50,29,NULL,NULL),(829,50,31,NULL,NULL),(830,50,32,NULL,NULL),(831,50,9,NULL,NULL),(832,50,21,NULL,NULL),(833,50,25,NULL,NULL),(834,51,22,NULL,NULL),(835,51,23,NULL,NULL),(836,51,45,NULL,NULL),(837,51,46,NULL,NULL),(838,51,47,NULL,NULL),(839,51,1,NULL,NULL),(840,51,8,NULL,NULL),(841,51,19,NULL,NULL),(842,51,11,NULL,NULL),(843,51,15,NULL,NULL),(844,51,16,NULL,NULL),(845,51,17,NULL,NULL),(846,51,29,NULL,NULL),(847,51,32,NULL,NULL),(848,51,35,NULL,NULL),(849,51,3,NULL,NULL),(850,51,21,NULL,NULL),(851,51,33,NULL,NULL),(852,52,13,NULL,NULL),(853,52,22,NULL,NULL),(854,52,47,NULL,NULL),(855,52,1,NULL,NULL),(856,52,6,NULL,NULL),(857,52,8,NULL,NULL),(858,52,10,NULL,NULL),(859,52,16,NULL,NULL),(860,52,17,NULL,NULL),(861,52,30,NULL,NULL),(862,52,35,NULL,NULL),(863,53,14,NULL,NULL),(864,53,22,NULL,NULL),(865,53,23,NULL,NULL),(866,53,45,NULL,NULL),(867,53,46,NULL,NULL),(868,53,1,NULL,NULL),(869,53,4,NULL,NULL),(870,53,8,NULL,NULL),(871,53,7,NULL,NULL),(872,53,11,NULL,NULL),(873,53,17,NULL,NULL),(874,53,28,NULL,NULL),(875,53,34,NULL,NULL),(876,53,5,NULL,NULL),(877,53,9,NULL,NULL),(878,53,25,NULL,NULL),(879,54,14,NULL,NULL),(880,54,22,NULL,NULL),(881,54,46,NULL,NULL),(882,54,1,NULL,NULL),(883,54,2,NULL,NULL),(884,54,6,NULL,NULL),(885,54,8,NULL,NULL),(886,54,19,NULL,NULL),(887,54,7,NULL,NULL),(888,54,10,NULL,NULL),(889,54,12,NULL,NULL),(890,54,18,NULL,NULL),(891,54,28,NULL,NULL),(892,54,30,NULL,NULL),(893,54,31,NULL,NULL),(894,54,34,NULL,NULL),(895,54,3,NULL,NULL),(896,54,21,NULL,NULL),(897,54,25,NULL,NULL),(898,55,13,NULL,NULL),(899,55,23,NULL,NULL),(900,55,45,NULL,NULL),(901,55,46,NULL,NULL),(902,55,1,NULL,NULL),(903,55,6,NULL,NULL),(904,55,19,NULL,NULL),(905,55,12,NULL,NULL),(906,55,15,NULL,NULL),(907,55,29,NULL,NULL),(908,55,30,NULL,NULL),(909,56,23,NULL,NULL),(910,56,46,NULL,NULL),(911,56,47,NULL,NULL),(912,56,2,NULL,NULL),(913,56,4,NULL,NULL),(914,56,19,NULL,NULL),(915,56,10,NULL,NULL),(916,56,12,NULL,NULL),(917,56,16,NULL,NULL),(918,56,29,NULL,NULL),(919,56,30,NULL,NULL),(920,56,35,NULL,NULL),(921,56,9,NULL,NULL),(922,56,20,NULL,NULL),(923,56,33,NULL,NULL),(924,57,14,NULL,NULL),(925,57,22,NULL,NULL),(926,57,23,NULL,NULL),(927,57,45,NULL,NULL),(928,57,2,NULL,NULL),(929,57,4,NULL,NULL),(930,57,6,NULL,NULL),(931,57,19,NULL,NULL),(932,57,7,NULL,NULL),(933,57,10,NULL,NULL),(934,57,11,NULL,NULL),(935,57,12,NULL,NULL),(936,57,16,NULL,NULL),(937,57,28,NULL,NULL),(938,57,29,NULL,NULL),(939,57,30,NULL,NULL),(940,57,32,NULL,NULL),(941,57,5,NULL,NULL),(942,57,21,NULL,NULL),(943,57,33,NULL,NULL),(944,57,37,NULL,NULL),(945,57,39,NULL,NULL),(946,57,41,NULL,NULL),(947,57,42,NULL,NULL),(948,58,14,NULL,NULL),(949,58,23,NULL,NULL),(950,58,47,NULL,NULL),(951,58,1,NULL,NULL),(952,58,4,NULL,NULL),(953,58,6,NULL,NULL),(954,58,8,NULL,NULL),(955,58,7,NULL,NULL),(956,58,10,NULL,NULL),(957,58,16,NULL,NULL),(958,58,34,NULL,NULL),(959,58,35,NULL,NULL),(960,58,38,NULL,NULL),(961,58,40,NULL,NULL),(962,58,43,NULL,NULL),(963,59,13,NULL,NULL),(964,59,14,NULL,NULL),(965,59,22,NULL,NULL),(966,59,47,NULL,NULL),(967,59,1,NULL,NULL),(968,59,8,NULL,NULL),(969,59,10,NULL,NULL),(970,59,18,NULL,NULL),(971,60,13,NULL,NULL),(972,60,14,NULL,NULL),(973,60,23,NULL,NULL),(974,60,45,NULL,NULL),(975,60,1,NULL,NULL),(976,60,2,NULL,NULL),(977,60,8,NULL,NULL),(978,60,19,NULL,NULL),(979,60,10,NULL,NULL),(980,60,15,NULL,NULL),(981,60,16,NULL,NULL),(982,60,18,NULL,NULL),(983,60,28,NULL,NULL),(984,60,30,NULL,NULL),(985,61,13,NULL,NULL),(986,61,22,NULL,NULL),(987,61,45,NULL,NULL),(988,61,46,NULL,NULL),(989,61,47,NULL,NULL),(990,61,2,NULL,NULL),(991,61,6,NULL,NULL),(992,61,8,NULL,NULL),(993,61,19,NULL,NULL),(994,61,11,NULL,NULL),(995,61,17,NULL,NULL),(996,61,18,NULL,NULL),(997,61,34,NULL,NULL),(998,62,13,NULL,NULL),(999,62,14,NULL,NULL),(1000,62,22,NULL,NULL),(1001,62,20,NULL,NULL),(1002,62,21,NULL,NULL),(1003,62,27,NULL,NULL),(1004,62,33,NULL,NULL),(1005,62,10,NULL,NULL),(1006,62,11,NULL,NULL),(1007,62,12,NULL,NULL),(1008,62,16,NULL,NULL),(1009,62,17,NULL,NULL),(1010,62,18,NULL,NULL),(1011,62,29,NULL,NULL),(1012,62,34,NULL,NULL),(1013,62,35,NULL,NULL),(1014,62,39,NULL,NULL),(1015,62,41,NULL,NULL),(1016,62,37,NULL,NULL),(1017,62,42,NULL,NULL),(1018,62,43,NULL,NULL),(1019,63,45,NULL,NULL),(1020,63,46,NULL,NULL),(1021,63,47,NULL,NULL),(1022,63,1,NULL,NULL),(1023,63,2,NULL,NULL),(1024,63,6,NULL,NULL),(1025,63,8,NULL,NULL),(1026,63,7,NULL,NULL),(1027,63,11,NULL,NULL),(1028,63,12,NULL,NULL),(1029,63,16,NULL,NULL),(1030,63,31,NULL,NULL),(1031,63,32,NULL,NULL),(1032,63,25,NULL,NULL),(1033,64,13,NULL,NULL),(1034,64,14,NULL,NULL),(1035,64,45,NULL,NULL),(1036,64,4,NULL,NULL),(1037,64,6,NULL,NULL),(1038,64,8,NULL,NULL),(1039,64,19,NULL,NULL),(1040,64,10,NULL,NULL),(1041,64,12,NULL,NULL),(1042,64,16,NULL,NULL),(1043,64,18,NULL,NULL),(1044,64,30,NULL,NULL),(1045,64,31,NULL,NULL),(1046,64,32,NULL,NULL),(1047,65,13,NULL,NULL),(1048,65,22,NULL,NULL),(1049,65,47,NULL,NULL),(1050,65,5,NULL,NULL),(1051,65,20,NULL,NULL),(1052,65,21,NULL,NULL),(1053,65,25,NULL,NULL),(1054,65,27,NULL,NULL),(1055,65,33,NULL,NULL),(1056,65,10,NULL,NULL),(1057,65,11,NULL,NULL),(1058,65,12,NULL,NULL),(1059,65,17,NULL,NULL),(1060,65,29,NULL,NULL),(1061,65,31,NULL,NULL),(1062,65,32,NULL,NULL),(1063,65,34,NULL,NULL),(1064,65,35,NULL,NULL),(1065,65,41,NULL,NULL),(1066,65,42,NULL,NULL),(1067,65,43,NULL,NULL),(1068,66,14,NULL,NULL),(1069,66,23,NULL,NULL),(1070,66,46,NULL,NULL),(1071,66,47,NULL,NULL),(1072,66,4,NULL,NULL),(1073,66,7,NULL,NULL),(1074,66,16,NULL,NULL),(1075,67,13,NULL,NULL),(1076,67,14,NULL,NULL),(1077,67,22,NULL,NULL),(1078,67,46,NULL,NULL),(1079,67,1,NULL,NULL),(1080,67,2,NULL,NULL),(1081,67,8,NULL,NULL),(1082,67,19,NULL,NULL),(1083,67,10,NULL,NULL),(1084,67,11,NULL,NULL),(1085,67,12,NULL,NULL),(1086,67,16,NULL,NULL),(1087,67,32,NULL,NULL),(1088,67,35,NULL,NULL),(1089,67,5,NULL,NULL),(1090,67,21,NULL,NULL),(1091,67,33,NULL,NULL),(1092,67,39,NULL,NULL),(1093,67,40,NULL,NULL),(1094,67,41,NULL,NULL),(1095,67,42,NULL,NULL),(1096,68,22,NULL,NULL),(1097,68,23,NULL,NULL),(1098,68,45,NULL,NULL),(1099,68,47,NULL,NULL),(1100,68,4,NULL,NULL),(1101,68,8,NULL,NULL),(1102,68,7,NULL,NULL),(1103,68,10,NULL,NULL),(1104,68,12,NULL,NULL),(1105,68,17,NULL,NULL),(1106,68,34,NULL,NULL),(1107,68,39,NULL,NULL),(1108,68,43,NULL,NULL),(1109,69,23,NULL,NULL),(1110,69,45,NULL,NULL),(1111,69,46,NULL,NULL),(1112,69,47,NULL,NULL),(1113,69,1,NULL,NULL),(1114,69,4,NULL,NULL),(1115,69,10,NULL,NULL),(1116,69,16,NULL,NULL),(1117,69,17,NULL,NULL),(1118,69,28,NULL,NULL),(1119,69,29,NULL,NULL),(1120,69,35,NULL,NULL),(1121,70,22,NULL,NULL),(1122,70,45,NULL,NULL),(1123,70,47,NULL,NULL),(1124,70,1,NULL,NULL),(1125,70,2,NULL,NULL),(1126,70,4,NULL,NULL),(1127,70,6,NULL,NULL),(1128,70,8,NULL,NULL),(1129,70,7,NULL,NULL),(1130,70,12,NULL,NULL),(1131,70,15,NULL,NULL),(1132,70,18,NULL,NULL),(1133,70,29,NULL,NULL),(1134,70,32,NULL,NULL),(1135,70,35,NULL,NULL),(1136,70,3,NULL,NULL),(1137,70,25,NULL,NULL),(1138,71,13,NULL,NULL),(1139,71,22,NULL,NULL),(1140,71,45,NULL,NULL),(1141,71,47,NULL,NULL),(1142,71,2,NULL,NULL),(1143,71,4,NULL,NULL),(1144,71,6,NULL,NULL),(1145,71,19,NULL,NULL),(1146,71,11,NULL,NULL),(1147,71,12,NULL,NULL),(1148,71,15,NULL,NULL),(1149,71,16,NULL,NULL),(1150,71,17,NULL,NULL),(1151,71,30,NULL,NULL),(1152,71,31,NULL,NULL),(1153,71,35,NULL,NULL),(1154,71,5,NULL,NULL),(1155,71,39,NULL,NULL),(1156,71,41,NULL,NULL),(1157,72,13,NULL,NULL),(1158,72,22,NULL,NULL),(1159,72,47,NULL,NULL),(1160,72,1,NULL,NULL),(1161,72,2,NULL,NULL),(1162,72,6,NULL,NULL),(1163,72,8,NULL,NULL),(1164,72,19,NULL,NULL),(1165,72,7,NULL,NULL),(1166,72,16,NULL,NULL),(1167,72,17,NULL,NULL),(1168,72,28,NULL,NULL),(1169,72,29,NULL,NULL),(1170,72,30,NULL,NULL),(1171,72,35,NULL,NULL),(1172,72,3,NULL,NULL),(1173,72,9,NULL,NULL),(1174,72,21,NULL,NULL),(1175,73,13,NULL,NULL),(1176,73,14,NULL,NULL),(1177,73,23,NULL,NULL),(1178,73,45,NULL,NULL),(1179,73,1,NULL,NULL),(1180,73,4,NULL,NULL),(1181,73,8,NULL,NULL),(1182,73,7,NULL,NULL),(1183,73,18,NULL,NULL),(1184,73,35,NULL,NULL),(1185,73,38,NULL,NULL),(1186,73,39,NULL,NULL),(1187,74,13,NULL,NULL),(1188,74,14,NULL,NULL),(1189,74,22,NULL,NULL),(1190,74,23,NULL,NULL),(1191,74,45,NULL,NULL),(1192,74,19,NULL,NULL),(1193,74,11,NULL,NULL),(1194,75,13,NULL,NULL),(1195,75,23,NULL,NULL),(1196,75,45,NULL,NULL),(1197,75,46,NULL,NULL),(1198,75,3,NULL,NULL),(1199,75,9,NULL,NULL),(1200,75,21,NULL,NULL),(1201,75,25,NULL,NULL),(1202,75,27,NULL,NULL),(1203,75,33,NULL,NULL),(1204,75,7,NULL,NULL),(1205,75,10,NULL,NULL),(1206,75,11,NULL,NULL),(1207,75,12,NULL,NULL),(1208,75,15,NULL,NULL),(1209,75,18,NULL,NULL),(1210,75,28,NULL,NULL),(1211,75,30,NULL,NULL),(1212,75,31,NULL,NULL),(1213,75,32,NULL,NULL),(1214,75,38,NULL,NULL),(1215,75,39,NULL,NULL),(1216,75,42,NULL,NULL),(1217,76,23,NULL,NULL),(1218,76,45,NULL,NULL),(1219,76,46,NULL,NULL),(1220,76,47,NULL,NULL),(1221,76,2,NULL,NULL),(1222,76,4,NULL,NULL),(1223,76,6,NULL,NULL),(1224,76,19,NULL,NULL),(1225,76,7,NULL,NULL),(1226,76,12,NULL,NULL),(1227,76,17,NULL,NULL),(1228,76,18,NULL,NULL),(1229,76,28,NULL,NULL),(1230,76,38,NULL,NULL),(1231,76,39,NULL,NULL),(1232,76,40,NULL,NULL),(1233,76,42,NULL,NULL),(1234,77,13,NULL,NULL),(1235,77,23,NULL,NULL),(1236,77,45,NULL,NULL),(1237,77,46,NULL,NULL),(1238,77,9,NULL,NULL),(1239,77,20,NULL,NULL),(1240,77,21,NULL,NULL),(1241,77,27,NULL,NULL),(1242,77,10,NULL,NULL),(1243,77,11,NULL,NULL),(1244,77,12,NULL,NULL),(1245,77,15,NULL,NULL),(1246,77,17,NULL,NULL),(1247,77,18,NULL,NULL),(1248,77,29,NULL,NULL),(1249,77,30,NULL,NULL),(1250,77,31,NULL,NULL),(1251,77,34,NULL,NULL),(1252,77,35,NULL,NULL),(1253,77,37,NULL,NULL),(1254,77,39,NULL,NULL),(1255,77,40,NULL,NULL),(1256,77,42,NULL,NULL),(1257,78,13,NULL,NULL),(1258,78,14,NULL,NULL),(1259,78,23,NULL,NULL),(1260,78,45,NULL,NULL),(1261,78,2,NULL,NULL),(1262,78,4,NULL,NULL),(1263,78,19,NULL,NULL),(1264,78,7,NULL,NULL),(1265,78,15,NULL,NULL),(1266,78,16,NULL,NULL),(1267,78,30,NULL,NULL),(1268,78,34,NULL,NULL),(1269,78,37,NULL,NULL),(1270,78,40,NULL,NULL),(1271,78,42,NULL,NULL),(1272,79,13,NULL,NULL),(1273,79,14,NULL,NULL),(1274,79,23,NULL,NULL),(1275,79,46,NULL,NULL),(1276,79,47,NULL,NULL),(1277,79,3,NULL,NULL),(1278,79,9,NULL,NULL),(1279,79,20,NULL,NULL),(1280,79,25,NULL,NULL),(1281,79,33,NULL,NULL),(1282,79,7,NULL,NULL),(1283,79,10,NULL,NULL),(1284,79,11,NULL,NULL),(1285,79,12,NULL,NULL),(1286,79,18,NULL,NULL),(1287,79,28,NULL,NULL),(1288,79,29,NULL,NULL),(1289,79,31,NULL,NULL),(1290,79,32,NULL,NULL),(1291,79,34,NULL,NULL),(1292,79,37,NULL,NULL),(1293,79,43,NULL,NULL),(1294,80,13,NULL,NULL),(1295,80,22,NULL,NULL),(1296,80,23,NULL,NULL),(1297,80,46,NULL,NULL),(1298,80,47,NULL,NULL),(1299,80,3,NULL,NULL),(1300,80,20,NULL,NULL),(1301,80,27,NULL,NULL),(1302,80,33,NULL,NULL),(1303,80,10,NULL,NULL),(1304,80,11,NULL,NULL),(1305,80,12,NULL,NULL),(1306,80,15,NULL,NULL),(1307,80,28,NULL,NULL),(1308,80,29,NULL,NULL),(1309,80,30,NULL,NULL),(1310,80,32,NULL,NULL),(1311,80,35,NULL,NULL),(1312,80,37,NULL,NULL),(1313,80,39,NULL,NULL),(1314,80,40,NULL,NULL),(1315,80,41,NULL,NULL),(1316,81,13,NULL,NULL),(1317,81,22,NULL,NULL),(1318,81,46,NULL,NULL),(1319,81,1,NULL,NULL),(1320,81,4,NULL,NULL),(1321,81,6,NULL,NULL),(1322,81,19,NULL,NULL),(1323,81,7,NULL,NULL),(1324,81,10,NULL,NULL),(1325,81,12,NULL,NULL),(1326,81,15,NULL,NULL),(1327,81,18,NULL,NULL),(1328,81,28,NULL,NULL),(1329,81,30,NULL,NULL),(1330,81,35,NULL,NULL),(1331,81,3,NULL,NULL),(1332,81,27,NULL,NULL),(1333,82,14,NULL,NULL),(1334,82,22,NULL,NULL),(1335,82,23,NULL,NULL),(1336,82,45,NULL,NULL),(1337,82,46,NULL,NULL),(1338,82,4,NULL,NULL),(1339,82,6,NULL,NULL),(1340,82,8,NULL,NULL),(1341,82,19,NULL,NULL),(1342,82,10,NULL,NULL),(1343,82,11,NULL,NULL),(1344,82,12,NULL,NULL),(1345,82,18,NULL,NULL),(1346,82,28,NULL,NULL),(1347,82,34,NULL,NULL),(1348,82,35,NULL,NULL),(1349,83,22,NULL,NULL),(1350,83,23,NULL,NULL),(1351,83,45,NULL,NULL),(1352,83,46,NULL,NULL),(1353,83,2,NULL,NULL),(1354,83,6,NULL,NULL),(1355,83,8,NULL,NULL),(1356,83,19,NULL,NULL),(1357,83,11,NULL,NULL),(1358,83,12,NULL,NULL),(1359,83,15,NULL,NULL),(1360,83,17,NULL,NULL),(1361,83,18,NULL,NULL),(1362,83,28,NULL,NULL),(1363,83,30,NULL,NULL),(1364,83,32,NULL,NULL),(1365,83,3,NULL,NULL),(1366,83,5,NULL,NULL),(1367,84,13,NULL,NULL),(1368,84,22,NULL,NULL),(1369,84,23,NULL,NULL),(1370,84,46,NULL,NULL),(1371,84,5,NULL,NULL),(1372,84,9,NULL,NULL),(1373,84,20,NULL,NULL),(1374,84,21,NULL,NULL),(1375,84,25,NULL,NULL),(1376,84,7,NULL,NULL),(1377,84,12,NULL,NULL),(1378,84,15,NULL,NULL),(1379,84,16,NULL,NULL),(1380,84,17,NULL,NULL),(1381,84,18,NULL,NULL),(1382,84,31,NULL,NULL),(1383,84,32,NULL,NULL),(1384,84,34,NULL,NULL),(1385,84,35,NULL,NULL),(1386,84,37,NULL,NULL),(1387,84,38,NULL,NULL),(1388,84,41,NULL,NULL),(1389,84,43,NULL,NULL),(1390,85,13,NULL,NULL),(1391,85,14,NULL,NULL),(1392,85,23,NULL,NULL),(1393,85,45,NULL,NULL),(1394,85,2,NULL,NULL),(1395,85,4,NULL,NULL),(1396,85,6,NULL,NULL),(1397,85,8,NULL,NULL),(1398,85,12,NULL,NULL),(1399,85,15,NULL,NULL),(1400,85,18,NULL,NULL),(1401,85,35,NULL,NULL),(1402,86,13,NULL,NULL),(1403,86,23,NULL,NULL),(1404,86,47,NULL,NULL),(1405,86,3,NULL,NULL),(1406,86,21,NULL,NULL),(1407,86,25,NULL,NULL),(1408,86,27,NULL,NULL),(1409,86,7,NULL,NULL),(1410,86,11,NULL,NULL),(1411,86,12,NULL,NULL),(1412,86,17,NULL,NULL),(1413,86,18,NULL,NULL),(1414,86,29,NULL,NULL),(1415,86,31,NULL,NULL),(1416,86,32,NULL,NULL),(1417,86,34,NULL,NULL),(1418,86,35,NULL,NULL),(1419,86,38,NULL,NULL),(1420,86,41,NULL,NULL),(1421,86,42,NULL,NULL),(1422,87,13,NULL,NULL),(1423,87,22,NULL,NULL),(1424,87,45,NULL,NULL),(1425,87,47,NULL,NULL),(1426,87,1,NULL,NULL),(1427,87,4,NULL,NULL),(1428,87,6,NULL,NULL),(1429,87,8,NULL,NULL),(1430,87,19,NULL,NULL),(1431,87,11,NULL,NULL),(1432,87,12,NULL,NULL),(1433,87,15,NULL,NULL),(1434,87,16,NULL,NULL),(1435,87,28,NULL,NULL),(1436,87,29,NULL,NULL),(1437,87,30,NULL,NULL),(1438,87,3,NULL,NULL),(1439,87,27,NULL,NULL),(1440,88,13,NULL,NULL),(1441,88,22,NULL,NULL),(1442,88,45,NULL,NULL),(1443,88,46,NULL,NULL),(1444,88,47,NULL,NULL),(1445,88,2,NULL,NULL),(1446,88,4,NULL,NULL),(1447,88,6,NULL,NULL),(1448,88,8,NULL,NULL),(1449,88,19,NULL,NULL),(1450,88,10,NULL,NULL),(1451,88,15,NULL,NULL),(1452,88,16,NULL,NULL),(1453,88,17,NULL,NULL),(1454,88,28,NULL,NULL),(1455,88,30,NULL,NULL),(1456,88,31,NULL,NULL),(1457,88,34,NULL,NULL),(1458,88,5,NULL,NULL),(1459,88,9,NULL,NULL),(1460,89,13,NULL,NULL),(1461,89,14,NULL,NULL),(1462,89,23,NULL,NULL),(1463,89,45,NULL,NULL),(1464,89,47,NULL,NULL),(1465,89,3,NULL,NULL),(1466,89,5,NULL,NULL),(1467,89,9,NULL,NULL),(1468,89,20,NULL,NULL),(1469,89,21,NULL,NULL),(1470,89,27,NULL,NULL),(1471,89,7,NULL,NULL),(1472,89,15,NULL,NULL),(1473,89,16,NULL,NULL),(1474,89,18,NULL,NULL),(1475,89,29,NULL,NULL),(1476,89,30,NULL,NULL),(1477,89,31,NULL,NULL),(1478,89,32,NULL,NULL),(1479,89,35,NULL,NULL),(1480,89,39,NULL,NULL),(1481,89,42,NULL,NULL),(1482,89,43,NULL,NULL),(1483,90,13,NULL,NULL),(1484,90,14,NULL,NULL),(1485,90,22,NULL,NULL),(1486,90,45,NULL,NULL),(1487,90,2,NULL,NULL),(1488,90,4,NULL,NULL),(1489,90,19,NULL,NULL),(1490,90,7,NULL,NULL),(1491,90,10,NULL,NULL),(1492,90,16,NULL,NULL),(1493,90,17,NULL,NULL),(1494,90,31,NULL,NULL),(1495,90,35,NULL,NULL),(1496,91,14,NULL,NULL),(1497,91,22,NULL,NULL),(1498,91,23,NULL,NULL),(1499,91,46,NULL,NULL),(1500,91,1,NULL,NULL),(1501,91,2,NULL,NULL),(1502,91,6,NULL,NULL),(1503,91,7,NULL,NULL),(1504,91,10,NULL,NULL),(1505,91,11,NULL,NULL),(1506,91,12,NULL,NULL),(1507,91,16,NULL,NULL),(1508,91,28,NULL,NULL),(1509,91,29,NULL,NULL),(1510,91,32,NULL,NULL),(1511,91,35,NULL,NULL),(1512,91,21,NULL,NULL),(1513,91,25,NULL,NULL),(1514,92,13,NULL,NULL),(1515,92,14,NULL,NULL),(1516,92,23,NULL,NULL),(1517,92,47,NULL,NULL),(1518,92,1,NULL,NULL),(1519,92,8,NULL,NULL),(1520,92,7,NULL,NULL),(1521,92,12,NULL,NULL),(1522,92,16,NULL,NULL),(1523,92,18,NULL,NULL),(1524,92,29,NULL,NULL),(1525,92,34,NULL,NULL),(1526,92,35,NULL,NULL),(1527,92,37,NULL,NULL),(1528,92,39,NULL,NULL),(1529,93,14,NULL,NULL),(1530,93,23,NULL,NULL),(1531,93,45,NULL,NULL),(1532,93,46,NULL,NULL),(1533,93,47,NULL,NULL),(1534,93,1,NULL,NULL),(1535,93,2,NULL,NULL),(1536,93,4,NULL,NULL),(1537,93,8,NULL,NULL),(1538,93,7,NULL,NULL),(1539,93,10,NULL,NULL),(1540,93,15,NULL,NULL),(1541,93,16,NULL,NULL),(1542,93,17,NULL,NULL),(1543,93,31,NULL,NULL),(1544,93,34,NULL,NULL),(1545,93,35,NULL,NULL),(1546,93,27,NULL,NULL),(1547,93,33,NULL,NULL),(1548,94,22,NULL,NULL),(1549,94,23,NULL,NULL),(1550,94,45,NULL,NULL),(1551,94,47,NULL,NULL),(1552,94,5,NULL,NULL),(1553,94,25,NULL,NULL),(1554,94,27,NULL,NULL),(1555,94,33,NULL,NULL),(1556,94,11,NULL,NULL),(1557,94,12,NULL,NULL),(1558,94,16,NULL,NULL),(1559,94,17,NULL,NULL),(1560,94,29,NULL,NULL),(1561,94,31,NULL,NULL),(1562,94,32,NULL,NULL),(1563,94,38,NULL,NULL),(1564,94,40,NULL,NULL),(1565,94,42,NULL,NULL),(1566,94,43,NULL,NULL),(1567,94,39,NULL,NULL),(1568,95,13,NULL,NULL),(1569,95,14,NULL,NULL),(1570,95,47,NULL,NULL),(1571,95,1,NULL,NULL),(1572,95,2,NULL,NULL),(1573,95,4,NULL,NULL),(1574,95,8,NULL,NULL),(1575,95,19,NULL,NULL),(1576,95,7,NULL,NULL),(1577,95,11,NULL,NULL),(1578,95,15,NULL,NULL),(1579,95,17,NULL,NULL),(1580,95,29,NULL,NULL),(1581,95,30,NULL,NULL),(1582,95,27,NULL,NULL),(1583,95,37,NULL,NULL),(1584,95,38,NULL,NULL),(1585,95,39,NULL,NULL),(1586,95,43,NULL,NULL),(1587,96,14,NULL,NULL),(1588,96,22,NULL,NULL),(1589,96,23,NULL,NULL),(1590,96,46,NULL,NULL),(1591,96,5,NULL,NULL),(1592,96,21,NULL,NULL),(1593,96,25,NULL,NULL),(1594,96,33,NULL,NULL),(1595,96,10,NULL,NULL),(1596,96,11,NULL,NULL),(1597,96,15,NULL,NULL),(1598,96,16,NULL,NULL),(1599,96,17,NULL,NULL),(1600,96,18,NULL,NULL),(1601,96,28,NULL,NULL),(1602,96,29,NULL,NULL),(1603,96,31,NULL,NULL),(1604,96,35,NULL,NULL),(1605,96,37,NULL,NULL),(1606,96,40,NULL,NULL),(1607,96,43,NULL,NULL),(1608,97,14,NULL,NULL),(1609,97,22,NULL,NULL),(1610,97,45,NULL,NULL),(1611,97,46,NULL,NULL),(1612,97,47,NULL,NULL),(1613,97,4,NULL,NULL),(1614,97,6,NULL,NULL),(1615,97,11,NULL,NULL),(1616,97,12,NULL,NULL),(1617,97,37,NULL,NULL),(1618,97,38,NULL,NULL),(1619,97,42,NULL,NULL),(1620,97,43,NULL,NULL),(1621,98,14,NULL,NULL),(1622,98,22,NULL,NULL),(1623,98,23,NULL,NULL),(1624,98,46,NULL,NULL),(1625,98,47,NULL,NULL),(1626,98,1,NULL,NULL),(1627,98,8,NULL,NULL),(1628,98,15,NULL,NULL),(1629,98,18,NULL,NULL),(1630,99,13,NULL,NULL),(1631,99,14,NULL,NULL),(1632,99,22,NULL,NULL),(1633,99,46,NULL,NULL),(1634,99,47,NULL,NULL),(1635,99,8,NULL,NULL),(1636,99,19,NULL,NULL),(1637,99,7,NULL,NULL),(1638,99,11,NULL,NULL),(1639,99,12,NULL,NULL),(1640,99,16,NULL,NULL),(1641,99,28,NULL,NULL),(1642,99,30,NULL,NULL),(1643,99,35,NULL,NULL),(1644,99,41,NULL,NULL),(1645,99,42,NULL,NULL),(1646,100,14,NULL,NULL),(1647,100,23,NULL,NULL),(1648,100,46,NULL,NULL),(1649,100,47,NULL,NULL),(1650,100,8,NULL,NULL),(1651,100,10,NULL,NULL),(1652,100,38,NULL,NULL),(1653,100,40,NULL,NULL),(1654,100,41,NULL,NULL),(1655,100,42,NULL,NULL);
/*!40000 ALTER TABLE `cr_cars_amenities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_categories`
--

DROP TABLE IF EXISTS `cr_cars_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_category_id` bigint unsigned DEFAULT NULL,
  `cr_car_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_cars_categories_cr_car_category_id_index` (`cr_car_category_id`),
  KEY `cr_cars_categories_cr_car_id_index` (`cr_car_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_categories`
--

LOCK TABLES `cr_cars_categories` WRITE;
/*!40000 ALTER TABLE `cr_cars_categories` DISABLE KEYS */;
INSERT INTO `cr_cars_categories` VALUES (1,5,21),(2,1,27),(3,3,30),(4,5,66),(5,5,82),(6,1,6),(7,3,7),(8,2,39),(9,4,40),(10,1,72),(11,3,73),(12,2,86),(13,5,89),(14,5,91),(15,1,16),(16,3,49),(17,5,53),(18,4,52),(19,1,60),(20,5,78),(21,5,1),(22,3,2),(23,3,10),(24,3,14),(25,4,23),(26,5,28),(27,1,36),(28,4,44),(29,5,70),(30,3,85),(31,1,5),(32,5,26),(33,1,50),(34,3,59),(35,5,68),(36,4,69),(37,2,75),(38,2,98),(39,4,11),(40,4,25),(41,4,31),(42,2,32),(43,4,38),(44,2,41),(45,4,47),(46,3,55),(47,1,83),(48,1,90),(49,2,96),(50,4,99),(51,1,100),(52,3,4),(53,4,8),(54,4,15),(55,4,19),(56,5,24),(57,2,56),(58,2,64),(59,1,94),(60,2,95),(61,3,3),(62,4,9),(63,2,12),(64,1,13),(65,2,48),(66,4,57),(67,3,61),(68,5,65),(69,4,84),(70,4,18),(71,4,33),(72,1,37),(73,5,54),(74,1,63),(75,1,67),(76,3,71),(77,1,74),(78,1,76),(79,1,77),(80,1,79),(81,1,92),(82,4,29),(83,1,46),(84,2,51),(85,4,58),(86,3,17),(87,1,20),(88,4,22),(89,1,34),(90,4,35),(91,2,43),(92,4,80),(93,3,81),(94,4,42),(95,3,45),(96,4,62),(97,5,87),(98,4,88),(99,5,93),(100,5,97);
/*!40000 ALTER TABLE `cr_cars_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_colors`
--

DROP TABLE IF EXISTS `cr_cars_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_colors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cr_car_id` bigint unsigned NOT NULL,
  `cr_car_color_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_colors`
--

LOCK TABLES `cr_cars_colors` WRITE;
/*!40000 ALTER TABLE `cr_cars_colors` DISABLE KEYS */;
INSERT INTO `cr_cars_colors` VALUES (1,1,4,NULL,NULL),(2,2,4,NULL,NULL),(3,3,5,NULL,NULL),(4,4,4,NULL,NULL),(5,5,3,NULL,NULL),(6,6,3,NULL,NULL),(7,7,1,NULL,NULL),(8,8,5,NULL,NULL),(9,9,1,NULL,NULL),(10,10,4,NULL,NULL),(11,11,5,NULL,NULL),(12,12,6,NULL,NULL),(13,13,1,NULL,NULL),(14,14,5,NULL,NULL),(15,15,4,NULL,NULL),(16,16,3,NULL,NULL),(17,17,3,NULL,NULL),(18,18,1,NULL,NULL),(19,19,5,NULL,NULL),(20,20,6,NULL,NULL),(21,21,5,NULL,NULL),(22,22,4,NULL,NULL),(23,23,1,NULL,NULL),(24,24,6,NULL,NULL),(25,25,3,NULL,NULL),(26,26,1,NULL,NULL),(27,27,2,NULL,NULL),(28,28,4,NULL,NULL),(29,29,5,NULL,NULL),(30,30,4,NULL,NULL),(31,31,5,NULL,NULL),(32,32,2,NULL,NULL),(33,33,3,NULL,NULL),(34,34,3,NULL,NULL),(35,35,5,NULL,NULL),(36,36,5,NULL,NULL),(37,37,2,NULL,NULL),(38,38,5,NULL,NULL),(39,39,1,NULL,NULL),(40,40,4,NULL,NULL),(41,41,3,NULL,NULL),(42,42,2,NULL,NULL),(43,43,1,NULL,NULL),(44,44,2,NULL,NULL),(45,45,5,NULL,NULL),(46,46,1,NULL,NULL),(47,47,2,NULL,NULL),(48,48,2,NULL,NULL),(49,49,2,NULL,NULL),(50,50,2,NULL,NULL),(51,51,3,NULL,NULL),(52,52,2,NULL,NULL),(53,53,1,NULL,NULL),(54,54,1,NULL,NULL),(55,55,6,NULL,NULL),(56,56,2,NULL,NULL),(57,57,2,NULL,NULL),(58,58,4,NULL,NULL),(59,59,5,NULL,NULL),(60,60,1,NULL,NULL),(61,61,3,NULL,NULL),(62,62,5,NULL,NULL),(63,63,3,NULL,NULL),(64,64,6,NULL,NULL),(65,65,2,NULL,NULL),(66,66,1,NULL,NULL),(67,67,4,NULL,NULL),(68,68,6,NULL,NULL),(69,69,6,NULL,NULL),(70,70,5,NULL,NULL),(71,71,2,NULL,NULL),(72,72,6,NULL,NULL),(73,73,5,NULL,NULL),(74,74,1,NULL,NULL),(75,75,3,NULL,NULL),(76,76,2,NULL,NULL),(77,77,1,NULL,NULL),(78,78,6,NULL,NULL),(79,79,4,NULL,NULL),(80,80,2,NULL,NULL),(81,81,3,NULL,NULL),(82,82,3,NULL,NULL),(83,83,5,NULL,NULL),(84,84,2,NULL,NULL),(85,85,5,NULL,NULL),(86,86,1,NULL,NULL),(87,87,4,NULL,NULL),(88,88,6,NULL,NULL),(89,89,2,NULL,NULL),(90,90,6,NULL,NULL),(91,91,3,NULL,NULL),(92,92,5,NULL,NULL),(93,93,5,NULL,NULL),(94,94,3,NULL,NULL),(95,95,5,NULL,NULL),(96,96,3,NULL,NULL),(97,97,5,NULL,NULL),(98,98,6,NULL,NULL),(99,99,1,NULL,NULL),(100,100,4,NULL,NULL);
/*!40000 ALTER TABLE `cr_cars_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_cars_translations`
--

DROP TABLE IF EXISTS `cr_cars_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_cars_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_cars_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_cars_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_cars_translations`
--

LOCK TABLES `cr_cars_translations` WRITE;
/*!40000 ALTER TABLE `cr_cars_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_cars_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_category_commissions`
--

DROP TABLE IF EXISTS `cr_category_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_category_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_category_commissions`
--

LOCK TABLES `cr_category_commissions` WRITE;
/*!40000 ALTER TABLE `cr_category_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_category_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_coupons`
--

DROP TABLE IF EXISTS `cr_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` double NOT NULL,
  `is_unlimited_expires` tinyint NOT NULL DEFAULT '0',
  `expires_at` datetime DEFAULT NULL,
  `is_unlimited` tinyint NOT NULL DEFAULT '1',
  `limit` int NOT NULL DEFAULT '0',
  `used` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_coupons_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_coupons`
--

LOCK TABLES `cr_coupons` WRITE;
/*!40000 ALTER TABLE `cr_coupons` DISABLE KEYS */;
INSERT INTO `cr_coupons` VALUES (1,'IRZfFlmJPPD1','money',1,0,'2025-12-18 04:10:24',1,0,10,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Fi83VVxm4CaD','money',8,0,'2026-01-18 04:10:24',0,797,105,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'OvYRDIo67yya','money',1,0,'2026-02-18 04:10:24',0,286,38,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'SdZY606Eh8zJ','percentage',69.39,0,'2026-03-18 04:10:24',1,0,59,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'SUxQcmYE2SEd','money',1,1,NULL,1,0,62,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'sBVSMG2sLEpR','percentage',34.62,0,'2026-04-18 04:10:24',0,250,71,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(7,'nOk2ogJBM01y','percentage',93.14,0,'2026-05-18 04:10:24',1,0,25,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(8,'3rdXFVopSsYA','percentage',18.32,1,NULL,0,850,12,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(9,'Bo1jesd9CA1a','money',4,0,'2026-06-18 04:10:24',0,185,112,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(10,'HlPfvoJ8kFYO','percentage',29.27,0,'2026-07-18 04:10:24',1,0,11,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(11,'IJEX8gJk1Beb','percentage',30.19,0,'2026-08-18 04:10:24',0,646,44,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(12,'omH1dx1GL6N1','money',7,0,'2026-09-18 04:10:24',1,0,92,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(13,'CxOC1A05Zzmq','money',4,0,'2026-10-18 04:10:24',0,111,108,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(14,'PkphhAlVz7MH','money',1,0,'2026-11-18 04:10:24',1,0,105,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(15,'ya8CGy1BtB5x','money',4,1,NULL,0,911,24,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(16,'8ixZ0EvY3T1x','money',2,1,NULL,0,594,46,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(17,'1s9OUkk5uIqB','money',4,0,'2026-12-18 04:10:24',1,0,91,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(18,'VKfVQwtOLR6x','percentage',56.99,1,NULL,1,0,72,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(19,'OLDeN0HWLuqY','money',5,1,NULL,0,192,92,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(20,'t7qlaCKvGTUZ','money',7,1,NULL,1,0,96,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(21,'tzZmnIkwvg2p','percentage',42.54,0,'2027-01-18 04:10:24',0,419,21,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(22,'AIj19Vw1uZEZ','money',2,1,NULL,1,0,59,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(23,'D4KUs5j1X9tq','percentage',6.37,1,NULL,1,0,95,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(24,'8myVlgxc8Cha','percentage',13.67,1,NULL,1,0,67,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(25,'Qn1QyMzMC1cz','money',0,0,'2027-02-18 04:10:24',1,0,111,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(26,'9pReetJrJoiZ','percentage',65.78,1,NULL,0,479,41,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(27,'w4sx8cBl8RYD','money',7,1,NULL,0,981,84,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(28,'tyFgheD2YmzP','percentage',10.58,1,NULL,1,0,110,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(29,'OfaD3N8CCGYK','money',8,0,'2027-03-18 04:10:24',1,0,27,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(30,'XP0wuX1rwXG8','percentage',70.85,0,'2027-04-18 04:10:24',0,374,16,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(31,'AFEAIFRlzl6g','percentage',74.33,1,NULL,0,814,23,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_currencies`
--

DROP TABLE IF EXISTS `cr_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `number_format_style` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'western',
  `space_between_price_and_currency` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_currencies`
--

LOCK TABLES `cr_currencies` WRITE;
/*!40000 ALTER TABLE `cr_currencies` DISABLE KEYS */;
INSERT INTO `cr_currencies` VALUES (1,'USD','$',1,0,0,1,1,'western',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'EUR','€',0,0,1,0,0.84,'western',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'VND','₫',0,0,2,0,23203,'western',0,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'NGN','₦',1,0,2,0,895.52,'western',0,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_password_resets`
--

DROP TABLE IF EXISTS `cr_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `cr_customer_password_resets_email_index` (`email`),
  KEY `cr_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_password_resets`
--

LOCK TABLES `cr_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `cr_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_revenues`
--

DROP TABLE IF EXISTS `cr_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `booking_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) NOT NULL,
  `fee` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `current_balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add-amount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_revenues`
--

LOCK TABLES `cr_customer_revenues` WRITE;
/*!40000 ALTER TABLE `cr_customer_revenues` DISABLE KEYS */;
INSERT INTO `cr_customer_revenues` VALUES (1,2,1,196.00,39.20,156.80,156.80,'USD','Earnings from booking ##1000002 for Fiat 500X Sport AWD 2024',NULL,'booking-completed','2025-11-13 21:11:20','2025-11-13 21:11:20'),(2,5,2,219.60,43.92,175.68,175.68,'USD','Earnings from booking ##1000003 for Peugeot 308 GT Premium 2024',NULL,'booking-completed','2025-09-20 21:11:20','2025-09-20 21:11:20'),(3,16,3,68.40,13.68,54.72,54.72,'USD','Earnings from booking ##1000004 for Mercedes-Benz E450 4MATIC All-Terrain 2024',NULL,'booking-completed','2025-09-20 21:11:20','2025-09-20 21:11:20'),(4,2,4,44.10,8.82,35.28,192.08,'USD','Earnings from booking ##1000005 for Fiat 500X Sport AWD 2024',NULL,'booking-completed','2025-10-05 21:11:20','2025-10-05 21:11:20'),(5,4,5,234.00,46.80,187.20,187.20,'USD','Earnings from booking ##1000006 for Porsche 911 Carrera S 2024',NULL,'booking-completed','2025-10-21 21:11:20','2025-10-21 21:11:20'),(6,4,6,475.00,95.00,380.00,567.20,'USD','Earnings from booking ##1000007 for Volkswagen Tiguan SEL R-Line 2024',NULL,'booking-completed','2025-10-04 21:11:20','2025-10-04 21:11:20'),(7,7,7,170.00,34.00,136.00,136.00,'USD','Earnings from booking ##1000008 for Smart EQ fortwo Prime 2024',NULL,'booking-completed','2025-10-23 21:11:20','2025-10-23 21:11:20'),(8,11,11,491.40,98.28,393.12,393.12,'USD','Earnings from booking ##1000012 for Audi RS Q8 quattro 2024',NULL,'booking-completed','2025-11-11 21:11:20','2025-11-11 21:11:20'),(9,20,12,64.00,12.80,51.20,51.20,'USD','Earnings from booking ##1000013 for Chrysler Pacifica Pinnacle AWD 2024',NULL,'booking-completed','2025-10-03 21:11:20','2025-10-03 21:11:20'),(10,7,14,34.00,6.80,27.20,163.20,'USD','Earnings from booking ##1000015 for Smart EQ fortwo Prime 2024',NULL,'booking-completed','2025-10-11 21:11:20','2025-10-11 21:11:20'),(11,16,15,343.00,68.60,274.40,329.12,'USD','Earnings from booking ##1000016 for Porsche Cayenne Turbo GT 2024',NULL,'booking-completed','2025-10-19 21:11:20','2025-10-19 21:11:20'),(12,16,22,147.00,29.40,117.60,446.72,'USD','Earnings from booking ##1000023 for Porsche Cayenne Turbo GT 2024',NULL,'booking-completed','2025-09-25 21:11:20','2025-09-25 21:11:20'),(13,15,23,162.00,32.40,129.60,129.60,'USD','Earnings from booking ##1000024 for Ford GT Heritage Edition 2024',NULL,'booking-completed','2025-11-15 21:11:20','2025-11-15 21:11:20'),(14,16,25,76.00,15.20,60.80,507.52,'USD','Earnings from booking ##1000026 for Mercedes-Benz E450 4MATIC All-Terrain 2024',NULL,'booking-completed','2025-10-18 21:11:20','2025-10-18 21:11:20'),(15,18,27,582.00,116.40,465.60,465.60,'USD','Earnings from booking ##1000028 for Porsche Taycan Turbo S Cross Turismo 2024',NULL,'booking-completed','2025-10-31 21:11:20','2025-10-31 21:11:20'),(16,13,35,360.00,72.00,288.00,288.00,'USD','Earnings from booking ##1000036 for BMW X5 xDrive40i M Sport 2024',NULL,'booking-completed','2025-11-11 21:11:21','2025-11-11 21:11:21'),(17,9,37,49.00,9.80,39.20,39.20,'USD','Earnings from booking ##1000038 for Lexus LX 600 Ultra Luxury 2024',NULL,'booking-completed','2025-11-16 21:11:21','2025-11-16 21:11:21'),(18,18,42,291.00,58.20,232.80,698.40,'USD','Earnings from booking ##1000043 for Porsche Taycan Turbo S Cross Turismo 2024',NULL,'booking-completed','2025-11-10 21:11:21','2025-11-10 21:11:21'),(19,20,46,384.00,76.80,307.20,358.40,'USD','Earnings from booking ##1000047 for Chrysler Pacifica Pinnacle AWD 2024',NULL,'booking-completed','2025-11-13 21:11:21','2025-11-13 21:11:21');
/*!40000 ALTER TABLE `cr_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customer_withdrawals`
--

DROP TABLE IF EXISTS `cr_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `fee` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `current_balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customer_withdrawals`
--

LOCK TABLES `cr_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `cr_customer_withdrawals` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_customers`
--

DROP TABLE IF EXISTS `cr_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `is_verified` tinyint(1) NOT NULL DEFAULT '0',
  `verified_at` timestamp NULL DEFAULT NULL,
  `verified_by` bigint unsigned DEFAULT NULL,
  `verification_note` text COLLATE utf8mb4_unicode_ci,
  `vendor_verified_at` datetime DEFAULT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `bank_info` json DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_customers`
--

LOCK TABLES `cr_customers` WRITE;
/*!40000 ALTER TABLE `cr_customers` DISABLE KEYS */;
INSERT INTO `cr_customers` VALUES (1,'Elite Auto Group','margaret41@wehner.biz','$2y$12$Uk.tzOipehoxJs2gpLFJ9uIC69.LipDATRqWdkLLyFiaswNdTUMIO','customers/12.jpg','+19293851280','+19293851280',NULL,'published',NULL,'2025-11-18 04:10:16',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-07-09 12:59:45',1,'Certified dealer','2024-12-29 12:43:43',0.00,NULL,NULL),(2,'Premier Motors','stephanie.kihn@kreiger.org','$2y$12$FN/3Plhk4HNiY7MG2OjYH.OioY9uh0GEqhqh.JQJZKDToq3nep8/6','customers/13.jpg','+16788815764','+16788815764',NULL,'published',NULL,'2025-11-18 04:10:16',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,0,NULL,NULL,NULL,NULL,192.08,NULL,NULL),(3,'Luxury Car Rentals','padberg.eliseo@willms.biz','$2y$12$fqJ2UorjCoroegW1mZa0t.S4AAbqO5wca7Rhr0MG/bIHhD9j28rGW','customers/14.jpg','+15622684315','+15622684315',NULL,'published',NULL,'2025-11-18 04:10:17',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(4,'City Drive Solutions','kris85@funk.org','$2y$12$bqz2dIpwZxVJB8RsSJ.7IuGd21MqvYCe17PigkOuG8OVMAckrb8Ry','customers/15.jpg','+18783768863','+18783768863',NULL,'published',NULL,'2025-11-18 04:10:17',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,0,NULL,NULL,NULL,NULL,567.20,NULL,NULL),(5,'Express Auto Dealers','ufeeney@kshlerin.biz','$2y$12$0iWVRf15mWxOxlnEoLOxluY7AmleOiwZTs.Wey9rIuV2QMcfalNsm','customers/16.jpg','+12316144068','+12316144068',NULL,'published',NULL,'2025-11-18 04:10:17',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,1,'2025-07-15 17:30:36',1,'Certified dealer','2024-12-12 10:03:10',175.68,NULL,NULL),(6,'Summit Car Company','patience25@koch.com','$2y$12$RDEG3jn8d8RUZwMGynF4z.c6Mo/hm8DcLJltb8/y3nG10bZ0G10/i','customers/17.jpg','+14057803506','+14057803506',NULL,'published',NULL,'2025-11-18 04:10:17',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-09-17 00:06:34',1,'Verified dealership','2025-08-07 07:15:27',0.00,NULL,NULL),(7,'Horizon Automotive','dstehr@pouros.com','$2y$12$XI4K12OWfMeotLAtHWQRa.b2LS/slEOZugHbcesuNU2tz7Hn4mz1i','customers/18.jpg','+18386839058','+18386839058',NULL,'published',NULL,'2025-11-18 04:10:18',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,1,'2025-11-05 15:17:48',1,'Premium vendor account','2025-10-11 22:47:26',163.20,NULL,NULL),(8,'Prestige Vehicles','zola04@lind.com','$2y$12$fC5nBqYDCraNjSowrp2UuuobTBHyZ/DIYkiL8g61VbKcQV/qpXkQi','customers/19.jpg','+15403679921','+15403679921',NULL,'published',NULL,'2025-11-18 04:10:18',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-07-01 00:28:01',1,'Verified dealership','2025-07-08 20:50:34',0.00,NULL,NULL),(9,'Metro Car Center','cartwright.burnice@emmerich.info','$2y$12$w8ldbY0SxeSP3GsTYm2XuuhHXiSsqhdS2ojAppjG8vIud9dOo4AeS','customers/20.jpg','+15314073855','+15314073855',NULL,'published',NULL,'2025-11-18 04:10:18',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:21',1,1,'2025-08-01 10:23:39',1,'Verified dealership','2025-08-20 02:35:52',39.20,NULL,NULL),(10,'Global Auto Partners','ruben80@barrows.net','$2y$12$2FezwvTvbPDdcFazbLIQVuYTXQn/1db.g7QoMnDYNB/swM5DJPAw6','customers/21.jpg','+13855071258','+13855071258',NULL,'published',NULL,'2025-11-18 04:10:18',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-06-18 00:51:05',1,'Premium vendor account','2025-03-12 00:39:58',0.00,NULL,NULL),(11,'Royal Motors Group','whammes@howell.org','$2y$12$yGvdxiiSoYk5G5t2.U1r2eOLqNNW3.OZoW8p7KonMozyyusNpgTlm','customers/22.jpg','+15057862463','+15057862463',NULL,'published',NULL,'2025-11-18 04:10:19',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,1,'2025-09-21 07:35:02',1,'Authorized car dealer','2025-09-09 00:08:27',393.12,NULL,NULL),(12,'Diamond Car Dealers','jackson63@green.net','$2y$12$sLeZ38QYiJGcgnWUfMopnO.JhC40XvXRBarArUOHRTKU3iRfWcwci','customers/23.jpg','+18587553455','+18587553455',NULL,'published',NULL,'2025-11-18 04:10:19',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-11-01 10:17:22',1,'Premium vendor account','2025-10-29 03:37:26',0.00,NULL,NULL),(13,'Pacific Auto Sales','willms.cesar@aufderhar.info','$2y$12$lU0YQwjO7yYbW4b5trrcnOseuS2RXgv4e3ZhjUa4ns5siS31DXkB.','customers/24.jpg','+12796251322','+12796251322',NULL,'published',NULL,'2025-11-18 04:10:19',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:21',1,1,'2025-10-04 00:19:30',1,'Verified dealership','2024-11-27 12:55:20',288.00,NULL,NULL),(14,'Mountain View Motors','zelma.rosenbaum@terry.com','$2y$12$QgyAy4KN.QzUgYirYlJMS.Ey5WU8RTa6LxKmAo6o/vTinTt4tFGIW','customers/25.jpg','+13516442578','+13516442578',NULL,'published',NULL,'2025-11-18 04:10:19',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-10-15 02:10:58',1,'Premium vendor account','2025-08-04 05:27:22',0.00,NULL,NULL),(15,'Coastal Car Company','mitchell.mozell@predovic.net','$2y$12$v65hkFBNm1CLzBYU6vWnTeM0dgac7NJKGw7kn/nFpZ5o4G1FCuGdS','customers/26.jpg','+12196381734','+12196381734',NULL,'published',NULL,'2025-11-18 04:10:20',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,1,'2025-05-24 22:45:42',1,'Trusted automotive partner','2025-09-29 17:29:42',129.60,NULL,NULL),(16,'Central Auto Hub','alanis.wintheiser@hansen.com','$2y$12$TKyPCtTFNsH9U5FsZfbAI.HgfxU5V5fg97iA8l9LaRNNru7Zm3D9.','customers/27.jpg','+14096320760','+14096320760',NULL,'published',NULL,'2025-11-18 04:10:20',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:20',1,1,'2025-08-18 17:48:43',1,'Trusted automotive partner','2025-07-13 04:41:25',507.52,NULL,NULL),(17,'Victory Automotive','green.caleigh@kulas.com','$2y$12$gUqrm5Ahk9263DopTwNvNehxMEWhuie2khJW.CObRmIaB9uOE6Fv.','customers/28.jpg','+17549735158','+17549735158',NULL,'published',NULL,'2025-11-18 04:10:20',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-07-10 05:03:07',1,'Authorized car dealer','2025-11-05 08:35:40',0.00,NULL,NULL),(18,'Alliance Car Group','leonie39@morissette.com','$2y$12$u04qDBD6PApXxrm805n3DetB9th4WvSCplf0357Vt/uLx04I2FvFC','customers/29.jpg','+17167044996','+17167044996',NULL,'published',NULL,'2025-11-18 04:10:20',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:21',1,1,'2025-06-03 11:59:01',1,'Authorized car dealer','2025-03-06 09:09:28',698.40,NULL,NULL),(19,'Phoenix Motors','ozella.hickle@hirthe.com','$2y$12$BKqtYaheW/Cor3WBDwmz.OOtqqVSL81tqftGQ4mCYzE35Q3Z5Np1K','customers/30.jpg','+18307669289','+18307669289',NULL,'published',NULL,'2025-11-18 04:10:21',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-08-15 08:20:34',1,'Premium vendor account','2025-04-24 06:24:37',0.00,NULL,NULL),(20,'Sterling Auto Sales','xfeil@mccullough.biz','$2y$12$3Skw2FiMc8IxSKXec/OoJuUA2Gyahp7Edy9YxEEj9FfaRGna9wM9a','customers/31.jpg','+14239705938','+14239705938',NULL,'published',NULL,'2025-11-18 04:10:21',NULL,'2025-11-17 21:10:24','2025-11-17 21:11:21',1,1,'2025-10-09 14:51:16',1,'Premium vendor account','2025-02-12 18:59:17',358.40,NULL,NULL),(21,'Verla Conroy','adams.mackenzie@example.org','$2y$12$4pWIEnUO1rklSTqU9bnqp.xJMjPB7QSEKa11TU8gysortvrnc/7dO','customers/1.jpg','+17192703606','+17192703606',NULL,'published',NULL,'2025-11-18 04:10:21',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(22,'Prof. Chad Flatley','htrantow@example.org','$2y$12$jGc/0M9aSUJrylAaKkd7H.OHEMZr4bPf6HKKXOYnj.UYK5sDL/jy2','customers/2.jpg','+14138452713','+14138452713',NULL,'published',NULL,'2025-11-18 04:10:21',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,1,'2025-11-15 19:20:45',1,'Verified through government ID',NULL,0.00,NULL,NULL),(23,'Sydnee Farrell III','ahodkiewicz@example.org','$2y$12$5PjYagLNcp3t8lbegOmF0O5P2TsvVyoFXoI2lGMPBzfi6YPi2B/ja','customers/3.jpg','+15862000822','+15862000822',NULL,'published',NULL,'2025-11-18 04:10:22',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(24,'Abraham Gutmann','audreanne.casper@example.org','$2y$12$4nZ8FfL2Nn0DOPoLi5CIfOsoBSpIZ.SiAJQY8eElNgKALmEqhxGq6','customers/4.jpg','+14232526899','+14232526899',NULL,'published',NULL,'2025-11-18 04:10:22',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(25,'Clementina Weimann','gibson.cali@example.org','$2y$12$24sqXxR/TPHd55TC6hoSSOCKY12r/m8lppLQpqrvGBwVXEEeJnqF2','customers/5.jpg','+18486586228','+18486586228',NULL,'published',NULL,'2025-11-18 04:10:22',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(26,'Estefania Dooley','dallas70@example.org','$2y$12$yQJ8w7QbszBC9E407xGgEucKt7vMUg.ivtjDjnn8gAdBR4jOInI.e','customers/6.jpg','+15647257105','+15647257105',NULL,'published',NULL,'2025-11-18 04:10:22',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(27,'Jarrod Schroeder','quigley.oliver@example.org','$2y$12$ZRAGbanLOXkK.eqvQa9vze/NZ55NXGgPqYUr.VNRn/HvwxQoEN3du','customers/7.jpg','+17749757485','+17749757485',NULL,'published',NULL,'2025-11-18 04:10:23',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','$2y$12$H6GYFqGm.iNZwd5BOvuFROpyPDtr4ULd9TOkG8AIqAR7ssPuFLiWe','customers/8.jpg','+19375406905','+19375406905',NULL,'published',NULL,'2025-11-18 04:10:23',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(29,'Ewell Carroll III','emmitt.dubuque@example.net','$2y$12$bcB6hrrj0MOT8PL83.TUeuZnsXJM.R/dcdDxWuxA2mtANVwcOWv0i','customers/9.jpg','+14103449437','+14103449437',NULL,'published',NULL,'2025-11-18 04:10:23',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,1,'2025-06-24 02:50:25',1,'Identity confirmed',NULL,0.00,NULL,NULL),(30,'Ms. Madilyn Huels','abbott.vanessa@example.com','$2y$12$BOfOCb4JMZ9q3wL6hf9TuuTIKIq/3UlB/CIYXHUukeXFYp1qIbBb6','customers/10.jpg','+16784087632','+16784087632',NULL,'published',NULL,'2025-11-18 04:10:23',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,1,'2025-09-08 10:32:31',1,'Verified through government ID',NULL,0.00,NULL,NULL),(31,'Mrs. Hosea Stroman','customer@botble.com','$2y$12$kXW/nzDS/Qf5fuW73q5HruFxOjx02XIn96wZUVgsz25ssQWw4lFcq','customers/8.jpg','+13526186202','+13526186202',NULL,'published',NULL,'2025-11-18 04:10:24',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',0,0,NULL,NULL,NULL,NULL,0.00,NULL,NULL),(32,'Emie Conn','vendor@botble.com','$2y$12$sZT2sARyDVThnTkI8ZR4aulq9TJVXPiS23rlX09KThaG4jUSBCnp2','customers/8.jpg','+18632081038','+18632081038',NULL,'published',NULL,'2025-11-18 04:10:24',NULL,'2025-11-17 21:10:24','2025-11-17 21:10:24',1,1,'2025-10-03 00:58:54',1,'Verified vendor account','2025-06-25 01:04:31',0.00,NULL,NULL);
/*!40000 ALTER TABLE `cr_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_invoice_items`
--

DROP TABLE IF EXISTS `cr_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_invoice_items`
--

LOCK TABLES `cr_invoice_items` WRITE;
/*!40000 ALTER TABLE `cr_invoice_items` DISABLE KEYS */;
INSERT INTO `cr_invoice_items` VALUES (1,1,'Fiat 500X Sport AWD 2024','',1,196.00,0.00,0.00,196.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(2,2,'Peugeot 308 GT Premium 2024','',1,244.00,0.00,0.00,244.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(3,3,'Mercedes-Benz E450 4MATIC All-Terrain 2024','',1,76.00,0.00,0.00,76.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(4,4,'Fiat 500X Sport AWD 2024','',1,49.00,0.00,0.00,49.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(5,5,'Porsche 911 Carrera S 2024','',1,234.00,0.00,0.00,234.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(6,6,'Volkswagen Tiguan SEL R-Line 2024','',1,475.00,0.00,0.00,475.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(7,7,'Smart EQ fortwo Prime 2024','',1,170.00,0.00,0.00,170.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(8,8,'Aston Martin DBX707 2024','',1,98.00,0.00,0.00,98.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(9,9,'Genesis Electrified GV70 Advanced AWD 2024','',1,282.00,0.00,0.00,282.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(10,10,'Lucid Air Grand Touring Performance 2024','',1,141.00,0.00,0.00,141.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(11,11,'Audi RS Q8 quattro 2024','',1,546.00,0.00,0.00,546.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(12,12,'Chrysler Pacifica Pinnacle AWD 2024','',1,64.00,0.00,0.00,64.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(13,13,'Mitsubishi Outlander SEL S-AWC 2024','',1,126.00,0.00,0.00,126.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(14,14,'Smart EQ fortwo Prime 2024','',1,34.00,0.00,0.00,34.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(15,15,'Porsche Cayenne Turbo GT 2024','',1,343.00,0.00,0.00,343.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(16,16,'McLaren Artura Spider 2024','',1,370.00,0.00,0.00,370.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(17,17,'Audi A4 Premium Plus quattro 2024','',1,30.00,0.00,0.00,30.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(18,18,'Jaguar F-PACE SVR 2024','',1,252.00,0.00,0.00,252.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(19,19,'Genesis GV70 2.5T Sport AWD 2024','',1,276.00,0.00,0.00,276.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(20,20,'Lexus ES 350 F Sport 2024','',1,245.00,0.00,0.00,245.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(21,21,'Alfa Romeo Stelvio Veloce AWD 2024','',1,546.00,0.00,0.00,546.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(22,22,'Porsche Cayenne Turbo GT 2024','',1,147.00,0.00,0.00,147.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(23,23,'Ford GT Heritage Edition 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(24,24,'Mazda MX-5 Miata Grand Touring 2024','',1,180.00,0.00,0.00,180.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(25,25,'Mercedes-Benz E450 4MATIC All-Terrain 2024','',1,76.00,0.00,0.00,76.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(26,26,'Genesis G70 3.3T Sport Prestige AWD 2024','',1,62.00,0.00,0.00,62.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(27,27,'Porsche Taycan Turbo S Cross Turismo 2024','',1,582.00,0.00,0.00,582.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(28,28,'Audi Q7 55 TFSI quattro Premium Plus 2024','',1,292.00,0.00,0.00,292.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(29,29,'Land Rover Defender 110 X 2024','',1,427.00,0.00,0.00,427.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(30,30,'Honda CR-V Touring Hybrid AWD 2024','',1,224.00,0.00,0.00,224.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(31,31,'Mercedes-Benz GLC 300 4MATIC 2024','',1,320.00,0.00,0.00,320.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(32,32,'Infiniti QX60 Autograph AWD 2024','',1,426.00,0.00,0.00,426.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(33,33,'Nissan GT-R NISMO Special Edition 2024','',1,264.00,0.00,0.00,264.00,'2025-11-17 21:11:20','2025-11-17 21:11:20'),(34,34,'Tesla Model S Plaid 2024','',1,284.00,0.00,0.00,284.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(35,35,'BMW X5 xDrive40i M Sport 2024','',1,360.00,0.00,0.00,360.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(36,36,'Mercedes-Maybach S 580 4MATIC 2024','',1,552.00,0.00,0.00,552.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(37,37,'Lexus LX 600 Ultra Luxury 2024','',1,49.00,0.00,0.00,49.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(38,38,'Jeep Grand Cherokee Summit Reserve 4xe 2024','',1,36.00,0.00,0.00,36.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(39,39,'Alfa Romeo Giulia Quadrifoglio 2024','',1,176.00,0.00,0.00,176.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(40,40,'Chevrolet Corvette Z06 3LZ 2024','',1,188.00,0.00,0.00,188.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(41,41,'Mercedes-Benz G550 4MATIC 2024','',1,55.00,0.00,0.00,55.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(42,42,'Porsche Taycan Turbo S Cross Turismo 2024','',1,291.00,0.00,0.00,291.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(43,43,'Bentley Bentayga S V8 2024','',1,355.00,0.00,0.00,355.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(44,44,'Chevrolet Camaro SS 1LE 2024','',1,420.00,0.00,0.00,420.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(45,45,'Mercedes-Benz C300 4MATIC 2024','',1,570.00,0.00,0.00,570.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(46,46,'Chrysler Pacifica Pinnacle AWD 2024','',1,384.00,0.00,0.00,384.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(47,47,'McLaren 720S Spider 2024','',1,96.00,0.00,0.00,96.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(48,48,'Lincoln Aviator Reserve AWD 2024','',1,33.00,0.00,0.00,33.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(49,49,'Lincoln Aviator Reserve AWD 2024','',1,165.00,0.00,0.00,165.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(50,50,'Jaguar F-PACE SVR 2024','',1,84.00,0.00,0.00,84.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(51,51,'Pagani Huayra Roadster BC 2024','',1,270.00,0.00,0.00,270.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(52,52,'Honda Pilot TrailSport AWD 2024','',1,192.00,0.00,0.00,192.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(53,53,'Porsche Cayenne Turbo GT 2024','',1,196.00,0.00,0.00,196.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(54,54,'Koenigsegg Jesko Absolut 2024','',1,602.00,0.00,0.00,602.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(55,55,'Maserati Ghibli Modena 2024','',1,291.00,0.00,0.00,291.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(56,56,'Pagani Huayra Roadster BC 2024','',1,45.00,0.00,0.00,45.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(57,57,'Range Rover Sport HSE Dynamic 2024','',1,570.00,0.00,0.00,570.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(58,58,'Genesis GV70 2.5T Sport AWD 2024','',1,414.00,0.00,0.00,414.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(59,59,'Jeep Grand Cherokee Summit Reserve 4xe 2024','',1,216.00,0.00,0.00,216.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(60,60,'Lincoln Aviator Reserve AWD 2024','',1,99.00,0.00,0.00,99.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(61,61,'Mercedes-Benz E450 4MATIC All-Terrain 2024','',1,38.00,0.00,0.00,38.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(62,62,'Mercedes-Benz G550 4MATIC 2024','',1,110.00,0.00,0.00,110.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(63,63,'Infiniti QX60 Autograph AWD 2024','',1,355.00,0.00,0.00,355.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(64,64,'Nissan GT-R NISMO Special Edition 2024','',1,220.00,0.00,0.00,220.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(65,65,'BMW M4 Competition xDrive 2024','',1,570.00,0.00,0.00,570.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(66,66,'Volvo XC60 B6 Ultimate AWD 2024','',1,441.00,0.00,0.00,441.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(67,67,'Acura MDX Type S Advance 2024','',1,156.00,0.00,0.00,156.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(68,68,'Ford Mustang GT Premium 2024','',1,40.00,0.00,0.00,40.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(69,69,'Lucid Air Grand Touring Performance 2024','',1,282.00,0.00,0.00,282.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(70,70,'Aston Martin DBX707 2024','',1,294.00,0.00,0.00,294.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(71,71,'Fiat 500X Sport AWD 2024','',1,196.00,0.00,0.00,196.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(72,72,'Volkswagen Atlas Cross Sport SEL Premium 2024','',1,288.00,0.00,0.00,288.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(73,73,'Rivian R1S Adventure 2024','',1,438.00,0.00,0.00,438.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(74,74,'Audi A4 Premium Plus quattro 2024','',1,210.00,0.00,0.00,210.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(75,75,'Mercedes-Maybach S 580 4MATIC 2024','',1,644.00,0.00,0.00,644.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(76,76,'Porsche Macan S 2024','',1,90.00,0.00,0.00,90.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(77,77,'McLaren Artura Spider 2024','',1,518.00,0.00,0.00,518.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(78,78,'Genesis GV70 2.5T Sport AWD 2024','',1,483.00,0.00,0.00,483.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(79,79,'Chevrolet Corvette Z06 3LZ 2024','',1,282.00,0.00,0.00,282.00,'2025-11-17 21:11:21','2025-11-17 21:11:21'),(80,80,'Alfa Romeo Giulia Quadrifoglio 2024','',1,176.00,0.00,0.00,176.00,'2025-11-17 21:11:21','2025-11-17 21:11:21');
/*!40000 ALTER TABLE `cr_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_invoices`
--

DROP TABLE IF EXISTS `cr_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` double NOT NULL,
  `tax_amount` double NOT NULL DEFAULT '0',
  `discount_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cr_invoices_code_unique` (`code`),
  KEY `cr_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `cr_invoices_payment_id_index` (`payment_id`),
  KEY `cr_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_invoices`
--

LOCK TABLES `cr_invoices` WRITE;
/*!40000 ALTER TABLE `cr_invoices` DISABLE KEYS */;
INSERT INTO `cr_invoices` VALUES (1,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',1,1,'Botble\\CarRentals\\Models\\Booking',1,'INV-1',196,0,0,196,'completed','2025-11-17 21:11:20','2025-11-13 21:11:20','2025-11-17 21:11:20',2),(2,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',2,1,'Botble\\CarRentals\\Models\\Booking',2,'INV-2',244,24.4,0,244,'completed','2025-11-17 21:11:20','2025-09-20 21:11:20','2025-11-17 21:11:20',5),(3,24,'Abraham Gutmann','audreanne.casper@example.org','+14232526899',3,1,'Botble\\CarRentals\\Models\\Booking',3,'INV-3',76,7.6,0,76,'completed','2025-11-17 21:11:20','2025-09-20 21:11:20','2025-11-17 21:11:20',16),(4,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',4,1,'Botble\\CarRentals\\Models\\Booking',4,'INV-4',49,4.9,0,49,'completed','2025-11-17 21:11:20','2025-10-05 21:11:20','2025-11-17 21:11:20',2),(5,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',5,1,'Botble\\CarRentals\\Models\\Booking',5,'INV-5',234,0,0,234,'completed','2025-11-17 21:11:20','2025-10-21 21:11:20','2025-11-17 21:11:20',4),(6,26,'Estefania Dooley','dallas70@example.org','+15647257105',6,1,'Botble\\CarRentals\\Models\\Booking',6,'INV-6',475,0,0,475,'completed','2025-11-17 21:11:20','2025-10-04 21:11:20','2025-11-17 21:11:20',4),(7,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',7,1,'Botble\\CarRentals\\Models\\Booking',7,'INV-7',170,0,0,170,'completed','2025-11-17 21:11:20','2025-10-23 21:11:20','2025-11-17 21:11:20',7),(8,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',8,1,'Botble\\CarRentals\\Models\\Booking',8,'INV-8',98,0,0,98,'completed','2025-11-17 21:11:20','2025-10-28 21:11:20','2025-11-17 21:11:20',NULL),(9,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',9,1,'Botble\\CarRentals\\Models\\Booking',9,'INV-9',282,0,0,282,'completed','2025-11-17 21:11:20','2025-10-13 21:11:20','2025-11-17 21:11:20',NULL),(10,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',10,1,'Botble\\CarRentals\\Models\\Booking',10,'INV-10',141,0,0,141,'pending',NULL,'2025-10-20 21:11:20','2025-11-17 21:11:20',NULL),(11,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',11,1,'Botble\\CarRentals\\Models\\Booking',11,'INV-11',546,54.6,0,546,'completed','2025-11-17 21:11:20','2025-11-11 21:11:20','2025-11-17 21:11:20',11),(12,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',12,1,'Botble\\CarRentals\\Models\\Booking',12,'INV-12',64,0,0,64,'completed','2025-11-17 21:11:20','2025-10-03 21:11:20','2025-11-17 21:11:20',20),(13,26,'Estefania Dooley','dallas70@example.org','+15647257105',13,1,'Botble\\CarRentals\\Models\\Booking',13,'INV-13',126,0,0,126,'pending',NULL,'2025-10-25 21:11:20','2025-11-17 21:11:20',9),(14,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',14,1,'Botble\\CarRentals\\Models\\Booking',14,'INV-14',34,0,0,34,'completed','2025-11-17 21:11:20','2025-10-11 21:11:20','2025-11-17 21:11:20',7),(15,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',15,1,'Botble\\CarRentals\\Models\\Booking',15,'INV-15',343,0,0,343,'completed','2025-11-17 21:11:20','2025-10-19 21:11:20','2025-11-17 21:11:20',16),(16,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',16,1,'Botble\\CarRentals\\Models\\Booking',16,'INV-16',370,0,0,370,'pending',NULL,'2025-10-12 21:11:20','2025-11-17 21:11:20',32),(17,26,'Estefania Dooley','dallas70@example.org','+15647257105',17,1,'Botble\\CarRentals\\Models\\Booking',17,'INV-17',30,3,0,30,'pending',NULL,'2025-10-28 21:11:20','2025-11-17 21:11:20',15),(18,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',18,1,'Botble\\CarRentals\\Models\\Booking',18,'INV-18',252,0,0,252,'completed','2025-11-17 21:11:20','2025-10-27 21:11:20','2025-11-17 21:11:20',NULL),(19,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',19,1,'Botble\\CarRentals\\Models\\Booking',19,'INV-19',276,0,0,276,'completed','2025-11-17 21:11:20','2025-11-10 21:11:20','2025-11-17 21:11:20',NULL),(20,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',20,1,'Botble\\CarRentals\\Models\\Booking',20,'INV-20',245,0,0,245,'completed','2025-11-17 21:11:20','2025-09-19 21:11:20','2025-11-17 21:11:20',NULL),(21,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',21,1,'Botble\\CarRentals\\Models\\Booking',21,'INV-21',546,0,0,546,'pending',NULL,'2025-10-28 21:11:20','2025-11-17 21:11:20',19),(22,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',22,1,'Botble\\CarRentals\\Models\\Booking',22,'INV-22',147,0,0,147,'completed','2025-11-17 21:11:20','2025-09-25 21:11:20','2025-11-17 21:11:20',16),(23,27,'Jarrod Schroeder','quigley.oliver@example.org','+17749757485',23,1,'Botble\\CarRentals\\Models\\Booking',23,'INV-23',180,18,0,180,'completed','2025-11-17 21:11:20','2025-11-15 21:11:20','2025-11-17 21:11:20',15),(24,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',24,1,'Botble\\CarRentals\\Models\\Booking',24,'INV-24',180,0,0,180,'pending',NULL,'2025-10-29 21:11:20','2025-11-17 21:11:20',10),(25,22,'Prof. Chad Flatley','htrantow@example.org','+14138452713',25,1,'Botble\\CarRentals\\Models\\Booking',25,'INV-25',76,0,0,76,'completed','2025-11-17 21:11:20','2025-10-18 21:11:20','2025-11-17 21:11:20',16),(26,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',26,1,'Botble\\CarRentals\\Models\\Booking',26,'INV-26',62,6.2,0,62,'pending',NULL,'2025-10-01 21:11:20','2025-11-17 21:11:20',6),(27,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',27,1,'Botble\\CarRentals\\Models\\Booking',27,'INV-27',582,0,0,582,'completed','2025-11-17 21:11:20','2025-10-31 21:11:20','2025-11-17 21:11:20',18),(28,26,'Estefania Dooley','dallas70@example.org','+15647257105',28,1,'Botble\\CarRentals\\Models\\Booking',28,'INV-28',292,29.2,0,292,'pending',NULL,'2025-10-31 21:11:20','2025-11-17 21:11:20',NULL),(29,22,'Prof. Chad Flatley','htrantow@example.org','+14138452713',29,1,'Botble\\CarRentals\\Models\\Booking',29,'INV-29',427,42.7,0,427,'completed','2025-11-17 21:11:20','2025-11-06 21:11:20','2025-11-17 21:11:20',NULL),(30,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',30,1,'Botble\\CarRentals\\Models\\Booking',30,'INV-30',224,22.4,0,224,'completed','2025-11-17 21:11:20','2025-10-18 21:11:20','2025-11-17 21:11:20',NULL),(31,26,'Estefania Dooley','dallas70@example.org','+15647257105',31,1,'Botble\\CarRentals\\Models\\Booking',31,'INV-31',320,32,0,320,'pending',NULL,'2025-11-14 21:11:20','2025-11-17 21:11:20',6),(32,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',32,1,'Botble\\CarRentals\\Models\\Booking',32,'INV-32',426,0,0,426,'pending',NULL,'2025-11-11 21:11:20','2025-11-17 21:11:20',8),(33,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',33,1,'Botble\\CarRentals\\Models\\Booking',33,'INV-33',264,0,0,264,'pending',NULL,'2025-11-13 21:11:20','2025-11-17 21:11:20',12),(34,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',34,1,'Botble\\CarRentals\\Models\\Booking',34,'INV-34',284,28.4,0,284,'pending',NULL,'2025-11-17 21:11:20','2025-11-17 21:11:20',13),(35,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',35,1,'Botble\\CarRentals\\Models\\Booking',35,'INV-35',360,0,0,360,'completed','2025-11-17 21:11:21','2025-11-11 21:11:21','2025-11-17 21:11:21',13),(36,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',36,1,'Botble\\CarRentals\\Models\\Booking',36,'INV-36',552,55.2,0,552,'pending',NULL,'2025-11-16 21:11:21','2025-11-17 21:11:21',14),(37,27,'Jarrod Schroeder','quigley.oliver@example.org','+17749757485',37,1,'Botble\\CarRentals\\Models\\Booking',37,'INV-37',49,0,0,49,'completed','2025-11-17 21:11:21','2025-11-16 21:11:21','2025-11-17 21:11:21',9),(38,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',38,1,'Botble\\CarRentals\\Models\\Booking',38,'INV-38',36,0,0,36,'completed','2025-11-17 21:11:21','2025-11-11 21:11:21','2025-11-17 21:11:21',NULL),(39,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',39,1,'Botble\\CarRentals\\Models\\Booking',39,'INV-39',176,0,0,176,'completed','2025-11-17 21:11:21','2025-11-10 21:11:21','2025-11-17 21:11:21',NULL),(40,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',40,1,'Botble\\CarRentals\\Models\\Booking',40,'INV-40',188,0,0,188,'pending',NULL,'2025-11-15 21:11:21','2025-11-17 21:11:21',NULL),(41,24,'Abraham Gutmann','audreanne.casper@example.org','+14232526899',41,1,'Botble\\CarRentals\\Models\\Booking',41,'INV-41',55,0,0,55,'pending',NULL,'2025-11-14 21:11:21','2025-11-17 21:11:21',19),(42,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',42,1,'Botble\\CarRentals\\Models\\Booking',42,'INV-42',291,0,0,291,'completed','2025-11-17 21:11:21','2025-11-10 21:11:21','2025-11-17 21:11:21',18),(43,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',43,1,'Botble\\CarRentals\\Models\\Booking',43,'INV-43',355,0,0,355,'pending',NULL,'2025-11-16 21:11:21','2025-11-17 21:11:21',11),(44,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',44,1,'Botble\\CarRentals\\Models\\Booking',44,'INV-44',420,0,0,420,'pending',NULL,'2025-11-14 21:11:21','2025-11-17 21:11:21',3),(45,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',45,1,'Botble\\CarRentals\\Models\\Booking',45,'INV-45',570,0,0,570,'pending',NULL,'2025-11-15 21:11:21','2025-11-17 21:11:21',14),(46,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',46,1,'Botble\\CarRentals\\Models\\Booking',46,'INV-46',384,0,0,384,'completed','2025-11-17 21:11:21','2025-11-13 21:11:21','2025-11-17 21:11:21',20),(47,24,'Abraham Gutmann','audreanne.casper@example.org','+14232526899',47,1,'Botble\\CarRentals\\Models\\Booking',47,'INV-47',96,0,0,96,'pending',NULL,'2025-11-13 21:11:21','2025-11-17 21:11:21',1),(48,26,'Estefania Dooley','dallas70@example.org','+15647257105',48,1,'Botble\\CarRentals\\Models\\Booking',48,'INV-48',33,0,0,33,'pending',NULL,'2025-11-12 21:11:21','2025-11-17 21:11:21',NULL),(49,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',49,1,'Botble\\CarRentals\\Models\\Booking',49,'INV-49',165,16.5,0,165,'pending',NULL,'2025-11-15 21:11:21','2025-11-17 21:11:21',NULL),(50,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',50,1,'Botble\\CarRentals\\Models\\Booking',50,'INV-50',84,8.4,0,84,'pending',NULL,'2025-11-11 21:11:21','2025-11-17 21:11:21',NULL),(51,26,'Estefania Dooley','dallas70@example.org','+15647257105',51,1,'Botble\\CarRentals\\Models\\Booking',51,'INV-51',270,0,0,270,'pending',NULL,'2025-12-03 21:11:21','2025-11-17 21:11:21',2),(52,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',52,1,'Botble\\CarRentals\\Models\\Booking',52,'INV-52',192,0,0,192,'pending',NULL,'2025-11-25 21:11:21','2025-11-17 21:11:21',5),(53,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',53,1,'Botble\\CarRentals\\Models\\Booking',53,'INV-53',196,19.6,0,196,'pending',NULL,'2025-12-17 21:11:21','2025-11-17 21:11:21',16),(54,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',54,1,'Botble\\CarRentals\\Models\\Booking',54,'INV-54',602,60.2,0,602,'pending',NULL,'2025-12-03 21:11:21','2025-11-17 21:11:21',10),(55,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',55,1,'Botble\\CarRentals\\Models\\Booking',55,'INV-55',291,29.1,0,291,'pending',NULL,'2025-12-16 21:11:21','2025-11-17 21:11:21',4),(56,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',56,1,'Botble\\CarRentals\\Models\\Booking',56,'INV-56',45,4.5,0,45,'pending',NULL,'2025-11-28 21:11:21','2025-11-17 21:11:21',2),(57,27,'Jarrod Schroeder','quigley.oliver@example.org','+17749757485',57,1,'Botble\\CarRentals\\Models\\Booking',57,'INV-57',570,0,0,570,'pending',NULL,'2025-12-08 21:11:21','2025-11-17 21:11:21',10),(58,23,'Sydnee Farrell III','ahodkiewicz@example.org','+15862000822',58,1,'Botble\\CarRentals\\Models\\Booking',58,'INV-58',414,0,0,414,'pending',NULL,'2025-12-03 21:11:21','2025-11-17 21:11:21',NULL),(59,30,'Ms. Madilyn Huels','abbott.vanessa@example.com','+16784087632',59,1,'Botble\\CarRentals\\Models\\Booking',59,'INV-59',216,0,0,216,'pending',NULL,'2025-11-22 21:11:21','2025-11-17 21:11:21',NULL),(60,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',60,1,'Botble\\CarRentals\\Models\\Booking',60,'INV-60',99,0,0,99,'pending',NULL,'2025-12-01 21:11:21','2025-11-17 21:11:21',NULL),(61,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',61,1,'Botble\\CarRentals\\Models\\Booking',61,'INV-61',38,0,0,38,'pending',NULL,'2025-12-01 21:11:21','2025-11-17 21:11:21',16),(62,29,'Ewell Carroll III','emmitt.dubuque@example.net','+14103449437',62,1,'Botble\\CarRentals\\Models\\Booking',62,'INV-62',110,0,0,110,'pending',NULL,'2025-11-30 21:11:21','2025-11-17 21:11:21',19),(63,26,'Estefania Dooley','dallas70@example.org','+15647257105',63,1,'Botble\\CarRentals\\Models\\Booking',63,'INV-63',355,0,0,355,'pending',NULL,'2025-11-25 21:11:21','2025-11-17 21:11:21',8),(64,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',64,1,'Botble\\CarRentals\\Models\\Booking',64,'INV-64',220,0,0,220,'pending',NULL,'2025-12-11 21:11:21','2025-11-17 21:11:21',12),(65,27,'Jarrod Schroeder','quigley.oliver@example.org','+17749757485',65,1,'Botble\\CarRentals\\Models\\Booking',65,'INV-65',570,57,0,570,'pending',NULL,'2025-11-18 21:11:21','2025-11-17 21:11:21',9),(66,26,'Estefania Dooley','dallas70@example.org','+15647257105',66,1,'Botble\\CarRentals\\Models\\Booking',66,'INV-66',441,44.1,0,441,'pending',NULL,'2025-11-27 21:11:21','2025-11-17 21:11:21',4),(67,24,'Abraham Gutmann','audreanne.casper@example.org','+14232526899',67,1,'Botble\\CarRentals\\Models\\Booking',67,'INV-67',156,0,0,156,'pending',NULL,'2025-12-01 21:11:21','2025-11-17 21:11:21',4),(68,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',68,1,'Botble\\CarRentals\\Models\\Booking',68,'INV-68',40,0,0,40,'pending',NULL,'2025-11-23 21:11:21','2025-11-17 21:11:21',NULL),(69,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',69,1,'Botble\\CarRentals\\Models\\Booking',69,'INV-69',282,28.2,0,282,'pending',NULL,'2025-11-22 21:11:21','2025-11-17 21:11:21',NULL),(70,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',70,1,'Botble\\CarRentals\\Models\\Booking',70,'INV-70',294,0,0,294,'pending',NULL,'2025-12-15 21:11:21','2025-11-17 21:11:21',NULL),(71,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',71,1,'Botble\\CarRentals\\Models\\Booking',71,'INV-71',196,0,0,196,'pending',NULL,'2025-11-29 21:11:21','2025-11-17 21:11:21',2),(72,28,'Prof. Mylene Tremblay PhD','balistreri.araceli@example.org','+19375406905',72,1,'Botble\\CarRentals\\Models\\Booking',72,'INV-72',288,0,0,288,'pending',NULL,'2025-11-24 21:11:21','2025-11-17 21:11:21',18),(73,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',73,1,'Botble\\CarRentals\\Models\\Booking',73,'INV-73',438,0,0,438,'pending',NULL,'2025-11-27 21:11:21','2025-11-17 21:11:21',12),(74,24,'Abraham Gutmann','audreanne.casper@example.org','+14232526899',74,1,'Botble\\CarRentals\\Models\\Booking',74,'INV-74',210,0,0,210,'pending',NULL,'2025-12-09 21:11:21','2025-11-17 21:11:21',15),(75,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',75,1,'Botble\\CarRentals\\Models\\Booking',75,'INV-75',644,0,0,644,'pending',NULL,'2025-12-12 21:11:21','2025-11-17 21:11:21',14),(76,31,'Mrs. Hosea Stroman','customer@botble.com','+13526186202',76,1,'Botble\\CarRentals\\Models\\Booking',76,'INV-76',90,9,0,90,'pending',NULL,'2025-12-10 21:11:21','2025-11-17 21:11:21',14),(77,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',77,1,'Botble\\CarRentals\\Models\\Booking',77,'INV-77',518,0,0,518,'pending',NULL,'2025-12-09 21:11:21','2025-11-17 21:11:21',32),(78,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',78,1,'Botble\\CarRentals\\Models\\Booking',78,'INV-78',483,0,0,483,'pending',NULL,'2025-11-19 21:11:21','2025-11-17 21:11:21',NULL),(79,25,'Clementina Weimann','gibson.cali@example.org','+18486586228',79,1,'Botble\\CarRentals\\Models\\Booking',79,'INV-79',282,0,0,282,'pending',NULL,'2025-12-08 21:11:21','2025-11-17 21:11:21',NULL),(80,21,'Verla Conroy','adams.mackenzie@example.org','+17192703606',80,1,'Botble\\CarRentals\\Models\\Booking',80,'INV-80',176,0,0,176,'pending',NULL,'2025-12-17 21:11:21','2025-11-17 21:11:21',NULL);
/*!40000 ALTER TABLE `cr_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_messages`
--

DROP TABLE IF EXISTS `cr_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_messages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `car_id` bigint unsigned DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `vendor_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_messages`
--

LOCK TABLES `cr_messages` WRITE;
/*!40000 ALTER TABLE `cr_messages` DISABLE KEYS */;
INSERT INTO `cr_messages` VALUES (1,NULL,28,'John Doe','johndoe@example.com','I would like to know more about your services.','192.168.1.1','2025-11-17 21:11:21','2025-11-17 21:11:21','123-456-7890','unread',3),(2,NULL,21,'Jane Smith','janesmith@example.com','Can you provide a quotation for the project?','192.168.1.2','2025-11-17 21:11:21','2025-11-17 21:11:21','987-654-3210','read',NULL),(3,NULL,5,'Alice Brown','alicebrown@example.com','I am having an issue with my recent order.','192.168.1.3','2025-11-17 21:11:21','2025-11-17 21:11:21','555-666-7777','read',NULL),(4,NULL,6,'Bob Green','bobgreen@example.com','What are your business hours?','192.168.1.4','2025-11-17 21:11:21','2025-11-17 21:11:21','222-333-4444','read',3),(5,NULL,17,'Charlie White','charliewhite@example.com','I need assistance with your product.','192.168.1.5','2025-11-17 21:11:21','2025-11-17 21:11:21','333-444-5555','read',NULL),(6,NULL,21,'Diana Blue','dianablue@example.com','Do you offer international shipping?','192.168.1.6','2025-11-17 21:11:21','2025-11-17 21:11:21','444-555-6666','unread',NULL),(7,NULL,23,'Edward Black','edwardblack@example.com','Can I schedule an appointment?','192.168.1.7','2025-11-17 21:11:21','2025-11-17 21:11:21','555-666-7778','unread',15),(8,NULL,1,'Fiona Gray','fionagray@example.com','Your website is not loading for me.','192.168.1.8','2025-11-17 21:11:21','2025-11-17 21:11:21','666-777-8888','unread',NULL),(9,NULL,16,'George Violet','georgeviolet@example.com','I want to change my order details.','192.168.1.9','2025-11-17 21:11:21','2025-11-17 21:11:21','777-888-9999','read',NULL),(10,NULL,25,'Hannah Pink','hannahpink@example.com','Can you send me a catalog of your products?','192.168.1.10','2025-11-17 21:11:21','2025-11-17 21:11:21','888-999-0000','unread',2),(11,NULL,28,'Ian Orange','ianorange@example.com','Do you offer discounts for bulk purchases?','192.168.1.11','2025-11-17 21:11:21','2025-11-17 21:11:21','999-000-1111','unread',NULL),(12,NULL,6,'Jack Purple','jackpurple@example.com','I forgot my account password.','192.168.1.12','2025-11-17 21:11:21','2025-11-17 21:11:21','000-111-2222','unread',NULL),(13,NULL,30,'Karen Yellow','karenyellow@example.com','Can you expedite my order?','192.168.1.13','2025-11-17 21:11:21','2025-11-17 21:11:21','111-222-3333','unread',13),(14,NULL,5,'Liam Red','liamred@example.com','Do you have a return policy?','192.168.1.14','2025-11-17 21:11:21','2025-11-17 21:11:21','222-333-4445','unread',NULL),(15,NULL,4,'Mia Silver','miasilver@example.com','Thank you for resolving my issue quickly.','192.168.1.15','2025-11-17 21:11:21','2025-11-17 21:11:21','333-444-5556','unread',NULL),(16,NULL,26,'Noah Gold','noahgold@example.com','Can I get an invoice for my purchase?','192.168.1.16','2025-11-17 21:11:21','2025-11-17 21:11:21','444-555-6667','unread',4),(17,NULL,28,'Olivia Bronze','oliviabronze@example.com','I would like to cancel my order.','192.168.1.17','2025-11-17 21:11:21','2025-11-17 21:11:21','555-666-7779','read',NULL),(18,NULL,9,'Paul Amber','paulamber@example.com','Your support team is very helpful.','192.168.1.18','2025-11-17 21:11:21','2025-11-17 21:11:21','666-777-8889','read',NULL),(19,NULL,24,'Quinn Platinum','quinnplatinum@example.com','How do I track my shipment?','192.168.1.19','2025-11-17 21:11:21','2025-11-17 21:11:21','777-888-9990','unread',4),(20,NULL,27,'Ruby Diamond','rubydiamond@example.com','Great service and prompt delivery!','192.168.1.20','2025-11-17 21:11:21','2025-11-17 21:11:21','888-999-0001','unread',NULL);
/*!40000 ALTER TABLE `cr_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_services`
--

DROP TABLE IF EXISTS `cr_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_services` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `price` double unsigned NOT NULL DEFAULT '0',
  `currency_id` bigint unsigned DEFAULT NULL,
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'once',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_services_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_services`
--

LOCK TABLES `cr_services` WRITE;
/*!40000 ALTER TABLE `cr_services` DISABLE KEYS */;
INSERT INTO `cr_services` VALUES (1,'Driver Rental Service','In addition to our car rental service, we offer professional drivers for hire. Enjoy a stress-free journey with our experienced drivers handling the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Sint ea ipsa qui ipsa et. Sunt dolorem enim rerum ut omnis. Explicabo sunt quo excepturi facere quae non. Ab ad ut recusandae iure eum adipisci est. Temporibus id accusamus ut adipisci sed aut dolorem. Laudantium voluptatum et qui adipisci magni distinctio. Recusandae ut quidem quos cum. Dolores sint ut laudantium veritatis.\" content_2=\"Optio ex ea in iusto quibusdam maiores veniam. Vero sit qui sapiente non. Aperiam quisquam minima distinctio reiciendis. Ipsa possimus sed magni officia. Tempora dolores repellendus voluptas iste. Et molestiae magni molestias perspiciatis sed. Molestias laboriosam quibusdam quasi. Enim laudantium sint voluptas iste aut ut. Aut dicta non accusamus neque voluptatem.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',813,NULL,'once','news/1.jpg','icons/lexus.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Oil Change Service','Keep your engine in top condition with our oil change service. Available as an add-on to any of our maintenance or repair services.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Ducimus voluptas eius voluptates dignissimos omnis unde. Sapiente nulla fugiat cupiditate aut architecto quis. Similique adipisci impedit enim deleniti consectetur nemo inventore. Dolorem error et eum provident. Quos cum dolores tempore. A dolorum sint quae laborum voluptatum laboriosam aliquid. Eos architecto iure magni tenetur. Atque natus molestiae dolor est mollitia amet.\" content_2=\"Rerum omnis et delectus recusandae et numquam nisi. Saepe optio doloremque est excepturi temporibus reiciendis. Illum nisi excepturi aut quia accusantium quod dicta. Aut ullam libero quas laborum omnis. Eos totam et autem eligendi debitis sit quidem similique. Explicabo eaque maxime quidem et soluta odit. Explicabo ipsam voluptatem repudiandae repellat.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',368,NULL,'once','news/2.jpg','icons/mer.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Car Wash & Detailing Package','Enhance your car rental or repair experience with our premium car wash and detailing service, leaving your car spotless inside and out.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Voluptates voluptas aliquid quis facilis rerum quas aspernatur. Atque rerum temporibus impedit quae impedit minima. Numquam molestias iusto quas inventore odit officia doloremque. In molestias nesciunt alias repudiandae non a suscipit. Consequuntur non excepturi quia facilis ad ea. Debitis accusamus dolore et et ut. Eligendi aut adipisci similique. Quam quidem nisi nam dicta ex.\" content_2=\"Qui optio dignissimos quia dignissimos omnis. Non cum vero quibusdam doloremque. Error dicta et suscipit ut omnis ipsa et. Aut voluptas aut et quia distinctio beatae sequi. Alias qui aperiam cum laborum. Delectus ipsam nihil est quia esse porro non dolorum. Reiciendis quo ut saepe.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',356,NULL,'once','news/3.jpg','icons/bugatti.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Roadside Assistance','Our roadside assistance service ensures peace of mind while you rent or drive. Get help with breakdowns, flat tires, or towing when you need it most.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quidem provident fugiat blanditiis assumenda. Voluptatum magni optio quam labore ut rerum aliquam perspiciatis. Et voluptatem consectetur sed sunt earum. Eveniet omnis omnis at eos et. Recusandae eos dolorum distinctio nesciunt corrupti et aut repellat. Distinctio ullam corporis maiores occaecati rerum non.\" content_2=\"Quod aut cumque corrupti adipisci ullam quo. Cum quia voluptas reiciendis aut. Tenetur dicta repellendus et eos illum autem ut. Id possimus officia iusto quis. Ab porro corrupti voluptas ut voluptatem quo quia adipisci. Repellendus quas et in saepe dolores est rem. Illo mollitia sed mollitia aperiam doloribus perferendis quo.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',300,NULL,'once','news/4.jpg','icons/jaguar.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Temporary Car Replacement','If your car is in for repairs or maintenance, we offer a temporary car replacement service so you’re never without transportation.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Asperiores est maiores eum perspiciatis aut. Inventore a quia maxime quibusdam iusto commodi aut. Officia aperiam labore qui expedita. Animi fugiat modi porro atque necessitatibus voluptas. Vel molestias temporibus dicta labore. Ab repellat ipsam nulla aperiam vel ad est. Repellendus ducimus beatae iure nemo voluptatem voluptatibus.\" content_2=\"Voluptatem veritatis aliquam itaque dolores dolor est. Suscipit sit ut sit ipsum. Quis provident non ratione vel. Esse dolorem et earum mollitia aut qui blanditiis ducimus. Tempore est dolorem qui voluptatum ipsum aspernatur illum libero. Sit illum assumenda fugit laboriosam magnam soluta. Enim voluptatibus assumenda temporibus tempore harum quis consequuntur.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',192,NULL,'once','news/5.jpg','icons/honda.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Tire Replacement & Balancing','We provide tire replacement and wheel balancing services, ensuring your car is safe and smooth on the road, available as an add-on to any maintenance package.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Laudantium aut accusamus dolor quia hic. Quod dolore dolore voluptate quae. Dolores veniam a eos saepe. Autem consequuntur eum soluta mollitia soluta. Dolor sed quibusdam culpa enim tempore accusantium repellendus. Assumenda omnis vitae autem dolore. Quaerat illo maxime perferendis fugit accusamus ipsa.\" content_2=\"Ut assumenda sed quam voluptatem. Porro sit quam aut atque eaque aliquid illum. Qui quia qui explicabo porro maiores. Libero iure perferendis voluptas quisquam et sed. Quaerat consectetur sed reprehenderit doloribus expedita. Ut totam officia pariatur consequatur eum perspiciatis. Ut sit est quisquam quis libero alias. Repellat possimus est id enim.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',395,NULL,'once','news/6.jpg','icons/chevrolet.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(7,'Vehicle Inspection Service','For those looking to sell or rent a car, we offer thorough vehicle inspection services to certify your car’s condition and increase its market value.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Officia ducimus autem cupiditate temporibus. Neque maiores est voluptas est eligendi dolor soluta voluptas. Dolorem assumenda alias ipsa ea provident ut. Sunt porro nam nam sint repudiandae. Vitae maxime atque suscipit et non cupiditate et. Iste tempore mollitia voluptas repellendus ut est. Harum aliquam inventore velit laborum eum ab.\" content_2=\"Autem incidunt aliquid rerum repudiandae similique error. Nulla iste blanditiis impedit iste voluptas. Dolores commodi repellendus similique temporibus nesciunt dolores. Autem consequatur velit aut officia quis optio possimus. Atque et sint quo. Placeat odio provident molestiae. Consequuntur aliquam qui et minus rerum iusto veniam.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',415,NULL,'once','news/7.jpg','icons/chevrolet.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(8,'Car Insurance Assistance','Our experts can help you find the right car insurance policy, available as an add-on when purchasing or renting a vehicle from us.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Tempora debitis quas eos possimus quia distinctio non. Omnis aut dolor ea at eos. Ut nobis eos sit doloribus et quod. Eos enim voluptas necessitatibus sequi dolor. Harum occaecati omnis quia doloremque harum eum eligendi. Sed adipisci molestiae placeat.\" content_2=\"Laudantium voluptas accusamus libero dolor modi. Culpa voluptas accusamus in dolore qui. Qui ducimus ut est et magnam est reprehenderit. Rerum rerum quae ut quo accusamus. Ut qui minima at nihil cum. Ut animi placeat numquam qui qui. Fuga nihil ratione neque atque expedita facilis. Error nesciunt recusandae dolorem laboriosam in eaque. Quia a rerum officia voluptates.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/3.jpg\" image_2=\"news/2.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',757,NULL,'once','news/8.jpg','icons/chevrolet.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(9,'Pick-Up & Drop-Off Service','We offer a convenient pick-up and drop-off service when you rent a car, have your car serviced, or use our detailing services.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Pariatur aperiam tempore voluptas et officia ratione rerum. Sint quas alias ut dolorem. Consequatur inventore tempora ea nesciunt. Eligendi ut voluptate molestiae in eaque sint dolores enim.\" content_2=\"Omnis possimus nesciunt sequi sint fugiat nostrum. Cumque nulla et laboriosam sapiente sed. Pariatur qui qui nesciunt aut. Ullam officiis temporibus dolorum accusantium perspiciatis. Consequatur sit voluptate amet nihil illo cupiditate voluptates. Aut nobis incidunt nisi optio quaerat perferendis explicabo laborum. Repellendus illo est doloribus veniam architecto sapiente.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',948,NULL,'once','news/9.jpg','icons/chevrolet.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24'),(10,'Premium Fuel Service','Refuel your rental or serviced vehicle with high-quality premium fuel before hitting the road, ensuring optimal performance and mileage.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Iste illo laborum id qui. Magnam exercitationem omnis vitae qui itaque voluptatem. Minima debitis soluta placeat sunt. Eum assumenda repudiandae consectetur quis ipsam. Rem sint pariatur maiores nisi. Fugiat hic et consequatur soluta qui est. Culpa voluptatibus eum ex nisi. Distinctio aut qui consequatur est error. Ullam ut est voluptas officia et. Neque assumenda voluptas et.\" content_2=\"Facilis at ipsa sint ut tempora assumenda aliquid. Mollitia error consequatur doloribus cupiditate nulla voluptatum. Rerum odio et quis quia ab et. Ipsum temporibus consequatur consequatur ut quis. Quia dicta molestias sunt est nesciunt et error ad. Architecto molestias repellat soluta aliquam quam sapiente sit ipsam.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n',171,NULL,'once','news/10.jpg','icons/chevrolet.png','published','2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_services_translations`
--

DROP TABLE IF EXISTS `cr_services_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_services_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_services_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`cr_services_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_services_translations`
--

LOCK TABLES `cr_services_translations` WRITE;
/*!40000 ALTER TABLE `cr_services_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_services_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_tags`
--

DROP TABLE IF EXISTS `cr_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cr_tags_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_tags`
--

LOCK TABLES `cr_tags` WRITE;
/*!40000 ALTER TABLE `cr_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_tags_translations`
--

DROP TABLE IF EXISTS `cr_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_tags_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cr_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_tags_translations`
--

LOCK TABLES `cr_tags_translations` WRITE;
/*!40000 ALTER TABLE `cr_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_taxes`
--

DROP TABLE IF EXISTS `cr_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `priority` smallint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_taxes`
--

LOCK TABLES `cr_taxes` WRITE;
/*!40000 ALTER TABLE `cr_taxes` DISABLE KEYS */;
INSERT INTO `cr_taxes` VALUES (1,'Import Duty',2.82,'published',1,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(2,'Value Added Tax (VAT)',0.26,'published',2,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(3,'Currency Conversion',2.79,'published',3,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(4,'Brokerage',4.73,'published',4,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(5,'Storage',3.79,'published',5,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(6,'Administrative',0.62,'published',6,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(7,'Handling',0.74,'published',7,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(8,'Insurance',4.73,'published',8,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(9,'Rural Delivery',2.79,'published',9,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(10,'Return Shipping',0.15,'published',10,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(11,'Environmental',1.97,'published',11,'2025-11-17 21:10:24','2025-11-17 21:10:24'),(12,'Excise',4.02,'published',12,'2025-11-17 21:10:24','2025-11-17 21:10:24');
/*!40000 ALTER TABLE `cr_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cr_taxes_translations`
--

DROP TABLE IF EXISTS `cr_taxes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cr_taxes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cr_taxes_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_code`,`cr_taxes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cr_taxes_translations`
--

LOCK TABLES `cr_taxes_translations` WRITE;
/*!40000 ALTER TABLE `cr_taxes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cr_taxes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_tokens_token_unique` (`token`),
  KEY `device_tokens_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `device_tokens_platform_is_active_index` (`platform`,`is_active`),
  KEY `device_tokens_is_active_index` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'GENERAL INFORMATION',0,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(2,'ACCOMMODATIONS AND AMENITIES',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(3,'SPECIAL EVENTS',2,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(4,'SAFETY AND HEALTH',3,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(5,'EXPLORING',4,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(6,'Account Management',5,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(7,'Booking and Reservations',6,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(8,'Activity Information',7,'published','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What sets Luxury Hotel apart from others area?','Our hotel stands out with its prime coastal location, captivating design that harmonizes with nature, impeccable service dedicated to fulfilling every guest’s desire, and an array of world-class amenities that redefine opulence and sophistication.',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(2,'Are pets allowed at your hotel?','Unfortunately, as we strive to maintain an environment of tranquility and luxury for all our guests, we regret to inform you that we do not permit pets in our elegantly appointed rooms and meticulously designed public spaces.',2,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(3,'Is there a service from airport to hotel?','Absolutely! For your convenience, we offer an exclusive airport shuttle service that can be arranged in advance. Our dedicated concierge team will be delighted to provide you with detailed information and assist with reservations.',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(4,'What dining options are available at hotel?','Indulge in a culinary journey at our resort with a range of exquisite dining options. From elegantly crafted local and international cuisines to delightful specialty restaurants and inviting bars, every dining experience promises to tantalize your taste buds and elevate your stay to new heights of gastronomic pleasure.',2,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(5,'Is there a spa and wellness center on-site?','Embrace holistic well-being at our luxurious on-site spa and wellness center. Immerse yourself in a world of serenity and rejuvenation with a diverse selection of treatments, therapies, and state-of-the-art facilities that cater to your body, mind, and soul.',2,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(6,'Do you have family-friendly activities?','Families are warmly welcomed to our resort, where we have thoughtfully curated a range of family-friendly amenities and activities. From a dedicated kids’ club to a family pool and a host of engaging recreational options, we ensure a harmonious and enjoyable stay for guests of all ages.',2,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(7,'How can I arrange special at resort?','Celebrate life’s most precious moments in the epitome of luxury and elegance. Our skilled event planning team is committed to orchestrating seamless and memorable celebrations, ensuring every detail is tailored to your vision. Contact our dedicated events department to embark on a journey of crafting extraordinary moments.',3,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(8,'What safety measures do you have for guests?','Your well-being is our paramount concern. We have implemented stringent health and safety protocols to ensure a secure and comfortable environment for all our guests. These measures encompass enhanced cleaning procedures, social distancing guidelines, and a commitment to maintaining the highest standards of hygiene throughout the resort.',4,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(9,'Can I cancel or modify my reservation?','Our reservation policies vary based on the rate type and specific booking conditions. We kindly advise reviewing the terms and details of your reservation or reaching out to our dedicated reservations team for personalized assistance regarding cancellations or modifications. Your comfort and satisfaction remain our utmost priority.',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(10,'What activities are near your hotel?','Our hotel’s prime location offers easy access to a plethora of attractions. Explore the captivating Adriatic coastline, immerse yourself in historical landmarks, indulge in vibrant local culture, and embark on memorable excursions that our concierge team can readily assist in arranging.',5,'published','2025-11-17 21:10:00','2025-11-17 21:10:00');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fob_comments`
--

DROP TABLE IF EXISTS `fob_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fob_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reply_to` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fob_comments_author_type_author_id_index` (`author_type`,`author_id`),
  KEY `fob_comments_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `fob_comments_reply_to_index` (`reply_to`),
  KEY `fob_comments_reference_url_index` (`reference_url`),
  KEY `fob_comments_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fob_comments`
--

LOCK TABLES `fob_comments` WRITE;
/*!40000 ALTER TABLE `fob_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `fob_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Stunning Electric Cars of 2024','Ipsa totam consequuntur est. Architecto nisi tenetur ea. Veniam et est aut itaque voluptatem nam et sit. Sit sunt laudantium et eos maxime.',0,0,'galleries/1.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(2,'Top Luxury Cars for Special Occasions','Ea velit occaecati ad eos laudantium et. Qui tempora facilis et praesentium atque explicabo accusantium possimus. Non consequatur ab modi labore.',0,0,'galleries/2.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(3,'Family Cars with Advanced Safety Features','Odit aspernatur et dignissimos totam est et. Quibusdam minus ad nostrum id autem excepturi. Ea autem quibusdam et inventore totam sit.',0,0,'galleries/3.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(4,'Off-Road Vehicles in Action','Sed et vel neque minus id. Minus occaecati soluta amet nam. Illum numquam vel iure perferendis.',0,0,'galleries/4.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(5,'The Evolution of Car Design: A Visual Journey','Veniam inventore est sed et consequatur nesciunt recusandae. Facilis ut aut assumenda provident natus cum laboriosam.',0,0,'galleries/5.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(6,'Best Road Trip Cars of the Year','Dolore eos impedit illum. Ut esse aut sunt suscipit. Omnis et ratione est doloribus.',0,0,'galleries/6.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(7,'Exclusive New Car Models Unveiled','Voluptatem ut quae optio dolores ea. Magni impedit consequatur voluptas illo minus maiores ipsam. Reiciendis id natus alias officia et sequi.',0,0,'galleries/7.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(8,'Iconic Cars from Around the World','Veritatis quos omnis harum ut officia illo. Cupiditate sunt enim nemo quis ut facere. Qui at omnis eaque illo illo qui commodi.',0,0,'galleries/8.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(9,'The Future of Electric and Hybrid Cars','Numquam a magni ducimus cum error. Ut aut sit placeat a. Delectus sunt rerum reprehenderit nam dolorum corporis.',0,0,'galleries/9.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00'),(10,'Luxury Car Interiors: A Closer Look','Non non aliquam id libero eaque. Et et dolore a eveniet sit. Ad sapiente excepturi sunt perferendis quo.',0,0,'galleries/10.jpg',1,'published','2025-11-17 21:10:00','2025-11-17 21:10:00');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(2,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(3,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(4,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(5,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(6,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(7,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(8,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(9,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00'),(10,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/7.jpg\",\"description\":\"\"},{\"img\":\"galleries\\/8.jpg\",\"description\":\"\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-11-17 21:10:00','2025-11-17 21:10:00');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','4288eb338865b5e39e25cac2a9e97227',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','3e4fc747d508ea0f5ca8311d54a92d36',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','18d185f64f191091939bb1b129ef86fc',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(4,'en_US','5f287f5df6ac82e6c99acf60357b3615',2,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'1','1',1,'image/jpeg',10644,'general/1.jpg','[]','2025-11-17 21:09:41','2025-11-17 21:09:41',NULL,'public'),(2,0,'2','2',1,'image/jpeg',4750,'general/2.jpg','[]','2025-11-17 21:09:42','2025-11-17 21:09:42',NULL,'public'),(3,0,'3','3',1,'image/jpeg',8045,'general/3.jpg','[]','2025-11-17 21:09:42','2025-11-17 21:09:42',NULL,'public'),(4,0,'about-us-1','about-us-1',1,'image/jpeg',11009,'general/about-us-1.jpg','[]','2025-11-17 21:09:42','2025-11-17 21:09:42',NULL,'public'),(5,0,'about-us-2','about-us-2',1,'image/jpeg',11009,'general/about-us-2.jpg','[]','2025-11-17 21:09:42','2025-11-17 21:09:42',NULL,'public'),(6,0,'about-us-3','about-us-3',1,'image/jpeg',9151,'general/about-us-3.jpg','[]','2025-11-17 21:09:43','2025-11-17 21:09:43',NULL,'public'),(7,0,'admin-logo','admin-logo',1,'image/png',3856,'general/admin-logo.png','[]','2025-11-17 21:09:43','2025-11-17 21:09:43',NULL,'public'),(8,0,'appstore','appstore',1,'image/png',3718,'general/appstore.png','[]','2025-11-17 21:09:43','2025-11-17 21:09:43',NULL,'public'),(9,0,'background','background',1,'image/png',171804,'general/background.png','[]','2025-11-17 21:09:43','2025-11-17 21:09:43',NULL,'public'),(10,0,'favicon','favicon',1,'image/png',2019,'general/favicon.png','[]','2025-11-17 21:09:44','2025-11-17 21:09:44',NULL,'public'),(11,0,'googleplay','googleplay',1,'image/png',3970,'general/googleplay.png','[]','2025-11-17 21:09:44','2025-11-17 21:09:44',NULL,'public'),(12,0,'img-1','img-1',1,'image/png',8332,'general/img-1.png','[]','2025-11-17 21:09:44','2025-11-17 21:09:44',NULL,'public'),(13,0,'img-2-1','img-2-1',1,'image/png',4793,'general/img-2-1.png','[]','2025-11-17 21:09:45','2025-11-17 21:09:45',NULL,'public'),(14,0,'img-2-2','img-2-2',1,'image/png',4443,'general/img-2-2.png','[]','2025-11-17 21:09:45','2025-11-17 21:09:45',NULL,'public'),(15,0,'img-2-3','img-2-3',1,'image/png',3547,'general/img-2-3.png','[]','2025-11-17 21:09:45','2025-11-17 21:09:45',NULL,'public'),(16,0,'img-2-4','img-2-4',1,'image/png',4221,'general/img-2-4.png','[]','2025-11-17 21:09:46','2025-11-17 21:09:46',NULL,'public'),(17,0,'img-2','img-2',1,'image/png',8360,'general/img-2.png','[]','2025-11-17 21:09:46','2025-11-17 21:09:46',NULL,'public'),(18,0,'img-3','img-3',1,'image/png',7564,'general/img-3.png','[]','2025-11-17 21:09:46','2025-11-17 21:09:46',NULL,'public'),(19,0,'img-4','img-4',1,'image/png',7335,'general/img-4.png','[]','2025-11-17 21:09:46','2025-11-17 21:09:46',NULL,'public'),(20,0,'img-5','img-5',1,'image/png',8318,'general/img-5.png','[]','2025-11-17 21:09:47','2025-11-17 21:09:47',NULL,'public'),(21,0,'logo-dark','logo-dark',1,'image/png',3856,'general/logo-dark.png','[]','2025-11-17 21:09:47','2025-11-17 21:09:47',NULL,'public'),(22,0,'logo','logo',1,'image/png',4617,'general/logo.png','[]','2025-11-17 21:09:47','2025-11-17 21:09:47',NULL,'public'),(23,0,'phone','phone',1,'image/png',10618,'general/phone.png','[]','2025-11-17 21:09:47','2025-11-17 21:09:47',NULL,'public'),(24,0,'truck','truck',1,'image/png',5660,'general/truck.png','[]','2025-11-17 21:09:47','2025-11-17 21:09:47',NULL,'public'),(29,0,'1','1',3,'image/jpeg',19108,'news/1.jpg','[]','2025-11-17 21:09:51','2025-11-17 21:09:51',NULL,'public'),(30,0,'10','10',3,'image/jpeg',19108,'news/10.jpg','[]','2025-11-17 21:09:51','2025-11-17 21:09:51',NULL,'public'),(31,0,'11','11',3,'image/jpeg',19108,'news/11.jpg','[]','2025-11-17 21:09:51','2025-11-17 21:09:51',NULL,'public'),(32,0,'12','12',3,'image/jpeg',19108,'news/12.jpg','[]','2025-11-17 21:09:52','2025-11-17 21:09:52',NULL,'public'),(33,0,'13','13',3,'image/jpeg',19108,'news/13.jpg','[]','2025-11-17 21:09:52','2025-11-17 21:09:52',NULL,'public'),(34,0,'14','14',3,'image/jpeg',19108,'news/14.jpg','[]','2025-11-17 21:09:52','2025-11-17 21:09:52',NULL,'public'),(35,0,'15','15',3,'image/jpeg',19108,'news/15.jpg','[]','2025-11-17 21:09:52','2025-11-17 21:09:52',NULL,'public'),(36,0,'16','16',3,'image/jpeg',19108,'news/16.jpg','[]','2025-11-17 21:09:53','2025-11-17 21:09:53',NULL,'public'),(37,0,'17','17',3,'image/jpeg',19108,'news/17.jpg','[]','2025-11-17 21:09:53','2025-11-17 21:09:53',NULL,'public'),(38,0,'18','18',3,'image/jpeg',19108,'news/18.jpg','[]','2025-11-17 21:09:53','2025-11-17 21:09:53',NULL,'public'),(39,0,'19','19',3,'image/jpeg',19108,'news/19.jpg','[]','2025-11-17 21:09:54','2025-11-17 21:09:54',NULL,'public'),(40,0,'2','2',3,'image/jpeg',19108,'news/2.jpg','[]','2025-11-17 21:09:54','2025-11-17 21:09:54',NULL,'public'),(41,0,'20','20',3,'image/jpeg',19108,'news/20.jpg','[]','2025-11-17 21:09:54','2025-11-17 21:09:54',NULL,'public'),(42,0,'3','3',3,'image/jpeg',19108,'news/3.jpg','[]','2025-11-17 21:09:55','2025-11-17 21:09:55',NULL,'public'),(43,0,'4','4',3,'image/jpeg',19108,'news/4.jpg','[]','2025-11-17 21:09:55','2025-11-17 21:09:55',NULL,'public'),(44,0,'5','5',3,'image/jpeg',19108,'news/5.jpg','[]','2025-11-17 21:09:55','2025-11-17 21:09:55',NULL,'public'),(45,0,'6','6',3,'image/jpeg',19108,'news/6.jpg','[]','2025-11-17 21:09:55','2025-11-17 21:09:55',NULL,'public'),(46,0,'7','7',3,'image/jpeg',19108,'news/7.jpg','[]','2025-11-17 21:09:56','2025-11-17 21:09:56',NULL,'public'),(47,0,'8','8',3,'image/jpeg',19108,'news/8.jpg','[]','2025-11-17 21:09:56','2025-11-17 21:09:56',NULL,'public'),(48,0,'9','9',3,'image/jpeg',19108,'news/9.jpg','[]','2025-11-17 21:09:56','2025-11-17 21:09:56',NULL,'public'),(49,0,'1','1',4,'image/jpeg',12879,'galleries/1.jpg','[]','2025-11-17 21:09:57','2025-11-17 21:09:57',NULL,'public'),(50,0,'10','10',4,'image/jpeg',12879,'galleries/10.jpg','[]','2025-11-17 21:09:57','2025-11-17 21:09:57',NULL,'public'),(51,0,'2','2',4,'image/jpeg',12879,'galleries/2.jpg','[]','2025-11-17 21:09:57','2025-11-17 21:09:57',NULL,'public'),(52,0,'3','3',4,'image/jpeg',12879,'galleries/3.jpg','[]','2025-11-17 21:09:58','2025-11-17 21:09:58',NULL,'public'),(53,0,'4','4',4,'image/jpeg',12879,'galleries/4.jpg','[]','2025-11-17 21:09:58','2025-11-17 21:09:58',NULL,'public'),(54,0,'5','5',4,'image/jpeg',12879,'galleries/5.jpg','[]','2025-11-17 21:09:58','2025-11-17 21:09:58',NULL,'public'),(55,0,'6','6',4,'image/jpeg',12879,'galleries/6.jpg','[]','2025-11-17 21:09:59','2025-11-17 21:09:59',NULL,'public'),(56,0,'7','7',4,'image/jpeg',12879,'galleries/7.jpg','[]','2025-11-17 21:09:59','2025-11-17 21:09:59',NULL,'public'),(57,0,'8','8',4,'image/jpeg',12879,'galleries/8.jpg','[]','2025-11-17 21:09:59','2025-11-17 21:09:59',NULL,'public'),(58,0,'9','9',4,'image/jpeg',12879,'galleries/9.jpg','[]','2025-11-17 21:09:59','2025-11-17 21:09:59',NULL,'public'),(59,0,'1','1',5,'image/jpeg',9803,'teams/1.jpg','[]','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL,'public'),(60,0,'2','2',5,'image/jpeg',9803,'teams/2.jpg','[]','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL,'public'),(61,0,'3','3',5,'image/jpeg',9803,'teams/3.jpg','[]','2025-11-17 21:10:00','2025-11-17 21:10:00',NULL,'public'),(62,0,'4','4',5,'image/jpeg',9803,'teams/4.jpg','[]','2025-11-17 21:10:01','2025-11-17 21:10:01',NULL,'public'),(63,0,'5','5',5,'image/jpeg',9803,'teams/5.jpg','[]','2025-11-17 21:10:01','2025-11-17 21:10:01',NULL,'public'),(64,0,'6','6',5,'image/jpeg',9803,'teams/6.jpg','[]','2025-11-17 21:10:01','2025-11-17 21:10:01',NULL,'public'),(65,0,'7','7',5,'image/jpeg',9803,'teams/7.jpg','[]','2025-11-17 21:10:02','2025-11-17 21:10:02',NULL,'public'),(66,0,'8','8',5,'image/jpeg',9803,'teams/8.jpg','[]','2025-11-17 21:10:02','2025-11-17 21:10:02',NULL,'public'),(67,0,'1','1',6,'image/png',3750,'testimonials/1.png','[]','2025-11-17 21:10:02','2025-11-17 21:10:02',NULL,'public'),(68,0,'2','2',6,'image/png',3750,'testimonials/2.png','[]','2025-11-17 21:10:02','2025-11-17 21:10:02',NULL,'public'),(69,0,'3','3',6,'image/png',3750,'testimonials/3.png','[]','2025-11-17 21:10:03','2025-11-17 21:10:03',NULL,'public'),(70,0,'4','4',6,'image/png',3750,'testimonials/4.png','[]','2025-11-17 21:10:03','2025-11-17 21:10:03',NULL,'public'),(71,0,'location1','location1',7,'image/jpeg',11707,'locations/location1.jpg','[]','2025-11-17 21:10:03','2025-11-17 21:10:03',NULL,'public'),(72,0,'location2','location2',7,'image/jpeg',11707,'locations/location2.jpg','[]','2025-11-17 21:10:04','2025-11-17 21:10:04',NULL,'public'),(73,0,'location3','location3',7,'image/jpeg',11707,'locations/location3.jpg','[]','2025-11-17 21:10:04','2025-11-17 21:10:04',NULL,'public'),(74,0,'location4','location4',7,'image/jpeg',11707,'locations/location4.jpg','[]','2025-11-17 21:10:04','2025-11-17 21:10:04',NULL,'public'),(75,0,'location5','location5',7,'image/jpeg',11707,'locations/location5.jpg','[]','2025-11-17 21:10:04','2025-11-17 21:10:04',NULL,'public'),(76,0,'location6','location6',7,'image/jpeg',11707,'locations/location6.jpg','[]','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL,'public'),(77,0,'1','1',8,'image/jpeg',3916,'customers/1.jpg','[]','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL,'public'),(78,0,'10','10',8,'image/jpeg',3916,'customers/10.jpg','[]','2025-11-17 21:10:05','2025-11-17 21:10:05',NULL,'public'),(79,0,'11','11',8,'image/jpeg',3916,'customers/11.jpg','[]','2025-11-17 21:10:06','2025-11-17 21:10:06',NULL,'public'),(80,0,'12','12',8,'image/jpeg',3916,'customers/12.jpg','[]','2025-11-17 21:10:06','2025-11-17 21:10:06',NULL,'public'),(81,0,'13','13',8,'image/jpeg',3916,'customers/13.jpg','[]','2025-11-17 21:10:06','2025-11-17 21:10:06',NULL,'public'),(82,0,'14','14',8,'image/jpeg',3916,'customers/14.jpg','[]','2025-11-17 21:10:06','2025-11-17 21:10:06',NULL,'public'),(83,0,'15','15',8,'image/jpeg',3916,'customers/15.jpg','[]','2025-11-17 21:10:07','2025-11-17 21:10:07',NULL,'public'),(84,0,'16','16',8,'image/jpeg',3916,'customers/16.jpg','[]','2025-11-17 21:10:07','2025-11-17 21:10:07',NULL,'public'),(85,0,'17','17',8,'image/jpeg',3916,'customers/17.jpg','[]','2025-11-17 21:10:07','2025-11-17 21:10:07',NULL,'public'),(86,0,'18','18',8,'image/jpeg',3916,'customers/18.jpg','[]','2025-11-17 21:10:08','2025-11-17 21:10:08',NULL,'public'),(87,0,'19','19',8,'image/jpeg',3916,'customers/19.jpg','[]','2025-11-17 21:10:08','2025-11-17 21:10:08',NULL,'public'),(88,0,'2','2',8,'image/jpeg',3916,'customers/2.jpg','[]','2025-11-17 21:10:09','2025-11-17 21:10:09',NULL,'public'),(89,0,'20','20',8,'image/jpeg',3916,'customers/20.jpg','[]','2025-11-17 21:10:09','2025-11-17 21:10:09',NULL,'public'),(90,0,'21','21',8,'image/jpeg',3916,'customers/21.jpg','[]','2025-11-17 21:10:10','2025-11-17 21:10:10',NULL,'public'),(91,0,'22','22',8,'image/jpeg',3916,'customers/22.jpg','[]','2025-11-17 21:10:10','2025-11-17 21:10:10',NULL,'public'),(92,0,'23','23',8,'image/jpeg',3916,'customers/23.jpg','[]','2025-11-17 21:10:10','2025-11-17 21:10:10',NULL,'public'),(93,0,'24','24',8,'image/jpeg',3916,'customers/24.jpg','[]','2025-11-17 21:10:10','2025-11-17 21:10:10',NULL,'public'),(94,0,'25','25',8,'image/jpeg',3916,'customers/25.jpg','[]','2025-11-17 21:10:11','2025-11-17 21:10:11',NULL,'public'),(95,0,'26','26',8,'image/jpeg',3916,'customers/26.jpg','[]','2025-11-17 21:10:11','2025-11-17 21:10:11',NULL,'public'),(96,0,'27','27',8,'image/jpeg',3916,'customers/27.jpg','[]','2025-11-17 21:10:11','2025-11-17 21:10:11',NULL,'public'),(97,0,'28','28',8,'image/jpeg',3916,'customers/28.jpg','[]','2025-11-17 21:10:12','2025-11-17 21:10:12',NULL,'public'),(98,0,'29','29',8,'image/jpeg',3916,'customers/29.jpg','[]','2025-11-17 21:10:12','2025-11-17 21:10:12',NULL,'public'),(99,0,'3','3',8,'image/jpeg',3916,'customers/3.jpg','[]','2025-11-17 21:10:12','2025-11-17 21:10:12',NULL,'public'),(100,0,'30','30',8,'image/jpeg',3916,'customers/30.jpg','[]','2025-11-17 21:10:13','2025-11-17 21:10:13',NULL,'public'),(101,0,'31','31',8,'image/jpeg',3916,'customers/31.jpg','[]','2025-11-17 21:10:13','2025-11-17 21:10:13',NULL,'public'),(102,0,'4','4',8,'image/jpeg',3916,'customers/4.jpg','[]','2025-11-17 21:10:14','2025-11-17 21:10:14',NULL,'public'),(103,0,'5','5',8,'image/jpeg',3916,'customers/5.jpg','[]','2025-11-17 21:10:14','2025-11-17 21:10:14',NULL,'public'),(104,0,'6','6',8,'image/jpeg',3916,'customers/6.jpg','[]','2025-11-17 21:10:15','2025-11-17 21:10:15',NULL,'public'),(105,0,'7','7',8,'image/jpeg',3916,'customers/7.jpg','[]','2025-11-17 21:10:15','2025-11-17 21:10:15',NULL,'public'),(106,0,'8','8',8,'image/jpeg',3916,'customers/8.jpg','[]','2025-11-17 21:10:15','2025-11-17 21:10:15',NULL,'public'),(107,0,'9','9',8,'image/jpeg',3916,'customers/9.jpg','[]','2025-11-17 21:10:16','2025-11-17 21:10:16',NULL,'public'),(108,0,'1','1',9,'image/jpeg',33268,'cars/1.jpg','[]','2025-11-17 21:10:25','2025-11-17 21:10:25',NULL,'public'),(109,0,'10','10',9,'image/jpeg',33268,'cars/10.jpg','[]','2025-11-17 21:10:26','2025-11-17 21:10:26',NULL,'public'),(110,0,'100','100',9,'image/jpeg',33268,'cars/100.jpg','[]','2025-11-17 21:10:26','2025-11-17 21:10:26',NULL,'public'),(111,0,'101','101',9,'image/jpeg',33268,'cars/101.jpg','[]','2025-11-17 21:10:26','2025-11-17 21:10:26',NULL,'public'),(112,0,'102','102',9,'image/jpeg',33268,'cars/102.jpg','[]','2025-11-17 21:10:27','2025-11-17 21:10:27',NULL,'public'),(113,0,'103','103',9,'image/jpeg',33268,'cars/103.jpg','[]','2025-11-17 21:10:27','2025-11-17 21:10:27',NULL,'public'),(114,0,'104','104',9,'image/jpeg',33268,'cars/104.jpg','[]','2025-11-17 21:10:27','2025-11-17 21:10:27',NULL,'public'),(115,0,'105','105',9,'image/jpeg',33268,'cars/105.jpg','[]','2025-11-17 21:10:28','2025-11-17 21:10:28',NULL,'public'),(116,0,'11','11',9,'image/jpeg',33268,'cars/11.jpg','[]','2025-11-17 21:10:28','2025-11-17 21:10:28',NULL,'public'),(117,0,'12','12',9,'image/jpeg',33268,'cars/12.jpg','[]','2025-11-17 21:10:29','2025-11-17 21:10:29',NULL,'public'),(118,0,'13','13',9,'image/jpeg',33268,'cars/13.jpg','[]','2025-11-17 21:10:29','2025-11-17 21:10:29',NULL,'public'),(119,0,'14','14',9,'image/jpeg',33268,'cars/14.jpg','[]','2025-11-17 21:10:30','2025-11-17 21:10:30',NULL,'public'),(120,0,'15','15',9,'image/jpeg',33268,'cars/15.jpg','[]','2025-11-17 21:10:30','2025-11-17 21:10:30',NULL,'public'),(121,0,'16','16',9,'image/jpeg',33268,'cars/16.jpg','[]','2025-11-17 21:10:30','2025-11-17 21:10:30',NULL,'public'),(122,0,'17','17',9,'image/jpeg',33268,'cars/17.jpg','[]','2025-11-17 21:10:31','2025-11-17 21:10:31',NULL,'public'),(123,0,'18','18',9,'image/jpeg',33268,'cars/18.jpg','[]','2025-11-17 21:10:31','2025-11-17 21:10:31',NULL,'public'),(124,0,'19','19',9,'image/jpeg',33268,'cars/19.jpg','[]','2025-11-17 21:10:31','2025-11-17 21:10:31',NULL,'public'),(125,0,'2','2',9,'image/jpeg',33268,'cars/2.jpg','[]','2025-11-17 21:10:32','2025-11-17 21:10:32',NULL,'public'),(126,0,'20','20',9,'image/jpeg',33268,'cars/20.jpg','[]','2025-11-17 21:10:32','2025-11-17 21:10:32',NULL,'public'),(127,0,'21','21',9,'image/jpeg',33268,'cars/21.jpg','[]','2025-11-17 21:10:33','2025-11-17 21:10:33',NULL,'public'),(128,0,'22','22',9,'image/jpeg',33268,'cars/22.jpg','[]','2025-11-17 21:10:33','2025-11-17 21:10:33',NULL,'public'),(129,0,'23','23',9,'image/jpeg',33268,'cars/23.jpg','[]','2025-11-17 21:10:33','2025-11-17 21:10:33',NULL,'public'),(130,0,'24','24',9,'image/jpeg',33268,'cars/24.jpg','[]','2025-11-17 21:10:34','2025-11-17 21:10:34',NULL,'public'),(131,0,'25','25',9,'image/jpeg',33268,'cars/25.jpg','[]','2025-11-17 21:10:34','2025-11-17 21:10:34',NULL,'public'),(132,0,'26','26',9,'image/jpeg',33268,'cars/26.jpg','[]','2025-11-17 21:10:35','2025-11-17 21:10:35',NULL,'public'),(133,0,'27','27',9,'image/jpeg',33268,'cars/27.jpg','[]','2025-11-17 21:10:35','2025-11-17 21:10:35',NULL,'public'),(134,0,'28','28',9,'image/jpeg',33268,'cars/28.jpg','[]','2025-11-17 21:10:35','2025-11-17 21:10:35',NULL,'public'),(135,0,'29','29',9,'image/jpeg',33268,'cars/29.jpg','[]','2025-11-17 21:10:36','2025-11-17 21:10:36',NULL,'public'),(136,0,'3','3',9,'image/jpeg',33268,'cars/3.jpg','[]','2025-11-17 21:10:36','2025-11-17 21:10:36',NULL,'public'),(137,0,'30','30',9,'image/jpeg',33268,'cars/30.jpg','[]','2025-11-17 21:10:36','2025-11-17 21:10:36',NULL,'public'),(138,0,'31','31',9,'image/jpeg',33268,'cars/31.jpg','[]','2025-11-17 21:10:37','2025-11-17 21:10:37',NULL,'public'),(139,0,'32','32',9,'image/jpeg',33268,'cars/32.jpg','[]','2025-11-17 21:10:37','2025-11-17 21:10:37',NULL,'public'),(140,0,'33','33',9,'image/jpeg',33268,'cars/33.jpg','[]','2025-11-17 21:10:38','2025-11-17 21:10:38',NULL,'public'),(141,0,'34','34',9,'image/jpeg',33268,'cars/34.jpg','[]','2025-11-17 21:10:38','2025-11-17 21:10:38',NULL,'public'),(142,0,'35','35',9,'image/jpeg',33268,'cars/35.jpg','[]','2025-11-17 21:10:38','2025-11-17 21:10:38',NULL,'public'),(143,0,'36','36',9,'image/jpeg',33268,'cars/36.jpg','[]','2025-11-17 21:10:39','2025-11-17 21:10:39',NULL,'public'),(144,0,'37','37',9,'image/jpeg',33268,'cars/37.jpg','[]','2025-11-17 21:10:39','2025-11-17 21:10:39',NULL,'public'),(145,0,'38','38',9,'image/jpeg',33268,'cars/38.jpg','[]','2025-11-17 21:10:39','2025-11-17 21:10:39',NULL,'public'),(146,0,'39','39',9,'image/jpeg',33268,'cars/39.jpg','[]','2025-11-17 21:10:40','2025-11-17 21:10:40',NULL,'public'),(147,0,'4','4',9,'image/jpeg',33268,'cars/4.jpg','[]','2025-11-17 21:10:40','2025-11-17 21:10:40',NULL,'public'),(148,0,'40','40',9,'image/jpeg',33268,'cars/40.jpg','[]','2025-11-17 21:10:41','2025-11-17 21:10:41',NULL,'public'),(149,0,'41','41',9,'image/jpeg',33268,'cars/41.jpg','[]','2025-11-17 21:10:41','2025-11-17 21:10:41',NULL,'public'),(150,0,'42','42',9,'image/jpeg',33268,'cars/42.jpg','[]','2025-11-17 21:10:41','2025-11-17 21:10:41',NULL,'public'),(151,0,'43','43',9,'image/jpeg',33268,'cars/43.jpg','[]','2025-11-17 21:10:42','2025-11-17 21:10:42',NULL,'public'),(152,0,'44','44',9,'image/jpeg',33268,'cars/44.jpg','[]','2025-11-17 21:10:42','2025-11-17 21:10:42',NULL,'public'),(153,0,'45','45',9,'image/jpeg',33268,'cars/45.jpg','[]','2025-11-17 21:10:43','2025-11-17 21:10:43',NULL,'public'),(154,0,'46','46',9,'image/jpeg',33268,'cars/46.jpg','[]','2025-11-17 21:10:43','2025-11-17 21:10:43',NULL,'public'),(155,0,'47','47',9,'image/jpeg',33268,'cars/47.jpg','[]','2025-11-17 21:10:43','2025-11-17 21:10:43',NULL,'public'),(156,0,'48','48',9,'image/jpeg',33268,'cars/48.jpg','[]','2025-11-17 21:10:44','2025-11-17 21:10:44',NULL,'public'),(157,0,'49','49',9,'image/jpeg',33268,'cars/49.jpg','[]','2025-11-17 21:10:44','2025-11-17 21:10:44',NULL,'public'),(158,0,'5','5',9,'image/jpeg',33268,'cars/5.jpg','[]','2025-11-17 21:10:45','2025-11-17 21:10:45',NULL,'public'),(159,0,'50','50',9,'image/jpeg',33268,'cars/50.jpg','[]','2025-11-17 21:10:45','2025-11-17 21:10:45',NULL,'public'),(160,0,'51','51',9,'image/jpeg',33268,'cars/51.jpg','[]','2025-11-17 21:10:45','2025-11-17 21:10:45',NULL,'public'),(161,0,'52','52',9,'image/jpeg',33268,'cars/52.jpg','[]','2025-11-17 21:10:46','2025-11-17 21:10:46',NULL,'public'),(162,0,'53','53',9,'image/jpeg',33268,'cars/53.jpg','[]','2025-11-17 21:10:46','2025-11-17 21:10:46',NULL,'public'),(163,0,'54','54',9,'image/jpeg',33268,'cars/54.jpg','[]','2025-11-17 21:10:47','2025-11-17 21:10:47',NULL,'public'),(164,0,'55','55',9,'image/jpeg',33268,'cars/55.jpg','[]','2025-11-17 21:10:47','2025-11-17 21:10:47',NULL,'public'),(165,0,'56','56',9,'image/jpeg',33268,'cars/56.jpg','[]','2025-11-17 21:10:48','2025-11-17 21:10:48',NULL,'public'),(166,0,'57','57',9,'image/jpeg',33268,'cars/57.jpg','[]','2025-11-17 21:10:48','2025-11-17 21:10:48',NULL,'public'),(167,0,'58','58',9,'image/jpeg',33268,'cars/58.jpg','[]','2025-11-17 21:10:48','2025-11-17 21:10:48',NULL,'public'),(168,0,'59','59',9,'image/jpeg',33268,'cars/59.jpg','[]','2025-11-17 21:10:49','2025-11-17 21:10:49',NULL,'public'),(169,0,'6','6',9,'image/jpeg',33268,'cars/6.jpg','[]','2025-11-17 21:10:49','2025-11-17 21:10:49',NULL,'public'),(170,0,'60','60',9,'image/jpeg',33268,'cars/60.jpg','[]','2025-11-17 21:10:49','2025-11-17 21:10:49',NULL,'public'),(171,0,'61','61',9,'image/jpeg',33268,'cars/61.jpg','[]','2025-11-17 21:10:50','2025-11-17 21:10:50',NULL,'public'),(172,0,'62','62',9,'image/jpeg',33268,'cars/62.jpg','[]','2025-11-17 21:10:50','2025-11-17 21:10:50',NULL,'public'),(173,0,'63','63',9,'image/jpeg',33268,'cars/63.jpg','[]','2025-11-17 21:10:51','2025-11-17 21:10:51',NULL,'public'),(174,0,'64','64',9,'image/jpeg',33268,'cars/64.jpg','[]','2025-11-17 21:10:51','2025-11-17 21:10:51',NULL,'public'),(175,0,'65','65',9,'image/jpeg',33268,'cars/65.jpg','[]','2025-11-17 21:10:51','2025-11-17 21:10:51',NULL,'public'),(176,0,'66','66',9,'image/jpeg',33268,'cars/66.jpg','[]','2025-11-17 21:10:52','2025-11-17 21:10:52',NULL,'public'),(177,0,'67','67',9,'image/jpeg',33268,'cars/67.jpg','[]','2025-11-17 21:10:52','2025-11-17 21:10:52',NULL,'public'),(178,0,'68','68',9,'image/jpeg',33268,'cars/68.jpg','[]','2025-11-17 21:10:53','2025-11-17 21:10:53',NULL,'public'),(179,0,'69','69',9,'image/jpeg',33268,'cars/69.jpg','[]','2025-11-17 21:10:53','2025-11-17 21:10:53',NULL,'public'),(180,0,'7','7',9,'image/jpeg',33268,'cars/7.jpg','[]','2025-11-17 21:10:54','2025-11-17 21:10:54',NULL,'public'),(181,0,'70','70',9,'image/jpeg',33268,'cars/70.jpg','[]','2025-11-17 21:10:54','2025-11-17 21:10:54',NULL,'public'),(182,0,'71','71',9,'image/jpeg',33268,'cars/71.jpg','[]','2025-11-17 21:10:54','2025-11-17 21:10:54',NULL,'public'),(183,0,'72','72',9,'image/jpeg',33268,'cars/72.jpg','[]','2025-11-17 21:10:55','2025-11-17 21:10:55',NULL,'public'),(184,0,'73','73',9,'image/jpeg',33268,'cars/73.jpg','[]','2025-11-17 21:10:55','2025-11-17 21:10:55',NULL,'public'),(185,0,'74','74',9,'image/jpeg',33268,'cars/74.jpg','[]','2025-11-17 21:10:55','2025-11-17 21:10:55',NULL,'public'),(186,0,'75','75',9,'image/jpeg',33268,'cars/75.jpg','[]','2025-11-17 21:10:56','2025-11-17 21:10:56',NULL,'public'),(187,0,'76','76',9,'image/jpeg',33268,'cars/76.jpg','[]','2025-11-17 21:10:56','2025-11-17 21:10:56',NULL,'public'),(188,0,'77','77',9,'image/jpeg',33268,'cars/77.jpg','[]','2025-11-17 21:10:57','2025-11-17 21:10:57',NULL,'public'),(189,0,'78','78',9,'image/jpeg',33268,'cars/78.jpg','[]','2025-11-17 21:10:57','2025-11-17 21:10:57',NULL,'public'),(190,0,'79','79',9,'image/jpeg',33268,'cars/79.jpg','[]','2025-11-17 21:10:58','2025-11-17 21:10:58',NULL,'public'),(191,0,'8','8',9,'image/jpeg',33268,'cars/8.jpg','[]','2025-11-17 21:10:58','2025-11-17 21:10:58',NULL,'public'),(192,0,'80','80',9,'image/jpeg',33268,'cars/80.jpg','[]','2025-11-17 21:10:58','2025-11-17 21:10:58',NULL,'public'),(193,0,'81','81',9,'image/jpeg',33268,'cars/81.jpg','[]','2025-11-17 21:10:59','2025-11-17 21:10:59',NULL,'public'),(194,0,'82','82',9,'image/jpeg',33268,'cars/82.jpg','[]','2025-11-17 21:10:59','2025-11-17 21:10:59',NULL,'public'),(195,0,'83','83',9,'image/jpeg',33268,'cars/83.jpg','[]','2025-11-17 21:11:00','2025-11-17 21:11:00',NULL,'public'),(196,0,'84','84',9,'image/jpeg',33268,'cars/84.jpg','[]','2025-11-17 21:11:00','2025-11-17 21:11:00',NULL,'public'),(197,0,'85','85',9,'image/jpeg',33268,'cars/85.jpg','[]','2025-11-17 21:11:01','2025-11-17 21:11:01',NULL,'public'),(198,0,'86','86',9,'image/jpeg',33268,'cars/86.jpg','[]','2025-11-17 21:11:01','2025-11-17 21:11:01',NULL,'public'),(199,0,'87','87',9,'image/jpeg',33268,'cars/87.jpg','[]','2025-11-17 21:11:02','2025-11-17 21:11:02',NULL,'public'),(200,0,'88','88',9,'image/jpeg',33268,'cars/88.jpg','[]','2025-11-17 21:11:02','2025-11-17 21:11:02',NULL,'public'),(201,0,'89','89',9,'image/jpeg',33268,'cars/89.jpg','[]','2025-11-17 21:11:03','2025-11-17 21:11:03',NULL,'public'),(202,0,'9','9',9,'image/jpeg',33268,'cars/9.jpg','[]','2025-11-17 21:11:03','2025-11-17 21:11:03',NULL,'public'),(203,0,'90','90',9,'image/jpeg',33268,'cars/90.jpg','[]','2025-11-17 21:11:03','2025-11-17 21:11:03',NULL,'public'),(204,0,'91','91',9,'image/jpeg',33268,'cars/91.jpg','[]','2025-11-17 21:11:04','2025-11-17 21:11:04',NULL,'public'),(205,0,'92','92',9,'image/jpeg',33268,'cars/92.jpg','[]','2025-11-17 21:11:04','2025-11-17 21:11:04',NULL,'public'),(206,0,'93','93',9,'image/jpeg',33268,'cars/93.jpg','[]','2025-11-17 21:11:05','2025-11-17 21:11:05',NULL,'public'),(207,0,'94','94',9,'image/jpeg',33268,'cars/94.jpg','[]','2025-11-17 21:11:05','2025-11-17 21:11:05',NULL,'public'),(208,0,'95','95',9,'image/jpeg',33268,'cars/95.jpg','[]','2025-11-17 21:11:06','2025-11-17 21:11:06',NULL,'public'),(209,0,'96','96',9,'image/jpeg',33268,'cars/96.jpg','[]','2025-11-17 21:11:06','2025-11-17 21:11:06',NULL,'public'),(210,0,'97','97',9,'image/jpeg',33268,'cars/97.jpg','[]','2025-11-17 21:11:07','2025-11-17 21:11:07',NULL,'public'),(211,0,'98','98',9,'image/jpeg',33268,'cars/98.jpg','[]','2025-11-17 21:11:07','2025-11-17 21:11:07',NULL,'public'),(212,0,'99','99',9,'image/jpeg',33268,'cars/99.jpg','[]','2025-11-17 21:11:07','2025-11-17 21:11:07',NULL,'public'),(213,0,'car-1','car-1',9,'image/jpeg',33268,'cars/car-1.jpg','[]','2025-11-17 21:11:08','2025-11-17 21:11:08',NULL,'public'),(214,0,'car-2','car-2',9,'image/jpeg',33268,'cars/car-2.jpg','[]','2025-11-17 21:11:08','2025-11-17 21:11:08',NULL,'public'),(215,0,'car-3','car-3',9,'image/jpeg',33268,'cars/car-3.jpg','[]','2025-11-17 21:11:09','2025-11-17 21:11:09',NULL,'public'),(216,0,'car-4','car-4',9,'image/jpeg',33268,'cars/car-4.jpg','[]','2025-11-17 21:11:09','2025-11-17 21:11:09',NULL,'public'),(217,0,'car-5','car-5',9,'image/jpeg',33268,'cars/car-5.jpg','[]','2025-11-17 21:11:10','2025-11-17 21:11:10',NULL,'public'),(218,0,'car-6','car-6',9,'image/jpeg',33268,'cars/car-6.jpg','[]','2025-11-17 21:11:10','2025-11-17 21:11:10',NULL,'public'),(219,0,'car-7','car-7',9,'image/jpeg',33268,'cars/car-7.jpg','[]','2025-11-17 21:11:11','2025-11-17 21:11:11',NULL,'public'),(220,0,'car-8','car-8',9,'image/jpeg',33268,'cars/car-8.jpg','[]','2025-11-17 21:11:11','2025-11-17 21:11:11',NULL,'public'),(221,0,'car-interiors-1','car-interiors-1',9,'image/jpeg',33268,'cars/car-interiors-1.jpg','[]','2025-11-17 21:11:12','2025-11-17 21:11:12',NULL,'public'),(222,0,'car-interiors-2','car-interiors-2',9,'image/jpeg',33268,'cars/car-interiors-2.jpg','[]','2025-11-17 21:11:12','2025-11-17 21:11:12',NULL,'public'),(223,0,'car-interiors-3','car-interiors-3',9,'image/jpeg',33268,'cars/car-interiors-3.jpg','[]','2025-11-17 21:11:13','2025-11-17 21:11:13',NULL,'public'),(224,0,'car-interiors-4','car-interiors-4',9,'image/jpeg',33268,'cars/car-interiors-4.jpg','[]','2025-11-17 21:11:14','2025-11-17 21:11:14',NULL,'public'),(225,0,'car-interiors-5','car-interiors-5',9,'image/jpeg',33268,'cars/car-interiors-5.jpg','[]','2025-11-17 21:11:15','2025-11-17 21:11:15',NULL,'public'),(226,0,'car-interiors-6','car-interiors-6',9,'image/jpeg',33268,'cars/car-interiors-6.jpg','[]','2025-11-17 21:11:15','2025-11-17 21:11:15',NULL,'public'),(227,0,'car-interiors-7','car-interiors-7',9,'image/jpeg',33268,'cars/car-interiors-7.jpg','[]','2025-11-17 21:11:16','2025-11-17 21:11:16',NULL,'public'),(228,0,'car-interiors-8','car-interiors-8',9,'image/jpeg',33268,'cars/car-interiors-8.jpg','[]','2025-11-17 21:11:16','2025-11-17 21:11:16',NULL,'public'),(229,0,'img-1','img-1',9,'image/png',33268,'cars/img-1.png','[]','2025-11-17 21:11:17','2025-11-17 21:11:17',NULL,'public'),(230,0,'img-2','img-2',9,'image/png',33268,'cars/img-2.png','[]','2025-11-17 21:11:17','2025-11-17 21:11:17',NULL,'public'),(231,0,'banner-1','banner-1',10,'image/jpeg',23738,'sliders/banner-1.jpg','[]','2025-11-17 21:11:22','2025-11-17 21:11:22',NULL,'public'),(232,0,'banner-2','banner-2',10,'image/jpeg',23738,'sliders/banner-2.jpg','[]','2025-11-17 21:11:22','2025-11-17 21:11:22',NULL,'public'),(233,0,'img-1-1','img-1-1',10,'image/jpeg',23738,'sliders/img-1-1.jpg','[]','2025-11-17 21:11:22','2025-11-17 21:11:22',NULL,'public'),(234,0,'img-1','img-1',10,'image/jpeg',23738,'sliders/img-1.jpg','[]','2025-11-17 21:11:23','2025-11-17 21:11:23',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'general',NULL,'general',0,'2025-11-17 21:09:41','2025-11-17 21:09:41',NULL),(3,0,'news',NULL,'news',0,'2025-11-17 21:09:51','2025-11-17 21:09:51',NULL),(4,0,'galleries',NULL,'galleries',0,'2025-11-17 21:09:57','2025-11-17 21:09:57',NULL),(5,0,'teams',NULL,'teams',0,'2025-11-17 21:10:00','2025-11-17 21:10:00',NULL),(6,0,'testimonials',NULL,'testimonials',0,'2025-11-17 21:10:02','2025-11-17 21:10:02',NULL),(7,0,'locations',NULL,'locations',0,'2025-11-17 21:10:03','2025-11-17 21:10:03',NULL),(8,0,'customers',NULL,'customers',0,'2025-11-17 21:10:05','2025-11-17 21:10:05',NULL),(9,0,'cars',NULL,'cars',0,'2025-11-17 21:10:25','2025-11-17 21:10:25',NULL),(10,0,'sliders',NULL,'sliders',0,'2025-11-17 21:11:22','2025-11-17 21:11:22',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-11-17 21:09:50','2025-11-17 21:09:50');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(2,1,1,NULL,NULL,'https://carento.botble.com',NULL,0,'Home Page v1',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(3,1,1,NULL,NULL,'https://carento-home-2.botble.com',NULL,1,'Home Page v2',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(4,1,1,NULL,NULL,'https://carento-home-3.botble.com',NULL,2,'Home Page v3',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(5,1,0,NULL,NULL,'/',NULL,1,'Vehicles',NULL,'_self',1,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(6,1,5,7,'Botble\\Page\\Models\\Page','/car-list-1',NULL,0,'Cars List v1',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(7,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024',NULL,1,'Car Detail v1',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(8,1,5,8,'Botble\\Page\\Models\\Page','/car-list-2',NULL,2,'Car List v2',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(9,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-2',NULL,3,'Car Detail v2',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(10,1,5,9,'Botble\\Page\\Models\\Page','/car-list-3',NULL,4,'Car List v3',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(11,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-3',NULL,5,'Car Detail v3',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(12,1,5,10,'Botble\\Page\\Models\\Page','/car-list-4',NULL,6,'Car List v4',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(13,1,5,NULL,NULL,'/cars/honda-accord-sport-20t-2024?style=style-4',NULL,7,'Car Detail v4',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(14,1,0,NULL,NULL,'/',NULL,2,'Pages',NULL,'_self',1,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(15,1,14,6,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'About Us',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(16,1,14,4,'Botble\\Page\\Models\\Page','/services',NULL,1,'Our Services',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(17,1,14,5,'Botble\\Page\\Models\\Page','/pricing',NULL,2,'Pricing',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(18,1,14,12,'Botble\\Page\\Models\\Page','/faqs',NULL,3,'FAQs',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(19,1,14,14,'Botble\\Page\\Models\\Page','/car-dealers',NULL,4,'Car Dealers',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(20,1,14,17,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,5,'Term',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(21,1,14,NULL,NULL,'/login',NULL,6,'Login',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(22,1,14,NULL,NULL,'/register',NULL,7,'Register',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(23,1,0,NULL,NULL,'/',NULL,3,'News',NULL,'_self',1,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(24,1,23,2,'Botble\\Page\\Models\\Page','/blog',NULL,0,'News Grid',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:51'),(25,1,23,NULL,NULL,'/blog?style=list',NULL,1,'News List',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(26,1,23,NULL,NULL,'/news/top-5-new-cars-to-look-out-for-in-2024',NULL,2,'New Detail',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:50'),(27,1,0,3,'Botble\\Page\\Models\\Page','/contact',NULL,4,'Contact',NULL,'_self',0,'2025-11-17 21:09:50','2025-11-17 21:09:51');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-11-17 21:09:50','2025-11-17 21:09:50');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'content_on_top','[\"[car-advance-search button_search_name=\\\"Find a Vehicle\\\" link_need_help=\\\"\\/faqs\\\" top=\\\"0\\\" bottom=\\\"0\\\" left=\\\"0\\\" right=\\\"0\\\" url=\\\"\\/cars\\\" tabs=\\\"all,new_car,used_car\\\"][\\/car-advance-search]\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:09:50','2025-11-17 21:09:50'),(2,'footer_on_top','[\"<p><span class=\\\"text-lg-medium color-white\\\">Get 5% discount when <\\/span><a class=\\\"text-primary\\\" href=\\\"#install-app\\\"><span class=\\\"text-lg-medium\\\">Ordering via APP<\\/span><\\/a><\\/p>\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:09:50','2025-11-17 21:09:50'),(3,'label_top','[\"+3600 cars for you\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(4,'keywords','[[{\"name\":\"Economy\",\"link\":\"\\/\"},{\"name\":\"Standard\",\"link\":\"\\/\"},{\"name\":\"Luxury\",\"link\":\"\\/\"},{\"name\":\"SUV\",\"link\":\"\\/\"},{\"name\":\"Convertible\",\"link\":\"\\/\"}]]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(5,'label_top','[\"Best car rental system\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(6,'keywords','[[{\"name\":\"Economy\",\"link\":\"\\/\"},{\"name\":\"Standard\",\"link\":\"\\/\"},{\"name\":\"Luxury\",\"link\":\"\\/\"},{\"name\":\"SUV\",\"link\":\"\\/\"},{\"name\":\"Convertible\",\"link\":\"\\/\"}]]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(7,'appearance','[\"style-2\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSlider','2025-11-17 21:09:50','2025-11-17 21:09:50'),(8,'subtitle','[\"2025 Mazda CX-50 <br class=\\\"d-none d-md-block\\\"> Review and news\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(9,'link_label','[\"View Details\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(10,'subtitle','[\"Hyundai Tucson Plug-In <br class=\\\"d-none d-md-block\\\"> Hybrid 2025 review\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(11,'link_label','[\"View Details\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-17 21:09:50','2025-11-17 21:09:50'),(12,'breadcrumb_simple','[true]',2,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(13,'breadcrumb_background_image','[\"backgrounds\\/contact-bg.jpg\"]',3,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(14,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(15,'breadcrumb_background_image','[\"backgrounds\\/service-bg.jpg\"]',4,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(16,'breadcrumb_text_color','[\"#ffffff\"]',4,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(17,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',5,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(18,'breadcrumb_text_color','[\"#ffffff\"]',5,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(19,'breadcrumb_background_image','[\"backgrounds\\/about-us-bg.jpg\"]',6,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(20,'breadcrumb_text_color','[\"#ffffff\"]',6,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(21,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(22,'breadcrumb_text_color','[\"#ffffff\"]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(23,'breadcrumb_display_last_update','[true]',11,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(24,'breadcrumb_simple','[true]',12,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(25,'breadcrumb_background_image','[\"backgrounds\\/brand-bg.jpg\"]',13,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(26,'breadcrumb_text_color','[\"#ffffff\"]',13,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(27,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',14,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(28,'breadcrumb_text_color','[\"#ffffff\"]',14,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(29,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',15,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(30,'breadcrumb_text_color','[\"#ffffff\"]',15,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(31,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',16,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(32,'breadcrumb_text_color','[\"#ffffff\"]',16,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(33,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',17,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(34,'breadcrumb_text_color','[\"#ffffff\"]',17,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(35,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',18,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(36,'breadcrumb_text_color','[\"#ffffff\"]',18,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(37,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',19,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(38,'breadcrumb_text_color','[\"#ffffff\"]',19,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(39,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',20,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(40,'breadcrumb_text_color','[\"#ffffff\"]',20,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(41,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',21,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(42,'breadcrumb_text_color','[\"#ffffff\"]',21,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(43,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',22,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(44,'breadcrumb_text_color','[\"#ffffff\"]',22,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(45,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',23,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(46,'breadcrumb_text_color','[\"#ffffff\"]',23,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(47,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',24,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(48,'breadcrumb_text_color','[\"#ffffff\"]',24,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(49,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',25,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(50,'breadcrumb_text_color','[\"#ffffff\"]',25,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(51,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',26,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(52,'breadcrumb_text_color','[\"#ffffff\"]',26,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(53,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',27,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(54,'breadcrumb_text_color','[\"#ffffff\"]',27,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(55,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',28,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(56,'breadcrumb_text_color','[\"#ffffff\"]',28,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(57,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',29,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(58,'breadcrumb_text_color','[\"#ffffff\"]',29,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(59,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',30,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(60,'breadcrumb_text_color','[\"#ffffff\"]',30,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(61,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',31,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(62,'breadcrumb_text_color','[\"#ffffff\"]',31,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(63,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',32,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(64,'breadcrumb_text_color','[\"#ffffff\"]',32,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(65,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',33,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(66,'breadcrumb_text_color','[\"#ffffff\"]',33,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(67,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',34,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(68,'breadcrumb_text_color','[\"#ffffff\"]',34,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(69,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',35,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(70,'breadcrumb_text_color','[\"#ffffff\"]',35,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(71,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',36,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(72,'breadcrumb_text_color','[\"#ffffff\"]',36,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(73,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',37,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(74,'breadcrumb_text_color','[\"#ffffff\"]',37,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(75,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',38,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(76,'breadcrumb_text_color','[\"#ffffff\"]',38,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(77,'breadcrumb_background_image','[\"backgrounds\\/pricing-bg.jpg\"]',39,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(78,'breadcrumb_text_color','[\"#ffffff\"]',39,'Botble\\Page\\Models\\Page','2025-11-17 21:09:50','2025-11-17 21:09:50'),(79,'logo','[\"icons\\/activity.png\"]',1,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(80,'logo_dark','[\"icons\\/activity-w.png\"]',1,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(81,'logo','[\"icons\\/flash.png\"]',2,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(82,'logo_dark','[\"icons\\/flash-w.png\"]',2,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(83,'logo','[\"icons\\/list.png\"]',3,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(84,'logo_dark','[\"icons\\/list-w.png\"]',3,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(85,'logo','[\"icons\\/refresh.png\"]',4,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(86,'logo_dark','[\"icons\\/refresh-w.png\"]',4,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(87,'logo','[\"icons\\/ticket.png\"]',5,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(88,'logo_dark','[\"icons\\/ticket-w.png\"]',5,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(89,'logo','[\"icons\\/user.png\"]',6,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(90,'logo_dark','[\"icons\\/user-w.png\"]',6,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(91,'logo','[\"icons\\/ticket.png\"]',7,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(92,'logo_dark','[\"icons\\/ticket-w.png\"]',7,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(93,'logo','[\"icons\\/wallet.png\"]',8,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(94,'logo_dark','[\"icons\\/wallet-w.png\"]',8,'Botble\\Faq\\Models\\FaqCategory','2025-11-17 21:10:00','2025-11-17 21:10:00'),(95,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:10:03','2025-11-17 21:10:03'),(96,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:10:03','2025-11-17 21:10:03'),(97,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:10:03','2025-11-17 21:10:03'),(98,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-11-17 21:10:03','2025-11-17 21:10:03'),(99,'logo_dark','[\"icons\\/lexus-w.png\"]',1,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(100,'logo_invert','[\"icons\\/lexus-w.png\"]',1,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(101,'logo_dark','[\"icons\\/mer-w.png\"]',2,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(102,'logo_invert','[\"icons\\/mer-i.png\"]',2,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(103,'logo_dark','[\"icons\\/bugatti-w.png\"]',3,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(104,'logo_invert','[\"icons\\/bugatti-w.png\"]',3,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(105,'logo_dark','[\"icons\\/jaguar-w.png\"]',4,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(106,'logo_invert','[\"icons\\/jaguar-w.png\"]',4,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(107,'logo_dark','[\"icons\\/honda-w.png\"]',5,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(108,'logo_invert','[\"icons\\/honda-w.png\"]',5,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(109,'logo_dark','[\"icons\\/chevrolet-w.png\"]',6,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(110,'logo_invert','[\"icons\\/chevrolet-w.png\"]',6,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(111,'logo_dark','[\"icons\\/acura-w.png\"]',7,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(112,'logo_invert','[\"icons\\/acura-w.png\"]',7,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(113,'logo_dark','[\"icons\\/bmw-w.png\"]',8,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(114,'logo_invert','[\"icons\\/bmw-i.png\"]',8,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(115,'logo_dark','[\"icons\\/toyota-w.png\"]',9,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(116,'logo_invert','[\"icons\\/toyota-i.png\"]',9,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(117,'logo_dark','[\"icons\\/ford-i.png\"]',10,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(118,'logo_invert','[\"icons\\/ford-i.png\"]',10,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(119,'logo_dark','[\"icons\\/nissan-w.png\"]',11,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(120,'logo_invert','[\"icons\\/nissan-i.png\"]',11,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(121,'logo_dark','[\"icons\\/opel-w.png\"]',12,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(122,'logo_invert','[\"icons\\/opel-i.png\"]',12,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(123,'logo_dark','[\"icons\\/bmw-w.png\"]',13,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(124,'logo_invert','[\"icons\\/bmw-i.png\"]',13,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(125,'logo_dark','[\"icons\\/toyota-w.png\"]',14,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(126,'logo_invert','[\"icons\\/toyota-i.png\"]',14,'Botble\\CarRentals\\Models\\CarMake','2025-11-17 21:10:24','2025-11-17 21:10:24'),(127,'faq_ids','[[2,5,6,7,8]]',1,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:17','2025-11-17 21:11:17'),(128,'faq_ids','[[3,4,7,9,10]]',2,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(129,'faq_ids','[[1,2,6,7,10]]',3,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(130,'faq_ids','[[1,6,7,9,10]]',4,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(131,'faq_ids','[[3,5,7,8,10]]',5,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(132,'faq_ids','[[5,6,7,8,9]]',6,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(133,'faq_ids','[[1,2,3,5,10]]',7,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(134,'faq_ids','[[3,6,8,9,10]]',8,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(135,'faq_ids','[[3,4,5,6,10]]',9,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(136,'faq_ids','[[1,2,3,6,9]]',10,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(137,'faq_ids','[[2,4,5,8,10]]',11,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(138,'faq_ids','[[4,6,8,9,10]]',12,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(139,'faq_ids','[[1,3,4,6,9]]',13,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(140,'faq_ids','[[1,3,4,9,10]]',14,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(141,'faq_ids','[[1,5,7,8,10]]',15,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(142,'faq_ids','[[2,3,5,7,10]]',16,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(143,'faq_ids','[[1,3,6,7,9]]',17,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(144,'faq_ids','[[2,4,6,7,9]]',18,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(145,'faq_ids','[[2,4,7,8,9]]',19,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(146,'faq_ids','[[2,3,4,8,10]]',20,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(147,'faq_ids','[[1,2,5,7,9]]',21,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(148,'faq_ids','[[1,3,5,6,7]]',22,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(149,'faq_ids','[[1,5,7,8,10]]',23,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(150,'faq_ids','[[2,4,5,8,10]]',24,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(151,'faq_ids','[[1,2,7,8,9]]',25,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(152,'faq_ids','[[3,4,6,8,9]]',26,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(153,'faq_ids','[[2,3,4,5,6]]',27,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(154,'faq_ids','[[5,6,8,9,10]]',28,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(155,'faq_ids','[[2,3,4,7,9]]',29,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(156,'faq_ids','[[1,3,4,5,9]]',30,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(157,'faq_ids','[[2,3,7,9,10]]',31,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(158,'faq_ids','[[3,5,6,9,10]]',32,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(159,'faq_ids','[[3,4,6,8,9]]',33,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(160,'faq_ids','[[1,2,6,7,9]]',34,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(161,'faq_ids','[[2,3,4,6,9]]',35,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:18','2025-11-17 21:11:18'),(162,'faq_ids','[[2,3,4,7,8]]',36,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(163,'faq_ids','[[2,4,6,9,10]]',37,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(164,'faq_ids','[[1,3,5,8,9]]',38,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(165,'faq_ids','[[3,4,6,7,8]]',39,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(166,'faq_ids','[[3,6,7,8,10]]',40,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(167,'faq_ids','[[1,2,4,8,10]]',41,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(168,'faq_ids','[[1,2,6,8,10]]',42,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(169,'faq_ids','[[3,4,5,8,9]]',43,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(170,'faq_ids','[[3,6,7,8,10]]',44,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(171,'faq_ids','[[1,2,7,8,10]]',45,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(172,'faq_ids','[[1,4,8,9,10]]',46,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(173,'faq_ids','[[1,2,4,5,6]]',47,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(174,'faq_ids','[[3,6,8,9,10]]',48,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(175,'faq_ids','[[1,3,7,9,10]]',49,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(176,'faq_ids','[[2,3,5,6,7]]',50,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(177,'faq_ids','[[1,3,6,7,10]]',51,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(178,'faq_ids','[[1,4,5,6,9]]',52,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(179,'faq_ids','[[1,6,7,8,9]]',53,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(180,'faq_ids','[[4,5,7,8,10]]',54,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(181,'faq_ids','[[2,3,5,6,8]]',55,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(182,'faq_ids','[[3,5,6,9,10]]',56,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(183,'faq_ids','[[1,2,3,4,5]]',57,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(184,'faq_ids','[[1,2,5,8,9]]',58,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(185,'faq_ids','[[2,3,5,6,9]]',59,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(186,'faq_ids','[[5,6,7,9,10]]',60,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(187,'faq_ids','[[2,3,5,7,10]]',61,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(188,'faq_ids','[[2,3,5,7,9]]',62,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(189,'faq_ids','[[1,3,8,9,10]]',63,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(190,'faq_ids','[[1,2,5,6,10]]',64,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(191,'faq_ids','[[3,4,8,9,10]]',65,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(192,'faq_ids','[[2,4,6,7,10]]',66,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(193,'faq_ids','[[2,3,4,5,10]]',67,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(194,'faq_ids','[[1,6,7,8,9]]',68,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(195,'faq_ids','[[1,5,7,9,10]]',69,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(196,'faq_ids','[[1,2,7,8,10]]',70,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(197,'faq_ids','[[1,2,3,6,9]]',71,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(198,'faq_ids','[[1,4,5,7,9]]',72,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(199,'faq_ids','[[1,5,6,7,9]]',73,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(200,'faq_ids','[[1,4,5,7,10]]',74,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(201,'faq_ids','[[1,2,5,6,9]]',75,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(202,'faq_ids','[[3,6,8,9,10]]',76,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(203,'faq_ids','[[1,2,5,6,8]]',77,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(204,'faq_ids','[[1,4,6,7,8]]',78,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(205,'faq_ids','[[2,3,6,8,10]]',79,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(206,'faq_ids','[[2,3,5,7,9]]',80,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(207,'faq_ids','[[2,4,6,7,10]]',81,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(208,'faq_ids','[[1,3,6,7,9]]',82,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(209,'faq_ids','[[2,3,7,8,10]]',83,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(210,'faq_ids','[[3,5,6,7,8]]',84,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(211,'faq_ids','[[1,2,3,5,7]]',85,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(212,'faq_ids','[[4,6,7,9,10]]',86,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(213,'faq_ids','[[3,4,5,9,10]]',87,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(214,'faq_ids','[[2,3,4,5,7]]',88,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(215,'faq_ids','[[1,2,5,9,10]]',89,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(216,'faq_ids','[[3,5,7,8,10]]',90,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(217,'faq_ids','[[1,2,3,4,9]]',91,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(218,'faq_ids','[[2,5,7,8,10]]',92,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(219,'faq_ids','[[4,5,7,8,9]]',93,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(220,'faq_ids','[[1,4,5,6,8]]',94,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:19','2025-11-17 21:11:19'),(221,'faq_ids','[[1,4,5,6,7]]',95,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:20','2025-11-17 21:11:20'),(222,'faq_ids','[[2,3,4,8,10]]',96,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:20','2025-11-17 21:11:20'),(223,'faq_ids','[[1,4,5,8,10]]',97,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:20','2025-11-17 21:11:20'),(224,'faq_ids','[[1,2,3,5,7]]',98,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:20','2025-11-17 21:11:20'),(225,'faq_ids','[[1,3,4,5,7]]',99,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:20','2025-11-17 21:11:20'),(226,'faq_ids','[[1,3,5,6,10]]',100,'Botble\\CarRentals\\Models\\Car','2025-11-17 21:11:20','2025-11-17 21:11:20');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2021_02_16_092633_remove_default_value_for_author_type',1),(30,'2021_03_27_144913_add_customer_type_into_table_payments',1),(31,'2021_05_24_034720_make_column_currency_nullable',1),(32,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(33,'2021_10_19_020859_update_metadata_field',1),(34,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(35,'2021_12_03_030600_create_blog_translations',1),(36,'2021_12_03_075608_create_page_translations',1),(37,'2021_12_03_082134_create_faq_translations',1),(38,'2021_12_03_082953_create_gallery_translations',1),(39,'2021_12_03_083642_create_testimonials_translations',1),(40,'2021_12_03_084118_create_location_translations',1),(41,'2021_12_03_094518_migrate_old_location_data',1),(42,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(43,'2022_01_16_085908_improve_plugin_location',1),(44,'2022_04_19_113923_add_index_to_table_posts',1),(45,'2022_04_20_100851_add_index_to_media_table',1),(46,'2022_04_20_101046_add_index_to_menu_table',1),(47,'2022_04_30_034048_create_gallery_meta_translations_table',1),(48,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(49,'2022_07_07_153354_update_charge_id_in_table_payments',1),(50,'2022_07_10_034813_move_lang_folder_to_root',1),(51,'2022_08_04_051940_add_missing_column_expires_at',1),(52,'2022_08_04_052122_delete_location_backup_tables',1),(53,'2022_09_01_000001_create_admin_notifications_tables',1),(54,'2022_10_14_024629_drop_column_is_featured',1),(55,'2022_11_02_092723_team_create_team_table',1),(56,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(57,'2022_12_02_093615_update_slug_index_columns',1),(58,'2023_01_30_024431_add_alt_to_media_table',1),(59,'2023_02_16_042611_drop_table_password_resets',1),(60,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(61,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(62,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(63,'2023_07_06_011444_create_slug_translations_table',1),(64,'2023_07_26_041451_add_more_columns_to_location_table',1),(65,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(66,'2023_08_11_060908_create_announcements_table',1),(67,'2023_08_11_094574_update_team_table',1),(68,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(69,'2023_08_21_090810_make_page_content_nullable',1),(70,'2023_08_29_074620_make_column_author_id_nullable',1),(71,'2023_08_29_075308_make_column_user_id_nullable',1),(72,'2023_09_14_021936_update_index_for_slugs_table',1),(73,'2023_09_14_022423_add_index_for_language_table',1),(74,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(75,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(76,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(77,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(78,'2023_11_30_085354_add_missing_description_to_team',1),(79,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(80,'2023_12_12_105220_drop_translations_table',1),(81,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(82,'2024_01_16_050056_create_comments_table',1),(83,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(84,'2024_03_25_000001_update_captcha_settings_for_contact',1),(85,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(86,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(87,'2024_04_19_063914_create_custom_fields_table',1),(88,'2024_04_27_100730_improve_analytics_setting',1),(89,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(90,'2024_07_04_083133_create_payment_logs_table',1),(91,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(92,'2024_07_12_100000_change_random_hash_for_media',1),(93,'2024_07_30_091615_fix_order_column_in_categories_table',1),(94,'2024_08_17_094600_add_image_into_countries',1),(95,'2024_08_22_062602_create_car_rentals_tables',1),(96,'2024_08_28_154009_create_cr_car_addresses',1),(97,'2024_09_05_151532_add_column_addresses_cars_table',1),(98,'2024_09_11_151251_create_cr_car_categories',1),(99,'2024_09_30_024515_create_sessions_table',1),(100,'2024_10_02_030027_add_more_columns_to_teams_translations_table',1),(101,'2024_12_11_044552_add_author_to_table_cr_cars',1),(102,'2024_12_11_082630_create_cr_messages_table',1),(103,'2024_12_12_034118_add_is_vendor_to_cr_customers',1),(104,'2024_12_12_082259_add_phone_to_table_cr_messages',1),(105,'2024_12_12_093603_add_vendor_verified_at_to_table_cr_customers',1),(106,'2024_12_19_000001_create_device_tokens_table',1),(107,'2024_12_19_000002_create_push_notifications_table',1),(108,'2024_12_19_000003_create_push_notification_recipients_table',1),(109,'2024_12_20_064621_add_moderation_status_to_cr_cars',1),(110,'2024_12_30_000001_create_user_settings_table',1),(111,'2024_12_30_022046_add_vendor_id_to_cr_bookings_table',1),(112,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(113,'2025_01_08_093652_add_zip_code_to_cities',1),(114,'2025_01_15_000000_add_completion_fields_to_cr_bookings_table',1),(115,'2025_01_17_043153_improve_invoices_table',1),(116,'2025_02_10_040833_add_reject_reason_to_cars',1),(117,'2025_02_11_153025_add_action_label_to_announcement_translations',1),(118,'2025_02_20_075043_improve_cr_cars_table',1),(119,'2025_03_23_075418_add_selling_features_to_cr_cars_table',1),(120,'2025_04_02_000000_rename_car_rentals_enabled_rental_booking_setting',1),(121,'2025_04_08_040931_create_social_logins_table',1),(122,'2025_04_10_000000_update_cr_taxes_table',1),(123,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(124,'2025_04_14_000001_create_category_commissions_table',1),(125,'2025_04_14_000002_create_customer_revenues_table',1),(126,'2025_04_14_000003_add_balance_column_to_customers_table',1),(127,'2025_04_14_000004_add_vendor_id_column_to_bookings_table',1),(128,'2025_04_14_000005_add_vendor_id_column_to_cars_table',1),(129,'2025_04_14_000006_create_customer_withdrawals_table',1),(130,'2025_04_14_000007_add_bank_info_to_customers_table',1),(131,'2025_04_20_081632_rename_current_location_to_location_in_cr_cars_table',1),(132,'2025_04_22_102623_set_moderation_status_to_approved_for_existing_cars',1),(133,'2025_04_23_000000_add_external_booking_url_to_cr_cars_table',1),(134,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(135,'2025_05_13_000000_add_price_type_column_to_cr_services_table',1),(136,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1),(137,'2025_06_04_000000_add_horsepower_to_cr_cars_table',1),(138,'2025_07_06_030754_add_phone_to_users_table',1),(139,'2025_07_11_160139_add_order_column_to_cr_car_makes_table',1),(140,'2025_07_11_160140_add_order_column_to_cr_car_types_table',1),(141,'2025_07_11_160141_add_order_column_to_cr_car_transmissions_table',1),(142,'2025_07_11_160142_add_order_column_to_cr_car_fuels_table',1),(143,'2025_07_11_160143_add_order_column_to_cr_car_addresses_table',1),(144,'2025_07_11_160144_add_order_column_to_cr_car_amenities_table',1),(145,'2025_07_11_160145_add_order_column_to_cr_car_colors_table',1),(146,'2025_07_14_014535_add_currency_tables_to_car_rentals',1),(147,'2025_07_14_025000_simplify_currency_implementation',1),(148,'2025_07_14_030502_add_currency_id_to_cr_services_table',1),(149,'2025_07_23_000000_create_car_amenity_categories_table',1),(150,'2025_07_23_000001_add_category_id_to_car_amenities_table',1),(151,'2025_07_23_add_icon_column_to_cr_car_amenities_table',1),(152,'2025_07_23_add_icon_column_to_cr_car_types_table',1),(153,'2025_07_31_083459_add_indexes_for_location_search_performance',1),(154,'2025_07_31_add_performance_indexes_to_slugs_table',1),(155,'2025_08_07_090752_add_verification_fields_to_cr_customers_table',1),(156,'2025_08_11_055037_add_location_fields_to_cr_cars_table',1),(157,'2025_08_11_063447_remove_address_fields_from_cr_cars_table',1),(158,'2025_08_11_064405_migrate_car_addresses_to_cities',1),(159,'2025_08_11_091336_add_address_to_cr_cars_table',1),(160,'2025_10_10_200000_add_advanced_fields_to_cr_currencies_table',1),(161,'2025_10_22_000001_add_whatsapp_to_cr_customers_table',1),(162,'2025_10_29_100000_add_sessions_invalidated_at_to_users_table',1),(163,'2025_11_07_000001_add_actor_type_to_audit_histories_table',1),(164,'2025_11_10_000000_cleanup_duplicate_widgets',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banners title=&quot;Looking for a vehicle? &lt;br class=&ldquo;d-none d-lg-block&rdquo; /&gt;You&rsquo;re in the perfect spot.&quot; subtitle=&quot;Find Your Perfect Car&quot; background_image=&quot;backgrounds/hero-banner.jpg&quot; content_1=&quot;High quality at a low cost.&quot; content_2=&quot;Premium services&quot; content_3=&quot;24/7 roadside support.&quot; quantity=&quot;3&quot;][/hero-banners][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; url=&quot;/cars&quot; background_color=&quot;rgb(242, 244, 246)&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][brands style=&quot;style-1&quot; title=&quot;Premium Brands&quot; subtitle=&quot;Unveil the Finest Selection of High-End Vehicles&quot; brand_ids=&quot;&quot; button_label=&quot;Show All Brands&quot; button_url=&quot;/brands&quot;][/brands][cars style=&quot;style-latest&quot; title=&quot;Most View Vehicles&quot; subtitle=&quot;The world&#039;s leading car brands&quot; number_rows=&quot;2&quot; limit=&quot;12&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/cars][intro-video title=&quot;Receive a Competitive Offer Sell Your Car to Us Today.&quot; description=&quot;We are committed to delivering exceptional service, competitive pricing, and a diverse selection of options for our customers.&quot; subtitle=&quot;Best Car Rental System&quot; youtube_video_url=&quot;https://www.youtube.com/watch?v=ldusxyoq0Y8&quot; image=&quot;general/1.jpg&quot; content_1=&quot;Expert Certified Mechanics&quot; content_2=&quot;First Class Services&quot; content_3=&quot;Get Reasonable Price&quot; content_4=&quot;24/7 road assistance&quot; content_5=&quot;Genuine Spares Parts&quot; content_6=&quot;Free Pick-Up &amp; Drop-Offs&quot; quantity=&quot;6&quot;][/intro-video][car-types title=&quot;Browse by Type&quot; sub_title=&quot;Find the perfect ride for any occasion&quot; car_types=&quot;&quot; redirect_url=&quot;/cars&quot;][/car-types][why-us sub_title=&quot;HOW IT WORKS&quot; title=&quot;Presenting Your New Go-To Car &lt;br&gt; Rental Experience&quot; card_image_1=&quot;icons/car-location.png&quot; card_title_1=&quot;Choose a Location&quot; card_content_1=&quot;Select the ideal destination to begin your journey with ease&quot; card_image_2=&quot;icons/car-selected.png&quot; card_title_2=&quot;Choose Your Vehicle&quot; card_content_2=&quot;Browse our fleet and find the perfect car for your needs&quot; card_image_3=&quot;icons/car.png&quot; card_title_3=&quot;Verification&quot; card_content_3=&quot;Review your information and confirm your booking&quot; card_image_4=&quot;icons/car-key.png&quot; card_title_4=&quot;Begin Your Journey&quot; card_content_4=&quot;Start your adventure with confidence and ease&quot; quantity=&quot;4&quot;][/why-us][car-loan-form style=&quot;style-1&quot; title=&quot;Want to Calculate Your Car Payment?&quot; description=&quot;Match with up to 4 lenders to get the lowest rate available with no markups, no fees, and no obligations.&quot; form_url=&quot;/contact&quot; form_title=&quot;Car Loan Calculator&quot; form_description=&quot;Estimate your monthly auto loan payments with this calculator.&quot; form_button_label=&quot;Apply for a loan&quot; background_image=&quot;backgrounds/car-loan-form-bg.jpg&quot; enable_lazy_loading=&quot;&quot;][/car-loan-form][cars style=&quot;style-feature&quot; title=&quot;Featured Listings&quot; subtitle=&quot;Find the perfect ride for any occasion&quot; limit=&quot;4&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/cars][featured-block title=&quot;Get a great deal for your vehicle sell to us now&quot; subtitle=&quot;Trusted Expertise&quot; description=&quot;Get the best value for your vehicle with our transparent and straightforward selling process&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/cars&quot; image_1=&quot;general/img-1.png&quot; image_2=&quot;general/img-2.png&quot; image_3=&quot;general/img-3.png&quot; image_4=&quot;general/img-4.png&quot; image_5=&quot;general/img-5.png&quot; content_1=&quot;Experienced Professionals You Can Trust&quot; content_2=&quot;Clear and Transparent Pricing, No Hidden Fees&quot; content_3=&quot;Genuine Spares Parts&quot; quantity=&quot;3&quot;][/featured-block][cars-by-locations title=&quot;Available Car Rentals&quot; main_content=&quot;Choose the location that suits your journey and start exploring today&quot; city_ids=&quot;1,2,3,5,6&quot; button_label=&quot;View More&quot; button_url=&quot;/cars&quot;][/cars-by-locations][simple-banners title_1=&quot;Looking for a rental car?&quot; subtitle_1=&quot;Discover your ideal rental car for every adventure, &lt;br&gt;whether it&#039;s a road trip or business travel&quot; image_1=&quot;cars/img-1.png&quot; button_url_1=&quot;/cars&quot; button_name_1=&quot;Get Started Now&quot; button_color_1=&quot;#70f46d&quot; background_color_1=&quot;#9dd3fb&quot; title_2=&quot;Looking for a rental car?&quot; subtitle_2=&quot;Maximize your vehicle&#039;s potential: seamlessly &lt;br&gt; rent or sell with confidence&quot; image_2=&quot;cars/img-2.png&quot; button_url_2=&quot;/cars&quot; button_name_2=&quot;Get Started Now&quot; button_color_2=&quot;#ffffff&quot; background_color_2=&quot;#ffec88&quot; quantity=&quot;2&quot;][/simple-banners][testimonials title=&quot;What they say about us?&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot;][/testimonials][blog-posts style=&quot;style-3&quot; title=&quot;Car Reviews&quot; subtitle=&quot;Expert insights and honest evaluations to help you choose the perfect car&quot; link_label=&quot;View More&quot; link_url=&quot;/blog&quot; category_ids=&quot;1,2,3,4,5,6&quot; limit=&quot;4&quot;][/blog-posts][blog-posts style=&quot;style-1&quot; title=&quot;Upcoming Cars &amp; Events&quot; subtitle=&quot;Stay ahead with the latest car releases and upcoming events&quot; button_label=&quot;Keep Reading&quot; category_ids=&quot;1,2,3,4,5,6&quot; limit=&quot;10&quot;][/blog-posts][install-apps title=&quot;Carento App Is Available&quot; description=&quot;Install App&quot; apps_description=&quot;Manage all your car rentals on the go with the Carento app&quot; android_app_url=&quot;/contact&quot; android_app_image=&quot;general/googleplay.png&quot; ios_app_url=&quot;/contact&quot; ios_app_image=&quot;general/appstore.png&quot; decor_image=&quot;general/truck.png&quot; background_image=&quot;general/background.png&quot;][/install-apps]',NULL,NULL,'homepage',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(2,'Blog','',NULL,NULL,'blog-with-sidebar',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(3,'Contact','[branch-locations title=\"Our agents worldwide\" quantity=\"4\" name_1=\"New York\" icon_image_1=\"icons/sedan-car-model.png\" phone_1=\"+1 212 555 0146\" email_1=\"newyork@carento.com\" address_1=\"750 7th Avenue, Manhattan, New York, NY 10019, USA\" name_2=\"Tokyo\" icon_image_2=\"icons/car-city-model.png\" phone_2=\"+81 3 3456 7890\" email_2=\"tokyo@carento.com\" address_2=\"2-11-3 Meguro, Meguro City, Tokyo 153-0063, Japan\" name_3=\"Paris\" icon_image_3=\"icons/jeep.png\" phone_3=\"+33 1 42 68 53 00\" email_3=\"paris@carento.com\" address_3=\"22 Rue de la Paix, 75002 Paris, France\" name_4=\"Sydney\" icon_image_4=\"icons/pick-up.png\" phone_4=\"+61 2 9255 6000\" email_4=\"sydney@carento.com\" address_4=\"88 George Street, The Rocks, Sydney NSW 2000, Australia\"][/branch-locations][contact-form display_fields=\"phone,email,subject,address\" mandatory_fields=\"email\" title=\"Get in Touch\" show_map=\"0,1\" map_title=\"Our location\" map_address=\"12560 Rental Rd, Memphis, TN 38118, United States\"][/contact-form]',NULL,NULL,NULL,NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(4,'Services','[car-services title=\"Comprehensive Car Rental Services to Meet All Your Needs\" description=\"From daily rentals to long-term solutions, we offer a comprehensive range of vehicles and services to suit every need and budget.\" limit=\"10\"][/car-services][promotion-block title=\"Best Car Rent Deals\" subtitle=\"Save 15% or more when you book and ride before 1 April 2025\" button_label=\"Find Early 2025 Deals\" button_url=\"/cars\" background_image=\"backgrounds/promotion-block-bg.jpg\"][/promotion-block][testimonials title=\"What they say about us?\" subtitle=\"Testimonials\" testimonial_ids=\"1,2,3,4\" style=\"style-2\" enable_lazy_loading=\"\"][/testimonials][intro-video title=\"Receive a Competitive Offer Sell Your Car to Us Today.\" description=\"We are committed to delivering exceptional service, competitive pricing, and a diverse selection of options for our customers.\" subtitle=\"Best Car Rental System\" image=\"general/1.jpg\" content_1=\"Expert Certified Mechanics\" content_2=\"First Class Services\" content_3=\"Get Reasonable Price\" content_4=\"24/7 road assistance\" content_5=\"Genuine Spares Parts\" content_6=\"Free Pick-Up & Drop-Offs\" quantity=\"6\"][/intro-video][site-statistics quantity=\"5\" title_1=\"Global <br> Branches\" data_1=\"45\" unit_1=\"+\" title_2=\"Destinations  <br> Collaboration\" data_2=\"29\" unit_2=\"K\" title_3=\"Years <br> Experience\" data_3=\"20\" unit_3=\"+\" title_4=\"Happy <br> Customers\" data_4=\"168\" unit_4=\"K\" title_5=\"User  <br> Account\" data_5=\"15\" unit_5=\"M\"][/site-statistics][blog-posts style=\"style-1\" title=\"Upcoming Cars & Events\" subtitle=\"Stay ahead with the latest car releases and upcoming events\" button_label=\"Keep Reading\" category_ids=\"1,2,3,4,5\" limit=\"10\"][/blog-posts]',NULL,NULL,'full-width',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(5,'Pricing','[pricing title=\"Membership Plans\" button_label_monthly=\"Monthly Price\" button_label_yearly=\"Annual Price\" quantity=\"4\" name_1=\"Basic\" description_1=\"For most businesses that want to optimize web queries\" monthly_price_1=\"19\" yearly_price_1=\"348\" features_1=\"+ Access to standard vehicles \\n + 24/7 customer support \\n + Basic insurance coverage \\n + Online booking \\n + Standard roadside assistance \\n+ One free vehicle per month\" button_label_1=\"Get Started Now\" button_url_1=\"/\" name_2=\"Standard\" description_2=\"For most businesses that want to optimize web queries\" monthly_price_2=\"29\" yearly_price_2=\"348\" features_2=\"+ All Basic Plan features \\n + Access to premium vehicles \\n + Flexible rental terms \\n + GPS included \\n + Free additional driver \\n + Unlimited vehicle swaps\" button_label_2=\"Get Started Now\" button_url_2=\"/\" name_3=\"Premium\" description_3=\"For most businesses that want to optimize web queries\" monthly_price_3=\"49\" yearly_price_3=\"585\" features_3=\"+ All Standard Plan features \\n + Luxury vehicle options \\n + Complimentary upgrades \\n + Enhanced insurance coverage \\n + Free airport pickup, drop off \\n + Exclusive deals and offers\" button_label_3=\"Get Started Now\" button_url_3=\"/\" name_4=\"VIP\" description_4=\"For most businesses that want to optimize web queries\" monthly_price_4=\"99\" yearly_price_4=\"1185\" features_4=\"+ All Premium Plan features \\n + VIP transfer service \\n + Personal concierge \\n + Unlimited mileage \\n + Luxury vehicle upgrades \\n + 24/7 account manager\" button_label_4=\"Get Started Now\" button_url_4=\"/\"][/pricing][faqs title=\"Frequently Asked Questions\" description=\"Any questions? We would be happy to help you.\" faq_category_ids=\"1,2,3,4,5\" limit=\"10\" button_secondary_label=\"Contact Us\" button_secondary_url=\"/contact\" button_primary_label=\"Submit A Ticket\" button_primary_url=\"/\"][/faqs]',NULL,NULL,'full-width',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(6,'About Us','[about-us-information title=&quot;The Future of &lt;br&gt; Car Rental is Here&quot; description=&quot;Welcome to Carento, your trusted partner in car rentals. Since our founding, we have been committed to providing our customers with a seamless and reliable car rental experience. Whether you are planning a business trip, a family vacation, or just need a vehicle for everyday use, we offer a wide range of vehicles to meet your needs.&quot; quantity=&quot;3&quot; data_number_1=&quot;86&quot; data_title_1=&quot;Industry &lt;br&gt; Experts&quot; image_1=&quot;general/about-us-1.jpg&quot; image_2=&quot;general/about-us-2.jpg&quot; data_number_3=&quot;25&quot; data_title_3=&quot;Years in Business&quot; image_3=&quot;general/about-us-3.jpg&quot;][/about-us-information][why-us card_image_1=&quot;icons/car-location.png&quot; card_title_1=&quot;Choose a Location&quot; card_content_1=&quot;Select the ideal destination to begin your journey with ease&quot; card_image_2=&quot;icons/money.png&quot; card_title_2=&quot;Transparent Pricing&quot; card_content_2=&quot;Enjoy clear and upfront pricing with no surprises, ensuring you know exactly what you are paying for.&quot; card_image_3=&quot;icons/convenient.png&quot; card_title_3=&quot;Convenient Booking&quot; card_content_3=&quot;Benefit from a variety of rental options, including short-term, long-term, and weekend specials&quot; card_image_4=&quot;icons/supporter.png&quot; card_title_4=&quot;24/7 Customer Support&quot; card_content_4=&quot;Get assistance whenever you need it with our dedicated support team available around the clock.&quot; quantity=&quot;4&quot;][/why-us][team title=&quot;Meet Our Agents&quot; subtitle=&quot;Awesome Teams&quot; team_ids=&quot;1,2,3,5&quot;][/team][featured-block style=&quot;style-2&quot; title=&quot;Sell your car at a fair price. Get started with us today.&quot; subtitle=&quot;Our Mission&quot; description=&quot;Our mission is to make car rental easy, accessible, and affordable for everyone. We believe that renting a car should be a hassle-free experience, and we are dedicated to ensuring that every customer finds the perfect vehicle for their journey.&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot; 24/7 customer support for assistance anytime, anywhere&quot; image_1=&quot;general/img-2-1.png&quot; image_2=&quot;general/img-2-2.png&quot; image_3=&quot;general/img-2-3.png&quot; image_4=&quot;general/img-2-4.png&quot; enable_lazy_loading=&quot;no&quot;][/featured-block][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot; background_color=&quot;#d8f4db&quot;][/site-statistics][intro-video style=&quot;style-2&quot; title=&quot;Carento offers clear pricing and 24/7 great support.&quot; subtitle=&quot;Our Commitment&quot; description=&quot;We are committed to offering transparent pricing with no hidden fees, comprehensive insurance options for peace of mind, and 24/7 customer support to assist you whenever you need it. At Carento, your satisfaction is our top priority.&quot; youtube_video_url=&quot;https://www.youtube.com/watch?v=ldusxyoq0Y8&quot; quantity=&quot;3&quot; content_1=&quot;Explore a wide range of flexible rental options to suit your needs&quot; content_2=&quot;Comprehensive insurance coverage for complete peace of mind&quot; content_3=&quot;24/7 customer support for assistance anytime, anywhere&quot; button_label=&quot;Get Started Now&quot; button_url=&quot;/contact&quot; image=&quot;general/3.jpg&quot; image_1=&quot;general/2.jpg&quot; enable_lazy_loading=&quot;&quot;][/intro-video][testimonials title=&quot;What they say about us?&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot; style=&quot;style-2&quot; enable_lazy_loading=&quot;&quot;][/testimonials][blog-posts style=&quot;style-1&quot; title=&quot;Upcoming Cars &amp; Events&quot; subtitle=&quot;Stay ahead with the latest car releases and upcoming events&quot; button_label=&quot;Keep Reading&quot; category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot;][/blog-posts]',NULL,NULL,'full-width',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(7,'Car List 1','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;yes&quot; default_layout=&quot;grid&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',NULL,NULL,'homepage',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(8,'Car List 2','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;no&quot; default_layout=&quot;grid&quot; layout_col=&quot;4&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',NULL,NULL,'homepage',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(9,'Car List 3','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;no&quot; default_layout=&quot;grid&quot; layout_col=&quot;3&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',NULL,NULL,'homepage',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(10,'Car List 4','[banner title=&quot;Find Your Perfect Car&quot; subtitle=&quot;Search and find your best car rental with easy way&quot; tag=&quot;Find cars for sale and for rent near you&quot; background_image=&quot;backgrounds/banner6.jpg&quot;][/banner][car-advance-search button_search_name=&quot;Find a Vehicle&quot; link_need_help=&quot;/faqs&quot; top=&quot;-124&quot; bottom=&quot;0&quot; left=&quot;0&quot; right=&quot;0&quot; tabs=&quot;all,new_car,used_car&quot;][/car-advance-search][car-list title=&quot;Our Vehicle Fleet&quot; subtitle=&quot;Turning dreams into reality with versatile vehicles.&quot; enable_filter=&quot;yes&quot; default_layout=&quot;list&quot; layout_col=&quot;4&quot;][/car-list][brands title=&quot;&quot; subtitle=&quot;&quot; brand_ids=&quot;&quot; button_label=&quot;&quot; button_url=&quot;&quot;][/brands]',NULL,NULL,'homepage',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(11,'Agencies','[team title=\"Meet Our Agents\" subtitle=\"Awesome Teams\" team_ids=\"1,2,3,4,5,6,7,8\"][/team]',NULL,NULL,'full-width',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(12,'Faqs','[faq-categories title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot;][/faq-categories][faqs title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot; faq_category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot; button_secondary_label=&quot;Contact Us&quot; button_secondary_url=&quot;/contact&quot; button_primary_label=&quot;Submit A Ticket&quot; button_primary_url=&quot;/&quot;][/faqs][faqs title=&quot;Frequently Asked Questions&quot; description=&quot;Any questions? We would be happy to help you.&quot; faq_category_ids=&quot;1,2,3,4,5&quot; limit=&quot;10&quot; button_secondary_label=&quot;Contact Us&quot; button_secondary_url=&quot;/contact&quot; button_primary_label=&quot;Submit A Ticket&quot; button_primary_url=&quot;/&quot;][/faqs][site-statistics quantity=&quot;5&quot; title_1=&quot;Global &lt;br&gt; Branches&quot; data_1=&quot;45&quot; unit_1=&quot;+&quot; title_2=&quot;Destinations  &lt;br&gt; Collaboration&quot; data_2=&quot;29&quot; unit_2=&quot;K&quot; title_3=&quot;Years &lt;br&gt; Experience&quot; data_3=&quot;20&quot; unit_3=&quot;+&quot; title_4=&quot;Happy &lt;br&gt; Customers&quot; data_4=&quot;168&quot; unit_4=&quot;K&quot; title_5=&quot;User  &lt;br&gt; Account&quot; data_5=&quot;15&quot; unit_5=&quot;M&quot;][/site-statistics]',NULL,NULL,'full-width',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(13,'Brands','[brands title=\"Brands\" style=\"style-3\" brand_ids=\"\"][/brands]',NULL,NULL,NULL,NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(14,'Car Dealers','[car-dealers title=\"Our Trusted Car Dealers\" subtitle=\"Find the best car dealers with excellent service and competitive prices\" limit=\"12\" show_car_count=\"yes\" button_label=\"View All Dealers\" button_url=\"/car-dealers\"][/car-dealers]',NULL,NULL,'full-width',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(15,'Our Awards','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(16,'Copyright Notices','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(17,'Terms of Use','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(18,'Privacy Notice','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(19,'Lost &amp; Found','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(20,'Car Rental Services','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(21,'Vehicle Leasing Options','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(22,'Long-Term Car Rentals','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(23,'Car Sales and Trade-Ins','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(24,'Luxury Car Rentals','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(25,'Rent-to-Own Programs','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(26,'Fleet Management Solutions','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(27,'Affiliates','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(28,'Travel Agents','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(29,'AARP Members','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(30,'Points Programs','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(31,'Military &amp; Veterans','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(32,'Work with us','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(33,'Advertise with us','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(34,'Forum support','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(35,'Help Center','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(36,'Live chat','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(37,'How it works','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(38,'Security','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50'),(39,'Refund Policy','<p>\n    <strong>Welcome to Carento!</strong>\n    Renting a car with us is easy, fast, and convenient. Whether you\\\'re going on a weekend getaway, need a car for business, or are planning a road trip, Carento makes renting a car seamless. Here’s how it works:</p>\n<h3>1.\n    <strong>Browse &amp; Select Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Browse Our Fleet:</strong>\n        Start by browsing our diverse fleet of cars. Whether you\\\'re looking for a compact car, an SUV, or a luxury vehicle, we have a variety of options to suit your needs.</li>\n    <li>\n        <strong>Filter Your Choices:</strong>\n        Use our search filters to select the type of vehicle, pick-up location, rental dates, and any additional features you may need, such as GPS or a child car seat.</li>\n    <li>\n        <strong>Check Availability:</strong>\n        View real-time availability and pricing for your selected car. If your desired car is unavailable, you’ll see alternative options.</li>\n</ul><hr><h3>2.\n    <strong>Make a Reservation</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Select Your Rental Period:</strong>\n        Choose the dates and times you need the car, from daily rentals to weekly or monthly bookings.</li>\n    <li>\n        <strong>Add Extras:</strong>\n        You can add optional extras such as additional drivers, insurance, or GPS systems at this stage.</li>\n    <li>\n        <strong>Review Your Booking:</strong>\n        Review your booking details, including the car type, rental period, and total cost.</li>\n    <li>\n        <strong>Secure Payment:</strong>\n        Confirm your reservation by entering your payment details through our secure payment gateway. We accept all major credit cards, debit cards, and payment systems like PayPal.</li>\n    <li>\n        <strong>Get Confirmation:</strong>\n        Once your payment is processed, you\\\'ll receive an instant email confirmation with all the details of your reservation, including a unique booking reference number.</li>\n</ul><hr><h3>3.\n    <strong>Pick Up Your Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Locate Your Pick-Up Location:</strong>\n        You’ll find your car ready for you at the designated pick-up location. We offer several convenient locations, including major airports, city centers, and train stations.</li>\n    <li>\n        <strong>Present Your ID &amp; License:</strong>\n        When you arrive, we’ll need to verify your identity. Please bring a valid driver’s license and the credit card used for the booking.</li>\n    <li>\n        <strong>Car Inspection:</strong>\n        Before you drive off, we will conduct a quick inspection of the car with you, noting any pre-existing damage. You’ll also receive instructions on how to operate the vehicle, including key features and emergency procedures.</li>\n    <li>\n        <strong>Sign the Rental Agreement:</strong>\n        Sign the rental agreement, which will outline the terms and conditions of your rental. If you have any questions about the agreement, our staff is happy to assist you.</li>\n</ul><hr><h3>4.\n    <strong>Enjoy Your Ride</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Drive with Confidence:</strong>\n        Once you’re all set, you’re free to enjoy your trip! Feel free to use the car for your travel needs, whether it\\\'s for business, leisure, or exploration.</li>\n    <li>\n        <strong>24/7 Roadside Assistance:</strong>\n        If you encounter any issues during your rental, we offer 24/7 roadside assistance to help with breakdowns, flat tires, or emergencies.</li>\n    <li>\n        <strong>Fuel Policy:</strong>\n        Our cars are provided with a full tank of fuel. You can return the vehicle with a full tank or pay for the fuel used during your rental period. Please note, if the car is returned with less than a full tank, you may be charged a refueling fee.</li>\n</ul><hr><h3>5.\n    <strong>Return the Car</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Return Location:</strong>\n        Return the car to the same location where you picked it up, or select a different return location if available. For airport rentals, simply drop the car off at the designated Carento area.</li>\n    <li>\n        <strong>Car Inspection &amp; Check-Out:</strong>\n        Upon return, we will conduct a brief inspection of the vehicle to ensure there’s no damage or additional issues. Please remember to return the car on time to avoid any late fees.</li>\n    <li>\n        <strong>Final Payment (If Necessary):</strong>\n        Any remaining balance (such as extra mileage charges or fuel costs) will be settled at the time of return. You can pay with your credit/debit card or any other available payment method.</li>\n    <li>\n        <strong>Get Your Final Receipt:</strong>\n        Once everything is checked, we\\’ll send you a final receipt by email, outlining the charges and any deposits returned. If applicable, we’ll also issue any refunds for unused services.</li>\n</ul><hr><h3>6.\n    <strong>Enjoy Our Loyalty Program (Optional)</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Earn Points with Every Rental:</strong>\n        If you\\\'re a member of the\n        <strong>Carento Loyalty Program</strong>, you can earn points with every booking to redeem for discounts, free upgrades, and other special offers.</li>\n    <li>\n        <strong>Exclusive Deals &amp; Offers:</strong>\n        Sign up for exclusive offers, early access to new fleet options, and seasonal promotions.</li>\n</ul>\n<p>&nbsp;</p>\n<h3>\n    <strong>Need Help?</strong>\n</h3>\n<p>If you need assistance at any point in your rental process, our customer support team is always ready to help. We offer live chat support, email assistance, and a 24/7 customer service hotline.</p>\n<h3>\n    <strong>Why Rent with Carento?</strong>\n</h3>\n<ul>\n    <li>\n        <strong>Wide Selection:</strong>\n        A variety of cars for all needs, from economy to luxury, compact cars to SUVs.</li>\n    <li>\n        <strong>Flexible Booking:</strong>\n        Easily book online with flexible rental durations, from daily to monthly rentals.</li>\n    <li>\n        <strong>Transparent Pricing:</strong>\n        No hidden fees! Our prices are clear, and all fees are explained upfront.</li>\n    <li>\n        <strong>Customer Satisfaction:</strong>\n        We pride ourselves on excellent customer service and ensuring your rental experience is smooth and hassle-free.</li>\n</ul>\n<h3>\n    <strong>Get Started Today!</strong>\n</h3>\n<p>Ready to hit the road?\n    <strong>Browse our fleet</strong>\n    today, select your car, and book your next rental with Carento! We’re here to make your car rental experience easy, safe, and enjoyable.</p>\n<p>\n    <strong>Contact Us:</strong>\n</p>\n<p>If you have any questions or need more information, feel free to reach out to us:</p>\n<ul>\n    <li>\n        <strong>Email:</strong>\n        <a rel=\"noopener\">\n            <span>support@carento.com</span>\n        </a>\n    </li>\n    <li>\n        <strong>Phone:</strong>\n        +1 (800) 123-4567</li>\n    <li>\n        <strong>Live Chat:</strong>\n        Available on our website 24/7</li>\n</ul>\n',NULL,NULL,'default',NULL,'published','2025-11-17 21:09:50','2025-11-17 21:09:50');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',30,'AUTBQSNBOGAL','bank_transfer',NULL,196.00,0.00,1,'completed','direct',30,NULL,NULL,'2025-11-13 21:11:20','2025-11-13 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(2,'USD',28,'C9BV83NJH2NK','razorpay',NULL,244.00,0.00,2,'completed','direct',28,NULL,NULL,'2025-09-20 21:11:20','2025-09-20 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(3,'USD',24,'LQBRP5WTRQJO','paypal',NULL,76.00,0.00,3,'completed','direct',24,NULL,NULL,'2025-09-20 21:11:20','2025-09-20 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(4,'USD',23,'UOV2J1HG0NWP','paypal',NULL,49.00,0.00,4,'completed','direct',23,NULL,NULL,'2025-10-05 21:11:20','2025-10-05 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(5,'USD',31,'ILNGN5PLPKZI','paypal',NULL,234.00,0.00,5,'completed','direct',31,NULL,NULL,'2025-10-21 21:11:20','2025-10-21 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(6,'USD',26,'WW2Q0IP275FZ','sslcommerz',NULL,475.00,0.00,6,'completed','direct',26,NULL,NULL,'2025-10-04 21:11:20','2025-10-04 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(7,'USD',25,'X9YTVG036GLI','paypal',NULL,170.00,0.00,7,'completed','direct',25,NULL,NULL,'2025-10-23 21:11:20','2025-10-23 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(8,'USD',25,'QLPROIQWUD7L','sslcommerz',NULL,98.00,0.00,8,'completed','direct',25,NULL,NULL,'2025-10-28 21:11:20','2025-10-28 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(9,'USD',23,'5VN3UP8XEA0I','stripe',NULL,282.00,0.00,9,'completed','direct',23,NULL,NULL,'2025-10-13 21:11:20','2025-10-13 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(10,'USD',25,'UXJ4DYBRMUQO','stripe',NULL,141.00,0.00,10,'pending','direct',25,NULL,NULL,'2025-10-20 21:11:20','2025-10-20 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(11,'USD',29,'FJHMF2MKH2BH','paypal',NULL,546.00,0.00,11,'completed','direct',29,NULL,NULL,'2025-11-11 21:11:20','2025-11-11 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(12,'USD',31,'UL6UKT7NFYVL','razorpay',NULL,64.00,0.00,12,'completed','direct',31,NULL,NULL,'2025-10-03 21:11:20','2025-10-03 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(13,'USD',26,'XWGB4KC7WVWW','stripe',NULL,126.00,0.00,13,'pending','direct',26,NULL,NULL,'2025-10-25 21:11:20','2025-10-25 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(14,'USD',21,'BLLKP84NOAAU','stripe',NULL,34.00,0.00,14,'completed','direct',21,NULL,NULL,'2025-10-11 21:11:20','2025-10-11 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(15,'USD',31,'WGIT66WCOYZP','cod',NULL,343.00,0.00,15,'completed','direct',31,NULL,NULL,'2025-10-19 21:11:20','2025-10-19 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(16,'USD',23,'R0NTXVBWMFJA','bank_transfer',NULL,370.00,0.00,16,'pending','direct',23,NULL,NULL,'2025-10-12 21:11:20','2025-10-12 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(17,'USD',26,'SQK6YVN0CHZL','sslcommerz',NULL,30.00,0.00,17,'pending','direct',26,NULL,NULL,'2025-10-28 21:11:20','2025-10-28 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(18,'USD',29,'EHJTVAP9UQOR','razorpay',NULL,252.00,0.00,18,'completed','direct',29,NULL,NULL,'2025-10-27 21:11:20','2025-10-27 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(19,'USD',23,'15NUHRRAPGLI','paystack',NULL,276.00,0.00,19,'completed','direct',23,NULL,NULL,'2025-11-10 21:11:20','2025-11-10 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(20,'USD',29,'UYGCIBCKVVA6','razorpay',NULL,245.00,0.00,20,'completed','direct',29,NULL,NULL,'2025-09-19 21:11:20','2025-09-19 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(21,'USD',28,'PWJQUM0MQZDY','paypal',NULL,546.00,0.00,21,'pending','direct',28,NULL,NULL,'2025-10-28 21:11:20','2025-10-28 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(22,'USD',21,'HUXU8ZCVMI9S','stripe',NULL,147.00,0.00,22,'completed','direct',21,NULL,NULL,'2025-09-25 21:11:20','2025-09-25 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(23,'USD',27,'MCK9PXKZXOVO','paystack',NULL,180.00,0.00,23,'completed','direct',27,NULL,NULL,'2025-11-15 21:11:20','2025-11-15 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(24,'USD',30,'7JCY83XQYWL1','paypal',NULL,180.00,0.00,24,'pending','direct',30,NULL,NULL,'2025-10-29 21:11:20','2025-10-29 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(25,'USD',22,'XWJAMAVFTMTP','sslcommerz',NULL,76.00,0.00,25,'completed','direct',22,NULL,NULL,'2025-10-18 21:11:20','2025-10-18 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(26,'USD',30,'CZ6O3ADRL0EF','stripe',NULL,62.00,0.00,26,'pending','direct',30,NULL,NULL,'2025-10-01 21:11:20','2025-10-01 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(27,'USD',31,'GAYIONIYI5E9','paypal',NULL,582.00,0.00,27,'completed','direct',31,NULL,NULL,'2025-10-31 21:11:20','2025-10-31 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(28,'USD',26,'PGK6MM40KLL9','stripe',NULL,292.00,0.00,28,'pending','direct',26,NULL,NULL,'2025-10-31 21:11:20','2025-10-31 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(29,'USD',22,'TWJOCFQOWW3W','paypal',NULL,427.00,0.00,29,'completed','direct',22,NULL,NULL,'2025-11-06 21:11:20','2025-11-06 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(30,'USD',30,'VKZYEONPRQ1O','razorpay',NULL,224.00,0.00,30,'completed','direct',30,NULL,NULL,'2025-10-18 21:11:20','2025-10-18 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(31,'USD',26,'2NZDOCXZI5M0','paystack',NULL,320.00,0.00,31,'pending','direct',26,NULL,NULL,'2025-11-14 21:11:20','2025-11-14 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(32,'USD',23,'RXXENXWNAVAT','sslcommerz',NULL,426.00,0.00,32,'pending','direct',23,NULL,NULL,'2025-11-11 21:11:20','2025-11-11 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(33,'USD',30,'RBSZWMJIAFT0','paystack',NULL,264.00,0.00,33,'pending','direct',30,NULL,NULL,'2025-11-13 21:11:20','2025-11-13 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(34,'USD',29,'JWSWWOHGWZPB','razorpay',NULL,284.00,0.00,34,'pending','direct',29,NULL,NULL,'2025-11-17 21:11:20','2025-11-17 21:11:20','Botble\\CarRentals\\Models\\Customer',NULL),(35,'USD',31,'JKRQO05P5NMG','paypal',NULL,360.00,0.00,35,'completed','direct',31,NULL,NULL,'2025-11-11 21:11:21','2025-11-11 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(36,'USD',23,'BBJNE5KAVZWG','stripe',NULL,552.00,0.00,36,'pending','direct',23,NULL,NULL,'2025-11-16 21:11:21','2025-11-16 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(37,'USD',27,'TEGQXAXULTGS','sslcommerz',NULL,49.00,0.00,37,'completed','direct',27,NULL,NULL,'2025-11-16 21:11:21','2025-11-16 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(38,'USD',30,'MRWVHLDH3ZIS','paypal',NULL,36.00,0.00,38,'completed','direct',30,NULL,NULL,'2025-11-11 21:11:21','2025-11-11 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(39,'USD',25,'AVGAKE6NVXC9','sslcommerz',NULL,176.00,0.00,39,'completed','direct',25,NULL,NULL,'2025-11-10 21:11:21','2025-11-10 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(40,'USD',25,'ODVVQWXGY86T','cod',NULL,188.00,0.00,40,'pending','direct',25,NULL,NULL,'2025-11-15 21:11:21','2025-11-15 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(41,'USD',24,'R8VP29WL9JG4','sslcommerz',NULL,55.00,0.00,41,'pending','direct',24,NULL,NULL,'2025-11-14 21:11:21','2025-11-14 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(42,'USD',30,'WS33QNWXYTSQ','razorpay',NULL,291.00,0.00,42,'completed','direct',30,NULL,NULL,'2025-11-10 21:11:21','2025-11-10 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(43,'USD',28,'QL7RXJSRLR5O','cod',NULL,355.00,0.00,43,'pending','direct',28,NULL,NULL,'2025-11-16 21:11:21','2025-11-16 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(44,'USD',28,'EBWRP0ENVOKH','sslcommerz',NULL,420.00,0.00,44,'pending','direct',28,NULL,NULL,'2025-11-14 21:11:21','2025-11-14 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(45,'USD',30,'DLZQYQNJPTWG','razorpay',NULL,570.00,0.00,45,'pending','direct',30,NULL,NULL,'2025-11-15 21:11:21','2025-11-15 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(46,'USD',21,'5TMJGYCOGPGR','bank_transfer',NULL,384.00,0.00,46,'completed','direct',21,NULL,NULL,'2025-11-13 21:11:21','2025-11-13 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(47,'USD',24,'WVR3CXVZOQ7L','paystack',NULL,96.00,0.00,47,'pending','direct',24,NULL,NULL,'2025-11-13 21:11:21','2025-11-13 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(48,'USD',26,'MJLIW4DX7TKV','razorpay',NULL,33.00,0.00,48,'pending','direct',26,NULL,NULL,'2025-11-12 21:11:21','2025-11-12 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(49,'USD',25,'ILOW0V4QN0MD','razorpay',NULL,165.00,0.00,49,'pending','direct',25,NULL,NULL,'2025-11-15 21:11:21','2025-11-15 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(50,'USD',21,'MUGBVSNC1TCE','sslcommerz',NULL,84.00,0.00,50,'pending','direct',21,NULL,NULL,'2025-11-11 21:11:21','2025-11-11 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(51,'USD',26,'5TC2WHGZXI4A','stripe',NULL,270.00,0.00,51,'pending','direct',26,NULL,NULL,'2025-12-03 21:11:21','2025-12-03 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(52,'USD',28,'MSEFHGQ7HIIY','paystack',NULL,192.00,0.00,52,'pending','direct',28,NULL,NULL,'2025-11-25 21:11:21','2025-11-25 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(53,'USD',29,'H6PYNMYENBAJ','stripe',NULL,196.00,0.00,53,'pending','direct',29,NULL,NULL,'2025-12-17 21:11:21','2025-12-17 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(54,'USD',30,'HQKKXRAXZHKT','bank_transfer',NULL,602.00,0.00,54,'pending','direct',30,NULL,NULL,'2025-12-03 21:11:21','2025-12-03 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(55,'USD',31,'QXCLCGUKBE2T','razorpay',NULL,291.00,0.00,55,'pending','direct',31,NULL,NULL,'2025-12-16 21:11:21','2025-12-16 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(56,'USD',30,'GIJWQKHZPDIU','bank_transfer',NULL,45.00,0.00,56,'pending','direct',30,NULL,NULL,'2025-11-28 21:11:21','2025-11-28 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(57,'USD',27,'MFZ0PHUQSU2B','paypal',NULL,570.00,0.00,57,'pending','direct',27,NULL,NULL,'2025-12-08 21:11:21','2025-12-08 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(58,'USD',23,'VUTGVZCZUT9J','razorpay',NULL,414.00,0.00,58,'pending','direct',23,NULL,NULL,'2025-12-03 21:11:21','2025-12-03 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(59,'USD',30,'KFNGSJMLPMZD','sslcommerz',NULL,216.00,0.00,59,'pending','direct',30,NULL,NULL,'2025-11-22 21:11:21','2025-11-22 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(60,'USD',29,'9QTQGXGODXK8','stripe',NULL,99.00,0.00,60,'pending','direct',29,NULL,NULL,'2025-12-01 21:11:21','2025-12-01 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(61,'USD',31,'DBIYKTDR59ZO','paypal',NULL,38.00,0.00,61,'pending','direct',31,NULL,NULL,'2025-12-01 21:11:21','2025-12-01 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(62,'USD',29,'GBB1VU6IPDJV','bank_transfer',NULL,110.00,0.00,62,'pending','direct',29,NULL,NULL,'2025-11-30 21:11:21','2025-11-30 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(63,'USD',26,'8LWE7JPV6KTQ','paypal',NULL,355.00,0.00,63,'pending','direct',26,NULL,NULL,'2025-11-25 21:11:21','2025-11-25 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(64,'USD',25,'IAMUYD2SC6XV','sslcommerz',NULL,220.00,0.00,64,'pending','direct',25,NULL,NULL,'2025-12-11 21:11:21','2025-12-11 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(65,'USD',27,'5IWPHAVK9XS3','paypal',NULL,570.00,0.00,65,'pending','direct',27,NULL,NULL,'2025-11-18 21:11:21','2025-11-18 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(66,'USD',26,'JDBYNIQZQSE1','razorpay',NULL,441.00,0.00,66,'pending','direct',26,NULL,NULL,'2025-11-27 21:11:21','2025-11-27 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(67,'USD',24,'XN6YJBVSI78N','razorpay',NULL,156.00,0.00,67,'pending','direct',24,NULL,NULL,'2025-12-01 21:11:21','2025-12-01 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(68,'USD',28,'DSSWBPG4E6MN','paystack',NULL,40.00,0.00,68,'pending','direct',28,NULL,NULL,'2025-11-23 21:11:21','2025-11-23 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(69,'USD',31,'K7I3N7M8GRGO','stripe',NULL,282.00,0.00,69,'pending','direct',31,NULL,NULL,'2025-11-22 21:11:21','2025-11-22 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(70,'USD',21,'T1MZVCBB5EOX','stripe',NULL,294.00,0.00,70,'pending','direct',21,NULL,NULL,'2025-12-15 21:11:21','2025-12-15 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(71,'USD',25,'GIUEIGWHXTKS','paypal',NULL,196.00,0.00,71,'pending','direct',25,NULL,NULL,'2025-11-29 21:11:21','2025-11-29 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(72,'USD',28,'X8LUEEZ2RFR6','bank_transfer',NULL,288.00,0.00,72,'pending','direct',28,NULL,NULL,'2025-11-24 21:11:21','2025-11-24 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(73,'USD',31,'TNIGIQHSXAAI','cod',NULL,438.00,0.00,73,'pending','direct',31,NULL,NULL,'2025-11-27 21:11:21','2025-11-27 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(74,'USD',24,'RGUQDGJ7QW91','paystack',NULL,210.00,0.00,74,'pending','direct',24,NULL,NULL,'2025-12-09 21:11:21','2025-12-09 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(75,'USD',25,'U7DTZZGEQLZE','paypal',NULL,644.00,0.00,75,'pending','direct',25,NULL,NULL,'2025-12-12 21:11:21','2025-12-12 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(76,'USD',31,'YFSOOFTHMX5I','sslcommerz',NULL,90.00,0.00,76,'pending','direct',31,NULL,NULL,'2025-12-10 21:11:21','2025-12-10 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(77,'USD',21,'SG0VG9DKR5GJ','sslcommerz',NULL,518.00,0.00,77,'pending','direct',21,NULL,NULL,'2025-12-09 21:11:21','2025-12-09 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(78,'USD',25,'IXYFYSOC7ZCQ','paypal',NULL,483.00,0.00,78,'pending','direct',25,NULL,NULL,'2025-11-19 21:11:21','2025-11-19 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(79,'USD',25,'LAVVZXY4TBE2','razorpay',NULL,282.00,0.00,79,'pending','direct',25,NULL,NULL,'2025-12-08 21:11:21','2025-12-08 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL),(80,'USD',21,'YPLGPOCIGFYW','razorpay',NULL,176.00,0.00,80,'pending','direct',21,NULL,NULL,'2025-12-17 21:11:21','2025-12-17 21:11:21','Botble\\CarRentals\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (9,1),(6,1),(9,2),(1,2),(10,3),(8,3),(10,4),(3,4),(7,5),(4,5),(2,6),(10,6),(2,7),(1,8),(10,8),(6,9),(5,9),(2,10),(10,11),(1,11),(4,12),(6,12),(7,13),(1,13),(9,14),(5,14),(7,15),(6,15),(3,16),(10,16),(10,17),(3,17),(7,18),(9,18),(6,19),(9,19),(9,20),(8,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (2,1),(4,1),(9,1),(4,2),(8,2),(1,3),(6,3),(5,3),(4,4),(3,4),(5,4),(3,5),(9,5),(5,5),(3,6),(8,6),(9,6),(10,7),(5,7),(3,7),(2,8),(4,8),(7,8),(7,9),(5,9),(9,9),(8,10),(3,10),(1,10),(3,11),(4,11),(2,11),(9,12),(7,12),(8,13),(1,13),(5,13),(5,14),(9,14),(5,15),(6,15),(8,15),(10,16),(9,16),(7,16),(9,17),(5,17),(5,18),(8,18),(9,19),(6,19),(1,19),(7,20),(6,20),(9,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Top 5 New Cars to Look Out for in 2024','Discover the most anticipated car models coming in 2024, featuring cutting-edge technology and stunning designs.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Sed fugiat temporibus sed repellendus. Laudantium rerum laboriosam adipisci consectetur laborum sit non. Amet quaerat omnis porro et veniam. Consequatur non ipsam dignissimos fuga non maiores.\" content_2=\"Aut ratione non enim quia nemo adipisci ipsam. Excepturi esse error enim voluptatem minima. Nihil porro aut quis deserunt. Non non illum unde libero. Cumque quas nostrum beatae inventore deleniti. Ut ratione nemo aut dolorum repellendus deserunt labore eos. Culpa sint nam corrupti ea qui.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/1.jpg',103,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(2,'How to Choose the Best Car Rental Service for Your Trip','A comprehensive guide on selecting the right car rental service based on your travel needs and budget.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Et incidunt cupiditate magni fugit cum voluptatem perferendis. Quaerat nostrum quis sint sint. Aut eaque error occaecati ut quisquam iste. Eaque enim dolor enim voluptas qui quam tempora fugiat.\" content_2=\"Qui asperiores eum ea quia reprehenderit. Ducimus et laudantium occaecati quia dolor dignissimos. Expedita cumque sit nesciunt fuga quidem. Nihil quo delectus vel quos minima molestias. Aliquam et nihil pariatur temporibus vitae corporis rerum qui. Non tempora facilis nisi ut voluptate et doloribus.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/1.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/2.jpg',1089,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(3,'The Evolution of Electric Vehicles: A New Era','Explore how electric cars are transforming the auto industry and why they are the future of transportation.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Eos vel necessitatibus reiciendis. Alias inventore enim eveniet consequatur dolorum explicabo error. Veniam porro est rerum in quis magni. Officiis fugiat iste explicabo assumenda. Odio dolores commodi placeat beatae enim autem est. Ea consequuntur ipsum et beatae. Quidem et modi omnis asperiores ut. Molestiae possimus sint veritatis qui accusantium.\" content_2=\"Beatae velit iusto voluptates omnis est voluptatem magni. Eos amet aut ut aut praesentium. Numquam et soluta placeat accusantium. Qui nobis perspiciatis voluptatem quibusdam repellat harum tenetur nulla. Dolorem natus sit repellendus quae. A voluptatum ipsa debitis quia et. Tenetur expedita dignissimos iure quibusdam deserunt. A nostrum eos quibusdam repudiandae.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/3.jpg',2184,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(4,'Leasing vs. Buying a Car: Which Is Right for You?','An in-depth comparison of leasing and buying a car, helping you decide which option suits your lifestyle.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Ipsum reprehenderit aliquam ullam reprehenderit. Non qui perspiciatis ratione. Cupiditate fugit itaque debitis. Placeat labore ipsa id harum ut tempora odit. Omnis in deleniti molestiae architecto voluptas ratione. Placeat eos et nesciunt non aut voluptatem accusamus.\" content_2=\"Autem rem quo ipsam perspiciatis vel rem qui cupiditate. Quo eos sit et architecto aut fuga. Repellendus voluptatum occaecati dolor consequatur occaecati amet. Et dolores velit fugit eius in. Expedita molestiae a ut quibusdam in est culpa omnis. Sapiente modi occaecati aut et ut voluptatibus. Repudiandae aut voluptates eveniet illo magni beatae.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/4.jpg',1343,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(5,'The Ultimate Road Trip Checklist','Everything you need to pack and check before embarking on an unforgettable road trip adventure.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Maxime facere hic in in nemo. Deserunt inventore minus amet ex libero dolor. Similique eaque unde repellendus aliquid incidunt non. Sed vel aperiam ex autem natus est placeat. Et molestiae atque sit voluptates velit totam omnis. Et vel esse blanditiis dicta. Provident recusandae atque qui et excepturi labore. Saepe mollitia sit optio exercitationem illum deserunt.\" content_2=\"Pariatur velit eaque et in eligendi. Aliquid voluptatem molestiae fugit. Ea at ut dolorem sint nesciunt. Amet adipisci quos vel ut. Voluptatum eligendi quam aut sed eos sapiente reiciendis. Est quas similique harum laudantium doloremque aut ea. Ipsum aperiam velit illo quis rerum officiis.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/4.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/5.jpg',533,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(6,'The Benefits of Renting a Luxury Car for Special Occasions','Find out why renting a luxury vehicle can make your events even more memorable and stylish.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Velit accusamus id optio distinctio. Sequi ipsam ratione qui non. Dolor eum dolor et incidunt. Sit earum aspernatur iure asperiores autem itaque sint. Voluptatem non architecto vel et nisi sit. Saepe placeat ipsa sapiente ea rem omnis labore harum. Quod et corporis velit dolores explicabo omnis totam cupiditate. Vero rerum aliquam voluptatem in nesciunt. Fugiat ratione non sunt eveniet id.\" content_2=\"Rem laboriosam adipisci delectus et vel molestiae. Delectus exercitationem corporis eos fugiat quos non. Repellat consequatur enim voluptatem laborum consequuntur expedita. Mollitia ab doloremque est voluptas architecto debitis non quos.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/6.jpg',1253,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(7,'Tips for Maintaining Your Car to Extend Its Lifespan','Essential tips on how to keep your car in top condition, ensuring it lasts longer and performs better.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Molestiae suscipit natus et facilis. Aut eaque quibusdam unde laborum ullam est. Qui animi rerum cumque expedita accusantium. Quisquam aperiam et amet sed id quia. Amet quasi facilis odio ut illum quaerat nihil. Et consequuntur perspiciatis nemo voluptas sed corporis. Doloremque et dolore numquam doloribus voluptas hic modi.\" content_2=\"Vitae quos vel ad mollitia. Alias et quis omnis eos qui praesentium. Qui in recusandae sed repellendus. Laudantium quo omnis aut natus officia est velit voluptatem. Autem error enim et ut. Eius quod voluptas quasi molestiae ut cum ea. Omnis sint voluptas assumenda est. Animi velit quae nesciunt explicabo. Expedita iusto nemo sunt eligendi. Cum alias amet cupiditate quae quis eaque.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/7.jpg',1738,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(8,'Top Safety Features to Look for in a Family Car','A guide to the latest safety innovations in family vehicles and how they protect your loved ones on the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Excepturi non dolores ducimus saepe aut non voluptatem. Exercitationem aut ut qui ea omnis nesciunt ea facere. Accusantium a expedita aut inventore. Impedit odio et rem doloremque omnis doloremque. Culpa quas ea dolor quasi tempora. Minus et labore quas. Dolores rerum sit nihil repudiandae similique iste.\" content_2=\"Dignissimos aut eaque est voluptate inventore quia. Quisquam modi voluptatem aperiam sequi consequatur cum odit. Laborum quia laboriosam nulla et ut quia alias qui. Necessitatibus placeat est sit sed atque voluptatum commodi.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/8.jpg',1190,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(9,'How Self-Driving Cars Are Changing the Future of Transportation','An overview of autonomous vehicles and the potential they have to reshape the way we travel.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Autem expedita quibusdam a porro reiciendis. Recusandae excepturi perferendis rerum provident consequatur reprehenderit numquam. Adipisci sed ut ut rerum. Illum assumenda ut hic iusto enim qui hic. Ullam itaque voluptatum facilis ut molestias ea. Qui aut ab et reprehenderit. Vero et nam consequatur dicta cum excepturi.\" content_2=\"Totam exercitationem beatae facere dolor quam est. Saepe quo non quo odit. Praesentium vitae sequi incidunt nam quas est aperiam accusamus. Quis error dolorem tenetur impedit dicta molestiae assumenda. Explicabo temporibus et laborum ipsam qui. Atque eaque ipsa nobis doloremque labore qui omnis.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/7.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/9.jpg',2219,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(10,'The Best Cars for Off-Road Adventures','Discover the top vehicles that offer exceptional performance on rough terrains for your next outdoor adventure.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quod velit est nam quas est eaque minima commodi. Iusto soluta dolor porro voluptatem porro nemo asperiores aut. In dolorum aut eaque pariatur maxime consequuntur tempore voluptatem. Sed non earum aut nam. Quo non laboriosam officiis nostrum ut labore. Voluptatem quas eos dolorem mollitia.\" content_2=\"Voluptatibus eum ea nulla rerum quidem et alias. Quis culpa consequatur suscipit sunt ipsa consequatur iste quisquam. Non ex est corporis sequi quo mollitia amet minima. Eligendi vel ut magni tenetur blanditiis occaecati. Sed nihil et facere qui.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/10.jpg',1616,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(11,'The Rise of Car Subscription Services','Learn about the growing trend of car subscription services and why more drivers are opting for this flexible alternative to car ownership.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Voluptatem sit culpa quas veniam repellendus. Eum natus enim beatae laboriosam harum aspernatur. Quibusdam excepturi mollitia temporibus unde consectetur eos cum id. Sed cum est tenetur corporis. Est qui sunt assumenda alias sint ducimus. Sunt qui occaecati expedita voluptatum consequatur et iusto. Ut et quis ipsa.\" content_2=\"Quisquam officiis commodi nihil qui dicta et nesciunt. Aperiam sunt temporibus ut voluptas non adipisci sit nam. Doloremque autem ut aspernatur sed. Molestiae earum incidunt esse et occaecati nemo soluta. Ut sed cupiditate praesentium voluptatem laboriosam. Consequatur doloremque ab ut consequatur consequuntur et.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/2.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/11.jpg',420,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(12,'Eco-Friendly Driving Tips to Reduce Your Carbon Footprint','Simple strategies for eco-conscious drivers to minimize their environmental impact on the road.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Qui eaque culpa quo qui sit. Quia cum atque voluptatem alias. Quos eos aspernatur rem magnam. Sunt inventore labore impedit est nemo. Perferendis ea quidem tenetur et. Quo culpa vel fugit veritatis. Ipsa dolore ut voluptates consequuntur ut eum. Possimus ducimus corporis totam nam asperiores est debitis.\" content_2=\"Et ipsam maxime modi magnam illum nesciunt tempora. Alias deleniti occaecati deleniti et rerum. Illum voluptates sint magnam aperiam qui. Quis eum voluptas officiis non voluptates sit necessitatibus. Et omnis sit et ut quas. Corrupti qui necessitatibus quas.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/9.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/12.jpg',1316,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(13,'The Future of Car Sharing: Convenience at Your Fingertips','Explore how car sharing platforms are making it easier for people to access vehicles without the commitment of ownership.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Porro temporibus et debitis in omnis. Consectetur odit sint possimus reiciendis aut. Alias aut est et nihil et nesciunt blanditiis. Ipsam ipsam eum harum sit perspiciatis illum eos. Voluptatem vero suscipit voluptatem unde voluptatem necessitatibus. Soluta quod harum et atque eos quia. Fugit laborum consequuntur nulla numquam possimus ipsum est.\" content_2=\"Quaerat explicabo aut nesciunt aperiam qui. Repudiandae commodi ut tempore voluptatum. Dolore numquam laudantium consequatur nemo et sunt. Aspernatur deserunt libero facilis est. Molestiae omnis sint aspernatur. Molestias eaque doloremque sed impedit nam enim delectus. Dolorum quod aperiam labore. Libero dolorem totam sequi.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/3.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/13.jpg',851,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(14,'How to Get the Best Deals on Car Rentals During Holidays','Insider tips on how to save money and secure great deals when renting cars for your holiday travels.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Nesciunt inventore optio voluptas aut id assumenda id qui. Debitis fugiat similique qui voluptatem quasi. Consequuntur quia quidem in iure. Aut hic provident et hic dolores. Blanditiis animi praesentium hic dolorem consequatur et molestiae. Aliquid voluptatem aut pariatur. Aperiam atque itaque at. Sit quae odit illum in.\" content_2=\"Ad sint qui dolor iste. Tempore repudiandae rerum dolor rem ex provident incidunt quia. Porro nihil laudantium autem eum. Facilis rerum qui natus dolor nihil. Quia rerum delectus quo. Accusamus vitae quasi minus dolorum.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/14.jpg',852,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(15,'The Pros and Cons of Hybrid Vehicles','An analysis of the advantages and disadvantages of hybrid cars, helping you decide if they are the right choice for you.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Atque eos laborum eos quia. Expedita tenetur deleniti quaerat commodi voluptatem architecto. Explicabo enim autem veritatis facere suscipit. Doloremque sit qui animi est. Doloremque consectetur molestiae minus consectetur voluptas. Pariatur non architecto quo beatae quis delectus. Omnis corporis esse suscipit aliquid.\" content_2=\"Inventore aut quaerat officiis et. Dolorem quas id odio. Qui enim quod sunt repellendus et ea totam. At ut eligendi omnis voluptatum porro incidunt non. Nulla sed molestiae hic dolor sed sint. Dicta voluptatem qui aut qui. Nostrum sunt laboriosam tempora.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/6.jpg\" image_2=\"news/10.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/15.jpg',1871,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(16,'How to Properly Clean and Detail Your Car','Step-by-step instructions on cleaning your car inside and out to keep it looking brand new.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Qui quasi sunt et ratione voluptatem dignissimos impedit. Consequatur nihil voluptatum omnis aut qui exercitationem doloribus. Accusamus officiis quasi qui ipsa nihil vel et. Eligendi sed dolores ullam nulla laboriosam. Commodi alias eveniet dolor aliquid est. Rerum necessitatibus inventore quisquam ullam.\" content_2=\"Et unde ut expedita commodi earum ratione molestias. Cumque odit explicabo quis nemo quasi. Consequatur et odit vero voluptas error dolores voluptatem qui. Voluptates in quidem quia omnis repellendus sit vitae. Voluptas molestias eius soluta.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/8.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/16.jpg',624,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(17,'Car Innovations: What to Expect in the Next 5 Years','A look at the technological advancements expected to revolutionize cars in the near future.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Reiciendis nam sed vel placeat quam dignissimos. Quidem similique ipsa soluta et assumenda. Inventore sunt facilis quae pariatur. Numquam hic porro necessitatibus molestiae. Voluptatem quidem nihil voluptatem labore. Impedit aut praesentium aut adipisci qui. Ut voluptas totam id temporibus saepe ducimus. Inventore omnis eius impedit repudiandae.\" content_2=\"Sunt suscipit impedit voluptas placeat omnis dolor id. Reprehenderit quisquam voluptatem nihil est distinctio quia est esse. Aut officia fugiat facere ratione tenetur provident dolores. Ea iste dolorem voluptate culpa est. Sed aperiam distinctio magnam vel et aliquid inventore. Adipisci quia ut dolores mollitia veritatis ullam occaecati. Quidem a quasi et consequatur maiores consequatur tempora.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/10.jpg\" image_2=\"news/1.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/17.jpg',2237,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(18,'The Ultimate Guide to Buying a Used Car','Everything you need to know about purchasing a used vehicle, from inspecting it to negotiating the best price.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Quod dolorum et accusamus qui aperiam qui aspernatur earum. Officiis doloremque et id et aut vel magnam explicabo. Error nam natus occaecati facere enim. Eius adipisci doloribus praesentium. Libero enim et exercitationem. Nihil at adipisci odit tenetur nisi est. Iusto delectus autem est quo.\" content_2=\"Velit libero delectus et voluptatem saepe voluptatem vel. Rerum dolor qui accusantium deleniti delectus perferendis. Est architecto quos ab consequatur. Distinctio cupiditate expedita doloremque et soluta reiciendis. Et omnis ab soluta delectus laboriosam.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/5.jpg\" image_2=\"news/6.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/18.jpg',1698,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(19,'How to Plan a Cross-Country Trip with a Rented Car','Tips on organizing a successful cross-country road trip, including how to choose the right rental car.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Eius voluptatem a odit aut pariatur expedita cum nulla. Quos dolorem ab quas earum quisquam et. Voluptas atque tenetur sapiente qui dolores veritatis voluptates. Quia debitis reprehenderit dolor facere aut et tempora. Repellat in rem recusandae architecto impedit. Consequatur distinctio eius numquam minus consequatur.\" content_2=\"Voluptatum cumque expedita vel nemo. Dignissimos non sequi quis ex perspiciatis sit. Natus fugit placeat officiis facere quos. Impedit animi nesciunt laboriosam ducimus sit nihil. Illo necessitatibus illo dolorem deleniti in quia veritatis. Nihil voluptate et ipsum aut sunt. Atque quisquam blanditiis tempora est ut totam a. Dignissimos ab voluptatem similique sit itaque rem officiis.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/9.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/19.jpg',110,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57'),(20,'What You Need to Know About Car Insurance Before Renting','An essential guide to understanding car rental insurance and how to choose the right coverage for your trip.','<h6>Determine Your Trip Purpose</h6>\n\n<p class=\"neutral-1000\">The first step in choosing the right rental car is to clearly define the purpose of your trip. Are you traveling alone or with family? Is it a business trip or a leisure vacation? The purpose of your trip will greatly influence the type of car you need. For instance, a compact car might be ideal for a solo business trip in a busy city, while a spacious SUV or minivan would be better suited for a family road trip.</p>\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Consider the Number of Passengers and Luggage</h6>\n\n<p>The number of passengers and the amount of luggage you need to carry are crucial factors in choosing a rental car. If you\'re traveling with a large group or have plenty of baggage, a larger vehicle like an SUV or minivan will provide the space and comfort you need. On the other hand, if you\'re traveling light or with just one other person, a compact or mid-size car may be more economical and easier to maneuver.</p>\n\n<h6>Think About the Terrain and Weather Conditions</h6>\n\n<p>Where you’re going plays a significant role in your choice of rental car. If you\'re planning to drive in a mountainous region or during winter, a vehicle with all-wheel drive (AWD) or four-wheel drive (4WD) might be necessary for safety. For urban areas with smooth roads, a standard sedan or compact car should suffice. Additionally, consider the climate; air conditioning is essential in hot climates, while heated seats can be a nice touch in colder regions.</p>\n\n<h6>Assess Your Budget</h6>\n\n<p>Your budget is another crucial factor when choosing a rental car. Rental rates vary depending on the vehicle type, rental duration, and additional services or features. Set a budget before you start comparing options and stick to it. Remember to factor in additional costs like insurance, fuel, and any extras such as GPS, child seats, or toll passes.</p>\n\n<h6>Check for Special Requirements or Preferences</h6>\n\n[content-columns quantity=\"2\" content_1=\"Dolorem optio vero tenetur. Suscipit quaerat similique consequatur. Sed magni est sed facere corporis. Occaecati magni iure ea repudiandae. Veniam maiores soluta nulla voluptatibus quod tenetur ut omnis. Ipsum ut optio unde corrupti aliquam. Et rerum aut molestiae incidunt. Fugit fugit amet accusamus distinctio eum et et similique. Laboriosam beatae ut nemo et consequuntur numquam voluptatem.\" content_2=\"Ex voluptatem aspernatur beatae optio rerum aliquid. Ab magnam odit earum nihil repudiandae aperiam. Perferendis ea consectetur architecto quam. Animi incidunt asperiores dolores. Quia soluta quasi dolores laboriosam sit et animi. Quas perferendis sit omnis quos quia id consectetur. Neque maiores reiciendis necessitatibus id.\"][/content-columns]\n\n[content-images quantity=\"2\" image_1=\"news/7.jpg\" image_2=\"news/8.jpg\"][/content-images]\n\n<h6>Conclusion</h6>\n\n<p>Choosing the right rental car involves more than just picking a vehicle that looks good. By considering the purpose of your trip, the number of passengers, the terrain, fuel efficiency, and your budget, you can select a car that will make your journey smooth, comfortable, and enjoyable. Take your time to compare options and book in advance to ensure you get the best vehicle for your needs. Whether you\'re hitting the open road or navigating city streets, the right rental car can make all the difference in your travel experience.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/20.jpg',1032,NULL,'2025-11-17 21:09:57','2025-11-17 21:09:57');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notification_recipients`
--

DROP TABLE IF EXISTS `push_notification_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notification_recipients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `push_notification_id` bigint unsigned NOT NULL,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `device_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `clicked_at` timestamp NULL DEFAULT NULL,
  `fcm_response` json DEFAULT NULL,
  `error_message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pnr_notification_user_index` (`push_notification_id`,`user_type`,`user_id`),
  KEY `pnr_user_status_index` (`user_type`,`user_id`,`status`),
  KEY `pnr_user_read_index` (`user_type`,`user_id`,`read_at`),
  KEY `pnr_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notification_recipients`
--

LOCK TABLES `push_notification_recipients` WRITE;
/*!40000 ALTER TABLE `push_notification_recipients` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notification_recipients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notifications`
--

DROP TABLE IF EXISTS `push_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `target_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` json DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_count` int NOT NULL DEFAULT '0',
  `failed_count` int NOT NULL DEFAULT '0',
  `delivered_count` int NOT NULL DEFAULT '0',
  `read_count` int NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `push_notifications_type_created_at_index` (`type`,`created_at`),
  KEY `push_notifications_status_scheduled_at_index` (`status`,`scheduled_at`),
  KEY `push_notifications_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notifications`
--

LOCK TABLES `push_notifications` WRITE;
/*!40000 ALTER TABLE `push_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"car-rentals.index\":true,\"car-rentals.cars.index\":true,\"car-rentals.cars.create\":true,\"car-rentals.cars.edit\":true,\"car-rentals.cars.destroy\":true,\"car-rentals.customers.index\":true,\"car-rentals.customers.create\":true,\"car-rentals.customers.edit\":true,\"car-rentals.customers.destroy\":true,\"car-rentals.bookings.index\":true,\"car-rentals.bookings.create\":true,\"car-rentals.bookings.edit\":true,\"car-rentals.bookings.destroy\":true,\"car-rentals.invoices.index\":true,\"car-rentals.invoices.create\":true,\"car-rentals.invoices.edit\":true,\"car-rentals.invoices.destroy\":true,\"car-rentals.reviews.index\":true,\"car-rentals.reviews.edit\":true,\"car-rentals.reviews.destroy\":true,\"car-rentals.coupons.index\":true,\"car-rentals.coupons.create\":true,\"car-rentals.coupons.edit\":true,\"car-rentals.coupons.destroy\":true,\"car-rentals.taxes.index\":true,\"car-rentals.taxes.create\":true,\"car-rentals.taxes.edit\":true,\"car-rentals.taxes.destroy\":true,\"car-rentals.attributes.index\":true,\"car-rentals.car-makes.index\":true,\"car-rentals.car-makes.create\":true,\"car-rentals.car-makes.edit\":true,\"car-rentals.car-makes.destroy\":true,\"car-rentals.car-types.index\":true,\"car-rentals.car-types.create\":true,\"car-rentals.car-types.edit\":true,\"car-rentals.car-types.destroy\":true,\"car-rentals.car-transmissions.index\":true,\"car-rentals.car-transmissions.create\":true,\"car-rentals.car-transmissions.edit\":true,\"car-rentals.car-transmissions.destroy\":true,\"car-rentals.car-fuels.index\":true,\"car-rentals.car-fuels.create\":true,\"car-rentals.car-fuels.edit\":true,\"car-rentals.car-fuels.destroy\":true,\"car-rentals.car-colors.index\":true,\"car-rentals.car-colors.create\":true,\"car-rentals.car-colors.edit\":true,\"car-rentals.car-colors.destroy\":true,\"car-rentals.car-maintenance-histories.index\":true,\"car-rentals.car-maintenance-histories.create\":true,\"car-rentals.car-maintenance-histories.edit\":true,\"car-rentals.car-maintenance-histories.destroy\":true,\"car-rentals.car-tags.index\":true,\"car-rentals.car-tags.create\":true,\"car-rentals.car-tags.edit\":true,\"car-rentals.car-tags.destroy\":true,\"car-rentals.car-categories.index\":true,\"car-rentals.car-categories.create\":true,\"car-rentals.car-categories.edit\":true,\"car-rentals.car-categories.destroy\":true,\"car-rentals.car-amenities.index\":true,\"car-rentals.car-amenities.create\":true,\"car-rentals.car-amenities.edit\":true,\"car-rentals.car-amenities.destroy\":true,\"car-rentals.services.index\":true,\"car-rentals.services.create\":true,\"car-rentals.services.edit\":true,\"car-rentals.services.destroy\":true,\"car-rentals.booking.reports.index\":true,\"car-rentals.booking.calendar.index\":true,\"car-rentals.message.index\":true,\"car-rentals.message.edit\":true,\"car-rentals.message.destroy\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"fob-comment.index\":true,\"fob-comment.comments.index\":true,\"fob-comment.comments.edit\":true,\"fob-comment.comments.destroy\":true,\"fob-comment.comments.reply\":true,\"fob-comment.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"team.index\":true,\"team.create\":true,\"team.edit\":true,\"team.destroy\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-11-17 21:09:50','2025-11-17 21:09:50');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','e8341aba65c12cb2bf4184a957d25e9c',NULL,'2025-11-17 21:11:23'),(2,'api_enabled','0',NULL,'2025-11-17 21:11:23'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"car-rentals\",\"contact\",\"cookie-consent\",\"faq\",\"fob-comment\",\"gallery\",\"location\",\"newsletter\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"team\",\"testimonial\",\"translation\"]',NULL,'2025-11-17 21:11:23'),(4,'theme','carento',NULL,'2025-11-17 21:11:23'),(5,'show_admin_bar','1',NULL,'2025-11-17 21:11:23'),(6,'admin_logo','general/logo-dark.png',NULL,'2025-11-17 21:11:23'),(7,'admin_favicon','general/favicon.png',NULL,'2025-11-17 21:11:23'),(8,'permalink-botble-blog-models-post','news',NULL,'2025-11-17 21:11:23'),(9,'permalink-botble-blog-models-category','news',NULL,'2025-11-17 21:11:23'),(10,'payment_cod_status','1',NULL,'2025-11-17 21:11:23'),(11,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-11-17 21:11:23'),(12,'payment_bank_transfer_status','1',NULL,'2025-11-17 21:11:23'),(13,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-11-17 21:11:23'),(14,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-11-17 21:11:23'),(15,'language_switcher_display','dropdown',NULL,'2025-11-17 21:11:23'),(16,'car_rentals_company_name_for_invoicing','Carento',NULL,'2025-11-17 21:11:23'),(17,'car_rentals_company_logo_for_invoicing','general/logo.png',NULL,'2025-11-17 21:11:23'),(18,'car_rentals_company_address_for_invoicing','123, My Street, Kingston, New York',NULL,'2025-11-17 21:11:23'),(19,'car_rentals_company_email_for_invoicing','contact@botble.com',NULL,'2025-11-17 21:11:23'),(20,'car_rentals_company_phone_for_invoicing','123456789',NULL,'2025-11-17 21:11:23'),(21,'car_rentals_enabled_review','1',NULL,'2025-11-17 21:11:23'),(22,'car_rentals_enabled_multi_vendor','1',NULL,'2025-11-17 21:11:23'),(23,'simple_slider_using_assets','0',NULL,'2025-11-17 21:11:23'),(24,'theme-carento-site_title','Carento - Car Rentals Laravel Script',NULL,'2025-11-17 21:11:23'),(25,'theme-carento-seo_description','Carento is a robust Laravel script for managing car rental businesses, featuring advanced booking, real-time vehicle availability, and customizable options for efficient operations.',NULL,'2025-11-17 21:11:23'),(26,'theme-carento-copyright','©%Y Botble Team. All Rights Reserved.',NULL,'2025-11-17 21:11:23'),(27,'theme-carento-favicon','general/favicon.png',NULL,'2025-11-17 21:11:23'),(28,'theme-carento-logo','general/logo.png',NULL,'2025-11-17 21:11:23'),(29,'theme-carento-logo_dark','general/logo-dark.png',NULL,'2025-11-17 21:11:23'),(30,'theme-carento-logo_height','76',NULL,'2025-11-17 21:11:23'),(31,'theme-carento-primary_font','Urbanist',NULL,'2025-11-17 21:11:23'),(32,'theme-carento-secondary_font','Urbanist',NULL,'2025-11-17 21:11:23'),(33,'theme-carento-primary_color','#82b440',NULL,'2025-11-17 21:11:23'),(34,'theme-carento-primary_color_hover','#7aa93c',NULL,'2025-11-17 21:11:23'),(35,'theme-carento-secondary_color','rgba(45, 74, 44, 0.6)',NULL,'2025-11-17 21:11:23'),(36,'theme-carento-heading_color','#000000',NULL,'2025-11-17 21:11:23'),(37,'theme-carento-text_color','#454545',NULL,'2025-11-17 21:11:23'),(38,'theme-carento-header_top_background_color','#000000',NULL,'2025-11-17 21:11:23'),(39,'theme-carento-header_top_text_color','#ffffff',NULL,'2025-11-17 21:11:23'),(40,'theme-carento-is_header_transparent','1',NULL,'2025-11-17 21:11:23'),(41,'theme-carento-preloader_enabled','1',NULL,'2025-11-17 21:11:23'),(42,'theme-carento-preloader_version','v2',NULL,'2025-11-17 21:11:23'),(43,'theme-carento-breadcrumb_background_image','backgrounds/service-bg.jpg',NULL,'2025-11-17 21:11:23'),(44,'theme-carento-homepage_id','1',NULL,'2025-11-17 21:11:23'),(45,'theme-carento-blog_page_id','2',NULL,'2025-11-17 21:11:23'),(46,'theme-carento-blog_post_list_page_title','Recent Posts',NULL,'2025-11-17 21:11:23'),(47,'theme-carento-blog_post_list_page_description','Favorite vehicles based on customer reviews',NULL,'2025-11-17 21:11:23'),(48,'theme-carento-blog_post_gird_items_per_row','2',NULL,'2025-11-17 21:11:23'),(49,'theme-carento-blog_post_style','grid',NULL,'2025-11-17 21:11:23'),(50,'theme-carento-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-11-17 21:11:23'),(51,'theme-carento-footer_text_color','#8e8e8e',NULL,'2025-11-17 21:11:23'),(52,'theme-carento-footer_heading_color','#ffffff',NULL,'2025-11-17 21:11:23'),(53,'theme-carento-footer_border_color','#5756567d',NULL,'2025-11-17 21:11:23'),(54,'theme-carento-footer_background_color','#000000',NULL,'2025-11-17 21:11:23'),(55,'theme-carento-newsletter_popup_enable','1',NULL,'2025-11-17 21:11:23'),(56,'theme-carento-newsletter_popup_image','backgrounds/newsletter-bg.jpg',NULL,'2025-11-17 21:11:23'),(57,'theme-carento-newsletter_popup_title','Special Offers',NULL,'2025-11-17 21:11:23'),(58,'theme-carento-newsletter_popup_subtitle','Newsletter',NULL,'2025-11-17 21:11:23'),(59,'theme-carento-newsletter_popup_description','Special Offer: Rent Your Car Today!',NULL,'2025-11-17 21:11:23'),(60,'theme-carento-number_of_cars_per_page','30',NULL,'2025-11-17 21:11:23'),(61,'language_hide_default','1',NULL,'2025-11-17 21:11:23'),(62,'language_display','all',NULL,'2025-11-17 21:11:23'),(63,'language_hide_languages','[]',NULL,'2025-11-17 21:11:23'),(64,'announcement_max_width','1210',NULL,'2025-11-17 21:11:23'),(65,'announcement_text_color','#FFFFFF',NULL,'2025-11-17 21:11:23'),(66,'announcement_background_color','transparent',NULL,'2025-11-17 21:11:23'),(67,'announcement_text_alignment','start',NULL,'2025-11-17 21:11:23'),(68,'announcement_dismissible','1',NULL,'2025-11-17 21:11:23'),(69,'announcement_font_size','14',NULL,'2025-11-17 21:11:23'),(70,'announcement_font_size_unit','px',NULL,'2025-11-17 21:11:23'),(71,'announcement_placement','theme',NULL,'2025-11-17 21:11:23');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Find your next vehicle today','sliders/banner-1.jpg','/','Browse our diverse inventory and enjoy a seamless buying experience <br> with expert support every step of the way',0,'2025-11-17 21:11:23','2025-11-17 21:11:23'),(2,1,'Discover your next ride today','sliders/banner-2.jpg','/','Explore our wide selection and enjoy a smooth purchasing journey, <br> with expert assistance at every turn',1,'2025-11-17 21:11:23','2025-11-17 21:11:23'),(3,2,'CAR REVIEW','sliders/img-1-1.jpg','/','The Tucson Plug-in Hybrid is easy to drive and provides a sufficient all-electric range.',0,'2025-11-17 21:11:23','2025-11-17 21:11:23'),(4,2,'CAR REVIEW','sliders/img-1.jpg','/','The Tucson Plug-in Hybrid is easy to drive and provides a sufficient all-electric range.',1,'2025-11-17 21:11:23','2025-11-17 21:11:23');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-11-17 21:11:23','2025-11-17 21:11:23'),(2,'Home slider 02','home-slider-02','The slider in homepage page 2','published','2025-11-17 21:11:23','2025-11-17 21:11:23');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`),
  KEY `idx_slugs_reference` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'homepage',1,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(2,'blog',2,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(3,'contact',3,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(4,'services',4,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(5,'pricing',5,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(6,'about-us',6,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(7,'car-list-1',7,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(8,'car-list-2',8,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(9,'car-list-3',9,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(10,'car-list-4',10,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(11,'agencies',11,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(12,'faqs',12,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(13,'brands',13,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(14,'car-dealers',14,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(15,'our-awards',15,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(16,'copyright-notices',16,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(17,'terms-of-use',17,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(18,'privacy-notice',18,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(19,'lost-found',19,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(20,'car-rental-services',20,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(21,'vehicle-leasing-options',21,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(22,'long-term-car-rentals',22,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(23,'car-sales-and-trade-ins',23,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(24,'luxury-car-rentals',24,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(25,'rent-to-own-programs',25,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(26,'fleet-management-solutions',26,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(27,'affiliates',27,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(28,'travel-agents',28,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(29,'aarp-members',29,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(30,'points-programs',30,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(31,'military-veterans',31,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(32,'work-with-us',32,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(33,'advertise-with-us',33,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(34,'forum-support',34,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(35,'help-center',35,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(36,'live-chat',36,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(37,'how-it-works',37,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(38,'security',38,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(39,'refund-policy',39,'Botble\\Page\\Models\\Page','','2025-11-17 21:09:50','2025-11-17 21:09:50'),(40,'new-cars',1,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(41,'car-rentals',2,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(42,'electric-vehicles',3,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(43,'car-maintenance',4,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(44,'road-trips',5,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(45,'luxury-cars',6,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(46,'family-cars',7,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(47,'off-road-vehicles',8,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(48,'hybrid-cars',9,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(49,'car-innovations',10,'Botble\\Blog\\Models\\Category','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(50,'2024-cars',1,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(51,'car-leasing',2,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(52,'self-driving-cars',3,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(53,'eco-friendly',4,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(54,'car-subscription',5,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(55,'car-insurance',6,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(56,'used-cars',7,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(57,'car-detailing',8,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(58,'holiday-rentals',9,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(59,'cross-country-trips',10,'Botble\\Blog\\Models\\Tag','tag','2025-11-17 21:09:57','2025-11-17 21:09:57'),(60,'top-5-new-cars-to-look-out-for-in-2024',1,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(61,'how-to-choose-the-best-car-rental-service-for-your-trip',2,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(62,'the-evolution-of-electric-vehicles-a-new-era',3,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(63,'leasing-vs-buying-a-car-which-is-right-for-you',4,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(64,'the-ultimate-road-trip-checklist',5,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(65,'the-benefits-of-renting-a-luxury-car-for-special-occasions',6,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(66,'tips-for-maintaining-your-car-to-extend-its-lifespan',7,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(67,'top-safety-features-to-look-for-in-a-family-car',8,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(68,'how-self-driving-cars-are-changing-the-future-of-transportation',9,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(69,'the-best-cars-for-off-road-adventures',10,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(70,'the-rise-of-car-subscription-services',11,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(71,'eco-friendly-driving-tips-to-reduce-your-carbon-footprint',12,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(72,'the-future-of-car-sharing-convenience-at-your-fingertips',13,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(73,'how-to-get-the-best-deals-on-car-rentals-during-holidays',14,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(74,'the-pros-and-cons-of-hybrid-vehicles',15,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(75,'how-to-properly-clean-and-detail-your-car',16,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(76,'car-innovations-what-to-expect-in-the-next-5-years',17,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(77,'the-ultimate-guide-to-buying-a-used-car',18,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(78,'how-to-plan-a-cross-country-trip-with-a-rented-car',19,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(79,'what-you-need-to-know-about-car-insurance-before-renting',20,'Botble\\Blog\\Models\\Post','news','2025-11-17 21:09:57','2025-11-17 21:09:57'),(80,'stunning-electric-cars-of-2024',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(81,'top-luxury-cars-for-special-occasions',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(82,'family-cars-with-advanced-safety-features',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(83,'off-road-vehicles-in-action',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(84,'the-evolution-of-car-design-a-visual-journey',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(85,'best-road-trip-cars-of-the-year',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(86,'exclusive-new-car-models-unveiled',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(87,'iconic-cars-from-around-the-world',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(88,'the-future-of-electric-and-hybrid-cars',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(89,'luxury-car-interiors-a-closer-look',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-11-17 21:10:00','2025-11-17 21:10:00'),(90,'devon-lane',1,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(91,'marvin-mckinney',2,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(92,'ronald-richards',3,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(93,'cameron-williamson',4,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(94,'alicia-sanders',5,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(95,'ethan-wright',6,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(96,'isabella-johnson',7,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(97,'liam-brown',8,'Botble\\Team\\Models\\Team','teams','2025-11-17 21:10:02','2025-11-17 21:10:02'),(98,'toyota-camry-xle-hybrid-2024',1,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(99,'honda-accord-sport-20t-2024',2,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(100,'mercedes-benz-c300-4matic-2024',3,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(101,'bmw-330i-xdrive-m-sport-2024',4,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(102,'lexus-es-350-f-sport-2024',5,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(103,'toyota-rav4-prime-xse-awd-2024',6,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(104,'honda-cr-v-touring-hybrid-awd-2024',7,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(105,'bmw-x5-xdrive40i-m-sport-2024',8,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(106,'mercedes-benz-glc-300-4matic-2024',9,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(107,'lexus-rx-350-f-sport-handling-awd-2024',10,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(108,'audi-a4-premium-plus-quattro-2024',11,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(109,'mazda-cx-5-25-turbo-signature-awd-2024',12,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(110,'tesla-model-3-long-range-awd-2024',13,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(111,'porsche-macan-s-2024',14,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(112,'volvo-xc60-b6-ultimate-awd-2024',15,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(113,'genesis-g70-33t-sport-prestige-awd-2024',16,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(114,'subaru-outback-limited-xt-2024',17,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(115,'acura-mdx-type-s-advance-2024',18,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(116,'range-rover-evoque-p250-s-2024',19,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(117,'infiniti-qx60-autograph-awd-2024',20,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(118,'nissan-altima-sr-vc-turbo-2024',21,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(119,'hyundai-sonata-n-line-2024',22,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(120,'kia-stinger-gt2-awd-2024',23,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(121,'volkswagen-atlas-cross-sport-sel-premium-2024',24,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(122,'chevrolet-blazer-rs-awd-2024',25,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(123,'ford-explorer-st-4wd-2024',26,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(124,'jeep-grand-cherokee-summit-reserve-4xe-2024',27,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(125,'cadillac-xt5-premium-luxury-awd-2024',28,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(126,'lincoln-aviator-reserve-awd-2024',29,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(127,'alfa-romeo-stelvio-veloce-awd-2024',30,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(128,'mclaren-720s-spider-2024',31,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(129,'mercedes-benz-g550-4matic-2024',32,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(130,'ford-mustang-gt-premium-2024',33,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(131,'porsche-911-carrera-s-2024',34,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(132,'audi-r8-v10-performance-2024',35,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(133,'lamborghini-huracan-evo-2024',36,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(134,'bmw-m4-competition-xdrive-2024',37,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(135,'maserati-ghibli-modena-2024',38,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(136,'bentley-continental-gt-v8-2024',39,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(137,'rolls-royce-ghost-black-badge-2024',40,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(138,'hyundai-tucson-limited-awd-2024',41,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(139,'kia-sportage-sx-turbo-awd-2024',42,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(140,'volkswagen-tiguan-sel-r-line-2024',43,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(141,'toyota-highlander-platinum-awd-2024',44,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(142,'honda-pilot-trailsport-awd-2024',45,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(143,'mazda-mx-5-miata-grand-touring-2024',46,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(144,'nissan-rogue-platinum-awd-2024',47,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(145,'mini-cooper-s-hardtop-2024',48,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(146,'dodge-challenger-rt-scat-pack-2024',49,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(147,'chevrolet-camaro-ss-1le-2024',50,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(148,'ferrari-f8-tributo-2024',51,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(149,'jaguar-f-pace-svr-2024',52,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(150,'land-rover-defender-110-x-2024',53,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(151,'chrysler-pacifica-pinnacle-awd-2024',54,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(152,'gmc-sierra-1500-denali-2024',55,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(153,'mitsubishi-outlander-sel-s-awc-2024',56,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(154,'peugeot-308-gt-premium-2024',57,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(155,'fiat-500x-sport-awd-2024',58,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(156,'smart-eq-fortwo-prime-2024',59,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(157,'toyota-corolla-hybrid-le-2024',60,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(158,'aston-martin-vantage-f1-edition-2024',61,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(159,'bugatti-chiron-super-sport-2024',62,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(160,'mclaren-artura-spider-2024',63,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(161,'pagani-huayra-roadster-bc-2024',64,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(162,'koenigsegg-jesko-absolut-2024',65,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(163,'mercedes-benz-e450-4matic-all-terrain-2024',66,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(164,'audi-q7-55-tfsi-quattro-premium-plus-2024',67,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(165,'bmw-x7-xdrive40i-m-sport-2024',68,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(166,'lexus-lx-600-ultra-luxury-2024',69,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(167,'volvo-s90-b6-ultimate-awd-2024',70,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(168,'genesis-gv70-25t-sport-awd-2024',71,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(169,'acura-tlx-type-s-pmc-edition-2024',72,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(170,'infiniti-q50-red-sport-400-awd-2024',73,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(171,'jaguar-xf-p300-r-dynamic-s-awd-2024',74,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(172,'alfa-romeo-giulia-quadrifoglio-2024',75,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(173,'porsche-cayenne-turbo-gt-2024',76,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(174,'range-rover-sport-hse-dynamic-2024',77,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(175,'mercedes-amg-gle-63-s-4matic-2024',78,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(176,'bmw-m5-competition-xdrive-2024',79,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(177,'audi-rs-q8-quattro-2024',80,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(178,'tesla-model-s-plaid-2024',81,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(179,'lucid-air-grand-touring-performance-2024',82,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(180,'rivian-r1s-adventure-2024',83,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(181,'polestar-2-long-range-dual-motor-2024',84,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(182,'genesis-electrified-gv70-advanced-awd-2024',85,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(183,'mercedes-maybach-s-580-4matic-2024',86,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(184,'bentley-bentayga-s-v8-2024',87,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(185,'rolls-royce-cullinan-black-badge-2024',88,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(186,'aston-martin-dbx707-2024',89,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(187,'maserati-levante-trofeo-2024',90,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(188,'ferrari-roma-spider-2024',91,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(189,'mclaren-gt-luxe-2024',92,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(190,'lamborghini-urus-performante-2024',93,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(191,'porsche-taycan-turbo-s-cross-turismo-2024',94,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(192,'bmw-xm-label-red-2024',95,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(193,'chevrolet-corvette-z06-3lz-2024',96,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(194,'ford-gt-heritage-edition-2024',97,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(195,'dodge-viper-acr-extreme-2024',98,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(196,'nissan-gt-r-nismo-special-edition-2024',99,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(197,'toyota-supra-30-premium-2024',100,'Botble\\CarRentals\\Models\\Car','cars','2025-11-17 21:11:23','2025-11-17 21:11:23'),(198,'driver-rental-service',1,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(199,'oil-change-service',2,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(200,'car-wash-detailing-package',3,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(201,'roadside-assistance',4,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(202,'temporary-car-replacement',5,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(203,'tire-replacement-balancing',6,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(204,'vehicle-inspection-service',7,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(205,'car-insurance-assistance',8,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(206,'pick-up-drop-off-service',9,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(207,'premium-fuel-service',10,'Botble\\CarRentals\\Models\\Service','services','2025-11-17 21:11:24','2025-11-17 21:11:24'),(208,'sport',1,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:11:24','2025-11-17 21:11:24'),(209,'maserati',2,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:11:24','2025-11-17 21:11:24'),(210,'ferrari',3,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:11:24','2025-11-17 21:11:24'),(211,'classic',4,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:11:24','2025-11-17 21:11:24'),(212,'new',5,'Botble\\CarRentals\\Models\\CarCategory','car-categories','2025-11-17 21:11:24','2025-11-17 21:11:24'),(213,'lexus',1,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(214,'mercedes',2,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(215,'bugatti',3,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(216,'jaguar',4,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(217,'honda',5,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(218,'chevrolet',6,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(219,'acura',7,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(220,'bmw',8,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(221,'toyota',9,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(222,'ford',10,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(223,'nissan',11,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(224,'opel',12,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(225,'bmw',13,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24'),(226,'toyota',14,'Botble\\CarRentals\\Models\\CarMake','makes','2025-11-17 21:11:24','2025-11-17 21:11:24');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`),
  KEY `idx_states_name` (`name`),
  KEY `idx_states_status` (`status`),
  KEY `idx_states_country_id` (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'California','california','CA',1,1,NULL,1,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(2,'New York','new-york','NY',1,2,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(3,'Florida','florida','FL',1,3,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(4,'Texas','texas','TX',1,4,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(5,'Illinois','illinois','IL',1,5,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(6,'England','england','ENG',2,6,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(7,'Scotland','scotland','SCT',2,7,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(8,'Ontario','ontario','ON',3,8,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(9,'British Columbia','british-columbia','BC',3,9,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(10,'Bavaria','bavaria','BY',4,10,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(11,'Berlin','berlin','BE',4,11,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(12,'Île-de-France','ile-de-france','IDF',5,12,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(13,'Provence-Alpes-Côte d\'Azur','provence-alpes-cote-dazur','PACA',5,13,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(14,'New South Wales','new-south-wales','NSW',6,14,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(15,'Victoria','victoria','VIC',6,15,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(16,'Tokyo','tokyo','TK',7,16,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(17,'Osaka','osaka','OS',7,17,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(18,'Lazio','lazio','LAZ',8,18,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05'),(19,'Lombardy','lombardy','LOM',8,19,NULL,0,'published','2025-11-17 21:10:05','2025-11-17 21:10:05');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`),
  KEY `idx_states_trans_state_lang` (`states_id`,`lang_code`),
  KEY `idx_states_trans_name` (`name`),
  KEY `idx_states_trans_states_id` (`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'2024 Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(2,'Car Leasing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(3,'Self-Driving Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(4,'Eco-Friendly',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(5,'Car Subscription',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(6,'Car Insurance',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(7,'Used Cars',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(8,'Car Detailing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(9,'Holiday Rentals',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57'),(10,'Cross-Country Trips',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-11-17 21:09:57','2025-11-17 21:09:57');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teams`
--

DROP TABLE IF EXISTS `teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `socials` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `phone` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teams`
--

LOCK TABLES `teams` WRITE;
/*!40000 ALTER TABLE `teams` DISABLE KEYS */;
INSERT INTO `teams` VALUES (1,'Devon Lane','teams/1.jpg','Chief Executive Officer (CEO)','India','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','01123259241','devonsoland111@gmail.com','4855, 24, Ansari Road, Darya Ganj',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(2,'Marvin McKinney','teams/2.jpg','Fleet Manager','Thailand','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','6623742088','marvinkensy@gmail.com','849 Sukhapibal 1 Klong Chan Bang Kapi',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(3,'Ronald Richards','teams/3.jpg','Customer Service Representative','Canada','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','4165550123','ronrichards@marketing.com','123 Maple Street, Toronto, ON',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(4,'Cameron Williamson','teams/4.jpg','Finance &amp; Accounting Officer','Germany','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','49221567890','cameronwill@tech.com','45 Hauptstraße, 50667 Köln',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(5,'Alicia Sanders','teams/5.jpg','Marketing Executive','Australia','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0298765432','alicia.hr@company.com','15 George St, Sydney, NSW',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(6,'Ethan Wright','teams/6.jpg','Automotive Technician/Mechanic','South Africa','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0217896543','ethanwright@operations.com','789 Beach Road, Cape Town',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(7,'Isabella Johnson','teams/7.jpg','Operations Coordinator','New Zealand','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','0498761234','isabella.prod@company.com','32 Victoria St, Wellington',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally'),(8,'Liam Brown','teams/8.jpg','HR &amp; Administration Officer','United Kingdom','{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"instagram\":\"https:\\/\\/www.instagram.com\\/\"}','published','2025-11-17 21:10:02','2025-11-17 21:10:02','<p>Our diverse team of experts brings a wealth of knowledge and experience across various industries. We are united by a shared passion for excellence and a commitment to providing innovative solutions for your business needs. Get to know the faces driving our success and learn how their expertise can contribute to yours.</p>','02079461234','liam.legal@company.co.uk','10 Downing Street, London',NULL,'Sharing content online allows you to craft an online persona that reflects your personal values and professional skills. Even if you only use social media occasionally');
/*!40000 ALTER TABLE `teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teams_translations`
--

DROP TABLE IF EXISTS `teams_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `teams_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `teams_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`teams_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teams_translations`
--

LOCK TABLES `teams_translations` WRITE;
/*!40000 ALTER TABLE `teams_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `teams_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','testimonials/1.png','CEO, JAKS Shans','published','2025-11-17 21:10:03','2025-11-17 21:10:03'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','testimonials/2.png','SEO, ChenTech Solutions','published','2025-11-17 21:10:03','2025-11-17 21:10:03'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','testimonials/3.png','Developer, Moie Agency','published','2025-11-17 21:10:03','2025-11-17 21:10:03'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','testimonials/4.png','CEO, Bank of America','published','2025-11-17 21:10:03','2025-11-17 21:10:03');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_settings`
--

DROP TABLE IF EXISTS `user_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` json NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_settings_user_type_user_id_key_unique` (`user_type`,`user_id`,`key`),
  KEY `user_settings_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `user_settings_key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_settings`
--

LOCK TABLES `user_settings` WRITE;
/*!40000 ALTER TABLE `user_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  `sessions_invalidated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'hmcglynn@rippin.net',NULL,NULL,'$2y$12$PCs0HyIJn0P.0wcHa62.dO6lN0NuOdE9u2JTFCHgL21MSEul5nRw.',NULL,'2025-11-17 21:09:50','2025-11-17 21:10:02','Vivian','Konopelski','admin',59,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `widgets_unique_index` (`theme`,`sidebar_id`,`widget_id`,`position`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInformationWidget','footer_sidebar','carento',1,'{\"id\":\"SiteInformationWidget\",\"logo\":\"general\\/logo-dark.png\",\"quantity\":4,\"icon_1\":\"ti ti-map-pin\",\"description_1\":\"2356 Oakwood Drive, Suite 18, San Francisco, California 94111, US\",\"icon_2\":\"ti ti-clock-hour-3\",\"description_2\":\"Hours: 8:00 - 17:00, Mon - Sat\",\"icon_3\":\"ti ti-mail\",\"description_3\":\"support@carento.com\",\"title_4\":\"Need help? Call us\",\"icon_4\":\"ti ti-phone\",\"description_4\":\"<a href=\\\"tel:+1 222-555-33-99\\\">+1 222-555-33-99<\\/a>\"}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(2,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Company\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Awards\"},{\"key\":\"url\",\"value\":\"\\/our-awards\"}],[{\"key\":\"label\",\"value\":\"Agencies\"},{\"key\":\"url\",\"value\":\"\\/agencies\"}],[{\"key\":\"label\",\"value\":\"Copyright Notices\"},{\"key\":\"url\",\"value\":\"\\/copyright-notices\"}],[{\"key\":\"label\",\"value\":\"Terms of Use\"},{\"key\":\"url\",\"value\":\"\\/terms-of-use\"}],[{\"key\":\"label\",\"value\":\"Privacy Notice\"},{\"key\":\"url\",\"value\":\"\\/privacy-notice\"}],[{\"key\":\"label\",\"value\":\"Lost & Found\"},{\"key\":\"url\",\"value\":\"\\/lost-found\"}]]}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(3,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Our Services\",\"items\":[[{\"key\":\"label\",\"value\":\"Premium Fuel Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/premium-fuel-service\"}],[{\"key\":\"label\",\"value\":\"Pick-Up & Drop-Off Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/pick-up-drop-off-service\"}],[{\"key\":\"label\",\"value\":\"Car Insurance Assistance\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/car-insurance-assistance\"}],[{\"key\":\"label\",\"value\":\"Vehicle Inspection Service\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/vehicle-inspection-service\"}],[{\"key\":\"label\",\"value\":\"Tire Replacement & Balancing\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/tire-replacement-balancing\"}],[{\"key\":\"label\",\"value\":\"Temporary Car Replacement\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/temporary-car-replacement\"}],[{\"key\":\"label\",\"value\":\"Roadside Assistance\"},{\"key\":\"url\",\"value\":\"http:\\/\\/carento.test\\/services\\/roadside-assistance\"}]]}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',4,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Our Partners\",\"items\":[[{\"key\":\"label\",\"value\":\"Affiliates\"},{\"key\":\"url\",\"value\":\"\\/affiliates\"}],[{\"key\":\"label\",\"value\":\"Travel Agents\"},{\"key\":\"url\",\"value\":\"\\/travel-agents\"}],[{\"key\":\"label\",\"value\":\"AARP Members\"},{\"key\":\"url\",\"value\":\"\\/aarp-members\"}],[{\"key\":\"label\",\"value\":\"Points Programs\"},{\"key\":\"url\",\"value\":\"\\/points-programs\"}],[{\"key\":\"label\",\"value\":\"Military & Veterans\"},{\"key\":\"url\",\"value\":\"\\/military-veterans\"}],[{\"key\":\"label\",\"value\":\"Work with us\"},{\"key\":\"url\",\"value\":\"\\/work-with-us\"}],[{\"key\":\"label\",\"value\":\"Advertise with us\"},{\"key\":\"url\",\"value\":\"\\/advertise-with-us\"}]]}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','carento',5,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Support\",\"items\":[[{\"key\":\"label\",\"value\":\"Forum support\"},{\"key\":\"url\",\"value\":\"\\/forum-support\"}],[{\"key\":\"label\",\"value\":\"Help Center\"},{\"key\":\"url\",\"value\":\"\\/help-center\"}],[{\"key\":\"label\",\"value\":\"Live chat\"},{\"key\":\"url\",\"value\":\"\\/live-chat\"}],[{\"key\":\"label\",\"value\":\"How it works\"},{\"key\":\"url\",\"value\":\"\\/how-it-works\"}],[{\"key\":\"label\",\"value\":\"Security\"},{\"key\":\"url\",\"value\":\"\\/security\"}],[{\"key\":\"label\",\"value\":\"Refund Policy\"},{\"key\":\"url\",\"value\":\"\\/refund-policy\"}]]}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(6,'SiteCopyrightWidget','bottom_footer_sidebar','carento',1,'[]','2025-11-17 21:11:21','2025-11-17 21:11:21'),(7,'SocialLinksWidget','bottom_footer_sidebar','carento',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"\"}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(8,'NewsletterWidget','top_footer_sidebar','carento',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe to see secret deals prices drop the moment you sign up!\",\"button_label\":\"Subscribe\"}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(9,'ContactInformationWidget','header_top_sidebar','carento',1,'{\"id\":\"ContactInformationWidget\",\"quantity\":2,\"title_1\":\"+123 9898 500\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:123 9898 500\",\"title_2\":\"sale@carento.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:sale@carento.com\"}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(10,'BlogSearchWidget','blog_sidebar','carento',1,'{\"id\":\"BlogSearchWidget\"}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(11,'BlogPostsWidget','blog_sidebar','carento',2,'{\"id\":\"BlogPostsWidget\",\"title\":\"Latest Posts\",\"category_ids\":[1,2,3,4,5],\"limit\":5}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(12,'GalleriesWidget','blog_sidebar','carento',3,'{\"id\":\"GalleriesWidget\",\"title\":\"Instagram Posts\",\"limit\":9}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(13,'FeaturedPostsWidget','above_blog_list_sidebar','carento',1,'{\"id\":\"FeaturedPostsWidget\",\"title\":\"Inside & Trending\",\"category_ids\":[1,2,3,4,5,6],\"limit\":4}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(14,'BlogPostsWidget','off_canvas_sidebar','carento',1,'{\"id\":\"BlogPostsWidget\",\"title\":\"Latest Posts\",\"category_ids\":[1,2,3,4,5],\"limit\":5}','2025-11-17 21:11:21','2025-11-17 21:11:21'),(15,'SiteInformationWidget','off_canvas_sidebar','carento',2,'{\"id\":\"SiteInformationWidget\",\"logo\":\"icons\\/contact.png\",\"quantity\":4,\"icon_1\":\"ti ti-map-pin\",\"description_1\":\"2356 Oakwood Drive, Suite 18, San Francisco, California 94111, US\",\"icon_2\":\"ti ti-clock-hour-3\",\"description_2\":\"Hours: 8:00 - 17:00, Mon - Sat\",\"icon_3\":\"ti ti-mail\",\"description_3\":\"support@carento.com\"}','2025-11-17 21:11:21','2025-11-17 21:11:21');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-11-18 11:11:25
