<?php

namespace Database\Seeders\Themes\Main;

use Botble\Base\Enums\BaseStatusEnum;
use Botble\Base\Supports\BaseSeeder;
use Botble\Location\Models\City;
use Botble\Location\Models\Country;
use Botble\Location\Models\State;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class LocationSeeder extends BaseSeeder
{
    public function run(): void
    {
        City::query()->truncate();
        State::query()->truncate();
        Country::query()->truncate();

        $this->uploadFiles('locations');

        $now = $this->now();

        $countries = [
            [
                'id' => 1,
                'name' => 'United States',
                'nationality' => 'American',
                'order' => 1,
                'is_default' => 1,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'US',
                'created_at' => $now,
            ],
            [
                'id' => 2,
                'name' => 'United Kingdom',
                'nationality' => 'British',
                'order' => 2,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'GB',
                'created_at' => $now,
            ],
            [
                'id' => 3,
                'name' => 'Canada',
                'nationality' => 'Canadian',
                'order' => 3,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'CA',
                'created_at' => $now,
            ],
            [
                'id' => 4,
                'name' => 'Germany',
                'nationality' => 'German',
                'order' => 4,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'DE',
                'created_at' => $now,
            ],
            [
                'id' => 5,
                'name' => 'France',
                'nationality' => 'French',
                'order' => 5,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'FR',
                'created_at' => $now,
            ],
            [
                'id' => 6,
                'name' => 'Australia',
                'nationality' => 'Australian',
                'order' => 6,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'AU',
                'created_at' => $now,
            ],
            [
                'id' => 7,
                'name' => 'Japan',
                'nationality' => 'Japanese',
                'order' => 7,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'JP',
                'created_at' => $now,
            ],
            [
                'id' => 8,
                'name' => 'Italy',
                'nationality' => 'Italian',
                'order' => 8,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'code' => 'IT',
                'created_at' => $now,
            ],
        ];

        $states = [
            // United States
            [
                'id' => 1,
                'name' => 'California',
                'abbreviation' => 'CA',
                'country_id' => 1,
                'order' => 1,
                'is_default' => 1,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 2,
                'name' => 'New York',
                'abbreviation' => 'NY',
                'country_id' => 1,
                'order' => 2,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 3,
                'name' => 'Florida',
                'abbreviation' => 'FL',
                'country_id' => 1,
                'order' => 3,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 4,
                'name' => 'Texas',
                'abbreviation' => 'TX',
                'country_id' => 1,
                'order' => 4,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 5,
                'name' => 'Illinois',
                'abbreviation' => 'IL',
                'country_id' => 1,
                'order' => 5,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // United Kingdom
            [
                'id' => 6,
                'name' => 'England',
                'abbreviation' => 'ENG',
                'country_id' => 2,
                'order' => 6,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 7,
                'name' => 'Scotland',
                'abbreviation' => 'SCT',
                'country_id' => 2,
                'order' => 7,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // Canada
            [
                'id' => 8,
                'name' => 'Ontario',
                'abbreviation' => 'ON',
                'country_id' => 3,
                'order' => 8,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 9,
                'name' => 'British Columbia',
                'abbreviation' => 'BC',
                'country_id' => 3,
                'order' => 9,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // Germany
            [
                'id' => 10,
                'name' => 'Bavaria',
                'abbreviation' => 'BY',
                'country_id' => 4,
                'order' => 10,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 11,
                'name' => 'Berlin',
                'abbreviation' => 'BE',
                'country_id' => 4,
                'order' => 11,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // France
            [
                'id' => 12,
                'name' => 'Île-de-France',
                'abbreviation' => 'IDF',
                'country_id' => 5,
                'order' => 12,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 13,
                'name' => 'Provence-Alpes-Côte d\'Azur',
                'abbreviation' => 'PACA',
                'country_id' => 5,
                'order' => 13,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // Australia
            [
                'id' => 14,
                'name' => 'New South Wales',
                'abbreviation' => 'NSW',
                'country_id' => 6,
                'order' => 14,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 15,
                'name' => 'Victoria',
                'abbreviation' => 'VIC',
                'country_id' => 6,
                'order' => 15,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // Japan
            [
                'id' => 16,
                'name' => 'Tokyo',
                'abbreviation' => 'TK',
                'country_id' => 7,
                'order' => 16,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 17,
                'name' => 'Osaka',
                'abbreviation' => 'OS',
                'country_id' => 7,
                'order' => 17,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            // Italy
            [
                'id' => 18,
                'name' => 'Lazio',
                'abbreviation' => 'LAZ',
                'country_id' => 8,
                'order' => 18,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'id' => 19,
                'name' => 'Lombardy',
                'abbreviation' => 'LOM',
                'country_id' => 8,
                'order' => 19,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ];

        $cities = [
            // California, USA
            [
                'id' => 1,
                'name' => 'Los Angeles',
                'state_id' => 1,
                'country_id' => 1,
                'record_id' => null,
                'order' => 1,
                'is_default' => 1,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'The entertainment capital of the world, home to Hollywood and beautiful beaches.',
                'latitude' => 34.0522,
                'longitude' => -118.2437,
            ],
            [
                'id' => 2,
                'name' => 'San Francisco',
                'state_id' => 1,
                'country_id' => 1,
                'record_id' => null,
                'order' => 2,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Known for the Golden Gate Bridge, cable cars, and vibrant tech scene.',
                'latitude' => 37.7749,
                'longitude' => -122.4194,
            ],
            [
                'id' => 3,
                'name' => 'San Diego',
                'state_id' => 1,
                'country_id' => 1,
                'record_id' => null,
                'order' => 3,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Perfect weather year-round, stunning beaches, and a relaxed coastal vibe.',
                'latitude' => 32.7157,
                'longitude' => -117.1611,
            ],
            // New York, USA
            [
                'id' => 4,
                'name' => 'New York City',
                'state_id' => 2,
                'country_id' => 1,
                'record_id' => null,
                'order' => 4,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'The city that never sleeps, featuring iconic landmarks like Times Square and Central Park.',
                'latitude' => 40.7128,
                'longitude' => -74.0060,
            ],
            [
                'id' => 5,
                'name' => 'Buffalo',
                'state_id' => 2,
                'country_id' => 1,
                'record_id' => null,
                'order' => 5,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Gateway to Niagara Falls and known for its rich architectural heritage.',
                'latitude' => 42.8864,
                'longitude' => -78.8784,
            ],
            // Florida, USA
            [
                'id' => 6,
                'name' => 'Miami',
                'state_id' => 3,
                'country_id' => 1,
                'record_id' => null,
                'order' => 6,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Vibrant beaches, Art Deco architecture, and a thriving Latin culture.',
                'latitude' => 25.7617,
                'longitude' => -80.1918,
            ],
            [
                'id' => 7,
                'name' => 'Orlando',
                'state_id' => 3,
                'country_id' => 1,
                'record_id' => null,
                'order' => 7,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Theme park capital of the world, home to Disney World and Universal Studios.',
                'latitude' => 28.5383,
                'longitude' => -81.3792,
            ],
            // Texas, USA
            [
                'id' => 8,
                'name' => 'Houston',
                'state_id' => 4,
                'country_id' => 1,
                'record_id' => null,
                'order' => 8,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Space City USA, home to NASA and a diverse culinary scene.',
                'latitude' => 29.7604,
                'longitude' => -95.3698,
            ],
            [
                'id' => 9,
                'name' => 'Austin',
                'state_id' => 4,
                'country_id' => 1,
                'record_id' => null,
                'order' => 9,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Live music capital of the world and a booming tech hub.',
                'latitude' => 30.2672,
                'longitude' => -97.7431,
            ],
            // Illinois, USA
            [
                'id' => 10,
                'name' => 'Chicago',
                'state_id' => 5,
                'country_id' => 1,
                'record_id' => null,
                'order' => 10,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'The Windy City, famous for deep-dish pizza and stunning architecture.',
                'latitude' => 41.8781,
                'longitude' => -87.6298,
            ],
            // England, UK
            [
                'id' => 11,
                'name' => 'London',
                'state_id' => 6,
                'country_id' => 2,
                'record_id' => null,
                'order' => 11,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Historic capital featuring Big Ben, Buckingham Palace, and world-class museums.',
                'latitude' => 51.5074,
                'longitude' => -0.1278,
            ],
            [
                'id' => 12,
                'name' => 'Manchester',
                'state_id' => 6,
                'country_id' => 2,
                'record_id' => null,
                'order' => 12,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Industrial heritage meets modern culture in this vibrant northern city.',
                'latitude' => 53.4808,
                'longitude' => -2.2426,
            ],
            // Scotland, UK
            [
                'id' => 13,
                'name' => 'Edinburgh',
                'state_id' => 7,
                'country_id' => 2,
                'record_id' => null,
                'order' => 13,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Scotland\'s capital, famous for its castle and annual festivals.',
                'latitude' => 55.9533,
                'longitude' => -3.1883,
            ],
            // Ontario, Canada
            [
                'id' => 14,
                'name' => 'Toronto',
                'state_id' => 8,
                'country_id' => 3,
                'record_id' => null,
                'order' => 14,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Canada\'s largest city, featuring the CN Tower and diverse neighborhoods.',
                'latitude' => 43.6532,
                'longitude' => -79.3832,
            ],
            [
                'id' => 15,
                'name' => 'Ottawa',
                'state_id' => 8,
                'country_id' => 3,
                'record_id' => null,
                'order' => 15,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Canada\'s capital city, home to Parliament Hill and national museums.',
                'latitude' => 45.4215,
                'longitude' => -75.6972,
            ],
            // British Columbia, Canada
            [
                'id' => 16,
                'name' => 'Vancouver',
                'state_id' => 9,
                'country_id' => 3,
                'record_id' => null,
                'order' => 16,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Scenic coastal city surrounded by mountains and ocean.',
                'latitude' => 49.2827,
                'longitude' => -123.1207,
            ],
            // Bavaria, Germany
            [
                'id' => 17,
                'name' => 'Munich',
                'state_id' => 10,
                'country_id' => 4,
                'record_id' => null,
                'order' => 17,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Bavarian capital famous for Oktoberfest and historic beer gardens.',
                'latitude' => 48.1351,
                'longitude' => 11.5820,
            ],
            // Berlin, Germany
            [
                'id' => 18,
                'name' => 'Berlin',
                'state_id' => 11,
                'country_id' => 4,
                'record_id' => null,
                'order' => 18,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Dynamic capital blending history with cutting-edge culture and nightlife.',
                'latitude' => 52.5200,
                'longitude' => 13.4050,
            ],
            // Île-de-France, France
            [
                'id' => 19,
                'name' => 'Paris',
                'state_id' => 12,
                'country_id' => 5,
                'record_id' => null,
                'order' => 19,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'City of Light, home to the Eiffel Tower, Louvre, and world-renowned cuisine.',
                'latitude' => 48.8566,
                'longitude' => 2.3522,
            ],
            // Provence-Alpes-Côte d'Azur, France
            [
                'id' => 20,
                'name' => 'Nice',
                'state_id' => 13,
                'country_id' => 5,
                'record_id' => null,
                'order' => 20,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Glamorous French Riviera city with stunning Mediterranean beaches.',
                'latitude' => 43.7102,
                'longitude' => 7.2620,
            ],
            // New South Wales, Australia
            [
                'id' => 21,
                'name' => 'Sydney',
                'state_id' => 14,
                'country_id' => 6,
                'record_id' => null,
                'order' => 21,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Harbor city featuring the Opera House and beautiful beaches.',
                'latitude' => -33.8688,
                'longitude' => 151.2093,
            ],
            // Victoria, Australia
            [
                'id' => 22,
                'name' => 'Melbourne',
                'state_id' => 15,
                'country_id' => 6,
                'record_id' => null,
                'order' => 22,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Cultural capital known for coffee, arts, and sports events.',
                'latitude' => -37.8136,
                'longitude' => 144.9631,
            ],
            // Tokyo, Japan
            [
                'id' => 23,
                'name' => 'Tokyo',
                'state_id' => 16,
                'country_id' => 7,
                'record_id' => null,
                'order' => 23,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Ultra-modern metropolis blending tradition with cutting-edge technology.',
                'latitude' => 35.6762,
                'longitude' => 139.6503,
            ],
            // Osaka, Japan
            [
                'id' => 24,
                'name' => 'Osaka',
                'state_id' => 17,
                'country_id' => 7,
                'record_id' => null,
                'order' => 24,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Known for street food, historic castle, and vibrant nightlife.',
                'latitude' => 34.6937,
                'longitude' => 135.5023,
            ],
            // Lazio, Italy
            [
                'id' => 25,
                'name' => 'Rome',
                'state_id' => 18,
                'country_id' => 8,
                'record_id' => null,
                'order' => 25,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'The Eternal City, filled with ancient ruins and Renaissance art.',
                'latitude' => 41.9028,
                'longitude' => 12.4964,
            ],
            // Lombardy, Italy
            [
                'id' => 26,
                'name' => 'Milan',
                'state_id' => 19,
                'country_id' => 8,
                'record_id' => null,
                'order' => 26,
                'is_default' => 0,
                'status' => BaseStatusEnum::PUBLISHED,
                'created_at' => $now,
                'updated_at' => $now,
                'description' => 'Fashion and design capital with stunning Gothic architecture.',
                'latitude' => 45.4642,
                'longitude' => 9.1900,
            ],
        ];

        foreach ($countries as $country) {
            DB::table('countries')->insert($country);
        }

        foreach ($states as $state) {
            DB::table('states')->insert(array_merge($state, [
                'slug' => Str::slug($state['name']),
            ]));
        }

        foreach ($cities as $city) {
            // Use modulo to cycle through available images if we have more cities than images
            $imageNumber = (($city['id'] - 1) % 6) + 1;
            $city['image'] = 'locations/location' . $imageNumber . '.jpg';

            // Remove extra fields that don't exist in the database schema
            unset($city['description']);
            unset($city['latitude']);
            unset($city['longitude']);

            City::query()->create(array_merge($city, [
                'slug' => Str::slug($city['name']),
            ]));
        }
    }
}
