<?php

return [
    'title' => 'Impostazioni',
    'general_setting' => 'Impostazioni Generali',
    'menu' => 'Tutte le Impostazioni',
    'email_setting_title' => 'Impostazioni email',
    'email_setting_description' => 'Configura le impostazioni email',
    'general' => [
        'theme' => 'Tema',
        'title' => 'Informazioni Generali',
        'description' => 'Visualizza e aggiorna le informazioni del sito',
        'rich_editor' => 'Editor Avanzato',
        'site_title' => 'Titolo del sito',
        'admin_email' => 'Email Amministratore',
        'seo_block' => 'Configurazione SEO',
        'seo_title' => 'Titolo SEO',
        'seo_description' => 'Descrizione SEO',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Titolo del Sito (massimo 120 caratteri)',
            'admin_email' => 'Email Amministratore',
            'seo_title' => 'Titolo SEO (massimo 120 caratteri)',
            'seo_description' => 'Descrizione SEO (massimo 120 caratteri)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Invia segnalazioni di errore via email',
        'enable_send_error_reporting_via_email_helper' => 'Quando abilitato, i rapporti dettagliati sugli errori verranno inviati agli indirizzi email dell\'amministratore quando si verificano errori critici sul sito',
        'time_zone' => 'Fuso orario',
        'time_zone_helper' => 'Seleziona il fuso orario per il tuo sito web. Questo verrà utilizzato per tutte le visualizzazioni di data e ora in tutto il sistema',
        'enable' => 'Abilita',
        'disable' => 'Disabilita',
        'disabled_helper' => 'Impossibile disabilitare questo template email!',
        'enable_cache_site_map' => 'Abilita cache della sitemap',
        'cache_time_site_map' => 'Timeout cache sitemap (in minuti)',
        'admin_logo' => 'Logo amministratore',
        'admin_favicon' => 'Favicon amministratore',
        'admin_title' => 'Titolo amministratore',
        'admin_title_placeholder' => 'Titolo da mostrare nella scheda del browser',
        'admin_appearance_title' => 'Aspetto amministratore',
        'admin_appearance_description' => 'Impostazione aspetto amministratore come editor, lingua...',
        'seo_block_description' => 'Imposta titolo del sito, meta descrizione, parole chiave per ottimizzare la SEO',
        'webmaster_tools_description' => 'Google Search Console è uno strumento web gratuito fornito da Google che aiuta i proprietari di siti web a monitorare le prestazioni del loro sito nei risultati di ricerca di Google.',
        'yes' => 'Sì',
        'no' => 'No',
        'show_on_front' => 'La tua homepage mostra',
        'select' => '— Seleziona —',
        'show_site_name' => 'Mostra il nome del sito dopo il titolo della pagina, separato con "-"',
        'locale' => 'Lingua del sito',
        'locale_direction' => 'Direzione lingua sito frontend',
        'minutes' => 'minuti',
        'redirect_404_to_homepage' => 'Reindirizza tutte le richieste Non Trovate alla homepage',
    ],
    'admin_appearance' => [
        'title' => 'Aspetto amministratore',
        'description' => 'Visualizza e aggiorna logo, favicon, layout,...',
        'layout' => 'Layout',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'Orizzontale',
        'vertical' => 'Verticale',
        'show_menu_item_icon' => 'Mostra icona voce di menu',
        'language' => 'Lingua pannello amministratore',
        'theme_mode' => 'Modalità tema',
        'dark' => 'Scuro',
        'light' => 'Chiaro',
        'container_width' => [
            'title' => 'Larghezza contenitore',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'Predefinito',
            'large' => 'Grande',
            'full' => 'Completo',
        ],
        'form' => [
            'admin_logo' => 'Logo amministratore',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'Altezza logo (px)',
            'admin_logo_max_height_helper' => 'Imposta l\'altezza del logo in pixel. Il valore predefinito è :default.',
            'admin_favicon' => 'Favicon amministratore',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'Tipo favicon amministratore',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'Titolo amministratore',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'Titolo da mostrare nella scheda del browser',
            'admin_login_screen_backgrounds' => 'Sfondi schermata di login (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'Lingua amministratore',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'Direzione lingua amministratore',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'Editor Avanzato',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'Font primario',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'Colore primario',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'Colore secondario',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'Colore intestazione',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'Colore testo',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'Colore link',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'Colore link al passaggio del mouse',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => 'Mostra icona voce di menu',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'CSS Personalizzato',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'JS Personalizzato',
            'custom_header_js' => 'JS Header',
            'custom_header_js_placeholder' => 'JavaScript nell\'intestazione della pagina, racchiudilo dentro &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'JS Body',
            'custom_body_js_placeholder' => 'JavaScript nel corpo della pagina, racchiudilo dentro &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'JS Footer',
            'custom_footer_js_placeholder' => 'JavaScript nel footer della pagina, racchiudilo dentro &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Tabelle dati',
        'description' => 'Impostazioni per le tabelle dati',
        'form' => [
            'show_column_visibility' => 'Mostra visibilità colonne per impostazione predefinita',
            'show_column_visibility_helper' => 'Abilita il pulsante di attivazione della visibilità delle colonne nelle tabelle dati per consentire agli utenti di mostrare/nascondere colonne',
            'show_export_button' => 'Mostra pulsante esporta per impostazione predefinita',
            'show_export_button_helper' => 'Visualizza opzioni di esportazione (CSV, Excel, PDF) nelle tabelle dati per scaricare i dati della tabella',
            'pagination_type' => 'Tipo di paginazione',
            'pagination_type_helper' => 'Scegli come vengono visualizzati i controlli di paginazione: Predefinito mostra i numeri di pagina, Dropdown mostra un selettore a discesa compatto',
            'default' => 'Predefinito',
            'dropdown' => 'Dropdown',
            'enable_responsive' => 'Abilita tabella responsive',
            'enable_responsive_helper' => 'Regola automaticamente le colonne della tabella per adattarsi a diverse dimensioni dello schermo per una migliore esperienza mobile',
        ],
    ],
    'email' => [
        'subject' => 'Oggetto',
        'content' => 'Contenuto',
        'title' => 'Impostazione per template email',
        'description' => 'Template email utilizzando HTML e variabili di sistema.',
        'reset_to_default' => 'Ripristina predefinito',
        'back' => 'Torna alle impostazioni',
        'reset_success' => 'Ripristinato con successo al predefinito',
        'confirm_reset' => 'Confermi il ripristino del template email?',
        'confirm_message' => 'Vuoi davvero ripristinare questo template email al predefinito?',
        'continue' => 'Continua',
        'sender_name' => 'Nome mittente',
        'sender_name_placeholder' => 'Nome',
        'sender_name_helper' => 'Il nome che apparirà nel campo Da delle email inviate dal sistema',
        'sender_email' => 'Email mittente',
        'sender_email_placeholder' => 'Indirizzo email (es. :default)',
        'sender_email_helper' => 'L\'indirizzo email che verrà utilizzato come mittente per tutte le email inviate dal sistema',
        'mailer' => 'Mailer',
        'port' => 'Porta',
        'port_placeholder' => 'Es: 587',
        'port_helper' => 'La porta utilizzata dal tuo server di posta (porte comuni: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Es: smtp.gmail.com',
        'host_helper' => 'Indirizzo host SMTP',
        'username' => 'Nome utente',
        'username_placeholder' => 'Nome utente per accedere al server di posta',
        'username_helper' => 'Il tuo nome utente di accesso al server di posta',
        'password' => 'Password',
        'password_placeholder' => 'Password per accedere al server di posta',
        'password_helper' => 'La tua password di accesso al server di posta',
        'encryption' => 'Crittografia',
        'encryption_placeholder' => 'Seleziona tipo di crittografia',
        'encryption_helper' => 'Scegli il metodo di crittografia per la trasmissione sicura delle email',
        'encryption_none' => 'Nessuna',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Suggerimenti Configurazione Email',
        'setup_tip_gmail' => 'Per Gmail: Usa smtp.gmail.com come host, porta 587 con TLS o porta 465 con SSL. Abilita "Accesso app meno sicure" o usa una Password App.',
        'setup_tip_port' => 'Porte comuni: 25 (non crittografata), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternativa).',
        'setup_tip_encryption' => 'Usa TLS per porta 587 (consigliato), SSL per porta 465, o Nessuna per porta 25 (non consigliato per produzione).',
        'setup_tip_test' => 'Usa sempre il pulsante "Invia Email di Test" per verificare la tua configurazione prima di salvare.',
        'setup_tip_mailgun' => 'Per una migliore consegna, considera l\'utilizzo di servizi email come Mailgun, SendGrid o Amazon SES invece di SMTP.',
        'queue_warning_title' => 'Richiesta Configurazione Coda',
        'queue_warning_description' => 'La tua coda email è attualmente configurata per utilizzare il driver ":default", ma il tuo worker di coda potrebbe non essere in esecuzione. Ciò significa che le email non verranno inviate finché non configuri un worker di coda.',
        'queue_warning_action' => 'Per inviare email immediatamente senza un worker di coda, imposta QUEUE_CONNECTION=sync nel tuo file .env. Altrimenti, assicurati che il tuo worker di coda sia in esecuzione con "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Maggiori informazioni sulle Code Laravel</a>.',
        'mail_gun_domain' => 'Dominio',
        'mail_gun_domain_placeholder' => 'Es: mg.tuodominio.com',
        'mail_gun_domain_helper' => 'Il nome di dominio che hai registrato con Mailgun',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => 'Es: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'La tua chiave API Mailgun',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Es: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Endpoint API Mailgun (api.mailgun.net per USA, api.eu.mailgun.net per EU)',
        'log_channel' => 'Canale log',
        'log_channel_helper' => 'Seleziona quale canale di registrazione utilizzare per i log email',
        'sendmail_path' => 'Percorso Sendmail',
        'local_domain' => 'Dominio locale',
        'local_domain_placeholder' => 'Può essere vuoto. Deve essere impostato sul tuo dominio quando usi SMTP Relay. Es. tuo-dominio.com',
        'local_domain_helper' => 'Il dominio che verrà utilizzato per identificare il server durante la comunicazione con server SMTP remoti',
        'ses_key' => 'Chiave',
        'ses_key_placeholder' => 'Es: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Il tuo ID chiave di accesso AWS',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => 'Es: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'La tua chiave di accesso segreta AWS',
        'ses_region' => 'Regione',
        'ses_region_placeholder' => 'Es: us-east-1',
        'ses_region_helper' => 'La regione AWS dove è configurato il tuo servizio SES',
        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Es: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Il tuo token server Postmark',
        'resend_key' => 'Chiave API',
        'resend_key_placeholder' => 'Es: re_123456789012345678901234567890',
        'resend_key_helper' => 'La tua chiave API Resend',
        'email_templates' => 'Template email',
        'email_templates_description' => 'Template email utilizzando HTML e variabili di sistema.',
        'email_template_settings' => 'Impostazioni Template Email',
        'email_template_settings_description' => 'Visualizza e aggiorna le impostazioni dei tuoi template email',
        'email_rules' => 'Regole email',
        'email_rules_description' => 'Configura le regole email per la validazione',
        'base_template' => 'Template base',
        'base_template_description' => 'Template base per tutte le email',
        'template_header' => 'Intestazione template email',
        'template_header_description' => 'Template per l\'intestazione delle email',
        'template_footer' => 'Footer template email',
        'template_footer_description' => 'Template per il footer delle email',
        'default' => 'Predefinito',
        'template_off_status_helper' => 'Questo template email è disattivato.',
        'blacklist_email_domains' => 'Domini Email Bloccati',
        'blacklist_email_domains_helper' => 'Inserisci un elenco di domini email da bloccare. Es. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Indirizzi Email Bloccati',
        'blacklist_specified_emails_helper' => 'Inserisci un elenco di indirizzi email specifici da bloccare. Es. mail@example.com.',
        'exception_emails' => 'Email Eccezione',
        'exception_emails_helper' => 'Queste email verranno escluse dalle regole di validazione.',
        'email_rules_strict' => 'Validazione Email Rigorosa',
        'email_rules_strict_helper' => 'Esegui validazione email simile a RFC con regole rigide.',
        'email_rules_dns' => 'Validazione Controllo DNS',
        'email_rules_dns_helper' => 'Controlla se ci sono record DNS che indicano che il server accetta email.',
        'email_rules_spoof' => 'Rilevamento Spoofing',
        'email_rules_spoof_helper' => 'Rileva potenziali tentativi di spoofing email.',
        'template_turn_off' => 'Clicca per disattivare questo template email',
        'template_turn_on' => 'Clicca per attivare questo template email',
        'turn_on_success_message' => 'Template email attivato con successo!',
        'turn_off_success_message' => 'Template email disattivato con successo!',
        'email_template_status' => 'Stato template email',
        'email_template_status_description' => 'Attiva/disattiva template email',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Se non impostato, verrà preso dal logo amministratore in Admin -> Impostazioni -> Aspetto Admin -> Logo.',
        'email_template_copyright_text_helper_text' => 'Se non impostato, verrà preso dal copyright opzioni tema in Admin -> Aspetto -> Opzioni Tema -> Generale -> Copyright.',
        'email_template_email_contact' => 'Indirizzo email di contatto',
        'email_template_email_contact_helper_text' => 'Se non impostato, verrà preso dall\'email mittente in Admin -> Impostazioni -> Email',
        'email_template_social_links' => 'Link Social',
        'email_template_copyright_text' => 'Copyright',
        'image_upload_supported' => 'Supporta solo formati PNG, JPG, JPEG e GIF.',
        'email_template_custom_css' => 'CSS personalizzato template email',
        'social_links' => [
            'name' => 'Nome',
            'icon' => 'Icona',
            'icon_image' => 'Immagine Icona (Supporta solo formati PNG, JPG, JPEG e GIF.)',
            'url' => 'URL',
            'image' => 'Immagine',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Licenza',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Media',
        'driver' => 'Driver',
        'description' => 'Impostazioni per i media',
        'local_disk' => 'Disco locale',
        'aws_access_key_id' => 'ID Chiave di Accesso AWS',
        'aws_secret_key' => 'Chiave Segreta AWS',
        'aws_default_region' => 'Regione Predefinita AWS',
        'aws_bucket' => 'Bucket AWS',
        'aws_url' => 'URL AWS',
        'aws_endpoint' => 'Endpoint AWS (Opzionale)',
        'use_path_style_endpoint' => 'Usa endpoint stile percorso',
        'r2_access_key_id' => 'ID Chiave di Accesso R2',
        'r2_secret_key' => 'Chiave Segreta R2',
        'r2_bucket' => 'Bucket R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Endpoint R2',
        'do_spaces_access_key_id' => 'ID Chiave di Accesso DO Spaces',
        'do_spaces_secret_key' => 'Chiave Segreta DO Spaces',
        'do_spaces_default_region' => 'Regione Predefinita DO Spaces',
        'do_spaces_bucket' => 'Bucket DO Spaces',
        'do_spaces_endpoint' => 'Endpoint DO Spaces',
        'do_spaces_cdn_enabled' => 'È abilitato DO Spaces CDN?',
        'do_spaces_cdn_enabled_helper' => 'Se abilitati, i file multimediali verranno serviti tramite la CDN DigitalOcean Spaces per una distribuzione globale più rapida dei contenuti. Facoltativamente, puoi configurare un dominio CDN personalizzato di seguito.',
        'media_do_spaces_cdn_custom_domain' => 'Dominio personalizzato CDN Do Spaces',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://tuo-dominio-personalizzato.com',
        'wasabi_access_key_id' => 'ID Chiave di Accesso Wasabi',
        'wasabi_secret_key' => 'Chiave Segreta Wasabi',
        'wasabi_default_region' => 'Regione Predefinita Wasabi',
        'wasabi_bucket' => 'Bucket Wasabi',
        'wasabi_root' => 'Root Wasabi',
        'wasabi_root_helper' => 'Per riutilizzare le immagini esistenti, basta designare la root Wasabi come "/", quindi caricare tutti i file correnti da public/storage alla tua directory root Wasabi.',
        'backblaze_access_key_id' => 'ID Chiave di Accesso Backblaze',
        'backblaze_secret_key' => 'Chiave Segreta Backblaze',
        'backblaze_bucket' => 'Bucket Backblaze',
        'backblaze_default_region' => 'Regione Predefinita Backblaze',
        'backblaze_url' => 'URL Backblaze',
        'backblaze_endpoint' => 'Endpoint Backblaze',
        'backblaze_cdn_enabled' => 'È abilitato Backblaze CDN?',
        'backblaze_cdn_enabled_helper' => 'Se abilitati, i file multimediali verranno serviti tramite una CDN per una distribuzione dei contenuti globale più rapida. È necessario configurare un dominio CDN personalizzato di seguito (ad esempio, Cloudflare CDN o Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Dominio personalizzato CDN Backblaze',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://tuo-dominio-personalizzato.com',
        'default_placeholder_image' => 'Immagine placeholder predefinita',
        'enable_chunk' => 'Abilita caricamento a blocchi',
        'chunk_size' => 'Dimensione blocco (Bytes)',
        'chunk_size_placeholder' => 'Predefinito: 1048576 ~ 1MB',
        'max_file_size' => 'Dimensione massima file blocco (MB)',
        'max_file_size_placeholder' => 'Predefinito: 1048576 ~ 1GB',
        'enable_watermark' => 'Abilita filigrana',
        'enable_watermark_helper' => 'Se abilitato, una filigrana verrà automaticamente aggiunta alle immagini appena caricate nelle cartelle selezionate. Ciò non influisce sulle immagini esistenti.',
        'watermark_source' => 'Immagine filigrana',
        'watermark_source_helper' => 'Supporta solo formati PNG, JPG e JPEG. Dovresti usare un\'immagine inferiore a 200x200px e dimensione inferiore a 50KB.',
        'watermark_size' => 'Dimensione della filigrana (%)',
        'watermark_size_placeholder' => 'Predefinito: 10 (%)',
        'watermark_opacity' => 'Opacità Filigrana (%)',
        'watermark_opacity_placeholder' => 'Predefinito: 70 (%)',
        'watermark_position' => 'Posizione filigrana',
        'watermark_position_x' => 'Posizione X filigrana',
        'watermark_position_y' => 'Posizione Y filigrana',
        'watermark_position_top_left' => 'Alto sinistra',
        'watermark_position_top_right' => 'Alto destra',
        'watermark_position_bottom_left' => 'Basso sinistra',
        'watermark_position_bottom_right' => 'Basso destra',
        'watermark_position_center' => 'Centro',
        'turn_off_automatic_url_translation_into_latin' => 'Disattiva traduzione automatica URL in latino',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Se abilitati, gli URL dei file non verranno traslitterati automaticamente in caratteri latini, preservando i caratteri originali degli alfabeti non latini.',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Nome Zona (Il nome della tua zona di archiviazione)',
        'bunnycdn_key' => 'Password Accesso FTP & API (La password di accesso API della zona di archiviazione)',
        'bunnycdn_region' => 'Regione (La regione della zona di archiviazione)',
        'optional' => 'Opzionale',
        'sizes' => 'Dimensioni miniature media',
        'media_sizes_helper' => 'Imposta larghezza o altezza a 0 se vuoi ritagliare solo per larghezza o altezza.',
        'width' => 'Larghezza',
        'height' => 'Altezza',
        'default_size_value' => 'Predefinito: :size',
        'all' => 'Tutti',
        'all_helper_text' => 'Se deselezioni tutte le cartelle, verrà applicato a tutte le cartelle.',
        'media_folders_can_add_watermark' => 'Aggiungi filigrana per le immagini nelle cartelle:',
        'max_upload_filesize' => 'Dimensione massima caricamento file (MB)',
        'max_upload_filesize_placeholder' => 'Predefinito: :size, deve essere inferiore a :size.',
        'max_upload_filesize_helper' => 'Il tuo server consente di caricare file massimo :size, puoi modificare questo valore per limitare la dimensione del file caricato.',
        'image_processing_library' => 'Libreria elaborazione immagini',
        'use_original_name_for_file_path' => 'Usa nome originale per il percorso file',
        'use_original_name_for_file_path_helper' => 'Se abilitato, i file caricati manterranno i loro nomi originali. Se disabilitato, i nomi dei file verranno convertiti in slug URL-friendly (ad esempio, "La mia foto.jpg" diventa "la mia-foto.jpg").',
        'keep_original_file_size_and_quality' => 'Mantieni dimensione e qualità file originale',
        'keep_original_file_size_and_quality_helper' => 'Se abilitate, le immagini caricate non verranno ridimensionate o ottimizzate, preservando la qualità e la dimensione del file originali. Se disabilitato, le immagini potrebbero essere compresse e ridimensionate in base alle impostazioni.',
        'update_thumbnail_sizes_warning' => 'Dopo aver regolato le dimensioni delle miniature, devi cliccare sul pulsante ":button_text" per aggiornarle.',
        'thumbnail_crop_position' => 'Posizione ritaglio miniatura',
        'thumbnail_crop_position_left' => 'Sinistra',
        'thumbnail_crop_position_center' => 'Centro',
        'thumbnail_crop_position_right' => 'Destra',
        'thumbnail_crop_position_top' => 'Alto',
        'thumbnail_crop_position_bottom' => 'Basso',
        'thumbnail_crop_position_helper' => 'Questa impostazione viene utilizzata per ritagliare l\'immagine durante la generazione delle miniature. Verrà ritagliata da questa posizione fino a quando l\'immagine è riempita.',
        'user_can_only_view_own_media' => 'Gli utenti possono visualizzare solo i propri media',
        'user_can_only_view_own_media_helper' => 'Quando abilitato, gli utenti possono visualizzare solo i propri media, mentre i super amministratori possono visualizzare tutti i media.',
        'enable_thumbnail_sizes' => 'Abilita dimensioni miniature',
        'enable_thumbnail_sizes_helper' => 'Abilita questa opzione per generare miniature per le immagini. Se è disabilitata, il sistema non genererà miniature per le immagini e utilizzerà sempre l\'immagine a dimensione intera.',
        'convert_image_to_webp' => 'Converti immagine JPG, JPEG, PNG in WebP',
        'convert_image_to_webp_helper' => 'WebP è un formato di immagine moderno che fornisce compressione lossless e lossy superiore per le immagini sul web. È supportato in Chrome, Firefox, Edge e Opera. L\'immagine verrà convertita in formato WebP durante il caricamento. È applicato solo per immagini JPG, JPEG, PNG.',
        'reduce_large_image_size' => 'Riduci dimensione immagini grandi durante il caricamento',
        'reduce_large_image_size_helper' => 'Quando abilitato, il sistema ridurrà la dimensione delle immagini grandi durante il caricamento, applicato per immagini JPG, JPEG, PNG, WebP. La larghezza e l\'altezza massime dell\'immagine verranno ridimensionate ai valori impostati di seguito.',
        'image_max_width' => 'Larghezza massima immagine (px)',
        'image_max_height' => 'Altezza massima immagine (px)',
        'image_max_width_placeholder' => 'Lascia vuoto per mantenere la larghezza originale',
        'image_max_height_placeholder' => 'Lascia vuoto per mantenere l\'altezza originale',
        'image_max_width_helper' => 'Imposta la larghezza massima dell\'immagine in pixel. La larghezza originale verrà mantenuta se questo campo è vuoto.',
        'image_max_height_helper' => 'Imposta l\'altezza massima dell\'immagine in pixel. L\'altezza originale verrà mantenuta se questo campo è vuoto.',
        'customize_upload_path' => 'Personalizza percorso caricamento',
        'customize_upload_path_helper' => 'Personalizza il percorso di caricamento per i file multimediali. Per impostazione predefinita, il sistema caricherà i file nella cartella ":path".',
        'upload_path' => 'Percorso caricamento',
        'upload_path_placeholder' => 'Esempio: uploads',
        'upload_path_helper' => 'Quella cartella verrà creata in /public. La cartella predefinita è ":folder". Quindi verrà caricata in "/public/:folder".',
        'upload_path_warning' => 'Il sistema non sposterà i file esistenti nella nuova cartella. Se vuoi spostare i file esistenti nella nuova cartella, devi farlo manualmente.',
        'convert_file_name_to_uuid' => 'Converti nome file in UUID',
        'convert_file_name_to_uuid_helper' => 'Quando abilitato, il sistema convertirà il nome del file in UUID durante il caricamento. È utile per prevenire nomi di file duplicati e migliorare la sicurezza.',
        's3_path' => 'Percorso S3 Personalizzato (Opzionale)',
        's3_path_placeholder' => 'Percorso personalizzato opzionale nel bucket S3 (es., uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Salva impostazioni',
    'template' => 'Template',
    'description' => 'Descrizione',
    'enable' => 'Abilita',
    'send' => 'Invia',
    'test_email_description' => 'Per inviare un\'email di test, assicurati di aver aggiornato le configurazioni per l\'invio di email!',
    'test_email_input_placeholder' => 'Inserisci l\'indirizzo email a cui desideri inviare l\'email di test.',
    'test_email_modal_title' => 'Invia un\'email di test',
    'test_send_mail' => 'Invia email di test',
    'test_email_send_success' => 'Email inviata con successo!',
    'locale_direction_ltr' => 'Da Sinistra a Destra',
    'locale_direction_rtl' => 'Da Destra a Sinistra',
    'emails_warning' => 'Puoi aggiungere massimo :count email',
    'email_add_more' => 'Aggiungi altro',
    'generate' => 'Genera',
    'generate_thumbnails' => 'Genera miniature',
    'generate_thumbnails_success' => 'Miniature generate con successo. :count file sono stati generati!',
    'generate_thumbnails_error' => 'Non è stato possibile rigenerare le miniature per :count file!',
    'generate_thumbnails_description' => 'Sei sicuro di voler rigenerare le miniature per tutte le immagini? Questo potrebbe richiedere del tempo. Si prega di non allontanarsi da questa pagina fino al completamento del processo.',
    'enable_chunk_description' => 'Il caricamento a blocchi viene utilizzato per caricare file di grandi dimensioni.',
    'watermark_description' => 'ATTENZIONE: La filigrana viene aggiunta solo alle nuove immagini caricate, non verrà aggiunta alle immagini esistenti. La disabilitazione della filigrana non rimuoverà la filigrana dalle immagini esistenti.',
    'submit' => 'Invia',
    'back' => 'Indietro',
    'enter_sample_value' => 'Inserisci valori di esempio per il test',
    'preview' => 'Anteprima',
    'media_size_width' => 'La larghezza della dimensione :size deve essere maggiore di 0',
    'media_size_height' => 'L\'altezza della dimensione :size deve essere maggiore di 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob ti permette di automatizzare determinati comandi o script sul tuo sito.',
        'is_not_ready' => 'Per eseguire il cronjob, segui le istruzioni di seguito.',
        'is_working' => 'Congratulazioni! Il tuo cronjob è in esecuzione.',
        'is_not_working' => 'Il tuo cronjob non è in esecuzione. Controlla il cronjob del tuo server.',
        'last_checked' => 'Ultimo controllo alle :time.',
        'copy_button' => 'Copia',
        'setup' => [
            'name' => 'Configurazione del Cronjob',
            'connect_to_server' => 'Connettiti al tuo server tramite SSH o qualsiasi metodo preferito.',
            'open_crontab' => 'Apri il file crontab utilizzando un editor di testo (es., `crontab -e`).',
            'add_cronjob' => 'Aggiungi il comando sopra al file crontab e salvalo.',
            'done' => 'Il cronjob verrà ora eseguito ogni minuto ed eseguirà il comando specificato.',
            'learn_more' => 'Puoi saperne di più sul cronjob dalla :documentation di Laravel',
            'documentation' => 'documentazione',
            'copied' => 'Copiato',
        ],
    ],
    'security' => [
        'title' => 'Impostazioni di Sicurezza',
        'description' => 'Controlla e configura le impostazioni di sicurezza per il tuo sito web.',
        'menu_description' => 'Gestisci sicurezza cookie e header HTTP',
        'status_secure' => 'Tutte le impostazioni di sicurezza sono configurate correttamente!',
        'status_insecure' => 'Alcune impostazioni di sicurezza richiedono attenzione!',
        'current_settings' => 'Impostazioni di Sicurezza Attuali',
        'status' => 'Stato',
        'setting' => 'Impostazione',
        'current_value' => 'Valore Attuale',
        'recommended_value' => 'Consigliato',
        'session_http_only' => 'Flag Cookie HttpOnly',
        'session_http_only_description' => 'Impedisce a JavaScript di accedere ai cookie di sessione (protegge contro attacchi XSS)',
        'session_secure_cookie' => 'Flag Cookie Secure',
        'session_secure_cookie_description' => 'Assicura che i cookie vengano inviati solo su connessioni HTTPS',
        'session_same_site' => 'Flag Cookie SameSite',
        'session_same_site_description' => 'Previene attacchi CSRF limitando quando i cookie vengono inviati',
        'http_security_headers' => 'Header di Sicurezza HTTP',
        'http_security_headers_description' => 'Aggiunge header di sicurezza per proteggere contro vulnerabilità web comuni',
        'https_warning' => 'Il tuo sito non utilizza HTTPS',
        'https_warning_description' => 'Alcune funzionalità di sicurezza come i cookie sicuri richiedono HTTPS. Considera l\'abilitazione di SSL per il tuo sito web.',
        'how_to_fix' => 'Come Risolvere i Problemi di Sicurezza',
        'env_file_location' => 'Modifica il tuo file .env situato in:',
        'add_to_env' => 'Impostazioni da Aggiungere',
        'required_settings' => 'Impostazioni di Sicurezza Richieste',
        'for_https_sites' => 'Solo per Siti HTTPS',
        'copy' => 'Copia',
        'copy_settings' => 'Copia Tutte le Impostazioni',
        'copied' => 'Copiato!',
        'steps' => 'Passaggi per Applicare le Impostazioni',
        'step_1' => 'Apri il tuo file .env in un editor di testo',
        'step_2' => 'Aggiungi o aggiorna le impostazioni di sicurezza mostrate sopra',
        'step_3' => 'Salva il file .env',
        'step_4' => 'Svuota la cache usando Pannello Admin → Amministrazione Piattaforma → Gestione Cache',
        'security_headers_info' => 'Informazioni Header di Sicurezza',
        'security_headers_list' => 'Quando abilitati, i seguenti header vengono aggiunti a tutte le risposte:',
        'header_nosniff' => 'Impedisce ai browser di indovinare i tipi di contenuto',
        'header_frame' => 'Protegge contro attacchi clickjacking',
        'header_xss' => 'Abilita la protezione XSS del browser',
        'header_referrer' => 'Controlla quante informazioni referrer vengono inviate',
        'learn_more' => 'Per informazioni più dettagliate, consulta la :documentation',
        'documentation' => 'documentazione di sicurezza',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Configura la cache per velocità ottimizzata',
        'form' => [
            'cache_admin_menu' => 'Cache menu amministratore',
            'cache_admin_menu_helper' => 'Cache del menu amministratore per velocità ottimizzata. Questa opzione dovrebbe essere disabilitata se stai sviluppando o personalizzando il menu amministratore.',
            'enable_cache_site_map' => 'Cache sitemap',
            'enable_cache_site_map_helper' => 'La sitemap :url dovrebbe essere in cache a causa del gran numero di pagine. Se hai un numero ridotto di pagine, puoi disabilitare questa opzione.',
            'cache_time_site_map' => 'Timeout cache sitemap (in minuti)',
            'cache_front_menu' => 'Cache menu frontend',
            'cache_front_menu_helper' => 'Cache del menu frontend per velocità ottimizzata',
            'cache_user_avatar' => 'Cache avatar utente',
            'cache_user_avatar_helper' => 'Per gli utenti senza avatar, il sistema genererà avatar dai loro nomi utente. Gli avatar verranno memorizzati in cache per velocità ottimizzata e non verranno rigenerati.',
            'shortcode_cache_enabled' => 'Cache shortcode (blocchi UI)',
            'shortcode_cache_enabled_helper' => 'Abilita la cache per gli shortcode per migliorare le prestazioni. Quando abilitato, gli shortcode verranno memorizzati in cache per ridurre i tempi di rendering.',
            'shortcode_cache_warning' => '<strong>⚠️ Avviso Importante:</strong><br>• Gli shortcode contenenti moduli (moduli di contatto, iscrizioni newsletter, ecc.) ignoreranno automaticamente la cache per preservare la funzionalità.<br>• Gli shortcode con contenuto JavaScript dinamico dovrebbero avere la cache disabilitata manualmente.<br>• Per disabilitare la cache per shortcode specifici, aggiungi <code>Abilita cache: No</code> alla configurazione dello shortcode.<br>• I moduli con token CSRF, reCAPTCHA o altri elementi dinamici vengono rilevati automaticamente ed esclusi dalla cache.',
            'shortcode_cache_ttl' => 'Durata cache (secondi)',
            'shortcode_cache_ttl_helper' => 'La durata per memorizzare in cache tutti gli shortcode. Predefinito è 1800 secondi (30 minuti).',
            'widget_cache_enabled' => 'Cache widget',
            'widget_cache_enabled_helper' => 'Abilita la cache per i widget per migliorare le prestazioni. Quando abilitato, i widget verranno memorizzati in cache per ridurre i tempi di rendering.',
            'widget_cache_warning' => '<strong>⚠️ Avviso Importante:</strong><br>• I widget contenenti moduli (moduli di contatto, iscrizioni newsletter, ecc.) ignoreranno automaticamente la cache per preservare la funzionalità.<br>• I widget con contenuto JavaScript dinamico dovrebbero avere la cache disabilitata manualmente.<br>• Per disabilitare la cache per widget specifici, imposta <code>Abilita cache: No</code> nella configurazione del widget.<br>• I moduli con token CSRF, reCAPTCHA o altri elementi dinamici vengono rilevati automaticamente ed esclusi dalla cache.',
            'widget_cache_ttl' => 'Durata cache (secondi)',
            'widget_cache_ttl_helper' => 'La durata per memorizzare in cache tutti i widget. Predefinito è 1800 secondi (30 minuti).',
            'plugin_cache_enabled' => 'Cache plugin installati',
            'plugin_cache_enabled_helper' => 'Memorizza in cache l\'elenco dei plugin installati per prestazioni migliorate. Quando abilitato, il sistema memorizzerà in cache l\'elenco dei plugin per 30 minuti per ridurre le scansioni del file system.',
        ],
    ],
    'appearance' => [
        'title' => 'Aspetto',
    ],
    'panel' => [
        'common' => 'Comune',
        'general' => 'Generale',
        'general_description' => 'Visualizza e aggiorna le tue impostazioni generali e attiva la licenza',
        'email' => 'Email',
        'email_description' => 'Visualizza e aggiorna le tue impostazioni email e i template email',
        'media' => 'Media',
        'media_description' => 'Visualizza e aggiorna le tue impostazioni media',
        'system' => 'Sistema',
        'system_updater' => 'Aggiornamento Sistema',
        'system_updater_description' => 'Aggiorna il tuo sistema all\'ultima versione',
        'others' => 'Altro',
    ],
    'saving' => 'Salvataggio...',
    'generating_media_thumbnails' => 'Generazione miniature media...',
    'test_email_template' => 'Testa template email',
    'select_email_template' => 'Seleziona template email',
    'enums' => [
        'data_retention_period' => [
            'Mai',
            '1 Giorno',
            3 => '3 Giorni',
            7 => '1 Settimana',
            30 => '1 Mese',
            90 => '3 Mesi',
            180 => '6 Mesi',
            365 => '1 Anno',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'Il campo :attribute deve essere una regione AWS valida (es., us-east-1, eu-west-1).',
    ],
];
