<?php

return [
    'title' => 'Iestatījumi',
    'general_setting' => 'Vispārīgie iestatījumi',
    'menu' => 'Visi iestatījumi',
    'email_setting_title' => 'E-pasta iestatījumi',
    'email_setting_description' => 'Konfigurēt e-pasta iestatījumus',
    'general' => [
        'theme' => 'Tēma',
        'title' => 'Vispārīgā informācija',
        'description' => 'Skatīt un atjaunināt vietnes informāciju',
        'rich_editor' => 'Bagātinātais redaktors',
        'site_title' => 'Vietnes nosaukums',
        'admin_email' => 'Administratora e-pasts',
        'seo_block' => 'SEO konfigurācija',
        'seo_title' => 'SEO nosaukums',
        'seo_description' => 'SEO apraksts',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Vietnes nosaukums (maksimums 120 rakstzīmes)',
            'admin_email' => 'Administratora e-pasts',
            'seo_title' => 'SEO nosaukums (maksimums 120 rakstzīmes)',
            'seo_description' => 'SEO apraksts (maksimums 120 rakstzīmes)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Sūtīt kļūdu ziņojumus pa e-pastu',
        'enable_send_error_reporting_via_email_helper' => 'Kad iespējots, detalizēti kļūdu ziņojumi tiks nosūtīti uz administratora e-pasta adresēm, kad vietnē rodas kritiski kļūdas',
        'time_zone' => 'Laika josla',
        'time_zone_helper' => 'Atlasiet sava vietnes laika joslu. Tas tiks izmantots visām datuma un laika rādīšanām visā sistēmā',
        'enable' => 'Iespējot',
        'disable' => 'Atspējot',
        'disabled_helper' => 'Nevar atspējot šo e-pasta veidni!',
        'enable_cache_site_map' => 'Iespējot vietnes kartes kešatmiņu',
        'cache_time_site_map' => 'Vietnes kartes kešatmiņas noilgums (minūtēs)',
        'admin_logo' => 'Administratora logo',
        'admin_favicon' => 'Administratora favicon',
        'admin_title' => 'Administratora nosaukums',
        'admin_title_placeholder' => 'Nosaukums, ko rādīt pārlūkprogrammas cilnē',
        'admin_appearance_title' => 'Administratora izskats',
        'admin_appearance_description' => 'Iestatīt administratora izskatu, piemēram, redaktoru, valodu...',
        'seo_block_description' => 'Iestatīt vietnes nosaukumu, vietnes meta aprakstu, vietnes atslēgvārdu SEO optimizācijai',
        'webmaster_tools_description' => 'Google Search Console ir bezmaksas tīmekļa rīks, ko nodrošina Google un kas palīdz vietnes īpašniekiem uzraudzīt savas vietnes darbību Google meklēšanas rezultātos.',
        'yes' => 'Jā',
        'no' => 'Nē',
        'show_on_front' => 'Jūsu sākumlapā tiek rādīts',
        'select' => '— Izvēlieties —',
        'show_site_name' => 'Rādīt vietnes nosaukumu pēc lapas nosaukuma, atdalītu ar "-"',
        'locale' => 'Vietnes valoda',
        'locale_direction' => 'Vietnes valodas virziens',
        'minutes' => 'minūtes',
        'redirect_404_to_homepage' => 'Pāradresēt visus Nav atrasts pieprasījumus uz sākumlapu',
    ],
    'admin_appearance' => [
        'title' => 'Administratora izskats',
        'description' => 'Skatīt un atjaunināt logo, favicon, izkārtojumu,...',
        'layout' => 'Izkārtojums',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'Horizontāls',
        'vertical' => 'Vertikāls',
        'show_menu_item_icon' => 'Rādīt izvēlnes elementa ikonu',
        'language' => 'Administratora paneļa valoda',
        'theme_mode' => 'Tēmas režīms',
        'dark' => 'Tumšs',
        'light' => 'Gaišs',
        'container_width' => [
            'title' => 'Konteinera platums',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'Noklusējuma',
            'large' => 'Liels',
            'full' => 'Pilns',
        ],
        'form' => [
            'admin_logo' => 'Administratora logo',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'Logo augstums (px)',
            'admin_logo_max_height_helper' => 'Iestatiet logo augstumu pikseļos. Noklusējuma vērtība ir :default.',
            'admin_favicon' => 'Administratora favicon',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'Administratora favicon tips',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'Administratora nosaukums',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'Nosaukums, ko rādīt pārlūkprogrammas cilnē',
            'admin_login_screen_backgrounds' => 'Pieteikšanās ekrāna foni (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'Administratora valoda',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'Administratora valodas virziens',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'Bagātinātais redaktors',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'Primārais fonts',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'Primārā krāsa',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'Sekundārā krāsa',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'Virsraksta krāsa',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'Teksta krāsa',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'Saites krāsa',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'Saites pārbraukšanas krāsa',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => 'Rādīt izvēlnes elementa ikonu',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'Pielāgots CSS',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'Pielāgots JS',
            'custom_header_js' => 'Galvenes JS',
            'custom_header_js_placeholder' => 'JavaScript lapas galvenē, ievietojiet to &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript lapas body, ievietojiet to &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Kājenes JS',
            'custom_footer_js_placeholder' => 'JavaScript lapas kājenē, ievietojiet to &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Datu tabulas',
        'description' => 'Iestatījumi datu tabulām',
        'form' => [
            'show_column_visibility' => 'Pēc noklusējuma rādīt kolonnu redzamību',
            'show_column_visibility_helper' => 'Iespējot kolonnu redzamības pārslēgšanas pogu datu tabulās, lai ļautu lietotājiem rādīt/paslēpt kolonnas',
            'show_export_button' => 'Pēc noklusējuma rādīt eksporta pogu',
            'show_export_button_helper' => 'Parādīt eksporta opcijas (CSV, Excel, PDF) datu tabulās, lai lejupielādētu tabulas datus',
            'pagination_type' => 'Lapošanas tips',
            'pagination_type_helper' => 'Izvēlieties, kā tiek rādītas lapošanas vadīklas: Noklusējuma rāda lapas numurus, Nolaižamā izvēlne rāda kompaktu nolaižamo izvēlētāju',
            'default' => 'Noklusējuma',
            'dropdown' => 'Nolaižamā izvēlne',
            'enable_responsive' => 'Iespējot tabulas responsivitāti',
            'enable_responsive_helper' => 'Automātiski pielāgot tabulas kolonnas dažādiem ekrāna izmēriem labākai mobilās ierīces pieredzei',
        ],
    ],
    'email' => [
        'subject' => 'Temats',
        'content' => 'Saturs',
        'title' => 'Iestatījums e-pasta veidnei',
        'description' => 'E-pasta veidne, izmantojot HTML un sistēmas mainīgos.',
        'reset_to_default' => 'Atiestatīt uz noklusējuma',
        'back' => 'Atpakaļ uz iestatījumiem',
        'reset_success' => 'Veiksmīgi atiestatīts uz noklusējuma',
        'confirm_reset' => 'Apstiprināt e-pasta veidnes atiestatīšanu?',
        'confirm_message' => 'Vai tiešām vēlaties atiestatīt šo e-pasta veidni uz noklusējuma?',
        'continue' => 'Turpināt',
        'sender_name' => 'Sūtītāja vārds',
        'sender_name_placeholder' => 'Vārds',
        'sender_name_helper' => 'Vārds, kas parādīsies sistēmas nosūtītajos e-pastos laukā No',
        'sender_email' => 'Sūtītāja e-pasts',
        'sender_email_placeholder' => 'E-pasta adrese (piemēram, :default)',
        'sender_email_helper' => 'E-pasta adrese, kas tiks izmantota kā sūtītājs visiem sistēmas nosūtītajiem e-pastiem',
        'mailer' => 'Pasta sūtītājs',
        'port' => 'Ports',
        'port_placeholder' => 'Piemērs: 587',
        'port_helper' => 'Ports, ko izmanto jūsu pasta serveris (izplatīti porti: 25, 465, 587)',
        'host' => 'Hosts',
        'host_placeholder' => 'Piemērs: smtp.gmail.com',
        'host_helper' => 'SMTP hosta adrese',
        'username' => 'Lietotājvārds',
        'username_placeholder' => 'Lietotājvārds pieteikšanai pasta serverī',
        'username_helper' => 'Jūsu pasta servera pieteikšanās lietotājvārds',
        'password' => 'Parole',
        'password_placeholder' => 'Parole pieteikšanai pasta serverī',
        'password_helper' => 'Jūsu pasta servera pieteikšanās parole',
        'encryption' => 'Šifrēšana',
        'encryption_placeholder' => 'Izvēlieties šifrēšanas tipu',
        'encryption_helper' => 'Izvēlieties šifrēšanas metodi drošai e-pasta pārsūtīšanai',
        'encryption_none' => 'Nav',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'E-pasta iestatīšanas padomi',
        'setup_tip_gmail' => 'Gmail: izmantojiet smtp.gmail.com kā hostu, portu 587 ar TLS vai portu 465 ar SSL. Iespējojiet "Mazāk drošu lietotņu piekļuvi" vai izmantojiet lietotnes paroli.',
        'setup_tip_port' => 'Izplatīti porti: 25 (nešifrēts), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternatīvs).',
        'setup_tip_encryption' => 'Izmantojiet TLS portam 587 (ieteicams), SSL portam 465 vai Nav portam 25 (nav ieteicams ražošanai).',
        'setup_tip_test' => 'Vienmēr izmantojiet pogu "Sūtīt testa e-pastu", lai pārbaudītu konfigurāciju pirms saglabāšanas.',
        'setup_tip_mailgun' => 'Labākai piegādātspējai apsveriet e-pasta pakalpojumu izmantošanu, piemēram, Mailgun, SendGrid vai Amazon SES, nevis SMTP.',
        'queue_warning_title' => 'Nepieciešama rindas konfigurācija',
        'queue_warning_description' => 'Jūsu e-pasta rinda pašlaik ir konfigurēta, lai izmantotu ":default" draiveri, bet jūsu rindas darbinieks, iespējams, nedarbojas. Tas nozīmē, ka e-pasti netiks nosūtīti, kamēr iestatīsiet rindas darbinieku.',
        'queue_warning_action' => 'Lai nosūtītu e-pastus nekavējoties bez rindas darbinieka, iestatiet QUEUE_CONNECTION=sync savā .env failā. Pretējā gadījumā pārliecinieties, ka jūsu rindas darbinieks darbojas ar "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Uzziniet vairāk par Laravel rindām</a>.',
        'mail_gun_domain' => 'Domēns',
        'mail_gun_domain_placeholder' => 'Piemērs: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Domēna nosaukums, ko reģistrējāt Mailgun',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => 'Piemērs: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Jūsu Mailgun API atslēga',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Piemērs: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API endpoint (api.mailgun.net ASV, api.eu.mailgun.net ES)',
        'log_channel' => 'Log kanāls',
        'log_channel_helper' => 'Izvēlieties, kuru reģistrēšanas kanālu izmantot e-pasta žurnāliem',
        'sendmail_path' => 'Sendmail ceļš',
        'local_domain' => 'Lokālais domēns',
        'local_domain_placeholder' => 'Tas var būt tukšs. Jāiestata uz jūsu domēnu, izmantojot SMTP Relay. Piemēram, jūsu-domēns.lv',
        'local_domain_helper' => 'Domēns, kas tiks izmantots, lai identificētu serveri, sazinājoties ar attāliem SMTP serveriem',
        'ses_key' => 'Atslēga',
        'ses_key_placeholder' => 'Piemērs: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Jūsu AWS piekļuves atslēgas ID',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => 'Piemērs: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Jūsu AWS slepenā piekļuves atslēga',
        'ses_region' => 'Reģions',
        'ses_region_placeholder' => 'Piemērs: us-east-1',
        'ses_region_helper' => 'AWS reģions, kurā ir konfigurēts jūsu SES pakalpojums',
        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Piemērs: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Jūsu Postmark servera token',
        'resend_key' => 'API atslēga',
        'resend_key_placeholder' => 'Piemērs: re_123456789012345678901234567890',
        'resend_key_helper' => 'Jūsu Resend API atslēga',
        'email_templates' => 'E-pasta veidnes',
        'email_templates_description' => 'E-pasta veidnes, izmantojot HTML un sistēmas mainīgos.',
        'email_template_settings' => 'E-pasta veidņu iestatījumi',
        'email_template_settings_description' => 'Skatīt un atjaunināt e-pasta veidņu iestatījumus',
        'email_rules' => 'E-pasta noteikumi',
        'email_rules_description' => 'Konfigurēt e-pasta noteikumus validācijai',
        'base_template' => 'Pamata veidne',
        'base_template_description' => 'Pamata veidne visiem e-pastiem',
        'template_header' => 'E-pasta veidnes galvene',
        'template_header_description' => 'Veidne e-pasta galvenei',
        'template_footer' => 'E-pasta veidnes kājene',
        'template_footer_description' => 'Veidne e-pasta kājenei',
        'default' => 'Noklusējuma',
        'template_off_status_helper' => 'Šī e-pasta veidne ir izslēgta.',
        'blacklist_email_domains' => 'Melnajā sarakstā esošie e-pasta domēni',
        'blacklist_email_domains_helper' => 'Ievadiet e-pasta domēnu sarakstu, kas jāiekļauj melnajā sarakstā. Piemēram, gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Melnajā sarakstā esošās e-pasta adreses',
        'blacklist_specified_emails_helper' => 'Ievadiet konkrētu e-pasta adrešu sarakstu, kas jāiekļauj melnajā sarakstā. Piemēram, pasts@piemers.lv.',
        'exception_emails' => 'Izņēmuma e-pasti',
        'exception_emails_helper' => 'Šie e-pasti tiks izslēgti no validācijas noteikumiem.',
        'email_rules_strict' => 'Stingra e-pasta validācija',
        'email_rules_strict_helper' => 'Veikt RFC līdzīgu e-pasta validāciju ar stingriem noteikumiem.',
        'email_rules_dns' => 'DNS pārbaudes validācija',
        'email_rules_dns_helper' => 'Pārbaudīt, vai ir DNS ieraksti, kas norāda, ka serveris pieņem e-pastus.',
        'email_rules_spoof' => 'Viltošanas noteikšana',
        'email_rules_spoof_helper' => 'Noteikt potenciālus e-pasta viltošanas mēģinājumus.',
        'template_turn_off' => 'Noklikšķiniet, lai izslēgtu šo e-pasta veidni',
        'template_turn_on' => 'Noklikšķiniet, lai ieslēgtu šo e-pasta veidni',
        'turn_on_success_message' => 'E-pasta veidne veiksmīgi ieslēgta!',
        'turn_off_success_message' => 'E-pasta veidne veiksmīgi izslēgta!',
        'email_template_status' => 'E-pasta veidnes statuss',
        'email_template_status_description' => 'Ieslēgt/izslēgt e-pasta veidni',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Ja nav iestatīts, tas tiks iegūts no administratora logo sadaļā Administrators -> Iestatījumi -> Administratora izskats -> Logo.',
        'email_template_copyright_text_helper_text' => 'Ja nav iestatīts, tas tiks iegūts no tēmas opciju autortiesībām sadaļā Administrators -> Izskats -> Tēmas opcijas -> Vispārīgi -> Autortiesības.',
        'email_template_email_contact' => 'Kontakta e-pasta adrese',
        'email_template_email_contact_helper_text' => 'Ja nav iestatīts, tas tiks iegūts no sūtītāja e-pasta sadaļā Administrators -> Iestatījumi -> E-pasts',
        'email_template_social_links' => 'Sociālie saites',
        'email_template_copyright_text' => 'Autortiesības',
        'image_upload_supported' => 'Atbalsta tikai PNG, JPG, JPEG un GIF formātus.',
        'email_template_custom_css' => 'E-pasta veidnes pielāgots CSS',
        'social_links' => [
            'name' => 'Nosaukums',
            'icon' => 'Ikona',
            'icon_image' => 'Ikonas attēls (Atbalsta tikai PNG, JPG, JPEG un GIF formātus.)',
            'url' => 'URL',
            'image' => 'Attēls',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Licence',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Mediji',
        'driver' => 'Draiveris',
        'description' => 'Iestatījumi medijiem',
        'local_disk' => 'Lokālais disks',
        'aws_access_key_id' => 'AWS piekļuves atslēgas ID',
        'aws_secret_key' => 'AWS slepenā atslēga',
        'aws_default_region' => 'AWS noklusējuma reģions',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (neobligāts)',
        'use_path_style_endpoint' => 'Izmantot ceļa stila endpoint',
        'r2_access_key_id' => 'R2 piekļuves atslēgas ID',
        'r2_secret_key' => 'R2 slepenā atslēga',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces piekļuves atslēgas ID',
        'do_spaces_secret_key' => 'DO Spaces slepenā atslēga',
        'do_spaces_default_region' => 'DO Spaces noklusējuma reģions',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'Vai DO Spaces CDN ir iespējots?',
        'do_spaces_cdn_enabled_helper' => 'Kad tas ir iespējots, multivides faili tiks apkalpoti, izmantojot DigitalOcean Spaces CDN, lai nodrošinātu ātrāku globālo satura piegādi. Tālāk varat pēc izvēles konfigurēt pielāgotu CDN domēnu.',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN pielāgots domēns',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://jusu-pielagotais-domens.lv',
        'wasabi_access_key_id' => 'Wasabi piekļuves atslēgas ID',
        'wasabi_secret_key' => 'Wasabi slepenā atslēga',
        'wasabi_default_region' => 'Wasabi noklusējuma reģions',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'Lai atkārtoti izmantotu esošos attēlus, vienkārši norādiet Wasabi root kā "/", pēc tam augšupielādējiet visus pašreizējos failus no public/storage uz savu Wasabi root direktoriju.',
        'backblaze_access_key_id' => 'Backblaze piekļuves atslēgas ID',
        'backblaze_secret_key' => 'Backblaze slepenā atslēga',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze noklusējuma reģions',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Vai Backblaze CDN ir iespējots?',
        'backblaze_cdn_enabled_helper' => 'Kad tas ir iespējots, multivides faili tiks apkalpoti, izmantojot CDN, lai nodrošinātu ātrāku globālo satura piegādi. Tālāk ir jākonfigurē pielāgots CDN domēns (piemēram, Cloudflare CDN vai Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN pielāgots domēns',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://jusu-pielagotais-domens.lv',
        'default_placeholder_image' => 'Noklusējuma viettura attēls',
        'enable_chunk' => 'Iespējot daļu augšupielādi',
        'chunk_size' => 'Daļas izmērs (baiti)',
        'chunk_size_placeholder' => 'Noklusējuma: 1048576 ~ 1MB',
        'max_file_size' => 'Daļas maksimālais faila izmērs (MB)',
        'max_file_size_placeholder' => 'Noklusējuma: 1048576 ~ 1GB',
        'enable_watermark' => 'Iespējot ūdenszīmi',
        'enable_watermark_helper' => 'Kad tas ir iespējots, tikko augšupielādētajiem attēliem atlasītajās mapēs tiks automātiski pievienota ūdenszīme. Tas neietekmē esošos attēlus.',
        'watermark_source' => 'Ūdenszīmes attēls',
        'watermark_source_helper' => 'Atbalsta tikai PNG, JPG un JPEG formātus. Jums vajadzētu izmantot attēlu, kas ir mazāks par 200x200px un izmērs mazāks par 50KB.',
        'watermark_size' => 'Ūdenszīmes izmērs (%)',
        'watermark_size_placeholder' => 'Noklusējuma: 10 (%)',
        'watermark_opacity' => 'Ūdenszīmes necaurredzamība (%)',
        'watermark_opacity_placeholder' => 'Noklusējuma: 70 (%)',
        'watermark_position' => 'Ūdenszīmes pozīcija',
        'watermark_position_x' => 'Ūdenszīmes pozīcija X',
        'watermark_position_y' => 'Ūdenszīmes pozīcija Y',
        'watermark_position_top_left' => 'Augšpusē pa kreisi',
        'watermark_position_top_right' => 'Augšpusē pa labi',
        'watermark_position_bottom_left' => 'Apakšā pa kreisi',
        'watermark_position_bottom_right' => 'Apakšā pa labi',
        'watermark_position_center' => 'Centrā',
        'turn_off_automatic_url_translation_into_latin' => 'Izslēgt automātisku URL tulkošanu latīņu valodā',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Ja tas ir iespējots, failu URL netiks automātiski transliterēti latīņu rakstzīmēs, saglabājot oriģinālās rakstzīmes no alfabēta, kas nav latīņu alfabēts.',
        'bunnycdn_hostname' => 'Hosta nosaukums',
        'bunnycdn_zone' => 'Zonas nosaukums (jūsu glabāšanas zonas nosaukums)',
        'bunnycdn_key' => 'FTP un API piekļuves parole (glabāšanas zonas API piekļuves parole)',
        'bunnycdn_region' => 'Reģions (glabāšanas zonas reģions)',
        'optional' => 'Neobligāts',
        'sizes' => 'Mediju sīktēlu izmēri',
        'media_sizes_helper' => 'Iestatiet platumu vai augstumu uz 0, ja vēlaties apgriezt tikai pēc platuma vai augstuma.',
        'width' => 'Platums',
        'height' => 'Augstums',
        'default_size_value' => 'Noklusējuma: :size',
        'all' => 'Visi',
        'all_helper_text' => 'Ja noņemat atzīmi visām mapēm, tas tiks piemērots visām mapēm.',
        'media_folders_can_add_watermark' => 'Pievienot ūdenszīmi attēliem mapēs:',
        'max_upload_filesize' => 'Maksimālais augšupielādes faila izmērs (MB)',
        'max_upload_filesize_placeholder' => 'Noklusējuma: :size, jābūt mazākam par :size.',
        'max_upload_filesize_helper' => 'Jūsu serveris ļauj augšupielādēt failus maksimums :size, varat mainīt šo vērtību, lai ierobežotu augšupielādes faila izmēru.',
        'image_processing_library' => 'Attēlu apstrādes bibliotēka',
        'use_original_name_for_file_path' => 'Izmantot oriģinālo nosaukumu faila ceļam',
        'use_original_name_for_file_path_helper' => 'Kad tas ir iespējots, augšupielādētajiem failiem tiks saglabāti to sākotnējie nosaukumi. Ja tas ir atspējots, failu nosaukumi tiks pārveidoti par URL draudzīgiem elementiem (piemēram, "Mans fotoattēls.jpg" kļūst par "mans fotoattēls.jpg").',
        'keep_original_file_size_and_quality' => 'Saglabāt oriģinālo faila izmēru un kvalitāti',
        'keep_original_file_size_and_quality_helper' => 'Ja tas ir iespējots, augšupielādēto attēlu izmēri netiks mainīti vai optimizēti, saglabājot to sākotnējo kvalitāti un faila lielumu. Ja tas ir atspējots, attēli var tikt saspiesti un mainīti atbilstoši jūsu iestatījumiem.',
        'update_thumbnail_sizes_warning' => 'Pēc sīktēlu izmēru pielāgošanas jums jānoklikšķina uz pogas ":button_text", lai tos atsvaidzinātu.',
        'thumbnail_crop_position' => 'Sīktēla apgriešanas pozīcija',
        'thumbnail_crop_position_left' => 'Pa kreisi',
        'thumbnail_crop_position_center' => 'Centrā',
        'thumbnail_crop_position_right' => 'Pa labi',
        'thumbnail_crop_position_top' => 'Augšpusē',
        'thumbnail_crop_position_bottom' => 'Apakšā',
        'thumbnail_crop_position_helper' => 'Šis iestatījums tiek izmantots, lai apgrieztu attēlu, ģenerējot sīktēlus. Tas tiks apgriezts no šīs pozīcijas, līdz attēls ir aizpildīts.',
        'user_can_only_view_own_media' => 'Lietotāji var skatīt tikai savus medijus',
        'user_can_only_view_own_media_helper' => 'Kad iespējots, lietotāji var skatīt tikai savus medijus, savukārt super administratori var skatīt visus medijus.',
        'enable_thumbnail_sizes' => 'Iespējot sīktēlu izmērus',
        'enable_thumbnail_sizes_helper' => 'Iespējojiet šo opciju, lai ģenerētu sīktēlus attēliem. Ja tas ir atspējots, sistēma neģenerēs sīktēlus attēliem un vienmēr izmantos pilna izmēra attēlu.',
        'convert_image_to_webp' => 'Konvertēt JPG, JPEG, PNG attēlu uz WebP',
        'convert_image_to_webp_helper' => 'WebP ir mūsdienīgs attēlu formāts, kas nodrošina izcilu bezvērtības un zudumaina saspiešanu attēliem tīmeklī. To atbalsta Chrome, Firefox, Edge un Opera. Attēls tiks konvertēts uz WebP formātu, augšupielādējot. Tas tiek piemērots tikai JPG, JPEG, PNG attēliem.',
        'reduce_large_image_size' => 'Samazināt liela attēla izmēru, augšupielādējot',
        'reduce_large_image_size_helper' => 'Kad iespējots, sistēma samazinās lielu attēlu izmēru, augšupielādējot, piemērots JPG, JPEG, PNG, WebP attēliem. Maksimālais attēla platums un augstums tiks mainīts uz zemāk iestatītajām vērtībām.',
        'image_max_width' => 'Attēla maksimālais platums (px)',
        'image_max_height' => 'Attēla maksimālais augstums (px)',
        'image_max_width_placeholder' => 'Atstājiet tukšu, lai saglabātu oriģinālo platumu',
        'image_max_height_placeholder' => 'Atstājiet tukšu, lai saglabātu oriģinālo augstumu',
        'image_max_width_helper' => 'Iestatiet maksimālo attēla platumu pikseļos. Oriģinālais platums tiks saglabāts, ja šis lauks ir tukšs.',
        'image_max_height_helper' => 'Iestatiet maksimālo attēla augstumu pikseļos. Oriģinālais augstums tiks saglabāts, ja šis lauks ir tukšs.',
        'customize_upload_path' => 'Pielāgot augšupielādes ceļu',
        'customize_upload_path_helper' => 'Pielāgojiet mediju failu augšupielādes ceļu. Pēc noklusējuma sistēma augšupielādēs failus mapē ":path".',
        'upload_path' => 'Augšupielādes ceļš',
        'upload_path_placeholder' => 'Piemērs: uploads',
        'upload_path_helper' => 'Šī mape tiks izveidota /public. Noklusējuma mape ir ":folder". Pēc tam tā tiks augšupielādēta "/public/:folder".',
        'upload_path_warning' => 'Sistēma nepārvietos esošos failus uz jauno mapi. Ja vēlaties pārvietot esošos failus uz jauno mapi, jums tas jādara manuāli.',
        'convert_file_name_to_uuid' => 'Konvertēt faila nosaukumu uz UUID',
        'convert_file_name_to_uuid_helper' => 'Kad iespējots, sistēma konvertēs faila nosaukumu uz UUID, augšupielādējot. Tas ir noderīgi, lai novērstu dublētus failu nosaukumus un uzlabotu drošību.',
        's3_path' => 'Pielāgots S3 ceļš (neobligāts)',
        's3_path_placeholder' => 'Neobligāts pielāgots ceļš S3 bucket (piemēram, uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Saglabāt iestatījumus',
    'template' => 'Veidne',
    'description' => 'Apraksts',
    'enable' => 'Iespējot',
    'send' => 'Sūtīt',
    'test_email_description' => 'Lai nosūtītu testa e-pastu, pārliecinieties, ka esat atjauninājis e-pasta sūtīšanas konfigurācijas!',
    'test_email_input_placeholder' => 'Ievadiet e-pasta adresi, uz kuru vēlaties nosūtīt testa e-pastu.',
    'test_email_modal_title' => 'Nosūtīt testa e-pastu',
    'test_send_mail' => 'Nosūtīt testa e-pastu',
    'test_email_send_success' => 'E-pasts veiksmīgi nosūtīts!',
    'locale_direction_ltr' => 'No kreisās uz labo',
    'locale_direction_rtl' => 'No labās uz kreiso',
    'emails_warning' => 'Varat pievienot maksimums :count e-pastus',
    'email_add_more' => 'Pievienot vairāk',
    'generate' => 'Ģenerēt',
    'generate_thumbnails' => 'Ģenerēt sīktēlus',
    'generate_thumbnails_success' => 'Sīktēli veiksmīgi ģenerēti. :count faili ir ģenerēti!',
    'generate_thumbnails_error' => 'Mēs nevarējām reģenerēt sīktēlus :count failiem!',
    'generate_thumbnails_description' => 'Vai esat pārliecināts, ka vēlaties reģenerēt sīktēlus visiem attēliem? Tas var aizņemt kādu laiku. Lūdzu, neaizejiet no šīs lapas, kamēr process nav pabeigts.',
    'enable_chunk_description' => 'Daļu izmēra augšupielāde tiek izmantota, lai augšupielādētu liela izmēra failus.',
    'watermark_description' => 'BRĪDINĀJUMS: Ūdenszīme tiek pievienota tikai jauniem augšupielādētajiem attēliem, tā netiks pievienota esošajiem attēliem. Ūdenszīmes atspējošana nenoņems ūdenszīmi no esošajiem attēliem.',
    'submit' => 'Iesniegt',
    'back' => 'Atpakaļ',
    'enter_sample_value' => 'Ievadiet parauga vērtības testēšanai',
    'preview' => 'Priekšskatījums',
    'media_size_width' => ':size izmēra platumam jābūt lielākam par 0',
    'media_size_height' => ':size izmēra augstumam jābūt lielākam par 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob ļauj automatizēt noteiktas komandas vai skriptus jūsu vietnē.',
        'is_not_ready' => 'Lai palaistu cronjob, izpildiet zemāk norādītās instrukcijas.',
        'is_working' => 'Apsveicam! Jūsu cronjob darbojas.',
        'is_not_working' => 'Jūsu cronjob nedarbojas. Lūdzu, pārbaudiet sava servera cronjob.',
        'last_checked' => 'Pēdējoreiz pārbaudīts :time.',
        'copy_button' => 'Kopēt',
        'setup' => [
            'name' => 'Cronjob iestatīšana',
            'connect_to_server' => 'Savienojieties ar serveri, izmantojot SSH vai citu vēlamo metodi.',
            'open_crontab' => 'Atveriet crontab failu, izmantojot teksta redaktoru (piemēram, `crontab -e`).',
            'add_cronjob' => 'Pievienojiet iepriekš norādīto komandu crontab failam un saglabājiet to.',
            'done' => 'Cronjob tagad darbosies katru minūti un izpildīs norādīto komandu.',
            'learn_more' => 'Varat uzzināt vairāk par cronjob no Laravel :documentation',
            'documentation' => 'dokumentācijas',
            'copied' => 'Nokopēts',
        ],
    ],
    'security' => [
        'title' => 'Drošības iestatījumi',
        'description' => 'Pārbaudiet un konfigurējiet drošības iestatījumus jūsu vietnei.',
        'menu_description' => 'Pārvaldīt sīkdatņu drošību un HTTP galvenes',
        'status_secure' => 'Visi drošības iestatījumi ir pareizi konfigurēti!',
        'status_insecure' => 'Daži drošības iestatījumi prasa uzmanību!',
        'current_settings' => 'Pašreizējie drošības iestatījumi',
        'status' => 'Statuss',
        'setting' => 'Iestatījums',
        'current_value' => 'Pašreizējā vērtība',
        'recommended_value' => 'Ieteicams',
        'session_http_only' => 'HttpOnly sīkdatnes karogs',
        'session_http_only_description' => 'Novērš JavaScript piekļuvi sesijas sīkdatnēm (aizsargā pret XSS uzbrukumiem)',
        'session_secure_cookie' => 'Secure sīkdatnes karogs',
        'session_secure_cookie_description' => 'Nodrošina, ka sīkdatnes tiek sūtītas tikai caur HTTPS savienojumiem',
        'session_same_site' => 'SameSite sīkdatnes karogs',
        'session_same_site_description' => 'Novērš CSRF uzbrukumus, ierobežojot, kad sīkdatnes tiek sūtītas',
        'http_security_headers' => 'HTTP drošības galvenes',
        'http_security_headers_description' => 'Pievieno drošības galvenes, lai aizsargātu pret izplatītām tīmekļa ievainojamībām',
        'https_warning' => 'Jūsu vietne neizmanto HTTPS',
        'https_warning_description' => 'Dažas drošības funkcijas, piemēram, drošas sīkdatnes, prasa HTTPS. Apsveriet SSL iespējošanu jūsu vietnei.',
        'how_to_fix' => 'Kā novērst drošības problēmas',
        'env_file_location' => 'Rediģējiet savu .env failu, kas atrodas:',
        'add_to_env' => 'Pievienojamie iestatījumi',
        'required_settings' => 'Nepieciešamie drošības iestatījumi',
        'for_https_sites' => 'Tikai HTTPS vietnēm',
        'copy' => 'Kopēt',
        'copy_settings' => 'Kopēt visus iestatījumus',
        'copied' => 'Nokopēts!',
        'steps' => 'Darbības iestatījumu piemērošanai',
        'step_1' => 'Atveriet savu .env failu teksta redaktorā',
        'step_2' => 'Pievienojiet vai atjauniniet iepriekš parādītos drošības iestatījumus',
        'step_3' => 'Saglabājiet .env failu',
        'step_4' => 'Notīriet kešatmiņu, izmantojot Administratora paneli → Platformas administrācija → Kešatmiņas pārvaldība',
        'security_headers_info' => 'Drošības galveņu informācija',
        'security_headers_list' => 'Kad iespējots, visām atbildēm tiek pievienotas šādas galvenes:',
        'header_nosniff' => 'Novērš pārlūkprogrammu minējumus par satura tipiem',
        'header_frame' => 'Aizsargā pret clickjacking uzbrukumiem',
        'header_xss' => 'Iespējo pārlūkprogrammas XSS aizsardzību',
        'header_referrer' => 'Kontrolē, cik daudz referrer informācijas tiek nosūtīts',
        'learn_more' => 'Detalizētākai informācijai skatiet :documentation',
        'documentation' => 'drošības dokumentāciju',
    ],
    'cache' => [
        'title' => 'Kešatmiņa',
        'description' => 'Konfigurēt kešatmiņu optimizētai ātrumam',
        'form' => [
            'cache_admin_menu' => 'Kešot administratora izvēlni',
            'cache_admin_menu_helper' => 'Kešot administratora izvēlni optimizētam ātrumam. Šī opcija jāatspējo, ja izstrādājat vai pielāgojat administratora izvēlni.',
            'enable_cache_site_map' => 'Kešot vietnes karti',
            'enable_cache_site_map_helper' => 'Vietnes karte :url jākešo liela skaita lapu dēļ. Ja jums ir neliels skaits lapu, varat atspējot šo opciju.',
            'cache_time_site_map' => 'Vietnes kartes kešatmiņas noilgums (minūtēs)',
            'cache_front_menu' => 'Kešot priekšējās vietnes izvēlni',
            'cache_front_menu_helper' => 'Kešot priekšējās vietnes izvēlni optimizētam ātrumam',
            'cache_user_avatar' => 'Kešot lietotāja avataru',
            'cache_user_avatar_helper' => 'Lietotājiem bez avatara sistēma ģenerēs avatarus no viņu lietotājvārdiem. Avatari tiks kešoti optimizētam ātrumam un netiks reģenerēti.',
            'shortcode_cache_enabled' => 'Kešot saīsinājumus (UI blokus)',
            'shortcode_cache_enabled_helper' => 'Iespējot saīsinājumu kešatmiņu, lai uzlabotu veiktspēju. Kad iespējots, saīsinājumi tiks kešoti, lai samazinātu atveidošanas laiku.',
            'shortcode_cache_warning' => '<strong>⚠️ Svarīgs paziņojums:</strong><br>• Saīsinājumi, kas satur formas (kontaktu formas, biļetenu abonementi utt.), automātiski apies kešatmiņu, lai saglabātu funkcionalitāti.<br>• Saīsinājumiem ar dinamisku JavaScript saturu kešatmiņa jāatspējo manuāli.<br>• Lai atspējotu kešatmiņu konkrētiem saīsinājumiem, pievienojiet <code>Iespējot kešatmiņu: Nē</code> saīsinājuma konfigurācijā.<br>• Formas ar CSRF marķieriem, reCAPTCHA vai citiem dinamiskiem elementiem tiek automātiski noteiktas un izslēgtas no kešatmiņas.',
            'shortcode_cache_ttl' => 'Kešatmiņas ilgums (sekundēs)',
            'shortcode_cache_ttl_helper' => 'Laiks, cik ilgi kešot visus saīsinājumus. Noklusējuma ir 1800 sekundes (30 minūtes).',
            'widget_cache_enabled' => 'Kešot logrīkus',
            'widget_cache_enabled_helper' => 'Iespējot logrīku kešatmiņu, lai uzlabotu veiktspēju. Kad iespējots, logrīki tiks kešoti, lai samazinātu atveidošanas laiku.',
            'widget_cache_warning' => '<strong>⚠️ Svarīgs paziņojums:</strong><br>• Logrīki, kas satur formas (kontaktu formas, biļetenu abonementi utt.), automātiski apies kešatmiņu, lai saglabātu funkcionalitāti.<br>• Logrīkiem ar dinamisku JavaScript saturu kešatmiņa jāatspējo manuāli.<br>• Lai atspējotu kešatmiņu konkrētiem logrīkiem, iestatiet <code>Iespējot kešatmiņu: Nē</code> logrīka konfigurācijā.<br>• Formas ar CSRF marķieriem, reCAPTCHA vai citiem dinamiskiem elementiem tiek automātiski noteiktas un izslēgtas no kešatmiņas.',
            'widget_cache_ttl' => 'Kešatmiņas ilgums (sekundēs)',
            'widget_cache_ttl_helper' => 'Laiks, cik ilgi kešot visus logrīkus. Noklusējuma ir 1800 sekundes (30 minūtes).',
            'plugin_cache_enabled' => 'Kešot instalētos spraudņus',
            'plugin_cache_enabled_helper' => 'Kešot instalēto spraudņu sarakstu uzlabotai veiktspējai. Kad iespējots, sistēma kešos spraudņu sarakstu 30 minūtes, lai samazinātu failu sistēmas skenēšanu.',
        ],
    ],
    'appearance' => [
        'title' => 'Izskats',
    ],
    'panel' => [
        'common' => 'Kopīgs',
        'general' => 'Vispārīgi',
        'general_description' => 'Skatīt un atjaunināt vispārīgos iestatījumus un aktivizēt licenci',
        'email' => 'E-pasts',
        'email_description' => 'Skatīt un atjaunināt e-pasta iestatījumus un e-pasta veidnes',
        'media' => 'Mediji',
        'media_description' => 'Skatīt un atjaunināt mediju iestatījumus',
        'system' => 'Sistēma',
        'system_updater' => 'Sistēmas atjauninātājs',
        'system_updater_description' => 'Atjaunināt sistēmu uz jaunāko versiju',
        'others' => 'Citi',
    ],
    'saving' => 'Saglabā...',
    'generating_media_thumbnails' => 'Ģenerē mediju sīktēlus...',
    'test_email_template' => 'Testēt e-pasta veidni',
    'select_email_template' => 'Izvēlēties e-pasta veidni',
    'enums' => [
        'data_retention_period' => [
            'Nekad',
            '1 diena',
            3 => '3 dienas',
            7 => '1 nedēļa',
            30 => '1 mēnesis',
            90 => '3 mēneši',
            180 => '6 mēneši',
            365 => '1 gads',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute jābūt derīgam AWS reģionam (piemēram, us-east-1, eu-west-1).',
    ],
];
