<?php

return [
    'name' => 'Ενοικιάσεις Αυτοκινήτων',
    'customer' => [
        'name' => 'Πελάτες',
        'create' => 'Δημιουργία Πελάτη',
        'view' => 'Προβολή',
        'information' => 'Πληροφορίες Πελάτη',
        'email' => 'Email',
        'phone' => 'Τηλέφωνο',
        'status' => 'Κατάσταση',
        'vendor_status' => 'Κατάσταση Προμηθευτή',
        'is_vendor' => 'Προμηθευτής',
        'not_vendor' => 'Πελάτης',
        'recent_activity' => 'Πρόσφατη Δραστηριότητα',
        'recent_activity_description' => 'Η δραστηριότητα του πελάτη θα εμφανιστεί εδώ.',
        'verification_section' => 'Επαλήθευση Πελάτη',
        'verified' => 'Επαληθευμένος',
        'not_verified' => 'Μη Επαληθευμένος',
        'verified_by' => 'Επαληθεύτηκε Από',
        'verified_at' => 'Επαληθεύτηκε Στις',
        'verify_customer' => 'Επαλήθευση Πελάτη',
        'unverify_customer' => 'Ακύρωση Επαλήθευσης Πελάτη',
        'verify_customer_confirmation' => 'Επιβεβαίωση Επαλήθευσης Πελάτη',
        'verify_customer_confirmation_desc' => 'Είστε βέβαιοι ότι θέλετε να επαληθεύσετε τον/την :name; Αυτό θα εμφανίσει ένα σήμα επαλήθευσης στο προφίλ τους.',
        'unverify_customer_confirmation' => 'Επιβεβαίωση Ακύρωσης Επαλήθευσης Πελάτη',
        'unverify_customer_confirmation_desc' => 'Είστε βέβαιοι ότι θέλετε να αφαιρέσετε την επαλήθευση από τον/την :name; Το σήμα επαλήθευσης θα αφαιρεθεί.',
        'verify_success' => 'Ο πελάτης :name επαληθεύτηκε με επιτυχία.',
        'unverify_success' => 'Η επαλήθευση του πελάτη :name αφαιρέθηκε με επιτυχία.',
        'already_verified' => 'Αυτός ο πελάτης είναι ήδη επαληθευμένος.',
        'already_unverified' => 'Αυτός ο πελάτης δεν είναι επαληθευμένος.',
        'upgrade_to_vendor_title' => 'Αναβάθμιση σε Προμηθευτή',
        'upgrade_to_vendor_description' => 'Αναβαθμίστε αυτόν τον πελάτη σε κατάσταση προμηθευτή για να του επιτρέψετε να καταχωρήσει και να διαχειριστεί τα δικά του αυτοκίνητα προς ενοικίαση.',
        'upgrade_to_vendor_button' => 'Αναβάθμιση σε Προμηθευτή',
        'upgrade_to_vendor_confirmation' => 'Επιβεβαίωση Αναβάθμισης σε Προμηθευτή',
        'upgrade_to_vendor_confirmation_desc' => 'Είστε βέβαιοι ότι θέλετε να αναβαθμίσετε τον/την :name σε κατάσταση προμηθευτή; Αυτό θα του επιτρέψει να καταχωρήσει και να διαχειριστεί τα δικά του αυτοκίνητα στην πλατφόρμα.',
        'upgrade_to_vendor_success' => 'Ο/Η :name αναβαθμίστηκε με επιτυχία σε κατάσταση προμηθευτή.',
        'already_vendor' => 'Αυτός ο πελάτης είναι ήδη προμηθευτής.',
        'customer_verified_successfully' => 'Αυτός ο πελάτης έχει επαληθευτεί και μπορείτε να τον εμπιστευτείτε.',
        'customer_not_verified_yet' => 'Αυτός ο πελάτης δεν έχει επαληθευτεί ακόμα.',
        'verification_pending' => 'Εκκρεμεί Επαλήθευση',
        'click_verify_to_approve' => 'Κάντε κλικ στο κουμπί παρακάτω για να επαληθεύσετε αυτόν τον πελάτη και να εμφανίσετε το σήμα επαλήθευσης.',
        'verification_note' => 'Σημείωση Επαλήθευσης',
        'verification_note_placeholder' => 'Εισαγάγετε τυχόν σημειώσεις σχετικά με αυτή την ενέργεια επαλήθευσης...',
        'verification_note_helper' => 'Προσθέστε σημειώσεις σχετικά με τη διαδικασία επαλήθευσης (μόνο για εσωτερική χρήση)',
        'forms' => [
            'name' => 'Όνομα',
            'email' => 'Email',
            'phone' => 'Τηλέφωνο',
            'avatar' => 'Avatar',
            'dob' => 'Ημερομηνία Γέννησης',
            'company' => 'Εταιρεία',
            'position' => 'Θέση',
            'password' => 'Κωδικός',
            'password_confirmation' => 'Επιβεβαίωση Κωδικού',
            'change_password' => 'Αλλαγή κωδικού;',
            'phone_placeholder' => 'Τηλέφωνο',
        ],
    ],
    'vendor' => [
        'name' => 'Προμηθευτές',
        'view' => 'Προβολή :name',
        'information' => 'Πληροφορίες Προμηθευτή',
        'total_cars' => 'Συνολικά Αυτοκίνητα',
        'total_bookings' => 'Συνολικές Κρατήσεις',
        'verified' => 'Επαληθευμένος',
        'not_verified' => 'Μη Επαληθευμένος',
        'verification_section' => 'Επαλήθευση Προμηθευτή',
        'vendor_verified_successfully' => 'Αυτός ο προμηθευτής έχει επαληθευτεί και μπορείτε να τον εμπιστευτείτε.',
        'vendor_not_verified_yet' => 'Αυτός ο προμηθευτής δεν έχει επαληθευτεί ακόμα.',
        'verification_pending' => 'Εκκρεμεί Επαλήθευση',
        'click_verify_to_approve' => 'Κάντε κλικ στο κουμπί παρακάτω για να επαληθεύσετε αυτόν τον προμηθευτή και να εμφανίσετε το σήμα επαλήθευσης.',
        'verify_vendor' => 'Επαλήθευση Προμηθευτή',
        'unverify_vendor' => 'Ακύρωση Επαλήθευσης Προμηθευτή',
        'verify_vendor_confirmation' => 'Επιβεβαίωση Επαλήθευσης Προμηθευτή',
        'verify_vendor_confirmation_desc' => 'Είστε βέβαιοι ότι θέλετε να επαληθεύσετε τον/την :name; Αυτό θα εμφανίσει ένα σήμα επαλήθευσης στο προφίλ τους.',
        'unverify_vendor_confirmation' => 'Επιβεβαίωση Ακύρωσης Επαλήθευσης Προμηθευτή',
        'unverify_vendor_confirmation_desc' => 'Είστε βέβαιοι ότι θέλετε να αφαιρέσετε την επαλήθευση από τον/την :name; Το σήμα επαλήθευσης θα αφαιρεθεί.',
        'verified_successfully' => 'Ο προμηθευτής επαληθεύτηκε με επιτυχία.',
        'unverified_successfully' => 'Η επαλήθευση του προμηθευτή αφαιρέθηκε με επιτυχία.',
        'already_verified' => 'Αυτός ο προμηθευτής είναι ήδη επαληθευμένος.',
        'not_verified_yet' => 'Αυτός ο προμηθευτής δεν έχει επαληθευτεί ακόμα.',
        'recent_activity' => 'Πρόσφατη Δραστηριότητα',
        'recent_cars' => 'Πρόσφατα Αυτοκίνητα',
        'recent_bookings' => 'Πρόσφατες Κρατήσεις',
        'no_cars_yet' => 'Δεν έχουν προστεθεί αυτοκίνητα ακόμα.',
        'no_bookings_yet' => 'Δεν έχουν ληφθεί κρατήσεις ακόμα.',
    ],
    'make' => [
        'name' => 'Κατασκευαστές',
        'create' => 'Δημιουργία Κατασκευαστή Αυτοκινήτου',
        'forms' => [
            'logo' => 'Λογότυπο',
            'logo_dark' => 'Λογότυπο Σκούρο',
        ],
    ],
    'car' => [
        'name' => 'Αυτοκίνητα',
        'create' => 'Δημιουργία Αυτοκινήτου',
        'forms' => [
            'car' => 'Αυτοκίνητο',
            'logo' => 'Λογότυπο',
            'license_plate' => 'Πινακίδα Κυκλοφορίας',
            'make' => 'Κατασκευαστής',
            'model' => 'Μοντέλο',
            'name' => 'Όνομα',
            'images' => 'Εικόνες',
            'year' => 'Έτος',
            'color' => 'Χρώμα',
            'mileage' => 'Χιλιόμετρα',
            'kilometers' => 'Χιλιόμετρα',
            'horsepower' => 'Ιπποδύναμη',
            'vehicle_type' => 'Τύπος Οχήματος',
            'transmission' => 'Κιβώτιο Ταχυτήτων',
            'fuel_type' => 'Τύπος Καυσίμου',
            'rental_rate' => 'Τιμή Ενοικίασης',
            'currency' => 'Νόμισμα',
            'status' => 'Κατάσταση',
            'availability' => 'Διαθεσιμότητα',
            'insurance_info' => 'Πληροφορίες Ασφάλισης',
            'number_of_seats' => 'Αριθμός Θέσεων',
            'number_of_doors' => 'Αριθμός Πορτών',
            'vin' => 'VIN',
            'maintenance_history' => 'Ιστορικό Συντήρησης',
            'location' => 'Τοποθεσία',
            'description' => 'Περιγραφή',
            'rental_type' => 'Τύπος Ενοικίασης',
            'tags' => 'Ετικέτες',
            'add_new_attribute' => 'Προσθήκη νέου <a href=":url" target="_blank">εδώ</a>.',
            'categories' => 'Κατηγορίες',
            'pick_address' => 'Διεύθυνση Παραλαβής',
            'return_address' => 'Διεύθυνση Επιστροφής',
            'same_drop_off' => 'Ίδια Επιστροφή',
            'tax' => 'Φόρος',
            'select_tax' => 'Επιλογή Φόρου',
            'none' => 'Κανένας',
            'colors' => 'Χρώματα',
            'amenities' => 'Ανέσεις',
            'is_used' => 'Είναι μεταχειρισμένο;',
            'moderation_status' => 'Κατάσταση Επιθεώρησης',
            'status_moderation' => [
                'approve' => 'Έγκριση',
                'reject' => 'Απόρριψη',
                'approve_title' => 'Έγκριση αυτοκινήτου',
                'approve_message' => 'Είστε βέβαιοι ότι θέλετε να εγκρίνετε αυτό το αυτοκίνητο; Αυτή η ενέργεια δεν μπορεί να αναιρεθεί.',
                'reject_title' => 'Απόρριψη αυτοκινήτου',
                'reject_message' => 'Είστε βέβαιοι ότι θέλετε να απορρίψετε αυτό το αυτοκίνητο; Αυτή η ενέργεια δεν μπορεί να αναιρεθεί.',
                'reject_reason' => 'Εισαγάγετε τον λόγο απόρριψης',
                'approved' => 'Το αυτοκίνητο εγκρίθηκε με επιτυχία!',
                'rejected' => 'Το αυτοκίνητο απορρίφθηκε με επιτυχία!',
                'reason_rejected' => 'Λόγος απόρριψης',
            ],
            'customer' => 'Πελάτης',
            'select_customer' => 'Επιλέξτε πελάτη...',
            'vendor_images' => 'Εικόνες (Μέγιστο :max εικόνες)',
            'images_upload_placeholder' => 'Αποθέστε αρχεία εδώ ή κάντε κλικ για μεταφόρτωση.',
            'car_purpose' => 'Σκοπός Αυτοκινήτου',
            'for_rent' => 'Προς Ενοικίαση',
            'for_sale' => 'Προς Πώληση',
            'car_type' => 'Τύπος Αυτοκινήτου',
            'rental_information' => 'Πληροφορίες Ενοικίασης',
            'sale_statuses' => [
                'available' => 'Διαθέσιμο',
                'sold' => 'Πωλήθηκε',
                'reserved' => 'Δεσμευμένο',
            ],
            'selling_information' => 'Πληροφορίες Πώλησης',
            'is_for_sale' => 'Διαθέσιμο προς πώληση',
            'sale_price' => 'Τιμή Πώλησης',
            'sale_price_placeholder' => 'Εισαγάγετε τιμή πώλησης',
            'condition' => 'Κατάσταση',
            'select_condition' => 'Επιλέξτε Κατάσταση',
            'condition_options' => [
                'new' => 'Καινούργιο',
                'like_new' => 'Σαν Καινούργιο',
                'excellent' => 'Άριστη',
                'good' => 'Καλή',
                'fair' => 'Μέτρια',
                'poor' => 'Κακή',
            ],
            'ownership_history' => 'Ιστορικό Ιδιοκτησίας',
            'ownership_history_placeholder' => 'Εισαγάγετε ιστορικό ιδιοκτησίας',
            'warranty_information' => 'Πληροφορίες Εγγύησης',
            'warranty_information_placeholder' => 'Εισαγάγετε πληροφορίες εγγύησης',
            'sale_status' => 'Κατάσταση Πώλησης',
            'external_booking_url' => 'Σύνδεσμος Κράτησης Εκτός Ιστότοπου',
            'external_booking_url_helper' => 'Εισαγάγετε την εξωτερική διεύθυνση URL όπου οι πελάτες μπορούν να κάνουν κράτηση για αυτό το αυτοκίνητο εκτός αυτής της πλατφόρμας. Αφήστε κενό εάν η κράτηση είναι διαθέσιμη μόνο σε αυτόν τον ιστότοπο.',
            'address' => 'Διεύθυνση',
            'address_helper' => 'Εισαγάγετε τη συγκεκριμένη διεύθυνση όπου βρίσκεται αυτό το όχημα',
        ],
        'car_purposes' => [
            'sale' => 'Προς Πώληση',
            'rent' => 'Προς Ενοικίαση',
        ],
        'placeholders' => [
            'name' => 'Εισαγάγετε το όνομα του οχήματος (π.χ. Toyota Camry 2023, Honda CR-V, κλπ.)',
            'description' => 'Εισαγάγετε μια σύντομη περιγραφή του οχήματος επισημαίνοντας τα βασικά χαρακτηριστικά',
            'rental_rate' => 'Εισαγάγετε την τιμή ενοικίασης με βάση τον επιλεγμένο τύπο ενοικίασης',
            'location' => 'Εισαγάγετε τη φυσική τοποθεσία του οχήματος',
            'address' => 'Εισαγάγετε τη συγκεκριμένη διεύθυνση (π.χ. Λεωφ. Αθηνών 123, Πόλη, Περιοχή)',
            'sale_price' => 'Εισαγάγετε την τιμή πώλησης για αυτό το όχημα',
            'ownership_history' => 'Εισαγάγετε λεπτομέρειες σχετικά με τους προηγούμενους ιδιοκτήτες, αριθμό ιδιοκτητών, κλπ.',
            'warranty_information' => 'Εισαγάγετε λεπτομέρειες σχετικά με την κάλυψη εγγύησης, ημερομηνία λήξης, κλπ.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Εισαγάγετε αριθμό πινακίδας οχήματος',
            'vin' => 'Εισαγάγετε τον Αριθμό Αναγνώρισης Οχήματος (VIN)',
            'year' => 'Εισαγάγετε το έτος κατασκευής (π.χ. 2023)',
            'mileage' => 'Εισαγάγετε τα τρέχοντα χιλιόμετρα',
            'kilometers' => 'Εισαγάγετε τα τρέχοντα χιλιόμετρα',
            'horsepower' => 'Εισαγάγετε την ιπποδύναμη (HP) του οχήματος (π.χ. 150.5)',
            'number_of_seats' => 'Εισαγάγετε τον αριθμό των θέσεων στο όχημα',
            'number_of_doors' => 'Εισαγάγετε τον αριθμό των πορτών που έχει το όχημα',
            'insurance_info' => 'Εισαγάγετε σχετικές πληροφορίες ασφάλισης για αυτό το όχημα',
            'tags' => 'Επιλέξτε ή δημιουργήστε ετικέτες',
            'amenities' => 'Επιλέξτε ανέσεις',
            'colors' => 'Επιλέξτε ή δημιουργήστε χρώματα',
        ],
        'enums' => [
            'vendor_status' => 'Κατάσταση Προμηθευτή',
            'is_vendor' => 'Προμηθευτής',
            'not_vendor' => 'Πελάτης',
            'statuses' => [
                'available' => 'Διαθέσιμο',
                'rented' => 'Ενοικιασμένο',
                'maintenance' => 'Συντήρηση',
                'out_of_service' => 'Εκτός Λειτουργίας',
            ],
            'rental_types' => [
                'per_hour' => 'Ανά ώρα',
                'per_day' => 'Ανά ημέρα',
                'per_week' => 'Ανά εβδομάδα',
                'per_month' => 'Ανά μήνα',
            ],
            'moderation_statuses' => [
                'pending' => 'Εκκρεμεί',
                'approved' => 'Εγκρίθηκε',
                'rejected' => 'Απορρίφθηκε',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Ιστορικά Συντήρησης',
            'create' => 'Δημιουργία Ιστορικού Συντήρησης',
            'amount' => 'Ποσό',
            'forms' => [
                'price_placeholder' => 'Τιμή υπηρεσίας',
                'currency' => 'Νόμισμα',
                'none' => 'Κανένα',
                'name' => 'Όνομα',
                'amount' => 'Ποσό',
                'created_at' => 'Δημιουργήθηκε Στις',
                'action' => 'Ενέργεια',
                'date' => 'Ημερομηνία',
                'no_maintenance_history' => 'Δεν υπάρχουν ιστορικά συντήρησης',
                'edit_maintenance_history' => 'Επεξεργασία ιστορικού συντήρησης',
                'add_maintenance_history' => 'Προσθήκη ιστορικού συντήρησης',
                'add' => 'Προσθήκη',
                'edit' => 'Επεξεργασία',
                'delete' => 'Διαγραφή',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Χαρακτηριστικά Αυτοκινήτου',
        'car_type' => [
            'name' => 'Τύποι',
            'create' => 'Δημιουργία Τύπου Αυτοκινήτου',
            'forms' => [
                'name' => 'Όνομα',
            ],
        ],
        'transmission' => [
            'name' => 'Κιβώτια Ταχυτήτων',
            'create' => 'Δημιουργία Κιβωτίου Ταχυτήτων',
            'forms' => [
                'name' => 'Όνομα',
            ],
        ],
        'fuel_type' => [
            'name' => 'Καύσιμα',
            'create' => 'Δημιουργία Τύπου Καυσίμου',
            'forms' => [
                'name' => 'Όνομα',
            ],
        ],
        'tag' => [
            'name' => 'Ετικέτες',
            'create' => 'Δημιουργία Ετικέτας',
        ],
        'category' => [
            'name' => 'Κατηγορίες',
            'create' => 'Δημιουργία Κατηγορίας',
            'forms' => [
                'none' => 'Κανένα',
                'total_cars' => 'Σύνολο αυτοκινήτων: :total',
            ],
        ],
        'address' => [
            'name' => 'Τοποθεσίες',
            'create' => 'Δημιουργία Τοποθεσίας Αυτοκινήτου',
            'form' => [
                'name' => 'Διεύθυνση',
                'full_address' => 'Πλήρης Διεύθυνση',
                'detail_address' => 'Λεπτομερής Διεύθυνση',
            ],
        ],
        'color' => [
            'name' => 'Χρώμα',
            'create' => 'Δημιουργία Χρώματος',
        ],
        'amenity' => [
            'name' => 'Ανέσεις',
            'create' => 'Δημιουργία Άνεσης',
        ],
    ],
    'tax' => [
        'name' => 'Φόροι',
        'create' => 'Δημιουργία Φόρου',
        'forms' => [
            'name' => 'Όνομα',
            'name_placeholder' => 'Εισαγάγετε όνομα',
            'percentage' => 'Ποσοστό',
            'percentage_placeholder' => 'Ποσοστό',
            'percent_placeholder' => 'Ποσοστό',
            'priority' => 'Προτεραιότητα',
            'priority_placeholder' => 'Προτεραιότητα',
        ],
    ],
    'review' => [
        'name' => 'Κριτικές',
        'create' => 'Δημιουργία Κριτικής',
        'edit' => 'Επεξεργασία Κριτικής',
        'vendor' => [
            'title' => 'Κριτικές Πελατών',
            'description' => 'Διαχείριση όλων των κριτικών πελατών για τα αυτοκίνητά σας',
            'no_reviews' => 'Δεν έχετε κριτικές ακόμα',
            'filter_by_car' => 'Φιλτράρισμα ανά αυτοκίνητο',
            'filter_by_rating' => 'Φιλτράρισμα ανά βαθμολογία',
            'filter_by_date' => 'Φιλτράρισμα ανά ημερομηνία',
            'all_cars' => 'Όλα τα Αυτοκίνητα',
            'all_ratings' => 'Όλες οι Βαθμολογίες',
            'manage_reviews' => 'Διαχείριση Κριτικών',
            'view_all' => 'Προβολή Όλων των Κριτικών',
            'delete_review_confirmation' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτή την κριτική;',
            'delete_review_success' => 'Η κριτική διαγράφηκε με επιτυχία',
            'cannot_delete' => 'Δεν είναι δυνατή η διαγραφή αυτής της κριτικής',
        ],
        'forms' => [
            'customer' => 'Πελάτης',
            'car' => 'Αυτοκίνητο',
            'content' => 'Περιεχόμενο',
            'rating' => 'Βαθμολογία',
            'your_name' => 'Το Όνομά Σας',
            'email_address' => 'Διεύθυνση Email',
            'submit' => 'Υποβολή',
            'star' => 'Αστέρι',
            'status' => 'Κατάσταση',
            'created_at' => 'Δημιουργήθηκε Στις',
            'select_car' => 'Επιλέξτε Αυτοκίνητο',
            'select_rating' => 'Επιλέξτε Βαθμολογία',
            'comment' => 'Σχόλιο',
            'reply' => 'Απάντηση',
            'reply_to_review' => 'Απάντηση σε Κριτική',
            'save_reply' => 'Αποθήκευση Απάντησης',
            'cancel_reply' => 'Ακύρωση',
        ],
        'statuses' => [
            'published' => 'Δημοσιευμένη',
            'pending' => 'Εκκρεμεί',
            'rejected' => 'Απορρίφθηκε',
        ],
        'ratings' => [
            '1' => '1 Αστέρι - Κακή',
            '2' => '2 Αστέρια - Μέτρια',
            '3' => '3 Αστέρια - Καλή',
            '4' => '4 Αστέρια - Πολύ Καλή',
            '5' => '5 Αστέρια - Εξαιρετική',
        ],
    ],
    'coupon' => [
        'name' => 'Κουπόνια',
        'create' => 'Δημιουργία Κουπονιού',
        'types' => [
            'percentage' => 'Ποσοστό %',
            'money' => 'Χρήματα',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Υπηρεσίες',
        'create' => 'Δημιουργία Υπηρεσίας',
        'forms' => [
            'name' => 'Όνομα',
            'content' => 'Περιεχόμενο',
            'price' => 'Τιμή',
            'currency' => 'Νόμισμα',
            'image' => 'Εικόνα',
            'logo' => 'Λογότυπο',
            'status' => 'Κατάσταση',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Ημερολόγιο Διαθεσιμότητας',
        'title' => 'Ημερολόγιο Διαθεσιμότητας',
        'description' => 'Προβολή διαθεσιμότητας αυτοκινήτων και κρατήσεων σε μορφή ημερολογίου',
        'select_dates' => 'Επιλέξτε ημερομηνίες για έλεγχο διαθεσιμότητας',
        'car_filter' => 'Φιλτράρισμα ανά Αυτοκίνητο',
        'all_cars' => 'Όλα τα Αυτοκίνητα',
        'clear_filter' => 'Καθαρισμός Φίλτρου',
        'availability_check' => 'Έλεγχος Διαθεσιμότητας Αυτοκινήτου',
        'selected_period' => 'Επιλεγμένη Περίοδος',
        'checking_availability' => 'Έλεγχος διαθεσιμότητας...',
        'available' => 'Διαθέσιμο',
        'not_available' => 'Μη Διαθέσιμο',
        'booking_details' => 'Λεπτομέρειες Κράτησης',
        'how_to_use' => 'Πώς να Χρησιμοποιήσετε το Ημερολόγιο Διαθεσιμότητας Αυτοκινήτων',
        'viewing_bookings' => 'Προβολή Κρατήσεων',
        'checking_availability_help' => 'Έλεγχος Διαθεσιμότητας',
        'color_legend' => 'Υπόμνημα Χρωμάτων',
        'pending_bookings' => 'Εκκρεμείς Κρατήσεις',
        'processing_bookings' => 'Κρατήσεις σε Επεξεργασία',
        'completed_bookings' => 'Ολοκληρωμένες Κρατήσεις',
        'cancelled_bookings' => 'Ακυρωμένες Κρατήσεις',
        'unknown_make' => 'Άγνωστος Κατασκευαστής',
        'loading' => 'Φόρτωση...',
        'loading_calendar_data' => 'Φόρτωση δεδομένων ημερολογίου...',
        'loading_booking_details' => 'Φόρτωση λεπτομερειών κράτησης...',
        'please_wait_booking_info' => 'Παρακαλώ περιμένετε ενώ ανακτούμε τις πληροφορίες κράτησης.',
        'please_wait_availability' => 'Παρακαλώ περιμένετε ενώ ελέγχουμε τη διαθεσιμότητα αυτοκινήτου για τις επιλεγμένες ημερομηνίες.',
        'error' => 'Σφάλμα',
        'error_loading_booking' => 'Αποτυχία φόρτωσης λεπτομερειών κράτησης. Παρακαλώ δοκιμάστε ξανά.',
        'error_checking_availability' => 'Σφάλμα ελέγχου διαθεσιμότητας αυτοκινήτου',
        'customer' => 'Πελάτης',
        'status' => 'Κατάσταση',
        'amount' => 'Ποσό',
        'make' => 'Κατασκευαστής',
        'vendor' => 'Προμηθευτής',
        'per_day' => '/ημέρα',
        'edit_car' => 'Επεξεργασία Αυτοκινήτου',
        'no_cars_found' => 'Δεν βρέθηκαν αυτοκίνητα',
        'no_cars_available_period' => 'Δεν υπάρχουν διαθέσιμα αυτοκίνητα για την επιλεγμένη περίοδο.',
        'close' => 'Κλείσιμο',
        'edit_booking' => 'Επεξεργασία Κράτησης',
        'pending' => 'Εκκρεμεί',
        'processing' => 'Σε Επεξεργασία',
        'completed' => 'Ολοκληρώθηκε',
        'cancelled' => 'Ακυρώθηκε',
    ],
    'theme_options' => [
        'name' => 'Ενοικιάσεις Αυτοκινήτων',
        'description' => 'Επιλογές θέματος για ενοικιάσεις αυτοκινήτων',
        'car_location_filter_by' => 'Φιλτράρισμα τοποθεσίας αυτοκινήτου ανά',
        'state' => 'Περιοχή',
        'city' => 'Πόλη',
        'yes' => 'Ναι',
        'no' => 'Όχι',
        'is_display_country' => 'Εμφάνιση χώρας στο φίλτρο τοποθεσίας;',
        'logo_vendor_dashboard' => 'Λογότυπο στον πίνακα ελέγχου προμηθευτή (Προεπιλογή είναι το κύριο λογότυπο)',
        'number_of_cars_per_page' => 'Αριθμός αυτοκινήτων ανά σελίδα',
        'number_of_cars_per_page_placeholder' => 'Εισαγάγετε αριθμό αυτοκινήτων προς εμφάνιση ανά σελίδα',
    ],
    'message' => [
        'name' => 'Μηνύματα',
        'forms' => [
            'customer_name' => 'Όνομα πελάτη',
            'message' => 'Μήνυμα',
            'phone' => 'Τηλέφωνο',
            'email' => 'Email',
            'created_at' => 'Δημιουργήθηκε στις',
            'status' => 'Κατάσταση',
        ],
    ],
    'car_sale' => [
        'name' => 'Πωλήσεις Αυτοκινήτων',
        'create' => 'Νέα Πώληση Αυτοκινήτου',
        'edit' => 'Επεξεργασία Πώλησης Αυτοκινήτου :name',
        'statuses' => [
            'pending' => 'Εκκρεμεί',
            'processing' => 'Σε Επεξεργασία',
            'completed' => 'Ολοκληρώθηκε',
            'cancelled' => 'Ακυρώθηκε',
        ],
        'forms' => [
            'transaction_id' => 'Κωδικός Συναλλαγής',
            'transaction_id_placeholder' => 'Εισαγάγετε κωδικό συναλλαγής',
            'car_id' => 'Αυτοκίνητο',
            'car' => 'Αυτοκίνητο',
            'customer_id' => 'Πελάτης',
            'customer_name' => 'Όνομα Πελάτη',
            'customer_name_placeholder' => 'Εισαγάγετε όνομα πελάτη',
            'customer_email' => 'Email Πελάτη',
            'customer_email_placeholder' => 'Εισαγάγετε email πελάτη',
            'customer_phone' => 'Τηλέφωνο Πελάτη',
            'customer_phone_placeholder' => 'Εισαγάγετε τηλέφωνο πελάτη',
            'sale_price' => 'Τιμή Πώλησης',
            'sale_price_placeholder' => 'Εισαγάγετε τιμή πώλησης',
            'tax_amount' => 'Ποσό Φόρου',
            'tax_amount_placeholder' => 'Εισαγάγετε ποσό φόρου',
            'total_amount' => 'Συνολικό Ποσό',
            'total_amount_placeholder' => 'Εισαγάγετε συνολικό ποσό',
            'payment_details' => 'Λεπτομέρειες Πληρωμής',
            'payment_details_placeholder' => 'Εισαγάγετε λεπτομέρειες πληρωμής',
            'notes' => 'Σημειώσεις',
            'notes_placeholder' => 'Εισαγάγετε σημειώσεις',
            'sale_date' => 'Ημερομηνία Πώλησης',
            'delivery_date' => 'Ημερομηνία Παράδοσης',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Τραπεζική Μεταφορά',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Επιβεβαίωση Κράτησης Ενοικίασης Αυτοκινήτου',
        'booking_confirm_greeting' => 'Αγαπητέ/ή :customer_name,',
        'booking_confirm_message' => 'Είμαστε στην ευχάριστη θέση να σας ενημερώσουμε ότι η κράτησή σας για ενοικίαση αυτοκινήτου έχει επιβεβαιωθεί με επιτυχία!',
        'customer_information' => 'Πληροφορίες Πελάτη',
        'booking_information' => 'Πληροφορίες Κράτησης',
        'field_name' => 'Όνομα:',
        'field_phone' => 'Τηλέφωνο:',
        'field_email' => 'Email:',
        'field_car_model' => 'Μοντέλο Αυτοκινήτου:',
        'field_start_date' => 'Ημερομηνία Έναρξης:',
        'field_end_date' => 'Ημερομηνία Λήξης:',
        'field_pickup_address' => 'Διεύθυνση Παραλαβής:',
        'field_return_address' => 'Διεύθυνση Επιστροφής:',
        'field_note' => 'Σημείωση:',
        'field_order_number' => 'Αριθμός παραγγελίας',
        'field_payment_method' => 'Τρόπος Πληρωμής',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Ειδοποίηση Νέας Κράτησης',
        'booking_notice_admin_greeting' => 'Γεια σας, υπάρχει μια νέα κράτηση από :site_title:',
        'booking_notice_admin_message' => 'Μια νέα κράτηση ενοικίασης αυτοκινήτου έχει υποβληθεί και απαιτεί την προσοχή σας.',
        'booking_view_detail' => 'Προβολή λεπτομερειών κράτησης:',
        'view_booking_details' => 'Προβολή Λεπτομερειών Κράτησης',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Νέα Κράτηση για το Αυτοκίνητό Σας',
        'booking_notice_vendor_greeting' => 'Αγαπητέ/ή :vendor_name,',
        'booking_notice_vendor_message' => 'Εξαιρετικά νέα! Έχετε λάβει μια νέα κράτηση για το αυτοκίνητό σας προς ενοικίαση.',

        // Booking status changed email
        'booking_status_updated' => 'Η Κατάσταση Κράτησης Ενημερώθηκε',
        'hello_thanks_for_booking' => 'Γεια σας, Ευχαριστούμε για την κράτηση δωματίων από :site_title:',
        'booking_status_change_message' => 'Ελπίζουμε να σας βρίσκει καλά αυτό το μήνυμα. Θέλαμε να σας ενημερώσουμε ότι η κατάσταση της κράτησής σας έχει ενημερωθεί.',
        'name' => 'Όνομα',
        'phone' => 'Τηλέφωνο',
        'email' => 'Email',
        'car_model' => 'Μοντέλο Αυτοκινήτου',
        'start_date' => 'Ημερομηνία Έναρξης',
        'end_date' => 'Ημερομηνία Λήξης',
        'pickup_address' => 'Διεύθυνση Παραλαβής',
        'return_address' => 'Διεύθυνση Επιστροφής',
        'note' => 'Σημείωση',
        'order_number' => 'Αριθμός παραγγελίας',
        'payment_method' => 'Τρόπος Πληρωμής',

        // Car approved email
        'hello' => 'Γεια σας',
        'car_approved_title' => 'Εξαιρετικά Νέα! Το Αυτοκίνητό Σας Εγκρίθηκε',
        'car_approved_message' => 'Είμαστε στην ευχάριστη θέση να σας ενημερώσουμε ότι η καταχώρηση του αυτοκινήτου σας ":car_name" έχει εγκριθεί και είναι πλέον ζωντανή στο :site_title. Μπορείτε να αρχίσετε να λαμβάνετε κρατήσεις και να διαχειρίζεστε την καταχώρησή σας αμέσως.',
        'view_edit_car_link' => 'Για να δείτε ή να επεξεργαστείτε την καταχώρηση του αυτοκινήτου σας, παρακαλώ κάντε κλικ σε αυτόν τον σύνδεσμο',
        'view_car' => 'Προβολή Καταχώρησης Αυτοκινήτου',
        'regards' => 'Με εκτίμηση',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Συγχαρητήρια! Είστε Πλέον Προμηθευτής',
        'vendor_upgrade_congratulations' => 'Είμαστε ενθουσιασμένοι να σας ενημερώσουμε ότι ο λογαριασμός σας έχει αναβαθμιστεί με επιτυχία σε κατάσταση προμηθευτή!',
        'vendor_upgrade_message' => 'Μπορείτε πλέον να καταχωρήσετε και να διαχειριστείτε τα δικά σας αυτοκίνητα στο :site_title. Αυτό ανοίγει νέες ευκαιρίες για να αναπτύξετε την επιχείρησή σας ενοικίασης μαζί μας.',
        'vendor_benefits_title' => 'Τα Νέα Σας Οφέλη ως Προμηθευτής',
        'vendor_benefit_1' => 'Καταχώρηση απεριόριστων αυτοκινήτων προς ενοικίαση',
        'vendor_benefit_2' => 'Διαχείριση των δικών σας κρατήσεων και πελατών',
        'vendor_benefit_3' => 'Παρακολούθηση εσόδων και μετρήσεων απόδοσης',
        'vendor_benefit_4' => 'Πρόσβαση σε αποκλειστικές λειτουργίες και εργαλεία προμηθευτών',
        'next_steps' => 'Επόμενα Βήματα',
        'vendor_next_steps_message' => 'Συνδεθείτε στον πίνακα ελέγχου προμηθευτή σας για να αρχίσετε να προσθέτετε τα αυτοκίνητά σας και να διαχειρίζεστε την επιχείρησή σας ενοικίασης.',
        'go_to_dashboard' => 'Μετάβαση στον Πίνακα Ελέγχου Προμηθευτή',
        'vendor_support_message' => 'Εάν έχετε οποιεσδήποτε ερωτήσεις ή χρειάζεστε βοήθεια, η ομάδα υποστήριξής μας είναι εδώ για να σας βοηθήσει να ξεκινήσετε.',
        'approved' => 'Εγκρίθηκε',

        // Car rejected email
        'car_rejected_title' => 'Απαιτείται Ενημέρωση για την Καταχώρηση του Αυτοκινήτου Σας',
        'car_rejected_message' => 'Σας ευχαριστούμε που υποβάλατε την καταχώρηση του αυτοκινήτου σας ":car_name" στο :site_title. Μετά την επανεξέταση της υποβολής σας, χρειαζόμαστε να κάνετε ορισμένες προσαρμογές πριν μπορέσουμε να την εγκρίνουμε.',
        'rejection_reason' => 'Αυτό που χρειάζεται να ενημερωθεί',
        'rejection_details' => 'Απαιτούμενες Ενημερώσεις',
        'contact_support' => 'Εάν έχετε οποιεσδήποτε ερωτήσεις ή χρειάζεστε βοήθεια με αυτές τις ενημερώσεις, μη διστάσετε να επικοινωνήσετε με την ομάδα υποστήριξής μας στο :site_email. Είμαστε εδώ για να σας βοηθήσουμε να εγκρίνετε την καταχώρησή σας γρήγορα.',

        // Confirm email
        'verify_email' => 'Επαλήθευση Email',
        'welcome_message' => 'Χαιρόμαστε που σας έχουμε εδώ, :customer_name!',
        'verify_email_instruction' => 'Παρακαλώ επαληθεύστε τη διεύθυνση email σας για να αποκτήσετε πρόσβαση σε αυτόν τον ιστότοπο. Κάντε κλικ στο κουμπί παρακάτω για να επαληθεύσετε το email σας.',
        'confirm_email_button' => 'Επιβεβαιώστε τη διεύθυνση email σας',
        'verify_link_trouble' => 'Εάν αντιμετωπίζετε πρόβλημα με το κλικ στο κουμπί \'Επιβεβαιώστε τη διεύθυνση email σας\', αντιγράψτε και επικολλήστε τη διεύθυνση URL παρακάτω στο πρόγραμμα περιήγησης ιστού σας: :verify_link και επικολλήστε την στο πρόγραμμα περιήγησής σας.',

        // Message email
        'new_message' => 'Νέο Μήνυμα',
        'dear_admin' => 'Αγαπητέ Διαχειριστή',
        'new_message_from' => 'Υπάρχει ένα νέο μήνυμα από :site_title:',
        'subject' => 'Θέμα',
        'address' => 'Διεύθυνση',
        'content' => 'Περιεχόμενο',

        // New pending car email
        'hi_admin' => 'Γεια σας Διαχειριστή,',
        'new_car_pending_title' => 'Νέα Καταχώρηση Αυτοκινήτου Αναμένει Επανεξέταση',
        'new_car_pending_approval' => 'Μια νέα καταχώρηση αυτοκινήτου ":post_name" έχει υποβληθεί από :post_author και είναι έτοιμη για την επανεξέτασή σας.',
        'pending_approval' => 'Αναμένει Επανεξέταση',
        'review_car_admin' => 'Παρακαλώ επανεξετάστε αυτή την καταχώρηση στον πίνακα διαχείρισης και εγκρίνετε ή ζητήστε ενημερώσεις όπως χρειάζεται.',

        // Common fields
        'car_information' => 'Πληροφορίες Αυτοκινήτου',
        'field_car_name' => 'Όνομα Αυτοκινήτου:',
        'field_author' => 'Συγγραφέας:',
        'field_status' => 'Κατάσταση:',
        'actions' => 'Ενέργειες',

        // Password reminder email
        'reset_password_instruction' => 'Οδηγίες Επαναφοράς Κωδικού',
        'password_reset_request' => 'Λαμβάνετε αυτό το email επειδή λάβαμε αίτημα επαναφοράς κωδικού για τον λογαριασμό σας.',
        'reset_password_button' => 'Επαναφορά κωδικού',
        'reset_link_trouble' => 'Εάν αντιμετωπίζετε πρόβλημα με το κλικ στο κουμπί \'Επαναφορά Κωδικού\', αντιγράψτε και επικολλήστε τη διεύθυνση URL παρακάτω στο πρόγραμμα περιήγησης ιστού σας: :reset_link και επικολλήστε την στο πρόγραμμα περιήγησής σας. Εάν δεν ζητήσατε επαναφορά κωδικού, παρακαλώ αγνοήστε αυτό το μήνυμα ή επικοινωνήστε μαζί μας εάν έχετε ερωτήσεις.',
    ],
];
