<?php

return [
    'name' => 'Alquiler de Coches',
    'customer' => [
        'name' => 'Clientes',
        'create' => 'Crear Cliente',
        'forms' => [
            'name' => 'Nombre',
            'email' => 'Correo electrónico',
            'phone' => 'Teléfono',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Avatar',
            'dob' => 'Fecha de nacimiento',
            'company' => 'Empresa',
            'position' => 'Cargo',
            'password' => 'Contraseña',
            'password_confirmation' => 'Confirmación de contraseña',
            'change_password' => '¿Cambiar contraseña?',
            'phone_placeholder' => 'Teléfono',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
        'view' => 'Ver',
        'information' => 'Información del Cliente',
        'email' => 'Email',
        'phone' => 'Teléfono',
        'status' => 'Estado',
        'vendor_status' => 'Estado del Vendedor',
        'is_vendor' => 'Vendedor',
        'not_vendor' => 'Cliente',
        'recent_activity' => 'Actividad Reciente',
        'recent_activity_description' => 'La actividad del cliente aparecerá aquí.',
        'verification_section' => 'Verificación del Cliente',
        'verified' => 'Verificado',
        'not_verified' => 'No Verificado',
        'verified_by' => 'Verificado Por',
        'verified_at' => 'Verificado el',
        'verify_customer' => 'Verificar Cliente',
        'unverify_customer' => 'Desverificar Cliente',
        'verify_customer_confirmation' => 'Confirmación de Verificación de Cliente',
        'verify_customer_confirmation_desc' => '¿Estás seguro de que quieres verificar a :name? Esto mostrará una insignia de verificado en su perfil.',
        'unverify_customer_confirmation' => 'Confirmación de Desverificación de Cliente',
        'unverify_customer_confirmation_desc' => '¿Estás seguro de que quieres remover la verificación de :name? La insignia de verificado será removida.',
        'verify_success' => 'El cliente :name ha sido verificado con éxito.',
        'unverify_success' => 'La verificación del cliente :name ha sido removida con éxito.',
        'already_verified' => 'Este cliente ya está verificado.',
        'already_unverified' => 'Este cliente no está verificado.',
        'upgrade_to_vendor_title' => 'Promover a Vendedor',
        'upgrade_to_vendor_description' => 'Promueva este cliente al estado de vendedor para permitirle listar y gestionar sus propios alquileres de coches.',
        'upgrade_to_vendor_button' => 'Promover a Vendedor',
        'upgrade_to_vendor_confirmation' => 'Confirmar Promoción a Vendedor',
        'upgrade_to_vendor_confirmation_desc' => '¿Estás seguro de que quieres promover a :name al estado de vendedor? Esto le permitirá listar y gestionar sus propios coches en la plataforma.',
        'upgrade_to_vendor_success' => ':name ha sido promovido con éxito al estado de vendedor.',
        'already_vendor' => 'Este cliente ya es un vendedor.',
        'email_verified' => 'Email Verificado',
        'email_not_verified' => 'Email No Verificado',
        'verify_email_warning_message' => 'La dirección de correo electrónico de este cliente no ha sido verificada. Puedes verificarla manualmente para confirmar que su email es válido.',
        'verify_email_title' => 'Verificar Dirección de Correo Electrónico',
        'verify_email_description' => 'La dirección de correo electrónico de este cliente no ha sido verificada. Puedes verificarla manualmente para confirmar que su email es válido.',
        'verify_email_button' => 'Verificar Email',
        'verify_email_confirmation' => 'Confirmar Verificación de Email',
        'verify_email_confirmation_desc' => '¿Estás seguro de que quieres verificar la dirección de correo electrónico :email para :name? Esto marcará su email como confirmado.',
        'verify_email_success' => 'El email :email ha sido verificado con éxito para :name.',
        'email_already_verified' => 'Esta dirección de correo electrónico ya está verificada.',
        'resend_confirmation_button' => 'Reenviar Email de Confirmación',
        'resend_confirmation_title' => 'Reenviar Email de Confirmación',
        'resend_confirmation_desc' => '¿Estás seguro de que quieres reenviar el email de confirmación a :email para :name? Esto enviará un nuevo enlace de verificación a su dirección de correo electrónico.',
        'resend_confirmation_success' => 'El email de confirmación ha sido enviado a :email.',
        'resend_confirmation_error' => 'Error al enviar el email de confirmación. Por favor, inténtalo de nuevo.',
        'customer_verified_successfully' => 'Este cliente ha sido verificado y es confiable.',
        'customer_not_verified_yet' => 'Este cliente aún no ha sido verificado.',
        'verification_pending' => 'Verificación Pendiente',
        'click_verify_to_approve' => 'Haz clic en el botón de abajo para verificar a este cliente y mostrar la insignia de verificado.',
        'verification_note' => 'Nota de Verificación',
        'verification_note_placeholder' => 'Ingresa cualquier nota sobre esta acción de verificación...',
        'verification_note_helper' => 'Agregar notas sobre el proceso de verificación (solo uso interno)',
    ],
    'vendor' => [
        'name' => 'Vendedores',
        'view' => 'Ver :name',
        'information' => 'Información del Vendedor',
        'total_cars' => 'Total de Coches',
        'total_bookings' => 'Total de Reservas',
        'verified' => 'Verificado',
        'not_verified' => 'No Verificado',
        'verification_section' => 'Verificación del Vendedor',
        'vendor_verified_successfully' => 'Este vendedor ha sido verificado y es confiable.',
        'vendor_not_verified_yet' => 'Este vendedor aún no ha sido verificado.',
        'verification_pending' => 'Verificación Pendiente',
        'click_verify_to_approve' => 'Haz clic en el botón de abajo para verificar a este vendedor y mostrar la insignia de verificado.',
        'verify_vendor' => 'Verificar Vendedor',
        'unverify_vendor' => 'Desverificar Vendedor',
        'verify_vendor_confirmation' => 'Confirmación de Verificación de Vendedor',
        'verify_vendor_confirmation_desc' => '¿Estás seguro de que quieres verificar a :name? Esto mostrará una insignia de verificado en su perfil.',
        'unverify_vendor_confirmation' => 'Confirmación de Desverificación de Vendedor',
        'unverify_vendor_confirmation_desc' => '¿Estás seguro de que quieres remover la verificación de :name? La insignia de verificado será removida.',
        'verified_successfully' => 'El vendedor ha sido verificado con éxito.',
        'unverified_successfully' => 'La verificación del vendedor ha sido removida con éxito.',
        'already_verified' => 'Este vendedor ya está verificado.',
        'not_verified_yet' => 'Este vendedor aún no está verificado.',
        'recent_activity' => 'Actividad Reciente',
        'recent_cars' => 'Coches Recientes',
        'recent_bookings' => 'Reservas Recientes',
        'no_cars_yet' => 'Aún no se han agregado coches.',
        'no_bookings_yet' => 'Aún no se han recibido reservas.',
    ],
    'make' => [
        'name' => 'Marcas',
        'create' => 'Crear Marca de Coche',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Oscuro',
        ],
    ],
    'car' => [
        'name' => 'Coches',
        'create' => 'Crear Coche',
        'forms' => [
            'car' => 'Coche',
            'logo' => 'Logo',
            'license_plate' => 'Matrícula',
            'make' => 'Marca',
            'model' => 'Modelo',
            'name' => 'Nombre',
            'images' => 'Imágenes',
            'year' => 'Año',
            'color' => 'Color',
            'mileage' => 'Kilometraje',
            'vehicle_type' => 'Tipo de vehículo',
            'transmission' => 'Transmisión',
            'fuel_type' => 'Tipo de combustible',
            'rental_rate' => 'Tarifa de alquiler',
            'status' => 'Estado',
            'availability' => 'Disponibilidad',
            'insurance_info' => 'Información del seguro',
            'number_of_seats' => 'Número de asientos',
            'number_of_doors' => 'Número de puertas',
            'vin' => 'VIN',
            'maintenance_history' => 'Historial de mantenimiento',
            'location' => 'Ubicación',
            'description' => 'Descripción',
            'rental_type' => 'Tipo de alquiler',
            'tags' => 'Etiquetas',
        ],
        'placeholders' => [
            'name' => 'Ingrese el nombre del vehículo (ej., Toyota Camry 2023, Honda CR-V, etc.)',
            'description' => 'Ingrese una breve descripción del vehículo destacando características clave',
            'rental_rate' => 'Ingrese la tarifa de alquiler según el tipo de alquiler seleccionado',
            'location' => 'Ingrese la ubicación física del vehículo',
            'sale_price' => 'Ingrese el precio de venta de este vehículo',
            'ownership_history' => 'Ingrese detalles sobre propietarios anteriores, número de propietarios, etc.',
            'warranty_information' => 'Ingrese detalles sobre la cobertura de garantía, fecha de vencimiento, etc.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Ingrese el número de matrícula del vehículo',
            'vin' => 'Ingrese el Número de Identificación del Vehículo (VIN)',
        ],
        'enums' => [
            'statuses' => [
                'available' => 'Disponible',
                'rented' => 'Alquilado',
                'maintenance' => 'Mantenimiento',
                'out_of_service' => 'Fuera de servicio',
            ],
            'rental_types' => [
                'per_hour' => 'Por hora',
                'per_day' => 'Por día',
                'per_week' => 'Por semana',
                'per_month' => 'Por mes',
            ],
            'moderation_statuses' => [
                'pending' => 'Pendiente',
                'approved' => 'Aprobado',
                'rejected' => 'Rechazado',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atributos de Coche',
        'car_type' => [
            'name' => 'Tipos',
            'create' => 'Crear Tipo de Coche',
            'forms' => [
                'name' => 'Nombre',
            ],
        ],
        'transmission' => [
            'name' => 'Transmisiones',
            'create' => 'Crear Transmisión',
            'forms' => [
                'name' => 'Nombre',
            ],
        ],
        'fuel_type' => [
            'name' => 'Combustibles',
            'create' => 'Crear Tipos de Combustible',
            'forms' => [
                'name' => 'Nombre',
            ],
        ],
        'tag' => [
            'name' => 'Etiquetas',
            'create' => 'Crear Etiqueta',
        ],
        'category' => [
            'name' => 'Categorías',
            'create' => 'Crear Categoría',
            'forms' => [
                'none' => 'Ninguno',
                'total_cars' => 'Total de coches: :total',
            ],
        ],
        'address' => [
            'name' => 'Ubicaciones',
            'create' => 'Crear Ubicación de Coche',
            'form' => [
                'name' => 'Dirección',
                'full_address' => 'Dirección completa',
                'detail_address' => 'Dirección detallada',
            ],
        ],
    ],
    'review' => [
        'name' => 'Reseñas',
        'create' => 'Crear Reseña',
        'edit' => 'Editar Reseña',
        'vendor' => [
            'title' => 'Reseñas de Clientes',
            'description' => 'Gestionar todas las reseñas de clientes para tus coches',
            'no_reviews' => 'Aún no tienes reseñas',
            'filter_by_car' => 'Filtrar por coche',
            'filter_by_rating' => 'Filtrar por calificación',
            'filter_by_date' => 'Filtrar por fecha',
            'all_cars' => 'Todos los Coches',
            'all_ratings' => 'Todas las Calificaciones',
            'manage_reviews' => 'Gestionar Reseñas',
            'view_all' => 'Ver Todas las Reseñas',
            'delete_review_confirmation' => '¿Estás seguro de que quieres eliminar esta reseña?',
            'delete_review_success' => 'Reseña eliminada con éxito',
            'cannot_delete' => 'No se puede eliminar esta reseña',
        ],
        'forms' => [
            'customer' => 'Cliente',
            'car' => 'Coche',
            'content' => 'Contenido',
            'rating' => 'Calificación',
            'your_name' => 'Tu Nombre',
            'email_address' => 'Dirección de Correo Electrónico',
            'submit' => 'Enviar',
            'star' => 'Estrella',
            'status' => 'Estado',
            'created_at' => 'Creado el',
            'select_car' => 'Seleccionar Coche',
            'select_rating' => 'Seleccionar Calificación',
            'comment' => 'Comentario',
            'reply' => 'Responder',
            'reply_to_review' => 'Responder a la Reseña',
            'save_reply' => 'Guardar Respuesta',
            'cancel_reply' => 'Cancelar',
        ],
        'statuses' => [
            'published' => 'Publicado',
            'pending' => 'Pendiente',
            'rejected' => 'Rechazado',
        ],
        'ratings' => [
            1 => '1 Estrella - Malo',
            '2 Estrellas - Regular',
            '3 Estrellas - Bueno',
            '4 Estrellas - Muy Bueno',
            '5 Estrellas - Excelente',
        ],
    ],
    'coupon' => [
        'name' => 'Cupones',
        'create' => 'Crear Cupón',
        'types' => [
            'percentage' => 'Porcentaje %',
            'money' => 'Dinero',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'Servicios',
        'create' => 'Crear Servicio',
        'forms' => [
            'name' => 'Nombre',
            'content' => 'Contenido',
            'price' => 'Precio',
            'image' => 'Imagen',
            'logo' => 'Logo',
            'status' => 'Estado',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Calendario de Disponibilidad de Coches',
        'title' => 'Calendario de Disponibilidad de Coches',
        'description' => 'Ver disponibilidad de coches y reservas en formato calendario',
        'select_dates' => 'Selecciona fechas para verificar disponibilidad',
        'car_filter' => 'Filtrar por Coche',
        'all_cars' => 'Todos los Coches',
        'clear_filter' => 'Limpiar Filtro',
        'availability_check' => 'Verificación de Disponibilidad de Coches',
        'selected_period' => 'Período Seleccionado',
        'checking_availability' => 'Verificando disponibilidad...',
        'available' => 'Disponible',
        'not_available' => 'No Disponible',
        'booking_details' => 'Detalles de la Reserva',
        'how_to_use' => 'Cómo usar el Calendario de Disponibilidad de Coches',
        'viewing_bookings' => 'Viendo Reservas',
        'checking_availability_help' => 'Verificando Disponibilidad',
        'color_legend' => 'Leyenda de Colores',
        'pending_bookings' => 'Reservas Pendientes',
        'processing_bookings' => 'Reservas en Proceso',
        'completed_bookings' => 'Reservas Completadas',
        'cancelled_bookings' => 'Reservas Canceladas',
        'unknown_make' => 'Marca Desconocida',
        'loading' => 'Cargando...',
        'loading_calendar_data' => 'Cargando datos del calendario...',
        'loading_booking_details' => 'Cargando detalles de la reserva...',
        'please_wait_booking_info' => 'Por favor espera mientras obtenemos la información de la reserva.',
        'please_wait_availability' => 'Por favor espera mientras verificamos la disponibilidad de coches para tus fechas seleccionadas.',
        'error' => 'Error',
        'error_loading_booking' => 'Error al cargar los detalles de la reserva. Por favor inténtalo de nuevo.',
        'error_checking_availability' => 'Error al verificar la disponibilidad de coches',
        'customer' => 'Cliente',
        'status' => 'Estado',
        'amount' => 'Cantidad',
        'make' => 'Marca',
        'vendor' => 'Vendedor',
        'per_day' => '/día',
        'edit_car' => 'Editar Coche',
        'no_cars_found' => 'No se encontraron coches',
        'no_cars_available_period' => 'No hay coches disponibles para el período seleccionado.',
        'close' => 'Cerrar',
        'edit_booking' => 'Editar Reserva',
        'pending' => 'Pendiente',
        'processing' => 'Procesando',
        'completed' => 'Completado',
        'cancelled' => 'Cancelado',
    ],
    'theme_options' => [
        'name' => 'Alquiler de Coches',
        'description' => 'Opciones de tema para alquiler de coches',
        'car_location_filter_by' => 'Filtrar ubicación de coche por',
        'state' => 'Estado',
        'city' => 'Ciudad',
        'yes' => 'Sí',
        'no' => 'No',
        'is_display_country' => '¿Mostrar país en el filtro de ubicación?',
        'logo_vendor_dashboard' => 'Logo en el panel de vendedor (Por defecto es el logo principal)',
    ],
    'message' => [
        'name' => 'Mensajes',
        'forms' => [
            'customer_name' => 'Nombre del cliente',
            'message' => 'Mensaje',
            'phone' => 'Teléfono',
            'email' => 'Correo electrónico',
            'created_at' => 'Creado el',
            'status' => 'Estado',
        ],
    ],
    'car_sale' => [
        'name' => 'Ventas de Coches',
        'create' => 'Nueva Venta de Coche',
        'edit' => 'Editar Venta de Coche :name',
        'statuses' => [
            'pending' => 'Pendiente',
            'processing' => 'Procesando',
            'completed' => 'Completado',
            'cancelled' => 'Cancelado',
        ],
    ],
    'email_templates' => [
        'booking_notice_admin_title' => 'Notificación de Nueva Reserva',
        'booking_notice_admin_greeting' => 'Hola, hay una nueva reserva de :site_title:',
        'booking_notice_admin_message' => 'Se ha enviado una nueva reserva de alquiler de coche y requiere su atención.',
        'booking_view_detail' => 'Ver detalles de la reserva:',
        'view_booking_details' => 'Ver Detalles de la Reserva',
        'booking_notice_vendor_title' => 'Nueva Reserva para Tu Coche',
        'booking_notice_vendor_greeting' => 'Estimado :vendor_name,',
        'booking_notice_vendor_message' => '¡Excelentes noticias! Has recibido una nueva reserva para tu alquiler de coche.',
        'hello' => 'Hola',
        'car_approved_title' => '¡Excelentes noticias! Tu coche ha sido aprobado',
        'car_approved_message' => 'Nos complace informarte que tu anuncio de coche ":car_name" ha sido aprobado y ya está disponible en :site_title. Puedes comenzar a recibir reservas y gestionar tu anuncio de inmediato.',
        'view_edit_car_link' => 'Para ver o editar tu anuncio de coche, por favor haz clic en este enlace',
        'view_car' => 'Ver Anuncio del Coche',
        'regards' => 'Saludos cordiales',
        'approved' => 'Aprobado',
        'car_rejected_title' => 'Actualización requerida para tu anuncio de coche',
        'car_rejected_message' => 'Gracias por enviar tu anuncio de coche ":car_name" a :site_title. Después de revisar tu envío, necesitamos que hagas algunos ajustes antes de que podamos aprobarlo.',
        'rejection_reason' => 'Esto es lo que necesita ser actualizado',
        'rejection_details' => 'Actualizaciones Requeridas',
        'contact_support' => 'Si tienes alguna pregunta o necesitas ayuda con estas actualizaciones, no dudes en contactar a nuestro equipo de soporte en :site_email. Estamos aquí para ayudarte a que tu anuncio sea aprobado rápidamente.',
        'hi_admin' => 'Hola Administrador,',
        'new_car_pending_title' => 'Nuevo Anuncio de Coche Esperando Revisión',
        'new_car_pending_approval' => 'Un nuevo anuncio de coche ":post_name" ha sido enviado por :post_author y está listo para tu revisión.',
        'pending_approval' => 'Esperando Revisión',
        'review_car_admin' => 'Por favor revisa este anuncio en el panel de administración y apruébalo o solicita actualizaciones según sea necesario.',
        'car_information' => 'Información del Coche',
        'field_car_name' => 'Nombre del Coche:',
        'field_author' => 'Autor:',
        'field_status' => 'Estado:',
        'actions' => 'Acciones',
        'reset_password_instruction' => 'Instrucciones para Restablecer Contraseña',
        'password_reset_request' => 'Estás recibiendo este correo electrónico porque recibimos una solicitud de restablecimiento de contraseña para tu cuenta.',
        'reset_password_button' => 'Restablecer contraseña',
        'reset_link_trouble' => 'Si tienes problemas haciendo clic en el botón \'Restablecer Contraseña\', copia y pega la URL de abajo en tu navegador web: :reset_link y pégala en tu navegador. Si no solicitaste un restablecimiento de contraseña, por favor ignora este mensaje o contáctanos si tienes alguna pregunta.',
    ],
];
