<?php

return [
    'name' => 'Autovuokraus',
    'customer' => [
        'name' => 'Asiakkaat',
        'create' => 'Luo asiakas',
        'view' => 'Näytä',
        'information' => 'Asiakkaan tiedot',
        'email' => 'Sähköposti',
        'phone' => 'Puhelin',
        'status' => 'Tila',
        'vendor_status' => 'Myyjän tila',
        'is_vendor' => 'Myyjä',
        'not_vendor' => 'Asiakas',
        'recent_activity' => 'Viimeaikainen toiminta',
        'recent_activity_description' => 'Asiakkaan toiminta näkyy täällä.',
        'verification_section' => 'Asiakkaan vahvistus',
        'verified' => 'Vahvistettu',
        'not_verified' => 'Ei vahvistettu',
        'verified_by' => 'Vahvistanut',
        'verified_at' => 'Vahvistettu',
        'verify_customer' => 'Vahvista asiakas',
        'unverify_customer' => 'Poista vahvistus',
        'verify_customer_confirmation' => 'Vahvista asiakkaan vahvistus',
        'verify_customer_confirmation_desc' => 'Haluatko varmasti vahvistaa asiakkaan :name? Tämä näyttää vahvistetun merkin heidän profiilissaan.',
        'unverify_customer_confirmation' => 'Poista asiakkaan vahvistus',
        'unverify_customer_confirmation_desc' => 'Haluatko varmasti poistaa vahvistuksen asiakkaalta :name? Vahvistettu merkki poistetaan.',
        'verify_success' => 'Asiakas :name on vahvistettu onnistuneesti.',
        'unverify_success' => 'Asiakkaan :name vahvistus on poistettu onnistuneesti.',
        'already_verified' => 'Tämä asiakas on jo vahvistettu.',
        'already_unverified' => 'Tätä asiakasta ei ole vahvistettu.',
        'upgrade_to_vendor_title' => 'Päivitä myyjäksi',
        'upgrade_to_vendor_description' => 'Päivitä tämä asiakas myyjäksi, jotta he voivat listata ja hallita omia autovuokrauksiaan.',
        'upgrade_to_vendor_button' => 'Päivitä myyjäksi',
        'upgrade_to_vendor_confirmation' => 'Vahvista päivitys myyjäksi',
        'upgrade_to_vendor_confirmation_desc' => 'Haluatko varmasti päivittää asiakkaan :name myyjäksi? Tämä sallii heidän listata ja hallita omia autojaan alustalla.',
        'upgrade_to_vendor_success' => ':name on päivitetty onnistuneesti myyjäksi.',
        'already_vendor' => 'Tämä asiakas on jo myyjä.',
        'customer_verified_successfully' => 'Tämä asiakas on vahvistettu ja luotettava.',
        'customer_not_verified_yet' => 'Tätä asiakasta ei ole vielä vahvistettu.',
        'verification_pending' => 'Vahvistus odottaa',
        'click_verify_to_approve' => 'Klikkaa alla olevaa painiketta vahvistaaksesi tämän asiakkaan ja näyttääksesi vahvistetun merkin.',
        'verification_note' => 'Vahvistushuomautus',
        'verification_note_placeholder' => 'Kirjoita huomautuksia tästä vahvistustoiminnosta...',
        'verification_note_helper' => 'Lisää huomautuksia vahvistusprosessista (vain sisäiseen käyttöön)',
        'forms' => [
            'name' => 'Nimi',
            'email' => 'Sähköposti',
            'phone' => 'Puhelin',
            'avatar' => 'Avatar',
            'dob' => 'Syntymäpäivä',
            'company' => 'Yritys',
            'position' => 'Asema',
            'password' => 'Salasana',
            'password_confirmation' => 'Salasanan vahvistus',
            'change_password' => 'Vaihda salasana?',
            'phone_placeholder' => 'Puhelin',
        ],
    ],
    'vendor' => [
        'name' => 'Myyjät',
        'view' => 'Näytä :name',
        'information' => 'Myyjän tiedot',
        'total_cars' => 'Autoja yhteensä',
        'total_bookings' => 'Varauksia yhteensä',
        'verified' => 'Vahvistettu',
        'not_verified' => 'Ei vahvistettu',
        'verification_section' => 'Myyjän vahvistus',
        'vendor_verified_successfully' => 'Tämä myyjä on vahvistettu ja luotettava.',
        'vendor_not_verified_yet' => 'Tätä myyjää ei ole vielä vahvistettu.',
        'verification_pending' => 'Vahvistus odottaa',
        'click_verify_to_approve' => 'Klikkaa alla olevaa painiketta vahvistaaksesi tämän myyjän ja näyttääksesi vahvistetun merkin.',
        'verify_vendor' => 'Vahvista myyjä',
        'unverify_vendor' => 'Poista myyjän vahvistus',
        'verify_vendor_confirmation' => 'Vahvista myyjän vahvistus',
        'verify_vendor_confirmation_desc' => 'Haluatko varmasti vahvistaa myyjän :name? Tämä näyttää vahvistetun merkin heidän profiilissaan.',
        'unverify_vendor_confirmation' => 'Poista myyjän vahvistus',
        'unverify_vendor_confirmation_desc' => 'Haluatko varmasti poistaa vahvistuksen myyjältä :name? Vahvistettu merkki poistetaan.',
        'verified_successfully' => 'Myyjä on vahvistettu onnistuneesti.',
        'unverified_successfully' => 'Myyjän vahvistus on poistettu onnistuneesti.',
        'already_verified' => 'Tämä myyjä on jo vahvistettu.',
        'not_verified_yet' => 'Tätä myyjää ei ole vielä vahvistettu.',
        'recent_activity' => 'Viimeaikainen toiminta',
        'recent_cars' => 'Viimeisimmät autot',
        'recent_bookings' => 'Viimeisimmät varaukset',
        'no_cars_yet' => 'Autoja ei ole vielä lisätty.',
        'no_bookings_yet' => 'Varauksia ei ole vielä vastaanotettu.',
    ],
    'make' => [
        'name' => 'Merkit',
        'create' => 'Luo autom merkki',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Tumma logo',
        ],
    ],
    'car' => [
        'name' => 'Autot',
        'create' => 'Luo auto',
        'forms' => [
            'car' => 'Auto',
            'logo' => 'Logo',
            'license_plate' => 'Rekisterikilpi',
            'make' => 'Merkki',
            'model' => 'Malli',
            'name' => 'Nimi',
            'images' => 'Kuvat',
            'year' => 'Vuosi',
            'color' => 'Väri',
            'mileage' => 'Mittarilukema',
            'kilometers' => 'Kilometrit',
            'horsepower' => 'Hevosvoimat',
            'vehicle_type' => 'Ajoneuvon tyyppi',
            'transmission' => 'Vaihteisto',
            'fuel_type' => 'Polttoainetyyppi',
            'rental_rate' => 'Vuokrahinta',
            'currency' => 'Valuutta',
            'status' => 'Tila',
            'availability' => 'Saatavuus',
            'insurance_info' => 'Vakuutustiedot',
            'number_of_seats' => 'Istuinten määrä',
            'number_of_doors' => 'Ovien määrä',
            'vin' => 'VIN',
            'maintenance_history' => 'Huoltohistoria',
            'location' => 'Sijainti',
            'description' => 'Kuvaus',
            'rental_type' => 'Vuokraustyyppi',
            'tags' => 'Tunnisteet',
            'add_new_attribute' => 'Lisää uusi <a href=":url" target="_blank">tässä</a>.',
            'categories' => 'Kategoriat',
            'pick_address' => 'Noutoosoite',
            'return_address' => 'Palautusosoite',
            'same_drop_off' => 'Sama palautuspaikka',
            'tax' => 'Vero',
            'select_tax' => 'Valitse vero',
            'none' => 'Ei mitään',
            'colors' => 'Värit',
            'amenities' => 'Mukavuudet',
            'is_used' => 'Käytetty?',
            'moderation_status' => 'Moderointitila',
            'status_moderation' => [
                'approve' => 'Hyväksy',
                'reject' => 'Hylkää',
                'approve_title' => 'Hyväksy auto',
                'approve_message' => 'Haluatko varmasti hyväksyä tämän auton? Tätä toimintoa ei voi peruuttaa.',
                'reject_title' => 'Hylkää auto',
                'reject_message' => 'Haluatko varmasti hylätä tämän auton? Tätä toimintoa ei voi peruuttaa.',
                'reject_reason' => 'Syötä hylkäämisen syy',
                'approved' => 'Auto on hyväksytty onnistuneesti!',
                'rejected' => 'Auto on hylätty onnistuneesti!',
                'reason_rejected' => 'Hylkäämisen syy',
            ],
            'customer' => 'Asiakas',
            'select_customer' => 'Valitse asiakas...',
            'vendor_images' => 'Kuvat (Enintään :max kuvaa)',
            'images_upload_placeholder' => 'Pudota tiedostot tähän tai klikkaa ladataksesi.',
            'car_purpose' => 'Auton tarkoitus',
            'for_rent' => 'Vuokrattavana',
            'for_sale' => 'Myytävänä',
            'car_type' => 'Auton tyyppi',
            'rental_information' => 'Vuokratiedot',
            'sale_statuses' => [
                'available' => 'Saatavilla',
                'sold' => 'Myyty',
                'reserved' => 'Varattu',
            ],
            'selling_information' => 'Myyntitiedot',
            'is_for_sale' => 'Myytävänä',
            'sale_price' => 'Myyntihinta',
            'sale_price_placeholder' => 'Syötä myyntihinta',
            'condition' => 'Kunto',
            'select_condition' => 'Valitse kunto',
            'condition_options' => [
                'new' => 'Uusi',
                'like_new' => 'Kuin uusi',
                'excellent' => 'Erinomainen',
                'good' => 'Hyvä',
                'fair' => 'Tyydyttävä',
                'poor' => 'Huono',
            ],
            'ownership_history' => 'Omistushistoria',
            'ownership_history_placeholder' => 'Syötä omistushistoria',
            'warranty_information' => 'Takuutiedot',
            'warranty_information_placeholder' => 'Syötä takuutiedot',
            'sale_status' => 'Myyntitila',
            'external_booking_url' => 'Ulkoinen varauslinkki',
            'external_booking_url_helper' => 'Syötä ulkoinen URL, jossa asiakkaat voivat varata tämän auton tämän alustan ulkopuolella. Jätä tyhjäksi, jos varaus on saatavilla vain tällä sivustolla.',
            'address' => 'Osoite',
            'address_helper' => 'Syötä tarkka katuosoite, jossa tämä ajoneuvo sijaitsee',
        ],
        'car_purposes' => [
            'sale' => 'Myytävänä',
            'rent' => 'Vuokrattavana',
        ],
        'placeholders' => [
            'name' => 'Syötä ajoneuvon nimi (esim. Toyota Camry 2023, Honda CR-V jne.)',
            'description' => 'Syötä ajoneuvon lyhyt kuvaus korostaen keskeisiä ominaisuuksia',
            'rental_rate' => 'Syötä vuokrahinta valitun vuokraustyypin perusteella',
            'location' => 'Syötä ajoneuvon fyysinen sijainti',
            'address' => 'Syötä tarkka katuosoite (esim. 123 Main St, Kaupunki, Osavaltio)',
            'sale_price' => 'Syötä tämän ajoneuvon myyntihinta',
            'ownership_history' => 'Syötä tiedot aiemmista omistajista, omistajien määrästä jne.',
            'warranty_information' => 'Syötä tiedot takuun kattavuudesta, voimassaoloajasta jne.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Syötä ajoneuvon rekisterikilpi',
            'vin' => 'Syötä ajoneuvon tunnistenumero (VIN)',
            'year' => 'Syötä valmistusvuosi (esim. 2023)',
            'mileage' => 'Syötä nykyinen mittarilukema',
            'kilometers' => 'Syötä nykyiset kilometrit',
            'horsepower' => 'Syötä ajoneuvon hevosvoimat (HP) (esim. 150.5)',
            'number_of_seats' => 'Syötä ajoneuvossa olevien istuimien määrä',
            'number_of_doors' => 'Syötä ajoneuvossa olevien ovien määrä',
            'insurance_info' => 'Syötä tähän ajoneuvoon liittyvät vakuutustiedot',
            'tags' => 'Valitse tai luo tunnisteita',
            'amenities' => 'Valitse mukavuudet',
            'colors' => 'Valitse tai luo värejä',
        ],
        'enums' => [
            'vendor_status' => 'Myyjän tila',
            'is_vendor' => 'Myyjä',
            'not_vendor' => 'Asiakas',
            'statuses' => [
                'available' => 'Saatavilla',
                'rented' => 'Vuokrattu',
                'maintenance' => 'Huollossa',
                'out_of_service' => 'Poissa käytöstä',
            ],
            'rental_types' => [
                'per_hour' => 'Tuntia kohden',
                'per_day' => 'Päivää kohden',
                'per_week' => 'Viikkoa kohden',
                'per_month' => 'Kuukautta kohden',
            ],
            'moderation_statuses' => [
                'pending' => 'Odottaa',
                'approved' => 'Hyväksytty',
                'rejected' => 'Hylätty',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Huoltohistoria',
            'create' => 'Luo huoltohistoria',
            'amount' => 'Summa',
            'forms' => [
                'price_placeholder' => 'Palvelun hinta',
                'currency' => 'Valuutta',
                'none' => 'Ei mitään',
                'name' => 'Nimi',
                'amount' => 'Summa',
                'created_at' => 'Luotu',
                'action' => 'Toiminto',
                'date' => 'Päivämäärä',
                'no_maintenance_history' => 'Ei huoltohistoriaa',
                'edit_maintenance_history' => 'Muokkaa huoltohistoriaa',
                'add_maintenance_history' => 'Lisää huoltohistoria',
                'add' => 'Lisää',
                'edit' => 'Muokkaa',
                'delete' => 'Poista',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Auton ominaisuudet',
        'car_type' => [
            'name' => 'Tyypit',
            'create' => 'Luo autolaji',
            'forms' => [
                'name' => 'Nimi',
            ],
        ],
        'transmission' => [
            'name' => 'Vaihteistot',
            'create' => 'Luo vaihteisto',
            'forms' => [
                'name' => 'Nimi',
            ],
        ],
        'fuel_type' => [
            'name' => 'Polttoaineet',
            'create' => 'Luo polttoainetyyppi',
            'forms' => [
                'name' => 'Nimi',
            ],
        ],
        'tag' => [
            'name' => 'Tunnisteet',
            'create' => 'Luo tunniste',
        ],
        'category' => [
            'name' => 'Kategoriat',
            'create' => 'Luo kategoria',
            'forms' => [
                'none' => 'Ei mitään',
                'total_cars' => 'Autoja yhteensä: :total',
            ],
        ],
        'address' => [
            'name' => 'Sijainnit',
            'create' => 'Luo auton sijainti',
            'form' => [
                'name' => 'Osoite',
                'full_address' => 'Täydellinen osoite',
                'detail_address' => 'Yksityiskohtainen osoite',
            ],
        ],
        'color' => [
            'name' => 'Väri',
            'create' => 'Luo väri',
        ],
        'amenity' => [
            'name' => 'Mukavuudet',
            'create' => 'Luo mukavuus',
        ],
    ],
    'tax' => [
        'name' => 'Verot',
        'create' => 'Luo vero',
        'forms' => [
            'name' => 'Nimi',
            'name_placeholder' => 'Syötä nimi',
            'percentage' => 'Prosentti',
            'percentage_placeholder' => 'Prosentti',
            'percent_placeholder' => 'Prosentti',
            'priority' => 'Prioriteetti',
            'priority_placeholder' => 'Prioriteetti',
        ],
    ],
    'review' => [
        'name' => 'Arvostelut',
        'create' => 'Luo arvostelu',
        'edit' => 'Muokkaa arvostelua',
        'vendor' => [
            'title' => 'Asiakkaiden arvostelut',
            'description' => 'Hallitse kaikkia autojesi asiakasarvosteluja',
            'no_reviews' => 'Sinulla ei ole vielä arvosteluja',
            'filter_by_car' => 'Suodata auton mukaan',
            'filter_by_rating' => 'Suodata arvosanan mukaan',
            'filter_by_date' => 'Suodata päivämäärän mukaan',
            'all_cars' => 'Kaikki autot',
            'all_ratings' => 'Kaikki arvosanat',
            'manage_reviews' => 'Hallitse arvosteluja',
            'view_all' => 'Näytä kaikki arvostelut',
            'delete_review_confirmation' => 'Haluatko varmasti poistaa tämän arvostelun?',
            'delete_review_success' => 'Arvostelu poistettu onnistuneesti',
            'cannot_delete' => 'Tätä arvostelua ei voi poistaa',
        ],
        'forms' => [
            'customer' => 'Asiakas',
            'car' => 'Auto',
            'content' => 'Sisältö',
            'rating' => 'Arvosana',
            'your_name' => 'Nimesi',
            'email_address' => 'Sähköpostiosoite',
            'submit' => 'Lähetä',
            'star' => 'Tähti',
            'status' => 'Tila',
            'created_at' => 'Luotu',
            'select_car' => 'Valitse auto',
            'select_rating' => 'Valitse arvosana',
            'comment' => 'Kommentti',
            'reply' => 'Vastaa',
            'reply_to_review' => 'Vastaa arvosteluun',
            'save_reply' => 'Tallenna vastaus',
            'cancel_reply' => 'Peruuta',
        ],
        'statuses' => [
            'published' => 'Julkaistu',
            'pending' => 'Odottaa',
            'rejected' => 'Hylätty',
        ],
        'ratings' => [
            '1' => '1 tähti - Huono',
            '2' => '2 tähteä - Tyydyttävä',
            '3' => '3 tähteä - Hyvä',
            '4' => '4 tähteä - Erittäin hyvä',
            '5' => '5 tähteä - Erinomainen',
        ],
    ],
    'coupon' => [
        'name' => 'Kupongit',
        'create' => 'Luo kuponki',
        'types' => [
            'percentage' => 'Prosentti %',
            'money' => 'Raha',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Palvelut',
        'create' => 'Luo palvelu',
        'forms' => [
            'name' => 'Nimi',
            'content' => 'Sisältö',
            'price' => 'Hinta',
            'currency' => 'Valuutta',
            'image' => 'Kuva',
            'logo' => 'Logo',
            'status' => 'Tila',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Saatavuuskalenteri',
        'title' => 'Saatavuuskalenteri',
        'description' => 'Näytä auton saatavuus ja varaukset kalenterimuodossa',
        'select_dates' => 'Valitse päivämäärät saatavuuden tarkistamiseksi',
        'car_filter' => 'Suodata auton mukaan',
        'all_cars' => 'Kaikki autot',
        'clear_filter' => 'Tyhjennä suodatin',
        'availability_check' => 'Auton saatavuuden tarkistus',
        'selected_period' => 'Valittu ajanjakso',
        'checking_availability' => 'Tarkistetaan saatavuutta...',
        'available' => 'Saatavilla',
        'not_available' => 'Ei saatavilla',
        'booking_details' => 'Varauksen tiedot',
        'how_to_use' => 'Kuinka käyttää auton saatavuuskalenteria',
        'viewing_bookings' => 'Varausten tarkastelu',
        'checking_availability_help' => 'Saatavuuden tarkistaminen',
        'color_legend' => 'Väriselite',
        'pending_bookings' => 'Odottavat varaukset',
        'processing_bookings' => 'Käsittelyssä olevat varaukset',
        'completed_bookings' => 'Valmiit varaukset',
        'cancelled_bookings' => 'Peruutetut varaukset',
        'unknown_make' => 'Tuntematon merkki',
        'loading' => 'Ladataan...',
        'loading_calendar_data' => 'Ladataan kalenterin tietoja...',
        'loading_booking_details' => 'Ladataan varauksen tietoja...',
        'please_wait_booking_info' => 'Odota, kun haemme varauksen tiedot.',
        'please_wait_availability' => 'Odota, kun tarkistamme auton saatavuutta valituille päivämäärille.',
        'error' => 'Virhe',
        'error_loading_booking' => 'Varauksen tietojen lataaminen epäonnistui. Yritä uudelleen.',
        'error_checking_availability' => 'Virhe auton saatavuuden tarkistamisessa',
        'customer' => 'Asiakas',
        'status' => 'Tila',
        'amount' => 'Summa',
        'make' => 'Merkki',
        'vendor' => 'Myyjä',
        'per_day' => '/päivä',
        'edit_car' => 'Muokkaa autoa',
        'no_cars_found' => 'Autoja ei löytynyt',
        'no_cars_available_period' => 'Valitulla ajanjaksolla ei ole autoja saatavilla.',
        'close' => 'Sulje',
        'edit_booking' => 'Muokkaa varausta',
        'pending' => 'Odottaa',
        'processing' => 'Käsittelyssä',
        'completed' => 'Valmis',
        'cancelled' => 'Peruutettu',
    ],
    'theme_options' => [
        'name' => 'Autovuokraus',
        'description' => 'Teema-asetukset autovuokraukselle',
        'car_location_filter_by' => 'Auton sijaintisuodatus',
        'state' => 'Osavaltio',
        'city' => 'Kaupunki',
        'yes' => 'Kyllä',
        'no' => 'Ei',
        'is_display_country' => 'Näytetäänkö maa sijaintisuodattimessa?',
        'logo_vendor_dashboard' => 'Logo myyjän hallintapaneelissa (Oletus on päälogo)',
        'number_of_cars_per_page' => 'Autojen määrä sivua kohden',
        'number_of_cars_per_page_placeholder' => 'Syötä sivua kohden näytettävien autojen määrä',
    ],
    'message' => [
        'name' => 'Viestit',
        'forms' => [
            'customer_name' => 'Asiakkaan nimi',
            'message' => 'Viesti',
            'phone' => 'Puhelin',
            'email' => 'Sähköposti',
            'created_at' => 'Luotu',
            'status' => 'Tila',
        ],
    ],
    'car_sale' => [
        'name' => 'Automyynti',
        'create' => 'Uusi automyynti',
        'edit' => 'Muokkaa automyyntiä :name',
        'statuses' => [
            'pending' => 'Odottaa',
            'processing' => 'Käsittelyssä',
            'completed' => 'Valmis',
            'cancelled' => 'Peruutettu',
        ],
        'forms' => [
            'transaction_id' => 'Maksutapahtuman tunnus',
            'transaction_id_placeholder' => 'Syötä maksutapahtuman tunnus',
            'car_id' => 'Auto',
            'car' => 'Auto',
            'customer_id' => 'Asiakas',
            'customer_name' => 'Asiakkaan nimi',
            'customer_name_placeholder' => 'Syötä asiakkaan nimi',
            'customer_email' => 'Asiakkaan sähköposti',
            'customer_email_placeholder' => 'Syötä asiakkaan sähköposti',
            'customer_phone' => 'Asiakkaan puhelin',
            'customer_phone_placeholder' => 'Syötä asiakkaan puhelin',
            'sale_price' => 'Myyntihinta',
            'sale_price_placeholder' => 'Syötä myyntihinta',
            'tax_amount' => 'Veron määrä',
            'tax_amount_placeholder' => 'Syötä veron määrä',
            'total_amount' => 'Kokonaissumma',
            'total_amount_placeholder' => 'Syötä kokonaissumma',
            'payment_details' => 'Maksutiedot',
            'payment_details_placeholder' => 'Syötä maksutiedot',
            'notes' => 'Huomautukset',
            'notes_placeholder' => 'Syötä huomautukset',
            'sale_date' => 'Myyntipäivä',
            'delivery_date' => 'Toimituspäivä',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Tilisiirto',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Autovuokrauksen varausvahvistus',
        'booking_confirm_greeting' => 'Hyvä :customer_name,',
        'booking_confirm_message' => 'Ilmoitamme ilolla, että autovuokrausvarauksesi on vahvistettu onnistuneesti!',
        'customer_information' => 'Asiakkaan tiedot',
        'booking_information' => 'Varauksen tiedot',
        'field_name' => 'Nimi:',
        'field_phone' => 'Puhelin:',
        'field_email' => 'Sähköposti:',
        'field_car_model' => 'Auton malli:',
        'field_start_date' => 'Alkamispäivä:',
        'field_end_date' => 'Päättymispäivä:',
        'field_pickup_address' => 'Noutoosoite:',
        'field_return_address' => 'Palautusosoite:',
        'field_note' => 'Huomautus:',
        'field_order_number' => 'Tilausnumero',
        'field_payment_method' => 'Maksutapa',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Uusi varausilmoitus',
        'booking_notice_admin_greeting' => 'Hei, sivustolta :site_title on uusi varaus:',
        'booking_notice_admin_message' => 'Uusi autovuokrausvaraus on tehty ja vaatii huomiosi.',
        'booking_view_detail' => 'Näytä varauksen tiedot:',
        'view_booking_details' => 'Näytä varauksen tiedot',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Uusi varaus autollesi',
        'booking_notice_vendor_greeting' => 'Hyvä :vendor_name,',
        'booking_notice_vendor_message' => 'Hienoja uutisia! Olet saanut uuden varauksen autovuokrauksellesi.',

        // Booking status changed email
        'booking_status_updated' => 'Varauksen tila päivitetty',
        'hello_thanks_for_booking' => 'Hei, kiitos varauksesta sivustolta :site_title:',
        'booking_status_change_message' => 'Toivomme, että tämä viesti tavoittaa sinut hyvin. Halusimme ilmoittaa, että varauksesi tila on päivitetty.',
        'name' => 'Nimi',
        'phone' => 'Puhelin',
        'email' => 'Sähköposti',
        'car_model' => 'Auton malli',
        'start_date' => 'Alkamispäivä',
        'end_date' => 'Päättymispäivä',
        'pickup_address' => 'Noutoosoite',
        'return_address' => 'Palautusosoite',
        'note' => 'Huomautus',
        'order_number' => 'Tilausnumero',
        'payment_method' => 'Maksutapa',

        // Car approved email
        'hello' => 'Hei',
        'car_approved_title' => 'Hienoja uutisia! Autosi on hyväksytty',
        'car_approved_message' => 'Ilmoitamme ilolla, että autolistaus ":car_name" on hyväksytty ja on nyt julkaistu sivustolla :site_title. Voit alkaa vastaanottaa varauksia ja hallita listaustasiasi heti.',
        'view_edit_car_link' => 'Nähdäksesi tai muokataksesi autolistaustasi, klikkaa tätä linkkiä',
        'view_car' => 'Näytä autolistaus',
        'regards' => 'Ystävällisin terveisin',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Onnittelut! Olet nyt myyjä',
        'vendor_upgrade_congratulations' => 'Ilmoitamme innoissamme, että tilisi on päivitetty onnistuneesti myyjäksi!',
        'vendor_upgrade_message' => 'Voit nyt listata ja hallita omia autojasi sivustolla :site_title. Tämä avaa sinulle uusia mahdollisuuksia kasvattaa vuokrausliiketoimintaasi kanssamme.',
        'vendor_benefits_title' => 'Uudet myyjäedut',
        'vendor_benefit_1' => 'Listaa rajattomasti autoja vuokralle',
        'vendor_benefit_2' => 'Hallitse omia varauksesi ja asiakkaitasi',
        'vendor_benefit_3' => 'Seuraa tuloja ja suorituskykymittareita',
        'vendor_benefit_4' => 'Pääsy myyjälle eksklusiivisiin ominaisuuksiin ja työkaluihin',
        'next_steps' => 'Seuraavat vaiheet',
        'vendor_next_steps_message' => 'Kirjaudu myyjän hallintapaneeliin aloittaaksesi autojesi lisäämisen ja vuokrausliiketoimintasi hallinnoimisen.',
        'go_to_dashboard' => 'Siirry myyjän hallintapaneeliin',
        'vendor_support_message' => 'Jos sinulla on kysymyksiä tai tarvitset apua, tukitiimimme on täällä auttamassa sinua alkuun.',
        'approved' => 'Hyväksytty',

        // Car rejected email
        'car_rejected_title' => 'Päivitys vaaditaan autolistauksellesi',
        'car_rejected_message' => 'Kiitos autolistauksen ":car_name" lähettämisestä sivustolle :site_title. Lähetyksesi tarkastelun jälkeen tarvitsemme sinun tekevän joitain muutoksia ennen kuin voimme hyväksyä sen.',
        'rejection_reason' => 'Tässä on mitä on päivitettävä',
        'rejection_details' => 'Vaaditut päivitykset',
        'contact_support' => 'Jos sinulla on kysymyksiä tai tarvitset apua näiden päivitysten kanssa, älä epäröi ottaa yhteyttä tukitiimiimme osoitteessa :site_email. Olemme täällä auttamassa sinua saamaan listauksesi hyväksytyksi nopeasti.',

        // Confirm email
        'verify_email' => 'Vahvista sähköposti',
        'welcome_message' => 'Olemme iloisia nähdessämme sinut täällä, :customer_name!',
        'verify_email_instruction' => 'Vahvista sähköpostiosoitteesi päästäksesi tälle sivustolle. Klikkaa alla olevaa painiketta vahvistaaksesi sähköpostisi.',
        'confirm_email_button' => 'Vahvista sähköpostiosoitteesi',
        'verify_link_trouble' => 'Jos sinulla on vaikeuksia klikata "Vahvista sähköpostiosoitteesi" -painiketta, kopioi ja liitä alla oleva URL-osoite verkkoselaimesi: :verify_link ja liitä se selaimeesi.',

        // Message email
        'new_message' => 'Uusi viesti',
        'dear_admin' => 'Hyvä ylläpitäjä',
        'new_message_from' => 'Sivustolta :site_title on uusi viesti:',
        'subject' => 'Aihe',
        'address' => 'Osoite',
        'content' => 'Sisältö',

        // New pending car email
        'hi_admin' => 'Hei ylläpitäjä,',
        'new_car_pending_title' => 'Uusi autolistaus odottaa tarkastusta',
        'new_car_pending_approval' => 'Uusi autolistaus ":post_name" on lähetetty käyttäjän :post_author toimesta ja on valmis tarkastukseen.',
        'pending_approval' => 'Odottaa tarkastusta',
        'review_car_admin' => 'Tarkista tämä listaus hallintapaneelissa ja hyväksy tai pyydä päivityksiä tarvittaessa.',

        // Common fields
        'car_information' => 'Auton tiedot',
        'field_car_name' => 'Auton nimi:',
        'field_author' => 'Tekijä:',
        'field_status' => 'Tila:',
        'actions' => 'Toiminnot',

        // Password reminder email
        'reset_password_instruction' => 'Salasanan palautusohjeet',
        'password_reset_request' => 'Saat tämän sähköpostin, koska olemme saaneet tilillesi salasanan palautuspyynnön.',
        'reset_password_button' => 'Palauta salasana',
        'reset_link_trouble' => 'Jos sinulla on vaikeuksia klikata "Palauta salasana" -painiketta, kopioi ja liitä alla oleva URL-osoite verkkoselaimesi: :reset_link ja liitä se selaimeesi. Jos et pyytänyt salasanan palautusta, ohita tämä viesti tai ota meihin yhteyttä, jos sinulla on kysymyksiä.',
    ],
];
