<?php

return [
    'name' => 'Noleggio Auto',
    'customer' => [
        'name' => 'Clienti',
        'create' => 'Crea Cliente',
        'view' => 'Visualizza',
        'information' => 'Informazioni Cliente',
        'email' => 'Email',
        'phone' => 'Telefono',
        'status' => 'Stato',
        'vendor_status' => 'Stato Venditore',
        'is_vendor' => 'Venditore',
        'not_vendor' => 'Cliente',
        'recent_activity' => 'Attività Recente',
        'recent_activity_description' => 'L\'attività del cliente apparirà qui.',
        'verification_section' => 'Verifica Cliente',
        'verified' => 'Verificato',
        'not_verified' => 'Non Verificato',
        'verified_by' => 'Verificato Da',
        'verified_at' => 'Verificato Il',
        'verify_customer' => 'Verifica Cliente',
        'unverify_customer' => 'Rimuovi Verifica Cliente',
        'verify_customer_confirmation' => 'Conferma Verifica Cliente',
        'verify_customer_confirmation_desc' => 'Sei sicuro di voler verificare :name? Questo mostrerà un badge verificato sul loro profilo.',
        'unverify_customer_confirmation' => 'Conferma Rimozione Verifica Cliente',
        'unverify_customer_confirmation_desc' => 'Sei sicuro di voler rimuovere la verifica da :name? Il badge verificato sarà rimosso.',
        'verify_success' => 'Cliente :name è stato verificato con successo.',
        'unverify_success' => 'La verifica del cliente :name è stata rimossa con successo.',
        'already_verified' => 'Questo cliente è già verificato.',
        'already_unverified' => 'Questo cliente non è verificato.',
        'customer_verified_successfully' => 'Questo cliente è stato verificato ed è affidabile.',
        'customer_not_verified_yet' => 'Questo cliente non è ancora stato verificato.',
        'verification_pending' => 'Verifica in Attesa',
        'click_verify_to_approve' => 'Clicca il pulsante sotto per verificare questo cliente e mostrare il badge verificato.',
        'verification_note' => 'Nota Verifica',
        'verification_note_placeholder' => 'Inserisci eventuali note su questa azione di verifica...',
        'verification_note_helper' => 'Aggiungi note sul processo di verifica (solo uso interno)',
        'forms' => [
            'name' => 'Nome',
            'email' => 'Email',
            'phone' => 'Telefono',
            'avatar' => 'Avatar',
            'dob' => 'Data di Nascita',
            'company' => 'Azienda',
            'position' => 'Posizione',
            'password' => 'Password',
            'password_confirmation' => 'Conferma password',
            'change_password' => 'Cambia password?',
            'phone_placeholder' => 'Telefono',
        ],
    ],
    'vendor' => [
        'name' => 'Venditori',
        'view' => 'Visualizza :name',
        'information' => 'Informazioni Venditore',
        'total_cars' => 'Totale Auto',
        'total_bookings' => 'Totale Prenotazioni',
        'verified' => 'Verificato',
        'not_verified' => 'Non Verificato',
        'verification_section' => 'Verifica Venditore',
        'vendor_verified_successfully' => 'Questo venditore è stato verificato ed è affidabile.',
        'vendor_not_verified_yet' => 'Questo venditore non è ancora stato verificato.',
        'verification_pending' => 'Verifica in Attesa',
        'click_verify_to_approve' => 'Clicca il pulsante sotto per verificare questo venditore e mostrare il badge verificato.',
        'verify_vendor' => 'Verifica Venditore',
        'unverify_vendor' => 'Rimuovi Verifica Venditore',
        'verify_vendor_confirmation' => 'Conferma Verifica Venditore',
        'verify_vendor_confirmation_desc' => 'Sei sicuro di voler verificare :name? Questo mostrerà un badge verificato sul loro profilo.',
        'unverify_vendor_confirmation' => 'Conferma Rimozione Verifica Venditore',
        'unverify_vendor_confirmation_desc' => 'Sei sicuro di voler rimuovere la verifica da :name? Il badge verificato sarà rimosso.',
        'verified_successfully' => 'Il venditore è stato verificato con successo.',
        'unverified_successfully' => 'La verifica del venditore è stata rimossa con successo.',
        'already_verified' => 'Questo venditore è già verificato.',
        'not_verified_yet' => 'Questo venditore non è ancora verificato.',
        'recent_activity' => 'Attività Recente',
        'recent_cars' => 'Auto Recenti',
        'recent_bookings' => 'Prenotazioni Recenti',
        'no_cars_yet' => 'Nessuna auto aggiunta ancora.',
        'no_bookings_yet' => 'Nessuna prenotazione ricevuta ancora.',
    ],
    'make' => [
        'name' => 'Marche',
        'create' => 'Crea Marca Auto',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Scuro',
        ],
    ],
    'car' => [
        'name' => 'Auto',
        'create' => 'Crea Auto',
        'forms' => [
            'car' => 'Auto',
            'logo' => 'Logo',
            'license_plate' => 'Targa',
            'make' => 'Marca',
            'model' => 'Modello',
            'name' => 'Nome',
            'images' => 'Immagini',
            'year' => 'Anno',
            'color' => 'Colore',
            'mileage' => 'Chilometraggio',
            'kilometers' => 'Chilometri',
            'horsepower' => 'Potenza',
            'vehicle_type' => 'Tipo Veicolo',
            'transmission' => 'Trasmissione',
            'fuel_type' => 'Tipo Carburante',
            'rental_rate' => 'Tariffa Noleggio',
            'currency' => 'Valuta',
            'status' => 'Stato',
            'availability' => 'Disponibilità',
            'insurance_info' => 'Informazioni assicurazione',
            'number_of_seats' => 'Numero Posti',
            'number_of_doors' => 'Numero Porte',
            'vin' => 'VIN',
            'maintenance_history' => 'Storico Manutenzione',
            'location' => 'Posizione',
            'description' => 'Descrizione',
            'rental_type' => 'Tipo Noleggio',
            'tags' => 'Tag',
            'add_new_attribute' => 'Aggiungi nuovo <a href=":url" target="_blank">qui</a>.',
            'categories' => 'Categorie',
            'pick_address' => 'Indirizzo Ritiro',
            'return_address' => 'Indirizzo Riconsegna',
            'same_drop_off' => 'Stessa Riconsegna',
            'tax' => 'Tassa',
            'select_tax' => 'Seleziona Tassa',
            'none' => 'Nessuno',
            'colors' => 'Colori',
            'amenities' => 'Servizi',
            'is_used' => 'È usata?',
            'moderation_status' => 'Stato moderazione',
            'status_moderation' => [
                'approve' => 'Approva',
                'reject' => 'Rifiuta',
                'approve_title' => 'Approva auto',
                'approve_message' => 'Sei sicuro di voler approvare questa auto? Questa azione non può essere annullata.',
                'reject_title' => 'Rifiuta auto',
                'reject_message' => 'Sei sicuro di voler rifiutare questa auto? Questa azione non può essere annullata.',
                'reject_reason' => 'Inserisci il motivo del rifiuto',
                'approved' => 'L\'auto è stata approvata con successo!',
                'rejected' => 'L\'auto è stata rifiutata con successo!',
                'reason_rejected' => 'Motivo rifiutato',
            ],
            'customer' => 'Cliente',
            'select_customer' => 'Seleziona un cliente...',
            'vendor_images' => 'Immagini (Massimo :max immagini)',
            'images_upload_placeholder' => 'Trascina i file qui o clicca per caricare.',
            'car_purpose' => 'Scopo Auto',
            'for_rent' => 'Per Noleggio',
            'for_sale' => 'Per Vendita',
            'car_type' => 'Tipo Auto',
            'rental_information' => 'Informazioni Noleggio',
            'sale_statuses' => [
                'available' => 'Disponibile',
                'sold' => 'Venduta',
                'reserved' => 'Riservata',
            ],
            'selling_information' => 'Informazioni Vendita',
            'is_for_sale' => 'Disponibile per la vendita',
            'sale_price' => 'Prezzo di Vendita',
            'sale_price_placeholder' => 'Inserisci prezzo di vendita',
            'condition' => 'Condizione',
            'select_condition' => 'Seleziona Condizione',
            'condition_options' => [
                'new' => 'Nuova',
                'like_new' => 'Come Nuova',
                'excellent' => 'Eccellente',
                'good' => 'Buona',
                'fair' => 'Discreta',
                'poor' => 'Scarsa',
            ],
            'ownership_history' => 'Storico Proprietà',
            'ownership_history_placeholder' => 'Inserisci storico proprietà',
            'warranty_information' => 'Informazioni Garanzia',
            'warranty_information_placeholder' => 'Inserisci informazioni garanzia',
            'sale_status' => 'Stato Vendita',
            'external_booking_url' => 'Link Prenotazione Esterno',
            'external_booking_url_helper' => 'Inserisci l\'URL esterno dove i clienti possono prenotare questa auto fuori da questa piattaforma. Lascia vuoto se la prenotazione è disponibile solo su questo sito.',
            'address' => 'Indirizzo',
            'address_helper' => 'Inserisci l\'indirizzo specifico dove si trova questo veicolo',
        ],
        'car_purposes' => [
            'sale' => 'Per Vendita',
            'rent' => 'Per Noleggio',
        ],
        'placeholders' => [
            'name' => 'Inserisci il nome del veicolo (es. Toyota Camry 2023, Honda CR-V, ecc.)',
            'description' => 'Inserisci una breve descrizione del veicolo evidenziando le caratteristiche principali',
            'rental_rate' => 'Inserisci la tariffa di noleggio basata sul tipo di noleggio selezionato',
            'location' => 'Inserisci la posizione fisica del veicolo',
            'address' => 'Inserisci l\'indirizzo specifico (es. Via Roma 123, Città, Stato)',
            'sale_price' => 'Inserisci il prezzo di vendita per questo veicolo',
            'ownership_history' => 'Inserisci dettagli sui proprietari precedenti, numero di proprietari, ecc.',
            'warranty_information' => 'Inserisci dettagli sulla copertura garanzia, data di scadenza, ecc.',
            'external_booking_url' => 'https://esempio.com/link-prenotazione',
            'license_plate' => 'Inserisci numero targa veicolo',
            'vin' => 'Inserisci il Numero di Identificazione Veicolo (VIN)',
            'year' => 'Inserisci l\'anno di produzione (es. 2023)',
            'mileage' => 'Inserisci il chilometraggio attuale',
            'kilometers' => 'Inserisci i chilometri attuali',
            'horsepower' => 'Inserisci la potenza (CV) del veicolo (es. 150.5)',
            'number_of_seats' => 'Inserisci il numero di posti nel veicolo',
            'number_of_doors' => 'Inserisci il numero di porte del veicolo',
            'insurance_info' => 'Inserisci informazioni assicurative rilevanti per questo veicolo',
            'tags' => 'Seleziona o crea tag',
            'amenities' => 'Seleziona servizi',
            'colors' => 'Seleziona o crea colori',
        ],
        'enums' => [
            'statuses' => [
                'available' => 'Disponibile',
                'rented' => 'Noleggiata',
                'maintenance' => 'Manutenzione',
                'out_of_service' => 'Fuori Servizio',
            ],
            'rental_types' => [
                'per_hour' => 'All\'ora',
                'per_day' => 'Al giorno',
                'per_week' => 'Alla settimana',
                'per_month' => 'Al mese',
            ],
            'moderation_statuses' => [
                'pending' => 'In attesa',
                'approved' => 'Approvata',
                'rejected' => 'Rifiutata',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Storico Manutenzioni',
            'create' => 'Crea Storico Servizio',
            'amount' => 'Importo',
            'forms' => [
                'price_placeholder' => 'Prezzo servizio',
                'currency' => 'Valuta',
                'none' => 'Nessuno',
                'name' => 'Nome',
                'amount' => 'Importo',
                'created_at' => 'Creato Il',
                'action' => 'Azione',
                'date' => 'Data',
                'no_maintenance_history' => 'Nessuno storico manutenzioni',
                'edit_maintenance_history' => 'Modifica storico manutenzione',
                'add_maintenance_history' => 'Aggiungi storico manutenzione',
                'add' => 'Aggiungi',
                'edit' => 'Modifica',
                'delete' => 'Elimina',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Attributi Auto',
        'car_type' => [
            'name' => 'Tipi',
            'create' => 'Crea Tipo Auto',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'transmission' => [
            'name' => 'Trasmissioni',
            'create' => 'Crea Trasmissione',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'fuel_type' => [
            'name' => 'Carburanti',
            'create' => 'Crea Tipi Carburante',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'tag' => [
            'name' => 'Tag',
            'create' => 'Crea Tag',
        ],
        'category' => [
            'name' => 'Categorie',
            'create' => 'Crea Categoria',
            'forms' => [
                'none' => 'Nessuno',
                'total_cars' => 'Totale auto: :total',
            ],
        ],
        'address' => [
            'name' => 'Località',
            'create' => 'Crea Località Auto',
            'form' => [
                'name' => 'Indirizzo',
                'full_address' => 'Indirizzo Completo',
                'detail_address' => 'Indirizzo Dettagliato',
            ],
        ],
        'color' => [
            'name' => 'Colore',
            'create' => 'Crea Colore',
        ],
        'amenity' => [
            'name' => 'Servizi',
            'create' => 'Crea Servizio',
        ],
    ],
    'tax' => [
        'name' => 'Tasse',
        'create' => 'Crea Tassa',
        'forms' => [
            'name' => 'Nome',
            'name_placeholder' => 'Inserisci nome',
            'percentage' => 'Percentuale',
            'percentage_placeholder' => 'Percentuale',
            'percent_placeholder' => 'Percentuale',
            'priority' => 'Priorità',
            'priority_placeholder' => 'Priorità',
        ],
    ],
    'review' => [
        'name' => 'Recensioni',
        'create' => 'Crea Recensione',
        'edit' => 'Modifica Recensione',
        'vendor' => [
            'title' => 'Recensioni Clienti',
            'description' => 'Gestisci tutte le recensioni clienti per le tue auto',
            'no_reviews' => 'Non hai ancora recensioni',
            'filter_by_car' => 'Filtra per auto',
            'filter_by_rating' => 'Filtra per valutazione',
            'filter_by_date' => 'Filtra per data',
            'all_cars' => 'Tutte le Auto',
            'all_ratings' => 'Tutte le Valutazioni',
            'manage_reviews' => 'Gestisci Recensioni',
            'view_all' => 'Visualizza Tutte le Recensioni',
            'delete_review_confirmation' => 'Sei sicuro di voler eliminare questa recensione?',
            'delete_review_success' => 'Recensione eliminata con successo',
            'cannot_delete' => 'Impossibile eliminare questa recensione',
        ],
        'forms' => [
            'customer' => 'Cliente',
            'car' => 'Auto',
            'content' => 'Contenuto',
            'rating' => 'Valutazione',
            'your_name' => 'Il Tuo Nome',
            'email_address' => 'Indirizzo Email',
            'submit' => 'Invia',
            'star' => 'Stella',
            'status' => 'Stato',
            'created_at' => 'Creato Il',
            'select_car' => 'Seleziona Auto',
            'select_rating' => 'Seleziona Valutazione',
            'comment' => 'Commento',
            'reply' => 'Rispondi',
            'reply_to_review' => 'Rispondi alla Recensione',
            'save_reply' => 'Salva Risposta',
            'cancel_reply' => 'Annulla',
        ],
        'statuses' => [
            'published' => 'Pubblicata',
            'pending' => 'In attesa',
            'rejected' => 'Rifiutata',
        ],
        'ratings' => [
            '1' => '1 Stella - Scarsa',
            '2' => '2 Stelle - Discreta',
            '3' => '3 Stelle - Buona',
            '4' => '4 Stelle - Molto Buona',
            '5' => '5 Stelle - Eccellente',
        ],
    ],
    'coupon' => [
        'name' => 'Coupon',
        'create' => 'Crea Coupon',
        'types' => [
            'percentage' => 'Percentuale %',
            'money' => 'Denaro',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Servizi',
        'create' => 'Crea Servizio',
        'forms' => [
            'name' => 'Nome',
            'content' => 'Contenuto',
            'price' => 'Prezzo',
            'currency' => 'Valuta',
            'image' => 'Immagine',
            'logo' => 'Logo',
            'status' => 'Stato',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Calendario Disponibilità',
        'title' => 'Calendario Disponibilità',
        'description' => 'Visualizza disponibilità auto e prenotazioni in formato calendario',
        'select_dates' => 'Seleziona date per controllare disponibilità',
        'car_filter' => 'Filtra per Auto',
        'all_cars' => 'Tutte le Auto',
        'clear_filter' => 'Cancella Filtro',
        'availability_check' => 'Controllo Disponibilità Auto',
        'selected_period' => 'Periodo Selezionato',
        'checking_availability' => 'Controllo disponibilità...',
        'available' => 'Disponibile',
        'not_available' => 'Non Disponibile',
        'booking_details' => 'Dettagli Prenotazione',
        'how_to_use' => 'Come Usare il Calendario Disponibilità Auto',
        'viewing_bookings' => 'Visualizzazione Prenotazioni',
        'checking_availability_help' => 'Controllo Disponibilità',
        'color_legend' => 'Legenda Colori',
        'pending_bookings' => 'Prenotazioni in Attesa',
        'processing_bookings' => 'Prenotazioni in Elaborazione',
        'completed_bookings' => 'Prenotazioni Completate',
        'cancelled_bookings' => 'Prenotazioni Annullate',
        'unknown_make' => 'Marca Sconosciuta',
        'loading' => 'Caricamento...',
        'loading_calendar_data' => 'Caricamento dati calendario...',
        'loading_booking_details' => 'Caricamento dettagli prenotazione...',
        'please_wait_booking_info' => 'Attendi mentre recuperiamo le informazioni della prenotazione.',
        'please_wait_availability' => 'Attendi mentre controlliamo la disponibilità auto per le date selezionate.',
        'error' => 'Errore',
        'error_loading_booking' => 'Impossibile caricare dettagli prenotazione. Riprova.',
        'error_checking_availability' => 'Errore controllo disponibilità auto',
        'customer' => 'Cliente',
        'status' => 'Stato',
        'amount' => 'Importo',
        'make' => 'Marca',
        'vendor' => 'Venditore',
        'per_day' => '/giorno',
        'edit_car' => 'Modifica Auto',
        'no_cars_found' => 'Nessuna auto trovata',
        'no_cars_available_period' => 'Non ci sono auto disponibili per il periodo selezionato.',
        'close' => 'Chiudi',
        'edit_booking' => 'Modifica Prenotazione',
        'pending' => 'In attesa',
        'processing' => 'In elaborazione',
        'completed' => 'Completata',
        'cancelled' => 'Annullata',
    ],
    'theme_options' => [
        'name' => 'Noleggio Auto',
        'description' => 'Opzioni tema per noleggio auto',
        'car_location_filter_by' => 'Filtro località auto per',
        'state' => 'Stato',
        'city' => 'Città',
        'yes' => 'Sì',
        'no' => 'No',
        'is_display_country' => 'Visualizzare paese nel filtro località?',
        'logo_vendor_dashboard' => 'Logo nella dashboard venditore (Predefinito è il logo principale)',
        'number_of_cars_per_page' => 'Numero di auto per pagina',
        'number_of_cars_per_page_placeholder' => 'Inserisci numero di auto da visualizzare per pagina',
    ],
    'message' => [
        'name' => 'Messaggi',
        'forms' => [
            'customer_name' => 'Nome cliente',
            'message' => 'Messaggio',
            'phone' => 'Telefono',
            'email' => 'Email',
            'created_at' => 'Creato il',
            'status' => 'Stato',
        ],
    ],
    'car_sale' => [
        'name' => 'Vendite Auto',
        'create' => 'Nuova Vendita Auto',
        'edit' => 'Modifica Vendita Auto :name',
        'statuses' => [
            'pending' => 'In attesa',
            'processing' => 'In elaborazione',
            'completed' => 'Completata',
            'cancelled' => 'Annullata',
        ],
        'forms' => [
            'transaction_id' => 'ID Transazione',
            'transaction_id_placeholder' => 'Inserisci ID transazione',
            'car_id' => 'Auto',
            'car' => 'Auto',
            'customer_id' => 'Cliente',
            'customer_name' => 'Nome Cliente',
            'customer_name_placeholder' => 'Inserisci nome cliente',
            'customer_email' => 'Email Cliente',
            'customer_email_placeholder' => 'Inserisci email cliente',
            'customer_phone' => 'Telefono Cliente',
            'customer_phone_placeholder' => 'Inserisci telefono cliente',
            'sale_price' => 'Prezzo Vendita',
            'sale_price_placeholder' => 'Inserisci prezzo vendita',
            'tax_amount' => 'Importo Tassa',
            'tax_amount_placeholder' => 'Inserisci importo tassa',
            'total_amount' => 'Importo Totale',
            'total_amount_placeholder' => 'Inserisci importo totale',
            'payment_details' => 'Dettagli Pagamento',
            'payment_details_placeholder' => 'Inserisci dettagli pagamento',
            'notes' => 'Note',
            'notes_placeholder' => 'Inserisci note',
            'sale_date' => 'Data Vendita',
            'delivery_date' => 'Data Consegna',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bonifico Bancario',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Conferma Prenotazione Noleggio Auto',
        'booking_confirm_greeting' => 'Gentile :customer_name,',
        'booking_confirm_message' => 'Siamo lieti di informarvi che la vostra prenotazione noleggio auto è stata confermata con successo!',
        'customer_information' => 'Informazioni Cliente',
        'booking_information' => 'Informazioni Prenotazione',
        'field_name' => 'Nome:',
        'field_phone' => 'Telefono:',
        'field_email' => 'Email:',
        'field_car_model' => 'Modello Auto:',
        'field_start_date' => 'Data Inizio:',
        'field_end_date' => 'Data Fine:',
        'field_pickup_address' => 'Indirizzo Ritiro:',
        'field_return_address' => 'Indirizzo Riconsegna:',
        'field_note' => 'Nota:',
        'field_order_number' => 'Numero ordine',
        'field_payment_method' => 'Metodo di Pagamento',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Notifica Nuova Prenotazione',
        'booking_notice_admin_greeting' => 'Ciao, c\'è una nuova prenotazione da :site_title:',
        'booking_notice_admin_message' => 'È stata inviata una nuova prenotazione noleggio auto che richiede la tua attenzione.',
        'booking_view_detail' => 'Visualizza dettagli prenotazione:',
        'view_booking_details' => 'Visualizza Dettagli Prenotazione',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Nuova Prenotazione per la Tua Auto',
        'booking_notice_vendor_greeting' => 'Gentile :vendor_name,',
        'booking_notice_vendor_message' => 'Ottime notizie! Hai ricevuto una nuova prenotazione per il tuo noleggio auto.',

        // Booking status changed email
        'booking_status_updated' => 'Stato Prenotazione Aggiornato',
        'hello_thanks_for_booking' => 'Ciao, grazie per aver prenotato camere da :site_title:',
        'booking_status_change_message' => 'Speriamo che questo messaggio ti trovi bene. Volevamo informarti che lo stato della tua prenotazione è stato aggiornato.',
        'name' => 'Nome',
        'phone' => 'Telefono',
        'email' => 'Email',
        'car_model' => 'Modello Auto',
        'start_date' => 'Data Inizio',
        'end_date' => 'Data Fine',
        'pickup_address' => 'Indirizzo Ritiro',
        'return_address' => 'Indirizzo Riconsegna',
        'note' => 'Nota',
        'order_number' => 'Numero ordine',
        'payment_method' => 'Metodo di Pagamento',

        // Car approved email
        'hello' => 'Ciao',
        'car_approved_title' => 'Ottime Notizie! La Tua Auto È Stata Approvata',
        'car_approved_message' => 'Siamo lieti di informarti che la tua inserzione auto ":car_name" è stata approvata ed è ora live su :site_title. Puoi iniziare a ricevere prenotazioni e gestire la tua inserzione immediatamente.',
        'view_edit_car_link' => 'Per visualizzare o modificare la tua inserzione auto, clicca su questo link',
        'view_car' => 'Visualizza Inserzione Auto',
        'regards' => 'Cordiali saluti',
        'approved' => 'Approvata',

        // Car rejected email
        'car_rejected_title' => 'Aggiornamento Richiesto per la Tua Inserzione Auto',
        'car_rejected_message' => 'Grazie per aver inviato la tua inserzione auto ":car_name" a :site_title. Dopo aver esaminato la tua presentazione, abbiamo bisogno che tu faccia alcune modifiche prima che possiamo approvarla.',
        'rejection_reason' => 'Ecco cosa deve essere aggiornato',
        'rejection_details' => 'Aggiornamenti Richiesti',
        'contact_support' => 'Se hai domande o hai bisogno di assistenza con questi aggiornamenti, non esitare a contattare il nostro team di supporto a :site_email. Siamo qui per aiutarti ad ottenere la tua inserzione approvata rapidamente.',

        // Confirm email
        'verify_email' => 'Verifica Email',
        'welcome_message' => 'Siamo felici di averti qui, :customer_name!',
        'verify_email_instruction' => 'Per favore verifica il tuo indirizzo email per accedere a questo sito web. Clicca sul pulsante sotto per verificare la tua email.',
        'confirm_email_button' => 'Conferma il tuo indirizzo email',
        'verify_link_trouble' => 'Se hai problemi a cliccare il pulsante \'Conferma il tuo indirizzo email\', copia e incolla l\'URL sotto nel tuo browser web: :verify_link e incollalo nel tuo browser.',

        // Message email
        'new_message' => 'Nuovo Messaggio',
        'dear_admin' => 'Gentile Amministratore',
        'new_message_from' => 'C\'è un nuovo messaggio da :site_title:',
        'subject' => 'Oggetto',
        'address' => 'Indirizzo',
        'content' => 'Contenuto',

        // New pending car email
        'hi_admin' => 'Ciao Amministratore,',
        'new_car_pending_title' => 'Nuova Inserzione Auto in Attesa di Revisione',
        'new_car_pending_approval' => 'Una nuova inserzione auto ":post_name" è stata inviata da :post_author ed è pronta per la tua revisione.',
        'pending_approval' => 'In Attesa di Revisione',
        'review_car_admin' => 'Esamina questa inserzione nel pannello admin e approva o richiedi aggiornamenti se necessario.',

        // Common fields
        'car_information' => 'Informazioni Auto',
        'field_car_name' => 'Nome Auto:',
        'field_author' => 'Autore:',
        'field_status' => 'Stato:',
        'actions' => 'Azioni',

        // Password reminder email
        'reset_password_instruction' => 'Istruzioni Reset Password',
        'password_reset_request' => 'Stai ricevendo questa email perché abbiamo ricevuto una richiesta di reset password per il tuo account.',
        'reset_password_button' => 'Reset password',
        'reset_link_trouble' => 'Se hai problemi a cliccare il pulsante \'Reset Password\', copia e incolla l\'URL sotto nel tuo browser web: :reset_link e incollalo nel tuo browser. Se non hai richiesto un reset password, ignora questo messaggio o contattaci se hai domande.',
    ],
];