<?php

return [
    'name' => 'レンタカー',
    'customer' => [
        'name' => '顧客',
        'create' => '顧客を作成',
        'view' => '表示',
        'information' => '顧客情報',
        'email' => 'メール',
        'phone' => '電話',
        'status' => 'ステータス',
        'vendor_status' => 'ベンダーステータス',
        'is_vendor' => 'ベンダー',
        'not_vendor' => '顧客',
        'recent_activity' => '最近のアクティビティ',
        'recent_activity_description' => '顧客のアクティビティがここに表示されます。',
        'verification_section' => '顧客確認',
        'verified' => '確認済み',
        'not_verified' => '未確認',
        'verified_by' => '確認者',
        'verified_at' => '確認日時',
        'verify_customer' => '顧客を確認',
        'unverify_customer' => '顧客の確認を解除',
        'verify_customer_confirmation' => '顧客確認の確認',
        'verify_customer_confirmation_desc' => ':nameを確認してもよろしいですか？これにより、プロフィールに確認済みバッジが表示されます。',
        'unverify_customer_confirmation' => '顧客確認解除の確認',
        'unverify_customer_confirmation_desc' => ':nameから確認を削除してもよろしいですか？確認済みバッジが削除されます。',
        'verify_success' => '顧客:nameが正常に確認されました。',
        'unverify_success' => '顧客:nameの確認が正常に削除されました。',
        'already_verified' => 'この顧客はすでに確認済みです。',
        'already_unverified' => 'この顧客は確認されていません。',
        'upgrade_to_vendor_title' => 'ベンダーにアップグレード',
        'upgrade_to_vendor_description' => 'この顧客をベンダーステータスにアップグレードして、独自のレンタカーをリストして管理できるようにします。',
        'upgrade_to_vendor_button' => 'ベンダーにアップグレード',
        'upgrade_to_vendor_confirmation' => 'ベンダーへのアップグレードを確認',
        'upgrade_to_vendor_confirmation_desc' => ':nameをベンダーステータスにアップグレードしてもよろしいですか？これにより、プラットフォームで独自の車両をリストして管理できるようになります。',
        'upgrade_to_vendor_success' => ':nameが正常にベンダーステータスにアップグレードされました。',
        'already_vendor' => 'この顧客はすでにベンダーです。',
        'email_verified' => 'メール確認済み',
        'email_not_verified' => 'メール未確認',
        'verify_email_warning_message' => 'この顧客のメールアドレスは確認されていません。メールが有効であることを確認するために手動で確認できます。',
        'verify_email_title' => 'メールアドレスを確認',
        'verify_email_description' => 'この顧客のメールアドレスは確認されていません。メールが有効であることを確認するために手動で確認できます。',
        'verify_email_button' => 'メールを確認',
        'verify_email_confirmation' => 'メール確認の確認',
        'verify_email_confirmation_desc' => ':nameのメールアドレス:emailを確認してもよろしいですか？これにより、メールが確認済みとしてマークされます。',
        'verify_email_success' => ':nameのメール:emailが正常に確認されました。',
        'email_already_verified' => 'このメールアドレスはすでに確認済みです。',
        'resend_confirmation_button' => '確認メールを再送信',
        'resend_confirmation_title' => '確認メールを再送信',
        'resend_confirmation_desc' => ':nameの:emailに確認メールを再送信してもよろしいですか？これにより、新しい確認リンクがメールアドレスに送信されます。',
        'resend_confirmation_success' => '確認メールが:emailに送信されました。',
        'resend_confirmation_error' => '確認メールの送信に失敗しました。もう一度お試しください。',
        'customer_verified_successfully' => 'この顧客は確認済みで、信頼できます。',
        'customer_not_verified_yet' => 'この顧客はまだ確認されていません。',
        'verification_pending' => '確認保留中',
        'click_verify_to_approve' => '下のボタンをクリックして、この顧客を確認し、確認済みバッジを表示します。',
        'verification_note' => '確認備考',
        'verification_note_placeholder' => 'この確認アクションに関する備考を入力...',
        'verification_note_helper' => '確認プロセスに関する備考を追加（内部使用のみ）',
        'forms' => [
            'name' => '名前',
            'email' => 'メール',
            'phone' => '電話',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'アバター',
            'dob' => '生年月日',
            'company' => '会社',
            'position' => '役職',
            'password' => 'パスワード',
            'password_confirmation' => 'パスワード確認',
            'change_password' => 'パスワードを変更？',
            'phone_placeholder' => '電話',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => 'ベンダー',
        'view' => ':nameを表示',
        'information' => 'ベンダー情報',
        'total_cars' => '総車両数',
        'total_bookings' => '総予約数',
        'verified' => '確認済み',
        'not_verified' => '未確認',
        'verification_section' => 'ベンダー確認',
        'vendor_verified_successfully' => 'このベンダーは確認済みで、信頼できます。',
        'vendor_not_verified_yet' => 'このベンダーはまだ確認されていません。',
        'verification_pending' => '確認保留中',
        'click_verify_to_approve' => '下のボタンをクリックして、このベンダーを確認し、確認済みバッジを表示します。',
        'verify_vendor' => 'ベンダーを確認',
        'unverify_vendor' => 'ベンダーの確認を解除',
        'verify_vendor_confirmation' => 'ベンダー確認の確認',
        'verify_vendor_confirmation_desc' => ':nameを確認してもよろしいですか？これにより、プロフィールに確認済みバッジが表示されます。',
        'unverify_vendor_confirmation' => 'ベンダー確認解除の確認',
        'unverify_vendor_confirmation_desc' => ':nameから確認を削除してもよろしいですか？確認済みバッジが削除されます。',
        'verified_successfully' => 'ベンダーが正常に確認されました。',
        'unverified_successfully' => 'ベンダーの確認が正常に削除されました。',
        'already_verified' => 'このベンダーはすでに確認済みです。',
        'not_verified_yet' => 'このベンダーはまだ確認されていません。',
        'recent_activity' => '最近のアクティビティ',
        'recent_cars' => '最近の車両',
        'recent_bookings' => '最近の予約',
        'no_cars_yet' => 'まだ車両が追加されていません。',
        'no_bookings_yet' => 'まだ予約を受けていません。',
    ],
    'make' => [
        'name' => 'メーカー',
        'create' => '車両メーカーを作成',
        'forms' => [
            'logo' => 'ロゴ',
            'logo_dark' => 'ダークロゴ',
        ],
    ],
    'car' => [
        'name' => '車両',
        'create' => '車両を作成',
        'forms' => [
            'car' => '車両',
            'logo' => 'ロゴ',
            'license_plate' => 'ナンバープレート',
            'make' => 'メーカー',
            'model' => 'モデル',
            'name' => '名前',
            'images' => '画像',
            'year' => '年式',
            'color' => '色',
            'mileage' => '走行距離',
            'kilometers' => 'キロメートル',
            'horsepower' => '馬力',
            'vehicle_type' => '車両タイプ',
            'transmission' => 'トランスミッション',
            'fuel_type' => '燃料タイプ',
            'rental_rate' => 'レンタル料金',
            'currency' => '通貨',
            'status' => 'ステータス',
            'availability' => '空き状況',
            'insurance_info' => '保険情報',
            'number_of_seats' => 'シート数',
            'number_of_doors' => 'ドア数',
            'vin' => 'VIN',
            'maintenance_history' => 'メンテナンス履歴',
            'location' => 'ロケーション',
            'description' => '説明',
            'rental_type' => 'レンタルタイプ',
            'tags' => 'タグ',
            'add_new_attribute' => '<a href=":url" target="_blank">ここ</a>で新規追加。',
            'categories' => 'カテゴリー',
            'pick_address' => 'ピックアップ住所',
            'return_address' => '返却住所',
            'same_drop_off' => '同じ返却場所',
            'tax' => '税',
            'select_tax' => '税を選択',
            'none' => 'なし',
            'colors' => '色',
            'amenities' => 'アメニティ',
            'is_used' => '中古？',
            'moderation_status' => 'モデレーションステータス',
            'status_moderation' => [
                'approve' => '承認',
                'reject' => '拒否',
                'approve_title' => '車両を承認',
                'approve_message' => 'この車両を承認してもよろしいですか？このアクションは元に戻せません。',
                'reject_title' => '車両を拒否',
                'reject_message' => 'この車両を拒否してもよろしいですか？このアクションは元に戻せません。',
                'reject_reason' => '拒否理由を入力',
                'approved' => '車両が正常に承認されました！',
                'rejected' => '車両が正常に拒否されました！',
                'reason_rejected' => '拒否理由',
            ],
            'customer' => '顧客',
            'select_customer' => '顧客を選択...',
            'vendor_images' => '画像（最大:max枚）',
            'images_upload_placeholder' => 'ファイルをここにドロップするか、クリックしてアップロードしてください。',
            'car_purpose' => '車両の目的',
            'for_rent' => 'レンタル用',
            'for_sale' => '販売用',
            'car_type' => '車両タイプ',
            'rental_information' => 'レンタル情報',
            'sale_statuses' => [
                'available' => '利用可能',
                'sold' => '売却済み',
                'reserved' => '予約済み',
            ],
            'selling_information' => '販売情報',
            'is_for_sale' => '販売可能',
            'sale_price' => '販売価格',
            'sale_price_placeholder' => '販売価格を入力',
            'condition' => '状態',
            'select_condition' => '状態を選択',
            'condition_options' => [
                'new' => '新品',
                'like_new' => '新品同様',
                'excellent' => '優良',
                'good' => '良好',
                'fair' => '普通',
                'poor' => '不良',
            ],
            'ownership_history' => '所有履歴',
            'ownership_history_placeholder' => '所有履歴を入力',
            'warranty_information' => '保証情報',
            'warranty_information_placeholder' => '保証情報を入力',
            'sale_status' => '販売ステータス',
            'external_booking_url' => 'オフサイト予約リンク',
            'external_booking_url_helper' => 'このプラットフォーム外で顧客がこの車両を予約できる外部URLを入力してください。このサイトでのみ予約可能な場合は空欄にしてください。',
            'address' => '住所',
            'address_helper' => 'この車両がある具体的な住所を入力してください',
        ],
        'car_purposes' => [
            'sale' => '販売用',
            'rent' => 'レンタル用',
        ],
        'placeholders' => [
            'name' => '車両名を入力（例：トヨタ カムリ 2023、ホンダ CR-Vなど）',
            'description' => '主要機能を強調した車両の簡単な説明を入力',
            'rental_rate' => '選択したレンタルタイプに基づくレンタル料金を入力',
            'location' => '車両の物理的な場所を入力',
            'address' => '具体的な住所を入力（例：東京都渋谷区渋谷1-2-3）',
            'sale_price' => 'この車両の販売価格を入力',
            'ownership_history' => '前のオーナー、オーナー数などの詳細を入力',
            'warranty_information' => '保証の範囲、有効期限などの詳細を入力',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => '車両ナンバープレート番号を入力',
            'vin' => '車両識別番号（VIN）を入力',
            'year' => '製造年を入力（例：2023）',
            'mileage' => '現在の走行距離を入力',
            'kilometers' => '現在のキロメートルを入力',
            'horsepower' => '車両の馬力（HP）を入力（例：150.5）',
            'number_of_seats' => '車両のシート数を入力',
            'number_of_doors' => '車両のドア数を入力',
            'insurance_info' => 'この車両の関連保険情報を入力',
            'tags' => 'タグを選択または作成',
            'amenities' => 'アメニティを選択',
            'colors' => '色を選択または作成',
        ],
        'enums' => [
            'vendor_status' => 'ベンダーステータス',
            'is_vendor' => 'ベンダー',
            'not_vendor' => '顧客',
            'statuses' => [
                'available' => '利用可能',
                'rented' => 'レンタル中',
                'maintenance' => 'メンテナンス中',
                'out_of_service' => 'サービス外',
            ],
            'rental_types' => [
                'per_hour' => '1時間あたり',
                'per_day' => '1日あたり',
                'per_week' => '1週間あたり',
                'per_month' => '1ヶ月あたり',
            ],
            'moderation_statuses' => [
                'pending' => '保留中',
                'approved' => '承認済み',
                'rejected' => '拒否済み',
            ],
        ],
        'maintenance_history' => [
            'name' => 'メンテナンス履歴',
            'create' => 'サービス履歴を作成',
            'amount' => '金額',
            'forms' => [
                'price_placeholder' => 'サービス価格',
                'currency' => '通貨',
                'none' => 'なし',
                'name' => '名前',
                'amount' => '金額',
                'created_at' => '作成日',
                'action' => 'アクション',
                'date' => '日付',
                'no_maintenance_history' => 'メンテナンス履歴なし',
                'edit_maintenance_history' => 'メンテナンス履歴を編集',
                'add_maintenance_history' => 'メンテナンス履歴を追加',
                'add' => '追加',
                'edit' => '編集',
                'delete' => '削除',
            ],
        ],
    ],
    'attribute' => [
        'name' => '車両属性',
        'car_type' => [
            'name' => 'タイプ',
            'create' => '車両タイプを作成',
            'forms' => [
                'name' => '名前',
            ],
        ],
        'transmission' => [
            'name' => 'トランスミッション',
            'create' => 'トランスミッションを作成',
            'forms' => [
                'name' => '名前',
            ],
        ],
        'fuel_type' => [
            'name' => '燃料',
            'create' => '燃料タイプを作成',
            'forms' => [
                'name' => '名前',
            ],
        ],
        'tag' => [
            'name' => 'タグ',
            'create' => 'タグを作成',
        ],
        'category' => [
            'name' => 'カテゴリー',
            'create' => 'カテゴリーを作成',
            'forms' => [
                'none' => 'なし',
                'total_cars' => '総車両数：:total',
            ],
        ],
        'address' => [
            'name' => 'ロケーション',
            'create' => '車両ロケーションを作成',
            'form' => [
                'name' => '住所',
                'full_address' => '完全な住所',
                'detail_address' => '詳細住所',
            ],
        ],
        'color' => [
            'name' => '色',
            'create' => '色を作成',
        ],
        'amenity' => [
            'name' => 'アメニティ',
            'create' => 'アメニティを作成',
        ],
    ],
    'tax' => [
        'name' => '税',
        'create' => '税を作成',
        'forms' => [
            'name' => '名前',
            'name_placeholder' => '名前を入力',
            'percentage' => 'パーセンテージ',
            'percentage_placeholder' => 'パーセンテージ',
            'percent_placeholder' => 'パーセンテージ',
            'priority' => '優先度',
            'priority_placeholder' => '優先度',
        ],
    ],
    'review' => [
        'name' => 'レビュー',
        'create' => 'レビューを作成',
        'edit' => 'レビューを編集',
        'vendor' => [
            'title' => '顧客レビュー',
            'description' => '車両のすべての顧客レビューを管理',
            'no_reviews' => 'まだレビューはありません',
            'filter_by_car' => '車両でフィルター',
            'filter_by_rating' => '評価でフィルター',
            'filter_by_date' => '日付でフィルター',
            'all_cars' => 'すべての車両',
            'all_ratings' => 'すべての評価',
            'manage_reviews' => 'レビューを管理',
            'view_all' => 'すべてのレビューを表示',
            'delete_review_confirmation' => 'このレビューを削除してもよろしいですか？',
            'delete_review_success' => 'レビューが正常に削除されました',
            'cannot_delete' => 'このレビューを削除できません',
        ],
        'forms' => [
            'customer' => '顧客',
            'car' => '車両',
            'content' => 'コンテンツ',
            'rating' => '評価',
            'your_name' => 'お名前',
            'email_address' => 'メールアドレス',
            'submit' => '送信',
            'star' => '星',
            'status' => 'ステータス',
            'created_at' => '作成日',
            'select_car' => '車両を選択',
            'select_rating' => '評価を選択',
            'comment' => 'コメント',
            'reply' => '返信',
            'reply_to_review' => 'レビューに返信',
            'save_reply' => '返信を保存',
            'cancel_reply' => 'キャンセル',
        ],
        'statuses' => [
            'published' => '公開済み',
            'pending' => '保留中',
            'rejected' => '拒否済み',
        ],
        'ratings' => [
            1 => '1つ星 - 悪い',
            '2つ星 - 普通',
            '3つ星 - 良い',
            '4つ星 - 非常に良い',
            '5つ星 - 優秀',
        ],
    ],
    'coupon' => [
        'name' => 'クーポン',
        'create' => 'クーポンを作成',
        'types' => [
            'percentage' => 'パーセンテージ%',
            'money' => '金額',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'サービス',
        'create' => 'サービスを作成',
        'forms' => [
            'name' => '名前',
            'content' => 'コンテンツ',
            'price' => '価格',
            'currency' => '通貨',
            'image' => '画像',
            'logo' => 'ロゴ',
            'status' => 'ステータス',
        ],
    ],
    'availability_calendar' => [
        'name' => '空き状況カレンダー',
        'title' => '空き状況カレンダー',
        'description' => 'カレンダー形式で車両の空き状況と予約を表示',
        'select_dates' => '空き状況を確認する日付を選択',
        'car_filter' => '車両でフィルター',
        'all_cars' => 'すべての車両',
        'clear_filter' => 'フィルターをクリア',
        'availability_check' => '車両空き状況チェック',
        'selected_period' => '選択期間',
        'checking_availability' => '空き状況を確認中...',
        'available' => '利用可能',
        'not_available' => '利用不可',
        'booking_details' => '予約詳細',
        'how_to_use' => '車両空き状況カレンダーの使い方',
        'viewing_bookings' => '予約の表示',
        'checking_availability_help' => '空き状況の確認',
        'color_legend' => '色の凡例',
        'pending_bookings' => '保留中の予約',
        'processing_bookings' => '処理中の予約',
        'completed_bookings' => '完了した予約',
        'cancelled_bookings' => 'キャンセルされた予約',
        'unknown_make' => '不明なメーカー',
        'loading' => '読み込み中...',
        'loading_calendar_data' => 'カレンダーデータを読み込み中...',
        'loading_booking_details' => '予約詳細を読み込み中...',
        'please_wait_booking_info' => '予約情報を取得していますので、お待ちください。',
        'please_wait_availability' => '選択した日付の車両の空き状況を確認していますので、お待ちください。',
        'error' => 'エラー',
        'error_loading_booking' => '予約詳細の読み込みに失敗しました。もう一度お試しください。',
        'error_checking_availability' => '車両の空き状況の確認エラー',
        'customer' => '顧客',
        'status' => 'ステータス',
        'amount' => '金額',
        'make' => 'メーカー',
        'vendor' => 'ベンダー',
        'per_day' => '/日',
        'edit_car' => '車両を編集',
        'no_cars_found' => '車両が見つかりません',
        'no_cars_available_period' => '選択期間に利用可能な車両はありません。',
        'close' => '閉じる',
        'edit_booking' => '予約を編集',
        'pending' => '保留中',
        'processing' => '処理中',
        'completed' => '完了',
        'cancelled' => 'キャンセル',
    ],
    'theme_options' => [
        'name' => 'レンタカー',
        'description' => 'レンタカーのテーマオプション',
        'car_location_filter_by' => '車両ロケーションフィルター',
        'state' => '都道府県',
        'city' => '市区町村',
        'yes' => 'はい',
        'no' => 'いいえ',
        'is_display_country' => 'ロケーションフィルターに国を表示？',
        'logo_vendor_dashboard' => 'ベンダーダッシュボードのロゴ（デフォルトはメインロゴ）',
        'number_of_cars_per_page' => 'ページあたりの車両数',
        'number_of_cars_per_page_placeholder' => 'ページあたりに表示する車両数を入力',
    ],
    'message' => [
        'name' => 'メッセージ',
        'forms' => [
            'customer_name' => '顧客名',
            'message' => 'メッセージ',
            'phone' => '電話',
            'email' => 'メール',
            'created_at' => '作成日',
            'status' => 'ステータス',
        ],
    ],
    'car_sale' => [
        'name' => '車両販売',
        'create' => '新規車両販売',
        'edit' => '車両販売を編集:name',
        'statuses' => [
            'pending' => '保留中',
            'processing' => '処理中',
            'completed' => '完了',
            'cancelled' => 'キャンセル',
        ],
        'forms' => [
            'transaction_id' => '取引ID',
            'transaction_id_placeholder' => '取引IDを入力',
            'car_id' => '車両',
            'car' => '車両',
            'customer_id' => '顧客',
            'customer_name' => '顧客名',
            'customer_name_placeholder' => '顧客名を入力',
            'customer_email' => '顧客メール',
            'customer_email_placeholder' => '顧客メールを入力',
            'customer_phone' => '顧客電話',
            'customer_phone_placeholder' => '顧客電話を入力',
            'sale_price' => '販売価格',
            'sale_price_placeholder' => '販売価格を入力',
            'tax_amount' => '税額',
            'tax_amount_placeholder' => '税額を入力',
            'total_amount' => '合計金額',
            'total_amount_placeholder' => '合計金額を入力',
            'payment_details' => '支払い詳細',
            'payment_details_placeholder' => '支払い詳細を入力',
            'notes' => '備考',
            'notes_placeholder' => '備考を入力',
            'sale_date' => '販売日',
            'delivery_date' => '配送日',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => '銀行振込',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        'booking_confirm_title' => 'レンタカー予約確認',
        'booking_confirm_greeting' => ':customer_name様',
        'booking_confirm_message' => 'レンタカーの予約が正常に確認されたことをお知らせいたします！',
        'customer_information' => '顧客情報',
        'booking_information' => '予約情報',
        'field_name' => '名前：',
        'field_phone' => '電話：',
        'field_email' => 'メール：',
        'field_car_model' => '車両モデル：',
        'field_start_date' => '開始日：',
        'field_end_date' => '終了日：',
        'field_pickup_address' => 'ピックアップ住所：',
        'field_return_address' => '返却住所：',
        'field_note' => '備考：',
        'field_order_number' => '注文番号',
        'field_payment_method' => '支払い方法',
        'booking_notice_admin_title' => '新規予約通知',
        'booking_notice_admin_greeting' => 'こんにちは、:site_titleから新しい予約があります：',
        'booking_notice_admin_message' => '新しいレンタカーの予約が送信され、対応が必要です。',
        'booking_view_detail' => '予約詳細を表示：',
        'view_booking_details' => '予約詳細を表示',
        'booking_notice_vendor_title' => '車両の新規予約',
        'booking_notice_vendor_greeting' => ':vendor_name様',
        'booking_notice_vendor_message' => '素晴らしいニュースです！レンタカーの新しい予約を受け取りました。',
        'booking_status_updated' => '予約ステータスが更新されました',
        'hello_thanks_for_booking' => 'こんにちは、:site_titleで予約していただきありがとうございます：',
        'booking_status_change_message' => 'このメッセージが良い状態であることを願っています。予約のステータスが更新されたことをお知らせします。',
        'name' => '名前',
        'phone' => '電話',
        'email' => 'メール',
        'car_model' => '車両モデル',
        'start_date' => '開始日',
        'end_date' => '終了日',
        'pickup_address' => 'ピックアップ住所',
        'return_address' => '返却住所',
        'note' => '備考',
        'order_number' => '注文番号',
        'payment_method' => '支払い方法',
        'hello' => 'こんにちは',
        'car_approved_title' => '素晴らしいニュース！車両が承認されました',
        'car_approved_message' => '車両リスト「:car_name」が承認され、:site_titleで公開されたことをお知らせします。すぐに予約を受け取り、リストを管理できます。',
        'view_edit_car_link' => '車両リストを表示または編集するには、このリンクをクリックしてください',
        'view_car' => '車両リストを表示',
        'regards' => 'よろしくお願いいたします',
        'vendor_upgrade_title' => 'おめでとうございます！あなたは今ベンダーです',
        'vendor_upgrade_congratulations' => 'アカウントが正常にベンダーステータスにアップグレードされたことをお知らせします！',
        'vendor_upgrade_message' => ':site_titleで独自の車両をリストして管理できるようになりました。これにより、当社とレンタルビジネスを成長させる新しい機会が開かれます。',
        'vendor_benefits_title' => '新しいベンダーの特典',
        'vendor_benefit_1' => 'レンタル用の無制限の車両をリスト',
        'vendor_benefit_2' => '独自の予約と顧客を管理',
        'vendor_benefit_3' => '収益とパフォーマンス指標を追跡',
        'vendor_benefit_4' => 'ベンダー限定の機能とツールへのアクセス',
        'next_steps' => '次のステップ',
        'vendor_next_steps_message' => 'ベンダーダッシュボードにログインして、車両の追加とレンタルビジネスの管理を開始してください。',
        'go_to_dashboard' => 'ベンダーダッシュボードに移動',
        'vendor_support_message' => 'ご質問やサポートが必要な場合は、当社のサポートチームがお手伝いいたします。',
        'approved' => '承認済み',
        'car_rejected_title' => '車両リストの更新が必要です',
        'car_rejected_message' => '車両リスト「:car_name」を:site_titleに送信していただきありがとうございます。送信内容を確認した結果、承認する前にいくつかの調整が必要です。',
        'rejection_reason' => '更新が必要な内容',
        'rejection_details' => '必要な更新',
        'contact_support' => 'これらの更新についてご質問やサポートが必要な場合は、:site_emailのサポートチームにお気軽にお問い合わせください。リストの承認を迅速に行うためにお手伝いいたします。',
        'verify_email' => 'メールを確認',
        'welcome_message' => 'ご参加いただきありがとうございます、:customer_name様！',
        'verify_email_instruction' => 'このウェブサイトにアクセスするには、メールアドレスを確認してください。以下のボタンをクリックしてメールを確認してください。',
        'confirm_email_button' => 'メールアドレスを確認',
        'verify_link_trouble' => '「メールアドレスを確認」ボタンのクリックに問題がある場合は、以下のURLをコピーしてウェブブラウザに貼り付けてください：:verify_linkとブラウザに貼り付けてください。',
        'new_message' => '新しいメッセージ',
        'dear_admin' => '管理者様',
        'new_message_from' => ':site_titleから新しいメッセージがあります：',
        'subject' => '件名',
        'address' => '住所',
        'content' => 'コンテンツ',
        'hi_admin' => 'こんにちは、管理者様',
        'new_car_pending_title' => 'レビュー待ちの新しい車両リスト',
        'new_car_pending_approval' => ':post_authorが新しい車両リスト「:post_name」を送信し、レビューの準備ができています。',
        'pending_approval' => 'レビュー待ち',
        'review_car_admin' => '管理パネルでこのリストをレビューし、承認するか更新をリクエストしてください。',
        'car_information' => '車両情報',
        'field_car_name' => '車両名：',
        'field_author' => '著者：',
        'field_status' => 'ステータス：',
        'actions' => 'アクション',
        'reset_password_instruction' => 'パスワードリセット手順',
        'password_reset_request' => 'アカウントのパスワードリセットリクエストを受け取ったため、このメールを受信しています。',
        'reset_password_button' => 'パスワードをリセット',
        'reset_link_trouble' => '「パスワードをリセット」ボタンのクリックに問題がある場合は、以下のURLをコピーしてウェブブラウザに貼り付けてください：:reset_linkとブラウザに貼り付けてください。パスワードリセットをリクエストしていない場合は、このメッセージを無視するか、ご質問がある場合はお問い合わせください。',
    ],
];
