<?php

return [
    'name' => 'Autoverhuur',
    'customer' => [
        'name' => 'Klanten',
        'create' => 'Klant Aanmaken',
        'view' => 'Bekijken',
        'information' => 'Klantinformatie',
        'email' => 'E-mail',
        'phone' => 'Telefoon',
        'status' => 'Status',
        'vendor_status' => 'Verhuurderstatus',
        'is_vendor' => 'Verhuurder',
        'not_vendor' => 'Klant',
        'recent_activity' => 'Recente Activiteit',
        'recent_activity_description' => 'Klantactiviteit wordt hier weergegeven.',
        'verification_section' => 'Klantverificatie',
        'verified' => 'Geverifieerd',
        'not_verified' => 'Niet Geverifieerd',
        'verified_by' => 'Geverifieerd Door',
        'verified_at' => 'Geverifieerd Op',
        'verify_customer' => 'Klant Verifiëren',
        'unverify_customer' => 'Verificatie Verwijderen',
        'verify_customer_confirmation' => 'Bevestiging Klantverificatie',
        'verify_customer_confirmation_desc' => 'Weet u zeker dat u :name wilt verifiëren? Dit toont een geverifieerd badge op hun profiel.',
        'unverify_customer_confirmation' => 'Bevestiging Verwijderen Verificatie',
        'unverify_customer_confirmation_desc' => 'Weet u zeker dat u de verificatie van :name wilt verwijderen? Het geverifieerde badge wordt verwijderd.',
        'verify_success' => 'Klant :name is succesvol geverifieerd.',
        'unverify_success' => 'Klantverificatie :name is succesvol verwijderd.',
        'already_verified' => 'Deze klant is al geverifieerd.',
        'already_unverified' => 'Deze klant is niet geverifieerd.',
        'upgrade_to_vendor_title' => 'Upgraden naar Verhuurder',
        'upgrade_to_vendor_description' => 'Upgrade deze klant naar verhuurderstatus zodat ze hun eigen autoverhuur kunnen aanbieden en beheren.',
        'upgrade_to_vendor_button' => 'Upgraden naar Verhuurder',
        'upgrade_to_vendor_confirmation' => 'Bevestig Upgrade naar Verhuurder',
        'upgrade_to_vendor_confirmation_desc' => 'Weet u zeker dat u :name wilt upgraden naar verhuurderstatus? Dit stelt hen in staat om hun eigen auto\'s op het platform aan te bieden en te beheren.',
        'upgrade_to_vendor_success' => ':name is succesvol geüpgraded naar verhuurderstatus.',
        'already_vendor' => 'Deze klant is al een verhuurder.',
        'customer_verified_successfully' => 'Deze klant is geverifieerd en kan worden vertrouwd.',
        'customer_not_verified_yet' => 'Deze klant is nog niet geverifieerd.',
        'verification_pending' => 'Verificatie In Behandeling',
        'click_verify_to_approve' => 'Klik op de knop hieronder om deze klant te verifiëren en het geverifieerde badge weer te geven.',
        'verification_note' => 'Verificatienotitie',
        'verification_note_placeholder' => 'Voer eventuele notities over deze verificatie-actie in...',
        'verification_note_helper' => 'Voeg notities toe over het verificatieproces (alleen intern gebruik)',
        'forms' => [
            'name' => 'Naam',
            'email' => 'E-mail',
            'phone' => 'Telefoon',
            'avatar' => 'Avatar',
            'dob' => 'Geboortedatum',
            'company' => 'Bedrijf',
            'position' => 'Functie',
            'password' => 'Wachtwoord',
            'password_confirmation' => 'Wachtwoordbevestiging',
            'change_password' => 'Wachtwoord wijzigen?',
            'phone_placeholder' => 'Telefoon',
        ],
    ],
    'vendor' => [
        'name' => 'Verhuurders',
        'view' => 'Bekijk :name',
        'information' => 'Verhuurderinformatie',
        'total_cars' => 'Totaal Auto\'s',
        'total_bookings' => 'Totaal Boekingen',
        'verified' => 'Geverifieerd',
        'not_verified' => 'Niet Geverifieerd',
        'verification_section' => 'Verhuurderverificatie',
        'vendor_verified_successfully' => 'Deze verhuurder is geverifieerd en kan worden vertrouwd.',
        'vendor_not_verified_yet' => 'Deze verhuurder is nog niet geverifieerd.',
        'verification_pending' => 'Verificatie In Behandeling',
        'click_verify_to_approve' => 'Klik op de knop hieronder om deze verhuurder te verifiëren en het geverifieerde badge weer te geven.',
        'verify_vendor' => 'Verhuurder Verifiëren',
        'unverify_vendor' => 'Verificatie Verwijderen',
        'verify_vendor_confirmation' => 'Bevestiging Verhuurderverificatie',
        'verify_vendor_confirmation_desc' => 'Weet u zeker dat u :name wilt verifiëren? Dit toont een geverifieerd badge op hun profiel.',
        'unverify_vendor_confirmation' => 'Bevestiging Verwijderen Verificatie',
        'unverify_vendor_confirmation_desc' => 'Weet u zeker dat u de verificatie van :name wilt verwijderen? Het geverifieerde badge wordt verwijderd.',
        'verified_successfully' => 'Verhuurder is succesvol geverifieerd.',
        'unverified_successfully' => 'Verhuurderverificatie is succesvol verwijderd.',
        'already_verified' => 'Deze verhuurder is al geverifieerd.',
        'not_verified_yet' => 'Deze verhuurder is nog niet geverifieerd.',
        'recent_activity' => 'Recente Activiteit',
        'recent_cars' => 'Recente Auto\'s',
        'recent_bookings' => 'Recente Boekingen',
        'no_cars_yet' => 'Nog geen auto\'s toegevoegd.',
        'no_bookings_yet' => 'Nog geen boekingen ontvangen.',
    ],
    'make' => [
        'name' => 'Merken',
        'create' => 'Automerk Aanmaken',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Donker',
        ],
    ],
    'car' => [
        'name' => 'Auto\'s',
        'create' => 'Auto Aanmaken',
        'forms' => [
            'car' => 'Auto',
            'logo' => 'Logo',
            'license_plate' => 'Kenteken',
            'make' => 'Merk',
            'model' => 'Model',
            'name' => 'Naam',
            'images' => 'Afbeeldingen',
            'year' => 'Bouwjaar',
            'color' => 'Kleur',
            'mileage' => 'Kilometerstand',
            'kilometers' => 'Kilometers',
            'horsepower' => 'Paardenkracht',
            'vehicle_type' => 'Voertuigtype',
            'transmission' => 'Transmissie',
            'fuel_type' => 'Brandstoftype',
            'rental_rate' => 'Huurtarief',
            'currency' => 'Valuta',
            'status' => 'Status',
            'availability' => 'Beschikbaarheid',
            'insurance_info' => 'Verzekeringsinformatie',
            'number_of_seats' => 'Aantal Zitplaatsen',
            'number_of_doors' => 'Aantal Deuren',
            'vin' => 'VIN',
            'maintenance_history' => 'Onderhoudsgeschiedenis',
            'location' => 'Locatie',
            'description' => 'Beschrijving',
            'rental_type' => 'Huurtype',
            'tags' => 'Tags',
            'add_new_attribute' => 'Nieuw attribuut toevoegen <a href=":url" target="_blank">hier</a>.',
            'categories' => 'Categorieën',
            'pick_address' => 'Ophaaladres',
            'return_address' => 'Retouradres',
            'same_drop_off' => 'Zelfde Inleverlocatie',
            'tax' => 'Belasting',
            'select_tax' => 'Selecteer Belasting',
            'none' => 'Geen',
            'colors' => 'Kleuren',
            'amenities' => 'Voorzieningen',
            'is_used' => 'Is gebruikt?',
            'moderation_status' => 'Moderatiestatus',
            'status_moderation' => [
                'approve' => 'Goedkeuren',
                'reject' => 'Afwijzen',
                'approve_title' => 'Auto goedkeuren',
                'approve_message' => 'Weet u zeker dat u deze auto wilt goedkeuren? Deze actie kan niet ongedaan worden gemaakt.',
                'reject_title' => 'Auto afwijzen',
                'reject_message' => 'Weet u zeker dat u deze auto wilt afwijzen? Deze actie kan niet ongedaan worden gemaakt.',
                'reject_reason' => 'Voer de reden voor afwijzing in',
                'approved' => 'Auto is succesvol goedgekeurd!',
                'rejected' => 'Auto is succesvol afgewezen!',
                'reason_rejected' => 'Reden van afwijzing',
            ],
            'customer' => 'Klant',
            'select_customer' => 'Selecteer een klant...',
            'vendor_images' => 'Afbeeldingen (Maximaal :max afbeeldingen)',
            'images_upload_placeholder' => 'Sleep bestanden hierheen of klik om te uploaden.',
            'car_purpose' => 'Auto Doel',
            'for_rent' => 'Te Huur',
            'for_sale' => 'Te Koop',
            'car_type' => 'Autotype',
            'rental_information' => 'Huurinformatie',
            'sale_statuses' => [
                'available' => 'Beschikbaar',
                'sold' => 'Verkocht',
                'reserved' => 'Gereserveerd',
            ],
            'selling_information' => 'Verkoop Informatie',
            'is_for_sale' => 'Te koop beschikbaar',
            'sale_price' => 'Verkoopprijs',
            'sale_price_placeholder' => 'Voer verkoopprijs in',
            'condition' => 'Conditie',
            'select_condition' => 'Selecteer Conditie',
            'condition_options' => [
                'new' => 'Nieuw',
                'like_new' => 'Als Nieuw',
                'excellent' => 'Uitstekend',
                'good' => 'Goed',
                'fair' => 'Redelijk',
                'poor' => 'Slecht',
            ],
            'ownership_history' => 'Eigendomsgeschiedenis',
            'ownership_history_placeholder' => 'Voer eigendomsgeschiedenis in',
            'warranty_information' => 'Garantie-informatie',
            'warranty_information_placeholder' => 'Voer garantie-informatie in',
            'sale_status' => 'Verkoopstatus',
            'external_booking_url' => 'Externe Boekingslink',
            'external_booking_url_helper' => 'Voer de externe URL in waar klanten deze auto kunnen boeken buiten dit platform. Laat leeg als boeken alleen op deze site beschikbaar is.',
            'address' => 'Adres',
            'address_helper' => 'Voer het specifieke straat adres in waar dit voertuig zich bevindt',
        ],
        'car_purposes' => [
            'sale' => 'Te Koop',
            'rent' => 'Te Huur',
        ],
        'placeholders' => [
            'name' => 'Voer de voertuignaam in (bijv. Toyota Camry 2023, Honda CR-V, enz.)',
            'description' => 'Voer een korte beschrijving van het voertuig in met belangrijke kenmerken',
            'rental_rate' => 'Voer het huurtarief in op basis van het geselecteerde huurtype',
            'location' => 'Voer de fysieke locatie van het voertuig in',
            'address' => 'Voer het specifieke straat adres in (bijv. Hoofdstraat 123, Stad, Provincie)',
            'sale_price' => 'Voer de verkoopprijs voor dit voertuig in',
            'ownership_history' => 'Voer details in over vorige eigenaren, aantal eigenaren, enz.',
            'warranty_information' => 'Voer details in over garantiedekking, vervaldatum, enz.',
            'external_booking_url' => 'https://voorbeeld.nl/boekingslink',
            'license_plate' => 'Voer kenteken in',
            'vin' => 'Voer het Voertuig Identificatie Nummer (VIN) in',
            'year' => 'Voer het productiejaar in (bijv. 2023)',
            'mileage' => 'Voer de huidige kilometerstand in',
            'kilometers' => 'Voer de huidige kilometers in',
            'horsepower' => 'Voer de paardenkracht (PK) van het voertuig in (bijv. 150,5)',
            'number_of_seats' => 'Voer het aantal zitplaatsen in het voertuig in',
            'number_of_doors' => 'Voer het aantal deuren van het voertuig in',
            'insurance_info' => 'Voer relevante verzekeringsinformatie voor dit voertuig in',
            'tags' => 'Selecteer of maak tags aan',
            'amenities' => 'Selecteer voorzieningen',
            'colors' => 'Selecteer of maak kleuren aan',
        ],
        'enums' => [
            'vendor_status' => 'Verhuurderstatus',
            'is_vendor' => 'Verhuurder',
            'not_vendor' => 'Klant',
            'statuses' => [
                'available' => 'Beschikbaar',
                'rented' => 'Verhuurd',
                'maintenance' => 'Onderhoud',
                'out_of_service' => 'Buiten Dienst',
            ],
            'rental_types' => [
                'per_hour' => 'Per uur',
                'per_day' => 'Per dag',
                'per_week' => 'Per week',
                'per_month' => 'Per maand',
            ],
            'moderation_statuses' => [
                'pending' => 'In Behandeling',
                'approved' => 'Goedgekeurd',
                'rejected' => 'Afgewezen',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Onderhoudsgeschiedenis',
            'create' => 'Servicegeschiedenis Aanmaken',
            'amount' => 'Bedrag',
            'forms' => [
                'price_placeholder' => 'Serviceprijs',
                'currency' => 'Valuta',
                'none' => 'Geen',
                'name' => 'Naam',
                'amount' => 'Bedrag',
                'created_at' => 'Aangemaakt Op',
                'action' => 'Actie',
                'date' => 'Datum',
                'no_maintenance_history' => 'Geen onderhoudsgeschiedenis',
                'edit_maintenance_history' => 'Onderhoudsgeschiedenis bewerken',
                'add_maintenance_history' => 'Onderhoudsgeschiedenis toevoegen',
                'add' => 'Toevoegen',
                'edit' => 'Bewerken',
                'delete' => 'Verwijderen',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Auto-attributen',
        'car_type' => [
            'name' => 'Types',
            'create' => 'Autotype Aanmaken',
            'forms' => [
                'name' => 'Naam',
            ],
        ],
        'transmission' => [
            'name' => 'Transmissies',
            'create' => 'Transmissie Aanmaken',
            'forms' => [
                'name' => 'Naam',
            ],
        ],
        'fuel_type' => [
            'name' => 'Brandstoffen',
            'create' => 'Brandstoftype Aanmaken',
            'forms' => [
                'name' => 'Naam',
            ],
        ],
        'tag' => [
            'name' => 'Tags',
            'create' => 'Tag Aanmaken',
        ],
        'category' => [
            'name' => 'Categorieën',
            'create' => 'Categorie Aanmaken',
            'forms' => [
                'none' => 'Geen',
                'total_cars' => 'Totaal auto\'s: :total',
            ],
        ],
        'address' => [
            'name' => 'Locaties',
            'create' => 'Autolocatie Aanmaken',
            'form' => [
                'name' => 'Adres',
                'full_address' => 'Volledig Adres',
                'detail_address' => 'Gedetailleerd Adres',
            ],
        ],
        'color' => [
            'name' => 'Kleur',
            'create' => 'Kleur Aanmaken',
        ],
        'amenity' => [
            'name' => 'Voorzieningen',
            'create' => 'Voorziening Aanmaken',
        ],
    ],
    'tax' => [
        'name' => 'Belastingen',
        'create' => 'Belasting Aanmaken',
        'forms' => [
            'name' => 'Naam',
            'name_placeholder' => 'Voer naam in',
            'percentage' => 'Percentage',
            'percentage_placeholder' => 'Percentage',
            'percent_placeholder' => 'Percentage',
            'priority' => 'Prioriteit',
            'priority_placeholder' => 'Prioriteit',
        ],
    ],
    'review' => [
        'name' => 'Reviews',
        'create' => 'Review Aanmaken',
        'edit' => 'Review Bewerken',
        'vendor' => [
            'title' => 'Klantreviews',
            'description' => 'Beheer alle klantreviews voor uw auto\'s',
            'no_reviews' => 'U heeft nog geen reviews',
            'filter_by_car' => 'Filter op auto',
            'filter_by_rating' => 'Filter op beoordeling',
            'filter_by_date' => 'Filter op datum',
            'all_cars' => 'Alle Auto\'s',
            'all_ratings' => 'Alle Beoordelingen',
            'manage_reviews' => 'Reviews Beheren',
            'view_all' => 'Alle Reviews Bekijken',
            'delete_review_confirmation' => 'Weet u zeker dat u deze review wilt verwijderen?',
            'delete_review_success' => 'Review succesvol verwijderd',
            'cannot_delete' => 'Kan deze review niet verwijderen',
        ],
        'forms' => [
            'customer' => 'Klant',
            'car' => 'Auto',
            'content' => 'Inhoud',
            'rating' => 'Beoordeling',
            'your_name' => 'Uw Naam',
            'email_address' => 'E-mailadres',
            'submit' => 'Verzenden',
            'star' => 'Ster',
            'status' => 'Status',
            'created_at' => 'Aangemaakt Op',
            'select_car' => 'Selecteer Auto',
            'select_rating' => 'Selecteer Beoordeling',
            'comment' => 'Opmerking',
            'reply' => 'Reageren',
            'reply_to_review' => 'Reageren op Review',
            'save_reply' => 'Reactie Opslaan',
            'cancel_reply' => 'Annuleren',
        ],
        'statuses' => [
            'published' => 'Gepubliceerd',
            'pending' => 'In Behandeling',
            'rejected' => 'Afgewezen',
        ],
        'ratings' => [
            '1' => '1 Ster - Slecht',
            '2' => '2 Sterren - Redelijk',
            '3' => '3 Sterren - Goed',
            '4' => '4 Sterren - Zeer Goed',
            '5' => '5 Sterren - Uitstekend',
        ],
    ],
    'coupon' => [
        'name' => 'Kortingsbonnen',
        'create' => 'Kortingsbon Aanmaken',
        'types' => [
            'percentage' => 'Percentage %',
            'money' => 'Geld',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Services',
        'create' => 'Service Aanmaken',
        'forms' => [
            'name' => 'Naam',
            'content' => 'Inhoud',
            'price' => 'Prijs',
            'currency' => 'Valuta',
            'image' => 'Afbeelding',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Beschikbaarheidskalender',
        'title' => 'Beschikbaarheidskalender',
        'description' => 'Bekijk autobeschikbaarheid en boekingen in kalenderindeling',
        'select_dates' => 'Selecteer datums om beschikbaarheid te controleren',
        'car_filter' => 'Filter op Auto',
        'all_cars' => 'Alle Auto\'s',
        'clear_filter' => 'Filter Wissen',
        'availability_check' => 'Autobeschikbaarheid Controleren',
        'selected_period' => 'Geselecteerde Periode',
        'checking_availability' => 'Beschikbaarheid controleren...',
        'available' => 'Beschikbaar',
        'not_available' => 'Niet Beschikbaar',
        'booking_details' => 'Boekingsdetails',
        'how_to_use' => 'Hoe de Autobeschikbaarheidskalender Te Gebruiken',
        'viewing_bookings' => 'Boekingen Bekijken',
        'checking_availability_help' => 'Beschikbaarheid Controleren',
        'color_legend' => 'Kleurlegenda',
        'pending_bookings' => 'Boekingen in Behandeling',
        'processing_bookings' => 'Boekingen in Verwerking',
        'completed_bookings' => 'Voltooide Boekingen',
        'cancelled_bookings' => 'Geannuleerde Boekingen',
        'unknown_make' => 'Onbekend Merk',
        'loading' => 'Laden...',
        'loading_calendar_data' => 'Kalendergegevens laden...',
        'loading_booking_details' => 'Boekingsdetails laden...',
        'please_wait_booking_info' => 'Even geduld terwijl we de boekingsinformatie ophalen.',
        'please_wait_availability' => 'Even geduld terwijl we de autobeschikbaarheid controleren voor uw geselecteerde datums.',
        'error' => 'Fout',
        'error_loading_booking' => 'Fout bij laden van boekingsdetails. Probeer het opnieuw.',
        'error_checking_availability' => 'Fout bij controleren autobeschikbaarheid',
        'customer' => 'Klant',
        'status' => 'Status',
        'amount' => 'Bedrag',
        'make' => 'Merk',
        'vendor' => 'Verhuurder',
        'per_day' => '/dag',
        'edit_car' => 'Auto Bewerken',
        'no_cars_found' => 'Geen auto\'s gevonden',
        'no_cars_available_period' => 'Er zijn geen auto\'s beschikbaar voor de geselecteerde periode.',
        'close' => 'Sluiten',
        'edit_booking' => 'Boeking Bewerken',
        'pending' => 'In Behandeling',
        'processing' => 'In Verwerking',
        'completed' => 'Voltooid',
        'cancelled' => 'Geannuleerd',
    ],
    'theme_options' => [
        'name' => 'Autoverhuur',
        'description' => 'Thema-opties voor autoverhuur',
        'car_location_filter_by' => 'Autolocatie filteren op',
        'state' => 'Provincie',
        'city' => 'Stad',
        'yes' => 'Ja',
        'no' => 'Nee',
        'is_display_country' => 'Land weergeven op locatiefilter?',
        'logo_vendor_dashboard' => 'Logo in het verhuurdersdashboard (Standaard is het hoofdlogo)',
        'number_of_cars_per_page' => 'Aantal auto\'s per pagina',
        'number_of_cars_per_page_placeholder' => 'Voer aantal auto\'s in om per pagina weer te geven',
    ],
    'message' => [
        'name' => 'Berichten',
        'forms' => [
            'customer_name' => 'Klantnaam',
            'message' => 'Bericht',
            'phone' => 'Telefoon',
            'email' => 'E-mail',
            'created_at' => 'Aangemaakt op',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Autoverkopen',
        'create' => 'Nieuwe Autoverkoop',
        'edit' => 'Autoverkoop Bewerken :name',
        'statuses' => [
            'pending' => 'In Behandeling',
            'processing' => 'In Verwerking',
            'completed' => 'Voltooid',
            'cancelled' => 'Geannuleerd',
        ],
        'forms' => [
            'transaction_id' => 'Transactie ID',
            'transaction_id_placeholder' => 'Voer transactie ID in',
            'car_id' => 'Auto',
            'car' => 'Auto',
            'customer_id' => 'Klant',
            'customer_name' => 'Klantnaam',
            'customer_name_placeholder' => 'Voer klantnaam in',
            'customer_email' => 'Klant E-mail',
            'customer_email_placeholder' => 'Voer klant e-mail in',
            'customer_phone' => 'Klant Telefoon',
            'customer_phone_placeholder' => 'Voer klant telefoon in',
            'sale_price' => 'Verkoopprijs',
            'sale_price_placeholder' => 'Voer verkoopprijs in',
            'tax_amount' => 'Belastingbedrag',
            'tax_amount_placeholder' => 'Voer belastingbedrag in',
            'total_amount' => 'Totaalbedrag',
            'total_amount_placeholder' => 'Voer totaalbedrag in',
            'payment_details' => 'Betalingsdetails',
            'payment_details_placeholder' => 'Voer betalingsdetails in',
            'notes' => 'Notities',
            'notes_placeholder' => 'Voer notities in',
            'sale_date' => 'Verkoopdatum',
            'delivery_date' => 'Leverdatum',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankoverschrijving',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Bevestiging Autoverhuur Boeking',
        'booking_confirm_greeting' => 'Geachte :customer_name,',
        'booking_confirm_message' => 'We zijn verheugd u te kunnen informeren dat uw autoverhuur boeking succesvol is bevestigd!',
        'customer_information' => 'Klantinformatie',
        'booking_information' => 'Boekingsinformatie',
        'field_name' => 'Naam:',
        'field_phone' => 'Telefoon:',
        'field_email' => 'E-mail:',
        'field_car_model' => 'Automodel:',
        'field_start_date' => 'Startdatum:',
        'field_end_date' => 'Einddatum:',
        'field_pickup_address' => 'Ophaaladres:',
        'field_return_address' => 'Retouradres:',
        'field_note' => 'Notitie:',
        'field_order_number' => 'Ordernummer',
        'field_payment_method' => 'Betaalmethode',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Nieuwe Boekingsmelding',
        'booking_notice_admin_greeting' => 'Hallo, er is een nieuwe boeking van :site_title:',
        'booking_notice_admin_message' => 'Er is een nieuwe autoverhuur boeking ingediend die uw aandacht vereist.',
        'booking_view_detail' => 'Bekijk boekingsdetails:',
        'view_booking_details' => 'Boekingsdetails Bekijken',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Nieuwe Boeking voor Uw Auto',
        'booking_notice_vendor_greeting' => 'Geachte :vendor_name,',
        'booking_notice_vendor_message' => 'Goed nieuws! U heeft een nieuwe boeking ontvangen voor uw autoverhuur.',

        // Booking status changed email
        'booking_status_updated' => 'Boekingsstatus Bijgewerkt',
        'hello_thanks_for_booking' => 'Hallo, Bedankt voor het boeken van kamers van :site_title:',
        'booking_status_change_message' => 'We hopen dat dit bericht u goed bereikt. We wilden u informeren dat de status van uw boeking is bijgewerkt.',
        'name' => 'Naam',
        'phone' => 'Telefoon',
        'email' => 'E-mail',
        'car_model' => 'Automodel',
        'start_date' => 'Startdatum',
        'end_date' => 'Einddatum',
        'pickup_address' => 'Ophaaladres',
        'return_address' => 'Retouradres',
        'note' => 'Notitie',
        'order_number' => 'Ordernummer',
        'payment_method' => 'Betaalmethode',

        // Car approved email
        'hello' => 'Hallo',
        'car_approved_title' => 'Goed Nieuws! Uw Auto Is Goedgekeurd',
        'car_approved_message' => 'We zijn verheugd u te informeren dat uw autolijst ":car_name" is goedgekeurd en nu live is op :site_title. U kunt direct boekingen ontvangen en uw lijst beheren.',
        'view_edit_car_link' => 'Om uw autolijst te bekijken of bewerken, klik op deze link',
        'view_car' => 'Autolijst Bekijken',
        'regards' => 'Met vriendelijke groet',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Gefeliciteerd! U Bent Nu Een Verhuurder',
        'vendor_upgrade_congratulations' => 'We zijn verheugd u te informeren dat uw account succesvol is geüpgraded naar verhuurderstatus!',
        'vendor_upgrade_message' => 'U kunt nu uw eigen auto\'s aanbieden en beheren op :site_title. Dit opent nieuwe mogelijkheden voor u om uw verhuurbedrijf met ons te laten groeien.',
        'vendor_benefits_title' => 'Uw Nieuwe Verhuurdervoordelen',
        'vendor_benefit_1' => 'Onbeperkt auto\'s aanbieden voor verhuur',
        'vendor_benefit_2' => 'Uw eigen boekingen en klanten beheren',
        'vendor_benefit_3' => 'Inkomsten en prestaties bijhouden',
        'vendor_benefit_4' => 'Toegang tot exclusieve verhuurder functies en tools',
        'next_steps' => 'Volgende Stappen',
        'vendor_next_steps_message' => 'Log in op uw verhuurdersdashboard om uw auto\'s toe te voegen en uw verhuurbedrijf te beheren.',
        'go_to_dashboard' => 'Naar Verhuurdersdashboard',
        'vendor_support_message' => 'Als u vragen heeft of hulp nodig heeft, staat ons ondersteuningsteam klaar om u te helpen beginnen.',
        'approved' => 'Goedgekeurd',

        // Car rejected email
        'car_rejected_title' => 'Update Vereist voor Uw Autolijst',
        'car_rejected_message' => 'Bedankt voor het indienen van uw autolijst ":car_name" bij :site_title. Na het beoordelen van uw inzending, moeten we u vragen enkele aanpassingen te maken voordat we deze kunnen goedkeuren.',
        'rejection_reason' => 'Dit moet worden bijgewerkt',
        'rejection_details' => 'Vereiste Updates',
        'contact_support' => 'Als u vragen heeft of hulp nodig heeft met deze updates, aarzel dan niet om contact op te nemen met ons ondersteuningsteam op :site_email. We zijn er om u te helpen uw lijst snel goedgekeurd te krijgen.',

        // Confirm email
        'verify_email' => 'E-mail Verifiëren',
        'welcome_message' => 'We zijn blij u hier te hebben, :customer_name!',
        'verify_email_instruction' => 'Verifieer uw e-mailadres om toegang te krijgen tot deze website. Klik op de knop hieronder om uw e-mail te verifiëren.',
        'confirm_email_button' => 'Bevestig uw e-mailadres',
        'verify_link_trouble' => 'Als u problemen ondervindt met het klikken op de knop \'Bevestig uw e-mailadres\', kopieer en plak dan de onderstaande URL in uw webbrowser: :verify_link en plak deze in uw browser.',

        // Message email
        'new_message' => 'Nieuw Bericht',
        'dear_admin' => 'Geachte Beheerder',
        'new_message_from' => 'Er is een nieuw bericht van :site_title:',
        'subject' => 'Onderwerp',
        'address' => 'Adres',
        'content' => 'Inhoud',

        // New pending car email
        'hi_admin' => 'Hallo Beheerder,',
        'new_car_pending_title' => 'Nieuwe Autolijst In Afwachting van Beoordeling',
        'new_car_pending_approval' => 'Een nieuwe autolijst ":post_name" is ingediend door :post_author en is klaar voor uw beoordeling.',
        'pending_approval' => 'In Afwachting van Beoordeling',
        'review_car_admin' => 'Beoordeel deze lijst in het beheerpaneel en keur goed of vraag updates aan indien nodig.',

        // Common fields
        'car_information' => 'Auto-informatie',
        'field_car_name' => 'Autonaam:',
        'field_author' => 'Auteur:',
        'field_status' => 'Status:',
        'actions' => 'Acties',

        // Password reminder email
        'reset_password_instruction' => 'Wachtwoord Reset Instructie',
        'password_reset_request' => 'U ontvangt deze e-mail omdat we een wachtwoord reset verzoek hebben ontvangen voor uw account.',
        'reset_password_button' => 'Wachtwoord resetten',
        'reset_link_trouble' => 'Als u problemen ondervindt met het klikken op de knop \'Wachtwoord Resetten\', kopieer en plak dan de onderstaande URL in uw webbrowser: :reset_link en plak deze in uw browser. Als u geen wachtwoord reset heeft aangevraagd, negeer dan dit bericht of neem contact met ons op als u vragen heeft.',
    ],
];
