<?php

return [
    'name' => 'Wynajem Samochodów',
    'customer' => [
        'name' => 'Klienci',
        'create' => 'Utwórz Klienta',
        'view' => 'Zobacz',
        'information' => 'Informacje o Kliencie',
        'email' => 'E-mail',
        'phone' => 'Telefon',
        'status' => 'Status',
        'vendor_status' => 'Status Wynajmującego',
        'is_vendor' => 'Wynajmujący',
        'not_vendor' => 'Klient',
        'recent_activity' => 'Ostatnia Aktywność',
        'recent_activity_description' => 'Aktywność klienta pojawi się tutaj.',
        'verification_section' => 'Weryfikacja Klienta',
        'verified' => 'Zweryfikowany',
        'not_verified' => 'Niezweryfikowany',
        'verified_by' => 'Zweryfikowany Przez',
        'verified_at' => 'Zweryfikowano Dnia',
        'verify_customer' => 'Zweryfikuj Klienta',
        'unverify_customer' => 'Usuń Weryfikację',
        'verify_customer_confirmation' => 'Potwierdzenie Weryfikacji Klienta',
        'verify_customer_confirmation_desc' => 'Czy na pewno chcesz zweryfikować :name? Spowoduje to wyświetlenie odznaki zweryfikowanego na profilu.',
        'unverify_customer_confirmation' => 'Potwierdzenie Usunięcia Weryfikacji',
        'unverify_customer_confirmation_desc' => 'Czy na pewno chcesz usunąć weryfikację :name? Odznaka zweryfikowanego zostanie usunięta.',
        'verify_success' => 'Klient :name został pomyślnie zweryfikowany.',
        'unverify_success' => 'Weryfikacja klienta :name została pomyślnie usunięta.',
        'already_verified' => 'Ten klient jest już zweryfikowany.',
        'already_unverified' => 'Ten klient nie jest zweryfikowany.',
        'upgrade_to_vendor_title' => 'Awansuj na Wynajmującego',
        'upgrade_to_vendor_description' => 'Awansuj tego klienta na wynajmującego, aby umożliwić mu wystawianie i zarządzanie własnymi wynajmami samochodów.',
        'upgrade_to_vendor_button' => 'Awansuj na Wynajmującego',
        'upgrade_to_vendor_confirmation' => 'Potwierdź Awans na Wynajmującego',
        'upgrade_to_vendor_confirmation_desc' => 'Czy na pewno chcesz awansować :name na wynajmującego? To pozwoli mu wystawiać i zarządzać własnymi samochodami na platformie.',
        'upgrade_to_vendor_success' => ':name został pomyślnie awansowany na wynajmującego.',
        'already_vendor' => 'Ten klient jest już wynajmującym.',
        'customer_verified_successfully' => 'Ten klient został zweryfikowany i można mu zaufać.',
        'customer_not_verified_yet' => 'Ten klient nie został jeszcze zweryfikowany.',
        'verification_pending' => 'Weryfikacja w Toku',
        'click_verify_to_approve' => 'Kliknij przycisk poniżej, aby zweryfikować tego klienta i wyświetlić odznakę zweryfikowanego.',
        'verification_note' => 'Notatka Weryfikacji',
        'verification_note_placeholder' => 'Wpisz wszelkie uwagi dotyczące tej czynności weryfikacji...',
        'verification_note_helper' => 'Dodaj uwagi dotyczące procesu weryfikacji (tylko do użytku wewnętrznego)',
        'forms' => [
            'name' => 'Nazwisko',
            'email' => 'E-mail',
            'phone' => 'Telefon',
            'avatar' => 'Awatar',
            'dob' => 'Data Urodzenia',
            'company' => 'Firma',
            'position' => 'Stanowisko',
            'password' => 'Hasło',
            'password_confirmation' => 'Potwierdzenie hasła',
            'change_password' => 'Zmienić hasło?',
            'phone_placeholder' => 'Telefon',
        ],
    ],
    'vendor' => [
        'name' => 'Wynajmujący',
        'view' => 'Zobacz :name',
        'information' => 'Informacje o Wynajmującym',
        'total_cars' => 'Łączna Liczba Samochodów',
        'total_bookings' => 'Łączna Liczba Rezerwacji',
        'verified' => 'Zweryfikowany',
        'not_verified' => 'Niezweryfikowany',
        'verification_section' => 'Weryfikacja Wynajmującego',
        'vendor_verified_successfully' => 'Ten wynajmujący został zweryfikowany i można mu zaufać.',
        'vendor_not_verified_yet' => 'Ten wynajmujący nie został jeszcze zweryfikowany.',
        'verification_pending' => 'Weryfikacja w Toku',
        'click_verify_to_approve' => 'Kliknij przycisk poniżej, aby zweryfikować tego wynajmującego i wyświetlić odznakę zweryfikowanego.',
        'verify_vendor' => 'Zweryfikuj Wynajmującego',
        'unverify_vendor' => 'Usuń Weryfikację',
        'verify_vendor_confirmation' => 'Potwierdzenie Weryfikacji Wynajmującego',
        'verify_vendor_confirmation_desc' => 'Czy na pewno chcesz zweryfikować :name? Spowoduje to wyświetlenie odznaki zweryfikowanego na profilu.',
        'unverify_vendor_confirmation' => 'Potwierdzenie Usunięcia Weryfikacji',
        'unverify_vendor_confirmation_desc' => 'Czy na pewno chcesz usunąć weryfikację :name? Odznaka zweryfikowanego zostanie usunięta.',
        'verified_successfully' => 'Wynajmujący został pomyślnie zweryfikowany.',
        'unverified_successfully' => 'Weryfikacja wynajmującego została pomyślnie usunięta.',
        'already_verified' => 'Ten wynajmujący jest już zweryfikowany.',
        'not_verified_yet' => 'Ten wynajmujący nie jest jeszcze zweryfikowany.',
        'recent_activity' => 'Ostatnia Aktywność',
        'recent_cars' => 'Ostatnie Samochody',
        'recent_bookings' => 'Ostatnie Rezerwacje',
        'no_cars_yet' => 'Nie dodano jeszcze samochodów.',
        'no_bookings_yet' => 'Nie otrzymano jeszcze rezerwacji.',
    ],
    'make' => [
        'name' => 'Marki',
        'create' => 'Utwórz Markę Samochodu',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Ciemne',
        ],
    ],
    'car' => [
        'name' => 'Samochody',
        'create' => 'Utwórz Samochód',
        'forms' => [
            'car' => 'Samochód',
            'logo' => 'Logo',
            'license_plate' => 'Numer Rejestracyjny',
            'make' => 'Marka',
            'model' => 'Model',
            'name' => 'Nazwa',
            'images' => 'Zdjęcia',
            'year' => 'Rok',
            'color' => 'Kolor',
            'mileage' => 'Przebieg',
            'kilometers' => 'Kilometry',
            'horsepower' => 'Moc',
            'vehicle_type' => 'Typ Pojazdu',
            'transmission' => 'Skrzynia Biegów',
            'fuel_type' => 'Typ Paliwa',
            'rental_rate' => 'Stawka Wynajmu',
            'currency' => 'Waluta',
            'status' => 'Status',
            'availability' => 'Dostępność',
            'insurance_info' => 'Informacje o ubezpieczeniu',
            'number_of_seats' => 'Liczba Miejsc',
            'number_of_doors' => 'Liczba Drzwi',
            'vin' => 'VIN',
            'maintenance_history' => 'Historia Serwisowa',
            'location' => 'Lokalizacja',
            'description' => 'Opis',
            'rental_type' => 'Typ Wynajmu',
            'tags' => 'Tagi',
            'add_new_attribute' => 'Dodaj nowy atrybut <a href=":url" target="_blank">tutaj</a>.',
            'categories' => 'Kategorie',
            'pick_address' => 'Adres Odbioru',
            'return_address' => 'Adres Zwrotu',
            'same_drop_off' => 'To Samo Miejsce Zwrotu',
            'tax' => 'Podatek',
            'select_tax' => 'Wybierz Podatek',
            'none' => 'Brak',
            'colors' => 'Kolory',
            'amenities' => 'Udogodnienia',
            'is_used' => 'Używany?',
            'moderation_status' => 'Status moderacji',
            'status_moderation' => [
                'approve' => 'Zatwierdź',
                'reject' => 'Odrzuć',
                'approve_title' => 'Zatwierdź samochód',
                'approve_message' => 'Czy na pewno chcesz zatwierdzić ten samochód? Tej akcji nie można cofnąć.',
                'reject_title' => 'Odrzuć samochód',
                'reject_message' => 'Czy na pewno chcesz odrzucić ten samochód? Tej akcji nie można cofnąć.',
                'reject_reason' => 'Podaj powód odrzucenia',
                'approved' => 'Samochód został pomyślnie zatwierdzony!',
                'rejected' => 'Samochód został pomyślnie odrzucony!',
                'reason_rejected' => 'Powód odrzucenia',
            ],
            'customer' => 'Klient',
            'select_customer' => 'Wybierz klienta...',
            'vendor_images' => 'Zdjęcia (Maksymalnie :max zdjęć)',
            'images_upload_placeholder' => 'Przeciągnij pliki tutaj lub kliknij, aby przesłać.',
            'car_purpose' => 'Przeznaczenie Samochodu',
            'for_rent' => 'Do Wynajęcia',
            'for_sale' => 'Na Sprzedaż',
            'car_type' => 'Typ Samochodu',
            'rental_information' => 'Informacje o Wynajmie',
            'sale_statuses' => [
                'available' => 'Dostępny',
                'sold' => 'Sprzedany',
                'reserved' => 'Zarezerwowany',
            ],
            'selling_information' => 'Informacje o Sprzedaży',
            'is_for_sale' => 'Dostępny na sprzedaż',
            'sale_price' => 'Cena Sprzedaży',
            'sale_price_placeholder' => 'Wpisz cenę sprzedaży',
            'condition' => 'Stan',
            'select_condition' => 'Wybierz Stan',
            'condition_options' => [
                'new' => 'Nowy',
                'like_new' => 'Jak Nowy',
                'excellent' => 'Doskonały',
                'good' => 'Dobry',
                'fair' => 'Zadowalający',
                'poor' => 'Słaby',
            ],
            'ownership_history' => 'Historia Własności',
            'ownership_history_placeholder' => 'Wpisz historię własności',
            'warranty_information' => 'Informacje o Gwarancji',
            'warranty_information_placeholder' => 'Wpisz informacje o gwarancji',
            'sale_status' => 'Status Sprzedaży',
            'external_booking_url' => 'Link do Rezerwacji Zewnętrznej',
            'external_booking_url_helper' => 'Wpisz zewnętrzny adres URL, gdzie klienci mogą zarezerwować ten samochód poza platformą. Zostaw puste, jeśli rezerwacja jest dostępna tylko na tej stronie.',
            'address' => 'Adres',
            'address_helper' => 'Wpisz konkretny adres ulicy, gdzie znajduje się ten pojazd',
        ],
        'car_purposes' => [
            'sale' => 'Na Sprzedaż',
            'rent' => 'Do Wynajęcia',
        ],
        'placeholders' => [
            'name' => 'Wpisz nazwę pojazdu (np. Toyota Camry 2023, Honda CR-V, itp.)',
            'description' => 'Wpisz krótki opis pojazdu podkreślający kluczowe cechy',
            'rental_rate' => 'Wpisz stawkę wynajmu na podstawie wybranego typu wynajmu',
            'location' => 'Wpisz fizyczną lokalizację pojazdu',
            'address' => 'Wpisz konkretny adres ulicy (np. ul. Główna 123, Miasto, Województwo)',
            'sale_price' => 'Wpisz cenę sprzedaży tego pojazdu',
            'ownership_history' => 'Wpisz szczegóły dotyczące poprzednich właścicieli, liczby właścicieli, itp.',
            'warranty_information' => 'Wpisz szczegóły dotyczące pokrycia gwarancji, daty wygaśnięcia, itp.',
            'external_booking_url' => 'https://przyklad.pl/link-rezerwacji',
            'license_plate' => 'Wpisz numer rejestracyjny pojazdu',
            'vin' => 'Wpisz Numer Identyfikacyjny Pojazdu (VIN)',
            'year' => 'Wpisz rok produkcji (np. 2023)',
            'mileage' => 'Wpisz aktualny przebieg',
            'kilometers' => 'Wpisz aktualną liczbę kilometrów',
            'horsepower' => 'Wpisz moc pojazdu (KM) (np. 150,5)',
            'number_of_seats' => 'Wpisz liczbę miejsc w pojeździe',
            'number_of_doors' => 'Wpisz liczbę drzwi pojazdu',
            'insurance_info' => 'Wpisz odpowiednie informacje o ubezpieczeniu tego pojazdu',
            'tags' => 'Wybierz lub utwórz tagi',
            'amenities' => 'Wybierz udogodnienia',
            'colors' => 'Wybierz lub utwórz kolory',
        ],
        'enums' => [
            'vendor_status' => 'Status Wynajmującego',
            'is_vendor' => 'Wynajmujący',
            'not_vendor' => 'Klient',
            'statuses' => [
                'available' => 'Dostępny',
                'rented' => 'Wynajęty',
                'maintenance' => 'W Serwisie',
                'out_of_service' => 'Poza Służbą',
            ],
            'rental_types' => [
                'per_hour' => 'Za godzinę',
                'per_day' => 'Za dzień',
                'per_week' => 'Za tydzień',
                'per_month' => 'Za miesiąc',
            ],
            'moderation_statuses' => [
                'pending' => 'Oczekujące',
                'approved' => 'Zatwierdzone',
                'rejected' => 'Odrzucone',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Historia Serwisowa',
            'create' => 'Utwórz Historię Serwisową',
            'amount' => 'Kwota',
            'forms' => [
                'price_placeholder' => 'Cena usługi',
                'currency' => 'Waluta',
                'none' => 'Brak',
                'name' => 'Nazwa',
                'amount' => 'Kwota',
                'created_at' => 'Utworzono',
                'action' => 'Akcja',
                'date' => 'Data',
                'no_maintenance_history' => 'Brak historii serwisowej',
                'edit_maintenance_history' => 'Edytuj historię serwisową',
                'add_maintenance_history' => 'Dodaj historię serwisową',
                'add' => 'Dodaj',
                'edit' => 'Edytuj',
                'delete' => 'Usuń',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atrybuty Samochodu',
        'car_type' => [
            'name' => 'Typy',
            'create' => 'Utwórz Typ Samochodu',
            'forms' => [
                'name' => 'Nazwa',
            ],
        ],
        'transmission' => [
            'name' => 'Skrzynie Biegów',
            'create' => 'Utwórz Skrzynię Biegów',
            'forms' => [
                'name' => 'Nazwa',
            ],
        ],
        'fuel_type' => [
            'name' => 'Paliwa',
            'create' => 'Utwórz Typy Paliwa',
            'forms' => [
                'name' => 'Nazwa',
            ],
        ],
        'tag' => [
            'name' => 'Tagi',
            'create' => 'Utwórz Tag',
        ],
        'category' => [
            'name' => 'Kategorie',
            'create' => 'Utwórz Kategorię',
            'forms' => [
                'none' => 'Brak',
                'total_cars' => 'Łącznie samochodów: :total',
            ],
        ],
        'address' => [
            'name' => 'Lokalizacje',
            'create' => 'Utwórz Lokalizację Samochodu',
            'form' => [
                'name' => 'Adres',
                'full_address' => 'Pełny Adres',
                'detail_address' => 'Szczegółowy Adres',
            ],
        ],
        'color' => [
            'name' => 'Kolor',
            'create' => 'Utwórz Kolor',
        ],
        'amenity' => [
            'name' => 'Udogodnienia',
            'create' => 'Utwórz Udogodnienie',
        ],
    ],
    'tax' => [
        'name' => 'Podatki',
        'create' => 'Utwórz Podatek',
        'forms' => [
            'name' => 'Nazwa',
            'name_placeholder' => 'Wpisz nazwę',
            'percentage' => 'Procent',
            'percentage_placeholder' => 'Procent',
            'percent_placeholder' => 'Procent',
            'priority' => 'Priorytet',
            'priority_placeholder' => 'Priorytet',
        ],
    ],
    'review' => [
        'name' => 'Opinie',
        'create' => 'Utwórz Opinię',
        'edit' => 'Edytuj Opinię',
        'vendor' => [
            'title' => 'Opinie Klientów',
            'description' => 'Zarządzaj wszystkimi opiniami klientów dotyczącymi Twoich samochodów',
            'no_reviews' => 'Nie masz jeszcze opinii',
            'filter_by_car' => 'Filtruj według samochodu',
            'filter_by_rating' => 'Filtruj według oceny',
            'filter_by_date' => 'Filtruj według daty',
            'all_cars' => 'Wszystkie Samochody',
            'all_ratings' => 'Wszystkie Oceny',
            'manage_reviews' => 'Zarządzaj Opiniami',
            'view_all' => 'Zobacz Wszystkie Opinie',
            'delete_review_confirmation' => 'Czy na pewno chcesz usunąć tę opinię?',
            'delete_review_success' => 'Opinia została pomyślnie usunięta',
            'cannot_delete' => 'Nie można usunąć tej opinii',
        ],
        'forms' => [
            'customer' => 'Klient',
            'car' => 'Samochód',
            'content' => 'Treść',
            'rating' => 'Ocena',
            'your_name' => 'Twoje Nazwisko',
            'email_address' => 'Adres E-mail',
            'submit' => 'Wyślij',
            'star' => 'Gwiazdka',
            'status' => 'Status',
            'created_at' => 'Utworzono',
            'select_car' => 'Wybierz Samochód',
            'select_rating' => 'Wybierz Ocenę',
            'comment' => 'Komentarz',
            'reply' => 'Odpowiedz',
            'reply_to_review' => 'Odpowiedz na Opinię',
            'save_reply' => 'Zapisz Odpowiedź',
            'cancel_reply' => 'Anuluj',
        ],
        'statuses' => [
            'published' => 'Opublikowane',
            'pending' => 'Oczekujące',
            'rejected' => 'Odrzucone',
        ],
        'ratings' => [
            '1' => '1 Gwiazdka - Słabo',
            '2' => '2 Gwiazdki - Zadowalająco',
            '3' => '3 Gwiazdki - Dobrze',
            '4' => '4 Gwiazdki - Bardzo Dobrze',
            '5' => '5 Gwiazdek - Doskonale',
        ],
    ],
    'coupon' => [
        'name' => 'Kupony',
        'create' => 'Utwórz Kupon',
        'types' => [
            'percentage' => 'Procent %',
            'money' => 'Pieniądze',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Usługi',
        'create' => 'Utwórz Usługę',
        'forms' => [
            'name' => 'Nazwa',
            'content' => 'Treść',
            'price' => 'Cena',
            'currency' => 'Waluta',
            'image' => 'Obraz',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Kalendarz Dostępności',
        'title' => 'Kalendarz Dostępności',
        'description' => 'Zobacz dostępność samochodów i rezerwacje w formacie kalendarza',
        'select_dates' => 'Wybierz daty, aby sprawdzić dostępność',
        'car_filter' => 'Filtruj według Samochodu',
        'all_cars' => 'Wszystkie Samochody',
        'clear_filter' => 'Wyczyść Filtr',
        'availability_check' => 'Sprawdzanie Dostępności Samochodu',
        'selected_period' => 'Wybrany Okres',
        'checking_availability' => 'Sprawdzanie dostępności...',
        'available' => 'Dostępny',
        'not_available' => 'Niedostępny',
        'booking_details' => 'Szczegóły Rezerwacji',
        'how_to_use' => 'Jak Używać Kalendarza Dostępności Samochodów',
        'viewing_bookings' => 'Przeglądanie Rezerwacji',
        'checking_availability_help' => 'Sprawdzanie Dostępności',
        'color_legend' => 'Legenda Kolorów',
        'pending_bookings' => 'Rezerwacje Oczekujące',
        'processing_bookings' => 'Rezerwacje w Przetwarzaniu',
        'completed_bookings' => 'Rezerwacje Zakończone',
        'cancelled_bookings' => 'Rezerwacje Anulowane',
        'unknown_make' => 'Nieznana Marka',
        'loading' => 'Ładowanie...',
        'loading_calendar_data' => 'Ładowanie danych kalendarza...',
        'loading_booking_details' => 'Ładowanie szczegółów rezerwacji...',
        'please_wait_booking_info' => 'Proszę czekać, pobieramy informacje o rezerwacji.',
        'please_wait_availability' => 'Proszę czekać, sprawdzamy dostępność samochodów dla wybranych dat.',
        'error' => 'Błąd',
        'error_loading_booking' => 'Nie udało się załadować szczegółów rezerwacji. Spróbuj ponownie.',
        'error_checking_availability' => 'Błąd podczas sprawdzania dostępności samochodu',
        'customer' => 'Klient',
        'status' => 'Status',
        'amount' => 'Kwota',
        'make' => 'Marka',
        'vendor' => 'Wynajmujący',
        'per_day' => '/dzień',
        'edit_car' => 'Edytuj Samochód',
        'no_cars_found' => 'Nie znaleziono samochodów',
        'no_cars_available_period' => 'Brak dostępnych samochodów w wybranym okresie.',
        'close' => 'Zamknij',
        'edit_booking' => 'Edytuj Rezerwację',
        'pending' => 'Oczekująca',
        'processing' => 'Przetwarzanie',
        'completed' => 'Zakończona',
        'cancelled' => 'Anulowana',
    ],
    'theme_options' => [
        'name' => 'Wynajem Samochodów',
        'description' => 'Opcje motywu dla wynajmu samochodów',
        'car_location_filter_by' => 'Filtruj lokalizację samochodu według',
        'state' => 'Województwo',
        'city' => 'Miasto',
        'yes' => 'Tak',
        'no' => 'Nie',
        'is_display_country' => 'Wyświetlać kraj w filtrze lokalizacji?',
        'logo_vendor_dashboard' => 'Logo na pulpicie wynajmującego (Domyślnie jest to logo główne)',
        'number_of_cars_per_page' => 'Liczba samochodów na stronę',
        'number_of_cars_per_page_placeholder' => 'Wpisz liczbę samochodów do wyświetlenia na stronę',
    ],
    'message' => [
        'name' => 'Wiadomości',
        'forms' => [
            'customer_name' => 'Nazwisko klienta',
            'message' => 'Wiadomość',
            'phone' => 'Telefon',
            'email' => 'E-mail',
            'created_at' => 'Utworzono',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Sprzedaż Samochodów',
        'create' => 'Nowa Sprzedaż Samochodu',
        'edit' => 'Edytuj Sprzedaż Samochodu :name',
        'statuses' => [
            'pending' => 'Oczekująca',
            'processing' => 'Przetwarzanie',
            'completed' => 'Zakończona',
            'cancelled' => 'Anulowana',
        ],
        'forms' => [
            'transaction_id' => 'ID Transakcji',
            'transaction_id_placeholder' => 'Wpisz ID transakcji',
            'car_id' => 'Samochód',
            'car' => 'Samochód',
            'customer_id' => 'Klient',
            'customer_name' => 'Nazwisko Klienta',
            'customer_name_placeholder' => 'Wpisz nazwisko klienta',
            'customer_email' => 'E-mail Klienta',
            'customer_email_placeholder' => 'Wpisz e-mail klienta',
            'customer_phone' => 'Telefon Klienta',
            'customer_phone_placeholder' => 'Wpisz telefon klienta',
            'sale_price' => 'Cena Sprzedaży',
            'sale_price_placeholder' => 'Wpisz cenę sprzedaży',
            'tax_amount' => 'Kwota Podatku',
            'tax_amount_placeholder' => 'Wpisz kwotę podatku',
            'total_amount' => 'Kwota Całkowita',
            'total_amount_placeholder' => 'Wpisz kwotę całkowitą',
            'payment_details' => 'Szczegóły Płatności',
            'payment_details_placeholder' => 'Wpisz szczegóły płatności',
            'notes' => 'Uwagi',
            'notes_placeholder' => 'Wpisz uwagi',
            'sale_date' => 'Data Sprzedaży',
            'delivery_date' => 'Data Dostawy',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Przelew Bankowy',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Potwierdzenie Rezerwacji Wynajmu Samochodu',
        'booking_confirm_greeting' => 'Szanowny/a :customer_name,',
        'booking_confirm_message' => 'Mamy przyjemność poinformować, że Twoja rezerwacja wynajmu samochodu została pomyślnie potwierdzona!',
        'customer_information' => 'Informacje o Kliencie',
        'booking_information' => 'Informacje o Rezerwacji',
        'field_name' => 'Nazwisko:',
        'field_phone' => 'Telefon:',
        'field_email' => 'E-mail:',
        'field_car_model' => 'Model Samochodu:',
        'field_start_date' => 'Data Rozpoczęcia:',
        'field_end_date' => 'Data Zakończenia:',
        'field_pickup_address' => 'Adres Odbioru:',
        'field_return_address' => 'Adres Zwrotu:',
        'field_note' => 'Uwaga:',
        'field_order_number' => 'Numer zamówienia',
        'field_payment_method' => 'Metoda Płatności',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Powiadomienie o Nowej Rezerwacji',
        'booking_notice_admin_greeting' => 'Witaj, otrzymano nową rezerwację z :site_title:',
        'booking_notice_admin_message' => 'Nowa rezerwacja wynajmu samochodu została złożona i wymaga Twojej uwagi.',
        'booking_view_detail' => 'Zobacz szczegóły rezerwacji:',
        'view_booking_details' => 'Zobacz Szczegóły Rezerwacji',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Nowa Rezerwacja Twojego Samochodu',
        'booking_notice_vendor_greeting' => 'Szanowny/a :vendor_name,',
        'booking_notice_vendor_message' => 'Świetna wiadomość! Otrzymałeś nową rezerwację wynajmu swojego samochodu.',

        // Booking status changed email
        'booking_status_updated' => 'Status Rezerwacji Zaktualizowany',
        'hello_thanks_for_booking' => 'Witaj, Dziękujemy za rezerwację pokoi z :site_title:',
        'booking_status_change_message' => 'Mamy nadzieję, że ta wiadomość dotrze do Ciebie w dobrym zdrowiu. Chcieliśmy poinformować, że status Twojej rezerwacji został zaktualizowany.',
        'name' => 'Nazwisko',
        'phone' => 'Telefon',
        'email' => 'E-mail',
        'car_model' => 'Model Samochodu',
        'start_date' => 'Data Rozpoczęcia',
        'end_date' => 'Data Zakończenia',
        'pickup_address' => 'Adres Odbioru',
        'return_address' => 'Adres Zwrotu',
        'note' => 'Uwaga',
        'order_number' => 'Numer zamówienia',
        'payment_method' => 'Metoda Płatności',

        // Car approved email
        'hello' => 'Witaj',
        'car_approved_title' => 'Świetna Wiadomość! Twój Samochód Został Zatwierdzony',
        'car_approved_message' => 'Mamy przyjemność poinformować, że Twoja oferta samochodu ":car_name" została zatwierdzona i jest już dostępna na :site_title. Możesz już zacząć otrzymywać rezerwacje i zarządzać swoją ofertą.',
        'view_edit_car_link' => 'Aby zobaczyć lub edytować swoją ofertę samochodu, kliknij ten link',
        'view_car' => 'Zobacz Ofertę Samochodu',
        'regards' => 'Z poważaniem',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Gratulacje! Jesteś Teraz Wynajmującym',
        'vendor_upgrade_congratulations' => 'Mamy przyjemność poinformować, że Twoje konto zostało pomyślnie awansowane do statusu wynajmującego!',
        'vendor_upgrade_message' => 'Możesz teraz wystawiać i zarządzać własnymi samochodami na :site_title. Otwiera to nowe możliwości rozwoju Twojego biznesu wynajmu z nami.',
        'vendor_benefits_title' => 'Twoje Nowe Korzyści Wynajmującego',
        'vendor_benefit_1' => 'Wystawianie nieograniczonej liczby samochodów na wynajem',
        'vendor_benefit_2' => 'Zarządzanie własnymi rezerwacjami i klientami',
        'vendor_benefit_3' => 'Śledzenie przychodów i wskaźników wydajności',
        'vendor_benefit_4' => 'Dostęp do funkcji i narzędzi dostępnych wyłącznie dla wynajmujących',
        'next_steps' => 'Następne Kroki',
        'vendor_next_steps_message' => 'Zaloguj się do swojego pulpitu wynajmującego, aby zacząć dodawać samochody i zarządzać swoim biznesem wynajmu.',
        'go_to_dashboard' => 'Przejdź do Pulpitu Wynajmującego',
        'vendor_support_message' => 'Jeśli masz jakiekolwiek pytania lub potrzebujesz pomocy, nasz zespół wsparcia jest tutaj, aby pomóc Ci zacząć.',
        'approved' => 'Zatwierdzone',

        // Car rejected email
        'car_rejected_title' => 'Wymagana Aktualizacja Oferty Samochodu',
        'car_rejected_message' => 'Dziękujemy za przesłanie oferty samochodu ":car_name" do :site_title. Po przejrzeniu Twojego zgłoszenia, potrzebujemy abyś dokonał niektórych dostosowań zanim będziemy mogli ją zatwierdzić.',
        'rejection_reason' => 'Oto co należy zaktualizować',
        'rejection_details' => 'Wymagane Aktualizacje',
        'contact_support' => 'Jeśli masz jakiekolwiek pytania lub potrzebujesz pomocy z tymi aktualizacjami, nie wahaj się skontaktować z naszym zespołem wsparcia pod adresem :site_email. Jesteśmy tutaj, aby pomóc Ci szybko zatwierdzić Twoją ofertę.',

        // Confirm email
        'verify_email' => 'Weryfikacja E-mail',
        'welcome_message' => 'Cieszymy się, że tu jesteś, :customer_name!',
        'verify_email_instruction' => 'Proszę zweryfikuj swój adres e-mail, aby uzyskać dostęp do tej strony. Kliknij przycisk poniżej, aby zweryfikować swój e-mail.',
        'confirm_email_button' => 'Potwierdź swój adres e-mail',
        'verify_link_trouble' => 'Jeśli masz problem z kliknięciem przycisku \'Potwierdź swój adres e-mail\', skopiuj i wklej poniższy URL do swojej przeglądarki internetowej: :verify_link i wklej go do swojej przeglądarki.',

        // Message email
        'new_message' => 'Nowa Wiadomość',
        'dear_admin' => 'Szanowny Administratorze',
        'new_message_from' => 'Jest nowa wiadomość z :site_title:',
        'subject' => 'Temat',
        'address' => 'Adres',
        'content' => 'Treść',

        // New pending car email
        'hi_admin' => 'Witaj Administratorze,',
        'new_car_pending_title' => 'Nowa Oferta Samochodu Oczekuje na Przegląd',
        'new_car_pending_approval' => 'Nowa oferta samochodu ":post_name" została przesłana przez :post_author i jest gotowa do Twojego przeglądu.',
        'pending_approval' => 'Oczekuje na Przegląd',
        'review_car_admin' => 'Proszę przejrzyj tę ofertę w panelu administratora i zatwierdź lub poproś o aktualizacje w razie potrzeby.',

        // Common fields
        'car_information' => 'Informacje o Samochodzie',
        'field_car_name' => 'Nazwa Samochodu:',
        'field_author' => 'Autor:',
        'field_status' => 'Status:',
        'actions' => 'Akcje',

        // Password reminder email
        'reset_password_instruction' => 'Instrukcje Resetowania Hasła',
        'password_reset_request' => 'Otrzymujesz ten e-mail, ponieważ otrzymaliśmy żądanie resetowania hasła do Twojego konta.',
        'reset_password_button' => 'Resetuj hasło',
        'reset_link_trouble' => 'Jeśli masz problem z kliknięciem przycisku \'Resetuj Hasło\', skopiuj i wklej poniższy URL do swojej przeglądarki internetowej: :reset_link i wklej go do swojej przeglądarki. Jeśli nie żądałeś resetowania hasła, zignoruj tę wiadomość lub skontaktuj się z nami, jeśli masz jakiekolwiek pytania.',
    ],
];
