<?php

return [
    'name' => 'Аренда Автомобилей',
    'customer' => [
        'name' => 'Клиенты',
        'create' => 'Создать Клиента',
        'view' => 'Просмотр',
        'information' => 'Информация о Клиенте',
        'email' => 'Электронная почта',
        'phone' => 'Телефон',
        'status' => 'Статус',
        'vendor_status' => 'Статус Арендодателя',
        'is_vendor' => 'Арендодатель',
        'not_vendor' => 'Клиент',
        'recent_activity' => 'Последняя Активность',
        'recent_activity_description' => 'Активность клиента будет отображаться здесь.',
        'verification_section' => 'Верификация Клиента',
        'verified' => 'Верифицирован',
        'not_verified' => 'Не Верифицирован',
        'verified_by' => 'Верифицирован',
        'verified_at' => 'Дата Верификации',
        'verify_customer' => 'Верифицировать Клиента',
        'unverify_customer' => 'Отменить Верификацию',
        'verify_customer_confirmation' => 'Подтверждение Верификации Клиента',
        'verify_customer_confirmation_desc' => 'Вы уверены, что хотите верифицировать :name? Это отобразит значок верификации в их профиле.',
        'unverify_customer_confirmation' => 'Подтверждение Отмены Верификации',
        'unverify_customer_confirmation_desc' => 'Вы уверены, что хотите удалить верификацию :name? Значок верификации будет удален.',
        'verify_success' => 'Клиент :name успешно верифицирован.',
        'unverify_success' => 'Верификация клиента :name успешно удалена.',
        'already_verified' => 'Этот клиент уже верифицирован.',
        'already_unverified' => 'Этот клиент не верифицирован.',
        'upgrade_to_vendor_title' => 'Повысить до Арендодателя',
        'upgrade_to_vendor_description' => 'Повысьте этого клиента до статуса арендодателя, чтобы позволить им размещать и управлять своими автомобилями.',
        'upgrade_to_vendor_button' => 'Повысить до Арендодателя',
        'upgrade_to_vendor_confirmation' => 'Подтвердите Повышение до Арендодателя',
        'upgrade_to_vendor_confirmation_desc' => 'Вы уверены, что хотите повысить :name до статуса арендодателя? Это позволит им размещать и управлять своими автомобилями на платформе.',
        'upgrade_to_vendor_success' => ':name успешно повышен до статуса арендодателя.',
        'already_vendor' => 'Этот клиент уже является арендодателем.',
        'email_verified' => 'Email Верифицирован',
        'email_not_verified' => 'Email Не Верифицирован',
        'verify_email_warning_message' => 'Адрес электронной почты этого клиента не был верифицирован. Вы можете вручную верифицировать его, чтобы подтвердить, что их email действителен.',
        'verify_email_title' => 'Верифицировать Адрес Электронной Почты',
        'verify_email_description' => 'Адрес электронной почты этого клиента не был верифицирован. Вы можете вручную верифицировать его, чтобы подтвердить, что их email действителен.',
        'verify_email_button' => 'Верифицировать Email',
        'verify_email_confirmation' => 'Подтвердить Верификацию Email',
        'verify_email_confirmation_desc' => 'Вы уверены, что хотите верифицировать адрес электронной почты :email для :name? Это отметит их email как подтвержденный.',
        'verify_email_success' => 'Email :email был успешно верифицирован для :name.',
        'email_already_verified' => 'Этот адрес электронной почты уже верифицирован.',
        'resend_confirmation_button' => 'Отправить Повторно Подтверждающее Письмо',
        'resend_confirmation_title' => 'Отправить Повторно Подтверждающее Письмо',
        'resend_confirmation_desc' => 'Вы уверены, что хотите отправить повторно подтверждающее письмо на :email для :name? Это отправит новую ссылку для верификации на их адрес электронной почты.',
        'resend_confirmation_success' => 'Подтверждающее письмо было отправлено на :email.',
        'resend_confirmation_error' => 'Не удалось отправить подтверждающее письмо. Пожалуйста, попробуйте снова.',
        'customer_verified_successfully' => 'Этот клиент верифицирован и ему можно доверять.',
        'customer_not_verified_yet' => 'Этот клиент еще не верифицирован.',
        'verification_pending' => 'Верификация в Ожидании',
        'click_verify_to_approve' => 'Нажмите кнопку ниже, чтобы верифицировать этого клиента и отобразить значок верификации.',
        'verification_note' => 'Примечание Верификации',
        'verification_note_placeholder' => 'Введите любые примечания об этой верификации...',
        'verification_note_helper' => 'Добавьте примечания о процессе верификации (только для внутреннего использования)',
        'forms' => [
            'name' => 'Имя',
            'email' => 'Электронная почта',
            'phone' => 'Телефон',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Аватар',
            'dob' => 'Дата Рождения',
            'company' => 'Компания',
            'position' => 'Должность',
            'password' => 'Пароль',
            'password_confirmation' => 'Подтверждение пароля',
            'change_password' => 'Изменить пароль?',
            'phone_placeholder' => 'Телефон',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => 'Арендодатели',
        'view' => 'Просмотр :name',
        'information' => 'Информация об Арендодателе',
        'total_cars' => 'Всего Автомобилей',
        'total_bookings' => 'Всего Бронирований',
        'verified' => 'Верифицирован',
        'not_verified' => 'Не Верифицирован',
        'verification_section' => 'Верификация Арендодателя',
        'vendor_verified_successfully' => 'Этот арендодатель верифицирован и ему можно доверять.',
        'vendor_not_verified_yet' => 'Этот арендодатель еще не верифицирован.',
        'verification_pending' => 'Верификация в Ожидании',
        'click_verify_to_approve' => 'Нажмите кнопку ниже, чтобы верифицировать этого арендодателя и отобразить значок верификации.',
        'verify_vendor' => 'Верифицировать Арендодателя',
        'unverify_vendor' => 'Отменить Верификацию',
        'verify_vendor_confirmation' => 'Подтверждение Верификации Арендодателя',
        'verify_vendor_confirmation_desc' => 'Вы уверены, что хотите верифицировать :name? Это отобразит значок верификации в их профиле.',
        'unverify_vendor_confirmation' => 'Подтверждение Отмены Верификации',
        'unverify_vendor_confirmation_desc' => 'Вы уверены, что хотите удалить верификацию :name? Значок верификации будет удален.',
        'verified_successfully' => 'Арендодатель успешно верифицирован.',
        'unverified_successfully' => 'Верификация арендодателя успешно удалена.',
        'already_verified' => 'Этот арендодатель уже верифицирован.',
        'not_verified_yet' => 'Этот арендодатель еще не верифицирован.',
        'recent_activity' => 'Последняя Активность',
        'recent_cars' => 'Последние Автомобили',
        'recent_bookings' => 'Последние Бронирования',
        'no_cars_yet' => 'Автомобили еще не добавлены.',
        'no_bookings_yet' => 'Бронирования еще не получены.',
    ],
    'make' => [
        'name' => 'Марки',
        'create' => 'Создать Марку Автомобиля',
        'forms' => [
            'logo' => 'Логотип',
            'logo_dark' => 'Логотип Темный',
        ],
    ],
    'car' => [
        'name' => 'Автомобили',
        'create' => 'Создать Автомобиль',
        'forms' => [
            'car' => 'Автомобиль',
            'logo' => 'Логотип',
            'license_plate' => 'Регистрационный Номер',
            'make' => 'Марка',
            'model' => 'Модель',
            'name' => 'Название',
            'images' => 'Изображения',
            'year' => 'Год',
            'color' => 'Цвет',
            'mileage' => 'Пробег',
            'kilometers' => 'Километры',
            'horsepower' => 'Лошадиные Силы',
            'vehicle_type' => 'Тип Транспорта',
            'transmission' => 'Коробка Передач',
            'fuel_type' => 'Тип Топлива',
            'rental_rate' => 'Ставка Аренды',
            'currency' => 'Валюта',
            'status' => 'Статус',
            'availability' => 'Доступность',
            'insurance_info' => 'Информация о страховке',
            'number_of_seats' => 'Количество Мест',
            'number_of_doors' => 'Количество Дверей',
            'vin' => 'VIN',
            'maintenance_history' => 'История Обслуживания',
            'location' => 'Местоположение',
            'description' => 'Описание',
            'rental_type' => 'Тип Аренды',
            'tags' => 'Теги',
            'add_new_attribute' => 'Добавить новый атрибут <a href=":url" target="_blank">здесь</a>.',
            'categories' => 'Категории',
            'pick_address' => 'Адрес Получения',
            'return_address' => 'Адрес Возврата',
            'same_drop_off' => 'То Же Место Возврата',
            'tax' => 'Налог',
            'select_tax' => 'Выбрать Налог',
            'none' => 'Нет',
            'colors' => 'Цвета',
            'amenities' => 'Удобства',
            'is_used' => 'Использованный?',
            'moderation_status' => 'Статус модерации',
            'status_moderation' => [
                'approve' => 'Утвердить',
                'reject' => 'Отклонить',
                'approve_title' => 'Утвердить автомобиль',
                'approve_message' => 'Вы уверены, что хотите утвердить этот автомобиль? Это действие не может быть отменено.',
                'reject_title' => 'Отклонить автомобиль',
                'reject_message' => 'Вы уверены, что хотите отклонить этот автомобиль? Это действие не может быть отменено.',
                'reject_reason' => 'Введите причину отклонения',
                'approved' => 'Автомобиль успешно утвержден!',
                'rejected' => 'Автомобиль успешно отклонен!',
                'reason_rejected' => 'Причина отклонения',
            ],
            'customer' => 'Клиент',
            'select_customer' => 'Выберите клиента...',
            'vendor_images' => 'Изображения (Максимум :max изображений)',
            'images_upload_placeholder' => 'Перетащите файлы сюда или нажмите для загрузки.',
            'car_purpose' => 'Назначение Автомобиля',
            'for_rent' => 'В Аренду',
            'for_sale' => 'На Продажу',
            'car_type' => 'Тип Автомобиля',
            'rental_information' => 'Информация об Аренде',
            'sale_statuses' => [
                'available' => 'Доступен',
                'sold' => 'Продан',
                'reserved' => 'Зарезервирован',
            ],
            'selling_information' => 'Информация о Продаже',
            'is_for_sale' => 'Доступен для продажи',
            'sale_price' => 'Цена Продажи',
            'sale_price_placeholder' => 'Введите цену продажи',
            'condition' => 'Состояние',
            'select_condition' => 'Выберите Состояние',
            'condition_options' => [
                'new' => 'Новый',
                'like_new' => 'Как Новый',
                'excellent' => 'Отличное',
                'good' => 'Хорошее',
                'fair' => 'Удовлетворительное',
                'poor' => 'Плохое',
            ],
            'ownership_history' => 'История Владения',
            'ownership_history_placeholder' => 'Введите историю владения',
            'warranty_information' => 'Информация о Гарантии',
            'warranty_information_placeholder' => 'Введите информацию о гарантии',
            'sale_status' => 'Статус Продажи',
            'external_booking_url' => 'Ссылка на Внешнее Бронирование',
            'external_booking_url_helper' => 'Введите внешний URL, где клиенты могут забронировать этот автомобиль вне платформы. Оставьте пустым, если бронирование доступно только на этом сайте.',
            'address' => 'Адрес',
            'address_helper' => 'Введите конкретный адрес улицы, где находится этот автомобиль',
        ],
        'car_purposes' => [
            'sale' => 'На Продажу',
            'rent' => 'В Аренду',
        ],
        'placeholders' => [
            'name' => 'Введите название автомобиля (например, Toyota Camry 2023, Honda CR-V и т.д.)',
            'description' => 'Введите краткое описание автомобиля с указанием ключевых особенностей',
            'rental_rate' => 'Введите ставку аренды на основе выбранного типа аренды',
            'location' => 'Введите физическое местоположение автомобиля',
            'address' => 'Введите конкретный адрес улицы (например, ул. Главная 123, Город, Регион)',
            'sale_price' => 'Введите цену продажи этого автомобиля',
            'ownership_history' => 'Введите детали о предыдущих владельцах, количестве владельцев и т.д.',
            'warranty_information' => 'Введите детали о покрытии гарантии, дате истечения и т.д.',
            'external_booking_url' => 'https://primer.ru/ssylka-bronirovaniya',
            'license_plate' => 'Введите регистрационный номер автомобиля',
            'vin' => 'Введите Идентификационный Номер Транспорта (VIN)',
            'year' => 'Введите год выпуска (например, 2023)',
            'mileage' => 'Введите текущий пробег',
            'kilometers' => 'Введите текущие километры',
            'horsepower' => 'Введите мощность автомобиля (л.с.) (например, 150,5)',
            'number_of_seats' => 'Введите количество мест в автомобиле',
            'number_of_doors' => 'Введите количество дверей автомобиля',
            'insurance_info' => 'Введите соответствующую информацию о страховке для этого автомобиля',
            'tags' => 'Выберите или создайте теги',
            'amenities' => 'Выберите удобства',
            'colors' => 'Выберите или создайте цвета',
        ],
        'enums' => [
            'vendor_status' => 'Статус Арендодателя',
            'is_vendor' => 'Арендодатель',
            'not_vendor' => 'Клиент',
            'statuses' => [
                'available' => 'Доступен',
                'rented' => 'Арендован',
                'maintenance' => 'На Обслуживании',
                'out_of_service' => 'Вне Службы',
            ],
            'rental_types' => [
                'per_hour' => 'В час',
                'per_day' => 'В день',
                'per_week' => 'В неделю',
                'per_month' => 'В месяц',
            ],
            'moderation_statuses' => [
                'pending' => 'В Ожидании',
                'approved' => 'Утверждено',
                'rejected' => 'Отклонено',
            ],
        ],
        'maintenance_history' => [
            'name' => 'История Обслуживания',
            'create' => 'Создать Историю Обслуживания',
            'amount' => 'Сумма',
            'forms' => [
                'price_placeholder' => 'Цена услуги',
                'currency' => 'Валюта',
                'none' => 'Нет',
                'name' => 'Название',
                'amount' => 'Сумма',
                'created_at' => 'Создано',
                'action' => 'Действие',
                'date' => 'Дата',
                'no_maintenance_history' => 'Нет истории обслуживания',
                'edit_maintenance_history' => 'Редактировать историю обслуживания',
                'add_maintenance_history' => 'Добавить историю обслуживания',
                'add' => 'Добавить',
                'edit' => 'Редактировать',
                'delete' => 'Удалить',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Атрибуты Автомобиля',
        'car_type' => [
            'name' => 'Типы',
            'create' => 'Создать Тип Автомобиля',
            'forms' => [
                'name' => 'Название',
            ],
        ],
        'transmission' => [
            'name' => 'Коробки Передач',
            'create' => 'Создать Коробку Передач',
            'forms' => [
                'name' => 'Название',
            ],
        ],
        'fuel_type' => [
            'name' => 'Топлива',
            'create' => 'Создать Типы Топлива',
            'forms' => [
                'name' => 'Название',
            ],
        ],
        'tag' => [
            'name' => 'Теги',
            'create' => 'Создать Тег',
        ],
        'category' => [
            'name' => 'Категории',
            'create' => 'Создать Категорию',
            'forms' => [
                'none' => 'Нет',
                'total_cars' => 'Всего автомобилей: :total',
            ],
        ],
        'address' => [
            'name' => 'Местоположения',
            'create' => 'Создать Местоположение Автомобиля',
            'form' => [
                'name' => 'Адрес',
                'full_address' => 'Полный Адрес',
                'detail_address' => 'Подробный Адрес',
            ],
        ],
        'color' => [
            'name' => 'Цвет',
            'create' => 'Создать Цвет',
        ],
        'amenity' => [
            'name' => 'Удобства',
            'create' => 'Создать Удобство',
        ],
    ],
    'tax' => [
        'name' => 'Налоги',
        'create' => 'Создать Налог',
        'forms' => [
            'name' => 'Название',
            'name_placeholder' => 'Введите название',
            'percentage' => 'Процент',
            'percentage_placeholder' => 'Процент',
            'percent_placeholder' => 'Процент',
            'priority' => 'Приоритет',
            'priority_placeholder' => 'Приоритет',
        ],
    ],
    'review' => [
        'name' => 'Отзывы',
        'create' => 'Создать Отзыв',
        'edit' => 'Редактировать Отзыв',
        'vendor' => [
            'title' => 'Отзывы Клиентов',
            'description' => 'Управляйте всеми отзывами клиентов о ваших автомобилях',
            'no_reviews' => 'У вас еще нет отзывов',
            'filter_by_car' => 'Фильтр по автомобилю',
            'filter_by_rating' => 'Фильтр по рейтингу',
            'filter_by_date' => 'Фильтр по дате',
            'all_cars' => 'Все Автомобили',
            'all_ratings' => 'Все Рейтинги',
            'manage_reviews' => 'Управление Отзывами',
            'view_all' => 'Просмотреть Все Отзывы',
            'delete_review_confirmation' => 'Вы уверены, что хотите удалить этот отзыв?',
            'delete_review_success' => 'Отзыв успешно удален',
            'cannot_delete' => 'Невозможно удалить этот отзыв',
        ],
        'forms' => [
            'customer' => 'Клиент',
            'car' => 'Автомобиль',
            'content' => 'Содержание',
            'rating' => 'Рейтинг',
            'your_name' => 'Ваше Имя',
            'email_address' => 'Адрес Электронной Почты',
            'submit' => 'Отправить',
            'star' => 'Звезда',
            'status' => 'Статус',
            'created_at' => 'Создано',
            'select_car' => 'Выбрать Автомобиль',
            'select_rating' => 'Выбрать Рейтинг',
            'comment' => 'Комментарий',
            'reply' => 'Ответить',
            'reply_to_review' => 'Ответить на Отзыв',
            'save_reply' => 'Сохранить Ответ',
            'cancel_reply' => 'Отмена',
        ],
        'statuses' => [
            'published' => 'Опубликовано',
            'pending' => 'В Ожидании',
            'rejected' => 'Отклонено',
        ],
        'ratings' => [
            1 => '1 Звезда - Плохо',
            '2 Звезды - Удовлетворительно',
            '3 Звезды - Хорошо',
            '4 Звезды - Очень Хорошо',
            '5 Звезд - Отлично',
        ],
    ],
    'coupon' => [
        'name' => 'Купоны',
        'create' => 'Создать Купон',
        'types' => [
            'percentage' => 'Процент %',
            'money' => 'Деньги',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'Услуги',
        'create' => 'Создать Услугу',
        'forms' => [
            'name' => 'Название',
            'content' => 'Содержание',
            'price' => 'Цена',
            'currency' => 'Валюта',
            'image' => 'Изображение',
            'logo' => 'Логотип',
            'status' => 'Статус',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Календарь Доступности',
        'title' => 'Календарь Доступности',
        'description' => 'Просмотр доступности автомобилей и бронирований в формате календаря',
        'select_dates' => 'Выберите даты для проверки доступности',
        'car_filter' => 'Фильтр по Автомобилю',
        'all_cars' => 'Все Автомобили',
        'clear_filter' => 'Очистить Фильтр',
        'availability_check' => 'Проверка Доступности Автомобиля',
        'selected_period' => 'Выбранный Период',
        'checking_availability' => 'Проверка доступности...',
        'available' => 'Доступен',
        'not_available' => 'Недоступен',
        'booking_details' => 'Детали Бронирования',
        'how_to_use' => 'Как Использовать Календарь Доступности Автомобилей',
        'viewing_bookings' => 'Просмотр Бронирований',
        'checking_availability_help' => 'Проверка Доступности',
        'color_legend' => 'Легенда Цветов',
        'pending_bookings' => 'Бронирования в Ожидании',
        'processing_bookings' => 'Бронирования в Обработке',
        'completed_bookings' => 'Завершенные Бронирования',
        'cancelled_bookings' => 'Отмененные Бронирования',
        'unknown_make' => 'Неизвестная Марка',
        'loading' => 'Загрузка...',
        'loading_calendar_data' => 'Загрузка данных календаря...',
        'loading_booking_details' => 'Загрузка деталей бронирования...',
        'please_wait_booking_info' => 'Пожалуйста, подождите, мы получаем информацию о бронировании.',
        'please_wait_availability' => 'Пожалуйста, подождите, мы проверяем доступность автомобилей для выбранных дат.',
        'error' => 'Ошибка',
        'error_loading_booking' => 'Не удалось загрузить детали бронирования. Попробуйте снова.',
        'error_checking_availability' => 'Ошибка при проверке доступности автомобиля',
        'customer' => 'Клиент',
        'status' => 'Статус',
        'amount' => 'Сумма',
        'make' => 'Марка',
        'vendor' => 'Арендодатель',
        'per_day' => '/день',
        'edit_car' => 'Редактировать Автомобиль',
        'no_cars_found' => 'Автомобили не найдены',
        'no_cars_available_period' => 'Нет доступных автомобилей на выбранный период.',
        'close' => 'Закрыть',
        'edit_booking' => 'Редактировать Бронирование',
        'pending' => 'В Ожидании',
        'processing' => 'Обработка',
        'completed' => 'Завершено',
        'cancelled' => 'Отменено',
    ],
    'theme_options' => [
        'name' => 'Аренда Автомобилей',
        'description' => 'Настройки темы для аренды автомобилей',
        'car_location_filter_by' => 'Фильтр местоположения автомобиля по',
        'state' => 'Регион',
        'city' => 'Город',
        'yes' => 'Да',
        'no' => 'Нет',
        'is_display_country' => 'Отображать страну в фильтре местоположения?',
        'logo_vendor_dashboard' => 'Логотип на панели арендодателя (По умолчанию основной логотип)',
        'number_of_cars_per_page' => 'Количество автомобилей на странице',
        'number_of_cars_per_page_placeholder' => 'Введите количество автомобилей для отображения на странице',
    ],
    'message' => [
        'name' => 'Сообщения',
        'forms' => [
            'customer_name' => 'Имя клиента',
            'message' => 'Сообщение',
            'phone' => 'Телефон',
            'email' => 'Электронная почта',
            'created_at' => 'Создано',
            'status' => 'Статус',
        ],
    ],
    'car_sale' => [
        'name' => 'Продажи Автомобилей',
        'create' => 'Новая Продажа Автомобиля',
        'edit' => 'Редактировать Продажу Автомобиля :name',
        'statuses' => [
            'pending' => 'В Ожидании',
            'processing' => 'Обработка',
            'completed' => 'Завершено',
            'cancelled' => 'Отменено',
        ],
        'forms' => [
            'transaction_id' => 'ID Транзакции',
            'transaction_id_placeholder' => 'Введите ID транзакции',
            'car_id' => 'Автомобиль',
            'car' => 'Автомобиль',
            'customer_id' => 'Клиент',
            'customer_name' => 'Имя Клиента',
            'customer_name_placeholder' => 'Введите имя клиента',
            'customer_email' => 'Электронная Почта Клиента',
            'customer_email_placeholder' => 'Введите электронную почту клиента',
            'customer_phone' => 'Телефон Клиента',
            'customer_phone_placeholder' => 'Введите телефон клиента',
            'sale_price' => 'Цена Продажи',
            'sale_price_placeholder' => 'Введите цену продажи',
            'tax_amount' => 'Сумма Налога',
            'tax_amount_placeholder' => 'Введите сумму налога',
            'total_amount' => 'Общая Сумма',
            'total_amount_placeholder' => 'Введите общую сумму',
            'payment_details' => 'Детали Оплаты',
            'payment_details_placeholder' => 'Введите детали оплаты',
            'notes' => 'Примечания',
            'notes_placeholder' => 'Введите примечания',
            'sale_date' => 'Дата Продажи',
            'delivery_date' => 'Дата Доставки',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Банковский Перевод',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        'booking_confirm_title' => 'Подтверждение Бронирования Аренды Автомобиля',
        'booking_confirm_greeting' => 'Уважаемый :customer_name,',
        'booking_confirm_message' => 'Мы рады сообщить вам, что ваше бронирование аренды автомобиля успешно подтверждено!',
        'customer_information' => 'Информация о Клиенте',
        'booking_information' => 'Информация о Бронировании',
        'field_name' => 'Имя:',
        'field_phone' => 'Телефон:',
        'field_email' => 'Электронная почта:',
        'field_car_model' => 'Модель Автомобиля:',
        'field_start_date' => 'Дата Начала:',
        'field_end_date' => 'Дата Окончания:',
        'field_pickup_address' => 'Адрес Получения:',
        'field_return_address' => 'Адрес Возврата:',
        'field_note' => 'Примечание:',
        'field_order_number' => 'Номер заказа',
        'field_payment_method' => 'Способ Оплаты',
        'booking_notice_admin_title' => 'Уведомление о Новом Бронировании',
        'booking_notice_admin_greeting' => 'Здравствуйте, получено новое бронирование от :site_title:',
        'booking_notice_admin_message' => 'Новое бронирование аренды автомобиля было отправлено и требует вашего внимания.',
        'booking_view_detail' => 'Просмотр деталей бронирования:',
        'view_booking_details' => 'Просмотр Деталей Бронирования',
        'booking_notice_vendor_title' => 'Новое Бронирование Вашего Автомобиля',
        'booking_notice_vendor_greeting' => 'Уважаемый :vendor_name,',
        'booking_notice_vendor_message' => 'Отличная новость! Вы получили новое бронирование вашего автомобиля.',
        'booking_status_updated' => 'Статус Бронирования Обновлен',
        'hello_thanks_for_booking' => 'Здравствуйте, Спасибо за бронирование номеров в :site_title:',
        'booking_status_change_message' => 'Надеемся, что это сообщение найдет вас в добром здравии. Мы хотели сообщить вам, что статус вашего бронирования был обновлен.',
        'name' => 'Имя',
        'phone' => 'Телефон',
        'email' => 'Электронная почта',
        'car_model' => 'Модель Автомобиля',
        'start_date' => 'Дата Начала',
        'end_date' => 'Дата Окончания',
        'pickup_address' => 'Адрес Получения',
        'return_address' => 'Адрес Возврата',
        'note' => 'Примечание',
        'order_number' => 'Номер заказа',
        'payment_method' => 'Способ Оплаты',
        'hello' => 'Здравствуйте',
        'car_approved_title' => 'Отличная Новость! Ваш Автомобиль Утвержден',
        'car_approved_message' => 'Мы рады сообщить вам, что ваше объявление об автомобиле ":car_name" было утверждено и теперь доступно на :site_title. Вы можете начать получать бронирования и управлять своим объявлением прямо сейчас.',
        'view_edit_car_link' => 'Чтобы просмотреть или отредактировать ваше объявление об автомобиле, пожалуйста, нажмите на эту ссылку',
        'view_car' => 'Просмотр Объявления об Автомобиле',
        'regards' => 'С уважением',
        'vendor_upgrade_title' => 'Поздравляем! Теперь Вы Арендодатель',
        'vendor_upgrade_congratulations' => 'Мы рады сообщить вам, что ваш аккаунт успешно повышен до статуса арендодателя!',
        'vendor_upgrade_message' => 'Теперь вы можете размещать и управлять своими автомобилями на :site_title. Это открывает новые возможности для развития вашего арендного бизнеса с нами.',
        'vendor_benefits_title' => 'Ваши Новые Преимущества Арендодателя',
        'vendor_benefit_1' => 'Размещение неограниченного количества автомобилей для аренды',
        'vendor_benefit_2' => 'Управление собственными бронированиями и клиентами',
        'vendor_benefit_3' => 'Отслеживание доходов и показателей производительности',
        'vendor_benefit_4' => 'Доступ к эксклюзивным функциям и инструментам для арендодателей',
        'next_steps' => 'Следующие Шаги',
        'vendor_next_steps_message' => 'Войдите в панель арендодателя, чтобы начать добавлять свои автомобили и управлять арендным бизнесом.',
        'go_to_dashboard' => 'Перейти в Панель Арендодателя',
        'vendor_support_message' => 'Если у вас есть вопросы или нужна помощь, наша служба поддержки готова помочь вам начать.',
        'approved' => 'Утверждено',
        'car_rejected_title' => 'Требуется Обновление Объявления об Автомобиле',
        'car_rejected_message' => 'Благодарим вас за отправку объявления об автомобиле ":car_name" на :site_title. После рассмотрения вашей заявки, нам нужно, чтобы вы внесли некоторые изменения, прежде чем мы сможем ее утвердить.',
        'rejection_reason' => 'Вот что нужно обновить',
        'rejection_details' => 'Необходимые Обновления',
        'contact_support' => 'Если у вас есть вопросы или нужна помощь с этими обновлениями, не стесняйтесь обращаться в нашу службу поддержки по адресу :site_email. Мы здесь, чтобы помочь вам быстро получить утверждение вашего объявления.',
        'verify_email' => 'Верификация Электронной Почты',
        'welcome_message' => 'Мы рады видеть вас здесь, :customer_name!',
        'verify_email_instruction' => 'Пожалуйста, верифицируйте ваш адрес электронной почты для доступа к этому сайту. Нажмите на кнопку ниже, чтобы верифицировать вашу электронную почту.',
        'confirm_email_button' => 'Подтвердите свой адрес электронной почты',
        'verify_link_trouble' => 'Если у вас возникли проблемы с нажатием кнопки \'Подтвердите свой адрес электронной почты\', скопируйте и вставьте URL ниже в ваш веб-браузер: :verify_link и вставьте его в ваш браузер.',
        'new_message' => 'Новое Сообщение',
        'dear_admin' => 'Уважаемый Администратор',
        'new_message_from' => 'Новое сообщение от :site_title:',
        'subject' => 'Тема',
        'address' => 'Адрес',
        'content' => 'Содержание',
        'hi_admin' => 'Здравствуйте, Администратор,',
        'new_car_pending_title' => 'Новое Объявление об Автомобиле Ожидает Рассмотрения',
        'new_car_pending_approval' => 'Новое объявление об автомобиле ":post_name" было отправлено :post_author и готово для вашего рассмотрения.',
        'pending_approval' => 'Ожидает Рассмотрения',
        'review_car_admin' => 'Пожалуйста, рассмотрите это объявление в панели администратора и утвердите или запросите обновления по мере необходимости.',
        'car_information' => 'Информация об Автомобиле',
        'field_car_name' => 'Название Автомобиля:',
        'field_author' => 'Автор:',
        'field_status' => 'Статус:',
        'actions' => 'Действия',
        'reset_password_instruction' => 'Инструкции по Сбросу Пароля',
        'password_reset_request' => 'Вы получаете это письмо, потому что мы получили запрос на сброс пароля для вашего аккаунта.',
        'reset_password_button' => 'Сбросить пароль',
        'reset_link_trouble' => 'Если у вас возникли проблемы с нажатием кнопки \'Сбросить Пароль\', скопируйте и вставьте URL ниже в ваш веб-браузер: :reset_link и вставьте его в ваш браузер. Если вы не запрашивали сброс пароля, пожалуйста, проигнорируйте это сообщение или свяжитесь с нами, если у вас есть вопросы.',
    ],
];
