<?php

return [
    'name' => 'Najam vozila',
    'customer' => [
        'name' => 'Kupci',
        'create' => 'Kreiraj kupca',
        'view' => 'Pregledaj',
        'information' => 'Informacije o kupcu',
        'email' => 'E-pošta',
        'phone' => 'Telefon',
        'status' => 'Status',
        'vendor_status' => 'Status dobavljača',
        'is_vendor' => 'Dobavljač',
        'not_vendor' => 'Kupac',
        'recent_activity' => 'Nedavna aktivnost',
        'recent_activity_description' => 'Aktivnost kupca pojavit će se ovdje.',
        'verification_section' => 'Potvrda kupca',
        'verified' => 'Potvrđeno',
        'not_verified' => 'Nije potvrđeno',
        'verified_by' => 'Potvrdio',
        'verified_at' => 'Potvrđeno u',
        'verify_customer' => 'Potvrdi kupca',
        'unverify_customer' => 'Ukloni potvrdu kupca',
        'verify_customer_confirmation' => 'Potvrda potvrde kupca',
        'verify_customer_confirmation_desc' => 'Jeste li sigurni da želite potvrditi :name? Ovo će prikazati značku potvrđeno na njihovom profilu.',
        'unverify_customer_confirmation' => 'Potvrda uklanjanja potvrde kupca',
        'unverify_customer_confirmation_desc' => 'Jeste li sigurni da želite ukloniti potvrdu od :name? Značka potvrđeno bit će uklonjena.',
        'verify_success' => 'Kupac :name uspješno potvrđen.',
        'unverify_success' => 'Potvrda kupca :name uspješno uklonjena.',
        'already_verified' => 'Ovaj kupac je već potvrđen.',
        'already_unverified' => 'Ovaj kupac nije potvrđen.',
        'upgrade_to_vendor_title' => 'Nadogradi na dobavljača',
        'upgrade_to_vendor_description' => 'Nadogradite ovog kupca na status dobavljača kako bi im omogućili da navedu i upravljaju vlastitim najmom vozila.',
        'upgrade_to_vendor_button' => 'Nadogradi na dobavljača',
        'upgrade_to_vendor_confirmation' => 'Potvrdi nadogradnju na dobavljača',
        'upgrade_to_vendor_confirmation_desc' => 'Jeste li sigurni da želite nadograditi :name na status dobavljača? Ovo će im omogućiti da navedu i upravljaju vlastitim vozilima na platformi.',
        'upgrade_to_vendor_success' => ':name je uspješno nadograđen na status dobavljača.',
        'already_vendor' => 'Ovaj kupac je već dobavljač.',
        'customer_verified_successfully' => 'Ovaj kupac je potvrđen i njemu se može vjerovati.',
        'customer_not_verified_yet' => 'Ovaj kupac još nije potvrđen.',
        'verification_pending' => 'Potvrda na čekanju',
        'click_verify_to_approve' => 'Kliknite gumb ispod da potvrdite ovog kupca i prikažete značku potvrđeno.',
        'verification_note' => 'Napomena o potvrdi',
        'verification_note_placeholder' => 'Unesite napomene o ovoj radnji potvrde...',
        'verification_note_helper' => 'Dodajte napomene o procesu potvrde (samo za internu upotrebu)',
        'forms' => [
            'name' => 'Ime',
            'email' => 'E-pošta',
            'phone' => 'Telefon',
            'avatar' => 'Avatar',
            'dob' => 'Datum rođenja',
            'company' => 'Tvrtka',
            'position' => 'Pozicija',
            'password' => 'Lozinka',
            'password_confirmation' => 'Potvrda lozinke',
            'change_password' => 'Promijeni lozinku?',
            'phone_placeholder' => 'Telefon',
        ],
    ],
    'vendor' => [
        'name' => 'Dobavljači',
        'view' => 'Pregledaj :name',
        'information' => 'Informacije o dobavljaču',
        'total_cars' => 'Ukupno vozila',
        'total_bookings' => 'Ukupno rezervacija',
        'verified' => 'Potvrđeno',
        'not_verified' => 'Nije potvrđeno',
        'verification_section' => 'Potvrda dobavljača',
        'vendor_verified_successfully' => 'Ovaj dobavljač je potvrđen i njemu se može vjerovati.',
        'vendor_not_verified_yet' => 'Ovaj dobavljač još nije potvrđen.',
        'verification_pending' => 'Potvrda na čekanju',
        'click_verify_to_approve' => 'Kliknite gumb ispod da potvrdite ovog dobavljača i prikažete značku potvrđeno.',
        'verify_vendor' => 'Potvrdi dobavljača',
        'unverify_vendor' => 'Ukloni potvrdu dobavljača',
        'verify_vendor_confirmation' => 'Potvrda potvrde dobavljača',
        'verify_vendor_confirmation_desc' => 'Jeste li sigurni da želite potvrditi :name? Ovo će prikazati značku potvrđeno na njihovom profilu.',
        'unverify_vendor_confirmation' => 'Potvrda uklanjanja potvrde dobavljača',
        'unverify_vendor_confirmation_desc' => 'Jeste li sigurni da želite ukloniti potvrdu od :name? Značka potvrđeno bit će uklonjena.',
        'verified_successfully' => 'Dobavljač je uspješno potvrđen.',
        'unverified_successfully' => 'Potvrda dobavljača uspješno uklonjena.',
        'already_verified' => 'Ovaj dobavljač je već potvrđen.',
        'not_verified_yet' => 'Ovaj dobavljač još nije potvrđen.',
        'recent_activity' => 'Nedavna aktivnost',
        'recent_cars' => 'Nedavna vozila',
        'recent_bookings' => 'Nedavne rezervacije',
        'no_cars_yet' => 'Još nisu dodana vozila.',
        'no_bookings_yet' => 'Još nisu primljene rezervacije.',
    ],
    'make' => [
        'name' => 'Proizvođači',
        'create' => 'Kreiraj proizvođača vozila',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Tamni logo',
        ],
    ],
    'car' => [
        'name' => 'Vozila',
        'create' => 'Kreiraj vozilo',
        'forms' => [
            'car' => 'Vozilo',
            'logo' => 'Logo',
            'license_plate' => 'Registracijska pločica',
            'make' => 'Proizvođač',
            'model' => 'Model',
            'name' => 'Naziv',
            'images' => 'Slike',
            'year' => 'Godina',
            'color' => 'Boja',
            'mileage' => 'Kilometraža',
            'kilometers' => 'Kilometri',
            'horsepower' => 'Konjska snaga',
            'vehicle_type' => 'Tip vozila',
            'transmission' => 'Mjenjač',
            'fuel_type' => 'Vrsta goriva',
            'rental_rate' => 'Cijena najma',
            'currency' => 'Valuta',
            'status' => 'Status',
            'availability' => 'Dostupnost',
            'insurance_info' => 'Informacije o osiguranju',
            'number_of_seats' => 'Broj sjedala',
            'number_of_doors' => 'Broj vrata',
            'vin' => 'VIN',
            'maintenance_history' => 'Povijest održavanja',
            'location' => 'Lokacija',
            'description' => 'Opis',
            'rental_type' => 'Vrsta najma',
            'tags' => 'Oznake',
            'add_new_attribute' => 'Dodaj novo <a href=":url" target="_blank">ovdje</a>.',
            'categories' => 'Kategorije',
            'pick_address' => 'Adresa preuzimanja',
            'return_address' => 'Adresa povrata',
            'same_drop_off' => 'Ista lokacija povrata',
            'tax' => 'Porez',
            'select_tax' => 'Odaberi porez',
            'none' => 'Nijedan',
            'colors' => 'Boje',
            'amenities' => 'Pogodnosti',
            'is_used' => 'Je li rabljeno?',
            'moderation_status' => 'Status moderiranja',
            'status_moderation' => [
                'approve' => 'Odobri',
                'reject' => 'Odbij',
                'approve_title' => 'Odobri vozilo',
                'approve_message' => 'Jeste li sigurni da želite odobriti ovo vozilo? Ova radnja se ne može poništiti.',
                'reject_title' => 'Odbij vozilo',
                'reject_message' => 'Jeste li sigurni da želite odbiti ovo vozilo? Ova radnja se ne može poništiti.',
                'reject_reason' => 'Unesite razlog odbijanja',
                'approved' => 'Vozilo je uspješno odobreno!',
                'rejected' => 'Vozilo je uspješno odbijeno!',
                'reason_rejected' => 'Razlog odbijanja',
            ],
            'customer' => 'Kupac',
            'select_customer' => 'Odaberite kupca...',
            'vendor_images' => 'Slike (Maksimalno :max slika)',
            'images_upload_placeholder' => 'Ispustite datoteke ovdje ili kliknite za prijenos.',
            'car_purpose' => 'Svrha vozila',
            'for_rent' => 'Za najam',
            'for_sale' => 'Za prodaju',
            'car_type' => 'Vrsta vozila',
            'rental_information' => 'Informacije o najmu',
            'sale_statuses' => [
                'available' => 'Dostupno',
                'sold' => 'Prodano',
                'reserved' => 'Rezervirano',
            ],
            'selling_information' => 'Informacije o prodaji',
            'is_for_sale' => 'Dostupno za prodaju',
            'sale_price' => 'Prodajna cijena',
            'sale_price_placeholder' => 'Unesite prodajnu cijenu',
            'condition' => 'Stanje',
            'select_condition' => 'Odaberite stanje',
            'condition_options' => [
                'new' => 'Novo',
                'like_new' => 'Kao novo',
                'excellent' => 'Izvrsno',
                'good' => 'Dobro',
                'fair' => 'Solidno',
                'poor' => 'Loše',
            ],
            'ownership_history' => 'Povijest vlasništva',
            'ownership_history_placeholder' => 'Unesite povijest vlasništva',
            'warranty_information' => 'Informacije o jamstvu',
            'warranty_information_placeholder' => 'Unesite informacije o jamstvu',
            'sale_status' => 'Status prodaje',
            'external_booking_url' => 'Poveznica za rezervaciju izvan stranice',
            'external_booking_url_helper' => 'Unesite vanjski URL gdje kupci mogu rezervirati ovo vozilo izvan ove platforme. Ostavite prazno ako je rezervacija dostupna samo na ovoj stranici.',
            'address' => 'Adresa',
            'address_helper' => 'Unesite specifičnu adresu ulice gdje se nalazi ovo vozilo',
        ],
        'car_purposes' => [
            'sale' => 'Za prodaju',
            'rent' => 'Za najam',
        ],
        'placeholders' => [
            'name' => 'Unesite naziv vozila (npr. Toyota Camry 2023, Honda CR-V, itd.)',
            'description' => 'Unesite kratak opis vozila s isticanjem ključnih značajki',
            'rental_rate' => 'Unesite cijenu najma na temelju odabrane vrste najma',
            'location' => 'Unesite fizičku lokaciju vozila',
            'address' => 'Unesite specifičnu adresu ulice (npr. Glavna ulica 123, Grad, Država)',
            'sale_price' => 'Unesite prodajnu cijenu za ovo vozilo',
            'ownership_history' => 'Unesite detalje o prethodnim vlasnicima, broj vlasnika, itd.',
            'warranty_information' => 'Unesite detalje o pokrivenosti jamstva, datumu isteka, itd.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Unesite broj registracijske pločice vozila',
            'vin' => 'Unesite identifikacijski broj vozila (VIN)',
            'year' => 'Unesite godinu proizvodnje (npr. 2023)',
            'mileage' => 'Unesite trenutnu kilometražu',
            'kilometers' => 'Unesite trenutne kilometre',
            'horsepower' => 'Unesite konjsku snagu (HP) vozila (npr. 150.5)',
            'number_of_seats' => 'Unesite broj sjedala u vozilu',
            'number_of_doors' => 'Unesite broj vrata koje vozilo ima',
            'insurance_info' => 'Unesite relevantne informacije o osiguranju za ovo vozilo',
            'tags' => 'Odaberite ili kreirajte oznake',
            'amenities' => 'Odaberite pogodnosti',
            'colors' => 'Odaberite ili kreirajte boje',
        ],
        'enums' => [
            'vendor_status' => 'Status dobavljača',
            'is_vendor' => 'Dobavljač',
            'not_vendor' => 'Kupac',
            'statuses' => [
                'available' => 'Dostupno',
                'rented' => 'Iznajmljeno',
                'maintenance' => 'Održavanje',
                'out_of_service' => 'Izvan pogona',
            ],
            'rental_types' => [
                'per_hour' => 'Po satu',
                'per_day' => 'Po danu',
                'per_week' => 'Po tjednu',
                'per_month' => 'Po mjesecu',
            ],
            'moderation_statuses' => [
                'pending' => 'Na čekanju',
                'approved' => 'Odobreno',
                'rejected' => 'Odbijeno',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Povijest održavanja',
            'create' => 'Kreiraj povijest servisa',
            'amount' => 'Iznos',
            'forms' => [
                'price_placeholder' => 'Cijena servisa',
                'currency' => 'Valuta',
                'none' => 'Nijedan',
                'name' => 'Naziv',
                'amount' => 'Iznos',
                'created_at' => 'Kreirano u',
                'action' => 'Radnja',
                'date' => 'Datum',
                'no_maintenance_history' => 'Nema povijesti održavanja',
                'edit_maintenance_history' => 'Uredi povijest održavanja',
                'add_maintenance_history' => 'Dodaj povijest održavanja',
                'add' => 'Dodaj',
                'edit' => 'Uredi',
                'delete' => 'Izbriši',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atributi vozila',
        'car_type' => [
            'name' => 'Tipovi',
            'create' => 'Kreiraj tip vozila',
            'forms' => [
                'name' => 'Naziv',
            ],
        ],
        'transmission' => [
            'name' => 'Mjenjači',
            'create' => 'Kreiraj mjenjač',
            'forms' => [
                'name' => 'Naziv',
            ],
        ],
        'fuel_type' => [
            'name' => 'Goriva',
            'create' => 'Kreiraj vrste goriva',
            'forms' => [
                'name' => 'Naziv',
            ],
        ],
        'tag' => [
            'name' => 'Oznake',
            'create' => 'Kreiraj oznaku',
        ],
        'category' => [
            'name' => 'Kategorije',
            'create' => 'Kreiraj kategoriju',
            'forms' => [
                'none' => 'Nijedan',
                'total_cars' => 'Ukupno vozila: :total',
            ],
        ],
        'address' => [
            'name' => 'Lokacije',
            'create' => 'Kreiraj lokaciju vozila',
            'form' => [
                'name' => 'Adresa',
                'full_address' => 'Puna adresa',
                'detail_address' => 'Detaljna adresa',
            ],
        ],
        'color' => [
            'name' => 'Boja',
            'create' => 'Kreiraj boju',
        ],
        'amenity' => [
            'name' => 'Pogodnosti',
            'create' => 'Kreiraj pogodnost',
        ],
    ],
    'tax' => [
        'name' => 'Porezi',
        'create' => 'Kreiraj porez',
        'forms' => [
            'name' => 'Naziv',
            'name_placeholder' => 'Unesite naziv',
            'percentage' => 'Postotak',
            'percentage_placeholder' => 'Postotak',
            'percent_placeholder' => 'Postotak',
            'priority' => 'Prioritet',
            'priority_placeholder' => 'Prioritet',
        ],
    ],
    'review' => [
        'name' => 'Recenzije',
        'create' => 'Kreiraj recenziju',
        'edit' => 'Uredi recenziju',
        'vendor' => [
            'title' => 'Recenzije kupaca',
            'description' => 'Upravljajte svim recenzijama kupaca za svoja vozila',
            'no_reviews' => 'Još nemate recenzija',
            'filter_by_car' => 'Filtriraj po vozilu',
            'filter_by_rating' => 'Filtriraj po ocjeni',
            'filter_by_date' => 'Filtriraj po datumu',
            'all_cars' => 'Sva vozila',
            'all_ratings' => 'Sve ocjene',
            'manage_reviews' => 'Upravljaj recenzijama',
            'view_all' => 'Pregledaj sve recenzije',
            'delete_review_confirmation' => 'Jeste li sigurni da želite izbrisati ovu recenziju?',
            'delete_review_success' => 'Recenzija uspješno izbrisana',
            'cannot_delete' => 'Ne može se izbrisati ova recenzija',
        ],
        'forms' => [
            'customer' => 'Kupac',
            'car' => 'Vozilo',
            'content' => 'Sadržaj',
            'rating' => 'Ocjena',
            'your_name' => 'Vaše ime',
            'email_address' => 'Adresa e-pošte',
            'submit' => 'Pošalji',
            'star' => 'Zvijezda',
            'status' => 'Status',
            'created_at' => 'Kreirano u',
            'select_car' => 'Odaberi vozilo',
            'select_rating' => 'Odaberi ocjenu',
            'comment' => 'Komentar',
            'reply' => 'Odgovori',
            'reply_to_review' => 'Odgovori na recenziju',
            'save_reply' => 'Spremi odgovor',
            'cancel_reply' => 'Otkaži',
        ],
        'statuses' => [
            'published' => 'Objavljeno',
            'pending' => 'Na čekanju',
            'rejected' => 'Odbijeno',
        ],
        'ratings' => [
            '1' => '1 zvijezda - Loše',
            '2' => '2 zvijezde - Solidno',
            '3' => '3 zvijezde - Dobro',
            '4' => '4 zvijezde - Vrlo dobro',
            '5' => '5 zvijezda - Izvrsno',
        ],
    ],
    'coupon' => [
        'name' => 'Kuponi',
        'create' => 'Kreiraj kupon',
        'types' => [
            'percentage' => 'Postotak %',
            'money' => 'Novac',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Usluge',
        'create' => 'Kreiraj uslugu',
        'forms' => [
            'name' => 'Naziv',
            'content' => 'Sadržaj',
            'price' => 'Cijena',
            'currency' => 'Valuta',
            'image' => 'Slika',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Kalendar dostupnosti',
        'title' => 'Kalendar dostupnosti',
        'description' => 'Pregledajte dostupnost vozila i rezervacije u formatu kalendara',
        'select_dates' => 'Odaberite datume za provjeru dostupnosti',
        'car_filter' => 'Filtriraj po vozilu',
        'all_cars' => 'Sva vozila',
        'clear_filter' => 'Očisti filter',
        'availability_check' => 'Provjera dostupnosti vozila',
        'selected_period' => 'Odabrano razdoblje',
        'checking_availability' => 'Provjera dostupnosti...',
        'available' => 'Dostupno',
        'not_available' => 'Nije dostupno',
        'booking_details' => 'Detalji rezervacije',
        'how_to_use' => 'Kako koristiti kalendar dostupnosti vozila',
        'viewing_bookings' => 'Pregled rezervacija',
        'checking_availability_help' => 'Provjera dostupnosti',
        'color_legend' => 'Legenda boja',
        'pending_bookings' => 'Rezervacije na čekanju',
        'processing_bookings' => 'Rezervacije u obradi',
        'completed_bookings' => 'Završene rezervacije',
        'cancelled_bookings' => 'Otkazane rezervacije',
        'unknown_make' => 'Nepoznat proizvođač',
        'loading' => 'Učitavanje...',
        'loading_calendar_data' => 'Učitavanje podataka kalendara...',
        'loading_booking_details' => 'Učitavanje detalja rezervacije...',
        'please_wait_booking_info' => 'Molimo pričekajte dok dohvaćamo informacije o rezervaciji.',
        'please_wait_availability' => 'Molimo pričekajte dok provjeravamo dostupnost vozila za odabrane datume.',
        'error' => 'Greška',
        'error_loading_booking' => 'Učitavanje detalja rezervacije nije uspjelo. Molimo pokušajte ponovno.',
        'error_checking_availability' => 'Greška pri provjeri dostupnosti vozila',
        'customer' => 'Kupac',
        'status' => 'Status',
        'amount' => 'Iznos',
        'make' => 'Proizvođač',
        'vendor' => 'Dobavljač',
        'per_day' => '/dan',
        'edit_car' => 'Uredi vozilo',
        'no_cars_found' => 'Nisu pronađena vozila',
        'no_cars_available_period' => 'Nema dostupnih vozila za odabrano razdoblje.',
        'close' => 'Zatvori',
        'edit_booking' => 'Uredi rezervaciju',
        'pending' => 'Na čekanju',
        'processing' => 'U obradi',
        'completed' => 'Završeno',
        'cancelled' => 'Otkazano',
    ],
    'theme_options' => [
        'name' => 'Najam vozila',
        'description' => 'Opcije teme za najam vozila',
        'car_location_filter_by' => 'Filter lokacije vozila po',
        'state' => 'Država',
        'city' => 'Grad',
        'yes' => 'Da',
        'no' => 'Ne',
        'is_display_country' => 'Prikazati zemlju na filteru lokacije?',
        'logo_vendor_dashboard' => 'Logo na nadzornoj ploči dobavljača (Zadano je glavni logo)',
        'number_of_cars_per_page' => 'Broj vozila po stranici',
        'number_of_cars_per_page_placeholder' => 'Unesite broj vozila za prikaz po stranici',
    ],
    'message' => [
        'name' => 'Poruke',
        'forms' => [
            'customer_name' => 'Ime kupca',
            'message' => 'Poruka',
            'phone' => 'Telefon',
            'email' => 'E-pošta',
            'created_at' => 'Kreirano u',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Prodaja vozila',
        'create' => 'Nova prodaja vozila',
        'edit' => 'Uredi prodaju vozila :name',
        'statuses' => [
            'pending' => 'Na čekanju',
            'processing' => 'U obradi',
            'completed' => 'Završeno',
            'cancelled' => 'Otkazano',
        ],
        'forms' => [
            'transaction_id' => 'ID transakcije',
            'transaction_id_placeholder' => 'Unesite ID transakcije',
            'car_id' => 'Vozilo',
            'car' => 'Vozilo',
            'customer_id' => 'Kupac',
            'customer_name' => 'Ime kupca',
            'customer_name_placeholder' => 'Unesite ime kupca',
            'customer_email' => 'E-pošta kupca',
            'customer_email_placeholder' => 'Unesite e-poštu kupca',
            'customer_phone' => 'Telefon kupca',
            'customer_phone_placeholder' => 'Unesite telefon kupca',
            'sale_price' => 'Prodajna cijena',
            'sale_price_placeholder' => 'Unesite prodajnu cijenu',
            'tax_amount' => 'Iznos poreza',
            'tax_amount_placeholder' => 'Unesite iznos poreza',
            'total_amount' => 'Ukupan iznos',
            'total_amount_placeholder' => 'Unesite ukupan iznos',
            'payment_details' => 'Detalji plaćanja',
            'payment_details_placeholder' => 'Unesite detalje plaćanja',
            'notes' => 'Napomene',
            'notes_placeholder' => 'Unesite napomene',
            'sale_date' => 'Datum prodaje',
            'delivery_date' => 'Datum dostave',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankovni prijenos',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Potvrda rezervacije najma vozila',
        'booking_confirm_greeting' => 'Poštovani :customer_name,',
        'booking_confirm_message' => 'Drago nam je obavijestiti vas da je vaša rezervacija najma vozila uspješno potvrđena!',
        'customer_information' => 'Informacije o kupcu',
        'booking_information' => 'Informacije o rezervaciji',
        'field_name' => 'Ime:',
        'field_phone' => 'Telefon:',
        'field_email' => 'E-pošta:',
        'field_car_model' => 'Model vozila:',
        'field_start_date' => 'Datum početka:',
        'field_end_date' => 'Datum završetka:',
        'field_pickup_address' => 'Adresa preuzimanja:',
        'field_return_address' => 'Adresa povrata:',
        'field_note' => 'Napomena:',
        'field_order_number' => 'Broj narudžbe',
        'field_payment_method' => 'Način plaćanja',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Obavijest o novoj rezervaciji',
        'booking_notice_admin_greeting' => 'Pozdrav, postoji nova rezervacija od :site_title:',
        'booking_notice_admin_message' => 'Nova rezervacija najma vozila je podnesena i zahtijeva vašu pažnju.',
        'booking_view_detail' => 'Pregledaj detalje rezervacije:',
        'view_booking_details' => 'Pregledaj detalje rezervacije',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Nova rezervacija za vaše vozilo',
        'booking_notice_vendor_greeting' => 'Poštovani :vendor_name,',
        'booking_notice_vendor_message' => 'Odlične vijesti! Primili ste novu rezervaciju za najam vašeg vozila.',

        // Booking status changed email
        'booking_status_updated' => 'Status rezervacije ažuriran',
        'hello_thanks_for_booking' => 'Pozdrav, Hvala što ste rezervirali sobe od :site_title:',
        'booking_status_change_message' => 'Nadamo se da vas ova poruka zatječe dobro. Željeli smo vas obavijestiti da je status vaše rezervacije ažuriran.',
        'name' => 'Ime',
        'phone' => 'Telefon',
        'email' => 'E-pošta',
        'car_model' => 'Model vozila',
        'start_date' => 'Datum početka',
        'end_date' => 'Datum završetka',
        'pickup_address' => 'Adresa preuzimanja',
        'return_address' => 'Adresa povrata',
        'note' => 'Napomena',
        'order_number' => 'Broj narudžbe',
        'payment_method' => 'Način plaćanja',

        // Car approved email
        'hello' => 'Pozdrav',
        'car_approved_title' => 'Odlične vijesti! Vaše vozilo je odobreno',
        'car_approved_message' => 'Drago nam je obavijestiti vas da je vaš oglas vozila ":car_name" odobren i sada je dostupan na :site_title. Možete početi primati rezervacije i upravljati svojim oglasom odmah.',
        'view_edit_car_link' => 'Za pregled ili uređivanje vašeg oglasa vozila, molimo kliknite na ovu poveznicu',
        'view_car' => 'Pregledaj oglas vozila',
        'regards' => 'S poštovanjem',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Čestitamo! Sada ste dobavljač',
        'vendor_upgrade_congratulations' => 'Oduševljeni smo obavijestiti vas da je vaš račun uspješno nadograđen na status dobavljača!',
        'vendor_upgrade_message' => 'Sada možete navoditi i upravljati vlastitim vozilima na :site_title. Ovo vam otvara nove prilike za rast vašeg poslovanja najma s nama.',
        'vendor_benefits_title' => 'Vaše nove pogodnosti dobavljača',
        'vendor_benefit_1' => 'Neograničeno navodite vozila za najam',
        'vendor_benefit_2' => 'Upravljajte vlastitim rezervacijama i kupcima',
        'vendor_benefit_3' => 'Pratite prihode i metrike učinka',
        'vendor_benefit_4' => 'Pristup ekskluzivnim značajkama i alatima za dobavljače',
        'next_steps' => 'Sljedeći koraci',
        'vendor_next_steps_message' => 'Prijavite se na svoju nadzornu ploču dobavljača kako biste počeli dodavati svoja vozila i upravljati svojim poslom najma.',
        'go_to_dashboard' => 'Idite na nadzornu ploču dobavljača',
        'vendor_support_message' => 'Ako imate pitanja ili trebate pomoć, naš tim za podršku je ovdje da vam pomogne započeti.',
        'approved' => 'Odobreno',

        // Car rejected email
        'car_rejected_title' => 'Potrebno ažuriranje za vaš oglas vozila',
        'car_rejected_message' => 'Hvala što ste poslali svoj oglas vozila ":car_name" na :site_title. Nakon pregleda vaše prijave, trebamo da napravite neke prilagodbe prije nego što ga možemo odobriti.',
        'rejection_reason' => 'Evo što treba ažurirati',
        'rejection_details' => 'Potrebna ažuriranja',
        'contact_support' => 'Ako imate pitanja ili trebate pomoć s ovim ažuriranjima, nemojte se ustručavati kontaktirati naš tim za podršku na :site_email. Ovdje smo da vam pomognemo brzo odobriti vaš oglas.',

        // Confirm email
        'verify_email' => 'Potvrdite e-poštu',
        'welcome_message' => 'Drago nam je što ste ovdje, :customer_name!',
        'verify_email_instruction' => 'Molimo potvrdite svoju adresu e-pošte kako biste pristupili ovoj web stranici. Kliknite na gumb ispod da potvrdite svoju e-poštu..',
        'confirm_email_button' => 'Potvrdite svoju adresu e-pošte',
        'verify_link_trouble' => 'Ako imate problema s klikom na gumb \'Potvrdite svoju adresu e-pošte\', kopirajte i zalijepite URL ispod u svoj web preglednik: :verify_link i zalijepite ga u svoj preglednik.',

        // Message email
        'new_message' => 'Nova poruka',
        'dear_admin' => 'Poštovani administratore',
        'new_message_from' => 'Postoji nova poruka od :site_title:',
        'subject' => 'Predmet',
        'address' => 'Adresa',
        'content' => 'Sadržaj',

        // New pending car email
        'hi_admin' => 'Pozdrav administratore,',
        'new_car_pending_title' => 'Novi oglas vozila čeka pregled',
        'new_car_pending_approval' => 'Novi oglas vozila ":post_name" poslao je :post_author i spreman je za vaš pregled.',
        'pending_approval' => 'Čeka pregled',
        'review_car_admin' => 'Molimo pregledajte ovaj oglas u administrativnoj ploči i odobrite ili zatražite ažuriranja prema potrebi.',

        // Common fields
        'car_information' => 'Informacije o vozilu',
        'field_car_name' => 'Naziv vozila:',
        'field_author' => 'Autor:',
        'field_status' => 'Status:',
        'actions' => 'Radnje',

        // Password reminder email
        'reset_password_instruction' => 'Upute za poništavanje lozinke',
        'password_reset_request' => 'Primili ste ovu e-poštu jer smo primili zahtjev za poništavanje lozinke za vaš račun.',
        'reset_password_button' => 'Poništi lozinku',
        'reset_link_trouble' => 'Ako imate problema s klikom na gumb \'Poništi lozinku\', kopirajte i zalijepite URL ispod u svoj web preglednik: :reset_link i zalijepite ga u svoj preglednik. Ako niste zatražili poništavanje lozinke, molimo zanemarite ovu poruku ili nas kontaktirajte ako imate pitanja.',
    ],
];
