<?php

return [
    'name' => 'Thuê Xe',
    'icon' => 'Biểu tượng',
    'customer' => [
        'name' => 'Khách hàng',
        'create' => 'Tạo Khách hàng',
        'forms' => [
            'name' => 'Tên',
            'email' => 'Email',
            'phone' => 'Điện thoại',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Ảnh đại diện',
            'dob' => 'Ngày sinh',
            'company' => 'Công ty',
            'position' => 'Chức vụ',
            'password' => 'Mật khẩu',
            'password_confirmation' => 'Xác nhận mật khẩu',
            'change_password' => 'Thay đổi mật khẩu?',
            'phone_placeholder' => 'Điện thoại',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
        'view' => 'Xem',
        'information' => 'Thông tin Khách hàng',
        'email' => 'Email',
        'phone' => 'Điện thoại',
        'status' => 'Trạng thái',
        'vendor_status' => 'Trạng thái Nhà cung cấp',
        'is_vendor' => 'Nhà cung cấp',
        'not_vendor' => 'Khách hàng',
        'recent_activity' => 'Hoạt động gần đây',
        'recent_activity_description' => 'Hoạt động của khách hàng sẽ hiển thị ở đây.',
        'verification_section' => 'Xác minh Khách hàng',
        'verified' => 'Đã xác minh',
        'not_verified' => 'Chưa xác minh',
        'verified_by' => 'Được xác minh bởi',
        'verified_at' => 'Xác minh lúc',
        'verify_customer' => 'Xác minh Khách hàng',
        'unverify_customer' => 'Hủy xác minh Khách hàng',
        'verify_customer_confirmation' => 'Xác nhận Xác minh Khách hàng',
        'verify_customer_confirmation_desc' => 'Bạn có chắc chắn muốn xác minh :name? Điều này sẽ hiển thị huy hiệu xác minh trên hồ sơ của họ.',
        'unverify_customer_confirmation' => 'Xác nhận Hủy xác minh Khách hàng',
        'unverify_customer_confirmation_desc' => 'Bạn có chắc chắn muốn xóa xác minh khỏi :name? Huy hiệu xác minh sẽ bị xóa.',
        'verify_success' => 'Khách hàng :name đã được xác minh thành công.',
        'unverify_success' => 'Xác minh của khách hàng :name đã được xóa thành công.',
        'already_verified' => 'Khách hàng này đã được xác minh.',
        'already_unverified' => 'Khách hàng này chưa được xác minh.',
        'upgrade_to_vendor_title' => 'Nâng cấp lên Nhà cung cấp',
        'upgrade_to_vendor_description' => 'Nâng cấp khách hàng này lên trạng thái nhà cung cấp để cho phép họ liệt kê và quản lý cho thuê xe của riêng mình.',
        'upgrade_to_vendor_button' => 'Nâng cấp lên Nhà cung cấp',
        'upgrade_to_vendor_confirmation' => 'Xác nhận Nâng cấp lên Nhà cung cấp',
        'upgrade_to_vendor_confirmation_desc' => 'Bạn có chắc chắn muốn nâng cấp :name lên trạng thái nhà cung cấp? Điều này sẽ cho phép họ liệt kê và quản lý xe của riêng mình trên nền tảng.',
        'upgrade_to_vendor_success' => ':name đã được nâng cấp thành công lên trạng thái nhà cung cấp.',
        'already_vendor' => 'Khách hàng này đã là nhà cung cấp.',
        'email_verified' => 'Email Đã Xác Minh',
        'email_not_verified' => 'Email Chưa Xác Minh',
        'verify_email_warning_message' => 'Địa chỉ email của khách hàng này chưa được xác minh. Bạn có thể xác minh thủ công để xác nhận email của họ là hợp lệ.',
        'verify_email_title' => 'Xác Minh Địa Chỉ Email',
        'verify_email_description' => 'Địa chỉ email của khách hàng này chưa được xác minh. Bạn có thể xác minh thủ công để xác nhận email của họ là hợp lệ.',
        'verify_email_button' => 'Xác Minh Email',
        'verify_email_confirmation' => 'Xác Nhận Xác Minh Email',
        'verify_email_confirmation_desc' => 'Bạn có chắc chắn muốn xác minh địa chỉ email :email cho :name? Điều này sẽ đánh dấu email của họ là đã xác nhận.',
        'verify_email_success' => 'Email :email đã được xác minh thành công cho :name.',
        'email_already_verified' => 'Địa chỉ email này đã được xác minh.',
        'resend_confirmation_button' => 'Gửi Lại Email Xác Nhận',
        'resend_confirmation_title' => 'Gửi Lại Email Xác Nhận',
        'resend_confirmation_desc' => 'Bạn có chắc chắn muốn gửi lại email xác nhận đến :email cho :name? Điều này sẽ gửi một liên kết xác minh mới đến địa chỉ email của họ.',
        'resend_confirmation_success' => 'Email xác nhận đã được gửi đến :email.',
        'resend_confirmation_error' => 'Gửi email xác nhận thất bại. Vui lòng thử lại.',
        'customer_verified_successfully' => 'Khách hàng này đã được xác minh và có thể tin tưởng.',
        'customer_not_verified_yet' => 'Khách hàng này chưa được xác minh.',
        'verification_pending' => 'Đang chờ xác minh',
        'click_verify_to_approve' => 'Nhấp vào nút bên dưới để xác minh khách hàng này và hiển thị huy hiệu xác minh.',
        'verification_note' => 'Ghi chú Xác minh',
        'verification_note_placeholder' => 'Nhập bất kỳ ghi chú nào về hành động xác minh này...',
        'verification_note_helper' => 'Thêm ghi chú về quy trình xác minh (chỉ sử dụng nội bộ)',
    ],
    'vendor' => [
        'name' => 'Nhà cung cấp',
        'view' => 'Xem :name',
        'information' => 'Thông tin nhà cung cấp',
        'total_cars' => 'Tổng số xe',
        'total_bookings' => 'Tổng số đặt xe',
        'verified' => 'Đã xác minh',
        'not_verified' => 'Chưa xác minh',
        'verification_section' => 'Xác minh nhà cung cấp',
        'vendor_verified_successfully' => 'Nhà cung cấp này đã được xác minh và có thể tin tưởng.',
        'vendor_not_verified_yet' => 'Nhà cung cấp này chưa được xác minh.',
        'verification_pending' => 'Đang chờ xác minh',
        'click_verify_to_approve' => 'Nhấp vào nút bên dưới để xác minh nhà cung cấp này và hiển thị hô sơ xác minh.',
        'verify_vendor' => 'Xác minh nhà cung cấp',
        'unverify_vendor' => 'Hủy xác minh nhà cung cấp',
        'verify_vendor_confirmation' => 'Xác nhận xác minh nhà cung cấp',
        'verify_vendor_confirmation_desc' => 'Bạn có chắc chắn muốn xác minh :name? Điều này sẽ hiển thị hô sơ xác minh trên hồ sơ của họ.',
        'unverify_vendor_confirmation' => 'Xác nhận hủy xác minh nhà cung cấp',
        'unverify_vendor_confirmation_desc' => 'Bạn có chắc chắn muốn xóa xác minh khỏi :name? Hô sơ xác minh sẽ bị xóa.',
        'verified_successfully' => 'Nhà cung cấp đã được xác minh thành công.',
        'unverified_successfully' => 'Xác minh nhà cung cấp đã được xóa thành công.',
        'already_verified' => 'Nhà cung cấp này đã được xác minh.',
        'not_verified_yet' => 'Nhà cung cấp này chưa được xác minh.',
        'recent_activity' => 'Hoạt động gần đây',
        'recent_cars' => 'Xe gần đây',
        'recent_bookings' => 'Đặt xe gần đây',
        'no_cars_yet' => 'Chưa có xe nào được thêm.',
        'no_bookings_yet' => 'Chưa nhận được đặt xe nào.',
    ],
    'make' => [
        'name' => 'Hãng xe',
        'create' => 'Tạo Hãng xe',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo tối',
        ],
    ],
    'car' => [
        'name' => 'Xe',
        'create' => 'Tạo Xe',
        'forms' => [
            'car' => 'Xe',
            'logo' => 'Logo',
            'license_plate' => 'Biển số xe',
            'make' => 'Hãng xe',
            'model' => 'Mẫu xe',
            'name' => 'Tên',
            'images' => 'Hình ảnh',
            'year' => 'Năm sản xuất',
            'color' => 'Màu sắc',
            'mileage' => 'Số km đã đi',
            'kilometers' => 'Kilomét',
            'horsepower' => 'Mã lực',
            'vehicle_type' => 'Loại xe',
            'transmission' => 'Hộp số',
            'fuel_type' => 'Loại nhiên liệu',
            'rental_rate' => 'Giá thuê',
            'currency' => 'Tiền tệ',
            'status' => 'Trạng thái',
            'availability' => 'Tình trạng',
            'insurance_info' => 'Thông tin bảo hiểm',
            'number_of_seats' => 'Số ghế',
            'number_of_doors' => 'Số cửa',
            'vin' => 'Số khung (VIN)',
            'maintenance_history' => 'Lịch sử bảo dưỡng',
            'location' => 'Vị trí',
            'description' => 'Mô tả',
            'rental_type' => 'Loại thuê',
            'car_purpose' => 'Mục đích của xe',
            'for_rent' => 'Cho thuê',
            'for_sale' => 'Để bán',
            'car_type' => 'Dòng xe',
            'rental_information' => 'Thông tin thuê',
            'selling_information' => 'Thông tin bán xe',
            'sale_statuses' => [
                'available' => 'Có sẵn',
                'sold' => 'Đã bán',
                'reserved' => 'Đã giữ chỗ',
            ],
            'is_for_sale' => 'Cho phép bán',
            'sale_price' => 'Giá bán',
            'sale_price_placeholder' => 'Nhập giá bán',
            'condition' => 'Tình trạng',
            'select_condition' => 'Chọn tình trạng',
            'condition_options' => [
                'new' => 'Mới',
                'like_new' => 'Như mới',
                'excellent' => 'Xuất sắc',
                'good' => 'Tốt',
                'fair' => 'Khá',
                'poor' => 'Kém',
            ],
            'ownership_history' => 'Lịch sử sở hữu',
            'ownership_history_placeholder' => 'Nhập lịch sử sở hữu',
            'warranty_information' => 'Thông tin bảo hành',
            'warranty_information_placeholder' => 'Nhập thông tin bảo hành',
            'sale_status' => 'Trạng thái bán',
            'tags' => 'Thẻ',
            'add_new_attribute' => 'Thêm mới <a href=":url" target="_blank">ở đây</a>.',
            'categories' => 'Danh mục',
            'colors' => 'Màu sắc',
            'amenities' => 'Tiện nghi',
            'pick_address' => 'Địa chỉ nhận',
            'return_address' => 'Địa chỉ trả',
            'same_drop_off' => 'Cùng địa chỉ trả',
            'address' => 'Địa chỉ',
            'address_helper' => 'Nhập địa chỉ cụ thể nơi xe đang đỗ',
            'external_booking_url' => 'Liên kết đặt xe ngoài trang',
            'external_booking_url_helper' => 'Nhập URL bên ngoài nơi khách có thể đặt xe này. Để trống nếu chỉ đặt trên trang này.',
            'tax' => 'Thuế',
            'select_tax' => 'Chọn thuế',
            'none' => 'Không có',
            'is_used' => 'Đã qua sử dụng?',
            'moderation_status' => 'Trạng thái kiểm duyệt',
            'status_moderation' => [
                'approve' => 'Phê duyệt',
                'reject' => 'Từ chối',
                'approve_title' => 'Phê duyệt xe',
                'approve_message' => 'Bạn có chắc chắn muốn phê duyệt xe này? Hành động này không thể hoàn tác.',
                'reject_title' => 'Từ chối xe',
                'reject_message' => 'Bạn có chắc chắn muốn từ chối xe này? Hành động này không thể hoàn tác.',
                'reject_reason' => 'Nhập lý do từ chối',
                'approved' => 'Xe đã được phê duyệt thành công!',
                'rejected' => 'Xe đã được từ chối thành công!',
                'reason_rejected' => 'Lý do từ chối',
            ],
            'customer' => 'Khách hàng',
            'select_customer' => 'Chọn khách hàng...',
            'vendor_images' => 'Hình ảnh (Tối đa :max hình ảnh)',
            'images_upload_placeholder' => 'Kéo thả tập tin vào đây hoặc nhấp để tải lên.',
        ],
        'car_purposes' => [
            'sale' => 'Để bán',
            'rent' => 'Cho thuê',
        ],
        'placeholders' => [
            'name' => 'Nhập tên xe (ví dụ: Toyota Camry 2023, Honda CR-V, v.v.)',
            'description' => 'Nhập mô tả ngắn gọn về xe nêu bật các tính năng chính',
            'rental_rate' => 'Nhập giá thuê dựa trên loại thuê đã chọn',
            'location' => 'Nhập vị trí thực tế của xe',
            'address' => 'Nhập địa chỉ cụ thể (ví dụ: 123 Trần Hưng Đạo, Quận 1, TP.HCM)',
            'sale_price' => 'Nhập giá bán cho xe này',
            'ownership_history' => 'Nhập chi tiết về chủ sở hữu trước đây, số lượng chủ sở hữu, v.v.',
            'warranty_information' => 'Nhập chi tiết về bảo hành, ngày hết hạn, v.v.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Nhập biển số xe',
            'vin' => 'Nhập Số Khung Xe (VIN)',
            'year' => 'Nhập năm sản xuất (ví dụ: 2023)',
            'mileage' => 'Nhập số km hiện tại',
            'kilometers' => 'Nhập số kilômét hiện tại',
            'horsepower' => 'Nhập mã lực (HP) của xe (ví dụ: 150.5)',
            'number_of_seats' => 'Nhập số ghế trong xe',
            'number_of_doors' => 'Nhập số cửa của xe',
            'insurance_info' => 'Nhập thông tin bảo hiểm liên quan của xe',
            'tags' => 'Chọn hoặc tạo thẻ',
            'amenities' => 'Chọn tiện nghi',
            'colors' => 'Chọn hoặc tạo màu sắc',
        ],
        'enums' => [
            'vendor_status' => 'Trạng thái nhà cung cấp',
            'is_vendor' => 'Nhà cung cấp',
            'not_vendor' => 'Khách hàng',
            'statuses' => [
                'available' => 'Có sẵn',
                'rented' => 'Đã cho thuê',
                'maintenance' => 'Bảo dưỡng',
                'out_of_service' => 'Ngừng hoạt động',
            ],
            'rental_types' => [
                'per_hour' => 'Theo giờ',
                'per_day' => 'Theo ngày',
                'per_week' => 'Theo tuần',
                'per_month' => 'Theo tháng',
            ],
            'moderation_statuses' => [
                'pending' => 'Đang chờ',
                'approved' => 'Đã duyệt',
                'rejected' => 'Đã từ chối',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Lịch sử bảo dưỡng',
            'create' => 'Tạo lịch sử dịch vụ',
            'amount' => 'Số tiền',
            'forms' => [
                'price_placeholder' => 'Chi phí dịch vụ',
                'currency' => 'Tiền tệ',
                'none' => 'Không có',
                'name' => 'Tên',
                'amount' => 'Số tiền',
                'created_at' => 'Tạo lúc',
                'action' => 'Hành động',
                'date' => 'Ngày',
                'no_maintenance_history' => 'Chưa có lịch sử bảo dưỡng',
                'edit_maintenance_history' => 'Chỉnh sửa lịch sử bảo dưỡng',
                'add_maintenance_history' => 'Thêm lịch sử bảo dưỡng',
                'add' => 'Thêm',
                'edit' => 'Chỉnh sửa',
                'delete' => 'Xóa',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Thuộc tính Xe',
        'car_type' => [
            'name' => 'Loại xe',
            'create' => 'Tạo Loại xe',
            'forms' => [
                'name' => 'Tên',
            ],
        ],
        'transmission' => [
            'name' => 'Hộp số',
            'create' => 'Tạo Hộp số',
            'forms' => [
                'name' => 'Tên',
            ],
        ],
        'fuel_type' => [
            'name' => 'Nhiên liệu',
            'create' => 'Tạo Loại nhiên liệu',
            'forms' => [
                'name' => 'Tên',
            ],
        ],
        'tag' => [
            'name' => 'Thẻ',
            'create' => 'Tạo Thẻ',
        ],
        'category' => [
            'name' => 'Danh mục',
            'create' => 'Tạo Danh mục',
            'forms' => [
                'none' => 'Không có',
                'total_cars' => 'Tổng số xe: :total',
            ],
        ],
        'address' => [
            'name' => 'Địa điểm',
            'create' => 'Tạo Địa điểm Xe',
            'form' => [
                'name' => 'Địa chỉ',
                'full_address' => 'Địa chỉ đầy đủ',
                'detail_address' => 'Chi tiết địa chỉ',
            ],
        ],
        'color' => [
            'name' => 'Màu sắc',
            'create' => 'Tạo Màu sắc',
        ],
        'amenity' => [
            'name' => 'Tiện nghi',
            'create' => 'Tạo Tiện nghi',
        ],
    ],
    'tax' => [
        'name' => 'Thuế',
        'create' => 'Tạo Thuế',
        'forms' => [
            'name' => 'Tên',
            'name_placeholder' => 'Nhập tên',
            'percentage' => 'Phần trăm',
            'percentage_placeholder' => 'Phần trăm',
            'percent_placeholder' => 'Phần trăm',
            'priority' => 'Độ ưu tiên',
            'priority_placeholder' => 'Độ ưu tiên',
        ],
    ],
    'review' => [
        'name' => 'Đánh giá',
        'create' => 'Tạo Đánh giá',
        'edit' => 'Chỉnh sửa Đánh giá',
        'vendor' => [
            'title' => 'Đánh giá từ Khách hàng',
            'description' => 'Quản lý tất cả đánh giá từ khách hàng cho xe của bạn',
            'no_reviews' => 'Bạn chưa có đánh giá nào',
            'filter_by_car' => 'Lọc theo xe',
            'filter_by_rating' => 'Lọc theo đánh giá',
            'filter_by_date' => 'Lọc theo ngày',
            'all_cars' => 'Tất cả Xe',
            'all_ratings' => 'Tất cả Đánh giá',
            'manage_reviews' => 'Quản lý Đánh giá',
            'view_all' => 'Xem Tất cả Đánh giá',
            'delete_review_confirmation' => 'Bạn có chắc chắn muốn xóa đánh giá này?',
            'delete_review_success' => 'Đã xóa đánh giá thành công',
            'cannot_delete' => 'Không thể xóa đánh giá này',
        ],
        'forms' => [
            'customer' => 'Khách hàng',
            'car' => 'Xe',
            'content' => 'Nội dung',
            'rating' => 'Đánh giá',
            'your_name' => 'Tên của bạn',
            'email_address' => 'Địa chỉ Email',
            'submit' => 'Gửi',
            'star' => 'Sao',
            'status' => 'Trạng thái',
            'created_at' => 'Ngày tạo',
            'select_car' => 'Chọn Xe',
            'select_rating' => 'Chọn Đánh giá',
            'comment' => 'Bình luận',
            'reply' => 'Trả lời',
            'reply_to_review' => 'Trả lời Đánh giá',
            'save_reply' => 'Lưu Trả lời',
            'cancel_reply' => 'Hủy',
        ],
        'statuses' => [
            'published' => 'Đã xuất bản',
            'pending' => 'Đang chờ',
            'rejected' => 'Đã từ chối',
        ],
        'ratings' => [
            1 => '1 Sao - Kém',
            '2 Sao - Trung bình',
            '3 Sao - Tốt',
            '4 Sao - Rất tốt',
            '5 Sao - Xuất sắc',
        ],
    ],
    'coupon' => [
        'name' => 'Mã giảm giá',
        'create' => 'Tạo Mã giảm giá',
        'types' => [
            'percentage' => 'Phần trăm %',
            'money' => 'Tiền',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'Dịch vụ',
        'create' => 'Tạo Dịch vụ',
        'forms' => [
            'name' => 'Tên',
            'content' => 'Nội dung',
            'price' => 'Giá',
            'currency' => 'Tiền tệ',
            'image' => 'Hình ảnh',
            'logo' => 'Logo',
            'status' => 'Trạng thái',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Lịch khả dụng',
        'title' => 'Lịch khả dụng',
        'description' => 'Xem tình trạng xe và các đơn đặt trong chế độ xem lịch',
        'select_dates' => 'Chọn ngày để kiểm tra khả dụng',
        'car_filter' => 'Lọc theo xe',
        'all_cars' => 'Tất cả xe',
        'clear_filter' => 'Xóa bộ lọc',
        'availability_check' => 'Kiểm tra khả dụng của xe',
        'selected_period' => 'Khoảng thời gian đã chọn',
        'checking_availability' => 'Đang kiểm tra khả dụng...',
        'available' => 'Có sẵn',
        'not_available' => 'Không khả dụng',
        'booking_details' => 'Chi tiết đặt xe',
        'how_to_use' => 'Cách sử dụng lịch khả dụng',
        'viewing_bookings' => 'Xem các đơn đặt',
        'checking_availability_help' => 'Kiểm tra khả dụng',
        'color_legend' => 'Chú thích màu',
        'pending_bookings' => 'Đơn đang chờ',
        'processing_bookings' => 'Đơn đang xử lý',
        'completed_bookings' => 'Đơn đã hoàn thành',
        'cancelled_bookings' => 'Đơn đã hủy',
        'unknown_make' => 'Không rõ hãng xe',
        'loading' => 'Đang tải...',
        'loading_calendar_data' => 'Đang tải dữ liệu lịch...',
        'loading_booking_details' => 'Đang tải chi tiết đặt xe...',
        'please_wait_booking_info' => 'Vui lòng đợi trong khi chúng tôi lấy thông tin đặt xe.',
        'please_wait_availability' => 'Vui lòng đợi trong khi chúng tôi kiểm tra khả dụng cho khoảng thời gian bạn chọn.',
        'error' => 'Lỗi',
        'error_loading_booking' => 'Không thể tải chi tiết đặt xe. Vui lòng thử lại.',
        'error_checking_availability' => 'Lỗi khi kiểm tra khả dụng của xe',
        'customer' => 'Khách hàng',
        'status' => 'Trạng thái',
        'amount' => 'Số tiền',
        'make' => 'Hãng xe',
        'vendor' => 'Nhà cung cấp',
        'per_day' => '/ngày',
        'edit_car' => 'Chỉnh sửa xe',
        'no_cars_found' => 'Không tìm thấy xe nào',
        'no_cars_available_period' => 'Không có xe nào khả dụng trong khoảng thời gian đã chọn.',
        'close' => 'Đóng',
        'edit_booking' => 'Chỉnh sửa đặt xe',
        'pending' => 'Đang chờ',
        'processing' => 'Đang xử lý',
        'completed' => 'Hoàn thành',
        'cancelled' => 'Đã hủy',
    ],
    'theme_options' => [
        'name' => 'Thuê Xe',
        'description' => 'Tùy chọn giao diện cho thuê xe',
        'car_location_filter_by' => 'Lọc vị trí xe theo',
        'state' => 'Tỉnh/Thành',
        'city' => 'Thành phố',
        'yes' => 'Có',
        'no' => 'Không',
        'is_display_country' => 'Hiển thị quốc gia trong bộ lọc vị trí?',
        'logo_vendor_dashboard' => 'Logo trong bảng điều khiển nhà cung cấp (Mặc định là logo chính)',
        'number_of_cars_per_page' => 'Số xe trên mỗi trang',
        'number_of_cars_per_page_placeholder' => 'Nhập số xe muốn hiển thị trên một trang',
    ],
    'message' => [
        'name' => 'Tin nhắn',
        'forms' => [
            'customer_name' => 'Tên khách hàng',
            'message' => 'Tin nhắn',
            'phone' => 'Điện thoại',
            'email' => 'Email',
            'created_at' => 'Ngày tạo',
            'status' => 'Trạng thái',
        ],
    ],
    'car_sale' => [
        'name' => 'Bán Xe',
        'create' => 'Bán Xe Mới',
        'edit' => 'Chỉnh sửa Bán Xe :name',
        'statuses' => [
            'pending' => 'Đang chờ',
            'processing' => 'Đang xử lý',
            'completed' => 'Hoàn thành',
            'cancelled' => 'Đã hủy',
        ],
        'forms' => [
            'transaction_id' => 'Mã giao dịch',
            'transaction_id_placeholder' => 'Nhập mã giao dịch',
            'car_id' => 'Xe',
            'car' => 'Xe',
            'customer_id' => 'Khách hàng',
            'customer_name' => 'Tên khách hàng',
            'customer_name_placeholder' => 'Nhập tên khách hàng',
            'customer_email' => 'Email khách hàng',
            'customer_email_placeholder' => 'Nhập email khách hàng',
            'customer_phone' => 'Điện thoại khách hàng',
            'customer_phone_placeholder' => 'Nhập số điện thoại khách hàng',
            'sale_price' => 'Giá bán',
            'sale_price_placeholder' => 'Nhập giá bán',
            'tax_amount' => 'Tiền thuế',
            'tax_amount_placeholder' => 'Nhập tiền thuế',
            'total_amount' => 'Tổng số tiền',
            'total_amount_placeholder' => 'Nhập tổng số tiền',
            'payment_details' => 'Chi tiết thanh toán',
            'payment_details_placeholder' => 'Nhập chi tiết thanh toán',
            'notes' => 'Ghi chú',
            'notes_placeholder' => 'Nhập ghi chú',
            'sale_date' => 'Ngày bán',
            'delivery_date' => 'Ngày bàn giao',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Chuyển khoản ngân hàng',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Xác nhận Đặt Thuê Xe',
        'booking_confirm_greeting' => 'Kính gửi :customer_name,',
        'booking_confirm_message' => 'Chúng tôi rất vui thông báo rằng việc đặt xe của bạn đã được xác nhận thành công!',
        'customer_information' => 'Thông tin khách hàng',
        'booking_information' => 'Thông tin đặt xe',
        'field_name' => 'Tên:',
        'field_phone' => 'Điện thoại:',
        'field_email' => 'Email:',
        'field_car_model' => 'Mẫu xe:',
        'field_start_date' => 'Ngày bắt đầu:',
        'field_end_date' => 'Ngày kết thúc:',
        'field_pickup_address' => 'Địa chỉ nhận xe:',
        'field_return_address' => 'Địa chỉ trả xe:',
        'field_note' => 'Ghi chú:',
        'field_order_number' => 'Mã đơn hàng',
        'field_payment_method' => 'Phương thức thanh toán',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Thông Báo Đặt Xe Mới',
        'booking_notice_admin_greeting' => 'Xin chào, có một đặt xe mới từ :site_title:',
        'booking_notice_admin_message' => 'Một đặt xe thuê ô tô mới đã được gửi và cần sự chú ý của bạn.',
        'booking_view_detail' => 'Xem chi tiết đặt xe:',
        'view_booking_details' => 'Xem Chi Tiết Đặt Xe',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Đặt Xe Mới Cho Xe Của Bạn',
        'booking_notice_vendor_greeting' => 'Kính gửi :vendor_name,',
        'booking_notice_vendor_message' => 'Tin tuyệt vời! Bạn đã nhận được một đặt xe mới cho việc thuê xe của mình.',

        // Booking status changed email
        'booking_status_updated' => 'Trạng thái đặt xe đã được cập nhật',
        'hello_thanks_for_booking' => 'Xin chào, cảm ơn bạn đã đặt xe tại :site_title:',
        'booking_status_change_message' => 'Chúng tôi muốn thông báo rằng trạng thái đặt xe của bạn đã được cập nhật.',
        'name' => 'Tên',
        'phone' => 'Điện thoại',
        'email' => 'Email',
        'car_model' => 'Mẫu xe',
        'start_date' => 'Ngày bắt đầu',
        'end_date' => 'Ngày kết thúc',
        'pickup_address' => 'Địa chỉ nhận xe',
        'return_address' => 'Địa chỉ trả xe',
        'note' => 'Ghi chú',
        'order_number' => 'Mã đơn hàng',
        'payment_method' => 'Phương thức thanh toán',

        // Car approved email
        'hello' => 'Xin chào',
        'car_approved_title' => 'Tin Tuyệt Vời! Xe Của Bạn Đã Được Phê Duyệt',
        'car_approved_message' => 'Chúng tôi vui mừng thông báo rằng tin đăng xe ":car_name" của bạn đã được phê duyệt và hiện đã có mặt trên :site_title. Bạn có thể bắt đầu nhận đặt xe và quản lý tin đăng ngay lập tức.',
        'view_edit_car_link' => 'Để xem hoặc chỉnh sửa tin đăng xe của bạn, vui lòng nhấp vào liên kết này',
        'view_car' => 'Xem Tin Đăng Xe',
        'regards' => 'Trân trọng',
        'approved' => 'Đã Phê Duyệt',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Chúc mừng! Bạn đã trở thành Nhà cung cấp',
        'vendor_upgrade_congratulations' => 'Chúng tôi rất vui thông báo rằng tài khoản của bạn đã được nâng cấp thành nhà cung cấp!',
        'vendor_upgrade_message' => 'Bạn có thể đăng và quản lý xe của riêng mình trên :site_title. Đây là cơ hội tuyệt vời để phát triển kinh doanh cho thuê xe của bạn.',
        'vendor_benefits_title' => 'Quyền lợi mới của nhà cung cấp',
        'vendor_benefit_1' => 'Đăng không giới hạn số lượng xe cho thuê',
        'vendor_benefit_2' => 'Tự quản lý các đặt xe và khách hàng',
        'vendor_benefit_3' => 'Theo dõi doanh thu và các chỉ số hiệu quả',
        'vendor_benefit_4' => 'Truy cập các tính năng và công cụ dành riêng cho nhà cung cấp',
        'next_steps' => 'Các bước tiếp theo',
        'vendor_next_steps_message' => 'Hãy đăng nhập vào bảng điều khiển nhà cung cấp để bắt đầu thêm xe và quản lý hoạt động của bạn.',
        'go_to_dashboard' => 'Tới Bảng điều khiển Nhà cung cấp',
        'vendor_support_message' => 'Nếu bạn có bất kỳ câu hỏi nào, đội ngũ hỗ trợ của chúng tôi luôn sẵn sàng giúp bạn bắt đầu.',

        // Car rejected email
        'car_rejected_title' => 'Cần cập nhật cho tin đăng xe của bạn',
        'car_rejected_message' => 'Cảm ơn bạn đã gửi tin đăng xe ":car_name" đến :site_title. Sau khi xem xét, chúng tôi cần bạn cập nhật một số thông tin trước khi phê duyệt.',
        'rejection_reason' => 'Những gì cần cập nhật',
        'rejection_details' => 'Các mục cần chỉnh sửa',
        'contact_support' => 'Nếu bạn có câu hỏi hoặc cần hỗ trợ, hãy liên hệ đội ngũ hỗ trợ của chúng tôi tại :site_email. Chúng tôi sẽ giúp bạn được phê duyệt nhanh chóng.',

        // Confirm email
        'verify_email' => 'Xác minh Email',
        'welcome_message' => 'Chúng tôi rất vui khi có bạn, :customer_name!',
        'verify_email_instruction' => 'Vui lòng xác minh địa chỉ email để truy cập website. Nhấp vào nút bên dưới để xác minh.',
        'confirm_email_button' => 'Xác nhận địa chỉ email của bạn',
        'verify_link_trouble' => 'Nếu bạn gặp khó khăn khi nhấp vào nút "Xác nhận địa chỉ email", hãy sao chép và dán URL sau vào trình duyệt của bạn: :verify_link và mở trong trình duyệt.',

        // Message email
        'new_message' => 'Tin nhắn mới',
        'dear_admin' => 'Kính gửi Quản trị viên',
        'new_message_from' => 'Bạn có tin nhắn mới từ :site_title:',
        'subject' => 'Tiêu đề',
        'address' => 'Địa chỉ',
        'content' => 'Nội dung',

        // New pending car email
        'hi_admin' => 'Xin chào Quản trị viên,',
        'new_car_pending_title' => 'Tin đăng xe mới đang chờ duyệt',
        'new_car_pending_approval' => 'Một tin đăng xe ":post_name" đã được gửi bởi :post_author và sẵn sàng để bạn xem xét.',
        'pending_approval' => 'Đang chờ duyệt',
        'review_car_admin' => 'Vui lòng xem xét tin đăng này trong trang quản trị và phê duyệt hoặc yêu cầu cập nhật nếu cần.',

        // Common fields
        'car_information' => 'Thông tin xe',
        'field_car_name' => 'Tên xe:',
        'field_author' => 'Tác giả:',
        'field_status' => 'Trạng thái:',
        'actions' => 'Hành động',

        // Password reminder email
        'reset_password_instruction' => 'Hướng dẫn đặt lại mật khẩu',
        'password_reset_request' => 'Bạn nhận được email này vì chúng tôi đã nhận được yêu cầu đặt lại mật khẩu cho tài khoản của bạn.',
        'reset_password_button' => 'Đặt lại mật khẩu',
        'reset_link_trouble' => 'Nếu bạn gặp sự cố khi nhấp vào nút "Đặt Lại Mật Khẩu", hãy sao chép và dán URL bên dưới vào trình duyệt của bạn: :reset_link. Nếu bạn không yêu cầu đặt lại mật khẩu, hãy bỏ qua email này hoặc liên hệ với chúng tôi nếu cần.',
    ],
    'cars' => [
        'forms' => [
            'status_moderation' => [
                'reason_rejected' => 'Lý do từ chối',
            ],
        ],
    ],
    'settings' => [
        'withdrawal_fee_types' => [
            'label' => 'Loại phí rút tiền',
            'fixed' => 'Cố định',
            'percentage' => 'Phần trăm',
        ],
    ],
];
