<?php

return [
    'name' => '所在地',
    'all_states' => 'すべての州',
    'abbreviation' => '略語',
    'abbreviation_placeholder' => '例: カリフォルニア州',
    'import_type' => [
        'country' => '国',
        'state' => '州',
        'city' => '市',
    ],
    'enums' => [
        'import_type' => [
            'country' => '国',
            'state' => '州',
            'city' => '市',
        ],
    ],
    'export' => [
        'total' => '総拠点数',
        'total_countries' => '国の合計',
        'total_states' => '合計状態',
        'total_cities' => '都市の合計',
        'description' => '国、州、都市などの位置データをエクスポートします。',
        'import_type' => 'ロケーションタイプ',
        'all_types' => 'すべてのタイプ',
        'all_status' => 'すべてのステータス',
        'use_chunked_export' => 'チャンクエクスポートを使用',
        'use_chunked_export_helper' => '大規模なデータセットでメモリの問題を回避するために、データを小さなバッチで処理します。',
        'optimize_memory' => 'メモリ使用量を最適化',
        'optimize_memory_helper' => '必要な列のみを読み込み、エクスポート中に定期的にメモリを解放します。',
        'use_streaming' => 'ストリーミングモードを使用',
        'use_streaming_helper' => 'すべてをメモリにロードせずに、データを直接ファイルにストリーミングします。非常に大きなデータセットに推奨されます。',
        'streaming_enabled_title' => 'ストリーミングモード有効',
        'streaming_enabled_message' => '最適なメモリ使用のため、データは直接ファイルにストリーミングされます。',
        'chunk_size' => 'チャンクサイズ',
        'chunk_size_helper' => '各バッチで処理するレコード数。低い値はメモリを少なく使用しますが、時間がかかります。',
        'recommended_range' => '推奨範囲',
        'optimal_range' => '最適',
        'too_small_slow' => '小さすぎる（遅い）',
        'too_large_timeouts' => '大きすぎる（タイムアウトの可能性）',
        'range_large_export' => '150-300 レコード',
        'range_medium_export' => '200-500 レコード',
        'range_small_export' => '300-700 レコード',
        'large_dataset_title' => '大規模なデータセットが検出されました',
        'large_dataset_message' => 'より良いパフォーマンスのために最適化されたエクスポートモードが自動的に有効になりました。',
        'large_dataset_warning_title' => '大規模データセットのエクスポートの推奨事項',
        'large_dataset_specific_message' => ':count 件のロケーションをエクスポートしています。最適なパフォーマンスのために、チャンクエクスポート付きのCSV形式の使用をお勧めします。',
        'format_label' => 'フォーマット',
        'csv_recommended' => 'CSV（推奨）',
        'chunk_label' => 'チャンクサイズ',
        'chunk_recommended' => '150-300 レコード',
        'time_label' => '推定時間',
        'time_estimate' => '2-5 分',
        'pro_tip' => 'プロのヒント:',
        'pro_tip_message' => 'ロケーションタイプ（国/州/市）でフィルタリングして、特定のデータをエクスポートできます。',
        'medium_dataset_detected' => '中規模のデータセットが検出されました',
        'medium_dataset_message' => ':count 件のロケーションをエクスポート中。エクスポートは1-2分以内に完了する予定です。',
        'excel_disabled_warning' => 'Excelフォーマットは大規模なデータセット（:count+ レコード）には推奨されません。代わりにCSVを使用してください。',
    ],
    'import' => [
        'description' => '利用可能なデータから、または CSV/Excel ファイルをアップロードすることで、位置データを簡単にインポートします。',
        'rules' => [
            'name' => '場所の名前は必須であり、120 文字を超えてはなりません。',
            'slug' => '場所のスラッグを指定する場合は、120 文字を超えてはなりません。',
            'import_type' => 'インポートのタイプは必須であり、事前定義された値の 1 つである必要があります。',
            'order' => '位置の順序は、指定する場合、0 ～ 127 の正の整数である必要があります。',
            'abbreviation' => '場所の省略形を指定する場合は、10 文字を超えてはなりません。',
            'status' => '場所のステータスは必須であり、事前定義された値の 1 つである必要があります。',
            'country' => 'インポートタイプが州または都市の場合、国フィールドは必須です。',
            'state' => 'インポートタイプが都市の場合、州フィールドは必須です。',
            'nationality' => '場所の国籍を指定する場合は、120 文字を超えてはなりません。',
        ],
    ],
];
