<?php

return [
    'title' => '설정',
    'general_setting' => '일반 설정',
    'menu' => '모든 설정',
    'email_setting_title' => '이메일 설정',
    'email_setting_description' => '이메일 설정 구성',
    'general' => [
        'theme' => '테마',
        'title' => '일반 정보',
        'description' => '사이트 정보 보기 및 업데이트',
        'rich_editor' => '리치 에디터',
        'site_title' => '사이트 제목',
        'admin_email' => '관리자 이메일',
        'seo_block' => 'SEO 구성',
        'seo_title' => 'SEO 제목',
        'seo_description' => 'SEO 설명',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => '사이트 제목 (최대 120자)',
            'admin_email' => '관리자 이메일',
            'seo_title' => 'SEO 제목 (최대 120자)',
            'seo_description' => 'SEO 설명 (최대 120자)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => '이메일로 오류 보고 전송',
        'enable_send_error_reporting_via_email_helper' => '활성화하면 사이트에서 중요한 오류가 발생할 때 자세한 오류 보고서가 관리자 이메일 주소로 전송됩니다',
        'time_zone' => '시간대',
        'time_zone_helper' => '웹사이트의 시간대를 선택하세요. 이는 시스템 전체의 모든 날짜 및 시간 표시에 사용됩니다',
        'enable' => '활성화',
        'disable' => '비활성화',
        'disabled_helper' => '이 이메일 템플릿을 비활성화할 수 없습니다!',
        'enable_cache_site_map' => '사이트맵 캐싱 활성화',
        'cache_time_site_map' => '사이트맵 캐시 시간 제한 (분)',
        'admin_logo' => '관리자 로고',
        'admin_favicon' => '관리자 파비콘',
        'admin_title' => '관리자 제목',
        'admin_title_placeholder' => '브라우저 탭에 표시할 제목',
        'admin_appearance_title' => '관리자 모양',
        'admin_appearance_description' => '편집기, 언어 등 관리자 모양 설정...',
        'seo_block_description' => 'SEO 최적화를 위한 사이트 제목, 사이트 메타 설명, 사이트 키워드 설정',
        'webmaster_tools_description' => 'Google Search Console은 Google이 제공하는 무료 웹 도구로 웹사이트 소유자가 Google 검색 결과에서 사이트 성능을 모니터링할 수 있도록 도와줍니다.',
        'yes' => '예',
        'no' => '아니오',
        'show_on_front' => '홈페이지 표시',
        'select' => '— 선택 —',
        'show_site_name' => '페이지 제목 뒤에 사이트 이름 표시, "-"로 구분',
        'locale' => '사이트 언어',
        'locale_direction' => '프론트 사이트 언어 방향',
        'minutes' => '분',
        'redirect_404_to_homepage' => '모든 Not Found 요청을 홈페이지로 리디렉션',
    ],
    'admin_appearance' => [
        'title' => '관리자 모양',
        'description' => '로고, 파비콘, 레이아웃 보기 및 업데이트...',
        'layout' => '레이아웃',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => '가로',
        'vertical' => '세로',
        'show_menu_item_icon' => '메뉴 항목 아이콘 표시',
        'language' => '관리 패널 언어',
        'theme_mode' => '테마 모드',
        'dark' => '다크',
        'light' => '라이트',
        'container_width' => [
            'title' => '컨테이너 너비',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => '기본',
            'large' => '크게',
            'full' => '전체',
        ],
        'form' => [
            'admin_logo' => '관리자 로고',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => '로고 높이 (px)',
            'admin_logo_max_height_helper' => '로고의 높이를 픽셀 단위로 설정합니다. 기본값은 :default입니다.',
            'admin_favicon' => '관리자 파비콘',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => '관리자 파비콘 유형',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => '관리자 제목',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => '브라우저 탭에 표시할 제목',
            'admin_login_screen_backgrounds' => '로그인 화면 배경 (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => '관리자 언어',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => '관리자 언어 방향',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => '리치 에디터',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => '기본 글꼴',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => '기본 색상',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => '보조 색상',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => '제목 색상',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => '텍스트 색상',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => '링크 색상',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => '링크 호버 색상',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => '메뉴 항목 아이콘 표시',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => '사용자 정의 CSS',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => '사용자 정의 JS',
            'custom_header_js' => '헤더 JS',
            'custom_header_js_placeholder' => '페이지 헤더의 JavaScript, &#x3C;script&#x3E;&#x3C;/script&#x3E;로 감싸기',
            'custom_body_js' => '본문 JS',
            'custom_body_js_placeholder' => '페이지 본문의 JavaScript, &#x3C;script&#x3E;&#x3C;/script&#x3E;로 감싸기',
            'custom_footer_js' => '푸터 JS',
            'custom_footer_js_placeholder' => '페이지 푸터의 JavaScript, &#x3C;script&#x3E;&#x3C;/script&#x3E;로 감싸기',
        ],
    ],
    'datatable' => [
        'title' => 'Datatables',
        'description' => 'datatables 설정',
        'form' => [
            'show_column_visibility' => '기본적으로 열 표시 여부 표시',
            'show_column_visibility_helper' => '데이터 테이블에서 열 표시 전환 버튼을 활성화하여 사용자가 열을 표시/숨길 수 있도록 합니다',
            'show_export_button' => '기본적으로 내보내기 버튼 표시',
            'show_export_button_helper' => '테이블 데이터를 다운로드하기 위한 내보내기 옵션(CSV, Excel, PDF)을 데이터 테이블에 표시',
            'pagination_type' => '페이지네이션 유형',
            'pagination_type_helper' => '페이지네이션 컨트롤 표시 방법 선택: 기본은 페이지 번호 표시, 드롭다운은 컴팩트한 드롭다운 선택기 표시',
            'default' => '기본',
            'dropdown' => '드롭다운',
            'enable_responsive' => '테이블 반응형 활성화',
            'enable_responsive_helper' => '더 나은 모바일 경험을 위해 다양한 화면 크기에 맞게 테이블 열을 자동으로 조정',
        ],
    ],
    'email' => [
        'subject' => '제목',
        'content' => '내용',
        'title' => '이메일 템플릿 설정',
        'description' => 'HTML 및 시스템 변수를 사용하는 이메일 템플릿.',
        'reset_to_default' => '기본값으로 재설정',
        'back' => '설정으로 돌아가기',
        'reset_success' => '기본값으로 재설정 성공',
        'confirm_reset' => '이메일 템플릿을 재설정하시겠습니까?',
        'confirm_message' => '정말로 이 이메일 템플릿을 기본값으로 재설정하시겠습니까?',
        'continue' => '계속',
        'sender_name' => '발신자 이름',
        'sender_name_placeholder' => '이름',
        'sender_name_helper' => '시스템에서 보낸 이메일의 From 필드에 표시될 이름',
        'sender_email' => '발신자 이메일',
        'sender_email_placeholder' => '이메일 주소 (예: :default)',
        'sender_email_helper' => '시스템에서 보낸 모든 이메일의 발신자로 사용될 이메일 주소',
        'mailer' => 'Mailer',
        'port' => '포트',
        'port_placeholder' => '예: 587',
        'port_helper' => '메일 서버에서 사용하는 포트 (일반 포트: 25, 465, 587)',
        'host' => '호스트',
        'host_placeholder' => '예: smtp.gmail.com',
        'host_helper' => 'SMTP 호스트 주소',
        'username' => '사용자 이름',
        'username_placeholder' => '메일 서버 로그인 사용자 이름',
        'username_helper' => '메일 서버 로그인 사용자 이름',
        'password' => '비밀번호',
        'password_placeholder' => '메일 서버 로그인 비밀번호',
        'password_helper' => '메일 서버 로그인 비밀번호',
        'encryption' => '암호화',
        'encryption_placeholder' => '암호화 유형 선택',
        'encryption_helper' => '안전한 이메일 전송을 위한 암호화 방법 선택',
        'encryption_none' => '없음',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => '이메일 설정 팁',
        'setup_tip_gmail' => 'Gmail의 경우: smtp.gmail.com을 호스트로 사용하고, TLS의 경우 포트 587 또는 SSL의 경우 포트 465를 사용하세요. "Less secure app access"를 활성화하거나 App Password를 사용하세요.',
        'setup_tip_port' => '일반 포트: 25 (암호화 없음), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (대체).',
        'setup_tip_encryption' => '포트 587에는 TLS(권장), 포트 465에는 SSL, 포트 25에는 None(프로덕션에는 권장하지 않음)을 사용하세요.',
        'setup_tip_test' => '저장하기 전에 항상 "Send Test Email" 버튼을 사용하여 구성을 확인하세요.',
        'setup_tip_mailgun' => '더 나은 전송을 위해 SMTP 대신 Mailgun, SendGrid 또는 Amazon SES와 같은 이메일 서비스 사용을 고려하세요.',
        'queue_warning_title' => 'Queue 구성 필요',
        'queue_warning_description' => '이메일 대기열이 현재 ":default" 드라이버를 사용하도록 구성되어 있지만 대기열 워커가 실행 중이 아닐 수 있습니다. 이는 대기열 워커를 설정할 때까지 이메일이 전송되지 않음을 의미합니다.',
        'queue_warning_action' => '대기열 워커 없이 이메일을 즉시 보내려면 .env 파일에서 QUEUE_CONNECTION=sync를 설정하세요. 그렇지 않으면 "php artisan queue:work"로 대기열 워커가 실행 중인지 확인하세요. <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Laravel Queues에 대해 자세히 알아보기</a>.',
        'mail_gun_domain' => '도메인',
        'mail_gun_domain_placeholder' => '예: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Mailgun에 등록한 도메인 이름',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => '예: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Mailgun API 키',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => '예: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API 엔드포인트 (미국의 경우 api.mailgun.net, EU의 경우 api.eu.mailgun.net)',
        'log_channel' => '로그 채널',
        'log_channel_helper' => '이메일 로그에 사용할 로깅 채널 선택',
        'sendmail_path' => 'Sendmail 경로',
        'local_domain' => '로컬 도메인',
        'local_domain_placeholder' => '비워둘 수 있습니다. SMTP Relay 사용 시 도메인으로 설정해야 합니다. 예: your-domain.com',
        'local_domain_helper' => '원격 SMTP 서버와 통신할 때 서버를 식별하는 데 사용할 도메인',
        'ses_key' => 'Key',
        'ses_key_placeholder' => '예: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'AWS 액세스 키 ID',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => '예: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'AWS 비밀 액세스 키',
        'ses_region' => 'Region',
        'ses_region_placeholder' => '예: us-east-1',
        'ses_region_helper' => 'SES 서비스가 구성된 AWS 리전',
        'postmark_token' => 'Token',
        'postmark_token_placeholder' => '예: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Postmark 서버 토큰',
        'resend_key' => 'API Key',
        'resend_key_placeholder' => '예: re_123456789012345678901234567890',
        'resend_key_helper' => 'Resend API 키',
        'email_templates' => '이메일 템플릿',
        'email_templates_description' => 'HTML 및 시스템 변수를 사용하는 이메일 템플릿.',
        'email_template_settings' => '이메일 템플릿 설정',
        'email_template_settings_description' => '이메일 템플릿 설정 보기 및 업데이트',
        'email_rules' => '이메일 규칙',
        'email_rules_description' => '유효성 검사를 위한 이메일 규칙 구성',
        'base_template' => '기본 템플릿',
        'base_template_description' => '모든 이메일의 기본 템플릿',
        'template_header' => '이메일 템플릿 헤더',
        'template_header_description' => '이메일 헤더 템플릿',
        'template_footer' => '이메일 템플릿 푸터',
        'template_footer_description' => '이메일 푸터 템플릿',
        'default' => '기본',
        'template_off_status_helper' => '이 이메일 템플릿이 꺼져 있습니다.',
        'blacklist_email_domains' => '블랙리스트 이메일 도메인',
        'blacklist_email_domains_helper' => '블랙리스트에 추가할 이메일 도메인 목록을 입력하세요. 예: gmail.com, yahoo.com.',
        'blacklist_specified_emails' => '블랙리스트 이메일 주소',
        'blacklist_specified_emails_helper' => '블랙리스트에 추가할 특정 이메일 주소 목록을 입력하세요. 예: mail@example.com.',
        'exception_emails' => '예외 이메일',
        'exception_emails_helper' => '이 이메일들은 유효성 검사 규칙에서 제외됩니다.',
        'email_rules_strict' => '엄격한 이메일 유효성 검사',
        'email_rules_strict_helper' => '엄격한 규칙으로 RFC와 유사한 이메일 유효성 검사를 수행합니다.',
        'email_rules_dns' => 'DNS 확인 유효성 검사',
        'email_rules_dns_helper' => '서버가 이메일을 수락한다는 DNS 레코드가 있는지 확인합니다.',
        'email_rules_spoof' => '스푸핑 감지',
        'email_rules_spoof_helper' => '잠재적인 이메일 스푸핑 시도를 감지합니다.',
        'template_turn_off' => '이 이메일 템플릿을 끄려면 클릭',
        'template_turn_on' => '이 이메일 템플릿을 켜려면 클릭',
        'turn_on_success_message' => '이메일 템플릿 켜기 성공!',
        'turn_off_success_message' => '이메일 템플릿 끄기 성공!',
        'email_template_status' => '이메일 템플릿 상태',
        'email_template_status_description' => '이메일 템플릿 켜기/끄기',
        'email_template_logo' => '로고',
        'email_template_logo_helper_text' => '설정하지 않으면 Admin -> Settings -> Admin Appearance -> Logo의 관리자 로고에서 가져옵니다.',
        'email_template_copyright_text_helper_text' => '설정하지 않으면 Admin -> Appearance -> Theme Options -> General -> Copyright의 테마 옵션 저작권에서 가져옵니다.',
        'email_template_email_contact' => '연락처 이메일 주소',
        'email_template_email_contact_helper_text' => '설정하지 않으면 Admin -> Settings -> Email의 발신자 이메일에서 가져옵니다',
        'email_template_social_links' => '소셜 링크',
        'email_template_copyright_text' => '저작권',
        'image_upload_supported' => 'PNG, JPG, JPEG 및 GIF 형식만 지원합니다.',
        'email_template_custom_css' => '이메일 템플릿 사용자 정의 CSS',
        'social_links' => [
            'name' => '이름',
            'icon' => '아이콘',
            'icon_image' => '아이콘 이미지 (PNG, JPG, JPEG 및 GIF 형식만 지원합니다.)',
            'url' => 'URL',
            'image' => '이미지',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => '라이선스',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => '미디어',
        'driver' => '드라이버',
        'description' => '미디어 설정',
        'local_disk' => '로컬 디스크',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS Default Region',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (선택사항)',
        'use_path_style_endpoint' => '경로 스타일 엔드포인트 사용',
        'r2_access_key_id' => 'R2 Access Key ID',
        'r2_secret_key' => 'R2 Secret Key',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces Default Region',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'DO Spaces CDN이 활성화되어 있습니까?',
        'do_spaces_cdn_enabled_helper' => '활성화되면 더 빠른 글로벌 콘텐츠 제공을 위해 미디어 파일이 DigitalOcean Spaces CDN을 통해 제공됩니다. 아래에서 선택적으로 사용자 지정 CDN 도메인을 구성할 수 있습니다.',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN 사용자 정의 도메인',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi Default Region',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => '기존 이미지를 재사용하려면 Wasabi 루트를 "/"로 지정한 다음 public/storage의 모든 현재 파일을 Wasabi 루트 디렉터리에 업로드하세요.',
        'backblaze_access_key_id' => 'Backblaze Access Key ID',
        'backblaze_secret_key' => 'Backblaze Secret Key',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze Default Region',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Backblaze CDN이 활성화되어 있습니까?',
        'backblaze_cdn_enabled_helper' => '활성화되면 더 빠른 글로벌 콘텐츠 전송을 위해 미디어 파일이 CDN을 통해 제공됩니다. 아래에서 사용자 지정 CDN 도메인(예: Cloudflare CDN 또는 Backblaze CDN)을 구성해야 합니다.',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN 사용자 정의 도메인',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => '기본 플레이스홀더 이미지',
        'enable_chunk' => '청크 업로드 활성화',
        'chunk_size' => '청크 크기 (Bytes)',
        'chunk_size_placeholder' => '기본: 1048576 ~ 1MB',
        'max_file_size' => '청크 최대 파일 크기 (MB)',
        'max_file_size_placeholder' => '기본: 1048576 ~ 1GB',
        'enable_watermark' => '워터마크 활성화',
        'enable_watermark_helper' => '활성화하면 선택한 폴더에 새로 업로드된 이미지에 워터마크가 자동으로 추가됩니다. 기존 이미지에는 영향을 주지 않습니다.',
        'watermark_source' => '워터마크 이미지',
        'watermark_source_helper' => 'PNG, JPG 및 JPEG 형식만 지원합니다. 200x200px 미만이고 크기가 50KB보다 작은 이미지를 사용해야 합니다.',
        'watermark_size' => '워터마크 크기 (%)',
        'watermark_size_placeholder' => '기본: 10 (%)',
        'watermark_opacity' => '워터마크 불투명도 (%)',
        'watermark_opacity_placeholder' => '기본: 70 (%)',
        'watermark_position' => '워터마크 위치',
        'watermark_position_x' => '워터마크 위치 X',
        'watermark_position_y' => '워터마크 위치 Y',
        'watermark_position_top_left' => '왼쪽 상단',
        'watermark_position_top_right' => '오른쪽 상단',
        'watermark_position_bottom_left' => '왼쪽 하단',
        'watermark_position_bottom_right' => '오른쪽 하단',
        'watermark_position_center' => '가운데',
        'turn_off_automatic_url_translation_into_latin' => 'URL 자동 라틴어 번역 끄기',
        'turn_off_automatic_url_translation_into_latin_helper' => '활성화하면 파일 URL이 라틴 문자로 자동 음역되지 않고 라틴 문자가 아닌 문자의 원래 문자가 유지됩니다.',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Zone Name (스토리지 영역 이름)',
        'bunnycdn_key' => 'FTP & API Access Password (스토리지 영역 API Access Password)',
        'bunnycdn_region' => 'Region (스토리지 영역 지역)',
        'optional' => '선택사항',
        'sizes' => '미디어 썸네일 크기',
        'media_sizes_helper' => '너비 또는 높이로만 자르려면 너비 또는 높이를 0으로 설정하세요.',
        'width' => '너비',
        'height' => '높이',
        'default_size_value' => '기본: :size',
        'all' => '전체',
        'all_helper_text' => '모든 폴더의 확인을 해제하면 모든 폴더에 적용됩니다.',
        'media_folders_can_add_watermark' => '폴더의 이미지에 워터마크 추가:',
        'max_upload_filesize' => '최대 업로드 파일 크기 (MB)',
        'max_upload_filesize_placeholder' => '기본: :size, :size보다 작아야 합니다.',
        'max_upload_filesize_helper' => '서버에서 최대 :size 파일 업로드를 허용하며, 이 값을 변경하여 업로드 파일 크기를 제한할 수 있습니다.',
        'image_processing_library' => '이미지 처리 라이브러리',
        'use_original_name_for_file_path' => '파일 경로에 원본 이름 사용',
        'use_original_name_for_file_path_helper' => '활성화하면 업로드된 파일이 원래 이름을 유지합니다. 비활성화하면 파일 이름이 URL 친화적인 슬러그로 변환됩니다(예: "My Photo.jpg"는 "my-photo.jpg"가 됩니다).',
        'keep_original_file_size_and_quality' => '원본 파일 크기 및 품질 유지',
        'keep_original_file_size_and_quality_helper' => '활성화하면 업로드된 이미지의 크기가 조정되거나 최적화되지 않고 원래 품질과 파일 크기가 유지됩니다. 비활성화하면 설정에 따라 이미지가 압축되고 크기가 조정될 수 있습니다.',
        'update_thumbnail_sizes_warning' => '썸네일 크기를 조정한 후 ":button_text" 버튼을 클릭하여 새로 고쳐야 합니다.',
        'thumbnail_crop_position' => '썸네일 자르기 위치',
        'thumbnail_crop_position_left' => '왼쪽',
        'thumbnail_crop_position_center' => '가운데',
        'thumbnail_crop_position_right' => '오른쪽',
        'thumbnail_crop_position_top' => '위쪽',
        'thumbnail_crop_position_bottom' => '아래쪽',
        'thumbnail_crop_position_helper' => '이 설정은 썸네일을 생성할 때 이미지를 자르는 데 사용됩니다. 이미지가 채워질 때까지 이 위치에서 잘립니다.',
        'user_can_only_view_own_media' => '사용자는 자신의 미디어만 볼 수 있습니다',
        'user_can_only_view_own_media_helper' => '활성화하면 사용자는 자신의 미디어만 볼 수 있으며 슈퍼 관리자는 모든 미디어를 볼 수 있습니다.',
        'enable_thumbnail_sizes' => '썸네일 크기 활성화',
        'enable_thumbnail_sizes_helper' => '이 옵션을 활성화하면 이미지에 대한 썸네일이 생성됩니다. 비활성화하면 시스템이 이미지에 대한 썸네일을 생성하지 않고 항상 전체 크기 이미지를 사용합니다.',
        'convert_image_to_webp' => 'JPG, JPEG, PNG 이미지를 WebP로 변환',
        'convert_image_to_webp_helper' => 'WebP는 웹 이미지에 대한 우수한 무손실 및 손실 압축을 제공하는 최신 이미지 형식입니다. Chrome, Firefox, Edge 및 Opera에서 지원됩니다. 업로드 시 이미지가 WebP 형식으로 변환됩니다. JPG, JPEG, PNG 이미지에만 적용됩니다.',
        'reduce_large_image_size' => '업로드 시 큰 이미지 크기 줄이기',
        'reduce_large_image_size_helper' => '활성화하면 시스템이 업로드 시 큰 이미지의 크기를 줄입니다. JPG, JPEG, PNG, WebP 이미지에 적용됩니다. 이미지의 최대 너비와 높이는 아래 설정한 값으로 크기가 조정됩니다.',
        'image_max_width' => '이미지 최대 너비 (px)',
        'image_max_height' => '이미지 최대 높이 (px)',
        'image_max_width_placeholder' => '원본 너비를 유지하려면 비워 두세요',
        'image_max_height_placeholder' => '원본 높이를 유지하려면 비워 두세요',
        'image_max_width_helper' => '이미지의 최대 너비를 픽셀 단위로 설정합니다. 이 필드가 비어 있으면 원본 너비가 유지됩니다.',
        'image_max_height_helper' => '이미지의 최대 높이를 픽셀 단위로 설정합니다. 이 필드가 비어 있으면 원본 높이가 유지됩니다.',
        'customize_upload_path' => '업로드 경로 사용자 지정',
        'customize_upload_path_helper' => '미디어 파일의 업로드 경로를 사용자 지정합니다. 기본적으로 시스템은 파일을 ":path" 폴더에 업로드합니다.',
        'upload_path' => '업로드 경로',
        'upload_path_placeholder' => '예: uploads',
        'upload_path_helper' => '해당 폴더는 /public에 생성됩니다. 기본 폴더는 ":folder"입니다. 그런 다음 "/public/:folder"에 업로드됩니다.',
        'upload_path_warning' => '시스템은 기존 파일을 새 폴더로 이동하지 않습니다. 기존 파일을 새 폴더로 이동하려면 수동으로 수행해야 합니다.',
        'convert_file_name_to_uuid' => '파일 이름을 UUID로 변환',
        'convert_file_name_to_uuid_helper' => '활성화하면 시스템이 업로드 시 파일 이름을 UUID로 변환합니다. 중복 파일 이름을 방지하고 보안을 향상시키는 데 유용합니다.',
        's3_path' => '사용자 정의 S3 경로 (선택사항)',
        's3_path_placeholder' => 'S3 버킷의 선택적 사용자 정의 경로 (예: uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => '설정 저장',
    'template' => '템플릿',
    'description' => '설명',
    'enable' => '활성화',
    'send' => '보내기',
    'test_email_description' => '테스트 이메일을 보내려면 이메일 보내기 구성을 업데이트했는지 확인하세요!',
    'test_email_input_placeholder' => '테스트 이메일을 보낼 이메일 주소를 입력하세요.',
    'test_email_modal_title' => '테스트 이메일 보내기',
    'test_send_mail' => '테스트 이메일 보내기',
    'test_email_send_success' => '이메일이 성공적으로 전송되었습니다!',
    'locale_direction_ltr' => '왼쪽에서 오른쪽',
    'locale_direction_rtl' => '오른쪽에서 왼쪽',
    'emails_warning' => '최대 :count개의 이메일을 추가할 수 있습니다',
    'email_add_more' => '더 추가',
    'generate' => '생성',
    'generate_thumbnails' => '썸네일 생성',
    'generate_thumbnails_success' => '썸네일이 성공적으로 생성되었습니다. :count개의 파일이 생성되었습니다!',
    'generate_thumbnails_error' => ':count개의 파일에 대한 썸네일을 재생성할 수 없습니다!',
    'generate_thumbnails_description' => '모든 이미지에 대해 썸네일을 재생성하시겠습니까? 시간이 걸릴 수 있습니다. 프로세스가 완료될 때까지 이 페이지를 벗어나지 마세요.',
    'enable_chunk_description' => '청크 크기 업로드는 큰 파일 크기를 업로드하는 데 사용됩니다.',
    'watermark_description' => '경고: 워터마크는 새로 업로드된 이미지에만 추가되며 기존 이미지에는 추가되지 않습니다. 워터마크를 비활성화해도 기존 이미지에서 워터마크가 제거되지 않습니다.',
    'submit' => '제출',
    'back' => '뒤로',
    'enter_sample_value' => '테스트를 위한 샘플 값 입력',
    'preview' => '미리보기',
    'media_size_width' => ':size 크기 너비는 0보다 커야 합니다',
    'media_size_height' => ':size 크기 높이는 0보다 커야 합니다',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob을 사용하면 사이트에서 특정 명령이나 스크립트를 자동화할 수 있습니다.',
        'is_not_ready' => 'cronjob을 실행하려면 아래 지침을 따르세요.',
        'is_working' => '축하합니다! cronjob이 실행 중입니다.',
        'is_not_working' => 'cronjob이 실행되고 있지 않습니다. 서버의 cronjob을 확인하세요.',
        'last_checked' => '마지막 확인 시간 :time.',
        'copy_button' => '복사',
        'setup' => [
            'name' => 'Cronjob 설정',
            'connect_to_server' => 'SSH 또는 선호하는 방법을 통해 서버에 연결합니다.',
            'open_crontab' => '텍스트 편집기를 사용하여 crontab 파일을 엽니다 (예: `crontab -e`).',
            'add_cronjob' => '위 명령을 crontab 파일에 추가하고 저장합니다.',
            'done' => 'cronjob은 이제 매 분마다 실행되고 지정된 명령을 실행합니다.',
            'learn_more' => 'Laravel :documentation에서 cronjob에 대해 자세히 알아볼 수 있습니다',
            'documentation' => '문서',
            'copied' => '복사됨',
        ],
    ],
    'security' => [
        'title' => '보안 설정',
        'description' => '웹사이트의 보안 설정을 확인하고 구성합니다.',
        'menu_description' => '쿠키 보안 및 HTTP 헤더 관리',
        'status_secure' => '모든 보안 설정이 올바르게 구성되었습니다!',
        'status_insecure' => '일부 보안 설정에 주의가 필요합니다!',
        'current_settings' => '현재 보안 설정',
        'status' => '상태',
        'setting' => '설정',
        'current_value' => '현재 값',
        'recommended_value' => '권장',
        'session_http_only' => 'HttpOnly 쿠키 플래그',
        'session_http_only_description' => 'JavaScript가 세션 쿠키에 액세스하는 것을 방지합니다 (XSS 공격으로부터 보호)',
        'session_secure_cookie' => 'Secure 쿠키 플래그',
        'session_secure_cookie_description' => '쿠키가 HTTPS 연결을 통해서만 전송되도록 합니다',
        'session_same_site' => 'SameSite 쿠키 플래그',
        'session_same_site_description' => '쿠키가 전송되는 시기를 제한하여 CSRF 공격을 방지합니다',
        'http_security_headers' => 'HTTP 보안 헤더',
        'http_security_headers_description' => '일반적인 웹 취약점으로부터 보호하기 위한 보안 헤더 추가',
        'https_warning' => '사이트에서 HTTPS를 사용하지 않습니다',
        'https_warning_description' => '보안 쿠키와 같은 일부 보안 기능에는 HTTPS가 필요합니다. 웹사이트에 SSL을 활성화하는 것을 고려하세요.',
        'how_to_fix' => '보안 문제 해결 방법',
        'env_file_location' => '다음 위치에 있는 .env 파일을 편집하세요:',
        'add_to_env' => '추가할 설정',
        'required_settings' => '필수 보안 설정',
        'for_https_sites' => 'HTTPS 사이트만',
        'copy' => '복사',
        'copy_settings' => '모든 설정 복사',
        'copied' => '복사됨!',
        'steps' => '설정 적용 단계',
        'step_1' => '텍스트 편집기에서 .env 파일 열기',
        'step_2' => '위에 표시된 보안 설정 추가 또는 업데이트',
        'step_3' => '.env 파일 저장',
        'step_4' => 'Admin Panel → Platform Administration → Cache Management를 사용하여 캐시 지우기',
        'security_headers_info' => '보안 헤더 정보',
        'security_headers_list' => '활성화하면 다음 헤더가 모든 응답에 추가됩니다:',
        'header_nosniff' => '브라우저가 콘텐츠 유형을 추측하지 못하도록 방지',
        'header_frame' => '클릭재킹 공격으로부터 보호',
        'header_xss' => '브라우저 XSS 보호 활성화',
        'header_referrer' => '전송되는 참조자 정보의 양 제어',
        'learn_more' => '자세한 내용은 :documentation을 참조하세요',
        'documentation' => '보안 문서',
    ],
    'cache' => [
        'title' => '캐시',
        'description' => '최적화된 속도를 위한 캐싱 구성',
        'form' => [
            'cache_admin_menu' => '관리자 메뉴 캐시',
            'cache_admin_menu_helper' => '최적화된 속도를 위해 관리자 메뉴를 캐시합니다. 관리자 메뉴를 개발하거나 사용자 지정하는 경우 이 옵션을 비활성화해야 합니다.',
            'enable_cache_site_map' => '사이트맵 캐시',
            'enable_cache_site_map_helper' => '페이지가 많기 때문에 사이트맵 :url을 캐시해야 합니다. 페이지가 적으면 이 옵션을 비활성화할 수 있습니다.',
            'cache_time_site_map' => '사이트맵 캐시 시간 제한 (분)',
            'cache_front_menu' => '프론트 메뉴 캐시',
            'cache_front_menu_helper' => '최적화된 속도를 위해 프론트 메뉴를 캐시합니다',
            'cache_user_avatar' => '사용자 아바타 캐시',
            'cache_user_avatar_helper' => '아바타가 없는 사용자의 경우 시스템이 사용자 이름에서 아바타를 생성합니다. 아바타는 최적화된 속도를 위해 캐시되며 재생성되지 않습니다.',
            'shortcode_cache_enabled' => '숏코드(UI 블록) 캐시',
            'shortcode_cache_enabled_helper' => '성능 향상을 위해 숏코드 캐싱을 활성화합니다. 활성화하면 렌더링 시간을 줄이기 위해 숏코드가 캐시됩니다.',
            'shortcode_cache_warning' => '<strong>⚠️ 중요 알림:</strong><br>• 폼(연락처 폼, 뉴스레터 구독 등)이 포함된 숏코드는 기능을 유지하기 위해 자동으로 캐싱을 우회합니다.<br>• 동적 JavaScript 콘텐츠가 있는 숏코드는 수동으로 캐싱을 비활성화해야 합니다.<br>• 특정 숏코드에 대한 캐싱을 비활성화하려면 숏코드 구성에 <code>Enable caching: No</code>를 추가하세요.<br>• CSRF 토큰, reCAPTCHA 또는 기타 동적 요소가 있는 폼은 자동으로 감지되어 캐싱에서 제외됩니다.',
            'shortcode_cache_ttl' => '캐시 기간 (초)',
            'shortcode_cache_ttl_helper' => '모든 숏코드를 캐시하는 기간입니다. 기본값은 1800초(30분)입니다.',
            'widget_cache_enabled' => '위젯 캐시',
            'widget_cache_enabled_helper' => '성능 향상을 위해 위젯 캐싱을 활성화합니다. 활성화하면 렌더링 시간을 줄이기 위해 위젯이 캐시됩니다.',
            'widget_cache_warning' => '<strong>⚠️ 중요 알림:</strong><br>• 폼(연락처 폼, 뉴스레터 구독 등)이 포함된 위젯은 기능을 유지하기 위해 자동으로 캐싱을 우회합니다.<br>• 동적 JavaScript 콘텐츠가 있는 위젯은 수동으로 캐싱을 비활성화해야 합니다.<br>• 특정 위젯에 대한 캐싱을 비활성화하려면 위젯 구성에서 <code>Enable caching: No</code>를 설정하세요.<br>• CSRF 토큰, reCAPTCHA 또는 기타 동적 요소가 있는 폼은 자동으로 감지되어 캐싱에서 제외됩니다.',
            'widget_cache_ttl' => '캐시 기간 (초)',
            'widget_cache_ttl_helper' => '모든 위젯을 캐시하는 기간입니다. 기본값은 1800초(30분)입니다.',
            'plugin_cache_enabled' => '설치된 플러그인 캐시',
            'plugin_cache_enabled_helper' => '성능 향상을 위해 설치된 플러그인 목록을 캐시합니다. 활성화하면 파일 시스템 스캔을 줄이기 위해 시스템이 플러그인 목록을 30분 동안 캐시합니다.',
        ],
    ],
    'appearance' => [
        'title' => '모양',
    ],
    'panel' => [
        'common' => '공통',
        'general' => '일반',
        'general_description' => '일반 설정 보기 및 업데이트, 라이선스 활성화',
        'email' => '이메일',
        'email_description' => '이메일 설정 및 이메일 템플릿 보기 및 업데이트',
        'media' => '미디어',
        'media_description' => '미디어 설정 보기 및 업데이트',
        'system' => '시스템',
        'system_updater' => '시스템 업데이터',
        'system_updater_description' => '시스템을 최신 버전으로 업데이트',
        'others' => '기타',
    ],
    'saving' => '저장 중...',
    'generating_media_thumbnails' => '미디어 썸네일 생성 중...',
    'test_email_template' => '이메일 템플릿 테스트',
    'select_email_template' => '이메일 템플릿 선택',
    'enums' => [
        'data_retention_period' => [
            '안 함',
            '1일',
            3 => '3일',
            7 => '1주일',
            30 => '1개월',
            90 => '3개월',
            180 => '6개월',
            365 => '1년',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute는 유효한 AWS 리전이어야 합니다 (예: us-east-1, eu-west-1).',
    ],
];
