<?php

return [
    'title' => 'Innstillinger',
    'general_setting' => 'Generelle innstillinger',
    'menu' => 'Alle innstillinger',
    'email_setting_title' => 'E-postinnstillinger',
    'email_setting_description' => 'Konfigurer e-postinnstillinger',
    'general' => [
        'theme' => 'Tema',
        'title' => 'Generell informasjon',
        'description' => 'Vis og oppdater nettstedsinformasjon',
        'rich_editor' => 'Rik teksteditor',
        'site_title' => 'Nettstedstittel',
        'admin_email' => 'Administrator e-post',
        'seo_block' => 'SEO-konfigurasjon',
        'seo_title' => 'SEO-tittel',
        'seo_description' => 'SEO-beskrivelse',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Nettstedstittel (maksimalt 120 tegn)',
            'admin_email' => 'Administrator e-post',
            'seo_title' => 'SEO-tittel (maksimalt 120 tegn)',
            'seo_description' => 'SEO-beskrivelse (maksimalt 120 tegn)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Send feilrapportering via e-post',
        'enable_send_error_reporting_via_email_helper' => 'Når aktivert, sendes detaljerte feilrapporter til administratorens e-postadresser når kritiske feil oppstår på nettstedet',
        'time_zone' => 'Tidssone',
        'time_zone_helper' => 'Velg tidssone for nettstedet ditt. Dette vil bli brukt for alle dato- og tidsvisninger i hele systemet',
        'enable' => 'Aktiver',
        'disable' => 'Deaktiver',
        'disabled_helper' => 'Kan ikke deaktivere denne e-postmalen!',
        'enable_cache_site_map' => 'Aktiver nettstedskart-caching',
        'cache_time_site_map' => 'Nettstedskart cache-utløp (i minutter)',
        'admin_logo' => 'Administrator-logo',
        'admin_favicon' => 'Administrator-favicon',
        'admin_title' => 'Administrator-tittel',
        'admin_title_placeholder' => 'Tittel som vises i nettleserfanen',
        'admin_appearance_title' => 'Administrator-utseende',
        'admin_appearance_description' => 'Innstilling for administrator-utseende som editor, språk...',
        'seo_block_description' => 'Angi nettstedstittel, nettstedsbeskrivelse, nøkkelord for å optimalisere SEO',
        'webmaster_tools_description' => 'Google Search Console er et gratis webverktøy fra Google som hjelper nettstedseiere med å overvåke nettstedets ytelse i Google-søkeresultater.',
        'yes' => 'Ja',
        'no' => 'Nei',
        'show_on_front' => 'Din hjemmeside viser',
        'select' => '— Velg —',
        'show_site_name' => 'Vis nettstedsnavn etter sidetittel, separert med "-"',
        'locale' => 'Nettstedsspråk',
        'locale_direction' => 'Språkretning for front-side',
        'minutes' => 'minutter',
        'redirect_404_to_homepage' => 'Omdiriger alle Ikke funnet-forespørsler til hjemmesiden',
    ],
    'admin_appearance' => [
        'title' => 'Administrator-utseende',
        'description' => 'Vis og oppdater logo, favicon, layout,...',
        'layout' => 'Layout',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'Horisontal',
        'vertical' => 'Vertikal',
        'show_menu_item_icon' => 'Vis menyelement-ikon',
        'language' => 'Administrator-panelspråk',
        'theme_mode' => 'Temamodus',
        'dark' => 'Mørk',
        'light' => 'Lys',
        'container_width' => [
            'title' => 'Containerbredde',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'Standard',
            'large' => 'Stor',
            'full' => 'Full',
        ],
        'form' => [
            'admin_logo' => 'Administrator-logo',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'Logohøyde (px)',
            'admin_logo_max_height_helper' => 'Angi høyden på logoen i piksler. Standardverdien er :default.',
            'admin_favicon' => 'Administrator-favicon',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'Administrator-favicon type',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'Administrator-tittel',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'Tittel som vises i nettleserfanen',
            'admin_login_screen_backgrounds' => 'Påloggingsskjerm bakgrunner (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'Administrator-språk',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'Administrator-språkretning',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'Rik teksteditor',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'Primær skrifttype',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'Primærfarge',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'Sekundærfarge',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'Overskriftsfarge',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'Tekstfarge',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'Lenkefarge',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'Lenke hover-farge',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => 'Vis menyelement-ikon',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'Tilpasset CSS',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'Tilpasset JS',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript i sidehodet, pakk det inn i &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript i sidekroppen, pakk det inn i &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript i sidefoten, pakk det inn i &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Datatabeller',
        'description' => 'Innstillinger for datatabeller',
        'form' => [
            'show_column_visibility' => 'Vis kolonnesynlighet som standard',
            'show_column_visibility_helper' => 'Aktiver kolonnesynlighet vekslingsknappen i datatabeller for å tillate brukere å vise/skjule kolonner',
            'show_export_button' => 'Vis eksporteringsknapp som standard',
            'show_export_button_helper' => 'Vis eksporteringsalternativer (CSV, Excel, PDF) i datatabeller for å laste ned tabelldata',
            'pagination_type' => 'Pagineringstype',
            'pagination_type_helper' => 'Velg hvordan pagineringskontroller vises: Standard viser sidenumre, Rullegardinmeny viser en kompakt rullegardinvelger',
            'default' => 'Standard',
            'dropdown' => 'Rullegardinmeny',
            'enable_responsive' => 'Aktiver responsiv tabell',
            'enable_responsive_helper' => 'Juster automatisk tabellkolonner for å passe forskjellige skjermstørrelser for bedre mobilopplevelse',
        ],
    ],
    'email' => [
        'subject' => 'Emne',
        'content' => 'Innhold',
        'title' => 'Innstilling for e-postmal',
        'description' => 'E-postmal ved bruk av HTML og systemvariabler.',
        'reset_to_default' => 'Tilbakestill til standard',
        'back' => 'Tilbake til innstillinger',
        'reset_success' => 'Tilbakestilt til standard vellykket',
        'confirm_reset' => 'Bekreft tilbakestilling av e-postmal?',
        'confirm_message' => 'Vil du virkelig tilbakestille denne e-postmalen til standard?',
        'continue' => 'Fortsett',
        'sender_name' => 'Avsendernavn',
        'sender_name_placeholder' => 'Navn',
        'sender_name_helper' => 'Navnet som vil vises i Fra-feltet for e-poster sendt av systemet',
        'sender_email' => 'Avsender e-post',
        'sender_email_placeholder' => 'E-postadresse (f.eks. :default)',
        'sender_email_helper' => 'E-postadressen som vil brukes som avsender for alle e-poster sendt av systemet',
        'mailer' => 'Mailer',
        'port' => 'Port',
        'port_placeholder' => 'Eks: 587',
        'port_helper' => 'Porten som brukes av e-postserveren din (vanlige porter: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Eks: smtp.gmail.com',
        'host_helper' => 'SMTP vertadresse',
        'username' => 'Brukernavn',
        'username_placeholder' => 'Brukernavn for pålogging til e-postserver',
        'username_helper' => 'Ditt e-postserver påloggingsbrukernavn',
        'password' => 'Passord',
        'password_placeholder' => 'Passord for pålogging til e-postserver',
        'password_helper' => 'Ditt e-postserver påloggingspassord',
        'encryption' => 'Kryptering',
        'encryption_placeholder' => 'Velg krypteringstype',
        'encryption_helper' => 'Velg krypteringsmetode for sikker e-postoverføring',
        'encryption_none' => 'Ingen',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'E-postoppsett tips',
        'setup_tip_gmail' => 'For Gmail: Bruk smtp.gmail.com som vert, port 587 med TLS eller port 465 med SSL. Aktiver "Mindre sikker apptilgang" eller bruk et apppassord.',
        'setup_tip_port' => 'Vanlige porter: 25 (ukryptert), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternativ).',
        'setup_tip_encryption' => 'Bruk TLS for port 587 (anbefalt), SSL for port 465, eller Ingen for port 25 (ikke anbefalt for produksjon).',
        'setup_tip_test' => 'Bruk alltid "Send test e-post"-knappen for å verifisere konfigurasjonen før lagring.',
        'setup_tip_mailgun' => 'For bedre leveringsevne, vurder å bruke e-posttjenester som Mailgun, SendGrid eller Amazon SES i stedet for SMTP.',
        'queue_warning_title' => 'Køkonfigurasjon påkrevd',
        'queue_warning_description' => 'E-postkøen din er for øyeblikket konfigurert til å bruke ":default"-driver, men køarbeideren din kjører kanskje ikke. Dette betyr at e-poster ikke vil bli sendt før du setter opp en køarbeider.',
        'queue_warning_action' => 'For å sende e-poster umiddelbart uten en køarbeider, sett QUEUE_CONNECTION=sync i .env-filen din. Ellers, sørg for at køarbeideren din kjører med "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Lær mer om Laravel Queues</a>.',
        'mail_gun_domain' => 'Domene',
        'mail_gun_domain_placeholder' => 'Eks: mg.ditdomene.com',
        'mail_gun_domain_helper' => 'Domenenavnet du registrerte med Mailgun',
        'mail_gun_secret' => 'Hemmelighet',
        'mail_gun_secret_placeholder' => 'Eks: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Din Mailgun API-nøkkel',
        'mail_gun_endpoint' => 'Endepunkt',
        'mail_gun_endpoint_placeholder' => 'Eks: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API endepunkt (api.mailgun.net for USA, api.eu.mailgun.net for EU)',
        'log_channel' => 'Loggkanal',
        'log_channel_helper' => 'Velg hvilken loggkanal som skal brukes for e-postlogger',
        'sendmail_path' => 'Sendmail-sti',
        'local_domain' => 'Lokalt domene',
        'local_domain_placeholder' => 'Kan være tomt. Må settes til ditt domene når du bruker SMTP Relay. F.eks. ditt-domene.com',
        'local_domain_helper' => 'Domenet som vil brukes til å identifisere serveren når du kommuniserer med eksterne SMTP-servere',
        'ses_key' => 'Nøkkel',
        'ses_key_placeholder' => 'Eks: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Din AWS tilgangsnøkkel-ID',
        'ses_secret' => 'Hemmelighet',
        'ses_secret_placeholder' => 'Eks: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Din AWS hemmelige tilgangsnøkkel',
        'ses_region' => 'Region',
        'ses_region_placeholder' => 'Eks: us-east-1',
        'ses_region_helper' => 'AWS-regionen der SES-tjenesten din er konfigurert',
        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Eks: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Ditt Postmark server-token',
        'resend_key' => 'API-nøkkel',
        'resend_key_placeholder' => 'Eks: re_123456789012345678901234567890',
        'resend_key_helper' => 'Din Resend API-nøkkel',
        'email_templates' => 'E-postmaler',
        'email_templates_description' => 'E-postmaler ved bruk av HTML og systemvariabler.',
        'email_template_settings' => 'Innstillinger for e-postmal',
        'email_template_settings_description' => 'Vis og oppdater innstillingene for e-postmaler',
        'email_rules' => 'E-postregler',
        'email_rules_description' => 'Konfigurer e-postregler for validering',
        'base_template' => 'Basismal',
        'base_template_description' => 'Basismal for alle e-poster',
        'template_header' => 'E-postmal header',
        'template_header_description' => 'Mal for header i e-poster',
        'template_footer' => 'E-postmal footer',
        'template_footer_description' => 'Mal for footer i e-poster',
        'default' => 'Standard',
        'template_off_status_helper' => 'Denne e-postmalen er slått av.',
        'blacklist_email_domains' => 'Svartelistede e-postdomener',
        'blacklist_email_domains_helper' => 'Angi en liste over e-postdomener som skal svartelistes. F.eks. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Svartelistede e-postadresser',
        'blacklist_specified_emails_helper' => 'Angi en liste over spesifikke e-postadresser som skal svartelistes. F.eks. mail@example.com.',
        'exception_emails' => 'Unntak e-poster',
        'exception_emails_helper' => 'Disse e-postene vil bli ekskludert fra valideringsreglene.',
        'email_rules_strict' => 'Streng e-postvalidering',
        'email_rules_strict_helper' => 'Utfør RFC-lignende e-postvalidering med strenge regler.',
        'email_rules_dns' => 'DNS-sjekkvalidering',
        'email_rules_dns_helper' => 'Sjekk om det finnes DNS-poster som indikerer at serveren godtar e-poster.',
        'email_rules_spoof' => 'Spoofing-deteksjon',
        'email_rules_spoof_helper' => 'Oppdag potensielle e-postspoofing-forsøk.',
        'template_turn_off' => 'Klikk for å slå av denne e-postmalen',
        'template_turn_on' => 'Klikk for å slå på denne e-postmalen',
        'turn_on_success_message' => 'Slått på e-postmal vellykket!',
        'turn_off_success_message' => 'Slått av e-postmal vellykket!',
        'email_template_status' => 'E-postmal status',
        'email_template_status_description' => 'Slå på/av e-postmal',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Hvis ikke angitt, vil den hentes fra administrator-logo i Administrator -> Innstillinger -> Administrator-utseende -> Logo.',
        'email_template_copyright_text_helper_text' => 'Hvis ikke angitt, vil den hentes fra temaalternativenes opphavsrett i Administrator -> Utseende -> Temaalternativer -> Generelt -> Opphavsrett.',
        'email_template_email_contact' => 'Kontakt e-postadresse',
        'email_template_email_contact_helper_text' => 'Hvis ikke angitt, vil den hentes fra avsender-e-post i Administrator -> Innstillinger -> E-post',
        'email_template_social_links' => 'Sosiale lenker',
        'email_template_copyright_text' => 'Opphavsrett',
        'image_upload_supported' => 'Støtter bare PNG, JPG, JPEG og GIF-formater.',
        'email_template_custom_css' => 'E-postmal tilpasset CSS',
        'social_links' => [
            'name' => 'Navn',
            'icon' => 'Ikon',
            'icon_image' => 'Ikonbilde (Støtter bare PNG, JPG, JPEG og GIF-formater.)',
            'url' => 'URL',
            'image' => 'Bilde',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Lisens',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Media',
        'driver' => 'Driver',
        'description' => 'Innstillinger for media',
        'local_disk' => 'Lokal disk',
        'aws_access_key_id' => 'AWS tilgangsnøkkel-ID',
        'aws_secret_key' => 'AWS hemmelig nøkkel',
        'aws_default_region' => 'AWS standardregion',
        'aws_bucket' => 'AWS bøtte',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS endepunkt (valgfritt)',
        'use_path_style_endpoint' => 'Bruk stistil-endepunkt',
        'r2_access_key_id' => 'R2 tilgangsnøkkel-ID',
        'r2_secret_key' => 'R2 hemmelig nøkkel',
        'r2_bucket' => 'R2 bøtte',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 endepunkt',
        'do_spaces_access_key_id' => 'DO Spaces tilgangsnøkkel-ID',
        'do_spaces_secret_key' => 'DO Spaces hemmelig nøkkel',
        'do_spaces_default_region' => 'DO Spaces standardregion',
        'do_spaces_bucket' => 'DO Spaces bøtte',
        'do_spaces_endpoint' => 'DO Spaces endepunkt',
        'do_spaces_cdn_enabled' => 'Er DO Spaces CDN aktivert?',
        'do_spaces_cdn_enabled_helper' => 'Når aktivert, vil mediefiler bli servert gjennom DigitalOcean Spaces CDN for raskere global innholdslevering. Du kan valgfritt konfigurere et tilpasset CDN-domene nedenfor.',
        'media_do_spaces_cdn_custom_domain' => 'Do Spaces CDN tilpasset domene',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://ditt-tilpasset-domene.com',
        'wasabi_access_key_id' => 'Wasabi tilgangsnøkkel-ID',
        'wasabi_secret_key' => 'Wasabi hemmelig nøkkel',
        'wasabi_default_region' => 'Wasabi standardregion',
        'wasabi_bucket' => 'Wasabi bøtte',
        'wasabi_root' => 'Wasabi rot',
        'wasabi_root_helper' => 'For å gjenbruke eksisterende bilder, angi ganske enkelt Wasabi-roten som "/", last deretter opp alle gjeldende filer fra public/storage til Wasabi rot-katalogen din.',
        'backblaze_access_key_id' => 'Backblaze tilgangsnøkkel-ID',
        'backblaze_secret_key' => 'Backblaze hemmelig nøkkel',
        'backblaze_bucket' => 'Backblaze bøtte',
        'backblaze_default_region' => 'Backblaze standardregion',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze endepunkt',
        'backblaze_cdn_enabled' => 'Er Backblaze CDN aktivert?',
        'backblaze_cdn_enabled_helper' => 'Når aktivert, vil mediefiler bli servert gjennom et CDN for raskere global innholdslevering. Du må konfigurere et tilpasset CDN-domene nedenfor (f.eks. Cloudflare CDN eller Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Backblaze CDN tilpasset domene',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://ditt-tilpasset-domene.com',
        'default_placeholder_image' => 'Standard plassholderbilde',
        'enable_chunk' => 'Aktiver delt opplasting',
        'chunk_size' => 'Del størrelse (bytes)',
        'chunk_size_placeholder' => 'Standard: 1048576 ~ 1MB',
        'max_file_size' => 'Maks filstørrelse for del (MB)',
        'max_file_size_placeholder' => 'Standard: 1048576 ~ 1GB',
        'enable_watermark' => 'Aktiver vannmerke',
        'enable_watermark_helper' => 'Når aktivert, vil et vannmerke automatisk legges til nylig opplastede bilder i valgte mapper. Dette påvirker ikke eksisterende bilder.',
        'watermark_source' => 'Vannmerkebilde',
        'watermark_source_helper' => 'Støtter bare PNG, JPG og JPEG-formater. Du bør bruke bilde mindre enn 200x200px og størrelse mindre enn 50KB.',
        'watermark_size' => 'Vannmerkestørrelse (%)',
        'watermark_size_placeholder' => 'Standard: 10 (%)',
        'watermark_opacity' => 'Vannmerke gjennomsiktighet (%)',
        'watermark_opacity_placeholder' => 'Standard: 70 (%)',
        'watermark_position' => 'Vannmerkeposisjon',
        'watermark_position_x' => 'Vannmerkeposisjon X',
        'watermark_position_y' => 'Vannmerkeposisjon Y',
        'watermark_position_top_left' => 'Øverst til venstre',
        'watermark_position_top_right' => 'Øverst til høyre',
        'watermark_position_bottom_left' => 'Nederst til venstre',
        'watermark_position_bottom_right' => 'Nederst til høyre',
        'watermark_position_center' => 'Senter',
        'turn_off_automatic_url_translation_into_latin' => 'Slå av automatisk URL-oversettelse til latin',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Når den er aktivert, vil ikke fil-URL-er automatisk translittereres til latinske tegn, og originaltegn fra ikke-latinske alfabeter bevares.',
        'bunnycdn_hostname' => 'Vertsnavn',
        'bunnycdn_zone' => 'Sonenavn (Navnet på lagringssonen din)',
        'bunnycdn_key' => 'FTP & API tilgangspassord (Lagringssone API tilgangspassord)',
        'bunnycdn_region' => 'Region (Lagringssone region)',
        'optional' => 'Valgfritt',
        'sizes' => 'Media miniatyrbilde størrelser',
        'media_sizes_helper' => 'Sett bredde eller høyde til 0 hvis du bare vil beskjære etter bredde eller høyde.',
        'width' => 'Bredde',
        'height' => 'Høyde',
        'default_size_value' => 'Standard: :size',
        'all' => 'Alle',
        'all_helper_text' => 'Hvis du fjerner merket for alle mapper, vil det gjelde for alle mapper.',
        'media_folders_can_add_watermark' => 'Legg til vannmerke for bilder i mapper:',
        'max_upload_filesize' => 'Maks opplastingsfilstørrelse (MB)',
        'max_upload_filesize_placeholder' => 'Standard: :size, må være mindre enn :size.',
        'max_upload_filesize_helper' => 'Serveren din tillater opplasting av filer maksimalt :size, du kan endre denne verdien for å begrense opplastingsfilstørrelse.',
        'image_processing_library' => 'Bildebehandlingsbibliotek',
        'use_original_name_for_file_path' => 'Bruk originalt navn for filbane',
        'use_original_name_for_file_path_helper' => 'Når aktivert, vil opplastede filer beholde sine opprinnelige navn. Når den er deaktivert, vil filnavn konverteres til URL-vennlige snegler (f.eks. "My Photo.jpg" blir "my-photo.jpg").',
        'keep_original_file_size_and_quality' => 'Behold original filstørrelse og kvalitet',
        'keep_original_file_size_and_quality_helper' => 'Når den er aktivert, vil ikke opplastede bilder endres størrelse eller optimaliseres, noe som beholder deres opprinnelige kvalitet og filstørrelse. Når den er deaktivert, kan bilder komprimeres og endres størrelse basert på innstillingene dine.',
        'update_thumbnail_sizes_warning' => 'Etter justering av miniatyrbildestørrelser, må du klikke på ":button_text"-knappen for å oppdatere dem.',
        'thumbnail_crop_position' => 'Miniatyrbilde beskjæringsposisjon',
        'thumbnail_crop_position_left' => 'Venstre',
        'thumbnail_crop_position_center' => 'Senter',
        'thumbnail_crop_position_right' => 'Høyre',
        'thumbnail_crop_position_top' => 'Topp',
        'thumbnail_crop_position_bottom' => 'Bunn',
        'thumbnail_crop_position_helper' => 'Denne innstillingen brukes til å beskjære bildet ved generering av miniatyrbilder. Det vil bli beskåret fra denne posisjonen til bildet er fylt.',
        'user_can_only_view_own_media' => 'Brukere kan bare se sin egen media',
        'user_can_only_view_own_media_helper' => 'Når aktivert, kan brukere bare se sin egen media, mens superadministratorer kan se all media.',
        'enable_thumbnail_sizes' => 'Aktiver miniatyrbildestørrelser',
        'enable_thumbnail_sizes_helper' => 'Aktiver dette alternativet for å generere miniatyrbilder for bilder. Hvis det er deaktivert, vil systemet ikke generere miniatyrbilder for bilder og alltid bruke fullstørrelse bilde.',
        'convert_image_to_webp' => 'Konverter JPG, JPEG, PNG bilde til WebP',
        'convert_image_to_webp_helper' => 'WebP er et moderne bildeformat som gir overlegen tapsfri og tapsbeheftet komprimering for bilder på nettet. Det støttes i Chrome, Firefox, Edge og Opera. Bilde vil bli konvertert til WebP-format ved opplasting. Det gjelder bare for JPG, JPEG, PNG bilder.',
        'reduce_large_image_size' => 'Reduser stor bildestørrelse ved opplasting',
        'reduce_large_image_size_helper' => 'Når aktivert, vil systemet redusere størrelsen på store bilder ved opplasting, brukt for JPG, JPEG, PNG, WebP bilde. Maksimal bredde og høyde på bildet vil bli endret til verdiene du angir nedenfor.',
        'image_max_width' => 'Bilde maks bredde (px)',
        'image_max_height' => 'Bilde maks høyde (px)',
        'image_max_width_placeholder' => 'La være tom for å beholde original bredde',
        'image_max_height_placeholder' => 'La være tom for å beholde original høyde',
        'image_max_width_helper' => 'Angi maksimal bredde på bildet i piksler. Original bredde vil bli beholdt hvis dette feltet er tomt.',
        'image_max_height_helper' => 'Angi maksimal høyde på bildet i piksler. Original høyde vil bli beholdt hvis dette feltet er tomt.',
        'customize_upload_path' => 'Tilpass opplastingssti',
        'customize_upload_path_helper' => 'Tilpass opplastingsstien for mediafiler. Som standard vil systemet laste opp filer til ":path"-mappen.',
        'upload_path' => 'Opplastingssti',
        'upload_path_placeholder' => 'Eksempel: uploads',
        'upload_path_helper' => 'Den mappen vil bli opprettet i /public. Standardmappen er ":folder". Deretter vil den bli lastet opp til "/public/:folder".',
        'upload_path_warning' => 'Systemet vil ikke flytte eksisterende filer til den nye mappen. Hvis du vil flytte eksisterende filer til den nye mappen, må du gjøre det manuelt.',
        'convert_file_name_to_uuid' => 'Konverter filnavn til UUID',
        'convert_file_name_to_uuid_helper' => 'Når aktivert, vil systemet konvertere filnavnet til UUID ved opplasting. Dette er nyttig for å forhindre dupliserte filnavn og bedre sikkerhet.',
        's3_path' => 'Tilpasset S3-sti (valgfritt)',
        's3_path_placeholder' => 'Valgfri tilpasset sti i S3-bøtte (f.eks. uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Lagre innstillinger',
    'template' => 'Mal',
    'description' => 'Beskrivelse',
    'enable' => 'Aktiver',
    'send' => 'Send',
    'test_email_description' => 'For å sende test e-post, sørg for at du har oppdatert konfigurasjonene for sending av e-post!',
    'test_email_input_placeholder' => 'Skriv inn e-postadressen du vil sende test e-post til.',
    'test_email_modal_title' => 'Send en test e-post',
    'test_send_mail' => 'Send test e-post',
    'test_email_send_success' => 'E-post sendt vellykket!',
    'locale_direction_ltr' => 'Venstre til høyre',
    'locale_direction_rtl' => 'Høyre til venstre',
    'emails_warning' => 'Du kan legge til maksimalt :count e-poster',
    'email_add_more' => 'Legg til flere',
    'generate' => 'Generer',
    'generate_thumbnails' => 'Generer miniatyrbilder',
    'generate_thumbnails_success' => 'Miniatyrbilder generert vellykket. :count filer har blitt generert!',
    'generate_thumbnails_error' => 'Vi kunne ikke regenerere miniatyrbilder for :count filer!',
    'generate_thumbnails_description' => 'Er du sikker på at du vil regenerere miniatyrbilder for alle bilder? Dette kan ta litt tid. Ikke naviger bort fra denne siden før prosessen er fullført.',
    'enable_chunk_description' => 'Delt størrelse opplasting brukes til å laste opp store filstørrelser.',
    'watermark_description' => 'ADVARSEL: Vannmerke legges bare til nye opplastede bilder, det vil ikke bli lagt til eksisterende bilder. Deaktivering av vannmerke vil ikke fjerne vannmerke fra eksisterende bilder.',
    'submit' => 'Send inn',
    'back' => 'Tilbake',
    'enter_sample_value' => 'Angi prøveverdier for testing',
    'preview' => 'Forhåndsvisning',
    'media_size_width' => ':size størrelse bredde må være større enn 0',
    'media_size_height' => ':size størrelse høyde må være større enn 0',
    'cronjob' => [
        'name' => 'Cronjob',
        'description' => 'Cronjob lar deg automatisere visse kommandoer eller skript på nettstedet ditt.',
        'is_not_ready' => 'For å kjøre cronjob, følg instruksjonene nedenfor.',
        'is_working' => 'Gratulerer! Cronjobben din kjører.',
        'is_not_working' => 'Cronjobben din kjører ikke. Vennligst sjekk serverens cronjob.',
        'last_checked' => 'Sist sjekket kl. :time.',
        'copy_button' => 'Kopier',
        'setup' => [
            'name' => 'Oppsett av Cronjob',
            'connect_to_server' => 'Koble til serveren din via SSH eller en foretrukket metode.',
            'open_crontab' => 'Åpne crontab-filen med en teksteditor (f.eks. `crontab -e`).',
            'add_cronjob' => 'Legg til kommandoen ovenfor i crontab-filen og lagre den.',
            'done' => 'Cronjobben vil nå kjøre hvert minutt og utføre den angitte kommandoen.',
            'learn_more' => 'Du kan lære mer om cronjob fra Laravel :documentation',
            'documentation' => 'dokumentasjon',
            'copied' => 'Kopiert',
        ],
    ],
    'security' => [
        'title' => 'Sikkerhetsinnstillinger',
        'description' => 'Sjekk og konfigurer sikkerhetsinnstillingene for nettstedet ditt.',
        'menu_description' => 'Administrer informasjonskapsel-sikkerhet og HTTP-headere',
        'status_secure' => 'Alle sikkerhetsinnstillinger er riktig konfigurert!',
        'status_insecure' => 'Noen sikkerhetsinnstillinger trenger oppmerksomhet!',
        'current_settings' => 'Gjeldende sikkerhetsinnstillinger',
        'status' => 'Status',
        'setting' => 'Innstilling',
        'current_value' => 'Gjeldende verdi',
        'recommended_value' => 'Anbefalt',
        'session_http_only' => 'HttpOnly informasjonskapsel-flagg',
        'session_http_only_description' => 'Forhindrer JavaScript fra å få tilgang til økt-informasjonskapsler (beskytter mot XSS-angrep)',
        'session_secure_cookie' => 'Sikker informasjonskapsel-flagg',
        'session_secure_cookie_description' => 'Sikrer at informasjonskapsler bare sendes over HTTPS-tilkoblinger',
        'session_same_site' => 'SameSite informasjonskapsel-flagg',
        'session_same_site_description' => 'Forhindrer CSRF-angrep ved å begrense når informasjonskapsler sendes',
        'http_security_headers' => 'HTTP-sikkerhetshoder',
        'http_security_headers_description' => 'Legger til sikkerhetshoder for å beskytte mot vanlige webssårbarheter',
        'https_warning' => 'Nettstedet ditt bruker ikke HTTPS',
        'https_warning_description' => 'Noen sikkerhetsfunksjoner som sikre informasjonskapsler krever HTTPS. Vurder å aktivere SSL for nettstedet ditt.',
        'how_to_fix' => 'Hvordan fikse sikkerhetsproblemer',
        'env_file_location' => 'Rediger .env-filen din som ligger i:',
        'add_to_env' => 'Innstillinger å legge til',
        'required_settings' => 'Påkrevde sikkerhetsinnstillinger',
        'for_https_sites' => 'Kun for HTTPS-nettsteder',
        'copy' => 'Kopier',
        'copy_settings' => 'Kopier alle innstillinger',
        'copied' => 'Kopiert!',
        'steps' => 'Trinn for å bruke innstillinger',
        'step_1' => 'Åpne .env-filen din i en teksteditor',
        'step_2' => 'Legg til eller oppdater sikkerhetsinnstillingene vist ovenfor',
        'step_3' => 'Lagre .env-filen',
        'step_4' => 'Tøm cache ved å bruke Administrator-panel → Plattformadministrasjon → Cachehåndtering',
        'security_headers_info' => 'Informasjon om sikkerhetshoder',
        'security_headers_list' => 'Når aktivert, legges følgende hoder til alle svar:',
        'header_nosniff' => 'Forhindrer nettlesere fra å gjette innholdstyper',
        'header_frame' => 'Beskytter mot clickjacking-angrep',
        'header_xss' => 'Aktiverer nettleser XSS-beskyttelse',
        'header_referrer' => 'Kontrollerer hvor mye referrer-informasjon som sendes',
        'learn_more' => 'For mer detaljert informasjon, se :documentation',
        'documentation' => 'sikkerhetsdokumentasjon',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Konfigurer caching for optimalisert hastighet',
        'form' => [
            'cache_admin_menu' => 'Cache administrator-meny',
            'cache_admin_menu_helper' => 'Cache administrator-meny for optimalisert hastighet. Dette alternativet bør deaktiveres hvis du utvikler eller tilpasser administrator-menyen.',
            'enable_cache_site_map' => 'Cache nettstedskart',
            'enable_cache_site_map_helper' => 'Nettstedskart :url bør caches på grunn av det store antallet sider. Hvis du har et lite antall sider, kan du deaktivere dette alternativet.',
            'cache_time_site_map' => 'Nettstedskart cache-utløp (i minutter)',
            'cache_front_menu' => 'Cache front-meny',
            'cache_front_menu_helper' => 'Cache front-meny for optimalisert hastighet',
            'cache_user_avatar' => 'Cache brukeravatar',
            'cache_user_avatar_helper' => 'For brukere uten avatar vil systemet generere avatarer fra brukernavnene deres. Avatarene vil bli cachet for optimalisert hastighet og vil ikke bli regenerert.',
            'shortcode_cache_enabled' => 'Cache kortkoder (UI-blokker)',
            'shortcode_cache_enabled_helper' => 'Aktiver caching for kortkoder for å forbedre ytelsen. Når aktivert, vil kortkoder bli cachet for å redusere gjengivelsestid.',
            'shortcode_cache_warning' => '<strong>⚠️ Viktig varsel:</strong><br>• Kortkoder som inneholder skjemaer (kontaktskjemaer, nyhetsbrevabonnementer osv.) vil automatisk omgå caching for å bevare funksjonalitet.<br>• Kortkoder med dynamisk JavaScript-innhold bør ha caching deaktivert manuelt.<br>• For å deaktivere caching for spesifikke kortkoder, legg til <code>Aktiver caching: Nei</code> i kortkodekonfigurasjonen.<br>• Skjemaer med CSRF-tokens, reCAPTCHA eller andre dynamiske elementer oppdages automatisk og ekskluderes fra caching.',
            'shortcode_cache_ttl' => 'Cache-varighet (sekunder)',
            'shortcode_cache_ttl_helper' => 'Varigheten for å cache alle kortkoder. Standard er 1800 sekunder (30 minutter).',
            'widget_cache_enabled' => 'Cache widgets',
            'widget_cache_enabled_helper' => 'Aktiver caching for widgets for å forbedre ytelsen. Når aktivert, vil widgets bli cachet for å redusere gjengivelsestid.',
            'widget_cache_warning' => '<strong>⚠️ Viktig varsel:</strong><br>• Widgets som inneholder skjemaer (kontaktskjemaer, nyhetsbrevabonnementer osv.) vil automatisk omgå caching for å bevare funksjonalitet.<br>• Widgets med dynamisk JavaScript-innhold bør ha caching deaktivert manuelt.<br>• For å deaktivere caching for spesifikke widgets, sett <code>Aktiver caching: Nei</code> i widget-konfigurasjonen.<br>• Skjemaer med CSRF-tokens, reCAPTCHA eller andre dynamiske elementer oppdages automatisk og ekskluderes fra caching.',
            'widget_cache_ttl' => 'Cache-varighet (sekunder)',
            'widget_cache_ttl_helper' => 'Varigheten for å cache alle widgets. Standard er 1800 sekunder (30 minutter).',
            'plugin_cache_enabled' => 'Cache installerte plugins',
            'plugin_cache_enabled_helper' => 'Cache listen over installerte plugins for forbedret ytelse. Når aktivert, vil systemet cache plugin-listen i 30 minutter for å redusere filsystemskanning.',
        ],
    ],
    'appearance' => [
        'title' => 'Utseende',
    ],
    'panel' => [
        'common' => 'Vanlig',
        'general' => 'Generelt',
        'general_description' => 'Vis og oppdater dine generelle innstillinger og aktiver lisens',
        'email' => 'E-post',
        'email_description' => 'Vis og oppdater dine e-postinnstillinger og e-postmaler',
        'media' => 'Media',
        'media_description' => 'Vis og oppdater dine mediainnstillinger',
        'system' => 'System',
        'system_updater' => 'Systemoppdatering',
        'system_updater_description' => 'Oppdater systemet ditt til siste versjon',
        'others' => 'Andre',
    ],
    'saving' => 'Lagrer...',
    'generating_media_thumbnails' => 'Genererer media miniatyrbilder...',
    'test_email_template' => 'Test e-postmal',
    'select_email_template' => 'Velg e-postmal',
    'enums' => [
        'data_retention_period' => [
            'Aldri',
            '1 dag',
            3 => '3 dager',
            7 => '1 uke',
            30 => '1 måned',
            90 => '3 måneder',
            180 => '6 måneder',
            365 => '1 år',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => ':attribute må være en gyldig AWS-region (f.eks. us-east-1, eu-west-1).',
    ],
];
