<?php

return [
    'name' => 'plugins/car-rentals::settings.email.name',
    'description' => 'plugins/car-rentals::settings.email.description',
    'templates' => [
        'confirm-email' => [
            'title' => 'plugins/car-rentals::settings.email.templates.confirm_email_title',
            'description' => 'plugins/car-rentals::settings.email.templates.confirm_email_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.confirm_email_subject',
            'can_off' => false,
            'variables' => [
                'verify_link' => 'plugins/car-rentals::settings.email.templates.variables.verify_link',
                'customer_name' => 'plugins/car-rentals::settings.email.templates.variables.customer_name',
            ],
        ],
        'password-reminder' => [
            'title' => 'plugins/car-rentals::settings.email.templates.password_reminder_title',
            'description' => 'plugins/car-rentals::settings.email.templates.password_reminder_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.password_reminder_subject',
            'can_off' => false,
            'variables' => [
                'reset_link' => 'plugins/car-rentals::settings.email.templates.variables.reset_link',
                'customer_name' => 'plugins/car-rentals::settings.email.templates.variables.customer_name',
            ],
        ],
        'booking-confirm' => [
            'title' => 'plugins/car-rentals::settings.email.templates.booking_confirm.booking_confirmation_title',
            'description' => 'plugins/car-rentals::settings.email.templates.booking_confirm.booking_confirmation_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.booking_confirm_subject',
            'can_off' => true,
            'variables' => [
                'booking_code' => 'plugins/car-rentals::settings.email.templates.booking_confirm.booking_code',
                'customer_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_name',
                'customer_phone' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_phone',
                'customer_email' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_email',
                'payment_method' => 'plugins/car-rentals::settings.email.templates.booking_confirm.payment_method',
                'car_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.car_name',
                'pickup_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.pickup_address',
                'return_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.return_address',
                'rental_start_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_start_date',
                'rental_end_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_end_date',
                'note' => 'plugins/car-rentals::settings.email.templates.booking_confirm.note',
            ],
        ],
        'message' => [
            'title' => 'plugins/car-rentals::settings.email.templates.message_title',
            'description' => 'plugins/car-rentals::settings.email.templates.message_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.message_subject',
            'can_off' => true,
            'variables' => [
                'message_name' => 'plugins/car-rentals::settings.email.templates.variables.message_name',
                'message_phone' => 'plugins/car-rentals::settings.email.templates.variables.message_phone',
                'message_email' => 'plugins/car-rentals::settings.email.templates.variables.message_email',
                'message_content' => 'plugins/car-rentals::settings.email.templates.variables.message_content',
                'message_link' => 'plugins/car-rentals::settings.email.templates.variables.message_link',
                'message_subject' => 'plugins/car-rentals::settings.email.templates.variables.message_subject',
                'message_ip_address' => 'plugins/car-rentals::settings.email.templates.variables.message_ip_address',
                'message_custom_fields' => 'plugins/car-rentals::settings.email.templates.variables.message_custom_fields',
            ],
        ],
        'new-pending-car' => [
            'title' => 'plugins/car-rentals::settings.email.templates.new_pending_car_title',
            'description' => 'plugins/car-rentals::settings.email.templates.new_pending_car_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.new_pending_car_subject',
            'can_off' => true,
            'enabled' => false,
            'variables' => [
                'post_author' => 'plugins/car-rentals::settings.email.templates.variables.post_author',
                'post_name' => 'plugins/car-rentals::settings.email.templates.variables.post_name',
                'post_url' => 'plugins/car-rentals::settings.email.templates.variables.post_url',
            ],
        ],
        'booking-notice-to-admin' => [
            'title' => 'plugins/car-rentals::settings.email.templates.booking_notice_title',
            'description' => 'plugins/car-rentals::settings.email.templates.booking_notice_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.booking_notice_subject',
            'can_off' => true,
            'variables' => [
                'booking_code' => 'plugins/car-rentals::settings.email.templates.booking_confirm.booking_code',
                'customer_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_name',
                'customer_phone' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_phone',
                'customer_email' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_email',
                'payment_method' => 'plugins/car-rentals::settings.email.templates.booking_confirm.payment_method',
                'car_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.car_name',
                'pickup_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.pickup_address',
                'return_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.return_address',
                'rental_start_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_start_date',
                'rental_end_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_end_date',
                'note' => 'plugins/car-rentals::settings.email.templates.booking_confirm.note',
            ],
        ],
        'booking-notice-to-vendor' => [
            'title' => 'plugins/car-rentals::settings.email.templates.booking_notice_vendor_title',
            'description' => 'plugins/car-rentals::settings.email.templates.booking_notice_vendor_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.booking_notice_vendor_subject',
            'can_off' => true,
            'variables' => [
                'vendor_name' => 'plugins/car-rentals::settings.email.templates.booking_notice_vendor.vendor_name',
                'booking_code' => 'plugins/car-rentals::settings.email.templates.booking_confirm.booking_code',
                'customer_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_name',
                'customer_phone' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_phone',
                'customer_email' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_email',
                'payment_method' => 'plugins/car-rentals::settings.email.templates.booking_confirm.payment_method',
                'car_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.car_name',
                'pickup_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.pickup_address',
                'return_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.return_address',
                'rental_start_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_start_date',
                'rental_end_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_end_date',
                'note' => 'plugins/car-rentals::settings.email.templates.booking_confirm.note',
            ],
        ],
        'booking-status-changed' => [
            'title' => 'plugins/car-rentals::settings.email.templates.booking_status_changed_title',
            'description' => 'plugins/car-rentals::settings.email.templates.booking_status_changed_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.booking_status_changed_subject',
            'can_off' => true,
            'variables' => [
                'booking_code' => 'plugins/car-rentals::settings.email.templates.booking_confirm.booking_code',
                'customer_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_name',
                'customer_phone' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_phone',
                'customer_email' => 'plugins/car-rentals::settings.email.templates.booking_confirm.customer_email',
                'payment_method' => 'plugins/car-rentals::settings.email.templates.booking_confirm.payment_method',
                'car_name' => 'plugins/car-rentals::settings.email.templates.booking_confirm.car_name',
                'pickup_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.pickup_address',
                'return_address' => 'plugins/car-rentals::settings.email.templates.booking_confirm.return_address',
                'rental_start_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_start_date',
                'rental_end_date' => 'plugins/car-rentals::settings.email.templates.booking_confirm.rental_end_date',
                'note' => 'plugins/car-rentals::settings.email.templates.booking_confirm.note',
            ],
        ],
        'car-approved' => [
            'title' => 'plugins/car-rentals::settings.email.templates.car_approved_title',
            'description' => 'plugins/car-rentals::settings.email.templates.car_approved_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.car_approved_subject',
            'can_off' => true,
            'variables' => [
                'author_name' => 'plugins/car-rentals::settings.email.templates.car_approved.author_name',
                'car_name' => 'plugins/car-rentals::settings.email.templates.car_approved.car_name',
                'car_link' => 'plugins/car-rentals::settings.email.templates.car_approved.car_link',
            ],
        ],
        'car-rejected' => [
            'title' => 'plugins/car-rentals::settings.email.templates.car_rejected_title',
            'description' => 'plugins/car-rentals::settings.email.templates.car_rejected_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.car_rejected_subject',
            'can_off' => true,
            'variables' => [
                'author_name' => 'plugins/car-rentals::settings.email.templates.car_rejected.author_name',
                'car_name' => 'plugins/car-rentals::settings.email.templates.car_rejected.car_name',
                'car_link' => 'plugins/car-rentals::settings.email.templates.car_rejected.car_link',
                'reason' => 'plugins/car-rentals::settings.email.templates.car_rejected.reason',
            ],
        ],
        'vendor-upgrade' => [
            'title' => 'plugins/car-rentals::settings.email.templates.vendor_upgrade_title',
            'description' => 'plugins/car-rentals::settings.email.templates.vendor_upgrade_description',
            'subject' => 'plugins/car-rentals::settings.email.templates.vendor_upgrade_subject',
            'can_off' => true,
            'variables' => [
                'customer_name' => 'plugins/car-rentals::settings.email.templates.vendor_upgrade.customer_name',
                'customer_email' => 'plugins/car-rentals::settings.email.templates.vendor_upgrade.customer_email',
                'dashboard_link' => 'plugins/car-rentals::settings.email.templates.vendor_upgrade.dashboard_link',
            ],
        ],
    ],
];
