<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        if (! Schema::hasColumn('cr_car_types', 'icon')) {
            Schema::table('cr_car_types', function (Blueprint $table): void {
                $table->string('icon')->nullable()->after('image');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('cr_car_types', 'icon')) {
            Schema::table('cr_car_types', function (Blueprint $table): void {
                $table->dropColumn('icon');
            });
        }
    }
};
