<?php

return [
    'name' => 'تأجير السيارات',
    'customer' => [
        'name' => 'العملاء',
        'create' => 'إضافة عميل',
        'view' => 'عرض',
        'information' => 'معلومات العميل',
        'email' => 'البريد الإلكتروني',
        'phone' => 'الهاتف',
        'status' => 'الحالة',
        'vendor_status' => 'حالة البائع',
        'is_vendor' => 'بائع',
        'not_vendor' => 'عميل',
        'recent_activity' => 'النشاط الأخير',
        'recent_activity_description' => 'سيظهر نشاط العميل هنا.',
        'verification_section' => 'التحقق من العميل',
        'verified' => 'موثق',
        'not_verified' => 'غير موثق',
        'verified_by' => 'تم التوثيق بواسطة',
        'verified_at' => 'تاريخ التوثيق',
        'verify_customer' => 'توثيق العميل',
        'unverify_customer' => 'إلغاء توثيق العميل',
        'verify_customer_confirmation' => 'تأكيد توثيق العميل',
        'verify_customer_confirmation_desc' => 'هل أنت متأكد من رغبتك في توثيق :name؟ سيؤدي هذا إلى عرض شارة التوثيق على ملفهم الشخصي.',
        'unverify_customer_confirmation' => 'تأكيد إلغاء التوثيق',
        'unverify_customer_confirmation_desc' => 'هل أنت متأكد من رغبتك في إزالة التوثيق من :name؟ سيتم إزالة شارة التوثيق.',
        'verify_success' => 'تم توثيق العميل :name بنجاح.',
        'unverify_success' => 'تم إلغاء توثيق العميل :name بنجاح.',
        'already_verified' => 'هذا العميل موثق بالفعل.',
        'already_unverified' => 'هذا العميل غير موثق.',
        'upgrade_to_vendor_title' => 'الترقية إلى بائع',
        'upgrade_to_vendor_description' => 'قم بترقية هذا العميل إلى بائع للسماح له بإدراج وإدارة سياراته الخاصة للإيجار.',
        'upgrade_to_vendor_button' => 'ترقية إلى بائع',
        'upgrade_to_vendor_confirmation' => 'تأكيد الترقية إلى بائع',
        'upgrade_to_vendor_confirmation_desc' => 'هل أنت متأكد من رغبتك في ترقية :name إلى بائع؟ سيسمح لهم ذلك بإدراج وإدارة سياراتهم الخاصة على المنصة.',
        'upgrade_to_vendor_success' => 'تمت ترقية :name إلى بائع بنجاح.',
        'already_vendor' => 'هذا العميل هو بائع بالفعل.',
        'email_verified' => 'تم التحقق من البريد الإلكتروني',
        'email_not_verified' => 'لم يتم التحقق من البريد الإلكتروني',
        'verify_email_warning_message' => 'لم يتم التحقق من عنوان البريد الإلكتروني لهذا العميل. يمكنك التحقق منه يدويًا لتأكيد صحة بريده الإلكتروني.',
        'verify_email_title' => 'التحقق من عنوان البريد الإلكتروني',
        'verify_email_description' => 'لم يتم التحقق من عنوان البريد الإلكتروني لهذا العميل. يمكنك التحقق منه يدويًا لتأكيد صحة بريده الإلكتروني.',
        'verify_email_button' => 'التحقق من البريد الإلكتروني',
        'verify_email_confirmation' => 'تأكيد التحقق من البريد الإلكتروني',
        'verify_email_confirmation_desc' => 'هل أنت متأكد من رغبتك في التحقق من عنوان البريد الإلكتروني :email لـ :name؟ سيؤدي هذا إلى وضع علامة على بريدهم الإلكتروني كمؤكد.',
        'verify_email_success' => 'تم التحقق من البريد الإلكتروني :email بنجاح لـ :name.',
        'email_already_verified' => 'تم التحقق من عنوان البريد الإلكتروني هذا بالفعل.',
        'resend_confirmation_button' => 'إعادة إرسال بريد التأكيد',
        'resend_confirmation_title' => 'إعادة إرسال بريد التأكيد',
        'resend_confirmation_desc' => 'هل أنت متأكد من رغبتك في إعادة إرسال بريد التأكيد إلى :email لـ :name؟ سيؤدي هذا إلى إرسال رابط تحقق جديد إلى عنوان بريدهم الإلكتروني.',
        'resend_confirmation_success' => 'تم إرسال بريد التأكيد إلى :email.',
        'resend_confirmation_error' => 'فشل إرسال بريد التأكيد. يرجى المحاولة مرة أخرى.',
        'customer_verified_successfully' => 'تم توثيق هذا العميل ويمكن الوثوق به.',
        'customer_not_verified_yet' => 'لم يتم توثيق هذا العميل بعد.',
        'verification_pending' => 'التوثيق قيد الانتظار',
        'click_verify_to_approve' => 'انقر على الزر أدناه لتوثيق هذا العميل وعرض شارة التوثيق.',
        'verification_note' => 'ملاحظة التوثيق',
        'verification_note_placeholder' => 'أدخل أي ملاحظات حول إجراء التوثيق هذا...',
        'verification_note_helper' => 'أضف ملاحظات حول عملية التوثيق (للاستخدام الداخلي فقط)',
        'forms' => [
            'name' => 'الاسم',
            'email' => 'البريد الإلكتروني',
            'phone' => 'الهاتف',
            'whatsapp' => 'واتساب',
            'avatar' => 'الصورة الشخصية',
            'dob' => 'تاريخ الميلاد',
            'company' => 'الشركة',
            'position' => 'المنصب',
            'password' => 'كلمة المرور',
            'password_confirmation' => 'تأكيد كلمة المرور',
            'change_password' => 'تغيير كلمة المرور؟',
            'phone_placeholder' => 'الهاتف',
            'whatsapp_placeholder' => 'رقم واتساب',
        ],
    ],
    'vendor' => [
        'name' => 'البائعون',
        'view' => 'عرض :name',
        'information' => 'معلومات البائع',
        'total_cars' => 'إجمالي السيارات',
        'total_bookings' => 'إجمالي الحجوزات',
        'verified' => 'موثق',
        'not_verified' => 'غير موثق',
        'verification_section' => 'التحقق من البائع',
        'vendor_verified_successfully' => 'تم توثيق هذا البائع ويمكن الوثوق به.',
        'vendor_not_verified_yet' => 'لم يتم توثيق هذا البائع بعد.',
        'verification_pending' => 'التوثيق قيد الانتظار',
        'click_verify_to_approve' => 'انقر على الزر أدناه لتوثيق هذا البائع وعرض شارة التوثيق.',
        'verify_vendor' => 'توثيق البائع',
        'unverify_vendor' => 'إلغاء توثيق البائع',
        'verify_vendor_confirmation' => 'تأكيد توثيق البائع',
        'verify_vendor_confirmation_desc' => 'هل أنت متأكد من رغبتك في توثيق :name؟ سيؤدي هذا إلى عرض شارة التوثيق على ملفهم الشخصي.',
        'unverify_vendor_confirmation' => 'تأكيد إلغاء توثيق البائع',
        'unverify_vendor_confirmation_desc' => 'هل أنت متأكد من رغبتك في إزالة التوثيق من :name؟ سيتم إزالة شارة التوثيق.',
        'verified_successfully' => 'تم توثيق البائع بنجاح.',
        'unverified_successfully' => 'تم إلغاء توثيق البائع بنجاح.',
        'already_verified' => 'هذا البائع موثق بالفعل.',
        'not_verified_yet' => 'هذا البائع غير موثق بعد.',
        'recent_activity' => 'النشاط الأخير',
        'recent_cars' => 'السيارات الأخيرة',
        'recent_bookings' => 'الحجوزات الأخيرة',
        'no_cars_yet' => 'لم تتم إضافة أي سيارات بعد.',
        'no_bookings_yet' => 'لم يتم استلام أي حجوزات بعد.',
    ],
    'make' => [
        'name' => 'العلامات التجارية',
        'create' => 'إضافة علامة تجارية',
        'forms' => [
            'logo' => 'الشعار',
            'logo_dark' => 'الشعار الداكن',
        ],
    ],
    'car' => [
        'name' => 'السيارات',
        'create' => 'إضافة سيارة',
        'forms' => [
            'car' => 'السيارة',
            'logo' => 'الشعار',
            'license_plate' => 'لوحة الترخيص',
            'make' => 'العلامة التجارية',
            'model' => 'الموديل',
            'name' => 'الاسم',
            'images' => 'الصور',
            'year' => 'السنة',
            'color' => 'اللون',
            'mileage' => 'المسافة المقطوعة',
            'kilometers' => 'الكيلومترات',
            'horsepower' => 'قوة المحرك',
            'vehicle_type' => 'نوع المركبة',
            'transmission' => 'ناقل الحركة',
            'fuel_type' => 'نوع الوقود',
            'rental_rate' => 'سعر الإيجار',
            'currency' => 'العملة',
            'status' => 'الحالة',
            'availability' => 'التوفر',
            'insurance_info' => 'معلومات التأمين',
            'number_of_seats' => 'عدد المقاعد',
            'number_of_doors' => 'عدد الأبواب',
            'vin' => 'رقم الهيكل',
            'maintenance_history' => 'سجل الصيانة',
            'location' => 'الموقع',
            'description' => 'الوصف',
            'rental_type' => 'نوع الإيجار',
            'tags' => 'الوسوم',
            'add_new_attribute' => 'إضافة جديد <a href=\":url\" target=\"_blank\">هنا</a>.',
            'categories' => 'الفئات',
            'pick_address' => 'عنوان الاستلام',
            'return_address' => 'عنوان الإرجاع',
            'same_drop_off' => 'نفس مكان الإرجاع',
            'tax' => 'الضريبة',
            'select_tax' => 'اختر الضريبة',
            'none' => 'لا يوجد',
            'colors' => 'الألوان',
            'amenities' => 'المرافق',
            'is_used' => 'مستعمل؟',
            'moderation_status' => 'حالة المراجعة',
            'status_moderation' => [
                'approve' => 'قبول',
                'reject' => 'رفض',
                'approve_title' => 'قبول السيارة',
                'approve_message' => 'هل أنت متأكد من رغبتك في قبول هذه السيارة؟ لا يمكن التراجع عن هذا الإجراء.',
                'reject_title' => 'رفض السيارة',
                'reject_message' => 'هل أنت متأكد من رغبتك في رفض هذه السيارة؟ لا يمكن التراجع عن هذا الإجراء.',
                'reject_reason' => 'أدخل سبب الرفض',
                'approved' => 'تم قبول السيارة بنجاح!',
                'rejected' => 'تم رفض السيارة بنجاح!',
                'reason_rejected' => 'سبب الرفض',
            ],
            'customer' => 'العميل',
            'select_customer' => 'اختر عميلاً...',
            'vendor_images' => 'الصور (بحد أقصى :max صور)',
            'images_upload_placeholder' => 'قم بإفلات الملفات هنا أو انقر للتحميل.',
            'car_purpose' => 'الغرض من السيارة',
            'for_rent' => 'للإيجار',
            'for_sale' => 'للبيع',
            'car_type' => 'نوع السيارة',
            'rental_information' => 'معلومات الإيجار',
            'sale_statuses' => [
                'available' => 'متاح',
                'sold' => 'مباع',
                'reserved' => 'محجوز',
            ],
            'selling_information' => 'معلومات البيع',
            'is_for_sale' => 'متاح للبيع',
            'sale_price' => 'سعر البيع',
            'sale_price_placeholder' => 'أدخل سعر البيع',
            'condition' => 'الحالة',
            'select_condition' => 'اختر الحالة',
            'condition_options' => [
                'new' => 'جديد',
                'like_new' => 'مثل الجديد',
                'excellent' => 'ممتاز',
                'good' => 'جيد',
                'fair' => 'مقبول',
                'poor' => 'ضعيف',
            ],
            'ownership_history' => 'تاريخ الملكية',
            'ownership_history_placeholder' => 'أدخل تاريخ الملكية',
            'warranty_information' => 'معلومات الضمان',
            'warranty_information_placeholder' => 'أدخل معلومات الضمان',
            'sale_status' => 'حالة البيع',
            'external_booking_url' => 'رابط الحجز الخارجي',
            'external_booking_url_helper' => 'أدخل الرابط الخارجي حيث يمكن للعملاء حجز هذه السيارة خارج هذه المنصة. اتركه فارغاً إذا كان الحجز متاحاً فقط على هذا الموقع.',
            'address' => 'العنوان',
            'address_helper' => 'أدخل عنوان الشارع المحدد حيث توجد هذه المركبة',
        ],
        'car_purposes' => [
            'sale' => 'للبيع',
            'rent' => 'للإيجار',
        ],
        'placeholders' => [
            'name' => 'أدخل اسم المركبة (مثل: تويوتا كامري 2023، هوندا CR-V، إلخ)',
            'description' => 'أدخل وصفاً موجزاً للمركبة مع تسليط الضوء على الميزات الرئيسية',
            'rental_rate' => 'أدخل سعر الإيجار بناءً على نوع الإيجار المحدد',
            'location' => 'أدخل الموقع الفعلي للمركبة',
            'address' => 'أدخل عنوان الشارع المحدد (مثل: 123 شارع الرئيسي، المدينة، الولاية)',
            'sale_price' => 'أدخل سعر البيع لهذه المركبة',
            'ownership_history' => 'أدخل تفاصيل عن المالكين السابقين، عدد المالكين، إلخ.',
            'warranty_information' => 'أدخل تفاصيل عن تغطية الضمان، تاريخ انتهاء الصلاحية، إلخ.',
            'external_booking_url' => 'https://example.com/booking-link (رابط خارجي)',
            'license_plate' => 'أدخل رقم لوحة ترخيص المركبة',
            'vin' => 'أدخل رقم تعريف المركبة (VIN)',
            'year' => 'أدخل سنة التصنيع (مثل: 2023)',
            'mileage' => 'أدخل المسافة المقطوعة الحالية',
            'kilometers' => 'أدخل الكيلومترات الحالية',
            'horsepower' => 'أدخل قوة المحرك (HP) للمركبة (مثل: 150.5)',
            'number_of_seats' => 'أدخل عدد المقاعد في المركبة',
            'number_of_doors' => 'أدخل عدد أبواب المركبة',
            'insurance_info' => 'أدخل معلومات التأمين ذات الصلة لهذه المركبة',
            'tags' => 'اختر أو أنشئ وسوماً',
            'amenities' => 'اختر المرافق',
            'colors' => 'اختر أو أنشئ ألواناً',
        ],
        'enums' => [
            'vendor_status' => 'حالة البائع',
            'is_vendor' => 'بائع',
            'not_vendor' => 'عميل',
            'statuses' => [
                'available' => 'متاح',
                'rented' => 'مؤجر',
                'maintenance' => 'صيانة',
                'out_of_service' => 'خارج الخدمة',
            ],
            'rental_types' => [
                'per_hour' => 'بالساعة',
                'per_day' => 'باليوم',
                'per_week' => 'بالأسبوع',
                'per_month' => 'بالشهر',
            ],
            'moderation_statuses' => [
                'pending' => 'قيد الانتظار',
                'approved' => 'مقبول',
                'rejected' => 'مرفوض',
            ],
        ],
        'maintenance_history' => [
            'name' => 'سجلات الصيانة',
            'create' => 'إضافة سجل صيانة',
            'amount' => 'المبلغ',
            'forms' => [
                'price_placeholder' => 'سعر الخدمة',
                'currency' => 'العملة',
                'none' => 'لا يوجد',
                'name' => 'الاسم',
                'amount' => 'المبلغ',
                'created_at' => 'تاريخ الإنشاء',
                'action' => 'الإجراء',
                'date' => 'التاريخ',
                'no_maintenance_history' => 'لا توجد سجلات صيانة',
                'edit_maintenance_history' => 'تعديل سجل الصيانة',
                'add_maintenance_history' => 'إضافة سجل صيانة',
                'add' => 'إضافة',
                'edit' => 'تعديل',
                'delete' => 'حذف',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'خصائص السيارات',
        'car_type' => [
            'name' => 'الأنواع',
            'create' => 'إضافة نوع سيارة',
            'forms' => [
                'name' => 'الاسم',
            ],
        ],
        'transmission' => [
            'name' => 'ناقل الحركة',
            'create' => 'إضافة ناقل حركة',
            'forms' => [
                'name' => 'الاسم',
            ],
        ],
        'fuel_type' => [
            'name' => 'أنواع الوقود',
            'create' => 'إضافة نوع وقود',
            'forms' => [
                'name' => 'الاسم',
            ],
        ],
        'tag' => [
            'name' => 'الوسوم',
            'create' => 'إضافة وسم',
        ],
        'category' => [
            'name' => 'الفئات',
            'create' => 'إضافة فئة',
            'forms' => [
                'none' => 'لا يوجد',
                'total_cars' => 'إجمالي السيارات: :total',
            ],
        ],
        'address' => [
            'name' => 'المواقع',
            'create' => 'إضافة موقع سيارة',
            'form' => [
                'name' => 'العنوان',
                'full_address' => 'العنوان الكامل',
                'detail_address' => 'تفاصيل العنوان',
            ],
        ],
        'color' => [
            'name' => 'اللون',
            'create' => 'إضافة لون',
        ],
        'amenity' => [
            'name' => 'المرافق',
            'create' => 'إضافة مرفق',
        ],
    ],
    'tax' => [
        'name' => 'الضرائب',
        'create' => 'إضافة ضريبة',
        'forms' => [
            'name' => 'الاسم',
            'name_placeholder' => 'أدخل الاسم',
            'percentage' => 'النسبة المئوية',
            'percentage_placeholder' => 'النسبة المئوية',
            'percent_placeholder' => 'النسبة المئوية',
            'priority' => 'الأولوية',
            'priority_placeholder' => 'الأولوية',
        ],
    ],
    'review' => [
        'name' => 'التقييمات',
        'create' => 'إضافة تقييم',
        'edit' => 'تعديل التقييم',
        'vendor' => [
            'title' => 'تقييمات العملاء',
            'description' => 'إدارة جميع تقييمات العملاء لسياراتك',
            'no_reviews' => 'ليس لديك تقييمات بعد',
            'filter_by_car' => 'تصفية حسب السيارة',
            'filter_by_rating' => 'تصفية حسب التقييم',
            'filter_by_date' => 'تصفية حسب التاريخ',
            'all_cars' => 'جميع السيارات',
            'all_ratings' => 'جميع التقييمات',
            'manage_reviews' => 'إدارة التقييمات',
            'view_all' => 'عرض جميع التقييمات',
            'delete_review_confirmation' => 'هل أنت متأكد من رغبتك في حذف هذا التقييم؟',
            'delete_review_success' => 'تم حذف التقييم بنجاح',
            'cannot_delete' => 'لا يمكن حذف هذا التقييم',
        ],
        'forms' => [
            'customer' => 'العميل',
            'car' => 'السيارة',
            'content' => 'المحتوى',
            'rating' => 'التقييم',
            'your_name' => 'اسمك',
            'email_address' => 'عنوان البريد الإلكتروني',
            'submit' => 'إرسال',
            'star' => 'نجمة',
            'status' => 'الحالة',
            'created_at' => 'تاريخ الإنشاء',
            'select_car' => 'اختر سيارة',
            'select_rating' => 'اختر تقييماً',
            'comment' => 'تعليق',
            'reply' => 'رد',
            'reply_to_review' => 'الرد على التقييم',
            'save_reply' => 'حفظ الرد',
            'cancel_reply' => 'إلغاء',
        ],
        'statuses' => [
            'published' => 'منشور',
            'pending' => 'قيد الانتظار',
            'rejected' => 'مرفوض',
        ],
        'ratings' => [
            1 => 'نجمة واحدة - ضعيف',
            2 => 'نجمتان - مقبول',
            3 => '3 نجوم - جيد',
            4 => '4 نجوم - جيد جداً',
            5 => '5 نجوم - ممتاز',
        ],
    ],
    'coupon' => [
        'name' => 'القسائم',
        'create' => 'إضافة قسيمة',
        'types' => [
            'percentage' => 'نسبة مئوية %',
            'money' => 'مبلغ مالي',
        ],
        'forms' => [
        ],
    ],
    'service' => [
        'name' => 'الخدمات',
        'create' => 'إضافة خدمة',
        'forms' => [
            'name' => 'الاسم',
            'content' => 'المحتوى',
            'price' => 'السعر',
            'currency' => 'العملة',
            'image' => 'الصورة',
            'logo' => 'الشعار',
            'status' => 'الحالة',
        ],
    ],
    'availability_calendar' => [
        'name' => 'تقويم التوفر',
        'title' => 'تقويم التوفر',
        'description' => 'عرض توفر السيارات والحجوزات بتنسيق التقويم',
        'select_dates' => 'اختر التواريخ للتحقق من التوفر',
        'car_filter' => 'تصفية حسب السيارة',
        'all_cars' => 'جميع السيارات',
        'clear_filter' => 'مسح التصفية',
        'availability_check' => 'فحص توفر السيارة',
        'selected_period' => 'الفترة المحددة',
        'checking_availability' => 'جارٍ التحقق من التوفر...',
        'available' => 'متاح',
        'not_available' => 'غير متاح',
        'booking_details' => 'تفاصيل الحجز',
        'how_to_use' => 'كيفية استخدام تقويم توفر السيارات',
        'viewing_bookings' => 'عرض الحجوزات',
        'checking_availability_help' => 'التحقق من التوفر',
        'color_legend' => 'دليل الألوان',
        'pending_bookings' => 'الحجوزات قيد الانتظار',
        'processing_bookings' => 'الحجوزات قيد المعالجة',
        'completed_bookings' => 'الحجوزات المكتملة',
        'cancelled_bookings' => 'الحجوزات الملغاة',
        'unknown_make' => 'علامة تجارية غير معروفة',
        'loading' => 'جارٍ التحميل...',
        'loading_calendar_data' => 'جارٍ تحميل بيانات التقويم...',
        'loading_booking_details' => 'جارٍ تحميل تفاصيل الحجز...',
        'please_wait_booking_info' => 'يرجى الانتظار بينما نحصل على معلومات الحجز.',
        'please_wait_availability' => 'يرجى الانتظار بينما نتحقق من توفر السيارة للتواريخ المحددة.',
        'error' => 'خطأ',
        'error_loading_booking' => 'فشل تحميل تفاصيل الحجز. يرجى المحاولة مرة أخرى.',
        'error_checking_availability' => 'خطأ في التحقق من توفر السيارة',
        'customer' => 'العميل',
        'status' => 'الحالة',
        'amount' => 'المبلغ',
        'make' => 'العلامة التجارية',
        'vendor' => 'البائع',
        'per_day' => '/يوم',
        'edit_car' => 'تعديل السيارة',
        'no_cars_found' => 'لم يتم العثور على سيارات',
        'no_cars_available_period' => 'لا توجد سيارات متاحة للفترة المحددة.',
        'close' => 'إغلاق',
        'edit_booking' => 'تعديل الحجز',
        'pending' => 'قيد الانتظار',
        'processing' => 'قيد المعالجة',
        'completed' => 'مكتمل',
        'cancelled' => 'ملغى',
    ],
    'theme_options' => [
        'name' => 'تأجير السيارات',
        'description' => 'خيارات الثيم لتأجير السيارات',
        'car_location_filter_by' => 'تصفية موقع السيارة حسب',
        'state' => 'الولاية',
        'city' => 'المدينة',
        'yes' => 'نعم',
        'no' => 'لا',
        'is_display_country' => 'هل تريد عرض البلد في تصفية الموقع؟',
        'logo_vendor_dashboard' => 'الشعار في لوحة تحكم البائع (الافتراضي هو الشعار الرئيسي)',
        'number_of_cars_per_page' => 'عدد السيارات في كل صفحة',
        'number_of_cars_per_page_placeholder' => 'أدخل عدد السيارات لعرضها في كل صفحة',
    ],
    'message' => [
        'name' => 'الرسائل',
        'forms' => [
            'customer_name' => 'اسم العميل',
            'message' => 'الرسالة',
            'phone' => 'الهاتف',
            'email' => 'البريد الإلكتروني',
            'created_at' => 'تاريخ الإنشاء',
            'status' => 'الحالة',
        ],
    ],
    'car_sale' => [
        'name' => 'مبيعات السيارات',
        'create' => 'بيع سيارة جديد',
        'edit' => 'تعديل بيع السيارة :name',
        'statuses' => [
            'pending' => 'قيد الانتظار',
            'processing' => 'قيد المعالجة',
            'completed' => 'مكتمل',
            'cancelled' => 'ملغى',
        ],
        'forms' => [
            'transaction_id' => 'معرف المعاملة',
            'transaction_id_placeholder' => 'أدخل معرف المعاملة',
            'car_id' => 'السيارة',
            'car' => 'السيارة',
            'customer_id' => 'العميل',
            'customer_name' => 'اسم العميل',
            'customer_name_placeholder' => 'أدخل اسم العميل',
            'customer_email' => 'البريد الإلكتروني للعميل',
            'customer_email_placeholder' => 'أدخل البريد الإلكتروني للعميل',
            'customer_phone' => 'هاتف العميل',
            'customer_phone_placeholder' => 'أدخل هاتف العميل',
            'sale_price' => 'سعر البيع',
            'sale_price_placeholder' => 'أدخل سعر البيع',
            'tax_amount' => 'مبلغ الضريبة',
            'tax_amount_placeholder' => 'أدخل مبلغ الضريبة',
            'total_amount' => 'المبلغ الإجمالي',
            'total_amount_placeholder' => 'أدخل المبلغ الإجمالي',
            'payment_details' => 'تفاصيل الدفع',
            'payment_details_placeholder' => 'أدخل تفاصيل الدفع',
            'notes' => 'ملاحظات',
            'notes_placeholder' => 'أدخل الملاحظات',
            'sale_date' => 'تاريخ البيع',
            'delivery_date' => 'تاريخ التسليم',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'تحويل بنكي',
        'paypal' => 'باي بال',
    ],
    'email_templates' => [
        'booking_confirm_title' => 'تأكيد حجز تأجير السيارة',
        'booking_confirm_greeting' => 'عزيزي :customer_name،',
        'booking_confirm_message' => 'يسعدنا إبلاغك بأنه تم تأكيد حجز تأجير السيارة الخاص بك بنجاح!',
        'customer_information' => 'معلومات العميل',
        'booking_information' => 'معلومات الحجز',
        'field_name' => 'الاسم:',
        'field_phone' => 'الهاتف:',
        'field_email' => 'البريد الإلكتروني:',
        'field_car_model' => 'موديل السيارة:',
        'field_start_date' => 'تاريخ البداية:',
        'field_end_date' => 'تاريخ النهاية:',
        'field_pickup_address' => 'عنوان الاستلام:',
        'field_return_address' => 'عنوان الإرجاع:',
        'field_note' => 'ملاحظة:',
        'field_order_number' => 'رقم الطلب',
        'field_payment_method' => 'طريقة الدفع',
        'booking_notice_admin_title' => 'إشعار بحجز جديد',
        'booking_notice_admin_greeting' => 'مرحباً، هناك حجز جديد من :site_title:',
        'booking_notice_admin_message' => 'تم تقديم حجز تأجير سيارة جديد ويتطلب انتباهك.',
        'booking_view_detail' => 'عرض تفاصيل الحجز:',
        'view_booking_details' => 'عرض تفاصيل الحجز',
        'booking_notice_vendor_title' => 'حجز جديد لسيارتك',
        'booking_notice_vendor_greeting' => 'عزيزي :vendor_name،',
        'booking_notice_vendor_message' => 'أخبار رائعة! لقد تلقيت حجزاً جديداً لتأجير سيارتك.',
        'booking_status_updated' => 'تحديث حالة الحجز',
        'hello_thanks_for_booking' => 'مرحباً، شكراً لحجز الغرف من :site_title:',
        'booking_status_change_message' => 'نأمل أن تجدك هذه الرسالة بخير. أردنا إبلاغك بأنه تم تحديث حالة حجزك.',
        'name' => 'الاسم',
        'phone' => 'الهاتف',
        'email' => 'البريد الإلكتروني',
        'car_model' => 'موديل السيارة',
        'start_date' => 'تاريخ البداية',
        'end_date' => 'تاريخ النهاية',
        'pickup_address' => 'عنوان الاستلام',
        'return_address' => 'عنوان الإرجاع',
        'note' => 'ملاحظة',
        'order_number' => 'رقم الطلب',
        'payment_method' => 'طريقة الدفع',
        'hello' => 'مرحباً',
        'car_approved_title' => 'أخبار رائعة! تمت الموافقة على سيارتك',
        'car_approved_message' => 'يسرنا إبلاغك بأنه تمت الموافقة على إدراج سيارتك \":car_name\" وهي الآن مباشرة على :site_title. يمكنك البدء في تلقي الحجوزات وإدارة إدراجك على الفور.',
        'view_edit_car_link' => 'لعرض أو تعديل إدراج سيارتك، يرجى النقر على هذا الرابط',
        'view_car' => 'عرض إدراج السيارة',
        'regards' => 'أطيب التحيات',
        'vendor_upgrade_title' => 'مبروك! أنت الآن بائع',
        'vendor_upgrade_congratulations' => 'يسعدنا إبلاغك بأنه تمت ترقية حسابك إلى حالة البائع بنجاح!',
        'vendor_upgrade_message' => 'يمكنك الآن إدراج وإدارة سياراتك الخاصة على :site_title. هذا يفتح فرصاً جديدة لك لتنمية أعمال الإيجار الخاصة بك معنا.',
        'vendor_benefits_title' => 'مزايا البائع الجديدة الخاصة بك',
        'vendor_benefit_1' => 'إدراج سيارات غير محدودة للإيجار',
        'vendor_benefit_2' => 'إدارة الحجوزات والعملاء الخاصة بك',
        'vendor_benefit_3' => 'تتبع الإيرادات ومقاييس الأداء',
        'vendor_benefit_4' => 'الوصول إلى الميزات والأدوات الحصرية للبائعين',
        'next_steps' => 'الخطوات التالية',
        'vendor_next_steps_message' => 'قم بتسجيل الدخول إلى لوحة تحكم البائع الخاصة بك لبدء إضافة سياراتك وإدارة أعمال الإيجار الخاصة بك.',
        'go_to_dashboard' => 'الانتقال إلى لوحة تحكم البائع',
        'vendor_support_message' => 'إذا كان لديك أي أسئلة أو تحتاج إلى مساعدة، فريق الدعم لدينا هنا لمساعدتك على البدء.',
        'approved' => 'مقبول',
        'car_rejected_title' => 'مطلوب تحديث لإدراج سيارتك',
        'car_rejected_message' => 'شكراً لك على تقديم إدراج سيارتك \":car_name\" إلى :site_title. بعد مراجعة تقديمك، نحتاج منك إجراء بعض التعديلات قبل أن نتمكن من الموافقة عليه.',
        'rejection_reason' => 'إليك ما يحتاج إلى تحديث',
        'rejection_details' => 'التحديثات المطلوبة',
        'contact_support' => 'إذا كان لديك أي أسئلة أو تحتاج إلى مساعدة في هذه التحديثات، فلا تتردد في الاتصال بفريق الدعم لدينا على :site_email. نحن هنا لمساعدتك في الحصول على موافقة إدراجك بسرعة.',
        'verify_email' => 'التحقق من البريد الإلكتروني',
        'welcome_message' => 'نحن سعداء بوجودك هنا، :customer_name!',
        'verify_email_instruction' => 'يرجى التحقق من عنوان بريدك الإلكتروني للوصول إلى هذا الموقع. انقر على الزر أدناه للتحقق من بريدك الإلكتروني.',
        'confirm_email_button' => 'تأكيد عنوان بريدك الإلكتروني',
        'verify_link_trouble' => 'إذا كنت تواجه مشكلة في النقر على زر \'تأكيد عنوان بريدك الإلكتروني\'، انسخ والصق الرابط أدناه في متصفح الويب الخاص بك: :verify_link والصقه في متصفحك.',
        'new_message' => 'رسالة جديدة',
        'dear_admin' => 'عزيزي المسؤول',
        'new_message_from' => 'هناك رسالة جديدة من :site_title:',
        'subject' => 'الموضوع',
        'address' => 'العنوان',
        'content' => 'المحتوى',
        'hi_admin' => 'مرحباً المسؤول،',
        'new_car_pending_title' => 'إدراج سيارة جديد في انتظار المراجعة',
        'new_car_pending_approval' => 'تم تقديم إدراج سيارة جديد \":post_name\" بواسطة :post_author وهو جاهز للمراجعة.',
        'pending_approval' => 'في انتظار المراجعة',
        'review_car_admin' => 'يرجى مراجعة هذا الإدراج في لوحة الإدارة والموافقة عليه أو طلب تحديثات حسب الحاجة.',
        'car_information' => 'معلومات السيارة',
        'field_car_name' => 'اسم السيارة:',
        'field_author' => 'المؤلف:',
        'field_status' => 'الحالة:',
        'actions' => 'الإجراءات',
        'reset_password_instruction' => 'تعليمات إعادة تعيين كلمة المرور',
        'password_reset_request' => 'أنت تتلقى هذا البريد الإلكتروني لأننا تلقينا طلب إعادة تعيين كلمة المرور لحسابك.',
        'reset_password_button' => 'إعادة تعيين كلمة المرور',
        'reset_link_trouble' => 'إذا كنت تواجه مشكلة في النقر على زر \'إعادة تعيين كلمة المرور\'، انسخ والصق الرابط أدناه في متصفح الويب الخاص بك: :reset_link والصقه في متصفحك. إذا لم تطلب إعادة تعيين كلمة المرور، فيرجى تجاهل هذه الرسالة أو الاتصال بنا إذا كان لديك أي أسئلة.',
    ],
    'icon' => 'الأيقونة',
    'cars' => [
        'forms' => [
            'status_moderation' => [
                'reason_rejected' => 'سبب الرفض',
            ],
        ],
    ],
    'settings' => [
        'withdrawal_fee_types' => [
            'label' => 'أنواع رسوم السحب',
            'fixed' => 'مبلغ ثابت',
            'percentage' => 'نسبة مئوية',
        ],
    ],
];
