<?php

return [
    'name' => 'গাড়ি ভাড়া',
    'customer' => [
        'name' => 'গ্রাহকগণ',
        'create' => 'গ্রাহক তৈরি করুন',
        'view' => 'দেখুন',
        'information' => 'গ্রাহক তথ্য',
        'email' => 'ইমেইল',
        'phone' => 'ফোন',
        'status' => 'অবস্থা',
        'vendor_status' => 'বিক্রেতা অবস্থা',
        'is_vendor' => 'বিক্রেতা',
        'not_vendor' => 'গ্রাহক',
        'recent_activity' => 'সাম্প্রতিক কার্যকলাপ',
        'recent_activity_description' => 'গ্রাহক কার্যকলাপ এখানে প্রদর্শিত হবে।',
        'verification_section' => 'গ্রাহক যাচাইকরণ',
        'verified' => 'যাচাইকৃত',
        'not_verified' => 'যাচাইকৃত নয়',
        'verified_by' => 'যাচাইকারী',
        'verified_at' => 'যাচাইয়ের সময়',
        'verify_customer' => 'গ্রাহক যাচাই করুন',
        'unverify_customer' => 'গ্রাহক যাচাই বাতিল করুন',
        'verify_customer_confirmation' => 'গ্রাহক যাচাইকরণ নিশ্চিতকরণ',
        'verify_customer_confirmation_desc' => 'আপনি কি নিশ্চিত যে আপনি :name যাচাই করতে চান? এটি তাদের প্রোফাইলে একটি যাচাইকৃত ব্যাজ প্রদর্শন করবে।',
        'unverify_customer_confirmation' => 'গ্রাহক যাচাই বাতিল নিশ্চিতকরণ',
        'unverify_customer_confirmation_desc' => 'আপনি কি নিশ্চিত যে আপনি :name থেকে যাচাইকরণ সরাতে চান? যাচাইকৃত ব্যাজ সরানো হবে।',
        'verify_success' => 'গ্রাহক :name সফলভাবে যাচাই করা হয়েছে।',
        'unverify_success' => 'গ্রাহক :name যাচাইকরণ সফলভাবে সরানো হয়েছে।',
        'already_verified' => 'এই গ্রাহক ইতিমধ্যে যাচাইকৃত।',
        'already_unverified' => 'এই গ্রাহক যাচাইকৃত নয়।',
        'upgrade_to_vendor_title' => 'বিক্রেতায় আপগ্রেড করুন',
        'upgrade_to_vendor_description' => 'এই গ্রাহককে বিক্রেতা স্ট্যাটাসে আপগ্রেড করুন যাতে তারা তাদের নিজস্ব গাড়ি ভাড়া তালিকাভুক্ত এবং পরিচালনা করতে পারে।',
        'upgrade_to_vendor_button' => 'বিক্রেতায় আপগ্রেড করুন',
        'upgrade_to_vendor_confirmation' => 'বিক্রেতায় আপগ্রেড নিশ্চিত করুন',
        'upgrade_to_vendor_confirmation_desc' => 'আপনি কি নিশ্চিত যে আপনি :name কে বিক্রেতা স্ট্যাটাসে আপগ্রেড করতে চান? এটি তাদের প্ল্যাটফর্মে তাদের নিজস্ব গাড়ি তালিকাভুক্ত এবং পরিচালনা করার অনুমতি দেবে।',
        'upgrade_to_vendor_success' => ':name সফলভাবে বিক্রেতা স্ট্যাটাসে আপগ্রেড করা হয়েছে।',
        'already_vendor' => 'এই গ্রাহক ইতিমধ্যে একজন বিক্রেতা।',
        'customer_verified_successfully' => 'এই গ্রাহক যাচাই করা হয়েছে এবং বিশ্বাসযোগ্য।',
        'customer_not_verified_yet' => 'এই গ্রাহক এখনও যাচাই করা হয়নি।',
        'verification_pending' => 'যাচাইকরণ মুলতুবি',
        'click_verify_to_approve' => 'এই গ্রাহককে যাচাই করতে এবং যাচাইকৃত ব্যাজ প্রদর্শন করতে নিচের বোতামে ক্লিক করুন।',
        'verification_note' => 'যাচাইকরণ নোট',
        'verification_note_placeholder' => 'এই যাচাইকরণ কর্ম সম্পর্কে যেকোনো নোট লিখুন...',
        'verification_note_helper' => 'যাচাইকরণ প্রক্রিয়া সম্পর্কে নোট যোগ করুন (শুধুমাত্র অভ্যন্তরীণ ব্যবহারের জন্য)',
        'forms' => [
            'name' => 'নাম',
            'email' => 'ইমেইল',
            'phone' => 'ফোন',
            'avatar' => 'অবতার',
            'dob' => 'জন্ম তারিখ',
            'company' => 'কোম্পানি',
            'position' => 'পদবি',
            'password' => 'পাসওয়ার্ড',
            'password_confirmation' => 'পাসওয়ার্ড নিশ্চিতকরণ',
            'change_password' => 'পাসওয়ার্ড পরিবর্তন করবেন?',
            'phone_placeholder' => 'ফোন',
        ],
    ],
    'vendor' => [
        'name' => 'বিক্রেতাগণ',
        'view' => 'দেখুন :name',
        'information' => 'বিক্রেতা তথ্য',
        'total_cars' => 'মোট গাড়ি',
        'total_bookings' => 'মোট বুকিং',
        'verified' => 'যাচাইকৃত',
        'not_verified' => 'যাচাইকৃত নয়',
        'verification_section' => 'বিক্রেতা যাচাইকরণ',
        'vendor_verified_successfully' => 'এই বিক্রেতা যাচাই করা হয়েছে এবং বিশ্বাসযোগ্য।',
        'vendor_not_verified_yet' => 'এই বিক্রেতা এখনও যাচাই করা হয়নি।',
        'verification_pending' => 'যাচাইকরণ মুলতুবি',
        'click_verify_to_approve' => 'এই বিক্রেতাকে যাচাই করতে এবং যাচাইকৃত ব্যাজ প্রদর্শন করতে নিচের বোতামে ক্লিক করুন।',
        'verify_vendor' => 'বিক্রেতা যাচাই করুন',
        'unverify_vendor' => 'বিক্রেতা যাচাই বাতিল করুন',
        'verify_vendor_confirmation' => 'বিক্রেতা যাচাইকরণ নিশ্চিতকরণ',
        'verify_vendor_confirmation_desc' => 'আপনি কি নিশ্চিত যে আপনি :name যাচাই করতে চান? এটি তাদের প্রোফাইলে একটি যাচাইকৃত ব্যাজ প্রদর্শন করবে।',
        'unverify_vendor_confirmation' => 'বিক্রেতা যাচাই বাতিল নিশ্চিতকরণ',
        'unverify_vendor_confirmation_desc' => 'আপনি কি নিশ্চিত যে আপনি :name থেকে যাচাইকরণ সরাতে চান? যাচাইকৃত ব্যাজ সরানো হবে।',
        'verified_successfully' => 'বিক্রেতা সফলভাবে যাচাই করা হয়েছে।',
        'unverified_successfully' => 'বিক্রেতা যাচাইকরণ সফলভাবে সরানো হয়েছে।',
        'already_verified' => 'এই বিক্রেতা ইতিমধ্যে যাচাইকৃত।',
        'not_verified_yet' => 'এই বিক্রেতা এখনও যাচাই করা হয়নি।',
        'recent_activity' => 'সাম্প্রতিক কার্যকলাপ',
        'recent_cars' => 'সাম্প্রতিক গাড়ি',
        'recent_bookings' => 'সাম্প্রতিক বুকিং',
        'no_cars_yet' => 'এখনও কোন গাড়ি যোগ করা হয়নি।',
        'no_bookings_yet' => 'এখনও কোন বুকিং প্রাপ্ত হয়নি।',
    ],
    'make' => [
        'name' => 'ব্র্যান্ড',
        'create' => 'গাড়ির ব্র্যান্ড তৈরি করুন',
        'forms' => [
            'logo' => 'লোগো',
            'logo_dark' => 'ডার্ক লোগো',
        ],
    ],
    'car' => [
        'name' => 'গাড়ি',
        'create' => 'গাড়ি তৈরি করুন',
        'forms' => [
            'car' => 'গাড়ি',
            'logo' => 'লোগো',
            'license_plate' => 'লাইসেন্স প্লেট',
            'make' => 'ব্র্যান্ড',
            'model' => 'মডেল',
            'name' => 'নাম',
            'images' => 'ছবি',
            'year' => 'বছর',
            'color' => 'রঙ',
            'mileage' => 'মাইলেজ',
            'kilometers' => 'কিলোমিটার',
            'horsepower' => 'হর্সপাওয়ার',
            'vehicle_type' => 'গাড়ির ধরন',
            'transmission' => 'ট্রান্সমিশন',
            'fuel_type' => 'জ্বালানির ধরন',
            'rental_rate' => 'ভাড়ার হার',
            'currency' => 'মুদ্রা',
            'status' => 'অবস্থা',
            'availability' => 'উপলব্ধতা',
            'insurance_info' => 'বীমা তথ্য',
            'number_of_seats' => 'আসন সংখ্যা',
            'number_of_doors' => 'দরজা সংখ্যা',
            'vin' => 'VIN',
            'maintenance_history' => 'রক্ষণাবেক্ষণ ইতিহাস',
            'location' => 'অবস্থান',
            'description' => 'বর্ণনা',
            'rental_type' => 'ভাড়ার ধরন',
            'tags' => 'ট্যাগ',
            'add_new_attribute' => '<a href=":url" target="_blank">এখানে</a> নতুন যোগ করুন।',
            'categories' => 'বিভাগসমূহ',
            'pick_address' => 'পিকআপ ঠিকানা',
            'return_address' => 'ফেরত ঠিকানা',
            'same_drop_off' => 'একই ড্রপ-অফ',
            'tax' => 'কর',
            'select_tax' => 'কর নির্বাচন করুন',
            'none' => 'কিছু নেই',
            'colors' => 'রঙসমূহ',
            'amenities' => 'সুবিধাসমূহ',
            'is_used' => 'ব্যবহৃত?',
            'moderation_status' => 'মডারেশন অবস্থা',
            'status_moderation' => [
                'approve' => 'অনুমোদন করুন',
                'reject' => 'প্রত্যাখ্যান করুন',
                'approve_title' => 'গাড়ি অনুমোদন করুন',
                'approve_message' => 'আপনি কি নিশ্চিত যে আপনি এই গাড়িটি অনুমোদন করতে চান? এই কর্মটি পূর্বাবস্থায় ফেরানো যাবে না।',
                'reject_title' => 'গাড়ি প্রত্যাখ্যান করুন',
                'reject_message' => 'আপনি কি নিশ্চিত যে আপনি এই গাড়িটি প্রত্যাখ্যান করতে চান? এই কর্মটি পূর্বাবস্থায় ফেরানো যাবে না।',
                'reject_reason' => 'প্রত্যাখ্যানের কারণ লিখুন',
                'approved' => 'গাড়ি সফলভাবে অনুমোদিত হয়েছে!',
                'rejected' => 'গাড়ি সফলভাবে প্রত্যাখ্যান করা হয়েছে!',
                'reason_rejected' => 'প্রত্যাখ্যানের কারণ',
            ],
            'customer' => 'গ্রাহক',
            'select_customer' => 'একটি গ্রাহক নির্বাচন করুন...',
            'vendor_images' => 'ছবি (সর্বোচ্চ :max টি ছবি)',
            'images_upload_placeholder' => 'ফাইল এখানে ড্রপ করুন বা আপলোড করতে ক্লিক করুন।',
            'car_purpose' => 'গাড়ির উদ্দেশ্য',
            'for_rent' => 'ভাড়ার জন্য',
            'for_sale' => 'বিক্রয়ের জন্য',
            'car_type' => 'গাড়ির ধরন',
            'rental_information' => 'ভাড়া তথ্য',
            'sale_statuses' => [
                'available' => 'উপলব্ধ',
                'sold' => 'বিক্রিত',
                'reserved' => 'সংরক্ষিত',
            ],
            'selling_information' => 'বিক্রয় তথ্য',
            'is_for_sale' => 'বিক্রয়ের জন্য উপলব্ধ',
            'sale_price' => 'বিক্রয় মূল্য',
            'sale_price_placeholder' => 'বিক্রয় মূল্য লিখুন',
            'condition' => 'অবস্থা',
            'select_condition' => 'অবস্থা নির্বাচন করুন',
            'condition_options' => [
                'new' => 'নতুন',
                'like_new' => 'নতুনের মত',
                'excellent' => 'চমৎকার',
                'good' => 'ভাল',
                'fair' => 'মোটামুটি',
                'poor' => 'খারাপ',
            ],
            'ownership_history' => 'মালিকানা ইতিহাস',
            'ownership_history_placeholder' => 'মালিকানা ইতিহাস লিখুন',
            'warranty_information' => 'ওয়ারেন্টি তথ্য',
            'warranty_information_placeholder' => 'ওয়ারেন্টি তথ্য লিখুন',
            'sale_status' => 'বিক্রয় অবস্থা',
            'external_booking_url' => 'বাহ্যিক বুকিং লিঙ্ক',
            'external_booking_url_helper' => 'বাহ্যিক URL লিখুন যেখানে গ্রাহকরা এই প্ল্যাটফর্মের বাইরে এই গাড়ি বুক করতে পারে। শুধুমাত্র এই সাইটে বুকিং উপলব্ধ থাকলে খালি রাখুন।',
            'address' => 'ঠিকানা',
            'address_helper' => 'এই যানবাহন যেখানে অবস্থিত সেই নির্দিষ্ট রাস্তার ঠিকানা লিখুন',
        ],
        'car_purposes' => [
            'sale' => 'বিক্রয়ের জন্য',
            'rent' => 'ভাড়ার জন্য',
        ],
        'placeholders' => [
            'name' => 'যানবাহনের নাম লিখুন (যেমন, টয়োটা ক্যামরি 2023, হোন্ডা CR-V, ইত্যাদি)',
            'description' => 'মূল বৈশিষ্ট্য তুলে ধরে যানবাহনের একটি সংক্ষিপ্ত বর্ণনা লিখুন',
            'rental_rate' => 'নির্বাচিত ভাড়ার ধরনের উপর ভিত্তি করে ভাড়ার হার লিখুন',
            'location' => 'যানবাহনের ভৌত অবস্থান লিখুন',
            'address' => 'নির্দিষ্ট রাস্তার ঠিকানা লিখুন (যেমন, 123 মেইন স্ট্রিট, শহর, রাজ্য)',
            'sale_price' => 'এই যানবাহনের বিক্রয় মূল্য লিখুন',
            'ownership_history' => 'পূর্ববর্তী মালিক, মালিকদের সংখ্যা ইত্যাদি সম্পর্কে বিবরণ লিখুন',
            'warranty_information' => 'ওয়ারেন্টি কভারেজ, মেয়াদ শেষের তারিখ ইত্যাদি সম্পর্কে বিবরণ লিখুন',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'যানবাহন লাইসেন্স প্লেট নম্বর লিখুন',
            'vin' => 'যানবাহন শনাক্তকরণ নম্বর (VIN) লিখুন',
            'year' => 'উৎপাদন বছর লিখুন (যেমন, 2023)',
            'mileage' => 'বর্তমান মাইলেজ লিখুন',
            'kilometers' => 'বর্তমান কিলোমিটার লিখুন',
            'horsepower' => 'যানবাহনের হর্সপাওয়ার (HP) লিখুন (যেমন, 150.5)',
            'number_of_seats' => 'যানবাহনে আসন সংখ্যা লিখুন',
            'number_of_doors' => 'যানবাহনের দরজা সংখ্যা লিখুন',
            'insurance_info' => 'এই যানবাহনের জন্য প্রাসঙ্গিক বীমা তথ্য লিখুন',
            'tags' => 'ট্যাগ নির্বাচন বা তৈরি করুন',
            'amenities' => 'সুবিধা নির্বাচন করুন',
            'colors' => 'রঙ নির্বাচন বা তৈরি করুন',
        ],
        'enums' => [
            'vendor_status' => 'বিক্রেতা অবস্থা',
            'is_vendor' => 'বিক্রেতা',
            'not_vendor' => 'গ্রাহক',
            'statuses' => [
                'available' => 'উপলব্ধ',
                'rented' => 'ভাড়া দেওয়া',
                'maintenance' => 'রক্ষণাবেক্ষণ',
                'out_of_service' => 'সেবার বাইরে',
            ],
            'rental_types' => [
                'per_hour' => 'প্রতি ঘন্টা',
                'per_day' => 'প্রতিদিন',
                'per_week' => 'প্রতি সপ্তাহ',
                'per_month' => 'প্রতি মাস',
            ],
            'moderation_statuses' => [
                'pending' => 'মুলতুবি',
                'approved' => 'অনুমোদিত',
                'rejected' => 'প্রত্যাখ্যাত',
            ],
        ],
        'maintenance_history' => [
            'name' => 'রক্ষণাবেক্ষণ ইতিহাস',
            'create' => 'সেবা ইতিহাস তৈরি করুন',
            'amount' => 'পরিমাণ',
            'forms' => [
                'price_placeholder' => 'সেবা মূল্য',
                'currency' => 'মুদ্রা',
                'none' => 'কিছু নেই',
                'name' => 'নাম',
                'amount' => 'পরিমাণ',
                'created_at' => 'তৈরির সময়',
                'action' => 'কর্ম',
                'date' => 'তারিখ',
                'no_maintenance_history' => 'কোন রক্ষণাবেক্ষণ ইতিহাস নেই',
                'edit_maintenance_history' => 'রক্ষণাবেক্ষণ ইতিহাস সম্পাদনা করুন',
                'add_maintenance_history' => 'রক্ষণাবেক্ষণ ইতিহাস যোগ করুন',
                'add' => 'যোগ করুন',
                'edit' => 'সম্পাদনা',
                'delete' => 'মুছুন',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'গাড়ির বৈশিষ্ট্য',
        'car_type' => [
            'name' => 'ধরনসমূহ',
            'create' => 'গাড়ির ধরন তৈরি করুন',
            'forms' => [
                'name' => 'নাম',
            ],
        ],
        'transmission' => [
            'name' => 'ট্রান্সমিশন',
            'create' => 'ট্রান্সমিশন তৈরি করুন',
            'forms' => [
                'name' => 'নাম',
            ],
        ],
        'fuel_type' => [
            'name' => 'জ্বালানি',
            'create' => 'জ্বালানির ধরন তৈরি করুন',
            'forms' => [
                'name' => 'নাম',
            ],
        ],
        'tag' => [
            'name' => 'ট্যাগসমূহ',
            'create' => 'ট্যাগ তৈরি করুন',
        ],
        'category' => [
            'name' => 'বিভাগসমূহ',
            'create' => 'বিভাগ তৈরি করুন',
            'forms' => [
                'none' => 'কিছু নেই',
                'total_cars' => 'মোট গাড়ি: :total',
            ],
        ],
        'address' => [
            'name' => 'অবস্থানসমূহ',
            'create' => 'গাড়ির অবস্থান তৈরি করুন',
            'form' => [
                'name' => 'ঠিকানা',
                'full_address' => 'সম্পূর্ণ ঠিকানা',
                'detail_address' => 'বিস্তারিত ঠিকানা',
            ],
        ],
        'color' => [
            'name' => 'রঙ',
            'create' => 'রঙ তৈরি করুন',
        ],
        'amenity' => [
            'name' => 'সুবিধাসমূহ',
            'create' => 'সুবিধা তৈরি করুন',
        ],
    ],
    'tax' => [
        'name' => 'করসমূহ',
        'create' => 'কর তৈরি করুন',
        'forms' => [
            'name' => 'নাম',
            'name_placeholder' => 'নাম লিখুন',
            'percentage' => 'শতাংশ',
            'percentage_placeholder' => 'শতাংশ',
            'percent_placeholder' => 'শতাংশ',
            'priority' => 'অগ্রাধিকার',
            'priority_placeholder' => 'অগ্রাধিকার',
        ],
    ],
    'review' => [
        'name' => 'রিভিউ',
        'create' => 'রিভিউ তৈরি করুন',
        'edit' => 'রিভিউ সম্পাদনা করুন',
        'vendor' => [
            'title' => 'গ্রাহক রিভিউ',
            'description' => 'আপনার গাড়ির জন্য সমস্ত গ্রাহক রিভিউ পরিচালনা করুন',
            'no_reviews' => 'আপনার এখনও কোন রিভিউ নেই',
            'filter_by_car' => 'গাড়ি অনুযায়ী ফিল্টার করুন',
            'filter_by_rating' => 'রেটিং অনুযায়ী ফিল্টার করুন',
            'filter_by_date' => 'তারিখ অনুযায়ী ফিল্টার করুন',
            'all_cars' => 'সব গাড়ি',
            'all_ratings' => 'সব রেটিং',
            'manage_reviews' => 'রিভিউ পরিচালনা করুন',
            'view_all' => 'সব রিভিউ দেখুন',
            'delete_review_confirmation' => 'আপনি কি নিশ্চিত যে আপনি এই রিভিউ মুছতে চান?',
            'delete_review_success' => 'রিভিউ সফলভাবে মুছে ফেলা হয়েছে',
            'cannot_delete' => 'এই রিভিউ মুছা যাচ্ছে না',
        ],
        'forms' => [
            'customer' => 'গ্রাহক',
            'car' => 'গাড়ি',
            'content' => 'বিষয়বস্তু',
            'rating' => 'রেটিং',
            'your_name' => 'আপনার নাম',
            'email_address' => 'ইমেইল ঠিকানা',
            'submit' => 'জমা দিন',
            'star' => 'তারকা',
            'status' => 'অবস্থা',
            'created_at' => 'তৈরির সময়',
            'select_car' => 'গাড়ি নির্বাচন করুন',
            'select_rating' => 'রেটিং নির্বাচন করুন',
            'comment' => 'মন্তব্য',
            'reply' => 'উত্তর',
            'reply_to_review' => 'রিভিউতে উত্তর দিন',
            'save_reply' => 'উত্তর সংরক্ষণ করুন',
            'cancel_reply' => 'বাতিল',
        ],
        'statuses' => [
            'published' => 'প্রকাশিত',
            'pending' => 'মুলতুবি',
            'rejected' => 'প্রত্যাখ্যাত',
        ],
        'ratings' => [
            '1' => '১ তারকা - খারাপ',
            '2' => '২ তারকা - মোটামুটি',
            '3' => '৩ তারকা - ভাল',
            '4' => '৪ তারকা - অতি ভাল',
            '5' => '৫ তারকা - চমৎকার',
        ],
    ],
    'coupon' => [
        'name' => 'কুপন',
        'create' => 'কুপন তৈরি করুন',
        'types' => [
            'percentage' => 'শতাংশ %',
            'money' => 'টাকা',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'সেবাসমূহ',
        'create' => 'সেবা তৈরি করুন',
        'forms' => [
            'name' => 'নাম',
            'content' => 'বিষয়বস্তু',
            'price' => 'মূল্য',
            'currency' => 'মুদ্রা',
            'image' => 'ছবি',
            'logo' => 'লোগো',
            'status' => 'অবস্থা',
        ],
    ],
    'availability_calendar' => [
        'name' => 'উপলব্ধতা ক্যালেন্ডার',
        'title' => 'উপলব্ধতা ক্যালেন্ডার',
        'description' => 'ক্যালেন্ডার ফর্ম্যাটে গাড়ির উপলব্ধতা এবং বুকিং দেখুন',
        'select_dates' => 'উপলব্ধতা পরীক্ষা করতে তারিখ নির্বাচন করুন',
        'car_filter' => 'গাড়ি অনুযায়ী ফিল্টার করুন',
        'all_cars' => 'সব গাড়ি',
        'clear_filter' => 'ফিল্টার সাফ করুন',
        'availability_check' => 'গাড়ির উপলব্ধতা যাচাই',
        'selected_period' => 'নির্বাচিত সময়কাল',
        'checking_availability' => 'উপলব্ধতা পরীক্ষা করা হচ্ছে...',
        'available' => 'উপলব্ধ',
        'not_available' => 'উপলব্ধ নয়',
        'booking_details' => 'বুকিং বিবরণ',
        'how_to_use' => 'কিভাবে গাড়ির উপলব্ধতা ক্যালেন্ডার ব্যবহার করবেন',
        'viewing_bookings' => 'বুকিং দেখা',
        'checking_availability_help' => 'উপলব্ধতা পরীক্ষা করা',
        'color_legend' => 'রঙ কিংবদন্তি',
        'pending_bookings' => 'মুলতুবি বুকিং',
        'processing_bookings' => 'প্রক্রিয়াধীন বুকিং',
        'completed_bookings' => 'সম্পন্ন বুকিং',
        'cancelled_bookings' => 'বাতিল বুকিং',
        'unknown_make' => 'অজানা ব্র্যান্ড',
        'loading' => 'লোড হচ্ছে...',
        'loading_calendar_data' => 'ক্যালেন্ডার ডেটা লোড হচ্ছে...',
        'loading_booking_details' => 'বুকিং বিবরণ লোড হচ্ছে...',
        'please_wait_booking_info' => 'বুকিং তথ্য আনার সময় অনুগ্রহ করে অপেক্ষা করুন।',
        'please_wait_availability' => 'আপনার নির্বাচিত তারিখের জন্য গাড়ির উপলব্ধতা পরীক্ষা করার সময় অনুগ্রহ করে অপেক্ষা করুন।',
        'error' => 'ত্রুটি',
        'error_loading_booking' => 'বুকিং বিবরণ লোড করতে ব্যর্থ। অনুগ্রহ করে আবার চেষ্টা করুন।',
        'error_checking_availability' => 'গাড়ির উপলব্ধতা পরীক্ষা করতে ত্রুটি',
        'customer' => 'গ্রাহক',
        'status' => 'অবস্থা',
        'amount' => 'পরিমাণ',
        'make' => 'ব্র্যান্ড',
        'vendor' => 'বিক্রেতা',
        'per_day' => '/দিন',
        'edit_car' => 'গাড়ি সম্পাদনা করুন',
        'no_cars_found' => 'কোন গাড়ি পাওয়া যায়নি',
        'no_cars_available_period' => 'নির্বাচিত সময়কালের জন্য কোন গাড়ি উপলব্ধ নেই।',
        'close' => 'বন্ধ করুন',
        'edit_booking' => 'বুকিং সম্পাদনা করুন',
        'pending' => 'মুলতুবি',
        'processing' => 'প্রক্রিয়াধীন',
        'completed' => 'সম্পন্ন',
        'cancelled' => 'বাতিল',
    ],
    'theme_options' => [
        'name' => 'গাড়ি ভাড়া',
        'description' => 'গাড়ি ভাড়ার জন্য থিম অপশন',
        'car_location_filter_by' => 'গাড়ির অবস্থান ফিল্টার করুন',
        'state' => 'রাজ্য',
        'city' => 'শহর',
        'yes' => 'হ্যাঁ',
        'no' => 'না',
        'is_display_country' => 'অবস্থান ফিল্টারে দেশ প্রদর্শন করবেন?',
        'logo_vendor_dashboard' => 'বিক্রেতা ড্যাশবোর্ডে লোগো (ডিফল্ট হল মূল লোগো)',
        'number_of_cars_per_page' => 'প্রতি পৃষ্ঠায় গাড়ির সংখ্যা',
        'number_of_cars_per_page_placeholder' => 'প্রতি পৃষ্ঠায় প্রদর্শনের জন্য গাড়ির সংখ্যা লিখুন',
    ],
    'message' => [
        'name' => 'বার্তা',
        'forms' => [
            'customer_name' => 'গ্রাহকের নাম',
            'message' => 'বার্তা',
            'phone' => 'ফোন',
            'email' => 'ইমেইল',
            'created_at' => 'তৈরির সময়',
            'status' => 'অবস্থা',
        ],
    ],
    'car_sale' => [
        'name' => 'গাড়ি বিক্রয়',
        'create' => 'নতুন গাড়ি বিক্রয়',
        'edit' => 'গাড়ি বিক্রয় সম্পাদনা :name',
        'statuses' => [
            'pending' => 'মুলতুবি',
            'processing' => 'প্রক্রিয়াধীন',
            'completed' => 'সম্পন্ন',
            'cancelled' => 'বাতিল',
        ],
        'forms' => [
            'transaction_id' => 'লেনদেন আইডি',
            'transaction_id_placeholder' => 'লেনদেন আইডি লিখুন',
            'car_id' => 'গাড়ি',
            'car' => 'গাড়ি',
            'customer_id' => 'গ্রাহক',
            'customer_name' => 'গ্রাহকের নাম',
            'customer_name_placeholder' => 'গ্রাহকের নাম লিখুন',
            'customer_email' => 'গ্রাহক ইমেইল',
            'customer_email_placeholder' => 'গ্রাহক ইমেইল লিখুন',
            'customer_phone' => 'গ্রাহক ফোন',
            'customer_phone_placeholder' => 'গ্রাহক ফোন লিখুন',
            'sale_price' => 'বিক্রয় মূল্য',
            'sale_price_placeholder' => 'বিক্রয় মূল্য লিখুন',
            'tax_amount' => 'কর পরিমাণ',
            'tax_amount_placeholder' => 'কর পরিমাণ লিখুন',
            'total_amount' => 'মোট পরিমাণ',
            'total_amount_placeholder' => 'মোট পরিমাণ লিখুন',
            'payment_details' => 'পেমেন্ট বিবরণ',
            'payment_details_placeholder' => 'পেমেন্ট বিবরণ লিখুন',
            'notes' => 'নোট',
            'notes_placeholder' => 'নোট লিখুন',
            'sale_date' => 'বিক্রয় তারিখ',
            'delivery_date' => 'ডেলিভারি তারিখ',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'ব্যাংক ট্রান্সফার',
        'paypal' => 'পেপ্যাল',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'গাড়ি ভাড়া বুকিং নিশ্চিতকরণ',
        'booking_confirm_greeting' => 'প্রিয় :customer_name,',
        'booking_confirm_message' => 'আমরা আপনাকে জানাতে পেরে আনন্দিত যে আপনার গাড়ি ভাড়া বুকিং সফলভাবে নিশ্চিত করা হয়েছে!',
        'customer_information' => 'গ্রাহক তথ্য',
        'booking_information' => 'বুকিং তথ্য',
        'field_name' => 'নাম:',
        'field_phone' => 'ফোন:',
        'field_email' => 'ইমেইল:',
        'field_car_model' => 'গাড়ির মডেল:',
        'field_start_date' => 'শুরুর তারিখ:',
        'field_end_date' => 'শেষ তারিখ:',
        'field_pickup_address' => 'পিকআপ ঠিকানা:',
        'field_return_address' => 'ফেরত ঠিকানা:',
        'field_note' => 'নোট:',
        'field_order_number' => 'অর্ডার নম্বর',
        'field_payment_method' => 'পেমেন্ট পদ্ধতি',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'নতুন বুকিং বিজ্ঞপ্তি',
        'booking_notice_admin_greeting' => 'হ্যালো, :site_title থেকে একটি নতুন বুকিং আছে:',
        'booking_notice_admin_message' => 'একটি নতুন গাড়ি ভাড়া বুকিং জমা দেওয়া হয়েছে এবং আপনার মনোযোগের প্রয়োজন।',
        'booking_view_detail' => 'বুকিং বিবরণ দেখুন:',
        'view_booking_details' => 'বুকিং বিবরণ দেখুন',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'আপনার গাড়ির জন্য নতুন বুকিং',
        'booking_notice_vendor_greeting' => 'প্রিয় :vendor_name,',
        'booking_notice_vendor_message' => 'দারুণ খবর! আপনার গাড়ি ভাড়ার জন্য একটি নতুন বুকিং এসেছে।',

        // Booking status changed email
        'booking_status_updated' => 'বুকিং অবস্থা আপডেট করা হয়েছে',
        'hello_thanks_for_booking' => 'হ্যালো, :site_title থেকে রুম বুকিং করার জন্য ধন্যবাদ:',
        'booking_status_change_message' => 'আমরা আশা করি এই বার্তাটি আপনার কাছে ভালভাবে পৌঁছেছে। আমরা আপনাকে জানাতে চাই যে আপনার বুকিংর অবস্থা আপডেট করা হয়েছে।',
        'name' => 'নাম',
        'phone' => 'ফোন',
        'email' => 'ইমেইল',
        'car_model' => 'গাড়ির মডেল',
        'start_date' => 'শুরুর তারিখ',
        'end_date' => 'শেষ তারিখ',
        'pickup_address' => 'পিকআপ ঠিকানা',
        'return_address' => 'ফেরত ঠিকানা',
        'note' => 'নোট',
        'order_number' => 'অর্ডার নম্বর',
        'payment_method' => 'পেমেন্ট পদ্ধতি',

        // Car approved email
        'hello' => 'হ্যালো',
        'car_approved_title' => 'দারুণ খবর! আপনার গাড়ি অনুমোদিত হয়েছে',
        'car_approved_message' => 'আমরা আপনাকে জানাতে পেরে আনন্দিত যে আপনার গাড়ির তালিকা ":car_name" অনুমোদিত হয়েছে এবং এখন :site_title এ লাইভ রয়েছে। আপনি এখনই বুকিং গ্রহণ করতে এবং আপনার তালিকা পরিচালনা করতে পারেন।',
        'view_edit_car_link' => 'আপনার গাড়ির তালিকা দেখতে বা সম্পাদনা করতে, অনুগ্রহ করে এই লিঙ্কে ক্লিক করুন',
        'view_car' => 'গাড়ির তালিকা দেখুন',
        'regards' => 'শুভেচ্ছা',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'অভিনন্দন! আপনি এখন একজন বিক্রেতা',
        'vendor_upgrade_congratulations' => 'আমরা আপনাকে জানাতে পেরে আনন্দিত যে আপনার অ্যাকাউন্ট সফলভাবে বিক্রেতা স্ট্যাটাসে আপগ্রেড করা হয়েছে!',
        'vendor_upgrade_message' => 'এখন আপনি :site_title এ আপনার নিজস্ব গাড়ি তালিকাভুক্ত এবং পরিচালনা করতে পারবেন। এটি আমাদের সাথে আপনার ভাড়া ব্যবসা বৃদ্ধির জন্য নতুন সুযোগ খুলে দেয়।',
        'vendor_benefits_title' => 'আপনার নতুন বিক্রেতা সুবিধা',
        'vendor_benefit_1' => 'ভাড়ার জন্য সীমাহীন গাড়ি তালিকাভুক্ত করুন',
        'vendor_benefit_2' => 'আপনার নিজস্ব বুকিং এবং গ্রাহক পরিচালনা করুন',
        'vendor_benefit_3' => 'রাজস্ব এবং কর্মক্ষমতা মেট্রিক্স ট্র্যাক করুন',
        'vendor_benefit_4' => 'বিক্রেতা-এক্সক্লুসিভ বৈশিষ্ট্য এবং সরঞ্জামগুলিতে অ্যাক্সেস',
        'next_steps' => 'পরবর্তী পদক্ষেপ',
        'vendor_next_steps_message' => 'আপনার গাড়ি যোগ করতে এবং আপনার ভাড়া ব্যবসা পরিচালনা শুরু করতে আপনার বিক্রেতা ড্যাশবোর্ডে লগ ইন করুন।',
        'go_to_dashboard' => 'বিক্রেতা ড্যাশবোর্ডে যান',
        'vendor_support_message' => 'আপনার কোন প্রশ্ন থাকলে বা সহায়তার প্রয়োজন হলে, আমাদের সহায়তা দল আপনাকে শুরু করতে সাহায্য করার জন্য এখানে আছে।',
        'approved' => 'অনুমোদিত',

        // Car rejected email
        'car_rejected_title' => 'আপনার গাড়ির তালিকার জন্য আপডেট প্রয়োজন',
        'car_rejected_message' => ':site_title এ আপনার গাড়ির তালিকা ":car_name" জমা দেওয়ার জন্য ধন্যবাদ। আপনার জমা পর্যালোচনা করার পর, আমরা অনুমোদন করার আগে আপনাকে কিছু সমন্বয় করতে হবে।',
        'rejection_reason' => 'কি আপডেট করতে হবে',
        'rejection_details' => 'প্রয়োজনীয় আপডেট',
        'contact_support' => 'আপনার এই আপডেটগুলি সম্পর্কে কোন প্রশ্ন থাকলে বা সহায়তার প্রয়োজন হলে, অনুগ্রহ করে :site_email এ আমাদের সহায়তা দলের সাথে যোগাযোগ করতে দ্বিধা করবেন না। আমরা আপনার তালিকা দ্রুত অনুমোদিত করতে সাহায্য করার জন্য এখানে আছি।',

        // Confirm email
        'verify_email' => 'ইমেইল যাচাই করুন',
        'welcome_message' => 'আমরা আনন্দিত যে আপনি এখানে আছেন, :customer_name!',
        'verify_email_instruction' => 'এই ওয়েবসাইট অ্যাক্সেস করার জন্য অনুগ্রহ করে আপনার ইমেইল ঠিকানা যাচাই করুন। আপনার ইমেইল যাচাই করতে নিচের বোতামে ক্লিক করুন।',
        'confirm_email_button' => 'আপনার ইমেইল ঠিকানা নিশ্চিত করুন',
        'verify_link_trouble' => 'আপনার \'আপনার ইমেইল ঠিকানা নিশ্চিত করুন\' বোতামে ক্লিক করতে সমস্যা হলে, নিচের URL কপি করুন এবং আপনার ওয়েব ব্রাউজারে পেস্ট করুন: :verify_link এবং আপনার ব্রাউজারে পেস্ট করুন।',

        // Message email
        'new_message' => 'নতুন বার্তা',
        'dear_admin' => 'প্রিয় অ্যাডমিন',
        'new_message_from' => ':site_title থেকে একটি নতুন বার্তা আছে:',
        'subject' => 'বিষয়',
        'address' => 'ঠিকানা',
        'content' => 'বিষয়বস্তু',

        // New pending car email
        'hi_admin' => 'হ্যালো অ্যাডমিন,',
        'new_car_pending_title' => 'নতুন গাড়ির তালিকা পর্যালোচনার অপেক্ষায়',
        'new_car_pending_approval' => ':post_author দ্বারা একটি নতুন গাড়ির তালিকা ":post_name" জমা দেওয়া হয়েছে এবং আপনার পর্যালোচনার জন্য প্রস্তুত।',
        'pending_approval' => 'পর্যালোচনার অপেক্ষায়',
        'review_car_admin' => 'অনুগ্রহ করে অ্যাডমিন প্যানেলে এই তালিকাটি পর্যালোচনা করুন এবং অনুমোদন করুন বা প্রয়োজন অনুযায়ী আপডেট অনুরোধ করুন।',

        // Common fields
        'car_information' => 'গাড়ির তথ্য',
        'field_car_name' => 'গাড়ির নাম:',
        'field_author' => 'লেখক:',
        'field_status' => 'অবস্থা:',
        'actions' => 'কর্ম',

        // Password reminder email
        'reset_password_instruction' => 'পাসওয়ার্ড রিসেট নির্দেশাবলী',
        'password_reset_request' => 'আপনি এই ইমেইল পাচ্ছেন কারণ আমরা আপনার অ্যাকাউন্টের জন্য একটি পাসওয়ার্ড রিসেট অনুরোধ পেয়েছি।',
        'reset_password_button' => 'পাসওয়ার্ড রিসেট করুন',
        'reset_link_trouble' => 'আপনার \'পাসওয়ার্ড রিসেট করুন\' বোতামে ক্লিক করতে সমস্যা হলে, নিচের URL কপি করুন এবং আপনার ওয়েব ব্রাউজারে পেস্ট করুন: :reset_link এবং আপনার ব্রাউজারে পেস্ট করুন। আপনি যদি পাসওয়ার্ড রিসেট অনুরোধ না করে থাকেন, তাহলে অনুগ্রহ করে এই বার্তা উপেক্ষা করুন বা আপনার কোন প্রশ্ন থাকলে আমাদের সাথে যোগাযোগ করুন।',
    ],
];
