<?php

return [
    'name' => 'Autopůjčovny',
    'customer' => [
        'name' => 'Zákazníci',
        'create' => 'Vytvořit zákazníka',
        'view' => 'Zobrazit',
        'information' => 'Informace o zákazníkovi',
        'email' => 'Email',
        'phone' => 'Telefon',
        'status' => 'Stav',
        'vendor_status' => 'Status prodejce',
        'is_vendor' => 'Prodejce',
        'not_vendor' => 'Zákazník',
        'recent_activity' => 'Nedávná aktivita',
        'recent_activity_description' => 'Zde se zobrazí aktivita zákazníka.',
        'verification_section' => 'Ověření zákazníka',
        'verified' => 'Ověřeno',
        'not_verified' => 'Neověřeno',
        'verified_by' => 'Ověřil',
        'verified_at' => 'Ověřeno dne',
        'verify_customer' => 'Ověřit zákazníka',
        'unverify_customer' => 'Odebrat ověření zákazníka',
        'verify_customer_confirmation' => 'Potvrzení ověření zákazníka',
        'verify_customer_confirmation_desc' => 'Opravdu chcete ověřit :name? Tím se na jejich profilu zobrazí odznak ověření.',
        'unverify_customer_confirmation' => 'Potvrzení odebrání ověření zákazníka',
        'unverify_customer_confirmation_desc' => 'Opravdu chcete odebrat ověření od :name? Odznak ověření bude odstraněn.',
        'verify_success' => 'Zákazník :name byl úspěšně ověřen.',
        'unverify_success' => 'Ověření zákazníka :name bylo úspěšně odstraněno.',
        'already_verified' => 'Tento zákazník je již ověřen.',
        'already_unverified' => 'Tento zákazník není ověřen.',
        'upgrade_to_vendor_title' => 'Povýšit na prodejce',
        'upgrade_to_vendor_description' => 'Povyšte tohoto zákazníka na status prodejce, aby mohl zveřejňovat a spravovat vlastní autopůjčovny.',
        'upgrade_to_vendor_button' => 'Povýšit na prodejce',
        'upgrade_to_vendor_confirmation' => 'Potvrdit povýšení na prodejce',
        'upgrade_to_vendor_confirmation_desc' => 'Opravdu chcete povýšit :name na status prodejce? To jim umožní zveřejňovat a spravovat vlastní auta na platformě.',
        'upgrade_to_vendor_success' => ':name byl úspěšně povýšen na status prodejce.',
        'already_vendor' => 'Tento zákazník je již prodejce.',
        'customer_verified_successfully' => 'Tento zákazník byl ověřen a lze mu důvěřovat.',
        'customer_not_verified_yet' => 'Tento zákazník zatím nebyl ověřen.',
        'verification_pending' => 'Čeká na ověření',
        'click_verify_to_approve' => 'Klikněte na tlačítko níže pro ověření tohoto zákazníka a zobrazení odznaku ověření.',
        'verification_note' => 'Poznámka k ověření',
        'verification_note_placeholder' => 'Zadejte jakékoli poznámky k této akci ověření...',
        'verification_note_helper' => 'Přidejte poznámky k procesu ověření (pouze pro interní použití)',
        'forms' => [
            'name' => 'Jméno',
            'email' => 'Email',
            'phone' => 'Telefon',
            'avatar' => 'Avatar',
            'dob' => 'Datum narození',
            'company' => 'Společnost',
            'position' => 'Pozice',
            'password' => 'Heslo',
            'password_confirmation' => 'Potvrzení hesla',
            'change_password' => 'Změnit heslo?',
            'phone_placeholder' => 'Telefon',
        ],
    ],
    'vendor' => [
        'name' => 'Prodejci',
        'view' => 'Zobrazit :name',
        'information' => 'Informace o prodejci',
        'total_cars' => 'Celkový počet aut',
        'total_bookings' => 'Celkový počet rezervací',
        'verified' => 'Ověřeno',
        'not_verified' => 'Neověřeno',
        'verification_section' => 'Ověření prodejce',
        'vendor_verified_successfully' => 'Tento prodejce byl ověřen a lze mu důvěřovat.',
        'vendor_not_verified_yet' => 'Tento prodejce zatím nebyl ověřen.',
        'verification_pending' => 'Čeká na ověření',
        'click_verify_to_approve' => 'Klikněte na tlačítko níže pro ověření tohoto prodejce a zobrazení odznaku ověření.',
        'verify_vendor' => 'Ověřit prodejce',
        'unverify_vendor' => 'Odebrat ověření prodejce',
        'verify_vendor_confirmation' => 'Potvrzení ověření prodejce',
        'verify_vendor_confirmation_desc' => 'Opravdu chcete ověřit :name? Tím se na jejich profilu zobrazí odznak ověření.',
        'unverify_vendor_confirmation' => 'Potvrzení odebrání ověření prodejce',
        'unverify_vendor_confirmation_desc' => 'Opravdu chcete odebrat ověření od :name? Odznak ověření bude odstraněn.',
        'verified_successfully' => 'Prodejce byl úspěšně ověřen.',
        'unverified_successfully' => 'Ověření prodejce bylo úspěšně odstraněno.',
        'already_verified' => 'Tento prodejce je již ověřen.',
        'not_verified_yet' => 'Tento prodejce zatím není ověřen.',
        'recent_activity' => 'Nedávná aktivita',
        'recent_cars' => 'Nedávná auta',
        'recent_bookings' => 'Nedávné rezervace',
        'no_cars_yet' => 'Zatím nebyla přidána žádná auta.',
        'no_bookings_yet' => 'Zatím nebyly přijaty žádné rezervace.',
    ],
    'make' => [
        'name' => 'Značky',
        'create' => 'Vytvořit značku auta',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo tmavé',
        ],
    ],
    'car' => [
        'name' => 'Auta',
        'create' => 'Vytvořit auto',
        'forms' => [
            'car' => 'Auto',
            'logo' => 'Logo',
            'license_plate' => 'Registrační značka',
            'make' => 'Značka',
            'model' => 'Model',
            'name' => 'Název',
            'images' => 'Obrázky',
            'year' => 'Rok',
            'color' => 'Barva',
            'mileage' => 'Nájezd',
            'kilometers' => 'Kilometry',
            'horsepower' => 'Výkon',
            'vehicle_type' => 'Typ vozidla',
            'transmission' => 'Převodovka',
            'fuel_type' => 'Typ paliva',
            'rental_rate' => 'Cena pronájmu',
            'currency' => 'Měna',
            'status' => 'Stav',
            'availability' => 'Dostupnost',
            'insurance_info' => 'Informace o pojištění',
            'number_of_seats' => 'Počet sedadel',
            'number_of_doors' => 'Počet dveří',
            'vin' => 'VIN',
            'maintenance_history' => 'Historie údržby',
            'location' => 'Lokalita',
            'description' => 'Popis',
            'rental_type' => 'Typ pronájmu',
            'tags' => 'Štítky',
            'add_new_attribute' => 'Přidat nový <a href=":url" target="_blank">zde</a>.',
            'categories' => 'Kategorie',
            'pick_address' => 'Adresa vyzvednutí',
            'return_address' => 'Adresa vrácení',
            'same_drop_off' => 'Stejné místo vrácení',
            'tax' => 'Daň',
            'select_tax' => 'Vyberte daň',
            'none' => 'Žádná',
            'colors' => 'Barvy',
            'amenities' => 'Vybavení',
            'is_used' => 'Je použité?',
            'moderation_status' => 'Status moderování',
            'status_moderation' => [
                'approve' => 'Schválit',
                'reject' => 'Odmítnout',
                'approve_title' => 'Schválit auto',
                'approve_message' => 'Opravdu chcete schválit toto auto? Tuto akci nelze vrátit zpět.',
                'reject_title' => 'Odmítnout auto',
                'reject_message' => 'Opravdu chcete odmítnout toto auto? Tuto akci nelze vrátit zpět.',
                'reject_reason' => 'Zadejte důvod odmítnutí',
                'approved' => 'Auto bylo úspěšně schváleno!',
                'rejected' => 'Auto bylo úspěšně odmítnuto!',
                'reason_rejected' => 'Důvod odmítnutí',
            ],
            'customer' => 'Zákazník',
            'select_customer' => 'Vyberte zákazníka...',
            'vendor_images' => 'Obrázky (Maximálně :max obrázků)',
            'images_upload_placeholder' => 'Přetáhněte soubory sem nebo klikněte pro nahrání.',
            'car_purpose' => 'Účel vozu',
            'for_rent' => 'K pronájmu',
            'for_sale' => 'K prodeji',
            'car_type' => 'Typ vozu',
            'rental_information' => 'Informace o pronájmu',
            'sale_statuses' => [
                'available' => 'Dostupné',
                'sold' => 'Prodáno',
                'reserved' => 'Rezervováno',
            ],
            'selling_information' => 'Informace o prodeji',
            'is_for_sale' => 'K dispozici k prodeji',
            'sale_price' => 'Prodejní cena',
            'sale_price_placeholder' => 'Zadejte prodejní cenu',
            'condition' => 'Stav',
            'select_condition' => 'Vyberte stav',
            'condition_options' => [
                'new' => 'Nové',
                'like_new' => 'Jako nové',
                'excellent' => 'Výborný',
                'good' => 'Dobrý',
                'fair' => 'Průměrný',
                'poor' => 'Špatný',
            ],
            'ownership_history' => 'Historie vlastnictví',
            'ownership_history_placeholder' => 'Zadejte historii vlastnictví',
            'warranty_information' => 'Informace o záruce',
            'warranty_information_placeholder' => 'Zadejte informace o záruce',
            'sale_status' => 'Status prodeje',
            'external_booking_url' => 'Odkaz na rezervaci mimo web',
            'external_booking_url_helper' => 'Zadejte externí URL, kde si zákazníci mohou rezervovat toto auto mimo tuto platformu. Nechte prázdné, pokud je rezervace dostupná pouze na tomto webu.',
            'address' => 'Adresa',
            'address_helper' => 'Zadejte konkrétní adresu, kde se toto vozidlo nachází',
        ],
        'car_purposes' => [
            'sale' => 'K prodeji',
            'rent' => 'K pronájmu',
        ],
        'placeholders' => [
            'name' => 'Zadejte název vozidla (např. Toyota Camry 2023, Honda CR-V, atd.)',
            'description' => 'Zadejte stručný popis vozidla se zvýrazněním klíčových vlastností',
            'rental_rate' => 'Zadejte cenu pronájmu podle zvoleného typu pronájmu',
            'location' => 'Zadejte fyzickou polohu vozidla',
            'address' => 'Zadejte konkrétní adresu (např. Hlavní 123, Město, Stát)',
            'sale_price' => 'Zadejte prodejní cenu tohoto vozidla',
            'ownership_history' => 'Zadejte údaje o předchozích majitelích, počtu majitelů atd.',
            'warranty_information' => 'Zadejte údaje o pokrytí záruky, datu vypršení atd.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Zadejte číslo registrační značky vozidla',
            'vin' => 'Zadejte VIN (Vehicle Identification Number)',
            'year' => 'Zadejte rok výroby (např. 2023)',
            'mileage' => 'Zadejte aktuální nájezd',
            'kilometers' => 'Zadejte aktuální kilometry',
            'horsepower' => 'Zadejte výkon vozidla v HP (např. 150.5)',
            'number_of_seats' => 'Zadejte počet sedadel ve vozidle',
            'number_of_doors' => 'Zadejte počet dveří vozidla',
            'insurance_info' => 'Zadejte relevantní informace o pojištění tohoto vozidla',
            'tags' => 'Vyberte nebo vytvořte štítky',
            'amenities' => 'Vyberte vybavení',
            'colors' => 'Vyberte nebo vytvořte barvy',
        ],
        'enums' => [
            'vendor_status' => 'Status prodejce',
            'is_vendor' => 'Prodejce',
            'not_vendor' => 'Zákazník',
            'statuses' => [
                'available' => 'Dostupné',
                'rented' => 'Pronajato',
                'maintenance' => 'Údržba',
                'out_of_service' => 'Mimo provoz',
            ],
            'rental_types' => [
                'per_hour' => 'Za hodinu',
                'per_day' => 'Za den',
                'per_week' => 'Za týden',
                'per_month' => 'Za měsíc',
            ],
            'moderation_statuses' => [
                'pending' => 'Čeká na vyřízení',
                'approved' => 'Schváleno',
                'rejected' => 'Odmítnuto',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Historie údržby',
            'create' => 'Vytvořit historii servisu',
            'amount' => 'Částka',
            'forms' => [
                'price_placeholder' => 'Cena servisu',
                'currency' => 'Měna',
                'none' => 'Žádná',
                'name' => 'Název',
                'amount' => 'Částka',
                'created_at' => 'Vytvořeno dne',
                'action' => 'Akce',
                'date' => 'Datum',
                'no_maintenance_history' => 'Žádná historie údržby',
                'edit_maintenance_history' => 'Upravit historii údržby',
                'add_maintenance_history' => 'Přidat historii údržby',
                'add' => 'Přidat',
                'edit' => 'Upravit',
                'delete' => 'Smazat',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atributy aut',
        'car_type' => [
            'name' => 'Typy',
            'create' => 'Vytvořit typ auta',
            'forms' => [
                'name' => 'Název',
            ],
        ],
        'transmission' => [
            'name' => 'Převodovky',
            'create' => 'Vytvořit převodovku',
            'forms' => [
                'name' => 'Název',
            ],
        ],
        'fuel_type' => [
            'name' => 'Paliva',
            'create' => 'Vytvořit typ paliva',
            'forms' => [
                'name' => 'Název',
            ],
        ],
        'tag' => [
            'name' => 'Štítky',
            'create' => 'Vytvořit štítek',
        ],
        'category' => [
            'name' => 'Kategorie',
            'create' => 'Vytvořit kategorii',
            'forms' => [
                'none' => 'Žádná',
                'total_cars' => 'Celkem aut: :total',
            ],
        ],
        'address' => [
            'name' => 'Lokality',
            'create' => 'Vytvořit lokalitu auta',
            'form' => [
                'name' => 'Adresa',
                'full_address' => 'Úplná adresa',
                'detail_address' => 'Podrobná adresa',
            ],
        ],
        'color' => [
            'name' => 'Barva',
            'create' => 'Vytvořit barvu',
        ],
        'amenity' => [
            'name' => 'Vybavení',
            'create' => 'Vytvořit vybavení',
        ],
    ],
    'tax' => [
        'name' => 'Daně',
        'create' => 'Vytvořit daň',
        'forms' => [
            'name' => 'Název',
            'name_placeholder' => 'Zadejte název',
            'percentage' => 'Procento',
            'percentage_placeholder' => 'Procento',
            'percent_placeholder' => 'Procento',
            'priority' => 'Priorita',
            'priority_placeholder' => 'Priorita',
        ],
    ],
    'review' => [
        'name' => 'Hodnocení',
        'create' => 'Vytvořit hodnocení',
        'edit' => 'Upravit hodnocení',
        'vendor' => [
            'title' => 'Hodnocení zákazníků',
            'description' => 'Správa všech hodnocení zákazníků pro vaše auta',
            'no_reviews' => 'Zatím nemáte žádná hodnocení',
            'filter_by_car' => 'Filtrovat podle auta',
            'filter_by_rating' => 'Filtrovat podle hodnocení',
            'filter_by_date' => 'Filtrovat podle data',
            'all_cars' => 'Všechna auta',
            'all_ratings' => 'Všechna hodnocení',
            'manage_reviews' => 'Spravovat hodnocení',
            'view_all' => 'Zobrazit všechna hodnocení',
            'delete_review_confirmation' => 'Opravdu chcete smazat toto hodnocení?',
            'delete_review_success' => 'Hodnocení bylo úspěšně smazáno',
            'cannot_delete' => 'Toto hodnocení nelze smazat',
        ],
        'forms' => [
            'customer' => 'Zákazník',
            'car' => 'Auto',
            'content' => 'Obsah',
            'rating' => 'Hodnocení',
            'your_name' => 'Vaše jméno',
            'email_address' => 'E-mailová adresa',
            'submit' => 'Odeslat',
            'star' => 'Hvězdička',
            'status' => 'Stav',
            'created_at' => 'Vytvořeno dne',
            'select_car' => 'Vyberte auto',
            'select_rating' => 'Vyberte hodnocení',
            'comment' => 'Komentář',
            'reply' => 'Odpovědět',
            'reply_to_review' => 'Odpovědět na hodnocení',
            'save_reply' => 'Uložit odpověď',
            'cancel_reply' => 'Zrušit',
        ],
        'statuses' => [
            'published' => 'Zveřejněno',
            'pending' => 'Čeká na vyřízení',
            'rejected' => 'Odmítnuto',
        ],
        'ratings' => [
            '1' => '1 hvězdička - Špatné',
            '2' => '2 hvězdičky - Průměrné',
            '3' => '3 hvězdičky - Dobré',
            '4' => '4 hvězdičky - Velmi dobré',
            '5' => '5 hvězdiček - Vynikající',
        ],
    ],
    'coupon' => [
        'name' => 'Kupóny',
        'create' => 'Vytvořit kupón',
        'types' => [
            'percentage' => 'Procenta %',
            'money' => 'Peníze',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Služby',
        'create' => 'Vytvořit službu',
        'forms' => [
            'name' => 'Název',
            'content' => 'Obsah',
            'price' => 'Cena',
            'currency' => 'Měna',
            'image' => 'Obrázek',
            'logo' => 'Logo',
            'status' => 'Stav',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Kalendář dostupnosti',
        'title' => 'Kalendář dostupnosti',
        'description' => 'Zobrazit dostupnost aut a rezervace ve formátu kalendáře',
        'select_dates' => 'Vyberte data pro kontrolu dostupnosti',
        'car_filter' => 'Filtrovat podle auta',
        'all_cars' => 'Všechna auta',
        'clear_filter' => 'Vymazat filtr',
        'availability_check' => 'Kontrola dostupnosti auta',
        'selected_period' => 'Vybrané období',
        'checking_availability' => 'Kontrola dostupnosti...',
        'available' => 'Dostupné',
        'not_available' => 'Nedostupné',
        'booking_details' => 'Podrobnosti rezervace',
        'how_to_use' => 'Jak používat kalendář dostupnosti aut',
        'viewing_bookings' => 'Zobrazení rezervací',
        'checking_availability_help' => 'Kontrola dostupnosti',
        'color_legend' => 'Barevná legenda',
        'pending_bookings' => 'Čekající rezervace',
        'processing_bookings' => 'Zpracovávané rezervace',
        'completed_bookings' => 'Dokončené rezervace',
        'cancelled_bookings' => 'Zrušené rezervace',
        'unknown_make' => 'Neznámá značka',
        'loading' => 'Načítání...',
        'loading_calendar_data' => 'Načítání dat kalendáře...',
        'loading_booking_details' => 'Načítání podrobností rezervace...',
        'please_wait_booking_info' => 'Čekejte prosím, načítáme informace o rezervaci.',
        'please_wait_availability' => 'Čekejte prosím, kontrolujeme dostupnost aut pro vaše vybraná data.',
        'error' => 'Chyba',
        'error_loading_booking' => 'Nepodařilo se načíst podrobnosti rezervace. Zkuste to prosím znovu.',
        'error_checking_availability' => 'Chyba při kontrole dostupnosti auta',
        'customer' => 'Zákazník',
        'status' => 'Stav',
        'amount' => 'Částka',
        'make' => 'Značka',
        'vendor' => 'Prodejce',
        'per_day' => '/den',
        'edit_car' => 'Upravit auto',
        'no_cars_found' => 'Nebyla nalezena žádná auta',
        'no_cars_available_period' => 'Pro vybrané období nejsou k dispozici žádná auta.',
        'close' => 'Zavřít',
        'edit_booking' => 'Upravit rezervaci',
        'pending' => 'Čeká na vyřízení',
        'processing' => 'Zpracovává se',
        'completed' => 'Dokončeno',
        'cancelled' => 'Zrušeno',
    ],
    'theme_options' => [
        'name' => 'Autopůjčovny',
        'description' => 'Možnosti motivu pro autopůjčovny',
        'car_location_filter_by' => 'Filtr lokality auta podle',
        'state' => 'Stát',
        'city' => 'Město',
        'yes' => 'Ano',
        'no' => 'Ne',
        'is_display_country' => 'Zobrazit zemi ve filtru lokality?',
        'logo_vendor_dashboard' => 'Logo na panelu prodejce (Výchozí je hlavní logo)',
        'number_of_cars_per_page' => 'Počet aut na stránku',
        'number_of_cars_per_page_placeholder' => 'Zadejte počet aut k zobrazení na stránku',
    ],
    'message' => [
        'name' => 'Zprávy',
        'forms' => [
            'customer_name' => 'Jméno zákazníka',
            'message' => 'Zpráva',
            'phone' => 'Telefon',
            'email' => 'Email',
            'created_at' => 'Vytvořeno dne',
            'status' => 'Stav',
        ],
    ],
    'car_sale' => [
        'name' => 'Prodeje aut',
        'create' => 'Nový prodej auta',
        'edit' => 'Upravit prodej auta :name',
        'statuses' => [
            'pending' => 'Čeká na vyřízení',
            'processing' => 'Zpracovává se',
            'completed' => 'Dokončeno',
            'cancelled' => 'Zrušeno',
        ],
        'forms' => [
            'transaction_id' => 'ID transakce',
            'transaction_id_placeholder' => 'Zadejte ID transakce',
            'car_id' => 'Auto',
            'car' => 'Auto',
            'customer_id' => 'Zákazník',
            'customer_name' => 'Jméno zákazníka',
            'customer_name_placeholder' => 'Zadejte jméno zákazníka',
            'customer_email' => 'Email zákazníka',
            'customer_email_placeholder' => 'Zadejte email zákazníka',
            'customer_phone' => 'Telefon zákazníka',
            'customer_phone_placeholder' => 'Zadejte telefon zákazníka',
            'sale_price' => 'Prodejní cena',
            'sale_price_placeholder' => 'Zadejte prodejní cenu',
            'tax_amount' => 'Částka daně',
            'tax_amount_placeholder' => 'Zadejte částku daně',
            'total_amount' => 'Celková částka',
            'total_amount_placeholder' => 'Zadejte celkovou částku',
            'payment_details' => 'Platební údaje',
            'payment_details_placeholder' => 'Zadejte platební údaje',
            'notes' => 'Poznámky',
            'notes_placeholder' => 'Zadejte poznámky',
            'sale_date' => 'Datum prodeje',
            'delivery_date' => 'Datum dodání',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankovní převod',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Potvrzení rezervace autopůjčovny',
        'booking_confirm_greeting' => 'Vážený/á :customer_name,',
        'booking_confirm_message' => 'S potěšením vás informujeme, že vaše rezervace autopůjčovny byla úspěšně potvrzena!',
        'customer_information' => 'Informace o zákazníkovi',
        'booking_information' => 'Informace o rezervaci',
        'field_name' => 'Jméno:',
        'field_phone' => 'Telefon:',
        'field_email' => 'Email:',
        'field_car_model' => 'Model auta:',
        'field_start_date' => 'Datum zahájení:',
        'field_end_date' => 'Datum ukončení:',
        'field_pickup_address' => 'Adresa vyzvednutí:',
        'field_return_address' => 'Adresa vrácení:',
        'field_note' => 'Poznámka:',
        'field_order_number' => 'Číslo objednávky',
        'field_payment_method' => 'Platební metoda',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Oznámení o nové rezervaci',
        'booking_notice_admin_greeting' => 'Dobrý den, je zde nová rezervace z :site_title:',
        'booking_notice_admin_message' => 'Byla odeslána nová rezervace autopůjčovny a vyžaduje vaši pozornost.',
        'booking_view_detail' => 'Zobrazit detail rezervace:',
        'view_booking_details' => 'Zobrazit podrobnosti rezervace',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Nová rezervace vašeho auta',
        'booking_notice_vendor_greeting' => 'Vážený/á :vendor_name,',
        'booking_notice_vendor_message' => 'Skvělá zpráva! Obdrželi jste novou rezervaci vašeho auta k pronájmu.',

        // Booking status changed email
        'booking_status_updated' => 'Aktualizace stavu rezervace',
        'hello_thanks_for_booking' => 'Dobrý den, děkujeme za rezervaci z :site_title:',
        'booking_status_change_message' => 'Doufáme, že vás tato zpráva zastihne v dobrém zdraví. Rádi bychom vás informovali, že stav vaší rezervace byl aktualizován.',
        'name' => 'Jméno',
        'phone' => 'Telefon',
        'email' => 'Email',
        'car_model' => 'Model auta',
        'start_date' => 'Datum zahájení',
        'end_date' => 'Datum ukončení',
        'pickup_address' => 'Adresa vyzvednutí',
        'return_address' => 'Adresa vrácení',
        'note' => 'Poznámka',
        'order_number' => 'Číslo objednávky',
        'payment_method' => 'Platební metoda',

        // Car approved email
        'hello' => 'Dobrý den',
        'car_approved_title' => 'Skvělá zpráva! Vaše auto bylo schváleno',
        'car_approved_message' => 'S potěšením vás informujeme, že váš inzerát auta ":car_name" byl schválen a je nyní aktivní na :site_title. Můžete začít přijímat rezervace a spravovat svůj inzerát hned teď.',
        'view_edit_car_link' => 'Pro zobrazení nebo úpravu vašeho inzerátu auta klikněte prosím na tento odkaz',
        'view_car' => 'Zobrazit inzerát auta',
        'regards' => 'S pozdravem',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Gratulujeme! Nyní jste prodejce',
        'vendor_upgrade_congratulations' => 'S nadšením vás informujeme, že váš účet byl úspěšně povýšen na status prodejce!',
        'vendor_upgrade_message' => 'Nyní můžete zveřejňovat a spravovat vlastní auta na :site_title. To vám otevírá nové možnosti pro rozvoj vašeho pronajímacího byznysu s námi.',
        'vendor_benefits_title' => 'Vaše nové výhody prodejce',
        'vendor_benefit_1' => 'Zveřejňujte neomezený počet aut k pronájmu',
        'vendor_benefit_2' => 'Spravujte vlastní rezervace a zákazníky',
        'vendor_benefit_3' => 'Sledujte tržby a metriky výkonu',
        'vendor_benefit_4' => 'Přístup k exkluzivním funkcím a nástrojům pro prodejce',
        'next_steps' => 'Další kroky',
        'vendor_next_steps_message' => 'Přihlaste se na svůj panel prodejce pro začátek přidávání aut a správu vašeho pronajímacího byznysu.',
        'go_to_dashboard' => 'Přejít na panel prodejce',
        'vendor_support_message' => 'Pokud máte jakékoli otázky nebo potřebujete pomoc, náš tým podpory je tu, aby vám pomohl začít.',
        'approved' => 'Schváleno',

        // Car rejected email
        'car_rejected_title' => 'Požadována aktualizace vašeho inzerátu auta',
        'car_rejected_message' => 'Děkujeme za odeslání vašeho inzerátu auta ":car_name" na :site_title. Po kontrole vašeho podání potřebujeme, abyste provedli některé úpravy před tím, než ho můžeme schválit.',
        'rejection_reason' => 'Co je třeba aktualizovat',
        'rejection_details' => 'Požadované aktualizace',
        'contact_support' => 'Pokud máte jakékoli otázky nebo potřebujete pomoc s těmito aktualizacemi, neváhejte kontaktovat náš tým podpory na :site_email. Jsme tu, abychom vám pomohli rychle schválit váš inzerát.',

        // Confirm email
        'verify_email' => 'Ověřit email',
        'welcome_message' => 'Jsme rádi, že jste tady, :customer_name!',
        'verify_email_instruction' => 'Prosím ověřte svou e-mailovou adresu, abyste mohli přistupovat na tento web. Klikněte na tlačítko níže pro ověření vašeho e-mailu.',
        'confirm_email_button' => 'Potvrdit e-mailovou adresu',
        'verify_link_trouble' => 'Pokud máte problémy s kliknutím na tlačítko \'Potvrdit e-mailovou adresu\', zkopírujte a vložte URL níže do vašeho webového prohlížeče: :verify_link a vložte ji do vašeho prohlížeče.',

        // Message email
        'new_message' => 'Nová zpráva',
        'dear_admin' => 'Vážený administrátore',
        'new_message_from' => 'Je zde nová zpráva z :site_title:',
        'subject' => 'Předmět',
        'address' => 'Adresa',
        'content' => 'Obsah',

        // New pending car email
        'hi_admin' => 'Dobrý den administrátore,',
        'new_car_pending_title' => 'Nový inzerát auta čeká na kontrolu',
        'new_car_pending_approval' => 'Nový inzerát auta ":post_name" byl odeslán uživatelem :post_author a je připraven k vaší kontrole.',
        'pending_approval' => 'Čeká na kontrolu',
        'review_car_admin' => 'Prosím zkontrolujte tento inzerát v administračním panelu a schvalte ho nebo požádejte o aktualizace podle potřeby.',

        // Common fields
        'car_information' => 'Informace o autě',
        'field_car_name' => 'Název auta:',
        'field_author' => 'Autor:',
        'field_status' => 'Stav:',
        'actions' => 'Akce',

        // Password reminder email
        'reset_password_instruction' => 'Instrukce pro obnovení hesla',
        'password_reset_request' => 'Tento e-mail obdržíte, protože jsme obdrželi žádost o obnovení hesla pro váš účet.',
        'reset_password_button' => 'Obnovit heslo',
        'reset_link_trouble' => 'Pokud máte problémy s kliknutím na tlačítko \'Obnovit heslo\', zkopírujte a vložte URL níže do vašeho webového prohlížeče: :reset_link a vložte ji do vašeho prohlížeče. Pokud jste o obnovení hesla nežádali, prosím ignorujte tuto zprávu nebo nás kontaktujte, pokud máte jakékoli otázky.',
    ],
];
