<?php

return [
    'name' => 'Autovermietung',
    'customer' => [
        'name' => 'Kunden',
        'create' => 'Kunde erstellen',
        'view' => 'Ansehen',
        'information' => 'Kundeninformationen',
        'email' => 'E-Mail',
        'phone' => 'Telefon',
        'status' => 'Status',
        'vendor_status' => 'Anbieter-Status',
        'is_vendor' => 'Anbieter',
        'not_vendor' => 'Kunde',
        'recent_activity' => 'Letzte Aktivität',
        'recent_activity_description' => 'Kundenaktivitäten werden hier angezeigt.',
        'verification_section' => 'Kundenverifizierung',
        'verified' => 'Verifiziert',
        'not_verified' => 'Nicht verifiziert',
        'verified_by' => 'Verifiziert von',
        'verified_at' => 'Verifiziert am',
        'verify_customer' => 'Kunde verifizieren',
        'unverify_customer' => 'Verifizierung aufheben',
        'verify_customer_confirmation' => 'Kundenverifizierung bestätigen',
        'verify_customer_confirmation_desc' => 'Sind Sie sicher, dass Sie :name verifizieren möchten? Dies zeigt ein Verifizierungsabzeichen auf ihrem Profil an.',
        'unverify_customer_confirmation' => 'Verifizierung aufheben bestätigen',
        'unverify_customer_confirmation_desc' => 'Sind Sie sicher, dass Sie die Verifizierung von :name entfernen möchten? Das Verifizierungsabzeichen wird entfernt.',
        'verify_success' => 'Kunde :name wurde erfolgreich verifiziert.',
        'unverify_success' => 'Die Verifizierung von Kunde :name wurde erfolgreich entfernt.',
        'already_verified' => 'Dieser Kunde ist bereits verifiziert.',
        'already_unverified' => 'Dieser Kunde ist nicht verifiziert.',
        'upgrade_to_vendor_title' => 'Zum Anbieter upgraden',
        'upgrade_to_vendor_description' => 'Upgraden Sie diesen Kunden zum Anbieter-Status, um ihm zu ermöglichen, eigene Fahrzeuge zu listen und zu verwalten.',
        'upgrade_to_vendor_button' => 'Zum Anbieter upgraden',
        'upgrade_to_vendor_confirmation' => 'Upgrade zum Anbieter bestätigen',
        'upgrade_to_vendor_confirmation_desc' => 'Sind Sie sicher, dass Sie :name zum Anbieter-Status upgraden möchten? Dies ermöglicht es ihm, eigene Fahrzeuge auf der Plattform zu listen und zu verwalten.',
        'upgrade_to_vendor_success' => ':name wurde erfolgreich zum Anbieter-Status upgegraded.',
        'already_vendor' => 'Dieser Kunde ist bereits ein Anbieter.',
        'email_verified' => 'E-Mail Verifiziert',
        'email_not_verified' => 'E-Mail Nicht Verifiziert',
        'verify_email_warning_message' => 'Die E-Mail-Adresse dieses Kunden wurde nicht verifiziert. Sie können sie manuell verifizieren, um zu bestätigen, dass ihre E-Mail gültig ist.',
        'verify_email_title' => 'E-Mail-Adresse Verifizieren',
        'verify_email_description' => 'Die E-Mail-Adresse dieses Kunden wurde nicht verifiziert. Sie können sie manuell verifizieren, um zu bestätigen, dass ihre E-Mail gültig ist.',
        'verify_email_button' => 'E-Mail Verifizieren',
        'verify_email_confirmation' => 'E-Mail-Verifizierung Bestätigen',
        'verify_email_confirmation_desc' => 'Sind Sie sicher, dass Sie die E-Mail-Adresse :email für :name verifizieren möchten? Dies markiert ihre E-Mail als bestätigt.',
        'verify_email_success' => 'Die E-Mail :email wurde erfolgreich für :name verifiziert.',
        'email_already_verified' => 'Diese E-Mail-Adresse ist bereits verifiziert.',
        'resend_confirmation_button' => 'Bestätigungs-E-Mail Erneut Senden',
        'resend_confirmation_title' => 'Bestätigungs-E-Mail Erneut Senden',
        'resend_confirmation_desc' => 'Sind Sie sicher, dass Sie die Bestätigungs-E-Mail an :email für :name erneut senden möchten? Dies sendet einen neuen Verifizierungslink an ihre E-Mail-Adresse.',
        'resend_confirmation_success' => 'Bestätigungs-E-Mail wurde an :email gesendet.',
        'resend_confirmation_error' => 'Fehler beim Senden der Bestätigungs-E-Mail. Bitte versuchen Sie es erneut.',
        'customer_verified_successfully' => 'Dieser Kunde wurde verifiziert und ist vertrauenswürdig.',
        'customer_not_verified_yet' => 'Dieser Kunde wurde noch nicht verifiziert.',
        'verification_pending' => 'Verifizierung ausstehend',
        'click_verify_to_approve' => 'Klicken Sie auf die Schaltfläche unten, um diesen Kunden zu verifizieren und das Verifizierungsabzeichen anzuzeigen.',
        'verification_note' => 'Verifizierungsnotiz',
        'verification_note_placeholder' => 'Geben Sie Notizen zu dieser Verifizierungsaktion ein...',
        'verification_note_helper' => 'Fügen Sie Notizen zum Verifizierungsprozess hinzu (nur für internen Gebrauch)',
        'forms' => [
            'name' => 'Name',
            'email' => 'E-Mail',
            'phone' => 'Telefon',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Avatar',
            'dob' => 'Geburtsdatum',
            'company' => 'Unternehmen',
            'position' => 'Position',
            'password' => 'Passwort',
            'password_confirmation' => 'Passwort bestätigen',
            'change_password' => 'Passwort ändern?',
            'phone_placeholder' => 'Telefon',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => 'Anbieter',
        'view' => ':name ansehen',
        'information' => 'Anbieterinformationen',
        'total_cars' => 'Gesamtfahrzeuge',
        'total_bookings' => 'Gesamtbuchungen',
        'verified' => 'Verifiziert',
        'not_verified' => 'Nicht verifiziert',
        'verification_section' => 'Anbieterverifizierung',
        'vendor_verified_successfully' => 'Dieser Anbieter wurde verifiziert und ist vertrauenswürdig.',
        'vendor_not_verified_yet' => 'Dieser Anbieter wurde noch nicht verifiziert.',
        'verification_pending' => 'Verifizierung ausstehend',
        'click_verify_to_approve' => 'Klicken Sie auf die Schaltfläche unten, um diesen Anbieter zu verifizieren und das Verifizierungsabzeichen anzuzeigen.',
        'verify_vendor' => 'Anbieter verifizieren',
        'unverify_vendor' => 'Verifizierung aufheben',
        'verify_vendor_confirmation' => 'Anbieterverifizierung bestätigen',
        'verify_vendor_confirmation_desc' => 'Sind Sie sicher, dass Sie :name verifizieren möchten? Dies zeigt ein Verifizierungsabzeichen auf ihrem Profil an.',
        'unverify_vendor_confirmation' => 'Verifizierung aufheben bestätigen',
        'unverify_vendor_confirmation_desc' => 'Sind Sie sicher, dass Sie die Verifizierung von :name entfernen möchten? Das Verifizierungsabzeichen wird entfernt.',
        'verified_successfully' => 'Der Anbieter wurde erfolgreich verifiziert.',
        'unverified_successfully' => 'Die Anbieterverifizierung wurde erfolgreich entfernt.',
        'already_verified' => 'Dieser Anbieter ist bereits verifiziert.',
        'not_verified_yet' => 'Dieser Anbieter ist noch nicht verifiziert.',
        'recent_activity' => 'Letzte Aktivität',
        'recent_cars' => 'Neueste Fahrzeuge',
        'recent_bookings' => 'Neueste Buchungen',
        'no_cars_yet' => 'Noch keine Fahrzeuge hinzugefügt.',
        'no_bookings_yet' => 'Noch keine Buchungen erhalten.',
    ],
    'make' => [
        'name' => 'Marken',
        'create' => 'Fahrzeugmarke erstellen',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo dunkel',
        ],
    ],
    'car' => [
        'name' => 'Fahrzeuge',
        'create' => 'Fahrzeug erstellen',
        'forms' => [
            'car' => 'Fahrzeug',
            'logo' => 'Logo',
            'license_plate' => 'Kennzeichen',
            'make' => 'Marke',
            'model' => 'Modell',
            'name' => 'Name',
            'images' => 'Bilder',
            'year' => 'Jahr',
            'color' => 'Farbe',
            'mileage' => 'Kilometerstand',
            'kilometers' => 'Kilometer',
            'horsepower' => 'Pferdestärken',
            'vehicle_type' => 'Fahrzeugtyp',
            'transmission' => 'Getriebe',
            'fuel_type' => 'Kraftstoffart',
            'rental_rate' => 'Mietpreis',
            'currency' => 'Währung',
            'status' => 'Status',
            'availability' => 'Verfügbarkeit',
            'insurance_info' => 'Versicherungsinformationen',
            'number_of_seats' => 'Anzahl Sitze',
            'number_of_doors' => 'Anzahl Türen',
            'vin' => 'Fahrzeug-Identifizierungsnummer',
            'maintenance_history' => 'Wartungsverlauf',
            'location' => 'Standort',
            'description' => 'Beschreibung',
            'rental_type' => 'Mietart',
            'tags' => 'Schlagwörter',
            'add_new_attribute' => 'Neues <a href=":url" target="_blank">hier</a> hinzufügen.',
            'categories' => 'Kategorien',
            'pick_address' => 'Abholadresse',
            'return_address' => 'Rückgabeadresse',
            'same_drop_off' => 'Gleiche Rückgabe',
            'tax' => 'Steuer',
            'select_tax' => 'Steuer auswählen',
            'none' => 'Keine',
            'colors' => 'Farben',
            'amenities' => 'Ausstattung',
            'is_used' => 'Ist gebraucht?',
            'moderation_status' => 'Moderationsstatus',
            'status_moderation' => [
                'approve' => 'Genehmigen',
                'reject' => 'Ablehnen',
                'approve_title' => 'Fahrzeug genehmigen',
                'approve_message' => 'Sind Sie sicher, dass Sie dieses Fahrzeug genehmigen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
                'reject_title' => 'Fahrzeug ablehnen',
                'reject_message' => 'Sind Sie sicher, dass Sie dieses Fahrzeug ablehnen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
                'reject_reason' => 'Grund für die Ablehnung eingeben',
                'approved' => 'Fahrzeug wurde erfolgreich genehmigt!',
                'rejected' => 'Fahrzeug wurde erfolgreich abgelehnt!',
                'reason_rejected' => 'Ablehnungsgrund',
            ],
            'customer' => 'Kunde',
            'select_customer' => 'Kunde auswählen...',
            'vendor_images' => 'Bilder (Maximal :max Bilder)',
            'images_upload_placeholder' => 'Dateien hier ablegen oder zum Hochladen klicken.',
            'car_purpose' => 'Fahrzeugzweck',
            'for_rent' => 'Zur Miete',
            'for_sale' => 'Zum Verkauf',
            'car_type' => 'Fahrzeugtyp',
            'rental_information' => 'Mietinformationen',
            'sale_statuses' => [
                'available' => 'Verfügbar',
                'sold' => 'Verkauft',
                'reserved' => 'Reserviert',
            ],
            'selling_information' => 'Verkaufsinformationen',
            'is_for_sale' => 'Zum Verkauf verfügbar',
            'sale_price' => 'Verkaufspreis',
            'sale_price_placeholder' => 'Verkaufspreis eingeben',
            'condition' => 'Zustand',
            'select_condition' => 'Zustand auswählen',
            'condition_options' => [
                'new' => 'Neu',
                'like_new' => 'Wie neu',
                'excellent' => 'Ausgezeichnet',
                'good' => 'Gut',
                'fair' => 'Befriedigend',
                'poor' => 'Schlecht',
            ],
            'ownership_history' => 'Besitzverlauf',
            'ownership_history_placeholder' => 'Besitzverlauf eingeben',
            'warranty_information' => 'Garantieinformationen',
            'warranty_information_placeholder' => 'Garantieinformationen eingeben',
            'sale_status' => 'Verkaufsstatus',
            'external_booking_url' => 'Externe Buchungslink',
            'external_booking_url_helper' => 'Geben Sie die externe URL ein, unter der Kunden dieses Fahrzeug außerhalb dieser Plattform buchen können. Leer lassen, wenn die Buchung nur auf dieser Seite verfügbar ist.',
            'address' => 'Adresse',
            'address_helper' => 'Geben Sie die genaue Straßenadresse ein, an der sich dieses Fahrzeug befindet',
        ],
        'car_purposes' => [
            'sale' => 'Zum Verkauf',
            'rent' => 'Zur Miete',
        ],
        'placeholders' => [
            'name' => 'Fahrzeugname eingeben (z.B. Toyota Camry 2023, Honda CR-V, usw.)',
            'description' => 'Geben Sie eine kurze Beschreibung des Fahrzeugs mit Hervorhebung der wichtigsten Merkmale ein',
            'rental_rate' => 'Geben Sie den Mietpreis basierend auf der ausgewählten Mietart ein',
            'location' => 'Geben Sie den physischen Standort des Fahrzeugs ein',
            'address' => 'Geben Sie die genaue Straßenadresse ein (z.B. Musterstraße 123, Stadt, Bundesland)',
            'sale_price' => 'Geben Sie den Verkaufspreis für dieses Fahrzeug ein',
            'ownership_history' => 'Geben Sie Details zu früheren Besitzern, Anzahl der Besitzer usw. ein',
            'warranty_information' => 'Geben Sie Details zur Garantieabdeckung, Ablaufdatum usw. ein',
            'external_booking_url' => 'https://beispiel.de/buchungslink',
            'license_plate' => 'Fahrzeugkennzeichen eingeben',
            'vin' => 'Fahrzeug-Identifizierungsnummer (FIN) eingeben',
            'year' => 'Baujahr eingeben (z.B. 2023)',
            'mileage' => 'Aktuellen Kilometerstand eingeben',
            'kilometers' => 'Aktuelle Kilometer eingeben',
            'horsepower' => 'Pferdestärken (PS) des Fahrzeugs eingeben (z.B. 150,5)',
            'number_of_seats' => 'Anzahl der Sitze im Fahrzeug eingeben',
            'number_of_doors' => 'Anzahl der Türen des Fahrzeugs eingeben',
            'insurance_info' => 'Relevante Versicherungsinformationen für dieses Fahrzeug eingeben',
            'tags' => 'Schlagwörter auswählen oder erstellen',
            'amenities' => 'Ausstattung auswählen',
            'colors' => 'Farben auswählen oder erstellen',
        ],
        'enums' => [
            'vendor_status' => 'Anbieter-Status',
            'is_vendor' => 'Anbieter',
            'not_vendor' => 'Kunde',
            'statuses' => [
                'available' => 'Verfügbar',
                'rented' => 'Vermietet',
                'maintenance' => 'Wartung',
                'out_of_service' => 'Außer Betrieb',
            ],
            'rental_types' => [
                'per_hour' => 'Pro Stunde',
                'per_day' => 'Pro Tag',
                'per_week' => 'Pro Woche',
                'per_month' => 'Pro Monat',
            ],
            'moderation_statuses' => [
                'pending' => 'Ausstehend',
                'approved' => 'Genehmigt',
                'rejected' => 'Abgelehnt',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Wartungsverläufe',
            'create' => 'Serviceverlauf erstellen',
            'amount' => 'Betrag',
            'forms' => [
                'price_placeholder' => 'Servicepreis',
                'currency' => 'Währung',
                'none' => 'Keine',
                'name' => 'Name',
                'amount' => 'Betrag',
                'created_at' => 'Erstellt am',
                'action' => 'Aktion',
                'date' => 'Datum',
                'no_maintenance_history' => 'Keine Wartungsverläufe',
                'edit_maintenance_history' => 'Wartungsverlauf bearbeiten',
                'add_maintenance_history' => 'Wartungsverlauf hinzufügen',
                'add' => 'Hinzufügen',
                'edit' => 'Bearbeiten',
                'delete' => 'Löschen',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Fahrzeugattribute',
        'car_type' => [
            'name' => 'Typen',
            'create' => 'Fahrzeugtyp erstellen',
            'forms' => [
                'name' => 'Name',
            ],
        ],
        'transmission' => [
            'name' => 'Getriebe',
            'create' => 'Getriebe erstellen',
            'forms' => [
                'name' => 'Name',
            ],
        ],
        'fuel_type' => [
            'name' => 'Kraftstoffe',
            'create' => 'Kraftstoffart erstellen',
            'forms' => [
                'name' => 'Name',
            ],
        ],
        'tag' => [
            'name' => 'Schlagwörter',
            'create' => 'Schlagwort erstellen',
        ],
        'category' => [
            'name' => 'Kategorien',
            'create' => 'Kategorie erstellen',
            'forms' => [
                'none' => 'Keine',
                'total_cars' => 'Gesamtfahrzeuge: :total',
            ],
        ],
        'address' => [
            'name' => 'Standorte',
            'create' => 'Fahrzeugstandort erstellen',
            'form' => [
                'name' => 'Adresse',
                'full_address' => 'Vollständige Adresse',
                'detail_address' => 'Detailierte Adresse',
            ],
        ],
        'color' => [
            'name' => 'Farbe',
            'create' => 'Farbe erstellen',
        ],
        'amenity' => [
            'name' => 'Ausstattung',
            'create' => 'Ausstattung erstellen',
        ],
    ],
    'tax' => [
        'name' => 'Steuern',
        'create' => 'Steuer erstellen',
        'forms' => [
            'name' => 'Name',
            'name_placeholder' => 'Name eingeben',
            'percentage' => 'Prozentsatz',
            'percentage_placeholder' => 'Prozentsatz',
            'percent_placeholder' => 'Prozentsatz',
            'priority' => 'Priorität',
            'priority_placeholder' => 'Priorität',
        ],
    ],
    'review' => [
        'name' => 'Bewertungen',
        'create' => 'Bewertung erstellen',
        'edit' => 'Bewertung bearbeiten',
        'vendor' => [
            'title' => 'Kundenbewertungen',
            'description' => 'Alle Kundenbewertungen für Ihre Fahrzeuge verwalten',
            'no_reviews' => 'Sie haben noch keine Bewertungen',
            'filter_by_car' => 'Nach Fahrzeug filtern',
            'filter_by_rating' => 'Nach Bewertung filtern',
            'filter_by_date' => 'Nach Datum filtern',
            'all_cars' => 'Alle Fahrzeuge',
            'all_ratings' => 'Alle Bewertungen',
            'manage_reviews' => 'Bewertungen verwalten',
            'view_all' => 'Alle Bewertungen anzeigen',
            'delete_review_confirmation' => 'Sind Sie sicher, dass Sie diese Bewertung löschen möchten?',
            'delete_review_success' => 'Bewertung erfolgreich gelöscht',
            'cannot_delete' => 'Diese Bewertung kann nicht gelöscht werden',
        ],
        'forms' => [
            'customer' => 'Kunde',
            'car' => 'Fahrzeug',
            'content' => 'Inhalt',
            'rating' => 'Bewertung',
            'your_name' => 'Ihr Name',
            'email_address' => 'E-Mail-Adresse',
            'submit' => 'Absenden',
            'star' => 'Stern',
            'status' => 'Status',
            'created_at' => 'Erstellt am',
            'select_car' => 'Fahrzeug auswählen',
            'select_rating' => 'Bewertung auswählen',
            'comment' => 'Kommentar',
            'reply' => 'Antworten',
            'reply_to_review' => 'Auf Bewertung antworten',
            'save_reply' => 'Antwort speichern',
            'cancel_reply' => 'Abbrechen',
        ],
        'statuses' => [
            'published' => 'Veröffentlicht',
            'pending' => 'Ausstehend',
            'rejected' => 'Abgelehnt',
        ],
        'ratings' => [
            1 => '1 Stern - Schlecht',
            '2 Sterne - Ausreichend',
            '3 Sterne - Gut',
            '4 Sterne - Sehr gut',
            '5 Sterne - Ausgezeichnet',
        ],
    ],
    'coupon' => [
        'name' => 'Gutscheine',
        'create' => 'Gutschein erstellen',
        'types' => [
            'percentage' => 'Prozentsatz %',
            'money' => 'Geldbetrag',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'Dienstleistungen',
        'create' => 'Dienstleistung erstellen',
        'forms' => [
            'name' => 'Name',
            'content' => 'Inhalt',
            'price' => 'Preis',
            'currency' => 'Währung',
            'image' => 'Bild',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Verfügbarkeitskalender',
        'title' => 'Verfügbarkeitskalender',
        'description' => 'Fahrzeugverfügbarkeit und Buchungen im Kalenderformat anzeigen',
        'select_dates' => 'Daten auswählen, um Verfügbarkeit zu prüfen',
        'car_filter' => 'Nach Fahrzeug filtern',
        'all_cars' => 'Alle Fahrzeuge',
        'clear_filter' => 'Filter löschen',
        'availability_check' => 'Fahrzeugverfügbarkeitsprüfung',
        'selected_period' => 'Ausgewählter Zeitraum',
        'checking_availability' => 'Verfügbarkeit wird geprüft...',
        'available' => 'Verfügbar',
        'not_available' => 'Nicht verfügbar',
        'booking_details' => 'Buchungsdetails',
        'how_to_use' => 'Wie man den Fahrzeugverfügbarkeitskalender benutzt',
        'viewing_bookings' => 'Buchungen anzeigen',
        'checking_availability_help' => 'Verfügbarkeit prüfen',
        'color_legend' => 'Farblegende',
        'pending_bookings' => 'Ausstehende Buchungen',
        'processing_bookings' => 'Buchungen in Bearbeitung',
        'completed_bookings' => 'Abgeschlossene Buchungen',
        'cancelled_bookings' => 'Stornierte Buchungen',
        'unknown_make' => 'Unbekannte Marke',
        'loading' => 'Wird geladen...',
        'loading_calendar_data' => 'Kalenderdaten werden geladen...',
        'loading_booking_details' => 'Buchungsdetails werden geladen...',
        'please_wait_booking_info' => 'Bitte warten Sie, während wir die Buchungsinformationen abrufen.',
        'please_wait_availability' => 'Bitte warten Sie, während wir die Fahrzeugverfügbarkeit für Ihre ausgewählten Daten prüfen.',
        'error' => 'Fehler',
        'error_loading_booking' => 'Fehler beim Laden der Buchungsdetails. Bitte versuchen Sie es erneut.',
        'error_checking_availability' => 'Fehler beim Prüfen der Fahrzeugverfügbarkeit',
        'customer' => 'Kunde',
        'status' => 'Status',
        'amount' => 'Betrag',
        'make' => 'Marke',
        'vendor' => 'Anbieter',
        'per_day' => '/Tag',
        'edit_car' => 'Fahrzeug bearbeiten',
        'no_cars_found' => 'Keine Fahrzeuge gefunden',
        'no_cars_available_period' => 'Es sind keine Fahrzeuge für den ausgewählten Zeitraum verfügbar.',
        'close' => 'Schließen',
        'edit_booking' => 'Buchung bearbeiten',
        'pending' => 'Ausstehend',
        'processing' => 'In Bearbeitung',
        'completed' => 'Abgeschlossen',
        'cancelled' => 'Storniert',
    ],
    'theme_options' => [
        'name' => 'Autovermietung',
        'description' => 'Theme-Optionen für Autovermietung',
        'car_location_filter_by' => 'Fahrzeugstandortfilter nach',
        'state' => 'Bundesland',
        'city' => 'Stadt',
        'yes' => 'Ja',
        'no' => 'Nein',
        'is_display_country' => 'Land im Standortfilter anzeigen?',
        'logo_vendor_dashboard' => 'Logo im Anbieter-Dashboard (Standard ist das Hauptlogo)',
        'number_of_cars_per_page' => 'Anzahl der Fahrzeuge pro Seite',
        'number_of_cars_per_page_placeholder' => 'Anzahl der anzuzeigenden Fahrzeuge pro Seite eingeben',
    ],
    'message' => [
        'name' => 'Nachrichten',
        'forms' => [
            'customer_name' => 'Kundenname',
            'message' => 'Nachricht',
            'phone' => 'Telefon',
            'email' => 'E-Mail',
            'created_at' => 'Erstellt am',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Fahrzeugverkäufe',
        'create' => 'Neuer Fahrzeugverkauf',
        'edit' => 'Fahrzeugverkauf bearbeiten :name',
        'statuses' => [
            'pending' => 'Ausstehend',
            'processing' => 'In Bearbeitung',
            'completed' => 'Abgeschlossen',
            'cancelled' => 'Storniert',
        ],
        'forms' => [
            'transaction_id' => 'Transaktions-ID',
            'transaction_id_placeholder' => 'Transaktions-ID eingeben',
            'car_id' => 'Fahrzeug',
            'car' => 'Fahrzeug',
            'customer_id' => 'Kunde',
            'customer_name' => 'Kundenname',
            'customer_name_placeholder' => 'Kundenname eingeben',
            'customer_email' => 'Kunden-E-Mail',
            'customer_email_placeholder' => 'Kunden-E-Mail eingeben',
            'customer_phone' => 'Kundentelefon',
            'customer_phone_placeholder' => 'Kundentelefon eingeben',
            'sale_price' => 'Verkaufspreis',
            'sale_price_placeholder' => 'Verkaufspreis eingeben',
            'tax_amount' => 'Steuerbetrag',
            'tax_amount_placeholder' => 'Steuerbetrag eingeben',
            'total_amount' => 'Gesamtbetrag',
            'total_amount_placeholder' => 'Gesamtbetrag eingeben',
            'payment_details' => 'Zahlungsdetails',
            'payment_details_placeholder' => 'Zahlungsdetails eingeben',
            'notes' => 'Notizen',
            'notes_placeholder' => 'Notizen eingeben',
            'sale_date' => 'Verkaufsdatum',
            'delivery_date' => 'Lieferdatum',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Banküberweisung',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        'booking_confirm_title' => 'Autovermietung Buchungsbestätigung',
        'booking_confirm_greeting' => 'Sehr geehrte/r :customer_name,',
        'booking_confirm_message' => 'Wir freuen uns, Ihnen mitteilen zu können, dass Ihre Autovermietungsbuchung erfolgreich bestätigt wurde!',
        'customer_information' => 'Kundeninformationen',
        'booking_information' => 'Buchungsinformationen',
        'field_name' => 'Name:',
        'field_phone' => 'Telefon:',
        'field_email' => 'E-Mail:',
        'field_car_model' => 'Fahrzeugmodell:',
        'field_start_date' => 'Startdatum:',
        'field_end_date' => 'Enddatum:',
        'field_pickup_address' => 'Abholadresse:',
        'field_return_address' => 'Rückgabeadresse:',
        'field_note' => 'Notiz:',
        'field_order_number' => 'Bestellnummer',
        'field_payment_method' => 'Zahlungsmethode',
        'booking_notice_admin_title' => 'Neue Buchungsbenachrichtigung',
        'booking_notice_admin_greeting' => 'Hallo, es gibt eine neue Buchung von :site_title:',
        'booking_notice_admin_message' => 'Eine neue Autovermietungsbuchung wurde eingereicht und erfordert Ihre Aufmerksamkeit.',
        'booking_view_detail' => 'Buchungsdetails anzeigen:',
        'view_booking_details' => 'Buchungsdetails anzeigen',
        'booking_notice_vendor_title' => 'Neue Buchung für Ihr Fahrzeug',
        'booking_notice_vendor_greeting' => 'Sehr geehrte/r :vendor_name,',
        'booking_notice_vendor_message' => 'Großartige Neuigkeiten! Sie haben eine neue Buchung für Ihre Autovermietung erhalten.',
        'booking_status_updated' => 'Buchungsstatus aktualisiert',
        'hello_thanks_for_booking' => 'Hallo, vielen Dank für Ihre Buchung von :site_title:',
        'booking_status_change_message' => 'Wir hoffen, diese Nachricht erreicht Sie wohlauf. Wir möchten Sie darüber informieren, dass der Status Ihrer Buchung aktualisiert wurde.',
        'name' => 'Name',
        'phone' => 'Telefon',
        'email' => 'E-Mail',
        'car_model' => 'Fahrzeugmodell',
        'start_date' => 'Startdatum',
        'end_date' => 'Enddatum',
        'pickup_address' => 'Abholadresse',
        'return_address' => 'Rückgabeadresse',
        'note' => 'Notiz',
        'order_number' => 'Bestellnummer',
        'payment_method' => 'Zahlungsmethode',
        'hello' => 'Hallo',
        'car_approved_title' => 'Großartige Neuigkeiten! Ihr Fahrzeug wurde genehmigt',
        'car_approved_message' => 'Wir freuen uns, Ihnen mitteilen zu können, dass Ihre Fahrzeuganzeige ":car_name" genehmigt wurde und nun auf :site_title live ist. Sie können jetzt Buchungen erhalten und Ihre Anzeige sofort verwalten.',
        'view_edit_car_link' => 'Um Ihre Fahrzeuganzeige anzusehen oder zu bearbeiten, klicken Sie bitte auf diesen Link',
        'view_car' => 'Fahrzeuganzeige anzeigen',
        'regards' => 'Mit freundlichen Grüßen',
        'vendor_upgrade_title' => 'Herzlichen Glückwunsch! Sie sind jetzt ein Anbieter',
        'vendor_upgrade_congratulations' => 'Wir freuen uns, Ihnen mitteilen zu können, dass Ihr Konto erfolgreich auf Anbieter-Status upgegraded wurde!',
        'vendor_upgrade_message' => 'Sie können jetzt Ihre eigenen Fahrzeuge auf :site_title listen und verwalten. Dies eröffnet Ihnen neue Möglichkeiten, Ihr Mietgeschäft mit uns auszubauen.',
        'vendor_benefits_title' => 'Ihre neuen Anbietervorteile',
        'vendor_benefit_1' => 'Unbegrenzt Fahrzeuge zur Vermietung listen',
        'vendor_benefit_2' => 'Verwalten Sie Ihre eigenen Buchungen und Kunden',
        'vendor_benefit_3' => 'Umsatz- und Leistungskennzahlen verfolgen',
        'vendor_benefit_4' => 'Zugriff auf exklusive Anbieter-Funktionen und -Tools',
        'next_steps' => 'Nächste Schritte',
        'vendor_next_steps_message' => 'Melden Sie sich bei Ihrem Anbieter-Dashboard an, um mit dem Hinzufügen Ihrer Fahrzeuge und der Verwaltung Ihres Mietgeschäfts zu beginnen.',
        'go_to_dashboard' => 'Zum Anbieter-Dashboard',
        'vendor_support_message' => 'Wenn Sie Fragen haben oder Unterstützung benötigen, steht Ihnen unser Support-Team gerne zur Verfügung.',
        'approved' => 'Genehmigt',
        'car_rejected_title' => 'Aktualisierung erforderlich für Ihre Fahrzeuganzeige',
        'car_rejected_message' => 'Vielen Dank für die Einreichung Ihrer Fahrzeuganzeige ":car_name" bei :site_title. Nach Überprüfung Ihrer Einreichung müssen Sie einige Anpassungen vornehmen, bevor wir sie genehmigen können.',
        'rejection_reason' => 'Das muss aktualisiert werden',
        'rejection_details' => 'Erforderliche Aktualisierungen',
        'contact_support' => 'Wenn Sie Fragen haben oder Unterstützung bei diesen Aktualisierungen benötigen, zögern Sie bitte nicht, unser Support-Team unter :site_email zu kontaktieren. Wir sind hier, um Ihnen zu helfen, Ihre Anzeige schnell genehmigt zu bekommen.',
        'verify_email' => 'E-Mail verifizieren',
        'welcome_message' => 'Wir freuen uns, Sie hier zu haben, :customer_name!',
        'verify_email_instruction' => 'Bitte verifizieren Sie Ihre E-Mail-Adresse, um auf diese Website zugreifen zu können. Klicken Sie auf die Schaltfläche unten, um Ihre E-Mail zu verifizieren.',
        'confirm_email_button' => 'Bestätigen Sie Ihre E-Mail-Adresse',
        'verify_link_trouble' => 'Wenn Sie Probleme beim Klicken auf die Schaltfläche "E-Mail-Adresse bestätigen" haben, kopieren Sie die folgende URL und fügen Sie sie in Ihren Webbrowser ein: :verify_link',
        'new_message' => 'Neue Nachricht',
        'dear_admin' => 'Sehr geehrter Administrator',
        'new_message_from' => 'Es gibt eine neue Nachricht von :site_title:',
        'subject' => 'Betreff',
        'address' => 'Adresse',
        'content' => 'Inhalt',
        'hi_admin' => 'Hallo Administrator,',
        'new_car_pending_title' => 'Neue Fahrzeuganzeige wartet auf Überprüfung',
        'new_car_pending_approval' => 'Eine neue Fahrzeuganzeige ":post_name" wurde von :post_author eingereicht und wartet auf Ihre Überprüfung.',
        'pending_approval' => 'Wartet auf Überprüfung',
        'review_car_admin' => 'Bitte überprüfen Sie diese Anzeige im Admin-Panel und genehmigen Sie sie oder fordern Sie Aktualisierungen an.',
        'car_information' => 'Fahrzeuginformationen',
        'field_car_name' => 'Fahrzeugname:',
        'field_author' => 'Autor:',
        'field_status' => 'Status:',
        'actions' => 'Aktionen',
        'reset_password_instruction' => 'Passwort zurücksetzen Anleitung',
        'password_reset_request' => 'Sie erhalten diese E-Mail, weil wir eine Anfrage zum Zurücksetzen des Passworts für Ihr Konto erhalten haben.',
        'reset_password_button' => 'Passwort zurücksetzen',
        'reset_link_trouble' => 'Wenn Sie Probleme beim Klicken auf die Schaltfläche "Passwort zurücksetzen" haben, kopieren Sie die folgende URL und fügen Sie sie in Ihren Webbrowser ein: :reset_link. Wenn Sie keine Passwort-Zurücksetzung angefordert haben, ignorieren Sie bitte diese Nachricht oder kontaktieren Sie uns, wenn Sie Fragen haben.',
    ],
];
