<?php

return [
    'name' => 'Car Rentals',
    'icon' => 'Icon',
    'customer' => [
        'name' => 'Customers',
        'create' => 'Create Customer',
        'view' => 'View',
        'information' => 'Customer Information',
        'email' => 'Email',
        'phone' => 'Phone',
        'status' => 'Status',
        'vendor_status' => 'Vendor Status',
        'is_vendor' => 'Vendor',
        'not_vendor' => 'Customer',
        'recent_activity' => 'Recent Activity',
        'recent_activity_description' => 'Customer activity will appear here.',
        'verification_section' => 'Customer Verification',
        'verified' => 'Verified',
        'not_verified' => 'Not Verified',
        'verified_by' => 'Verified By',
        'verified_at' => 'Verified At',
        'verify_customer' => 'Verify Customer',
        'unverify_customer' => 'Unverify Customer',
        'verify_customer_confirmation' => 'Verify Customer Confirmation',
        'verify_customer_confirmation_desc' => 'Are you sure you want to verify :name? This will display a verified badge on their profile.',
        'unverify_customer_confirmation' => 'Unverify Customer Confirmation',
        'unverify_customer_confirmation_desc' => 'Are you sure you want to remove verification from :name? The verified badge will be removed.',
        'verify_success' => 'Customer :name has been verified successfully.',
        'unverify_success' => 'Customer :name verification has been removed successfully.',
        'already_verified' => 'This customer is already verified.',
        'already_unverified' => 'This customer is not verified.',
        'upgrade_to_vendor_title' => 'Upgrade to Vendor',
        'upgrade_to_vendor_description' => 'Upgrade this customer to vendor status to allow them to list and manage their own car rentals.',
        'upgrade_to_vendor_button' => 'Upgrade to Vendor',
        'upgrade_to_vendor_confirmation' => 'Confirm Upgrade to Vendor',
        'upgrade_to_vendor_confirmation_desc' => 'Are you sure you want to upgrade :name to vendor status? This will allow them to list and manage their own cars on the platform.',
        'upgrade_to_vendor_success' => ':name has been successfully upgraded to vendor status.',
        'already_vendor' => 'This customer is already a vendor.',
        'email_verified' => 'Email Verified',
        'email_not_verified' => 'Email Not Verified',
        'verify_email_warning_message' => 'This customer\'s email address has not been verified. You can manually verify it to confirm their email is valid.',
        'verify_email_title' => 'Verify Email Address',
        'verify_email_description' => 'This customer\'s email address has not been verified. You can manually verify it to confirm their email is valid.',
        'verify_email_button' => 'Verify Email',
        'verify_email_confirmation' => 'Confirm Email Verification',
        'verify_email_confirmation_desc' => 'Are you sure you want to verify the email address :email for :name? This will mark their email as confirmed.',
        'verify_email_success' => 'Email :email has been successfully verified for :name.',
        'email_already_verified' => 'This email address is already verified.',
        'resend_confirmation_button' => 'Resend Confirmation Email',
        'resend_confirmation_title' => 'Resend Confirmation Email',
        'resend_confirmation_desc' => 'Are you sure you want to resend the confirmation email to :email for :name? This will send a new verification link to their email address.',
        'resend_confirmation_success' => 'Confirmation email has been sent to :email.',
        'resend_confirmation_error' => 'Failed to send confirmation email. Please try again.',
        'customer_verified_successfully' => 'This customer has been verified and can be trusted.',
        'customer_not_verified_yet' => 'This customer has not been verified yet.',
        'verification_pending' => 'Verification Pending',
        'click_verify_to_approve' => 'Click the button below to verify this customer and display the verified badge.',
        'verification_note' => 'Verification Note',
        'verification_note_placeholder' => 'Enter any notes about this verification action...',
        'verification_note_helper' => 'Add notes about the verification process (internal use only)',
        'forms' => [
            'name' => 'Name',
            'email' => 'Email',
            'phone' => 'Phone',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Avatar',
            'dob' => 'Date of Birth',
            'company' => 'Company',
            'position' => 'Position',
            'password' => 'Password',
            'password_confirmation' => 'Password confirmation',
            'change_password' => 'Change password?',
            'phone_placeholder' => 'Phone',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => 'Vendors',
        'view' => 'View :name',
        'information' => 'Vendor Information',
        'total_cars' => 'Total Cars',
        'total_bookings' => 'Total Bookings',
        'verified' => 'Verified',
        'not_verified' => 'Not Verified',
        'verification_section' => 'Vendor Verification',
        'vendor_verified_successfully' => 'This vendor has been verified and can be trusted.',
        'vendor_not_verified_yet' => 'This vendor has not been verified yet.',
        'verification_pending' => 'Verification Pending',
        'click_verify_to_approve' => 'Click the button below to verify this vendor and display the verified badge.',
        'verify_vendor' => 'Verify Vendor',
        'unverify_vendor' => 'Unverify Vendor',
        'verify_vendor_confirmation' => 'Verify Vendor Confirmation',
        'verify_vendor_confirmation_desc' => 'Are you sure you want to verify :name? This will display a verified badge on their profile.',
        'unverify_vendor_confirmation' => 'Unverify Vendor Confirmation',
        'unverify_vendor_confirmation_desc' => 'Are you sure you want to remove verification from :name? The verified badge will be removed.',
        'verified_successfully' => 'Vendor has been verified successfully.',
        'unverified_successfully' => 'Vendor verification has been removed successfully.',
        'already_verified' => 'This vendor is already verified.',
        'not_verified_yet' => 'This vendor is not verified yet.',
        'recent_activity' => 'Recent Activity',
        'recent_cars' => 'Recent Cars',
        'recent_bookings' => 'Recent Bookings',
        'no_cars_yet' => 'No cars added yet.',
        'no_bookings_yet' => 'No bookings received yet.',
    ],
    'make' => [
        'name' => 'Makes',
        'create' => 'Create Car Make',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Dark',
        ],
    ],
    'car' => [
        'name' => 'Cars',
        'create' => 'Create Car',
        'forms' => [
            'car' => 'Car',
            'logo' => 'Logo',
            'license_plate' => 'License Plate',
            'make' => 'Make',
            'model' => 'Model',
            'name' => 'Name',
            'images' => 'Images',
            'year' => 'Year',
            'color' => 'Color',
            'mileage' => 'Mileage',
            'kilometers' => 'Kilometers',
            'horsepower' => 'Horsepower',
            'vehicle_type' => 'Vehicle Type',
            'transmission' => 'Transmission',
            'fuel_type' => 'Fuel Type',
            'rental_rate' => 'Rental Rate',
            'currency' => 'Currency',
            'status' => 'Status',
            'availability' => 'Availability',
            'insurance_info' => 'Insurance information',
            'number_of_seats' => 'Number Seats',
            'number_of_doors' => 'Number Doors',
            'vin' => 'VIN',
            'maintenance_history' => 'Maintenance History',
            'location' => 'Location',
            'description' => 'Description',
            'rental_type' => 'Rental Type',
            'tags' => 'Tags',
            'add_new_attribute' => 'Add new <a href=":url" target="_blank">here</a>.',
            'categories' => 'Categories',
            'pick_address' => 'Pick Address',
            'return_address' => 'Return Address',
            'same_drop_off' => 'Same Drop-Off',
            'tax' => 'Tax',
            'select_tax' => 'Select Tax',
            'none' => 'None',
            'colors' => 'Colors',
            'amenities' => 'Amenities',
            'is_used' => 'Is used?',
            'moderation_status' => 'Moderation status',
            'status_moderation' => [
                'approve' => 'Approve',
                'reject' => 'Reject',
                'approve_title' => 'Approve car',
                'approve_message' => 'Are you sure you want to approve this car? This action cannot be undone.',
                'reject_title' => 'Reject car',
                'reject_message' => 'Are you sure you want to reject this car? This action cannot be undone.',
                'reject_reason' => 'Enter the reason for rejection',
                'approved' => 'Car has been approved successfully!',
                'rejected' => 'Car has been rejected successfully!',
                'reason_rejected' => 'Reason rejected',
            ],
            'customer' => 'Customer',
            'select_customer' => 'Select a customer...',
            'vendor_images' => 'Images (Maximum :max images)',
            'images_upload_placeholder' => 'Drop files here or click to upload.',
            'car_purpose' => 'Car Purpose',
            'for_rent' => 'For Rent',
            'for_sale' => 'For Sale',
            'car_type' => 'Car Type',
            'rental_information' => 'Rental Information',
            'sale_statuses' => [
                'available' => 'Available',
                'sold' => 'Sold',
                'reserved' => 'Reserved',
            ],
            'selling_information' => 'Selling Information',
            'is_for_sale' => 'Available for sale',
            'sale_price' => 'Sale Price',
            'sale_price_placeholder' => 'Enter sale price',
            'condition' => 'Condition',
            'select_condition' => 'Select Condition',
            'condition_options' => [
                'new' => 'New',
                'like_new' => 'Like New',
                'excellent' => 'Excellent',
                'good' => 'Good',
                'fair' => 'Fair',
                'poor' => 'Poor',
            ],
            'ownership_history' => 'Ownership History',
            'ownership_history_placeholder' => 'Enter ownership history',
            'warranty_information' => 'Warranty Information',
            'warranty_information_placeholder' => 'Enter warranty information',
            'sale_status' => 'Sale Status',
            'external_booking_url' => 'Off-Site Booking Link',
            'external_booking_url_helper' => 'Enter the external URL where customers can book this car outside of this platform. Leave empty if booking is only available on this site.',
            'address' => 'Address',
            'address_helper' => 'Enter the specific street address where this vehicle is located',
        ],
        'car_purposes' => [
            'sale' => 'For Sale',
            'rent' => 'For Rent',
        ],
        'placeholders' => [
            'name' => 'Enter the vehicle name (e.g., Toyota Camry 2023, Honda CR-V, etc.)',
            'description' => 'Enter a brief description of the vehicle highlighting key features',
            'rental_rate' => 'Enter the rental rate based on the selected rental type',
            'location' => 'Enter the physical location of the vehicle',
            'address' => 'Enter the specific street address (e.g., 123 Main St, City, State)',
            'sale_price' => 'Enter the selling price for this vehicle',
            'ownership_history' => 'Enter details about previous owners, number of owners, etc.',
            'warranty_information' => 'Enter details about warranty coverage, expiration date, etc.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Enter vehicle license plate number',
            'vin' => 'Enter the Vehicle Identification Number (VIN)',
            'year' => 'Enter the manufacturing year (e.g., 2023)',
            'mileage' => 'Enter the current mileage',
            'kilometers' => 'Enter the current kilometers',
            'horsepower' => 'Enter the horsepower (HP) of the vehicle (e.g., 150.5)',
            'number_of_seats' => 'Enter the number of seats in the vehicle',
            'number_of_doors' => 'Enter the number of doors the vehicle has',
            'insurance_info' => 'Enter relevant insurance information for this vehicle',
            'tags' => 'Select or create tags',
            'amenities' => 'Select amenities',
            'colors' => 'Select or create colors',
        ],
        'enums' => [
            'vendor_status' => 'Vendor Status',
            'is_vendor' => 'Vendor',
            'not_vendor' => 'Customer',
            'statuses' => [
                'available' => 'Available',
                'rented' => 'Rented',
                'maintenance' => 'Maintenance',
                'out_of_service' => 'Out of Service',
            ],
            'rental_types' => [
                'per_hour' => 'Per hour',
                'per_day' => 'Per day',
                'per_week' => 'Per week',
                'per_month' => 'Per month',
            ],
            'moderation_statuses' => [
                'pending' => 'Pending',
                'approved' => 'Approved',
                'rejected' => 'Rejected',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Maintenance Histories',
            'create' => 'Create Service History',
            'amount' => 'Amount',
            'forms' => [
                'price_placeholder' => 'Price service',
                'currency' => 'Currency',
                'none' => 'None',
                'name' => 'Name',
                'amount' => 'Amount',
                'created_at' => 'Created At',
                'action' => 'Action',
                'date' => 'Date',
                'no_maintenance_history' => 'No maintenance histories',
                'edit_maintenance_history' => 'Edit maintenance history',
                'add_maintenance_history' => 'Add maintenance history',
                'add' => 'Add',
                'edit' => 'Edit',
                'delete' => 'Delete',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Car Attributes',
        'car_type' => [
            'name' => 'Types',
            'create' => 'Create Car Type',
            'forms' => [
                'name' => 'Name',
            ],
        ],
        'transmission' => [
            'name' => 'Transmissions',
            'create' => 'Create Transmission',
            'forms' => [
                'name' => 'Name',
            ],
        ],
        'fuel_type' => [
            'name' => 'Fuels',
            'create' => 'Create Fuel Types',
            'forms' => [
                'name' => 'Name',
            ],
        ],
        'tag' => [
            'name' => 'Tags',
            'create' => 'Create Tag',
        ],
        'category' => [
            'name' => 'Categories',
            'create' => 'Create Category',
            'forms' => [
                'none' => 'None',
                'total_cars' => 'Total cars: :total',
            ],
        ],
        'address' => [
            'name' => 'Locations',
            'create' => 'Create Car Location',
            'form' => [
                'name' => 'Address',
                'full_address' => 'Full Address',
                'detail_address' => 'Detail Address',
            ],
        ],
        'color' => [
            'name' => 'Color',
            'create' => 'Create Color',
        ],
        'amenity' => [
            'name' => 'Amenities',
            'create' => 'Create Amenity',
        ],
    ],
    'tax' => [
        'name' => 'Taxes',
        'create' => 'Create Tax',
        'forms' => [
            'name' => 'Name',
            'name_placeholder' => 'Enter name',
            'percentage' => 'Percentage',
            'percentage_placeholder' => 'Percentage',
            'percent_placeholder' => 'Percentage',
            'priority' => 'Priority',
            'priority_placeholder' => 'Priority',
        ],
    ],
    'review' => [
        'name' => 'Reviews',
        'create' => 'Create Review',
        'edit' => 'Edit Review',
        'vendor' => [
            'title' => 'Customer Reviews',
            'description' => 'Manage all customer reviews for your cars',
            'no_reviews' => 'You have no reviews yet',
            'filter_by_car' => 'Filter by car',
            'filter_by_rating' => 'Filter by rating',
            'filter_by_date' => 'Filter by date',
            'all_cars' => 'All Cars',
            'all_ratings' => 'All Ratings',
            'manage_reviews' => 'Manage Reviews',
            'view_all' => 'View All Reviews',
            'delete_review_confirmation' => 'Are you sure you want to delete this review?',
            'delete_review_success' => 'Review deleted successfully',
            'cannot_delete' => 'Cannot delete this review',
        ],
        'forms' => [
            'customer' => 'Customer',
            'car' => 'Car',
            'content' => 'Content',
            'rating' => 'Rating',
            'your_name' => 'Your Name',
            'email_address' => 'Email Address',
            'submit' => 'Submit',
            'star' => 'Star',
            'status' => 'Status',
            'created_at' => 'Created At',
            'select_car' => 'Select Car',
            'select_rating' => 'Select Rating',
            'comment' => 'Comment',
            'reply' => 'Reply',
            'reply_to_review' => 'Reply to Review',
            'save_reply' => 'Save Reply',
            'cancel_reply' => 'Cancel',
        ],
        'statuses' => [
            'published' => 'Published',
            'pending' => 'Pending',
            'rejected' => 'Rejected',
        ],
        'ratings' => [
            '1' => '1 Star - Poor',
            '2' => '2 Stars - Fair',
            '3' => '3 Stars - Good',
            '4' => '4 Stars - Very Good',
            '5' => '5 Stars - Excellent',
        ],
    ],
    'coupon' => [
        'name' => 'Coupons',
        'create' => 'Create Coupon',
        'types' => [
            'percentage' => 'Percentage %',
            'money' => 'Money',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Services',
        'create' => 'Create Service',
        'forms' => [
            'name' => 'Name',
            'content' => 'Content',
            'price' => 'Price',
            'currency' => 'Currency',
            'image' => 'Image',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Availability Calendar',
        'title' => 'Availability Calendar',
        'description' => 'View car availability and bookings in calendar format',
        'select_dates' => 'Select dates to check availability',
        'car_filter' => 'Filter by Car',
        'all_cars' => 'All Cars',
        'clear_filter' => 'Clear Filter',
        'availability_check' => 'Car Availability Check',
        'selected_period' => 'Selected Period',
        'checking_availability' => 'Checking availability...',
        'available' => 'Available',
        'not_available' => 'Not Available',
        'booking_details' => 'Booking Details',
        'how_to_use' => 'How to Use the Car Availability Calendar',
        'viewing_bookings' => 'Viewing Bookings',
        'checking_availability_help' => 'Checking Availability',
        'color_legend' => 'Color Legend',
        'pending_bookings' => 'Pending Bookings',
        'processing_bookings' => 'Processing Bookings',
        'completed_bookings' => 'Completed Bookings',
        'cancelled_bookings' => 'Cancelled Bookings',
        'unknown_make' => 'Unknown Make',
        'loading' => 'Loading...',
        'loading_calendar_data' => 'Loading calendar data...',
        'loading_booking_details' => 'Loading booking details...',
        'please_wait_booking_info' => 'Please wait while we fetch the booking information.',
        'please_wait_availability' => 'Please wait while we check car availability for your selected dates.',
        'error' => 'Error',
        'error_loading_booking' => 'Failed to load booking details. Please try again.',
        'error_checking_availability' => 'Error checking car availability',
        'customer' => 'Customer',
        'status' => 'Status',
        'amount' => 'Amount',
        'make' => 'Make',
        'vendor' => 'Vendor',
        'per_day' => '/day',
        'edit_car' => 'Edit Car',
        'no_cars_found' => 'No cars found',
        'no_cars_available_period' => 'There are no cars available for the selected period.',
        'close' => 'Close',
        'edit_booking' => 'Edit Booking',
        'pending' => 'Pending',
        'processing' => 'Processing',
        'completed' => 'Completed',
        'cancelled' => 'Cancelled',
    ],
    'theme_options' => [
        'name' => 'Car Rentals',
        'description' => 'Theme options for car rentals',
        'car_location_filter_by' => 'Car location filter by',
        'state' => 'State',
        'city' => 'City',
        'yes' => 'Yes',
        'no' => 'No',
        'is_display_country' => 'Is display country on location filter?',
        'logo_vendor_dashboard' => 'Logo in the vendor dashboard (Default is the main logo)',
        'number_of_cars_per_page' => 'Number of cars per page',
        'number_of_cars_per_page_placeholder' => 'Enter number of cars to display per page',
    ],
    'message' => [
        'name' => 'Messages',
        'forms' => [
            'customer_name' => 'Customer name',
            'message' => 'Message',
            'phone' => 'Phone',
            'email' => 'Email',
            'created_at' => 'Created at',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Car Sales',
        'create' => 'New Car Sale',
        'edit' => 'Edit Car Sale :name',
        'statuses' => [
            'pending' => 'Pending',
            'processing' => 'Processing',
            'completed' => 'Completed',
            'cancelled' => 'Cancelled',
        ],
        'forms' => [
            'transaction_id' => 'Transaction ID',
            'transaction_id_placeholder' => 'Enter transaction ID',
            'car_id' => 'Car',
            'car' => 'Car',
            'customer_id' => 'Customer',
            'customer_name' => 'Customer Name',
            'customer_name_placeholder' => 'Enter customer name',
            'customer_email' => 'Customer Email',
            'customer_email_placeholder' => 'Enter customer email',
            'customer_phone' => 'Customer Phone',
            'customer_phone_placeholder' => 'Enter customer phone',
            'sale_price' => 'Sale Price',
            'sale_price_placeholder' => 'Enter sale price',
            'tax_amount' => 'Tax Amount',
            'tax_amount_placeholder' => 'Enter tax amount',
            'total_amount' => 'Total Amount',
            'total_amount_placeholder' => 'Enter total amount',
            'payment_details' => 'Payment Details',
            'payment_details_placeholder' => 'Enter payment details',
            'notes' => 'Notes',
            'notes_placeholder' => 'Enter notes',
            'sale_date' => 'Sale Date',
            'delivery_date' => 'Delivery Date',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bank Transfer',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Car Rental Booking Confirmation',
        'booking_confirm_greeting' => 'Dear :customer_name,',
        'booking_confirm_message' => 'We are delighted to inform you that your car rental booking has been successfully confirmed!',
        'customer_information' => 'Customer Information',
        'booking_information' => 'Booking Information',
        'field_name' => 'Name:',
        'field_phone' => 'Phone:',
        'field_email' => 'Email:',
        'field_car_model' => 'Car Model:',
        'field_start_date' => 'Start Date:',
        'field_end_date' => 'End Date:',
        'field_pickup_address' => 'Pickup Address:',
        'field_return_address' => 'Return Address:',
        'field_note' => 'Note:',
        'field_order_number' => 'Order number',
        'field_payment_method' => 'Payment Method',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'New Booking Notification',
        'booking_notice_admin_greeting' => 'Hello, there is a new booking from :site_title:',
        'booking_notice_admin_message' => 'A new car rental booking has been submitted and requires your attention.',
        'booking_view_detail' => 'View booking detail:',
        'view_booking_details' => 'View Booking Details',
        
        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'New Booking for Your Car',
        'booking_notice_vendor_greeting' => 'Dear :vendor_name,',
        'booking_notice_vendor_message' => 'Great news! You have received a new booking for your car rental.',

        // Booking status changed email
        'booking_status_updated' => 'Booking Status Updated',
        'hello_thanks_for_booking' => 'Hello, Thanks for booking rooms from :site_title:',
        'booking_status_change_message' => 'We hope this message finds you well. We wanted to inform you that the status of your booking has been updated.',
        'name' => 'Name',
        'phone' => 'Phone',
        'email' => 'Email',
        'car_model' => 'Car Model',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'pickup_address' => 'Pickup Address',
        'return_address' => 'Return Address',
        'note' => 'Note',
        'order_number' => 'Order number',
        'payment_method' => 'Payment Method',

        // Car approved email
        'hello' => 'Hello',
        'car_approved_title' => 'Great News! Your Car Has Been Approved',
        'car_approved_message' => 'We\'re pleased to inform you that your car listing ":car_name" has been approved and is now live on :site_title. You can start receiving bookings and manage your listing right away.',
        'view_edit_car_link' => 'To view or edit your car listing, please click on this link',
        'view_car' => 'View Car Listing',
        'regards' => 'Best regards',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Congratulations! You Are Now a Vendor',
        'vendor_upgrade_congratulations' => 'We are thrilled to inform you that your account has been successfully upgraded to vendor status!',
        'vendor_upgrade_message' => 'You can now list and manage your own cars on :site_title. This opens up new opportunities for you to grow your rental business with us.',
        'vendor_benefits_title' => 'Your New Vendor Benefits',
        'vendor_benefit_1' => 'List unlimited cars for rental',
        'vendor_benefit_2' => 'Manage your own bookings and customers',
        'vendor_benefit_3' => 'Track revenue and performance metrics',
        'vendor_benefit_4' => 'Access to vendor-exclusive features and tools',
        'next_steps' => 'Next Steps',
        'vendor_next_steps_message' => 'Log in to your vendor dashboard to start adding your cars and managing your rental business.',
        'go_to_dashboard' => 'Go to Vendor Dashboard',
        'vendor_support_message' => 'If you have any questions or need assistance, our support team is here to help you get started.',
        'approved' => 'Approved',

        // Car rejected email
        'car_rejected_title' => 'Update Required for Your Car Listing',
        'car_rejected_message' => 'Thank you for submitting your car listing ":car_name" to :site_title. After reviewing your submission, we need you to make some adjustments before we can approve it.',
        'rejection_reason' => 'Here\'s what needs to be updated',
        'rejection_details' => 'Required Updates',
        'contact_support' => 'If you have any questions or need assistance with these updates, please don\'t hesitate to contact our support team at :site_email. We\'re here to help you get your listing approved quickly.',

        // Confirm email
        'verify_email' => 'Verify Email',
        'welcome_message' => 'We\'re glad to have you here, :customer_name!',
        'verify_email_instruction' => 'Please verify your email address in order to access this website. Click on the button below to verify your email..',
        'confirm_email_button' => 'Confirm your email address',
        'verify_link_trouble' => 'If you\'re having trouble clicking the \'Confirm your email address\' button, copy and paste the URL below into your web browser: :verify_link and paste it into your browser.',

        // Message email
        'new_message' => 'New Message',
        'dear_admin' => 'Dear Admin',
        'new_message_from' => 'There is a new message from :site_title:',
        'subject' => 'Subject',
        'address' => 'Address',
        'content' => 'Content',

        // New pending car email
        'hi_admin' => 'Hello Admin,',
        'new_car_pending_title' => 'New Car Listing Awaiting Review',
        'new_car_pending_approval' => 'A new car listing ":post_name" has been submitted by :post_author and is ready for your review.',
        'pending_approval' => 'Awaiting Review',
        'review_car_admin' => 'Please review this listing in the admin panel and approve or request updates as needed.',

        // Common fields
        'car_information' => 'Car Information',
        'field_car_name' => 'Car Name:',
        'field_author' => 'Author:',
        'field_status' => 'Status:',
        'actions' => 'Actions',

        // Password reminder email
        'reset_password_instruction' => 'Reset Password Instruction',
        'password_reset_request' => 'You are receiving this email because we received a password reset request for your account.',
        'reset_password_button' => 'Reset password',
        'reset_link_trouble' => 'If you\'re having trouble clicking the \'Reset Password\' button, copy and paste the URL below into your web browser: :reset_link and paste it into your browser. If you didn\'t request a password reset, please ignore this message or contact us if you have any questions.',
    ],
    'cars' => [
        'forms' => [
            'status_moderation' => [
                'reason_rejected' => 'Reason rejected',
            ],
        ],
    ],
    'settings' => [
        'withdrawal_fee_types' => [
            'label' => 'Withdrawal fee types',
            'fixed' => 'Fixed amount',
            'percentage' => 'Percentage',
        ],
    ],
];
