<?php

return [
    'name' => 'Location de Voitures',
    'customer' => [
        'name' => 'Clients',
        'create' => 'Créer un Client',
        'forms' => [
            'name' => 'Nom',
            'email' => 'Email',
            'phone' => 'Téléphone',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Avatar',
            'dob' => 'Date de naissance',
            'company' => 'Entreprise',
            'position' => 'Poste',
            'password' => 'Mot de passe',
            'password_confirmation' => 'Confirmation du mot de passe',
            'change_password' => 'Changer le mot de passe ?',
            'phone_placeholder' => 'Téléphone',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
        'view' => 'Voir',
        'information' => 'Informations du Client',
        'email' => 'Email',
        'phone' => 'Téléphone',
        'status' => 'Statut',
        'vendor_status' => 'Statut du Fournisseur',
        'is_vendor' => 'Fournisseur',
        'not_vendor' => 'Client',
        'recent_activity' => 'Activité Récente',
        'recent_activity_description' => 'L\'activité du client apparaîtra ici.',
        'verification_section' => 'Vérification du Client',
        'verified' => 'Vérifié',
        'not_verified' => 'Non Vérifié',
        'verified_by' => 'Vérifié Par',
        'verified_at' => 'Vérifié le',
        'verify_customer' => 'Vérifier le Client',
        'unverify_customer' => 'Désvérifier le Client',
        'verify_customer_confirmation' => 'Confirmation de Vérification du Client',
        'verify_customer_confirmation_desc' => 'Êtes-vous sûr de vouloir vérifier :name ? Cela affichera un badge vérifié sur son profil.',
        'unverify_customer_confirmation' => 'Confirmation de Désvérification du Client',
        'unverify_customer_confirmation_desc' => 'Êtes-vous sûr de vouloir supprimer la vérification de :name ? Le badge vérifié sera supprimé.',
        'verify_success' => 'Le client :name a été vérifié avec succès.',
        'unverify_success' => 'La vérification du client :name a été supprimée avec succès.',
        'already_verified' => 'Ce client est déjà vérifié.',
        'already_unverified' => 'Ce client n\'est pas vérifié.',
        'upgrade_to_vendor_title' => 'Promouvoir en Fournisseur',
        'upgrade_to_vendor_description' => 'Promouvoir ce client au statut de fournisseur pour lui permettre de lister et gérer ses propres locations de voitures.',
        'upgrade_to_vendor_button' => 'Promouvoir en Fournisseur',
        'upgrade_to_vendor_confirmation' => 'Confirmer la Promotion en Fournisseur',
        'upgrade_to_vendor_confirmation_desc' => 'Êtes-vous sûr de vouloir promouvoir :name au statut de fournisseur ? Cela lui permettra de lister et gérer ses propres voitures sur la plateforme.',
        'upgrade_to_vendor_success' => ':name a été promu avec succès au statut de fournisseur.',
        'already_vendor' => 'Ce client est déjà un fournisseur.',
        'email_verified' => 'Email Vérifié',
        'email_not_verified' => 'Email Non Vérifié',
        'verify_email_warning_message' => 'L\'adresse email de ce client n\'a pas été vérifiée. Vous pouvez la vérifier manuellement pour confirmer que son email est valide.',
        'verify_email_title' => 'Vérifier l\'Adresse Email',
        'verify_email_description' => 'L\'adresse email de ce client n\'a pas été vérifiée. Vous pouvez la vérifier manuellement pour confirmer que son email est valide.',
        'verify_email_button' => 'Vérifier l\'Email',
        'verify_email_confirmation' => 'Confirmer la Vérification de l\'Email',
        'verify_email_confirmation_desc' => 'Êtes-vous sûr de vouloir vérifier l\'adresse email :email pour :name ? Cela marquera son email comme confirmé.',
        'verify_email_success' => 'L\'email :email a été vérifié avec succès pour :name.',
        'email_already_verified' => 'Cette adresse email est déjà vérifiée.',
        'resend_confirmation_button' => 'Renvoyer l\'Email de Confirmation',
        'resend_confirmation_title' => 'Renvoyer l\'Email de Confirmation',
        'resend_confirmation_desc' => 'Êtes-vous sûr de vouloir renvoyer l\'email de confirmation à :email pour :name ? Cela enverra un nouveau lien de vérification à son adresse email.',
        'resend_confirmation_success' => 'L\'email de confirmation a été envoyé à :email.',
        'resend_confirmation_error' => 'Échec de l\'envoi de l\'email de confirmation. Veuillez réessayer.',
        'customer_verified_successfully' => 'Ce client a été vérifié et est fiable.',
        'customer_not_verified_yet' => 'Ce client n\'a pas encore été vérifié.',
        'verification_pending' => 'Vérification en Attente',
        'click_verify_to_approve' => 'Cliquez sur le bouton ci-dessous pour vérifier ce client et afficher le badge vérifié.',
        'verification_note' => 'Note de Vérification',
        'verification_note_placeholder' => 'Entrez des notes concernant cette action de vérification...',
        'verification_note_helper' => 'Ajouter des notes sur le processus de vérification (usage interne uniquement)',
    ],
    'vendor' => [
        'name' => 'Vendeurs',
        'view' => 'Voir :name',
        'information' => 'Informations du Vendeur',
        'total_cars' => 'Total des Voitures',
        'total_bookings' => 'Total des Réservations',
        'verified' => 'Vérifié',
        'not_verified' => 'Non Vérifié',
        'verification_section' => 'Vérification du Vendeur',
        'vendor_verified_successfully' => 'Ce vendeur a été vérifié et est fiable.',
        'vendor_not_verified_yet' => 'Ce vendeur n\'a pas encore été vérifié.',
        'verification_pending' => 'Vérification en Attente',
        'click_verify_to_approve' => 'Cliquez sur le bouton ci-dessous pour vérifier ce vendeur et afficher le badge vérifié.',
        'verify_vendor' => 'Vérifier le Vendeur',
        'unverify_vendor' => 'Désvérifier le Vendeur',
        'verify_vendor_confirmation' => 'Confirmation de Vérification du Vendeur',
        'verify_vendor_confirmation_desc' => 'Êtes-vous sûr de vouloir vérifier :name ? Cela affichera un badge vérifié sur son profil.',
        'unverify_vendor_confirmation' => 'Confirmation de Désvérification du Vendeur',
        'unverify_vendor_confirmation_desc' => 'Êtes-vous sûr de vouloir supprimer la vérification de :name ? Le badge vérifié sera supprimé.',
        'verified_successfully' => 'Le vendeur a été vérifié avec succès.',
        'unverified_successfully' => 'La vérification du vendeur a été supprimée avec succès.',
        'already_verified' => 'Ce vendeur est déjà vérifié.',
        'not_verified_yet' => 'Ce vendeur n\'est pas encore vérifié.',
        'recent_activity' => 'Activité Récente',
        'recent_cars' => 'Voitures Récentes',
        'recent_bookings' => 'Réservations Récentes',
        'no_cars_yet' => 'Aucune voiture ajoutée pour le moment.',
        'no_bookings_yet' => 'Aucune réservation reçue pour le moment.',
    ],
    'make' => [
        'name' => 'Marques',
        'create' => 'Créer une Marque de Voiture',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Sombre',
        ],
    ],
    'car' => [
        'name' => 'Voitures',
        'create' => 'Créer une Voiture',
        'forms' => [
            'car' => 'Voiture',
            'logo' => 'Logo',
            'license_plate' => 'Plaque d\'immatriculation',
            'make' => 'Marque',
            'model' => 'Modèle',
            'name' => 'Nom',
            'images' => 'Images',
            'year' => 'Année',
            'color' => 'Couleur',
            'mileage' => 'Kilométrage',
            'vehicle_type' => 'Type de véhicule',
            'transmission' => 'Transmission',
            'fuel_type' => 'Type de carburant',
            'rental_rate' => 'Tarif de location',
            'status' => 'Statut',
            'availability' => 'Disponibilité',
            'insurance_info' => 'Informations d\'assurance',
            'number_of_seats' => 'Nombre de sièges',
            'number_of_doors' => 'Nombre de portes',
            'vin' => 'VIN',
            'maintenance_history' => 'Historique d\'entretien',
            'location' => 'Emplacement',
            'description' => 'Description',
            'rental_type' => 'Type de location',
            'tags' => 'Tags',
            'kilometers' => 'Kilometers',
            'horsepower' => 'Horsepower',
            'currency' => 'Currency',
            'add_new_attribute' => 'Add new <a href=\\\":url\\\" target=\\\"_blank\\\">here</a>.',
            'categories' => 'Categories',
            'pick_address' => 'Pick Address',
            'return_address' => 'Return Address',
            'same_drop_off' => 'Same Drop-Off',
            'tax' => 'Tax',
            'select_tax' => 'Select Tax',
            'none' => 'None',
            'colors' => 'Colors',
            'amenities' => 'Amenities',
            'is_used' => 'Is used?',
            'moderation_status' => 'Moderation status',
            'status_moderation' => [
                'approve' => 'Approve',
                'reject' => 'Reject',
                'approve_title' => 'Approve car',
                'approve_message' => 'Are you sure you want to approve this car? This action cannot be undone.',
                'reject_title' => 'Reject car',
                'reject_message' => 'Are you sure you want to reject this car? This action cannot be undone.',
                'reject_reason' => 'Enter the reason for rejection',
                'approved' => 'Car has been approved successfully!',
                'rejected' => 'Car has been rejected successfully!',
                'reason_rejected' => 'Reason rejected',
            ],
            'customer' => 'Customer',
            'select_customer' => 'Select a customer...',
            'vendor_images' => 'Images (Maximum :max images)',
            'images_upload_placeholder' => 'Drop files here or click to upload.',
            'car_purpose' => 'Car Purpose',
            'for_rent' => 'For Rent',
            'for_sale' => 'For Sale',
            'car_type' => 'Car Type',
            'rental_information' => 'Rental Information',
            'sale_statuses' => [
                'available' => 'Available',
                'sold' => 'Sold',
                'reserved' => 'Reserved',
            ],
            'selling_information' => 'Selling Information',
            'is_for_sale' => 'Available for sale',
            'sale_price' => 'Sale Price',
            'sale_price_placeholder' => 'Enter sale price',
            'condition' => 'Condition',
            'select_condition' => 'Select Condition',
            'condition_options' => [
                'new' => 'New',
                'like_new' => 'Like New',
                'excellent' => 'Excellent',
                'good' => 'Good',
                'fair' => 'Fair',
                'poor' => 'Poor',
            ],
            'ownership_history' => 'Ownership History',
            'ownership_history_placeholder' => 'Enter ownership history',
            'warranty_information' => 'Warranty Information',
            'warranty_information_placeholder' => 'Enter warranty information',
            'sale_status' => 'Sale Status',
            'external_booking_url' => 'Off-Site Booking Link',
            'external_booking_url_helper' => 'Enter the external URL where customers can book this car outside of this platform. Leave empty if booking is only available on this site.',
            'address' => 'Address',
            'address_helper' => 'Enter the specific street address where this vehicle is located',
        ],
        'placeholders' => [
            'name' => 'Entrez le nom du véhicule (ex., Toyota Camry 2023, Honda CR-V, etc.)',
            'description' => 'Entrez une brève description du véhicule en mettant en évidence les caractéristiques clés',
            'rental_rate' => 'Entrez le tarif de location en fonction du type de location sélectionné',
            'location' => 'Entrez l\'emplacement physique du véhicule',
            'sale_price' => 'Entrez le prix de vente de ce véhicule',
            'ownership_history' => 'Entrez les détails sur les propriétaires précédents, le nombre de propriétaires, etc.',
            'warranty_information' => 'Entrez les détails sur la couverture de garantie, la date d\'expiration, etc.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Entrez le numéro de plaque d\'immatriculation du véhicule',
            'vin' => 'Entrez le Numéro d\'Identification du Véhicule (VIN)',
            'address' => 'Enter the specific street address (e.g., 123 Main St, City, State)',
            'year' => 'Enter the manufacturing year (e.g., 2023)',
            'mileage' => 'Enter the current mileage',
            'kilometers' => 'Enter the current kilometers',
            'horsepower' => 'Enter the horsepower (HP) of the vehicle (e.g., 150.5)',
            'number_of_seats' => 'Enter the number of seats in the vehicle',
            'number_of_doors' => 'Enter the number of doors the vehicle has',
            'insurance_info' => 'Enter relevant insurance information for this vehicle',
            'tags' => 'Select or create tags',
            'amenities' => 'Select amenities',
            'colors' => 'Select or create colors',
        ],
        'enums' => [
            'statuses' => [
                'available' => 'Disponible',
                'rented' => 'Loué',
                'maintenance' => 'Entretien',
                'out_of_service' => 'Hors service',
            ],
            'rental_types' => [
                'per_hour' => 'Par heure',
                'per_day' => 'Par jour',
                'per_week' => 'Par semaine',
                'per_month' => 'Par mois',
            ],
            'moderation_statuses' => [
                'pending' => 'En attente',
                'approved' => 'Approuvé',
                'rejected' => 'Rejeté',
            ],
            'vendor_status' => 'Vendor Status',
            'is_vendor' => 'Vendor',
            'not_vendor' => 'Customer',
        ],
        'car_purposes' => [
            'sale' => 'For Sale',
            'rent' => 'For Rent',
        ],
        'maintenance_history' => [
            'name' => 'Maintenance Histories',
            'create' => 'Create Service History',
            'amount' => 'Amount',
            'forms' => [
                'price_placeholder' => 'Price service',
                'currency' => 'Currency',
                'none' => 'None',
                'name' => 'Name',
                'amount' => 'Amount',
                'created_at' => 'Created At',
                'action' => 'Action',
                'date' => 'Date',
                'no_maintenance_history' => 'No maintenance histories',
                'edit_maintenance_history' => 'Edit maintenance history',
                'add_maintenance_history' => 'Add maintenance history',
                'add' => 'Add',
                'edit' => 'Edit',
                'delete' => 'Delete',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Attributs de Voiture',
        'car_type' => [
            'name' => 'Types',
            'create' => 'Créer un Type de Voiture',
            'forms' => [
                'name' => 'Nom',
            ],
        ],
        'transmission' => [
            'name' => 'Transmissions',
            'create' => 'Créer une Transmission',
            'forms' => [
                'name' => 'Nom',
            ],
        ],
        'fuel_type' => [
            'name' => 'Carburants',
            'create' => 'Créer des Types de Carburant',
            'forms' => [
                'name' => 'Nom',
            ],
        ],
        'tag' => [
            'name' => 'Tags',
            'create' => 'Créer un Tag',
        ],
        'category' => [
            'name' => 'Catégories',
            'create' => 'Créer une Catégorie',
            'forms' => [
                'none' => 'Aucun',
                'total_cars' => 'Total des voitures : :total',
            ],
        ],
        'address' => [
            'name' => 'Emplacements',
            'create' => 'Créer un Emplacement de Voiture',
            'form' => [
                'name' => 'Adresse',
                'full_address' => 'Adresse complète',
                'detail_address' => 'Adresse détaillée',
            ],
        ],
        'color' => [
            'name' => 'Color',
            'create' => 'Create Color',
        ],
        'amenity' => [
            'name' => 'Amenities',
            'create' => 'Create Amenity',
        ],
    ],
    'review' => [
        'name' => 'Avis',
        'create' => 'Créer un Avis',
        'edit' => 'Modifier l\'Avis',
        'vendor' => [
            'title' => 'Avis des Clients',
            'description' => 'Gérer tous les avis des clients pour vos voitures',
            'no_reviews' => 'Vous n\'avez pas encore d\'avis',
            'filter_by_car' => 'Filtrer par voiture',
            'filter_by_rating' => 'Filtrer par note',
            'filter_by_date' => 'Filtrer par date',
            'all_cars' => 'Toutes les Voitures',
            'all_ratings' => 'Toutes les Notes',
            'manage_reviews' => 'Gérer les Avis',
            'view_all' => 'Voir Tous les Avis',
            'delete_review_confirmation' => 'Êtes-vous sûr de vouloir supprimer cet avis ?',
            'delete_review_success' => 'Avis supprimé avec succès',
            'cannot_delete' => 'Impossible de supprimer cet avis',
        ],
        'forms' => [
            'customer' => 'Client',
            'car' => 'Voiture',
            'content' => 'Contenu',
            'rating' => 'Note',
            'your_name' => 'Votre Nom',
            'email_address' => 'Adresse Email',
            'submit' => 'Soumettre',
            'star' => 'Étoile',
            'status' => 'Statut',
            'created_at' => 'Créé le',
            'select_car' => 'Sélectionner une Voiture',
            'select_rating' => 'Sélectionner une Note',
            'comment' => 'Commentaire',
            'reply' => 'Répondre',
            'reply_to_review' => 'Répondre à l\'Avis',
            'save_reply' => 'Enregistrer la Réponse',
            'cancel_reply' => 'Annuler',
        ],
        'statuses' => [
            'published' => 'Publié',
            'pending' => 'En attente',
            'rejected' => 'Rejeté',
        ],
        'ratings' => [
            1 => '1 Étoile - Médiocre',
            2 => '2 Étoiles - Passable',
            3 => '3 Étoiles - Bon',
            4 => '4 Étoiles - Très Bon',
            5 => '5 Étoiles - Excellent',
        ],
    ],
    'coupon' => [
        'name' => 'Coupons',
        'create' => 'Créer un Coupon',
        'types' => [
            'percentage' => 'Pourcentage %',
            'money' => 'Argent',
        ],
        'forms' => [
        ],
    ],
    'service' => [
        'name' => 'Services',
        'create' => 'Créer un Service',
        'forms' => [
            'name' => 'Nom',
            'content' => 'Contenu',
            'price' => 'Prix',
            'image' => 'Image',
            'logo' => 'Logo',
            'status' => 'Statut',
            'currency' => 'Currency',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Calendrier de Disponibilité des Voitures',
        'title' => 'Calendrier de Disponibilité des Voitures',
        'description' => 'Voir la disponibilité des voitures et les réservations au format calendrier',
        'select_dates' => 'Sélectionnez les dates pour vérifier la disponibilité',
        'car_filter' => 'Filtrer par Voiture',
        'all_cars' => 'Toutes les Voitures',
        'clear_filter' => 'Effacer le Filtre',
        'availability_check' => 'Vérification de Disponibilité des Voitures',
        'selected_period' => 'Période Sélectionnée',
        'checking_availability' => 'Vérification de la disponibilité...',
        'available' => 'Disponible',
        'not_available' => 'Non Disponible',
        'booking_details' => 'Détails de la Réservation',
        'how_to_use' => 'Comment utiliser le Calendrier de Disponibilité des Voitures',
        'viewing_bookings' => 'Affichage des Réservations',
        'checking_availability_help' => 'Vérification de la Disponibilité',
        'color_legend' => 'Légende des Couleurs',
        'pending_bookings' => 'Réservations en Attente',
        'processing_bookings' => 'Réservations en Cours',
        'completed_bookings' => 'Réservations Terminées',
        'cancelled_bookings' => 'Réservations Annulées',
        'unknown_make' => 'Marque Inconnue',
        'loading' => 'Chargement...',
        'loading_calendar_data' => 'Chargement des données du calendrier...',
        'loading_booking_details' => 'Chargement des détails de la réservation...',
        'please_wait_booking_info' => 'Veuillez patienter pendant que nous récupérons les informations de réservation.',
        'please_wait_availability' => 'Veuillez patienter pendant que nous vérifions la disponibilité des voitures pour vos dates sélectionnées.',
        'error' => 'Erreur',
        'error_loading_booking' => 'Échec du chargement des détails de la réservation. Veuillez réessayer.',
        'error_checking_availability' => 'Erreur lors de la vérification de la disponibilité des voitures',
        'customer' => 'Client',
        'status' => 'Statut',
        'amount' => 'Montant',
        'make' => 'Marque',
        'vendor' => 'Vendeur',
        'per_day' => '/jour',
        'edit_car' => 'Modifier la Voiture',
        'no_cars_found' => 'Aucune voiture trouvée',
        'no_cars_available_period' => 'Aucune voiture disponible pour la période sélectionnée.',
        'close' => 'Fermer',
        'edit_booking' => 'Modifier la Réservation',
        'pending' => 'En attente',
        'processing' => 'En cours de traitement',
        'completed' => 'Terminé',
        'cancelled' => 'Annulé',
    ],
    'theme_options' => [
        'name' => 'Location de Voitures',
        'description' => 'Options de thème pour la location de voitures',
        'car_location_filter_by' => 'Filtrer l\'emplacement de la voiture par',
        'state' => 'État',
        'city' => 'Ville',
        'yes' => 'Oui',
        'no' => 'Non',
        'is_display_country' => 'Afficher le pays dans le filtre d\'emplacement ?',
        'logo_vendor_dashboard' => 'Logo dans le tableau de bord du vendeur (Par défaut, c\'est le logo principal)',
        'number_of_cars_per_page' => 'Number of cars per page',
        'number_of_cars_per_page_placeholder' => 'Enter number of cars to display per page',
    ],
    'message' => [
        'name' => 'Messages',
        'forms' => [
            'customer_name' => 'Nom du client',
            'message' => 'Message',
            'phone' => 'Téléphone',
            'email' => 'Email',
            'created_at' => 'Créé le',
            'status' => 'Statut',
        ],
    ],
    'car_sale' => [
        'name' => 'Ventes de Voitures',
        'create' => 'Nouvelle Vente de Voiture',
        'edit' => 'Modifier la Vente de Voiture :name',
        'statuses' => [
            'pending' => 'En attente',
            'processing' => 'En cours de traitement',
            'completed' => 'Terminé',
            'cancelled' => 'Annulé',
        ],
        'forms' => [
            'transaction_id' => 'Transaction ID',
            'transaction_id_placeholder' => 'Enter transaction ID',
            'car_id' => 'Car',
            'car' => 'Car',
            'customer_id' => 'Customer',
            'customer_name' => 'Customer Name',
            'customer_name_placeholder' => 'Enter customer name',
            'customer_email' => 'Customer Email',
            'customer_email_placeholder' => 'Enter customer email',
            'customer_phone' => 'Customer Phone',
            'customer_phone_placeholder' => 'Enter customer phone',
            'sale_price' => 'Sale Price',
            'sale_price_placeholder' => 'Enter sale price',
            'tax_amount' => 'Tax Amount',
            'tax_amount_placeholder' => 'Enter tax amount',
            'total_amount' => 'Total Amount',
            'total_amount_placeholder' => 'Enter total amount',
            'payment_details' => 'Payment Details',
            'payment_details_placeholder' => 'Enter payment details',
            'notes' => 'Notes',
            'notes_placeholder' => 'Enter notes',
            'sale_date' => 'Sale Date',
            'delivery_date' => 'Delivery Date',
        ],
    ],
    'email_templates' => [
        'booking_notice_admin_title' => 'Notification de Nouvelle Réservation',
        'booking_notice_admin_greeting' => 'Bonjour, il y a une nouvelle réservation de :site_title:',
        'booking_notice_admin_message' => 'Une nouvelle réservation de location de voiture a été soumise et nécessite votre attention.',
        'booking_view_detail' => 'Voir les détails de la réservation:',
        'view_booking_details' => 'Voir les Détails de la Réservation',
        'booking_notice_vendor_title' => 'Nouvelle Réservation pour Votre Voiture',
        'booking_notice_vendor_greeting' => 'Cher :vendor_name,',
        'booking_notice_vendor_message' => 'Excellente nouvelle ! Vous avez reçu une nouvelle réservation pour votre location de voiture.',
        'hello' => 'Bonjour',
        'car_approved_title' => 'Excellente nouvelle ! Votre voiture a été approuvée',
        'car_approved_message' => 'Nous sommes heureux de vous informer que votre annonce de voiture \\\":car_name\\\" a été approuvée et est maintenant en ligne sur :site_title. Vous pouvez commencer à recevoir des réservations et gérer votre annonce immédiatement.',
        'view_edit_car_link' => 'Pour voir ou modifier votre annonce de voiture, veuillez cliquer sur ce lien',
        'view_car' => 'Voir l\'Annonce de Voiture',
        'regards' => 'Cordialement',
        'approved' => 'Approuvé',
        'car_rejected_title' => 'Mise à jour requise pour votre annonce de voiture',
        'car_rejected_message' => 'Merci d\'avoir soumis votre annonce de voiture \\\":car_name\\\" à :site_title. Après avoir examiné votre soumission, nous avons besoin que vous fassiez quelques ajustements avant que nous puissions l\'approuver.',
        'rejection_reason' => 'Voici ce qui doit être mis à jour',
        'rejection_details' => 'Mises à Jour Requises',
        'contact_support' => 'Si vous avez des questions ou avez besoin d\'aide avec ces mises à jour, n\'hésitez pas à contacter notre équipe de support à :site_email. Nous sommes là pour vous aider à faire approuver votre annonce rapidement.',
        'hi_admin' => 'Bonjour Administrateur,',
        'new_car_pending_title' => 'Nouvelle Annonce de Voiture en Attente de Révision',
        'new_car_pending_approval' => 'Une nouvelle annonce de voiture \\\":post_name\\\" a été soumise par :post_author et est prête pour votre révision.',
        'pending_approval' => 'En Attente de Révision',
        'review_car_admin' => 'Veuillez examiner cette annonce dans le panneau d\'administration et l\'approuver ou demander des mises à jour selon les besoins.',
        'car_information' => 'Informations sur la Voiture',
        'field_car_name' => 'Nom de la Voiture:',
        'field_author' => 'Auteur:',
        'field_status' => 'Statut:',
        'actions' => 'Actions',
        'reset_password_instruction' => 'Instructions de Réinitialisation du Mot de Passe',
        'password_reset_request' => 'Vous recevez cet e-mail parce que nous avons reçu une demande de réinitialisation de mot de passe pour votre compte.',
        'reset_password_button' => 'Réinitialiser le mot de passe',
        'reset_link_trouble' => 'Si vous avez des difficultés à cliquer sur le bouton \'Réinitialiser le Mot de Passe\', copiez et collez l\'URL ci-dessous dans votre navigateur web : :reset_link et collez-la dans votre navigateur. Si vous n\'avez pas demandé de réinitialisation de mot de passe, veuillez ignorer ce message ou nous contacter si vous avez des questions.',
        'booking_confirm_title' => 'Car Rental Booking Confirmation',
        'booking_confirm_greeting' => 'Dear :customer_name,',
        'booking_confirm_message' => 'We are delighted to inform you that your car rental booking has been successfully confirmed!',
        'customer_information' => 'Customer Information',
        'booking_information' => 'Booking Information',
        'field_name' => 'Name:',
        'field_phone' => 'Phone:',
        'field_email' => 'Email:',
        'field_car_model' => 'Car Model:',
        'field_start_date' => 'Start Date:',
        'field_end_date' => 'End Date:',
        'field_pickup_address' => 'Pickup Address:',
        'field_return_address' => 'Return Address:',
        'field_note' => 'Note:',
        'field_order_number' => 'Order number',
        'field_payment_method' => 'Payment Method',
        'booking_status_updated' => 'Booking Status Updated',
        'hello_thanks_for_booking' => 'Hello, Thanks for booking rooms from :site_title:',
        'booking_status_change_message' => 'We hope this message finds you well. We wanted to inform you that the status of your booking has been updated.',
        'name' => 'Name',
        'phone' => 'Phone',
        'email' => 'Email',
        'car_model' => 'Car Model',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'pickup_address' => 'Pickup Address',
        'return_address' => 'Return Address',
        'note' => 'Note',
        'order_number' => 'Order number',
        'payment_method' => 'Payment Method',
        'vendor_upgrade_title' => 'Congratulations! You Are Now a Vendor',
        'vendor_upgrade_congratulations' => 'We are thrilled to inform you that your account has been successfully upgraded to vendor status!',
        'vendor_upgrade_message' => 'You can now list and manage your own cars on :site_title. This opens up new opportunities for you to grow your rental business with us.',
        'vendor_benefits_title' => 'Your New Vendor Benefits',
        'vendor_benefit_1' => 'List unlimited cars for rental',
        'vendor_benefit_2' => 'Manage your own bookings and customers',
        'vendor_benefit_3' => 'Track revenue and performance metrics',
        'vendor_benefit_4' => 'Access to vendor-exclusive features and tools',
        'next_steps' => 'Next Steps',
        'vendor_next_steps_message' => 'Log in to your vendor dashboard to start adding your cars and managing your rental business.',
        'go_to_dashboard' => 'Go to Vendor Dashboard',
        'vendor_support_message' => 'If you have any questions or need assistance, our support team is here to help you get started.',
        'verify_email' => 'Verify Email',
        'welcome_message' => 'We\'re glad to have you here, :customer_name!',
        'verify_email_instruction' => 'Please verify your email address in order to access this website. Click on the button below to verify your email..',
        'confirm_email_button' => 'Confirm your email address',
        'verify_link_trouble' => 'If you\'re having trouble clicking the \'Confirm your email address\' button, copy and paste the URL below into your web browser: :verify_link and paste it into your browser.',
        'new_message' => 'New Message',
        'dear_admin' => 'Dear Admin',
        'new_message_from' => 'There is a new message from :site_title:',
        'subject' => 'Subject',
        'address' => 'Address',
        'content' => 'Content',
    ],
    'icon' => 'Icon',
    'tax' => [
        'name' => 'Taxes',
        'create' => 'Create Tax',
        'forms' => [
            'name' => 'Name',
            'name_placeholder' => 'Enter name',
            'percentage' => 'Percentage',
            'percentage_placeholder' => 'Percentage',
            'percent_placeholder' => 'Percentage',
            'priority' => 'Priority',
            'priority_placeholder' => 'Priority',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bank Transfer',
        'paypal' => 'PayPal',
    ],
    'cars' => [
        'forms' => [
            'status_moderation' => [
                'reason_rejected' => 'Reason rejected',
            ],
        ],
    ],
    'settings' => [
        'withdrawal_fee_types' => [
            'label' => 'Withdrawal fee types',
            'fixed' => 'Fixed amount',
            'percentage' => 'Percentage',
        ],
    ],
];
