<?php

return [
    'name' => 'レンタカー',
    'currency' => [
        'title' => '通貨',
        'description' => 'レンタカーの通貨設定を管理します。',
    ],
    'general' => [
        'title' => '一般',
        'description' => 'レンタカーの一般設定を管理します。',
        'forms' => [
            'enabled_multi_vendor' => 'マルチベンダーを有効化',
            'enabled_multi_vendor_helper' => '有効にすると、訪問者はベンダーとして登録し、販売/レンタル用の車両をサイトに投稿できます。',
            'enabled_car_rental_feature' => 'レンタカー予約を有効化',
            'enabled_car_rental_feature_helper' => '有効にすると、レンタカー予約機能がウェブサイトで利用可能になります。',
            'enabled_car_rental' => 'レンタカーを有効化',
            'enabled_car_rental_helper' => '有効にすると、車両をレンタル用にリストできます。',
            'enabled_post_approval' => '投稿承認を有効化？',
            'enabled_post_approval_helper' => '有効にすると、ベンダーが投稿した車両は公開される前に管理者の承認が必要になります。',
            'enabled_car_sale' => '車両販売を有効化',
            'enabled_car_sale_helper' => '有効にすると、車両を販売用にリストできます。',
            'booking_number_format' => [
                'title' => '予約番号形式（オプション）',
                'description' => 'デフォルトの予約番号は特定の番号から始まります。予約番号の開始番号と終了番号をカスタマイズできます。例えば、予約番号は#:formatと表示されます。',
                'start_with' => '開始番号',
                'end_with' => '終了番号',
            ],
            'distance_unit' => '距離単位',
            'distance_unit_helper' => 'システム全体で使用する距離の測定単位を選択してください。',
            'owner_info_settings_title' => 'オーナー情報表示',
            'hide_owner_info' => 'オーナー情報を非表示',
            'hide_owner_info_helper' => '有効にすると、車両詳細ページからオーナー情報セクション全体が非表示になります。',
            'hide_owner_phone' => 'オーナーの電話番号を非表示',
            'hide_owner_phone_helper' => '有効にすると、車両詳細ページからオーナーの電話番号が非表示になります。',
            'hide_owner_email' => 'オーナーのメールアドレスを非表示',
            'hide_owner_email_helper' => '有効にすると、車両詳細ページからオーナーのメールアドレスが非表示になります。',
            'enable_off_site_booking' => 'オフサイト予約リンクを有効化',
            'enable_off_site_booking_helper' => '有効にすると、車両オーナーは外部予約URLを追加して、顧客をサードパーティの予約サイトにリダイレクトできます。',
            'enable_message_form' => 'メッセージフォームを有効化',
            'enable_message_form_helper' => '有効にすると、訪問者は車両詳細ページの連絡フォームから車両オーナーにメッセージを送信できます。',
        ],
    ],
    'review' => [
        'title' => 'レビュー',
        'description' => 'レンタカーのレビュー設定を管理します。',
        'forms' => [
            'enabled_review' => 'レビューを有効化？',
        ],
    ],
    'car_filter' => [
        'title' => '車両フィルター',
        'description' => 'レンタカーの車両フィルター設定を管理します。',
        'forms' => [
            'filter_cars_by' => '車両をフィルター：',
            'locations' => 'ロケーション',
            'prices' => '価格',
            'horsepower' => '馬力',
            'categories' => 'カテゴリー',
            'colors' => '色',
            'types' => 'タイプ',
            'transmissions' => 'トランスミッション',
            'fuels' => '燃料',
            'review_scores' => 'レビュースコア',
            'addresses' => '住所',
            'vehicle_condition' => '車両の状態',
            'enable_car_filter' => '車両フィルターを有効化？',
        ],
    ],
    'customer' => [
        'title' => '顧客',
        'description' => '顧客設定を表示および更新',
        'forms' => [
            'enabled_customer_registration' => '顧客登録を有効化？',
            'verify_customer_email' => '顧客のメールを確認',
            'verify_customer_email_helper' => '有効にすると、確認リンクが顧客のメールに送信され、顧客はログインする前にこのリンクをクリックしてメールを確認する必要があります。',
            'verification_expire_minutes' => '確認リンクの有効期限（分）',
            'verification_expire_minutes_helper' => '確認リンクはこの時間（分）後に期限切れになります。デフォルトは60分、最大10080分（7日）です。',
            'enabled_customer_registration_helper' => '有効にすると、訪問者はウェブサイトで顧客として登録して車両を予約できます。',
            'show_terms_checkbox' => '利用規約とポリシーのチェックボックスを表示',
            'show_terms_checkbox_helper' => '有効にすると、顧客は登録前に利用規約とポリシーに同意する必要があります',
            'max_upload_filesize' => '最大アップロードファイルサイズ（MB）',
            'max_upload_filesize_placeholder' => 'デフォルト：:size',
            'max_upload_filesize_helper' => 'この設定は、ベンダーが車両画像にアップロードできる最大ファイルサイズ（MB単位）を制御します。',
            'max_post_images_upload_by_vendor' => '各車両の最大画像数',
            'max_post_images_upload_by_vendor_helper' => 'この設定は、ベンダーが各車両にアップロードできる最大画像数を制御します。',
            'default_avatar' => 'デフォルトアバター',
            'default_avatar_helper' => '顧客がアバターを持っていない場合のデフォルトアバター。画像を選択しない場合、顧客名の最初の文字を使用して生成されます。',
        ],
    ],
    'invoice' => [
        'title' => '請求書',
        'description' => 'レンタカーの請求書設定を管理します。',
        'forms' => [
            'company_name' => '会社名',
            'company_name_placeholder' => '会社名を入力',
            'company_name_helper' => 'これはすべての請求書に会社名として表示されます。',
            'company_address' => '会社住所',
            'company_address_placeholder' => '会社住所を入力',
            'company_address_helper' => '請求書に表示される完全な会社住所。',
            'company_email' => '会社メール',
            'company_email_placeholder' => 'company@example.com',
            'company_email_helper' => '請求書に関するお問い合わせ用の連絡先メールアドレス。',
            'company_phone' => '会社電話',
            'company_phone_placeholder' => '+1 (555) 123-4567',
            'company_phone_helper' => '請求書に関するお問い合わせ用の連絡先電話番号。',
            'company_logo' => '会社ロゴ',
            'company_logo_helper' => '請求書に表示されるロゴ。推奨サイズ：200x80px。',
            'using_custom_font_for_invoice' => '請求書にカスタムフォントを使用？',
            'using_custom_font_for_invoice_helper' => '請求書にカスタムGoogleフォントを使用する場合は、これを有効にします。',
            'invoice_font_family' => '請求書フォントファミリー（ラテン言語のみ動作）',
            'invoice_font_family_helper' => '請求書テキストに使用するGoogleフォントを選択してください。',
            'enable_invoice_stamp' => '請求書スタンプを有効化？',
            'enable_invoice_stamp_helper' => '真正性のために請求書にスタンプ/ウォーターマークを追加します。',
            'invoice_support_arabic_language' => '請求書でアラビア語をサポート？',
            'invoice_support_arabic_language_helper' => '請求書でアラビア語テキストのサポートを有効にします。',
            'invoice_code_prefix' => '請求書コードの接頭辞',
            'invoice_code_prefix_placeholder' => 'INV-',
            'invoice_code_prefix_helper' => 'すべての請求書番号に追加される接頭辞（例：INV-001）。',
            'add_language_support' => '言語サポートを追加',
            'add_language_support_helper' => '請求書生成の言語サポートレベルを選択してください。',
            'only_latin_languages' => 'ラテン言語のみ',
            'invoice_processing_library' => '請求書処理ライブラリ',
            'invoice_processing_library_helper' => 'PDF処理ライブラリを選択してください。DomPDFは高速で、mPDFはより多くの機能をサポートしています。',
            'date_format' => '日付形式',
            'date_format_helper' => '請求書で日付を表示する形式。',
        ],
    ],
    'invoice_template' => [
        'title' => '請求書テンプレート',
        'description' => '請求書テンプレートの設定',
        'setting_content' => 'コンテンツ',
        'forms' => [
            'confirm_reset' => '請求書テンプレートのリセットを確認？',
            'confirm_message' => '本当にこの請求書テンプレートをデフォルトにリセットしますか？',
            'continue' => '続行',
        ],
    ],
    'email' => [
        'name' => 'レンタカー',
        'description' => 'レンタカーのメールテンプレートを設定',
        'templates' => [
            'variables' => [
                'verify_link' => 'メール確認リンク',
                'customer_name' => '顧客名',
                'reset_link' => 'パスワードリセットリンク',
                'message_name' => '名前',
                'message_phone' => '電話',
                'message_email' => 'メール',
                'message_content' => 'コンテンツ',
                'message_link' => 'リンク',
                'message_subject' => '件名',
                'message_ip_address' => 'IPアドレス',
                'message_custom_fields' => 'カスタムフィールド',
                'post_author' => '投稿者',
                'post_name' => '投稿名',
                'post_url' => '投稿URL',
            ],
            'booking_confirm' => [
                'booking_confirmation_title' => '予約確認',
                'booking_confirmation_description' => '予約が確認されたときに顧客に送信',
                'booking_code' => '予約コード',
                'customer_name' => '顧客名',
                'customer_phone' => '顧客電話',
                'customer_email' => '顧客メール',
                'payment_method' => '支払い方法',
                'car_name' => '車両名',
                'pickup_address' => 'ピックアップ住所',
                'return_address' => '返却住所',
                'rental_start_date' => 'レンタル開始日',
                'rental_end_date' => 'レンタル終了日',
                'amount' => '金額',
                'note' => '備考',
            ],
            'car_approved' => [
                'author_name' => '車両オーナー名',
                'car_name' => '車両名',
                'car_link' => '車両編集リンク',
            ],
            'car_rejected' => [
                'author_name' => '車両オーナー名',
                'car_name' => '車両名',
                'car_link' => '車両編集リンク',
                'reason' => '拒否理由',
            ],
            'vendor_upgrade' => [
                'customer_name' => '顧客名',
                'customer_email' => '顧客メール',
                'dashboard_link' => 'ベンダーダッシュボードリンク',
            ],
            'booking_notice_title' => '管理者予約通知',
            'booking_notice_description' => '新しい予約を受け取ったときに管理者に送信',
            'booking_notice_subject' => '新しい予約を受信 - {{ site_title }}',
            'booking_notice_vendor_title' => 'ベンダー予約通知',
            'booking_notice_vendor_description' => '車両の新しい予約を受け取ったときにベンダーに送信',
            'booking_notice_vendor_subject' => 'あなたの車両の新しい予約 - {{ site_title }}',
            'booking_notice_vendor' => [
                'vendor_name' => 'ベンダー名',
            ],
            'booking_success_title' => '予約成功通知',
            'booking_success_description' => '予約が受信されたことを顧客に確認するために送信',
            'booking_status_changed_title' => '予約ステータス更新',
            'booking_status_changed_description' => '予約ステータスが変更されたときに顧客に送信',
            'booking_status_changed_subject' => '予約ステータスが更新されました',
            'booking_confirm_subject' => '予約確認',
            'confirm_email_subject' => 'メール確認が必要です',
            'password_reminder_subject' => 'パスワードリセットリクエスト',
            'message_subject' => '新しいメッセージ - {{ site_title }}',
            'new_pending_car_subject' => '車両リストが承認待ちです',
            'car_approved_title' => '車両承認通知',
            'car_approved_description' => 'リストが承認されたときに車両オーナーに送信',
            'car_approved_subject' => '車両リストが承認されました',
            'car_rejected_title' => '車両拒否通知',
            'car_rejected_description' => 'リストが拒否されたときに車両オーナーに送信',
            'car_rejected_subject' => '車両リストが拒否されました',
            'vendor_upgrade_title' => 'ベンダーアップグレード通知',
            'vendor_upgrade_description' => 'アカウントがベンダーステータスにアップグレードされたときに顧客に送信',
            'vendor_upgrade_subject' => 'おめでとうございます！アカウントがベンダーステータスにアップグレードされました',
            'confirm_email_title' => 'メール確認',
            'confirm_email_description' => 'メールアドレスを確認するためにユーザーに送信',
            'password_reminder_title' => 'パスワードリセット',
            'password_reminder_description' => 'パスワードリセットをリクエストしたユーザーに送信',
            'message_title' => '連絡メッセージ',
            'message_description' => '連絡フォームが送信されたときに送信',
            'new_pending_car_title' => '保留中の車両リスト',
            'new_pending_car_description' => '新しい車両リストが承認を必要とするときに管理者に送信',
        ],
    ],
    'tax' => [
        'name' => '税',
        'description' => '税設定を表示および更新',
        'tax_setting' => '税設定',
        'tax_setting_description' => '税設定を構成',
        'tax_management' => '税管理',
        'tax_management_description' => '税を表示および管理',
        'forms' => [
            'enable_tax' => '税を有効化？',
            'apply_tax' => '税を適用',
        ],
    ],
    'commission' => [
        'title' => '手数料',
        'description' => 'レンタカーの手数料設定を構成',
        'default_commission_fee' => 'デフォルト手数料',
        'commission_fee_type' => '手数料タイプ',
        'enable_commission_fee_for_each_category' => '各カテゴリーの手数料を有効化？',
        'commission_fee' => '手数料',
        'categories' => 'カテゴリー',
        'select_categories' => 'カテゴリーを選択',
        'add_new' => '新規追加',
        'commission_fee_each_category_fee_name' => 'アイテム:keyの手数料',
        'commission_fee_each_category_name' => 'アイテム:keyのカテゴリー',
    ],
];
