<?php

/**
 * Translation: KA
 * Georgian translation for Car Rentals plugin
 */

return [
    'name' => 'ავტომობილების დაქირავება',
    'customer' => [
        'name' => 'მომხმარებლები',
        'create' => 'მომხმარებლის შექმნა',
        'view' => 'ნახვა',
        'information' => 'მომხმარებლის ინფორმაცია',
        'email' => 'ელ. ფოსტა',
        'phone' => 'ტელეფონი',
        'status' => 'სტატუსი',
        'vendor_status' => 'გამყიდველის სტატუსი',
        'is_vendor' => 'გამყიდველი',
        'not_vendor' => 'მომხმარებელი',
        'recent_activity' => 'ბოლო აქტივობა',
        'recent_activity_description' => 'მომხმარებლის აქტივობა გამოჩნდება აქ.',
        'verification_section' => 'მომხმარებლის ვერიფიკაცია',
        'verified' => 'ვერიფიცირებული',
        'not_verified' => 'არ არის ვერიფიცირებული',
        'verified_by' => 'ვერიფიცირებულია',
        'verified_at' => 'ვერიფიკაციის თარიღი',
        'verify_customer' => 'მომხმარებლის ვერიფიკაცია',
        'unverify_customer' => 'ვერიფიკაციის გაუქმება',
        'verify_customer_confirmation' => 'მომხმარებლის ვერიფიკაციის დადასტურება',
        'verify_customer_confirmation_desc' => 'დარწმუნებული ხართ, რომ გსურთ :name-ის ვერიფიკაცია? ეს გამოაჩენს ვერიფიცირებულის ნიშანს მათ პროფილზე.',
        'unverify_customer_confirmation' => 'ვერიფიკაციის გაუქმების დადასტურება',
        'unverify_customer_confirmation_desc' => 'დარწმუნებული ხართ, რომ გსურთ :name-ის ვერიფიკაციის მოხსნა? ვერიფიცირებულის ნიშანი წაიშლება.',
        'verify_success' => 'მომხმარებელი :name წარმატებით ვერიფიცირდა.',
        'unverify_success' => 'მომხმარებლის :name ვერიფიკაცია წარმატებით მოიხსნა.',
        'already_verified' => 'ეს მომხმარებელი უკვე ვერიფიცირებულია.',
        'already_unverified' => 'ეს მომხმარებელი არ არის ვერიფიცირებული.',
        'upgrade_to_vendor_title' => 'გამყიდველად განახლება',
        'upgrade_to_vendor_description' => 'განაახლეთ ეს მომხმარებელი გამყიდველის სტატუსზე, რათა მათ შეეძლოთ საკუთარი ავტომობილების განთავსება და მართვა.',
        'upgrade_to_vendor_button' => 'გამყიდველად განახლება',
        'upgrade_to_vendor_confirmation' => 'გამყიდველად განახლების დადასტურება',
        'upgrade_to_vendor_confirmation_desc' => 'დარწმუნებული ხართ, რომ გსურთ :name-ის გამყიდველის სტატუსზე განახლება? ეს მათ საშუალებას მისცემს განათავსონ და მართონ საკუთარი ავტომობილები პლატფორმაზე.',
        'upgrade_to_vendor_success' => ':name წარმატებით განახლდა გამყიდველის სტატუსზე.',
        'already_vendor' => 'ეს მომხმარებელი უკვე გამყიდველია.',
        'customer_verified_successfully' => 'ეს მომხმარებელი ვერიფიცირებულია და სანდოა.',
        'customer_not_verified_yet' => 'ეს მომხმარებელი ჯერ არ არის ვერიფიცირებული.',
        'verification_pending' => 'ვერიფიკაცია მოლოდინშია',
        'click_verify_to_approve' => 'დააჭირეთ ქვემოთ მოცემულ ღილაკს მომხმარებლის ვერიფიკაციისთვის და ვერიფიცირებულის ნიშნის საჩვენებლად.',
        'verification_note' => 'ვერიფიკაციის შენიშვნა',
        'verification_note_placeholder' => 'შეიყვანეთ შენიშვნები ამ ვერიფიკაციის მოქმედების შესახებ...',
        'verification_note_helper' => 'დაამატეთ შენიშვნები ვერიფიკაციის პროცესის შესახებ (მხოლოდ შიდა გამოყენებისთვის)',
        'forms' => [
            'name' => 'სახელი',
            'email' => 'ელ. ფოსტა',
            'phone' => 'ტელეფონი',
            'avatar' => 'ავატარი',
            'dob' => 'დაბადების თარიღი',
            'company' => 'კომპანია',
            'position' => 'პოზიცია',
            'password' => 'პაროლი',
            'password_confirmation' => 'პაროლის დადასტურება',
            'change_password' => 'პაროლის შეცვლა?',
            'phone_placeholder' => 'ტელეფონი',
        ],
    ],
    'vendor' => [
        'name' => 'გამყიდველები',
        'view' => 'ნახვა :name',
        'information' => 'გამყიდველის ინფორმაცია',
        'total_cars' => 'ავტომობილების სულ',
        'total_bookings' => 'დაჯავშნების სულ',
        'verified' => 'ვერიფიცირებული',
        'not_verified' => 'არ არის ვერიფიცირებული',
        'verification_section' => 'გამყიდველის ვერიფიკაცია',
        'vendor_verified_successfully' => 'ეს გამყიდველი ვერიფიცირებულია და სანდოა.',
        'vendor_not_verified_yet' => 'ეს გამყიდველი ჯერ არ არის ვერიფიცირებული.',
        'verification_pending' => 'ვერიფიკაცია მოლოდინშია',
        'click_verify_to_approve' => 'დააჭირეთ ქვემოთ მოცემულ ღილაკს ამ გამყიდველის ვერიფიკაციისთვის და ვერიფიცირებულის ნიშნის საჩვენებლად.',
        'verify_vendor' => 'გამყიდველის ვერიფიკაცია',
        'unverify_vendor' => 'ვერიფიკაციის გაუქმება',
        'verify_vendor_confirmation' => 'გამყიდველის ვერიფიკაციის დადასტურება',
        'verify_vendor_confirmation_desc' => 'დარწმუნებული ხართ, რომ გსურთ :name-ის ვერიფიკაცია? ეს გამოაჩენს ვერიფიცირებულის ნიშანს მათ პროფილზე.',
        'unverify_vendor_confirmation' => 'ვერიფიკაციის გაუქმების დადასტურება',
        'unverify_vendor_confirmation_desc' => 'დარწმუნებული ხართ, რომ გსურთ :name-ის ვერიფიკაციის მოხსნა? ვერიფიცირებულის ნიშანი წაიშლება.',
        'verified_successfully' => 'გამყიდველი წარმატებით ვერიფიცირდა.',
        'unverified_successfully' => 'გამყიდველის ვერიფიკაცია წარმატებით მოიხსნა.',
        'already_verified' => 'ეს გამყიდველი უკვე ვერიფიცირებულია.',
        'not_verified_yet' => 'ეს გამყიდველი ჯერ არ არის ვერიფიცირებული.',
        'recent_activity' => 'ბოლო აქტივობა',
        'recent_cars' => 'ბოლო ავტომობილები',
        'recent_bookings' => 'ბოლო დაჯავშნები',
        'no_cars_yet' => 'ავტომობილები ჯერ არ დამატებულა.',
        'no_bookings_yet' => 'დაჯავშნები ჯერ არ მიღებულა.',
    ],
    'make' => [
        'name' => 'მწარმოებლები',
        'create' => 'ავტომობილის მწარმოებლის შექმნა',
        'forms' => [
            'logo' => 'ლოგო',
            'logo_dark' => 'ლოგო მუქი',
        ],
    ],
    'car' => [
        'name' => 'ავტომობილები',
        'create' => 'ავტომობილის შექმნა',
        'forms' => [
            'car' => 'ავტომობილი',
            'logo' => 'ლოგო',
            'license_plate' => 'სახელმწიფო ნომერი',
            'make' => 'მწარმოებელი',
            'model' => 'მოდელი',
            'name' => 'სახელი',
            'images' => 'სურათები',
            'year' => 'წელი',
            'color' => 'ფერი',
            'mileage' => 'გარბენი',
            'kilometers' => 'კილომეტრები',
            'horsepower' => 'ცხენის ძალა',
            'vehicle_type' => 'ავტომობილის ტიპი',
            'transmission' => 'გადაცემათა კოლოფი',
            'fuel_type' => 'საწვავის ტიპი',
            'rental_rate' => 'დაქირავების ტარიფი',
            'currency' => 'ვალუტა',
            'status' => 'სტატუსი',
            'availability' => 'ხელმისაწვდომობა',
            'insurance_info' => 'დაზღვევის ინფორმაცია',
            'number_of_seats' => 'ადგილების რაოდენობა',
            'number_of_doors' => 'კარების რაოდენობა',
            'vin' => 'VIN კოდი',
            'maintenance_history' => 'ტექმომსახურების ისტორია',
            'location' => 'ადგილმდებარეობა',
            'description' => 'აღწერა',
            'rental_type' => 'დაქირავების ტიპი',
            'tags' => 'ტეგები',
            'add_new_attribute' => 'ახლის დამატება <a href=":url" target="_blank">აქ</a>.',
            'categories' => 'კატეგორიები',
            'pick_address' => 'აღების მისამართი',
            'return_address' => 'დაბრუნების მისამართი',
            'same_drop_off' => 'იგივე ჩაბარების ადგილი',
            'tax' => 'გადასახადი',
            'select_tax' => 'აირჩიეთ გადასახადი',
            'none' => 'არცერთი',
            'colors' => 'ფერები',
            'amenities' => 'კომფორტი',
            'is_used' => 'გამოყენებული?',
            'moderation_status' => 'მოდერაციის სტატუსი',
            'status_moderation' => [
                'approve' => 'დამტკიცება',
                'reject' => 'უარყოფა',
                'approve_title' => 'ავტომობილის დამტკიცება',
                'approve_message' => 'დარწმუნებული ხართ, რომ გსურთ ამ ავტომობილის დამტკიცება? ეს მოქმედება ვერ გაუქმდება.',
                'reject_title' => 'ავტომობილის უარყოფა',
                'reject_message' => 'დარწმუნებული ხართ, რომ გსურთ ამ ავტომობილის უარყოფა? ეს მოქმედება ვერ გაუქმდება.',
                'reject_reason' => 'შეიყვანეთ უარყოფის მიზეზი',
                'approved' => 'ავტომობილი წარმატებით დამტკიცდა!',
                'rejected' => 'ავტომობილი წარმატებით უარყოფილია!',
                'reason_rejected' => 'უარყოფის მიზეზი',
            ],
            'customer' => 'მომხმარებელი',
            'select_customer' => 'აირჩიეთ მომხმარებელი...',
            'vendor_images' => 'სურათები (მაქსიმუმ :max სურათი)',
            'images_upload_placeholder' => 'გადმოიტანეთ ფაილები აქ ან დააწკაპუნეთ ატვირთვისთვის.',
            'car_purpose' => 'ავტომობილის დანიშნულება',
            'for_rent' => 'დასაქირავებლად',
            'for_sale' => 'გასაყიდად',
            'car_type' => 'ავტომობილის ტიპი',
            'rental_information' => 'დაქირავების ინფორმაცია',
            'sale_statuses' => [
                'available' => 'ხელმისაწვდომი',
                'sold' => 'გაყიდული',
                'reserved' => 'დაჯავშნული',
            ],
            'selling_information' => 'გაყიდვის ინფორმაცია',
            'is_for_sale' => 'გასაყიდია',
            'sale_price' => 'გასაყიდი ფასი',
            'sale_price_placeholder' => 'შეიყვანეთ გასაყიდი ფასი',
            'condition' => 'მდგომარეობა',
            'select_condition' => 'აირჩიეთ მდგომარეობა',
            'condition_options' => [
                'new' => 'ახალი',
                'like_new' => 'ახალივით',
                'excellent' => 'შესანიშნავი',
                'good' => 'კარგი',
                'fair' => 'დამაკმაყოფილებელი',
                'poor' => 'ცუდი',
            ],
            'ownership_history' => 'მფლობელობის ისტორია',
            'ownership_history_placeholder' => 'შეიყვანეთ მფლობელობის ისტორია',
            'warranty_information' => 'გარანტიის ინფორმაცია',
            'warranty_information_placeholder' => 'შეიყვანეთ გარანტიის ინფორმაცია',
            'sale_status' => 'გაყიდვის სტატუსი',
            'external_booking_url' => 'გარე დაჯავშნის ბმული',
            'external_booking_url_helper' => 'შეიყვანეთ გარე URL სადაც მომხმარებლებს შეუძლიათ დაჯავშნონ ეს ავტომობილი ამ პლატფორმის გარეთ. დატოვეთ ცარიელი თუ დაჯავშნა მხოლოდ ამ საიტზეა ხელმისაწვდომი.',
            'address' => 'მისამართი',
            'address_helper' => 'შეიყვანეთ კონკრეტული ქუჩის მისამართი სადაც ავტომობილი მდებარეობს',
        ],
        'car_purposes' => [
            'sale' => 'გასაყიდად',
            'rent' => 'დასაქირავებლად',
        ],
        'placeholders' => [
            'name' => 'შეიყვანეთ ავტომობილის სახელი (მაგ., Toyota Camry 2023, Honda CR-V და ა.შ.)',
            'description' => 'შეიყვანეთ ავტომობილის მოკლე აღწერა ძირითადი მახასიათებლების ხაზგასმით',
            'rental_rate' => 'შეიყვანეთ დაქირავების ტარიფი არჩეული დაქირავების ტიპის მიხედვით',
            'location' => 'შეიყვანეთ ავტომობილის ფიზიკური მდებარეობა',
            'address' => 'შეიყვანეთ კონკრეტული ქუჩის მისამართი (მაგ., თბილისი, რუსთაველის 123)',
            'sale_price' => 'შეიყვანეთ ამ ავტომობილის გასაყიდი ფასი',
            'ownership_history' => 'შეიყვანეთ დეტალები წინა მფლობელების შესახებ, მფლობელთა რაოდენობა და ა.შ.',
            'warranty_information' => 'შეიყვანეთ დეტალები გარანტიის დაფარვის, ვადის გასვლის თარიღის შესახებ და ა.შ.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'შეიყვანეთ ავტომობილის სახელმწიფო ნომერი',
            'vin' => 'შეიყვანეთ ავტომობილის საიდენტიფიკაციო ნომერი (VIN)',
            'year' => 'შეიყვანეთ გამოშვების წელი (მაგ., 2023)',
            'mileage' => 'შეიყვანეთ მიმდინარე გარბენი',
            'kilometers' => 'შეიყვანეთ მიმდინარე კილომეტრები',
            'horsepower' => 'შეიყვანეთ ავტომობილის ცხენის ძალა (მაგ., 150.5)',
            'number_of_seats' => 'შეიყვანეთ ავტომობილში ადგილების რაოდენობა',
            'number_of_doors' => 'შეიყვანეთ ავტომობილის კარების რაოდენობა',
            'insurance_info' => 'შეიყვანეთ ამ ავტომობილის დაზღვევის შესაბამისი ინფორმაცია',
            'tags' => 'აირჩიეთ ან შექმენით ტეგები',
            'amenities' => 'აირჩიეთ კომფორტი',
            'colors' => 'აირჩიეთ ან შექმენით ფერები',
        ],
        'enums' => [
            'vendor_status' => 'გამყიდველის სტატუსი',
            'is_vendor' => 'გამყიდველი',
            'not_vendor' => 'მომხმარებელი',
            'statuses' => [
                'available' => 'ხელმისაწვდომი',
                'rented' => 'დაქირავებული',
                'maintenance' => 'ტექმომსახურება',
                'out_of_service' => 'გამოსულია მომსახურებიდან',
            ],
            'rental_types' => [
                'per_hour' => 'საათში',
                'per_day' => 'დღეში',
                'per_week' => 'კვირაში',
                'per_month' => 'თვეში',
            ],
            'moderation_statuses' => [
                'pending' => 'მოლოდინში',
                'approved' => 'დამტკიცებული',
                'rejected' => 'უარყოფილი',
            ],
        ],
        'maintenance_history' => [
            'name' => 'ტექმომსახურების ისტორია',
            'create' => 'სერვისის ისტორიის შექმნა',
            'amount' => 'თანხა',
            'forms' => [
                'price_placeholder' => 'სერვისის ფასი',
                'currency' => 'ვალუტა',
                'none' => 'არცერთი',
                'name' => 'სახელი',
                'amount' => 'თანხა',
                'created_at' => 'შექმნის თარიღი',
                'action' => 'მოქმედება',
                'date' => 'თარიღი',
                'no_maintenance_history' => 'ტექმომსახურების ისტორია არ არის',
                'edit_maintenance_history' => 'ტექმომსახურების ისტორიის რედაქტირება',
                'add_maintenance_history' => 'ტექმომსახურების ისტორიის დამატება',
                'add' => 'დამატება',
                'edit' => 'რედაქტირება',
                'delete' => 'წაშლა',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'ავტომობილის ატრიბუტები',
        'car_type' => [
            'name' => 'ტიპები',
            'create' => 'ავტომობილის ტიპის შექმნა',
            'forms' => [
                'name' => 'სახელი',
            ],
        ],
        'transmission' => [
            'name' => 'გადაცემათა კოლოფები',
            'create' => 'გადაცემათა კოლოფის შექმნა',
            'forms' => [
                'name' => 'სახელი',
            ],
        ],
        'fuel_type' => [
            'name' => 'საწვავი',
            'create' => 'საწვავის ტიპის შექმნა',
            'forms' => [
                'name' => 'სახელი',
            ],
        ],
        'tag' => [
            'name' => 'ტეგები',
            'create' => 'ტეგის შექმნა',
        ],
        'category' => [
            'name' => 'კატეგორიები',
            'create' => 'კატეგორიის შექმნა',
            'forms' => [
                'none' => 'არცერთი',
                'total_cars' => 'ავტომობილების სულ: :total',
            ],
        ],
        'address' => [
            'name' => 'ადგილმდებარეობები',
            'create' => 'ავტომობილის ადგილმდებარეობის შექმნა',
            'form' => [
                'name' => 'მისამართი',
                'full_address' => 'სრული მისამართი',
                'detail_address' => 'დეტალური მისამართი',
            ],
        ],
        'color' => [
            'name' => 'ფერი',
            'create' => 'ფერის შექმნა',
        ],
        'amenity' => [
            'name' => 'კომფორტი',
            'create' => 'კომფორტის შექმნა',
        ],
    ],
    'tax' => [
        'name' => 'გადასახადები',
        'create' => 'გადასახადის შექმნა',
        'forms' => [
            'name' => 'სახელი',
            'name_placeholder' => 'შეიყვანეთ სახელი',
            'percentage' => 'პროცენტი',
            'percentage_placeholder' => 'პროცენტი',
            'percent_placeholder' => 'პროცენტი',
            'priority' => 'პრიორიტეტი',
            'priority_placeholder' => 'პრიორიტეტი',
        ],
    ],
    'review' => [
        'name' => 'მიმოხილვები',
        'create' => 'მიმოხილვის შექმნა',
        'edit' => 'მიმოხილვის რედაქტირება',
        'vendor' => [
            'title' => 'მომხმარებლების მიმოხილვები',
            'description' => 'მართეთ ყველა მომხმარებლის მიმოხილვა თქვენი ავტომობილებისთვის',
            'no_reviews' => 'თქვენ ჯერ არ გაქვთ მიმოხილვები',
            'filter_by_car' => 'ფილტრაცია ავტომობილის მიხედვით',
            'filter_by_rating' => 'ფილტრაცია რეიტინგის მიხედვით',
            'filter_by_date' => 'ფილტრაცია თარიღის მიხედვით',
            'all_cars' => 'ყველა ავტომობილი',
            'all_ratings' => 'ყველა რეიტინგი',
            'manage_reviews' => 'მიმოხილვების მართვა',
            'view_all' => 'ყველა მიმოხილვის ნახვა',
            'delete_review_confirmation' => 'დარწმუნებული ხართ, რომ გსურთ ამ მიმოხილვის წაშლა?',
            'delete_review_success' => 'მიმოხილვა წარმატებით წაიშალა',
            'cannot_delete' => 'ამ მიმოხილვის წაშლა შეუძლებელია',
        ],
        'forms' => [
            'customer' => 'მომხმარებელი',
            'car' => 'ავტომობილი',
            'content' => 'შინაარსი',
            'rating' => 'რეიტინგი',
            'your_name' => 'თქვენი სახელი',
            'email_address' => 'ელ. ფოსტის მისამართი',
            'submit' => 'გაგზავნა',
            'star' => 'ვარსკვლავი',
            'status' => 'სტატუსი',
            'created_at' => 'შექმნის თარიღი',
            'select_car' => 'აირჩიეთ ავტომობილი',
            'select_rating' => 'აირჩიეთ რეიტინგი',
            'comment' => 'კომენტარი',
            'reply' => 'პასუხი',
            'reply_to_review' => 'მიმოხილვაზე პასუხი',
            'save_reply' => 'პასუხის შენახვა',
            'cancel_reply' => 'გაუქმება',
        ],
        'statuses' => [
            'published' => 'გამოქვეყნებული',
            'pending' => 'მოლოდინში',
            'rejected' => 'უარყოფილი',
        ],
        'ratings' => [
            '1' => '1 ვარსკვლავი - ცუდი',
            '2' => '2 ვარსკვლავი - დამაკმაყოფილებელი',
            '3' => '3 ვარსკვლავი - კარგი',
            '4' => '4 ვარსკვლავი - ძალიან კარგი',
            '5' => '5 ვარსკვლავი - შესანიშნავი',
        ],
    ],
    'coupon' => [
        'name' => 'კუპონები',
        'create' => 'კუპონის შექმნა',
        'types' => [
            'percentage' => 'პროცენტი %',
            'money' => 'თანხა',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'სერვისები',
        'create' => 'სერვისის შექმნა',
        'forms' => [
            'name' => 'სახელი',
            'content' => 'შინაარსი',
            'price' => 'ფასი',
            'currency' => 'ვალუტა',
            'image' => 'სურათი',
            'logo' => 'ლოგო',
            'status' => 'სტატუსი',
        ],
    ],
    'availability_calendar' => [
        'name' => 'ხელმისაწვდომობის კალენდარი',
        'title' => 'ხელმისაწვდომობის კალენდარი',
        'description' => 'ნახეთ ავტომობილის ხელმისაწვდომობა და დაჯავშნები კალენდარის ფორმატში',
        'select_dates' => 'აირჩიეთ თარიღები ხელმისაწვდომობის შესამოწმებლად',
        'car_filter' => 'ფილტრაცია ავტომობილის მიხედვით',
        'all_cars' => 'ყველა ავტომობილი',
        'clear_filter' => 'ფილტრის გასუფთავება',
        'availability_check' => 'ავტომობილის ხელმისაწვდომობის შემოწმება',
        'selected_period' => 'არჩეული პერიოდი',
        'checking_availability' => 'ხელმისაწვდომობის შემოწმება...',
        'available' => 'ხელმისაწვდომი',
        'not_available' => 'მიუწვდომელი',
        'booking_details' => 'დაჯავშნის დეტალები',
        'how_to_use' => 'როგორ გამოვიყენოთ ავტომობილის ხელმისაწვდომობის კალენდარი',
        'viewing_bookings' => 'დაჯავშნების ნახვა',
        'checking_availability_help' => 'ხელმისაწვდომობის შემოწმება',
        'color_legend' => 'ფერის ლეგენდა',
        'pending_bookings' => 'მოლოდინში მყოფი დაჯავშნები',
        'processing_bookings' => 'მუშავდება დაჯავშნები',
        'completed_bookings' => 'დასრულებული დაჯავშნები',
        'cancelled_bookings' => 'გაუქმებული დაჯავშნები',
        'unknown_make' => 'უცნობი მწარმოებელი',
        'loading' => 'იტვირთება...',
        'loading_calendar_data' => 'კალენდარის მონაცემების ჩატვირთვა...',
        'loading_booking_details' => 'დაჯავშნის დეტალების ჩატვირთვა...',
        'please_wait_booking_info' => 'გთხოვთ დაელოდოთ, სანამ ჩამოვტვირთავთ დაჯავშნის ინფორმაციას.',
        'please_wait_availability' => 'გთხოვთ დაელოდოთ, სანამ შევამოწმებთ ავტომობილის ხელმისაწვდომობას თქვენს არჩეულ თარიღებზე.',
        'error' => 'შეცდომა',
        'error_loading_booking' => 'დაჯავშნის დეტალების ჩატვირთვა ვერ მოხერხდა. გთხოვთ სცადოთ ხელახლა.',
        'error_checking_availability' => 'ავტომობილის ხელმისაწვდომობის შემოწმების შეცდომა',
        'customer' => 'მომხმარებელი',
        'status' => 'სტატუსი',
        'amount' => 'თანხა',
        'make' => 'მწარმოებელი',
        'vendor' => 'გამყიდველი',
        'per_day' => '/დღე',
        'edit_car' => 'ავტომობილის რედაქტირება',
        'no_cars_found' => 'ავტომობილები ვერ მოიძებნა',
        'no_cars_available_period' => 'არჩეული პერიოდისთვის ხელმისაწვდომი ავტომობილები არ არის.',
        'close' => 'დახურვა',
        'edit_booking' => 'დაჯავშნის რედაქტირება',
        'pending' => 'მოლოდინში',
        'processing' => 'მუშავდება',
        'completed' => 'დასრულებული',
        'cancelled' => 'გაუქმებული',
    ],
    'theme_options' => [
        'name' => 'ავტომობილების დაქირავება',
        'description' => 'თემის პარამეტრები ავტომობილების დაქირავებისთვის',
        'car_location_filter_by' => 'ავტომობილის ადგილმდებარეობის ფილტრაცია',
        'state' => 'შტატი',
        'city' => 'ქალაქი',
        'yes' => 'დიახ',
        'no' => 'არა',
        'is_display_country' => 'გამოჩნდეს ქვეყანა ადგილმდებარეობის ფილტრში?',
        'logo_vendor_dashboard' => 'ლოგო გამყიდველის დაშბორდში (ნაგულისხმევია მთავარი ლოგო)',
        'number_of_cars_per_page' => 'ავტომობილების რაოდენობა გვერდზე',
        'number_of_cars_per_page_placeholder' => 'შეიყვანეთ გვერდზე გამოსაჩენი ავტომობილების რაოდენობა',
    ],
    'message' => [
        'name' => 'შეტყობინებები',
        'forms' => [
            'customer_name' => 'მომხმარებლის სახელი',
            'message' => 'შეტყობინება',
            'phone' => 'ტელეფონი',
            'email' => 'ელ. ფოსტა',
            'created_at' => 'შექმნის თარიღი',
            'status' => 'სტატუსი',
        ],
    ],
    'car_sale' => [
        'name' => 'ავტომობილის გაყიდვები',
        'create' => 'ახალი ავტომობილის გაყიდვა',
        'edit' => 'ავტომობილის გაყიდვის რედაქტირება :name',
        'statuses' => [
            'pending' => 'მოლოდინში',
            'processing' => 'მუშავდება',
            'completed' => 'დასრულებული',
            'cancelled' => 'გაუქმებული',
        ],
        'forms' => [
            'transaction_id' => 'ტრანზაქციის ID',
            'transaction_id_placeholder' => 'შეიყვანეთ ტრანზაქციის ID',
            'car_id' => 'ავტომობილი',
            'car' => 'ავტომობილი',
            'customer_id' => 'მომხმარებელი',
            'customer_name' => 'მომხმარებლის სახელი',
            'customer_name_placeholder' => 'შეიყვანეთ მომხმარებლის სახელი',
            'customer_email' => 'მომხმარებლის ელ. ფოსტა',
            'customer_email_placeholder' => 'შეიყვანეთ მომხმარებლის ელ. ფოსტა',
            'customer_phone' => 'მომხმარებლის ტელეფონი',
            'customer_phone_placeholder' => 'შეიყვანეთ მომხმარებლის ტელეფონი',
            'sale_price' => 'გასაყიდი ფასი',
            'sale_price_placeholder' => 'შეიყვანეთ გასაყიდი ფასი',
            'tax_amount' => 'გადასახადის თანხა',
            'tax_amount_placeholder' => 'შეიყვანეთ გადასახადის თანხა',
            'total_amount' => 'სრული თანხა',
            'total_amount_placeholder' => 'შეიყვანეთ სრული თანხა',
            'payment_details' => 'გადახდის დეტალები',
            'payment_details_placeholder' => 'შეიყვანეთ გადახდის დეტალები',
            'notes' => 'შენიშვნები',
            'notes_placeholder' => 'შეიყვანეთ შენიშვნები',
            'sale_date' => 'გაყიდვის თარიღი',
            'delivery_date' => 'მიწოდების თარიღი',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'ბანკის გადარიცხვა',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'ავტომობილის დაქირავების დაჯავშნის დადასტურება',
        'booking_confirm_greeting' => 'ძვირფასო :customer_name,',
        'booking_confirm_message' => 'მოხარულები ვართ გაცნობოთ, რომ თქვენი ავტომობილის დაქირავების დაჯავშნა წარმატებით დადასტურდა!',
        'customer_information' => 'მომხმარებლის ინფორმაცია',
        'booking_information' => 'დაჯავშნის ინფორმაცია',
        'field_name' => 'სახელი:',
        'field_phone' => 'ტელეფონი:',
        'field_email' => 'ელ. ფოსტა:',
        'field_car_model' => 'ავტომობილის მოდელი:',
        'field_start_date' => 'დაწყების თარიღი:',
        'field_end_date' => 'დასრულების თარიღი:',
        'field_pickup_address' => 'აღების მისამართი:',
        'field_return_address' => 'დაბრუნების მისამართი:',
        'field_note' => 'შენიშვნა:',
        'field_order_number' => 'შეკვეთის ნომერი',
        'field_payment_method' => 'გადახდის მეთოდი',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'ახალი დაჯავშნის შეტყობინება',
        'booking_notice_admin_greeting' => 'გამარჯობა, ახალი დაჯავშნაა :site_title-დან:',
        'booking_notice_admin_message' => 'ახალი ავტომობილის დაქირავების დაჯავშნა გაგზავნილია და მოითხოვს თქვენს ყურადღებას.',
        'booking_view_detail' => 'დაჯავშნის დეტალების ნახვა:',
        'view_booking_details' => 'დაჯავშნის დეტალების ნახვა',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'ახალი დაჯავშნა თქვენი ავტომობილისთვის',
        'booking_notice_vendor_greeting' => 'ძვირფასო :vendor_name,',
        'booking_notice_vendor_message' => 'შესანიშნავი ამბავი! თქვენ მიიღეთ ახალი დაჯავშნა თქვენი ავტომობილის დაქირავებისთვის.',

        // Booking status changed email
        'booking_status_updated' => 'დაჯავშნის სტატუსი განახლდა',
        'hello_thanks_for_booking' => 'გამარჯობა, მადლობა დაჯავშნისთვის :site_title-დან:',
        'booking_status_change_message' => 'იმედს ვიტოვებთ ამ შეტყობინება კარგად გხვდებათ. გვინდა გაცნობოთ, რომ თქვენი დაჯავშნის სტატუსი განახლდა.',
        'name' => 'სახელი',
        'phone' => 'ტელეფონი',
        'email' => 'ელ. ფოსტა',
        'car_model' => 'ავტომობილის მოდელი',
        'start_date' => 'დაწყების თარიღი',
        'end_date' => 'დასრულების თარიღი',
        'pickup_address' => 'აღების მისამართი',
        'return_address' => 'დაბრუნების მისამართი',
        'note' => 'შენიშვნა',
        'order_number' => 'შეკვეთის ნომერი',
        'payment_method' => 'გადახდის მეთოდი',

        // Car approved email
        'hello' => 'გამარჯობა',
        'car_approved_title' => 'შესანიშნავი ამბავი! თქვენი ავტომობილი დამტკიცდა',
        'car_approved_message' => 'მოხარულები ვართ გაცნობოთ, რომ თქვენი ავტომობილის განცხადება ":car_name" დამტკიცდა და ახლა ცოცხალია :site_title-ზე. შეგიძლიათ დაიწყოთ დაჯავშნების მიღება და თქვენი განცხადების მართვა ახლავე.',
        'view_edit_car_link' => 'თქვენი ავტომობილის განცხადების სანახავად ან რედაქტირებისთვის, გთხოვთ დააწკაპუნოთ ამ ბმულზე',
        'view_car' => 'ავტომობილის განცხადების ნახვა',
        'regards' => 'პატივისცემით',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'გილოცავთ! თქვენ ახლა გამყიდველი ხართ',
        'vendor_upgrade_congratulations' => 'მოხარულები ვართ გაცნობოთ, რომ თქვენი ანგარიში წარმატებით განახლდა გამყიდველის სტატუსზე!',
        'vendor_upgrade_message' => 'ახლა შეგიძლიათ განათავსოთ და მართოთ თქვენი საკუთარი ავტომობილები :site_title-ზე. ეს გახსნით ახალ შესაძლებლობებს თქვენი საიჯარო ბიზნესის განვითარებისთვის ჩვენთან ერთად.',
        'vendor_benefits_title' => 'თქვენი ახალი გამყიდველის უპირატესობები',
        'vendor_benefit_1' => 'შეუზღუდავი ავტომობილების განთავსება დაქირავებისთვის',
        'vendor_benefit_2' => 'თქვენი საკუთარი დაჯავშნებისა და მომხმარებლების მართვა',
        'vendor_benefit_3' => 'შემოსავლისა და მუშაობის მეტრიკების თვალყურის დევნება',
        'vendor_benefit_4' => 'წვდომა გამყიდველის ექსკლუზიურ ფუნქციებზე და ხელსაწყოებზე',
        'next_steps' => 'შემდეგი ნაბიჯები',
        'vendor_next_steps_message' => 'შედით თქვენს გამყიდველის დაშბორდში, რათა დაიწყოთ თქვენი ავტომობილების დამატება და თქვენი საიჯარო ბიზნესის მართვა.',
        'go_to_dashboard' => 'გადასვლა გამყიდველის დაშბორდზე',
        'vendor_support_message' => 'თუ გაქვთ რაიმე შეკითხვა ან საჭიროებთ დახმარებას, ჩვენი მხარდაჭერის გუნდი აქ არის, რათა დაგეხმაროთ დაწყებაში.',
        'approved' => 'დამტკიცებული',

        // Car rejected email
        'car_rejected_title' => 'საჭიროა განახლება თქვენი ავტომობილის განცხადებისთვის',
        'car_rejected_message' => 'გმადლობთ თქვენი ავტომობილის განცხადების ":car_name" გაგზავნისთვის :site_title-ზე. თქვენი წარდგენის განხილვის შემდეგ, გვჭირდება რამდენიმე კორექტირების გაკეთება, სანამ ვამტკიცებთ მას.',
        'rejection_reason' => 'აი რა საჭიროებს განახლებას',
        'rejection_details' => 'საჭირო განახლებები',
        'contact_support' => 'თუ გაქვთ რაიმე შეკითხვა ან საჭიროებთ დახმარებას ამ განახლებებთან, გთხოვთ არ ყოყმანოთ დაუკავშირდეთ ჩვენს მხარდაჭერის გუნდს :site_email-ზე. ჩვენ აქ ვართ, რათა დაგეხმაროთ თქვენი განცხადების სწრაფად დამტკიცებაში.',

        // Confirm email
        'verify_email' => 'ელ. ფოსტის ვერიფიკაცია',
        'welcome_message' => 'მოხარულები ვართ აქ გყავთ, :customer_name!',
        'verify_email_instruction' => 'გთხოვთ დაადასტუროთ თქვენი ელ. ფოსტის მისამართი ამ ვებსაიტზე წვდომისთვის. დააწკაპუნეთ ქვემოთ მოცემულ ღილაკზე თქვენი ელ. ფოსტის დასადასტურებლად.',
        'confirm_email_button' => 'დაადასტურეთ თქვენი ელ. ფოსტის მისამართი',
        'verify_link_trouble' => 'თუ პრობლემა გაქვთ \'დაადასტურეთ თქვენი ელ. ფოსტის მისამართი\' ღილაკზე დაწკაპუნებით, დააკოპირეთ და ჩასვით ქვემოთ მოცემული URL თქვენს ბრაუზერში: :verify_link და ჩასვით იგი თქვენს ბრაუზერში.',

        // Message email
        'new_message' => 'ახალი შეტყობინება',
        'dear_admin' => 'ძვირფასო ადმინისტრატორ',
        'new_message_from' => 'ახალი შეტყობინებაა :site_title-დან:',
        'subject' => 'თემა',
        'address' => 'მისამართი',
        'content' => 'შინაარსი',

        // New pending car email
        'hi_admin' => 'გამარჯობა ადმინისტრატორ,',
        'new_car_pending_title' => 'ახალი ავტომობილის განცხადება მოლოდინშია განხილვისთვის',
        'new_car_pending_approval' => 'ახალი ავტომობილის განცხადება ":post_name" გაგზავნილია :post_author-ის მიერ და მზადაა თქვენი განხილვისთვის.',
        'pending_approval' => 'მოლოდინში განხილვისთვის',
        'review_car_admin' => 'გთხოვთ განიხილოთ ეს განცხადება ადმინისტრატორის პანელში და დაამტკიცოთ ან მოითხოვოთ განახლებები საჭიროების მიხედვით.',

        // Common fields
        'car_information' => 'ავტომობილის ინფორმაცია',
        'field_car_name' => 'ავტომობილის სახელი:',
        'field_author' => 'ავტორი:',
        'field_status' => 'სტატუსი:',
        'actions' => 'მოქმედებები',

        // Password reminder email
        'reset_password_instruction' => 'პაროლის აღდგენის ინსტრუქცია',
        'password_reset_request' => 'ამ ელ. ფოსტას იღებთ, რადგან მივიღეთ პაროლის აღდგენის მოთხოვნა თქვენი ანგარიშისთვის.',
        'reset_password_button' => 'პაროლის აღდგენა',
        'reset_link_trouble' => 'თუ პრობლემა გაქვთ \'პაროლის აღდგენა\' ღილაკზე დაწკაპუნებით, დააკოპირეთ და ჩასვით ქვემოთ მოცემული URL თქვენს ბრაუზერში: :reset_link და ჩასვით იგი თქვენს ბრაუზერში. თუ არ მოითხოვეთ პაროლის აღდგენა, გთხოვთ იგნორირება გაუკეთოთ ამ შეტყობინებას ან დაგვიკავშირდით თუ გაქვთ რაიმე შეკითხვა.',
    ],
];
