<?php

return [
    'name' => '렌터카',
    'customer' => [
        'name' => '고객',
        'create' => '고객 생성',
        'view' => '보기',
        'information' => '고객 정보',
        'email' => '이메일',
        'phone' => '전화',
        'status' => '상태',
        'vendor_status' => '판매자 상태',
        'is_vendor' => '판매자',
        'not_vendor' => '고객',
        'recent_activity' => '최근 활동',
        'recent_activity_description' => '고객 활동이 여기에 표시됩니다.',
        'verification_section' => '고객 확인',
        'verified' => '확인됨',
        'not_verified' => '확인되지 않음',
        'verified_by' => '확인자',
        'verified_at' => '확인 날짜',
        'verify_customer' => '고객 확인',
        'unverify_customer' => '고객 확인 취소',
        'verify_customer_confirmation' => '고객 확인',
        'verify_customer_confirmation_desc' => ':name을(를) 확인하시겠습니까? 프로필에 확인됨 배지가 표시됩니다.',
        'unverify_customer_confirmation' => '고객 확인 취소',
        'unverify_customer_confirmation_desc' => ':name의 확인을 제거하시겠습니까? 확인됨 배지가 제거됩니다.',
        'verify_success' => '고객 :name이(가) 성공적으로 확인되었습니다.',
        'unverify_success' => '고객 :name의 확인이 성공적으로 제거되었습니다.',
        'already_verified' => '이 고객은 이미 확인되었습니다.',
        'already_unverified' => '이 고객은 확인되지 않았습니다.',
        'upgrade_to_vendor_title' => '판매자로 업그레이드',
        'upgrade_to_vendor_description' => '이 고객을 판매자 상태로 업그레이드하여 자신의 렌터카를 등록하고 관리할 수 있도록 합니다.',
        'upgrade_to_vendor_button' => '판매자로 업그레이드',
        'upgrade_to_vendor_confirmation' => '판매자 업그레이드 확인',
        'upgrade_to_vendor_confirmation_desc' => ':name을(를) 판매자 상태로 업그레이드하시겠습니까? 플랫폼에서 자신의 차량을 등록하고 관리할 수 있습니다.',
        'upgrade_to_vendor_success' => ':name이(가) 판매자 상태로 성공적으로 업그레이드되었습니다.',
        'already_vendor' => '이 고객은 이미 판매자입니다.',
        'customer_verified_successfully' => '이 고객은 확인되었으며 신뢰할 수 있습니다.',
        'customer_not_verified_yet' => '이 고객은 아직 확인되지 않았습니다.',
        'verification_pending' => '확인 대기 중',
        'click_verify_to_approve' => '아래 버튼을 클릭하여 이 고객을 확인하고 확인됨 배지를 표시하세요.',
        'verification_note' => '확인 비고',
        'verification_note_placeholder' => '이 확인 작업에 대한 비고를 입력하세요...',
        'verification_note_helper' => '확인 프로세스에 대한 비고 추가 (내부 사용만)',
        'forms' => [
            'name' => '이름',
            'email' => '이메일',
            'phone' => '전화',
            'avatar' => '아바타',
            'dob' => '생년월일',
            'company' => '회사',
            'position' => '직위',
            'password' => '비밀번호',
            'password_confirmation' => '비밀번호 확인',
            'change_password' => '비밀번호 변경?',
            'phone_placeholder' => '전화',
        ],
    ],
    'vendor' => [
        'name' => '판매자',
        'view' => ':name 보기',
        'information' => '판매자 정보',
        'total_cars' => '총 차량 수',
        'total_bookings' => '총 예약 수',
        'verified' => '확인됨',
        'not_verified' => '확인되지 않음',
        'verification_section' => '판매자 확인',
        'vendor_verified_successfully' => '이 판매자는 확인되었으며 신뢰할 수 있습니다.',
        'vendor_not_verified_yet' => '이 판매자는 아직 확인되지 않았습니다.',
        'verification_pending' => '확인 대기 중',
        'click_verify_to_approve' => '아래 버튼을 클릭하여 이 판매자를 확인하고 확인됨 배지를 표시하세요.',
        'verify_vendor' => '판매자 확인',
        'unverify_vendor' => '판매자 확인 취소',
        'verify_vendor_confirmation' => '판매자 확인',
        'verify_vendor_confirmation_desc' => ':name을(를) 확인하시겠습니까? 프로필에 확인됨 배지가 표시됩니다.',
        'unverify_vendor_confirmation' => '판매자 확인 취소',
        'unverify_vendor_confirmation_desc' => ':name의 확인을 제거하시겠습니까? 확인됨 배지가 제거됩니다.',
        'verified_successfully' => '판매자가 성공적으로 확인되었습니다.',
        'unverified_successfully' => '판매자 확인이 성공적으로 제거되었습니다.',
        'already_verified' => '이 판매자는 이미 확인되었습니다.',
        'not_verified_yet' => '이 판매자는 아직 확인되지 않았습니다.',
        'recent_activity' => '최근 활동',
        'recent_cars' => '최근 차량',
        'recent_bookings' => '최근 예약',
        'no_cars_yet' => '아직 추가된 차량이 없습니다.',
        'no_bookings_yet' => '아직 받은 예약이 없습니다.',
    ],
    'make' => [
        'name' => '제조사',
        'create' => '차량 제조사 생성',
        'forms' => [
            'logo' => '로고',
            'logo_dark' => '다크 로고',
        ],
    ],
    'car' => [
        'name' => '차량',
        'create' => '차량 생성',
        'forms' => [
            'car' => '차량',
            'logo' => '로고',
            'license_plate' => '번호판',
            'make' => '제조사',
            'model' => '모델',
            'name' => '이름',
            'images' => '이미지',
            'year' => '연식',
            'color' => '색상',
            'mileage' => '주행거리',
            'kilometers' => '킬로미터',
            'horsepower' => '마력',
            'vehicle_type' => '차량 유형',
            'transmission' => '변속기',
            'fuel_type' => '연료 유형',
            'rental_rate' => '대여 요금',
            'currency' => '통화',
            'status' => '상태',
            'availability' => '가용성',
            'insurance_info' => '보험 정보',
            'number_of_seats' => '좌석 수',
            'number_of_doors' => '도어 수',
            'vin' => 'VIN',
            'maintenance_history' => '정비 이력',
            'location' => '위치',
            'description' => '설명',
            'rental_type' => '대여 유형',
            'tags' => '태그',
            'add_new_attribute' => '<a href=":url" target="_blank">여기</a>에서 새로 추가하세요.',
            'categories' => '카테고리',
            'pick_address' => '픽업 주소',
            'return_address' => '반납 주소',
            'same_drop_off' => '동일한 반납 장소',
            'tax' => '세금',
            'select_tax' => '세금 선택',
            'none' => '없음',
            'colors' => '색상',
            'amenities' => '편의시설',
            'is_used' => '중고?',
            'moderation_status' => '검토 상태',
            'status_moderation' => [
                'approve' => '승인',
                'reject' => '거부',
                'approve_title' => '차량 승인',
                'approve_message' => '이 차량을 승인하시겠습니까? 이 작업은 취소할 수 없습니다.',
                'reject_title' => '차량 거부',
                'reject_message' => '이 차량을 거부하시겠습니까? 이 작업은 취소할 수 없습니다.',
                'reject_reason' => '거부 사유 입력',
                'approved' => '차량이 성공적으로 승인되었습니다!',
                'rejected' => '차량이 성공적으로 거부되었습니다!',
                'reason_rejected' => '거부 사유',
            ],
            'customer' => '고객',
            'select_customer' => '고객 선택...',
            'vendor_images' => '이미지 (최대 :max개)',
            'images_upload_placeholder' => '파일을 여기에 드롭하거나 클릭하여 업로드하세요.',
            'car_purpose' => '차량 목적',
            'for_rent' => '대여용',
            'for_sale' => '판매용',
            'car_type' => '차량 유형',
            'rental_information' => '대여 정보',
            'sale_statuses' => [
                'available' => '이용 가능',
                'sold' => '판매됨',
                'reserved' => '예약됨',
            ],
            'selling_information' => '판매 정보',
            'is_for_sale' => '판매 가능',
            'sale_price' => '판매 가격',
            'sale_price_placeholder' => '판매 가격 입력',
            'condition' => '상태',
            'select_condition' => '상태 선택',
            'condition_options' => [
                'new' => '새 것',
                'like_new' => '새 것과 같음',
                'excellent' => '우수',
                'good' => '양호',
                'fair' => '보통',
                'poor' => '불량',
            ],
            'ownership_history' => '소유 이력',
            'ownership_history_placeholder' => '소유 이력 입력',
            'warranty_information' => '보증 정보',
            'warranty_information_placeholder' => '보증 정보 입력',
            'sale_status' => '판매 상태',
            'external_booking_url' => '오프사이트 예약 링크',
            'external_booking_url_helper' => '이 플랫폼 외부에서 고객이 이 차량을 예약할 수 있는 외부 URL을 입력하세요. 이 사이트에서만 예약 가능한 경우 비워두세요.',
            'address' => '주소',
            'address_helper' => '이 차량이 위치한 구체적인 주소를 입력하세요',
        ],
        'car_purposes' => [
            'sale' => '판매용',
            'rent' => '대여용',
        ],
        'placeholders' => [
            'name' => '차량 이름 입력 (예: 토요타 캠리 2023, 혼다 CR-V 등)',
            'description' => '주요 기능을 강조하는 차량에 대한 간단한 설명 입력',
            'rental_rate' => '선택한 대여 유형에 따른 대여 요금 입력',
            'location' => '차량의 물리적 위치 입력',
            'address' => '구체적인 주소 입력 (예: 서울시 강남구 강남대로 123)',
            'sale_price' => '이 차량의 판매 가격 입력',
            'ownership_history' => '이전 소유자, 소유자 수 등에 대한 세부 정보 입력',
            'warranty_information' => '보증 범위, 만료 날짜 등에 대한 세부 정보 입력',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => '차량 번호판 번호 입력',
            'vin' => '차량 식별 번호(VIN) 입력',
            'year' => '제조 연도 입력 (예: 2023)',
            'mileage' => '현재 주행거리 입력',
            'kilometers' => '현재 킬로미터 입력',
            'horsepower' => '차량의 마력(HP) 입력 (예: 150.5)',
            'number_of_seats' => '차량의 좌석 수 입력',
            'number_of_doors' => '차량의 도어 수 입력',
            'insurance_info' => '이 차량에 대한 관련 보험 정보 입력',
            'tags' => '태그 선택 또는 생성',
            'amenities' => '편의시설 선택',
            'colors' => '색상 선택 또는 생성',
        ],
        'enums' => [
            'vendor_status' => '판매자 상태',
            'is_vendor' => '판매자',
            'not_vendor' => '고객',
            'statuses' => [
                'available' => '이용 가능',
                'rented' => '대여 중',
                'maintenance' => '정비 중',
                'out_of_service' => '서비스 불가',
            ],
            'rental_types' => [
                'per_hour' => '시간당',
                'per_day' => '일당',
                'per_week' => '주당',
                'per_month' => '월당',
            ],
            'moderation_statuses' => [
                'pending' => '대기 중',
                'approved' => '승인됨',
                'rejected' => '거부됨',
            ],
        ],
        'maintenance_history' => [
            'name' => '정비 이력',
            'create' => '서비스 이력 생성',
            'amount' => '금액',
            'forms' => [
                'price_placeholder' => '서비스 가격',
                'currency' => '통화',
                'none' => '없음',
                'name' => '이름',
                'amount' => '금액',
                'created_at' => '생성일',
                'action' => '작업',
                'date' => '날짜',
                'no_maintenance_history' => '정비 이력 없음',
                'edit_maintenance_history' => '정비 이력 편집',
                'add_maintenance_history' => '정비 이력 추가',
                'add' => '추가',
                'edit' => '편집',
                'delete' => '삭제',
            ],
        ],
    ],
    'attribute' => [
        'name' => '차량 속성',
        'car_type' => [
            'name' => '유형',
            'create' => '차량 유형 생성',
            'forms' => [
                'name' => '이름',
            ],
        ],
        'transmission' => [
            'name' => '변속기',
            'create' => '변속기 생성',
            'forms' => [
                'name' => '이름',
            ],
        ],
        'fuel_type' => [
            'name' => '연료',
            'create' => '연료 유형 생성',
            'forms' => [
                'name' => '이름',
            ],
        ],
        'tag' => [
            'name' => '태그',
            'create' => '태그 생성',
        ],
        'category' => [
            'name' => '카테고리',
            'create' => '카테고리 생성',
            'forms' => [
                'none' => '없음',
                'total_cars' => '총 차량: :total',
            ],
        ],
        'address' => [
            'name' => '위치',
            'create' => '차량 위치 생성',
            'form' => [
                'name' => '주소',
                'full_address' => '전체 주소',
                'detail_address' => '상세 주소',
            ],
        ],
        'color' => [
            'name' => '색상',
            'create' => '색상 생성',
        ],
        'amenity' => [
            'name' => '편의시설',
            'create' => '편의시설 생성',
        ],
    ],
    'tax' => [
        'name' => '세금',
        'create' => '세금 생성',
        'forms' => [
            'name' => '이름',
            'name_placeholder' => '이름 입력',
            'percentage' => '퍼센트',
            'percentage_placeholder' => '퍼센트',
            'percent_placeholder' => '퍼센트',
            'priority' => '우선순위',
            'priority_placeholder' => '우선순위',
        ],
    ],
    'review' => [
        'name' => '리뷰',
        'create' => '리뷰 생성',
        'edit' => '리뷰 편집',
        'vendor' => [
            'title' => '고객 리뷰',
            'description' => '차량에 대한 모든 고객 리뷰 관리',
            'no_reviews' => '아직 리뷰가 없습니다',
            'filter_by_car' => '차량별 필터',
            'filter_by_rating' => '평점별 필터',
            'filter_by_date' => '날짜별 필터',
            'all_cars' => '모든 차량',
            'all_ratings' => '모든 평점',
            'manage_reviews' => '리뷰 관리',
            'view_all' => '모든 리뷰 보기',
            'delete_review_confirmation' => '이 리뷰를 삭제하시겠습니까?',
            'delete_review_success' => '리뷰가 성공적으로 삭제되었습니다',
            'cannot_delete' => '이 리뷰를 삭제할 수 없습니다',
        ],
        'forms' => [
            'customer' => '고객',
            'car' => '차량',
            'content' => '내용',
            'rating' => '평점',
            'your_name' => '이름',
            'email_address' => '이메일 주소',
            'submit' => '제출',
            'star' => '별',
            'status' => '상태',
            'created_at' => '생성일',
            'select_car' => '차량 선택',
            'select_rating' => '평점 선택',
            'comment' => '댓글',
            'reply' => '답글',
            'reply_to_review' => '리뷰에 답글',
            'save_reply' => '답글 저장',
            'cancel_reply' => '취소',
        ],
        'statuses' => [
            'published' => '게시됨',
            'pending' => '대기 중',
            'rejected' => '거부됨',
        ],
        'ratings' => [
            '1' => '별 1개 - 나쁨',
            '2' => '별 2개 - 보통',
            '3' => '별 3개 - 좋음',
            '4' => '별 4개 - 매우 좋음',
            '5' => '별 5개 - 우수',
        ],
    ],
    'coupon' => [
        'name' => '쿠폰',
        'create' => '쿠폰 생성',
        'types' => [
            'percentage' => '퍼센트 %',
            'money' => '금액',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => '서비스',
        'create' => '서비스 생성',
        'forms' => [
            'name' => '이름',
            'content' => '내용',
            'price' => '가격',
            'currency' => '통화',
            'image' => '이미지',
            'logo' => '로고',
            'status' => '상태',
        ],
    ],
    'availability_calendar' => [
        'name' => '가용성 캘린더',
        'title' => '가용성 캘린더',
        'description' => '캘린더 형식으로 차량 가용성 및 예약 보기',
        'select_dates' => '가용성을 확인할 날짜 선택',
        'car_filter' => '차량별 필터',
        'all_cars' => '모든 차량',
        'clear_filter' => '필터 지우기',
        'availability_check' => '차량 가용성 확인',
        'selected_period' => '선택 기간',
        'checking_availability' => '가용성 확인 중...',
        'available' => '이용 가능',
        'not_available' => '이용 불가',
        'booking_details' => '예약 세부정보',
        'how_to_use' => '차량 가용성 캘린더 사용 방법',
        'viewing_bookings' => '예약 보기',
        'checking_availability_help' => '가용성 확인',
        'color_legend' => '색상 범례',
        'pending_bookings' => '대기 중인 예약',
        'processing_bookings' => '처리 중인 예약',
        'completed_bookings' => '완료된 예약',
        'cancelled_bookings' => '취소된 예약',
        'unknown_make' => '알 수 없는 제조사',
        'loading' => '로드 중...',
        'loading_calendar_data' => '캘린더 데이터 로드 중...',
        'loading_booking_details' => '예약 세부정보 로드 중...',
        'please_wait_booking_info' => '예약 정보를 가져오는 동안 기다려 주세요.',
        'please_wait_availability' => '선택한 날짜의 차량 가용성을 확인하는 동안 기다려 주세요.',
        'error' => '오류',
        'error_loading_booking' => '예약 세부정보를 로드하지 못했습니다. 다시 시도하세요.',
        'error_checking_availability' => '차량 가용성 확인 오류',
        'customer' => '고객',
        'status' => '상태',
        'amount' => '금액',
        'make' => '제조사',
        'vendor' => '판매자',
        'per_day' => '/일',
        'edit_car' => '차량 편집',
        'no_cars_found' => '차량을 찾을 수 없습니다',
        'no_cars_available_period' => '선택한 기간에 이용 가능한 차량이 없습니다.',
        'close' => '닫기',
        'edit_booking' => '예약 편집',
        'pending' => '대기 중',
        'processing' => '처리 중',
        'completed' => '완료',
        'cancelled' => '취소됨',
    ],
    'theme_options' => [
        'name' => '렌터카',
        'description' => '렌터카 테마 옵션',
        'car_location_filter_by' => '차량 위치 필터 기준',
        'state' => '시/도',
        'city' => '도시',
        'yes' => '예',
        'no' => '아니오',
        'is_display_country' => '위치 필터에 국가 표시?',
        'logo_vendor_dashboard' => '판매자 대시보드의 로고 (기본값은 메인 로고)',
        'number_of_cars_per_page' => '페이지당 차량 수',
        'number_of_cars_per_page_placeholder' => '페이지당 표시할 차량 수 입력',
    ],
    'message' => [
        'name' => '메시지',
        'forms' => [
            'customer_name' => '고객 이름',
            'message' => '메시지',
            'phone' => '전화',
            'email' => '이메일',
            'created_at' => '생성일',
            'status' => '상태',
        ],
    ],
    'car_sale' => [
        'name' => '차량 판매',
        'create' => '새 차량 판매',
        'edit' => '차량 판매 편집 :name',
        'statuses' => [
            'pending' => '대기 중',
            'processing' => '처리 중',
            'completed' => '완료',
            'cancelled' => '취소됨',
        ],
        'forms' => [
            'transaction_id' => '거래 ID',
            'transaction_id_placeholder' => '거래 ID 입력',
            'car_id' => '차량',
            'car' => '차량',
            'customer_id' => '고객',
            'customer_name' => '고객 이름',
            'customer_name_placeholder' => '고객 이름 입력',
            'customer_email' => '고객 이메일',
            'customer_email_placeholder' => '고객 이메일 입력',
            'customer_phone' => '고객 전화',
            'customer_phone_placeholder' => '고객 전화 입력',
            'sale_price' => '판매 가격',
            'sale_price_placeholder' => '판매 가격 입력',
            'tax_amount' => '세액',
            'tax_amount_placeholder' => '세액 입력',
            'total_amount' => '총 금액',
            'total_amount_placeholder' => '총 금액 입력',
            'payment_details' => '결제 세부정보',
            'payment_details_placeholder' => '결제 세부정보 입력',
            'notes' => '비고',
            'notes_placeholder' => '비고 입력',
            'sale_date' => '판매일',
            'delivery_date' => '배송일',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => '은행 송금',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => '렌터카 예약 확인',
        'booking_confirm_greeting' => ':customer_name 고객님',
        'booking_confirm_message' => '렌터카 예약이 성공적으로 확인되었음을 알려드립니다!',
        'customer_information' => '고객 정보',
        'booking_information' => '예약 정보',
        'field_name' => '이름:',
        'field_phone' => '전화:',
        'field_email' => '이메일:',
        'field_car_model' => '차량 모델:',
        'field_start_date' => '시작일:',
        'field_end_date' => '종료일:',
        'field_pickup_address' => '픽업 주소:',
        'field_return_address' => '반납 주소:',
        'field_note' => '비고:',
        'field_order_number' => '주문 번호',
        'field_payment_method' => '결제 방법',

        // Booking notice to admin email
        'booking_notice_admin_title' => '새 예약 알림',
        'booking_notice_admin_greeting' => '안녕하세요, :site_title에서 새 예약이 있습니다:',
        'booking_notice_admin_message' => '새 렌터카 예약이 제출되어 주의가 필요합니다.',
        'booking_view_detail' => '예약 세부정보 보기:',
        'view_booking_details' => '예약 세부정보 보기',
        
        // Booking notice to vendor email
        'booking_notice_vendor_title' => '차량에 대한 새 예약',
        'booking_notice_vendor_greeting' => ':vendor_name 판매자님',
        'booking_notice_vendor_message' => '좋은 소식입니다! 렌터카에 대한 새 예약을 받았습니다.',

        // Booking status changed email
        'booking_status_updated' => '예약 상태가 업데이트되었습니다',
        'hello_thanks_for_booking' => '안녕하세요, :site_title에서 예약해 주셔서 감사합니다:',
        'booking_status_change_message' => '이 메시지가 잘 전달되기를 바랍니다. 예약 상태가 업데이트되었음을 알려드립니다.',
        'name' => '이름',
        'phone' => '전화',
        'email' => '이메일',
        'car_model' => '차량 모델',
        'start_date' => '시작일',
        'end_date' => '종료일',
        'pickup_address' => '픽업 주소',
        'return_address' => '반납 주소',
        'note' => '비고',
        'order_number' => '주문 번호',
        'payment_method' => '결제 방법',

        // Car approved email
        'hello' => '안녕하세요',
        'car_approved_title' => '좋은 소식! 차량이 승인되었습니다',
        'car_approved_message' => '차량 목록 ":car_name"이(가) 승인되어 :site_title에 게시되었음을 알려드립니다. 즉시 예약을 받고 목록을 관리할 수 있습니다.',
        'view_edit_car_link' => '차량 목록을 보거나 편집하려면 이 링크를 클릭하세요',
        'view_car' => '차량 목록 보기',
        'regards' => '감사합니다',

        // Vendor upgrade email
        'vendor_upgrade_title' => '축하합니다! 이제 판매자입니다',
        'vendor_upgrade_congratulations' => '계정이 판매자 상태로 성공적으로 업그레이드되었음을 알려드립니다!',
        'vendor_upgrade_message' => '이제 :site_title에서 자신의 차량을 등록하고 관리할 수 있습니다. 이를 통해 당사와 함께 대여 사업을 성장시킬 수 있는 새로운 기회가 열립니다.',
        'vendor_benefits_title' => '새로운 판매자 혜택',
        'vendor_benefit_1' => '대여용 무제한 차량 등록',
        'vendor_benefit_2' => '자신의 예약 및 고객 관리',
        'vendor_benefit_3' => '수익 및 성과 지표 추적',
        'vendor_benefit_4' => '판매자 전용 기능 및 도구 액세스',
        'next_steps' => '다음 단계',
        'vendor_next_steps_message' => '판매자 대시보드에 로그인하여 차량 추가 및 대여 사업 관리를 시작하세요.',
        'go_to_dashboard' => '판매자 대시보드로 이동',
        'vendor_support_message' => '질문이 있거나 도움이 필요하면 지원 팀이 시작을 도와드립니다.',
        'approved' => '승인됨',

        // Car rejected email
        'car_rejected_title' => '차량 목록 업데이트 필요',
        'car_rejected_message' => '차량 목록 ":car_name"을(를) :site_title에 제출해 주셔서 감사합니다. 제출 내용을 검토한 결과 승인하기 전에 몇 가지 조정이 필요합니다.',
        'rejection_reason' => '업데이트가 필요한 내용',
        'rejection_details' => '필요한 업데이트',
        'contact_support' => '이러한 업데이트에 대해 질문이 있거나 도움이 필요하면 :site_email의 지원 팀에 문의하세요. 목록의 신속한 승인을 위해 도와드리겠습니다.',

        // Confirm email
        'verify_email' => '이메일 확인',
        'welcome_message' => '환영합니다, :customer_name 님!',
        'verify_email_instruction' => '이 웹사이트에 액세스하려면 이메일 주소를 확인하세요. 아래 버튼을 클릭하여 이메일을 확인하세요.',
        'confirm_email_button' => '이메일 주소 확인',
        'verify_link_trouble' => '"이메일 주소 확인" 버튼 클릭에 문제가 있는 경우 아래 URL을 복사하여 웹 브라우저에 붙여넣으세요: :verify_link 그리고 브라우저에 붙여넣으세요.',

        // Message email
        'new_message' => '새 메시지',
        'dear_admin' => '관리자님',
        'new_message_from' => ':site_title에서 새 메시지가 있습니다:',
        'subject' => '제목',
        'address' => '주소',
        'content' => '내용',

        // New pending car email
        'hi_admin' => '안녕하세요 관리자님',
        'new_car_pending_title' => '검토 대기 중인 새 차량 목록',
        'new_car_pending_approval' => ':post_author이(가) 새 차량 목록 ":post_name"을(를) 제출했으며 검토 준비가 되었습니다.',
        'pending_approval' => '검토 대기 중',
        'review_car_admin' => '관리 패널에서 이 목록을 검토하고 승인하거나 업데이트를 요청하세요.',

        // Common fields
        'car_information' => '차량 정보',
        'field_car_name' => '차량 이름:',
        'field_author' => '작성자:',
        'field_status' => '상태:',
        'actions' => '작업',

        // Password reminder email
        'reset_password_instruction' => '비밀번호 재설정 지침',
        'password_reset_request' => '계정에 대한 비밀번호 재설정 요청을 받았기 때문에 이 이메일을 받고 있습니다.',
        'reset_password_button' => '비밀번호 재설정',
        'reset_link_trouble' => '"비밀번호 재설정" 버튼 클릭에 문제가 있는 경우 아래 URL을 복사하여 웹 브라우저에 붙여넣으세요: :reset_link 그리고 브라우저에 붙여넣으세요. 비밀번호 재설정을 요청하지 않았다면 이 메시지를 무시하거나 질문이 있으면 문의하세요.',
    ],
];
