<?php

/**
 * Translation: MS
 * This file uses English as base.
 * For production use, professional translation is recommended.
 */

return [
    'name' => 'Sewa Kereta',
    'customer' => [
        'name' => 'Pelanggan',
        'create' => 'Cipta Pelanggan',
        'view' => 'Lihat',
        'information' => 'Maklumat Pelanggan',
        'email' => 'E-mel',
        'phone' => 'Telefon',
        'status' => 'Status',
        'vendor_status' => 'Status Vendor',
        'is_vendor' => 'Vendor',
        'not_vendor' => 'Pelanggan',
        'recent_activity' => 'Aktiviti Terkini',
        'recent_activity_description' => 'Aktiviti pelanggan akan dipaparkan di sini.',
        'verification_section' => 'Pengesahan Pelanggan',
        'verified' => 'Disahkan',
        'not_verified' => 'Tidak Disahkan',
        'verified_by' => 'Disahkan Oleh',
        'verified_at' => 'Disahkan Pada',
        'verify_customer' => 'Sahkan Pelanggan',
        'unverify_customer' => 'Nyahsah Pelanggan',
        'verify_customer_confirmation' => 'Pengesahan Sahkan Pelanggan',
        'verify_customer_confirmation_desc' => 'Adakah anda pasti mahu mengesahkan :name? Ini akan memaparkan lencana disahkan pada profil mereka.',
        'unverify_customer_confirmation' => 'Pengesahan Nyahsah Pelanggan',
        'unverify_customer_confirmation_desc' => 'Adakah anda pasti mahu mengeluarkan pengesahan daripada :name? Lencana disahkan akan dikeluarkan.',
        'verify_success' => 'Pelanggan :name telah berjaya disahkan.',
        'unverify_success' => 'Pengesahan pelanggan :name telah berjaya dikeluarkan.',
        'already_verified' => 'Pelanggan ini telah pun disahkan.',
        'already_unverified' => 'Pelanggan ini belum disahkan.',
        'upgrade_to_vendor_title' => 'Naik Taraf kepada Vendor',
        'upgrade_to_vendor_description' => 'Naik taraf pelanggan ini kepada status vendor untuk membenarkan mereka menyenarai dan menguruskan sewa kereta mereka sendiri.',
        'upgrade_to_vendor_button' => 'Naik Taraf kepada Vendor',
        'upgrade_to_vendor_confirmation' => 'Sahkan Naik Taraf kepada Vendor',
        'upgrade_to_vendor_confirmation_desc' => 'Adakah anda pasti mahu menaik taraf :name kepada status vendor? Ini akan membenarkan mereka menyenarai dan menguruskan kereta mereka sendiri di platform.',
        'upgrade_to_vendor_success' => ':name telah berjaya dinaik taraf kepada status vendor.',
        'already_vendor' => 'Pelanggan ini sudah menjadi vendor.',
        'customer_verified_successfully' => 'Pelanggan ini telah disahkan dan boleh dipercayai.',
        'customer_not_verified_yet' => 'Pelanggan ini belum lagi disahkan.',
        'verification_pending' => 'Pengesahan Belum Selesai',
        'click_verify_to_approve' => 'Klik butang di bawah untuk mengesahkan pelanggan ini dan memaparkan lencana disahkan.',
        'verification_note' => 'Nota Pengesahan',
        'verification_note_placeholder' => 'Masukkan sebarang nota tentang tindakan pengesahan ini...',
        'verification_note_helper' => 'Tambah nota tentang proses pengesahan (kegunaan dalaman sahaja)',
        'forms' => [
            'name' => 'Nama',
            'email' => 'E-mel',
            'phone' => 'Telefon',
            'avatar' => 'Avatar',
            'dob' => 'Tarikh Lahir',
            'company' => 'Syarikat',
            'position' => 'Jawatan',
            'password' => 'Kata Laluan',
            'password_confirmation' => 'Pengesahan Kata Laluan',
            'change_password' => 'Tukar kata laluan?',
            'phone_placeholder' => 'Telefon',
        ],
    ],
    'vendor' => [
        'name' => 'Vendor',
        'view' => 'Lihat :name',
        'information' => 'Maklumat Vendor',
        'total_cars' => 'Jumlah Kereta',
        'total_bookings' => 'Jumlah Tempahan',
        'verified' => 'Disahkan',
        'not_verified' => 'Tidak Disahkan',
        'verification_section' => 'Pengesahan Vendor',
        'vendor_verified_successfully' => 'Vendor ini telah disahkan dan boleh dipercayai.',
        'vendor_not_verified_yet' => 'Vendor ini belum lagi disahkan.',
        'verification_pending' => 'Pengesahan Belum Selesai',
        'click_verify_to_approve' => 'Klik butang di bawah untuk mengesahkan vendor ini dan memaparkan lencana disahkan.',
        'verify_vendor' => 'Sahkan Vendor',
        'unverify_vendor' => 'Nyahsah Vendor',
        'verify_vendor_confirmation' => 'Pengesahan Sahkan Vendor',
        'verify_vendor_confirmation_desc' => 'Adakah anda pasti mahu mengesahkan :name? Ini akan memaparkan lencana disahkan pada profil mereka.',
        'unverify_vendor_confirmation' => 'Pengesahan Nyahsah Vendor',
        'unverify_vendor_confirmation_desc' => 'Adakah anda pasti mahu mengeluarkan pengesahan daripada :name? Lencana disahkan akan dikeluarkan.',
        'verified_successfully' => 'Vendor telah berjaya disahkan.',
        'unverified_successfully' => 'Pengesahan vendor telah berjaya dikeluarkan.',
        'already_verified' => 'Vendor ini telah pun disahkan.',
        'not_verified_yet' => 'Vendor ini belum disahkan.',
        'recent_activity' => 'Aktiviti Terkini',
        'recent_cars' => 'Kereta Terkini',
        'recent_bookings' => 'Tempahan Terkini',
        'no_cars_yet' => 'Tiada kereta ditambah lagi.',
        'no_bookings_yet' => 'Tiada tempahan diterima lagi.',
    ],
    'make' => [
        'name' => 'Jenama',
        'create' => 'Cipta Jenama Kereta',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Logo Gelap',
        ],
    ],
    'car' => [
        'name' => 'Kereta',
        'create' => 'Cipta Kereta',
        'forms' => [
            'car' => 'Kereta',
            'logo' => 'Logo',
            'license_plate' => 'Plat Nombor',
            'make' => 'Jenama',
            'model' => 'Model',
            'name' => 'Nama',
            'images' => 'Gambar',
            'year' => 'Tahun',
            'color' => 'Warna',
            'mileage' => 'Perbatuan',
            'kilometers' => 'Kilometer',
            'horsepower' => 'Kuasa Kuda',
            'vehicle_type' => 'Jenis Kenderaan',
            'transmission' => 'Transmisi',
            'fuel_type' => 'Jenis Bahan Api',
            'rental_rate' => 'Kadar Sewa',
            'currency' => 'Mata Wang',
            'status' => 'Status',
            'availability' => 'Ketersediaan',
            'insurance_info' => 'Maklumat insurans',
            'number_of_seats' => 'Bilangan Tempat Duduk',
            'number_of_doors' => 'Bilangan Pintu',
            'vin' => 'VIN',
            'maintenance_history' => 'Sejarah Penyelenggaraan',
            'location' => 'Lokasi',
            'description' => 'Penerangan',
            'rental_type' => 'Jenis Sewa',
            'tags' => 'Tag',
            'add_new_attribute' => 'Tambah baharu <a href=":url" target="_blank">di sini</a>.',
            'categories' => 'Kategori',
            'pick_address' => 'Alamat Pengambilan',
            'return_address' => 'Alamat Pemulangan',
            'same_drop_off' => 'Lokasi Pemulangan Sama',
            'tax' => 'Cukai',
            'select_tax' => 'Pilih Cukai',
            'none' => 'Tiada',
            'colors' => 'Warna',
            'amenities' => 'Kemudahan',
            'is_used' => 'Terpakai?',
            'moderation_status' => 'Status moderasi',
            'status_moderation' => [
                'approve' => 'Lulus',
                'reject' => 'Tolak',
                'approve_title' => 'Luluskan kereta',
                'approve_message' => 'Adakah anda pasti mahu meluluskan kereta ini? Tindakan ini tidak boleh dibatalkan.',
                'reject_title' => 'Tolak kereta',
                'reject_message' => 'Adakah anda pasti mahu menolak kereta ini? Tindakan ini tidak boleh dibatalkan.',
                'reject_reason' => 'Masukkan sebab penolakan',
                'approved' => 'Kereta telah berjaya diluluskan!',
                'rejected' => 'Kereta telah berjaya ditolak!',
                'reason_rejected' => 'Sebab ditolak',
            ],
            'customer' => 'Pelanggan',
            'select_customer' => 'Pilih pelanggan...',
            'vendor_images' => 'Gambar (Maksimum :max gambar)',
            'images_upload_placeholder' => 'Lepaskan fail di sini atau klik untuk muat naik.',
            'car_purpose' => 'Tujuan Kereta',
            'for_rent' => 'Untuk Disewa',
            'for_sale' => 'Untuk Dijual',
            'car_type' => 'Jenis Kereta',
            'rental_information' => 'Maklumat Sewaan',
            'sale_statuses' => [
                'available' => 'Tersedia',
                'sold' => 'Terjual',
                'reserved' => 'Ditempah',
            ],
            'selling_information' => 'Maklumat Jualan',
            'is_for_sale' => 'Tersedia untuk dijual',
            'sale_price' => 'Harga Jualan',
            'sale_price_placeholder' => 'Masukkan harga jualan',
            'condition' => 'Keadaan',
            'select_condition' => 'Pilih Keadaan',
            'condition_options' => [
                'new' => 'Baharu',
                'like_new' => 'Seperti Baharu',
                'excellent' => 'Cemerlang',
                'good' => 'Baik',
                'fair' => 'Sederhana',
                'poor' => 'Kurang Baik',
            ],
            'ownership_history' => 'Sejarah Pemilikan',
            'ownership_history_placeholder' => 'Masukkan sejarah pemilikan',
            'warranty_information' => 'Maklumat Waranti',
            'warranty_information_placeholder' => 'Masukkan maklumat waranti',
            'sale_status' => 'Status Jualan',
            'external_booking_url' => 'Pautan Tempahan Luar Tapak',
            'external_booking_url_helper' => 'Masukkan URL luaran di mana pelanggan boleh menempah kereta ini di luar platform ini. Biarkan kosong jika tempahan hanya tersedia di laman ini.',
            'address' => 'Alamat',
            'address_helper' => 'Masukkan alamat jalan khusus di mana kenderaan ini terletak',
        ],
        'car_purposes' => [
            'sale' => 'Untuk Dijual',
            'rent' => 'Untuk Disewa',
        ],
        'placeholders' => [
            'name' => 'Masukkan nama kenderaan (cth., Toyota Camry 2023, Honda CR-V, dll.)',
            'description' => 'Masukkan penerangan ringkas kenderaan yang menonjolkan ciri utama',
            'rental_rate' => 'Masukkan kadar sewa berdasarkan jenis sewa yang dipilih',
            'location' => 'Masukkan lokasi fizikal kenderaan',
            'address' => 'Masukkan alamat jalan khusus (cth., 123 Main St, City, State)',
            'sale_price' => 'Masukkan harga jualan untuk kenderaan ini',
            'ownership_history' => 'Masukkan butiran tentang pemilik terdahulu, bilangan pemilik, dll.',
            'warranty_information' => 'Masukkan butiran tentang perlindungan waranti, tarikh tamat tempoh, dll.',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Masukkan nombor plat kenderaan',
            'vin' => 'Masukkan Nombor Pengenalan Kenderaan (VIN)',
            'year' => 'Masukkan tahun pembuatan (cth., 2023)',
            'mileage' => 'Masukkan perbatuan semasa',
            'kilometers' => 'Masukkan kilometer semasa',
            'horsepower' => 'Masukkan kuasa kuda (HP) kenderaan (cth., 150.5)',
            'number_of_seats' => 'Masukkan bilangan tempat duduk dalam kenderaan',
            'number_of_doors' => 'Masukkan bilangan pintu yang ada pada kenderaan',
            'insurance_info' => 'Masukkan maklumat insurans yang berkaitan untuk kenderaan ini',
            'tags' => 'Pilih atau cipta tag',
            'amenities' => 'Pilih kemudahan',
            'colors' => 'Pilih atau cipta warna',
        ],
        'enums' => [
            'vendor_status' => 'Status Vendor',
            'is_vendor' => 'Vendor',
            'not_vendor' => 'Pelanggan',
            'statuses' => [
                'available' => 'Tersedia',
                'rented' => 'Disewa',
                'maintenance' => 'Penyelenggaraan',
                'out_of_service' => 'Tidak Beroperasi',
            ],
            'rental_types' => [
                'per_hour' => 'Setiap jam',
                'per_day' => 'Setiap hari',
                'per_week' => 'Setiap minggu',
                'per_month' => 'Setiap bulan',
            ],
            'moderation_statuses' => [
                'pending' => 'Menunggu',
                'approved' => 'Diluluskan',
                'rejected' => 'Ditolak',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Sejarah Penyelenggaraan',
            'create' => 'Cipta Sejarah Servis',
            'amount' => 'Jumlah',
            'forms' => [
                'price_placeholder' => 'Harga servis',
                'currency' => 'Mata Wang',
                'none' => 'Tiada',
                'name' => 'Nama',
                'amount' => 'Jumlah',
                'created_at' => 'Dicipta Pada',
                'action' => 'Tindakan',
                'date' => 'Tarikh',
                'no_maintenance_history' => 'Tiada sejarah penyelenggaraan',
                'edit_maintenance_history' => 'Edit sejarah penyelenggaraan',
                'add_maintenance_history' => 'Tambah sejarah penyelenggaraan',
                'add' => 'Tambah',
                'edit' => 'Edit',
                'delete' => 'Padam',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atribut Kereta',
        'car_type' => [
            'name' => 'Jenis',
            'create' => 'Cipta Jenis Kereta',
            'forms' => [
                'name' => 'Nama',
            ],
        ],
        'transmission' => [
            'name' => 'Transmisi',
            'create' => 'Cipta Transmisi',
            'forms' => [
                'name' => 'Nama',
            ],
        ],
        'fuel_type' => [
            'name' => 'Bahan Api',
            'create' => 'Cipta Jenis Bahan Api',
            'forms' => [
                'name' => 'Nama',
            ],
        ],
        'tag' => [
            'name' => 'Tag',
            'create' => 'Cipta Tag',
        ],
        'category' => [
            'name' => 'Kategori',
            'create' => 'Cipta Kategori',
            'forms' => [
                'none' => 'Tiada',
                'total_cars' => 'Jumlah kereta: :total',
            ],
        ],
        'address' => [
            'name' => 'Lokasi',
            'create' => 'Cipta Lokasi Kereta',
            'form' => [
                'name' => 'Alamat',
                'full_address' => 'Alamat Penuh',
                'detail_address' => 'Alamat Terperinci',
            ],
        ],
        'color' => [
            'name' => 'Warna',
            'create' => 'Cipta Warna',
        ],
        'amenity' => [
            'name' => 'Kemudahan',
            'create' => 'Cipta Kemudahan',
        ],
    ],
    'tax' => [
        'name' => 'Cukai',
        'create' => 'Cipta Cukai',
        'forms' => [
            'name' => 'Nama',
            'name_placeholder' => 'Masukkan nama',
            'percentage' => 'Peratusan',
            'percentage_placeholder' => 'Peratusan',
            'percent_placeholder' => 'Peratusan',
            'priority' => 'Keutamaan',
            'priority_placeholder' => 'Keutamaan',
        ],
    ],
    'review' => [
        'name' => 'Ulasan',
        'create' => 'Cipta Ulasan',
        'edit' => 'Edit Ulasan',
        'vendor' => [
            'title' => 'Ulasan Pelanggan',
            'description' => 'Uruskan semua ulasan pelanggan untuk kereta anda',
            'no_reviews' => 'Anda belum mempunyai ulasan',
            'filter_by_car' => 'Tapis mengikut kereta',
            'filter_by_rating' => 'Tapis mengikut penarafan',
            'filter_by_date' => 'Tapis mengikut tarikh',
            'all_cars' => 'Semua Kereta',
            'all_ratings' => 'Semua Penarafan',
            'manage_reviews' => 'Urus Ulasan',
            'view_all' => 'Lihat Semua Ulasan',
            'delete_review_confirmation' => 'Adakah anda pasti mahu memadam ulasan ini?',
            'delete_review_success' => 'Ulasan berjaya dipadam',
            'cannot_delete' => 'Tidak dapat memadam ulasan ini',
        ],
        'forms' => [
            'customer' => 'Pelanggan',
            'car' => 'Kereta',
            'content' => 'Kandungan',
            'rating' => 'Penarafan',
            'your_name' => 'Nama Anda',
            'email_address' => 'Alamat E-mel',
            'submit' => 'Hantar',
            'star' => 'Bintang',
            'status' => 'Status',
            'created_at' => 'Dicipta Pada',
            'select_car' => 'Pilih Kereta',
            'select_rating' => 'Pilih Penarafan',
            'comment' => 'Komen',
            'reply' => 'Balas',
            'reply_to_review' => 'Balas kepada Ulasan',
            'save_reply' => 'Simpan Balasan',
            'cancel_reply' => 'Batal',
        ],
        'statuses' => [
            'published' => 'Diterbitkan',
            'pending' => 'Menunggu',
            'rejected' => 'Ditolak',
        ],
        'ratings' => [
            '1' => '1 Bintang - Lemah',
            '2' => '2 Bintang - Sederhana',
            '3' => '3 Bintang - Baik',
            '4' => '4 Bintang - Sangat Baik',
            '5' => '5 Bintang - Cemerlang',
        ],
    ],
    'coupon' => [
        'name' => 'Kupon',
        'create' => 'Cipta Kupon',
        'types' => [
            'percentage' => 'Peratusan %',
            'money' => 'Wang',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Perkhidmatan',
        'create' => 'Cipta Perkhidmatan',
        'forms' => [
            'name' => 'Nama',
            'content' => 'Kandungan',
            'price' => 'Harga',
            'currency' => 'Mata Wang',
            'image' => 'Gambar',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Kalendar Ketersediaan',
        'title' => 'Kalendar Ketersediaan',
        'description' => 'Lihat ketersediaan kereta dan tempahan dalam format kalendar',
        'select_dates' => 'Pilih tarikh untuk menyemak ketersediaan',
        'car_filter' => 'Tapis mengikut Kereta',
        'all_cars' => 'Semua Kereta',
        'clear_filter' => 'Kosongkan Penapis',
        'availability_check' => 'Semakan Ketersediaan Kereta',
        'selected_period' => 'Tempoh Dipilih',
        'checking_availability' => 'Menyemak ketersediaan...',
        'available' => 'Tersedia',
        'not_available' => 'Tidak Tersedia',
        'booking_details' => 'Butiran Tempahan',
        'how_to_use' => 'Cara Menggunakan Kalendar Ketersediaan Kereta',
        'viewing_bookings' => 'Melihat Tempahan',
        'checking_availability_help' => 'Menyemak Ketersediaan',
        'color_legend' => 'Legenda Warna',
        'pending_bookings' => 'Tempahan Menunggu',
        'processing_bookings' => 'Tempahan Diproses',
        'completed_bookings' => 'Tempahan Selesai',
        'cancelled_bookings' => 'Tempahan Dibatal',
        'unknown_make' => 'Jenama Tidak Diketahui',
        'loading' => 'Memuatkan...',
        'loading_calendar_data' => 'Memuatkan data kalendar...',
        'loading_booking_details' => 'Memuatkan butiran tempahan...',
        'please_wait_booking_info' => 'Sila tunggu sementara kami mendapatkan maklumat tempahan.',
        'please_wait_availability' => 'Sila tunggu sementara kami menyemak ketersediaan kereta untuk tarikh yang anda pilih.',
        'error' => 'Ralat',
        'error_loading_booking' => 'Gagal memuatkan butiran tempahan. Sila cuba lagi.',
        'error_checking_availability' => 'Ralat menyemak ketersediaan kereta',
        'customer' => 'Pelanggan',
        'status' => 'Status',
        'amount' => 'Jumlah',
        'make' => 'Jenama',
        'vendor' => 'Vendor',
        'per_day' => '/hari',
        'edit_car' => 'Edit Kereta',
        'no_cars_found' => 'Tiada kereta dijumpai',
        'no_cars_available_period' => 'Tiada kereta tersedia untuk tempoh yang dipilih.',
        'close' => 'Tutup',
        'edit_booking' => 'Edit Tempahan',
        'pending' => 'Menunggu',
        'processing' => 'Diproses',
        'completed' => 'Selesai',
        'cancelled' => 'Dibatal',
    ],
    'theme_options' => [
        'name' => 'Sewa Kereta',
        'description' => 'Pilihan tema untuk sewa kereta',
        'car_location_filter_by' => 'Penapis lokasi kereta mengikut',
        'state' => 'Negeri',
        'city' => 'Bandar',
        'yes' => 'Ya',
        'no' => 'Tidak',
        'is_display_country' => 'Paparkan negara pada penapis lokasi?',
        'logo_vendor_dashboard' => 'Logo dalam papan pemuka vendor (Lalai adalah logo utama)',
        'number_of_cars_per_page' => 'Bilangan kereta setiap halaman',
        'number_of_cars_per_page_placeholder' => 'Masukkan bilangan kereta untuk dipaparkan setiap halaman',
    ],
    'message' => [
        'name' => 'Mesej',
        'forms' => [
            'customer_name' => 'Nama pelanggan',
            'message' => 'Mesej',
            'phone' => 'Telefon',
            'email' => 'E-mel',
            'created_at' => 'Dicipta pada',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Jualan Kereta',
        'create' => 'Jualan Kereta Baharu',
        'edit' => 'Edit Jualan Kereta :name',
        'statuses' => [
            'pending' => 'Menunggu',
            'processing' => 'Diproses',
            'completed' => 'Selesai',
            'cancelled' => 'Dibatal',
        ],
        'forms' => [
            'transaction_id' => 'ID Transaksi',
            'transaction_id_placeholder' => 'Masukkan ID transaksi',
            'car_id' => 'Kereta',
            'car' => 'Kereta',
            'customer_id' => 'Pelanggan',
            'customer_name' => 'Nama Pelanggan',
            'customer_name_placeholder' => 'Masukkan nama pelanggan',
            'customer_email' => 'E-mel Pelanggan',
            'customer_email_placeholder' => 'Masukkan e-mel pelanggan',
            'customer_phone' => 'Telefon Pelanggan',
            'customer_phone_placeholder' => 'Masukkan telefon pelanggan',
            'sale_price' => 'Harga Jualan',
            'sale_price_placeholder' => 'Masukkan harga jualan',
            'tax_amount' => 'Jumlah Cukai',
            'tax_amount_placeholder' => 'Masukkan jumlah cukai',
            'total_amount' => 'Jumlah Keseluruhan',
            'total_amount_placeholder' => 'Masukkan jumlah keseluruhan',
            'payment_details' => 'Butiran Pembayaran',
            'payment_details_placeholder' => 'Masukkan butiran pembayaran',
            'notes' => 'Nota',
            'notes_placeholder' => 'Masukkan nota',
            'sale_date' => 'Tarikh Jualan',
            'delivery_date' => 'Tarikh Penghantaran',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Pindahan Bank',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Pengesahan Tempahan Sewa Kereta',
        'booking_confirm_greeting' => 'Yang Berhormat :customer_name,',
        'booking_confirm_message' => 'Kami dengan sukacitanya memaklumkan bahawa tempahan sewa kereta anda telah berjaya disahkan!',
        'customer_information' => 'Maklumat Pelanggan',
        'booking_information' => 'Maklumat Tempahan',
        'field_name' => 'Nama:',
        'field_phone' => 'Telefon:',
        'field_email' => 'E-mel:',
        'field_car_model' => 'Model Kereta:',
        'field_start_date' => 'Tarikh Mula:',
        'field_end_date' => 'Tarikh Tamat:',
        'field_pickup_address' => 'Alamat Pengambilan:',
        'field_return_address' => 'Alamat Pemulangan:',
        'field_note' => 'Nota:',
        'field_order_number' => 'Nombor pesanan',
        'field_payment_method' => 'Kaedah Pembayaran',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Pemberitahuan Tempahan Baharu',
        'booking_notice_admin_greeting' => 'Helo, terdapat tempahan baharu daripada :site_title:',
        'booking_notice_admin_message' => 'Tempahan sewa kereta baharu telah dihantar dan memerlukan perhatian anda.',
        'booking_view_detail' => 'Lihat butiran tempahan:',
        'view_booking_details' => 'Lihat Butiran Tempahan',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Tempahan Baharu untuk Kereta Anda',
        'booking_notice_vendor_greeting' => 'Yang Berhormat :vendor_name,',
        'booking_notice_vendor_message' => 'Berita gembira! Anda telah menerima tempahan baharu untuk sewa kereta anda.',

        // Booking status changed email
        'booking_status_updated' => 'Status Tempahan Dikemas Kini',
        'hello_thanks_for_booking' => 'Helo, Terima kasih kerana menempah bilik daripada :site_title:',
        'booking_status_change_message' => 'Kami harap mesej ini mendapati anda dalam keadaan sihat. Kami ingin memaklumkan bahawa status tempahan anda telah dikemas kini.',
        'name' => 'Nama',
        'phone' => 'Telefon',
        'email' => 'E-mel',
        'car_model' => 'Model Kereta',
        'start_date' => 'Tarikh Mula',
        'end_date' => 'Tarikh Tamat',
        'pickup_address' => 'Alamat Pengambilan',
        'return_address' => 'Alamat Pemulangan',
        'note' => 'Nota',
        'order_number' => 'Nombor pesanan',
        'payment_method' => 'Kaedah Pembayaran',

        // Car approved email
        'hello' => 'Helo',
        'car_approved_title' => 'Berita Gembira! Kereta Anda Telah Diluluskan',
        'car_approved_message' => 'Kami dengan sukacita memaklumkan bahawa penyenaraian kereta anda ":car_name" telah diluluskan dan kini aktif di :site_title. Anda boleh mula menerima tempahan dan menguruskan penyenaraian anda dengan segera.',
        'view_edit_car_link' => 'Untuk melihat atau mengedit penyenaraian kereta anda, sila klik pada pautan ini',
        'view_car' => 'Lihat Penyenaraian Kereta',
        'regards' => 'Salam sejahtera',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Tahniah! Anda Kini Vendor',
        'vendor_upgrade_congratulations' => 'Kami sangat gembira untuk memaklumkan bahawa akaun anda telah berjaya dinaik taraf kepada status vendor!',
        'vendor_upgrade_message' => 'Anda kini boleh menyenarai dan menguruskan kereta anda sendiri di :site_title. Ini membuka peluang baharu untuk anda mengembangkan perniagaan sewa anda bersama kami.',
        'vendor_benefits_title' => 'Faedah Vendor Baharu Anda',
        'vendor_benefit_1' => 'Senaraikan kereta tanpa had untuk disewa',
        'vendor_benefit_2' => 'Uruskan tempahan dan pelanggan anda sendiri',
        'vendor_benefit_3' => 'Jejaki hasil dan metrik prestasi',
        'vendor_benefit_4' => 'Akses kepada ciri dan alatan eksklusif vendor',
        'next_steps' => 'Langkah Seterusnya',
        'vendor_next_steps_message' => 'Log masuk ke papan pemuka vendor anda untuk mula menambah kereta dan menguruskan perniagaan sewa anda.',
        'go_to_dashboard' => 'Pergi ke Papan Pemuka Vendor',
        'vendor_support_message' => 'Jika anda mempunyai sebarang soalan atau memerlukan bantuan, pasukan sokongan kami sedia membantu anda bermula.',
        'approved' => 'Diluluskan',

        // Car rejected email
        'car_rejected_title' => 'Kemas Kini Diperlukan untuk Penyenaraian Kereta Anda',
        'car_rejected_message' => 'Terima kasih kerana menghantar penyenaraian kereta anda ":car_name" ke :site_title. Selepas menyemak penyerahan anda, kami memerlukan anda membuat beberapa pelarasan sebelum kami boleh meluluskannya.',
        'rejection_reason' => 'Inilah yang perlu dikemas kini',
        'rejection_details' => 'Kemas Kini Diperlukan',
        'contact_support' => 'Jika anda mempunyai sebarang soalan atau memerlukan bantuan dengan kemas kini ini, sila hubungi pasukan sokongan kami di :site_email. Kami di sini untuk membantu anda mendapatkan kelulusan penyenaraian anda dengan cepat.',

        // Confirm email
        'verify_email' => 'Sahkan E-mel',
        'welcome_message' => 'Kami gembira menyambut anda di sini, :customer_name!',
        'verify_email_instruction' => 'Sila sahkan alamat e-mel anda untuk mengakses laman web ini. Klik pada butang di bawah untuk mengesahkan e-mel anda.',
        'confirm_email_button' => 'Sahkan alamat e-mel anda',
        'verify_link_trouble' => 'Jika anda menghadapi masalah mengklik butang \'Sahkan alamat e-mel anda\', salin dan tampal URL di bawah ke dalam pelayar web anda: :verify_link dan tampal ke dalam pelayar anda.',

        // Message email
        'new_message' => 'Mesej Baharu',
        'dear_admin' => 'Yang Berhormat Admin',
        'new_message_from' => 'Terdapat mesej baharu daripada :site_title:',
        'subject' => 'Subjek',
        'address' => 'Alamat',
        'content' => 'Kandungan',

        // New pending car email
        'hi_admin' => 'Helo Admin,',
        'new_car_pending_title' => 'Penyenaraian Kereta Baharu Menunggu Semakan',
        'new_car_pending_approval' => 'Penyenaraian kereta baharu ":post_name" telah dihantar oleh :post_author dan sedia untuk semakan anda.',
        'pending_approval' => 'Menunggu Semakan',
        'review_car_admin' => 'Sila semak penyenaraian ini dalam panel pentadbir dan luluskan atau minta kemas kini seperti yang diperlukan.',

        // Common fields
        'car_information' => 'Maklumat Kereta',
        'field_car_name' => 'Nama Kereta:',
        'field_author' => 'Pengarang:',
        'field_status' => 'Status:',
        'actions' => 'Tindakan',

        // Password reminder email
        'reset_password_instruction' => 'Arahan Tetap Semula Kata Laluan',
        'password_reset_request' => 'Anda menerima e-mel ini kerana kami menerima permintaan tetap semula kata laluan untuk akaun anda.',
        'reset_password_button' => 'Tetap semula kata laluan',
        'reset_link_trouble' => 'Jika anda menghadapi masalah mengklik butang \'Tetap Semula Kata Laluan\', salin dan tampal URL di bawah ke dalam pelayar web anda: :reset_link dan tampal ke dalam pelayar anda. Jika anda tidak meminta tetap semula kata laluan, sila abaikan mesej ini atau hubungi kami jika anda mempunyai sebarang soalan.',
    ],
];
