<?php

return [
    'name' => 'Bilutleie',
    'customer' => [
        'name' => 'Kunder',
        'create' => 'Opprett kunde',
        'view' => 'Vis',
        'information' => 'Kundeinformasjon',
        'email' => 'E-post',
        'phone' => 'Telefon',
        'status' => 'Status',
        'vendor_status' => 'Leverandørstatus',
        'is_vendor' => 'Leverandør',
        'not_vendor' => 'Kunde',
        'recent_activity' => 'Nylig aktivitet',
        'recent_activity_description' => 'Kundeaktivitet vil vises her.',
        'verification_section' => 'Kundeverifisering',
        'verified' => 'Verifisert',
        'not_verified' => 'Ikke verifisert',
        'verified_by' => 'Verifisert av',
        'verified_at' => 'Verifisert',
        'verify_customer' => 'Verifiser kunde',
        'unverify_customer' => 'Fjern verifisering av kunde',
        'verify_customer_confirmation' => 'Bekreft kundeverifisering',
        'verify_customer_confirmation_desc' => 'Er du sikker på at du vil verifisere :name? Dette vil vise et verifiseringmerke på profilen.',
        'unverify_customer_confirmation' => 'Bekreft fjerning av verifisering',
        'unverify_customer_confirmation_desc' => 'Er du sikker på at du vil fjerne verifiseringen fra :name? Verifiseringsmerket vil bli fjernet.',
        'verify_success' => 'Kunde :name har blitt verifisert.',
        'unverify_success' => 'Verifiseringen av kunde :name har blitt fjernet.',
        'already_verified' => 'Denne kunden er allerede verifisert.',
        'already_unverified' => 'Denne kunden er ikke verifisert.',
        'upgrade_to_vendor_title' => 'Oppgrader til leverandør',
        'upgrade_to_vendor_description' => 'Oppgrader denne kunden til leverandørstatus for å tillate dem å liste og administrere sine egne bilutleier.',
        'upgrade_to_vendor_button' => 'Oppgrader til leverandør',
        'upgrade_to_vendor_confirmation' => 'Bekreft oppgradering til leverandør',
        'upgrade_to_vendor_confirmation_desc' => 'Er du sikker på at du vil oppgradere :name til leverandørstatus? Dette vil tillate dem å liste og administrere sine egne biler på plattformen.',
        'upgrade_to_vendor_success' => ':name har blitt oppgradert til leverandørstatus.',
        'already_vendor' => 'Denne kunden er allerede en leverandør.',
        'customer_verified_successfully' => 'Denne kunden har blitt verifisert og kan stoles på.',
        'customer_not_verified_yet' => 'Denne kunden har ikke blitt verifisert ennå.',
        'verification_pending' => 'Verifisering venter',
        'click_verify_to_approve' => 'Klikk på knappen nedenfor for å verifisere denne kunden og vise verifiseringsmerket.',
        'verification_note' => 'Verifikasjonsmerknad',
        'verification_note_placeholder' => 'Skriv inn eventuelle merknader om denne verifikasjonshandlingen...',
        'verification_note_helper' => 'Legg til merknader om verifiseringsprosessen (kun intern bruk)',
        'forms' => [
            'name' => 'Navn',
            'email' => 'E-post',
            'phone' => 'Telefon',
            'avatar' => 'Avatar',
            'dob' => 'Fødselsdato',
            'company' => 'Selskap',
            'position' => 'Stilling',
            'password' => 'Passord',
            'password_confirmation' => 'Bekreft passord',
            'change_password' => 'Endre passord?',
            'phone_placeholder' => 'Telefon',
        ],
    ],
    'vendor' => [
        'name' => 'Leverandører',
        'view' => 'Vis :name',
        'information' => 'Leverandørinformasjon',
        'total_cars' => 'Totalt antall biler',
        'total_bookings' => 'Totalt antall bestillinger',
        'verified' => 'Verifisert',
        'not_verified' => 'Ikke verifisert',
        'verification_section' => 'Leverandørverifisering',
        'vendor_verified_successfully' => 'Denne leverandøren har blitt verifisert og kan stoles på.',
        'vendor_not_verified_yet' => 'Denne leverandøren har ikke blitt verifisert ennå.',
        'verification_pending' => 'Verifisering venter',
        'click_verify_to_approve' => 'Klikk på knappen nedenfor for å verifisere denne leverandøren og vise verifiseringsmerket.',
        'verify_vendor' => 'Verifiser leverandør',
        'unverify_vendor' => 'Fjern verifisering av leverandør',
        'verify_vendor_confirmation' => 'Bekreft leverandørverifisering',
        'verify_vendor_confirmation_desc' => 'Er du sikker på at du vil verifisere :name? Dette vil vise et verifiseringmerke på profilen.',
        'unverify_vendor_confirmation' => 'Bekreft fjerning av verifisering',
        'unverify_vendor_confirmation_desc' => 'Er du sikker på at du vil fjerne verifiseringen fra :name? Verifiseringsmerket vil bli fjernet.',
        'verified_successfully' => 'Leverandøren har blitt verifisert.',
        'unverified_successfully' => 'Leverandørverifiseringen har blitt fjernet.',
        'already_verified' => 'Denne leverandøren er allerede verifisert.',
        'not_verified_yet' => 'Denne leverandøren er ikke verifisert ennå.',
        'recent_activity' => 'Nylig aktivitet',
        'recent_cars' => 'Nylige biler',
        'recent_bookings' => 'Nylige bestillinger',
        'no_cars_yet' => 'Ingen biler lagt til ennå.',
        'no_bookings_yet' => 'Ingen bestillinger mottatt ennå.',
    ],
    'make' => [
        'name' => 'Bilmerker',
        'create' => 'Opprett bilmerke',
        'forms' => [
            'logo' => 'Logo',
            'logo_dark' => 'Mørk logo',
        ],
    ],
    'car' => [
        'name' => 'Biler',
        'create' => 'Opprett bil',
        'forms' => [
            'car' => 'Bil',
            'logo' => 'Logo',
            'license_plate' => 'Registreringsnummer',
            'make' => 'Merke',
            'model' => 'Modell',
            'name' => 'Navn',
            'images' => 'Bilder',
            'year' => 'År',
            'color' => 'Farge',
            'mileage' => 'Kjørelengde',
            'kilometers' => 'Kilometer',
            'horsepower' => 'Hestekrefter',
            'vehicle_type' => 'Kjøretøytype',
            'transmission' => 'Girkasse',
            'fuel_type' => 'Drivstofftype',
            'rental_rate' => 'Leiepris',
            'currency' => 'Valuta',
            'status' => 'Status',
            'availability' => 'Tilgjengelighet',
            'insurance_info' => 'Forsikringsinformasjon',
            'number_of_seats' => 'Antall seter',
            'number_of_doors' => 'Antall dører',
            'vin' => 'VIN',
            'maintenance_history' => 'Vedlikeholdshistorikk',
            'location' => 'Sted',
            'description' => 'Beskrivelse',
            'rental_type' => 'Leietype',
            'tags' => 'Etiketter',
            'add_new_attribute' => 'Legg til ny <a href=":url" target="_blank">her</a>.',
            'categories' => 'Kategorier',
            'pick_address' => 'Hentested',
            'return_address' => 'Leveringssted',
            'same_drop_off' => 'Samme leveringssted',
            'tax' => 'Skatt',
            'select_tax' => 'Velg skatt',
            'none' => 'Ingen',
            'colors' => 'Farger',
            'amenities' => 'Fasiliteter',
            'is_used' => 'Er brukt?',
            'moderation_status' => 'Modereringsstatus',
            'status_moderation' => [
                'approve' => 'Godkjenn',
                'reject' => 'Avvis',
                'approve_title' => 'Godkjenn bil',
                'approve_message' => 'Er du sikker på at du vil godkjenne denne bilen? Denne handlingen kan ikke angres.',
                'reject_title' => 'Avvis bil',
                'reject_message' => 'Er du sikker på at du vil avvise denne bilen? Denne handlingen kan ikke angres.',
                'reject_reason' => 'Skriv inn årsaken til avvisning',
                'approved' => 'Bilen har blitt godkjent!',
                'rejected' => 'Bilen har blitt avvist!',
                'reason_rejected' => 'Årsak til avvisning',
            ],
            'customer' => 'Kunde',
            'select_customer' => 'Velg en kunde...',
            'vendor_images' => 'Bilder (Maksimum :max bilder)',
            'images_upload_placeholder' => 'Slipp filer her eller klikk for å laste opp.',
            'car_purpose' => 'Bilformål',
            'for_rent' => 'Til leie',
            'for_sale' => 'Til salgs',
            'car_type' => 'Biltype',
            'rental_information' => 'Leieinformasjon',
            'sale_statuses' => [
                'available' => 'Tilgjengelig',
                'sold' => 'Solgt',
                'reserved' => 'Reservert',
            ],
            'selling_information' => 'Salgsinformasjon',
            'is_for_sale' => 'Tilgjengelig for salg',
            'sale_price' => 'Salgspris',
            'sale_price_placeholder' => 'Skriv inn salgspris',
            'condition' => 'Stand',
            'select_condition' => 'Velg stand',
            'condition_options' => [
                'new' => 'Ny',
                'like_new' => 'Som ny',
                'excellent' => 'Utmerket',
                'good' => 'God',
                'fair' => 'Akseptabel',
                'poor' => 'Dårlig',
            ],
            'ownership_history' => 'Eierhistorikk',
            'ownership_history_placeholder' => 'Skriv inn eierhistorikk',
            'warranty_information' => 'Garantiinformasjon',
            'warranty_information_placeholder' => 'Skriv inn garantiinformasjon',
            'sale_status' => 'Salgsstatus',
            'external_booking_url' => 'Ekstern bestillingslenke',
            'external_booking_url_helper' => 'Skriv inn den eksterne URL-en hvor kunder kan bestille denne bilen utenfor denne plattformen. La stå tom hvis bestilling kun er tilgjengelig på dette nettstedet.',
            'address' => 'Adresse',
            'address_helper' => 'Skriv inn den spesifikke gateadressen hvor kjøretøyet befinner seg',
        ],
        'car_purposes' => [
            'sale' => 'Til salgs',
            'rent' => 'Til leie',
        ],
        'placeholders' => [
            'name' => 'Skriv inn kjøretøyets navn (f.eks. Toyota Camry 2023, Honda CR-V, osv.)',
            'description' => 'Skriv inn en kort beskrivelse av kjøretøyet som fremhever nøkkelfunksjoner',
            'rental_rate' => 'Skriv inn leieprisen basert på valgt leietype',
            'location' => 'Skriv inn den fysiske plasseringen av kjøretøyet',
            'address' => 'Skriv inn den spesifikke gateadressen (f.eks. Storgata 123, By, Fylke)',
            'sale_price' => 'Skriv inn salgsprisen for dette kjøretøyet',
            'ownership_history' => 'Skriv inn detaljer om tidligere eiere, antall eiere, osv.',
            'warranty_information' => 'Skriv inn detaljer om garantidekning, utløpsdato, osv.',
            'external_booking_url' => 'https://eksempel.no/bestillings-lenke',
            'license_plate' => 'Skriv inn registreringsnummer',
            'vin' => 'Skriv inn understellsnummeret (VIN)',
            'year' => 'Skriv inn produksjonsåret (f.eks. 2023)',
            'mileage' => 'Skriv inn gjeldende kjørelengde',
            'kilometers' => 'Skriv inn gjeldende kilometer',
            'horsepower' => 'Skriv inn hestekrefter (HK) til kjøretøyet (f.eks. 150.5)',
            'number_of_seats' => 'Skriv inn antall seter i kjøretøyet',
            'number_of_doors' => 'Skriv inn antall dører kjøretøyet har',
            'insurance_info' => 'Skriv inn relevant forsikringsinformasjon for dette kjøretøyet',
            'tags' => 'Velg eller opprett etiketter',
            'amenities' => 'Velg fasiliteter',
            'colors' => 'Velg eller opprett farger',
        ],
        'enums' => [
            'vendor_status' => 'Leverandørstatus',
            'is_vendor' => 'Leverandør',
            'not_vendor' => 'Kunde',
            'statuses' => [
                'available' => 'Tilgjengelig',
                'rented' => 'Utleid',
                'maintenance' => 'Vedlikehold',
                'out_of_service' => 'Ute av drift',
            ],
            'rental_types' => [
                'per_hour' => 'Per time',
                'per_day' => 'Per dag',
                'per_week' => 'Per uke',
                'per_month' => 'Per måned',
            ],
            'moderation_statuses' => [
                'pending' => 'Venter',
                'approved' => 'Godkjent',
                'rejected' => 'Avvist',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Vedlikeholdshistorikk',
            'create' => 'Opprett servicehistorikk',
            'amount' => 'Beløp',
            'forms' => [
                'price_placeholder' => 'Servicepris',
                'currency' => 'Valuta',
                'none' => 'Ingen',
                'name' => 'Navn',
                'amount' => 'Beløp',
                'created_at' => 'Opprettet',
                'action' => 'Handling',
                'date' => 'Dato',
                'no_maintenance_history' => 'Ingen vedlikeholdshistorikk',
                'edit_maintenance_history' => 'Rediger vedlikeholdshistorikk',
                'add_maintenance_history' => 'Legg til vedlikeholdshistorikk',
                'add' => 'Legg til',
                'edit' => 'Rediger',
                'delete' => 'Slett',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Bilattributter',
        'car_type' => [
            'name' => 'Typer',
            'create' => 'Opprett biltype',
            'forms' => [
                'name' => 'Navn',
            ],
        ],
        'transmission' => [
            'name' => 'Girkasser',
            'create' => 'Opprett girkasse',
            'forms' => [
                'name' => 'Navn',
            ],
        ],
        'fuel_type' => [
            'name' => 'Drivstoff',
            'create' => 'Opprett drivstofftype',
            'forms' => [
                'name' => 'Navn',
            ],
        ],
        'tag' => [
            'name' => 'Etiketter',
            'create' => 'Opprett etikett',
        ],
        'category' => [
            'name' => 'Kategorier',
            'create' => 'Opprett kategori',
            'forms' => [
                'none' => 'Ingen',
                'total_cars' => 'Totalt antall biler: :total',
            ],
        ],
        'address' => [
            'name' => 'Steder',
            'create' => 'Opprett bilsted',
            'form' => [
                'name' => 'Adresse',
                'full_address' => 'Full adresse',
                'detail_address' => 'Detaljert adresse',
            ],
        ],
        'color' => [
            'name' => 'Farge',
            'create' => 'Opprett farge',
        ],
        'amenity' => [
            'name' => 'Fasiliteter',
            'create' => 'Opprett fasilitet',
        ],
    ],
    'tax' => [
        'name' => 'Skatter',
        'create' => 'Opprett skatt',
        'forms' => [
            'name' => 'Navn',
            'name_placeholder' => 'Skriv inn navn',
            'percentage' => 'Prosentsats',
            'percentage_placeholder' => 'Prosentsats',
            'percent_placeholder' => 'Prosentsats',
            'priority' => 'Prioritet',
            'priority_placeholder' => 'Prioritet',
        ],
    ],
    'review' => [
        'name' => 'Anmeldelser',
        'create' => 'Opprett anmeldelse',
        'edit' => 'Rediger anmeldelse',
        'vendor' => [
            'title' => 'Kundeanmeldelser',
            'description' => 'Administrer alle kundeanmeldelser for bilene dine',
            'no_reviews' => 'Du har ingen anmeldelser ennå',
            'filter_by_car' => 'Filtrer etter bil',
            'filter_by_rating' => 'Filtrer etter vurdering',
            'filter_by_date' => 'Filtrer etter dato',
            'all_cars' => 'Alle biler',
            'all_ratings' => 'Alle vurderinger',
            'manage_reviews' => 'Administrer anmeldelser',
            'view_all' => 'Vis alle anmeldelser',
            'delete_review_confirmation' => 'Er du sikker på at du vil slette denne anmeldelsen?',
            'delete_review_success' => 'Anmeldelsen er slettet',
            'cannot_delete' => 'Kan ikke slette denne anmeldelsen',
        ],
        'forms' => [
            'customer' => 'Kunde',
            'car' => 'Bil',
            'content' => 'Innhold',
            'rating' => 'Vurdering',
            'your_name' => 'Ditt navn',
            'email_address' => 'E-postadresse',
            'submit' => 'Send inn',
            'star' => 'Stjerne',
            'status' => 'Status',
            'created_at' => 'Opprettet',
            'select_car' => 'Velg bil',
            'select_rating' => 'Velg vurdering',
            'comment' => 'Kommentar',
            'reply' => 'Svar',
            'reply_to_review' => 'Svar på anmeldelse',
            'save_reply' => 'Lagre svar',
            'cancel_reply' => 'Avbryt',
        ],
        'statuses' => [
            'published' => 'Publisert',
            'pending' => 'Venter',
            'rejected' => 'Avvist',
        ],
        'ratings' => [
            '1' => '1 stjerne - Dårlig',
            '2' => '2 stjerner - Akseptabel',
            '3' => '3 stjerner - God',
            '4' => '4 stjerner - Meget god',
            '5' => '5 stjerner - Utmerket',
        ],
    ],
    'coupon' => [
        'name' => 'Kuponger',
        'create' => 'Opprett kupong',
        'types' => [
            'percentage' => 'Prosent %',
            'money' => 'Beløp',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Tjenester',
        'create' => 'Opprett tjeneste',
        'forms' => [
            'name' => 'Navn',
            'content' => 'Innhold',
            'price' => 'Pris',
            'currency' => 'Valuta',
            'image' => 'Bilde',
            'logo' => 'Logo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Tilgjengelighetskalender',
        'title' => 'Tilgjengelighetskalender',
        'description' => 'Vis biltilgjengelighet og bestillinger i kalenderformat',
        'select_dates' => 'Velg datoer for å sjekke tilgjengelighet',
        'car_filter' => 'Filtrer etter bil',
        'all_cars' => 'Alle biler',
        'clear_filter' => 'Fjern filter',
        'availability_check' => 'Sjekk biltilgjengelighet',
        'selected_period' => 'Valgt periode',
        'checking_availability' => 'Sjekker tilgjengelighet...',
        'available' => 'Tilgjengelig',
        'not_available' => 'Ikke tilgjengelig',
        'booking_details' => 'Bestillingsdetaljer',
        'how_to_use' => 'Hvordan bruke biltilgjengelighetskalenderen',
        'viewing_bookings' => 'Vise bestillinger',
        'checking_availability_help' => 'Sjekke tilgjengelighet',
        'color_legend' => 'Fargeoversikt',
        'pending_bookings' => 'Ventende bestillinger',
        'processing_bookings' => 'Behandler bestillinger',
        'completed_bookings' => 'Fullførte bestillinger',
        'cancelled_bookings' => 'Kansellerte bestillinger',
        'unknown_make' => 'Ukjent merke',
        'loading' => 'Laster...',
        'loading_calendar_data' => 'Laster kalenderdata...',
        'loading_booking_details' => 'Laster bestillingsdetaljer...',
        'please_wait_booking_info' => 'Vennligst vent mens vi henter bestillingsinformasjonen.',
        'please_wait_availability' => 'Vennligst vent mens vi sjekker biltilgjengelighet for de valgte datoene.',
        'error' => 'Feil',
        'error_loading_booking' => 'Kunne ikke laste bestillingsdetaljer. Vennligst prøv igjen.',
        'error_checking_availability' => 'Feil ved sjekking av biltilgjengelighet',
        'customer' => 'Kunde',
        'status' => 'Status',
        'amount' => 'Beløp',
        'make' => 'Merke',
        'vendor' => 'Leverandør',
        'per_day' => '/dag',
        'edit_car' => 'Rediger bil',
        'no_cars_found' => 'Ingen biler funnet',
        'no_cars_available_period' => 'Det er ingen biler tilgjengelig for den valgte perioden.',
        'close' => 'Lukk',
        'edit_booking' => 'Rediger bestilling',
        'pending' => 'Venter',
        'processing' => 'Behandler',
        'completed' => 'Fullført',
        'cancelled' => 'Kansellert',
    ],
    'theme_options' => [
        'name' => 'Bilutleie',
        'description' => 'Temainnstillinger for bilutleie',
        'car_location_filter_by' => 'Filtrer bilsted etter',
        'state' => 'Fylke',
        'city' => 'By',
        'yes' => 'Ja',
        'no' => 'Nei',
        'is_display_country' => 'Vis land på stedsfilter?',
        'logo_vendor_dashboard' => 'Logo i leverandørpanelet (Standard er hovedlogoen)',
        'number_of_cars_per_page' => 'Antall biler per side',
        'number_of_cars_per_page_placeholder' => 'Skriv inn antall biler som skal vises per side',
    ],
    'message' => [
        'name' => 'Meldinger',
        'forms' => [
            'customer_name' => 'Kundenavn',
            'message' => 'Melding',
            'phone' => 'Telefon',
            'email' => 'E-post',
            'created_at' => 'Opprettet',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Bilsalg',
        'create' => 'Nytt bilsalg',
        'edit' => 'Rediger bilsalg :name',
        'statuses' => [
            'pending' => 'Venter',
            'processing' => 'Behandler',
            'completed' => 'Fullført',
            'cancelled' => 'Kansellert',
        ],
        'forms' => [
            'transaction_id' => 'Transaksjons-ID',
            'transaction_id_placeholder' => 'Skriv inn transaksjons-ID',
            'car_id' => 'Bil',
            'car' => 'Bil',
            'customer_id' => 'Kunde',
            'customer_name' => 'Kundenavn',
            'customer_name_placeholder' => 'Skriv inn kundenavn',
            'customer_email' => 'Kunde e-post',
            'customer_email_placeholder' => 'Skriv inn kunde e-post',
            'customer_phone' => 'Kunde telefon',
            'customer_phone_placeholder' => 'Skriv inn kunde telefon',
            'sale_price' => 'Salgspris',
            'sale_price_placeholder' => 'Skriv inn salgspris',
            'tax_amount' => 'Skattebeløp',
            'tax_amount_placeholder' => 'Skriv inn skattebeløp',
            'total_amount' => 'Totalbeløp',
            'total_amount_placeholder' => 'Skriv inn totalbeløp',
            'payment_details' => 'Betalingsdetaljer',
            'payment_details_placeholder' => 'Skriv inn betalingsdetaljer',
            'notes' => 'Merknader',
            'notes_placeholder' => 'Skriv inn merknader',
            'sale_date' => 'Salgsdato',
            'delivery_date' => 'Leveringsdato',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankoverføring',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Bekreftelse på bilutleiebooking',
        'booking_confirm_greeting' => 'Kjære :customer_name,',
        'booking_confirm_message' => 'Vi er glade for å informere deg om at din bilutleiebooking har blitt bekreftet!',
        'customer_information' => 'Kundeinformasjon',
        'booking_information' => 'Bestillingsinformasjon',
        'field_name' => 'Navn:',
        'field_phone' => 'Telefon:',
        'field_email' => 'E-post:',
        'field_car_model' => 'Bilmodell:',
        'field_start_date' => 'Startdato:',
        'field_end_date' => 'Sluttdato:',
        'field_pickup_address' => 'Hentested:',
        'field_return_address' => 'Leveringssted:',
        'field_note' => 'Merknad:',
        'field_order_number' => 'Ordrenummer',
        'field_payment_method' => 'Betalingsmåte',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Ny bestillingsvarsel',
        'booking_notice_admin_greeting' => 'Hei, det er en ny bestilling fra :site_title:',
        'booking_notice_admin_message' => 'En ny bilutleiebooking har blitt sendt inn og krever din oppmerksomhet.',
        'booking_view_detail' => 'Vis bestillingsdetaljer:',
        'view_booking_details' => 'Vis bestillingsdetaljer',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Ny bestilling for bilen din',
        'booking_notice_vendor_greeting' => 'Kjære :vendor_name,',
        'booking_notice_vendor_message' => 'Gode nyheter! Du har mottatt en ny bestilling for bilutleien din.',

        // Booking status changed email
        'booking_status_updated' => 'Bestillingsstatus oppdatert',
        'hello_thanks_for_booking' => 'Hei, takk for bestillingen fra :site_title:',
        'booking_status_change_message' => 'Vi håper denne meldingen finner deg vel. Vi ønsket å informere deg om at statusen på bestillingen din har blitt oppdatert.',
        'name' => 'Navn',
        'phone' => 'Telefon',
        'email' => 'E-post',
        'car_model' => 'Bilmodell',
        'start_date' => 'Startdato',
        'end_date' => 'Sluttdato',
        'pickup_address' => 'Hentested',
        'return_address' => 'Leveringssted',
        'note' => 'Merknad',
        'order_number' => 'Ordrenummer',
        'payment_method' => 'Betalingsmåte',

        // Car approved email
        'hello' => 'Hei',
        'car_approved_title' => 'Gode nyheter! Bilen din har blitt godkjent',
        'car_approved_message' => 'Vi er glade for å informere deg om at din bilannonse ":car_name" har blitt godkjent og er nå direkte på :site_title. Du kan begynne å motta bestillinger og administrere annonsen din umiddelbart.',
        'view_edit_car_link' => 'For å se eller redigere bilannonsen din, vennligst klikk på denne lenken',
        'view_car' => 'Vis bilannonse',
        'regards' => 'Med vennlig hilsen',

        // Vendor upgrade email
        'vendor_upgrade_title' => 'Gratulerer! Du er nå en leverandør',
        'vendor_upgrade_congratulations' => 'Vi er glade for å informere deg om at kontoen din har blitt oppgradert til leverandørstatus!',
        'vendor_upgrade_message' => 'Du kan nå liste og administrere dine egne biler på :site_title. Dette åpner nye muligheter for deg til å utvikle din utleievirksomhet med oss.',
        'vendor_benefits_title' => 'Dine nye leverandørfordeler',
        'vendor_benefit_1' => 'List ubegrenset antall biler til leie',
        'vendor_benefit_2' => 'Administrer dine egne bestillinger og kunder',
        'vendor_benefit_3' => 'Spor inntekter og ytelsesmetrikker',
        'vendor_benefit_4' => 'Tilgang til leverandøreksklusive funksjoner og verktøy',
        'next_steps' => 'Neste steg',
        'vendor_next_steps_message' => 'Logg inn på leverandørpanelet ditt for å begynne å legge til dine biler og administrere utleievirksomheten din.',
        'go_to_dashboard' => 'Gå til leverandørpanelet',
        'vendor_support_message' => 'Hvis du har spørsmål eller trenger hjelp, er supportteamet vårt her for å hjelpe deg i gang.',
        'approved' => 'Godkjent',

        // Car rejected email
        'car_rejected_title' => 'Oppdatering kreves for bilannonsen din',
        'car_rejected_message' => 'Takk for at du sendte inn bilannonsen din ":car_name" til :site_title. Etter gjennomgang av innsendingen din, må du gjøre noen justeringer før vi kan godkjenne den.',
        'rejection_reason' => 'Her er hva som må oppdateres',
        'rejection_details' => 'Nødvendige oppdateringer',
        'contact_support' => 'Hvis du har spørsmål eller trenger hjelp med disse oppdateringene, vennligst ikke nøl med å kontakte supportteamet vårt på :site_email. Vi er her for å hjelpe deg med å få annonsen din godkjent raskt.',

        // Confirm email
        'verify_email' => 'Verifiser e-post',
        'welcome_message' => 'Vi er glade for å ha deg her, :customer_name!',
        'verify_email_instruction' => 'Vennligst verifiser e-postadressen din for å få tilgang til dette nettstedet. Klikk på knappen nedenfor for å verifisere e-posten din.',
        'confirm_email_button' => 'Bekreft e-postadressen din',
        'verify_link_trouble' => 'Hvis du har problemer med å klikke på \'Bekreft e-postadressen din\'-knappen, kopier og lim inn URL-en nedenfor i nettleseren din: :verify_link og lim den inn i nettleseren din.',

        // Message email
        'new_message' => 'Ny melding',
        'dear_admin' => 'Kjære administrator',
        'new_message_from' => 'Det er en ny melding fra :site_title:',
        'subject' => 'Emne',
        'address' => 'Adresse',
        'content' => 'Innhold',

        // New pending car email
        'hi_admin' => 'Hei administrator,',
        'new_car_pending_title' => 'Ny bilannonse venter på godkjenning',
        'new_car_pending_approval' => 'En ny bilannonse ":post_name" har blitt sendt inn av :post_author og er klar for din gjennomgang.',
        'pending_approval' => 'Venter på godkjenning',
        'review_car_admin' => 'Vennligst gjennomgå denne annonsen i administrasjonspanelet og godkjenn eller be om oppdateringer etter behov.',

        // Common fields
        'car_information' => 'Bilinformasjon',
        'field_car_name' => 'Bilnavn:',
        'field_author' => 'Forfatter:',
        'field_status' => 'Status:',
        'actions' => 'Handlinger',

        // Password reminder email
        'reset_password_instruction' => 'Instruksjoner for tilbakestilling av passord',
        'password_reset_request' => 'Du mottar denne e-posten fordi vi mottok en forespørsel om tilbakestilling av passord for kontoen din.',
        'reset_password_button' => 'Tilbakestill passord',
        'reset_link_trouble' => 'Hvis du har problemer med å klikke på \'Tilbakestill passord\'-knappen, kopier og lim inn URL-en nedenfor i nettleseren din: :reset_link og lim den inn i nettleseren din. Hvis du ikke ba om tilbakestilling av passord, vennligst ignorer denne meldingen eller kontakt oss hvis du har spørsmål.',
    ],
];
