<?php

return [
    'name' => 'Aluguer de Carros',
    'customer' => [
        'name' => 'Clientes',
        'create' => 'Criar Cliente',
        'view' => 'Ver',
        'information' => 'Informação do Cliente',
        'email' => 'Email',
        'phone' => 'Telefone',
        'status' => 'Estado',
        'vendor_status' => 'Estado do Fornecedor',
        'is_vendor' => 'Fornecedor',
        'not_vendor' => 'Cliente',
        'recent_activity' => 'Atividade Recente',
        'recent_activity_description' => 'A atividade do cliente aparecerá aqui.',
        'verification_section' => 'Verificação do Cliente',
        'verified' => 'Verificado',
        'not_verified' => 'Não Verificado',
        'verified_by' => 'Verificado Por',
        'verified_at' => 'Verificado Em',
        'verify_customer' => 'Verificar Cliente',
        'unverify_customer' => 'Remover Verificação do Cliente',
        'verify_customer_confirmation' => 'Confirmação de Verificação do Cliente',
        'verify_customer_confirmation_desc' => 'Tem a certeza que quer verificar :name? Isto irá mostrar um distintivo de verificação no perfil.',
        'unverify_customer_confirmation' => 'Confirmação de Remoção de Verificação do Cliente',
        'unverify_customer_confirmation_desc' => 'Tem a certeza que quer remover a verificação de :name? O distintivo de verificação será removido.',
        'verify_success' => 'Cliente :name foi verificado com sucesso.',
        'unverify_success' => 'A verificação do cliente :name foi removida com sucesso.',
        'already_verified' => 'Este cliente já está verificado.',
        'already_unverified' => 'Este cliente não está verificado.',
        'upgrade_to_vendor_title' => 'Promover para Fornecedor',
        'upgrade_to_vendor_description' => 'Promova este cliente para o status de fornecedor para permitir que listem e gerenciem seus próprios aluguéis de carros.',
        'upgrade_to_vendor_button' => 'Promover para Fornecedor',
        'upgrade_to_vendor_confirmation' => 'Confirmar Promoção para Fornecedor',
        'upgrade_to_vendor_confirmation_desc' => 'Tem a certeza que quer promover :name para o status de fornecedor? Isto permitirá que listem e gerenciem seus próprios carros na plataforma.',
        'upgrade_to_vendor_success' => ':name foi promovido com sucesso para o status de fornecedor.',
        'already_vendor' => 'Este cliente já é um fornecedor.',
        'email_verified' => 'Email Verificado',
        'email_not_verified' => 'Email Não Verificado',
        'verify_email_warning_message' => 'O endereço de email deste cliente não foi verificado. Pode verificá-lo manualmente para confirmar que o seu email é válido.',
        'verify_email_title' => 'Verificar Endereço de Email',
        'verify_email_description' => 'O endereço de email deste cliente não foi verificado. Pode verificá-lo manualmente para confirmar que o seu email é válido.',
        'verify_email_button' => 'Verificar Email',
        'verify_email_confirmation' => 'Confirmar Verificação de Email',
        'verify_email_confirmation_desc' => 'Tem a certeza que quer verificar o endereço de email :email para :name? Isto marcará o seu email como confirmado.',
        'verify_email_success' => 'O email :email foi verificado com sucesso para :name.',
        'email_already_verified' => 'Este endereço de email já está verificado.',
        'resend_confirmation_button' => 'Reenviar Email de Confirmação',
        'resend_confirmation_title' => 'Reenviar Email de Confirmação',
        'resend_confirmation_desc' => 'Tem a certeza que quer reenviar o email de confirmação para :email para :name? Isto enviará um novo link de verificação para o seu endereço de email.',
        'resend_confirmation_success' => 'Email de confirmação foi enviado para :email.',
        'resend_confirmation_error' => 'Falha ao enviar email de confirmação. Por favor, tente novamente.',
        'customer_verified_successfully' => 'Este cliente foi verificado e é de confiança.',
        'customer_not_verified_yet' => 'Este cliente ainda não foi verificado.',
        'verification_pending' => 'Verificação Pendente',
        'click_verify_to_approve' => 'Clique no botão abaixo para verificar este cliente e mostrar o distintivo de verificação.',
        'verification_note' => 'Nota de Verificação',
        'verification_note_placeholder' => 'Inserir notas sobre esta ação de verificação...',
        'verification_note_helper' => 'Adicionar notas sobre o processo de verificação (uso interno apenas)',
        'forms' => [
            'name' => 'Nome',
            'email' => 'Email',
            'phone' => 'Telefone',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Avatar',
            'dob' => 'Data de Nascimento',
            'company' => 'Empresa',
            'position' => 'Posição',
            'password' => 'Palavra-passe',
            'password_confirmation' => 'Confirmação da palavra-passe',
            'change_password' => 'Alterar palavra-passe?',
            'phone_placeholder' => 'Telefone',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => 'Fornecedores',
        'view' => 'Ver :name',
        'information' => 'Informação do Fornecedor',
        'total_cars' => 'Total de Carros',
        'total_bookings' => 'Total de Reservas',
        'verified' => 'Verificado',
        'not_verified' => 'Não Verificado',
        'verification_section' => 'Verificação do Fornecedor',
        'vendor_verified_successfully' => 'Este fornecedor foi verificado e é de confiança.',
        'vendor_not_verified_yet' => 'Este fornecedor ainda não foi verificado.',
        'verification_pending' => 'Verificação Pendente',
        'click_verify_to_approve' => 'Clique no botão abaixo para verificar este fornecedor e mostrar o distintivo de verificação.',
        'verify_vendor' => 'Verificar Fornecedor',
        'unverify_vendor' => 'Remover Verificação do Fornecedor',
        'verify_vendor_confirmation' => 'Confirmação de Verificação do Fornecedor',
        'verify_vendor_confirmation_desc' => 'Tem a certeza que quer verificar :name? Isto irá mostrar um distintivo de verificação no perfil.',
        'unverify_vendor_confirmation' => 'Confirmação de Remoção de Verificação do Fornecedor',
        'unverify_vendor_confirmation_desc' => 'Tem a certeza que quer remover a verificação de :name? O distintivo de verificação será removido.',
        'verified_successfully' => 'Fornecedor foi verificado com sucesso.',
        'unverified_successfully' => 'A verificação do fornecedor foi removida com sucesso.',
        'already_verified' => 'Este fornecedor já está verificado.',
        'not_verified_yet' => 'Este fornecedor ainda não está verificado.',
        'recent_activity' => 'Atividade Recente',
        'recent_cars' => 'Carros Recentes',
        'recent_bookings' => 'Reservas Recentes',
        'no_cars_yet' => 'Ainda não foram adicionados carros.',
        'no_bookings_yet' => 'Ainda não foram recebidas reservas.',
    ],
    'make' => [
        'name' => 'Marcas',
        'create' => 'Criar Marca de Carro',
        'forms' => [
            'logo' => 'Logótipo',
            'logo_dark' => 'Logótipo Escuro',
        ],
    ],
    'car' => [
        'name' => 'Carros',
        'create' => 'Criar Carro',
        'forms' => [
            'car' => 'Carro',
            'logo' => 'Logótipo',
            'license_plate' => 'Matrícula',
            'make' => 'Marca',
            'model' => 'Modelo',
            'name' => 'Nome',
            'images' => 'Imagens',
            'year' => 'Ano',
            'color' => 'Cor',
            'mileage' => 'Quilometragem',
            'kilometers' => 'Quilómetros',
            'horsepower' => 'Cavalos de Potência',
            'vehicle_type' => 'Tipo de Veículo',
            'transmission' => 'Transmissão',
            'fuel_type' => 'Tipo de Combustível',
            'rental_rate' => 'Taxa de Aluguer',
            'currency' => 'Moeda',
            'status' => 'Estado',
            'availability' => 'Disponibilidade',
            'insurance_info' => 'Informação do seguro',
            'number_of_seats' => 'Número de Lugares',
            'number_of_doors' => 'Número de Portas',
            'vin' => 'VIN',
            'maintenance_history' => 'Histórico de Manutenção',
            'location' => 'Localização',
            'description' => 'Descrição',
            'rental_type' => 'Tipo de Aluguer',
            'tags' => 'Etiquetas',
            'add_new_attribute' => 'Adicionar novo <a href=":url" target="_blank">aqui</a>.',
            'categories' => 'Categorias',
            'pick_address' => 'Morada de Recolha',
            'return_address' => 'Morada de Devolução',
            'same_drop_off' => 'Mesma Devolução',
            'tax' => 'Imposto',
            'select_tax' => 'Selecionar Imposto',
            'none' => 'Nenhum',
            'colors' => 'Cores',
            'amenities' => 'Comodidades',
            'is_used' => 'É usado?',
            'moderation_status' => 'Estado de moderação',
            'status_moderation' => [
                'approve' => 'Aprovar',
                'reject' => 'Rejeitar',
                'approve_title' => 'Aprovar carro',
                'approve_message' => 'Tem a certeza que quer aprovar este carro? Esta ação não pode ser desfeita.',
                'reject_title' => 'Rejeitar carro',
                'reject_message' => 'Tem a certeza que quer rejeitar este carro? Esta ação não pode ser desfeita.',
                'reject_reason' => 'Inserir o motivo da rejeição',
                'approved' => 'Carro foi aprovado com sucesso!',
                'rejected' => 'Carro foi rejeitado com sucesso!',
                'reason_rejected' => 'Motivo da rejeição',
            ],
            'customer' => 'Cliente',
            'select_customer' => 'Selecionar um cliente...',
            'vendor_images' => 'Imagens (Máximo :max imagens)',
            'images_upload_placeholder' => 'Solte ficheiros aqui ou clique para carregar.',
            'car_purpose' => 'Propósito do Carro',
            'for_rent' => 'Para Alugar',
            'for_sale' => 'Para Venda',
            'car_type' => 'Tipo de Carro',
            'rental_information' => 'Informação de Aluguer',
            'sale_statuses' => [
                'available' => 'Disponível',
                'sold' => 'Vendido',
                'reserved' => 'Reservado',
            ],
            'selling_information' => 'Informação de Venda',
            'is_for_sale' => 'Disponível para venda',
            'sale_price' => 'Preço de Venda',
            'sale_price_placeholder' => 'Inserir preço de venda',
            'condition' => 'Condição',
            'select_condition' => 'Selecionar Condição',
            'condition_options' => [
                'new' => 'Novo',
                'like_new' => 'Como Novo',
                'excellent' => 'Excelente',
                'good' => 'Bom',
                'fair' => 'Razoável',
                'poor' => 'Mau',
            ],
            'ownership_history' => 'Histórico de Propriedade',
            'ownership_history_placeholder' => 'Inserir histórico de propriedade',
            'warranty_information' => 'Informação de Garantia',
            'warranty_information_placeholder' => 'Inserir informação de garantia',
            'sale_status' => 'Estado de Venda',
            'external_booking_url' => 'Link de Reserva Externa',
            'external_booking_url_helper' => 'Inserir o URL externo onde os clientes podem reservar este carro fora desta plataforma. Deixar vazio se a reserva apenas estiver disponível neste site.',
            'address' => 'Morada',
            'address_helper' => 'Inserir a morada específica onde este veículo está localizado',
        ],
        'car_purposes' => [
            'sale' => 'Para Venda',
            'rent' => 'Para Alugar',
        ],
        'placeholders' => [
            'name' => 'Inserir o nome do veículo (ex: Toyota Camry 2023, Honda CR-V, etc.)',
            'description' => 'Inserir uma breve descrição do veículo destacando características principais',
            'rental_rate' => 'Inserir a taxa de aluguer baseada no tipo de aluguer selecionado',
            'location' => 'Inserir a localização física do veículo',
            'address' => 'Inserir a morada específica (ex: Rua Principal 123, Cidade, Estado)',
            'sale_price' => 'Inserir o preço de venda para este veículo',
            'ownership_history' => 'Inserir detalhes sobre proprietários anteriores, número de proprietários, etc.',
            'warranty_information' => 'Inserir detalhes sobre cobertura de garantia, data de expiração, etc.',
            'external_booking_url' => 'https://exemplo.com/link-reserva',
            'license_plate' => 'Inserir número da matrícula do veículo',
            'vin' => 'Inserir o Número de Identificação do Veículo (VIN)',
            'year' => 'Inserir o ano de fabrico (ex: 2023)',
            'mileage' => 'Inserir a quilometragem atual',
            'kilometers' => 'Inserir os quilómetros atuais',
            'horsepower' => 'Inserir os cavalos de potência (HP) do veículo (ex: 150.5)',
            'number_of_seats' => 'Inserir o número de lugares no veículo',
            'number_of_doors' => 'Inserir o número de portas que o veículo tem',
            'insurance_info' => 'Inserir informação de seguro relevante para este veículo',
            'tags' => 'Selecionar ou criar etiquetas',
            'amenities' => 'Selecionar comodidades',
            'colors' => 'Selecionar ou criar cores',
        ],
        'enums' => [
            'statuses' => [
                'available' => 'Disponível',
                'rented' => 'Alugado',
                'maintenance' => 'Manutenção',
                'out_of_service' => 'Fora de Serviço',
            ],
            'rental_types' => [
                'per_hour' => 'Por hora',
                'per_day' => 'Por dia',
                'per_week' => 'Por semana',
                'per_month' => 'Por mês',
            ],
            'moderation_statuses' => [
                'pending' => 'Pendente',
                'approved' => 'Aprovado',
                'rejected' => 'Rejeitado',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Históricos de Manutenção',
            'create' => 'Criar Histórico de Serviço',
            'amount' => 'Montante',
            'forms' => [
                'price_placeholder' => 'Preço do serviço',
                'currency' => 'Moeda',
                'none' => 'Nenhum',
                'name' => 'Nome',
                'amount' => 'Montante',
                'created_at' => 'Criado Em',
                'action' => 'Ação',
                'date' => 'Data',
                'no_maintenance_history' => 'Sem históricos de manutenção',
                'edit_maintenance_history' => 'Editar histórico de manutenção',
                'add_maintenance_history' => 'Adicionar histórico de manutenção',
                'add' => 'Adicionar',
                'edit' => 'Editar',
                'delete' => 'Eliminar',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atributos de Carro',
        'car_type' => [
            'name' => 'Tipos',
            'create' => 'Criar Tipo de Carro',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'transmission' => [
            'name' => 'Transmissões',
            'create' => 'Criar Transmissão',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'fuel_type' => [
            'name' => 'Combustíveis',
            'create' => 'Criar Tipos de Combustível',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'tag' => [
            'name' => 'Etiquetas',
            'create' => 'Criar Etiqueta',
        ],
        'category' => [
            'name' => 'Categorias',
            'create' => 'Criar Categoria',
            'forms' => [
                'none' => 'Nenhum',
                'total_cars' => 'Total de carros: :total',
            ],
        ],
        'address' => [
            'name' => 'Localizações',
            'create' => 'Criar Localização de Carro',
            'form' => [
                'name' => 'Morada',
                'full_address' => 'Morada Completa',
                'detail_address' => 'Morada Detalhada',
            ],
        ],
        'color' => [
            'name' => 'Cor',
            'create' => 'Criar Cor',
        ],
        'amenity' => [
            'name' => 'Comodidades',
            'create' => 'Criar Comodidade',
        ],
    ],
    'tax' => [
        'name' => 'Impostos',
        'create' => 'Criar Imposto',
        'forms' => [
            'name' => 'Nome',
            'name_placeholder' => 'Inserir nome',
            'percentage' => 'Percentagem',
            'percentage_placeholder' => 'Percentagem',
            'percent_placeholder' => 'Percentagem',
            'priority' => 'Prioridade',
            'priority_placeholder' => 'Prioridade',
        ],
    ],
    'review' => [
        'name' => 'Avaliações',
        'create' => 'Criar Avaliação',
        'edit' => 'Editar Avaliação',
        'vendor' => [
            'title' => 'Avaliações de Clientes',
            'description' => 'Gerir todas as avaliações de clientes para os seus carros',
            'no_reviews' => 'Ainda não tem avaliações',
            'filter_by_car' => 'Filtrar por carro',
            'filter_by_rating' => 'Filtrar por classificação',
            'filter_by_date' => 'Filtrar por data',
            'all_cars' => 'Todos os Carros',
            'all_ratings' => 'Todas as Classificações',
            'manage_reviews' => 'Gerir Avaliações',
            'view_all' => 'Ver Todas as Avaliações',
            'delete_review_confirmation' => 'Tem a certeza que quer eliminar esta avaliação?',
            'delete_review_success' => 'Avaliação eliminada com sucesso',
            'cannot_delete' => 'Não é possível eliminar esta avaliação',
        ],
        'forms' => [
            'customer' => 'Cliente',
            'car' => 'Carro',
            'content' => 'Conteúdo',
            'rating' => 'Classificação',
            'your_name' => 'O Seu Nome',
            'email_address' => 'Endereço de Email',
            'submit' => 'Submeter',
            'star' => 'Estrela',
            'status' => 'Estado',
            'created_at' => 'Criado Em',
            'select_car' => 'Selecionar Carro',
            'select_rating' => 'Selecionar Classificação',
            'comment' => 'Comentário',
            'reply' => 'Responder',
            'reply_to_review' => 'Responder à Avaliação',
            'save_reply' => 'Guardar Resposta',
            'cancel_reply' => 'Cancelar',
        ],
        'statuses' => [
            'published' => 'Publicada',
            'pending' => 'Pendente',
            'rejected' => 'Rejeitada',
        ],
        'ratings' => [
            1 => '1 Estrela - Mau',
            '2 Estrelas - Razoável',
            '3 Estrelas - Bom',
            '4 Estrelas - Muito Bom',
            '5 Estrelas - Excelente',
        ],
    ],
    'coupon' => [
        'name' => 'Cupões',
        'create' => 'Criar Cupão',
        'types' => [
            'percentage' => 'Percentagem %',
            'money' => 'Dinheiro',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'Serviços',
        'create' => 'Criar Serviço',
        'forms' => [
            'name' => 'Nome',
            'content' => 'Conteúdo',
            'price' => 'Preço',
            'currency' => 'Moeda',
            'image' => 'Imagem',
            'logo' => 'Logótipo',
            'status' => 'Estado',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Calendário de Disponibilidade',
        'title' => 'Calendário de Disponibilidade',
        'description' => 'Ver disponibilidade de carros e reservas em formato de calendário',
        'select_dates' => 'Selecionar datas para verificar disponibilidade',
        'car_filter' => 'Filtrar por Carro',
        'all_cars' => 'Todos os Carros',
        'clear_filter' => 'Limpar Filtro',
        'availability_check' => 'Verificação de Disponibilidade de Carro',
        'selected_period' => 'Período Selecionado',
        'checking_availability' => 'A verificar disponibilidade...',
        'available' => 'Disponível',
        'not_available' => 'Não Disponível',
        'booking_details' => 'Detalhes da Reserva',
        'how_to_use' => 'Como Usar o Calendário de Disponibilidade de Carros',
        'viewing_bookings' => 'Ver Reservas',
        'checking_availability_help' => 'Verificar Disponibilidade',
        'color_legend' => 'Legenda de Cores',
        'pending_bookings' => 'Reservas Pendentes',
        'processing_bookings' => 'Reservas em Processamento',
        'completed_bookings' => 'Reservas Concluídas',
        'cancelled_bookings' => 'Reservas Canceladas',
        'unknown_make' => 'Marca Desconhecida',
        'loading' => 'A carregar...',
        'loading_calendar_data' => 'A carregar dados do calendário...',
        'loading_booking_details' => 'A carregar detalhes da reserva...',
        'please_wait_booking_info' => 'Por favor, aguarde enquanto procuramos a informação da reserva.',
        'please_wait_availability' => 'Por favor, aguarde enquanto verificamos a disponibilidade do carro para as datas selecionadas.',
        'error' => 'Erro',
        'error_loading_booking' => 'Falha ao carregar detalhes da reserva. Por favor, tente novamente.',
        'error_checking_availability' => 'Erro ao verificar disponibilidade do carro',
        'customer' => 'Cliente',
        'status' => 'Estado',
        'amount' => 'Montante',
        'make' => 'Marca',
        'vendor' => 'Fornecedor',
        'per_day' => '/dia',
        'edit_car' => 'Editar Carro',
        'no_cars_found' => 'Nenhum carro encontrado',
        'no_cars_available_period' => 'Não há carros disponíveis para o período selecionado.',
        'close' => 'Fechar',
        'edit_booking' => 'Editar Reserva',
        'pending' => 'Pendente',
        'processing' => 'A processar',
        'completed' => 'Concluída',
        'cancelled' => 'Cancelada',
    ],
    'theme_options' => [
        'name' => 'Aluguer de Carros',
        'description' => 'Opções de tema para aluguer de carros',
        'car_location_filter_by' => 'Filtro de localização de carro por',
        'state' => 'Estado',
        'city' => 'Cidade',
        'yes' => 'Sim',
        'no' => 'Não',
        'is_display_country' => 'Mostrar país no filtro de localização?',
        'logo_vendor_dashboard' => 'Logótipo no painel do fornecedor (Predefinido é o logótipo principal)',
        'number_of_cars_per_page' => 'Número de carros por página',
        'number_of_cars_per_page_placeholder' => 'Inserir número de carros a mostrar por página',
    ],
    'message' => [
        'name' => 'Mensagens',
        'forms' => [
            'customer_name' => 'Nome do cliente',
            'message' => 'Mensagem',
            'phone' => 'Telefone',
            'email' => 'Email',
            'created_at' => 'Criado em',
            'status' => 'Estado',
        ],
    ],
    'car_sale' => [
        'name' => 'Vendas de Carros',
        'create' => 'Nova Venda de Carro',
        'edit' => 'Editar Venda de Carro :name',
        'statuses' => [
            'pending' => 'Pendente',
            'processing' => 'A processar',
            'completed' => 'Concluída',
            'cancelled' => 'Cancelada',
        ],
        'forms' => [
            'transaction_id' => 'ID da Transação',
            'transaction_id_placeholder' => 'Inserir ID da transação',
            'car_id' => 'Carro',
            'car' => 'Carro',
            'customer_id' => 'Cliente',
            'customer_name' => 'Nome do Cliente',
            'customer_name_placeholder' => 'Inserir nome do cliente',
            'customer_email' => 'Email do Cliente',
            'customer_email_placeholder' => 'Inserir email do cliente',
            'customer_phone' => 'Telefone do Cliente',
            'customer_phone_placeholder' => 'Inserir telefone do cliente',
            'sale_price' => 'Preço de Venda',
            'sale_price_placeholder' => 'Inserir preço de venda',
            'tax_amount' => 'Montante do Imposto',
            'tax_amount_placeholder' => 'Inserir montante do imposto',
            'total_amount' => 'Montante Total',
            'total_amount_placeholder' => 'Inserir montante total',
            'payment_details' => 'Detalhes do Pagamento',
            'payment_details_placeholder' => 'Inserir detalhes do pagamento',
            'notes' => 'Notas',
            'notes_placeholder' => 'Inserir notas',
            'sale_date' => 'Data de Venda',
            'delivery_date' => 'Data de Entrega',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Transferência Bancária',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        'booking_confirm_title' => 'Confirmação de Reserva de Aluguer de Carro',
        'booking_confirm_greeting' => 'Caro :customer_name,',
        'booking_confirm_message' => 'Temos o prazer de informá-lo que a sua reserva de aluguer de carro foi confirmada com sucesso!',
        'customer_information' => 'Informação do Cliente',
        'booking_information' => 'Informação da Reserva',
        'field_name' => 'Nome:',
        'field_phone' => 'Telefone:',
        'field_email' => 'Email:',
        'field_car_model' => 'Modelo do Carro:',
        'field_start_date' => 'Data de Início:',
        'field_end_date' => 'Data de Fim:',
        'field_pickup_address' => 'Morada de Recolha:',
        'field_return_address' => 'Morada de Devolução:',
        'field_note' => 'Nota:',
        'field_order_number' => 'Número do pedido',
        'field_payment_method' => 'Método de Pagamento',
        'booking_notice_admin_title' => 'Notificação de Nova Reserva',
        'booking_notice_admin_greeting' => 'Olá, há uma nova reserva de :site_title:',
        'booking_notice_admin_message' => 'Uma nova reserva de aluguer de carro foi submetida e requer a sua atenção.',
        'booking_view_detail' => 'Ver detalhes da reserva:',
        'view_booking_details' => 'Ver Detalhes da Reserva',
        'booking_notice_vendor_title' => 'Nova Reserva para o Seu Carro',
        'booking_notice_vendor_greeting' => 'Caro :vendor_name,',
        'booking_notice_vendor_message' => 'Ótimas notícias! Recebeu uma nova reserva para o seu aluguer de carro.',
        'booking_status_updated' => 'Estado da Reserva Atualizado',
        'hello_thanks_for_booking' => 'Olá, Obrigado por reservar quartos de :site_title:',
        'booking_status_change_message' => 'Esperamos que esta mensagem o encontre bem. Queríamos informá-lo que o estado da sua reserva foi atualizado.',
        'name' => 'Nome',
        'phone' => 'Telefone',
        'email' => 'Email',
        'car_model' => 'Modelo do Carro',
        'start_date' => 'Data de Início',
        'end_date' => 'Data de Fim',
        'pickup_address' => 'Morada de Recolha',
        'return_address' => 'Morada de Devolução',
        'note' => 'Nota',
        'order_number' => 'Número do pedido',
        'payment_method' => 'Método de Pagamento',
        'hello' => 'Olá',
        'car_approved_title' => 'Ótimas Notícias! O Seu Carro Foi Aprovado',
        'car_approved_message' => 'Temos o prazer de informá-lo que o seu anúncio de carro ":car_name" foi aprovado e está agora ativo em :site_title. Pode começar a receber reservas e gerir o seu anúncio imediatamente.',
        'view_edit_car_link' => 'Para ver ou editar o seu anúncio de carro, por favor clique neste link',
        'view_car' => 'Ver Anúncio de Carro',
        'regards' => 'Cumprimentos',
        'approved' => 'Aprovado',
        'car_rejected_title' => 'Atualização Necessária para o Seu Anúncio de Carro',
        'car_rejected_message' => 'Obrigado por submeter o seu anúncio de carro ":car_name" para :site_title. Após rever a sua submissão, precisamos que faça alguns ajustes antes de podermos aprová-lo.',
        'rejection_reason' => 'Aqui está o que precisa de ser atualizado',
        'rejection_details' => 'Atualizações Necessárias',
        'contact_support' => 'Se tiver alguma questão ou precisar de assistência com estas atualizações, por favor não hesite em contactar a nossa equipa de suporte em :site_email. Estamos aqui para ajudá-lo a aprovar o seu anúncio rapidamente.',
        'verify_email' => 'Verificar Email',
        'welcome_message' => 'Ficamos contentes por tê-lo aqui, :customer_name!',
        'verify_email_instruction' => 'Por favor, verifique o seu endereço de email para poder aceder a este website. Clique no botão abaixo para verificar o seu email.',
        'confirm_email_button' => 'Confirmar o seu endereço de email',
        'verify_link_trouble' => 'Se tiver problemas a clicar no botão \'Confirmar o seu endereço de email\', copie e cole o URL abaixo no seu navegador: :verify_link e cole-o no seu navegador.',
        'new_message' => 'Nova Mensagem',
        'dear_admin' => 'Caro Administrador',
        'new_message_from' => 'Há uma nova mensagem de :site_title:',
        'subject' => 'Assunto',
        'address' => 'Morada',
        'content' => 'Conteúdo',
        'hi_admin' => 'Olá Administrador,',
        'new_car_pending_title' => 'Novo Anúncio de Carro Aguarda Revisão',
        'new_car_pending_approval' => 'Um novo anúncio de carro ":post_name" foi submetido por :post_author e está pronto para a sua revisão.',
        'pending_approval' => 'Aguarda Revisão',
        'review_car_admin' => 'Por favor, reveja este anúncio no painel de administração e aprove ou solicite atualizações conforme necessário.',
        'car_information' => 'Informação do Carro',
        'field_car_name' => 'Nome do Carro:',
        'field_author' => 'Autor:',
        'field_status' => 'Estado:',
        'actions' => 'Ações',
        'reset_password_instruction' => 'Instruções para Redefinir Palavra-passe',
        'password_reset_request' => 'Está a receber este email porque recebemos um pedido de redefinição de palavra-passe para a sua conta.',
        'reset_password_button' => 'Redefinir palavra-passe',
        'reset_link_trouble' => 'Se tiver problemas a clicar no botão \'Redefinir Palavra-passe\', copie e cole o URL abaixo no seu navegador: :reset_link e cole-o no seu navegador. Se não solicitou uma redefinição de palavra-passe, por favor ignore esta mensagem ou contacte-nos se tiver alguma questão.',
    ],
];
