<?php

return [
    'name' => 'Aluguel de Carros',
    'customer' => [
        'name' => 'Clientes',
        'create' => 'Criar Cliente',
        'view' => 'Visualizar',
        'information' => 'Informações do Cliente',
        'email' => 'E-mail',
        'phone' => 'Telefone',
        'status' => 'Status',
        'vendor_status' => 'Status de Fornecedor',
        'is_vendor' => 'Fornecedor',
        'not_vendor' => 'Cliente',
        'recent_activity' => 'Atividade Recente',
        'recent_activity_description' => 'A atividade do cliente aparecerá aqui.',
        'verification_section' => 'Verificação do Cliente',
        'verified' => 'Verificado',
        'not_verified' => 'Não Verificado',
        'verified_by' => 'Verificado Por',
        'verified_at' => 'Verificado Em',
        'verify_customer' => 'Verificar Cliente',
        'unverify_customer' => 'Remover Verificação do Cliente',
        'verify_customer_confirmation' => 'Confirmação de Verificação do Cliente',
        'verify_customer_confirmation_desc' => 'Tem certeza de que deseja verificar :name? Isso exibirá um selo de verificação no perfil dele.',
        'unverify_customer_confirmation' => 'Confirmação de Remoção de Verificação',
        'unverify_customer_confirmation_desc' => 'Tem certeza de que deseja remover a verificação de :name? O selo de verificação será removido.',
        'verify_success' => 'Cliente :name foi verificado com sucesso.',
        'unverify_success' => 'A verificação do cliente :name foi removida com sucesso.',
        'already_verified' => 'Este cliente já está verificado.',
        'already_unverified' => 'Este cliente não está verificado.',
        'upgrade_to_vendor_title' => 'Atualizar para Fornecedor',
        'upgrade_to_vendor_description' => 'Atualize este cliente para o status de fornecedor para permitir que ele liste e gerencie seus próprios aluguéis de carros.',
        'upgrade_to_vendor_button' => 'Atualizar para Fornecedor',
        'upgrade_to_vendor_confirmation' => 'Confirmar Atualização para Fornecedor',
        'upgrade_to_vendor_confirmation_desc' => 'Tem certeza de que deseja atualizar :name para o status de fornecedor? Isso permitirá que ele liste e gerencie seus próprios carros na plataforma.',
        'upgrade_to_vendor_success' => ':name foi atualizado com sucesso para o status de fornecedor.',
        'already_vendor' => 'Este cliente já é um fornecedor.',
        'customer_verified_successfully' => 'Este cliente foi verificado e é confiável.',
        'customer_not_verified_yet' => 'Este cliente ainda não foi verificado.',
        'verification_pending' => 'Verificação Pendente',
        'click_verify_to_approve' => 'Clique no botão abaixo para verificar este cliente e exibir o selo de verificação.',
        'verification_note' => 'Nota de Verificação',
        'verification_note_placeholder' => 'Digite quaisquer observações sobre esta ação de verificação...',
        'verification_note_helper' => 'Adicione notas sobre o processo de verificação (uso interno apenas)',
        'forms' => [
            'name' => 'Nome',
            'email' => 'E-mail',
            'phone' => 'Telefone',
            'whatsapp' => 'WhatsApp',
            'avatar' => 'Avatar',
            'dob' => 'Data de Nascimento',
            'company' => 'Empresa',
            'position' => 'Cargo',
            'password' => 'Senha',
            'password_confirmation' => 'Confirmação de senha',
            'change_password' => 'Alterar senha?',
            'phone_placeholder' => 'Telefone',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => 'Fornecedores',
        'view' => 'Visualizar :name',
        'information' => 'Informações do Fornecedor',
        'total_cars' => 'Total de Carros',
        'total_bookings' => 'Total de Reservas',
        'verified' => 'Verificado',
        'not_verified' => 'Não Verificado',
        'verification_section' => 'Verificação do Fornecedor',
        'vendor_verified_successfully' => 'Este fornecedor foi verificado e é confiável.',
        'vendor_not_verified_yet' => 'Este fornecedor ainda não foi verificado.',
        'verification_pending' => 'Verificação Pendente',
        'click_verify_to_approve' => 'Clique no botão abaixo para verificar este fornecedor e exibir o selo de verificação.',
        'verify_vendor' => 'Verificar Fornecedor',
        'unverify_vendor' => 'Remover Verificação do Fornecedor',
        'verify_vendor_confirmation' => 'Confirmação de Verificação do Fornecedor',
        'verify_vendor_confirmation_desc' => 'Tem certeza de que deseja verificar :name? Isso exibirá um selo de verificação no perfil dele.',
        'unverify_vendor_confirmation' => 'Confirmação de Remoção de Verificação',
        'unverify_vendor_confirmation_desc' => 'Tem certeza de que deseja remover a verificação de :name? O selo de verificação será removido.',
        'verified_successfully' => 'O fornecedor foi verificado com sucesso.',
        'unverified_successfully' => 'A verificação do fornecedor foi removida com sucesso.',
        'already_verified' => 'Este fornecedor já está verificado.',
        'not_verified_yet' => 'Este fornecedor ainda não foi verificado.',
        'recent_activity' => 'Atividade Recente',
        'recent_cars' => 'Carros Recentes',
        'recent_bookings' => 'Reservas Recentes',
        'no_cars_yet' => 'Nenhum carro adicionado ainda.',
        'no_bookings_yet' => 'Nenhuma reserva recebida ainda.',
    ],
    'make' => [
        'name' => 'Marcas',
        'create' => 'Criar Marca de Carro',
        'forms' => [
            'logo' => 'Logotipo',
            'logo_dark' => 'Logotipo Escuro',
        ],
    ],
    'car' => [
        'name' => 'Carros',
        'create' => 'Criar Carro',
        'forms' => [
            'car' => 'Carro',
            'logo' => 'Logotipo',
            'license_plate' => 'Placa',
            'make' => 'Marca',
            'model' => 'Modelo',
            'name' => 'Nome',
            'images' => 'Imagens',
            'year' => 'Ano',
            'color' => 'Cor',
            'mileage' => 'Quilometragem',
            'kilometers' => 'Quilômetros',
            'horsepower' => 'Potência',
            'vehicle_type' => 'Tipo de Veículo',
            'transmission' => 'Transmissão',
            'fuel_type' => 'Tipo de Combustível',
            'rental_rate' => 'Valor do Aluguel',
            'currency' => 'Moeda',
            'status' => 'Status',
            'availability' => 'Disponibilidade',
            'insurance_info' => 'Informações do seguro',
            'number_of_seats' => 'Número de Assentos',
            'number_of_doors' => 'Número de Portas',
            'vin' => 'Chassi',
            'maintenance_history' => 'Histórico de Manutenção',
            'location' => 'Localização',
            'description' => 'Descrição',
            'rental_type' => 'Tipo de Aluguel',
            'tags' => 'Tags',
            'add_new_attribute' => 'Adicionar novo <a href=":url" target="_blank">aqui</a>.',
            'categories' => 'Categorias',
            'pick_address' => 'Endereço de Retirada',
            'return_address' => 'Endereço de Devolução',
            'same_drop_off' => 'Mesma Devolução',
            'tax' => 'Imposto',
            'select_tax' => 'Selecionar Imposto',
            'none' => 'Nenhum',
            'colors' => 'Cores',
            'amenities' => 'Comodidades',
            'is_used' => 'É usado?',
            'moderation_status' => 'Status de moderação',
            'status_moderation' => [
                'approve' => 'Aprovar',
                'reject' => 'Rejeitar',
                'approve_title' => 'Aprovar carro',
                'approve_message' => 'Tem certeza de que deseja aprovar este carro? Esta ação não pode ser desfeita.',
                'reject_title' => 'Rejeitar carro',
                'reject_message' => 'Tem certeza de que deseja rejeitar este carro? Esta ação não pode ser desfeita.',
                'reject_reason' => 'Digite o motivo da rejeição',
                'approved' => 'Carro foi aprovado com sucesso!',
                'rejected' => 'Carro foi rejeitado com sucesso!',
                'reason_rejected' => 'Motivo da rejeição',
            ],
            'customer' => 'Cliente',
            'select_customer' => 'Selecione um cliente...',
            'vendor_images' => 'Imagens (Máximo :max imagens)',
            'images_upload_placeholder' => 'Solte os arquivos aqui ou clique para fazer upload.',
            'car_purpose' => 'Finalidade do Carro',
            'for_rent' => 'Para Alugar',
            'for_sale' => 'Para Vender',
            'car_type' => 'Tipo de Carro',
            'rental_information' => 'Informações de Aluguel',
            'sale_statuses' => [
                'available' => 'Disponível',
                'sold' => 'Vendido',
                'reserved' => 'Reservado',
            ],
            'selling_information' => 'Informações de Venda',
            'is_for_sale' => 'Disponível para venda',
            'sale_price' => 'Preço de Venda',
            'sale_price_placeholder' => 'Digite o preço de venda',
            'condition' => 'Condição',
            'select_condition' => 'Selecione a Condição',
            'condition_options' => [
                'new' => 'Novo',
                'like_new' => 'Como Novo',
                'excellent' => 'Excelente',
                'good' => 'Bom',
                'fair' => 'Regular',
                'poor' => 'Ruim',
            ],
            'ownership_history' => 'Histórico de Propriedade',
            'ownership_history_placeholder' => 'Digite o histórico de propriedade',
            'warranty_information' => 'Informações de Garantia',
            'warranty_information_placeholder' => 'Digite as informações de garantia',
            'sale_status' => 'Status de Venda',
            'external_booking_url' => 'Link de Reserva Externa',
            'external_booking_url_helper' => 'Digite a URL externa onde os clientes podem reservar este carro fora desta plataforma. Deixe em branco se a reserva estiver disponível apenas neste site.',
            'address' => 'Endereço',
            'address_helper' => 'Digite o endereço específico onde este veículo está localizado',
        ],
        'car_purposes' => [
            'sale' => 'Para Venda',
            'rent' => 'Para Aluguel',
        ],
        'placeholders' => [
            'name' => 'Digite o nome do veículo (ex: Toyota Camry 2023, Honda CR-V, etc.)',
            'description' => 'Digite uma breve descrição do veículo destacando as principais características',
            'rental_rate' => 'Digite o valor do aluguel com base no tipo de aluguel selecionado',
            'location' => 'Digite a localização física do veículo',
            'address' => 'Digite o endereço específico (ex: Rua Principal, 123, Cidade, Estado)',
            'sale_price' => 'Digite o preço de venda deste veículo',
            'ownership_history' => 'Digite detalhes sobre proprietários anteriores, número de proprietários, etc.',
            'warranty_information' => 'Digite detalhes sobre a cobertura da garantia, data de expiração, etc.',
            'external_booking_url' => 'https://exemplo.com/link-de-reserva',
            'license_plate' => 'Digite o número da placa do veículo',
            'vin' => 'Digite o Número de Identificação do Veículo (Chassi)',
            'year' => 'Digite o ano de fabricação (ex: 2023)',
            'mileage' => 'Digite a quilometragem atual',
            'kilometers' => 'Digite os quilômetros atuais',
            'horsepower' => 'Digite a potência (HP) do veículo (ex: 150.5)',
            'number_of_seats' => 'Digite o número de assentos no veículo',
            'number_of_doors' => 'Digite o número de portas que o veículo tem',
            'insurance_info' => 'Digite as informações de seguro relevantes para este veículo',
            'tags' => 'Selecione ou crie tags',
            'amenities' => 'Selecione comodidades',
            'colors' => 'Selecione ou crie cores',
        ],
        'enums' => [
            'vendor_status' => 'Status de Fornecedor',
            'is_vendor' => 'Fornecedor',
            'not_vendor' => 'Cliente',
            'statuses' => [
                'available' => 'Disponível',
                'rented' => 'Alugado',
                'maintenance' => 'Manutenção',
                'out_of_service' => 'Fora de Serviço',
            ],
            'rental_types' => [
                'per_hour' => 'Por hora',
                'per_day' => 'Por dia',
                'per_week' => 'Por semana',
                'per_month' => 'Por mês',
            ],
            'moderation_statuses' => [
                'pending' => 'Pendente',
                'approved' => 'Aprovado',
                'rejected' => 'Rejeitado',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Histórico de Manutenção',
            'create' => 'Criar Histórico de Serviço',
            'amount' => 'Valor',
            'forms' => [
                'price_placeholder' => 'Preço do serviço',
                'currency' => 'Moeda',
                'none' => 'Nenhum',
                'name' => 'Nome',
                'amount' => 'Valor',
                'created_at' => 'Criado Em',
                'action' => 'Ação',
                'date' => 'Data',
                'no_maintenance_history' => 'Sem histórico de manutenção',
                'edit_maintenance_history' => 'Editar histórico de manutenção',
                'add_maintenance_history' => 'Adicionar histórico de manutenção',
                'add' => 'Adicionar',
                'edit' => 'Editar',
                'delete' => 'Excluir',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Atributos do Carro',
        'car_type' => [
            'name' => 'Tipos',
            'create' => 'Criar Tipo de Carro',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'transmission' => [
            'name' => 'Transmissões',
            'create' => 'Criar Transmissão',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'fuel_type' => [
            'name' => 'Combustíveis',
            'create' => 'Criar Tipo de Combustível',
            'forms' => [
                'name' => 'Nome',
            ],
        ],
        'tag' => [
            'name' => 'Tags',
            'create' => 'Criar Tag',
        ],
        'category' => [
            'name' => 'Categorias',
            'create' => 'Criar Categoria',
            'forms' => [
                'none' => 'Nenhum',
                'total_cars' => 'Total de carros: :total',
            ],
        ],
        'address' => [
            'name' => 'Localizações',
            'create' => 'Criar Localização de Carro',
            'form' => [
                'name' => 'Endereço',
                'full_address' => 'Endereço Completo',
                'detail_address' => 'Detalhes do Endereço',
            ],
        ],
        'color' => [
            'name' => 'Cor',
            'create' => 'Criar Cor',
        ],
        'amenity' => [
            'name' => 'Comodidades',
            'create' => 'Criar Comodidade',
        ],
    ],
    'tax' => [
        'name' => 'Impostos',
        'create' => 'Criar Imposto',
        'forms' => [
            'name' => 'Nome',
            'name_placeholder' => 'Digite o nome',
            'percentage' => 'Porcentagem',
            'percentage_placeholder' => 'Porcentagem',
            'percent_placeholder' => 'Porcentagem',
            'priority' => 'Prioridade',
            'priority_placeholder' => 'Prioridade',
        ],
    ],
    'review' => [
        'name' => 'Avaliações',
        'create' => 'Criar Avaliação',
        'edit' => 'Editar Avaliação',
        'vendor' => [
            'title' => 'Avaliações de Clientes',
            'description' => 'Gerencie todas as avaliações de clientes para seus carros',
            'no_reviews' => 'Você ainda não tem avaliações',
            'filter_by_car' => 'Filtrar por carro',
            'filter_by_rating' => 'Filtrar por classificação',
            'filter_by_date' => 'Filtrar por data',
            'all_cars' => 'Todos os Carros',
            'all_ratings' => 'Todas as Classificações',
            'manage_reviews' => 'Gerenciar Avaliações',
            'view_all' => 'Ver Todas as Avaliações',
            'delete_review_confirmation' => 'Tem certeza de que deseja excluir esta avaliação?',
            'delete_review_success' => 'Avaliação excluída com sucesso',
            'cannot_delete' => 'Não é possível excluir esta avaliação',
        ],
        'forms' => [
            'customer' => 'Cliente',
            'car' => 'Carro',
            'content' => 'Conteúdo',
            'rating' => 'Classificação',
            'your_name' => 'Seu Nome',
            'email_address' => 'Endereço de E-mail',
            'submit' => 'Enviar',
            'star' => 'Estrela',
            'status' => 'Status',
            'created_at' => 'Criado Em',
            'select_car' => 'Selecionar Carro',
            'select_rating' => 'Selecionar Classificação',
            'comment' => 'Comentário',
            'reply' => 'Responder',
            'reply_to_review' => 'Responder à Avaliação',
            'save_reply' => 'Salvar Resposta',
            'cancel_reply' => 'Cancelar',
        ],
        'statuses' => [
            'published' => 'Publicado',
            'pending' => 'Pendente',
            'rejected' => 'Rejeitado',
        ],
        'ratings' => [
            1 => '1 Estrela - Ruim',
            '2 Estrelas - Regular',
            '3 Estrelas - Bom',
            '4 Estrelas - Muito Bom',
            '5 Estrelas - Excelente',
        ],
    ],
    'coupon' => [
        'name' => 'Cupons',
        'create' => 'Criar Cupom',
        'types' => [
            'percentage' => 'Porcentagem %',
            'money' => 'Dinheiro',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => 'Serviços',
        'create' => 'Criar Serviço',
        'forms' => [
            'name' => 'Nome',
            'content' => 'Conteúdo',
            'price' => 'Preço',
            'currency' => 'Moeda',
            'image' => 'Imagem',
            'logo' => 'Logotipo',
            'status' => 'Status',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Calendário de Disponibilidade',
        'title' => 'Calendário de Disponibilidade',
        'description' => 'Visualize a disponibilidade de carros e reservas em formato de calendário',
        'select_dates' => 'Selecione as datas para verificar a disponibilidade',
        'car_filter' => 'Filtrar por Carro',
        'all_cars' => 'Todos os Carros',
        'clear_filter' => 'Limpar Filtro',
        'availability_check' => 'Verificação de Disponibilidade do Carro',
        'selected_period' => 'Período Selecionado',
        'checking_availability' => 'Verificando disponibilidade...',
        'available' => 'Disponível',
        'not_available' => 'Não Disponível',
        'booking_details' => 'Detalhes da Reserva',
        'how_to_use' => 'Como Usar o Calendário de Disponibilidade de Carros',
        'viewing_bookings' => 'Visualizando Reservas',
        'checking_availability_help' => 'Verificando Disponibilidade',
        'color_legend' => 'Legenda de Cores',
        'pending_bookings' => 'Reservas Pendentes',
        'processing_bookings' => 'Reservas em Processamento',
        'completed_bookings' => 'Reservas Concluídas',
        'cancelled_bookings' => 'Reservas Canceladas',
        'unknown_make' => 'Marca Desconhecida',
        'loading' => 'Carregando...',
        'loading_calendar_data' => 'Carregando dados do calendário...',
        'loading_booking_details' => 'Carregando detalhes da reserva...',
        'please_wait_booking_info' => 'Aguarde enquanto buscamos as informações da reserva.',
        'please_wait_availability' => 'Aguarde enquanto verificamos a disponibilidade do carro para as datas selecionadas.',
        'error' => 'Erro',
        'error_loading_booking' => 'Falha ao carregar detalhes da reserva. Por favor, tente novamente.',
        'error_checking_availability' => 'Erro ao verificar a disponibilidade do carro',
        'customer' => 'Cliente',
        'status' => 'Status',
        'amount' => 'Valor',
        'make' => 'Marca',
        'vendor' => 'Fornecedor',
        'per_day' => '/dia',
        'edit_car' => 'Editar Carro',
        'no_cars_found' => 'Nenhum carro encontrado',
        'no_cars_available_period' => 'Não há carros disponíveis para o período selecionado.',
        'close' => 'Fechar',
        'edit_booking' => 'Editar Reserva',
        'pending' => 'Pendente',
        'processing' => 'Processando',
        'completed' => 'Concluído',
        'cancelled' => 'Cancelado',
    ],
    'theme_options' => [
        'name' => 'Aluguel de Carros',
        'description' => 'Opções de tema para aluguel de carros',
        'car_location_filter_by' => 'Filtro de localização de carros por',
        'state' => 'Estado',
        'city' => 'Cidade',
        'yes' => 'Sim',
        'no' => 'Não',
        'is_display_country' => 'Exibir país no filtro de localização?',
        'logo_vendor_dashboard' => 'Logotipo no painel do fornecedor (Padrão é o logotipo principal)',
        'number_of_cars_per_page' => 'Número de carros por página',
        'number_of_cars_per_page_placeholder' => 'Digite o número de carros a serem exibidos por página',
    ],
    'message' => [
        'name' => 'Mensagens',
        'forms' => [
            'customer_name' => 'Nome do cliente',
            'message' => 'Mensagem',
            'phone' => 'Telefone',
            'email' => 'E-mail',
            'created_at' => 'Criado em',
            'status' => 'Status',
        ],
    ],
    'car_sale' => [
        'name' => 'Vendas de Carros',
        'create' => 'Nova Venda de Carro',
        'edit' => 'Editar Venda de Carro :name',
        'statuses' => [
            'pending' => 'Pendente',
            'processing' => 'Processando',
            'completed' => 'Concluído',
            'cancelled' => 'Cancelado',
        ],
        'forms' => [
            'transaction_id' => 'ID da Transação',
            'transaction_id_placeholder' => 'Digite o ID da transação',
            'car_id' => 'Carro',
            'car' => 'Carro',
            'customer_id' => 'Cliente',
            'customer_name' => 'Nome do Cliente',
            'customer_name_placeholder' => 'Digite o nome do cliente',
            'customer_email' => 'E-mail do Cliente',
            'customer_email_placeholder' => 'Digite o e-mail do cliente',
            'customer_phone' => 'Telefone do Cliente',
            'customer_phone_placeholder' => 'Digite o telefone do cliente',
            'sale_price' => 'Preço de Venda',
            'sale_price_placeholder' => 'Digite o preço de venda',
            'tax_amount' => 'Valor do Imposto',
            'tax_amount_placeholder' => 'Digite o valor do imposto',
            'total_amount' => 'Valor Total',
            'total_amount_placeholder' => 'Digite o valor total',
            'payment_details' => 'Detalhes do Pagamento',
            'payment_details_placeholder' => 'Digite os detalhes do pagamento',
            'notes' => 'Observações',
            'notes_placeholder' => 'Digite as observações',
            'sale_date' => 'Data da Venda',
            'delivery_date' => 'Data de Entrega',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Transferência Bancária',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        'booking_confirm_title' => 'Confirmação de Reserva de Aluguel de Carro',
        'booking_confirm_greeting' => 'Prezado(a) :customer_name,',
        'booking_confirm_message' => 'Temos o prazer de informar que sua reserva de aluguel de carro foi confirmada com sucesso!',
        'customer_information' => 'Informações do Cliente',
        'booking_information' => 'Informações da Reserva',
        'field_name' => 'Nome:',
        'field_phone' => 'Telefone:',
        'field_email' => 'E-mail:',
        'field_car_model' => 'Modelo do Carro:',
        'field_start_date' => 'Data de Início:',
        'field_end_date' => 'Data de Término:',
        'field_pickup_address' => 'Endereço de Retirada:',
        'field_return_address' => 'Endereço de Devolução:',
        'field_note' => 'Observação:',
        'field_order_number' => 'Número do pedido',
        'field_payment_method' => 'Método de Pagamento',
        'booking_notice_admin_title' => 'Notificação de Nova Reserva',
        'booking_notice_admin_greeting' => 'Olá, há uma nova reserva de :site_title:',
        'booking_notice_admin_message' => 'Uma nova reserva de aluguel de carro foi enviada e requer sua atenção.',
        'booking_view_detail' => 'Ver detalhes da reserva:',
        'view_booking_details' => 'Ver Detalhes da Reserva',
        'booking_notice_vendor_title' => 'Nova Reserva para Seu Carro',
        'booking_notice_vendor_greeting' => 'Prezado(a) :vendor_name,',
        'booking_notice_vendor_message' => 'Ótimas notícias! Você recebeu uma nova reserva para o aluguel do seu carro.',
        'booking_status_updated' => 'Status da Reserva Atualizado',
        'hello_thanks_for_booking' => 'Olá, Obrigado por reservar quartos de :site_title:',
        'booking_status_change_message' => 'Esperamos que esta mensagem o encontre bem. Queríamos informar que o status da sua reserva foi atualizado.',
        'name' => 'Nome',
        'phone' => 'Telefone',
        'email' => 'E-mail',
        'car_model' => 'Modelo do Carro',
        'start_date' => 'Data de Início',
        'end_date' => 'Data de Término',
        'pickup_address' => 'Endereço de Retirada',
        'return_address' => 'Endereço de Devolução',
        'note' => 'Observação',
        'order_number' => 'Número do pedido',
        'payment_method' => 'Método de Pagamento',
        'hello' => 'Olá',
        'car_approved_title' => 'Ótimas Notícias! Seu Carro Foi Aprovado',
        'car_approved_message' => 'Temos o prazer de informar que seu anúncio de carro ":car_name" foi aprovado e agora está ativo em :site_title. Você pode começar a receber reservas e gerenciar seu anúncio imediatamente.',
        'view_edit_car_link' => 'Para visualizar ou editar seu anúncio de carro, clique neste link',
        'view_car' => 'Ver Anúncio do Carro',
        'regards' => 'Atenciosamente',
        'vendor_upgrade_title' => 'Parabéns! Você Agora É um Fornecedor',
        'vendor_upgrade_congratulations' => 'Estamos muito felizes em informar que sua conta foi atualizada com sucesso para o status de fornecedor!',
        'vendor_upgrade_message' => 'Agora você pode listar e gerenciar seus próprios carros em :site_title. Isso abre novas oportunidades para você expandir seu negócio de aluguel conosco.',
        'vendor_benefits_title' => 'Seus Novos Benefícios de Fornecedor',
        'vendor_benefit_1' => 'Listar carros ilimitados para aluguel',
        'vendor_benefit_2' => 'Gerenciar suas próprias reservas e clientes',
        'vendor_benefit_3' => 'Acompanhar receitas e métricas de desempenho',
        'vendor_benefit_4' => 'Acesso a recursos e ferramentas exclusivos para fornecedores',
        'next_steps' => 'Próximos Passos',
        'vendor_next_steps_message' => 'Faça login no painel do fornecedor para começar a adicionar seus carros e gerenciar seu negócio de aluguel.',
        'go_to_dashboard' => 'Ir para o Painel do Fornecedor',
        'vendor_support_message' => 'Se você tiver alguma dúvida ou precisar de assistência, nossa equipe de suporte está aqui para ajudá-lo a começar.',
        'approved' => 'Aprovado',
        'car_rejected_title' => 'Atualização Necessária para Seu Anúncio de Carro',
        'car_rejected_message' => 'Obrigado por enviar seu anúncio de carro ":car_name" para :site_title. Após revisar seu envio, precisamos que você faça alguns ajustes antes que possamos aprová-lo.',
        'rejection_reason' => 'Aqui está o que precisa ser atualizado',
        'rejection_details' => 'Atualizações Necessárias',
        'contact_support' => 'Se você tiver alguma dúvida ou precisar de assistência com essas atualizações, não hesite em entrar em contato com nossa equipe de suporte em :site_email. Estamos aqui para ajudá-lo a ter seu anúncio aprovado rapidamente.',
        'verify_email' => 'Verificar E-mail',
        'welcome_message' => 'Estamos felizes em tê-lo aqui, :customer_name!',
        'verify_email_instruction' => 'Por favor, verifique seu endereço de e-mail para acessar este site. Clique no botão abaixo para verificar seu e-mail.',
        'confirm_email_button' => 'Confirmar seu endereço de e-mail',
        'verify_link_trouble' => 'Se você estiver tendo problemas ao clicar no botão \'Confirmar seu endereço de e-mail\', copie e cole a URL abaixo em seu navegador: :verify_link e cole-a em seu navegador.',
        'new_message' => 'Nova Mensagem',
        'dear_admin' => 'Prezado Administrador',
        'new_message_from' => 'Há uma nova mensagem de :site_title:',
        'subject' => 'Assunto',
        'address' => 'Endereço',
        'content' => 'Conteúdo',
        'hi_admin' => 'Olá Administrador,',
        'new_car_pending_title' => 'Novo Anúncio de Carro Aguardando Revisão',
        'new_car_pending_approval' => 'Um novo anúncio de carro ":post_name" foi enviado por :post_author e está pronto para sua revisão.',
        'pending_approval' => 'Aguardando Revisão',
        'review_car_admin' => 'Revise este anúncio no painel administrativo e aprove ou solicite atualizações conforme necessário.',
        'car_information' => 'Informações do Carro',
        'field_car_name' => 'Nome do Carro:',
        'field_author' => 'Autor:',
        'field_status' => 'Status:',
        'actions' => 'Ações',
        'reset_password_instruction' => 'Instruções para Redefinir a Senha',
        'password_reset_request' => 'Você está recebendo este e-mail porque recebemos uma solicitação de redefinição de senha para sua conta.',
        'reset_password_button' => 'Redefinir senha',
        'reset_link_trouble' => 'Se você estiver tendo problemas ao clicar no botão \'Redefinir Senha\', copie e cole a URL abaixo em seu navegador: :reset_link e cole-a em seu navegador. Se você não solicitou uma redefinição de senha, ignore esta mensagem ou entre em contato conosco se tiver alguma dúvida.',
    ],
];
