<?php

return [
    'name' => 'Оренда автомобілів',
    'customer' => [
        'name' => 'Клієнти',
        'create' => 'Створити клієнта',
        'view' => 'Переглянути',
        'information' => 'Інформація про клієнта',
        'email' => 'Електронна пошта',
        'phone' => 'Телефон',
        'status' => 'Статус',
        'vendor_status' => 'Статус постачальника',
        'is_vendor' => 'Постачальник',
        'not_vendor' => 'Клієнт',
        'recent_activity' => 'Останні дії',
        'recent_activity_description' => 'Активність клієнта з\'явиться тут.',
        'verification_section' => 'Підтвердження клієнта',
        'verified' => 'Підтверджено',
        'not_verified' => 'Не підтверджено',
        'verified_by' => 'Підтверджено',
        'verified_at' => 'Підтверджено о',
        'verify_customer' => 'Підтвердити клієнта',
        'unverify_customer' => 'Скасувати підтвердження клієнта',
        'verify_customer_confirmation' => 'Підтвердження підтвердження клієнта',
        'verify_customer_confirmation_desc' => 'Ви впевнені, що хочете підтвердити :name? Це відобразить значок підтвердження в їхньому профілі.',
        'unverify_customer_confirmation' => 'Підтвердження скасування підтвердження клієнта',
        'unverify_customer_confirmation_desc' => 'Ви впевнені, що хочете видалити підтвердження з :name? Значок підтвердження буде видалено.',
        'verify_success' => 'Клієнт :name успішно підтверджений.',
        'unverify_success' => 'Підтвердження клієнта :name успішно видалено.',
        'already_verified' => 'Цей клієнт вже підтверджений.',
        'already_unverified' => 'Цей клієнт не підтверджений.',
        'customer_verified_successfully' => 'Цей клієнт підтверджений і йому можна довіряти.',
        'customer_not_verified_yet' => 'Цей клієнт ще не підтверджений.',
        'verification_pending' => 'Очікує підтвердження',
        'click_verify_to_approve' => 'Натисніть кнопку нижче, щоб підтвердити цього клієнта та відобразити значок підтвердження.',
        'verification_note' => 'Примітка про підтвердження',
        'verification_note_placeholder' => 'Введіть будь-які примітки про цю дію підтвердження...',
        'verification_note_helper' => 'Додайте примітки про процес підтвердження (лише для внутрішнього використання)',
        'forms' => [
            'name' => 'Ім\'я',
            'email' => 'Електронна пошта',
            'phone' => 'Телефон',
            'avatar' => 'Аватар',
            'dob' => 'Дата народження',
            'company' => 'Компанія',
            'position' => 'Посада',
            'password' => 'Пароль',
            'password_confirmation' => 'Підтвердження пароля',
            'change_password' => 'Змінити пароль?',
            'phone_placeholder' => 'Телефон',
        ],
    ],
    'vendor' => [
        'name' => 'Постачальники',
        'view' => 'Переглянути :name',
        'information' => 'Інформація про постачальника',
        'total_cars' => 'Всього автомобілів',
        'total_bookings' => 'Всього бронювань',
        'verified' => 'Підтверджено',
        'not_verified' => 'Не підтверджено',
        'verification_section' => 'Підтвердження постачальника',
        'vendor_verified_successfully' => 'Цей постачальник підтверджений і йому можна довіряти.',
        'vendor_not_verified_yet' => 'Цей постачальник ще не підтверджений.',
        'verification_pending' => 'Очікує підтвердження',
        'click_verify_to_approve' => 'Натисніть кнопку нижче, щоб підтвердити цього постачальника та відобразити значок підтвердження.',
        'verify_vendor' => 'Підтвердити постачальника',
        'unverify_vendor' => 'Скасувати підтвердження постачальника',
        'verify_vendor_confirmation' => 'Підтвердження підтвердження постачальника',
        'verify_vendor_confirmation_desc' => 'Ви впевнені, що хочете підтвердити :name? Це відобразить значок підтвердження в їхньому профілі.',
        'unverify_vendor_confirmation' => 'Підтвердження скасування підтвердження постачальника',
        'unverify_vendor_confirmation_desc' => 'Ви впевнені, що хочете видалити підтвердження з :name? Значок підтвердження буде видалено.',
        'verified_successfully' => 'Постачальника успішно підтверджено.',
        'unverified_successfully' => 'Підтвердження постачальника успішно видалено.',
        'already_verified' => 'Цей постачальник вже підтверджений.',
        'not_verified_yet' => 'Цей постачальник ще не підтверджений.',
        'recent_activity' => 'Останні дії',
        'recent_cars' => 'Останні автомобілі',
        'recent_bookings' => 'Останні бронювання',
        'no_cars_yet' => 'Автомобілі ще не додані.',
        'no_bookings_yet' => 'Бронювання ще не отримані.',
    ],
    'make' => [
        'name' => 'Марки',
        'create' => 'Створити марку автомобіля',
        'forms' => [
            'logo' => 'Логотип',
            'logo_dark' => 'Темний логотип',
        ],
    ],
    'car' => [
        'name' => 'Автомобілі',
        'create' => 'Створити автомобіль',
        'forms' => [
            'car' => 'Автомобіль',
            'logo' => 'Логотип',
            'license_plate' => 'Номерний знак',
            'make' => 'Марка',
            'model' => 'Модель',
            'name' => 'Назва',
            'images' => 'Зображення',
            'year' => 'Рік',
            'color' => 'Колір',
            'mileage' => 'Пробіг',
            'kilometers' => 'Кілометри',
            'horsepower' => 'Потужність',
            'vehicle_type' => 'Тип транспортного засобу',
            'transmission' => 'Трансмісія',
            'fuel_type' => 'Тип пального',
            'rental_rate' => 'Тариф оренди',
            'currency' => 'Валюта',
            'status' => 'Статус',
            'availability' => 'Доступність',
            'insurance_info' => 'Інформація про страхування',
            'number_of_seats' => 'Кількість місць',
            'number_of_doors' => 'Кількість дверей',
            'vin' => 'VIN',
            'maintenance_history' => 'Історія обслуговування',
            'location' => 'Місцезнаходження',
            'description' => 'Опис',
            'rental_type' => 'Тип оренди',
            'tags' => 'Теги',
            'add_new_attribute' => 'Додати новий <a href=":url" target="_blank">тут</a>.',
            'categories' => 'Категорії',
            'pick_address' => 'Адреса отримання',
            'return_address' => 'Адреса повернення',
            'same_drop_off' => 'Та сама адреса повернення',
            'tax' => 'Податок',
            'select_tax' => 'Вибрати податок',
            'none' => 'Немає',
            'colors' => 'Кольори',
            'amenities' => 'Зручності',
            'is_used' => 'Вживаний?',
            'moderation_status' => 'Статус модерації',
            'status_moderation' => [
                'approve' => 'Схвалити',
                'reject' => 'Відхилити',
                'approve_title' => 'Схвалити автомобіль',
                'approve_message' => 'Ви впевнені, що хочете схвалити цей автомобіль? Цю дію неможливо скасувати.',
                'reject_title' => 'Відхилити автомобіль',
                'reject_message' => 'Ви впевнені, що хочете відхилити цей автомобіль? Цю дію неможливо скасувати.',
                'reject_reason' => 'Введіть причину відхилення',
                'approved' => 'Автомобіль успішно схвалено!',
                'rejected' => 'Автомобіль успішно відхилено!',
                'reason_rejected' => 'Причина відхилення',
            ],
            'customer' => 'Клієнт',
            'select_customer' => 'Вибрати клієнта...',
            'vendor_images' => 'Зображення (Максимум :max зображень)',
            'images_upload_placeholder' => 'Перетягніть файли сюди або натисніть для завантаження.',
            'car_purpose' => 'Призначення автомобіля',
            'for_rent' => 'На оренду',
            'for_sale' => 'На продаж',
            'car_type' => 'Тип автомобіля',
            'rental_information' => 'Інформація про оренду',
            'sale_statuses' => [
                'available' => 'Доступний',
                'sold' => 'Продано',
                'reserved' => 'Зарезервовано',
            ],
            'selling_information' => 'Інформація про продаж',
            'is_for_sale' => 'Доступний для продажу',
            'sale_price' => 'Ціна продажу',
            'sale_price_placeholder' => 'Введіть ціну продажу',
            'condition' => 'Стан',
            'select_condition' => 'Виберіть стан',
            'condition_options' => [
                'new' => 'Новий',
                'like_new' => 'Як новий',
                'excellent' => 'Відмінний',
                'good' => 'Хороший',
                'fair' => 'Задовільний',
                'poor' => 'Поганий',
            ],
            'ownership_history' => 'Історія власності',
            'ownership_history_placeholder' => 'Введіть історію власності',
            'warranty_information' => 'Інформація про гарантію',
            'warranty_information_placeholder' => 'Введіть інформацію про гарантію',
            'sale_status' => 'Статус продажу',
            'external_booking_url' => 'Зовнішнє посилання для бронювання',
            'external_booking_url_helper' => 'Введіть зовнішній URL, де клієнти можуть забронювати цей автомобіль поза цією платформою. Залиште порожнім, якщо бронювання доступне лише на цьому сайті.',
            'address' => 'Адреса',
            'address_helper' => 'Введіть конкретну адресу, де знаходиться цей транспортний засіб',
        ],
        'car_purposes' => [
            'sale' => 'На продаж',
            'rent' => 'На оренду',
        ],
        'placeholders' => [
            'name' => 'Введіть назву транспортного засобу (наприклад, Toyota Camry 2023, Honda CR-V тощо)',
            'description' => 'Введіть короткий опис транспортного засобу, підкресливши ключові особливості',
            'rental_rate' => 'Введіть тариф оренди на основі вибраного типу оренди',
            'location' => 'Введіть фізичне місцезнаходження транспортного засобу',
            'address' => 'Введіть конкретну адресу (наприклад, вул. Головна 123, Місто, Область)',
            'sale_price' => 'Введіть ціну продажу для цього транспортного засобу',
            'ownership_history' => 'Введіть деталі про попередніх власників, кількість власників тощо',
            'warranty_information' => 'Введіть деталі про гарантійне покриття, дату закінчення тощо',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => 'Введіть номерний знак транспортного засобу',
            'vin' => 'Введіть ідентифікаційний номер транспортного засобу (VIN)',
            'year' => 'Введіть рік виробництва (наприклад, 2023)',
            'mileage' => 'Введіть поточний пробіг',
            'kilometers' => 'Введіть поточні кілометри',
            'horsepower' => 'Введіть потужність (к.с.) транспортного засобу (наприклад, 150.5)',
            'number_of_seats' => 'Введіть кількість місць у транспортному засобі',
            'number_of_doors' => 'Введіть кількість дверей транспортного засобу',
            'insurance_info' => 'Введіть відповідну інформацію про страхування для цього транспортного засобу',
            'tags' => 'Виберіть або створіть теги',
            'amenities' => 'Виберіть зручності',
            'colors' => 'Виберіть або створіть кольори',
        ],
        'enums' => [
            'statuses' => [
                'available' => 'Доступний',
                'rented' => 'Орендований',
                'maintenance' => 'Обслуговування',
                'out_of_service' => 'Не в експлуатації',
            ],
            'rental_types' => [
                'per_hour' => 'За годину',
                'per_day' => 'За день',
                'per_week' => 'За тиждень',
                'per_month' => 'За місяць',
            ],
            'moderation_statuses' => [
                'pending' => 'Очікує',
                'approved' => 'Схвалено',
                'rejected' => 'Відхилено',
            ],
        ],
        'maintenance_history' => [
            'name' => 'Історії обслуговування',
            'create' => 'Створити історію обслуговування',
            'amount' => 'Сума',
            'forms' => [
                'price_placeholder' => 'Ціна послуги',
                'currency' => 'Валюта',
                'none' => 'Немає',
                'name' => 'Назва',
                'amount' => 'Сума',
                'created_at' => 'Створено',
                'action' => 'Дія',
                'date' => 'Дата',
                'no_maintenance_history' => 'Немає історій обслуговування',
                'edit_maintenance_history' => 'Редагувати історію обслуговування',
                'add_maintenance_history' => 'Додати історію обслуговування',
                'add' => 'Додати',
                'edit' => 'Редагувати',
                'delete' => 'Видалити',
            ],
        ],
    ],
    'attribute' => [
        'name' => 'Атрибути автомобіля',
        'car_type' => [
            'name' => 'Типи',
            'create' => 'Створити тип автомобіля',
            'forms' => [
                'name' => 'Назва',
            ],
        ],
        'transmission' => [
            'name' => 'Трансмісії',
            'create' => 'Створити трансмісію',
            'forms' => [
                'name' => 'Назва',
            ],
        ],
        'fuel_type' => [
            'name' => 'Пальне',
            'create' => 'Створити типи пального',
            'forms' => [
                'name' => 'Назва',
            ],
        ],
        'tag' => [
            'name' => 'Теги',
            'create' => 'Створити тег',
        ],
        'category' => [
            'name' => 'Категорії',
            'create' => 'Створити категорію',
            'forms' => [
                'none' => 'Немає',
                'total_cars' => 'Всього автомобілів: :total',
            ],
        ],
        'address' => [
            'name' => 'Місцезнаходження',
            'create' => 'Створити місцезнаходження автомобіля',
            'form' => [
                'name' => 'Адреса',
                'full_address' => 'Повна адреса',
                'detail_address' => 'Детальна адреса',
            ],
        ],
        'color' => [
            'name' => 'Колір',
            'create' => 'Створити колір',
        ],
        'amenity' => [
            'name' => 'Зручності',
            'create' => 'Створити зручність',
        ],
    ],
    'tax' => [
        'name' => 'Податки',
        'create' => 'Створити податок',
        'forms' => [
            'name' => 'Назва',
            'name_placeholder' => 'Введіть назву',
            'percentage' => 'Відсоток',
            'percentage_placeholder' => 'Відсоток',
            'percent_placeholder' => 'Відсоток',
            'priority' => 'Пріоритет',
            'priority_placeholder' => 'Пріоритет',
        ],
    ],
    'review' => [
        'name' => 'Відгуки',
        'create' => 'Створити відгук',
        'edit' => 'Редагувати відгук',
        'vendor' => [
            'title' => 'Відгуки клієнтів',
            'description' => 'Керування всіма відгуками клієнтів для ваших автомобілів',
            'no_reviews' => 'У вас ще немає відгуків',
            'filter_by_car' => 'Фільтрувати за автомобілем',
            'filter_by_rating' => 'Фільтрувати за рейтингом',
            'filter_by_date' => 'Фільтрувати за датою',
            'all_cars' => 'Всі автомобілі',
            'all_ratings' => 'Всі рейтинги',
            'manage_reviews' => 'Керування відгуками',
            'view_all' => 'Переглянути всі відгуки',
            'delete_review_confirmation' => 'Ви впевнені, що хочете видалити цей відгук?',
            'delete_review_success' => 'Відгук успішно видалено',
            'cannot_delete' => 'Неможливо видалити цей відгук',
        ],
        'forms' => [
            'customer' => 'Клієнт',
            'car' => 'Автомобіль',
            'content' => 'Зміст',
            'rating' => 'Рейтинг',
            'your_name' => 'Ваше ім\'я',
            'email_address' => 'Адреса електронної пошти',
            'submit' => 'Надіслати',
            'star' => 'Зірка',
            'status' => 'Статус',
            'created_at' => 'Створено',
            'select_car' => 'Вибрати автомобіль',
            'select_rating' => 'Вибрати рейтинг',
            'comment' => 'Коментар',
            'reply' => 'Відповісти',
            'reply_to_review' => 'Відповісти на відгук',
            'save_reply' => 'Зберегти відповідь',
            'cancel_reply' => 'Скасувати',
        ],
        'statuses' => [
            'published' => 'Опубліковано',
            'pending' => 'Очікує',
            'rejected' => 'Відхилено',
        ],
        'ratings' => [
            '1' => '1 зірка - Погано',
            '2' => '2 зірки - Задовільно',
            '3' => '3 зірки - Добре',
            '4' => '4 зірки - Дуже добре',
            '5' => '5 зірок - Відмінно',
        ],
    ],
    'coupon' => [
        'name' => 'Купони',
        'create' => 'Створити купон',
        'types' => [
            'percentage' => 'Відсоток %',
            'money' => 'Гроші',
        ],
        'forms' => [
            //
        ],
    ],
    'service' => [
        'name' => 'Послуги',
        'create' => 'Створити послугу',
        'forms' => [
            'name' => 'Назва',
            'content' => 'Зміст',
            'price' => 'Ціна',
            'currency' => 'Валюта',
            'image' => 'Зображення',
            'logo' => 'Логотип',
            'status' => 'Статус',
        ],
    ],
    'availability_calendar' => [
        'name' => 'Календар доступності',
        'title' => 'Календар доступності',
        'description' => 'Переглядати доступність автомобілів та бронювання у форматі календаря',
        'select_dates' => 'Виберіть дати для перевірки доступності',
        'car_filter' => 'Фільтр за автомобілем',
        'all_cars' => 'Всі автомобілі',
        'clear_filter' => 'Очистити фільтр',
        'availability_check' => 'Перевірка доступності автомобіля',
        'selected_period' => 'Вибраний період',
        'checking_availability' => 'Перевірка доступності...',
        'available' => 'Доступний',
        'not_available' => 'Недоступний',
        'booking_details' => 'Деталі бронювання',
        'how_to_use' => 'Як використовувати календар доступності автомобілів',
        'viewing_bookings' => 'Перегляд бронювань',
        'checking_availability_help' => 'Перевірка доступності',
        'color_legend' => 'Легенда кольорів',
        'pending_bookings' => 'Очікуючі бронювання',
        'processing_bookings' => 'Обробка бронювань',
        'completed_bookings' => 'Завершені бронювання',
        'cancelled_bookings' => 'Скасовані бронювання',
        'unknown_make' => 'Невідома марка',
        'loading' => 'Завантаження...',
        'loading_calendar_data' => 'Завантаження даних календаря...',
        'loading_booking_details' => 'Завантаження деталей бронювання...',
        'please_wait_booking_info' => 'Будь ласка, зачекайте, поки ми отримаємо інформацію про бронювання.',
        'please_wait_availability' => 'Будь ласка, зачекайте, поки ми перевіримо доступність автомобіля для вибраних дат.',
        'error' => 'Помилка',
        'error_loading_booking' => 'Не вдалося завантажити деталі бронювання. Будь ласка, спробуйте ще раз.',
        'error_checking_availability' => 'Помилка перевірки доступності автомобіля',
        'customer' => 'Клієнт',
        'status' => 'Статус',
        'amount' => 'Сума',
        'make' => 'Марка',
        'vendor' => 'Постачальник',
        'per_day' => '/день',
        'edit_car' => 'Редагувати автомобіль',
        'no_cars_found' => 'Автомобілі не знайдені',
        'no_cars_available_period' => 'Немає доступних автомобілів для вибраного періоду.',
        'close' => 'Закрити',
        'edit_booking' => 'Редагувати бронювання',
        'pending' => 'Очікує',
        'processing' => 'Обробляється',
        'completed' => 'Завершено',
        'cancelled' => 'Скасовано',
    ],
    'theme_options' => [
        'name' => 'Оренда автомобілів',
        'description' => 'Параметри теми для оренди автомобілів',
        'car_location_filter_by' => 'Фільтр місцезнаходження автомобіля за',
        'state' => 'Область',
        'city' => 'Місто',
        'yes' => 'Так',
        'no' => 'Ні',
        'is_display_country' => 'Відображати країну у фільтрі місцезнаходження?',
        'logo_vendor_dashboard' => 'Логотип у панелі постачальника (За замовчуванням головний логотип)',
        'number_of_cars_per_page' => 'Кількість автомобілів на сторінці',
        'number_of_cars_per_page_placeholder' => 'Введіть кількість автомобілів для відображення на сторінці',
    ],
    'message' => [
        'name' => 'Повідомлення',
        'forms' => [
            'customer_name' => 'Ім\'я клієнта',
            'message' => 'Повідомлення',
            'phone' => 'Телефон',
            'email' => 'Електронна пошта',
            'created_at' => 'Створено',
            'status' => 'Статус',
        ],
    ],
    'car_sale' => [
        'name' => 'Продажі автомобілів',
        'create' => 'Новий продаж автомобіля',
        'edit' => 'Редагувати продаж автомобіля :name',
        'statuses' => [
            'pending' => 'Очікує',
            'processing' => 'Обробляється',
            'completed' => 'Завершено',
            'cancelled' => 'Скасовано',
        ],
        'forms' => [
            'transaction_id' => 'ID транзакції',
            'transaction_id_placeholder' => 'Введіть ID транзакції',
            'car_id' => 'Автомобіль',
            'car' => 'Автомобіль',
            'customer_id' => 'Клієнт',
            'customer_name' => 'Ім\'я клієнта',
            'customer_name_placeholder' => 'Введіть ім\'я клієнта',
            'customer_email' => 'Електронна пошта клієнта',
            'customer_email_placeholder' => 'Введіть електронну пошту клієнта',
            'customer_phone' => 'Телефон клієнта',
            'customer_phone_placeholder' => 'Введіть телефон клієнта',
            'sale_price' => 'Ціна продажу',
            'sale_price_placeholder' => 'Введіть ціну продажу',
            'tax_amount' => 'Сума податку',
            'tax_amount_placeholder' => 'Введіть суму податку',
            'total_amount' => 'Загальна сума',
            'total_amount_placeholder' => 'Введіть загальну суму',
            'payment_details' => 'Деталі платежу',
            'payment_details_placeholder' => 'Введіть деталі платежу',
            'notes' => 'Примітки',
            'notes_placeholder' => 'Введіть примітки',
            'sale_date' => 'Дата продажу',
            'delivery_date' => 'Дата доставки',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => 'Банківський переказ',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        // Booking confirmation email
        'booking_confirm_title' => 'Підтвердження бронювання оренди автомобіля',
        'booking_confirm_greeting' => 'Шановний(а) :customer_name,',
        'booking_confirm_message' => 'Ми раді повідомити вас, що ваше бронювання оренди автомобіля успішно підтверджено!',
        'customer_information' => 'Інформація про клієнта',
        'booking_information' => 'Інформація про бронювання',
        'field_name' => 'Ім\'я:',
        'field_phone' => 'Телефон:',
        'field_email' => 'Електронна пошта:',
        'field_car_model' => 'Модель автомобіля:',
        'field_start_date' => 'Дата початку:',
        'field_end_date' => 'Дата закінчення:',
        'field_pickup_address' => 'Адреса отримання:',
        'field_return_address' => 'Адреса повернення:',
        'field_note' => 'Примітка:',
        'field_order_number' => 'Номер замовлення',
        'field_payment_method' => 'Спосіб оплати',

        // Booking notice to admin email
        'booking_notice_admin_title' => 'Сповіщення про нове бронювання',
        'booking_notice_admin_greeting' => 'Привіт, є нове бронювання з :site_title:',
        'booking_notice_admin_message' => 'Подано нове бронювання оренди автомобіля, яке потребує вашої уваги.',
        'booking_view_detail' => 'Переглянути деталі бронювання:',
        'view_booking_details' => 'Переглянути деталі бронювання',

        // Booking notice to vendor email
        'booking_notice_vendor_title' => 'Нове бронювання для вашого автомобіля',
        'booking_notice_vendor_greeting' => 'Шановний(а) :vendor_name,',
        'booking_notice_vendor_message' => 'Чудові новини! Ви отримали нове бронювання для оренди вашого автомобіля.',

        // Booking status changed email
        'booking_status_updated' => 'Статус бронювання оновлено',
        'hello_thanks_for_booking' => 'Привіт, дякуємо за бронювання кімнат з :site_title:',
        'booking_status_change_message' => 'Сподіваємося, це повідомлення знайде вас у доброму здоров\'ї. Ми хотіли повідомити вас, що статус вашого бронювання було оновлено.',
        'name' => 'Ім\'я',
        'phone' => 'Телефон',
        'email' => 'Електронна пошта',
        'car_model' => 'Модель автомобіля',
        'start_date' => 'Дата початку',
        'end_date' => 'Дата закінчення',
        'pickup_address' => 'Адреса отримання',
        'return_address' => 'Адреса повернення',
        'note' => 'Примітка',
        'order_number' => 'Номер замовлення',
        'payment_method' => 'Спосіб оплати',

        // Car approved email
        'hello' => 'Привіт',
        'car_approved_title' => 'Чудові новини! Ваш автомобіль схвалено',
        'car_approved_message' => 'Ми раді повідомити вас, що ваш список автомобілів ":car_name" схвалено і тепер доступний на :site_title. Ви можете почати отримувати бронювання та керувати своїм списком прямо зараз.',
        'view_edit_car_link' => 'Для перегляду або редагування вашого списку автомобілів, будь ласка, натисніть на це посилання',
        'view_car' => 'Переглянути список автомобіля',
        'regards' => 'З найкращими побажаннями',
        'approved' => 'Схвалено',

        // Car rejected email
        'car_rejected_title' => 'Потрібне оновлення для вашого списку автомобіля',
        'car_rejected_message' => 'Дякуємо за подання вашого списку автомобіля ":car_name" до :site_title. Після перегляду вашої заявки, нам потрібно, щоб ви внесли деякі зміни перед тим, як ми зможемо його схвалити.',
        'rejection_reason' => 'Ось що потрібно оновити',
        'rejection_details' => 'Необхідні оновлення',
        'contact_support' => 'Якщо у вас є запитання або вам потрібна допомога з цими оновленнями, будь ласка, не соромтеся звертатися до нашої команди підтримки за адресою :site_email. Ми тут, щоб допомогти вам швидко схвалити ваш список.',

        // Confirm email
        'verify_email' => 'Підтвердити електронну пошту',
        'welcome_message' => 'Ми раді, що ви з нами, :customer_name!',
        'verify_email_instruction' => 'Будь ласка, підтвердіть вашу адресу електронної пошти, щоб отримати доступ до цього веб-сайту. Натисніть на кнопку нижче, щоб підтвердити вашу електронну пошту.',
        'confirm_email_button' => 'Підтвердіть вашу адресу електронної пошти',
        'verify_link_trouble' => 'Якщо у вас виникли проблеми з натисканням кнопки \'Підтвердіть вашу адресу електронної пошти\', скопіюйте та вставте URL нижче у ваш веб-браузер: :verify_link та вставте його у ваш браузер.',

        // Message email
        'new_message' => 'Нове повідомлення',
        'dear_admin' => 'Шановний адміністратор',
        'new_message_from' => 'Є нове повідомлення з :site_title:',
        'subject' => 'Тема',
        'address' => 'Адреса',
        'content' => 'Зміст',

        // New pending car email
        'hi_admin' => 'Привіт, адміністратор,',
        'new_car_pending_title' => 'Новий список автомобіля очікує перегляду',
        'new_car_pending_approval' => 'Новий список автомобіля ":post_name" подано :post_author і готовий для вашого перегляду.',
        'pending_approval' => 'Очікує перегляду',
        'review_car_admin' => 'Будь ласка, перегляньте цей список в адміністративній панелі та схваліть або запросіть оновлення за потреби.',

        // Common fields
        'car_information' => 'Інформація про автомобіль',
        'field_car_name' => 'Назва автомобіля:',
        'field_author' => 'Автор:',
        'field_status' => 'Статус:',
        'actions' => 'Дії',

        // Password reminder email
        'reset_password_instruction' => 'Інструкція зі скидання пароля',
        'password_reset_request' => 'Ви отримуєте цей електронний лист, тому що ми отримали запит на скидання пароля для вашого облікового запису.',
        'reset_password_button' => 'Скинути пароль',
        'reset_link_trouble' => 'Якщо у вас виникли проблеми з натисканням кнопки \'Скинути пароль\', скопіюйте та вставте URL нижче у ваш веб-браузер: :reset_link та вставте його у ваш браузер. Якщо ви не запитували скидання пароля, будь ласка, ігноруйте це повідомлення або зв\'яжіться з нами, якщо у вас є запитання.',
    ],
];