<?php

return [
    'name' => '租车',
    'customer' => [
        'name' => '客户',
        'create' => '客户创建',
        'view' => '显示',
        'information' => '客户信息',
        'email' => '电子邮件',
        'phone' => '电话',
        'status' => '状态',
        'vendor_status' => '供应商状态',
        'is_vendor' => '供应商',
        'not_vendor' => '客户',
        'recent_activity' => '最近活动',
        'recent_activity_description' => '客户活动此此显示。',
        'verification_section' => '客户确认',
        'verified' => '已确认',
        'not_verified' => '未确认',
        'verified_by' => '确认者',
        'verified_at' => '确认日期时间',
        'verify_customer' => '客户确认',
        'unverify_customer' => '客户确认解除',
        'verify_customer_confirmation' => '客户确认确认',
        'verify_customer_confirmation_desc' => ':name确认？此、资料已确认徽章显示。',
        'unverify_customer_confirmation' => '客户确认解除确认',
        'unverify_customer_confirmation_desc' => ':name确认删除？已确认徽章删除。',
        'verify_success' => '客户:name成功确认了。',
        'unverify_success' => '客户:name确认成功删除了。',
        'already_verified' => '此客户已确认。',
        'already_unverified' => '此客户确认尚未。',
        'upgrade_to_vendor_title' => '供应商升级',
        'upgrade_to_vendor_description' => '此客户供应商状态升级、独自租车列表管理。',
        'upgrade_to_vendor_button' => '供应商升级',
        'upgrade_to_vendor_confirmation' => '供应商升级确认',
        'upgrade_to_vendor_confirmation_desc' => ':name供应商状态升级？此、平台独自车辆列表管理。',
        'upgrade_to_vendor_success' => ':name成功供应商状态升级了。',
        'already_vendor' => '此客户供应商。',
        'email_verified' => '电子邮件已验证',
        'email_not_verified' => '电子邮件未验证',
        'verify_email_warning_message' => '此客户的电子邮件地址尚未验证。您可以手动验证以确认其电子邮件有效。',
        'verify_email_title' => '验证电子邮件地址',
        'verify_email_description' => '此客户的电子邮件地址尚未验证。您可以手动验证以确认其电子邮件有效。',
        'verify_email_button' => '验证电子邮件',
        'verify_email_confirmation' => '确认电子邮件验证',
        'verify_email_confirmation_desc' => '您确定要为:name验证电子邮件地址:email吗？这将标记其电子邮件为已确认。',
        'verify_email_success' => '已成功为:name验证电子邮件:email。',
        'email_already_verified' => '此电子邮件地址已经验证。',
        'resend_confirmation_button' => '重新发送确认邮件',
        'resend_confirmation_title' => '重新发送确认邮件',
        'resend_confirmation_desc' => '您确定要将确认邮件重新发送到:name的:email吗？这将向其电子邮件地址发送新的验证链接。',
        'resend_confirmation_success' => '确认邮件已发送至:email。',
        'resend_confirmation_error' => '发送确认邮件失败。请重试。',
        'customer_verified_successfully' => '此客户已确认、信頼。',
        'customer_not_verified_yet' => '此客户尚未确认尚未。',
        'verification_pending' => '确认待处理',
        'click_verify_to_approve' => '下按钮、此客户确认、已确认徽章显示。',
        'verification_note' => '确认备注',
        'verification_note_placeholder' => '此确认关于备注输入...',
        'verification_note_helper' => '确认关于备注添加（内部使用仅）',
        'forms' => [
            'name' => '名字称',
            'email' => '电子邮件',
            'phone' => '电话',
            'whatsapp' => 'WhatsApp',
            'avatar' => '头像',
            'dob' => '出生日期',
            'company' => '公司',
            'position' => '职位',
            'password' => '密码',
            'password_confirmation' => '密码确认',
            'change_password' => '密码更改？',
            'phone_placeholder' => '电话',
            'whatsapp_placeholder' => 'WhatsApp',
        ],
    ],
    'vendor' => [
        'name' => '供应商',
        'view' => ':name显示',
        'information' => '供应商信息',
        'total_cars' => '総车辆数',
        'total_bookings' => '総预约数',
        'verified' => '已确认',
        'not_verified' => '未确认',
        'verification_section' => '供应商确认',
        'vendor_verified_successfully' => '此供应商已确认、信頼。',
        'vendor_not_verified_yet' => '此供应商尚未确认尚未。',
        'verification_pending' => '确认待处理',
        'click_verify_to_approve' => '下按钮、此供应商确认、已确认徽章显示。',
        'verify_vendor' => '供应商确认',
        'unverify_vendor' => '供应商确认解除',
        'verify_vendor_confirmation' => '供应商确认确认',
        'verify_vendor_confirmation_desc' => ':name确认？此、资料已确认徽章显示。',
        'unverify_vendor_confirmation' => '供应商确认解除确认',
        'unverify_vendor_confirmation_desc' => ':name确认删除？已确认徽章删除。',
        'verified_successfully' => '供应商成功确认了。',
        'unverified_successfully' => '供应商确认成功删除了。',
        'already_verified' => '此供应商已确认。',
        'not_verified_yet' => '此供应商尚未确认尚未。',
        'recent_activity' => '最近活动',
        'recent_cars' => '最近车辆',
        'recent_bookings' => '最近预约',
        'no_cars_yet' => '尚未车辆添加尚未。',
        'no_bookings_yet' => '尚未预约受。',
    ],
    'make' => [
        'name' => '制造商',
        'create' => '车辆制造商创建',
        'forms' => [
            'logo' => '标志',
            'logo_dark' => '深色标志',
        ],
    ],
    'car' => [
        'name' => '车辆',
        'create' => '车辆创建',
        'forms' => [
            'car' => '车辆',
            'logo' => '标志',
            'license_plate' => '车牌号',
            'make' => '制造商',
            'model' => '型号',
            'name' => '名字称',
            'images' => '图片',
            'year' => '年份',
            'color' => '颜色',
            'mileage' => '里程',
            'kilometers' => '公里',
            'horsepower' => '马力',
            'vehicle_type' => '车辆类型',
            'transmission' => '变速箱',
            'fuel_type' => '燃料类型',
            'rental_rate' => '租赁费用',
            'currency' => '货币',
            'status' => '状态',
            'availability' => '空状况',
            'insurance_info' => '保险信息',
            'number_of_seats' => '座位数',
            'number_of_doors' => '车门数',
            'vin' => 'VIN',
            'maintenance_history' => '维护历史',
            'location' => '位置',
            'description' => '说明',
            'rental_type' => '租赁类型',
            'tags' => '标签',
            'add_new_attribute' => '<a href=":url" target="_blank">ここ</a>新添加。',
            'categories' => '类别',
            'pick_address' => '取车地址',
            'return_address' => '还车地址',
            'same_drop_off' => '同还车地点',
            'tax' => '税',
            'select_tax' => '税选择',
            'none' => '',
            'colors' => '颜色',
            'amenities' => '设施',
            'is_used' => '中古？',
            'moderation_status' => '状态',
            'status_moderation' => [
                'approve' => '批准',
                'reject' => '拒绝',
                'approve_title' => '车辆批准',
                'approve_message' => '此车辆批准？此元戻。',
                'reject_title' => '车辆拒绝',
                'reject_message' => '此车辆拒绝？此元戻。',
                'reject_reason' => '拒绝原因输入',
                'approved' => '车辆成功批准了！',
                'rejected' => '车辆成功拒绝了！',
                'reason_rejected' => '拒绝原因',
            ],
            'customer' => '客户',
            'select_customer' => '客户选择...',
            'vendor_images' => '图片（最大:max枚）',
            'images_upload_placeholder' => '文件此此、上传请。',
            'car_purpose' => '车辆目的',
            'for_rent' => '租赁用',
            'for_sale' => '销售用',
            'car_type' => '车辆类型',
            'rental_information' => '租赁信息',
            'sale_statuses' => [
                'available' => '可用',
                'sold' => '売却已',
                'reserved' => '预约已',
            ],
            'selling_information' => '销售信息',
            'is_for_sale' => '销售可用',
            'sale_price' => '销售价格',
            'sale_price_placeholder' => '销售价格输入',
            'condition' => '状态',
            'select_condition' => '状态选择',
            'condition_options' => [
                'new' => '新品',
                'like_new' => '新品同様',
                'excellent' => '優良',
                'good' => '良好',
                'fair' => '普通',
                'poor' => '不良',
            ],
            'ownership_history' => '所有历史',
            'ownership_history_placeholder' => '所有历史输入',
            'warranty_information' => '保修信息',
            'warranty_information_placeholder' => '保修信息输入',
            'sale_status' => '销售状态',
            'external_booking_url' => '网站预约',
            'external_booking_url_helper' => '此平台外客户此车辆预约外部URL输入请。此网站仅预约可用情况空欄请。',
            'address' => '地址',
            'address_helper' => '此车辆具体的地址输入请',
        ],
        'car_purposes' => [
            'sale' => '销售用',
            'rent' => '租赁用',
        ],
        'placeholders' => [
            'name' => '车辆名字输入（例： 2023、 CR-V）',
            'description' => '主要功能強調车辆簡単说明输入',
            'rental_rate' => '选择租赁类型基租赁费用输入',
            'location' => '车辆物理的地点输入',
            'address' => '具体的地址输入（例：東京都渋谷区渋谷1-2-3）',
            'sale_price' => '此车辆销售价格输入',
            'ownership_history' => '上一个车主、车主数详情输入',
            'warranty_information' => '保修范围、有效期限详情输入',
            'external_booking_url' => 'https://example.com/booking-link',
            'license_plate' => '车辆车牌号号码输入',
            'vin' => '车辆識別号码（VIN）输入',
            'year' => '製造年输入（例：2023）',
            'mileage' => '現在里程输入',
            'kilometers' => '現在公里输入',
            'horsepower' => '车辆马力（HP）输入（例：150.5）',
            'number_of_seats' => '车辆座位数输入',
            'number_of_doors' => '车辆车门数输入',
            'insurance_info' => '此车辆関連保险信息输入',
            'tags' => '标签选择创建',
            'amenities' => '设施选择',
            'colors' => '颜色选择创建',
        ],
        'enums' => [
            'vendor_status' => '供应商状态',
            'is_vendor' => '供应商',
            'not_vendor' => '客户',
            'statuses' => [
                'available' => '可用',
                'rented' => '租赁中',
                'maintenance' => '维护中',
                'out_of_service' => '服务外',
            ],
            'rental_types' => [
                'per_hour' => '1时间',
                'per_day' => '1日',
                'per_week' => '1週間',
                'per_month' => '1月',
            ],
            'moderation_statuses' => [
                'pending' => '待处理',
                'approved' => '已批准',
                'rejected' => '已拒绝',
            ],
        ],
        'maintenance_history' => [
            'name' => '维护历史',
            'create' => '服务历史创建',
            'amount' => '金额',
            'forms' => [
                'price_placeholder' => '服务价格',
                'currency' => '货币',
                'none' => '',
                'name' => '名字称',
                'amount' => '金额',
                'created_at' => '创建日',
                'action' => '',
                'date' => '日期',
                'no_maintenance_history' => '维护历史',
                'edit_maintenance_history' => '维护历史编辑',
                'add_maintenance_history' => '维护历史添加',
                'add' => '添加',
                'edit' => '编辑',
                'delete' => '删除',
            ],
        ],
    ],
    'attribute' => [
        'name' => '车辆属性',
        'car_type' => [
            'name' => '类型',
            'create' => '车辆类型创建',
            'forms' => [
                'name' => '名字称',
            ],
        ],
        'transmission' => [
            'name' => '变速箱',
            'create' => '变速箱创建',
            'forms' => [
                'name' => '名字称',
            ],
        ],
        'fuel_type' => [
            'name' => '燃料',
            'create' => '燃料类型创建',
            'forms' => [
                'name' => '名字称',
            ],
        ],
        'tag' => [
            'name' => '标签',
            'create' => '标签创建',
        ],
        'category' => [
            'name' => '类别',
            'create' => '类别创建',
            'forms' => [
                'none' => '',
                'total_cars' => '総车辆数：:total',
            ],
        ],
        'address' => [
            'name' => '位置',
            'create' => '车辆位置创建',
            'form' => [
                'name' => '地址',
                'full_address' => '完全地址',
                'detail_address' => '详情地址',
            ],
        ],
        'color' => [
            'name' => '颜色',
            'create' => '颜色创建',
        ],
        'amenity' => [
            'name' => '设施',
            'create' => '设施创建',
        ],
    ],
    'tax' => [
        'name' => '税',
        'create' => '税创建',
        'forms' => [
            'name' => '名字称',
            'name_placeholder' => '名字称输入',
            'percentage' => '百分比',
            'percentage_placeholder' => '百分比',
            'percent_placeholder' => '百分比',
            'priority' => '优先级',
            'priority_placeholder' => '优先级',
        ],
    ],
    'review' => [
        'name' => '评论',
        'create' => '评论创建',
        'edit' => '评论编辑',
        'vendor' => [
            'title' => '客户评论',
            'description' => '车辆客户评论管理',
            'no_reviews' => '尚未评论',
            'filter_by_car' => '车辆筛选',
            'filter_by_rating' => '評価筛选',
            'filter_by_date' => '日期筛选',
            'all_cars' => '车辆',
            'all_ratings' => '評価',
            'manage_reviews' => '评论管理',
            'view_all' => '评论显示',
            'delete_review_confirmation' => '此评论删除？',
            'delete_review_success' => '评论成功删除了',
            'cannot_delete' => '此评论删除',
        ],
        'forms' => [
            'customer' => '客户',
            'car' => '车辆',
            'content' => '内容',
            'rating' => '評価',
            'your_name' => '名字称',
            'email_address' => '电子邮件地址',
            'submit' => '发送',
            'star' => '星',
            'status' => '状态',
            'created_at' => '创建日',
            'select_car' => '车辆选择',
            'select_rating' => '評価选择',
            'comment' => '评论',
            'reply' => '返信',
            'reply_to_review' => '评论返信',
            'save_reply' => '返信保存',
            'cancel_reply' => '已取消',
        ],
        'statuses' => [
            'published' => '公開已',
            'pending' => '待处理',
            'rejected' => '已拒绝',
        ],
        'ratings' => [
            1 => '1星 - 悪',
            '2星 - 普通',
            '3星 - 良',
            '4星 - 非常良',
            '5星 - 優秀',
        ],
    ],
    'coupon' => [
        'name' => '优惠券',
        'create' => '优惠券创建',
        'types' => [
            'percentage' => '百分比%',
            'money' => '金额',
        ],
        'forms' => [],
    ],
    'service' => [
        'name' => '服务',
        'create' => '服务创建',
        'forms' => [
            'name' => '名字称',
            'content' => '内容',
            'price' => '价格',
            'currency' => '货币',
            'image' => '图片',
            'logo' => '标志',
            'status' => '状态',
        ],
    ],
    'availability_calendar' => [
        'name' => '空状况日历',
        'title' => '空状况日历',
        'description' => '日历格式车辆空状况预约显示',
        'select_dates' => '空状况确认日期选择',
        'car_filter' => '车辆筛选',
        'all_cars' => '车辆',
        'clear_filter' => '筛选',
        'availability_check' => '车辆空状况检查',
        'selected_period' => '选择期间',
        'checking_availability' => '空状况确认中...',
        'available' => '可用',
        'not_available' => '不可用用',
        'booking_details' => '预约详情',
        'how_to_use' => '车辆空状况日历使方',
        'viewing_bookings' => '预约显示',
        'checking_availability_help' => '空状况确认',
        'color_legend' => '颜色凡例',
        'pending_bookings' => '待处理预约',
        'processing_bookings' => '处理中预约',
        'completed_bookings' => '已完成预约',
        'cancelled_bookings' => '已取消预约',
        'unknown_make' => '不明制造商',
        'loading' => '加载中...',
        'loading_calendar_data' => '日历加载中...',
        'loading_booking_details' => '预约详情加载中...',
        'please_wait_booking_info' => '预约信息获取、待。',
        'please_wait_availability' => '选择日期车辆空状况确认、待。',
        'error' => '错误',
        'error_loading_booking' => '预约详情読仅込仅失败。一度試。',
        'error_checking_availability' => '车辆空状况确认错误',
        'customer' => '客户',
        'status' => '状态',
        'amount' => '金额',
        'make' => '制造商',
        'vendor' => '供应商',
        'per_day' => '/日',
        'edit_car' => '车辆编辑',
        'no_cars_found' => '车辆找',
        'no_cars_available_period' => '选择期间可用车辆。',
        'close' => '关闭',
        'edit_booking' => '预约编辑',
        'pending' => '待处理',
        'processing' => '处理中',
        'completed' => '已完成',
        'cancelled' => '已取消',
    ],
    'theme_options' => [
        'name' => '租车',
        'description' => '租车',
        'car_location_filter_by' => '车辆位置筛选',
        'state' => '州/省',
        'city' => '城市',
        'yes' => '',
        'no' => '',
        'is_display_country' => '位置筛选国家显示？',
        'logo_vendor_dashboard' => '供应商仪表板标志（标志）',
        'number_of_cars_per_page' => '页面车辆数',
        'number_of_cars_per_page_placeholder' => '页面显示车辆数输入',
    ],
    'message' => [
        'name' => '消息',
        'forms' => [
            'customer_name' => '客户名字',
            'message' => '消息',
            'phone' => '电话',
            'email' => '电子邮件',
            'created_at' => '创建日',
            'status' => '状态',
        ],
    ],
    'car_sale' => [
        'name' => '车辆销售',
        'create' => '新车辆销售',
        'edit' => '车辆销售编辑:name',
        'statuses' => [
            'pending' => '待处理',
            'processing' => '处理中',
            'completed' => '已完成',
            'cancelled' => '已取消',
        ],
        'forms' => [
            'transaction_id' => '交易ID',
            'transaction_id_placeholder' => '交易ID输入',
            'car_id' => '车辆',
            'car' => '车辆',
            'customer_id' => '客户',
            'customer_name' => '客户名字',
            'customer_name_placeholder' => '客户名字输入',
            'customer_email' => '客户电子邮件',
            'customer_email_placeholder' => '客户电子邮件输入',
            'customer_phone' => '客户电话',
            'customer_phone_placeholder' => '客户电话输入',
            'sale_price' => '销售价格',
            'sale_price_placeholder' => '销售价格输入',
            'tax_amount' => '税额',
            'tax_amount_placeholder' => '税额输入',
            'total_amount' => '合计金额',
            'total_amount_placeholder' => '合计金额输入',
            'payment_details' => '支付详情',
            'payment_details_placeholder' => '支付详情输入',
            'notes' => '备注',
            'notes_placeholder' => '备注输入',
            'sale_date' => '销售日',
            'delivery_date' => '配送日',
        ],
    ],
    'payout_payment_methods' => [
        'bank_transfer' => '銀行振込',
        'paypal' => 'PayPal',
    ],
    'email_templates' => [
        'booking_confirm_title' => '租车预约确认',
        'booking_confirm_greeting' => ':customer_name様',
        'booking_confirm_message' => '租车预约成功确认此知！',
        'customer_information' => '客户信息',
        'booking_information' => '预约信息',
        'field_name' => '名字称：',
        'field_phone' => '电话：',
        'field_email' => '电子邮件：',
        'field_car_model' => '车辆型号：',
        'field_start_date' => '开始日期：',
        'field_end_date' => '结束日期：',
        'field_pickup_address' => '取车地址：',
        'field_return_address' => '还车地址：',
        'field_note' => '备注：',
        'field_order_number' => '注文号码',
        'field_payment_method' => '支付方式',
        'booking_notice_admin_title' => '新预约通知',
        'booking_notice_admin_greeting' => '此、:site_title新预约：',
        'booking_notice_admin_message' => '新租车预约发送、对应必需。',
        'booking_view_detail' => '预约详情显示：',
        'view_booking_details' => '预约详情显示',
        'booking_notice_vendor_title' => '车辆新预约',
        'booking_notice_vendor_greeting' => ':vendor_name様',
        'booking_notice_vendor_message' => '素晴！租车新预约受取。',
        'booking_status_updated' => '预约状态更新了',
        'hello_thanks_for_booking' => '此、:site_title预约：',
        'booking_status_change_message' => '此消息良状态此願。预约状态更新此知。',
        'name' => '名字称',
        'phone' => '电话',
        'email' => '电子邮件',
        'car_model' => '车辆型号',
        'start_date' => '开始日期',
        'end_date' => '结束日期',
        'pickup_address' => '取车地址',
        'return_address' => '还车地址',
        'note' => '备注',
        'order_number' => '注文号码',
        'payment_method' => '支付方式',
        'hello' => '此',
        'car_approved_title' => '素晴！车辆批准了',
        'car_approved_message' => '车辆列表「:car_name」批准、:site_title公開此知。预约受取、列表管理。',
        'view_edit_car_link' => '车辆列表显示编辑、此请',
        'view_car' => '车辆列表显示',
        'regards' => '願',
        'vendor_upgrade_title' => '！您今供应商',
        'vendor_upgrade_congratulations' => '账户成功供应商状态升级此知！',
        'vendor_upgrade_message' => ':site_title独自车辆列表管理。此、当社租赁成長新機会開。',
        'vendor_benefits_title' => '新供应商特权',
        'vendor_benefit_1' => '租赁用无制限车辆列表',
        'vendor_benefit_2' => '独自预约客户管理',
        'vendor_benefit_3' => '收益指标追跡',
        'vendor_benefit_4' => '供应商限定功能',
        'next_steps' => '下一个',
        'vendor_next_steps_message' => '供应商仪表板、车辆添加租赁管理开始请。',
        'go_to_dashboard' => '供应商仪表板移动',
        'vendor_support_message' => '質問支持必需情况、当社支持手伝。',
        'approved' => '已批准',
        'car_rejected_title' => '车辆列表更新必需',
        'car_rejected_message' => '车辆列表「:car_name」:site_title发送。发送内容确认结果、批准上一个调整必需。',
        'rejection_reason' => '更新必需内容',
        'rejection_details' => '必需更新',
        'contact_support' => '此更新質問支持必需情况、:site_email支持気軽咨询。列表批准迅速行手伝。',
        'verify_email' => '电子邮件确认',
        'welcome_message' => '参加、:customer_name様！',
        'verify_email_instruction' => '此网络网站、电子邮件地址确认请。以下按钮电子邮件确认请。',
        'confirm_email_button' => '电子邮件地址确认',
        'verify_link_trouble' => '「电子邮件地址确认」按钮問題情况、以下URL网络貼付请：:verify_link貼付。',
        'new_message' => '新消息',
        'dear_admin' => '管理者様',
        'new_message_from' => ':site_title新消息：',
        'subject' => '主题',
        'address' => '地址',
        'content' => '内容',
        'hi_admin' => '此、管理者様',
        'new_car_pending_title' => '评论待新车辆列表',
        'new_car_pending_approval' => ':post_author新车辆列表「:post_name」发送、评论准备。',
        'pending_approval' => '评论待',
        'review_car_admin' => '管理此列表评论、批准更新要求请。',
        'car_information' => '车辆信息',
        'field_car_name' => '车辆名字：',
        'field_author' => '作者：',
        'field_status' => '状态：',
        'actions' => '',
        'reset_password_instruction' => '密码步骤',
        'password_reset_request' => '账户密码要求受取、此电子邮件接收。',
        'reset_password_button' => '密码',
        'reset_link_trouble' => '「密码」按钮問題情况、以下URL网络貼付请：:reset_link貼付。密码要求情况、此消息无視、質問情况咨询。',
    ],
];
