<?php

return [
    'name' => 'Locais',
    'all_states' => 'Todos os estados',
    'abbreviation' => 'Abreviação',
    'abbreviation_placeholder' => 'Ex.: CA',
    'import_type' => [
        'country' => 'País',
        'state' => 'Estado',
        'city' => 'Cidade',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'País',
            'state' => 'Estado',
            'city' => 'Cidade',
        ],
    ],
    'export' => [
        'total' => 'Total de locais',
        'total_countries' => 'Total de países',
        'total_states' => 'Total de Estados',
        'total_cities' => 'Total de cidades',
        'description' => 'Exporte seus dados de localização, como países, estados e cidades.',
        'import_type' => 'Tipo de Localização',
        'all_types' => 'Todos os tipos',
        'all_status' => 'Todos os status',
        'use_chunked_export' => 'Usar exportação em lotes',
        'use_chunked_export_helper' => 'Processe dados em lotes menores para evitar problemas de memória com grandes conjuntos de dados.',
        'optimize_memory' => 'Otimizar uso de memória',
        'optimize_memory_helper' => 'Carregue apenas colunas necessárias e libere memória periodicamente durante a exportação.',
        'use_streaming' => 'Usar modo streaming',
        'use_streaming_helper' => 'Transmita dados diretamente para o arquivo sem carregar tudo na memória. Recomendado para conjuntos de dados muito grandes.',
        'streaming_enabled_title' => 'Modo streaming ativado',
        'streaming_enabled_message' => 'Os dados serão transmitidos diretamente para o arquivo para uso otimizado de memória.',
        'chunk_size' => 'Tamanho do lote',
        'chunk_size_helper' => 'Número de registros a processar em cada lote. Valores mais baixos usam menos memória, mas levam mais tempo.',
        'recommended_range' => 'Intervalo recomendado',
        'optimal_range' => 'Ótimo',
        'too_small_slow' => 'Muito pequeno (mais lento)',
        'too_large_timeouts' => 'Muito grande (pode expirar)',
        'range_large_export' => '150-300 registros',
        'range_medium_export' => '200-500 registros',
        'range_small_export' => '300-700 registros',
        'large_dataset_title' => 'Grande conjunto de dados detetado',
        'large_dataset_message' => 'Modo de exportação otimizado ativado automaticamente para melhor desempenho.',
        'large_dataset_warning_title' => 'Recomendações para Exportação de Grande Conjunto de Dados',
        'large_dataset_specific_message' => 'Está a exportar :count localizações. Para um desempenho ideal, recomendamos usar o formato CSV com exportação em lotes.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Recomendado)',
        'chunk_label' => 'Tamanho do Lote',
        'chunk_recommended' => '150-300 registros',
        'time_label' => 'Tempo Estimado',
        'time_estimate' => '2-5 minutos',
        'pro_tip' => 'Dica Profissional:',
        'pro_tip_message' => 'Pode filtrar por tipo de localização (país/estado/cidade) para exportar dados específicos.',
        'medium_dataset_detected' => 'Conjunto de dados médio detetado',
        'medium_dataset_message' => 'A exportar :count localizações. A exportação deverá ser concluída em 1-2 minutos.',
        'excel_disabled_warning' => 'O formato Excel não é recomendado para grandes conjuntos de dados (:count+ registros). Use CSV em vez disso.',
    ],
    'import' => [
        'description' => 'Importe dados de localização facilmente a partir dos dados disponíveis ou carregando um arquivo CSV/Excel.',
        'rules' => [
            'name' => 'O nome do local é obrigatório e não deve ultrapassar 120 caracteres.',
            'slug' => 'O slug do local, se fornecido, não deve exceder 120 caracteres.',
            'import_type' => 'O tipo de importação é obrigatório e deve ser um dos valores predefinidos.',
            'order' => 'A ordem da localização, se fornecida, deve ser um número inteiro positivo entre 0 e 127.',
            'abbreviation' => 'A abreviatura do local, se fornecida, não deverá exceder 10 caracteres.',
            'status' => 'O status do local é obrigatório e deve ser um dos valores predefinidos.',
            'country' => 'O campo país é obrigatório caso o tipo de importação seja estado ou cidade.',
            'state' => 'O campo estado é obrigatório se o tipo de importação for cidade.',
            'nationality' => 'A nacionalidade do local, se fornecida, não deverá exceder 120 caracteres.',
        ],
    ],
];
