<?php

return [
    'name' => 'Newsletter',
    'newsletter_form' => 'Modulo newsletter',
    'description' => 'Visualizza ed elimina gli iscritti alla newsletter',
    'settings' => [
        'email' => [
            'templates' => [
                'title' => 'Newsletter',
                'description' => 'Configura i modelli email della newsletter',
                'to_admin' => [
                    'title' => 'Email inviata all\'amministratore',
                    'description' => 'Modello per l\'invio di email all\'amministratore',
                    'subject' => 'Un nuovo utente si è iscritto alla tua newsletter',
                    'newsletter_email' => 'Email dell\'utente che si è iscritto alla newsletter',
                ],
                'to_user' => [
                    'title' => 'Email inviata all\'utente',
                    'description' => 'Modello per l\'invio di email all\'iscritto',
                    'subject' => '{{ site_title }}: Iscrizione confermata!',
                    'newsletter_name' => 'Nome completo dell\'utente che si è iscritto alla newsletter',
                    'newsletter_email' => 'Email dell\'utente che si è iscritto alla newsletter',
                    'newsletter_unsubscribe_link' => 'Link per annullare l\'iscrizione alla newsletter',
                    'newsletter_unsubscribe_url' => 'URL per annullare l\'iscrizione alla newsletter',
                ],
            ],
        ],
        'title' => 'Newsletter',
        'panel_description' => 'Visualizza e aggiorna le impostazioni della newsletter',
        'description' => 'Impostazioni per la newsletter (invio automatico di email della newsletter a SendGrid, Mailchimp... quando qualcuno si iscrive alla newsletter sul sito web).',
        'mailchimp_api_key' => 'Chiave API Mailchimp',
        'mailchimp_api_key_helper' => 'Inserisci la tua chiave API Mailchimp per sincronizzare automaticamente gli iscritti alla newsletter. Ottieni la tua chiave API da Mailchimp: Account → Extra → Chiavi API → Crea una chiave.',
        'mailchimp_api_key_instruction' => 'Per ottenere la tua chiave API: Accedi a Mailchimp → Clicca sul nome del tuo profilo → Account → Extra → Chiavi API → Crea una chiave. <a href="https://mailchimp.com/help/about-api-keys/" target="_blank" rel="noopener">Ulteriori informazioni</a>',
        'mailchimp_list_id' => 'ID elenco Mailchimp',
        'mailchimp_list_id_helper' => 'Inserisci l\'ID del tuo pubblico (elenco) Mailchimp dove verranno aggiunti gli iscritti.',
        'mailchimp_list' => 'Elenco Mailchimp',
        'mailchimp_list_helper' => 'Seleziona l\'elenco del pubblico Mailchimp dove verranno aggiunti automaticamente i nuovi iscritti.',
        'sendgrid_api_key' => 'Chiave API Sendgrid',
        'sendgrid_api_key_helper' => 'Inserisci la tua chiave API SendGrid per sincronizzare automaticamente gli iscritti alla newsletter. La chiave API deve avere i permessi "Marketing" abilitati.',
        'sendgrid_api_key_instruction' => 'Per creare una chiave API: Accedi a SendGrid → Impostazioni → Chiavi API → Crea chiave API → Seleziona "Accesso limitato" → Abilita i permessi "Marketing". <a href="https://docs.sendgrid.com/ui/account-and-settings/api-keys" target="_blank" rel="noopener">Ulteriori informazioni</a>',
        'sendgrid_list_id' => 'ID elenco Sendgrid',
        'sendgrid_list_id_helper' => 'Inserisci l\'ID dell\'elenco contatti SendGrid dove verranno aggiunti gli iscritti.',
        'sendgrid_list' => 'Elenco Sendgrid',
        'sendgrid_list_helper' => 'Seleziona l\'elenco contatti SendGrid dove verranno aggiunti automaticamente i nuovi iscritti.',
        'enable_newsletter_contacts_list_api' => 'Abilitare l\'API dell\'elenco contatti della newsletter?',
        'enable_newsletter_contacts_list_api_helper' => 'Quando abilitato, i nuovi iscritti alla newsletter verranno sincronizzati automaticamente con il tuo servizio di email marketing (Mailchimp o SendGrid). Questo ti consente di gestire e inviare campagne tramite la tua piattaforma preferita.',
    ],
    'statuses' => [
        'subscribed' => 'Iscritto',
        'unsubscribed' => 'Disiscritto',
    ],
    'email_templates' => [
        // Admin email template
        'admin_new_subscriber_title' => 'Nuovo iscritto',
        'admin_new_subscriber_message' => 'Un nuovo utente si è iscritto alla tua newsletter:',

        // Subscriber email template
        'subscriber_success_title' => 'Iscrizione riuscita',
        'subscriber_thank_you_message' => 'Grazie per esserti iscritto alla nostra newsletter!',
        'subscriber_unsubscribe_instruction' => 'Per annullare l\'iscrizione alla newsletter, clicca su :newsletter_unsubscribe_link',
    ],

    'enter_your_email' => 'Inserisci la tua email',
    'subscribe' => 'Iscriviti',
    'newsletter_popup' => 'Popup della newsletter',
    'enable_newsletter_popup' => 'Abilita il popup della newsletter',
    'popup_image' => 'Immagine popup',
    'popup_title' => 'Titolo popup',
    'popup_subtitle' => 'Sottotitoli popup',
    'popup_description' => 'Descrizione popup',
    'popup_delay_seconds' => 'Ritardo popup (secondi)',
    'popup_delay_helper' => 'Il tempo di ritardo prima della visualizzazione del popup della newsletter dopo il caricamento della pagina. ',
    'display_on_pages' => 'Visualizzazione nelle pagine',
    'homepage' => 'Home page',
    'all_pages' => 'Tutte le pagine',
    'subscribe_success' => 'Iscriviti alla newsletter con successo!',
    'unsubscribe_success' => 'Annullamento dell\'iscrizione alla newsletter con successo',
    'email_not_exist_or_unsubscribed' => 'La tua email non esiste nel sistema o hai già cancellato l\'iscrizione!',
    'email_address' => 'Indirizzo e-mail',
    'dont_show_popup_again' => 'Non mostrare più questo popup',
    'here' => 'Qui',
];
