@use(Botble\Theme\Supports\Youtube;)

@php
    Theme::set('breadcrumbs', false);
    Theme::layout('full-width');

    $youtubeUrl = $car->getMetaData('youtube_video_url', true);

    $youtubeId = $youtubeUrl ? Youtube::getYoutubeVideoID($youtubeUrl) : null;

    $images = $car->getImages();
@endphp

<div class="car-detail-page">
    @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.breadcrumbs'), compact('car'))

    <div class="box-section box-content-tour-detail background-body">
        <div class="container">
            <div class="tour-header">
                @if($car->reviews_count)
                    <div class="tour-rate">
                        <div class="rate-element">
                            @include(Theme::getThemeNamespace('views.car-rentals.rating'), ['car' => $car])
                        </div>
                    </div>
                @endif

                <div class="row">
                    <div class="col-lg-8">
                        <div class="tour-title-main">
                            <h4 class="neutral-1000">{{ $car->name }}</h4>
                        </div>
                    </div>
                </div>
                <div class="tour-metas">
                    <div class="tour-meta-left">
                        @if($car->current_location)
                            <p class="text-md-medium neutral-1000 mr-20 tour-location">
                                {!! BaseHelper::renderIcon('ti ti-map-pin') !!}

                                {!! BaseHelper::clean($car->current_location) !!}
                            </p>
                            <a class="text-md-medium neutral-1000 mr-30" href="https://maps.google.com/maps?q={{ addslashes($car->current_location) }}">{{ __('Show on map') }}</a>
                        @endif
                    </div>
                    <div>
                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.share-button'), compact('car'))
                    </div>
                </div>
            </div>

            @if($images)
                <div class="box-section box-banner-property-detail background-body">
                    <div class="position-relative">
                        <div class="block-banner-property-detail container-banner-activities">
                            <div class="row g-3">
                                <div @class(['col-lg-7' => count($images) >= 5, 'col-lg-12' => count($images) == 1])>
                                    @php
                                        $firstImage = Arr::first($images);
                                    @endphp
                                    <div class="position-relative wrapper-main-car-image rounded-12 overflow-hidden">
                                        {{ RvMedia::image($firstImage, $car->name, 'large-rectangle') }}

                                        <div class="d-none d-sm-block">
                                            @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.gallery-buttons'), ['car' => $car])
                                        </div>
                                    </div>
                                </div>

                                @if (count($images) >= 5)
                                    @php
                                        unset($images[0]);
                                        $chunkImages = array_chunk($images, 2);
                                    @endphp
                                    <div class="col-lg-5">
                                        <div class="d-flex gap-3">
                                            @foreach($chunkImages as $chunkImage)
                                                @continue($loop->iteration > 2)
                                                <div class="d-flex gap-3 flex-column w-100">
                                                    @foreach($chunkImage as $imageItem)
                                                        <div class="rounded-12 overflow-hidden w-100">
                                                            {{ RvMedia::image($imageItem, $car->name, 'medium-square', attributes: ['class' => 'w-100']) }}
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>

                            <div class="d-block d-sm-none mt-4">
                                @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.gallery-buttons'), ['car' => $car])
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="row mt-20">
                <div class="col-lg-8">
                    @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.attributes'), compact('car'))

                    @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.additional-info'), compact('car'))

                    @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.amenities'), compact('car'))

                    <div class="box-collapse-expand">
                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.content'), compact('car'))

                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.owner-info'), compact('car'))

                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.faqs'), compact('car'))

                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.reviews'), compact('car', 'reviews'))
                    </div>
                </div>
                <div class="col-lg-4">
                    @if($car->is_for_sale && get_car_rentals_setting('enabled_car_sale', true))
                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.sale-info'), compact('car'))
                    @elseif(!$car->is_for_sale && CarRentalsHelper::isRentalBookingEnabled())
                        @include(Theme::getThemeNamespace('views.car-rentals.car-detail.includes.booking-form'), compact('car'))
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
